{"vars":[{"containerName":"","name":"base","kind":2,"line":101},{"line":116,"children":[{"line":118,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"analysis_query"},{"kind":13,"line":119,"name":"$self","containerName":"analysis_query"},{"line":119,"kind":12,"containerName":"analysis_query","name":"throw_not_implemented"}],"kind":12,"detail":"($self)","signature":{"label":"analysis_query($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: AnalysisResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::AnalysisResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Derived from Bio::Tools::AnalysisResult by Hilmar Lapp <hlapp@gmx.net>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AnalysisResultI - Interface for analysis result objects\n\n=head1 SYNOPSIS\n\nBio::AnalysisResultI defines an interface that must be implemented by\na subclass. So you cannot create Bio::AnalysisResultI objects,\nonly objects that inherit from Bio::AnalysisResultI. \n\n=head1 DESCRIPTION\n\nThe AnalysisResultI module provides an interface for modules\nencapsulating the result of an analysis that was carried out with a\nquery sequence and an optional subject dataset.\n\nThe notion of an analysis represented by this base class is that of a unary or\nbinary operator, taking either one query or a query and a subject and producing\na result. The query is e.g. a sequence, and a subject is either a sequence,\ntoo, or a database of sequences. \n\nThis interface defines methods to access analysis result data and does\nnot impose any contraints on how the analysis result data is acquired.\n\nNote that this module does not provide support for B<running> an analysis.\nRather, it is positioned in the subsequent parsing step (concerned with\nturning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Hilmar Lapp\n\nEmail sac@bioperl.org\nEmail hlapp@gmx.net (author of Bio::Tools::AnalysisResult on which this module is based)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AnalysisResultI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Get a Bio::PrimarySeqI-compatible object representing the entity \n             on which the analysis was performed. Lacks sequence information.\n Argument  : n/a\n Returns   : A Bio::PrimarySeqI-compatible object without sequence information.\n             The sequence will have display_id, description, moltype, and length data.","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":116},"end":{"character":9999,"line":120}},"name":"analysis_query"},{"children":[{"kind":13,"line":142,"name":"$self","definition":"my","containerName":"analysis_subject","localvar":"my"}],"line":140,"kind":12,"signature":{"label":"analysis_subject($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: AnalysisResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::AnalysisResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Derived from Bio::Tools::AnalysisResult by Hilmar Lapp <hlapp@gmx.net>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AnalysisResultI - Interface for analysis result objects\n\n=head1 SYNOPSIS\n\nBio::AnalysisResultI defines an interface that must be implemented by\na subclass. So you cannot create Bio::AnalysisResultI objects,\nonly objects that inherit from Bio::AnalysisResultI. \n\n=head1 DESCRIPTION\n\nThe AnalysisResultI module provides an interface for modules\nencapsulating the result of an analysis that was carried out with a\nquery sequence and an optional subject dataset.\n\nThe notion of an analysis represented by this base class is that of a unary or\nbinary operator, taking either one query or a query and a subject and producing\na result. The query is e.g. a sequence, and a subject is either a sequence,\ntoo, or a database of sequences. \n\nThis interface defines methods to access analysis result data and does\nnot impose any contraints on how the analysis result data is acquired.\n\nNote that this module does not provide support for B<running> an analysis.\nRather, it is positioned in the subsequent parsing step (concerned with\nturning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Hilmar Lapp\n\nEmail sac@bioperl.org\nEmail hlapp@gmx.net (author of Bio::Tools::AnalysisResult on which this module is based)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AnalysisResultI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Get a Bio::PrimarySeqI-compatible object representing the entity \n             on which the analysis was performed. Lacks sequence information.\n Argument  : n/a\n Returns   : A Bio::PrimarySeqI-compatible object without sequence information.\n             The sequence will have display_id, description, moltype, and length data.\n\n\n#---------------------\nsub analysis_query {\n#---------------------\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 analysis_subject\n\n Usage     : $obj = $result->analyis_subject();\n Purpose   : Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : An object of a type the depends on the implementation\n             May also return undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"line":140,"character":0},"end":{"line":144,"character":9999}},"name":"analysis_subject"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"analysis_subject_version($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: AnalysisResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::AnalysisResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Derived from Bio::Tools::AnalysisResult by Hilmar Lapp <hlapp@gmx.net>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AnalysisResultI - Interface for analysis result objects\n\n=head1 SYNOPSIS\n\nBio::AnalysisResultI defines an interface that must be implemented by\na subclass. So you cannot create Bio::AnalysisResultI objects,\nonly objects that inherit from Bio::AnalysisResultI. \n\n=head1 DESCRIPTION\n\nThe AnalysisResultI module provides an interface for modules\nencapsulating the result of an analysis that was carried out with a\nquery sequence and an optional subject dataset.\n\nThe notion of an analysis represented by this base class is that of a unary or\nbinary operator, taking either one query or a query and a subject and producing\na result. The query is e.g. a sequence, and a subject is either a sequence,\ntoo, or a database of sequences. \n\nThis interface defines methods to access analysis result data and does\nnot impose any contraints on how the analysis result data is acquired.\n\nNote that this module does not provide support for B<running> an analysis.\nRather, it is positioned in the subsequent parsing step (concerned with\nturning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Hilmar Lapp\n\nEmail sac@bioperl.org\nEmail hlapp@gmx.net (author of Bio::Tools::AnalysisResult on which this module is based)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AnalysisResultI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Get a Bio::PrimarySeqI-compatible object representing the entity \n             on which the analysis was performed. Lacks sequence information.\n Argument  : n/a\n Returns   : A Bio::PrimarySeqI-compatible object without sequence information.\n             The sequence will have display_id, description, moltype, and length data.\n\n\n#---------------------\nsub analysis_query {\n#---------------------\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 analysis_subject\n\n Usage     : $obj = $result->analyis_subject();\n Purpose   : Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : An object of a type the depends on the implementation\n             May also return undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.\n\n\n#---------------\nsub analysis_subject { \n#---------------\n    my ($self) = @_; \n    return;\n}\n\n=head2 analysis_subject_version\n\n Usage     : $vers = $result->analyis_subject_version();\n Purpose   : Get the version string of the subject of the analysis.\n Returns   : String or undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.","parameters":[{"label":"$self"}]},"kind":12,"line":158,"children":[{"containerName":"analysis_subject_version","name":"$self","definition":"my","localvar":"my","kind":13,"line":160}],"name":"analysis_subject_version","range":{"start":{"character":0,"line":158},"end":{"character":9999,"line":162}}},{"range":{"end":{"line":179,"character":9999},"start":{"line":175,"character":0}},"name":"analysis_date","line":175,"children":[{"kind":13,"line":177,"definition":"my","name":"$self","containerName":"analysis_date","localvar":"my"},{"containerName":"analysis_date","name":"$self","kind":13,"line":178},{"line":178,"kind":12,"containerName":"analysis_date","name":"throw_not_implemented"}],"kind":12,"detail":"($self)","signature":{"label":"analysis_date($self)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: AnalysisResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::AnalysisResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Derived from Bio::Tools::AnalysisResult by Hilmar Lapp <hlapp@gmx.net>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AnalysisResultI - Interface for analysis result objects\n\n=head1 SYNOPSIS\n\nBio::AnalysisResultI defines an interface that must be implemented by\na subclass. So you cannot create Bio::AnalysisResultI objects,\nonly objects that inherit from Bio::AnalysisResultI. \n\n=head1 DESCRIPTION\n\nThe AnalysisResultI module provides an interface for modules\nencapsulating the result of an analysis that was carried out with a\nquery sequence and an optional subject dataset.\n\nThe notion of an analysis represented by this base class is that of a unary or\nbinary operator, taking either one query or a query and a subject and producing\na result. The query is e.g. a sequence, and a subject is either a sequence,\ntoo, or a database of sequences. \n\nThis interface defines methods to access analysis result data and does\nnot impose any contraints on how the analysis result data is acquired.\n\nNote that this module does not provide support for B<running> an analysis.\nRather, it is positioned in the subsequent parsing step (concerned with\nturning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Hilmar Lapp\n\nEmail sac@bioperl.org\nEmail hlapp@gmx.net (author of Bio::Tools::AnalysisResult on which this module is based)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AnalysisResultI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Get a Bio::PrimarySeqI-compatible object representing the entity \n             on which the analysis was performed. Lacks sequence information.\n Argument  : n/a\n Returns   : A Bio::PrimarySeqI-compatible object without sequence information.\n             The sequence will have display_id, description, moltype, and length data.\n\n\n#---------------------\nsub analysis_query {\n#---------------------\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 analysis_subject\n\n Usage     : $obj = $result->analyis_subject();\n Purpose   : Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : An object of a type the depends on the implementation\n             May also return undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.\n\n\n#---------------\nsub analysis_subject { \n#---------------\n    my ($self) = @_; \n    return;\n}\n\n=head2 analysis_subject_version\n\n Usage     : $vers = $result->analyis_subject_version();\n Purpose   : Get the version string of the subject of the analysis.\n Returns   : String or undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.\n\n\n#---------------\nsub analysis_subject_version { \n#---------------\n    my ($self) = @_; \n    return;\n}\n\n\n=head2 analysis_date\n\n Usage     : $date = $result->analysis_date();\n Purpose   : Get the date on which the analysis was performed.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"name":"analysis_method","range":{"end":{"line":197,"character":9999},"start":{"line":193,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: AnalysisResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::AnalysisResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Derived from Bio::Tools::AnalysisResult by Hilmar Lapp <hlapp@gmx.net>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AnalysisResultI - Interface for analysis result objects\n\n=head1 SYNOPSIS\n\nBio::AnalysisResultI defines an interface that must be implemented by\na subclass. So you cannot create Bio::AnalysisResultI objects,\nonly objects that inherit from Bio::AnalysisResultI. \n\n=head1 DESCRIPTION\n\nThe AnalysisResultI module provides an interface for modules\nencapsulating the result of an analysis that was carried out with a\nquery sequence and an optional subject dataset.\n\nThe notion of an analysis represented by this base class is that of a unary or\nbinary operator, taking either one query or a query and a subject and producing\na result. The query is e.g. a sequence, and a subject is either a sequence,\ntoo, or a database of sequences. \n\nThis interface defines methods to access analysis result data and does\nnot impose any contraints on how the analysis result data is acquired.\n\nNote that this module does not provide support for B<running> an analysis.\nRather, it is positioned in the subsequent parsing step (concerned with\nturning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Hilmar Lapp\n\nEmail sac@bioperl.org\nEmail hlapp@gmx.net (author of Bio::Tools::AnalysisResult on which this module is based)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AnalysisResultI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Get a Bio::PrimarySeqI-compatible object representing the entity \n             on which the analysis was performed. Lacks sequence information.\n Argument  : n/a\n Returns   : A Bio::PrimarySeqI-compatible object without sequence information.\n             The sequence will have display_id, description, moltype, and length data.\n\n\n#---------------------\nsub analysis_query {\n#---------------------\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 analysis_subject\n\n Usage     : $obj = $result->analyis_subject();\n Purpose   : Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : An object of a type the depends on the implementation\n             May also return undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.\n\n\n#---------------\nsub analysis_subject { \n#---------------\n    my ($self) = @_; \n    return;\n}\n\n=head2 analysis_subject_version\n\n Usage     : $vers = $result->analyis_subject_version();\n Purpose   : Get the version string of the subject of the analysis.\n Returns   : String or undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.\n\n\n#---------------\nsub analysis_subject_version { \n#---------------\n    my ($self) = @_; \n    return;\n}\n\n\n=head2 analysis_date\n\n Usage     : $date = $result->analysis_date();\n Purpose   : Get the date on which the analysis was performed.\n Returns   : String\n Argument  : n/a\n\n\n#---------------------\nsub analysis_date {\n#---------------------\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 analysis_method\n\n Usage     : $meth = $result->analysis_method();\n Purpose   : Get the name of the sequence analysis method that was used\n             to produce this result (BLASTP, FASTA, etc.). May also be the\n             actual name of a program.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"}],"label":"analysis_method($self)"},"detail":"($self)","kind":12,"children":[{"line":195,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"analysis_method"},{"kind":13,"line":196,"containerName":"analysis_method","name":"$self"},{"kind":12,"line":196,"name":"throw_not_implemented","containerName":"analysis_method"}],"line":193},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: AnalysisResultI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::AnalysisResultI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Derived from Bio::Tools::AnalysisResult by Hilmar Lapp <hlapp@gmx.net>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AnalysisResultI - Interface for analysis result objects\n\n=head1 SYNOPSIS\n\nBio::AnalysisResultI defines an interface that must be implemented by\na subclass. So you cannot create Bio::AnalysisResultI objects,\nonly objects that inherit from Bio::AnalysisResultI. \n\n=head1 DESCRIPTION\n\nThe AnalysisResultI module provides an interface for modules\nencapsulating the result of an analysis that was carried out with a\nquery sequence and an optional subject dataset.\n\nThe notion of an analysis represented by this base class is that of a unary or\nbinary operator, taking either one query or a query and a subject and producing\na result. The query is e.g. a sequence, and a subject is either a sequence,\ntoo, or a database of sequences. \n\nThis interface defines methods to access analysis result data and does\nnot impose any contraints on how the analysis result data is acquired.\n\nNote that this module does not provide support for B<running> an analysis.\nRather, it is positioned in the subsequent parsing step (concerned with\nturning raw results into BioPerl objects).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Steve Chervitz, Hilmar Lapp\n\nEmail sac@bioperl.org\nEmail hlapp@gmx.net (author of Bio::Tools::AnalysisResult on which this module is based)\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AnalysisResultI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 analysis_query\n\n Usage     : $query_obj = $result->analysis_query();\n Purpose   : Get a Bio::PrimarySeqI-compatible object representing the entity \n             on which the analysis was performed. Lacks sequence information.\n Argument  : n/a\n Returns   : A Bio::PrimarySeqI-compatible object without sequence information.\n             The sequence will have display_id, description, moltype, and length data.\n\n\n#---------------------\nsub analysis_query {\n#---------------------\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 analysis_subject\n\n Usage     : $obj = $result->analyis_subject();\n Purpose   : Get the subject of the analysis against which it was\n             performed. For similarity searches it will probably be a database,\n             and for sequence feature predictions (exons, promoters, etc) it\n             may be a collection of models or homologous sequences that were\n             used, or undefined.\n Returns   : An object of a type the depends on the implementation\n             May also return undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.\n\n\n#---------------\nsub analysis_subject { \n#---------------\n    my ($self) = @_; \n    return;\n}\n\n=head2 analysis_subject_version\n\n Usage     : $vers = $result->analyis_subject_version();\n Purpose   : Get the version string of the subject of the analysis.\n Returns   : String or undef for analyses that don\\'t involve subjects.\n Argument  : n/a\n Comments  : Implementation of this method is optional.\n             AnalysisResultI provides a default behavior of returning undef.\n\n\n#---------------\nsub analysis_subject_version { \n#---------------\n    my ($self) = @_; \n    return;\n}\n\n\n=head2 analysis_date\n\n Usage     : $date = $result->analysis_date();\n Purpose   : Get the date on which the analysis was performed.\n Returns   : String\n Argument  : n/a\n\n\n#---------------------\nsub analysis_date {\n#---------------------\n    my ($self) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 analysis_method\n\n Usage     : $meth = $result->analysis_method();\n Purpose   : Get the name of the sequence analysis method that was used\n             to produce this result (BLASTP, FASTA, etc.). May also be the\n             actual name of a program.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self) = @_;  \n    $self->throw_not_implemented;\n}\n\n=head2 analysis_method_version\n\n Usage     : $vers = $result->analysis_method_version();\n Purpose   : Get the version string of the analysis program.\n           : (e.g., 1.4.9MP, 2.0a19MP-WashU).\n Returns   : String\n Argument  : n/a","label":"analysis_method_version($self)"},"detail":"($self)","kind":12,"children":[{"line":212,"kind":13,"localvar":"my","containerName":"analysis_method_version","definition":"my","name":"$self"},{"kind":13,"line":213,"containerName":"analysis_method_version","name":"$self"},{"containerName":"analysis_method_version","name":"throw_not_implemented","line":213,"kind":12}],"line":210,"name":"analysis_method_version","range":{"start":{"line":210,"character":0},"end":{"character":9999,"line":214}}},{"children":[{"line":232,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_feature"},{"name":"$self","containerName":"next_feature","line":233,"kind":13},{"name":"throw_not_implemented","containerName":"next_feature","kind":12,"line":233}],"line":230,"kind":12,"range":{"end":{"line":234,"character":9999},"start":{"character":0,"line":230}},"definition":"sub","name":"next_feature","containerName":"main::"}],"version":5}