{"vars":[{"line":226,"kind":2,"containerName":"strict::Bio::Seq::Meta::Bio::AlignIO::Handler::GenericAlignHandler::Text","name":"Wrap"},{"name":"base","containerName":"","line":228,"kind":2},{"name":"$STKVERSION","definition":"my","containerName":null,"localvar":"my","kind":13,"line":230},{"localvar":"my","name":"%MAPPING","definition":"my","containerName":null,"line":238,"kind":13},{"kind":13,"line":270,"containerName":"main::","name":"@WRITEORDER","definition":"our"},{"containerName":"main::","name":"%WRITEMAP","definition":"our","kind":13,"line":298},{"name":"_initialize","range":{"end":{"line":367,"character":9999},"start":{"character":0,"line":354}},"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: stockholm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::stockholm\n#\n#   Based on the Bio::SeqIO::stockholm module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Peter Schattner, Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# September 5, 2000\n# November 6, 2006 - completely refactor read_aln(), add write_aln()\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::stockholm - stockholm sequence input/output stream\n\n=head1 SYNOPSIS\n\n  # Do not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n  use Bio::AlignIO;\n  use strict;\n\n  my $in = Bio::AlignIO->new(-format => 'stockholm',\n                             -file   => 't/data/testaln.stockholm');\n  while( my $aln = $in->next_aln ) {\n\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from\nstockholm flat file databases.  This has been completely refactored\nfrom the original stockholm parser to handle annotation data and now\nincludes a write_aln() method for (almost) complete stockholm\nformat output.\n\nStockholm alignment records normally contain additional sequence-based\nand alignment-based annotation\n\n  GF Lines (alignment feature/annotation):\n  #=GF <featurename> <Generic per-file annotation, free text>\n  Placed above the alignment\n\n  GC Lines (Alignment consensus)\n  #=GC <featurename> <Generic per-column annotation, exactly 1\n       character per column>\n  Placed below the alignment\n\n  GS Lines (Sequence annotations)\n  #=GS <seqname> <featurename> <Generic per-sequence annotation, free\n       text>\n\n  GR Lines (Sequence meta data)\n  #=GR <seqname> <featurename> <Generic per-sequence AND per-column\n       mark up, exactly 1 character per column>\n\nCurrently, sequence annotations (those designated with GS tags) are\nparsed only for accession numbers and descriptions.  It is intended that\nfull parsing will be added at some point in the near future along with\na builder option for optionally parsing alignment annotation and meta data.\n\nThe following methods/tags are currently used for storing and writing\nthe alignment annotation data.\n\n    Tag        SimpleAlign\n                 Method  \n    ----------------------------------------------------------------------\n     AC        accession  \n     ID        id  \n     DE        description\n    ----------------------------------------------------------------------\n\n    Tag        Bio::Annotation   TagName                    Parameters\n               Class\n    ----------------------------------------------------------------------\n     AU        SimpleValue       record_authors             value\n     SE        SimpleValue       seed_source                value\n     GA        SimpleValue       gathering_threshold        value\n     NC        SimpleValue       noise_cutoff               value\n     TC        SimpleValue       trusted_cutoff             value\n     TP        SimpleValue       entry_type                 value\n     SQ        SimpleValue       num_sequences              value\n     PI        SimpleValue       previous_ids               value\n     DC        Comment           database_comment           comment\n     CC        Comment           alignment_comment          comment\n     DR        Target            dblink                     database\n                                                            primary_id\n                                                            comment\n     AM        SimpleValue       build_method               value\n     NE        SimpleValue       pfam_family_accession      value\n     NL        SimpleValue       sequence_start_stop        value\n     SS        SimpleValue       sec_structure_source       value\n     BM        SimpleValue       build_model                value\n     RN        Reference         reference                  *\n     RC        Reference         reference                  comment\n     RM        Reference         reference                  pubmed\n     RT        Reference         reference                  title\n     RA        Reference         reference                  authors\n     RL        Reference         reference                  location\n    ----------------------------------------------------------------------\n  * RN is generated based on the number of Bio::Annotation::Reference objects\n\n=head2 Custom annotation\n\nSome users may want to add custom annotation beyond those mapped above.\nCurrently there are two methods to do so; however, the methods used for adding\nsuch annotation may change in the future, particularly if alignment Writer\nclasses are introduced. In particular, do not rely on changing the global\nvariables @WRITEORDER or %WRITEMAP as these may be made private at some point.\n\n1) Use (and abuse) the 'custom' tag.  The tagname for the object can differ\nfrom the tagname used to store the object in the AnnotationCollection.  \n\n    # AnnotationCollection from the SimpleAlign object\n    my $coll = $aln->annotation; \n    my $factory = Bio::Annotation::AnnotationFactory->new(-type => \n        Bio::Annotation::SimpleValue');\n    my $rfann = $factory->create_object(-value => $str, \n                                        -tagname => 'mytag');\n    $coll->add_Annotation('custom', $rfann);\n    $rfann = $factory->create_object(-value => 'foo',\n                                    -tagname => 'bar');\n    $coll->add_Annotation('custom', $rfann);\n\nOUTPUT:\n\n    # STOCKHOLM 1.0\n    \n    #=GF ID myID12345\n    #=GF mytag katnayygqelggvnhdyddlakfyfgaglealdffnnkeaaakiinwvaEDTTRGKIQDLV??\n    #=GF mytag TPtd~????LDPETQALLV???????????????????????NAIYFKGRWE?????????~??\n    #=GF mytag ??HEF?A?EMDTKPY??DFQH?TNen?????GRI??????V???KVAM??MF?????????N??\n    #=GF mytag ???DD?VFGYAEL????DE???????L??D??????A??TALELAY??????????????????\n    #=GF mytag ?????????????KG??????Sa???TSMLILLP???????????????D??????????????\n    #=GF mytag ???????????EGTr?????AGLGKLLQ??QL????????SREef??DLNK??L???AH????R\n    #=GF mytag ????????????L????????????????????????????????????????R?????????R\n    #=GF mytag ??QQ???????V???????AVRLPKFSFefefdlkeplknlgmhqafdpnsdvfklmdqavlvi\n    #=GF mytag gdlqhayafkvd????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ?????????????INVDEAG?TEAAAATAAKFVPLSLppkt??????????????????PIEFV\n    #=GF mytag ADRPFAFAIR??????E?PAT?G????SILFIGHVEDPTP?msv?\n    #=GF bar foo\n    ...\n\n2) Modify the global @WRITEORDER and %WRITEMAP.\n\n    # AnnotationCollection from the SimpleAlign object\n    my $coll = $aln->annotation;\n    \n    # add to WRITEORDER\n    my @order = @Bio::AlignIO::stockholm::WRITEORDER;\n    push @order, 'my_stuff';\n    @Bio::AlignIO::stockholm::WRITEORDER = @order;\n    \n    # make sure new tag maps to something\n    $Bio::AlignIO::stockholm::WRITEMAP{my_stuff} = 'Hobbit/SimpleValue';\n\n    my $rfann = $factory->create_object(-value => 'Frodo',\n                                        -tagname => 'Hobbit');\n    $coll->add_Annotation('my_stuff', $rfann);\n    $rfann = $factory->create_object(-value => 'Bilbo',\n                                     -tagname => 'Hobbit');\n    $coll->add_Annotation('my_stuff', $rfann);\n\nOUTPUT:\n\n    # STOCKHOLM 1.0\n    \n    #=GF ID myID12345\n    #=GF Hobbit Frodo\n    #=GF Hobbit Bilbo\n    ....\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Chris Fields, Peter Schattner\n\nEmail: cjfields-at-uiuc-dot-edu, schattner@alum.mit.edu \n\n=head1 CONTRIBUTORS\n\nAndreas Kahari, ak-at-ebi.ac.uk\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::stockholm;\nuse strict;\n\nuse Bio::Seq::Meta;\nuse Bio::AlignIO::Handler::GenericAlignHandler;\nuse Text::Wrap qw(wrap);\n\nuse base qw(Bio::AlignIO);\n\nmy $STKVERSION = 'STOCKHOLM 1.0';\n\n# This maps the two-letter annotation key to a Annotation/parameter/tagname\n# combination.  Some data is stored using get/set methods ('Methods')  The rest \n# is mapped to Annotation objects using the parameter for the parsed data\n# and the tagname for, well, the Annotation tagname.  A few are treated differently\n# based on the type of data stored (Reference data in particular).\n\nmy %MAPPING = (\n    'AC'    =>  'ACCESSION',\n    'ID'    =>  'ID',\n    'DE'    =>  ['DESCRIPTION' => 'DESCRIPTION'],\n    'AU'    =>  ['RECORD_AUTHORS' => 'RECORD_AUTHORS'],\n    'SE'    =>  'SEED_SOURCE',\n    'BM'    =>  'BUILD_COMMAND',\n    'GA'    =>  'GATHERING_THRESHOLD',\n    'NC'    =>  'NOISE_CUTOFF',\n    'TC'    =>  'TRUSTED_CUTOFF',\n    'TP'    =>  'ENTRY_TYPE',\n    'SQ'    =>  'NUM_SEQUENCES',\n    'PI'    =>  'PREVIOUS_IDS',\n    'DC'    =>  ['DATABASE_COMMENT' => 'DATABASE_COMMENT'],\n    'DR'    =>  'DBLINK',\n    'RN'    =>  ['REFERENCE' => 'REFERENCE'],\n    'RC'    =>  ['REFERENCE' => 'COMMENT'],\n    'RM'    =>  ['REFERENCE' => 'PUBMED'],\n    'RT'    =>  ['REFERENCE' => 'TITLE'],\n    'RA'    =>  ['REFERENCE' => 'AUTHORS'],\n    'RL'    =>  ['REFERENCE' => 'JOURNAL'],\n    'CC'    =>  ['ALIGNMENT_COMMENT' => 'ALIGNMENT_COMMENT'],\n    #Pfam-specific \n    'AM'    =>  'BUILD_METHOD',\n    'NE'    =>  'PFAM_FAMILY_ACCESSION',\n    'NL'    =>  'SEQ_START_STOP',\n    # Rfam-specific GF lines\n    #'SS'    =>  'SEC_STRUCTURE_SOURCE',\n    'SEQUENCE' => 'SEQUENCE'\n);\n\n# this is the order that annotations are written\nour @WRITEORDER = qw(accession\n  id\n  description\n  previous_ids  \n  record_authors\n  seed_source\n  sec_structure_source\n  gathering_threshold\n  trusted_cutoff \n  noise_cutoff\n  entry_type\n  build_command\n  build_method\n  pfam_family_accession\n  seq_start_stop\n  reference\n  database_comment\n  custom\n  dblink\n  alignment_comment\n  num_sequences\n  seq_annotation\n  );\n\n# This maps the tagname back to a tagname-annotation value combination.\n# Some data is stored using get/set methods ('Methods'), others\n# are mapped b/c of more complex annotation types.\n\nour %WRITEMAP = (\n    'accession'             =>  'AC/Method',\n    'id'                    =>  'ID/Method',\n    'description'           =>  'DE/Method',\n    'record_authors'        =>  'AU/SimpleValue',\n    'seed_source'           =>  'SE/SimpleValue',\n    'build_command'         =>  'BM/SimpleValue',\n    'gathering_threshold'   =>  'GA/SimpleValue',\n    'noise_cutoff'          =>  'NC/SimpleValue',\n    'trusted_cutoff'        =>  'TC/SimpleValue',\n    'entry_type'            =>  'TP/SimpleValue',\n    'num_sequences'         =>  'SQ/SimpleValue',\n    'previous_ids'          =>  'PI/SimpleValue',\n    'database_comment'      =>  'DC/SimpleValue',\n    'dblink'                =>  'DR/DBLink',\n    'reference'             =>  'RX/Reference',\n    'ref_number'            =>  'RN/number',\n    'ref_comment'           =>  'RC/comment',\n    'ref_pubmed'            =>  'RM/pubmed',\n    'ref_title'             =>  'RT/title',\n    'ref_authors'           =>  'RA/authors',\n    'ref_location'          =>  'RL/location',\n    'alignment_comment'     =>  'CC/Comment',\n    'seq_annotation'        =>  'DR/Collection',\n    #Pfam-specific \n    'build_method'          =>  'AM/SimpleValue',\n    'pfam_family_accession' =>  'NE/SimpleValue',\n    'seq_start_stop'        =>  'NL/SimpleValue',\n    # Rfam-specific GF lines\n    'sec_structure_source'  =>  'SS/SimpleValue',\n    # custom; this is used to carry over anything from the input alignment\n    # not mapped to LocatableSeqs or SimpleAlign in a meaningful way\n    'custom'                =>  'XX/SimpleValue'\n);\n\n# This maps the tagname back to a tagname-annotation value combination.\n# Some data is stored using get/set methods ('Methods'), others\n# are mapped b/c of more complex annotation types.\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file');\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : -line_length :  length of the line for the alignment block\n           -alphabet    :  symbol alphabet to set the sequences to.  If not set,\n                           the parser will try to guess based on the alignment\n                           accession (if present), defaulting to 'dna'.\n           -spaces      :  (optional, def = 1) boolean to add a space in between\n                           the \"# STOCKHOLM 1.0\" header and the annotation and\n                           the annotation and the alignment."},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":355,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"line":355,"kind":13,"name":"@args","containerName":"_initialize"},{"kind":13,"line":356,"name":"$self","containerName":"_initialize"},{"line":356,"kind":13,"containerName":"_initialize","name":"@args"},{"localvar":"my","containerName":"_initialize","name":"$handler","definition":"my","line":357,"kind":13},{"kind":13,"line":357,"containerName":"_initialize","name":"$linelength"},{"line":357,"kind":13,"containerName":"_initialize","name":"$spaces"},{"containerName":"_initialize","name":"$self","kind":13,"line":357},{"kind":12,"line":357,"name":"_rearrange","containerName":"_initialize"},{"line":357,"kind":13,"containerName":"_initialize","name":"@args"},{"line":358,"kind":13,"name":"$spaces","containerName":"_initialize"},{"name":"$spaces","containerName":"_initialize","kind":13,"line":358},{"line":358,"kind":13,"containerName":"_initialize","name":"$spaces"},{"name":"$self","containerName":"_initialize","line":359,"kind":13},{"containerName":"_initialize","name":"spaces","line":359,"kind":12},{"kind":13,"line":359,"name":"$spaces","containerName":"_initialize"},{"name":"$handler","containerName":"_initialize","line":361,"kind":13},{"line":361,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":361,"name":"alignhandler","containerName":"_initialize"},{"line":361,"kind":13,"name":"$handler","containerName":"_initialize"},{"line":362,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":362,"containerName":"_initialize","name":"alignhandler"},{"line":362,"kind":12,"containerName":"_initialize","name":"new"},{"containerName":"_initialize","name":"$self","line":364,"kind":13},{"name":"verbose","containerName":"_initialize","line":364,"kind":12},{"kind":13,"line":366,"containerName":"_initialize","name":"$linelength"},{"containerName":"_initialize","name":"$self","kind":13,"line":366},{"name":"line_length","containerName":"_initialize","kind":12,"line":366},{"kind":13,"line":366,"containerName":"_initialize","name":"$linelength"}],"line":354},{"kind":12,"line":356,"containerName":"_initialize","name":"SUPER"},{"line":362,"kind":12,"name":"Bio","containerName":"AlignIO::Handler::GenericAlignHandler"},{"line":379,"children":[{"name":"$self","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":380},{"name":"$handler","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":382},{"containerName":"next_aln","name":"$self","line":382,"kind":13},{"name":"alignhandler","containerName":"next_aln","kind":12,"line":382},{"definition":"my","name":"$line","containerName":"next_aln","localvar":"my","kind":13,"line":384},{"kind":13,"line":384,"name":"$self","containerName":"next_aln"},{"kind":12,"line":384,"name":"_readline","containerName":"next_aln"},{"line":385,"kind":13,"containerName":"next_aln","name":"$line"},{"name":"$self","containerName":"next_aln","kind":13,"line":390},{"localvar":"my","definition":"my","name":"$data_chunk","containerName":"next_aln","line":392,"kind":13},{"containerName":"next_aln","name":"$isa_primary","kind":13,"line":392},{"kind":13,"line":392,"name":"$name","containerName":"next_aln"},{"line":392,"kind":13,"name":"$alphabet","containerName":"next_aln"},{"kind":13,"line":393,"definition":"my","name":"$last_feat","containerName":"next_aln","localvar":"my"},{"containerName":"next_aln","name":"$line","definition":"my","localvar":"my","kind":13,"line":394},{"containerName":"next_aln","name":"$self","line":394,"kind":13},{"kind":12,"line":394,"containerName":"next_aln","name":"_readline"},{"name":"$primary_tag","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":396},{"containerName":"next_aln","name":"$secondary_tag","line":396,"kind":13},{"line":396,"kind":13,"name":"$data","containerName":"next_aln"},{"containerName":"next_aln","name":"$nse","line":396,"kind":13},{"name":"$feat","containerName":"next_aln","line":396,"kind":13},{"name":"$align","containerName":"next_aln","line":396,"kind":13},{"name":"$concat","containerName":"next_aln","line":396,"kind":13},{"line":397,"kind":13,"containerName":"next_aln","name":"$line"},{"containerName":"next_aln","name":"$self","kind":13,"line":398},{"kind":13,"line":403,"name":"$line","containerName":"next_aln"},{"containerName":"next_aln","name":"$handler","line":405,"kind":13},{"line":405,"kind":12,"name":"data_handler","containerName":"next_aln"},{"line":405,"kind":13,"containerName":"next_aln","name":"$data_chunk"},{"containerName":"next_aln","name":"$data_chunk","line":406,"kind":13},{"line":407,"kind":13,"name":"$handler","containerName":"next_aln"},{"line":407,"kind":12,"containerName":"next_aln","name":"data_handler"},{"containerName":"next_aln","name":"$self","kind":13,"line":409},{"containerName":"next_aln","name":"alphabet","kind":12,"line":409},{"kind":13,"line":410,"name":"$self","containerName":"next_aln"},{"name":"alphabet","containerName":"next_aln","line":410,"kind":12},{"line":413,"kind":13,"containerName":"next_aln","name":"$line"},{"containerName":"next_aln","name":"$primary_tag","kind":13,"line":414},{"kind":13,"line":414,"name":"$data","containerName":"next_aln"},{"containerName":"next_aln","name":"$primary_tag","line":415,"kind":13},{"containerName":"next_aln","name":"$primary_tag","kind":13,"line":415},{"containerName":"next_aln","name":"$nse","line":416,"kind":13},{"name":"$feat","containerName":"next_aln","line":416,"kind":13},{"containerName":"next_aln","name":"$data","line":416,"kind":13},{"kind":13,"line":416,"containerName":"next_aln","name":"$data"},{"containerName":"next_aln","name":"$feat","kind":13,"line":418},{"containerName":"next_aln","name":"$data","line":418,"kind":13},{"kind":13,"line":418,"name":"$data","containerName":"next_aln"},{"containerName":"next_aln","name":"$align","kind":13,"line":420},{"containerName":"next_aln","name":"$primary_tag","line":420,"kind":13},{"line":420,"kind":13,"name":"$primary_tag","containerName":"next_aln"},{"kind":13,"line":422,"name":"$line","containerName":"next_aln"},{"line":423,"kind":13,"containerName":"next_aln","name":"$self"},{"line":424,"kind":13,"containerName":"next_aln","name":"$feat"},{"line":424,"kind":13,"name":"$nse","containerName":"next_aln"},{"line":424,"kind":13,"containerName":"next_aln","name":"$data"},{"line":427,"kind":13,"name":"$self","containerName":"next_aln"},{"line":427,"kind":12,"containerName":"next_aln","name":"debug"},{"line":429,"kind":13,"name":"$primary_tag","containerName":"next_aln"},{"containerName":"next_aln","name":"$align","line":430,"kind":13},{"containerName":"next_aln","name":"$MAPPING","kind":13,"line":437},{"line":437,"kind":13,"containerName":"next_aln","name":"$feat"},{"name":"$MAPPING","containerName":"next_aln","line":437,"kind":13},{"kind":13,"line":437,"name":"$feat","containerName":"next_aln"},{"containerName":"next_aln","name":"$name","line":438,"kind":13},{"kind":13,"line":438,"containerName":"next_aln","name":"$secondary_tag"},{"kind":13,"line":438,"name":"$isa_primary","containerName":"next_aln"},{"kind":13,"line":438,"containerName":"next_aln","name":"$MAPPING"},{"kind":13,"line":438,"containerName":"next_aln","name":"$feat"},{"line":438,"kind":13,"containerName":"next_aln","name":"$MAPPING"},{"kind":13,"line":438,"name":"$feat","containerName":"next_aln"},{"name":"$MAPPING","containerName":"next_aln","line":439,"kind":13},{"line":439,"kind":13,"containerName":"next_aln","name":"$feat"},{"kind":13,"line":440,"containerName":"next_aln","name":"$MAPPING"},{"line":440,"kind":13,"containerName":"next_aln","name":"$feat"},{"name":"$concat","containerName":"next_aln","kind":13,"line":441},{"kind":13,"line":441,"containerName":"next_aln","name":"$last_feat"},{"containerName":"next_aln","name":"$feat","line":441,"kind":13},{"name":"$MAPPING","containerName":"next_aln","kind":13,"line":442},{"line":442,"kind":13,"name":"$feat","containerName":"next_aln"},{"kind":13,"line":443,"name":"$name","containerName":"next_aln"},{"line":443,"kind":13,"containerName":"next_aln","name":"$secondary_tag"},{"containerName":"next_aln","name":"$isa_primary","kind":13,"line":443},{"line":443,"kind":13,"containerName":"next_aln","name":"$MAPPING"},{"kind":13,"line":443,"containerName":"next_aln","name":"$feat"},{"line":445,"kind":13,"name":"$align","containerName":"next_aln"},{"name":"$name","containerName":"next_aln","line":445,"kind":13},{"name":"$self","containerName":"next_aln","kind":13,"line":445},{"name":"alphabet","containerName":"next_aln","line":445,"kind":12},{"name":"$data","containerName":"next_aln","kind":13,"line":446},{"kind":13,"line":447,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","name":"alphabet","kind":12,"line":447},{"line":451,"kind":13,"containerName":"next_aln","name":"$name"},{"name":"$primary_tag","containerName":"next_aln","kind":13,"line":451},{"containerName":"next_aln","name":"$primary_tag","line":452,"kind":13},{"line":454,"kind":13,"containerName":"next_aln","name":"$secondary_tag"},{"kind":13,"line":454,"name":"$isa_primary","containerName":"next_aln"},{"name":"$isa_primary","containerName":"next_aln","kind":13,"line":469},{"kind":13,"line":469,"name":"$data_chunk","containerName":"next_aln"},{"line":469,"kind":13,"containerName":"next_aln","name":"$concat"},{"kind":13,"line":470,"name":"$handler","containerName":"next_aln"},{"line":470,"kind":12,"containerName":"next_aln","name":"data_handler"},{"name":"$data_chunk","containerName":"next_aln","line":470,"kind":13},{"line":471,"kind":13,"name":"$data_chunk","containerName":"next_aln"},{"kind":13,"line":473,"name":"$data_chunk","containerName":"next_aln"},{"containerName":"next_aln","name":"$name","kind":13,"line":473},{"kind":13,"line":474,"containerName":"next_aln","name":"$data_chunk"},{"name":"$align","containerName":"next_aln","kind":13,"line":474},{"line":475,"kind":13,"name":"$data_chunk","containerName":"next_aln"},{"name":"$secondary_tag","containerName":"next_aln","kind":13,"line":475},{"kind":13,"line":475,"name":"$data_chunk","containerName":"next_aln"},{"kind":13,"line":475,"name":"$secondary_tag","containerName":"next_aln"},{"line":476,"kind":13,"containerName":"next_aln","name":"$data"},{"name":"$data","containerName":"next_aln","kind":13,"line":476},{"containerName":"next_aln","name":"$data_chunk","line":477,"kind":13},{"kind":13,"line":477,"name":"$nse","containerName":"next_aln"},{"name":"$nse","containerName":"next_aln","kind":13,"line":477},{"containerName":"next_aln","name":"$name","line":478,"kind":13},{"name":"$name","containerName":"next_aln","line":478,"kind":13},{"containerName":"next_aln","name":"$name","kind":13,"line":478},{"line":479,"kind":13,"name":"$data_chunk","containerName":"next_aln"},{"name":"$self","containerName":"next_aln","line":479,"kind":13},{"name":"$data_chunk","containerName":"next_aln","line":480,"kind":13},{"line":480,"kind":13,"containerName":"next_aln","name":"$feat"},{"name":"$name","containerName":"next_aln","line":480,"kind":13},{"line":482,"kind":13,"containerName":"next_aln","name":"$last_feat"},{"kind":13,"line":482,"containerName":"next_aln","name":"$feat"}],"kind":12,"range":{"end":{"line":483,"character":9999},"start":{"line":379,"character":0}},"containerName":"main::","definition":"sub","name":"next_aln"},{"name":"block_line","line":390,"kind":12},{"name":"block_line","kind":12,"line":398},{"kind":12,"line":407,"name":"ALIGNMENT"},{"kind":12,"line":408,"name":"NAME"},{"name":"DATA","kind":12,"line":409},{"kind":12,"line":423,"name":"block_line"},{"name":"NAME","kind":12,"line":473},{"name":"ALIGNMENT","line":474,"kind":12},{"line":477,"kind":12,"name":"NSE"},{"name":"BLOCK_LINE","line":479,"kind":12},{"name":"block_line","line":479,"kind":12},{"line":480,"kind":12,"name":"META_TAG"},{"localvar":"my","name":"$aln","definition":"my","containerName":null,"line":485,"kind":13},{"line":485,"kind":13,"name":"$handler","containerName":null},{"line":485,"kind":12,"containerName":"main::","name":"build_alignment"},{"line":486,"kind":13,"containerName":null,"name":"$handler"},{"containerName":"main::","name":"reset_parameters","line":486,"kind":12},{"name":"%aln","containerName":null,"line":487,"kind":13},{"containerName":null,"name":"%LINK_CB","definition":"my","localvar":"my","kind":13,"line":501},{"name":"database","containerName":"main::","line":502,"kind":12},{"containerName":"main::","name":"primary_id","line":503,"kind":12},{"line":504,"kind":12,"name":"optional_id","containerName":"main::"},{"name":"start","containerName":"main::","line":505,"kind":12},{"containerName":"main::","name":"end","line":506,"kind":12},{"name":"database","containerName":"main::","line":507,"kind":12},{"containerName":"main::","name":"primary_id","kind":12,"line":508},{"containerName":"main::","name":"optional_id","line":509,"kind":12},{"line":510,"kind":12,"containerName":"main::","name":"database"},{"kind":12,"line":511,"name":"primary_id","containerName":"main::"},{"range":{"end":{"line":645,"character":9999},"start":{"line":514,"character":0}},"name":"write_aln","detail":"($self,@aln)","signature":{"label":"write_aln($self,@aln)","documentation":"","parameters":[{"label":"$self"},{"label":"@aln"}]},"containerName":"main::","definition":"sub","line":514,"children":[{"localvar":"my","containerName":"write_aln","name":"$self","definition":"my","line":516,"kind":13},{"name":"@aln","containerName":"write_aln","kind":13,"line":516},{"line":517,"kind":13,"localvar":"my","containerName":"write_aln","name":"$aln","definition":"my"},{"name":"@aln","containerName":"write_aln","kind":13,"line":517},{"line":518,"kind":13,"name":"$self","containerName":"write_aln"},{"line":518,"kind":12,"containerName":"write_aln","name":"throw"},{"kind":13,"line":519,"name":"$aln","containerName":"write_aln"},{"kind":13,"line":519,"containerName":"write_aln","name":"$aln"},{"line":519,"kind":12,"containerName":"write_aln","name":"isa"},{"localvar":"my","containerName":"write_aln","name":"$coll","definition":"my","line":521,"kind":13},{"name":"$aln","containerName":"write_aln","kind":13,"line":521},{"kind":12,"line":521,"name":"annotation","containerName":"write_aln"},{"localvar":"my","containerName":"write_aln","definition":"my","name":"$aln_ann","line":522,"kind":13},{"name":"$seq_ann","containerName":"write_aln","line":522,"kind":13},{"line":524,"kind":13,"containerName":"write_aln","name":"$self"},{"containerName":"write_aln","name":"_print","kind":12,"line":524},{"name":"$self","containerName":"write_aln","kind":13,"line":525},{"kind":12,"line":525,"containerName":"write_aln","name":"spaces"},{"containerName":"write_aln","name":"$self","kind":13,"line":525},{"containerName":"write_aln","name":"_print","line":525,"kind":12},{"kind":13,"line":529,"containerName":"write_aln","name":"$param","definition":"my","localvar":"my"},{"name":"@WRITEORDER","containerName":"write_aln","kind":13,"line":529},{"line":530,"kind":13,"localvar":"my","definition":"my","name":"@anns","containerName":"write_aln"},{"containerName":"write_aln","name":"$coll","line":532,"kind":13},{"line":534,"kind":13,"localvar":"my","definition":"my","name":"$ct","containerName":"write_aln"},{"kind":13,"line":535,"name":"$self","containerName":"write_aln"},{"containerName":"write_aln","name":"throw","kind":12,"line":535},{"line":535,"kind":13,"containerName":"write_aln","name":"$WRITEMAP"},{"kind":13,"line":535,"name":"$param","containerName":"write_aln"},{"localvar":"my","containerName":"write_aln","name":"$tag","definition":"my","line":537,"kind":13},{"kind":13,"line":537,"containerName":"write_aln","name":"$key"},{"kind":13,"line":537,"name":"$WRITEMAP","containerName":"write_aln"},{"name":"$param","containerName":"write_aln","line":537,"kind":13},{"line":538,"kind":13,"name":"$key","containerName":"write_aln"},{"kind":13,"line":539,"containerName":"write_aln","name":"@anns"},{"line":539,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":539,"kind":13,"containerName":"write_aln","name":"$param"},{"containerName":"write_aln","name":"@anns","line":541,"kind":13},{"name":"$coll","containerName":"write_aln","line":541,"kind":13},{"name":"get_Annotations","containerName":"write_aln","line":541,"kind":12},{"line":541,"kind":13,"containerName":"write_aln","name":"$param"},{"line":543,"kind":13,"localvar":"my","definition":"my","name":"$rn","containerName":"write_aln"},{"line":545,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$ann"},{"containerName":"write_aln","name":"@anns","kind":13,"line":545},{"localvar":"my","definition":"my","name":"$text","containerName":"write_aln","line":547,"kind":13},{"line":547,"kind":13,"containerName":"write_aln","name":"$alntag"},{"name":"$data","containerName":"write_aln","kind":13,"line":547},{"kind":13,"line":548,"name":"$tag","containerName":"write_aln"},{"containerName":"write_aln","definition":"my","name":"$rkey","localvar":"my","kind":13,"line":550},{"kind":13,"line":552,"name":"$newtag","definition":"my","containerName":"write_aln","localvar":"my"},{"name":"$method","containerName":"write_aln","kind":13,"line":552},{"kind":13,"line":552,"name":"$WRITEMAP","containerName":"write_aln"},{"containerName":"write_aln","name":"$rkey","kind":13,"line":552},{"kind":13,"line":553,"name":"$alntag","containerName":"write_aln"},{"line":553,"kind":13,"containerName":"write_aln","name":"$aln_ann"},{"name":"$newtag","containerName":"write_aln","line":553,"kind":13},{"kind":13,"line":554,"name":"$rkey","containerName":"write_aln"},{"kind":13,"line":555,"name":"$data","containerName":"write_aln"},{"line":557,"kind":13,"name":"$data","containerName":"write_aln"},{"line":557,"kind":13,"containerName":"write_aln","name":"$ann"},{"line":557,"kind":13,"name":"$method","containerName":"write_aln"},{"name":"$data","containerName":"write_aln","line":559,"kind":13},{"line":560,"kind":13,"containerName":"write_aln","name":"$text"},{"name":"$alntag","containerName":"write_aln","line":560,"kind":13},{"containerName":"write_aln","name":"$alntag","line":560,"kind":13},{"name":"$data","containerName":"write_aln","line":560,"kind":13},{"kind":13,"line":561,"name":"$self","containerName":"write_aln"},{"line":561,"kind":12,"name":"_print","containerName":"write_aln"},{"name":"$rn","containerName":"write_aln","line":563,"kind":13},{"line":566,"kind":13,"containerName":"write_aln","name":"$tag"},{"kind":13,"line":567,"containerName":"write_aln","name":"$newtag","definition":"my","localvar":"my"},{"name":"$ann","containerName":"write_aln","line":567,"kind":13},{"line":567,"kind":12,"containerName":"write_aln","name":"tagname"},{"line":568,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$tmp"},{"line":568,"kind":13,"containerName":"write_aln","name":"$aln_ann"},{"line":568,"kind":13,"name":"$newtag","containerName":"write_aln"},{"name":"$alntag","containerName":"write_aln","line":569,"kind":13},{"line":569,"kind":13,"name":"$tmp","containerName":"write_aln"},{"line":569,"kind":13,"name":"$tmp","containerName":"write_aln"},{"kind":13,"line":570,"name":"$data","containerName":"write_aln"},{"name":"$ann","containerName":"write_aln","line":570,"kind":13},{"containerName":"write_aln","name":"display_text","kind":12,"line":570},{"containerName":"write_aln","name":"$tag","kind":13,"line":572},{"kind":13,"line":574,"containerName":"write_aln","definition":"my","name":"$tmp","localvar":"my"},{"kind":13,"line":574,"name":"$aln_ann","containerName":"write_aln"},{"kind":13,"line":574,"name":"$tag","containerName":"write_aln"},{"name":"$alntag","containerName":"write_aln","line":575,"kind":13},{"containerName":"write_aln","name":"$tmp","line":575,"kind":13},{"line":575,"kind":13,"containerName":"write_aln","name":"$tmp"},{"kind":13,"line":576,"name":"$data","containerName":"write_aln"},{"line":576,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":576,"kind":12,"containerName":"write_aln","name":"num_sequences"},{"kind":13,"line":578,"containerName":"write_aln","name":"$tag"},{"line":579,"kind":13,"localvar":"my","name":"$tmp","definition":"my","containerName":"write_aln"},{"name":"$aln_ann","containerName":"write_aln","line":579,"kind":13},{"name":"$tag","containerName":"write_aln","line":579,"kind":13},{"line":580,"kind":13,"containerName":"write_aln","name":"$alntag"},{"name":"$tmp","containerName":"write_aln","kind":13,"line":580},{"name":"$tmp","containerName":"write_aln","line":580,"kind":13},{"containerName":"write_aln","name":"$db","definition":"my","localvar":"my","kind":13,"line":581},{"name":"$ann","containerName":"write_aln","line":581,"kind":13},{"name":"database","containerName":"write_aln","kind":12,"line":581},{"line":582,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$cb"},{"kind":13,"line":582,"name":"$LINK_CB","containerName":"write_aln"},{"kind":13,"line":582,"containerName":"write_aln","name":"$db"},{"line":582,"kind":13,"containerName":"write_aln","name":"$LINK_CB"},{"containerName":"write_aln","name":"$db","line":582,"kind":13},{"name":"$LINK_CB","containerName":"write_aln","kind":13,"line":582},{"line":583,"kind":13,"containerName":"write_aln","name":"$data"},{"containerName":"write_aln","name":"$ann","line":583,"kind":13},{"name":"display_text","containerName":"write_aln","kind":12,"line":583},{"containerName":"write_aln","name":"$cb","line":583,"kind":13},{"definition":"my","name":"$tmp","containerName":"write_aln","localvar":"my","kind":13,"line":586},{"line":586,"kind":13,"name":"$aln_ann","containerName":"write_aln"},{"kind":13,"line":586,"containerName":"write_aln","name":"$tag"},{"line":587,"kind":13,"containerName":"write_aln","name":"$alntag"},{"name":"$tmp","containerName":"write_aln","kind":13,"line":587},{"name":"$tmp","containerName":"write_aln","kind":13,"line":587},{"containerName":"write_aln","name":"$data","line":588,"kind":13},{"kind":13,"line":588,"containerName":"write_aln","name":"$ann"},{"kind":13,"line":588,"name":"$ann","containerName":"write_aln"},{"kind":12,"line":588,"name":"display_text","containerName":"write_aln"},{"containerName":"write_aln","name":"$ann","line":588,"kind":13},{"name":"$data","containerName":"write_aln","line":590,"kind":13},{"kind":13,"line":591,"name":"$text","containerName":"write_aln"},{"kind":13,"line":591,"name":"$alntag","containerName":"write_aln"},{"kind":13,"line":591,"containerName":"write_aln","name":"$alntag"},{"name":"$data","containerName":"write_aln","kind":13,"line":591},{"containerName":"write_aln","name":"$self","kind":13,"line":592},{"name":"_print","containerName":"write_aln","kind":12,"line":592},{"localvar":"my","definition":"my","name":"$tag","containerName":"write_aln","line":597,"kind":13},{"line":598,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"write_aln"},{"kind":13,"line":598,"containerName":"write_aln","name":"$aln"},{"line":598,"kind":12,"containerName":"write_aln","name":"each_seq"},{"kind":13,"line":599,"containerName":"write_aln","name":"$acc","definition":"my","localvar":"my"},{"line":599,"kind":13,"name":"$seq","containerName":"write_aln"},{"name":"accession_number","containerName":"write_aln","line":599,"kind":12},{"kind":13,"line":600,"containerName":"write_aln","definition":"my","name":"$text","localvar":"my"},{"containerName":"write_aln","name":"$seq_ann","line":600,"kind":13},{"line":600,"kind":13,"name":"$seq","containerName":"write_aln"},{"containerName":"write_aln","name":"get_nse","kind":12,"line":600},{"containerName":"write_aln","name":"$tag","line":600,"kind":13},{"kind":13,"line":600,"containerName":"write_aln","name":"$acc"},{"line":601,"kind":13,"name":"$self","containerName":"write_aln"},{"containerName":"write_aln","name":"_print","line":601,"kind":12},{"kind":13,"line":601,"containerName":"write_aln","name":"$text"},{"line":606,"kind":13,"name":"$tag","containerName":"write_aln"},{"kind":13,"line":607,"containerName":"write_aln","definition":"my","name":"$sf","localvar":"my"},{"containerName":"write_aln","name":"$aln","line":607,"kind":13},{"containerName":"write_aln","name":"get_SeqFeatures","line":607,"kind":12},{"definition":"my","name":"@links","containerName":"write_aln","localvar":"my","kind":13,"line":608},{"containerName":"write_aln","name":"$sf","kind":13,"line":608},{"name":"annotation","containerName":"write_aln","kind":12,"line":608},{"containerName":"write_aln","name":"get_Annotations","line":608,"kind":12},{"line":609,"kind":13,"localvar":"my","definition":"my","name":"$link","containerName":"write_aln"},{"containerName":"write_aln","name":"@links","line":609,"kind":13},{"kind":13,"line":610,"name":"$db","definition":"my","containerName":"write_aln","localvar":"my"},{"kind":13,"line":610,"name":"$link","containerName":"write_aln"},{"containerName":"write_aln","name":"database","line":610,"kind":12},{"line":611,"kind":13,"localvar":"my","containerName":"write_aln","name":"$cb","definition":"my"},{"name":"$LINK_CB","containerName":"write_aln","line":611,"kind":13},{"line":611,"kind":13,"containerName":"write_aln","name":"$db"},{"containerName":"write_aln","name":"$LINK_CB","kind":13,"line":611},{"name":"$db","containerName":"write_aln","line":611,"kind":13},{"kind":13,"line":611,"containerName":"write_aln","name":"$LINK_CB"},{"kind":13,"line":612,"containerName":"write_aln","name":"$text","definition":"my","localvar":"my"},{"kind":13,"line":612,"name":"$seq_ann","containerName":"write_aln"},{"line":613,"kind":13,"name":"$sf","containerName":"write_aln"},{"line":613,"kind":12,"containerName":"write_aln","name":"entire_seq"},{"kind":12,"line":613,"containerName":"write_aln","name":"get_nse"},{"kind":13,"line":614,"name":"$tag","containerName":"write_aln"},{"kind":13,"line":615,"name":"$link","containerName":"write_aln"},{"containerName":"write_aln","name":"display_text","line":615,"kind":12},{"name":"$cb","containerName":"write_aln","line":615,"kind":13},{"containerName":"write_aln","name":"$self","line":616,"kind":13},{"name":"_print","containerName":"write_aln","kind":12,"line":616},{"containerName":"write_aln","name":"$text","kind":13,"line":616},{"name":"$self","containerName":"write_aln","kind":13,"line":621},{"containerName":"write_aln","name":"spaces","line":621,"kind":12},{"kind":13,"line":621,"containerName":"write_aln","name":"$self"},{"containerName":"write_aln","name":"_print","kind":12,"line":621},{"containerName":"write_aln","definition":"my","name":"$blocklen","localvar":"my","kind":13,"line":624},{"kind":13,"line":624,"name":"$self","containerName":"write_aln"},{"name":"line_length","containerName":"write_aln","kind":12,"line":624},{"line":625,"kind":13,"localvar":"my","name":"$maxlen","definition":"my","containerName":"write_aln"},{"name":"$aln","containerName":"write_aln","line":625,"kind":13},{"line":625,"kind":12,"name":"maxdisplayname_length","containerName":"write_aln"},{"kind":13,"line":626,"containerName":"write_aln","name":"$metalen","definition":"my","localvar":"my"},{"containerName":"write_aln","name":"$aln","line":626,"kind":13},{"kind":12,"line":626,"containerName":"write_aln","name":"max_metaname_length"},{"containerName":"write_aln","name":"$blocklen","line":627,"kind":13},{"line":628,"kind":13,"localvar":"my","containerName":"write_aln","name":"$blockstart","definition":"my"},{"kind":13,"line":629,"definition":"my","name":"$alnlen","containerName":"write_aln","localvar":"my"},{"line":629,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"length","kind":12,"line":629},{"kind":13,"line":630,"name":"$blockstart","containerName":"write_aln"},{"kind":13,"line":630,"name":"$alnlen","containerName":"write_aln"},{"kind":13,"line":631,"definition":"my","name":"$subaln","containerName":"write_aln","localvar":"my"},{"line":631,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":631,"kind":12,"containerName":"write_aln","name":"slice"},{"containerName":"write_aln","name":"$blockstart","kind":13,"line":631},{"kind":13,"line":631,"containerName":"write_aln","name":"$blockstart"},{"line":631,"kind":13,"containerName":"write_aln","name":"$blocklen"},{"name":"$self","containerName":"write_aln","kind":13,"line":632},{"line":632,"kind":12,"containerName":"write_aln","name":"_print_seqs"},{"kind":13,"line":632,"containerName":"write_aln","name":"$subaln"},{"name":"$maxlen","containerName":"write_aln","line":632,"kind":13},{"containerName":"write_aln","name":"$metalen","kind":13,"line":632},{"containerName":"write_aln","name":"$blockstart","line":633,"kind":13},{"name":"$blocklen","containerName":"write_aln","kind":13,"line":633},{"containerName":"write_aln","name":"$self","kind":13,"line":634},{"line":634,"kind":12,"containerName":"write_aln","name":"_print"},{"name":"$blockstart","containerName":"write_aln","line":634,"kind":13},{"kind":13,"line":634,"containerName":"write_aln","name":"$alnlen"},{"containerName":"write_aln","name":"$self","kind":13,"line":637},{"containerName":"write_aln","name":"_print_seqs","line":637,"kind":12},{"containerName":"write_aln","name":"$aln","kind":13,"line":637},{"name":"$maxlen","containerName":"write_aln","line":637,"kind":13},{"line":637,"kind":13,"name":"$metalen","containerName":"write_aln"},{"kind":13,"line":640,"containerName":"write_aln","name":"$self"},{"line":640,"kind":12,"name":"_print","containerName":"write_aln"},{"name":"$self","containerName":"write_aln","kind":13,"line":642},{"name":"flush","containerName":"write_aln","line":642,"kind":12},{"containerName":"write_aln","name":"$self","kind":13,"line":642},{"name":"_flush_on_write","containerName":"write_aln","line":642,"kind":12},{"kind":13,"line":642,"containerName":"write_aln","name":"$self"},{"kind":12,"line":642,"name":"_fh","containerName":"write_aln"}],"kind":12},{"line":544,"kind":12,"name":"ANNOTATIONS"},{"name":"REFS","line":549,"kind":12},{"line":559,"kind":12,"name":"REFS"},{"name":"wrap","line":560,"kind":12},{"name":"ANNOTATIONS","kind":12,"line":564},{"kind":12,"line":582,"name":"_DEFAULT_"},{"name":"wrap","kind":12,"line":591},{"kind":12,"line":611,"name":"_DEFAULT_"},{"range":{"end":{"character":9999,"line":665},"start":{"character":0,"line":659}},"name":"line_length","children":[{"line":660,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"line_length"},{"name":"$value","containerName":"line_length","line":660,"kind":13},{"name":"$value","containerName":"line_length","kind":13,"line":661},{"name":"$self","containerName":"line_length","line":662,"kind":13},{"kind":13,"line":662,"containerName":"line_length","name":"$value"},{"name":"$self","containerName":"line_length","kind":13,"line":664}],"line":659,"kind":12,"signature":{"label":"line_length($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: stockholm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::stockholm\n#\n#   Based on the Bio::SeqIO::stockholm module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Peter Schattner, Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# September 5, 2000\n# November 6, 2006 - completely refactor read_aln(), add write_aln()\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::stockholm - stockholm sequence input/output stream\n\n=head1 SYNOPSIS\n\n  # Do not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n  use Bio::AlignIO;\n  use strict;\n\n  my $in = Bio::AlignIO->new(-format => 'stockholm',\n                             -file   => 't/data/testaln.stockholm');\n  while( my $aln = $in->next_aln ) {\n\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from\nstockholm flat file databases.  This has been completely refactored\nfrom the original stockholm parser to handle annotation data and now\nincludes a write_aln() method for (almost) complete stockholm\nformat output.\n\nStockholm alignment records normally contain additional sequence-based\nand alignment-based annotation\n\n  GF Lines (alignment feature/annotation):\n  #=GF <featurename> <Generic per-file annotation, free text>\n  Placed above the alignment\n\n  GC Lines (Alignment consensus)\n  #=GC <featurename> <Generic per-column annotation, exactly 1\n       character per column>\n  Placed below the alignment\n\n  GS Lines (Sequence annotations)\n  #=GS <seqname> <featurename> <Generic per-sequence annotation, free\n       text>\n\n  GR Lines (Sequence meta data)\n  #=GR <seqname> <featurename> <Generic per-sequence AND per-column\n       mark up, exactly 1 character per column>\n\nCurrently, sequence annotations (those designated with GS tags) are\nparsed only for accession numbers and descriptions.  It is intended that\nfull parsing will be added at some point in the near future along with\na builder option for optionally parsing alignment annotation and meta data.\n\nThe following methods/tags are currently used for storing and writing\nthe alignment annotation data.\n\n    Tag        SimpleAlign\n                 Method  \n    ----------------------------------------------------------------------\n     AC        accession  \n     ID        id  \n     DE        description\n    ----------------------------------------------------------------------\n\n    Tag        Bio::Annotation   TagName                    Parameters\n               Class\n    ----------------------------------------------------------------------\n     AU        SimpleValue       record_authors             value\n     SE        SimpleValue       seed_source                value\n     GA        SimpleValue       gathering_threshold        value\n     NC        SimpleValue       noise_cutoff               value\n     TC        SimpleValue       trusted_cutoff             value\n     TP        SimpleValue       entry_type                 value\n     SQ        SimpleValue       num_sequences              value\n     PI        SimpleValue       previous_ids               value\n     DC        Comment           database_comment           comment\n     CC        Comment           alignment_comment          comment\n     DR        Target            dblink                     database\n                                                            primary_id\n                                                            comment\n     AM        SimpleValue       build_method               value\n     NE        SimpleValue       pfam_family_accession      value\n     NL        SimpleValue       sequence_start_stop        value\n     SS        SimpleValue       sec_structure_source       value\n     BM        SimpleValue       build_model                value\n     RN        Reference         reference                  *\n     RC        Reference         reference                  comment\n     RM        Reference         reference                  pubmed\n     RT        Reference         reference                  title\n     RA        Reference         reference                  authors\n     RL        Reference         reference                  location\n    ----------------------------------------------------------------------\n  * RN is generated based on the number of Bio::Annotation::Reference objects\n\n=head2 Custom annotation\n\nSome users may want to add custom annotation beyond those mapped above.\nCurrently there are two methods to do so; however, the methods used for adding\nsuch annotation may change in the future, particularly if alignment Writer\nclasses are introduced. In particular, do not rely on changing the global\nvariables @WRITEORDER or %WRITEMAP as these may be made private at some point.\n\n1) Use (and abuse) the 'custom' tag.  The tagname for the object can differ\nfrom the tagname used to store the object in the AnnotationCollection.  \n\n    # AnnotationCollection from the SimpleAlign object\n    my $coll = $aln->annotation; \n    my $factory = Bio::Annotation::AnnotationFactory->new(-type => \n        Bio::Annotation::SimpleValue');\n    my $rfann = $factory->create_object(-value => $str, \n                                        -tagname => 'mytag');\n    $coll->add_Annotation('custom', $rfann);\n    $rfann = $factory->create_object(-value => 'foo',\n                                    -tagname => 'bar');\n    $coll->add_Annotation('custom', $rfann);\n\nOUTPUT:\n\n    # STOCKHOLM 1.0\n    \n    #=GF ID myID12345\n    #=GF mytag katnayygqelggvnhdyddlakfyfgaglealdffnnkeaaakiinwvaEDTTRGKIQDLV??\n    #=GF mytag TPtd~????LDPETQALLV???????????????????????NAIYFKGRWE?????????~??\n    #=GF mytag ??HEF?A?EMDTKPY??DFQH?TNen?????GRI??????V???KVAM??MF?????????N??\n    #=GF mytag ???DD?VFGYAEL????DE???????L??D??????A??TALELAY??????????????????\n    #=GF mytag ?????????????KG??????Sa???TSMLILLP???????????????D??????????????\n    #=GF mytag ???????????EGTr?????AGLGKLLQ??QL????????SREef??DLNK??L???AH????R\n    #=GF mytag ????????????L????????????????????????????????????????R?????????R\n    #=GF mytag ??QQ???????V???????AVRLPKFSFefefdlkeplknlgmhqafdpnsdvfklmdqavlvi\n    #=GF mytag gdlqhayafkvd????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ?????????????INVDEAG?TEAAAATAAKFVPLSLppkt??????????????????PIEFV\n    #=GF mytag ADRPFAFAIR??????E?PAT?G????SILFIGHVEDPTP?msv?\n    #=GF bar foo\n    ...\n\n2) Modify the global @WRITEORDER and %WRITEMAP.\n\n    # AnnotationCollection from the SimpleAlign object\n    my $coll = $aln->annotation;\n    \n    # add to WRITEORDER\n    my @order = @Bio::AlignIO::stockholm::WRITEORDER;\n    push @order, 'my_stuff';\n    @Bio::AlignIO::stockholm::WRITEORDER = @order;\n    \n    # make sure new tag maps to something\n    $Bio::AlignIO::stockholm::WRITEMAP{my_stuff} = 'Hobbit/SimpleValue';\n\n    my $rfann = $factory->create_object(-value => 'Frodo',\n                                        -tagname => 'Hobbit');\n    $coll->add_Annotation('my_stuff', $rfann);\n    $rfann = $factory->create_object(-value => 'Bilbo',\n                                     -tagname => 'Hobbit');\n    $coll->add_Annotation('my_stuff', $rfann);\n\nOUTPUT:\n\n    # STOCKHOLM 1.0\n    \n    #=GF ID myID12345\n    #=GF Hobbit Frodo\n    #=GF Hobbit Bilbo\n    ....\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Chris Fields, Peter Schattner\n\nEmail: cjfields-at-uiuc-dot-edu, schattner@alum.mit.edu \n\n=head1 CONTRIBUTORS\n\nAndreas Kahari, ak-at-ebi.ac.uk\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::stockholm;\nuse strict;\n\nuse Bio::Seq::Meta;\nuse Bio::AlignIO::Handler::GenericAlignHandler;\nuse Text::Wrap qw(wrap);\n\nuse base qw(Bio::AlignIO);\n\nmy $STKVERSION = 'STOCKHOLM 1.0';\n\n# This maps the two-letter annotation key to a Annotation/parameter/tagname\n# combination.  Some data is stored using get/set methods ('Methods')  The rest \n# is mapped to Annotation objects using the parameter for the parsed data\n# and the tagname for, well, the Annotation tagname.  A few are treated differently\n# based on the type of data stored (Reference data in particular).\n\nmy %MAPPING = (\n    'AC'    =>  'ACCESSION',\n    'ID'    =>  'ID',\n    'DE'    =>  ['DESCRIPTION' => 'DESCRIPTION'],\n    'AU'    =>  ['RECORD_AUTHORS' => 'RECORD_AUTHORS'],\n    'SE'    =>  'SEED_SOURCE',\n    'BM'    =>  'BUILD_COMMAND',\n    'GA'    =>  'GATHERING_THRESHOLD',\n    'NC'    =>  'NOISE_CUTOFF',\n    'TC'    =>  'TRUSTED_CUTOFF',\n    'TP'    =>  'ENTRY_TYPE',\n    'SQ'    =>  'NUM_SEQUENCES',\n    'PI'    =>  'PREVIOUS_IDS',\n    'DC'    =>  ['DATABASE_COMMENT' => 'DATABASE_COMMENT'],\n    'DR'    =>  'DBLINK',\n    'RN'    =>  ['REFERENCE' => 'REFERENCE'],\n    'RC'    =>  ['REFERENCE' => 'COMMENT'],\n    'RM'    =>  ['REFERENCE' => 'PUBMED'],\n    'RT'    =>  ['REFERENCE' => 'TITLE'],\n    'RA'    =>  ['REFERENCE' => 'AUTHORS'],\n    'RL'    =>  ['REFERENCE' => 'JOURNAL'],\n    'CC'    =>  ['ALIGNMENT_COMMENT' => 'ALIGNMENT_COMMENT'],\n    #Pfam-specific \n    'AM'    =>  'BUILD_METHOD',\n    'NE'    =>  'PFAM_FAMILY_ACCESSION',\n    'NL'    =>  'SEQ_START_STOP',\n    # Rfam-specific GF lines\n    #'SS'    =>  'SEC_STRUCTURE_SOURCE',\n    'SEQUENCE' => 'SEQUENCE'\n);\n\n# this is the order that annotations are written\nour @WRITEORDER = qw(accession\n  id\n  description\n  previous_ids  \n  record_authors\n  seed_source\n  sec_structure_source\n  gathering_threshold\n  trusted_cutoff \n  noise_cutoff\n  entry_type\n  build_command\n  build_method\n  pfam_family_accession\n  seq_start_stop\n  reference\n  database_comment\n  custom\n  dblink\n  alignment_comment\n  num_sequences\n  seq_annotation\n  );\n\n# This maps the tagname back to a tagname-annotation value combination.\n# Some data is stored using get/set methods ('Methods'), others\n# are mapped b/c of more complex annotation types.\n\nour %WRITEMAP = (\n    'accession'             =>  'AC/Method',\n    'id'                    =>  'ID/Method',\n    'description'           =>  'DE/Method',\n    'record_authors'        =>  'AU/SimpleValue',\n    'seed_source'           =>  'SE/SimpleValue',\n    'build_command'         =>  'BM/SimpleValue',\n    'gathering_threshold'   =>  'GA/SimpleValue',\n    'noise_cutoff'          =>  'NC/SimpleValue',\n    'trusted_cutoff'        =>  'TC/SimpleValue',\n    'entry_type'            =>  'TP/SimpleValue',\n    'num_sequences'         =>  'SQ/SimpleValue',\n    'previous_ids'          =>  'PI/SimpleValue',\n    'database_comment'      =>  'DC/SimpleValue',\n    'dblink'                =>  'DR/DBLink',\n    'reference'             =>  'RX/Reference',\n    'ref_number'            =>  'RN/number',\n    'ref_comment'           =>  'RC/comment',\n    'ref_pubmed'            =>  'RM/pubmed',\n    'ref_title'             =>  'RT/title',\n    'ref_authors'           =>  'RA/authors',\n    'ref_location'          =>  'RL/location',\n    'alignment_comment'     =>  'CC/Comment',\n    'seq_annotation'        =>  'DR/Collection',\n    #Pfam-specific \n    'build_method'          =>  'AM/SimpleValue',\n    'pfam_family_accession' =>  'NE/SimpleValue',\n    'seq_start_stop'        =>  'NL/SimpleValue',\n    # Rfam-specific GF lines\n    'sec_structure_source'  =>  'SS/SimpleValue',\n    # custom; this is used to carry over anything from the input alignment\n    # not mapped to LocatableSeqs or SimpleAlign in a meaningful way\n    'custom'                =>  'XX/SimpleValue'\n);\n\n# This maps the tagname back to a tagname-annotation value combination.\n# Some data is stored using get/set methods ('Methods'), others\n# are mapped b/c of more complex annotation types.\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file');\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : -line_length :  length of the line for the alignment block\n           -alphabet    :  symbol alphabet to set the sequences to.  If not set,\n                           the parser will try to guess based on the alignment\n                           accession (if present), defaulting to 'dna'.\n           -spaces      :  (optional, def = 1) boolean to add a space in between\n                           the \"# STOCKHOLM 1.0\" header and the annotation and\n                           the annotation and the alignment.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($handler, $linelength, $spaces) = $self->_rearrange([qw(HANDLER LINE_LENGTH SPACES)],@args);\n    $spaces = defined $spaces ? $spaces : 1;\n    $self->spaces($spaces);\n    # hash for functions for decoding keys.\n    $handler ? $self->alignhandler($handler) :\n    $self->alignhandler(Bio::AlignIO::Handler::GenericAlignHandler->new(\n                    -format => 'stockholm',\n                    -verbose => $self->verbose,\n                    ));\n    $linelength && $self->line_length($linelength);\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object\n Args    : NONE\n\n\nsub next_aln {\n    my $self = shift;\n    \n    my $handler = $self->alignhandler;\n    # advance to alignment header\n    while( defined(my $line = $self->_readline) ) {        \n        if ($line =~ m{^\\#\\s*STOCKHOLM\\s+}xmso) {\n            last;\n        }\n    }\n    \n    $self->{block_line} = 0;\n    # go into main body of alignment\n    my ($data_chunk, $isa_primary, $name, $alphabet);\n    my $last_feat = '';\n    while( defined(my $line = $self->_readline) ) {\n        # only blank lines are in between blocks, so reset block line\n        my ($primary_tag, $secondary_tag, $data, $nse, $feat, $align, $concat);\n        if ($line =~ m{^\\s*$}xmso) {\n            $self->{block_line} &&= 0;\n            next;\n        }\n        \n        # End of Record\n        if (index($line, '//') == 0) {\n            # fencepost\n            $handler->data_handler($data_chunk);\n            undef $data_chunk;\n            $handler->data_handler({ALIGNMENT => 1,\n                                    NAME => 'ALPHABET',\n                                    DATA => $self->alphabet})\n                if $self->alphabet;\n            last;\n        }\n        elsif ($line =~ m{^\\#=([A-Z]{2})\\s+([^\\n]+?)\\s*$}xmso) {\n            ($primary_tag, $data) = ($1, $2);\n            if ($primary_tag eq 'GS' || $primary_tag eq 'GR') {\n                ($nse, $feat, $data) = split(/\\s+/, $data, 3);\n            } else {\n                ($feat, $data) = split(/\\s+/, $data, 2);\n            }\n            $align = ($primary_tag eq 'GF' || $primary_tag eq 'GR') ? 1 : 0;\n        }\n        elsif ($line =~ m{^([^\\#]\\S+)\\s+([^\\s]+)\\s*}) {\n            $self->{block_line}++;\n            ($feat, $nse, $data) = ('SEQUENCE', $1, $2);\n        }\n        else {\n            $self->debug(\"Missed line : $line\\n\");\n        }\n        $primary_tag ||= ''; # when no #= line is present\n        $align ||= 0;\n\n        # array refs where the two values are equal indicate the start of a\n        # primary chunk of data, otherwise it is to be folded into the last\n        # data chunk under a secondary tag.  These are also concatenated\n        # to previous values if the \n\n        if (exists($MAPPING{$feat}) && ref $MAPPING{$feat} eq 'ARRAY') {\n            ($name, $secondary_tag, $isa_primary) = ( $MAPPING{$feat}->[0] eq $MAPPING{$feat}->[1] ) ?\n                ($MAPPING{$feat}->[0], 'DATA', 1) :\n                (@{ $MAPPING{$feat} }, 0) ;\n            $concat = $last_feat eq $feat ? 1 : 0;\n        } elsif (exists($MAPPING{$feat})) {\n            ($name, $secondary_tag, $isa_primary) = ($MAPPING{$feat}, 'DATA', 1);\n            # catch alphabet here if possible\n            if ($align && $name eq 'ACCESSION' && !$self->alphabet) {\n                if ($data =~ m{^(P|R)F}) {\n                    $self->alphabet($1 eq 'R' ? 'rna' : $1 eq 'P' ? 'protein' : undef );\n                }\n            }\n        } else {\n            $name = ($primary_tag eq 'GR') ? 'NAMED_META' :\n                    ($primary_tag eq 'GC') ? 'CONSENSUS_META' :\n                    'CUSTOM';\n            ($secondary_tag, $isa_primary) = ('DATA', 1);\n        }\n        \n        # Since we can't determine whether data should be passed into the\n        # Handler until the next round (due to concatenation and combining\n        # data), we always check for the presence of the last chunk when the\n        # occasion calls for it (i.e. when the current data string needs to go\n        # into a new data chunk). If the data needs to be concatenated it is\n        # flagged above and checked below (and passed by if the conditions\n        # warrant it).\n        \n        # We run into a bit of a fencepost problem, (one chunk left over at\n        # the end); that is taken care of above when the end of the record is\n        # found.\n        \n        if ($isa_primary && defined $data_chunk && !$concat) {\n            $handler->data_handler($data_chunk);\n            undef $data_chunk;\n        }\n        $data_chunk->{NAME} = $name;       # used for the handler\n        $data_chunk->{ALIGNMENT} = $align; # flag that determines chunk destination\n        $data_chunk->{$secondary_tag} .= (defined($data_chunk->{$secondary_tag})) ?\n            ' '.$data : $data;\n        $data_chunk->{NSE} = $nse if $nse;\n        if ($name eq 'SEQUENCE' || $name eq 'NAMED_META' || $name eq 'CONSENSUS_META') {\n            $data_chunk->{BLOCK_LINE} = $self->{block_line};\n            $data_chunk->{META_TAG} = $feat if ($name ne 'SEQUENCE');\n        }\n        $last_feat = $feat;\n    }\n    \n    my $aln = $handler->build_alignment;\n    $handler->reset_parameters;\n    return $aln;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in stockholm format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\n{\n    my %LINK_CB = (\n        'PDB' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id.' '.\n                                 ($_[0]->optional_id || ''),\n                                 $_[0]->start,\n                                 $_[0]->end)).';'},\n        'SCOP' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id || '',\n                                 $_[0]->optional_id)).';'},\n        '_DEFAULT_' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id)).';'},\n    );\n\nsub write_aln {\n    # enable array of SimpleAlign objects as well (see clustalw write_aln())\n    my ($self, @aln) = @_;\n    for my $aln (@aln) {\n    $self->throw('Need Bio::Align::AlignI object')\n          if (!$aln || !($aln->isa('Bio::Align::AlignI')));\n\n    my $coll = $aln->annotation;\n    my ($aln_ann, $seq_ann) =\n       ('#=GF ', '#=GS ');\n    $self->_print(\"# $STKVERSION\\n\") || return 0;\n    $self->spaces && $self->_print(\"\\n\");\n    # annotations first\n    \n    #=GF XX ....\n    for my $param (@WRITEORDER) {\n        my @anns;\n        # no point in going through this if there is no annotation!\n        last if !$coll;\n        # alignment annotations\n        my $ct = 1;\n        $self->throw(\"Bad parameter: $param\") if !exists $WRITEMAP{$param};\n        # get the data, act on it based on the tag\n        my ($tag, $key) = split q(/), $WRITEMAP{$param};\n        if ($key eq 'Method') {\n            push @anns, $aln->$param;\n        } else {\n            @anns = $coll->get_Annotations($param);\n        }\n        my $rn = 1;\n        ANNOTATIONS:\n        for my $ann (@anns) {\n            # using Text::Wrap::wrap() for word wrap\n            my ($text, $alntag, $data);\n            if ($tag eq 'RX') {\n                REFS:\n                for my $rkey (qw(ref_comment ref_number ref_pubmed\n                              ref_title ref_authors ref_location)) {\n                    my ($newtag, $method) = split q(/), $WRITEMAP{$rkey};\n                    $alntag = sprintf('%-10s',$aln_ann.$newtag);\n                    if ($rkey eq 'ref_number') {\n                        $data = \"[$rn]\";\n                    } else {\n                        $data = $ann->$method;\n                    }\n                    next REFS unless $data;\n                    $text = wrap($alntag, $alntag, $data);\n                    $self->_print(\"$text\\n\") or return 0;\n                }\n                $rn++;\n                next ANNOTATIONS;\n            }\n            elsif ($tag eq 'XX') { # custom\n                my $newtag = $ann->tagname;\n                my $tmp = $aln_ann.$newtag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = $ann->display_text;\n            }\n            elsif ($tag eq 'SQ') {\n                # use the actual number, not the stored Annotation data\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = $aln->num_sequences;\n            }\n            elsif ($tag eq 'DR') {\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                my $db = uc $ann->database;\n                my $cb = exists $LINK_CB{$db} ? $LINK_CB{$db} : $LINK_CB{_DEFAULT_};\n                $data = $ann->display_text($cb);\n            }\n            else {\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = ref $ann ? $ann->display_text : $ann;\n            }\n            next unless $data;\n            $text = wrap($alntag, $alntag, $data);\n            $self->_print(\"$text\\n\") || return 0;\n        }\n    }\n    \n    #=GS <seq-id> AC xxxxxx\n    my $tag = 'AC';\n    for my $seq ($aln->each_seq) {\n        if (my $acc = $seq->accession_number) {\n        my $text = sprintf(\"%-4s%-22s%-3s%s\\n\",$seq_ann, $seq->get_nse, $tag, $acc);\n        $self->_print($text) || return 0;\n        }\n    }\n    \n    #=GS <seq-id> DR xxxxxx\n    $tag = 'DR';\n    for my $sf ($aln->get_SeqFeatures) {\n        if (my @links = $sf->annotation->get_Annotations('dblink')) {\n            for my $link (@links) {\n                my $db = uc $link->database;\n                my $cb = exists $LINK_CB{$db} ? $LINK_CB{$db} : $LINK_CB{_DEFAULT_};\n                my $text = sprintf(\"%-4s%-22s%-3s%s\\n\",$seq_ann,\n                                   $sf->entire_seq->get_nse,\n                                   $tag,\n                                   $link->display_text($cb));\n                $self->_print($text) || return 0;\n            }\n        }\n    }    \n    \n    $self->spaces && $self->_print(\"\\n\");    \n    # now the sequences...\n    \n    my $blocklen = $self->line_length;\n    my $maxlen = $aln->maxdisplayname_length() + 3;\n    my $metalen = $aln->max_metaname_length() || 0;\n    if ($blocklen) {\n        my $blockstart = 1;\n        my $alnlen = $aln->length;\n        while ($blockstart < $alnlen) {\n            my $subaln = $aln->slice($blockstart, $blockstart+$blocklen-1 ,1);\n            $self->_print_seqs($subaln,$maxlen,$metalen);\n            $blockstart += $blocklen;\n            $self->_print(\"\\n\") unless $blockstart >= $alnlen;\n        }\n    } else {\n        $self->_print_seqs($aln,$maxlen,$metalen);\n    }\n    \n    $self->_print(\"//\\n\") || return 0;\n    }\n    $self->flush() if $self->_flush_on_write && defined $self->_fh;\n    \n    return 1;\n}\n\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function: Set the alignment output line length\n Returns : value of line_length\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"alphabet","range":{"end":{"character":9999,"line":684},"start":{"character":0,"line":677}},"definition":"sub","containerName":"main::","signature":{"label":"alphabet($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: stockholm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::stockholm\n#\n#   Based on the Bio::SeqIO::stockholm module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Peter Schattner, Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# September 5, 2000\n# November 6, 2006 - completely refactor read_aln(), add write_aln()\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::stockholm - stockholm sequence input/output stream\n\n=head1 SYNOPSIS\n\n  # Do not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n  use Bio::AlignIO;\n  use strict;\n\n  my $in = Bio::AlignIO->new(-format => 'stockholm',\n                             -file   => 't/data/testaln.stockholm');\n  while( my $aln = $in->next_aln ) {\n\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from\nstockholm flat file databases.  This has been completely refactored\nfrom the original stockholm parser to handle annotation data and now\nincludes a write_aln() method for (almost) complete stockholm\nformat output.\n\nStockholm alignment records normally contain additional sequence-based\nand alignment-based annotation\n\n  GF Lines (alignment feature/annotation):\n  #=GF <featurename> <Generic per-file annotation, free text>\n  Placed above the alignment\n\n  GC Lines (Alignment consensus)\n  #=GC <featurename> <Generic per-column annotation, exactly 1\n       character per column>\n  Placed below the alignment\n\n  GS Lines (Sequence annotations)\n  #=GS <seqname> <featurename> <Generic per-sequence annotation, free\n       text>\n\n  GR Lines (Sequence meta data)\n  #=GR <seqname> <featurename> <Generic per-sequence AND per-column\n       mark up, exactly 1 character per column>\n\nCurrently, sequence annotations (those designated with GS tags) are\nparsed only for accession numbers and descriptions.  It is intended that\nfull parsing will be added at some point in the near future along with\na builder option for optionally parsing alignment annotation and meta data.\n\nThe following methods/tags are currently used for storing and writing\nthe alignment annotation data.\n\n    Tag        SimpleAlign\n                 Method  \n    ----------------------------------------------------------------------\n     AC        accession  \n     ID        id  \n     DE        description\n    ----------------------------------------------------------------------\n\n    Tag        Bio::Annotation   TagName                    Parameters\n               Class\n    ----------------------------------------------------------------------\n     AU        SimpleValue       record_authors             value\n     SE        SimpleValue       seed_source                value\n     GA        SimpleValue       gathering_threshold        value\n     NC        SimpleValue       noise_cutoff               value\n     TC        SimpleValue       trusted_cutoff             value\n     TP        SimpleValue       entry_type                 value\n     SQ        SimpleValue       num_sequences              value\n     PI        SimpleValue       previous_ids               value\n     DC        Comment           database_comment           comment\n     CC        Comment           alignment_comment          comment\n     DR        Target            dblink                     database\n                                                            primary_id\n                                                            comment\n     AM        SimpleValue       build_method               value\n     NE        SimpleValue       pfam_family_accession      value\n     NL        SimpleValue       sequence_start_stop        value\n     SS        SimpleValue       sec_structure_source       value\n     BM        SimpleValue       build_model                value\n     RN        Reference         reference                  *\n     RC        Reference         reference                  comment\n     RM        Reference         reference                  pubmed\n     RT        Reference         reference                  title\n     RA        Reference         reference                  authors\n     RL        Reference         reference                  location\n    ----------------------------------------------------------------------\n  * RN is generated based on the number of Bio::Annotation::Reference objects\n\n=head2 Custom annotation\n\nSome users may want to add custom annotation beyond those mapped above.\nCurrently there are two methods to do so; however, the methods used for adding\nsuch annotation may change in the future, particularly if alignment Writer\nclasses are introduced. In particular, do not rely on changing the global\nvariables @WRITEORDER or %WRITEMAP as these may be made private at some point.\n\n1) Use (and abuse) the 'custom' tag.  The tagname for the object can differ\nfrom the tagname used to store the object in the AnnotationCollection.  \n\n    # AnnotationCollection from the SimpleAlign object\n    my $coll = $aln->annotation; \n    my $factory = Bio::Annotation::AnnotationFactory->new(-type => \n        Bio::Annotation::SimpleValue');\n    my $rfann = $factory->create_object(-value => $str, \n                                        -tagname => 'mytag');\n    $coll->add_Annotation('custom', $rfann);\n    $rfann = $factory->create_object(-value => 'foo',\n                                    -tagname => 'bar');\n    $coll->add_Annotation('custom', $rfann);\n\nOUTPUT:\n\n    # STOCKHOLM 1.0\n    \n    #=GF ID myID12345\n    #=GF mytag katnayygqelggvnhdyddlakfyfgaglealdffnnkeaaakiinwvaEDTTRGKIQDLV??\n    #=GF mytag TPtd~????LDPETQALLV???????????????????????NAIYFKGRWE?????????~??\n    #=GF mytag ??HEF?A?EMDTKPY??DFQH?TNen?????GRI??????V???KVAM??MF?????????N??\n    #=GF mytag ???DD?VFGYAEL????DE???????L??D??????A??TALELAY??????????????????\n    #=GF mytag ?????????????KG??????Sa???TSMLILLP???????????????D??????????????\n    #=GF mytag ???????????EGTr?????AGLGKLLQ??QL????????SREef??DLNK??L???AH????R\n    #=GF mytag ????????????L????????????????????????????????????????R?????????R\n    #=GF mytag ??QQ???????V???????AVRLPKFSFefefdlkeplknlgmhqafdpnsdvfklmdqavlvi\n    #=GF mytag gdlqhayafkvd????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ?????????????INVDEAG?TEAAAATAAKFVPLSLppkt??????????????????PIEFV\n    #=GF mytag ADRPFAFAIR??????E?PAT?G????SILFIGHVEDPTP?msv?\n    #=GF bar foo\n    ...\n\n2) Modify the global @WRITEORDER and %WRITEMAP.\n\n    # AnnotationCollection from the SimpleAlign object\n    my $coll = $aln->annotation;\n    \n    # add to WRITEORDER\n    my @order = @Bio::AlignIO::stockholm::WRITEORDER;\n    push @order, 'my_stuff';\n    @Bio::AlignIO::stockholm::WRITEORDER = @order;\n    \n    # make sure new tag maps to something\n    $Bio::AlignIO::stockholm::WRITEMAP{my_stuff} = 'Hobbit/SimpleValue';\n\n    my $rfann = $factory->create_object(-value => 'Frodo',\n                                        -tagname => 'Hobbit');\n    $coll->add_Annotation('my_stuff', $rfann);\n    $rfann = $factory->create_object(-value => 'Bilbo',\n                                     -tagname => 'Hobbit');\n    $coll->add_Annotation('my_stuff', $rfann);\n\nOUTPUT:\n\n    # STOCKHOLM 1.0\n    \n    #=GF ID myID12345\n    #=GF Hobbit Frodo\n    #=GF Hobbit Bilbo\n    ....\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Chris Fields, Peter Schattner\n\nEmail: cjfields-at-uiuc-dot-edu, schattner@alum.mit.edu \n\n=head1 CONTRIBUTORS\n\nAndreas Kahari, ak-at-ebi.ac.uk\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::stockholm;\nuse strict;\n\nuse Bio::Seq::Meta;\nuse Bio::AlignIO::Handler::GenericAlignHandler;\nuse Text::Wrap qw(wrap);\n\nuse base qw(Bio::AlignIO);\n\nmy $STKVERSION = 'STOCKHOLM 1.0';\n\n# This maps the two-letter annotation key to a Annotation/parameter/tagname\n# combination.  Some data is stored using get/set methods ('Methods')  The rest \n# is mapped to Annotation objects using the parameter for the parsed data\n# and the tagname for, well, the Annotation tagname.  A few are treated differently\n# based on the type of data stored (Reference data in particular).\n\nmy %MAPPING = (\n    'AC'    =>  'ACCESSION',\n    'ID'    =>  'ID',\n    'DE'    =>  ['DESCRIPTION' => 'DESCRIPTION'],\n    'AU'    =>  ['RECORD_AUTHORS' => 'RECORD_AUTHORS'],\n    'SE'    =>  'SEED_SOURCE',\n    'BM'    =>  'BUILD_COMMAND',\n    'GA'    =>  'GATHERING_THRESHOLD',\n    'NC'    =>  'NOISE_CUTOFF',\n    'TC'    =>  'TRUSTED_CUTOFF',\n    'TP'    =>  'ENTRY_TYPE',\n    'SQ'    =>  'NUM_SEQUENCES',\n    'PI'    =>  'PREVIOUS_IDS',\n    'DC'    =>  ['DATABASE_COMMENT' => 'DATABASE_COMMENT'],\n    'DR'    =>  'DBLINK',\n    'RN'    =>  ['REFERENCE' => 'REFERENCE'],\n    'RC'    =>  ['REFERENCE' => 'COMMENT'],\n    'RM'    =>  ['REFERENCE' => 'PUBMED'],\n    'RT'    =>  ['REFERENCE' => 'TITLE'],\n    'RA'    =>  ['REFERENCE' => 'AUTHORS'],\n    'RL'    =>  ['REFERENCE' => 'JOURNAL'],\n    'CC'    =>  ['ALIGNMENT_COMMENT' => 'ALIGNMENT_COMMENT'],\n    #Pfam-specific \n    'AM'    =>  'BUILD_METHOD',\n    'NE'    =>  'PFAM_FAMILY_ACCESSION',\n    'NL'    =>  'SEQ_START_STOP',\n    # Rfam-specific GF lines\n    #'SS'    =>  'SEC_STRUCTURE_SOURCE',\n    'SEQUENCE' => 'SEQUENCE'\n);\n\n# this is the order that annotations are written\nour @WRITEORDER = qw(accession\n  id\n  description\n  previous_ids  \n  record_authors\n  seed_source\n  sec_structure_source\n  gathering_threshold\n  trusted_cutoff \n  noise_cutoff\n  entry_type\n  build_command\n  build_method\n  pfam_family_accession\n  seq_start_stop\n  reference\n  database_comment\n  custom\n  dblink\n  alignment_comment\n  num_sequences\n  seq_annotation\n  );\n\n# This maps the tagname back to a tagname-annotation value combination.\n# Some data is stored using get/set methods ('Methods'), others\n# are mapped b/c of more complex annotation types.\n\nour %WRITEMAP = (\n    'accession'             =>  'AC/Method',\n    'id'                    =>  'ID/Method',\n    'description'           =>  'DE/Method',\n    'record_authors'        =>  'AU/SimpleValue',\n    'seed_source'           =>  'SE/SimpleValue',\n    'build_command'         =>  'BM/SimpleValue',\n    'gathering_threshold'   =>  'GA/SimpleValue',\n    'noise_cutoff'          =>  'NC/SimpleValue',\n    'trusted_cutoff'        =>  'TC/SimpleValue',\n    'entry_type'            =>  'TP/SimpleValue',\n    'num_sequences'         =>  'SQ/SimpleValue',\n    'previous_ids'          =>  'PI/SimpleValue',\n    'database_comment'      =>  'DC/SimpleValue',\n    'dblink'                =>  'DR/DBLink',\n    'reference'             =>  'RX/Reference',\n    'ref_number'            =>  'RN/number',\n    'ref_comment'           =>  'RC/comment',\n    'ref_pubmed'            =>  'RM/pubmed',\n    'ref_title'             =>  'RT/title',\n    'ref_authors'           =>  'RA/authors',\n    'ref_location'          =>  'RL/location',\n    'alignment_comment'     =>  'CC/Comment',\n    'seq_annotation'        =>  'DR/Collection',\n    #Pfam-specific \n    'build_method'          =>  'AM/SimpleValue',\n    'pfam_family_accession' =>  'NE/SimpleValue',\n    'seq_start_stop'        =>  'NL/SimpleValue',\n    # Rfam-specific GF lines\n    'sec_structure_source'  =>  'SS/SimpleValue',\n    # custom; this is used to carry over anything from the input alignment\n    # not mapped to LocatableSeqs or SimpleAlign in a meaningful way\n    'custom'                =>  'XX/SimpleValue'\n);\n\n# This maps the tagname back to a tagname-annotation value combination.\n# Some data is stored using get/set methods ('Methods'), others\n# are mapped b/c of more complex annotation types.\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file');\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : -line_length :  length of the line for the alignment block\n           -alphabet    :  symbol alphabet to set the sequences to.  If not set,\n                           the parser will try to guess based on the alignment\n                           accession (if present), defaulting to 'dna'.\n           -spaces      :  (optional, def = 1) boolean to add a space in between\n                           the \"# STOCKHOLM 1.0\" header and the annotation and\n                           the annotation and the alignment.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($handler, $linelength, $spaces) = $self->_rearrange([qw(HANDLER LINE_LENGTH SPACES)],@args);\n    $spaces = defined $spaces ? $spaces : 1;\n    $self->spaces($spaces);\n    # hash for functions for decoding keys.\n    $handler ? $self->alignhandler($handler) :\n    $self->alignhandler(Bio::AlignIO::Handler::GenericAlignHandler->new(\n                    -format => 'stockholm',\n                    -verbose => $self->verbose,\n                    ));\n    $linelength && $self->line_length($linelength);\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object\n Args    : NONE\n\n\nsub next_aln {\n    my $self = shift;\n    \n    my $handler = $self->alignhandler;\n    # advance to alignment header\n    while( defined(my $line = $self->_readline) ) {        \n        if ($line =~ m{^\\#\\s*STOCKHOLM\\s+}xmso) {\n            last;\n        }\n    }\n    \n    $self->{block_line} = 0;\n    # go into main body of alignment\n    my ($data_chunk, $isa_primary, $name, $alphabet);\n    my $last_feat = '';\n    while( defined(my $line = $self->_readline) ) {\n        # only blank lines are in between blocks, so reset block line\n        my ($primary_tag, $secondary_tag, $data, $nse, $feat, $align, $concat);\n        if ($line =~ m{^\\s*$}xmso) {\n            $self->{block_line} &&= 0;\n            next;\n        }\n        \n        # End of Record\n        if (index($line, '//') == 0) {\n            # fencepost\n            $handler->data_handler($data_chunk);\n            undef $data_chunk;\n            $handler->data_handler({ALIGNMENT => 1,\n                                    NAME => 'ALPHABET',\n                                    DATA => $self->alphabet})\n                if $self->alphabet;\n            last;\n        }\n        elsif ($line =~ m{^\\#=([A-Z]{2})\\s+([^\\n]+?)\\s*$}xmso) {\n            ($primary_tag, $data) = ($1, $2);\n            if ($primary_tag eq 'GS' || $primary_tag eq 'GR') {\n                ($nse, $feat, $data) = split(/\\s+/, $data, 3);\n            } else {\n                ($feat, $data) = split(/\\s+/, $data, 2);\n            }\n            $align = ($primary_tag eq 'GF' || $primary_tag eq 'GR') ? 1 : 0;\n        }\n        elsif ($line =~ m{^([^\\#]\\S+)\\s+([^\\s]+)\\s*}) {\n            $self->{block_line}++;\n            ($feat, $nse, $data) = ('SEQUENCE', $1, $2);\n        }\n        else {\n            $self->debug(\"Missed line : $line\\n\");\n        }\n        $primary_tag ||= ''; # when no #= line is present\n        $align ||= 0;\n\n        # array refs where the two values are equal indicate the start of a\n        # primary chunk of data, otherwise it is to be folded into the last\n        # data chunk under a secondary tag.  These are also concatenated\n        # to previous values if the \n\n        if (exists($MAPPING{$feat}) && ref $MAPPING{$feat} eq 'ARRAY') {\n            ($name, $secondary_tag, $isa_primary) = ( $MAPPING{$feat}->[0] eq $MAPPING{$feat}->[1] ) ?\n                ($MAPPING{$feat}->[0], 'DATA', 1) :\n                (@{ $MAPPING{$feat} }, 0) ;\n            $concat = $last_feat eq $feat ? 1 : 0;\n        } elsif (exists($MAPPING{$feat})) {\n            ($name, $secondary_tag, $isa_primary) = ($MAPPING{$feat}, 'DATA', 1);\n            # catch alphabet here if possible\n            if ($align && $name eq 'ACCESSION' && !$self->alphabet) {\n                if ($data =~ m{^(P|R)F}) {\n                    $self->alphabet($1 eq 'R' ? 'rna' : $1 eq 'P' ? 'protein' : undef );\n                }\n            }\n        } else {\n            $name = ($primary_tag eq 'GR') ? 'NAMED_META' :\n                    ($primary_tag eq 'GC') ? 'CONSENSUS_META' :\n                    'CUSTOM';\n            ($secondary_tag, $isa_primary) = ('DATA', 1);\n        }\n        \n        # Since we can't determine whether data should be passed into the\n        # Handler until the next round (due to concatenation and combining\n        # data), we always check for the presence of the last chunk when the\n        # occasion calls for it (i.e. when the current data string needs to go\n        # into a new data chunk). If the data needs to be concatenated it is\n        # flagged above and checked below (and passed by if the conditions\n        # warrant it).\n        \n        # We run into a bit of a fencepost problem, (one chunk left over at\n        # the end); that is taken care of above when the end of the record is\n        # found.\n        \n        if ($isa_primary && defined $data_chunk && !$concat) {\n            $handler->data_handler($data_chunk);\n            undef $data_chunk;\n        }\n        $data_chunk->{NAME} = $name;       # used for the handler\n        $data_chunk->{ALIGNMENT} = $align; # flag that determines chunk destination\n        $data_chunk->{$secondary_tag} .= (defined($data_chunk->{$secondary_tag})) ?\n            ' '.$data : $data;\n        $data_chunk->{NSE} = $nse if $nse;\n        if ($name eq 'SEQUENCE' || $name eq 'NAMED_META' || $name eq 'CONSENSUS_META') {\n            $data_chunk->{BLOCK_LINE} = $self->{block_line};\n            $data_chunk->{META_TAG} = $feat if ($name ne 'SEQUENCE');\n        }\n        $last_feat = $feat;\n    }\n    \n    my $aln = $handler->build_alignment;\n    $handler->reset_parameters;\n    return $aln;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in stockholm format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\n{\n    my %LINK_CB = (\n        'PDB' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id.' '.\n                                 ($_[0]->optional_id || ''),\n                                 $_[0]->start,\n                                 $_[0]->end)).';'},\n        'SCOP' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id || '',\n                                 $_[0]->optional_id)).';'},\n        '_DEFAULT_' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id)).';'},\n    );\n\nsub write_aln {\n    # enable array of SimpleAlign objects as well (see clustalw write_aln())\n    my ($self, @aln) = @_;\n    for my $aln (@aln) {\n    $self->throw('Need Bio::Align::AlignI object')\n          if (!$aln || !($aln->isa('Bio::Align::AlignI')));\n\n    my $coll = $aln->annotation;\n    my ($aln_ann, $seq_ann) =\n       ('#=GF ', '#=GS ');\n    $self->_print(\"# $STKVERSION\\n\") || return 0;\n    $self->spaces && $self->_print(\"\\n\");\n    # annotations first\n    \n    #=GF XX ....\n    for my $param (@WRITEORDER) {\n        my @anns;\n        # no point in going through this if there is no annotation!\n        last if !$coll;\n        # alignment annotations\n        my $ct = 1;\n        $self->throw(\"Bad parameter: $param\") if !exists $WRITEMAP{$param};\n        # get the data, act on it based on the tag\n        my ($tag, $key) = split q(/), $WRITEMAP{$param};\n        if ($key eq 'Method') {\n            push @anns, $aln->$param;\n        } else {\n            @anns = $coll->get_Annotations($param);\n        }\n        my $rn = 1;\n        ANNOTATIONS:\n        for my $ann (@anns) {\n            # using Text::Wrap::wrap() for word wrap\n            my ($text, $alntag, $data);\n            if ($tag eq 'RX') {\n                REFS:\n                for my $rkey (qw(ref_comment ref_number ref_pubmed\n                              ref_title ref_authors ref_location)) {\n                    my ($newtag, $method) = split q(/), $WRITEMAP{$rkey};\n                    $alntag = sprintf('%-10s',$aln_ann.$newtag);\n                    if ($rkey eq 'ref_number') {\n                        $data = \"[$rn]\";\n                    } else {\n                        $data = $ann->$method;\n                    }\n                    next REFS unless $data;\n                    $text = wrap($alntag, $alntag, $data);\n                    $self->_print(\"$text\\n\") or return 0;\n                }\n                $rn++;\n                next ANNOTATIONS;\n            }\n            elsif ($tag eq 'XX') { # custom\n                my $newtag = $ann->tagname;\n                my $tmp = $aln_ann.$newtag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = $ann->display_text;\n            }\n            elsif ($tag eq 'SQ') {\n                # use the actual number, not the stored Annotation data\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = $aln->num_sequences;\n            }\n            elsif ($tag eq 'DR') {\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                my $db = uc $ann->database;\n                my $cb = exists $LINK_CB{$db} ? $LINK_CB{$db} : $LINK_CB{_DEFAULT_};\n                $data = $ann->display_text($cb);\n            }\n            else {\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = ref $ann ? $ann->display_text : $ann;\n            }\n            next unless $data;\n            $text = wrap($alntag, $alntag, $data);\n            $self->_print(\"$text\\n\") || return 0;\n        }\n    }\n    \n    #=GS <seq-id> AC xxxxxx\n    my $tag = 'AC';\n    for my $seq ($aln->each_seq) {\n        if (my $acc = $seq->accession_number) {\n        my $text = sprintf(\"%-4s%-22s%-3s%s\\n\",$seq_ann, $seq->get_nse, $tag, $acc);\n        $self->_print($text) || return 0;\n        }\n    }\n    \n    #=GS <seq-id> DR xxxxxx\n    $tag = 'DR';\n    for my $sf ($aln->get_SeqFeatures) {\n        if (my @links = $sf->annotation->get_Annotations('dblink')) {\n            for my $link (@links) {\n                my $db = uc $link->database;\n                my $cb = exists $LINK_CB{$db} ? $LINK_CB{$db} : $LINK_CB{_DEFAULT_};\n                my $text = sprintf(\"%-4s%-22s%-3s%s\\n\",$seq_ann,\n                                   $sf->entire_seq->get_nse,\n                                   $tag,\n                                   $link->display_text($cb));\n                $self->_print($text) || return 0;\n            }\n        }\n    }    \n    \n    $self->spaces && $self->_print(\"\\n\");    \n    # now the sequences...\n    \n    my $blocklen = $self->line_length;\n    my $maxlen = $aln->maxdisplayname_length() + 3;\n    my $metalen = $aln->max_metaname_length() || 0;\n    if ($blocklen) {\n        my $blockstart = 1;\n        my $alnlen = $aln->length;\n        while ($blockstart < $alnlen) {\n            my $subaln = $aln->slice($blockstart, $blockstart+$blocklen-1 ,1);\n            $self->_print_seqs($subaln,$maxlen,$metalen);\n            $blockstart += $blocklen;\n            $self->_print(\"\\n\") unless $blockstart >= $alnlen;\n        }\n    } else {\n        $self->_print_seqs($aln,$maxlen,$metalen);\n    }\n    \n    $self->_print(\"//\\n\") || return 0;\n    }\n    $self->flush() if $self->_flush_on_write && defined $self->_fh;\n    \n    return 1;\n}\n\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function: Set the alignment output line length\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\nsub line_length {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : $obj->alphabet('dna')\n Function: Set the sequence data alphabet\n Returns : sequence data type\n Args    : newvalue (optional)"},"detail":"($self,$value)","kind":12,"children":[{"containerName":"alphabet","definition":"my","name":"$self","localvar":"my","kind":13,"line":678},{"kind":13,"line":678,"name":"$value","containerName":"alphabet"},{"kind":13,"line":679,"containerName":"alphabet","name":"$value"},{"line":680,"kind":13,"containerName":"alphabet","name":"$self"},{"containerName":"alphabet","name":"throw","kind":12,"line":680},{"containerName":"alphabet","name":"$value","line":680,"kind":13},{"kind":13,"line":680,"containerName":"alphabet","name":"$value"},{"line":680,"kind":13,"name":"$value","containerName":"alphabet"},{"name":"$self","containerName":"alphabet","kind":13,"line":681},{"containerName":"alphabet","name":"$value","kind":13,"line":681},{"containerName":"alphabet","name":"$self","line":683,"kind":13}],"line":677},{"children":[{"kind":13,"line":698,"containerName":"spaces","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":699,"containerName":"spaces","name":"$self"},{"kind":13,"line":700,"name":"$self","containerName":"spaces"}],"line":697,"kind":12,"range":{"end":{"line":701,"character":9999},"start":{"line":697,"character":0}},"name":"spaces","definition":"sub","containerName":"main::"},{"name":"alignhandler","range":{"start":{"character":0,"line":713},"end":{"line":721,"character":9999}},"kind":12,"line":713,"children":[{"containerName":"alignhandler","definition":"my","name":"$self","localvar":"my","kind":13,"line":714},{"line":714,"kind":13,"containerName":"alignhandler","name":"$handler"},{"kind":13,"line":715,"containerName":"alignhandler","name":"$handler"},{"line":716,"kind":13,"containerName":"alignhandler","name":"$self"},{"name":"throw","containerName":"alignhandler","line":716,"kind":12},{"containerName":"alignhandler","name":"$handler","line":717,"kind":13},{"line":717,"kind":13,"containerName":"alignhandler","name":"$handler"},{"line":717,"kind":12,"containerName":"alignhandler","name":"isa"},{"name":"$self","containerName":"alignhandler","line":718,"kind":13},{"containerName":"alignhandler","name":"$handler","line":718,"kind":13},{"containerName":"alignhandler","name":"$self","line":720,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$handler)","signature":{"parameters":[{"label":"$self"},{"label":"$handler"}],"documentation":"1;\n# $Id: stockholm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::stockholm\n#\n#   Based on the Bio::SeqIO::stockholm module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Peter Schattner, Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# September 5, 2000\n# November 6, 2006 - completely refactor read_aln(), add write_aln()\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::stockholm - stockholm sequence input/output stream\n\n=head1 SYNOPSIS\n\n  # Do not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n  use Bio::AlignIO;\n  use strict;\n\n  my $in = Bio::AlignIO->new(-format => 'stockholm',\n                             -file   => 't/data/testaln.stockholm');\n  while( my $aln = $in->next_aln ) {\n\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::Align::AlignI> objects to and from\nstockholm flat file databases.  This has been completely refactored\nfrom the original stockholm parser to handle annotation data and now\nincludes a write_aln() method for (almost) complete stockholm\nformat output.\n\nStockholm alignment records normally contain additional sequence-based\nand alignment-based annotation\n\n  GF Lines (alignment feature/annotation):\n  #=GF <featurename> <Generic per-file annotation, free text>\n  Placed above the alignment\n\n  GC Lines (Alignment consensus)\n  #=GC <featurename> <Generic per-column annotation, exactly 1\n       character per column>\n  Placed below the alignment\n\n  GS Lines (Sequence annotations)\n  #=GS <seqname> <featurename> <Generic per-sequence annotation, free\n       text>\n\n  GR Lines (Sequence meta data)\n  #=GR <seqname> <featurename> <Generic per-sequence AND per-column\n       mark up, exactly 1 character per column>\n\nCurrently, sequence annotations (those designated with GS tags) are\nparsed only for accession numbers and descriptions.  It is intended that\nfull parsing will be added at some point in the near future along with\na builder option for optionally parsing alignment annotation and meta data.\n\nThe following methods/tags are currently used for storing and writing\nthe alignment annotation data.\n\n    Tag        SimpleAlign\n                 Method  \n    ----------------------------------------------------------------------\n     AC        accession  \n     ID        id  \n     DE        description\n    ----------------------------------------------------------------------\n\n    Tag        Bio::Annotation   TagName                    Parameters\n               Class\n    ----------------------------------------------------------------------\n     AU        SimpleValue       record_authors             value\n     SE        SimpleValue       seed_source                value\n     GA        SimpleValue       gathering_threshold        value\n     NC        SimpleValue       noise_cutoff               value\n     TC        SimpleValue       trusted_cutoff             value\n     TP        SimpleValue       entry_type                 value\n     SQ        SimpleValue       num_sequences              value\n     PI        SimpleValue       previous_ids               value\n     DC        Comment           database_comment           comment\n     CC        Comment           alignment_comment          comment\n     DR        Target            dblink                     database\n                                                            primary_id\n                                                            comment\n     AM        SimpleValue       build_method               value\n     NE        SimpleValue       pfam_family_accession      value\n     NL        SimpleValue       sequence_start_stop        value\n     SS        SimpleValue       sec_structure_source       value\n     BM        SimpleValue       build_model                value\n     RN        Reference         reference                  *\n     RC        Reference         reference                  comment\n     RM        Reference         reference                  pubmed\n     RT        Reference         reference                  title\n     RA        Reference         reference                  authors\n     RL        Reference         reference                  location\n    ----------------------------------------------------------------------\n  * RN is generated based on the number of Bio::Annotation::Reference objects\n\n=head2 Custom annotation\n\nSome users may want to add custom annotation beyond those mapped above.\nCurrently there are two methods to do so; however, the methods used for adding\nsuch annotation may change in the future, particularly if alignment Writer\nclasses are introduced. In particular, do not rely on changing the global\nvariables @WRITEORDER or %WRITEMAP as these may be made private at some point.\n\n1) Use (and abuse) the 'custom' tag.  The tagname for the object can differ\nfrom the tagname used to store the object in the AnnotationCollection.  \n\n    # AnnotationCollection from the SimpleAlign object\n    my $coll = $aln->annotation; \n    my $factory = Bio::Annotation::AnnotationFactory->new(-type => \n        Bio::Annotation::SimpleValue');\n    my $rfann = $factory->create_object(-value => $str, \n                                        -tagname => 'mytag');\n    $coll->add_Annotation('custom', $rfann);\n    $rfann = $factory->create_object(-value => 'foo',\n                                    -tagname => 'bar');\n    $coll->add_Annotation('custom', $rfann);\n\nOUTPUT:\n\n    # STOCKHOLM 1.0\n    \n    #=GF ID myID12345\n    #=GF mytag katnayygqelggvnhdyddlakfyfgaglealdffnnkeaaakiinwvaEDTTRGKIQDLV??\n    #=GF mytag TPtd~????LDPETQALLV???????????????????????NAIYFKGRWE?????????~??\n    #=GF mytag ??HEF?A?EMDTKPY??DFQH?TNen?????GRI??????V???KVAM??MF?????????N??\n    #=GF mytag ???DD?VFGYAEL????DE???????L??D??????A??TALELAY??????????????????\n    #=GF mytag ?????????????KG??????Sa???TSMLILLP???????????????D??????????????\n    #=GF mytag ???????????EGTr?????AGLGKLLQ??QL????????SREef??DLNK??L???AH????R\n    #=GF mytag ????????????L????????????????????????????????????????R?????????R\n    #=GF mytag ??QQ???????V???????AVRLPKFSFefefdlkeplknlgmhqafdpnsdvfklmdqavlvi\n    #=GF mytag gdlqhayafkvd????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ????????????????????????????????????????????????????????????????\n    #=GF mytag ?????????????INVDEAG?TEAAAATAAKFVPLSLppkt??????????????????PIEFV\n    #=GF mytag ADRPFAFAIR??????E?PAT?G????SILFIGHVEDPTP?msv?\n    #=GF bar foo\n    ...\n\n2) Modify the global @WRITEORDER and %WRITEMAP.\n\n    # AnnotationCollection from the SimpleAlign object\n    my $coll = $aln->annotation;\n    \n    # add to WRITEORDER\n    my @order = @Bio::AlignIO::stockholm::WRITEORDER;\n    push @order, 'my_stuff';\n    @Bio::AlignIO::stockholm::WRITEORDER = @order;\n    \n    # make sure new tag maps to something\n    $Bio::AlignIO::stockholm::WRITEMAP{my_stuff} = 'Hobbit/SimpleValue';\n\n    my $rfann = $factory->create_object(-value => 'Frodo',\n                                        -tagname => 'Hobbit');\n    $coll->add_Annotation('my_stuff', $rfann);\n    $rfann = $factory->create_object(-value => 'Bilbo',\n                                     -tagname => 'Hobbit');\n    $coll->add_Annotation('my_stuff', $rfann);\n\nOUTPUT:\n\n    # STOCKHOLM 1.0\n    \n    #=GF ID myID12345\n    #=GF Hobbit Frodo\n    #=GF Hobbit Bilbo\n    ....\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Chris Fields, Peter Schattner\n\nEmail: cjfields-at-uiuc-dot-edu, schattner@alum.mit.edu \n\n=head1 CONTRIBUTORS\n\nAndreas Kahari, ak-at-ebi.ac.uk\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::stockholm;\nuse strict;\n\nuse Bio::Seq::Meta;\nuse Bio::AlignIO::Handler::GenericAlignHandler;\nuse Text::Wrap qw(wrap);\n\nuse base qw(Bio::AlignIO);\n\nmy $STKVERSION = 'STOCKHOLM 1.0';\n\n# This maps the two-letter annotation key to a Annotation/parameter/tagname\n# combination.  Some data is stored using get/set methods ('Methods')  The rest \n# is mapped to Annotation objects using the parameter for the parsed data\n# and the tagname for, well, the Annotation tagname.  A few are treated differently\n# based on the type of data stored (Reference data in particular).\n\nmy %MAPPING = (\n    'AC'    =>  'ACCESSION',\n    'ID'    =>  'ID',\n    'DE'    =>  ['DESCRIPTION' => 'DESCRIPTION'],\n    'AU'    =>  ['RECORD_AUTHORS' => 'RECORD_AUTHORS'],\n    'SE'    =>  'SEED_SOURCE',\n    'BM'    =>  'BUILD_COMMAND',\n    'GA'    =>  'GATHERING_THRESHOLD',\n    'NC'    =>  'NOISE_CUTOFF',\n    'TC'    =>  'TRUSTED_CUTOFF',\n    'TP'    =>  'ENTRY_TYPE',\n    'SQ'    =>  'NUM_SEQUENCES',\n    'PI'    =>  'PREVIOUS_IDS',\n    'DC'    =>  ['DATABASE_COMMENT' => 'DATABASE_COMMENT'],\n    'DR'    =>  'DBLINK',\n    'RN'    =>  ['REFERENCE' => 'REFERENCE'],\n    'RC'    =>  ['REFERENCE' => 'COMMENT'],\n    'RM'    =>  ['REFERENCE' => 'PUBMED'],\n    'RT'    =>  ['REFERENCE' => 'TITLE'],\n    'RA'    =>  ['REFERENCE' => 'AUTHORS'],\n    'RL'    =>  ['REFERENCE' => 'JOURNAL'],\n    'CC'    =>  ['ALIGNMENT_COMMENT' => 'ALIGNMENT_COMMENT'],\n    #Pfam-specific \n    'AM'    =>  'BUILD_METHOD',\n    'NE'    =>  'PFAM_FAMILY_ACCESSION',\n    'NL'    =>  'SEQ_START_STOP',\n    # Rfam-specific GF lines\n    #'SS'    =>  'SEC_STRUCTURE_SOURCE',\n    'SEQUENCE' => 'SEQUENCE'\n);\n\n# this is the order that annotations are written\nour @WRITEORDER = qw(accession\n  id\n  description\n  previous_ids  \n  record_authors\n  seed_source\n  sec_structure_source\n  gathering_threshold\n  trusted_cutoff \n  noise_cutoff\n  entry_type\n  build_command\n  build_method\n  pfam_family_accession\n  seq_start_stop\n  reference\n  database_comment\n  custom\n  dblink\n  alignment_comment\n  num_sequences\n  seq_annotation\n  );\n\n# This maps the tagname back to a tagname-annotation value combination.\n# Some data is stored using get/set methods ('Methods'), others\n# are mapped b/c of more complex annotation types.\n\nour %WRITEMAP = (\n    'accession'             =>  'AC/Method',\n    'id'                    =>  'ID/Method',\n    'description'           =>  'DE/Method',\n    'record_authors'        =>  'AU/SimpleValue',\n    'seed_source'           =>  'SE/SimpleValue',\n    'build_command'         =>  'BM/SimpleValue',\n    'gathering_threshold'   =>  'GA/SimpleValue',\n    'noise_cutoff'          =>  'NC/SimpleValue',\n    'trusted_cutoff'        =>  'TC/SimpleValue',\n    'entry_type'            =>  'TP/SimpleValue',\n    'num_sequences'         =>  'SQ/SimpleValue',\n    'previous_ids'          =>  'PI/SimpleValue',\n    'database_comment'      =>  'DC/SimpleValue',\n    'dblink'                =>  'DR/DBLink',\n    'reference'             =>  'RX/Reference',\n    'ref_number'            =>  'RN/number',\n    'ref_comment'           =>  'RC/comment',\n    'ref_pubmed'            =>  'RM/pubmed',\n    'ref_title'             =>  'RT/title',\n    'ref_authors'           =>  'RA/authors',\n    'ref_location'          =>  'RL/location',\n    'alignment_comment'     =>  'CC/Comment',\n    'seq_annotation'        =>  'DR/Collection',\n    #Pfam-specific \n    'build_method'          =>  'AM/SimpleValue',\n    'pfam_family_accession' =>  'NE/SimpleValue',\n    'seq_start_stop'        =>  'NL/SimpleValue',\n    # Rfam-specific GF lines\n    'sec_structure_source'  =>  'SS/SimpleValue',\n    # custom; this is used to carry over anything from the input alignment\n    # not mapped to LocatableSeqs or SimpleAlign in a meaningful way\n    'custom'                =>  'XX/SimpleValue'\n);\n\n# This maps the tagname back to a tagname-annotation value combination.\n# Some data is stored using get/set methods ('Methods'), others\n# are mapped b/c of more complex annotation types.\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file');\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : -line_length :  length of the line for the alignment block\n           -alphabet    :  symbol alphabet to set the sequences to.  If not set,\n                           the parser will try to guess based on the alignment\n                           accession (if present), defaulting to 'dna'.\n           -spaces      :  (optional, def = 1) boolean to add a space in between\n                           the \"# STOCKHOLM 1.0\" header and the annotation and\n                           the annotation and the alignment.\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($handler, $linelength, $spaces) = $self->_rearrange([qw(HANDLER LINE_LENGTH SPACES)],@args);\n    $spaces = defined $spaces ? $spaces : 1;\n    $self->spaces($spaces);\n    # hash for functions for decoding keys.\n    $handler ? $self->alignhandler($handler) :\n    $self->alignhandler(Bio::AlignIO::Handler::GenericAlignHandler->new(\n                    -format => 'stockholm',\n                    -verbose => $self->verbose,\n                    ));\n    $linelength && $self->line_length($linelength);\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object\n Args    : NONE\n\n\nsub next_aln {\n    my $self = shift;\n    \n    my $handler = $self->alignhandler;\n    # advance to alignment header\n    while( defined(my $line = $self->_readline) ) {        \n        if ($line =~ m{^\\#\\s*STOCKHOLM\\s+}xmso) {\n            last;\n        }\n    }\n    \n    $self->{block_line} = 0;\n    # go into main body of alignment\n    my ($data_chunk, $isa_primary, $name, $alphabet);\n    my $last_feat = '';\n    while( defined(my $line = $self->_readline) ) {\n        # only blank lines are in between blocks, so reset block line\n        my ($primary_tag, $secondary_tag, $data, $nse, $feat, $align, $concat);\n        if ($line =~ m{^\\s*$}xmso) {\n            $self->{block_line} &&= 0;\n            next;\n        }\n        \n        # End of Record\n        if (index($line, '//') == 0) {\n            # fencepost\n            $handler->data_handler($data_chunk);\n            undef $data_chunk;\n            $handler->data_handler({ALIGNMENT => 1,\n                                    NAME => 'ALPHABET',\n                                    DATA => $self->alphabet})\n                if $self->alphabet;\n            last;\n        }\n        elsif ($line =~ m{^\\#=([A-Z]{2})\\s+([^\\n]+?)\\s*$}xmso) {\n            ($primary_tag, $data) = ($1, $2);\n            if ($primary_tag eq 'GS' || $primary_tag eq 'GR') {\n                ($nse, $feat, $data) = split(/\\s+/, $data, 3);\n            } else {\n                ($feat, $data) = split(/\\s+/, $data, 2);\n            }\n            $align = ($primary_tag eq 'GF' || $primary_tag eq 'GR') ? 1 : 0;\n        }\n        elsif ($line =~ m{^([^\\#]\\S+)\\s+([^\\s]+)\\s*}) {\n            $self->{block_line}++;\n            ($feat, $nse, $data) = ('SEQUENCE', $1, $2);\n        }\n        else {\n            $self->debug(\"Missed line : $line\\n\");\n        }\n        $primary_tag ||= ''; # when no #= line is present\n        $align ||= 0;\n\n        # array refs where the two values are equal indicate the start of a\n        # primary chunk of data, otherwise it is to be folded into the last\n        # data chunk under a secondary tag.  These are also concatenated\n        # to previous values if the \n\n        if (exists($MAPPING{$feat}) && ref $MAPPING{$feat} eq 'ARRAY') {\n            ($name, $secondary_tag, $isa_primary) = ( $MAPPING{$feat}->[0] eq $MAPPING{$feat}->[1] ) ?\n                ($MAPPING{$feat}->[0], 'DATA', 1) :\n                (@{ $MAPPING{$feat} }, 0) ;\n            $concat = $last_feat eq $feat ? 1 : 0;\n        } elsif (exists($MAPPING{$feat})) {\n            ($name, $secondary_tag, $isa_primary) = ($MAPPING{$feat}, 'DATA', 1);\n            # catch alphabet here if possible\n            if ($align && $name eq 'ACCESSION' && !$self->alphabet) {\n                if ($data =~ m{^(P|R)F}) {\n                    $self->alphabet($1 eq 'R' ? 'rna' : $1 eq 'P' ? 'protein' : undef );\n                }\n            }\n        } else {\n            $name = ($primary_tag eq 'GR') ? 'NAMED_META' :\n                    ($primary_tag eq 'GC') ? 'CONSENSUS_META' :\n                    'CUSTOM';\n            ($secondary_tag, $isa_primary) = ('DATA', 1);\n        }\n        \n        # Since we can't determine whether data should be passed into the\n        # Handler until the next round (due to concatenation and combining\n        # data), we always check for the presence of the last chunk when the\n        # occasion calls for it (i.e. when the current data string needs to go\n        # into a new data chunk). If the data needs to be concatenated it is\n        # flagged above and checked below (and passed by if the conditions\n        # warrant it).\n        \n        # We run into a bit of a fencepost problem, (one chunk left over at\n        # the end); that is taken care of above when the end of the record is\n        # found.\n        \n        if ($isa_primary && defined $data_chunk && !$concat) {\n            $handler->data_handler($data_chunk);\n            undef $data_chunk;\n        }\n        $data_chunk->{NAME} = $name;       # used for the handler\n        $data_chunk->{ALIGNMENT} = $align; # flag that determines chunk destination\n        $data_chunk->{$secondary_tag} .= (defined($data_chunk->{$secondary_tag})) ?\n            ' '.$data : $data;\n        $data_chunk->{NSE} = $nse if $nse;\n        if ($name eq 'SEQUENCE' || $name eq 'NAMED_META' || $name eq 'CONSENSUS_META') {\n            $data_chunk->{BLOCK_LINE} = $self->{block_line};\n            $data_chunk->{META_TAG} = $feat if ($name ne 'SEQUENCE');\n        }\n        $last_feat = $feat;\n    }\n    \n    my $aln = $handler->build_alignment;\n    $handler->reset_parameters;\n    return $aln;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in stockholm format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\n{\n    my %LINK_CB = (\n        'PDB' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id.' '.\n                                 ($_[0]->optional_id || ''),\n                                 $_[0]->start,\n                                 $_[0]->end)).';'},\n        'SCOP' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id || '',\n                                 $_[0]->optional_id)).';'},\n        '_DEFAULT_' => sub {join('; ',($_[0]->database,\n                                 $_[0]->primary_id)).';'},\n    );\n\nsub write_aln {\n    # enable array of SimpleAlign objects as well (see clustalw write_aln())\n    my ($self, @aln) = @_;\n    for my $aln (@aln) {\n    $self->throw('Need Bio::Align::AlignI object')\n          if (!$aln || !($aln->isa('Bio::Align::AlignI')));\n\n    my $coll = $aln->annotation;\n    my ($aln_ann, $seq_ann) =\n       ('#=GF ', '#=GS ');\n    $self->_print(\"# $STKVERSION\\n\") || return 0;\n    $self->spaces && $self->_print(\"\\n\");\n    # annotations first\n    \n    #=GF XX ....\n    for my $param (@WRITEORDER) {\n        my @anns;\n        # no point in going through this if there is no annotation!\n        last if !$coll;\n        # alignment annotations\n        my $ct = 1;\n        $self->throw(\"Bad parameter: $param\") if !exists $WRITEMAP{$param};\n        # get the data, act on it based on the tag\n        my ($tag, $key) = split q(/), $WRITEMAP{$param};\n        if ($key eq 'Method') {\n            push @anns, $aln->$param;\n        } else {\n            @anns = $coll->get_Annotations($param);\n        }\n        my $rn = 1;\n        ANNOTATIONS:\n        for my $ann (@anns) {\n            # using Text::Wrap::wrap() for word wrap\n            my ($text, $alntag, $data);\n            if ($tag eq 'RX') {\n                REFS:\n                for my $rkey (qw(ref_comment ref_number ref_pubmed\n                              ref_title ref_authors ref_location)) {\n                    my ($newtag, $method) = split q(/), $WRITEMAP{$rkey};\n                    $alntag = sprintf('%-10s',$aln_ann.$newtag);\n                    if ($rkey eq 'ref_number') {\n                        $data = \"[$rn]\";\n                    } else {\n                        $data = $ann->$method;\n                    }\n                    next REFS unless $data;\n                    $text = wrap($alntag, $alntag, $data);\n                    $self->_print(\"$text\\n\") or return 0;\n                }\n                $rn++;\n                next ANNOTATIONS;\n            }\n            elsif ($tag eq 'XX') { # custom\n                my $newtag = $ann->tagname;\n                my $tmp = $aln_ann.$newtag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = $ann->display_text;\n            }\n            elsif ($tag eq 'SQ') {\n                # use the actual number, not the stored Annotation data\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = $aln->num_sequences;\n            }\n            elsif ($tag eq 'DR') {\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                my $db = uc $ann->database;\n                my $cb = exists $LINK_CB{$db} ? $LINK_CB{$db} : $LINK_CB{_DEFAULT_};\n                $data = $ann->display_text($cb);\n            }\n            else {\n                my $tmp = $aln_ann.$tag;\n                $alntag = sprintf('%-*s',length($tmp) + 1, $tmp);\n                $data = ref $ann ? $ann->display_text : $ann;\n            }\n            next unless $data;\n            $text = wrap($alntag, $alntag, $data);\n            $self->_print(\"$text\\n\") || return 0;\n        }\n    }\n    \n    #=GS <seq-id> AC xxxxxx\n    my $tag = 'AC';\n    for my $seq ($aln->each_seq) {\n        if (my $acc = $seq->accession_number) {\n        my $text = sprintf(\"%-4s%-22s%-3s%s\\n\",$seq_ann, $seq->get_nse, $tag, $acc);\n        $self->_print($text) || return 0;\n        }\n    }\n    \n    #=GS <seq-id> DR xxxxxx\n    $tag = 'DR';\n    for my $sf ($aln->get_SeqFeatures) {\n        if (my @links = $sf->annotation->get_Annotations('dblink')) {\n            for my $link (@links) {\n                my $db = uc $link->database;\n                my $cb = exists $LINK_CB{$db} ? $LINK_CB{$db} : $LINK_CB{_DEFAULT_};\n                my $text = sprintf(\"%-4s%-22s%-3s%s\\n\",$seq_ann,\n                                   $sf->entire_seq->get_nse,\n                                   $tag,\n                                   $link->display_text($cb));\n                $self->_print($text) || return 0;\n            }\n        }\n    }    \n    \n    $self->spaces && $self->_print(\"\\n\");    \n    # now the sequences...\n    \n    my $blocklen = $self->line_length;\n    my $maxlen = $aln->maxdisplayname_length() + 3;\n    my $metalen = $aln->max_metaname_length() || 0;\n    if ($blocklen) {\n        my $blockstart = 1;\n        my $alnlen = $aln->length;\n        while ($blockstart < $alnlen) {\n            my $subaln = $aln->slice($blockstart, $blockstart+$blocklen-1 ,1);\n            $self->_print_seqs($subaln,$maxlen,$metalen);\n            $blockstart += $blocklen;\n            $self->_print(\"\\n\") unless $blockstart >= $alnlen;\n        }\n    } else {\n        $self->_print_seqs($aln,$maxlen,$metalen);\n    }\n    \n    $self->_print(\"//\\n\") || return 0;\n    }\n    $self->flush() if $self->_flush_on_write && defined $self->_fh;\n    \n    return 1;\n}\n\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function: Set the alignment output line length\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\nsub line_length {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'};\n}\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : $obj->alphabet('dna')\n Function: Set the sequence data alphabet\n Returns : sequence data type\n Args    : newvalue (optional)\n\n\nsub alphabet {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->throw(\"Invalid alphabet $value\") unless $value eq 'rna' || $value eq 'protein' || $value eq 'dna';\n        $self->{'_alphabet'} = $value;\n    }\n    return $self->{'_alphabet'};\n};\n\n=head2 spaces\n\n Title   : spaces\n Usage   : $obj->spaces(1)\n Function: Set the 'spaces' flag, which prints extra newlines between the\n           header and the annotation and the annotation and the alignment\n Returns : sequence data type\n Args    : newvalue (optional)\n\n\nsub spaces {\n    my $self = shift;\n    return $self->{'_spaces'} = shift if @_;\n    return $self->{'_spaces'};\n};\n\n=head2 alignhandler\n\n Title   : alignhandler\n Usage   : $stream->alignhandler($handler)\n Function: Get/Set the Bio::HandlerBaseI object\n Returns : Bio::HandlerBaseI \n Args    : Bio::HandlerBaseI ","label":"alignhandler($self,$handler)"}},{"name":"_print_seqs","range":{"end":{"character":9999,"line":758},"start":{"line":725,"character":0}},"kind":12,"line":725,"children":[{"containerName":"_print_seqs","definition":"my","name":"$self","localvar":"my","kind":13,"line":726},{"line":726,"kind":13,"containerName":"_print_seqs","name":"$aln"},{"kind":13,"line":726,"containerName":"_print_seqs","name":"$maxlen"},{"containerName":"_print_seqs","name":"$metalen","line":726,"kind":13},{"kind":13,"line":728,"name":"$seq_meta","definition":"my","containerName":"_print_seqs","localvar":"my"},{"name":"$aln_meta","containerName":"_print_seqs","line":728,"kind":13},{"localvar":"my","name":"$namestr","definition":"my","containerName":"_print_seqs","line":731,"kind":13},{"name":"$seq","containerName":"_print_seqs","kind":13,"line":731},{"containerName":"_print_seqs","name":"$add","line":731,"kind":13},{"containerName":"_print_seqs","name":"$seq","line":735,"kind":13},{"kind":13,"line":735,"containerName":"_print_seqs","name":"$aln"},{"containerName":"_print_seqs","name":"each_seq","kind":12,"line":735},{"name":"$s","definition":"my","containerName":"_print_seqs","localvar":"my","kind":13,"line":736},{"name":"$e","containerName":"_print_seqs","line":736,"kind":13},{"containerName":"_print_seqs","name":"$str","line":736,"kind":13},{"line":736,"kind":13,"containerName":"_print_seqs","name":"$seq"},{"containerName":"_print_seqs","name":"start","line":736,"kind":12},{"containerName":"_print_seqs","name":"$seq","kind":13,"line":736},{"containerName":"_print_seqs","name":"end","kind":12,"line":736},{"kind":13,"line":736,"containerName":"_print_seqs","name":"$seq"},{"containerName":"_print_seqs","name":"strand","kind":12,"line":736},{"name":"$namestr","containerName":"_print_seqs","kind":13,"line":737},{"name":"$seq","containerName":"_print_seqs","line":737,"kind":13},{"containerName":"_print_seqs","name":"get_nse","line":737,"kind":12},{"line":738,"kind":13,"name":"$self","containerName":"_print_seqs"},{"containerName":"_print_seqs","name":"_print","kind":12,"line":738},{"kind":13,"line":738,"name":"$maxlen","containerName":"_print_seqs"},{"name":"$metalen","containerName":"_print_seqs","kind":13,"line":738},{"containerName":"_print_seqs","name":"$namestr","kind":13,"line":739},{"containerName":"_print_seqs","name":"$seq","kind":13,"line":740},{"line":740,"kind":12,"name":"seq","containerName":"_print_seqs"},{"name":"$seq","containerName":"_print_seqs","kind":13,"line":741},{"containerName":"_print_seqs","name":"isa","kind":12,"line":741},{"localvar":"my","containerName":"_print_seqs","name":"$mname","definition":"my","line":742,"kind":13},{"name":"$seq","containerName":"_print_seqs","kind":13,"line":742},{"line":742,"kind":12,"name":"meta_names","containerName":"_print_seqs"},{"name":"$self","containerName":"_print_seqs","kind":13,"line":743},{"kind":12,"line":743,"containerName":"_print_seqs","name":"_print"},{"name":"$maxlen","containerName":"_print_seqs","line":743,"kind":13},{"containerName":"_print_seqs","name":"$metalen","line":743,"kind":13},{"containerName":"_print_seqs","name":"$seq_meta","line":744,"kind":13},{"containerName":"_print_seqs","name":"$namestr","kind":13,"line":744},{"containerName":"_print_seqs","name":"$mname","line":744,"kind":13},{"containerName":"_print_seqs","name":"$seq","line":745,"kind":13},{"name":"named_meta","containerName":"_print_seqs","line":745,"kind":12},{"containerName":"_print_seqs","name":"$mname","line":745,"kind":13},{"kind":13,"line":750,"definition":"my","name":"$ameta","containerName":"_print_seqs","localvar":"my"},{"name":"$aln","containerName":"_print_seqs","kind":13,"line":750},{"line":750,"kind":12,"containerName":"_print_seqs","name":"consensus_meta"},{"line":751,"kind":13,"containerName":"_print_seqs","name":"$ameta"},{"kind":13,"line":752,"containerName":"_print_seqs","definition":"my","name":"$mname","localvar":"my"},{"containerName":"_print_seqs","name":"$ameta","line":752,"kind":13},{"containerName":"_print_seqs","name":"meta_names","kind":12,"line":752},{"line":753,"kind":13,"name":"$self","containerName":"_print_seqs"},{"kind":12,"line":753,"containerName":"_print_seqs","name":"_print"},{"kind":13,"line":753,"containerName":"_print_seqs","name":"$maxlen"},{"name":"$metalen","containerName":"_print_seqs","line":753,"kind":13},{"name":"$aln_meta","containerName":"_print_seqs","line":754,"kind":13},{"kind":13,"line":754,"containerName":"_print_seqs","name":"$mname"},{"kind":13,"line":755,"containerName":"_print_seqs","name":"$ameta"},{"containerName":"_print_seqs","name":"named_meta","line":755,"kind":12},{"name":"$mname","containerName":"_print_seqs","kind":13,"line":755}],"containerName":"main::","definition":"sub","detail":"($self,$aln,$maxlen,$metalen)","signature":{"label":"_print_seqs($self,$aln,$maxlen,$metalen)","documentation":"############ PRIVATE INIT/HANDLER METHODS #############","parameters":[{"label":"$self"},{"label":"$aln"},{"label":"$maxlen"},{"label":"$metalen"}]}}],"version":5}