{"version":5,"vars":[{"name":"vars","containerName":"","line":72,"kind":2},{"name":"$BlockLen","containerName":null,"line":75,"kind":13},{"kind":2,"line":75,"name":"strict","containerName":""},{"name":"$IdLength","containerName":null,"line":76,"kind":13},{"containerName":"","name":"base","kind":2,"line":83},{"name":"next_aln","range":{"end":{"line":132,"character":9999},"start":{"line":107,"character":0}},"kind":12,"children":[{"line":108,"kind":13,"localvar":"my","containerName":"next_aln","definition":"my","name":"$self"},{"localvar":"my","containerName":"next_aln","name":"$aln","definition":"my","line":109,"kind":13},{"kind":13,"line":110,"containerName":"next_aln","name":"%seqs","definition":"my","localvar":"my"},{"kind":13,"line":111,"containerName":"next_aln","definition":"my","name":"@order","localvar":"my"},{"containerName":"next_aln","name":"$self","line":112,"kind":13},{"kind":12,"line":112,"containerName":"next_aln","name":"_readline"},{"line":114,"kind":13,"containerName":"next_aln","name":"$aln"},{"kind":13,"line":115,"name":"$aln","containerName":"next_aln"},{"kind":12,"line":115,"containerName":"next_aln","name":"new"},{"localvar":"my","containerName":"next_aln","name":"$id","definition":"my","line":117,"kind":13},{"line":117,"kind":13,"name":"$s","containerName":"next_aln"},{"line":118,"kind":13,"name":"@order","containerName":"next_aln"},{"containerName":"next_aln","name":"$id","line":118,"kind":13},{"name":"$seqs","containerName":"next_aln","kind":13,"line":118},{"line":118,"kind":13,"containerName":"next_aln","name":"$id"},{"containerName":"next_aln","name":"$seqs","line":119,"kind":13},{"name":"$id","containerName":"next_aln","kind":13,"line":119},{"line":119,"kind":13,"containerName":"next_aln","name":"$s"},{"kind":13,"line":121,"name":"$id","definition":"my","containerName":"next_aln","localvar":"my"},{"name":"@order","containerName":"next_aln","line":121,"kind":13},{"localvar":"my","name":"$gaps","definition":"my","containerName":"next_aln","line":122,"kind":13},{"name":"$seqs","containerName":"next_aln","kind":13,"line":122},{"kind":13,"line":122,"containerName":"next_aln","name":"$id"},{"localvar":"my","containerName":"next_aln","name":"$seq","definition":"my","line":123,"kind":13},{"kind":12,"line":123,"name":"new","containerName":"next_aln"},{"name":"$seqs","containerName":"next_aln","line":123,"kind":13},{"name":"$id","containerName":"next_aln","kind":13,"line":123},{"kind":13,"line":124,"name":"$id","containerName":"next_aln"},{"kind":13,"line":126,"name":"$seqs","containerName":"next_aln"},{"line":126,"kind":13,"containerName":"next_aln","name":"$id"},{"containerName":"next_aln","name":"$gaps","line":127,"kind":13},{"name":"$aln","containerName":"next_aln","kind":13,"line":128},{"containerName":"next_aln","name":"add_seq","line":128,"kind":12},{"name":"$seq","containerName":"next_aln","line":128,"kind":13},{"name":"$aln","containerName":"next_aln","line":130,"kind":13},{"kind":13,"line":130,"name":"$aln","containerName":"next_aln"},{"kind":13,"line":130,"containerName":"next_aln","name":"$aln"},{"containerName":"next_aln","name":"num_sequences","kind":12,"line":130},{"name":"$aln","containerName":"next_aln","line":131,"kind":13}],"line":107,"definition":"sub","containerName":"main::","signature":{"label":"next_aln($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: psi.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::psi\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::psi - Read/Write PSI-BLAST profile alignment files\n\n=head1 SYNOPSIS\n\nThis module will parse PSI-BLAST output of the format seqid XXXX  \n\n=head1 DESCRIPTION\n\nThis is a parser for psi-blast blocks.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::psi;\nuse vars qw($BlockLen $IdLength);\nuse strict;\n\n$BlockLen = 100; \n$IdLength = 13;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\n\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::AlignIO::psi->new();\n Function: Builds a new Bio::AlignIO::psi object \n Returns : Bio::AlignIO::psi\n Args    :\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI>"},"detail":"($self)"},{"kind":12,"line":115,"name":"Bio","containerName":"SimpleAlign"},{"containerName":"LocatableSeq","name":"Bio","line":123,"kind":12},{"range":{"start":{"line":146,"character":0},"end":{"line":174,"character":9999}},"name":"write_aln","signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: psi.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::psi\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::psi - Read/Write PSI-BLAST profile alignment files\n\n=head1 SYNOPSIS\n\nThis module will parse PSI-BLAST output of the format seqid XXXX  \n\n=head1 DESCRIPTION\n\nThis is a parser for psi-blast blocks.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::psi;\nuse vars qw($BlockLen $IdLength);\nuse strict;\n\n$BlockLen = 100; \n$IdLength = 13;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\n\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::AlignIO::psi->new();\n Function: Builds a new Bio::AlignIO::psi object \n Returns : Bio::AlignIO::psi\n Args    :\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI>\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $aln;\n    my %seqs;\n    my @order;\n    while( defined ($_ = $self->_readline ) ) {\n\tnext if( /^\\s+$/);\n\tif( !defined $aln ) {\n\t    $aln = Bio::SimpleAlign->new();\n\t}\n\tmy ($id,$s) = split;\n\tpush @order, $id if( ! defined $seqs{$id});\n\t$seqs{$id} .= $s;\n    }\n    foreach my $id ( @order) {\n    my $gaps = $seqs{$id} =~ tr/-/-/;\n\tmy $seq = Bio::LocatableSeq->new(-seq => $seqs{$id},\n\t\t\t\t\t-id  => $id,\n\t\t\t\t\t-start => 1,\n\t\t\t\t\t-end   => length($seqs{$id}) - $gaps\n                    );\n\t$aln->add_seq($seq);\n    }\n    return $aln if defined $aln && $aln->num_sequences;\n\treturn $aln;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the NCBI psi-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\nL<Bio::Align::AlignI>","label":"write_aln($self,$aln)"},"detail":"($self,$aln)","definition":"sub","containerName":"main::","children":[{"line":147,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"write_aln"},{"line":147,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":148,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"$aln","kind":13,"line":148},{"line":149,"kind":13,"containerName":"write_aln","name":"$aln"},{"kind":12,"line":149,"name":"isa","containerName":"write_aln"},{"name":"$self","containerName":"write_aln","kind":13,"line":150},{"kind":12,"line":150,"containerName":"write_aln","name":"warn"},{"line":153,"kind":13,"localvar":"my","containerName":"write_aln","name":"$ct","definition":"my"},{"name":"@seqs","definition":"my","containerName":"write_aln","localvar":"my","kind":13,"line":154},{"containerName":"write_aln","name":"$aln","line":154,"kind":13},{"line":154,"kind":12,"containerName":"write_aln","name":"each_seq"},{"kind":13,"line":155,"containerName":"write_aln","name":"$len","definition":"my","localvar":"my"},{"localvar":"my","containerName":"write_aln","definition":"my","name":"$alnlen","line":156,"kind":13},{"line":156,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"length","kind":12,"line":156},{"localvar":"my","containerName":"write_aln","definition":"my","name":"$idlen","line":157,"kind":13},{"line":157,"kind":13,"name":"$IdLength","containerName":"write_aln"},{"containerName":"write_aln","definition":"my","name":"@ids","localvar":"my","kind":13,"line":158},{"name":"display_id","containerName":"write_aln","line":158,"kind":12},{"kind":13,"line":158,"containerName":"write_aln","name":"$idlen"},{"containerName":"write_aln","name":"@seqs","kind":13,"line":158},{"kind":13,"line":159,"containerName":"write_aln","name":"$len"},{"name":"$alnlen","containerName":"write_aln","kind":13,"line":159},{"line":160,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$start"},{"kind":13,"line":160,"name":"$len","containerName":"write_aln"},{"localvar":"my","containerName":"write_aln","definition":"my","name":"$end","line":161,"kind":13},{"name":"$len","containerName":"write_aln","kind":13,"line":161},{"kind":13,"line":161,"name":"$BlockLen","containerName":"write_aln"},{"line":162,"kind":13,"containerName":"write_aln","name":"$end"},{"line":162,"kind":13,"containerName":"write_aln","name":"$alnlen"},{"containerName":"write_aln","name":"$end","line":162,"kind":13},{"line":162,"kind":13,"containerName":"write_aln","name":"$alnlen"},{"line":163,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$c"},{"localvar":"my","definition":"my","name":"$seq","containerName":"write_aln","line":164,"kind":13},{"line":164,"kind":13,"containerName":"write_aln","name":"@seqs"},{"kind":13,"line":165,"name":"$self","containerName":"write_aln"},{"containerName":"write_aln","name":"_print","kind":12,"line":165},{"containerName":"write_aln","name":"$idlen","kind":13,"line":165},{"line":166,"kind":13,"containerName":"write_aln","name":"$ids"},{"containerName":"write_aln","name":"$c","kind":13,"line":166},{"containerName":"write_aln","name":"$seq","line":167,"kind":13},{"kind":12,"line":167,"containerName":"write_aln","name":"subseq"},{"name":"$start","containerName":"write_aln","kind":13,"line":167},{"name":"$end","containerName":"write_aln","kind":13,"line":167},{"kind":13,"line":169,"name":"$self","containerName":"write_aln"},{"containerName":"write_aln","name":"_print","kind":12,"line":169},{"kind":13,"line":170,"name":"$len","containerName":"write_aln"},{"kind":13,"line":170,"name":"$BlockLen","containerName":"write_aln"},{"containerName":"write_aln","name":"$self","kind":13,"line":172},{"name":"flush","containerName":"write_aln","line":172,"kind":12},{"containerName":"write_aln","name":"$self","line":172,"kind":13},{"containerName":"write_aln","name":"_flush_on_write","line":172,"kind":12},{"containerName":"write_aln","name":"$self","line":172,"kind":13},{"line":172,"kind":12,"name":"_fh","containerName":"write_aln"}],"line":146,"kind":12}]}