{"vars":[{"containerName":"","name":"base","line":77,"kind":2},{"range":{"end":{"line":88,"character":9999},"start":{"character":0,"line":80}},"name":"_initialize","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":81,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"line":81,"kind":13,"name":"@args","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":82,"kind":13},{"kind":13,"line":82,"containerName":"_initialize","name":"@args"},{"line":83,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"sequence_factory","containerName":"_initialize","line":83,"kind":12},{"line":84,"kind":13,"name":"$self","containerName":"_initialize"},{"line":84,"kind":12,"name":"sequence_factory","containerName":"_initialize"},{"containerName":"_initialize","name":"new","kind":12,"line":85},{"kind":13,"line":85,"containerName":"_initialize","name":"$self"},{"kind":12,"line":85,"containerName":"_initialize","name":"verbose"}],"line":80,"kind":12},{"containerName":"_initialize","name":"SUPER","kind":12,"line":82},{"containerName":"Seq::SeqFactory","name":"Bio","kind":12,"line":84},{"range":{"start":{"character":0,"line":101},"end":{"line":128,"character":9999}},"name":"next_seq","signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n#\n# BioPerl module for Bio::AlignIO::largemultifasta\n\n#   based on the Bio::SeqIO::largefasta module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# January 20, 2004\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::largemultifasta - Largemultifasta MSA Sequence\ninput/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects to and from\nlargemultifasta flat file databases.  This is for the fasta sequence\nformat NOT FastA analysis program.  To process the pairwise alignments\nfrom a FastA (FastX, FastN, FastP, tFastA, etc) use the Bio::SearchIO\nmodule.\n\nReimplementation of Bio::AlignIO::fasta modules so that creates\ntemporary files instead of keeping the whole sequences in memory.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella, Heikki Lehvaslaiho\n\nEmail: avilella-at-gmail-dot-com, heikki-at-bioperl-dot-org\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::largemultifasta;\nuse strict;\n\nuse Bio::Seq::LargeLocatableSeq;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::AlignIO Bio::SeqIO Bio::SimpleAlign);\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::LargeLocatableSeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream while taking care\n           of the length\n Returns : Bio::Seq object\n Args    : NONE"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"next_seq","localvar":"my","kind":13,"line":102},{"containerName":"next_seq","name":"$largeseq","definition":"my","localvar":"my","kind":13,"line":103},{"kind":13,"line":103,"name":"$self","containerName":"next_seq"},{"containerName":"next_seq","name":"sequence_factory","line":103,"kind":12},{"line":103,"kind":12,"containerName":"next_seq","name":"create"},{"name":"$id","definition":"my","containerName":"next_seq","localvar":"my","kind":13,"line":104},{"name":"$fulldesc","containerName":"next_seq","kind":13,"line":104},{"name":"$entry","containerName":"next_seq","line":104,"kind":13},{"localvar":"my","name":"$count","definition":"my","containerName":"next_seq","line":105,"kind":13},{"localvar":"my","name":"$seen","definition":"my","containerName":"next_seq","line":106,"kind":13},{"containerName":"next_seq","name":"$entry","kind":13,"line":107},{"line":107,"kind":13,"name":"$self","containerName":"next_seq"},{"kind":12,"line":107,"name":"_readline","containerName":"next_seq"},{"containerName":"next_seq","name":"$seen","line":108,"kind":13},{"kind":13,"line":108,"name":"$entry","containerName":"next_seq"},{"name":"$self","containerName":"next_seq","line":109,"kind":13},{"containerName":"next_seq","name":"_pushback","line":109,"kind":12},{"name":"$entry","containerName":"next_seq","kind":13,"line":109},{"containerName":"next_seq","name":"$largeseq","line":110,"kind":13},{"kind":13,"line":112,"containerName":"next_seq","name":"$entry"},{"kind":13,"line":112,"name":"$seen","containerName":"next_seq"},{"containerName":"next_seq","name":"$entry","line":113,"kind":13},{"name":"$seen","containerName":"next_seq","kind":13,"line":114},{"name":"$id","containerName":"next_seq","line":115,"kind":13},{"containerName":"next_seq","name":"$fulldesc","line":115,"kind":13},{"kind":13,"line":116,"containerName":"next_seq","name":"$self"},{"name":"warn","containerName":"next_seq","line":116,"kind":12},{"line":117,"kind":13,"containerName":"next_seq","name":"$largeseq"},{"containerName":"next_seq","name":"display_id","kind":12,"line":117},{"name":"$id","containerName":"next_seq","line":117,"kind":13},{"kind":13,"line":118,"containerName":"next_seq","name":"$largeseq"},{"name":"primary_id","containerName":"next_seq","kind":12,"line":118},{"containerName":"next_seq","name":"$id","line":118,"kind":13},{"name":"$largeseq","containerName":"next_seq","kind":13,"line":119},{"name":"desc","containerName":"next_seq","kind":12,"line":119},{"line":119,"kind":13,"name":"$fulldesc","containerName":"next_seq"},{"name":"$entry","containerName":"next_seq","line":121,"kind":13},{"name":"$largeseq","containerName":"next_seq","kind":13,"line":122},{"line":122,"kind":12,"name":"add_sequence_as_string","containerName":"next_seq"},{"containerName":"next_seq","name":"$entry","line":122,"kind":13},{"containerName":"next_seq","name":"$count","line":124,"kind":13},{"name":"$self","containerName":"next_seq","kind":13,"line":124},{"name":"verbose","containerName":"next_seq","kind":12,"line":124},{"name":"$seen","containerName":"next_seq","line":126,"kind":13},{"line":127,"kind":13,"name":"$largeseq","containerName":"next_seq"}],"line":101,"kind":12},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_aln","line":143,"kind":13},{"localvar":"my","containerName":"next_aln","definition":"my","name":"$largeseq","line":144,"kind":13},{"line":145,"kind":13,"localvar":"my","name":"$aln","definition":"my","containerName":"next_aln"},{"kind":12,"line":145,"name":"new","containerName":"next_aln"},{"containerName":"next_aln","name":"$largeseq","kind":13,"line":146},{"line":146,"kind":13,"containerName":"next_aln","name":"$self"},{"name":"next_seq","containerName":"next_aln","line":146,"kind":12},{"kind":13,"line":147,"name":"$aln","containerName":"next_aln"},{"name":"add_seq","containerName":"next_aln","line":147,"kind":12},{"kind":13,"line":147,"containerName":"next_aln","name":"$largeseq"},{"containerName":"next_aln","name":"$self","kind":13,"line":148},{"containerName":"next_aln","name":"debug","line":148,"kind":12},{"kind":13,"line":151,"name":"$alnlen","definition":"my","containerName":"next_aln","localvar":"my"},{"name":"$aln","containerName":"next_aln","kind":13,"line":151},{"name":"length","containerName":"next_aln","line":151,"kind":12},{"kind":13,"line":152,"definition":"my","name":"$largeseq","containerName":"next_aln","localvar":"my"},{"containerName":"next_aln","name":"$aln","kind":13,"line":152},{"name":"each_seq","containerName":"next_aln","kind":12,"line":152},{"containerName":"next_aln","name":"$largeseq","kind":13,"line":153},{"kind":12,"line":153,"name":"length","containerName":"next_aln"},{"line":153,"kind":13,"containerName":"next_aln","name":"$alnlen"},{"line":154,"kind":13,"localvar":"my","definition":"my","name":"$diff","containerName":"next_aln"},{"line":154,"kind":13,"name":"$alnlen","containerName":"next_aln"},{"line":154,"kind":13,"containerName":"next_aln","name":"$largeseq"},{"name":"length","containerName":"next_aln","kind":12,"line":154},{"kind":13,"line":155,"containerName":"next_aln","name":"$largeseq"},{"kind":12,"line":155,"name":"seq","containerName":"next_aln"},{"containerName":"next_aln","name":"$diff","kind":13,"line":155},{"kind":13,"line":159,"containerName":"next_aln","name":"$aln"},{"containerName":"next_aln","name":"$aln","kind":13,"line":159},{"kind":12,"line":159,"name":"num_sequences","containerName":"next_aln"}],"line":142,"definition":"sub","name":"next_aln","containerName":"main::","range":{"start":{"character":0,"line":142},"end":{"character":9999,"line":162}}},{"containerName":"SimpleAlign","name":"Bio","line":145,"kind":12},{"name":"write_aln","range":{"start":{"line":175,"character":0},"end":{"line":200,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@aln)","signature":{"label":"write_aln($self,@aln)","parameters":[{"label":"$self"},{"label":"@aln"}],"documentation":"1;\n#\n# BioPerl module for Bio::AlignIO::largemultifasta\n\n#   based on the Bio::SeqIO::largefasta module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# January 20, 2004\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::largemultifasta - Largemultifasta MSA Sequence\ninput/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform L<Bio::SimpleAlign> objects to and from\nlargemultifasta flat file databases.  This is for the fasta sequence\nformat NOT FastA analysis program.  To process the pairwise alignments\nfrom a FastA (FastX, FastN, FastP, tFastA, etc) use the Bio::SearchIO\nmodule.\n\nReimplementation of Bio::AlignIO::fasta modules so that creates\ntemporary files instead of keeping the whole sequences in memory.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Albert Vilella, Heikki Lehvaslaiho\n\nEmail: avilella-at-gmail-dot-com, heikki-at-bioperl-dot-org\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::largemultifasta;\nuse strict;\n\nuse Bio::Seq::LargeLocatableSeq;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::AlignIO Bio::SeqIO Bio::SimpleAlign);\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::LargeLocatableSeq'));\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream while taking care\n           of the length\n Returns : Bio::Seq object\n Args    : NONE\n\n\nsub next_seq {\n    my ($self) = @_;\n    my $largeseq = $self->sequence_factory->create();\n    my ($id,$fulldesc,$entry);\n    my $count = 0;\n    my $seen = 0;\n    while( defined ($entry = $self->_readline) ) {\n\tif( $seen == 1 && $entry =~ /^\\s*>/ ) {\n\t    $self->_pushback($entry);\n\t    return $largeseq;\n\t}\n\tif ( ($entry eq '>')  ) { $seen = 1; next; }\n\telsif( $entry =~ /\\s*>(.+?)$/ ) {\n\t    $seen = 1;\n\t    ($id,$fulldesc) = ($1 =~ /^\\s*(\\S+)\\s*(.*)$/)\n\t\tor $self->warn(\"Can't parse fasta header\");\n\t    $largeseq->display_id($id);\n\t    $largeseq->primary_id($id);\n\t    $largeseq->desc($fulldesc);\n\t} else {\n\t    $entry =~ s/\\s+//g;\n\t    $largeseq->add_sequence_as_string($entry);\n\t}\n\t(++$count % 1000 == 0 && $self->verbose() > 0) && print \"line $count\\n\";\n    }\n    if( ! $seen ) { return; }\n    return $largeseq;\n}\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE\n\n\nsub next_aln {\n    my $self = shift;\n    my $largeseq;\n    my $aln =  Bio::SimpleAlign->new();\n    while (defined ($largeseq = $self->next_seq) ) {\n        $aln->add_seq($largeseq);\n        $self->debug(\"sequence readed\\n\");\n    }\n\n    my $alnlen = $aln->length;\n    foreach my $largeseq ( $aln->each_seq ) {\n\tif( $largeseq->length < $alnlen ) {\n\t    my ($diff) = ($alnlen - $largeseq->length);\n\t    $largeseq->seq(\"-\" x $diff);\n\t}\n    }\n\n    return $aln if $aln->num_sequences;\n\treturn;\n\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in largemultifasta format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object"},"kind":12,"line":175,"children":[{"line":176,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$self"},{"line":176,"kind":13,"name":"@aln","containerName":"write_aln"},{"containerName":"write_aln","name":"$seq","definition":"my","localvar":"my","kind":13,"line":177},{"line":177,"kind":13,"containerName":"write_aln","name":"$desc"},{"line":177,"kind":13,"containerName":"write_aln","name":"$rseq"},{"name":"$name","containerName":"write_aln","line":177,"kind":13},{"containerName":"write_aln","name":"$count","kind":13,"line":177},{"kind":13,"line":177,"containerName":"write_aln","name":"$length"},{"kind":13,"line":177,"containerName":"write_aln","name":"$seqsub"},{"line":179,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$aln"},{"name":"@aln","containerName":"write_aln","line":179,"kind":13},{"name":"$aln","containerName":"write_aln","line":180,"kind":13},{"containerName":"write_aln","name":"$aln","kind":13,"line":180},{"kind":12,"line":180,"containerName":"write_aln","name":"isa"},{"kind":13,"line":181,"name":"$self","containerName":"write_aln"},{"kind":12,"line":181,"containerName":"write_aln","name":"warn"},{"line":184,"kind":13,"name":"$rseq","containerName":"write_aln"},{"name":"$aln","containerName":"write_aln","kind":13,"line":184},{"containerName":"write_aln","name":"each_seq","line":184,"kind":12},{"containerName":"write_aln","name":"$name","line":185,"kind":13},{"line":185,"kind":13,"containerName":"write_aln","name":"$aln"},{"kind":12,"line":185,"containerName":"write_aln","name":"displayname"},{"containerName":"write_aln","name":"$rseq","line":185,"kind":13},{"name":"get_nse","containerName":"write_aln","line":185,"kind":12},{"containerName":"write_aln","name":"$seq","kind":13,"line":186},{"name":"$rseq","containerName":"write_aln","line":186,"kind":13},{"kind":12,"line":186,"name":"seq","containerName":"write_aln"},{"containerName":"write_aln","name":"$desc","kind":13,"line":187},{"containerName":"write_aln","name":"$rseq","line":187,"kind":13},{"kind":12,"line":187,"containerName":"write_aln","name":"description"},{"kind":13,"line":188,"name":"$self","containerName":"write_aln"},{"name":"_print","containerName":"write_aln","line":188,"kind":12},{"containerName":"write_aln","name":"$count","kind":13,"line":189},{"line":190,"kind":13,"containerName":"write_aln","name":"$length"},{"name":"$seq","containerName":"write_aln","line":190,"kind":13},{"containerName":"write_aln","name":"$count","line":191,"kind":13},{"containerName":"write_aln","name":"$length","kind":13,"line":191},{"containerName":"write_aln","name":"$seqsub","kind":13,"line":192},{"line":192,"kind":13,"name":"$seq","containerName":"write_aln"},{"kind":13,"line":192,"containerName":"write_aln","name":"$count"},{"kind":13,"line":193,"name":"$self","containerName":"write_aln"},{"line":193,"kind":12,"name":"_print","containerName":"write_aln"},{"name":"$count","containerName":"write_aln","line":194,"kind":13},{"containerName":"write_aln","name":"$self","line":198,"kind":13},{"containerName":"write_aln","name":"flush","line":198,"kind":12},{"name":"$self","containerName":"write_aln","line":198,"kind":13},{"name":"_flush_on_write","containerName":"write_aln","kind":12,"line":198},{"kind":13,"line":198,"containerName":"write_aln","name":"$self"},{"kind":12,"line":198,"containerName":"write_aln","name":"_fh"}]}],"version":5}