{"vars":[{"kind":2,"line":74,"name":"vars","containerName":""},{"containerName":null,"name":"$LINELENGTH","kind":13,"line":78},{"kind":2,"line":78,"name":"strict","containerName":""},{"containerName":null,"name":"$CLUSTALPRINTVERSION","kind":13,"line":79},{"containerName":"","name":"base","line":80,"kind":2},{"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":101,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$self"},{"kind":13,"line":101,"name":"@args","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":102},{"kind":13,"line":102,"containerName":"_initialize","name":"@args"},{"kind":13,"line":103,"name":"$percentages","definition":"my","containerName":"_initialize","localvar":"my"},{"kind":13,"line":103,"containerName":"_initialize","name":"$ll"},{"line":104,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":104},{"containerName":"_initialize","name":"@args","line":104,"kind":13},{"name":"$percentages","containerName":"_initialize","line":105,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":105},{"name":"percentages","containerName":"_initialize","line":105,"kind":12},{"kind":13,"line":105,"containerName":"_initialize","name":"$percentages"},{"containerName":"_initialize","name":"$self","line":106,"kind":13},{"line":106,"kind":12,"containerName":"_initialize","name":"line_length"},{"line":106,"kind":13,"containerName":"_initialize","name":"$ll"},{"name":"$LINELENGTH","containerName":"_initialize","line":106,"kind":13}],"line":100,"kind":12,"range":{"end":{"line":107,"character":9999},"start":{"character":0,"line":100}},"name":"_initialize"},{"containerName":"_initialize","name":"SUPER","kind":12,"line":102},{"kind":12,"line":121,"children":[{"line":122,"kind":13,"localvar":"my","containerName":"next_aln","name":"$self","definition":"my"},{"line":123,"kind":13,"localvar":"my","name":"$first_line","definition":"my","containerName":"next_aln"},{"name":"$first_line","containerName":"next_aln","line":125,"kind":13},{"kind":13,"line":125,"name":"$self","containerName":"next_aln"},{"line":125,"kind":12,"name":"_readline","containerName":"next_aln"},{"line":126,"kind":13,"containerName":"next_aln","name":"$first_line"},{"line":128,"kind":13,"containerName":"next_aln","name":"$self"},{"line":128,"kind":12,"containerName":"next_aln","name":"_pushback"},{"line":128,"kind":13,"name":"$first_line","containerName":"next_aln"},{"containerName":"next_aln","name":"$first_line","kind":13,"line":129},{"name":"$self","containerName":"next_aln","kind":13,"line":129},{"containerName":"next_aln","name":"_readline","kind":12,"line":129},{"kind":13,"line":130,"containerName":"next_aln","name":"$first_line"},{"line":132,"kind":13,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","name":"throw","kind":12,"line":132},{"kind":13,"line":136,"containerName":"next_aln","definition":"my","name":"%alignments","localvar":"my"},{"name":"$aln","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":137},{"containerName":"next_aln","name":"new","kind":12,"line":137},{"line":139,"kind":13,"name":"$self","containerName":"next_aln"},{"kind":12,"line":140,"name":"verbose","containerName":"next_aln"},{"kind":13,"line":141,"definition":"my","name":"$order","containerName":"next_aln","localvar":"my"},{"localvar":"my","definition":"my","name":"%order","containerName":"next_aln","line":142,"kind":13},{"kind":13,"line":143,"name":"$self","containerName":"next_aln"},{"line":144,"kind":13,"localvar":"my","containerName":"next_aln","name":"$first_block","definition":"my"},{"containerName":"next_aln","name":"$seen_block","kind":13,"line":144},{"name":"$self","containerName":"next_aln","line":145,"kind":13},{"line":145,"kind":12,"name":"_readline","containerName":"next_aln"},{"line":146,"kind":13,"name":"$first_block","containerName":"next_aln"},{"containerName":"next_aln","name":"$seen_block","line":148,"kind":13},{"containerName":"next_aln","name":"$first_block","line":151,"kind":13},{"containerName":"next_aln","name":"$self","kind":13,"line":155},{"name":"_pushback","containerName":"next_aln","line":155,"kind":12},{"line":159,"kind":13,"localvar":"my","definition":"my","name":"$seqname","containerName":"next_aln"},{"containerName":"next_aln","name":"$aln_line","line":159,"kind":13},{"kind":13,"line":163,"containerName":"next_aln","name":"$seqname"},{"containerName":"next_aln","name":"$aln_line","line":163,"kind":13},{"kind":13,"line":168,"containerName":"next_aln","name":"$seqname"},{"name":"$aln_line","containerName":"next_aln","line":168,"kind":13},{"line":169,"kind":13,"containerName":"next_aln","name":"$seqname"},{"name":"$self","containerName":"next_aln","line":170,"kind":13},{"name":"$self","containerName":"next_aln","line":175,"kind":13},{"containerName":"next_aln","name":"$seen_block","kind":13,"line":179},{"line":180,"kind":13,"name":"$order","containerName":"next_aln"},{"containerName":"next_aln","name":"$seqname","line":180,"kind":13},{"line":181,"kind":13,"containerName":"next_aln","name":"$self"},{"name":"warn","containerName":"next_aln","kind":12,"line":181},{"name":"$order","containerName":"next_aln","kind":13,"line":185},{"name":"$seqname","containerName":"next_aln","line":185,"kind":13},{"containerName":"next_aln","name":"$order","line":185,"kind":13},{"name":"$alignments","containerName":"next_aln","kind":13,"line":189},{"line":189,"kind":13,"containerName":"next_aln","name":"$seqname"},{"kind":13,"line":189,"name":"$aln_line","containerName":"next_aln"},{"localvar":"my","containerName":"next_aln","definition":"my","name":"$sname","line":192,"kind":13},{"kind":13,"line":192,"containerName":"next_aln","name":"$start"},{"containerName":"next_aln","name":"$end","kind":13,"line":192},{"line":193,"kind":13,"localvar":"my","containerName":"next_aln","definition":"my","name":"$name"},{"containerName":"next_aln","name":"$order","kind":13,"line":193},{"line":193,"kind":13,"containerName":"next_aln","name":"$a"},{"name":"$order","containerName":"next_aln","kind":13,"line":193},{"containerName":"next_aln","name":"$b","line":193,"kind":13},{"kind":13,"line":193,"containerName":"next_aln","name":"%alignments"},{"name":"$name","containerName":"next_aln","kind":13,"line":194},{"name":"$sname","containerName":"next_aln","line":195,"kind":13},{"kind":13,"line":195,"containerName":"next_aln","name":"$start"},{"name":"$end","containerName":"next_aln","line":195,"kind":13},{"containerName":"next_aln","name":"$sname","line":198,"kind":13},{"name":"$start","containerName":"next_aln","kind":13,"line":198},{"name":"$name","containerName":"next_aln","line":198,"kind":13},{"localvar":"my","containerName":"next_aln","name":"$str","definition":"my","line":199,"kind":13},{"line":199,"kind":13,"name":"$alignments","containerName":"next_aln"},{"containerName":"next_aln","name":"$name","kind":13,"line":199},{"kind":13,"line":200,"containerName":"next_aln","name":"$str"},{"name":"$end","containerName":"next_aln","line":201,"kind":13},{"containerName":"next_aln","name":"$str","kind":13,"line":201},{"line":203,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"next_aln"},{"line":203,"kind":12,"containerName":"next_aln","name":"new"},{"name":"$alignments","containerName":"next_aln","kind":13,"line":204},{"line":204,"kind":13,"name":"$name","containerName":"next_aln"},{"kind":13,"line":205,"containerName":"next_aln","name":"$sname"},{"name":"$start","containerName":"next_aln","line":206,"kind":13},{"containerName":"next_aln","name":"$end","kind":13,"line":208},{"name":"$aln","containerName":"next_aln","kind":13,"line":209},{"containerName":"next_aln","name":"add_seq","kind":12,"line":209},{"containerName":"next_aln","name":"$seq","line":209,"kind":13},{"line":217,"kind":13,"containerName":"next_aln","name":"$aln"},{"name":"$aln","containerName":"next_aln","line":217,"kind":13},{"line":217,"kind":12,"name":"num_sequences","containerName":"next_aln"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details","label":"next_aln($self)"},"name":"next_aln","range":{"start":{"line":121,"character":0},"end":{"character":9999,"line":219}}},{"kind":12,"line":137,"name":"Bio","containerName":"SimpleAlign"},{"name":"_lastline","kind":12,"line":143},{"name":"_lastline","line":170,"kind":12},{"name":"_lastline","kind":12,"line":175},{"kind":12,"line":203,"containerName":"LocatableSeq","name":"Bio"},{"range":{"start":{"character":0,"line":231},"end":{"character":9999,"line":316}},"name":"write_aln","children":[{"containerName":"write_aln","definition":"my","name":"$self","localvar":"my","kind":13,"line":232},{"name":"@aln","containerName":"write_aln","line":232,"kind":13},{"kind":13,"line":233,"containerName":"write_aln","name":"$count","definition":"my","localvar":"my"},{"kind":13,"line":233,"name":"$length","containerName":"write_aln"},{"line":233,"kind":13,"name":"$seq","containerName":"write_aln"},{"line":233,"kind":13,"name":"@seq","containerName":"write_aln"},{"name":"$tempcount","containerName":"write_aln","kind":13,"line":233},{"line":233,"kind":13,"name":"$line_len","containerName":"write_aln"},{"containerName":"write_aln","name":"$line_len","line":234,"kind":13},{"line":234,"kind":13,"name":"$self","containerName":"write_aln"},{"name":"line_length","containerName":"write_aln","line":234,"kind":12},{"containerName":"write_aln","name":"$LINELENGTH","kind":13,"line":234},{"line":235,"kind":13,"localvar":"my","definition":"my","name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"@aln","line":235,"kind":13},{"name":"$aln","containerName":"write_aln","line":236,"kind":13},{"name":"$aln","containerName":"write_aln","kind":13,"line":236},{"line":236,"kind":12,"containerName":"write_aln","name":"isa"},{"containerName":"write_aln","name":"$self","kind":13,"line":237},{"line":237,"kind":12,"containerName":"write_aln","name":"warn"},{"localvar":"my","name":"$matchline","definition":"my","containerName":"write_aln","line":242,"kind":13},{"name":"$aln","containerName":"write_aln","line":242,"kind":13},{"kind":12,"line":242,"containerName":"write_aln","name":"match_line"},{"name":"$self","containerName":"write_aln","line":243,"kind":13},{"containerName":"write_aln","name":"force_displayname_flat","line":243,"kind":12},{"name":"$aln","containerName":"write_aln","kind":13,"line":244},{"name":"set_displayname_flat","containerName":"write_aln","kind":12,"line":244},{"line":246,"kind":13,"containerName":"write_aln","name":"$self"},{"name":"_print","containerName":"write_aln","kind":12,"line":246},{"name":"$CLUSTALPRINTVERSION","containerName":"write_aln","line":248,"kind":13},{"kind":13,"line":250,"containerName":"write_aln","name":"$length"},{"kind":13,"line":250,"name":"$aln","containerName":"write_aln"},{"kind":12,"line":250,"containerName":"write_aln","name":"length"},{"line":251,"kind":13,"name":"$count","containerName":"write_aln"},{"line":251,"kind":13,"containerName":"write_aln","name":"$tempcount"},{"name":"@seq","containerName":"write_aln","line":252,"kind":13},{"line":252,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"each_seq","containerName":"write_aln","line":252,"kind":12},{"kind":13,"line":253,"name":"$max","definition":"my","containerName":"write_aln","localvar":"my"},{"containerName":"write_aln","name":"$seq","kind":13,"line":254},{"name":"@seq","containerName":"write_aln","line":254,"kind":13},{"containerName":"write_aln","name":"$max","kind":13,"line":255},{"kind":13,"line":255,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"displayname","line":255,"kind":12},{"kind":13,"line":255,"containerName":"write_aln","name":"$seq"},{"containerName":"write_aln","name":"get_nse","line":255,"kind":12},{"line":256,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"displayname","containerName":"write_aln","kind":12,"line":256},{"kind":13,"line":256,"containerName":"write_aln","name":"$seq"},{"name":"get_nse","containerName":"write_aln","kind":12,"line":256},{"kind":13,"line":256,"containerName":"write_aln","name":"$max"},{"containerName":"write_aln","name":"$count","kind":13,"line":259},{"kind":13,"line":259,"name":"$length","containerName":"write_aln"},{"kind":13,"line":260,"containerName":"write_aln","name":"$linesubstr","definition":"my","localvar":"my"},{"name":"$first","containerName":"write_aln","kind":13,"line":260},{"kind":13,"line":261,"name":"$seq","containerName":"write_aln"},{"name":"@seq","containerName":"write_aln","line":261,"kind":13},{"localvar":"my","containerName":"write_aln","definition":"my","name":"$substring","line":267,"kind":13},{"containerName":"write_aln","definition":"my","name":"$seqchars","localvar":"my","kind":13,"line":268},{"name":"$seq","containerName":"write_aln","kind":13,"line":268},{"name":"seq","containerName":"write_aln","kind":12,"line":268},{"name":"$seqchars","containerName":"write_aln","line":270,"kind":13},{"kind":13,"line":270,"containerName":"write_aln","name":"$count"},{"containerName":"write_aln","name":"$line_len","line":270,"kind":13},{"containerName":"write_aln","name":"$substring","line":271,"kind":13},{"containerName":"write_aln","name":"$seqchars","kind":13,"line":271},{"name":"$count","containerName":"write_aln","line":271,"kind":13},{"containerName":"write_aln","name":"$line_len","line":271,"kind":13},{"kind":13,"line":272,"containerName":"write_aln","name":"$first"},{"kind":13,"line":273,"containerName":"write_aln","name":"$linesubstr"},{"kind":13,"line":274,"containerName":"write_aln","name":"$matchline"},{"kind":13,"line":274,"containerName":"write_aln","name":"$count"},{"containerName":"write_aln","name":"$line_len","kind":13,"line":274},{"containerName":"write_aln","name":"$first","kind":13,"line":275},{"kind":13,"line":279,"name":"$seqchars","containerName":"write_aln"},{"name":"$count","containerName":"write_aln","kind":13,"line":279},{"name":"$substring","containerName":"write_aln","kind":13,"line":280},{"kind":13,"line":280,"containerName":"write_aln","name":"$seqchars"},{"containerName":"write_aln","name":"$count","kind":13,"line":280},{"containerName":"write_aln","name":"$first","kind":13,"line":281},{"kind":13,"line":282,"name":"$linesubstr","containerName":"write_aln"},{"name":"$matchline","containerName":"write_aln","kind":13,"line":282},{"kind":13,"line":282,"name":"$count","containerName":"write_aln"},{"containerName":"write_aln","name":"$first","line":283,"kind":13},{"containerName":"write_aln","name":"$substring","kind":13,"line":287},{"name":"$self","containerName":"write_aln","kind":13,"line":289},{"name":"_print","containerName":"write_aln","line":289,"kind":12},{"kind":13,"line":291,"containerName":"write_aln","name":"$max"},{"name":"$aln","containerName":"write_aln","kind":13,"line":292},{"kind":12,"line":292,"name":"displayname","containerName":"write_aln"},{"kind":13,"line":292,"name":"$seq","containerName":"write_aln"},{"containerName":"write_aln","name":"get_nse","line":292,"kind":12},{"kind":13,"line":293,"containerName":"write_aln","name":"$substring"},{"localvar":"my","containerName":"write_aln","definition":"my","name":"$percentages","line":297,"kind":13},{"containerName":"write_aln","name":"$self","line":298,"kind":13},{"name":"percentages","containerName":"write_aln","line":298,"kind":12},{"kind":13,"line":299,"containerName":"write_aln","definition":"my","name":"$strcpy","localvar":"my"},{"containerName":"write_aln","name":"$linesubstr","kind":13,"line":299},{"containerName":"write_aln","definition":"my","name":"$count","localvar":"my","kind":13,"line":300},{"name":"$strcpy","containerName":"write_aln","line":300,"kind":13},{"containerName":"write_aln","name":"$percentages","line":301,"kind":13},{"line":302,"kind":13,"name":"$count","containerName":"write_aln"},{"kind":13,"line":302,"name":"$linesubstr","containerName":"write_aln"},{"kind":13,"line":304,"name":"$self","containerName":"write_aln"},{"name":"_print","containerName":"write_aln","kind":12,"line":304},{"kind":13,"line":306,"containerName":"write_aln","name":"$max"},{"kind":13,"line":307,"name":"$linesubstr","containerName":"write_aln"},{"name":"$percentages","containerName":"write_aln","kind":13,"line":308},{"line":310,"kind":13,"containerName":"write_aln","name":"$self"},{"name":"_print","containerName":"write_aln","line":310,"kind":12},{"name":"$count","containerName":"write_aln","kind":13,"line":311},{"line":311,"kind":13,"containerName":"write_aln","name":"$line_len"},{"line":314,"kind":13,"name":"$self","containerName":"write_aln"},{"containerName":"write_aln","name":"flush","line":314,"kind":12},{"name":"$self","containerName":"write_aln","kind":13,"line":314},{"line":314,"kind":12,"name":"_flush_on_write","containerName":"write_aln"},{"name":"$self","containerName":"write_aln","line":314,"kind":13},{"line":314,"kind":12,"containerName":"write_aln","name":"_fh"}],"line":231,"kind":12,"signature":{"label":"write_aln($self,@aln)","documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /CLUSTAL/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with a CLUSTAL header\"\n        );\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'clustalw',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block) = (0,0);\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n        # break the loop if we come to the end of the current alignment\n        # and push back the CLUSTAL header\n        if (/CLUSTAL/) {\n            $self->_pushback($_);\n            last;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname} = $order++;\n            }\n        }\n\n        $alignments{$seqname} .= $aln_line;\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n\n    # not sure if this should be a default option - or we can pass in\n    # an option to do this in the future? --jason stajich\n    # $aln->map_chars('\\.','-');\n    \n    # no sequences added, so just return\n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the clustalw-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object","parameters":[{"label":"$self"},{"label":"@aln"}]},"detail":"($self,@aln)","definition":"sub","containerName":"main::"},{"line":269,"kind":12,"name":"SWITCH"},{"name":"SWITCH","kind":12,"line":277},{"line":285,"kind":12,"name":"SWITCH"},{"line":330,"children":[{"localvar":"my","containerName":"percentages","name":"$self","definition":"my","line":331,"kind":13},{"line":331,"kind":13,"name":"$value","containerName":"percentages"},{"containerName":"percentages","name":"$value","line":332,"kind":13},{"kind":13,"line":333,"containerName":"percentages","name":"$self"},{"name":"$value","containerName":"percentages","line":333,"kind":13},{"line":335,"kind":13,"name":"$self","containerName":"percentages"}],"kind":12,"detail":"($self,$value)","signature":{"label":"percentages($self,$value)","documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /CLUSTAL/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with a CLUSTAL header\"\n        );\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'clustalw',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block) = (0,0);\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n        # break the loop if we come to the end of the current alignment\n        # and push back the CLUSTAL header\n        if (/CLUSTAL/) {\n            $self->_pushback($_);\n            last;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname} = $order++;\n            }\n        }\n\n        $alignments{$seqname} .= $aln_line;\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n\n    # not sure if this should be a default option - or we can pass in\n    # an option to do this in the future? --jason stajich\n    # $aln->map_chars('\\.','-');\n    \n    # no sequences added, so just return\n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the clustalw-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\n\nsub write_aln {\n    my ( $self, @aln ) = @_;\n    my ( $count, $length, $seq, @seq, $tempcount, $line_len );\n    $line_len = $self->line_length || $LINELENGTH;\n    foreach my $aln (@aln) {\n        if ( !$aln || !$aln->isa('Bio::Align::AlignI') ) {\n            $self->warn(\n\"Must provide a Bio::Align::AlignI object when calling write_aln\"\n            );\n            next;\n        }\n        my $matchline = $aln->match_line;\n        if ( $self->force_displayname_flat ) {\n            $aln->set_displayname_flat(1);\n        }\n        $self->_print(\n            sprintf( \"CLUSTAL W(%s) multiple sequence alignment\\n\\n\\n\",\n                $CLUSTALPRINTVERSION )\n        ) or return;\n        $length = $aln->length();\n        $count  = $tempcount = 0;\n        @seq    = $aln->each_seq();\n        my $max = 22;\n        foreach $seq (@seq) {\n            $max = length( $aln->displayname( $seq->get_nse() ) )\n              if ( length( $aln->displayname( $seq->get_nse() ) ) > $max );\n        }\n\n        while ( $count < $length ) {\n            my ( $linesubstr, $first ) = ( '', 1 );\n            foreach $seq (@seq) {\n\n              #\n              #  Following lines are to suppress warnings\n              #  if some sequences in the alignment are much longer than others.\n\n                my ($substring);\n                my $seqchars = $seq->seq();\n              SWITCH: {\n                    if ( length($seqchars) >= ( $count + $line_len ) ) {\n                        $substring = substr( $seqchars, $count, $line_len );\n                        if ($first) {\n                            $linesubstr =\n                              substr( $matchline, $count, $line_len );\n                            $first = 0;\n                        }\n                        last SWITCH;\n                    }\n                    elsif ( length($seqchars) >= $count ) {\n                        $substring = substr( $seqchars, $count );\n                        if ($first) {\n                            $linesubstr = substr( $matchline, $count );\n                            $first = 0;\n                        }\n                        last SWITCH;\n                    }\n                    $substring = \"\";\n                }\n                $self->_print(\n                    sprintf(\n                        \"%-\" . $max . \"s %s\\n\",\n                        $aln->displayname( $seq->get_nse() ), $substring\n                    )\n                ) or return;\n            }\n\n            my $percentages = '';\n            if ( $self->percentages ) {\n                my ($strcpy) = ($linesubstr);\n                my $count = ( $strcpy =~ tr/\\*// );\n                $percentages =\n                  sprintf( \"\\t%d%%\", 100 * ( $count / length($linesubstr) ) );\n            }\n            $self->_print(\n                sprintf(\n                    \"%-\" . $max . \"s %s%s\\n\",\n                    '', $linesubstr, $percentages\n                )\n            );\n            $self->_print( sprintf(\"\\n\\n\") ) or return;\n            $count += $line_len;\n        }\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 percentages\n\n Title   : percentages\n Usage   : $obj->percentages($newval)\n Function: Set the percentages flag - whether or not to show percentages in\n           each output line\n Returns : value of percentages\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":336},"start":{"character":0,"line":330}},"name":"percentages"},{"range":{"start":{"line":349,"character":0},"end":{"character":9999,"line":355}},"name":"line_length","children":[{"name":"$self","definition":"my","containerName":"line_length","localvar":"my","kind":13,"line":350},{"name":"$value","containerName":"line_length","line":350,"kind":13},{"name":"$value","containerName":"line_length","kind":13,"line":351},{"containerName":"line_length","name":"$self","line":352,"kind":13},{"kind":13,"line":352,"name":"$value","containerName":"line_length"},{"line":354,"kind":13,"name":"$self","containerName":"line_length"}],"line":349,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: clustalw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::clustalw\n#\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#       and the Bio::SimpleAlign module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# History\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::clustalw - clustalw sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Align::AlignI objects to and from clustalw\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::clustalw;\nuse vars qw($LINELENGTH $CLUSTALPRINTVERSION);\nuse strict;\n\n\n$LINELENGTH          = 60;\n$CLUSTALPRINTVERSION = '1.81';\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : $alignio = Bio::AlignIO->new(-format => 'clustalw',\n                       -file => 'filename');\n Function: returns a new Bio::AlignIO object to handle clustalw files\n Returns : Bio::AlignIO::clustalw object\n Args    : -verbose => verbosity setting (-1, 0, 1, 2)\n           -file    => name of file to read in or to write, with \">\"\n           -fh      => alternative to -file param - provide a filehandle\n                       to read from or write to\n           -format  => alignment format to process or produce\n           -percentages => display a percentage of identity\n                           in each line of the alignment (clustalw only)\n           -linelength=> alignment output line length (default 60)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ( $percentages, $ll ) =\n      $self->_rearrange( [qw(PERCENTAGES LINELENGTH)], @args );\n    defined $percentages && $self->percentages($percentages);\n    $self->line_length( $ll || $LINELENGTH );\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::Align::AlignI object\n Args    : NONE\n\nSee L<Bio::Align::AlignI> for details\n\n\nsub next_aln {\n    my ($self) = @_;\n    my $first_line;\n\n    while ( $first_line = $self->_readline ) {\n        last if $first_line !~ /^$/;\n    }\n    $self->_pushback($first_line);\n    if ( defined( $first_line = $self->_readline )\n        && $first_line !~ /CLUSTAL/ )\n    {\n        $self->throw(\n            \"trying to parse a file which does not start with a CLUSTAL header\"\n        );\n    }\n    my %alignments;\n    my $aln = Bio::SimpleAlign->new(\n        -source  => 'clustalw',\n        -verbose => $self->verbose\n    );\n    my $order = 0;\n    my %order;\n    $self->{_lastline} = '';\n    my ($first_block, $seen_block) = (0,0);\n    while ( defined( $_ = $self->_readline ) ) {\n        next if (/^\\s+$/ && !$first_block);\n        if (/^\\s$/) {  # line contains no description\n            $seen_block = 1;\n            next;\n        }\n        $first_block = 1;\n        # break the loop if we come to the end of the current alignment\n        # and push back the CLUSTAL header\n        if (/CLUSTAL/) {\n            $self->_pushback($_);\n            last;\n        }\n\n        my ( $seqname, $aln_line ) = ( '', '' );\n        if (/^\\s*(\\S+)\\s*\\/\\s*(\\d+)-(\\d+)\\s+(\\S+)\\s*$/ox) {\n\n            # clustal 1.4 format\n            ( $seqname, $aln_line ) = ( \"$1:$2-$3\", $4 );\n\n            # } elsif( /^\\s*(\\S+)\\s+(\\S+)\\s*$/ox ) { without trailing numbers\n        }\n        elsif (/^\\s*(\\S+)\\s+(\\S+)\\s*\\d*\\s*$/ox) {    # with numbers\n            ( $seqname, $aln_line ) = ( $1, $2 );\n            if ( $seqname =~ /^[\\*\\.\\+\\:]+$/ ) {\n                $self->{_lastline} = $_;\n                next;\n            }\n        }\n        else {\n            $self->{_lastline} = $_;\n            next;\n        }\n\n        if ( !$seen_block ) {\n            if (exists $order{$seqname}) {\n                $self->warn(\"Duplicate sequence : $seqname\\n\".\n                            \"Can't guarantee alignment quality\");\n            }\n            else {\n                $order{$seqname} = $order++;\n            }\n        }\n\n        $alignments{$seqname} .= $aln_line;\n    }\n\n    my ( $sname, $start, $end );\n    foreach my $name ( sort { $order{$a} <=> $order{$b} } keys %alignments ) {\n        if ( $name =~ /(\\S+):(\\d+)-(\\d+)/ ) {\n            ( $sname, $start, $end ) = ( $1, $2, $3 );\n        }\n        else {\n            ( $sname, $start ) = ( $name, 1 );\n            my $str = $alignments{$name};\n            $str =~ s/[^A-Za-z]//g;\n            $end = length($str);\n        }\n        my $seq = Bio::LocatableSeq->new(\n            -seq   => $alignments{$name},\n            -id    => $sname,\n            -start => $start,\n            -end   => $end\n        );\n        $aln->add_seq($seq);\n    }\n\n    # not sure if this should be a default option - or we can pass in\n    # an option to do this in the future? --jason stajich\n    # $aln->map_chars('\\.','-');\n    \n    # no sequences added, so just return\n    return $aln if $aln->num_sequences;\n    return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the clustalw-format object (.aln) into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Align::AlignI object\n\n\nsub write_aln {\n    my ( $self, @aln ) = @_;\n    my ( $count, $length, $seq, @seq, $tempcount, $line_len );\n    $line_len = $self->line_length || $LINELENGTH;\n    foreach my $aln (@aln) {\n        if ( !$aln || !$aln->isa('Bio::Align::AlignI') ) {\n            $self->warn(\n\"Must provide a Bio::Align::AlignI object when calling write_aln\"\n            );\n            next;\n        }\n        my $matchline = $aln->match_line;\n        if ( $self->force_displayname_flat ) {\n            $aln->set_displayname_flat(1);\n        }\n        $self->_print(\n            sprintf( \"CLUSTAL W(%s) multiple sequence alignment\\n\\n\\n\",\n                $CLUSTALPRINTVERSION )\n        ) or return;\n        $length = $aln->length();\n        $count  = $tempcount = 0;\n        @seq    = $aln->each_seq();\n        my $max = 22;\n        foreach $seq (@seq) {\n            $max = length( $aln->displayname( $seq->get_nse() ) )\n              if ( length( $aln->displayname( $seq->get_nse() ) ) > $max );\n        }\n\n        while ( $count < $length ) {\n            my ( $linesubstr, $first ) = ( '', 1 );\n            foreach $seq (@seq) {\n\n              #\n              #  Following lines are to suppress warnings\n              #  if some sequences in the alignment are much longer than others.\n\n                my ($substring);\n                my $seqchars = $seq->seq();\n              SWITCH: {\n                    if ( length($seqchars) >= ( $count + $line_len ) ) {\n                        $substring = substr( $seqchars, $count, $line_len );\n                        if ($first) {\n                            $linesubstr =\n                              substr( $matchline, $count, $line_len );\n                            $first = 0;\n                        }\n                        last SWITCH;\n                    }\n                    elsif ( length($seqchars) >= $count ) {\n                        $substring = substr( $seqchars, $count );\n                        if ($first) {\n                            $linesubstr = substr( $matchline, $count );\n                            $first = 0;\n                        }\n                        last SWITCH;\n                    }\n                    $substring = \"\";\n                }\n                $self->_print(\n                    sprintf(\n                        \"%-\" . $max . \"s %s\\n\",\n                        $aln->displayname( $seq->get_nse() ), $substring\n                    )\n                ) or return;\n            }\n\n            my $percentages = '';\n            if ( $self->percentages ) {\n                my ($strcpy) = ($linesubstr);\n                my $count = ( $strcpy =~ tr/\\*// );\n                $percentages =\n                  sprintf( \"\\t%d%%\", 100 * ( $count / length($linesubstr) ) );\n            }\n            $self->_print(\n                sprintf(\n                    \"%-\" . $max . \"s %s%s\\n\",\n                    '', $linesubstr, $percentages\n                )\n            );\n            $self->_print( sprintf(\"\\n\\n\") ) or return;\n            $count += $line_len;\n        }\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 percentages\n\n Title   : percentages\n Usage   : $obj->percentages($newval)\n Function: Set the percentages flag - whether or not to show percentages in\n           each output line\n Returns : value of percentages\n Args    : newvalue (optional)\n\n\n\nsub percentages {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_percentages'} = $value;\n    }\n    return $self->{'_percentages'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function: Set the alignment output line length\n Returns : value of line_length\n Args    : newvalue (optional)","label":"line_length($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"}],"version":5}