{"vars":[{"containerName":"","name":"vars","line":89,"kind":2},{"name":"%DistanceMethods","containerName":null,"kind":13,"line":95},{"name":"PhylipDist","containerName":"strict::Bio::Align::PairwiseStatistics::Bio::Matrix","line":95,"kind":2},{"line":97,"kind":13,"containerName":null,"name":"$Precision"},{"containerName":null,"name":"$DefaultGapPenalty","kind":13,"line":98},{"line":100,"kind":2,"name":"base","containerName":""},{"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":113,"children":[{"kind":13,"line":114,"definition":"my","name":"$class","containerName":"new","localvar":"my"},{"kind":13,"line":114,"name":"@args","containerName":"new"},{"line":116,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"kind":13,"line":116,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":116,"kind":13},{"line":117,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":117,"containerName":"new","name":"pairwise_stats"},{"containerName":"new","name":"new","line":117,"kind":12},{"containerName":"new","name":"$self","line":119,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":120},"start":{"line":113,"character":0}},"name":"new"},{"name":"SUPER","containerName":"new","kind":12,"line":116},{"name":"Bio","containerName":"Align::PairwiseStatistics","kind":12,"line":117},{"kind":12,"children":[{"kind":13,"line":137,"containerName":"distance","name":"$self","definition":"my","localvar":"my"},{"name":"@args","containerName":"distance","kind":13,"line":137},{"kind":13,"line":138,"containerName":"distance","name":"$aln","definition":"my","localvar":"my"},{"kind":13,"line":138,"containerName":"distance","name":"$method"},{"kind":13,"line":138,"name":"$self","containerName":"distance"},{"kind":12,"line":138,"name":"_rearrange","containerName":"distance"},{"containerName":"distance","name":"@args","line":138,"kind":13},{"containerName":"distance","name":"$aln","kind":13,"line":139},{"line":139,"kind":13,"containerName":"distance","name":"$aln"},{"kind":13,"line":139,"containerName":"distance","name":"$aln"},{"kind":12,"line":139,"containerName":"distance","name":"isa"},{"containerName":"distance","name":"$self","kind":13,"line":140},{"name":"throw","containerName":"distance","kind":12,"line":140},{"name":"$method","containerName":"distance","line":142,"kind":13},{"localvar":"my","containerName":"distance","name":"$m","definition":"my","line":143,"kind":13},{"line":143,"kind":13,"name":"%DistanceMethods","containerName":"distance"},{"name":"$m","containerName":"distance","kind":13,"line":144},{"name":"$method","containerName":"distance","kind":13,"line":144},{"containerName":"distance","name":"$mtd","definition":"my","localvar":"my","kind":13,"line":145},{"kind":13,"line":146,"containerName":"distance","name":"$self"},{"kind":13,"line":146,"containerName":"distance","name":"$mtd"},{"line":146,"kind":13,"containerName":"distance","name":"$aln"},{"name":"$self","containerName":"distance","line":149,"kind":13},{"containerName":"distance","name":"warn","kind":12,"line":149},{"line":150,"kind":13,"containerName":"distance","name":"$self"},{"line":150,"kind":12,"name":"available_distance_methods","containerName":"distance"}],"line":136,"definition":"sub","containerName":"main::","signature":{"label":"distance($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n  return $self;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)"},"detail":"($self,@args)","name":"distance","range":{"start":{"line":136,"character":0},"end":{"line":152,"character":9999}}},{"range":{"start":{"line":165,"character":0},"end":{"line":168,"character":9999}},"name":"available_distance_methods","signature":{"documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n  return $self;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'Kimura';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"available_distance_methods($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":166,"containerName":"available_distance_methods","definition":"my","name":"$self","localvar":"my"},{"line":166,"kind":13,"containerName":"available_distance_methods","name":"@args"},{"containerName":"available_distance_methods","name":"%DistanceMethods","kind":13,"line":167}],"line":165,"kind":12},{"name":"D_Kimura","range":{"start":{"line":191,"character":0},"end":{"character":9999,"line":256}},"containerName":"main::","definition":"sub","detail":"($self,$aln)","signature":{"documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n  return $self;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'Kimura';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $matrix = $pepstats->D_Kimura($aln);\n Function: Calculate Kimura protein distance (Kimura 1983) which \n           approximates PAM distance\n           D = -ln ( 1 - p - 0.2 * p^2 )\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI>\n\n\n Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, Cambridge.","parameters":[{"label":"$self"},{"label":"$aln"}],"label":"D_Kimura($self,$aln)"},"kind":12,"line":191,"children":[{"kind":13,"line":192,"definition":"my","name":"$self","containerName":"D_Kimura","localvar":"my"},{"containerName":"D_Kimura","name":"$aln","line":192,"kind":13},{"containerName":"D_Kimura","name":"$self","kind":13,"line":193},{"kind":12,"line":193,"name":"_check_arg","containerName":"D_Kimura"},{"name":"$aln","containerName":"D_Kimura","line":193,"kind":13},{"definition":"my","name":"@seqs","containerName":"D_Kimura","localvar":"my","kind":13,"line":195},{"name":"@names","containerName":"D_Kimura","line":195,"kind":13},{"line":195,"kind":13,"name":"@values","containerName":"D_Kimura"},{"line":195,"kind":13,"containerName":"D_Kimura","name":"%dist"},{"containerName":"D_Kimura","definition":"my","name":"$seqct","localvar":"my","kind":13,"line":196},{"localvar":"my","containerName":"D_Kimura","name":"$seq","definition":"my","line":197,"kind":13},{"line":197,"kind":13,"name":"$aln","containerName":"D_Kimura"},{"kind":12,"line":197,"containerName":"D_Kimura","name":"each_seq"},{"containerName":"D_Kimura","name":"@names","kind":13,"line":198},{"name":"$seq","containerName":"D_Kimura","line":198,"kind":13},{"kind":12,"line":198,"containerName":"D_Kimura","name":"display_id"},{"name":"@seqs","containerName":"D_Kimura","line":199,"kind":13},{"line":199,"kind":13,"name":"$seq","containerName":"D_Kimura"},{"kind":12,"line":199,"name":"seq","containerName":"D_Kimura"},{"line":200,"kind":13,"name":"$seqct","containerName":"D_Kimura"},{"kind":13,"line":202,"containerName":"D_Kimura","name":"$len","definition":"my","localvar":"my"},{"name":"$aln","containerName":"D_Kimura","line":202,"kind":13},{"name":"length","containerName":"D_Kimura","kind":12,"line":202},{"line":203,"kind":13,"localvar":"my","definition":"my","name":"$precisionstr","containerName":"D_Kimura"},{"definition":"my","name":"$i","containerName":"D_Kimura","localvar":"my","kind":13,"line":205},{"containerName":"D_Kimura","name":"$i","line":205,"kind":13},{"line":205,"kind":13,"name":"$seqct","containerName":"D_Kimura"},{"line":205,"kind":13,"containerName":"D_Kimura","name":"$i"},{"containerName":"D_Kimura","name":"$dist","kind":13,"line":207},{"kind":13,"line":207,"containerName":"D_Kimura","name":"$names"},{"containerName":"D_Kimura","name":"$i","kind":13,"line":207},{"containerName":"D_Kimura","name":"$names","kind":13,"line":207},{"kind":13,"line":207,"containerName":"D_Kimura","name":"$i"},{"name":"$i","containerName":"D_Kimura","line":207,"kind":13},{"containerName":"D_Kimura","name":"$i","line":207,"kind":13},{"name":"$values","containerName":"D_Kimura","line":208,"kind":13},{"kind":13,"line":208,"name":"$i","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$i","kind":13,"line":208},{"containerName":"D_Kimura","name":"$precisionstr","kind":13,"line":208},{"line":209,"kind":13,"localvar":"my","containerName":"D_Kimura","name":"$j","definition":"my"},{"kind":13,"line":209,"name":"$i","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$j","kind":13,"line":209},{"line":209,"kind":13,"containerName":"D_Kimura","name":"$seqct"},{"line":209,"kind":13,"name":"$j","containerName":"D_Kimura"},{"line":210,"kind":13,"localvar":"my","containerName":"D_Kimura","definition":"my","name":"$scored"},{"kind":13,"line":210,"containerName":"D_Kimura","name":"$match"},{"localvar":"my","containerName":"D_Kimura","name":"$k","definition":"my","line":211,"kind":13},{"line":211,"kind":13,"name":"$k","containerName":"D_Kimura"},{"name":"$len","containerName":"D_Kimura","kind":13,"line":211},{"name":"$k","containerName":"D_Kimura","line":211,"kind":13},{"definition":"my","name":"$m1","containerName":"D_Kimura","localvar":"my","kind":13,"line":212},{"containerName":"D_Kimura","name":"$seqs","line":212,"kind":13},{"kind":13,"line":212,"name":"$i","containerName":"D_Kimura"},{"name":"$k","containerName":"D_Kimura","kind":13,"line":212},{"line":213,"kind":13,"localvar":"my","definition":"my","name":"$m2","containerName":"D_Kimura"},{"kind":13,"line":213,"containerName":"D_Kimura","name":"$seqs"},{"kind":13,"line":213,"name":"$j","containerName":"D_Kimura"},{"kind":13,"line":213,"name":"$k","containerName":"D_Kimura"},{"kind":13,"line":214,"containerName":"D_Kimura","name":"$m1"},{"kind":13,"line":214,"containerName":"D_Kimura","name":"$m2"},{"line":220,"kind":13,"name":"$match","containerName":"D_Kimura"},{"kind":13,"line":220,"name":"$m1","containerName":"D_Kimura"},{"line":220,"kind":13,"containerName":"D_Kimura","name":"$m2"},{"name":"$scored","containerName":"D_Kimura","line":221,"kind":13},{"line":234,"kind":13,"localvar":"my","containerName":"D_Kimura","name":"$D","definition":"my"},{"name":"$match","containerName":"D_Kimura","kind":13,"line":234},{"kind":13,"line":234,"name":"$scored","containerName":"D_Kimura"},{"kind":13,"line":235,"containerName":"D_Kimura","name":"$D"},{"line":236,"kind":13,"name":"$D","containerName":"D_Kimura"},{"line":236,"kind":13,"name":"$D","containerName":"D_Kimura"},{"name":"$D","containerName":"D_Kimura","line":236,"kind":13},{"line":237,"kind":13,"name":"$values","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$j","line":237,"kind":13},{"kind":13,"line":237,"containerName":"D_Kimura","name":"$i"},{"containerName":"D_Kimura","name":"$values","kind":13,"line":237},{"line":237,"kind":13,"name":"$i","containerName":"D_Kimura"},{"name":"$j","containerName":"D_Kimura","kind":13,"line":237},{"line":237,"kind":13,"name":"$precisionstr","containerName":"D_Kimura"},{"kind":13,"line":237,"containerName":"D_Kimura","name":"$D"},{"line":239,"kind":13,"containerName":"D_Kimura","name":"$values"},{"kind":13,"line":239,"name":"$j","containerName":"D_Kimura"},{"name":"$i","containerName":"D_Kimura","line":239,"kind":13},{"kind":13,"line":239,"containerName":"D_Kimura","name":"$values"},{"name":"$i","containerName":"D_Kimura","kind":13,"line":239},{"containerName":"D_Kimura","name":"$j","kind":13,"line":239},{"line":242,"kind":13,"containerName":"D_Kimura","name":"$dist"},{"kind":13,"line":242,"name":"$names","containerName":"D_Kimura"},{"name":"$i","containerName":"D_Kimura","line":242,"kind":13},{"name":"$names","containerName":"D_Kimura","line":242,"kind":13},{"name":"$j","containerName":"D_Kimura","line":242,"kind":13},{"kind":13,"line":242,"name":"$i","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$j","kind":13,"line":242},{"name":"$dist","containerName":"D_Kimura","line":243,"kind":13},{"line":243,"kind":13,"name":"$names","containerName":"D_Kimura"},{"name":"$j","containerName":"D_Kimura","line":243,"kind":13},{"line":243,"kind":13,"name":"$names","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$i","kind":13,"line":243},{"line":243,"kind":13,"containerName":"D_Kimura","name":"$i"},{"kind":13,"line":243,"name":"$j","containerName":"D_Kimura"},{"kind":13,"line":246,"containerName":"D_Kimura","name":"$dist"},{"line":246,"kind":13,"name":"$names","containerName":"D_Kimura"},{"line":246,"kind":13,"name":"$j","containerName":"D_Kimura"},{"name":"$names","containerName":"D_Kimura","line":246,"kind":13},{"name":"$j","containerName":"D_Kimura","line":246,"kind":13},{"line":246,"kind":13,"containerName":"D_Kimura","name":"$j"},{"kind":13,"line":246,"name":"$j","containerName":"D_Kimura"},{"kind":13,"line":247,"containerName":"D_Kimura","name":"$values"},{"line":247,"kind":13,"containerName":"D_Kimura","name":"$j"},{"kind":13,"line":247,"name":"$j","containerName":"D_Kimura"},{"containerName":"D_Kimura","name":"$precisionstr","kind":13,"line":247},{"kind":12,"line":251,"containerName":"D_Kimura","name":"new"},{"name":"%dist","containerName":"D_Kimura","line":252,"kind":13},{"kind":13,"line":253,"containerName":"D_Kimura","name":"@names"},{"name":"@values","containerName":"D_Kimura","kind":13,"line":254}]},{"kind":12,"line":220,"name":"_check_ambiguity_protein"},{"kind":12,"line":251,"containerName":"Matrix::PhylipDist","name":"Bio"},{"name":"_check_ambiguity_protein","range":{"start":{"character":0,"line":259},"end":{"character":9999,"line":278}},"containerName":"main::","definition":"sub","detail":"($t1,$t2)","signature":{"label":"_check_ambiguity_protein($t1,$t2)","documentation":" some methods from EMBOSS distmat","parameters":[{"label":"$t1"},{"label":"$t2"}]},"kind":12,"line":259,"children":[{"line":261,"kind":13,"localvar":"my","definition":"my","name":"$t1","containerName":"_check_ambiguity_protein"},{"name":"$t2","containerName":"_check_ambiguity_protein","line":261,"kind":13},{"kind":13,"line":262,"containerName":"_check_ambiguity_protein","name":"$n","definition":"my","localvar":"my"},{"kind":13,"line":264,"name":"$t1","containerName":"_check_ambiguity_protein"},{"kind":13,"line":264,"name":"$t1","containerName":"_check_ambiguity_protein"},{"name":"$t2","containerName":"_check_ambiguity_protein","kind":13,"line":264},{"containerName":"_check_ambiguity_protein","name":"$n","kind":13,"line":265},{"containerName":"_check_ambiguity_protein","name":"$t1","kind":13,"line":266},{"kind":13,"line":266,"containerName":"_check_ambiguity_protein","name":"$t2"},{"containerName":"_check_ambiguity_protein","name":"$t2","line":267,"kind":13},{"containerName":"_check_ambiguity_protein","name":"$t2","kind":13,"line":267},{"name":"$t1","containerName":"_check_ambiguity_protein","kind":13,"line":269},{"line":269,"kind":13,"name":"$t2","containerName":"_check_ambiguity_protein"},{"name":"$t2","containerName":"_check_ambiguity_protein","kind":13,"line":270},{"kind":13,"line":270,"containerName":"_check_ambiguity_protein","name":"$t1"},{"line":271,"kind":13,"name":"$n","containerName":"_check_ambiguity_protein"},{"kind":13,"line":272,"containerName":"_check_ambiguity_protein","name":"$t1"},{"name":"$t2","containerName":"_check_ambiguity_protein","line":272,"kind":13},{"kind":13,"line":273,"containerName":"_check_ambiguity_protein","name":"$n"},{"kind":13,"line":274,"containerName":"_check_ambiguity_protein","name":"$t1"},{"containerName":"_check_ambiguity_protein","name":"$t2","kind":13,"line":274},{"containerName":"_check_ambiguity_protein","name":"$n","line":275,"kind":13},{"line":277,"kind":13,"containerName":"_check_ambiguity_protein","name":"$n"}]},{"range":{"end":{"character":9999,"line":302},"start":{"line":295,"character":0}},"name":"pairwise_stats","line":295,"children":[{"containerName":"pairwise_stats","name":"$self","definition":"my","localvar":"my","kind":13,"line":296},{"line":296,"kind":13,"name":"$value","containerName":"pairwise_stats"},{"containerName":"pairwise_stats","name":"$value","line":297,"kind":13},{"line":298,"kind":13,"containerName":"pairwise_stats","name":"$self"},{"kind":13,"line":298,"containerName":"pairwise_stats","name":"$value"},{"name":"$self","containerName":"pairwise_stats","kind":13,"line":300}],"kind":12,"detail":"($self,$value)","signature":{"label":"pairwise_stats($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ProteinStatistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::ProteinStatistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::ProteinStatistics - Calculate Protein Alignment statistics (mostly distances)\n\n=head1 SYNOPSIS\n\n  use Bio::Align::ProteinStatistics;\n  use Bio::AlignIO;\n  my $in = Bio::AlignIO->new(-format => 'fasta',\n\t\t\t    -file   => 'pep-104.fasaln');\n  my $aln = $in->next_aln;\n\n  my $pepstats = Bio::Align::ProteinStatistics->new();\n  $kimura = $protstats->distance(-align => $aln,\n\t\t\t         -method => 'Kimura');\n  print $kimura->print_matrix;\n\n\n=head1 DESCRIPTION\n\nThis object is for generating various statistics from a protein\nalignment.  Mostly it is where pairwise protein distances can be\ncalculated.\n\n=head1 REFERENCES \n\nD_Kimura - Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, \n           Cambridge.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::ProteinStatistics;\nuse vars qw(%DistanceMethods $Precision $DefaultGapPenalty);\nuse strict;\n\nuse Bio::Align::PairwiseStatistics;\nuse Bio::Matrix::PhylipDist;\n\n%DistanceMethods = ('kimura|k' => 'Kimura',\n\t\t    );\n$Precision = 5;\n$DefaultGapPenalty = 0;\n\nuse base qw(Bio::Root::Root Bio::Align::StatisticsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Align::ProteinStatistics->new();\n Function: Builds a new Bio::Align::ProteinStatistics object \n Returns : an instance of Bio::Align::ProteinStatistics\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->pairwise_stats( Bio::Align::PairwiseStatistics->new());\n\n  return $self;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : L<Bio::Matrix::PhylipDist> object\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\n\n\nsub distance{\n   my ($self,@args) = @_;\n   my ($aln,$method) = $self->_rearrange([qw(ALIGN METHOD)],@args);\n   if( ! defined $aln || ! ref ($aln) || ! $aln->isa('Bio::Align::AlignI') ) { \n       $self->throw(\"Must supply a valid Bio::Align::AlignI for the -align parameter in distance\");\n   }\n   $method ||= 'Kimura';\n   foreach my $m ( keys %DistanceMethods ) {\n       if(defined $m &&  $method =~ /$m/i ) {\n\t   my $mtd = \"D_$DistanceMethods{$m}\";\n\t   return $self->$mtd($aln);\n       }\n   }\n   $self->warn(\"Unrecognized distance method $method must be one of [\".\n\t       join(',',$self->available_distance_methods()).\"]\");\n   return;\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none\n\n\n\nsub available_distance_methods{\n   my ($self,@args) = @_;\n   return values %DistanceMethods;\n}\n\n=head2 D - distance methods\n\n\n\n\n=head2 D_Kimura\n\n Title   : D_Kimura\n Usage   : my $matrix = $pepstats->D_Kimura($aln);\n Function: Calculate Kimura protein distance (Kimura 1983) which \n           approximates PAM distance\n           D = -ln ( 1 - p - 0.2 * p^2 )\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : L<Bio::Align::AlignI>\n\n\n\n# Kimura, M. 1983. The Neutral Theory of Molecular Evolution. CUP, Cambridge.\n\nsub D_Kimura{\n   my ($self,$aln) = @_;\n   return 0 unless $self->_check_arg($aln);\n   # ambiguities ignored at this point\n   my (@seqs,@names,@values,%dist);\n   my $seqct = 0;\n   foreach my $seq ( $aln->each_seq) {\n       push @names, $seq->display_id;\n       push @seqs, uc $seq->seq();\n       $seqct++;\n   }\n   my $len = $aln->length;\n   my $precisionstr = \"%.$Precision\".\"f\";\n\n   for( my $i = 0; $i < $seqct-1; $i++ ) {\n       # (diagonals) distance is 0 for same sequence\n       $dist{$names[$i]}->{$names[$i]} = [$i,$i];\n       $values[$i][$i] = sprintf($precisionstr,0);\n       for( my $j = $i+1; $j < $seqct; $j++ ) {\n\t   my ($scored,$match) = (0,0);\n\t   for( my $k=0; $k < $len; $k++ ) {\n\t       my $m1 = substr($seqs[$i],$k,1);\n\t       my $m2 = substr($seqs[$j],$k,1);\n\t       if( $m1 ne '-' && $m2 ne '-' ) {\n\t\t   # score is number of scored bases (alignable bases)\n\t\t   # it could have also come from \n\t\t   # my $L = $self->pairwise_stats->number_of_comparable_bases($pairwise);\n\t\t   # match is number of matches weighting ambiguity bases\n\t\t   # as well\n\t\t   $match += _check_ambiguity_protein($m1,$m2);\n\t\t   $scored++;\n\t       }\n\t   }\n\t   # From Felsenstein's PHYLIP documentation:\n\t   # This is very quick to do but has some obvious\n\t   # limitations. It does not take into account which amino\n\t   # acids differ or to what amino acids they change, so some\n\t   # information is lost. The units of the distance measure\n\t   # are fraction of amino acids differing, as also in the\n\t   # case of the PAM distance. If the fraction of amino acids\n\t   # differing gets larger than 0.8541 the distance becomes\n\t   # infinite.\n\n\t   my $D = 1 - ( $match / $scored );\n\t   if( $D < 0.8541 ) {\n\t       $D = - log ( 1 - $D - (0.2 * ($D ** 2)));\n\t       $values[$j][$i] = $values[$i][$j] = sprintf($precisionstr,$D);\n\t   } else { \n\t       $values[$j][$i] = $values[$i][$j] = '    NaN';\n\t   }\n\t   # fwd and rev lookup\n\t   $dist{$names[$i]}->{$names[$j]} = [$i,$j];\n\t   $dist{$names[$j]}->{$names[$i]} = [$i,$j];\t   \n\n           # (diagonals) distance is 0 for same sequence\n\t   $dist{$names[$j]}->{$names[$j]} = [$j,$j];\t   \n\t   $values[$j][$j] = sprintf($precisionstr,0); \n\n       }\n   }\n   return Bio::Matrix::PhylipDist->new(-program => 'bioperl_PEPstats',\n\t\t\t\t       -matrix  => \\%dist,\n\t\t\t\t       -names   => \\@names,\n\t\t\t\t       -values  => \\@values); \n   \n}\n\n# some methods from EMBOSS distmat\nsub _check_ambiguity_protein\n{\n    my ($t1,$t2) = @_;\n    my $n = 0;\n\n    if( $t1 ne 'X' && $t1 eq $t2 ) { \n        $n = 1.0;\n    } elsif(  ((($t1 eq 'B' && $t2 eq 'DN') ||\n\t       ($t2 eq 'B' && $t2 eq 'DN'))) ||\n\t      \n\t      ( ($t1 eq 'Z' && $t2 eq 'EQ') ||\n\t\t($t2 eq 'Z' && $t1 eq 'EQ'))) {\n        $n = 0.5;\n    } elsif ( $t1 eq 'X' && $t2 eq 'X' ) {\n        $n = 0.0025;\n    } elsif(  $t1 eq 'X' || $t2 eq 'X' ) {\n        $n = 0.05;\n    }\n    return $n;\n}\n\n=head2 Data Methods\n\n\n=head2 pairwise_stats\n\n Title   : pairwise_stats\n Usage   : $obj->pairwise_stats($newval)\n Function: \n Returns : value of pairwise_stats\n Args    : newvalue (optional)"},"containerName":"main::","definition":"sub"},{"name":"_check_arg","range":{"end":{"character":9999,"line":314},"start":{"character":0,"line":304}},"kind":12,"children":[{"kind":13,"line":305,"name":"$self","definition":"my","containerName":"_check_arg","localvar":"my"},{"containerName":"_check_arg","name":"$aln","kind":13,"line":305},{"kind":13,"line":306,"name":"$aln","containerName":"_check_arg"},{"line":306,"kind":13,"name":"$aln","containerName":"_check_arg"},{"kind":12,"line":306,"containerName":"_check_arg","name":"isa"},{"kind":13,"line":307,"name":"$self","containerName":"_check_arg"},{"containerName":"_check_arg","name":"warn","line":307,"kind":12},{"containerName":"_check_arg","name":"$aln","line":309,"kind":13},{"kind":12,"line":309,"containerName":"_check_arg","name":"get_seq_by_pos"},{"name":"alphabet","containerName":"_check_arg","line":309,"kind":12},{"line":310,"kind":13,"name":"$self","containerName":"_check_arg"},{"kind":12,"line":310,"name":"warn","containerName":"_check_arg"},{"kind":13,"line":310,"name":"$aln","containerName":"_check_arg"},{"kind":12,"line":310,"name":"get_seq_by_pos","containerName":"_check_arg"},{"containerName":"_check_arg","name":"alphabet","kind":12,"line":310}],"line":304,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"","label":"_check_arg($self,$aln)"},"detail":"($self,$aln)"}],"version":5}