{"version":5,"vars":[{"line":99,"kind":2,"name":"base","containerName":""},{"kind":12,"line":120,"children":[{"containerName":"add_seq","name":"$self","definition":"my","localvar":"my","kind":13,"line":121},{"line":122,"kind":13,"name":"$self","containerName":"add_seq"},{"kind":12,"line":122,"name":"throw_not_implemented","containerName":"add_seq"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.","parameters":[{"label":"$self"}],"label":"add_seq($self)"},"name":"add_seq","range":{"start":{"line":120,"character":0},"end":{"line":123,"character":9999}}},{"kind":12,"line":135,"children":[{"containerName":"remove_seq","name":"$self","definition":"my","localvar":"my","kind":13,"line":136},{"containerName":"remove_seq","name":"$self","line":137,"kind":13},{"containerName":"remove_seq","name":"throw_not_implemented","kind":12,"line":137}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"remove_seq($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object","parameters":[{"label":"$self"}]},"name":"remove_seq","range":{"start":{"line":135,"character":0},"end":{"line":138,"character":9999}}},{"range":{"start":{"line":158,"character":0},"end":{"character":9999,"line":161}},"name":"purge","children":[{"line":159,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"purge"},{"kind":13,"line":160,"containerName":"purge","name":"$self"},{"containerName":"purge","name":"throw_not_implemented","kind":12,"line":160}],"line":158,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:","label":"purge($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"detail":"($self)","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : ","parameters":[{"label":"$self"}],"label":"sort_alphabetically($self)"},"containerName":"main::","definition":"sub","line":177,"children":[{"line":178,"kind":13,"localvar":"my","containerName":"sort_alphabetically","definition":"my","name":"$self"},{"kind":13,"line":179,"name":"$self","containerName":"sort_alphabetically"},{"kind":12,"line":179,"name":"throw_not_implemented","containerName":"sort_alphabetically"}],"kind":12,"range":{"end":{"line":180,"character":9999},"start":{"character":0,"line":177}},"name":"sort_alphabetically"},{"range":{"start":{"character":0,"line":196},"end":{"line":199,"character":9999}},"name":"each_seq","line":196,"children":[{"kind":13,"line":197,"containerName":"each_seq","definition":"my","name":"$self","localvar":"my"},{"containerName":"each_seq","name":"$self","kind":13,"line":198},{"kind":12,"line":198,"name":"throw_not_implemented","containerName":"each_seq"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : ","parameters":[{"label":"$self"}],"label":"each_seq($self)"},"containerName":"main::","definition":"sub"},{"name":"each_alphabetically","range":{"end":{"line":219,"character":9999},"start":{"character":0,"line":216}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : ","label":"each_alphabetically($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"each_alphabetically","definition":"my","name":"$self","localvar":"my","kind":13,"line":217},{"containerName":"each_alphabetically","name":"$self","line":218,"kind":13},{"line":218,"kind":12,"containerName":"each_alphabetically","name":"throw_not_implemented"}],"line":216},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"each_seq_with_id($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name"},"kind":12,"line":236,"children":[{"line":237,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"each_seq_with_id"},{"name":"$self","containerName":"each_seq_with_id","kind":13,"line":238},{"containerName":"each_seq_with_id","name":"throw_not_implemented","kind":12,"line":238}],"name":"each_seq_with_id","range":{"end":{"line":239,"character":9999},"start":{"character":0,"line":236}}},{"definition":"sub","containerName":"main::","signature":{"label":"get_seq_by_pos($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"kind":13,"line":257,"name":"$self","definition":"my","containerName":"get_seq_by_pos","localvar":"my"},{"name":"$self","containerName":"get_seq_by_pos","kind":13,"line":258},{"containerName":"get_seq_by_pos","name":"throw_not_implemented","line":258,"kind":12}],"line":256,"name":"get_seq_by_pos","range":{"start":{"line":256,"character":0},"end":{"line":259,"character":9999}}},{"range":{"start":{"line":282,"character":0},"end":{"line":285,"character":9999}},"name":"select","detail":"($self)","signature":{"label":"select($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)"},"containerName":"main::","definition":"sub","line":282,"children":[{"localvar":"my","containerName":"select","definition":"my","name":"$self","line":283,"kind":13},{"containerName":"select","name":"$self","kind":13,"line":284},{"kind":12,"line":284,"containerName":"select","name":"throw_not_implemented"}],"kind":12},{"name":"select_noncont","range":{"end":{"line":306,"character":9999},"start":{"character":0,"line":303}},"kind":12,"line":303,"children":[{"kind":13,"line":304,"name":"$self","definition":"my","containerName":"select_noncont","localvar":"my"},{"containerName":"select_noncont","name":"$self","line":305,"kind":13},{"containerName":"select_noncont","name":"throw_not_implemented","line":305,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"select_noncont($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences"}},{"signature":{"label":"slice($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column "},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"slice","line":327,"kind":13},{"containerName":"slice","name":"$self","line":328,"kind":13},{"containerName":"slice","name":"throw_not_implemented","kind":12,"line":328}],"line":326,"kind":12,"range":{"end":{"character":9999,"line":329},"start":{"character":0,"line":326}},"name":"slice"},{"name":"map_chars","range":{"end":{"character":9999,"line":359},"start":{"character":0,"line":356}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string","parameters":[{"label":"$self"}],"label":"map_chars($self)"},"kind":12,"line":356,"children":[{"line":357,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"map_chars"},{"line":358,"kind":13,"containerName":"map_chars","name":"$self"},{"line":358,"kind":12,"containerName":"map_chars","name":"throw_not_implemented"}]},{"kind":12,"children":[{"line":372,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"uppercase"},{"name":"$self","containerName":"uppercase","line":373,"kind":13},{"containerName":"uppercase","name":"throw_not_implemented","kind":12,"line":373}],"line":371,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : ","parameters":[{"label":"$self"}],"label":"uppercase($self)"},"detail":"($self)","name":"uppercase","range":{"start":{"line":371,"character":0},"end":{"line":374,"character":9999}}},{"detail":"($self)","signature":{"label":"match_line($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)"},"containerName":"main::","definition":"sub","line":388,"children":[{"kind":13,"line":389,"definition":"my","name":"$self","containerName":"match_line","localvar":"my"},{"kind":13,"line":390,"containerName":"match_line","name":"$self"},{"kind":12,"line":390,"name":"throw_not_implemented","containerName":"match_line"}],"kind":12,"range":{"start":{"character":0,"line":388},"end":{"character":9999,"line":391}},"name":"match_line"},{"signature":{"label":"match($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":414,"containerName":"match","definition":"my","name":"$self","localvar":"my"},{"containerName":"match","name":"$self","kind":13,"line":415},{"line":415,"kind":12,"name":"throw_not_implemented","containerName":"match"}],"line":413,"kind":12,"range":{"start":{"line":413,"character":0},"end":{"line":416,"character":9999}},"name":"match"},{"name":"unmatch","range":{"end":{"line":434,"character":9999},"start":{"line":431,"character":0}},"kind":12,"line":431,"children":[{"name":"$self","definition":"my","containerName":"unmatch","localvar":"my","kind":13,"line":432},{"name":"$self","containerName":"unmatch","kind":13,"line":433},{"kind":12,"line":433,"name":"throw_not_implemented","containerName":"unmatch"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"unmatch($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'"}},{"kind":12,"children":[{"kind":13,"line":456,"containerName":"id","name":"$self","definition":"my","localvar":"my"},{"containerName":"id","name":"$self","kind":13,"line":457},{"containerName":"id","name":"throw_not_implemented","kind":12,"line":457}],"line":455,"definition":"sub","containerName":"main::","signature":{"label":"id($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)","parameters":[{"label":"$self"}]},"detail":"($self)","name":"id","range":{"start":{"character":0,"line":455},"end":{"line":458,"character":9999}}},{"signature":{"label":"missing_char($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"containerName":"missing_char","definition":"my","name":"$self","localvar":"my","kind":13,"line":473},{"containerName":"missing_char","name":"$self","line":474,"kind":13},{"name":"throw_not_implemented","containerName":"missing_char","kind":12,"line":474}],"line":472,"kind":12,"range":{"start":{"character":0,"line":472},"end":{"character":9999,"line":475}},"name":"missing_char"},{"name":"match_char","range":{"end":{"character":9999,"line":490},"start":{"character":0,"line":487}},"kind":12,"line":487,"children":[{"containerName":"match_char","definition":"my","name":"$self","localvar":"my","kind":13,"line":488},{"line":489,"kind":13,"containerName":"match_char","name":"$self"},{"line":489,"kind":12,"name":"throw_not_implemented","containerName":"match_char"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)","label":"match_char($self)"}},{"name":"gap_char","range":{"end":{"character":9999,"line":505},"start":{"character":0,"line":502}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)","label":"gap_char($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"gap_char","name":"$self","definition":"my","localvar":"my","kind":13,"line":503},{"line":504,"kind":13,"name":"$self","containerName":"gap_char"},{"kind":12,"line":504,"containerName":"gap_char","name":"throw_not_implemented"}],"line":502},{"range":{"start":{"line":517,"character":0},"end":{"line":520,"character":9999}},"name":"symbol_chars","signature":{"label":"symbol_chars($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":518,"kind":13,"localvar":"my","containerName":"symbol_chars","name":"$self","definition":"my"},{"kind":13,"line":519,"name":"$self","containerName":"symbol_chars"},{"containerName":"symbol_chars","name":"throw_not_implemented","kind":12,"line":519}],"line":517,"kind":12},{"range":{"end":{"line":544,"character":9999},"start":{"line":541,"character":0}},"name":"consensus_string","line":541,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"consensus_string","line":542,"kind":13},{"name":"$self","containerName":"consensus_string","kind":13,"line":543},{"containerName":"consensus_string","name":"throw_not_implemented","kind":12,"line":543}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)","label":"consensus_string($self)"},"containerName":"main::","definition":"sub"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"consensus_iupac($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences","parameters":[{"label":"$self"}]},"kind":12,"line":568,"children":[{"line":569,"kind":13,"localvar":"my","containerName":"consensus_iupac","name":"$self","definition":"my"},{"kind":13,"line":570,"name":"$self","containerName":"consensus_iupac"},{"name":"throw_not_implemented","containerName":"consensus_iupac","line":570,"kind":12}],"name":"consensus_iupac","range":{"end":{"character":9999,"line":571},"start":{"line":568,"character":0}}},{"name":"is_flush","range":{"end":{"line":591,"character":9999},"start":{"line":588,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : ","label":"is_flush($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"is_flush","name":"$self","definition":"my","localvar":"my","kind":13,"line":589},{"name":"$self","containerName":"is_flush","kind":13,"line":590},{"containerName":"is_flush","name":"throw_not_implemented","kind":12,"line":590}],"line":588},{"signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : ","parameters":[{"label":"$self"}],"label":"length($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":605,"kind":13,"localvar":"my","containerName":"length","definition":"my","name":"$self"},{"line":606,"kind":13,"containerName":"length","name":"$self"},{"name":"throw_not_implemented","containerName":"length","kind":12,"line":606}],"line":604,"kind":12,"range":{"end":{"character":9999,"line":607},"start":{"line":604,"character":0}},"name":"length"},{"name":"maxname_length","range":{"start":{"character":0,"line":623},"end":{"line":626,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : ","label":"maxname_length($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"maxname_length","definition":"my","name":"$self","localvar":"my","kind":13,"line":624},{"name":"$self","containerName":"maxname_length","line":625,"kind":13},{"line":625,"kind":12,"name":"throw_not_implemented","containerName":"maxname_length"}],"line":623},{"kind":12,"line":639,"children":[{"line":640,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"num_residues"},{"containerName":"num_residues","name":"$self","kind":13,"line":641},{"kind":12,"line":641,"name":"throw_not_implemented","containerName":"num_residues"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues","label":"num_residues($self)"},"name":"num_residues","range":{"end":{"character":9999,"line":642},"start":{"line":639,"character":0}}},{"name":"num_sequences","range":{"start":{"character":0,"line":655},"end":{"character":9999,"line":658}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"num_sequences","localvar":"my","kind":13,"line":656},{"containerName":"num_sequences","name":"$self","line":657,"kind":13},{"kind":12,"line":657,"name":"throw_not_implemented","containerName":"num_sequences"}],"line":655,"definition":"sub","containerName":"main::","signature":{"label":"num_sequences($self)","documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences","parameters":[{"label":"$self"}]},"detail":"($self)"},{"name":"percentage_identity","range":{"end":{"character":9999,"line":674},"start":{"line":671,"character":0}},"kind":12,"line":671,"children":[{"kind":13,"line":672,"containerName":"percentage_identity","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":673,"containerName":"percentage_identity","name":"$self"},{"name":"throw_not_implemented","containerName":"percentage_identity","line":673,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None","label":"percentage_identity($self)"}},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None","label":"overall_percentage_identity($self)"},"detail":"($self)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"overall_percentage_identity","localvar":"my","kind":13,"line":688},{"kind":13,"line":689,"name":"$self","containerName":"overall_percentage_identity"},{"kind":12,"line":689,"containerName":"overall_percentage_identity","name":"throw_not_implemented"}],"line":687,"name":"overall_percentage_identity","range":{"end":{"line":690,"character":9999},"start":{"character":0,"line":687}}},{"range":{"start":{"line":704,"character":0},"end":{"character":9999,"line":707}},"name":"average_percentage_identity","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None","label":"average_percentage_identity($self)"},"containerName":"main::","definition":"sub","line":704,"children":[{"localvar":"my","containerName":"average_percentage_identity","name":"$self","definition":"my","line":705,"kind":13},{"kind":13,"line":706,"containerName":"average_percentage_identity","name":"$self"},{"name":"throw_not_implemented","containerName":"average_percentage_identity","line":706,"kind":12}],"kind":12},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"column_from_residue_number","localvar":"my","kind":13,"line":758},{"name":"$self","containerName":"column_from_residue_number","kind":13,"line":759},{"containerName":"column_from_residue_number","name":"throw_not_implemented","kind":12,"line":759}],"line":757,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)","parameters":[{"label":"$self"}],"label":"column_from_residue_number($self)"},"detail":"($self)","name":"column_from_residue_number","range":{"start":{"line":757,"character":0},"end":{"line":760,"character":9999}}},{"name":"displayname","range":{"start":{"character":0,"line":780},"end":{"character":9999,"line":783}},"kind":12,"children":[{"kind":13,"line":781,"containerName":"displayname","name":"$self","definition":"my","localvar":"my"},{"containerName":"displayname","name":"$self","kind":13,"line":782},{"containerName":"displayname","name":"throw_not_implemented","line":782,"kind":12}],"line":780,"definition":"sub","containerName":"main::","signature":{"label":"displayname($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence names\n\nMethods to manipulate the display name. The default name based on the\nsequence id and subsequence positions can be overridden in various\nways.\n\n=head2 displayname\n\n Title     : displayname\n Usage     : $myalign->displayname(\"Ig\", \"IgA\")\n Function  : Gets/sets the display name of a sequence in the alignment\n           :\n Returns   : A display name string\n Argument  : name of the sequence\n             displayname of the sequence (optional)"},"detail":"($self)"},{"kind":12,"line":799,"children":[{"line":800,"kind":13,"localvar":"my","containerName":"set_displayname_count","definition":"my","name":"$self"},{"containerName":"set_displayname_count","name":"$self","kind":13,"line":801},{"containerName":"set_displayname_count","name":"throw_not_implemented","kind":12,"line":801}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence names\n\nMethods to manipulate the display name. The default name based on the\nsequence id and subsequence positions can be overridden in various\nways.\n\n=head2 displayname\n\n Title     : displayname\n Usage     : $myalign->displayname(\"Ig\", \"IgA\")\n Function  : Gets/sets the display name of a sequence in the alignment\n           :\n Returns   : A display name string\n Argument  : name of the sequence\n             displayname of the sequence (optional)\n\n\nsub displayname {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_count\n\n Title     : set_displayname_count\n Usage     : $ali->set_displayname_count\n Function  : \n\n             Sets the names to be name_# where # is the number of\n             times this name has been used.\n\n Returns   : None \n Argument  : None","parameters":[{"label":"$self"}],"label":"set_displayname_count($self)"},"name":"set_displayname_count","range":{"start":{"character":0,"line":799},"end":{"character":9999,"line":802}}},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"set_displayname_flat","line":816,"kind":13},{"line":817,"kind":13,"name":"$self","containerName":"set_displayname_flat"},{"containerName":"set_displayname_flat","name":"throw_not_implemented","kind":12,"line":817}],"line":815,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence names\n\nMethods to manipulate the display name. The default name based on the\nsequence id and subsequence positions can be overridden in various\nways.\n\n=head2 displayname\n\n Title     : displayname\n Usage     : $myalign->displayname(\"Ig\", \"IgA\")\n Function  : Gets/sets the display name of a sequence in the alignment\n           :\n Returns   : A display name string\n Argument  : name of the sequence\n             displayname of the sequence (optional)\n\n\nsub displayname {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_count\n\n Title     : set_displayname_count\n Usage     : $ali->set_displayname_count\n Function  : \n\n             Sets the names to be name_# where # is the number of\n             times this name has been used.\n\n Returns   : None \n Argument  : None\n\n\nsub set_displayname_count {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_flat\n\n Title     : set_displayname_flat\n Usage     : $ali->set_displayname_flat()\n Function  : Makes all the sequences be displayed as just their name,\n             not name/start-end\n Returns   : 1\n Argument  : None","parameters":[{"label":"$self"}],"label":"set_displayname_flat($self)"},"detail":"($self)","name":"set_displayname_flat","range":{"start":{"character":0,"line":815},"end":{"line":818,"character":9999}}},{"range":{"end":{"line":833,"character":9999},"start":{"line":830,"character":0}},"name":"set_displayname_normal","signature":{"label":"set_displayname_normal($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AlignI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::AlignI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::AlignI - An interface for describing sequence alignments.\n\n=head1 SYNOPSIS\n\n  # get a Bio::Align::AlignI somehow - typically using Bio::AlignIO system\n  # some descriptors\n  print $aln->length, \"\\n\";\n  print $aln->num_residues, \"\\n\";\n  print $aln->is_flush, \"\\n\";\n  print $aln->num_sequences, \"\\n\";\n  print $aln->percentage_identity, \"\\n\";\n  print $aln->consensus_string(50), \"\\n\";\n\n  # find the position in the alignment for a sequence location\n  $pos = $aln->column_from_residue_number('1433_LYCES', 14); # = 6;\n\n  # extract sequences and check values for the alignment column $pos\n  foreach $seq ($aln->each_seq) {\n      $res = $seq->subseq($pos, $pos);\n      $count{$res}++;\n  }\n  foreach $res (keys %count) {\n      printf \"Res: %s  Count: %2d\\n\", $res, $count{$res};\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basis for alignment objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::AlignI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head1 Modifier methods\n\nThese methods modify the MSE by adding, removing or shuffling complete\nsequences.\n\n=head2 add_seq\n\n Title     : add_seq\n Usage     : $myalign->add_seq($newseq);\n Function  : Adds another sequence to the alignment. *Does not* align\n             it - just adds it to the hashes.\n Returns   : None\n Argument  : a Bio::LocatableSeq object\n             order (optional)\n\nSee L<Bio::LocatableSeq> for more information.\n\n\nsub add_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 remove_seq\n\n Title     : remove_seq\n Usage     : $aln->remove_seq($seq);\n Function  : Removes a single sequence from an alignment\n Returns   :\n Argument  : a Bio::LocatableSeq object\n\n\nsub remove_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 purge\n\n Title   : purge\n Usage   : $aln->purge(0.7);\n Function:\n\n           Removes sequences above whatever %id.\n\n           This function will grind on large alignments. Beware!\n           (perhaps not ideally implemented)\n\n Example :\n Returns : An array of the removed sequences\n Argument:\n\n\n\nsub purge {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 sort_alphabetically\n\n Title     : sort_alphabetically\n Usage     : $ali->sort_alphabetically\n Function  : \n\n             Changes the order of the alignment to alphabetical on name \n             followed by numerical by number.\n\n Returns   : an array\n Argument  : \n\n\nsub sort_alphabetically {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence selection methods\n\nMethods returning one or more sequences objects.\n\n=head2 each_seq\n\n Title     : each_seq\n Usage     : foreach $seq ( $align->each_seq() ) \n Function  : Gets an array of Seq objects from the alignment\n Returns   : an array\n Argument  : \n\n\nsub each_seq {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_alphabetically\n\n Title     : each_alphabetically\n Usage     : foreach $seq ( $ali->each_alphabetically() )\n Function  :\n\n             Returns an array of sequence object sorted alphabetically \n             by name and then by start point.\n             Does not change the order of the alignment\n\n Returns   : \n Argument  : \n\n\nsub each_alphabetically {\n    my($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 each_seq_with_id\n\n Title     : each_seq_with_id\n Usage     : foreach $seq ( $align->each_seq_with_id() ) \n Function  : \n\n             Gets an array of Seq objects from the\n             alignment, the contents being those sequences\n             with the given name (there may be more than one)\n\n Returns   : an array\n Argument  : a seq name\n\n\nsub each_seq_with_id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_seq_by_pos\n\n Title     : get_seq_by_pos\n Usage     : $seq = $aln->get_seq_by_pos(3) # third sequence from the alignment\n Function  : \n\n             Gets a sequence based on its position in the alignment.\n             Numbering starts from 1.  Sequence positions larger than\n             num_sequences() will throw an error.\n\n Returns   : a Bio::LocatableSeq object\n Argument  : positive integer for the sequence position\n\n\nsub get_seq_by_pos {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Create new alignments\n\nThe result of these methods are horizontal or vertical subsets of the\ncurrent MSE.\n\n=head2 select\n\n Title     : select\n Usage     : $aln2 = $aln->select(1, 3) # three first sequences\n Function  : \n\n             Creates a new alignment from a continuous subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for the first sequence\n             positive integer for the last sequence to include (optional)\n\n\nsub select {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 select_noncont\n\n Title     : select_noncont\n Usage     : $aln2 = $aln->select_noncont(1, 3) # first and 3rd sequences\n Function  : \n\n             Creates a new alignment from a subset of\n             sequences.  Numbering starts from 1.  Sequence positions\n             larger than num_sequences() will throw an error.\n\n Returns   : a Bio::SimpleAlign object\n Args      : array of integers for the sequences\n\n\nsub select_noncont {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 slice\n\n Title     : slice\n Usage     : $aln2 = $aln->slice(20, 30)\n Function  : \n\n             Creates a slice from the alignment inclusive of start and\n             end columns.  Sequences with no residues in the slice are\n             excluded from the new alignment and a warning is printed.\n             Slice beyond the length of the sequence does not do\n             padding.\n\n Returns   : a Bio::SimpleAlign object\n Argument  : positive integer for start column \n             positive integer for end column \n\n\nsub slice {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Change sequences within the MSE\n\nThese methods affect characters in all sequences without changing the\nalignment.\n\n\n=head2 map_chars\n\n Title     : map_chars\n Usage     : $ali->map_chars('\\.','-')\n Function  : \n\n             Does a s/$arg1/$arg2/ on the sequences. Useful for gap\n             characters\n\n             Notice that the from (arg1) is interpreted as a regex,\n             so be careful about quoting meta characters (eg\n             $ali->map_chars('.','-') wont do what you want)\n\n Returns   : None\n Argument  : 'from' rexexp\n             'to' string\n\n\nsub map_chars {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 uppercase\n\n Title     : uppercase()\n Usage     : $ali->uppercase()\n Function  : Sets all the sequences to uppercase\n Returns   : \n Argument  : \n\n\nsub uppercase {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_line\n\n Title    : match_line()\n Usage    : $align->match_line()\n Function : Generates a match line - much like consensus string\n            except that a line indicating the '*' for a match.\n Argument : (optional) Match line characters ('*' by default)\n            (optional) Strong match char (':' by default)\n            (optional) Weak match char ('.' by default)\n\n\nsub match_line {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match\n\n Title     : match()\n Usage     : $ali->match()\n Function  : \n\n             Goes through all columns and changes residues that are\n             identical to residue in first sequence to match '.'\n             character. Sets match_char.\n\n             USE WITH CARE: Most MSE formats do not support match\n             characters in sequences, so this is mostly for output\n             only. NEXUS format (Bio::AlignIO::nexus) can handle\n             it.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub match {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 unmatch\n\n Title     : unmatch()\n Usage     : $ali->unmatch()\n Function  : \n\n             Undoes the effect of method match. Unsets match_char.\n\n Returns   : 1\n Argument  : a match character, optional, defaults to '.'\n\n\nsub unmatch {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head1 MSE attibutes\n\nMethods for setting and reading the MSE attributes. \n\nNote that the methods defining character semantics depend on the user\nto set them sensibly.  They are needed only by certain input/output\nmethods. Unset them by setting to an empty string ('').\n\n=head2 id\n\n Title     : id\n Usage     : $myalign->id(\"Ig\")\n Function  : Gets/sets the id field of the alignment\n Returns   : An id string\n Argument  : An id string (optional)\n\n\nsub id {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 missing_char\n\n Title     : missing_char\n Usage     : $myalign->missing_char(\"?\")\n Function  : Gets/sets the missing_char attribute of the alignment\n             It is generally recommended to set it to 'n' or 'N' \n             for nucleotides and to 'X' for protein. \n Returns   : An missing_char string,\n Argument  : An missing_char string (optional)\n\n\nsub missing_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 match_char\n\n Title     : match_char\n Usage     : $myalign->match_char('.')\n Function  : Gets/sets the match_char attribute of the alignment\n Returns   : An match_char string,\n Argument  : An match_char string (optional)\n\n\nsub match_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 gap_char\n\n Title     : gap_char\n Usage     : $myalign->gap_char('-')\n Function  : Gets/sets the gap_char attribute of the alignment\n Returns   : An gap_char string, defaults to '-'\n Argument  : An gap_char string (optional)\n\n\nsub gap_char {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 symbol_chars\n\n Title   : symbol_chars\n Usage   : my @symbolchars = $aln->symbol_chars;\n Function: Returns all the seen symbols (other than gaps)\n Returns : array of characters that are the seen symbols\n Argument: boolean to include the gap/missing/match characters\n\n\nsub symbol_chars{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment descriptors\n\nThese read only methods describe the MSE in various ways. \n\n\n=head2 consensus_string\n\n Title     : consensus_string\n Usage     : $str = $ali->consensus_string($threshold_percent)\n Function  : Makes a strict consensus \n Returns   : consensus string\n Argument  : Optional threshold ranging from 0 to 100.\n             The consensus residue has to appear at least threshold %\n             of the sequences at a given location, otherwise a '?'\n             character will be placed at that location.\n             (Default value = 0%)\n\n\nsub consensus_string {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 consensus_iupac\n\n Title     : consensus_iupac\n Usage     : $str = $ali->consensus_iupac()\n Function  : \n\n             Makes a consensus using IUPAC ambiguity codes from DNA\n             and RNA. The output is in upper case except when gaps in\n             a column force output to be in lower case.\n\n             Note that if your alignment sequences contain a lot of\n             IUPAC ambiquity codes you often have to manually set\n             alphabet.  Bio::PrimarySeq::_guess_type thinks they\n             indicate a protein sequence.\n\n Returns   : consensus string\n Argument  : none\n Throws    : on protein sequences\n\n\n\nsub consensus_iupac {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 is_flush\n\n Title     : is_flush\n Usage     : if( $ali->is_flush() )\n           : \n           :\n Function  : Tells you whether the alignment \n           : is flush, ie all of the same length\n           : \n           :\n Returns   : 1 or 0\n Argument  : \n\n\nsub is_flush {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 length\n\n Title     : length()\n Usage     : $len = $ali->length() \n Function  : Returns the maximum length of the alignment.\n             To be sure the alignment is a block, use is_flush\n Returns   : integer\n Argument  : \n\n\nsub length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 maxname_length\n\n Title     : maxname_length\n Usage     : $ali->maxname_length()\n Function  : \n\n             Gets the maximum length of the displayname in the\n             alignment. Used in writing out various MSE formats.\n\n Returns   : integer\n Argument  : \n\n\nsub maxname_length {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_residues\n\n Title     : num_residues\n Usage     : $no = $ali->num_residues\n Function  : number of residues in total in the alignment\n Returns   : integer\n Argument  :\n Note      : replaces no_residues\n\n\nsub num_residues {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 num_sequences\n\n Title     : num_sequences\n Usage     : $depth = $ali->num_sequences\n Function  : number of sequence in the sequence alignment\n Returns   : integer\n Argument  : None\n Note      : replaces no_sequences\n\n\nsub num_sequences {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 percentage_identity\n\n Title   : percentage_identity\n Usage   : $id = $align->percentage_identity\n Function: The function calculates the percentage identity of the alignment\n Returns : The percentage identity of the alignment (as defined by the \n\t   implementation)\n Argument: None\n\n\nsub percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 overall_percentage_identity\n\n Title   : overall_percentage_identity\n Usage   : $id = $align->overall_percentage_identity\n Function: The function calculates the percentage identity of \n           the conserved columns\n Returns : The percentage identity of the conserved columns\n Args    : None\n\n\nsub overall_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 average_percentage_identity\n\n Title   : average_percentage_identity\n Usage   : $id = $align->average_percentage_identity\n Function: The function uses a fast method to calculate the average \n           percentage identity of the alignment\n Returns : The average percentage identity of the alignment\n Args    : None\n\n\nsub average_percentage_identity{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Alignment positions\n\nMethods to map a sequence position into an alignment column and back.\ncolumn_from_residue_number() does the former. The latter is really a\nproperty of the sequence object and can done using\nL<Bio::LocatableSeq::location_from_column>:\n\n    # select somehow a sequence from the alignment, e.g.\n    my $seq = $aln->get_seq_by_pos(1);\n    #$loc is undef or Bio::LocationI object\n    my $loc = $seq->location_from_column(5);\n\n\n=head2 column_from_residue_number\n\n Title   : column_from_residue_number\n Usage   : $col = $ali->column_from_residue_number( $seqname, $resnumber)\n Function:\n\n           This function gives the position in the alignment\n           (i.e. column number) of the given residue number in the\n           sequence with the given name. For example, for the\n           alignment\n\n  \t     Seq1/91-97 AC..DEF.GH\n  \t     Seq2/24-30 ACGG.RTY..\n  \t     Seq3/43-51 AC.DDEFGHI\n\n           column_from_residue_number( \"Seq1\", 94 ) returns 6.\n           column_from_residue_number( \"Seq2\", 25 ) returns 2.\n           column_from_residue_number( \"Seq3\", 50 ) returns 9.\n\n           An exception is thrown if the residue number would lie\n           outside the length of the alignment\n           (e.g. column_from_residue_number( \"Seq2\", 22 )\n\n\t  Note: If the parent sequence is represented by more than one\n\t  alignment sequence and the residue number is present in\n\t  them, this method finds only the first one.\n\n Returns : A column number for the position in the alignment of the\n           given residue in the given sequence (1 = first column)\n Args    : A sequence id/name (not a name/start-end)\n           A residue number in the whole sequence (not just that\n           segment of it in the alignment)\n\n\nsub column_from_residue_number {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head1 Sequence names\n\nMethods to manipulate the display name. The default name based on the\nsequence id and subsequence positions can be overridden in various\nways.\n\n=head2 displayname\n\n Title     : displayname\n Usage     : $myalign->displayname(\"Ig\", \"IgA\")\n Function  : Gets/sets the display name of a sequence in the alignment\n           :\n Returns   : A display name string\n Argument  : name of the sequence\n             displayname of the sequence (optional)\n\n\nsub displayname {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_count\n\n Title     : set_displayname_count\n Usage     : $ali->set_displayname_count\n Function  : \n\n             Sets the names to be name_# where # is the number of\n             times this name has been used.\n\n Returns   : None \n Argument  : None\n\n\nsub set_displayname_count {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_flat\n\n Title     : set_displayname_flat\n Usage     : $ali->set_displayname_flat()\n Function  : Makes all the sequences be displayed as just their name,\n             not name/start-end\n Returns   : 1\n Argument  : None\n\n\nsub set_displayname_flat {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 set_displayname_normal\n\n Title     : set_displayname_normal\n Usage     : $ali->set_displayname_normal() \n Function  : Makes all the sequences be displayed as name/start-end\n Returns   : None\n Argument  : None"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":831,"containerName":"set_displayname_normal","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":832,"containerName":"set_displayname_normal","name":"$self"},{"kind":12,"line":832,"name":"throw_not_implemented","containerName":"set_displayname_normal"}],"line":830,"kind":12},{"children":[{"containerName":"no_residues","name":"deprecated","kind":12,"line":850}],"line":848,"kind":12,"range":{"end":{"character":9999,"line":851},"start":{"line":848,"character":0}},"definition":"sub","name":"no_residues","containerName":"main::"},{"kind":12,"line":864,"children":[{"name":"deprecated","containerName":"no_sequences","line":866,"kind":12}],"containerName":"main::","definition":"sub","name":"no_sequences","range":{"end":{"line":867,"character":9999},"start":{"line":864,"character":0}}}]}