{"vars":[{"name":"vars","containerName":"","kind":2,"line":4},{"line":5,"name":"$VERSION","kind":13,"containerName":null},{"definition":"my","line":15,"localvar":"my","kind":13,"containerName":null,"name":"$YES"},{"line":15,"name":"Results","kind":2,"containerName":"Config::Test::Harness::Assert::Test::Harness::Iterator::Test::Harness::Point::Test::Harness"},{"line":16,"name":"$NO","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$YES","containerName":null,"kind":13,"line":16},{"kind":12,"range":{"end":{"line":74,"character":9999},"start":{"character":0,"line":67}},"line":67,"containerName":"main::","name":"new","children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":68},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":69,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":69},{"line":71,"kind":13,"containerName":"new","name":"$self"},{"line":71,"name":"_init","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":73}],"definition":"sub"},{"range":{"end":{"character":9999,"line":90},"start":{"line":84,"character":0}},"kind":12,"line":84,"name":"_init","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_init","name":"$self","line":85},{"line":87,"kind":13,"containerName":"_init","name":"$self"},{"line":88,"containerName":"_init","kind":13,"name":"$self"},{"line":89,"name":"$self","containerName":"_init","kind":13}],"definition":"sub"},{"name":"_is_vms","kind":12,"line":87},{"kind":12,"name":"_is_win32","line":88},{"name":"_is_macos","kind":12,"line":89},{"name":"analyze","containerName":"main::","children":[{"line":108,"kind":13,"localvar":"my","containerName":"analyze","name":"$self","definition":"my"},{"name":"$name","kind":13,"containerName":"analyze","line":108},{"containerName":"analyze","kind":13,"name":"$test_output","line":108},{"definition":"my","line":110,"localvar":"my","containerName":"analyze","kind":13,"name":"$it"},{"line":110,"kind":12,"containerName":"analyze","name":"new"},{"line":110,"containerName":"analyze","kind":13,"name":"$test_output"},{"containerName":"analyze","kind":13,"name":"$self","line":111},{"name":"_analyze_iterator","kind":12,"containerName":"analyze","line":111},{"line":111,"name":"$name","kind":13,"containerName":"analyze"},{"line":111,"kind":13,"containerName":"analyze","name":"$it"}],"detail":"($self,$name,$test_output)","definition":"sub","range":{"start":{"line":107,"character":0},"end":{"character":9999,"line":112}},"kind":12,"line":107,"signature":{"documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$test_output"}],"label":"analyze($self,$name,$test_output)"}},{"name":"Test","containerName":"Harness::Iterator","kind":12,"line":110},{"detail":"($self,$name,$it)","definition":"sub","name":"_analyze_iterator","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_analyze_iterator","line":116,"definition":"my"},{"containerName":"_analyze_iterator","kind":13,"name":"$name","line":116},{"line":116,"name":"$it","kind":13,"containerName":"_analyze_iterator"},{"line":118,"containerName":"_analyze_iterator","kind":13,"name":"$self"},{"name":"_reset_file_state","containerName":"_analyze_iterator","kind":12,"line":118},{"line":119,"containerName":"_analyze_iterator","kind":13,"name":"$self"},{"name":"$name","containerName":"_analyze_iterator","kind":13,"line":119},{"line":121,"kind":13,"localvar":"my","containerName":"_analyze_iterator","name":"$results","definition":"my"},{"name":"new","containerName":"_analyze_iterator","kind":12,"line":121},{"kind":13,"containerName":"_analyze_iterator","name":"$self","line":124},{"kind":13,"containerName":"_analyze_iterator","name":"$name","line":124},{"line":124,"containerName":"_analyze_iterator","kind":13,"name":"$results"},{"definition":"my","line":125,"localvar":"my","kind":13,"containerName":"_analyze_iterator","name":"$line"},{"containerName":"_analyze_iterator","kind":13,"name":"$it","line":125},{"name":"next","kind":12,"containerName":"_analyze_iterator","line":125},{"line":126,"containerName":"_analyze_iterator","kind":13,"name":"$self"},{"line":126,"containerName":"_analyze_iterator","kind":12,"name":"_analyze_line"},{"containerName":"_analyze_iterator","kind":13,"name":"$line","line":126},{"line":126,"containerName":"_analyze_iterator","kind":13,"name":"$results"},{"containerName":"_analyze_iterator","kind":13,"name":"$self","line":127},{"name":"$results","kind":13,"containerName":"_analyze_iterator","line":130},{"line":130,"kind":12,"containerName":"_analyze_iterator","name":"set_skip_all"},{"line":130,"containerName":"_analyze_iterator","kind":13,"name":"$self"},{"line":130,"kind":13,"containerName":"_analyze_iterator","name":"$self"},{"definition":"my","line":132,"localvar":"my","containerName":"_analyze_iterator","kind":13,"name":"$passed"},{"line":133,"name":"$results","containerName":"_analyze_iterator","kind":13},{"line":133,"name":"max","containerName":"_analyze_iterator","kind":12},{"line":133,"containerName":"_analyze_iterator","kind":13,"name":"$results"},{"line":133,"containerName":"_analyze_iterator","kind":12,"name":"skip_all"},{"kind":13,"containerName":"_analyze_iterator","name":"$results","line":134},{"name":"max","containerName":"_analyze_iterator","kind":12,"line":134},{"line":135,"name":"$results","containerName":"_analyze_iterator","kind":13},{"line":135,"name":"seen","kind":12,"containerName":"_analyze_iterator"},{"line":136,"containerName":"_analyze_iterator","kind":13,"name":"$results"},{"line":136,"name":"max","kind":12,"containerName":"_analyze_iterator"},{"line":136,"name":"$results","kind":13,"containerName":"_analyze_iterator"},{"line":136,"containerName":"_analyze_iterator","kind":12,"name":"seen"},{"kind":13,"containerName":"_analyze_iterator","name":"$results","line":137},{"kind":12,"containerName":"_analyze_iterator","name":"max","line":137},{"containerName":"_analyze_iterator","kind":13,"name":"$results","line":137},{"line":137,"containerName":"_analyze_iterator","kind":12,"name":"ok"},{"containerName":"_analyze_iterator","kind":13,"name":"$results","line":139},{"kind":12,"containerName":"_analyze_iterator","name":"set_passing","line":139},{"kind":13,"containerName":"_analyze_iterator","name":"$passed","line":139},{"line":141,"name":"$results","containerName":"_analyze_iterator","kind":13}],"signature":{"label":"_analyze_iterator($self,$name,$it)","documentation":"","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$it"}]},"range":{"start":{"line":115,"character":0},"end":{"line":142,"character":9999}},"kind":12,"line":115},{"line":119,"name":"file","kind":12},{"name":"Test","containerName":"Harness::Results","kind":12,"line":121},{"line":124,"name":"totals","kind":12},{"line":127,"kind":12,"name":"saw_bailout"},{"line":130,"name":"skip_all","kind":12},{"line":130,"name":"skip_all","kind":12},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_analyze_line","line":146,"definition":"my"},{"definition":"my","line":147,"localvar":"my","kind":13,"containerName":"_analyze_line","name":"$line"},{"definition":"my","name":"$results","kind":13,"localvar":"my","containerName":"_analyze_line","line":148},{"line":150,"containerName":"_analyze_line","kind":13,"name":"$self"},{"definition":"my","line":152,"name":"$linetype","kind":13,"localvar":"my","containerName":"_analyze_line"},{"definition":"my","localvar":"my","kind":13,"containerName":"_analyze_line","name":"$point","line":153},{"name":"from_test_line","kind":12,"containerName":"_analyze_line","line":153},{"containerName":"_analyze_line","kind":13,"name":"$line","line":153},{"line":154,"kind":13,"containerName":"_analyze_line","name":"$point"},{"kind":13,"containerName":"_analyze_line","name":"$linetype","line":155},{"line":157,"containerName":"_analyze_line","kind":13,"name":"$results"},{"line":157,"containerName":"_analyze_line","kind":12,"name":"inc_seen"},{"line":158,"name":"$point","containerName":"_analyze_line","kind":13},{"name":"set_number","containerName":"_analyze_line","kind":12,"line":158},{"name":"$self","kind":13,"containerName":"_analyze_line","line":158},{"kind":13,"containerName":"_analyze_line","name":"$point","line":158},{"line":158,"containerName":"_analyze_line","kind":12,"name":"number"},{"containerName":"_analyze_line","kind":13,"name":"$self","line":164},{"line":164,"name":"$self","kind":13,"containerName":"_analyze_line"},{"name":"$self","kind":13,"containerName":"_analyze_line","line":164},{"line":165,"name":"$point","containerName":"_analyze_line","kind":13},{"line":165,"kind":12,"containerName":"_analyze_line","name":"set_ok"},{"name":"$self","containerName":"_analyze_line","kind":13,"line":168},{"line":168,"containerName":"_analyze_line","kind":13,"name":"$point"},{"name":"number","kind":12,"containerName":"_analyze_line","line":168},{"line":169,"name":"$point","containerName":"_analyze_line","kind":13},{"name":"set_directive_type","containerName":"_analyze_line","kind":12,"line":169},{"line":172,"name":"$point","containerName":"_analyze_line","kind":13},{"containerName":"_analyze_line","kind":12,"name":"is_todo","line":172},{"line":173,"name":"$results","containerName":"_analyze_line","kind":13},{"line":173,"kind":12,"containerName":"_analyze_line","name":"inc_todo"},{"kind":13,"containerName":"_analyze_line","name":"$results","line":174},{"containerName":"_analyze_line","kind":12,"name":"inc_bonus","line":174},{"line":174,"name":"$point","kind":13,"containerName":"_analyze_line"},{"containerName":"_analyze_line","kind":12,"name":"ok","line":174},{"name":"$point","containerName":"_analyze_line","kind":13,"line":176},{"containerName":"_analyze_line","kind":12,"name":"is_skip","line":176},{"name":"$results","containerName":"_analyze_line","kind":13,"line":177},{"containerName":"_analyze_line","kind":12,"name":"inc_skip","line":177},{"line":180,"containerName":"_analyze_line","kind":13,"name":"$results"},{"line":180,"kind":12,"containerName":"_analyze_line","name":"inc_ok"},{"line":180,"name":"$point","containerName":"_analyze_line","kind":13},{"containerName":"_analyze_line","kind":12,"name":"pass","line":180},{"line":182,"name":"$point","kind":13,"containerName":"_analyze_line"},{"line":182,"containerName":"_analyze_line","kind":12,"name":"number"},{"name":"$point","kind":13,"containerName":"_analyze_line","line":182},{"line":182,"kind":12,"containerName":"_analyze_line","name":"number"},{"containerName":"_analyze_line","kind":13,"name":"$self","line":182},{"kind":13,"containerName":"_analyze_line","name":"$self","line":183},{"name":"$point","kind":13,"containerName":"_analyze_line","line":184},{"containerName":"_analyze_line","kind":12,"name":"number","line":184},{"localvar":"my","containerName":"_analyze_line","kind":13,"name":"$details","line":189,"definition":"my"},{"line":190,"name":"$point","kind":13,"containerName":"_analyze_line"},{"line":190,"name":"pass","kind":12,"containerName":"_analyze_line"},{"line":191,"containerName":"_analyze_line","kind":13,"name":"$point"},{"name":"ok","containerName":"_analyze_line","kind":12,"line":191},{"line":192,"kind":13,"containerName":"_analyze_line","name":"$point"},{"kind":12,"containerName":"_analyze_line","name":"description","line":192},{"line":193,"kind":13,"containerName":"_analyze_line","name":"$point"},{"name":"directive_type","kind":12,"containerName":"_analyze_line","line":193},{"line":194,"name":"$point","containerName":"_analyze_line","kind":13},{"name":"directive_reason","kind":12,"containerName":"_analyze_line","line":194},{"line":197,"kind":13,"containerName":"_analyze_line","name":"$details"},{"containerName":"_analyze_line","kind":13,"name":"$details","line":197},{"line":198,"name":"$results","kind":13,"containerName":"_analyze_line"},{"line":198,"name":"set_details","kind":12,"containerName":"_analyze_line"},{"name":"$point","kind":13,"containerName":"_analyze_line","line":198},{"line":198,"name":"number","containerName":"_analyze_line","kind":12},{"containerName":"_analyze_line","kind":13,"name":"$details","line":198},{"kind":13,"containerName":"_analyze_line","name":"$line","line":201},{"line":202,"containerName":"_analyze_line","kind":13,"name":"$linetype"},{"kind":13,"containerName":"_analyze_line","name":"$self","line":205},{"line":205,"kind":13,"containerName":"_analyze_line","name":"$self"},{"line":207,"containerName":"_analyze_line","kind":13,"name":"$self"},{"line":207,"name":"_is_header","containerName":"_analyze_line","kind":12},{"containerName":"_analyze_line","kind":13,"name":"$line","line":207},{"line":208,"containerName":"_analyze_line","kind":13,"name":"$linetype"},{"kind":13,"containerName":"_analyze_line","name":"$self","line":210},{"line":212,"kind":13,"containerName":"_analyze_line","name":"$results"},{"containerName":"_analyze_line","kind":12,"name":"inc_max","line":212},{"name":"$self","containerName":"_analyze_line","kind":13,"line":212},{"kind":13,"containerName":"_analyze_line","name":"$self","line":214},{"line":214,"kind":12,"containerName":"_analyze_line","name":"_is_bail_out"},{"line":214,"name":"$line","containerName":"_analyze_line","kind":13},{"name":"$self","kind":13,"containerName":"_analyze_line","line":214},{"line":215,"name":"$linetype","containerName":"_analyze_line","kind":13},{"name":"$self","containerName":"_analyze_line","kind":13,"line":216},{"localvar":"my","kind":13,"containerName":"_analyze_line","name":"$diagnostics","line":218,"definition":"my"},{"containerName":"_analyze_line","kind":13,"name":"$self","line":218},{"line":218,"name":"_is_diagnostic_line","containerName":"_analyze_line","kind":12},{"line":218,"name":"$line","containerName":"_analyze_line","kind":13},{"line":219,"containerName":"_analyze_line","kind":13,"name":"$linetype"},{"line":221,"kind":13,"localvar":"my","containerName":"_analyze_line","name":"$test","definition":"my"},{"containerName":"_analyze_line","kind":13,"name":"$results","line":221},{"line":221,"name":"details","kind":12,"containerName":"_analyze_line"},{"containerName":"_analyze_line","kind":13,"name":"$test","line":222},{"name":"$test","containerName":"_analyze_line","kind":13,"line":223},{"line":223,"containerName":"_analyze_line","kind":13,"name":"$diagnostics"},{"line":226,"name":"$linetype","containerName":"_analyze_line","kind":13},{"containerName":"_analyze_line","kind":13,"name":"$self","line":229},{"containerName":"_analyze_line","kind":12,"name":"callback","line":229},{"name":"$self","kind":13,"containerName":"_analyze_line","line":229},{"name":"$line","containerName":"_analyze_line","kind":13,"line":229},{"containerName":"_analyze_line","kind":13,"name":"$linetype","line":229},{"line":229,"name":"$results","kind":13,"containerName":"_analyze_line"},{"line":229,"name":"$self","containerName":"_analyze_line","kind":13},{"name":"callback","kind":12,"containerName":"_analyze_line","line":229},{"line":231,"name":"$self","kind":13,"containerName":"_analyze_line"},{"containerName":"_analyze_line","kind":13,"name":"$point","line":231},{"line":231,"name":"number","kind":12,"containerName":"_analyze_line"},{"line":231,"name":"$point","kind":13,"containerName":"_analyze_line"}],"name":"_analyze_line","containerName":"main::","line":145,"kind":12,"range":{"start":{"line":145,"character":0},"end":{"character":9999,"line":232}}},{"line":150,"kind":12,"name":"line"},{"line":153,"name":"Test","containerName":"Harness::Point","kind":12},{"kind":12,"name":"lone_not_line","line":164},{"line":164,"name":"lone_not_line","kind":12},{"kind":12,"name":"line","line":164},{"line":168,"name":"todo","kind":12},{"line":182,"name":"max","kind":12},{"kind":12,"name":"too_many_tests","line":183},{"line":190,"kind":12,"name":"ok"},{"line":191,"kind":12,"name":"actual_ok"},{"kind":12,"name":"name","line":192},{"kind":12,"name":"_def_or_blank","line":192},{"line":193,"name":"type","kind":12},{"line":193,"name":"_def_or_blank","kind":12},{"line":194,"kind":12,"name":"reason"},{"name":"_def_or_blank","kind":12,"line":194},{"name":"assert","kind":12,"line":197},{"line":197,"name":"ok","kind":12},{"line":197,"kind":12,"name":"actual_ok"},{"name":"lone_not_line","kind":12,"line":205},{"line":205,"name":"line","kind":12},{"line":210,"name":"saw_header","kind":12},{"name":"max","kind":12,"line":212},{"name":"bailout_reason","kind":12,"line":214},{"line":216,"kind":12,"name":"saw_bailout"},{"kind":12,"name":"diagnostics","line":222},{"line":223,"name":"diagnostics","kind":12},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_is_diagnostic_line","kind":13,"line":236},{"kind":13,"containerName":"_is_diagnostic_line","name":"$line","line":236},{"line":237,"name":"$line","kind":13,"containerName":"_is_diagnostic_line"},{"line":238,"name":"$line","kind":13,"containerName":"_is_diagnostic_line"},{"line":239,"name":"$line","containerName":"_is_diagnostic_line","kind":13}],"name":"_is_diagnostic_line","containerName":"main::","definition":"sub","detail":"($self,$line)","line":235,"kind":12,"range":{"end":{"line":240,"character":9999},"start":{"character":0,"line":235}},"signature":{"label":"_is_diagnostic_line($self,$line)","parameters":[{"label":"$self"},{"label":"$line"}],"documentation":""}},{"children":[{"line":251,"localvar":"my","kind":13,"containerName":"analyze_fh","name":"$self","definition":"my"},{"containerName":"analyze_fh","kind":13,"name":"$name","line":251},{"name":"$fh","kind":13,"containerName":"analyze_fh","line":251},{"definition":"my","line":253,"localvar":"my","containerName":"analyze_fh","kind":13,"name":"$it"},{"name":"new","kind":12,"containerName":"analyze_fh","line":253},{"kind":13,"containerName":"analyze_fh","name":"$fh","line":253},{"line":254,"name":"$self","containerName":"analyze_fh","kind":13},{"name":"_analyze_iterator","kind":12,"containerName":"analyze_fh","line":254},{"containerName":"analyze_fh","kind":13,"name":"$name","line":254},{"line":254,"containerName":"analyze_fh","kind":13,"name":"$it"}],"containerName":"main::","name":"analyze_fh","definition":"sub","detail":"($self,$name,$fh)","line":250,"range":{"start":{"character":0,"line":250},"end":{"line":255,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$name"},{"label":"$fh"}],"documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.","label":"analyze_fh($self,$name,$fh)"}},{"line":253,"name":"Test","containerName":"Harness::Iterator","kind":12},{"signature":{"documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.","parameters":[{"label":"$self"},{"label":"$file"}],"label":"analyze_file($self,$file)"},"line":266,"range":{"end":{"character":9999,"line":308},"start":{"character":0,"line":266}},"kind":12,"definition":"sub","detail":"($self,$file)","children":[{"line":267,"localvar":"my","containerName":"analyze_file","kind":13,"name":"$self","definition":"my"},{"name":"$file","kind":13,"containerName":"analyze_file","line":267},{"name":"$file","containerName":"analyze_file","kind":13,"line":269},{"kind":13,"containerName":"analyze_file","name":"$self","line":270},{"name":"$file","containerName":"analyze_file","kind":13,"line":274},{"name":"$self","containerName":"analyze_file","kind":13,"line":275},{"line":279,"containerName":"analyze_file","kind":13,"name":"$ENV"},{"line":279,"containerName":"analyze_file","kind":13,"name":"$self"},{"name":"_INC2PERL5LIB","containerName":"analyze_file","kind":12,"line":279},{"line":280,"name":"$Test","kind":13,"containerName":"analyze_file"},{"containerName":"analyze_file","localvar":"my","kind":13,"name":"$line","line":286,"definition":"my"},{"line":286,"name":"$self","containerName":"analyze_file","kind":13},{"line":286,"kind":12,"containerName":"analyze_file","name":"_command_line"},{"line":286,"name":"$file","kind":13,"containerName":"analyze_file"},{"line":293,"name":"$results","localvar":"my","containerName":"analyze_file","kind":13,"definition":"my"},{"kind":13,"containerName":"analyze_file","name":"$self","line":293},{"line":293,"kind":12,"containerName":"analyze_file","name":"analyze_fh"},{"kind":13,"containerName":"analyze_file","name":"$file","line":293},{"line":294,"localvar":"my","kind":13,"containerName":"analyze_file","name":"$exit","definition":"my"},{"kind":13,"containerName":"analyze_file","name":"$results","line":296},{"name":"set_wait","containerName":"analyze_file","kind":12,"line":296},{"line":297,"name":"$self","containerName":"analyze_file","kind":13},{"kind":13,"containerName":"analyze_file","name":"$results","line":301},{"line":301,"name":"set_exit","kind":12,"containerName":"analyze_file"},{"containerName":"analyze_file","kind":13,"name":"$results","line":303},{"kind":12,"containerName":"analyze_file","name":"set_passing","line":303},{"line":305,"kind":13,"containerName":"analyze_file","name":"$self"},{"line":305,"containerName":"analyze_file","kind":12,"name":"_restore_PERL5LIB"},{"line":307,"containerName":"analyze_file","kind":13,"name":"$results"}],"name":"analyze_file","containerName":"main::"},{"line":270,"kind":12,"name":"error"},{"name":"error","kind":12,"line":275},{"name":"PERL5LIB","kind":12,"line":279},{"containerName":"Debug","kind":12,"name":"Harness","line":280},{"kind":12,"name":"FILE","line":288},{"name":"FILE","kind":12,"line":294},{"line":297,"kind":12,"name":"_is_vms"},{"kind":12,"name":"_wait2exit","line":301},{"line":311,"kind":12,"containerName":"WEXITSTATUS","name":"POSIX"},{"line":316,"kind":12,"containerName":"WEXITSTATUS","name":"POSIX"},{"line":325,"kind":12,"range":{"end":{"line":336,"character":9999},"start":{"character":0,"line":325}},"definition":"sub","children":[{"kind":13,"localvar":"my","containerName":"_command_line","name":"$self","line":326,"definition":"my"},{"definition":"my","line":327,"localvar":"my","kind":13,"containerName":"_command_line","name":"$file"},{"definition":"my","line":329,"name":"$command","kind":13,"localvar":"my","containerName":"_command_line"},{"kind":13,"containerName":"_command_line","name":"$self","line":329},{"line":329,"name":"_command","kind":12,"containerName":"_command_line"},{"localvar":"my","containerName":"_command_line","kind":13,"name":"$switches","line":330,"definition":"my"},{"line":330,"name":"$self","containerName":"_command_line","kind":13},{"line":330,"name":"_switches","kind":12,"containerName":"_command_line"},{"kind":13,"containerName":"_command_line","name":"$file","line":330},{"kind":13,"containerName":"_command_line","name":"$file","line":332},{"kind":13,"containerName":"_command_line","name":"$file","line":332},{"line":332,"containerName":"_command_line","kind":13,"name":"$file"},{"definition":"my","line":333,"localvar":"my","kind":13,"containerName":"_command_line","name":"$line"},{"kind":13,"containerName":"_command_line","name":"$line","line":335}],"containerName":"main::","name":"_command_line"},{"line":353,"kind":12,"range":{"end":{"line":359,"character":9999},"start":{"character":0,"line":353}},"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_command","line":354},{"line":356,"kind":13,"containerName":"_command","name":"$ENV"},{"line":356,"name":"$ENV","containerName":"_command","kind":13},{"name":"$self","kind":13,"containerName":"_command","line":357}],"name":"_command","containerName":"main::","definition":"sub"},{"kind":12,"name":"HARNESS_PERL","line":356},{"kind":12,"name":"HARNESS_PERL","line":356},{"line":357,"kind":12,"name":"_is_win32"},{"range":{"start":{"character":0,"line":368},"end":{"line":397,"character":9999}},"kind":12,"line":368,"signature":{"parameters":[{"label":"$self"},{"label":"$file"}],"documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.\n\n\nsub analyze_file {\n    my($self, $file) = @_;\n\n    unless( -e $file ) {\n        $self->{error} = \"$file does not exist\";\n        return;\n    }\n\n    unless( -r $file ) {\n        $self->{error} = \"$file is not readable\";\n        return;\n    }\n\n    local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n    if ( $Test::Harness::Debug ) {\n        local $^W=0; # ignore undef warnings\n        print \"# PERL5LIB=$ENV{PERL5LIB}\\n\";\n    }\n\n    # *sigh* this breaks under taint, but open -| is unportable.\n    my $line = $self->_command_line($file);\n\n    unless ( open(FILE, \"$line|\" )) {\n        print \"can't run $file. $!\\n\";\n        return;\n    }\n\n    my $results = $self->analyze_fh($file, \\*FILE);\n    my $exit    = close FILE;\n\n    $results->set_wait($?);\n    if ( $? && $self->{_is_vms} ) {\n        eval q{use vmsish \"status\"; $results->set_exit($?); };\n    }\n    else {\n        $results->set_exit( _wait2exit($?) );\n    }\n    $results->set_passing(0) unless $? == 0;\n\n    $self->_restore_PERL5LIB();\n\n    return $results;\n}\n\n\neval { require POSIX; &POSIX::WEXITSTATUS(0) };\nif( $@ ) {\n    *_wait2exit = sub { $_[0] >> 8 };\n}\nelse {\n    *_wait2exit = sub { POSIX::WEXITSTATUS($_[0]) }\n}\n\n=for private $strap->_command_line( $file )\n\nReturns the full command line that will be run to test I<$file>.\n\n\nsub _command_line {\n    my $self = shift;\n    my $file = shift;\n\n    my $command =  $self->_command();\n    my $switches = $self->_switches($file);\n\n    $file = qq[\"$file\"] if ($file =~ /\\s/) && ($file !~ /^\".*\"$/);\n    my $line = \"$command $switches $file\";\n\n    return $line;\n}\n\n\n=for private $strap->_command()\n\nReturns the command that runs the test.  Combine this with C<_switches()>\nto build a command line.\n\nTypically this is C<$^X>, but you can set C<$ENV{HARNESS_PERL}>\nto use a different Perl than what you're running the harness under.\nThis might be to run a threaded Perl, for example.\n\nYou can also overload this method if you've built your own strap subclass,\nsuch as a PHP interpreter for a PHP-based strap.\n\n\nsub _command {\n    my $self = shift;\n\n    return $ENV{HARNESS_PERL}   if defined $ENV{HARNESS_PERL};\n    return qq[\"$^X\"]            if $self->{_is_win32} && ($^X =~ /[^\\w\\.\\/\\\\]/);\n    return $^X;\n}\n\n\n=for private $strap->_switches( $file )\n\nFormats and returns the switches necessary to run the test.","label":"_switches($self,$file)"},"containerName":"main::","name":"_switches","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_switches","kind":13,"line":369},{"line":369,"name":"$file","kind":13,"containerName":"_switches"},{"kind":13,"localvar":"my","containerName":"_switches","name":"@existing_switches","line":371,"definition":"my"},{"name":"$self","containerName":"_switches","kind":13,"line":371},{"line":371,"name":"_cleaned_switches","containerName":"_switches","kind":12},{"name":"$Test","kind":13,"containerName":"_switches","line":371},{"line":371,"name":"$ENV","kind":13,"containerName":"_switches"},{"localvar":"my","kind":13,"containerName":"_switches","name":"@derived_switches","line":372,"definition":"my"},{"name":"$file","kind":13,"containerName":"_switches","line":375},{"line":376,"localvar":"my","kind":13,"containerName":"_switches","name":"$shebang","definition":"my"},{"definition":"my","name":"$taint","localvar":"my","kind":13,"containerName":"_switches","line":379},{"containerName":"_switches","kind":13,"name":"$shebang","line":379},{"containerName":"_switches","kind":13,"name":"@derived_switches","line":380},{"line":380,"kind":13,"containerName":"_switches","name":"$taint"},{"kind":13,"containerName":"_switches","name":"$taint","line":385},{"name":"$self","containerName":"_switches","kind":13,"line":385},{"definition":"my","line":386,"kind":13,"localvar":"my","containerName":"_switches","name":"@inc"},{"line":386,"name":"$self","containerName":"_switches","kind":13},{"line":386,"containerName":"_switches","kind":12,"name":"_filtered_INC"},{"line":387,"containerName":"_switches","kind":13,"name":"@derived_switches"},{"line":387,"name":"@inc","containerName":"_switches","kind":13},{"name":"@derived_switches","containerName":"_switches","kind":13,"line":393},{"line":394,"name":"$self","containerName":"_switches","kind":13},{"name":"@existing_switches","kind":13,"containerName":"_switches","line":396},{"line":396,"kind":13,"containerName":"_switches","name":"@derived_switches"}],"detail":"($self,$file)","definition":"sub"},{"line":371,"kind":12,"containerName":"Switches","name":"Harness"},{"name":"HARNESS_PERL_SWITCHES","kind":12,"line":371},{"line":375,"kind":12,"name":"TEST"},{"line":376,"name":"TEST","kind":12},{"name":"TEST","kind":12,"line":377},{"line":385,"kind":12,"name":"_is_macos"},{"line":394,"name":"_is_vms","kind":12},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_cleaned_switches","line":406,"definition":"my"},{"line":410,"containerName":"_cleaned_switches","localvar":"my","kind":13,"name":"@switches","definition":"my"},{"definition":"my","name":"$switch","localvar":"my","kind":13,"containerName":"_cleaned_switches","line":412},{"name":"$switch","containerName":"_cleaned_switches","kind":13,"line":413},{"line":414,"containerName":"_cleaned_switches","kind":13,"name":"$switch"},{"line":415,"name":"$switch","kind":13,"containerName":"_cleaned_switches"},{"line":416,"name":"@switches","containerName":"_cleaned_switches","kind":13},{"line":416,"kind":13,"containerName":"_cleaned_switches","name":"$switch"},{"line":416,"kind":13,"containerName":"_cleaned_switches","name":"$switch"},{"kind":13,"containerName":"_cleaned_switches","name":"@switches","line":419}],"name":"_cleaned_switches","containerName":"main::","line":405,"kind":12,"range":{"end":{"line":420,"character":9999},"start":{"character":0,"line":405}}},{"definition":"sub","containerName":"main::","name":"_INC2PERL5LIB","children":[{"definition":"my","line":432,"localvar":"my","containerName":"_INC2PERL5LIB","kind":13,"name":"$self"},{"name":"$self","containerName":"_INC2PERL5LIB","kind":13,"line":434},{"line":434,"name":"$ENV","containerName":"_INC2PERL5LIB","kind":13},{"line":436,"name":"$Config","kind":13,"containerName":"_INC2PERL5LIB"},{"containerName":"_INC2PERL5LIB","kind":13,"name":"$self","line":436},{"line":436,"name":"_filtered_INC","kind":12,"containerName":"_INC2PERL5LIB"}],"kind":12,"range":{"start":{"character":0,"line":431},"end":{"line":437,"character":9999}},"line":431},{"line":434,"kind":12,"name":"_old5lib"},{"line":434,"kind":12,"name":"PERL5LIB"},{"line":436,"kind":12,"name":"path_sep"},{"signature":{"label":"_filtered_INC($self,@inc)","parameters":[{"label":"$self"},{"label":"@inc"}],"documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.\n\n\nsub analyze_file {\n    my($self, $file) = @_;\n\n    unless( -e $file ) {\n        $self->{error} = \"$file does not exist\";\n        return;\n    }\n\n    unless( -r $file ) {\n        $self->{error} = \"$file is not readable\";\n        return;\n    }\n\n    local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n    if ( $Test::Harness::Debug ) {\n        local $^W=0; # ignore undef warnings\n        print \"# PERL5LIB=$ENV{PERL5LIB}\\n\";\n    }\n\n    # *sigh* this breaks under taint, but open -| is unportable.\n    my $line = $self->_command_line($file);\n\n    unless ( open(FILE, \"$line|\" )) {\n        print \"can't run $file. $!\\n\";\n        return;\n    }\n\n    my $results = $self->analyze_fh($file, \\*FILE);\n    my $exit    = close FILE;\n\n    $results->set_wait($?);\n    if ( $? && $self->{_is_vms} ) {\n        eval q{use vmsish \"status\"; $results->set_exit($?); };\n    }\n    else {\n        $results->set_exit( _wait2exit($?) );\n    }\n    $results->set_passing(0) unless $? == 0;\n\n    $self->_restore_PERL5LIB();\n\n    return $results;\n}\n\n\neval { require POSIX; &POSIX::WEXITSTATUS(0) };\nif( $@ ) {\n    *_wait2exit = sub { $_[0] >> 8 };\n}\nelse {\n    *_wait2exit = sub { POSIX::WEXITSTATUS($_[0]) }\n}\n\n=for private $strap->_command_line( $file )\n\nReturns the full command line that will be run to test I<$file>.\n\n\nsub _command_line {\n    my $self = shift;\n    my $file = shift;\n\n    my $command =  $self->_command();\n    my $switches = $self->_switches($file);\n\n    $file = qq[\"$file\"] if ($file =~ /\\s/) && ($file !~ /^\".*\"$/);\n    my $line = \"$command $switches $file\";\n\n    return $line;\n}\n\n\n=for private $strap->_command()\n\nReturns the command that runs the test.  Combine this with C<_switches()>\nto build a command line.\n\nTypically this is C<$^X>, but you can set C<$ENV{HARNESS_PERL}>\nto use a different Perl than what you're running the harness under.\nThis might be to run a threaded Perl, for example.\n\nYou can also overload this method if you've built your own strap subclass,\nsuch as a PHP interpreter for a PHP-based strap.\n\n\nsub _command {\n    my $self = shift;\n\n    return $ENV{HARNESS_PERL}   if defined $ENV{HARNESS_PERL};\n    return qq[\"$^X\"]            if $self->{_is_win32} && ($^X =~ /[^\\w\\.\\/\\\\]/);\n    return $^X;\n}\n\n\n=for private $strap->_switches( $file )\n\nFormats and returns the switches necessary to run the test.\n\n\nsub _switches {\n    my($self, $file) = @_;\n\n    my @existing_switches = $self->_cleaned_switches( $Test::Harness::Switches, $ENV{HARNESS_PERL_SWITCHES} );\n    my @derived_switches;\n\n    local *TEST;\n    open(TEST, $file) or print \"can't open $file. $!\\n\";\n    my $shebang = <TEST>;\n    close(TEST) or print \"can't close $file. $!\\n\";\n\n    my $taint = ( $shebang =~ /^#!.*\\bperl.*\\s-\\w*([Tt]+)/ );\n    push( @derived_switches, \"-$1\" ) if $taint;\n\n    # When taint mode is on, PERL5LIB is ignored.  So we need to put\n    # all that on the command line as -Is.\n    # MacPerl's putenv is broken, so it will not see PERL5LIB, tainted or not.\n    if ( $taint || $self->{_is_macos} ) {\n\tmy @inc = $self->_filtered_INC;\n\tpush @derived_switches, map { \"-I$_\" } @inc;\n    }\n\n    # Quote the argument if there's any whitespace in it, or if\n    # we're VMS, since VMS requires all parms quoted.  Also, don't quote\n    # it if it's already quoted.\n    for ( @derived_switches ) {\n\t$_ = qq[\"$_\"] if ((/\\s/ || $self->{_is_vms}) && !/^\".*\"$/ );\n    }\n    return join( \" \", @existing_switches, @derived_switches );\n}\n\n=for private $strap->_cleaned_switches( @switches_from_user )\n\nReturns only defined, non-blank, trimmed switches from the parms passed.\n\n\nsub _cleaned_switches {\n    my $self = shift;\n\n    local $_;\n\n    my @switches;\n    for ( @_ ) {\n\tmy $switch = $_;\n\tnext unless defined $switch;\n\t$switch =~ s/^\\s+//;\n\t$switch =~ s/\\s+$//;\n\tpush( @switches, $switch ) if $switch ne \"\";\n    }\n\n    return @switches;\n}\n\n=for private $strap->_INC2PERL5LIB\n\n  local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n\nTakes the current value of C<@INC> and turns it into something suitable\nfor putting onto C<PERL5LIB>.\n\n\nsub _INC2PERL5LIB {\n    my($self) = shift;\n\n    $self->{_old5lib} = $ENV{PERL5LIB};\n\n    return join $Config{path_sep}, $self->_filtered_INC;\n}\n\n=for private $strap->_filtered_INC()\n\n  my @filtered_inc = $self->_filtered_INC;\n\nShortens C<@INC> by removing redundant and unnecessary entries.\nNecessary for OSes with limited command line lengths, like VMS."},"line":448,"range":{"end":{"line":468,"character":9999},"start":{"character":0,"line":448}},"kind":12,"definition":"sub","detail":"($self,@inc)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_filtered_INC","line":449},{"name":"@inc","containerName":"_filtered_INC","kind":13,"line":449},{"line":450,"name":"@inc","kind":13,"containerName":"_filtered_INC"},{"name":"@inc","kind":13,"containerName":"_filtered_INC","line":450},{"line":452,"kind":13,"containerName":"_filtered_INC","name":"$self"},{"name":"@inc","kind":13,"containerName":"_filtered_INC","line":455},{"name":"@inc","containerName":"_filtered_INC","kind":13,"line":455},{"name":"$self","kind":13,"containerName":"_filtered_INC","line":458},{"kind":13,"containerName":"_filtered_INC","name":"@inc","line":460},{"definition":"my","line":463,"name":"%seen","containerName":"_filtered_INC","localvar":"my","kind":13},{"line":464,"kind":13,"containerName":"_filtered_INC","name":"$seen"},{"kind":13,"containerName":"_filtered_INC","name":"$self","line":464},{"kind":12,"containerName":"_filtered_INC","name":"_default_inc","line":464},{"containerName":"_filtered_INC","kind":13,"name":"@inc","line":465},{"name":"$seen","containerName":"_filtered_INC","kind":13,"line":465},{"containerName":"_filtered_INC","kind":13,"name":"@inc","line":465},{"kind":13,"containerName":"_filtered_INC","name":"@inc","line":467}],"containerName":"main::","name":"_filtered_INC"},{"line":452,"name":"_is_vms","kind":12},{"line":458,"name":"_is_win32","kind":12},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"%cache","line":472},{"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_default_inc","line":474},{"kind":13,"localvar":"my","containerName":"_default_inc","name":"$perl","line":475,"definition":"my"},{"line":475,"name":"$self","containerName":"_default_inc","kind":13},{"name":"_command","containerName":"_default_inc","kind":12,"line":475},{"kind":13,"containerName":"_default_inc","name":"$cache","line":476},{"kind":13,"containerName":"_default_inc","name":"$perl","line":476},{"kind":13,"containerName":"_default_inc","name":"$ENV","line":477},{"line":478,"name":"@inc","localvar":"my","containerName":"_default_inc","kind":13,"definition":"my"},{"line":479,"containerName":"_default_inc","kind":13,"name":"@inc"},{"line":481,"name":"$cache","containerName":"_default_inc","kind":13},{"line":481,"name":"$perl","kind":13,"containerName":"_default_inc"}],"name":"_default_inc","containerName":"main::","line":473,"kind":12,"range":{"start":{"character":0,"line":473},"end":{"character":9999,"line":481}}},{"name":"PERL5LIB","kind":12,"line":477},{"line":495,"range":{"start":{"character":0,"line":495},"end":{"character":9999,"line":503}},"kind":12,"definition":"sub","children":[{"line":496,"name":"$self","containerName":"_restore_PERL5LIB","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_restore_PERL5LIB","name":"$self","line":498},{"line":500,"name":"$self","kind":13,"containerName":"_restore_PERL5LIB"},{"line":501,"kind":13,"containerName":"_restore_PERL5LIB","name":"$ENV"},{"line":501,"containerName":"_restore_PERL5LIB","kind":13,"name":"$self"}],"containerName":"main::","name":"_restore_PERL5LIB"},{"name":"_is_vms","kind":12,"line":498},{"kind":12,"name":"_old5lib","line":500},{"name":"PERL5LIB","kind":12,"line":501},{"line":501,"kind":12,"name":"_old5lib"},{"signature":{"label":"_is_diagnostic($self,$line,$comment)","documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.\n\n\nsub analyze_file {\n    my($self, $file) = @_;\n\n    unless( -e $file ) {\n        $self->{error} = \"$file does not exist\";\n        return;\n    }\n\n    unless( -r $file ) {\n        $self->{error} = \"$file is not readable\";\n        return;\n    }\n\n    local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n    if ( $Test::Harness::Debug ) {\n        local $^W=0; # ignore undef warnings\n        print \"# PERL5LIB=$ENV{PERL5LIB}\\n\";\n    }\n\n    # *sigh* this breaks under taint, but open -| is unportable.\n    my $line = $self->_command_line($file);\n\n    unless ( open(FILE, \"$line|\" )) {\n        print \"can't run $file. $!\\n\";\n        return;\n    }\n\n    my $results = $self->analyze_fh($file, \\*FILE);\n    my $exit    = close FILE;\n\n    $results->set_wait($?);\n    if ( $? && $self->{_is_vms} ) {\n        eval q{use vmsish \"status\"; $results->set_exit($?); };\n    }\n    else {\n        $results->set_exit( _wait2exit($?) );\n    }\n    $results->set_passing(0) unless $? == 0;\n\n    $self->_restore_PERL5LIB();\n\n    return $results;\n}\n\n\neval { require POSIX; &POSIX::WEXITSTATUS(0) };\nif( $@ ) {\n    *_wait2exit = sub { $_[0] >> 8 };\n}\nelse {\n    *_wait2exit = sub { POSIX::WEXITSTATUS($_[0]) }\n}\n\n=for private $strap->_command_line( $file )\n\nReturns the full command line that will be run to test I<$file>.\n\n\nsub _command_line {\n    my $self = shift;\n    my $file = shift;\n\n    my $command =  $self->_command();\n    my $switches = $self->_switches($file);\n\n    $file = qq[\"$file\"] if ($file =~ /\\s/) && ($file !~ /^\".*\"$/);\n    my $line = \"$command $switches $file\";\n\n    return $line;\n}\n\n\n=for private $strap->_command()\n\nReturns the command that runs the test.  Combine this with C<_switches()>\nto build a command line.\n\nTypically this is C<$^X>, but you can set C<$ENV{HARNESS_PERL}>\nto use a different Perl than what you're running the harness under.\nThis might be to run a threaded Perl, for example.\n\nYou can also overload this method if you've built your own strap subclass,\nsuch as a PHP interpreter for a PHP-based strap.\n\n\nsub _command {\n    my $self = shift;\n\n    return $ENV{HARNESS_PERL}   if defined $ENV{HARNESS_PERL};\n    return qq[\"$^X\"]            if $self->{_is_win32} && ($^X =~ /[^\\w\\.\\/\\\\]/);\n    return $^X;\n}\n\n\n=for private $strap->_switches( $file )\n\nFormats and returns the switches necessary to run the test.\n\n\nsub _switches {\n    my($self, $file) = @_;\n\n    my @existing_switches = $self->_cleaned_switches( $Test::Harness::Switches, $ENV{HARNESS_PERL_SWITCHES} );\n    my @derived_switches;\n\n    local *TEST;\n    open(TEST, $file) or print \"can't open $file. $!\\n\";\n    my $shebang = <TEST>;\n    close(TEST) or print \"can't close $file. $!\\n\";\n\n    my $taint = ( $shebang =~ /^#!.*\\bperl.*\\s-\\w*([Tt]+)/ );\n    push( @derived_switches, \"-$1\" ) if $taint;\n\n    # When taint mode is on, PERL5LIB is ignored.  So we need to put\n    # all that on the command line as -Is.\n    # MacPerl's putenv is broken, so it will not see PERL5LIB, tainted or not.\n    if ( $taint || $self->{_is_macos} ) {\n\tmy @inc = $self->_filtered_INC;\n\tpush @derived_switches, map { \"-I$_\" } @inc;\n    }\n\n    # Quote the argument if there's any whitespace in it, or if\n    # we're VMS, since VMS requires all parms quoted.  Also, don't quote\n    # it if it's already quoted.\n    for ( @derived_switches ) {\n\t$_ = qq[\"$_\"] if ((/\\s/ || $self->{_is_vms}) && !/^\".*\"$/ );\n    }\n    return join( \" \", @existing_switches, @derived_switches );\n}\n\n=for private $strap->_cleaned_switches( @switches_from_user )\n\nReturns only defined, non-blank, trimmed switches from the parms passed.\n\n\nsub _cleaned_switches {\n    my $self = shift;\n\n    local $_;\n\n    my @switches;\n    for ( @_ ) {\n\tmy $switch = $_;\n\tnext unless defined $switch;\n\t$switch =~ s/^\\s+//;\n\t$switch =~ s/\\s+$//;\n\tpush( @switches, $switch ) if $switch ne \"\";\n    }\n\n    return @switches;\n}\n\n=for private $strap->_INC2PERL5LIB\n\n  local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n\nTakes the current value of C<@INC> and turns it into something suitable\nfor putting onto C<PERL5LIB>.\n\n\nsub _INC2PERL5LIB {\n    my($self) = shift;\n\n    $self->{_old5lib} = $ENV{PERL5LIB};\n\n    return join $Config{path_sep}, $self->_filtered_INC;\n}\n\n=for private $strap->_filtered_INC()\n\n  my @filtered_inc = $self->_filtered_INC;\n\nShortens C<@INC> by removing redundant and unnecessary entries.\nNecessary for OSes with limited command line lengths, like VMS.\n\n\nsub _filtered_INC {\n    my($self, @inc) = @_;\n    @inc = @INC unless @inc;\n\n    if( $self->{_is_vms} ) {\n\t# VMS has a 255-byte limit on the length of %ENV entries, so\n\t# toss the ones that involve perl_root, the install location\n        @inc = grep !/perl_root/i, @inc;\n\n    }\n    elsif ( $self->{_is_win32} ) {\n\t# Lose any trailing backslashes in the Win32 paths\n\ts/[\\\\\\/+]$// foreach @inc;\n    }\n\n    my %seen;\n    $seen{$_}++ foreach $self->_default_inc();\n    @inc = grep !$seen{$_}++, @inc;\n\n    return @inc;\n}\n\n\n{ # Without caching, _default_inc() takes a huge amount of time\n    my %cache;\n    sub _default_inc {\n        my $self = shift;\n        my $perl = $self->_command;\n        $cache{$perl} ||= [do {\n            local $ENV{PERL5LIB};\n            my @inc =`$perl -le \"print join qq[\\\\n], \\@INC\"`;\n            chomp @inc;\n        }];\n        return @{$cache{$perl}};\n    }\n}\n\n\n=for private $strap->_restore_PERL5LIB()\n\n  $self->_restore_PERL5LIB;\n\nThis restores the original value of the C<PERL5LIB> environment variable.\nNecessary on VMS, otherwise a no-op.\n\n\nsub _restore_PERL5LIB {\n    my($self) = shift;\n\n    return unless $self->{_is_vms};\n\n    if (defined $self->{_old5lib}) {\n        $ENV{PERL5LIB} = $self->{_old5lib};\n    }\n}\n\n=head1 Parsing\n\nMethods for identifying what sort of line you're looking at.\n\n=for private _is_diagnostic\n\n    my $is_diagnostic = $strap->_is_diagnostic($line, \\$comment);\n\nChecks if the given line is a comment.  If so, it will place it into\nC<$comment> (sans #).","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$comment"}]},"line":518,"kind":12,"range":{"end":{"line":528,"character":9999},"start":{"character":0,"line":518}},"definition":"sub","detail":"($self,$line,$comment)","children":[{"line":519,"kind":13,"localvar":"my","containerName":"_is_diagnostic","name":"$self","definition":"my"},{"kind":13,"containerName":"_is_diagnostic","name":"$line","line":519},{"line":519,"kind":13,"containerName":"_is_diagnostic","name":"$comment"},{"name":"$line","kind":13,"containerName":"_is_diagnostic","line":521},{"line":523,"containerName":"_is_diagnostic","kind":13,"name":"$YES"},{"name":"$NO","kind":13,"containerName":"_is_diagnostic","line":526}],"name":"_is_diagnostic","containerName":"main::"},{"line":522,"kind":12,"name":"comment"},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$Extra_Header_Re","line":542},{"signature":{"label":"_is_header($self,$line)","parameters":[{"label":"$self"},{"label":"$line"}],"documentation":""},"line":548,"kind":12,"range":{"end":{"character":9999,"line":572},"start":{"line":548,"character":0}},"definition":"sub","detail":"($self,$line)","children":[{"definition":"my","localvar":"my","containerName":"_is_header","kind":13,"name":"$self","line":549},{"name":"$line","kind":13,"containerName":"_is_header","line":549},{"line":551,"name":"$max","containerName":"_is_header","localvar":"my","kind":13,"definition":"my"},{"line":551,"name":"$extra","containerName":"_is_header","kind":13},{"name":"$line","containerName":"_is_header","kind":13,"line":551},{"line":552,"containerName":"_is_header","kind":13,"name":"$self"},{"kind":13,"containerName":"_is_header","name":"$max","line":552},{"kind":13,"containerName":"_is_header","name":"$self","line":553},{"line":555,"kind":13,"containerName":"_is_header","name":"$extra"},{"definition":"my","line":556,"name":"$todo","localvar":"my","kind":13,"containerName":"_is_header"},{"line":556,"containerName":"_is_header","kind":13,"name":"$skip"},{"line":556,"kind":13,"containerName":"_is_header","name":"$reason"},{"name":"$extra","containerName":"_is_header","kind":13,"line":556},{"line":558,"kind":13,"containerName":"_is_header","name":"$self"},{"containerName":"_is_header","kind":13,"name":"$todo","line":558},{"line":558,"name":"$todo","containerName":"_is_header","kind":13},{"containerName":"_is_header","kind":13,"name":"$self","line":560},{"line":561,"containerName":"_is_header","kind":13,"name":"$reason"},{"line":561,"kind":13,"containerName":"_is_header","name":"$skip"},{"name":"$skip","containerName":"_is_header","kind":13,"line":561},{"line":564,"name":"$self","containerName":"_is_header","kind":13},{"name":"$reason","containerName":"_is_header","kind":13,"line":564},{"line":567,"name":"$YES","containerName":"_is_header","kind":13},{"name":"$NO","containerName":"_is_header","kind":13,"line":570}],"containerName":"main::","name":"_is_header"},{"line":552,"kind":12,"name":"max"},{"line":553,"kind":12,"name":"assert"},{"kind":12,"name":"max","line":553},{"kind":12,"name":"todo","line":558},{"kind":12,"name":"max","line":560},{"kind":12,"name":"skip_all","line":564},{"children":[{"line":584,"name":"$self","containerName":"_is_bail_out","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_is_bail_out","name":"$line","line":584},{"line":584,"containerName":"_is_bail_out","kind":13,"name":"$reason"},{"line":586,"kind":13,"containerName":"_is_bail_out","name":"$line"},{"line":588,"name":"$YES","containerName":"_is_bail_out","kind":13},{"line":591,"containerName":"_is_bail_out","kind":13,"name":"$NO"}],"containerName":"main::","name":"_is_bail_out","definition":"sub","detail":"($self,$line,$reason)","line":583,"range":{"start":{"character":0,"line":583},"end":{"line":593,"character":9999}},"kind":12,"signature":{"label":"_is_bail_out($self,$line,$reason)","documentation":"1;\n# -*- Mode: cperl; cperl-indent-level: 4 -*-\npackage Test::Harness::Straps;\n\nuse strict;\nuse vars qw($VERSION);\n$VERSION = '0.26';\n\nuse Config;\nuse Test::Harness::Assert;\nuse Test::Harness::Iterator;\nuse Test::Harness::Point;\nuse Test::Harness::Results;\n\n# Flags used as return values from our methods.  Just for internal \n# clarification.\nmy $YES   = (1==1);\nmy $NO    = !$YES;\n\n=head1 NAME\n\nTest::Harness::Straps - detailed analysis of test results\n\n=head1 SYNOPSIS\n\n  use Test::Harness::Straps;\n\n  my $strap = Test::Harness::Straps->new;\n\n  # Various ways to interpret a test\n  my $results = $strap->analyze($name, \\@test_output);\n  my $results = $strap->analyze_fh($name, $test_filehandle);\n  my $results = $strap->analyze_file($test_file);\n\n  # UNIMPLEMENTED\n  my %total = $strap->total_results;\n\n  # Altering the behavior of the strap  UNIMPLEMENTED\n  my $verbose_output = $strap->dump_verbose();\n  $strap->dump_verbose_fh($output_filehandle);\n\n\n=head1 DESCRIPTION\n\nB<THIS IS ALPHA SOFTWARE> in that the interface is subject to change\nin incompatible ways.  It is otherwise stable.\n\nTest::Harness is limited to printing out its results.  This makes\nanalysis of the test results difficult for anything but a human.  To\nmake it easier for programs to work with test results, we provide\nTest::Harness::Straps.  Instead of printing the results, straps\nprovide them as raw data.  You can also configure how the tests are to\nbe run.\n\nThe interface is currently incomplete.  I<Please> contact the author\nif you'd like a feature added or something change or just have\ncomments.\n\n=head1 CONSTRUCTION\n\n=head2 new()\n\n  my $strap = Test::Harness::Straps->new;\n\nInitialize a new strap.\n\n\nsub new {\n    my $class = shift;\n    my $self  = bless {}, $class;\n\n    $self->_init;\n\n    return $self;\n}\n\n=for private $strap->_init\n\n  $strap->_init;\n\nInitialize the internal state of a strap to make it ready for parsing.\n\n\nsub _init {\n    my($self) = shift;\n\n    $self->{_is_vms}   = ( $^O eq 'VMS' );\n    $self->{_is_win32} = ( $^O =~ /^(MS)?Win32$/ );\n    $self->{_is_macos} = ( $^O eq 'MacOS' );\n}\n\n=head1 ANALYSIS\n\n=head2 $strap->analyze( $name, \\@output_lines )\n\n    my $results = $strap->analyze($name, \\@test_output);\n\nAnalyzes the output of a single test, assigning it the given C<$name>\nfor use in the total report.  Returns the C<$results> of the test.\nSee L<Results>.\n\nC<@test_output> should be the raw output from the test, including\nnewlines.\n\n\nsub analyze {\n    my($self, $name, $test_output) = @_;\n\n    my $it = Test::Harness::Iterator->new($test_output);\n    return $self->_analyze_iterator($name, $it);\n}\n\n\nsub _analyze_iterator {\n    my($self, $name, $it) = @_;\n\n    $self->_reset_file_state;\n    $self->{file} = $name;\n\n    my $results = Test::Harness::Results->new;\n\n    # Set them up here so callbacks can have them.\n    $self->{totals}{$name} = $results;\n    while( defined(my $line = $it->next) ) {\n        $self->_analyze_line($line, $results);\n        last if $self->{saw_bailout};\n    }\n\n    $results->set_skip_all( $self->{skip_all} ) if defined $self->{skip_all};\n\n    my $passed =\n        (($results->max == 0) && defined $results->skip_all) ||\n        ($results->max &&\n         $results->seen &&\n         $results->max == $results->seen &&\n         $results->max == $results->ok);\n\n    $results->set_passing( $passed ? 1 : 0 );\n\n    return $results;\n}\n\n\nsub _analyze_line {\n    my $self = shift;\n    my $line = shift;\n    my $results = shift;\n\n    $self->{line}++;\n\n    my $linetype;\n    my $point = Test::Harness::Point->from_test_line( $line );\n    if ( $point ) {\n        $linetype = 'test';\n\n        $results->inc_seen;\n        $point->set_number( $self->{'next'} ) unless $point->number;\n\n        # sometimes the 'not ' and the 'ok' are on different lines,\n        # happens often on VMS if you do:\n        #   print \"not \" unless $test;\n        #   print \"ok $num\\n\";\n        if ( $self->{lone_not_line} && ($self->{lone_not_line} == $self->{line} - 1) ) {\n            $point->set_ok( 0 );\n        }\n\n        if ( $self->{todo}{$point->number} ) {\n            $point->set_directive_type( 'todo' );\n        }\n\n        if ( $point->is_todo ) {\n            $results->inc_todo;\n            $results->inc_bonus if $point->ok;\n        }\n        elsif ( $point->is_skip ) {\n            $results->inc_skip;\n        }\n\n        $results->inc_ok if $point->pass;\n\n        if ( ($point->number > 100_000) && ($point->number > ($self->{max}||100_000)) ) {\n            if ( !$self->{too_many_tests}++ ) {\n                warn \"Enormous test number seen [test \", $point->number, \"]\\n\";\n                warn \"Can't detailize, too big.\\n\";\n            }\n        }\n        else {\n            my $details = {\n                ok          => $point->pass,\n                actual_ok   => $point->ok,\n                name        => _def_or_blank( $point->description ),\n                type        => _def_or_blank( $point->directive_type ),\n                reason      => _def_or_blank( $point->directive_reason ),\n            };\n\n            assert( defined( $details->{ok} ) && defined( $details->{actual_ok} ) );\n            $results->set_details( $point->number, $details );\n        }\n    } # test point\n    elsif ( $line =~ /^not\\s+$/ ) {\n        $linetype = 'other';\n        # Sometimes the \"not \" and \"ok\" will be on separate lines on VMS.\n        # We catch this and remember we saw it.\n        $self->{lone_not_line} = $self->{line};\n    }\n    elsif ( $self->_is_header($line) ) {\n        $linetype = 'header';\n\n        $self->{saw_header}++;\n\n        $results->inc_max( $self->{max} );\n    }\n    elsif ( $self->_is_bail_out($line, \\$self->{bailout_reason}) ) {\n        $linetype = 'bailout';\n        $self->{saw_bailout} = 1;\n    }\n    elsif (my $diagnostics = $self->_is_diagnostic_line( $line )) {\n        $linetype = 'other';\n        # XXX We can throw this away, really.\n        my $test = $results->details->[-1];\n        $test->{diagnostics} ||=  '';\n        $test->{diagnostics}  .= $diagnostics;\n    }\n    else {\n        $linetype = 'other';\n    }\n\n    $self->callback->($self, $line, $linetype, $results) if $self->callback;\n\n    $self->{'next'} = $point->number + 1 if $point;\n} # _analyze_line\n\n\nsub _is_diagnostic_line {\n    my ($self, $line) = @_;\n    return if index( $line, '# Looks like you failed' ) == 0;\n    $line =~ s/^#\\s//;\n    return $line;\n}\n\n=for private $strap->analyze_fh( $name, $test_filehandle )\n\n    my $results = $strap->analyze_fh($name, $test_filehandle);\n\nLike C<analyze>, but it reads from the given filehandle.\n\n\nsub analyze_fh {\n    my($self, $name, $fh) = @_;\n\n    my $it = Test::Harness::Iterator->new($fh);\n    return $self->_analyze_iterator($name, $it);\n}\n\n=head2 $strap->analyze_file( $test_file )\n\n    my $results = $strap->analyze_file($test_file);\n\nLike C<analyze>, but it runs the given C<$test_file> and parses its\nresults.  It will also use that name for the total report.\n\n\nsub analyze_file {\n    my($self, $file) = @_;\n\n    unless( -e $file ) {\n        $self->{error} = \"$file does not exist\";\n        return;\n    }\n\n    unless( -r $file ) {\n        $self->{error} = \"$file is not readable\";\n        return;\n    }\n\n    local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n    if ( $Test::Harness::Debug ) {\n        local $^W=0; # ignore undef warnings\n        print \"# PERL5LIB=$ENV{PERL5LIB}\\n\";\n    }\n\n    # *sigh* this breaks under taint, but open -| is unportable.\n    my $line = $self->_command_line($file);\n\n    unless ( open(FILE, \"$line|\" )) {\n        print \"can't run $file. $!\\n\";\n        return;\n    }\n\n    my $results = $self->analyze_fh($file, \\*FILE);\n    my $exit    = close FILE;\n\n    $results->set_wait($?);\n    if ( $? && $self->{_is_vms} ) {\n        eval q{use vmsish \"status\"; $results->set_exit($?); };\n    }\n    else {\n        $results->set_exit( _wait2exit($?) );\n    }\n    $results->set_passing(0) unless $? == 0;\n\n    $self->_restore_PERL5LIB();\n\n    return $results;\n}\n\n\neval { require POSIX; &POSIX::WEXITSTATUS(0) };\nif( $@ ) {\n    *_wait2exit = sub { $_[0] >> 8 };\n}\nelse {\n    *_wait2exit = sub { POSIX::WEXITSTATUS($_[0]) }\n}\n\n=for private $strap->_command_line( $file )\n\nReturns the full command line that will be run to test I<$file>.\n\n\nsub _command_line {\n    my $self = shift;\n    my $file = shift;\n\n    my $command =  $self->_command();\n    my $switches = $self->_switches($file);\n\n    $file = qq[\"$file\"] if ($file =~ /\\s/) && ($file !~ /^\".*\"$/);\n    my $line = \"$command $switches $file\";\n\n    return $line;\n}\n\n\n=for private $strap->_command()\n\nReturns the command that runs the test.  Combine this with C<_switches()>\nto build a command line.\n\nTypically this is C<$^X>, but you can set C<$ENV{HARNESS_PERL}>\nto use a different Perl than what you're running the harness under.\nThis might be to run a threaded Perl, for example.\n\nYou can also overload this method if you've built your own strap subclass,\nsuch as a PHP interpreter for a PHP-based strap.\n\n\nsub _command {\n    my $self = shift;\n\n    return $ENV{HARNESS_PERL}   if defined $ENV{HARNESS_PERL};\n    return qq[\"$^X\"]            if $self->{_is_win32} && ($^X =~ /[^\\w\\.\\/\\\\]/);\n    return $^X;\n}\n\n\n=for private $strap->_switches( $file )\n\nFormats and returns the switches necessary to run the test.\n\n\nsub _switches {\n    my($self, $file) = @_;\n\n    my @existing_switches = $self->_cleaned_switches( $Test::Harness::Switches, $ENV{HARNESS_PERL_SWITCHES} );\n    my @derived_switches;\n\n    local *TEST;\n    open(TEST, $file) or print \"can't open $file. $!\\n\";\n    my $shebang = <TEST>;\n    close(TEST) or print \"can't close $file. $!\\n\";\n\n    my $taint = ( $shebang =~ /^#!.*\\bperl.*\\s-\\w*([Tt]+)/ );\n    push( @derived_switches, \"-$1\" ) if $taint;\n\n    # When taint mode is on, PERL5LIB is ignored.  So we need to put\n    # all that on the command line as -Is.\n    # MacPerl's putenv is broken, so it will not see PERL5LIB, tainted or not.\n    if ( $taint || $self->{_is_macos} ) {\n\tmy @inc = $self->_filtered_INC;\n\tpush @derived_switches, map { \"-I$_\" } @inc;\n    }\n\n    # Quote the argument if there's any whitespace in it, or if\n    # we're VMS, since VMS requires all parms quoted.  Also, don't quote\n    # it if it's already quoted.\n    for ( @derived_switches ) {\n\t$_ = qq[\"$_\"] if ((/\\s/ || $self->{_is_vms}) && !/^\".*\"$/ );\n    }\n    return join( \" \", @existing_switches, @derived_switches );\n}\n\n=for private $strap->_cleaned_switches( @switches_from_user )\n\nReturns only defined, non-blank, trimmed switches from the parms passed.\n\n\nsub _cleaned_switches {\n    my $self = shift;\n\n    local $_;\n\n    my @switches;\n    for ( @_ ) {\n\tmy $switch = $_;\n\tnext unless defined $switch;\n\t$switch =~ s/^\\s+//;\n\t$switch =~ s/\\s+$//;\n\tpush( @switches, $switch ) if $switch ne \"\";\n    }\n\n    return @switches;\n}\n\n=for private $strap->_INC2PERL5LIB\n\n  local $ENV{PERL5LIB} = $self->_INC2PERL5LIB;\n\nTakes the current value of C<@INC> and turns it into something suitable\nfor putting onto C<PERL5LIB>.\n\n\nsub _INC2PERL5LIB {\n    my($self) = shift;\n\n    $self->{_old5lib} = $ENV{PERL5LIB};\n\n    return join $Config{path_sep}, $self->_filtered_INC;\n}\n\n=for private $strap->_filtered_INC()\n\n  my @filtered_inc = $self->_filtered_INC;\n\nShortens C<@INC> by removing redundant and unnecessary entries.\nNecessary for OSes with limited command line lengths, like VMS.\n\n\nsub _filtered_INC {\n    my($self, @inc) = @_;\n    @inc = @INC unless @inc;\n\n    if( $self->{_is_vms} ) {\n\t# VMS has a 255-byte limit on the length of %ENV entries, so\n\t# toss the ones that involve perl_root, the install location\n        @inc = grep !/perl_root/i, @inc;\n\n    }\n    elsif ( $self->{_is_win32} ) {\n\t# Lose any trailing backslashes in the Win32 paths\n\ts/[\\\\\\/+]$// foreach @inc;\n    }\n\n    my %seen;\n    $seen{$_}++ foreach $self->_default_inc();\n    @inc = grep !$seen{$_}++, @inc;\n\n    return @inc;\n}\n\n\n{ # Without caching, _default_inc() takes a huge amount of time\n    my %cache;\n    sub _default_inc {\n        my $self = shift;\n        my $perl = $self->_command;\n        $cache{$perl} ||= [do {\n            local $ENV{PERL5LIB};\n            my @inc =`$perl -le \"print join qq[\\\\n], \\@INC\"`;\n            chomp @inc;\n        }];\n        return @{$cache{$perl}};\n    }\n}\n\n\n=for private $strap->_restore_PERL5LIB()\n\n  $self->_restore_PERL5LIB;\n\nThis restores the original value of the C<PERL5LIB> environment variable.\nNecessary on VMS, otherwise a no-op.\n\n\nsub _restore_PERL5LIB {\n    my($self) = shift;\n\n    return unless $self->{_is_vms};\n\n    if (defined $self->{_old5lib}) {\n        $ENV{PERL5LIB} = $self->{_old5lib};\n    }\n}\n\n=head1 Parsing\n\nMethods for identifying what sort of line you're looking at.\n\n=for private _is_diagnostic\n\n    my $is_diagnostic = $strap->_is_diagnostic($line, \\$comment);\n\nChecks if the given line is a comment.  If so, it will place it into\nC<$comment> (sans #).\n\n\nsub _is_diagnostic {\n    my($self, $line, $comment) = @_;\n\n    if( $line =~ /^\\s*\\#(.*)/ ) {\n        $$comment = $1;\n        return $YES;\n    }\n    else {\n        return $NO;\n    }\n}\n\n=for private _is_header\n\n  my $is_header = $strap->_is_header($line);\n\nChecks if the given line is a header (1..M) line.  If so, it places how\nmany tests there will be in C<< $strap->{max} >>, a list of which tests\nare todo in C<< $strap->{todo} >> and if the whole test was skipped\nC<< $strap->{skip_all} >> contains the reason.\n\n\n# Regex for parsing a header.  Will be run with /x\nmy $Extra_Header_Re = <<'REGEX';\n                       ^\n                        (?: \\s+ todo \\s+ ([\\d \\t]+) )?      # optional todo set\n                        (?: \\s* \\# \\s* ([\\w:]+\\s?) (.*) )?     # optional skip with optional reason\nREGEX\n\nsub _is_header {\n    my($self, $line) = @_;\n\n    if( my($max, $extra) = $line =~ /^1\\.\\.(\\d+)(.*)/ ) {\n        $self->{max}  = $max;\n        assert( $self->{max} >= 0,  'Max # of tests looks right' );\n\n        if( defined $extra ) {\n            my($todo, $skip, $reason) = $extra =~ /$Extra_Header_Re/xo;\n\n            $self->{todo} = { map { $_ => 1 } split /\\s+/, $todo } if $todo;\n\n            if( $self->{max} == 0 ) {\n                $reason = '' unless defined $skip and $skip =~ /^Skip/i;\n            }\n\n            $self->{skip_all} = $reason;\n        }\n\n        return $YES;\n    }\n    else {\n        return $NO;\n    }\n}\n\n=for private _is_bail_out\n\n  my $is_bail_out = $strap->_is_bail_out($line, \\$reason);\n\nChecks if the line is a \"Bail out!\".  Places the reason for bailing\n(if any) in $reason.","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$reason"}]}},{"name":"reason","kind":12,"line":587},{"kind":12,"range":{"start":{"line":604,"character":0},"end":{"line":607,"character":9999}},"line":604,"definition":"sub","containerName":"main::","name":"_reset_file_state","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_reset_file_state","name":"$self","line":605},{"name":"$self","kind":13,"containerName":"_reset_file_state","line":607}]},{"name":"%self","containerName":null,"kind":13,"line":608},{"line":608,"kind":12,"name":"line"},{"line":609,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"name":"saw_header","line":609},{"containerName":null,"kind":13,"name":"%self","line":610},{"line":610,"kind":12,"name":"saw_bailout"},{"name":"%self","containerName":null,"kind":13,"line":611},{"line":611,"name":"lone_not_line","kind":12},{"line":612,"containerName":null,"kind":13,"name":"%self"},{"line":612,"kind":12,"name":"bailout_reason"},{"line":613,"name":"%self","containerName":null,"kind":13},{"containerName":"main::","name":"_def_or_blank","children":[],"definition":"sub","range":{"start":{"line":631,"character":0},"end":{"line":634,"character":9999}},"kind":12,"line":631},{"kind":12,"range":{"end":{"line":639,"character":9999},"start":{"line":636,"character":0}},"line":636,"definition":"sub","name":"set_callback","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"set_callback","line":637,"definition":"my"},{"line":638,"containerName":"set_callback","kind":13,"name":"$self"}]},{"name":"callback","kind":12,"line":638},{"definition":"sub","name":"callback","containerName":"main::","children":[{"line":642,"localvar":"my","kind":13,"containerName":"callback","name":"$self","definition":"my"},{"line":643,"name":"$self","containerName":"callback","kind":13}],"range":{"end":{"character":9999,"line":644},"start":{"line":641,"character":0}},"kind":12,"line":641},{"line":643,"name":"callback","kind":12}],"version":5}