{"vars":[{"kind":2,"containerName":"","name":"base","line":84},{"line":97,"range":{"end":{"line":102,"character":9999},"start":{"line":97,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: tabtree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::tabtree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::tabtree - A simple output format which displays a tree as an ASCII drawing\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 'input', -format => 'newick');\n  my $out = Bio::TreeIO->new(-file => '>output', -format => 'tabtree');\n\n  while( my $tree = $in->next_tree ) {\n      $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis is a made up format just for outputting trees as an ASCII drawing.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::tabtree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::tabtree->new();\n Function: Builds a new Bio::TreeIO::tabtree object \n Returns : Bio::TreeIO::tabtree\n Args    :","label":"new($class,@args)"},"children":[{"name":"$class","localvar":"my","kind":13,"containerName":"new","line":98,"definition":"my"},{"line":98,"name":"@args","containerName":"new","kind":13},{"line":100,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":100},{"containerName":"new","kind":13,"name":"@args","line":100}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"line":100,"containerName":"new","kind":12,"name":"SUPER"},{"detail":"($self,$tree)","definition":"sub","containerName":"main::","name":"write_tree","children":[{"line":115,"name":"$self","containerName":"write_tree","localvar":"my","kind":13,"definition":"my"},{"line":115,"name":"$tree","containerName":"write_tree","kind":13},{"localvar":"my","containerName":"write_tree","kind":13,"name":"$line","line":116,"definition":"my"},{"name":"$tree","kind":13,"containerName":"write_tree","line":116},{"line":116,"name":"get_root_node","containerName":"write_tree","kind":12},{"line":117,"kind":13,"containerName":"write_tree","name":"$self"},{"name":"_print","containerName":"write_tree","kind":12,"line":117},{"line":117,"containerName":"write_tree","kind":13,"name":"$line"},{"line":118,"name":"$self","kind":13,"containerName":"write_tree"},{"containerName":"write_tree","kind":12,"name":"flush","line":118},{"line":118,"containerName":"write_tree","kind":13,"name":"$self"},{"name":"_flush_on_write","kind":12,"containerName":"write_tree","line":118},{"line":118,"name":"$self","containerName":"write_tree","kind":13},{"line":118,"containerName":"write_tree","kind":12,"name":"_fh"}],"signature":{"parameters":[{"label":"$self"},{"label":"$tree"}],"documentation":"1;\n# $Id: tabtree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::tabtree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::tabtree - A simple output format which displays a tree as an ASCII drawing\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 'input', -format => 'newick');\n  my $out = Bio::TreeIO->new(-file => '>output', -format => 'tabtree');\n\n  while( my $tree = $in->next_tree ) {\n      $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis is a made up format just for outputting trees as an ASCII drawing.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::tabtree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::tabtree->new();\n Function: Builds a new Bio::TreeIO::tabtree object \n Returns : Bio::TreeIO::tabtree\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in newick/phylip format\n Returns : none\n Args    : Bio::Tree::TreeI object","label":"write_tree($self,$tree)"},"range":{"start":{"line":114,"character":0},"end":{"line":120,"character":9999}},"kind":12,"line":114},{"line":116,"kind":12,"name":"_write_tree_Helper"},{"detail":"($node,$indent)","definition":"sub","name":"_write_tree_Helper","containerName":"main::","children":[{"definition":"my","line":123,"name":"$node","localvar":"my","kind":13,"containerName":"_write_tree_Helper"},{"name":"$indent","containerName":"_write_tree_Helper","kind":13,"line":123},{"name":"$node","containerName":"_write_tree_Helper","kind":13,"line":124},{"definition":"my","line":126,"localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"@d"},{"kind":13,"containerName":"_write_tree_Helper","name":"$node","line":126},{"line":126,"containerName":"_write_tree_Helper","kind":12,"name":"each_Descendent"},{"definition":"my","line":127,"name":"$line","localvar":"my","kind":13,"containerName":"_write_tree_Helper"},{"definition":"my","line":128,"kind":13,"localvar":"my","containerName":"_write_tree_Helper","name":"$i"},{"name":"$lastchild","kind":13,"containerName":"_write_tree_Helper","line":128},{"name":"@d","kind":13,"containerName":"_write_tree_Helper","line":128},{"definition":"my","line":129,"localvar":"my","containerName":"_write_tree_Helper","kind":13,"name":"$n"},{"name":"@d","containerName":"_write_tree_Helper","kind":13,"line":129},{"line":130,"name":"$n","kind":13,"containerName":"_write_tree_Helper"},{"kind":12,"containerName":"_write_tree_Helper","name":"is_Leaf","line":130},{"name":"$line","kind":13,"containerName":"_write_tree_Helper","line":131},{"containerName":"_write_tree_Helper","kind":13,"name":"$indent","line":132},{"line":132,"containerName":"_write_tree_Helper","kind":13,"name":"$indent"},{"line":132,"containerName":"_write_tree_Helper","kind":13,"name":"$n"},{"line":132,"kind":12,"containerName":"_write_tree_Helper","name":"id"},{"line":134,"name":"$line","containerName":"_write_tree_Helper","kind":13},{"name":"$n","kind":13,"containerName":"_write_tree_Helper","line":134},{"containerName":"_write_tree_Helper","kind":12,"name":"id","line":134},{"containerName":"_write_tree_Helper","kind":13,"name":"$n","line":135},{"name":"id","containerName":"_write_tree_Helper","kind":12,"line":135},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"$new_indent","line":137},{"kind":13,"containerName":"_write_tree_Helper","name":"$indent","line":137},{"line":137,"name":"$i","containerName":"_write_tree_Helper","kind":13},{"line":137,"name":"$lastchild","containerName":"_write_tree_Helper","kind":13},{"kind":13,"containerName":"_write_tree_Helper","name":"$n","line":138},{"line":138,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"name":"$line","containerName":"_write_tree_Helper","kind":13,"line":140},{"name":"$n","kind":13,"containerName":"_write_tree_Helper","line":140},{"line":140,"kind":13,"containerName":"_write_tree_Helper","name":"$new_indent"},{"kind":13,"containerName":"_write_tree_Helper","name":"$line","line":143}],"signature":{"parameters":[{"label":"$node"},{"label":"$indent"}],"documentation":"","label":"_write_tree_Helper($node,$indent)"},"range":{"end":{"character":9999,"line":144},"start":{"line":122,"character":0}},"kind":12,"line":122},{"line":157,"kind":12,"range":{"start":{"line":157,"character":0},"end":{"line":159,"character":9999}},"children":[{"kind":12,"containerName":"next_tree","name":"throw","line":158}],"containerName":"main::","name":"next_tree","definition":"sub"}],"version":5}