{"version":5,"vars":[{"name":"UNIVERSAL","kind":2,"containerName":"","line":93},{"name":"base","kind":2,"containerName":"","line":95},{"signature":{"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$field"}],"label":"find_node($self,$type,$field)"},"line":110,"range":{"end":{"line":146,"character":9999},"start":{"line":110,"character":0}},"kind":12,"definition":"sub","detail":"($self,$type,$field)","children":[{"localvar":"my","kind":13,"containerName":"find_node","name":"$self","line":111,"definition":"my"},{"line":111,"kind":13,"containerName":"find_node","name":"$type"},{"line":111,"kind":13,"containerName":"find_node","name":"$field"},{"name":"$type","containerName":"find_node","kind":13,"line":112},{"name":"$self","kind":13,"containerName":"find_node","line":113},{"line":113,"name":"warn","kind":12,"containerName":"find_node"},{"name":"$field","containerName":"find_node","kind":13,"line":122},{"line":124,"name":"$field","containerName":"find_node","kind":13},{"name":"$type","kind":13,"containerName":"find_node","line":124},{"name":"$type","containerName":"find_node","kind":13,"line":125},{"line":127,"name":"$type","containerName":"find_node","kind":13},{"containerName":"find_node","localvar":"my","kind":13,"name":"@nodes","line":135,"definition":"my"},{"line":135,"name":"can","kind":12,"containerName":"find_node"},{"line":135,"name":"$type","kind":13,"containerName":"find_node"},{"name":"$type","kind":13,"containerName":"find_node","line":135},{"name":"$type","containerName":"find_node","kind":13,"line":136},{"containerName":"find_node","kind":13,"name":"$field","line":136},{"containerName":"find_node","kind":13,"name":"$self","line":136},{"name":"get_nodes","kind":12,"containerName":"find_node","line":136},{"line":139,"kind":13,"containerName":"find_node","name":"@nodes"},{"line":141,"name":"@nodes","kind":13,"containerName":"find_node"},{"line":142,"containerName":"find_node","kind":13,"name":"$self"},{"line":142,"kind":12,"containerName":"find_node","name":"warn"},{"line":144,"name":"@nodes","kind":13,"containerName":"find_node"}],"name":"find_node","containerName":"main::"},{"signature":{"label":"remove_Node($self,$input)","parameters":[{"label":"$self"},{"label":"$input"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id"},"kind":12,"range":{"start":{"line":158,"character":0},"end":{"line":175,"character":9999}},"line":158,"detail":"($self,$input)","definition":"sub","name":"remove_Node","containerName":"main::","children":[{"line":159,"localvar":"my","kind":13,"containerName":"remove_Node","name":"$self","definition":"my"},{"line":159,"name":"$input","kind":13,"containerName":"remove_Node"},{"definition":"my","line":160,"containerName":"remove_Node","localvar":"my","kind":13,"name":"$node"},{"line":161,"kind":13,"containerName":"remove_Node","name":"$input"},{"containerName":"remove_Node","kind":13,"name":"$node","line":162},{"line":162,"name":"$self","kind":13,"containerName":"remove_Node"},{"containerName":"remove_Node","kind":12,"name":"find_node","line":162},{"line":162,"kind":13,"containerName":"remove_Node","name":"$input"},{"kind":13,"containerName":"remove_Node","name":"$input","line":163},{"line":163,"kind":12,"containerName":"remove_Node","name":"isa"},{"containerName":"remove_Node","kind":13,"name":"$self","line":164},{"line":164,"name":"warn","containerName":"remove_Node","kind":12},{"name":"$node","containerName":"remove_Node","kind":13,"line":167},{"line":167,"kind":13,"containerName":"remove_Node","name":"$input"},{"line":169,"name":"$node","containerName":"remove_Node","kind":13},{"containerName":"remove_Node","kind":12,"name":"ancestor","line":169},{"kind":13,"containerName":"remove_Node","name":"$self","line":170},{"line":170,"kind":12,"containerName":"remove_Node","name":"get_root_node"},{"containerName":"remove_Node","kind":12,"name":"internal_id","line":170},{"line":170,"containerName":"remove_Node","kind":13,"name":"$node"},{"line":170,"containerName":"remove_Node","kind":12,"name":"internal_id"},{"name":"$self","containerName":"remove_Node","kind":13,"line":171},{"kind":12,"containerName":"remove_Node","name":"warn","line":171},{"line":171,"name":"$node","kind":13,"containerName":"remove_Node"},{"kind":12,"containerName":"remove_Node","name":"to_string","line":171},{"name":"$node","kind":13,"containerName":"remove_Node","line":173},{"line":173,"kind":12,"containerName":"remove_Node","name":"ancestor"},{"line":173,"kind":12,"containerName":"remove_Node","name":"remove_Descendent"},{"line":173,"kind":13,"containerName":"remove_Node","name":"$node"}]},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"get_lineage_nodes","name":"$self","line":189},{"line":189,"name":"$input","containerName":"get_lineage_nodes","kind":13},{"line":190,"localvar":"my","containerName":"get_lineage_nodes","kind":13,"name":"$node","definition":"my"},{"line":191,"name":"$input","containerName":"get_lineage_nodes","kind":13},{"line":192,"kind":13,"containerName":"get_lineage_nodes","name":"$node"},{"line":192,"name":"$self","kind":13,"containerName":"get_lineage_nodes"},{"line":192,"name":"find_node","kind":12,"containerName":"get_lineage_nodes"},{"line":192,"kind":13,"containerName":"get_lineage_nodes","name":"$input"},{"kind":13,"containerName":"get_lineage_nodes","name":"$input","line":194},{"line":194,"name":"isa","containerName":"get_lineage_nodes","kind":12},{"name":"$self","containerName":"get_lineage_nodes","kind":13,"line":195},{"name":"warn","kind":12,"containerName":"get_lineage_nodes","line":195},{"line":199,"containerName":"get_lineage_nodes","kind":13,"name":"$node"},{"kind":13,"containerName":"get_lineage_nodes","name":"$input","line":199},{"localvar":"my","containerName":"get_lineage_nodes","kind":13,"name":"$root","line":205,"definition":"my"},{"kind":13,"containerName":"get_lineage_nodes","name":"$self","line":205},{"kind":12,"containerName":"get_lineage_nodes","name":"get_root_node","line":205},{"definition":"my","line":207,"name":"@lineage","localvar":"my","containerName":"get_lineage_nodes","kind":13},{"line":208,"name":"$node","kind":13,"containerName":"get_lineage_nodes"},{"line":209,"name":"$node","kind":13,"containerName":"get_lineage_nodes"},{"line":209,"name":"$node","kind":13,"containerName":"get_lineage_nodes"},{"kind":12,"containerName":"get_lineage_nodes","name":"ancestor","line":209},{"name":"@lineage","kind":13,"containerName":"get_lineage_nodes","line":210},{"name":"$node","kind":13,"containerName":"get_lineage_nodes","line":210},{"line":211,"name":"$node","containerName":"get_lineage_nodes","kind":13},{"line":211,"containerName":"get_lineage_nodes","kind":13,"name":"$root"},{"kind":13,"containerName":"get_lineage_nodes","name":"@lineage","line":213}],"containerName":"main::","name":"get_lineage_nodes","definition":"sub","detail":"($self,$input)","line":188,"range":{"end":{"line":214,"character":9999},"start":{"line":188,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id","parameters":[{"label":"$self"},{"label":"$input"}],"label":"get_lineage_nodes($self,$input)"}},{"children":[{"line":249,"name":"$self","localvar":"my","kind":13,"containerName":"splice","definition":"my"},{"line":249,"name":"@args","kind":13,"containerName":"splice"},{"containerName":"splice","kind":13,"name":"$self","line":250},{"kind":12,"containerName":"splice","name":"throw","line":250},{"line":250,"name":"@args","kind":13,"containerName":"splice"},{"definition":"my","line":251,"kind":13,"localvar":"my","containerName":"splice","name":"$preserve_lengths"},{"definition":"my","localvar":"my","containerName":"splice","kind":13,"name":"@nodes_to_remove","line":252},{"line":253,"containerName":"splice","kind":13,"name":"$args"},{"line":254,"name":"$self","kind":13,"containerName":"splice"},{"name":"throw","kind":12,"containerName":"splice","line":254},{"containerName":"splice","kind":13,"name":"$args","line":254},{"containerName":"splice","kind":12,"name":"isa","line":254},{"line":255,"name":"@nodes_to_remove","kind":13,"containerName":"splice"},{"line":255,"name":"@args","kind":13,"containerName":"splice"},{"kind":13,"containerName":"splice","name":"$self","line":258},{"line":258,"name":"throw","kind":12,"containerName":"splice"},{"line":258,"name":"@args","kind":13,"containerName":"splice"},{"definition":"my","line":259,"kind":13,"localvar":"my","containerName":"splice","name":"%args"},{"name":"@args","kind":13,"containerName":"splice","line":259},{"definition":"my","line":260,"kind":13,"localvar":"my","containerName":"splice","name":"@keep_nodes"},{"definition":"my","line":261,"localvar":"my","kind":13,"containerName":"splice","name":"@remove_nodes"},{"definition":"my","containerName":"splice","localvar":"my","kind":13,"name":"$remove_all","line":262},{"name":"$key","localvar":"my","kind":13,"containerName":"splice","line":263,"definition":"my"},{"line":263,"containerName":"splice","kind":13,"name":"$value"},{"name":"%args","kind":13,"containerName":"splice","line":263},{"definition":"my","line":264,"name":"@values","kind":13,"localvar":"my","containerName":"splice"},{"line":264,"containerName":"splice","kind":13,"name":"$value"},{"line":264,"containerName":"splice","kind":13,"name":"$value"},{"line":264,"containerName":"splice","kind":13,"name":"$value"},{"name":"$key","containerName":"splice","kind":13,"line":266},{"line":267,"name":"$remove_all","kind":13,"containerName":"splice"},{"localvar":"my","containerName":"splice","kind":13,"name":"$value","line":268,"definition":"my"},{"name":"@values","containerName":"splice","kind":13,"line":268},{"line":269,"kind":13,"containerName":"splice","name":"@remove_nodes"},{"line":269,"name":"$self","containerName":"splice","kind":13},{"name":"find_node","kind":12,"containerName":"splice","line":269},{"name":"$key","containerName":"splice","kind":13,"line":269},{"line":269,"name":"$value","containerName":"splice","kind":13},{"line":272,"containerName":"splice","kind":13,"name":"$key"},{"line":273,"name":"$value","localvar":"my","kind":13,"containerName":"splice","definition":"my"},{"containerName":"splice","kind":13,"name":"@values","line":273},{"name":"@keep_nodes","containerName":"splice","kind":13,"line":274},{"name":"$self","containerName":"splice","kind":13,"line":274},{"name":"find_node","kind":12,"containerName":"splice","line":274},{"kind":13,"containerName":"splice","name":"$key","line":274},{"line":274,"name":"$value","containerName":"splice","kind":13},{"line":277,"name":"$key","kind":13,"containerName":"splice"},{"kind":13,"containerName":"splice","name":"$preserve_lengths","line":278},{"line":278,"name":"$value","kind":13,"containerName":"splice"},{"line":282,"containerName":"splice","kind":13,"name":"$remove_all"},{"name":"@keep_nodes","containerName":"splice","kind":13,"line":283},{"line":284,"name":"$self","containerName":"splice","kind":13},{"containerName":"splice","kind":12,"name":"warn","line":284},{"line":288,"kind":13,"containerName":"splice","name":"@remove_nodes"},{"line":288,"kind":13,"containerName":"splice","name":"$self"},{"containerName":"splice","kind":12,"name":"get_nodes","line":288},{"line":290,"containerName":"splice","kind":13,"name":"@keep_nodes"},{"line":291,"kind":13,"localvar":"my","containerName":"splice","name":"%keep_iids","definition":"my"},{"line":291,"kind":12,"containerName":"splice","name":"internal_id"},{"line":291,"kind":13,"containerName":"splice","name":"@keep_nodes"},{"definition":"my","localvar":"my","containerName":"splice","kind":13,"name":"$node","line":292},{"line":292,"containerName":"splice","kind":13,"name":"@remove_nodes"},{"name":"@nodes_to_remove","kind":13,"containerName":"splice","line":293},{"name":"$node","kind":13,"containerName":"splice","line":293},{"name":"$keep_iids","containerName":"splice","kind":13,"line":293},{"containerName":"splice","kind":13,"name":"$node","line":293},{"line":293,"name":"internal_id","kind":12,"containerName":"splice"},{"name":"@nodes_to_remove","kind":13,"containerName":"splice","line":297},{"line":297,"kind":13,"containerName":"splice","name":"@remove_nodes"}],"containerName":"main::","name":"splice","definition":"sub","detail":"($self,@args)","line":248,"range":{"end":{"line":299,"character":9999},"start":{"line":248,"character":0}},"kind":12,"signature":{"label":"splice($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default."}},{"name":"%root_descs","kind":13,"localvar":"my","containerName":null,"line":303,"definition":"my"},{"definition":"my","name":"$reroot","kind":13,"localvar":"my","containerName":null,"line":304},{"line":305,"name":"$node","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":305,"name":"@nodes_to_remove","kind":13,"containerName":null},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"@descs","line":306},{"line":306,"containerName":null,"kind":13,"name":"$node"},{"kind":12,"containerName":"main::","name":"each_Descendent","line":306},{"definition":"my","name":"$ancestor","localvar":"my","kind":13,"containerName":null,"line":307},{"containerName":null,"kind":13,"name":"$node","line":307},{"line":307,"kind":12,"containerName":"main::","name":"ancestor"},{"name":"$ancestor","kind":13,"containerName":null,"line":308},{"line":308,"kind":13,"containerName":null,"name":"%reroot"},{"line":311,"name":"$reroot","containerName":null,"kind":13},{"name":"%root_descs","containerName":null,"kind":13,"line":312},{"containerName":"main::","kind":12,"name":"internal_id","line":312},{"containerName":null,"kind":13,"name":"@descs","line":312},{"kind":13,"containerName":null,"name":"$node","line":313},{"containerName":"main::","kind":12,"name":"remove_all_Descendents","line":313},{"name":"%root_descs","containerName":null,"kind":13,"line":316},{"line":316,"containerName":null,"kind":13,"name":"$node"},{"name":"internal_id","kind":12,"containerName":"main::","line":316},{"line":318,"name":"%root_descs","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$node","line":318},{"containerName":"main::","kind":12,"name":"internal_id","line":318},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$desc","line":320},{"name":"@descs","kind":13,"containerName":null,"line":320},{"line":321,"name":"%root_descs","containerName":null,"kind":13},{"line":321,"name":"$desc","containerName":null,"kind":13},{"name":"internal_id","containerName":"main::","kind":12,"line":321},{"line":321,"name":"$desc","containerName":null,"kind":13},{"definition":"my","name":"$desc","kind":13,"localvar":"my","containerName":null,"line":326},{"name":"@descs","containerName":null,"kind":13,"line":326},{"kind":13,"containerName":null,"name":"$desc","line":327},{"kind":12,"containerName":"main::","name":"ancestor","line":327},{"line":327,"kind":13,"containerName":null,"name":"$ancestor"},{"line":328,"name":"$desc","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"branch_length","line":328},{"line":328,"name":"$desc","containerName":null,"kind":13},{"line":328,"name":"branch_length","containerName":"main::","kind":12},{"name":"$node","kind":13,"containerName":null,"line":328},{"line":328,"name":"branch_length","kind":12,"containerName":"main::"},{"name":"$preserve_lengths","containerName":null,"kind":13,"line":328},{"line":330,"name":"$node","containerName":null,"kind":13},{"name":"ancestor","kind":12,"containerName":"main::","line":330},{"name":"%reroot","kind":13,"containerName":null,"line":332},{"definition":"my","line":333,"name":"@candidates","kind":13,"localvar":"my","containerName":null},{"containerName":null,"kind":13,"name":"%root_descs","line":333},{"containerName":null,"kind":13,"name":"$self","line":334},{"line":334,"containerName":"main::","kind":12,"name":"throw"},{"line":334,"kind":13,"containerName":null,"name":"@candidates"},{"line":335,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"throw","line":335},{"line":335,"containerName":null,"kind":13,"name":"@candidates"},{"line":336,"name":"$self","kind":13,"containerName":null},{"name":"set_root_node","kind":12,"containerName":"main::","line":336},{"kind":13,"containerName":null,"name":"@candidates","line":336},{"kind":12,"range":{"start":{"line":353,"character":0},"end":{"line":359,"character":9999}},"line":353,"signature":{"label":"get_lca($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes"},"name":"get_lca","containerName":"main::","children":[{"definition":"my","line":354,"kind":13,"localvar":"my","containerName":"get_lca","name":"$self"},{"line":354,"kind":13,"containerName":"get_lca","name":"@args"},{"containerName":"get_lca","localvar":"my","kind":13,"name":"$nodes","line":355,"definition":"my"},{"line":355,"kind":13,"containerName":"get_lca","name":"$self"},{"line":355,"name":"_rearrange","containerName":"get_lca","kind":12},{"line":355,"containerName":"get_lca","kind":13,"name":"@args"},{"line":356,"name":"@nodes","kind":13,"localvar":"my","containerName":"get_lca","definition":"my"},{"name":"$nodes","kind":13,"containerName":"get_lca","line":357},{"containerName":"get_lca","kind":13,"name":"@nodes","line":358},{"line":358,"name":"$nodes","containerName":"get_lca","kind":13}],"detail":"($self,@args)","definition":"sub"},{"line":361,"name":"@nodes","containerName":null,"kind":13},{"line":361,"containerName":null,"kind":13,"name":"@args"},{"name":"@nodes","kind":13,"containerName":null,"line":363},{"containerName":null,"kind":13,"name":"$self","line":363},{"line":363,"containerName":"main::","kind":12,"name":"throw"},{"definition":"my","line":372,"containerName":null,"localvar":"my","kind":13,"name":"@paths"},{"name":"$node","containerName":null,"localvar":"my","kind":13,"line":373,"definition":"my"},{"line":373,"containerName":null,"kind":13,"name":"@nodes"},{"line":374,"containerName":null,"kind":13,"name":"$node"},{"line":374,"containerName":null,"kind":13,"name":"$node"},{"line":374,"kind":12,"containerName":"main::","name":"isa"},{"line":375,"containerName":null,"kind":13,"name":"$self"},{"line":375,"name":"throw","containerName":"main::","kind":12},{"line":377,"name":"@path","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":null,"kind":13,"line":377},{"line":377,"name":"get_lineage_nodes","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$node","line":377},{"name":"$node","kind":13,"containerName":null,"line":377},{"name":"@paths","containerName":null,"kind":13,"line":378},{"name":"@path","kind":13,"containerName":null,"line":378},{"line":380,"containerName":null,"kind":13,"name":"@paths"},{"name":"$lca","localvar":"my","containerName":null,"kind":13,"line":381,"definition":"my"},{"line":382,"name":"LEVEL","kind":12},{"name":"@paths","containerName":null,"kind":13,"line":382},{"definition":"my","line":383,"name":"%node_ids","containerName":null,"localvar":"my","kind":13},{"definition":"my","name":"$node","localvar":"my","containerName":null,"kind":13,"line":384},{"line":385,"containerName":null,"localvar":"my","kind":13,"name":"$path","definition":"my"},{"name":"@paths","containerName":null,"kind":13,"line":385},{"line":386,"name":"$node","containerName":null,"kind":13},{"line":386,"kind":13,"containerName":null,"name":"$path"},{"line":386,"name":"LEVEL","kind":12},{"line":387,"name":"$node_id","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"$node","line":387},{"kind":12,"containerName":"main::","name":"internal_id","line":387},{"name":"%node_id","kind":13,"containerName":null,"line":388},{"name":"$self","containerName":null,"kind":13,"line":389},{"line":389,"name":"warn","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"%node_ids","line":392},{"kind":13,"containerName":null,"name":"$node_id","line":392},{"line":394,"containerName":null,"kind":13,"name":"%node_ids"},{"containerName":null,"kind":13,"name":"$lca","line":395},{"line":395,"containerName":null,"kind":13,"name":"%node"},{"name":"LEVEL","kind":12,"line":400},{"line":406,"kind":13,"containerName":null,"name":"$lca"},{"line":406,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"number_nodes","line":406},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$own_lca","line":407},{"line":407,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"find_node","line":407},{"kind":13,"containerName":null,"name":"$lca","line":407},{"kind":12,"containerName":"main::","name":"internal_id","line":407},{"line":408,"containerName":null,"kind":13,"name":"$lca"},{"line":408,"name":"$own_lca","containerName":null,"kind":13},{"line":408,"name":"$own_lca","kind":13,"containerName":null},{"line":410,"kind":13,"containerName":null,"name":"$lca"},{"children":[{"line":445,"localvar":"my","containerName":"merge_lineage","kind":13,"name":"$self","definition":"my"},{"containerName":"merge_lineage","kind":13,"name":"$thing","line":445},{"kind":13,"containerName":"merge_lineage","name":"$self","line":446},{"name":"throw","containerName":"merge_lineage","kind":12,"line":446},{"line":446,"name":"$thing","kind":13,"containerName":"merge_lineage"},{"line":448,"name":"$lineage_tree","localvar":"my","containerName":"merge_lineage","kind":13,"definition":"my"},{"line":448,"containerName":"merge_lineage","kind":13,"name":"$lineage_leaf"},{"line":449,"name":"$thing","kind":13,"containerName":"merge_lineage"},{"line":449,"name":"isa","containerName":"merge_lineage","kind":12},{"definition":"my","localvar":"my","containerName":"merge_lineage","kind":13,"name":"@leaves","line":450},{"line":450,"name":"$thing","kind":13,"containerName":"merge_lineage"},{"name":"get_leaf_nodes","containerName":"merge_lineage","kind":12,"line":450},{"line":451,"containerName":"merge_lineage","kind":13,"name":"$self"},{"name":"throw","containerName":"merge_lineage","kind":12,"line":451},{"line":451,"name":"@leaves","kind":13,"containerName":"merge_lineage"},{"containerName":"merge_lineage","kind":13,"name":"$lineage_tree","line":452},{"name":"$thing","kind":13,"containerName":"merge_lineage","line":452},{"containerName":"merge_lineage","kind":13,"name":"$lineage_leaf","line":453},{"line":453,"name":"@leaves","containerName":"merge_lineage","kind":13},{"line":455,"containerName":"merge_lineage","kind":13,"name":"$thing"},{"containerName":"merge_lineage","kind":12,"name":"isa","line":455},{"line":456,"containerName":"merge_lineage","kind":13,"name":"$self"},{"line":456,"kind":12,"containerName":"merge_lineage","name":"throw"},{"containerName":"merge_lineage","kind":13,"name":"$thing","line":456},{"line":456,"name":"ancestor","containerName":"merge_lineage","kind":12},{"line":457,"name":"$lineage_tree","containerName":"merge_lineage","kind":13},{"line":457,"kind":13,"containerName":"merge_lineage","name":"$self"},{"line":457,"name":"new","containerName":"merge_lineage","kind":12},{"line":457,"name":"$thing","kind":13,"containerName":"merge_lineage"},{"containerName":"merge_lineage","kind":13,"name":"$lineage_leaf","line":458},{"name":"$thing","kind":13,"containerName":"merge_lineage","line":458},{"definition":"my","line":463,"localvar":"my","containerName":"merge_lineage","kind":13,"name":"@lineage"},{"line":463,"kind":13,"containerName":"merge_lineage","name":"$lineage_leaf"},{"line":463,"name":"$self","kind":13,"containerName":"merge_lineage"},{"name":"get_lineage_nodes","kind":12,"containerName":"merge_lineage","line":463},{"line":463,"name":"$lineage_leaf","kind":13,"containerName":"merge_lineage"},{"name":"$merged","containerName":"merge_lineage","localvar":"my","kind":13,"line":464,"definition":"my"},{"definition":"my","name":"$i","containerName":"merge_lineage","localvar":"my","kind":13,"line":465},{"definition":"my","line":466,"name":"$lca","localvar":"my","kind":13,"containerName":"merge_lineage"},{"line":466,"containerName":"merge_lineage","kind":13,"name":"$self"},{"containerName":"merge_lineage","kind":12,"name":"find_node","line":466},{"kind":13,"containerName":"merge_lineage","name":"$lineage","line":466},{"containerName":"merge_lineage","kind":13,"name":"$i","line":466},{"line":466,"kind":12,"containerName":"merge_lineage","name":"internal_id"},{"name":"$i","kind":13,"containerName":"merge_lineage","line":468},{"containerName":"merge_lineage","kind":13,"name":"$lca","line":474},{"line":474,"containerName":"merge_lineage","kind":12,"name":"add_Descendent"},{"kind":13,"containerName":"merge_lineage","name":"$lineage","line":474},{"line":474,"containerName":"merge_lineage","kind":13,"name":"$i"},{"line":475,"name":"$merged","containerName":"merge_lineage","kind":13},{"line":478,"kind":13,"containerName":"merge_lineage","name":"$merged"},{"name":"$self","containerName":"merge_lineage","kind":13,"line":478},{"kind":12,"containerName":"merge_lineage","name":"warn","line":478},{"containerName":"merge_lineage","kind":13,"name":"$lineage_leaf","line":478},{"name":"id","kind":12,"containerName":"merge_lineage","line":478}],"name":"merge_lineage","containerName":"main::","definition":"sub","detail":"($self,$thing)","line":444,"range":{"end":{"character":9999,"line":479},"start":{"line":444,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$thing"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D","label":"merge_lineage($self,$thing)"}},{"line":465,"name":"lineage","kind":12},{"containerName":"main::","name":"contract_linear_paths","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"contract_linear_paths","line":518},{"containerName":"contract_linear_paths","localvar":"my","kind":13,"name":"$reroot","line":519,"definition":"my"},{"definition":"my","name":"@remove","containerName":"contract_linear_paths","localvar":"my","kind":13,"line":520},{"line":521,"localvar":"my","containerName":"contract_linear_paths","kind":13,"name":"$node","definition":"my"},{"line":521,"name":"$self","containerName":"contract_linear_paths","kind":13},{"name":"get_nodes","kind":12,"containerName":"contract_linear_paths","line":521},{"name":"$node","containerName":"contract_linear_paths","kind":13,"line":522},{"containerName":"contract_linear_paths","kind":12,"name":"ancestor","line":522},{"line":522,"name":"$node","containerName":"contract_linear_paths","kind":13},{"line":522,"name":"each_Descendent","kind":12,"containerName":"contract_linear_paths"},{"line":523,"name":"@remove","containerName":"contract_linear_paths","kind":13},{"line":523,"containerName":"contract_linear_paths","kind":13,"name":"$node"},{"containerName":"contract_linear_paths","kind":13,"name":"$self","line":526},{"line":526,"kind":12,"containerName":"contract_linear_paths","name":"splice"},{"name":"@remove","containerName":"contract_linear_paths","kind":13,"line":526},{"line":526,"name":"@remove","kind":13,"containerName":"contract_linear_paths"},{"line":527,"containerName":"contract_linear_paths","kind":13,"name":"$reroot"},{"name":"$root","localvar":"my","containerName":"contract_linear_paths","kind":13,"line":528,"definition":"my"},{"line":528,"containerName":"contract_linear_paths","kind":13,"name":"$self"},{"line":528,"name":"get_root_node","containerName":"contract_linear_paths","kind":12},{"definition":"my","name":"@descs","localvar":"my","kind":13,"containerName":"contract_linear_paths","line":529},{"containerName":"contract_linear_paths","kind":13,"name":"$root","line":529},{"containerName":"contract_linear_paths","kind":12,"name":"each_Descendent","line":529},{"line":530,"kind":13,"containerName":"contract_linear_paths","name":"@descs"},{"definition":"my","containerName":"contract_linear_paths","localvar":"my","kind":13,"name":"$new_root","line":531},{"line":531,"name":"@descs","containerName":"contract_linear_paths","kind":13},{"name":"$self","kind":13,"containerName":"contract_linear_paths","line":532},{"line":532,"name":"set_root_node","containerName":"contract_linear_paths","kind":12},{"line":532,"containerName":"contract_linear_paths","kind":13,"name":"$new_root"},{"name":"$new_root","kind":13,"containerName":"contract_linear_paths","line":533},{"line":533,"name":"ancestor","kind":12,"containerName":"contract_linear_paths"}],"definition":"sub","range":{"end":{"line":536,"character":9999},"start":{"line":517,"character":0}},"kind":12,"line":517},{"children":[],"containerName":"main::","name":"is_binary","definition":"sub","line":551,"range":{"start":{"line":551,"character":0},"end":{"line":551,"character":9999}},"kind":12},{"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"is_binary","name":"$self","line":554},{"definition":"my","line":555,"kind":13,"localvar":"my","containerName":"is_binary","name":"$node"},{"containerName":"is_binary","kind":13,"name":"$self","line":555},{"containerName":"is_binary","kind":12,"name":"get_root_node","line":555},{"definition":"my","line":557,"name":"$binary","localvar":"my","kind":13,"containerName":"is_binary"},{"name":"@descs","containerName":"is_binary","localvar":"my","kind":13,"line":558,"definition":"my"},{"name":"$node","containerName":"is_binary","kind":13,"line":558},{"name":"each_Descendent","kind":12,"containerName":"is_binary","line":558},{"line":559,"containerName":"is_binary","kind":13,"name":"$binary"},{"line":559,"name":"@descs","kind":13,"containerName":"is_binary"},{"kind":13,"containerName":"is_binary","name":"@descs","line":559},{"definition":"my","line":563,"name":"$desc","containerName":"is_binary","localvar":"my","kind":13},{"line":563,"name":"@descs","containerName":"is_binary","kind":13},{"line":564,"name":"$binary","containerName":"is_binary","kind":13},{"kind":13,"containerName":"is_binary","name":"$self","line":564},{"line":564,"name":"is_binary","containerName":"is_binary","kind":12},{"line":564,"kind":13,"containerName":"is_binary","name":"$desc"},{"name":"$binary","kind":13,"containerName":"is_binary","line":566},{"name":"$binary","containerName":"is_binary","kind":13,"line":566},{"line":567,"name":"$binary","containerName":"is_binary","kind":13}],"containerName":"main::","name":"is_binary","line":553,"kind":12,"range":{"end":{"character":9999,"line":568},"start":{"character":0,"line":553}}},{"line":634,"kind":12,"range":{"start":{"character":0,"line":634},"end":{"line":678,"character":9999}},"definition":"sub","children":[{"definition":"my","line":635,"name":"$self","localvar":"my","kind":13,"containerName":"force_binary"},{"line":636,"name":"$node","containerName":"force_binary","localvar":"my","kind":13,"definition":"my"},{"line":636,"kind":13,"containerName":"force_binary","name":"$self"},{"line":636,"name":"get_root_node","kind":12,"containerName":"force_binary"},{"line":638,"localvar":"my","containerName":"force_binary","kind":13,"name":"@descs","definition":"my"},{"containerName":"force_binary","kind":13,"name":"$node","line":638},{"line":638,"name":"each_Descendent","kind":12,"containerName":"force_binary"},{"line":639,"name":"@descs","containerName":"force_binary","kind":13},{"line":640,"kind":13,"containerName":"force_binary","name":"$self"},{"line":640,"name":"warn","containerName":"force_binary","kind":12},{"name":"$node","containerName":"force_binary","kind":13,"line":640},{"name":"can","kind":12,"containerName":"force_binary","line":640},{"name":"$node","containerName":"force_binary","kind":13,"line":640},{"line":640,"name":"node_name","kind":12,"containerName":"force_binary"},{"line":640,"name":"$node","containerName":"force_binary","kind":13},{"name":"id","containerName":"force_binary","kind":12,"line":640},{"line":640,"containerName":"force_binary","kind":13,"name":"$node"},{"line":640,"containerName":"force_binary","kind":12,"name":"id"},{"name":"$node","kind":13,"containerName":"force_binary","line":642},{"line":642,"name":"can","kind":12,"containerName":"force_binary"},{"kind":13,"containerName":"force_binary","name":"$node","line":642},{"name":"node_name","containerName":"force_binary","kind":12,"line":642},{"line":642,"name":"$node","kind":13,"containerName":"force_binary"},{"name":"id","containerName":"force_binary","kind":12,"line":642},{"line":642,"kind":13,"containerName":"force_binary","name":"$node"},{"name":"id","containerName":"force_binary","kind":12,"line":642},{"line":642,"containerName":"force_binary","kind":13,"name":"@descs"},{"definition":"my","name":"@working","localvar":"my","containerName":"force_binary","kind":13,"line":644},{"containerName":"force_binary","kind":13,"name":"@descs","line":644},{"definition":"my","line":646,"kind":13,"localvar":"my","containerName":"force_binary","name":"$half"},{"kind":13,"containerName":"force_binary","name":"@working","line":646},{"containerName":"force_binary","kind":13,"name":"$half","line":647},{"line":647,"containerName":"force_binary","kind":13,"name":"$half"},{"line":647,"containerName":"force_binary","kind":13,"name":"$half"},{"kind":13,"containerName":"force_binary","name":"$half","line":648},{"name":"$half","kind":13,"containerName":"force_binary","line":648},{"line":649,"localvar":"my","kind":13,"containerName":"force_binary","name":"@artificials","definition":"my"},{"containerName":"force_binary","kind":13,"name":"$half","line":650},{"line":651,"name":"@this_level","kind":13,"localvar":"my","containerName":"force_binary","definition":"my"},{"line":652,"localvar":"my","kind":13,"containerName":"force_binary","name":"$top_node","definition":"my"},{"line":652,"kind":13,"containerName":"force_binary","name":"@artificials"},{"name":"$node","kind":13,"containerName":"force_binary","line":652},{"definition":"my","localvar":"my","containerName":"force_binary","kind":13,"name":"$art","line":654},{"name":"$top_node","containerName":"force_binary","kind":13,"line":654},{"line":654,"kind":12,"containerName":"force_binary","name":"new"},{"containerName":"force_binary","kind":13,"name":"$self","line":654},{"kind":13,"containerName":"force_binary","name":"$top_node","line":655},{"name":"add_Descendent","containerName":"force_binary","kind":12,"line":655},{"line":655,"name":"$art","kind":13,"containerName":"force_binary"},{"name":"@this_level","containerName":"force_binary","kind":13,"line":656},{"containerName":"force_binary","kind":13,"name":"$art","line":656},{"line":659,"name":"@artificials","kind":13,"containerName":"force_binary"},{"line":659,"containerName":"force_binary","kind":13,"name":"@this_level"},{"kind":13,"containerName":"force_binary","name":"$half","line":660},{"containerName":"force_binary","localvar":"my","kind":13,"name":"$art","line":663,"definition":"my"},{"name":"@artificials","containerName":"force_binary","kind":13,"line":663},{"name":"$desc","containerName":"force_binary","localvar":"my","kind":13,"line":665,"definition":"my"},{"name":"@working","kind":13,"containerName":"force_binary","line":665},{"kind":13,"containerName":"force_binary","name":"$node","line":665},{"line":665,"containerName":"force_binary","kind":12,"name":"new"},{"containerName":"force_binary","kind":13,"name":"$self","line":665},{"containerName":"force_binary","kind":13,"name":"$desc","line":666},{"name":"ancestor","kind":12,"containerName":"force_binary","line":666},{"containerName":"force_binary","kind":13,"name":"$art","line":666},{"line":670,"kind":13,"containerName":"force_binary","name":"@descs"},{"line":672,"name":"$node","containerName":"force_binary","kind":13},{"line":672,"containerName":"force_binary","kind":12,"name":"add_Descendent"},{"kind":13,"containerName":"force_binary","name":"$node","line":672},{"line":672,"name":"new","containerName":"force_binary","kind":12},{"kind":13,"containerName":"force_binary","name":"$self","line":672},{"line":675,"name":"$desc","localvar":"my","containerName":"force_binary","kind":13,"definition":"my"},{"name":"@descs","containerName":"force_binary","kind":13,"line":675},{"line":676,"containerName":"force_binary","kind":13,"name":"$self"},{"kind":12,"containerName":"force_binary","name":"force_binary","line":676},{"name":"$desc","kind":13,"containerName":"force_binary","line":676}],"name":"force_binary","containerName":"main::"},{"line":654,"name":"_art_num","kind":12},{"line":665,"name":"_art_num","kind":12},{"line":672,"name":"_art_num","kind":12},{"range":{"start":{"line":694,"character":0},"end":{"character":9999,"line":715}},"kind":12,"line":694,"definition":"sub","name":"simplify_to_leaves_string","containerName":"main::","children":[{"localvar":"my","containerName":"simplify_to_leaves_string","kind":13,"name":"$self","line":695,"definition":"my"},{"name":"$tree","localvar":"my","containerName":"simplify_to_leaves_string","kind":13,"line":701,"definition":"my"},{"line":701,"containerName":"simplify_to_leaves_string","kind":13,"name":"$self"},{"line":701,"name":"_clone","kind":12,"containerName":"simplify_to_leaves_string"},{"kind":13,"containerName":"simplify_to_leaves_string","name":"$tree","line":703},{"line":703,"kind":12,"containerName":"simplify_to_leaves_string","name":"contract_linear_paths"},{"containerName":"simplify_to_leaves_string","kind":13,"name":"$tree","line":704},{"containerName":"simplify_to_leaves_string","kind":12,"name":"force_binary","line":704},{"definition":"my","containerName":"simplify_to_leaves_string","localvar":"my","kind":13,"name":"$node","line":705},{"name":"$tree","kind":13,"containerName":"simplify_to_leaves_string","line":705},{"name":"get_nodes","kind":12,"containerName":"simplify_to_leaves_string","line":705},{"definition":"my","name":"$id","localvar":"my","containerName":"simplify_to_leaves_string","kind":13,"line":706},{"line":706,"kind":13,"containerName":"simplify_to_leaves_string","name":"$node"},{"kind":12,"containerName":"simplify_to_leaves_string","name":"id","line":706},{"name":"$id","kind":13,"containerName":"simplify_to_leaves_string","line":707},{"containerName":"simplify_to_leaves_string","kind":13,"name":"$node","line":707},{"line":707,"kind":12,"containerName":"simplify_to_leaves_string","name":"is_Leaf"},{"kind":13,"containerName":"simplify_to_leaves_string","name":"$id","line":707},{"line":707,"name":"$id","containerName":"simplify_to_leaves_string","kind":13},{"name":"$node","containerName":"simplify_to_leaves_string","kind":13,"line":708},{"line":708,"name":"id","containerName":"simplify_to_leaves_string","kind":12},{"name":"$id","kind":13,"containerName":"simplify_to_leaves_string","line":708},{"definition":"my","line":711,"containerName":"simplify_to_leaves_string","localvar":"my","kind":13,"name":"%paired"},{"definition":"my","localvar":"my","kind":13,"containerName":"simplify_to_leaves_string","name":"@data","line":712},{"containerName":"simplify_to_leaves_string","kind":13,"name":"$self","line":712},{"line":712,"kind":12,"containerName":"simplify_to_leaves_string","name":"_simplify_helper"},{"line":712,"containerName":"simplify_to_leaves_string","kind":13,"name":"$tree"},{"line":712,"kind":12,"containerName":"simplify_to_leaves_string","name":"get_root_node"},{"line":712,"name":"%paired","containerName":"simplify_to_leaves_string","kind":13},{"line":714,"name":"@data","containerName":"simplify_to_leaves_string","kind":13}]},{"signature":{"label":"clone($self,$parent,$parent_clone)","documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object","parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$parent_clone"}]},"line":732,"range":{"start":{"character":0,"line":732},"end":{"character":9999,"line":746}},"kind":12,"definition":"sub","detail":"($self,$parent,$parent_clone)","children":[{"name":"$self","containerName":"clone","localvar":"my","kind":13,"line":733,"definition":"my"},{"line":733,"name":"$parent","kind":13,"containerName":"clone"},{"kind":13,"containerName":"clone","name":"$parent_clone","line":733},{"name":"$parent","kind":13,"containerName":"clone","line":734},{"containerName":"clone","kind":13,"name":"$self","line":734},{"name":"get_root_node","containerName":"clone","kind":12,"line":734},{"name":"$parent_clone","containerName":"clone","kind":13,"line":735},{"name":"$self","containerName":"clone","kind":13,"line":735},{"name":"_clone_node","kind":12,"containerName":"clone","line":735},{"line":735,"name":"$parent","kind":13,"containerName":"clone"},{"definition":"my","line":737,"localvar":"my","kind":13,"containerName":"clone","name":"$node"},{"line":737,"kind":13,"containerName":"clone","name":"$parent"},{"line":737,"kind":12,"containerName":"clone","name":"each_Descendent"},{"line":738,"kind":13,"localvar":"my","containerName":"clone","name":"$child","definition":"my"},{"name":"$self","containerName":"clone","kind":13,"line":738},{"line":738,"name":"_clone_node","kind":12,"containerName":"clone"},{"containerName":"clone","kind":13,"name":"$node","line":738},{"containerName":"clone","kind":13,"name":"$child","line":739},{"name":"ancestor","containerName":"clone","kind":12,"line":739},{"containerName":"clone","kind":13,"name":"$parent_clone","line":739},{"name":"$self","kind":13,"containerName":"clone","line":740},{"name":"_clone","containerName":"clone","kind":12,"line":740},{"name":"$node","kind":13,"containerName":"clone","line":740},{"line":740,"name":"$child","kind":13,"containerName":"clone"},{"kind":13,"containerName":"clone","name":"$parent","line":742},{"line":742,"containerName":"clone","kind":12,"name":"ancestor"},{"definition":"my","line":744,"name":"$tree","localvar":"my","containerName":"clone","kind":13},{"kind":13,"containerName":"clone","name":"$self","line":744},{"line":744,"name":"new","kind":12,"containerName":"clone"},{"kind":13,"containerName":"clone","name":"$parent_clone","line":744},{"containerName":"clone","kind":13,"name":"$tree","line":745}],"name":"clone","containerName":"main::"},{"line":749,"kind":12,"range":{"start":{"line":749,"character":0},"end":{"line":749,"character":9999}},"children":[{"line":749,"name":"clone","kind":12,"containerName":"_clone"}],"name":"_clone","containerName":"main::","definition":"sub"},{"definition":"sub","detail":"($self,$node)","children":[{"definition":"my","containerName":"_clone_node","localvar":"my","kind":13,"name":"$self","line":754},{"containerName":"_clone_node","kind":13,"name":"$node","line":754},{"line":755,"name":"$clone","containerName":"_clone_node","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_clone_node","name":"$node","line":755},{"line":755,"kind":12,"containerName":"_clone_node","name":"new"},{"localvar":"my","kind":13,"containerName":"_clone_node","name":"$key","line":757,"definition":"my"},{"name":"$val","containerName":"_clone_node","kind":13,"line":757},{"name":"$node","containerName":"_clone_node","kind":13,"line":757}],"name":"_clone_node","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$node"}],"documentation":" safe node clone that doesn't seg fault, but deliberately loses ancestors and\n descendents","label":"_clone_node($self,$node)"},"line":753,"range":{"start":{"line":753,"character":0},"end":{"line":757,"character":9999}},"kind":12},{"containerName":null,"kind":13,"name":"$key","line":758},{"name":"%key","containerName":null,"kind":13,"line":758},{"line":761,"name":"%clone","containerName":null,"kind":13},{"line":761,"name":"$key","kind":13,"containerName":null},{"line":761,"name":"$val","kind":13,"containerName":null},{"line":764,"name":"$clone","kind":13,"containerName":null},{"signature":{"parameters":[{"label":"$self"},{"label":"$node"},{"label":"$paired"}],"documentation":" tree string generator for simplify_to_leaves_string, based on\n Bio::TreeIO::newick::_write_tree_Helper","label":"_simplify_helper($self,$node,$paired)"},"line":769,"range":{"start":{"line":769,"character":0},"end":{"character":9999,"line":784}},"kind":12,"definition":"sub","detail":"($self,$node,$paired)","children":[{"line":770,"name":"$self","kind":13,"localvar":"my","containerName":"_simplify_helper","definition":"my"},{"name":"$node","kind":13,"containerName":"_simplify_helper","line":770},{"name":"$paired","containerName":"_simplify_helper","kind":13,"line":770},{"kind":13,"containerName":"_simplify_helper","name":"$node","line":771},{"containerName":"_simplify_helper","localvar":"my","kind":13,"name":"@data","line":773,"definition":"my"},{"definition":"my","line":774,"kind":13,"localvar":"my","containerName":"_simplify_helper","name":"$node"},{"line":774,"containerName":"_simplify_helper","kind":13,"name":"$node"},{"line":774,"kind":12,"containerName":"_simplify_helper","name":"each_Descendent"},{"line":775,"name":"@data","kind":13,"containerName":"_simplify_helper"},{"containerName":"_simplify_helper","kind":13,"name":"$self","line":775},{"line":775,"name":"_simplify_helper","kind":12,"containerName":"_simplify_helper"},{"name":"$node","kind":13,"containerName":"_simplify_helper","line":775},{"line":775,"name":"$paired","containerName":"_simplify_helper","kind":13},{"definition":"my","line":778,"localvar":"my","kind":13,"containerName":"_simplify_helper","name":"$id"},{"line":778,"kind":13,"containerName":"_simplify_helper","name":"$node"},{"line":778,"name":"id_output","containerName":"_simplify_helper","kind":12},{"containerName":"_simplify_helper","kind":13,"name":"@data","line":779},{"line":780,"containerName":"_simplify_helper","kind":13,"name":"$paired"},{"line":780,"name":"@data","kind":13,"containerName":"_simplify_helper"},{"line":781,"containerName":"_simplify_helper","kind":13,"name":"$data"},{"name":"$data","kind":13,"containerName":"_simplify_helper","line":781},{"containerName":"_simplify_helper","kind":13,"name":"$data","line":782},{"line":783,"name":"$paired","kind":13,"containerName":"_simplify_helper"}],"containerName":"main::","name":"_simplify_helper"},{"containerName":null,"kind":13,"name":"%id","line":786},{"line":787,"kind":13,"containerName":null,"name":"@data"},{"containerName":null,"kind":13,"name":"$id","line":787},{"line":790,"containerName":null,"kind":13,"name":"@data"},{"signature":{"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object\n\n\nsub clone {\n    my ($self, $parent, $parent_clone) = @_;\n    $parent ||= $self->get_root_node;\n    $parent_clone ||= $self->_clone_node($parent);\n\n    foreach my $node ($parent->each_Descendent()) {\n        my $child = $self->_clone_node($node);\n        $child->ancestor($parent_clone);\n        $self->_clone($node, $child);\n    }\n    $parent->ancestor && return;\n\n    my $tree = $self->new(-root => $parent_clone);\n    return $tree;\n}\n\n# alias\nsub _clone { shift->clone(@_) }\n\n# safe node clone that doesn't seg fault, but deliberately loses ancestors and\n# descendents\nsub _clone_node {\n    my ($self, $node) = @_;\n    my $clone = $node->new;\n\n    while (my ($key, $val) = each %{$node}) {\n        if ($key eq '_desc' || $key eq '_ancestor') {\n            next;\n        }\n        ${$clone}{$key} = $val;\n    }\n\n    return $clone;\n}\n\n# tree string generator for simplify_to_leaves_string, based on\n# Bio::TreeIO::newick::_write_tree_Helper\nsub _simplify_helper {\n    my ($self, $node, $paired) = @_;\n    return () if (!defined $node);\n\n    my @data = ();\n    foreach my $node ($node->each_Descendent()) {\n        push(@data, $self->_simplify_helper($node, $paired));\n    }\n\n    my $id = $node->id_output || '';\n    if (@data) {\n        unless (exists ${$paired}{\"@data\"} || @data == 1)  {\n            $data[0] = \"(\" . $data[0];\n            $data[-1] .= \")\";\n            ${$paired}{\"@data\"} = 1;\n        }\n    }\n    elsif ($id) {\n        push(@data, $id);\n    }\n\n    return @data;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : distance(-nodes => \\@nodes )\n Function: returns the distance between two given nodes\n Returns : numerical distance\n Args    : -nodes => arrayref of nodes to test","parameters":[{"label":"$self"},{"label":"@args"}],"label":"distance($self,@args)"},"line":803,"kind":12,"range":{"start":{"character":0,"line":803},"end":{"line":810,"character":9999}},"definition":"sub","detail":"($self,@args)","children":[{"line":804,"localvar":"my","containerName":"distance","kind":13,"name":"$self","definition":"my"},{"line":804,"name":"@args","kind":13,"containerName":"distance"},{"line":805,"name":"$nodes","localvar":"my","kind":13,"containerName":"distance","definition":"my"},{"line":805,"kind":13,"containerName":"distance","name":"$self"},{"containerName":"distance","kind":12,"name":"_rearrange","line":805},{"name":"@args","containerName":"distance","kind":13,"line":805},{"line":806,"kind":13,"containerName":"distance","name":"$nodes"},{"name":"$self","containerName":"distance","kind":13,"line":807},{"line":807,"containerName":"distance","kind":12,"name":"warn"},{"line":810,"name":"$self","containerName":"distance","kind":13},{"line":810,"name":"throw","kind":12,"containerName":"distance"},{"line":810,"name":"$nodes","kind":13,"containerName":"distance"}],"containerName":"main::","name":"distance"},{"name":"$lca","containerName":null,"localvar":"my","kind":13,"line":812,"definition":"my"},{"name":"$self","containerName":null,"kind":13,"line":812},{"kind":12,"containerName":"main::","name":"get_lca","line":812},{"line":812,"containerName":null,"kind":13,"name":"$nodes"},{"line":813,"kind":13,"containerName":null,"name":"%lca"},{"containerName":null,"kind":13,"name":"$self","line":814},{"line":814,"kind":12,"containerName":"main::","name":"warn"},{"name":"$cumul_dist","localvar":"my","kind":13,"containerName":null,"line":818,"definition":"my"},{"line":819,"localvar":"my","containerName":null,"kind":13,"name":"$warned","definition":"my"},{"definition":"my","line":820,"name":"$current_node","containerName":null,"localvar":"my","kind":13},{"kind":13,"containerName":null,"name":"%nodes","line":820},{"name":"$current_node","containerName":null,"kind":13,"line":822},{"line":822,"containerName":null,"kind":13,"name":"$lca"},{"line":823,"kind":13,"containerName":null,"name":"$current_node"},{"line":823,"name":"branch_length","kind":12,"containerName":"main::"},{"name":"$cumul_dist","containerName":null,"kind":13,"line":824},{"line":824,"kind":13,"containerName":null,"name":"$current_node"},{"line":824,"name":"branch_length","kind":12,"containerName":"main::"},{"line":826,"containerName":null,"kind":13,"name":"%warned"},{"line":827,"name":"$self","kind":13,"containerName":null},{"line":827,"name":"warn","containerName":"main::","kind":12},{"name":"$warned","kind":13,"containerName":null,"line":828},{"kind":13,"containerName":null,"name":"$current_node","line":831},{"line":831,"kind":13,"containerName":null,"name":"$current_node"},{"line":831,"name":"ancestor","kind":12,"containerName":"main::"},{"name":"$cumul_dist","kind":13,"containerName":null,"line":835},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object\n\n\nsub clone {\n    my ($self, $parent, $parent_clone) = @_;\n    $parent ||= $self->get_root_node;\n    $parent_clone ||= $self->_clone_node($parent);\n\n    foreach my $node ($parent->each_Descendent()) {\n        my $child = $self->_clone_node($node);\n        $child->ancestor($parent_clone);\n        $self->_clone($node, $child);\n    }\n    $parent->ancestor && return;\n\n    my $tree = $self->new(-root => $parent_clone);\n    return $tree;\n}\n\n# alias\nsub _clone { shift->clone(@_) }\n\n# safe node clone that doesn't seg fault, but deliberately loses ancestors and\n# descendents\nsub _clone_node {\n    my ($self, $node) = @_;\n    my $clone = $node->new;\n\n    while (my ($key, $val) = each %{$node}) {\n        if ($key eq '_desc' || $key eq '_ancestor') {\n            next;\n        }\n        ${$clone}{$key} = $val;\n    }\n\n    return $clone;\n}\n\n# tree string generator for simplify_to_leaves_string, based on\n# Bio::TreeIO::newick::_write_tree_Helper\nsub _simplify_helper {\n    my ($self, $node, $paired) = @_;\n    return () if (!defined $node);\n\n    my @data = ();\n    foreach my $node ($node->each_Descendent()) {\n        push(@data, $self->_simplify_helper($node, $paired));\n    }\n\n    my $id = $node->id_output || '';\n    if (@data) {\n        unless (exists ${$paired}{\"@data\"} || @data == 1)  {\n            $data[0] = \"(\" . $data[0];\n            $data[-1] .= \")\";\n            ${$paired}{\"@data\"} = 1;\n        }\n    }\n    elsif ($id) {\n        push(@data, $id);\n    }\n\n    return @data;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : distance(-nodes => \\@nodes )\n Function: returns the distance between two given nodes\n Returns : numerical distance\n Args    : -nodes => arrayref of nodes to test\n\n\nsub distance {\n    my ($self,@args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    if( ! defined $nodes ) {\n\t$self->warn(\"Must supply -nodes parameter to distance() method\");\n\treturn;\n    }\n    $self->throw(\"Must provide 2 nodes\") unless @{$nodes} == 2;\n\n    my $lca = $self->get_lca(@{$nodes});\n    unless($lca) { \n        $self->warn(\"could not find the lca of supplied nodes; can't find distance either\");\n        return;\n    }\n\n    my $cumul_dist = 0;\n    my $warned = 0;\n    foreach my $current_node (@{$nodes}) {\n        while (1) {\n            last if $current_node eq $lca;\n            if ($current_node->branch_length) {\n                $cumul_dist += $current_node->branch_length;\n            }\n            elsif (! $warned) {\n                $self->warn(\"At least some nodes do not have a branch length, the distance returned could be wrong\");\n                $warned = 1;\n            }\n\n            $current_node = $current_node->ancestor || last;\n        }\n    }\n\n    return $cumul_dist;\n}\n\n=head2 is_monophyletic\n\n Title   : is_monophyletic\n Usage   : if( $tree->is_monophyletic(-nodes => \\@nodes, \n\t\t\t\t      -outgroup => $outgroup)\n Function: Will do a test of monophyly for the nodes specified\n           in comparison to a chosen outgroup\n Returns : boolean\n Args    : -nodes    => arrayref of nodes to test\n           -outgroup => outgroup to serve as a reference","label":"is_monophyletic($self,@args)"},"line":852,"kind":12,"range":{"start":{"line":852,"character":0},"end":{"character":9999,"line":865}},"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"is_monophyletic","name":"$self","line":853},{"name":"@args","kind":13,"containerName":"is_monophyletic","line":853},{"line":854,"containerName":"is_monophyletic","localvar":"my","kind":13,"name":"$nodes","definition":"my"},{"name":"$outgroup","kind":13,"containerName":"is_monophyletic","line":854},{"line":854,"name":"$self","kind":13,"containerName":"is_monophyletic"},{"name":"_rearrange","kind":12,"containerName":"is_monophyletic","line":854},{"line":854,"name":"@args","kind":13,"containerName":"is_monophyletic"},{"containerName":"is_monophyletic","kind":13,"name":"$nodes","line":856},{"line":856,"name":"$outgroup","containerName":"is_monophyletic","kind":13},{"line":857,"name":"$self","kind":13,"containerName":"is_monophyletic"},{"name":"warn","kind":12,"containerName":"is_monophyletic","line":857},{"line":861,"containerName":"is_monophyletic","kind":13,"name":"$nodes"},{"name":"$self","containerName":"is_monophyletic","kind":13,"line":862},{"name":"warn","kind":12,"containerName":"is_monophyletic","line":862},{"line":865,"kind":13,"localvar":"my","containerName":"is_monophyletic","name":"$clade_root","definition":"my"},{"line":865,"name":"$self","containerName":"is_monophyletic","kind":13},{"line":865,"kind":12,"containerName":"is_monophyletic","name":"get_lca"},{"line":865,"name":"$nodes","containerName":"is_monophyletic","kind":13}],"name":"is_monophyletic","containerName":"main::"},{"containerName":null,"kind":13,"name":"%clade_root","line":866},{"line":867,"kind":13,"containerName":null,"name":"$self"},{"line":867,"containerName":"main::","kind":12,"name":"warn"},{"line":871,"name":"$og_ancestor","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":871,"kind":13,"containerName":null,"name":"$outgroup"},{"kind":12,"containerName":"main::","name":"ancestor","line":871},{"containerName":null,"kind":13,"name":"%og_ancestor","line":872},{"line":873,"name":"$og_ancestor","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"internal_id","line":873},{"line":873,"name":"$clade_root","kind":13,"containerName":null},{"line":873,"kind":12,"containerName":"main::","name":"internal_id"},{"kind":13,"containerName":null,"name":"$og_ancestor","line":877},{"line":877,"kind":13,"containerName":null,"name":"$og_ancestor"},{"line":877,"name":"ancestor","kind":12,"containerName":"main::"},{"definition":"sub","detail":"($self,@args)","children":[{"line":899,"name":"$self","containerName":"is_paraphyletic","localvar":"my","kind":13,"definition":"my"},{"line":899,"name":"@args","kind":13,"containerName":"is_paraphyletic"},{"definition":"my","line":900,"name":"$nodes","containerName":"is_paraphyletic","localvar":"my","kind":13},{"line":900,"name":"$outgroup","containerName":"is_paraphyletic","kind":13},{"line":900,"name":"$self","containerName":"is_paraphyletic","kind":13},{"line":900,"name":"_rearrange","containerName":"is_paraphyletic","kind":12},{"line":900,"containerName":"is_paraphyletic","kind":13,"name":"@args"},{"line":902,"name":"$nodes","containerName":"is_paraphyletic","kind":13},{"containerName":"is_paraphyletic","kind":13,"name":"$outgroup","line":902},{"line":903,"name":"$self","containerName":"is_paraphyletic","kind":13},{"name":"warn","containerName":"is_paraphyletic","kind":12,"line":903},{"containerName":"is_paraphyletic","kind":13,"name":"$nodes","line":906},{"containerName":"is_paraphyletic","kind":13,"name":"$self","line":907},{"kind":12,"containerName":"is_paraphyletic","name":"warn","line":907},{"kind":13,"localvar":"my","containerName":"is_paraphyletic","name":"%nodehash","line":915,"definition":"my"},{"definition":"my","line":916,"name":"$n","localvar":"my","containerName":"is_paraphyletic","kind":13},{"line":916,"name":"$nodes","kind":13,"containerName":"is_paraphyletic"},{"line":917,"name":"$nodehash","containerName":"is_paraphyletic","kind":13},{"line":917,"name":"$n","kind":13,"containerName":"is_paraphyletic"},{"line":917,"name":"internal_id","containerName":"is_paraphyletic","kind":12},{"name":"$n","containerName":"is_paraphyletic","kind":13,"line":917},{"containerName":"is_paraphyletic","localvar":"my","kind":13,"name":"$clade_root","line":920,"definition":"my"},{"name":"$self","kind":13,"containerName":"is_paraphyletic","line":920},{"name":"get_lca","kind":12,"containerName":"is_paraphyletic","line":920},{"kind":13,"containerName":"is_paraphyletic","name":"$nodes","line":920},{"line":921,"name":"$clade_root","kind":13,"containerName":"is_paraphyletic"},{"kind":13,"containerName":"is_paraphyletic","name":"$self","line":922},{"line":922,"kind":12,"containerName":"is_paraphyletic","name":"warn"},{"line":926,"name":"$og_ancestor","localvar":"my","containerName":"is_paraphyletic","kind":13,"definition":"my"},{"line":926,"name":"$outgroup","containerName":"is_paraphyletic","kind":13},{"kind":12,"containerName":"is_paraphyletic","name":"ancestor","line":926},{"name":"$og_ancestor","containerName":"is_paraphyletic","kind":13,"line":929},{"kind":13,"containerName":"is_paraphyletic","name":"$og_ancestor","line":930},{"line":930,"name":"internal_id","kind":12,"containerName":"is_paraphyletic"},{"line":930,"name":"$clade_root","containerName":"is_paraphyletic","kind":13},{"name":"internal_id","containerName":"is_paraphyletic","kind":12,"line":930},{"line":934,"kind":13,"containerName":"is_paraphyletic","name":"$og_ancestor"},{"line":934,"kind":13,"containerName":"is_paraphyletic","name":"$og_ancestor"},{"line":934,"name":"ancestor","containerName":"is_paraphyletic","kind":12},{"name":"$tree","localvar":"my","kind":13,"containerName":"is_paraphyletic","line":936,"definition":"my"},{"containerName":"is_paraphyletic","kind":12,"name":"new","line":936},{"line":936,"kind":13,"containerName":"is_paraphyletic","name":"$clade_root"},{"line":939,"localvar":"my","containerName":"is_paraphyletic","kind":13,"name":"$n","definition":"my"},{"kind":13,"containerName":"is_paraphyletic","name":"$tree","line":939},{"kind":12,"containerName":"is_paraphyletic","name":"get_nodes","line":939},{"name":"$n","containerName":"is_paraphyletic","kind":13,"line":940},{"line":940,"name":"is_Leaf","kind":12,"containerName":"is_paraphyletic"},{"line":944,"containerName":"is_paraphyletic","kind":13,"name":"$nodehash"},{"name":"$n","kind":13,"containerName":"is_paraphyletic","line":944},{"line":944,"containerName":"is_paraphyletic","kind":12,"name":"internal_id"}],"containerName":"main::","name":"is_paraphyletic","signature":{"label":"is_paraphyletic($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object\n\n\nsub clone {\n    my ($self, $parent, $parent_clone) = @_;\n    $parent ||= $self->get_root_node;\n    $parent_clone ||= $self->_clone_node($parent);\n\n    foreach my $node ($parent->each_Descendent()) {\n        my $child = $self->_clone_node($node);\n        $child->ancestor($parent_clone);\n        $self->_clone($node, $child);\n    }\n    $parent->ancestor && return;\n\n    my $tree = $self->new(-root => $parent_clone);\n    return $tree;\n}\n\n# alias\nsub _clone { shift->clone(@_) }\n\n# safe node clone that doesn't seg fault, but deliberately loses ancestors and\n# descendents\nsub _clone_node {\n    my ($self, $node) = @_;\n    my $clone = $node->new;\n\n    while (my ($key, $val) = each %{$node}) {\n        if ($key eq '_desc' || $key eq '_ancestor') {\n            next;\n        }\n        ${$clone}{$key} = $val;\n    }\n\n    return $clone;\n}\n\n# tree string generator for simplify_to_leaves_string, based on\n# Bio::TreeIO::newick::_write_tree_Helper\nsub _simplify_helper {\n    my ($self, $node, $paired) = @_;\n    return () if (!defined $node);\n\n    my @data = ();\n    foreach my $node ($node->each_Descendent()) {\n        push(@data, $self->_simplify_helper($node, $paired));\n    }\n\n    my $id = $node->id_output || '';\n    if (@data) {\n        unless (exists ${$paired}{\"@data\"} || @data == 1)  {\n            $data[0] = \"(\" . $data[0];\n            $data[-1] .= \")\";\n            ${$paired}{\"@data\"} = 1;\n        }\n    }\n    elsif ($id) {\n        push(@data, $id);\n    }\n\n    return @data;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : distance(-nodes => \\@nodes )\n Function: returns the distance between two given nodes\n Returns : numerical distance\n Args    : -nodes => arrayref of nodes to test\n\n\nsub distance {\n    my ($self,@args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    if( ! defined $nodes ) {\n\t$self->warn(\"Must supply -nodes parameter to distance() method\");\n\treturn;\n    }\n    $self->throw(\"Must provide 2 nodes\") unless @{$nodes} == 2;\n\n    my $lca = $self->get_lca(@{$nodes});\n    unless($lca) { \n        $self->warn(\"could not find the lca of supplied nodes; can't find distance either\");\n        return;\n    }\n\n    my $cumul_dist = 0;\n    my $warned = 0;\n    foreach my $current_node (@{$nodes}) {\n        while (1) {\n            last if $current_node eq $lca;\n            if ($current_node->branch_length) {\n                $cumul_dist += $current_node->branch_length;\n            }\n            elsif (! $warned) {\n                $self->warn(\"At least some nodes do not have a branch length, the distance returned could be wrong\");\n                $warned = 1;\n            }\n\n            $current_node = $current_node->ancestor || last;\n        }\n    }\n\n    return $cumul_dist;\n}\n\n=head2 is_monophyletic\n\n Title   : is_monophyletic\n Usage   : if( $tree->is_monophyletic(-nodes => \\@nodes, \n\t\t\t\t      -outgroup => $outgroup)\n Function: Will do a test of monophyly for the nodes specified\n           in comparison to a chosen outgroup\n Returns : boolean\n Args    : -nodes    => arrayref of nodes to test\n           -outgroup => outgroup to serve as a reference\n\n\n\nsub is_monophyletic{\n   my ($self,@args) = @_;\n   my ($nodes,$outgroup) = $self->_rearrange([qw(NODES OUTGROUP)],@args);\n\n   if( ! defined $nodes || ! defined $outgroup ) {\n       $self->warn(\"Must supply -nodes and -outgroup parameters to the method\nis_monophyletic\");\n       return;\n   }\n   if( ref($nodes) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid array reference for -nodes\");\n   }\n\n   my $clade_root = $self->get_lca(@{$nodes});\n   unless( defined $clade_root ) { \n       $self->warn(\"could not find clade root via lca\");\n       return;\n   }\n\n   my $og_ancestor = $outgroup->ancestor;\n   while( defined ($og_ancestor ) ) {\n       if( $og_ancestor->internal_id == $clade_root->internal_id ) {\n           # monophyly is violated\n           return 0;\n       }\n       $og_ancestor = $og_ancestor->ancestor;\n   }\n   return 1;\n}\n\n=head2 is_paraphyletic\n\n Title   : is_paraphyletic\n Usage   : if( $tree->is_paraphyletic(-nodes =>\\@nodes,\n\t\t\t\t      -outgroup => $node) ){ }\n Function: Tests whether or not a given set of nodes are paraphyletic\n           (representing the full clade) given an outgroup\n Returns : [-1,0,1] , -1 if the group is not monophyletic\n                       0 if the group is not paraphyletic\n                       1 if the group is paraphyletic\n Args    : -nodes => Array of Bio::Tree::NodeI objects which are in the tree\n           -outgroup => a Bio::Tree::NodeI to compare the nodes to"},"line":898,"kind":12,"range":{"end":{"character":9999,"line":947},"start":{"character":0,"line":898}}},{"name":"Bio","containerName":"Tree::Tree","kind":12,"line":936},{"signature":{"label":"reroot($self,$new_root)","parameters":[{"label":"$self"},{"label":"$new_root"}],"documentation":"1;\n# $Id: TreeFunctionsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::TreeFunctionsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::TreeFunctionsI - Decorated Interface implementing basic Tree exploration methods\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'newick', -file => 'tree.tre');\n\n  my $tree = $in->next_tree;\n\n  my @nodes = $tree->find_node('id1');\n\n  if( $tree->is_monophyletic(-nodes => \\@nodes, -outgroup => $outnode) ){\n   #...\n  }\n\n=head1 DESCRIPTION\n\nThis interface provides a set of implementated Tree functions which\nonly use the defined methods in the TreeI or NodeI interface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey, Justin Reese\n\nEmail jason-at-bioperl-dot-org\nEmail amackey-at-virginia.edu\nEmail jtr4v-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\nRerooting code was worked on by\n\n  Daniel Barker d.barker-at-reading.ac.uk\n  Ramiro Barrantes Ramiro.Barrantes-at-uvm.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tree::TreeFunctionsI;\nuse strict;\n\nuse UNIVERSAL qw(isa);\n\nuse base qw(Bio::Tree::TreeI);\n\n=head2 find_node\n\n Title   : find_node\n Usage   : my @nodes = $self->find_node(-id => 'node1');\n Function: returns all nodes that match a specific field, by default this\n           is id, but different branch_length, \n Returns : List of nodes which matched search\n Args    : text string to search for\n           OR\n           -fieldname => $textstring\n\n\nsub find_node {\n   my ($self,$type,$field) = @_;\n   if( ! defined $type ) { \n       $self->warn(\"Must request a either a string or field and string when searching\");\n   }\n\n   # all this work for a '-' named field\n   # is so that we could potentially \n   # expand to other constraints in \n   # different implementations\n   # like 'find all nodes with boostrap < XX'\n\n   if( ! defined $field ) { \n       # only 1 argument, default to searching by id\n       $field= $type; \n       $type = 'id';\n   } else {   \n       $type =~ s/^-//;\n   }\n\n   # could actually do this by testing $rootnode->can($type) but\n   # it is possible that a tree is implemeted with different node types\n   # - although it is unlikely that the root node would be richer than the\n   # leaf nodes.  Can't handle NHX tags right now\n\n   my @nodes = grep { $_->can($type) && defined $_->$type() &&\n\t\t     $_->$type() eq $field } $self->get_nodes();\n\n   if ( wantarray) { \n       return @nodes;\n   } else { \n       if( @nodes > 1 ) { \n\t   $self->warn(\"More than 1 node found but caller requested scalar, only returning first node\");\n       }\n       return shift @nodes;\n   }\n}\n\n=head2 remove_Node\n\n Title   : remove_Node\n Usage   : $tree->remove_Node($node)\n Function: Removes a node from the tree\n Returns : boolean represent status of success\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub remove_Node {\n   my ($self,$input) = @_;\n   my $node = undef;\n   unless( ref($input) ) {\n       $node = $self->find_node($input);\n   }  elsif( ! $input->isa('Bio::Tree::NodeI') ) {\n       $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to remove_node\");\n       return 0;\n   } else { \n       $node = $input;\n   }\n   if( ! $node->ancestor && \n       $self->get_root_node->internal_id != $node->internal_id) {\n     $self->warn(\"Node (\".$node->to_string . \") has no ancestor, can't remove!\");\n   } else { \n     $node->ancestor->remove_Descendent($node);\n   }\n}\n\n=head2 get_lineage_nodes\n\n Title   : get_lineage_nodes\n Usage   : my @nodes = $tree->get_lineage_nodes($node);\n Function: Get the full lineage of a node (all its ancestors, in the order\n           root->most recent ancestor)\n Returns : list of nodes\n Args    : either Bio::Tree::NodeI or string of the node id\n\n\nsub get_lineage_nodes {\n    my ($self, $input) = @_;\n    my $node;\n    unless (ref $input) {\n        $node = $self->find_node($input);\n    }\n    elsif (! $input->isa('Bio::Tree::NodeI')) {\n        $self->warn(\"Did not provide either a valid Bio::Tree::NodeI object or id to get_lineage_nodes\");\n        return;\n    }\n    else { \n        $node = $input;\n    }\n\n    # when dealing with Bio::Taxon objects with databases, the root will always\n    # be the database's root, ignoring this Tree's set root node; prefer the\n    # Tree's idea of root.\n    my $root = $self->get_root_node || '';\n\n    my @lineage;\n    while ($node) {\n        $node = $node->ancestor || last;\n        unshift(@lineage, $node);\n        $node eq $root && last;\n    }\n    return @lineage;\n}\n\n=head2 splice\n\n Title   : splice\n Usage   : $tree->splice(-remove_id => \\@ids);\n Function: Remove all the nodes from a tree that correspond to the supplied\n           args, making all the descendents of a removed node the descendents\n           of the removed node's ancestor.\n           You can ask to explicitly remove certain nodes by using -remove_*,\n           remove them conditionally by using -remove_* in combination with\n           -keep_*, or remove everything except certain nodes by using only\n           -keep_*.\n Returns : n/a\n Args    : just a list of Bio::Tree::NodeI objects to remove, OR\n           -key => value pairs, where -key has the prefix 'remove' or 'keep',\n           followed by an underscore, followed by a fieldname (like for the\n           method find_node). Value should be a scalar or an array ref of\n           scalars (again, like you might supply to find_node).\n\n           So (-remove_id => [1, 2]) will remove all nodes from the tree that\n           have an id() of '1' or '2', while\n           (-remove_id => [1, 2], -keep_id => [2]) will remove all nodes with\n           an id() of '1'.\n           (-keep_id => [2]) will remove all nodes unless they have an id() of\n           '2' (note, no -remove_*).\n\n           -preserve_lengths => 1 : setting this argument will splice out\n           intermediate nodes, preserving the original total length between\n           the ancestor and the descendants of the spliced node. Undef \n           by default.\n\n\nsub splice {\n    my ($self, @args) = @_;\n    $self->throw(\"Must supply some arguments\") unless @args > 0;\n    my $preserve_lengths = 0;\n    my @nodes_to_remove;\n    if (ref($args[0])) {\n        $self->throw(\"When supplying just a list of Nodes, they must be Bio::Tree::NodeI objects\") unless $args[0]->isa('Bio::Tree::NodeI');\n        @nodes_to_remove = @args;\n    }\n    else {\n        $self->throw(\"When supplying -key => value pairs, must be an even number of args\") unless @args % 2 == 0;\n        my %args = @args;\n        my @keep_nodes;\n        my @remove_nodes;\n        my $remove_all = 1;\n        while (my ($key, $value) = each %args) {\n            my @values = ref($value) ? @{$value} : ($value);\n\n            if ($key =~ s/remove_//) {\n                $remove_all = 0;\n                foreach my $value (@values) {\n                    push(@remove_nodes, $self->find_node($key => $value));\n                }\n            }\n            elsif ($key =~ s/keep_//) {\n                foreach my $value (@values) {\n                    push(@keep_nodes, $self->find_node($key => $value));\n                }\n            }\n\t    elsif ($key =~ /preserve/) {\n\t\t$preserve_lengths = $value;\n\t    }\n        }\n\n        if ($remove_all) {\n            if (@keep_nodes == 0) {\n                $self->warn(\"Requested to remove everything except certain nodes, but those nodes were not found; doing nothing instead\");\n                return;\n            }\n\n            @remove_nodes = $self->get_nodes;\n        }\n        if (@keep_nodes > 0) {\n            my %keep_iids = map { $_->internal_id => 1 } @keep_nodes;\n            foreach my $node (@remove_nodes) {\n                push(@nodes_to_remove, $node) unless exists $keep_iids{$node->internal_id};\n            }\n        }\n        else {\n            @nodes_to_remove = @remove_nodes;\n        }\n    }\n    # do the splicing\n    #*** the algorithm here hasn't really been thought through and tested much,\n    #    will probably need revising\n    my %root_descs;\n    my $reroot = 0;\n    foreach my $node (@nodes_to_remove) {\n        my @descs = $node->each_Descendent;\n        my $ancestor = $node->ancestor;\n        if (! $ancestor && ! $reroot) {\n            # we're going to remove the tree root, so will have to re-root the\n            # tree later\n            $reroot = 1;\n            %root_descs = map { $_->internal_id => $_ } @descs;\n            $node->remove_all_Descendents;\n            next;\n        }\n        if (exists $root_descs{$node->internal_id}) {\n            # well, this one can't be the future root anymore\n            delete $root_descs{$node->internal_id};\n            # but maybe one of this one's descs will become the root\n            foreach my $desc (@descs) {\n                $root_descs{$desc->internal_id} = $desc;\n            }\n        }\n        # make the ancestor of our descendents our own ancestor, and give us\n        # no ancestor of our own to remove us from the tree\n        foreach my $desc (@descs) {\n            $desc->ancestor($ancestor);\n\t    $desc->branch_length($desc->branch_length + $node->branch_length) if $preserve_lengths;\n        }\n        $node->ancestor(undef);\n    }\n    if ($reroot) {\n        my @candidates = values %root_descs;\n        $self->throw(\"After splicing, there was no tree root!\") unless @candidates > 0;\n        $self->throw(\"After splicing, the original root was removed but there are multiple candidates for the new root!\") unless @candidates == 1;\n        $self->set_root_node($candidates[0]); # not sure its valid to use the reroot() method\n    }\n}\n\n=head2 get_lca\n\n Title   : get_lca\n Usage   : get_lca(-nodes => \\@nodes ); OR\n           get_lca(@nodes);\n Function: given two or more nodes, returns the lowest common ancestor (aka most\n           recent common ancestor)\n Returns : node object or undef if there is no common ancestor\n Args    : -nodes => arrayref of nodes to test, OR\n           just a list of nodes\n\n\nsub get_lca {\n    my ($self, @args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    my @nodes;\n    if (ref($nodes) eq 'ARRAY') {\n        @nodes = @{$nodes};\n    }\n    else {\n        @nodes = @args;\n    }\n    @nodes >= 2 or $self->throw(\"At least 2 nodes are required\");\n    # We must go root->leaf to get the correct answer to lca (in a world where\n    # internal_id might not be uniquely assigned), but leaf->root is more\n    # forgiving (eg. lineages may not all have the same root, or they may have\n    # different numbers of 'minor' taxa inbeteen 'major' ones).\n    #\n    # I use root->leaf so that we can easily do multiple nodes at once - no\n    # matter what taxa are below the lca, the lca and all its ancestors ought to\n    # be identical.\n    my @paths;\n    foreach my $node (@nodes) {\n\tunless(ref($node) && $node->isa('Bio::Tree::NodeI')) {\n\t    $self->throw(\"Cannot process get_lca() with a non-NodeI object ($node)\\n\");\n\t}\n        my @path = ($self->get_lineage_nodes($node), $node);\n        push(@paths, \\@path);\n    }\n    return unless @paths >= 2;\n    my $lca;\n    LEVEL: while ($paths[0] > 0) {\n        my %node_ids;\n        my $node;\n        foreach my $path (@paths) {\n            $node = shift(@{$path}) || last LEVEL;\n            my $node_id = $node->internal_id;\n            unless (defined $node_id) {\n                $self->warn(\"One of the lineages had a node with no internal_id, can't calculate the common ancestor\");\n                return;\n            }\n            $node_ids{$node_id}++;\n        }\n        if (keys %node_ids == 1) {\n            $lca = $node;\n        }\n        else {\n            # at this point in the lineage the nodes are different; the previous\n            # loop had the lca\n            last LEVEL;\n        }\n    }\n    # If the tree that we are contains the lca (get_lca could have been called\n    # on an empty tree, since it works with plain Nodes), prefer to return the\n    # node object that belongs to us\n    if ($lca && $self->number_nodes > 0) {\n        my $own_lca = $self->find_node(-internal_id => $lca->internal_id);\n        $lca = $own_lca if $own_lca;\n    }\n    return $lca;\n}\n\n=head2 merge_lineage\n\n Title   : merge_lineage\n Usage   : merge_lineage($node)\n Function: Merge a lineage of nodes with this tree.\n Returns : n/a\n Args    : Bio::Tree::TreeI with only one leaf, OR\n           Bio::Tree::NodeI which has an ancestor\n\n For example, if we are the tree $tree:\n\n +---B\n |\n A\n |\n +---C\n\n and we want to merge the lineage $other_tree:\n\n A---C---D\n\n After calling $tree->merge_lineage($other_tree), $tree looks like:\n\n +---B\n |\n A\n |\n +---C---D\n\n\nsub merge_lineage {\n    my ($self, $thing) = @_;\n    $self->throw(\"Must supply an object reference\") unless ref($thing);\n\n    my ($lineage_tree, $lineage_leaf);\n    if ($thing->isa('Bio::Tree::TreeI')) {\n        my @leaves = $thing->get_leaf_nodes;\n        $self->throw(\"The supplied Tree can only have one leaf\") unless @leaves == 1;\n        $lineage_tree = $thing;\n        $lineage_leaf = shift(@leaves);\n    }\n    elsif ($thing->isa('Bio::Tree::NodeI')) {\n        $self->throw(\"The supplied Node must have an ancestor\") unless $thing->ancestor;\n        $lineage_tree = $self->new(-node => $thing);\n        $lineage_leaf = $thing;\n    }\n\n    # see if any node in the supplied lineage is in our tree - that will be\n    # our lca and we can merge at the node below\n    my @lineage = ($lineage_leaf, reverse($self->get_lineage_nodes($lineage_leaf)));\n    my $merged = 0;\n    for my $i (0..$#lineage) {\n        my $lca = $self->find_node(-internal_id => $lineage[$i]->internal_id) || next;\n\n        if ($i == 0) {\n            # the supplied thing to merge is already in the tree, nothing to do\n            return;\n        }\n        # $i is the lca, so the previous node is new to the tree and should\n        # be merged on\n        $lca->add_Descendent($lineage[$i-1]);\n        $merged = 1;\n        last;\n    }\n    $merged || ($self->warn(\"Couldn't merge the lineage of \".$lineage_leaf->id.\" with the rest of the tree!\\n\") && return);\n}\n\n=head2 contract_linear_paths\n\n Title   : contract_linear_paths\n Usage   : contract_linear_paths()\n Function: Splices out all nodes in the tree that have an ancestor and only one\n           descendent.\n Returns : n/a\n Args    : none for normal behaviour, true to dis-regard the ancestor requirment\n           and re-root the tree as necessary\n\n For example, if we are the tree $tree:\n\n             +---E\n             |\n A---B---C---D\n             |\n             +---F\n\n After calling $tree->contract_linear_paths(), $tree looks like:\n\n     +---E\n     |\n A---D\n     |\n     +---F\n\n Instead, $tree->contract_linear_paths(1) would have given:\n\n +---E\n |\n D\n |\n +---F\n\n\nsub contract_linear_paths {\n    my $self = shift;\n    my $reroot = shift;\n    my @remove;\n    foreach my $node ($self->get_nodes) {\n        if ($node->ancestor && $node->each_Descendent == 1) {\n            push(@remove, $node);\n        }\n    }\n    $self->splice(@remove) if @remove;\n    if ($reroot) {\n        my $root = $self->get_root_node;\n        my @descs = $root->each_Descendent;\n        if (@descs == 1) {\n            my $new_root = shift(@descs);\n            $self->set_root_node($new_root);\n            $new_root->ancestor(undef);\n        }\n    }\n}\n\n=head2 is_binary\n\n  Example    : is_binary(); is_binary($node);\n  Description: Finds if the tree or subtree defined by\n               the internal node is a true binary tree\n               without polytomies\n  Returns    : boolean\n  Exceptions : \n  Args       : Internal node Bio::Tree::NodeI, optional\n\n\n\nsub is_binary;\n\nsub is_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my $binary = 1;\n    my @descs = $node->each_Descendent;\n    $binary = 0 unless @descs == 2 or @descs == 0;\n    #print \"$binary, \", scalar @descs, \"\\n\";\n\n    # recurse\n    foreach my $desc (@descs) {\n        $binary += $self->is_binary($desc) -1;\n    }\n    $binary = 0 if $binary < 0;\n    return $binary;\n}\n\n\n=head2 force_binary\n\n Title   : force_binary\n Usage   : force_binary()\n Function: Forces the tree into a binary tree, splitting branches arbitrarily\n           and creating extra nodes as necessary, such that all nodes have\n           exactly two or zero descendants.\n Returns : n/a\n Args    : none\n\n For example, if we are the tree $tree:\n\n +---G\n |\n +---F\n |\n +---E\n |\n A\n |\n +---D\n |\n +---C\n |\n +---B\n\n (A has 6 descendants B-G)\n\n After calling $tree->force_binary(), $tree looks like:\n\n         +---X\n         |\n     +---X\n     |   |\n     |   +---X\n     |\n +---X\n |   |\n |   |   +---G\n |   |   |\n |   +---X\n |       |\n |       +---F\n A\n |       +---E\n |       |\n |   +---X\n |   |   |\n |   |   +---D\n |   |\n +---X\n     |\n     |   +---C\n     |   |\n     +---X\n         |\n         +---B\n\n (Where X are artificially created nodes with ids 'artificial_n', where n is\n an integer making the id unique within the tree)\n\n\nsub force_binary {\n    my $self = shift;\n    my $node = shift || $self->get_root_node;\n\n    my @descs = $node->each_Descendent;\n    if (@descs > 2) {\n        $self->warn(\"Node \".($node->can('node_name') ? ($node->node_name || $node->id) : $node->id).\n                    \" has more than two descendants\\n(\".\n                    join(\", \", map { $node->can('node_name') ? ($node->node_name || $node->id) : $node->id } @descs).\n                    \")\\nWill do an arbitrary balanced split\");\n        my @working = @descs;\n        # create an even set of artifical nodes on which to later hang the descs\n        my $half = @working / 2;\n        $half++ if $half > int($half);\n        $half = int($half);\n        my @artificials;\n        while ($half > 1) {\n            my @this_level;\n            foreach my $top_node (@artificials || $node) {\n                for (1..2) {\n                    my $art = $top_node->new(-id => \"artificial_\".++$self->{_art_num});\n                    $top_node->add_Descendent($art);\n                    push(@this_level, $art);\n                }\n            }\n            @artificials = @this_level;\n            $half--;\n        }\n        # attach two descs to each artifical leaf\n        foreach my $art (@artificials) {\n            for (1..2) {\n                my $desc = shift(@working) || $node->new(-id => \"artificial_\".++$self->{_art_num});\n                $desc->ancestor($art);\n            }\n        }\n    }\n    elsif (@descs == 1) {\n        # ensure that all nodes have 2 descs\n        $node->add_Descendent($node->new(-id => \"artificial_\".++$self->{_art_num}));\n    }\n    # recurse\n    foreach my $desc (@descs) {\n        $self->force_binary($desc);\n    }\n}\n\n=head2 simplify_to_leaves_string\n\n Title   : simplify_to_leaves_string\n Usage   : my $leaves_string = $tree->simplify_to_leaves_string()\n Function: Creates a simple textual representation of the relationship between\n           leaves in self. It forces the tree to be binary, so the result may\n           not strictly correspond to the tree (if the tree wasn't binary), but\n           will be as close as possible. The tree object is not altered. Only\n           leaf node ids are output, in a newick-like format.\n Returns : string\n Args    : none\n\n\nsub simplify_to_leaves_string {\n    my $self = shift;\n\n    # Before contracting and forcing binary we need to clone self, but Clone.pm\n    # clone() seg faults and fails to make the clone, whilst Storable dclone\n    # needs $self->{_root_cleanup_methods} deleted (code ref) and seg faults at\n    # end of script. Let's make our own clone...\n    my $tree = $self->_clone;\n\n    $tree->contract_linear_paths(1);\n    $tree->force_binary;\n    foreach my $node ($tree->get_nodes) {\n        my $id = $node->id;\n        $id = ($node->is_Leaf && $id !~ /^artificial/) ? $id : '';\n        $node->id($id);\n    }\n\n    my %paired;\n    my @data = $self->_simplify_helper($tree->get_root_node, \\%paired);\n\n    return join(',', @data);\n}\n\n# safe tree clone that doesn't seg fault\n\n=head2 clone()\n\n Title   : clone\n Alias   : _clone\n Usage   : $tree_copy = $tree->clone();\n           $subtree_copy = $tree->clone($internal_node);\n Function: Safe tree clone that doesn't segfault\n           (of Sendu)\n Returns : Bio::Tree::Tree object\n Args    : [optional] $start_node, Bio::Tree::Node object\n\n\nsub clone {\n    my ($self, $parent, $parent_clone) = @_;\n    $parent ||= $self->get_root_node;\n    $parent_clone ||= $self->_clone_node($parent);\n\n    foreach my $node ($parent->each_Descendent()) {\n        my $child = $self->_clone_node($node);\n        $child->ancestor($parent_clone);\n        $self->_clone($node, $child);\n    }\n    $parent->ancestor && return;\n\n    my $tree = $self->new(-root => $parent_clone);\n    return $tree;\n}\n\n# alias\nsub _clone { shift->clone(@_) }\n\n# safe node clone that doesn't seg fault, but deliberately loses ancestors and\n# descendents\nsub _clone_node {\n    my ($self, $node) = @_;\n    my $clone = $node->new;\n\n    while (my ($key, $val) = each %{$node}) {\n        if ($key eq '_desc' || $key eq '_ancestor') {\n            next;\n        }\n        ${$clone}{$key} = $val;\n    }\n\n    return $clone;\n}\n\n# tree string generator for simplify_to_leaves_string, based on\n# Bio::TreeIO::newick::_write_tree_Helper\nsub _simplify_helper {\n    my ($self, $node, $paired) = @_;\n    return () if (!defined $node);\n\n    my @data = ();\n    foreach my $node ($node->each_Descendent()) {\n        push(@data, $self->_simplify_helper($node, $paired));\n    }\n\n    my $id = $node->id_output || '';\n    if (@data) {\n        unless (exists ${$paired}{\"@data\"} || @data == 1)  {\n            $data[0] = \"(\" . $data[0];\n            $data[-1] .= \")\";\n            ${$paired}{\"@data\"} = 1;\n        }\n    }\n    elsif ($id) {\n        push(@data, $id);\n    }\n\n    return @data;\n}\n\n=head2 distance\n\n Title   : distance\n Usage   : distance(-nodes => \\@nodes )\n Function: returns the distance between two given nodes\n Returns : numerical distance\n Args    : -nodes => arrayref of nodes to test\n\n\nsub distance {\n    my ($self,@args) = @_;\n    my ($nodes) = $self->_rearrange([qw(NODES)],@args);\n    if( ! defined $nodes ) {\n\t$self->warn(\"Must supply -nodes parameter to distance() method\");\n\treturn;\n    }\n    $self->throw(\"Must provide 2 nodes\") unless @{$nodes} == 2;\n\n    my $lca = $self->get_lca(@{$nodes});\n    unless($lca) { \n        $self->warn(\"could not find the lca of supplied nodes; can't find distance either\");\n        return;\n    }\n\n    my $cumul_dist = 0;\n    my $warned = 0;\n    foreach my $current_node (@{$nodes}) {\n        while (1) {\n            last if $current_node eq $lca;\n            if ($current_node->branch_length) {\n                $cumul_dist += $current_node->branch_length;\n            }\n            elsif (! $warned) {\n                $self->warn(\"At least some nodes do not have a branch length, the distance returned could be wrong\");\n                $warned = 1;\n            }\n\n            $current_node = $current_node->ancestor || last;\n        }\n    }\n\n    return $cumul_dist;\n}\n\n=head2 is_monophyletic\n\n Title   : is_monophyletic\n Usage   : if( $tree->is_monophyletic(-nodes => \\@nodes, \n\t\t\t\t      -outgroup => $outgroup)\n Function: Will do a test of monophyly for the nodes specified\n           in comparison to a chosen outgroup\n Returns : boolean\n Args    : -nodes    => arrayref of nodes to test\n           -outgroup => outgroup to serve as a reference\n\n\n\nsub is_monophyletic{\n   my ($self,@args) = @_;\n   my ($nodes,$outgroup) = $self->_rearrange([qw(NODES OUTGROUP)],@args);\n\n   if( ! defined $nodes || ! defined $outgroup ) {\n       $self->warn(\"Must supply -nodes and -outgroup parameters to the method\nis_monophyletic\");\n       return;\n   }\n   if( ref($nodes) !~ /ARRAY/i ) {\n       $self->warn(\"Must provide a valid array reference for -nodes\");\n   }\n\n   my $clade_root = $self->get_lca(@{$nodes});\n   unless( defined $clade_root ) { \n       $self->warn(\"could not find clade root via lca\");\n       return;\n   }\n\n   my $og_ancestor = $outgroup->ancestor;\n   while( defined ($og_ancestor ) ) {\n       if( $og_ancestor->internal_id == $clade_root->internal_id ) {\n           # monophyly is violated\n           return 0;\n       }\n       $og_ancestor = $og_ancestor->ancestor;\n   }\n   return 1;\n}\n\n=head2 is_paraphyletic\n\n Title   : is_paraphyletic\n Usage   : if( $tree->is_paraphyletic(-nodes =>\\@nodes,\n\t\t\t\t      -outgroup => $node) ){ }\n Function: Tests whether or not a given set of nodes are paraphyletic\n           (representing the full clade) given an outgroup\n Returns : [-1,0,1] , -1 if the group is not monophyletic\n                       0 if the group is not paraphyletic\n                       1 if the group is paraphyletic\n Args    : -nodes => Array of Bio::Tree::NodeI objects which are in the tree\n           -outgroup => a Bio::Tree::NodeI to compare the nodes to\n\n\n\nsub is_paraphyletic{\n   my ($self,@args) = @_;\n   my ($nodes,$outgroup) = $self->_rearrange([qw(NODES OUTGROUP)],@args);\n\n   if( ! defined $nodes || ! defined $outgroup ) {\n       $self->warn(\"Must suply -nodes and -outgroup parameters to the method is_paraphyletic\");\n       return;\n   }\n   if( ref($nodes) !~ /ARRAY/i ) { \n       $self->warn(\"Must provide a valid array reference for -nodes\");\n       return;\n   }\n\n   # Algorithm\n   # Find the lca\n   # Find all the nodes beneath the lca\n   # Test to see that none are missing from the nodes list\n   my %nodehash;\n   foreach my $n ( @$nodes ) {\n       $nodehash{$n->internal_id} = $n;\n   }\n\n   my $clade_root = $self->get_lca(-nodes => $nodes );\n   unless( defined $clade_root ) { \n       $self->warn(\"could not find clade root via lca\");\n       return;\n   }\n\n   my $og_ancestor = $outgroup->ancestor;\n\n   # Is this necessary/correct for paraphyly test?\n   while( defined ($og_ancestor ) ) {\n       if( $og_ancestor->internal_id == $clade_root->internal_id ) {\n           # monophyly is violated, could be paraphyletic\n           return -1;\n       }\n       $og_ancestor = $og_ancestor->ancestor;\n   }\n   my $tree = Bio::Tree::Tree->new(-root     => $clade_root,\n\t\t\t\t  -nodelete => 1);\n\n   foreach my $n ( $tree->get_nodes() ) { \n       next unless $n->is_Leaf();\n       # if any leaf node is not in the list\n       # then it is part of the clade and so the list\n       # must be paraphyletic\n       return 1 unless (  $nodehash{$n->internal_id} );\n   }\n   return 0;\n}\n\n\n=head2 reroot\n\n Title   : reroot\n Usage   : $tree->reroot($node);\n Function: Reroots a tree making a new node the root\n Returns : 1 on success, 0 on failure\n Args    : Bio::Tree::NodeI that is in the tree, but is not the current root"},"kind":12,"range":{"end":{"character":9999,"line":1002},"start":{"line":960,"character":0}},"line":960,"detail":"($self,$new_root)","definition":"sub","name":"reroot","containerName":"main::","children":[{"definition":"my","line":961,"kind":13,"localvar":"my","containerName":"reroot","name":"$self"},{"line":961,"containerName":"reroot","kind":13,"name":"$new_root"},{"kind":13,"containerName":"reroot","name":"$new_root","line":962},{"line":962,"containerName":"reroot","kind":13,"name":"$new_root"},{"line":962,"containerName":"reroot","kind":12,"name":"isa"},{"line":963,"containerName":"reroot","kind":13,"name":"$self"},{"line":963,"containerName":"reroot","kind":12,"name":"warn"},{"definition":"my","line":967,"name":"$old_root","localvar":"my","containerName":"reroot","kind":13},{"line":967,"containerName":"reroot","kind":13,"name":"$self"},{"containerName":"reroot","kind":12,"name":"get_root_node","line":967},{"line":968,"containerName":"reroot","kind":13,"name":"$new_root"},{"containerName":"reroot","kind":13,"name":"$old_root","line":968},{"name":"$self","kind":13,"containerName":"reroot","line":969},{"name":"warn","kind":12,"containerName":"reroot","line":969},{"localvar":"my","kind":13,"containerName":"reroot","name":"$anc","line":972,"definition":"my"},{"name":"$new_root","containerName":"reroot","kind":13,"line":972},{"line":972,"kind":12,"containerName":"reroot","name":"ancestor"},{"containerName":"reroot","kind":13,"name":"$anc","line":973},{"line":975,"kind":13,"containerName":"reroot","name":"$self"},{"containerName":"reroot","kind":12,"name":"warn","line":975},{"localvar":"my","containerName":"reroot","kind":13,"name":"$tmp_node","line":977,"definition":"my"},{"name":"$new_root","kind":13,"containerName":"reroot","line":977},{"name":"create_node_on_branch","kind":12,"containerName":"reroot","line":977},{"definition":"my","kind":13,"localvar":"my","containerName":"reroot","name":"$former_anc","line":979},{"line":979,"kind":13,"containerName":"reroot","name":"$tmp_node"},{"name":"ancestor","kind":12,"containerName":"reroot","line":979},{"definition":"my","line":980,"localvar":"my","kind":13,"containerName":"reroot","name":"@path_from_oldroot"},{"kind":13,"containerName":"reroot","name":"$self","line":980},{"containerName":"reroot","kind":12,"name":"get_lineage_nodes","line":980},{"kind":13,"containerName":"reroot","name":"$tmp_node","line":980},{"containerName":"reroot","kind":13,"name":"$tmp_node","line":980},{"localvar":"my","containerName":"reroot","kind":13,"name":"$i","line":981,"definition":"my"},{"line":981,"kind":13,"containerName":"reroot","name":"$i"},{"name":"$i","containerName":"reroot","kind":13,"line":981},{"definition":"my","containerName":"reroot","localvar":"my","kind":13,"name":"$current","line":982},{"line":982,"name":"$path_from_oldroot","kind":13,"containerName":"reroot"},{"line":982,"containerName":"reroot","kind":13,"name":"$i"},{"definition":"my","name":"$next","containerName":"reroot","localvar":"my","kind":13,"line":983},{"kind":13,"containerName":"reroot","name":"$path_from_oldroot","line":983},{"line":983,"kind":13,"containerName":"reroot","name":"$i"},{"line":984,"containerName":"reroot","kind":13,"name":"$current"},{"line":984,"name":"remove_Descendent","containerName":"reroot","kind":12},{"name":"$next","kind":13,"containerName":"reroot","line":984},{"containerName":"reroot","kind":13,"name":"$current","line":985},{"containerName":"reroot","kind":12,"name":"branch_length","line":985},{"line":985,"name":"$next","kind":13,"containerName":"reroot"},{"name":"branch_length","kind":12,"containerName":"reroot","line":985},{"containerName":"reroot","kind":13,"name":"$current","line":986},{"line":986,"containerName":"reroot","kind":12,"name":"bootstrap"},{"kind":13,"containerName":"reroot","name":"$next","line":986},{"containerName":"reroot","kind":12,"name":"bootstrap","line":986},{"line":986,"containerName":"reroot","kind":13,"name":"$next"},{"line":986,"name":"bootstrap","containerName":"reroot","kind":12},{"containerName":"reroot","kind":13,"name":"$next","line":987},{"line":987,"kind":12,"containerName":"reroot","name":"remove_tag"},{"name":"$next","containerName":"reroot","kind":13,"line":988},{"containerName":"reroot","kind":12,"name":"add_Descendent","line":988},{"line":988,"name":"$current","containerName":"reroot","kind":13},{"line":991,"name":"$new_root","kind":13,"containerName":"reroot"},{"line":991,"name":"add_Descendent","containerName":"reroot","kind":12},{"line":991,"containerName":"reroot","kind":13,"name":"$former_anc"},{"name":"$tmp_node","containerName":"reroot","kind":13,"line":992},{"line":992,"name":"remove_Descendent","containerName":"reroot","kind":12},{"line":992,"name":"$former_anc","containerName":"reroot","kind":13},{"name":"$tmp_node","containerName":"reroot","kind":13,"line":994},{"containerName":"reroot","kind":13,"name":"$new_root","line":995},{"line":995,"name":"branch_length","containerName":"reroot","kind":12},{"line":996,"name":"$new_root","containerName":"reroot","kind":13},{"containerName":"reroot","kind":12,"name":"remove_tag","line":996},{"kind":13,"containerName":"reroot","name":"$old_root","line":998},{"line":999,"kind":13,"containerName":"reroot","name":"$self"},{"line":999,"kind":12,"containerName":"reroot","name":"set_root_node"},{"line":999,"containerName":"reroot","kind":13,"name":"$new_root"}]},{"line":981,"kind":12,"name":"path_from_oldroot"},{"definition":"sub","name":"reroot_at_midpoint","containerName":"main::","children":[{"line":1017,"name":"$self","containerName":"reroot_at_midpoint","localvar":"my","kind":13,"definition":"my"},{"localvar":"my","containerName":"reroot_at_midpoint","kind":13,"name":"$node","line":1018,"definition":"my"},{"line":1019,"containerName":"reroot_at_midpoint","localvar":"my","kind":13,"name":"$id","definition":"my"},{"name":"$node","kind":13,"containerName":"reroot_at_midpoint","line":1021},{"kind":13,"containerName":"reroot_at_midpoint","name":"$node","line":1021},{"name":"isa","kind":12,"containerName":"reroot_at_midpoint","line":1021},{"line":1022,"kind":13,"containerName":"reroot_at_midpoint","name":"$self"},{"line":1022,"name":"warn","kind":12,"containerName":"reroot_at_midpoint"},{"localvar":"my","kind":13,"containerName":"reroot_at_midpoint","name":"$midpt","line":1026,"definition":"my"},{"kind":13,"containerName":"reroot_at_midpoint","name":"$node","line":1026},{"name":"create_node_on_branch","containerName":"reroot_at_midpoint","kind":12,"line":1026},{"line":1027,"kind":13,"containerName":"reroot_at_midpoint","name":"$id"},{"line":1028,"containerName":"reroot_at_midpoint","kind":13,"name":"$self"},{"line":1028,"containerName":"reroot_at_midpoint","kind":12,"name":"warn"},{"line":1028,"containerName":"reroot_at_midpoint","kind":13,"name":"$id"},{"line":1029,"name":"$midpt","kind":13,"containerName":"reroot_at_midpoint"},{"containerName":"reroot_at_midpoint","kind":12,"name":"id","line":1029},{"line":1029,"name":"$id","containerName":"reroot_at_midpoint","kind":13},{"kind":13,"containerName":"reroot_at_midpoint","name":"$id","line":1029},{"line":1029,"name":"$id","kind":13,"containerName":"reroot_at_midpoint"},{"containerName":"reroot_at_midpoint","kind":13,"name":"$self","line":1031},{"line":1031,"name":"reroot","containerName":"reroot_at_midpoint","kind":12},{"line":1031,"name":"$midpt","kind":13,"containerName":"reroot_at_midpoint"},{"line":1032,"kind":13,"containerName":"reroot_at_midpoint","name":"$midpt"}],"kind":12,"range":{"start":{"line":1016,"character":0},"end":{"character":9999,"line":1033}},"line":1016},{"line":1048,"kind":12,"range":{"start":{"line":1048,"character":0},"end":{"line":1063,"character":9999}},"children":[{"line":1049,"containerName":"findnode_by_id","localvar":"my","kind":13,"name":"$tree","definition":"my"},{"line":1050,"kind":13,"containerName":"findnode_by_id","name":"$tree"},{"line":1050,"containerName":"findnode_by_id","kind":12,"name":"deprecated"},{"definition":"my","name":"$id","containerName":"findnode_by_id","localvar":"my","kind":13,"line":1052},{"name":"$rootnode","localvar":"my","containerName":"findnode_by_id","kind":13,"line":1053,"definition":"my"},{"line":1053,"containerName":"findnode_by_id","kind":13,"name":"$tree"},{"line":1053,"name":"get_root_node","containerName":"findnode_by_id","kind":12},{"line":1054,"kind":13,"containerName":"findnode_by_id","name":"$rootnode"},{"line":1054,"name":"id","containerName":"findnode_by_id","kind":12},{"line":1054,"containerName":"findnode_by_id","kind":13,"name":"$rootnode"},{"containerName":"findnode_by_id","kind":12,"name":"id","line":1054},{"name":"$id","kind":13,"containerName":"findnode_by_id","line":1054},{"line":1055,"name":"$rootnode","containerName":"findnode_by_id","kind":13},{"definition":"my","name":"$node","localvar":"my","containerName":"findnode_by_id","kind":13,"line":1058},{"line":1058,"containerName":"findnode_by_id","kind":13,"name":"$rootnode"},{"line":1058,"containerName":"findnode_by_id","kind":12,"name":"get_Descendents"},{"line":1059,"containerName":"findnode_by_id","kind":13,"name":"$node"},{"line":1059,"name":"id","containerName":"findnode_by_id","kind":12},{"line":1059,"containerName":"findnode_by_id","kind":13,"name":"$node"},{"name":"id","containerName":"findnode_by_id","kind":12,"line":1059},{"line":1059,"name":"$id","kind":13,"containerName":"findnode_by_id"},{"line":1060,"name":"$node","containerName":"findnode_by_id","kind":13}],"name":"findnode_by_id","containerName":"main::","definition":"sub"},{"containerName":"main::","name":"move_id_to_bootstrap","children":[{"localvar":"my","containerName":"move_id_to_bootstrap","kind":13,"name":"$tree","line":1077,"definition":"my"},{"definition":"my","line":1078,"name":"$node","kind":13,"localvar":"my","containerName":"move_id_to_bootstrap"},{"name":"is_Leaf","kind":12,"containerName":"move_id_to_bootstrap","line":1078},{"line":1078,"kind":13,"containerName":"move_id_to_bootstrap","name":"$tree"},{"line":1078,"name":"get_nodes","containerName":"move_id_to_bootstrap","kind":12},{"line":1079,"name":"$node","containerName":"move_id_to_bootstrap","kind":13},{"line":1079,"containerName":"move_id_to_bootstrap","kind":12,"name":"bootstrap"},{"line":1079,"kind":13,"containerName":"move_id_to_bootstrap","name":"$node"},{"line":1079,"containerName":"move_id_to_bootstrap","kind":12,"name":"id"},{"line":1080,"containerName":"move_id_to_bootstrap","kind":13,"name":"$node"},{"name":"id","containerName":"move_id_to_bootstrap","kind":12,"line":1080}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":1076},"end":{"line":1082,"character":9999}},"line":1076},{"containerName":"main::","name":"_read_trait_file","children":[{"definition":"my","line":1104,"name":"$self","containerName":"_read_trait_file","localvar":"my","kind":13},{"definition":"my","line":1105,"name":"$file","containerName":"_read_trait_file","localvar":"my","kind":13},{"line":1106,"name":"$column","localvar":"my","kind":13,"containerName":"_read_trait_file","definition":"my"},{"line":1108,"kind":13,"localvar":"my","containerName":"_read_trait_file","name":"$traits","definition":"my"},{"definition":"my","name":"$TRAIT","localvar":"my","kind":13,"containerName":"_read_trait_file","line":1109},{"containerName":"_read_trait_file","kind":13,"name":"$file","line":1109},{"line":1109,"name":"$self","containerName":"_read_trait_file","kind":13},{"line":1111,"containerName":"_read_trait_file","localvar":"my","kind":13,"name":"$first_line","definition":"my"},{"kind":13,"containerName":"_read_trait_file","name":"$TRAIT","line":1112},{"line":1113,"name":"$first_line","kind":13,"containerName":"_read_trait_file"},{"line":1114,"name":"$first_line","kind":13,"containerName":"_read_trait_file"},{"definition":"my","line":1116,"name":"@line","containerName":"_read_trait_file","localvar":"my","kind":13},{"line":1117,"name":"$traits","containerName":"_read_trait_file","kind":13},{"line":1117,"name":"$line","kind":13,"containerName":"_read_trait_file"},{"name":"$column","kind":13,"containerName":"_read_trait_file","line":1117},{"definition":"my","line":1121,"localvar":"my","kind":13,"containerName":"_read_trait_file","name":"@line"},{"line":1122,"name":"$line","kind":13,"containerName":"_read_trait_file"},{"line":1123,"name":"$traits","containerName":"_read_trait_file","kind":13},{"line":1123,"kind":13,"containerName":"_read_trait_file","name":"$line"},{"line":1123,"name":"$line","containerName":"_read_trait_file","kind":13},{"line":1123,"kind":13,"containerName":"_read_trait_file","name":"$column"},{"kind":13,"containerName":"_read_trait_file","name":"$traits","line":1125}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":1126},"start":{"line":1103,"character":0}},"line":1103},{"range":{"end":{"character":9999,"line":1148},"start":{"line":1128,"character":0}},"kind":12,"line":1128,"definition":"sub","containerName":"main::","name":"add_trait","children":[{"localvar":"my","kind":13,"containerName":"add_trait","name":"$self","line":1129,"definition":"my"},{"line":1130,"localvar":"my","containerName":"add_trait","kind":13,"name":"$file","definition":"my"},{"name":"$column","containerName":"add_trait","localvar":"my","kind":13,"line":1131,"definition":"my"},{"definition":"my","line":1133,"containerName":"add_trait","localvar":"my","kind":13,"name":"$traits"},{"line":1133,"name":"$self","kind":13,"containerName":"add_trait"},{"name":"_read_trait_file","kind":12,"containerName":"add_trait","line":1133},{"containerName":"add_trait","kind":13,"name":"$file","line":1133},{"name":"$column","kind":13,"containerName":"add_trait","line":1133},{"line":1134,"name":"$key","localvar":"my","containerName":"add_trait","kind":13,"definition":"my"},{"name":"$traits","containerName":"add_trait","kind":13,"line":1134},{"name":"$node","kind":13,"localvar":"my","containerName":"add_trait","line":1136,"definition":"my"},{"line":1136,"containerName":"add_trait","kind":13,"name":"$self"},{"name":"get_leaf_nodes","containerName":"add_trait","kind":12,"line":1136},{"line":1138,"name":"$node","kind":13,"containerName":"add_trait"},{"containerName":"add_trait","kind":12,"name":"id","line":1138},{"line":1138,"name":"$node","containerName":"add_trait","kind":13},{"name":"id","containerName":"add_trait","kind":12,"line":1138},{"name":"$node","containerName":"add_trait","kind":13,"line":1140},{"containerName":"add_trait","kind":12,"name":"verbose","line":1140},{"line":1141,"containerName":"add_trait","kind":13,"name":"$node"},{"kind":12,"containerName":"add_trait","name":"add_tag_value","line":1141},{"containerName":"add_trait","kind":13,"name":"$key","line":1141},{"line":1141,"containerName":"add_trait","kind":13,"name":"$traits"},{"line":1141,"name":"$node","containerName":"add_trait","kind":13},{"name":"id","kind":12,"containerName":"add_trait","line":1141},{"kind":13,"containerName":"add_trait","name":"$self","line":1143},{"name":"throw","containerName":"add_trait","kind":12,"line":1143},{"line":1144,"containerName":"add_trait","kind":13,"name":"$node"},{"line":1144,"kind":12,"containerName":"add_trait","name":"id"},{"name":"$node","kind":13,"containerName":"add_trait","line":1144},{"line":1144,"name":"internal_id","containerName":"add_trait","kind":12},{"name":"$key","containerName":"add_trait","kind":13,"line":1147}]}]}