{"version":5,"vars":[{"kind":2,"containerName":"","name":"vars","line":86},{"name":"$UIDCOUNTER","containerName":null,"kind":13,"line":88},{"line":88,"name":"strict","containerName":"","kind":2},{"name":"base","containerName":"","kind":2,"line":93},{"signature":{"documentation":"1;\n# $Id: AlleleNode.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::AlleleNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AlleleNode - A Node with Alleles attached\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::AlleleNode;\n\n=head1 DESCRIPTION\n\nAlleleNodes are basic L<Bio::Tree::Node>s with the added ability to\nadd Genotypes alleles as defined by the L<Bio::PopGen::IndividualI>\ninterface.  Genotypes are defined by the L<Bio::PopGen::GenotypeI>\ninterface, you will probably want to use the L<Bio::PopGen::Genotype>\nimplementation.\n\nThis is implemented via containment to avoid multiple inheritance\nproblems.  Their is a L<Bio::PopGen::Individual> object which handles\nthe L<Bio::PopGen::IndividualI> interface, and is accessible via the\nL<Bio::Tree::AlleleNode::individual> method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n=head1 HISTORY\n\nThis module was re-written to be a combination of\nL<Bio::PopGen::Individual> and L<Bio::Tree::Node> primarily for use in\nL<Bio::PopGen::Simulation::Coalescent> simulations.\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::AlleleNode;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::Tree::Node Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AlleleNode->new();\n Function: Builds a new Bio::Tree::AlleleNode() object \n Returns : an instance of Bio::Tree::AlleleNode\n Args    : -unique_id     => $id,\n           -genotypes     => \\@genotypes\n           -left          => pointer to Left descendent (optional)\n           -right         => pointer to Right descenent (optional)\n\t   -branch_length => branch length [integer] (optional)\n           -bootstrap     => value   bootstrap value (string)\n           -description   => description of node\n           -id            => human readable (unique) id for node\n                             Should NOT contain the characters \n                             '();:'","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"start":{"character":0,"line":113},"end":{"line":119,"character":9999}},"line":113,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":114,"name":"$class","containerName":"new","localvar":"my","kind":13},{"line":114,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","localvar":"my","kind":13,"line":116,"definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":116},{"name":"@args","kind":13,"containerName":"new","line":116},{"containerName":"new","kind":13,"name":"$self","line":117},{"containerName":"new","kind":12,"name":"individual","line":117},{"line":117,"name":"new","kind":12,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":117},{"name":"$self","containerName":"new","kind":13,"line":118}]},{"line":116,"kind":12,"containerName":"new","name":"SUPER"},{"line":117,"containerName":"PopGen::Individual","kind":12,"name":"Bio"},{"signature":{"parameters":[{"label":"$self"},{"label":"$newval"}],"documentation":"1;\n# $Id: AlleleNode.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::AlleleNode\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::AlleleNode - A Node with Alleles attached\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::AlleleNode;\n\n=head1 DESCRIPTION\n\nAlleleNodes are basic L<Bio::Tree::Node>s with the added ability to\nadd Genotypes alleles as defined by the L<Bio::PopGen::IndividualI>\ninterface.  Genotypes are defined by the L<Bio::PopGen::GenotypeI>\ninterface, you will probably want to use the L<Bio::PopGen::Genotype>\nimplementation.\n\nThis is implemented via containment to avoid multiple inheritance\nproblems.  Their is a L<Bio::PopGen::Individual> object which handles\nthe L<Bio::PopGen::IndividualI> interface, and is accessible via the\nL<Bio::Tree::AlleleNode::individual> method.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n=head1 HISTORY\n\nThis module was re-written to be a combination of\nL<Bio::PopGen::Individual> and L<Bio::Tree::Node> primarily for use in\nL<Bio::PopGen::Simulation::Coalescent> simulations.\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::AlleleNode;\nuse vars qw($UIDCOUNTER);\nuse strict;\nBEGIN { $UIDCOUNTER = 1 }\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::Tree::Node Bio::PopGen::IndividualI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::AlleleNode->new();\n Function: Builds a new Bio::Tree::AlleleNode() object \n Returns : an instance of Bio::Tree::AlleleNode\n Args    : -unique_id     => $id,\n           -genotypes     => \\@genotypes\n           -left          => pointer to Left descendent (optional)\n           -right         => pointer to Right descenent (optional)\n\t   -branch_length => branch length [integer] (optional)\n           -bootstrap     => value   bootstrap value (string)\n           -description   => description of node\n           -id            => human readable (unique) id for node\n                             Should NOT contain the characters \n                             '();:'\n\nsub new { \n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->individual( Bio::PopGen::Individual->new(@args));\n    return $self;\n}\n\n=head2 individual\n\n Title   : individual\n Usage   : $obj->individual($newval)\n Function: Get/Set Access to the underlying individual object\n Returns : L<Bio::PopGen::Individual> object\n Args    : on set, new value (L<Bio::PopGen::Individual>)","label":"individual($self,$newval)"},"line":132,"range":{"start":{"character":0,"line":132},"end":{"character":9999,"line":139}},"kind":12,"definition":"sub","detail":"($self,$newval)","children":[{"definition":"my","line":133,"localvar":"my","containerName":"individual","kind":13,"name":"$self"},{"containerName":"individual","kind":13,"name":"$newval","line":133},{"name":"$newval","kind":13,"containerName":"individual","line":134},{"line":134,"containerName":"individual","kind":13,"name":"$self"},{"line":135,"name":"$newval","containerName":"individual","kind":13},{"name":"new","kind":12,"containerName":"individual","line":135},{"kind":13,"containerName":"individual","name":"$newval","line":135},{"line":136,"name":"$self","containerName":"individual","kind":13},{"line":136,"kind":13,"containerName":"individual","name":"$newval"},{"line":138,"name":"$self","containerName":"individual","kind":13}],"name":"individual","containerName":"main::"},{"containerName":"PopGen::Individual","kind":12,"name":"Bio","line":135},{"definition":"sub","containerName":"main::","name":"unique_id","children":[{"definition":"my","line":158,"containerName":"unique_id","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"unique_id","line":159},{"line":159,"name":"individual","containerName":"unique_id","kind":12},{"line":159,"kind":12,"containerName":"unique_id","name":"unique_id"}],"range":{"end":{"line":160,"character":9999},"start":{"character":0,"line":157}},"kind":12,"line":157},{"definition":"sub","containerName":"main::","name":"num_of_results","children":[{"definition":"my","localvar":"my","containerName":"num_of_results","kind":13,"name":"$self","line":173},{"kind":13,"containerName":"num_of_results","name":"$self","line":174},{"containerName":"num_of_results","kind":12,"name":"individual","line":174},{"containerName":"num_of_results","kind":12,"name":"num_of_results","line":174}],"kind":12,"range":{"start":{"line":172,"character":0},"end":{"line":175,"character":9999}},"line":172},{"range":{"end":{"line":192,"character":9999},"start":{"line":189,"character":0}},"kind":12,"line":189,"name":"add_Genotype","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"add_Genotype","line":190,"definition":"my"},{"line":191,"kind":13,"containerName":"add_Genotype","name":"$self"},{"line":191,"kind":12,"containerName":"add_Genotype","name":"individual"},{"name":"add_Genotype","kind":12,"containerName":"add_Genotype","line":191}],"definition":"sub"},{"range":{"start":{"line":205,"character":0},"end":{"line":208,"character":9999}},"kind":12,"line":205,"name":"reset_Genotypes","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"reset_Genotypes","name":"$self","line":206,"definition":"my"},{"name":"$self","kind":13,"containerName":"reset_Genotypes","line":207},{"line":207,"name":"individual","containerName":"reset_Genotypes","kind":12},{"line":207,"name":"reset_Genotypes","containerName":"reset_Genotypes","kind":12}],"definition":"sub"},{"containerName":"main::","name":"remove_Genotype","children":[{"definition":"my","name":"$self","containerName":"remove_Genotype","localvar":"my","kind":13,"line":222},{"line":223,"kind":13,"containerName":"remove_Genotype","name":"$self"},{"line":223,"name":"individual","kind":12,"containerName":"remove_Genotype"},{"name":"remove_Genotype","containerName":"remove_Genotype","kind":12,"line":223}],"definition":"sub","range":{"start":{"line":221,"character":0},"end":{"line":224,"character":9999}},"kind":12,"line":221},{"definition":"sub","containerName":"main::","name":"get_Genotypes","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"get_Genotypes","line":239},{"line":240,"name":"$self","kind":13,"containerName":"get_Genotypes"},{"name":"individual","kind":12,"containerName":"get_Genotypes","line":240},{"line":240,"kind":12,"containerName":"get_Genotypes","name":"get_Genotypes"}],"kind":12,"range":{"end":{"line":241,"character":9999},"start":{"line":238,"character":0}},"line":238},{"name":"has_Marker","containerName":"main::","children":[{"definition":"my","line":256,"name":"$self","kind":13,"localvar":"my","containerName":"has_Marker"},{"name":"$self","kind":13,"containerName":"has_Marker","line":257},{"containerName":"has_Marker","kind":12,"name":"individual","line":257},{"line":257,"containerName":"has_Marker","kind":12,"name":"has_Marker"}],"definition":"sub","kind":12,"range":{"end":{"line":258,"character":9999},"start":{"character":0,"line":255}},"line":255},{"containerName":"main::","name":"get_marker_names","children":[{"definition":"my","containerName":"get_marker_names","localvar":"my","kind":13,"name":"$self","line":272},{"name":"$self","kind":13,"containerName":"get_marker_names","line":273},{"name":"individual","kind":12,"containerName":"get_marker_names","line":273},{"name":"get_marker_names","containerName":"get_marker_names","kind":12,"line":273}],"definition":"sub","kind":12,"range":{"end":{"line":274,"character":9999},"start":{"character":0,"line":271}},"line":271}]}