{"version":5,"vars":[{"line":107,"name":"base","containerName":"","kind":2},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"%DTASelect_pK","line":111},{"line":111,"kind":12,"name":"N_term"},{"kind":12,"name":"C_term","line":119},{"definition":"my","name":"%Emboss_pK","localvar":"my","containerName":null,"kind":13,"line":124},{"line":124,"kind":12,"name":"N_term"},{"name":"C_term","kind":12,"line":132},{"signature":{"label":"new($class,%opts)","documentation":"__END__\n# $Id: pICalculator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::pICalculator\n#\n# Copyright (c) 2002, Merck & Co. Inc. All Rights Reserved.\n#\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pICalculator - calculate the isoelectric point of a protein\n\n=head1 DESCRIPTION\n\nCalculates the isoelectric point of a protein, the pH at which there\nis no overall charge on the protein. Calculates the charge on a protein\nat a given pH. Can use built-in sets of pK values or custom pK sets.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::pICalculator;\n  use Bio::SeqIO;\n\n  my $in = Bio::SeqIO->new( -fh => \\*STDIN ,\n                            -format => 'Fasta' );\n\n  my $calc = Bio::Tools::pICalculator->new(-places => 2,\n                                           -pKset => 'EMBOSS');\n\n  while ( my $seq = $in->next_seq ) {\n     $calc->seq($seq);\n     my $iep = $calc->iep;\n     print sprintf( \"%s\\t%s\\t%.2f\\n\",\n                    $seq->id,\n                    $iep,\n                    $calc->charge_at_pH($iep) );\n\n     for( my $i = 0; $i <= 14; $i += 0.5 ){\n        print sprintf( \"pH = %.2f\\tCharge = %.2f\\n\",\n                       $i,\n                       $calc->charge_at_pH($i) );\n     }\n  }\n\n=head1 SEE ALSO\n\nhttp://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf\nhttp://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nhttp://us.expasy.org/tools/pi_tool.html\n\n=head1 LIMITATIONS\n\nThere are various sources for the pK values of the amino acids. \nThe set of pK values chosen will affect the pI reported.\n\nThe charge state of each residue is assumed to be independent of \nthe others. Protein modifications (such as a phosphate group) that \nhave a charge are ignored.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the \nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMark Southern (mark_southern@merck.com). From an algorithm by David \nTabb found at http://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf.\nModification for Bioperl, additional documentation by Brian Osborne.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002, Merck & Co. Inc. All Rights Reserved. This module is\nfree software. It may be used, redistributed and/or modified under the terms\nof the Perl Artistic License (see http://www.perl.com/perl/misc/Artistic.html)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nPrivate methods are usually preceded by a _.\n\n\n# Let the code begin...\n\npackage Bio::Tools::pICalculator;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n# pK values from the DTASelect program from Scripps\n# http://fields.scripps.edu/DTASelect\nmy $DTASelect_pK = {  N_term   =>  8.0,\n                      K        => 10.0, # Lys\n                      R        => 12.0, # Arg\n                      H        =>  6.5, # His\n                      D        =>  4.4, # Asp\n                      E        =>  4.4, # Glu\n                      C        =>  8.5, # Cys\n                      Y        => 10.0, # Tyr\n                      C_term   =>  3.1\n                    };\n\n# pK values from the iep program from EMBOSS\n# http://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nmy $Emboss_pK  = { N_term   =>  8.6,\n                   K        => 10.8, # Lys\n                   R        => 12.5, # Arg\n                   H        =>  6.5, # His\n                   D        =>  3.9, # Asp\n                   E        =>  4.1, # Glu\n                   C        =>  8.5, # Cys\n                   Y        => 10.1, # Tyr\n                   C_term   =>  3.6\n                 };\n\n=head2 desc\n\n Title   : new\n Usage   : Bio::Tools::pICalculator->new\n Function: Instantiates the Bio::Tools::pICalculator object\n Example : $calc = Bio::Tools::pICalculator->new( -pKset => \\%pKvalues,\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 2 );\n           or:\n\n           $calc = Bio::Tools::pICalculator->new( -pKset => 'string',\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 1 );\n\n           Constructs a new pICalculator. Arguments are a flattened hash.\n           Valid, optional keys are:\n\n           pKset - A reference to a hash with key value pairs for the \n                   pK values of the charged amino acids. Required keys\n                   are:\n\n                   N_term   C_term   K   R   H   D   E   C   Y\n\n           pKset - A string ( 'DTASelect' or 'EMBOSS' ) that will \n                   specify an internal set of pK values to be used. The \n                   default is 'EMBOSS'\n\n           seq - A Bio::Seq sequence object to analyze\n\n           places - The number of decimal places to use in the\n                    isoelectric point calculation. The default is 2.\n\n Returns : The description\n Args    : The description or none","parameters":[{"label":"$class"},{"label":"%opts"}]},"line":174,"range":{"end":{"line":183,"character":9999},"start":{"line":174,"character":0}},"kind":12,"definition":"sub","detail":"($class,%opts)","children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":175},{"line":175,"kind":13,"containerName":"new","name":"%opts"},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":176},{"line":176,"name":"$class","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"%opts","line":176},{"kind":13,"containerName":"new","name":"$self","line":177},{"line":177,"name":"$self","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":177},{"line":178,"name":"$self","kind":13,"containerName":"new"},{"name":"seq","containerName":"new","kind":12,"line":178},{"line":178,"name":"$opts","containerName":"new","kind":13},{"line":178,"name":"$opts","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":179},{"line":179,"kind":12,"containerName":"new","name":"pKset"},{"line":179,"name":"$opts","containerName":"new","kind":13},{"name":"$opts","containerName":"new","kind":13,"line":180},{"line":180,"name":"$self","containerName":"new","kind":13},{"name":"places","kind":12,"containerName":"new","line":180},{"line":180,"kind":13,"containerName":"new","name":"$opts"},{"containerName":"new","kind":13,"name":"$self","line":181},{"name":"places","containerName":"new","kind":12,"line":181},{"line":182,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::"},{"line":176,"kind":12,"containerName":"new","name":"SUPER"},{"signature":{"parameters":[{"label":"$this"},{"label":"$seq"}],"documentation":"__END__\n# $Id: pICalculator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::pICalculator\n#\n# Copyright (c) 2002, Merck & Co. Inc. All Rights Reserved.\n#\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pICalculator - calculate the isoelectric point of a protein\n\n=head1 DESCRIPTION\n\nCalculates the isoelectric point of a protein, the pH at which there\nis no overall charge on the protein. Calculates the charge on a protein\nat a given pH. Can use built-in sets of pK values or custom pK sets.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::pICalculator;\n  use Bio::SeqIO;\n\n  my $in = Bio::SeqIO->new( -fh => \\*STDIN ,\n                            -format => 'Fasta' );\n\n  my $calc = Bio::Tools::pICalculator->new(-places => 2,\n                                           -pKset => 'EMBOSS');\n\n  while ( my $seq = $in->next_seq ) {\n     $calc->seq($seq);\n     my $iep = $calc->iep;\n     print sprintf( \"%s\\t%s\\t%.2f\\n\",\n                    $seq->id,\n                    $iep,\n                    $calc->charge_at_pH($iep) );\n\n     for( my $i = 0; $i <= 14; $i += 0.5 ){\n        print sprintf( \"pH = %.2f\\tCharge = %.2f\\n\",\n                       $i,\n                       $calc->charge_at_pH($i) );\n     }\n  }\n\n=head1 SEE ALSO\n\nhttp://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf\nhttp://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nhttp://us.expasy.org/tools/pi_tool.html\n\n=head1 LIMITATIONS\n\nThere are various sources for the pK values of the amino acids. \nThe set of pK values chosen will affect the pI reported.\n\nThe charge state of each residue is assumed to be independent of \nthe others. Protein modifications (such as a phosphate group) that \nhave a charge are ignored.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the \nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMark Southern (mark_southern@merck.com). From an algorithm by David \nTabb found at http://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf.\nModification for Bioperl, additional documentation by Brian Osborne.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002, Merck & Co. Inc. All Rights Reserved. This module is\nfree software. It may be used, redistributed and/or modified under the terms\nof the Perl Artistic License (see http://www.perl.com/perl/misc/Artistic.html)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nPrivate methods are usually preceded by a _.\n\n\n# Let the code begin...\n\npackage Bio::Tools::pICalculator;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n# pK values from the DTASelect program from Scripps\n# http://fields.scripps.edu/DTASelect\nmy $DTASelect_pK = {  N_term   =>  8.0,\n                      K        => 10.0, # Lys\n                      R        => 12.0, # Arg\n                      H        =>  6.5, # His\n                      D        =>  4.4, # Asp\n                      E        =>  4.4, # Glu\n                      C        =>  8.5, # Cys\n                      Y        => 10.0, # Tyr\n                      C_term   =>  3.1\n                    };\n\n# pK values from the iep program from EMBOSS\n# http://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nmy $Emboss_pK  = { N_term   =>  8.6,\n                   K        => 10.8, # Lys\n                   R        => 12.5, # Arg\n                   H        =>  6.5, # His\n                   D        =>  3.9, # Asp\n                   E        =>  4.1, # Glu\n                   C        =>  8.5, # Cys\n                   Y        => 10.1, # Tyr\n                   C_term   =>  3.6\n                 };\n\n=head2 desc\n\n Title   : new\n Usage   : Bio::Tools::pICalculator->new\n Function: Instantiates the Bio::Tools::pICalculator object\n Example : $calc = Bio::Tools::pICalculator->new( -pKset => \\%pKvalues,\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 2 );\n           or:\n\n           $calc = Bio::Tools::pICalculator->new( -pKset => 'string',\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 1 );\n\n           Constructs a new pICalculator. Arguments are a flattened hash.\n           Valid, optional keys are:\n\n           pKset - A reference to a hash with key value pairs for the \n                   pK values of the charged amino acids. Required keys\n                   are:\n\n                   N_term   C_term   K   R   H   D   E   C   Y\n\n           pKset - A string ( 'DTASelect' or 'EMBOSS' ) that will \n                   specify an internal set of pK values to be used. The \n                   default is 'EMBOSS'\n\n           seq - A Bio::Seq sequence object to analyze\n\n           places - The number of decimal places to use in the\n                    isoelectric point calculation. The default is 2.\n\n Returns : The description\n Args    : The description or none\n\n\nsub new {\n   my( $class, %opts ) = @_;\n   my $self = $class->SUPER::new(%opts);\n   $self = bless {}, ref $self || $self;\n   $self->seq( $opts{-seq} ) if exists $opts{-seq};\n   $self->pKset( $opts{-pKset} || 'EMBOSS' );\n   exists $opts{-places} ? $self->places( $opts{-places} ) :\n     $self->places(2);\n   return $self;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $calc->seq($seqobj)\n Function: Sets or returns the Bio::Seq used in the calculation\n Example : $seqobj = Bio::Seq->new(-seq=>\"gghhhmmm\",-id=>\"GHM\");\n           $calc = Bio::Tools::pICalculator->new;\n           $calc->seq($seqobj);\n Returns : Bio::Seq object\n Args    : Bio::Seq object or none","label":"seq($this,$seq)"},"line":198,"kind":12,"range":{"start":{"line":198,"character":0},"end":{"character":9999,"line":206}},"definition":"sub","detail":"($this,$seq)","children":[{"definition":"my","line":199,"localvar":"my","kind":13,"containerName":"seq","name":"$this"},{"name":"$seq","kind":13,"containerName":"seq","line":199},{"line":200,"kind":13,"containerName":"seq","name":"$seq"},{"name":"$seq","kind":13,"containerName":"seq","line":200},{"line":201,"kind":13,"containerName":"seq","name":"$this"},{"line":201,"name":"throw","kind":12,"containerName":"seq"},{"kind":13,"containerName":"seq","name":"$this","line":203},{"line":203,"name":"$seq","kind":13,"containerName":"seq"},{"line":204,"name":"$this","kind":13,"containerName":"seq"},{"kind":13,"containerName":"seq","name":"$seq","line":204},{"kind":13,"containerName":"seq","name":"$this","line":205}],"containerName":"main::","name":"seq"},{"name":"UNIVERSAL","kind":12,"containerName":"isa","line":200},{"name":"count_charged_residues","kind":12,"line":204},{"line":229,"kind":12,"range":{"end":{"character":9999,"line":241},"start":{"line":229,"character":0}},"signature":{"label":"pKset($this,$pKset)","parameters":[{"label":"$this"},{"label":"$pKset"}],"documentation":"__END__\n# $Id: pICalculator.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::pICalculator\n#\n# Copyright (c) 2002, Merck & Co. Inc. All Rights Reserved.\n#\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::pICalculator - calculate the isoelectric point of a protein\n\n=head1 DESCRIPTION\n\nCalculates the isoelectric point of a protein, the pH at which there\nis no overall charge on the protein. Calculates the charge on a protein\nat a given pH. Can use built-in sets of pK values or custom pK sets.\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::pICalculator;\n  use Bio::SeqIO;\n\n  my $in = Bio::SeqIO->new( -fh => \\*STDIN ,\n                            -format => 'Fasta' );\n\n  my $calc = Bio::Tools::pICalculator->new(-places => 2,\n                                           -pKset => 'EMBOSS');\n\n  while ( my $seq = $in->next_seq ) {\n     $calc->seq($seq);\n     my $iep = $calc->iep;\n     print sprintf( \"%s\\t%s\\t%.2f\\n\",\n                    $seq->id,\n                    $iep,\n                    $calc->charge_at_pH($iep) );\n\n     for( my $i = 0; $i <= 14; $i += 0.5 ){\n        print sprintf( \"pH = %.2f\\tCharge = %.2f\\n\",\n                       $i,\n                       $calc->charge_at_pH($i) );\n     }\n  }\n\n=head1 SEE ALSO\n\nhttp://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf\nhttp://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nhttp://us.expasy.org/tools/pi_tool.html\n\n=head1 LIMITATIONS\n\nThere are various sources for the pK values of the amino acids. \nThe set of pK values chosen will affect the pI reported.\n\nThe charge state of each residue is assumed to be independent of \nthe others. Protein modifications (such as a phosphate group) that \nhave a charge are ignored.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the \nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nMark Southern (mark_southern@merck.com). From an algorithm by David \nTabb found at http://fields.scripps.edu/DTASelect/20010710-pI-Algorithm.pdf.\nModification for Bioperl, additional documentation by Brian Osborne.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2002, Merck & Co. Inc. All Rights Reserved. This module is\nfree software. It may be used, redistributed and/or modified under the terms\nof the Perl Artistic License (see http://www.perl.com/perl/misc/Artistic.html)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nPrivate methods are usually preceded by a _.\n\n\n# Let the code begin...\n\npackage Bio::Tools::pICalculator;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n# pK values from the DTASelect program from Scripps\n# http://fields.scripps.edu/DTASelect\nmy $DTASelect_pK = {  N_term   =>  8.0,\n                      K        => 10.0, # Lys\n                      R        => 12.0, # Arg\n                      H        =>  6.5, # His\n                      D        =>  4.4, # Asp\n                      E        =>  4.4, # Glu\n                      C        =>  8.5, # Cys\n                      Y        => 10.0, # Tyr\n                      C_term   =>  3.1\n                    };\n\n# pK values from the iep program from EMBOSS\n# http://emboss.sourceforge.net/apps/cvs/emboss/apps/iep.html\nmy $Emboss_pK  = { N_term   =>  8.6,\n                   K        => 10.8, # Lys\n                   R        => 12.5, # Arg\n                   H        =>  6.5, # His\n                   D        =>  3.9, # Asp\n                   E        =>  4.1, # Glu\n                   C        =>  8.5, # Cys\n                   Y        => 10.1, # Tyr\n                   C_term   =>  3.6\n                 };\n\n=head2 desc\n\n Title   : new\n Usage   : Bio::Tools::pICalculator->new\n Function: Instantiates the Bio::Tools::pICalculator object\n Example : $calc = Bio::Tools::pICalculator->new( -pKset => \\%pKvalues,\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 2 );\n           or:\n\n           $calc = Bio::Tools::pICalculator->new( -pKset => 'string',\n                                                  # a Bio::Seq object\n                                                  -seq => $seq,\n                                                  -places => 1 );\n\n           Constructs a new pICalculator. Arguments are a flattened hash.\n           Valid, optional keys are:\n\n           pKset - A reference to a hash with key value pairs for the \n                   pK values of the charged amino acids. Required keys\n                   are:\n\n                   N_term   C_term   K   R   H   D   E   C   Y\n\n           pKset - A string ( 'DTASelect' or 'EMBOSS' ) that will \n                   specify an internal set of pK values to be used. The \n                   default is 'EMBOSS'\n\n           seq - A Bio::Seq sequence object to analyze\n\n           places - The number of decimal places to use in the\n                    isoelectric point calculation. The default is 2.\n\n Returns : The description\n Args    : The description or none\n\n\nsub new {\n   my( $class, %opts ) = @_;\n   my $self = $class->SUPER::new(%opts);\n   $self = bless {}, ref $self || $self;\n   $self->seq( $opts{-seq} ) if exists $opts{-seq};\n   $self->pKset( $opts{-pKset} || 'EMBOSS' );\n   exists $opts{-places} ? $self->places( $opts{-places} ) :\n     $self->places(2);\n   return $self;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $calc->seq($seqobj)\n Function: Sets or returns the Bio::Seq used in the calculation\n Example : $seqobj = Bio::Seq->new(-seq=>\"gghhhmmm\",-id=>\"GHM\");\n           $calc = Bio::Tools::pICalculator->new;\n           $calc->seq($seqobj);\n Returns : Bio::Seq object\n Args    : Bio::Seq object or none\n\n\nsub seq {\n   my( $this, $seq ) = @_;\n   unless( defined $seq && UNIVERSAL::isa($seq,'Bio::Seq') ){\n      $this->throw(\"$seq is not a valid Bio::Seq object\");\n   }\n   $this->{-seq} = $seq;\n   $this->{-count} = count_charged_residues( $seq );\n   return $this->{-seq};\n}\n\n=head2 pKset\n\n Title   : pKset\n Usage   : $pkSet = $calc->pKSet(\\%pKSet)\n Function: Sets or returns the hash of pK values used in the calculation\n Example : $calc->pKset('emboss')\n Returns : reference to pKset hash\n Args    : The reference to a pKset hash, a string, or none. Examples:\n\n           pKset - A reference to a hash with key value pairs for the\n                   pK values of the charged amino acids. Required keys\n                   are:\n\n                   N_term   C_term   K   R   H   D   E   C   Y\n\n           pKset - A valid string ( 'DTASelect' or 'EMBOSS' ) that will \n                   specify an internal set of pK values to be used. The \n                   default is 'EMBOSS'"},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"pKset","name":"$this","line":230},{"line":230,"kind":13,"containerName":"pKset","name":"$pKset"},{"line":231,"containerName":"pKset","kind":13,"name":"$pKset"},{"line":232,"name":"$this","kind":13,"containerName":"pKset"},{"line":232,"kind":13,"containerName":"pKset","name":"$pKset"},{"line":233,"name":"$pKset","kind":13,"containerName":"pKset"},{"line":234,"name":"$this","containerName":"pKset","kind":13},{"line":234,"kind":13,"containerName":"pKset","name":"$Emboss_pK"},{"name":"$pKset","kind":13,"containerName":"pKset","line":235},{"kind":13,"containerName":"pKset","name":"$this","line":236},{"line":236,"kind":13,"containerName":"pKset","name":"$DTASelect_pK"},{"name":"$this","kind":13,"containerName":"pKset","line":238},{"containerName":"pKset","kind":13,"name":"$Emboss_pK","line":238},{"kind":13,"containerName":"pKset","name":"$this","line":240}],"containerName":"main::","name":"pKset","definition":"sub","detail":"($this,$pKset)"},{"children":[{"line":244,"localvar":"my","kind":13,"containerName":"places","name":"$this","definition":"my"},{"kind":13,"containerName":"places","name":"$this","line":245},{"line":246,"containerName":"places","kind":13,"name":"$this"}],"name":"places","containerName":"main::","definition":"sub","line":243,"range":{"end":{"line":247,"character":9999},"start":{"line":243,"character":0}},"kind":12},{"line":262,"range":{"end":{"line":269,"character":9999},"start":{"character":0,"line":262}},"kind":12,"children":[{"line":263,"name":"$this","localvar":"my","containerName":"iep","kind":13,"definition":"my"},{"line":264,"kind":13,"containerName":"iep","name":"$this"},{"line":265,"name":"$this","containerName":"iep","kind":13},{"line":266,"name":"$this","kind":13,"containerName":"iep"},{"line":267,"containerName":"iep","kind":13,"name":"$this"}],"containerName":"main::","name":"iep","definition":"sub"},{"name":"_calculate_iep","kind":12,"line":264},{"line":284,"range":{"start":{"line":284,"character":0},"end":{"character":9999,"line":288}},"kind":12,"definition":"sub","children":[{"line":285,"kind":13,"localvar":"my","containerName":"charge_at_pH","name":"$this","definition":"my"},{"containerName":"charge_at_pH","kind":13,"name":"$this","line":286},{"containerName":"charge_at_pH","kind":13,"name":"$this","line":287}],"name":"charge_at_pH","containerName":"main::"},{"kind":12,"name":"_calculate_charge_at_pH","line":286},{"definition":"sub","name":"count_charged_residues","containerName":"main::","children":[{"definition":"my","line":291,"localvar":"my","kind":13,"containerName":"count_charged_residues","name":"$seq"},{"definition":"my","line":292,"name":"$sequence","localvar":"my","containerName":"count_charged_residues","kind":13},{"line":292,"name":"$seq","containerName":"count_charged_residues","kind":13},{"line":292,"kind":12,"containerName":"count_charged_residues","name":"seq"},{"definition":"my","line":293,"localvar":"my","kind":13,"containerName":"count_charged_residues","name":"$count"},{"containerName":"count_charged_residues","kind":13,"name":"$count","line":295},{"line":295,"kind":13,"containerName":"count_charged_residues","name":"$sequence"},{"containerName":"count_charged_residues","kind":13,"name":"$count","line":297}],"kind":12,"range":{"end":{"character":9999,"line":298},"start":{"character":0,"line":290}},"line":290},{"line":300,"range":{"start":{"line":300,"character":0},"end":{"line":319,"character":9999}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$pK"},{"label":"$places"},{"label":"$seq"},{"label":"$count"}],"label":"_calculate_iep($pK,$places,$seq,$count)"},"children":[{"line":301,"name":"$pK","localvar":"my","containerName":"_calculate_iep","kind":13,"definition":"my"},{"line":301,"name":"$places","containerName":"_calculate_iep","kind":13},{"containerName":"_calculate_iep","kind":13,"name":"$seq","line":301},{"containerName":"_calculate_iep","kind":13,"name":"$count","line":301},{"definition":"my","line":302,"containerName":"_calculate_iep","localvar":"my","kind":13,"name":"$pH"},{"kind":13,"localvar":"my","containerName":"_calculate_iep","name":"$step","line":303,"definition":"my"},{"line":304,"name":"$last_charge","localvar":"my","containerName":"_calculate_iep","kind":13,"definition":"my"},{"definition":"my","line":305,"localvar":"my","kind":13,"containerName":"_calculate_iep","name":"$format"},{"line":307,"name":"$count","kind":13,"containerName":"_calculate_iep"},{"kind":13,"containerName":"_calculate_iep","name":"$count","line":308},{"containerName":"_calculate_iep","kind":13,"name":"$seq","line":308},{"definition":"my","name":"$charge","containerName":"_calculate_iep","localvar":"my","kind":13,"line":311},{"line":311,"name":"$pH","containerName":"_calculate_iep","kind":13},{"line":311,"kind":13,"containerName":"_calculate_iep","name":"$pK"},{"containerName":"_calculate_iep","kind":13,"name":"$count","line":311},{"line":312,"name":"$format","kind":13,"containerName":"_calculate_iep"},{"line":312,"kind":13,"containerName":"_calculate_iep","name":"$charge"},{"line":313,"kind":13,"containerName":"_calculate_iep","name":"$format"},{"line":313,"name":"$last_charge","kind":13,"containerName":"_calculate_iep"},{"name":"$charge","kind":13,"containerName":"_calculate_iep","line":314},{"line":314,"name":"$pH","containerName":"_calculate_iep","kind":13},{"line":314,"name":"$step","kind":13,"containerName":"_calculate_iep"},{"name":"$pH","kind":13,"containerName":"_calculate_iep","line":314},{"kind":13,"containerName":"_calculate_iep","name":"$step","line":314},{"line":315,"name":"$step","containerName":"_calculate_iep","kind":13},{"line":316,"kind":13,"containerName":"_calculate_iep","name":"$last_charge"},{"containerName":"_calculate_iep","kind":13,"name":"$charge","line":316},{"name":"$format","kind":13,"containerName":"_calculate_iep","line":318},{"line":318,"name":"$pH","kind":13,"containerName":"_calculate_iep"}],"name":"_calculate_iep","containerName":"main::","definition":"sub","detail":"($pK,$places,$seq,$count)"},{"line":311,"name":"_calculate_charge_at_pH","kind":12},{"line":323,"kind":12,"range":{"end":{"character":9999,"line":336},"start":{"line":323,"character":0}},"signature":{"parameters":[{"label":"$pH"},{"label":"$pK"},{"label":"$count"}],"documentation":" it's the sum of all the partial charges for the\n termini and all of the charged aa's!","label":"_calculate_charge_at_pH($pH,$pK,$count)"},"children":[{"definition":"my","name":"$pH","localvar":"my","kind":13,"containerName":"_calculate_charge_at_pH","line":325},{"containerName":"_calculate_charge_at_pH","kind":13,"name":"$pK","line":325},{"containerName":"_calculate_charge_at_pH","kind":13,"name":"$count","line":325},{"line":326,"localvar":"my","containerName":"_calculate_charge_at_pH","kind":13,"name":"$charge","definition":"my"},{"line":326,"containerName":"_calculate_charge_at_pH","kind":13,"name":"$pK"},{"line":326,"containerName":"_calculate_charge_at_pH","kind":13,"name":"$pH"},{"line":327,"containerName":"_calculate_charge_at_pH","kind":13,"name":"$count"},{"line":327,"kind":13,"containerName":"_calculate_charge_at_pH","name":"$pK"},{"line":327,"name":"$pH","containerName":"_calculate_charge_at_pH","kind":13},{"kind":13,"containerName":"_calculate_charge_at_pH","name":"$count","line":328},{"line":328,"containerName":"_calculate_charge_at_pH","kind":13,"name":"$pK"},{"name":"$pH","containerName":"_calculate_charge_at_pH","kind":13,"line":328},{"containerName":"_calculate_charge_at_pH","kind":13,"name":"$count","line":329},{"line":329,"containerName":"_calculate_charge_at_pH","kind":13,"name":"$pK"},{"name":"$pH","containerName":"_calculate_charge_at_pH","kind":13,"line":329},{"line":330,"containerName":"_calculate_charge_at_pH","kind":13,"name":"$count"},{"containerName":"_calculate_charge_at_pH","kind":13,"name":"$pH","line":330},{"name":"$pK","kind":13,"containerName":"_calculate_charge_at_pH","line":330},{"line":331,"containerName":"_calculate_charge_at_pH","kind":13,"name":"$count"},{"name":"$pH","containerName":"_calculate_charge_at_pH","kind":13,"line":331},{"line":331,"name":"$pK","containerName":"_calculate_charge_at_pH","kind":13},{"line":332,"name":"$count","containerName":"_calculate_charge_at_pH","kind":13},{"name":"$pH","kind":13,"containerName":"_calculate_charge_at_pH","line":332},{"line":332,"name":"$pK","kind":13,"containerName":"_calculate_charge_at_pH"},{"containerName":"_calculate_charge_at_pH","kind":13,"name":"$count","line":333},{"name":"$pH","kind":13,"containerName":"_calculate_charge_at_pH","line":333},{"name":"$pK","containerName":"_calculate_charge_at_pH","kind":13,"line":333},{"line":334,"name":"$pH","kind":13,"containerName":"_calculate_charge_at_pH"},{"line":334,"kind":13,"containerName":"_calculate_charge_at_pH","name":"$pK"},{"kind":13,"containerName":"_calculate_charge_at_pH","name":"$charge","line":335}],"containerName":"main::","name":"_calculate_charge_at_pH","definition":"sub","detail":"($pH,$pK,$count)"},{"name":"warnings","kind":12,"line":324},{"line":326,"name":"_partial_charge","kind":12},{"kind":12,"name":"N_term","line":326},{"kind":12,"name":"_partial_charge","line":327},{"name":"_partial_charge","kind":12,"line":328},{"line":329,"name":"_partial_charge","kind":12},{"name":"_partial_charge","kind":12,"line":330},{"line":331,"name":"_partial_charge","kind":12},{"name":"_partial_charge","kind":12,"line":332},{"name":"_partial_charge","kind":12,"line":333},{"name":"_partial_charge","kind":12,"line":334},{"line":334,"kind":12,"name":"C_term"},{"containerName":"main::","name":"_partial_charge","children":[{"definition":"my","line":341,"name":"$cr","localvar":"my","containerName":"_partial_charge","kind":13},{"name":"$cr","kind":13,"containerName":"_partial_charge","line":342},{"line":342,"containerName":"_partial_charge","kind":13,"name":"$cr"}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":340},"end":{"line":343,"character":9999}},"line":340}]}