{"version":5,"vars":[{"line":121,"name":"base","containerName":"","kind":2},{"children":[{"definition":"my","localvar":"my","containerName":"_initialize_state","kind":13,"name":"$self","line":124},{"line":124,"name":"@args","kind":13,"containerName":"_initialize_state"},{"line":127,"name":"$make","localvar":"my","kind":13,"containerName":"_initialize_state","definition":"my"},{"containerName":"_initialize_state","kind":13,"name":"$self","line":127},{"line":127,"name":"@args","containerName":"_initialize_state","kind":13},{"line":133,"kind":13,"containerName":"_initialize_state","name":"$self"},{"containerName":"_initialize_state","kind":12,"name":"analysis_method","line":133}],"containerName":"main::","name":"_initialize_state","definition":"sub","detail":"($self,@args)","line":123,"range":{"end":{"line":134,"character":9999},"start":{"character":0,"line":123}},"kind":12,"signature":{"label":"_initialize_state($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""}},{"name":"SUPER","kind":12,"containerName":"_initialize_state","line":127},{"range":{"start":{"character":0,"line":147},"end":{"line":154,"character":9999}},"kind":12,"line":147,"signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"containerName":"main::","name":"analysis_method","children":[{"definition":"my","line":149,"name":"$self","kind":13,"localvar":"my","containerName":"analysis_method"},{"name":"$method","containerName":"analysis_method","kind":13,"line":149},{"line":150,"name":"$method","kind":13,"containerName":"analysis_method"},{"line":150,"name":"$method","kind":13,"containerName":"analysis_method"},{"line":151,"containerName":"analysis_method","kind":13,"name":"$self"},{"containerName":"analysis_method","kind":12,"name":"throw","line":151},{"name":"$self","containerName":"analysis_method","kind":13,"line":151},{"name":"$self","containerName":"analysis_method","kind":13,"line":153},{"kind":13,"containerName":"analysis_method","name":"$method","line":153}],"detail":"($self,$method)","definition":"sub"},{"name":"SUPER","containerName":"analysis_method","kind":12,"line":153},{"definition":"sub","detail":"($self)","children":[{"definition":"my","containerName":"parse_next_alignment","localvar":"my","kind":13,"name":"$self","line":175},{"definition":"my","line":177,"name":"$started","localvar":"my","kind":13,"containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","kind":13,"name":"$version","line":177},{"kind":13,"containerName":"parse_next_alignment","name":"$strand","line":177},{"line":177,"kind":13,"containerName":"parse_next_alignment","name":"$exoncount"},{"localvar":"my","kind":13,"containerName":"parse_next_alignment","name":"%seq1props","line":178,"definition":"my"},{"line":178,"name":"%seq2props","kind":13,"containerName":"parse_next_alignment"},{"kind":13,"containerName":"parse_next_alignment","name":"@exons","line":178},{"line":182,"name":"$self","kind":13,"containerName":"parse_next_alignment"},{"line":182,"name":"_readline","kind":12,"containerName":"parse_next_alignment"},{"containerName":"parse_next_alignment","kind":13,"name":"$started","line":189},{"line":190,"containerName":"parse_next_alignment","kind":13,"name":"$self"},{"line":190,"name":"_pushback","containerName":"parse_next_alignment","kind":12},{"line":191,"containerName":"parse_next_alignment","kind":13,"name":"@exons"},{"containerName":"parse_next_alignment","kind":13,"name":"$version","line":193},{"name":"$version","containerName":"parse_next_alignment","kind":13,"line":194},{"name":"$self","containerName":"parse_next_alignment","kind":13,"line":195},{"name":"throw","kind":12,"containerName":"parse_next_alignment","line":195},{"name":"$started","containerName":"parse_next_alignment","kind":13,"line":197},{"name":"$seq1props","kind":13,"containerName":"parse_next_alignment","line":201},{"line":202,"kind":13,"containerName":"parse_next_alignment","name":"$seq1props"},{"name":"$self","containerName":"parse_next_alignment","kind":13,"line":203},{"line":203,"name":"genomic_dna_length","containerName":"parse_next_alignment","kind":12},{"line":203,"name":"$seq1props","containerName":"parse_next_alignment","kind":13},{"containerName":"parse_next_alignment","kind":13,"name":"$seq2props","line":208},{"kind":13,"containerName":"parse_next_alignment","name":"$seq2props","line":209},{"name":"$strand","kind":13,"containerName":"parse_next_alignment","line":213},{"line":215,"kind":13,"containerName":"parse_next_alignment","name":"$strand"},{"containerName":"parse_next_alignment","kind":13,"name":"$exoncount","line":218},{"definition":"my","name":"$genomic_start","localvar":"my","containerName":"parse_next_alignment","kind":13,"line":220},{"name":"$genomic_stop","containerName":"parse_next_alignment","kind":13,"line":220},{"name":"$cdna_start","containerName":"parse_next_alignment","kind":13,"line":220},{"line":220,"name":"$cdna_stop","containerName":"parse_next_alignment","kind":13},{"line":221,"name":"$id","containerName":"parse_next_alignment","kind":13},{"line":221,"kind":13,"containerName":"parse_next_alignment","name":"$mismatches"},{"name":"$gaps","kind":13,"containerName":"parse_next_alignment","line":221},{"name":"$splice_donor","kind":13,"containerName":"parse_next_alignment","line":221},{"line":222,"containerName":"parse_next_alignment","kind":13,"name":"$splice_acceptor"},{"line":222,"containerName":"parse_next_alignment","kind":13,"name":"$uncertain"},{"definition":"my","name":"$ec","localvar":"my","kind":13,"containerName":"parse_next_alignment","line":228},{"kind":13,"containerName":"parse_next_alignment","name":"$ec","line":228},{"kind":13,"containerName":"parse_next_alignment","name":"$exoncount","line":228},{"line":228,"name":"$ec","containerName":"parse_next_alignment","kind":13},{"name":"$self","kind":13,"containerName":"parse_next_alignment","line":229},{"kind":12,"containerName":"parse_next_alignment","name":"_readline","line":229},{"name":"$genomic_start","kind":13,"containerName":"parse_next_alignment","line":233},{"line":234,"name":"$genomic_stop","containerName":"parse_next_alignment","kind":13},{"name":"$cdna_start","kind":13,"containerName":"parse_next_alignment","line":235},{"line":236,"name":"$cdna_stop","containerName":"parse_next_alignment","kind":13},{"name":"$id","containerName":"parse_next_alignment","kind":13,"line":237},{"name":"$mismatches","containerName":"parse_next_alignment","kind":13,"line":238},{"name":"$gaps","kind":13,"containerName":"parse_next_alignment","line":239},{"line":240,"name":"$splice_donor","containerName":"parse_next_alignment","kind":13},{"line":241,"name":"$splice_acceptor","containerName":"parse_next_alignment","kind":13},{"containerName":"parse_next_alignment","kind":13,"name":"$uncertain","line":242},{"containerName":"parse_next_alignment","kind":13,"name":"$self","line":244},{"line":244,"name":"throw","kind":12,"containerName":"parse_next_alignment"},{"definition":"my","name":"$exon","kind":13,"localvar":"my","containerName":"parse_next_alignment","line":247},{"name":"new","kind":12,"containerName":"parse_next_alignment","line":248},{"kind":13,"containerName":"parse_next_alignment","name":"$genomic_start","line":248},{"line":249,"name":"$genomic_stop","containerName":"parse_next_alignment","kind":13},{"line":250,"name":"$strand","containerName":"parse_next_alignment","kind":13},{"line":251,"kind":13,"containerName":"parse_next_alignment","name":"$exon"},{"name":"seq_id","kind":12,"containerName":"parse_next_alignment","line":251},{"kind":13,"containerName":"parse_next_alignment","name":"$seq1props","line":251},{"name":"$exon","containerName":"parse_next_alignment","kind":13,"line":254},{"kind":12,"containerName":"parse_next_alignment","name":"feature1","line":254},{"name":"can","kind":12,"containerName":"parse_next_alignment","line":254},{"line":255,"kind":13,"containerName":"parse_next_alignment","name":"$exon"},{"name":"feature1","kind":12,"containerName":"parse_next_alignment","line":255},{"name":"seqlength","containerName":"parse_next_alignment","kind":12,"line":255},{"containerName":"parse_next_alignment","kind":13,"name":"$seq1props","line":255},{"line":257,"containerName":"parse_next_alignment","kind":13,"name":"$exon"},{"line":257,"containerName":"parse_next_alignment","kind":12,"name":"feature1"},{"containerName":"parse_next_alignment","kind":12,"name":"add_tag_value","line":257},{"line":257,"containerName":"parse_next_alignment","kind":13,"name":"$seq1props"},{"definition":"my","line":261,"containerName":"parse_next_alignment","localvar":"my","kind":13,"name":"$fea2"},{"line":262,"kind":12,"containerName":"parse_next_alignment","name":"new"},{"kind":13,"containerName":"parse_next_alignment","name":"$cdna_start","line":262},{"containerName":"parse_next_alignment","kind":13,"name":"$cdna_stop","line":263},{"line":264,"containerName":"parse_next_alignment","kind":13,"name":"$strand"},{"line":265,"containerName":"parse_next_alignment","kind":13,"name":"$seq2props"},{"line":267,"name":"$fea2","containerName":"parse_next_alignment","kind":13},{"name":"seqlength","kind":12,"containerName":"parse_next_alignment","line":267},{"name":"$seq2props","kind":13,"containerName":"parse_next_alignment","line":267},{"name":"$exon","kind":13,"containerName":"parse_next_alignment","line":269},{"containerName":"parse_next_alignment","kind":12,"name":"est_hit","line":269},{"containerName":"parse_next_alignment","kind":13,"name":"$fea2","line":269},{"name":"$exon","containerName":"parse_next_alignment","kind":13,"line":272},{"line":272,"containerName":"parse_next_alignment","kind":12,"name":"source_tag"},{"line":272,"containerName":"parse_next_alignment","kind":13,"name":"$self"},{"name":"analysis_method","containerName":"parse_next_alignment","kind":12,"line":272},{"line":273,"containerName":"parse_next_alignment","kind":13,"name":"$exon"},{"name":"percentage_id","kind":12,"containerName":"parse_next_alignment","line":273},{"line":274,"kind":13,"containerName":"parse_next_alignment","name":"$exon"},{"line":274,"name":"mismatches","kind":12,"containerName":"parse_next_alignment"},{"line":275,"containerName":"parse_next_alignment","kind":13,"name":"$exon"},{"name":"gaps","containerName":"parse_next_alignment","kind":12,"line":275},{"kind":13,"containerName":"parse_next_alignment","name":"$exon","line":276},{"name":"donor","containerName":"parse_next_alignment","kind":12,"line":276},{"line":277,"kind":13,"containerName":"parse_next_alignment","name":"$exon"},{"line":277,"kind":12,"containerName":"parse_next_alignment","name":"acceptor"},{"line":280,"containerName":"parse_next_alignment","kind":13,"name":"@exons"},{"kind":13,"containerName":"parse_next_alignment","name":"$exon","line":280},{"kind":13,"containerName":"parse_next_alignment","name":"$self","line":282},{"line":282,"name":"throw","kind":12,"containerName":"parse_next_alignment"},{"line":286,"containerName":"parse_next_alignment","kind":13,"name":"$self"},{"name":"splicesites","kind":12,"containerName":"parse_next_alignment","line":286},{"line":288,"name":"$self","containerName":"parse_next_alignment","kind":13},{"line":288,"containerName":"parse_next_alignment","kind":12,"name":"est_coverage"},{"line":290,"name":"$self","containerName":"parse_next_alignment","kind":13},{"kind":12,"containerName":"parse_next_alignment","name":"overall_percentage_id","line":290},{"line":292,"containerName":"parse_next_alignment","kind":13,"name":"$self"},{"line":292,"name":"missing_mrna_ends","containerName":"parse_next_alignment","kind":12},{"localvar":"my","containerName":"parse_next_alignment","kind":13,"name":"$exon_num","line":294,"definition":"my"},{"line":294,"name":"$gen_start","kind":13,"containerName":"parse_next_alignment"},{"kind":13,"containerName":"parse_next_alignment","name":"$gen_stop","line":294},{"kind":13,"containerName":"parse_next_alignment","name":"$cdna_start","line":294},{"line":294,"name":"$cdna_stop","kind":13,"containerName":"parse_next_alignment"},{"line":295,"name":"$exon_num","kind":13,"containerName":"parse_next_alignment"},{"line":296,"kind":13,"containerName":"parse_next_alignment","name":"$gen_start"},{"line":297,"containerName":"parse_next_alignment","kind":13,"name":"$gen_stop"},{"line":298,"name":"$cdna_start","containerName":"parse_next_alignment","kind":13},{"kind":13,"containerName":"parse_next_alignment","name":"$cdna_stop","line":299},{"line":324,"kind":13,"containerName":"parse_next_alignment","name":"@exons"},{"kind":13,"containerName":"parse_next_alignment","name":"@exons","line":324}],"name":"parse_next_alignment","containerName":"main::","signature":{"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :","parameters":[{"label":"$self"}],"label":"parse_next_alignment($self)"},"line":174,"kind":12,"range":{"end":{"line":325,"character":9999},"start":{"line":174,"character":0}}},{"name":"Bio","kind":12,"containerName":"Tools::Spidey::Exon","line":247},{"containerName":"SeqFeature::Similarity","kind":12,"name":"Bio","line":261},{"line":351,"range":{"end":{"line":378,"character":9999},"start":{"character":0,"line":351}},"kind":12,"children":[{"kind":13,"localvar":"my","containerName":"next_exonset","name":"$self","line":352,"definition":"my"},{"localvar":"my","kind":13,"containerName":"next_exonset","name":"$exonset","line":353,"definition":"my"},{"name":"$exons","localvar":"my","containerName":"next_exonset","kind":13,"line":356,"definition":"my"},{"containerName":"next_exonset","kind":13,"name":"$self","line":356},{"name":"parse_next_alignment","containerName":"next_exonset","kind":12,"line":356},{"name":"$exons","containerName":"next_exonset","kind":13,"line":357},{"containerName":"next_exonset","kind":13,"name":"$self","line":358},{"kind":12,"containerName":"next_exonset","name":"warn","line":358},{"line":361,"name":"$exons","containerName":"next_exonset","kind":13},{"name":"new","kind":12,"containerName":"next_exonset","line":362},{"line":366,"name":"$exonset","containerName":"next_exonset","kind":13},{"containerName":"next_exonset","kind":12,"name":"new","line":366},{"line":366,"containerName":"next_exonset","kind":13,"name":"$exons"},{"line":366,"name":"start","kind":12,"containerName":"next_exonset"},{"line":367,"kind":13,"containerName":"next_exonset","name":"$exons"},{"name":"end","kind":12,"containerName":"next_exonset","line":367},{"line":368,"name":"$exons","containerName":"next_exonset","kind":13},{"name":"strand","containerName":"next_exonset","kind":12,"line":368},{"line":370,"name":"$exonset","containerName":"next_exonset","kind":13},{"name":"source_tag","containerName":"next_exonset","kind":12,"line":370},{"containerName":"next_exonset","kind":13,"name":"$exons","line":370},{"containerName":"next_exonset","kind":12,"name":"source_tag","line":370},{"line":371,"containerName":"next_exonset","kind":13,"name":"$exonset"},{"name":"seq_id","kind":12,"containerName":"next_exonset","line":371},{"kind":13,"containerName":"next_exonset","name":"$exons","line":371},{"kind":12,"containerName":"next_exonset","name":"seq_id","line":371},{"definition":"my","line":374,"name":"$exon","localvar":"my","containerName":"next_exonset","kind":13},{"name":"$exons","kind":13,"containerName":"next_exonset","line":374},{"line":375,"containerName":"next_exonset","kind":13,"name":"$exonset"},{"name":"add_sub_SeqFeature","kind":12,"containerName":"next_exonset","line":375},{"line":375,"name":"$exon","kind":13,"containerName":"next_exonset"},{"line":377,"name":"$exonset","containerName":"next_exonset","kind":13}],"name":"next_exonset","containerName":"main::","definition":"sub"},{"line":362,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"line":366,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"kind":12,"range":{"start":{"line":401,"character":0},"end":{"line":407,"character":9999}},"line":401,"signature":{"label":"next_feature($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :"},"name":"next_feature","containerName":"main::","children":[{"line":402,"name":"$self","localvar":"my","containerName":"next_feature","kind":13,"definition":"my"},{"line":402,"containerName":"next_feature","kind":13,"name":"@args"},{"name":"$self","containerName":"next_feature","kind":13,"line":406},{"kind":12,"containerName":"next_feature","name":"next_exonset","line":406},{"kind":13,"containerName":"next_feature","name":"@args","line":406}],"detail":"($self,@args)","definition":"sub"},{"name":"genomic_dna_length","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"genomic_dna_length","name":"$self","line":421},{"name":"@args","containerName":"genomic_dna_length","kind":13,"line":421},{"line":422,"name":"$val","containerName":"genomic_dna_length","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"genomic_dna_length","name":"@args","line":424},{"name":"$val","kind":13,"containerName":"genomic_dna_length","line":425},{"line":425,"kind":13,"containerName":"genomic_dna_length","name":"@args"},{"name":"$self","containerName":"genomic_dna_length","kind":13,"line":426},{"containerName":"genomic_dna_length","kind":13,"name":"$val","line":426},{"line":428,"name":"$val","containerName":"genomic_dna_length","kind":13},{"kind":13,"containerName":"genomic_dna_length","name":"$self","line":428},{"name":"$val","containerName":"genomic_dna_length","kind":13,"line":430}],"detail":"($self,@args)","definition":"sub","range":{"end":{"character":9999,"line":431},"start":{"line":420,"character":0}},"kind":12,"line":420,"signature":{"label":"genomic_dna_length($self,@args)","documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :","parameters":[{"label":"$self"},{"label":"@args"}]}},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub genomic_dna_length {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'genomic_dna_length'} = $val;\n    } else {\n\t$val = $self->{'genomic_dna_length'};\n    }\n    return $val;\n}\n\n=head2 splicesites\n\n    Title   : splicesites\n    Usage   : $spidey->splicesites();\n    Function: Returns the number of splice sites found in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :","label":"splicesites($self,@args)"},"line":444,"range":{"start":{"line":444,"character":0},"end":{"character":9999,"line":455}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"line":445,"name":"$self","containerName":"splicesites","localvar":"my","kind":13,"definition":"my"},{"line":445,"name":"@args","kind":13,"containerName":"splicesites"},{"definition":"my","line":446,"containerName":"splicesites","localvar":"my","kind":13,"name":"$val"},{"line":448,"kind":13,"containerName":"splicesites","name":"@args"},{"kind":13,"containerName":"splicesites","name":"$val","line":449},{"name":"@args","kind":13,"containerName":"splicesites","line":449},{"line":450,"name":"$self","kind":13,"containerName":"splicesites"},{"kind":13,"containerName":"splicesites","name":"$val","line":450},{"kind":13,"containerName":"splicesites","name":"$val","line":452},{"kind":13,"containerName":"splicesites","name":"$self","line":452},{"name":"$val","kind":13,"containerName":"splicesites","line":454}],"containerName":"main::","name":"splicesites"},{"name":"est_coverage","containerName":"main::","children":[{"definition":"my","line":469,"localvar":"my","containerName":"est_coverage","kind":13,"name":"$self"},{"containerName":"est_coverage","kind":13,"name":"@args","line":469},{"kind":13,"localvar":"my","containerName":"est_coverage","name":"$val","line":470,"definition":"my"},{"line":472,"kind":13,"containerName":"est_coverage","name":"@args"},{"name":"$val","kind":13,"containerName":"est_coverage","line":473},{"kind":13,"containerName":"est_coverage","name":"@args","line":473},{"name":"$self","kind":13,"containerName":"est_coverage","line":474},{"name":"$val","kind":13,"containerName":"est_coverage","line":474},{"line":476,"kind":13,"containerName":"est_coverage","name":"$val"},{"line":476,"name":"$self","kind":13,"containerName":"est_coverage"},{"line":478,"kind":13,"containerName":"est_coverage","name":"$val"}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"line":468,"character":0},"end":{"character":9999,"line":479}},"line":468,"signature":{"label":"est_coverage($self,@args)","documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub genomic_dna_length {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'genomic_dna_length'} = $val;\n    } else {\n\t$val = $self->{'genomic_dna_length'};\n    }\n    return $val;\n}\n\n=head2 splicesites\n\n    Title   : splicesites\n    Usage   : $spidey->splicesites();\n    Function: Returns the number of splice sites found in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub splicesites {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'splicesites'} = $val;\n    } else {\n\t$val = $self->{'splicesites'};\n    }\n    return $val;\n}\n\n=head2 est_coverage\n\n    Title   : est_coverage\n    Usage   : $spidey->est_coverage();\n    Function: Returns the percent of est coverage in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :","parameters":[{"label":"$self"},{"label":"@args"}]}},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"overall_percentage_id","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"overall_percentage_id","line":493,"definition":"my"},{"line":493,"kind":13,"containerName":"overall_percentage_id","name":"@args"},{"definition":"my","line":494,"containerName":"overall_percentage_id","localvar":"my","kind":13,"name":"$val"},{"line":496,"kind":13,"containerName":"overall_percentage_id","name":"@args"},{"name":"$val","containerName":"overall_percentage_id","kind":13,"line":497},{"name":"@args","kind":13,"containerName":"overall_percentage_id","line":497},{"name":"$self","kind":13,"containerName":"overall_percentage_id","line":498},{"name":"$val","containerName":"overall_percentage_id","kind":13,"line":498},{"name":"$val","kind":13,"containerName":"overall_percentage_id","line":500},{"name":"$self","kind":13,"containerName":"overall_percentage_id","line":500},{"name":"$val","kind":13,"containerName":"overall_percentage_id","line":502}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub genomic_dna_length {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'genomic_dna_length'} = $val;\n    } else {\n\t$val = $self->{'genomic_dna_length'};\n    }\n    return $val;\n}\n\n=head2 splicesites\n\n    Title   : splicesites\n    Usage   : $spidey->splicesites();\n    Function: Returns the number of splice sites found in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub splicesites {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'splicesites'} = $val;\n    } else {\n\t$val = $self->{'splicesites'};\n    }\n    return $val;\n}\n\n=head2 est_coverage\n\n    Title   : est_coverage\n    Usage   : $spidey->est_coverage();\n    Function: Returns the percent of est coverage in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub est_coverage {\n     my ($self, @args) = @_;\n     my $val;\n     \n     if(@args) {\n\t $val = shift(@args);\n\t $self->{'est_coverage'} = $val;\n     } else {\n\t $val = $self->{'est_coverage'};\n     }\n     return $val;\n }\n\n=head2 overall_percentage_id\n\n    Title   : overall_percentage_id\n    Usage   : $spidey->overall_percentage_id();\n    Function: Returns the overall percent id in this Spidey result\n    Example :\n    Returns : An float value.\n    Args    :","label":"overall_percentage_id($self,@args)"},"kind":12,"range":{"start":{"line":492,"character":0},"end":{"line":503,"character":9999}},"line":492},{"signature":{"label":"missing_mrna_ends($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Results.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Spidey::Results\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ryan Golhar <golharam@umdnj.edu>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Spidey::Results - Results of a Spidey run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Spidey::Results;\n\tmy $spidey = Bio::Tools::Spidey::Results->new(-file => 'result.spidey' );\n\n\t# or\n\n\tmy $spidey = Bio::Tools::Spidey::Results->new( -fh   => \\*INPUT );\n\n\t# get the exons before doing anything else\n\tmy $exonset = $spidey->next_exonset();\n\n\t# parse the results\n\tmy @exons = $exonset->sub_SeqFeature();\n\tprint \"Total no of Exons: \", scalar(@exons), \"\\n\";\n\n\tprint \"Genomic sequence length: \", $spidey->genomic_dna_length(), \"\\n\";\n\n\t# $exonset is-a Bio::SeqFeature::Generic with Bio::Tools::Spidey::Exons\n\t# as sub features\n\tprint \"Delimited on sequence \", $exonset->seq_id(), \" from \", \n\t\t$exonset->start(), \" to \", $exonset->end(), \"\\n\";\n\n\tforeach my $exon ( $exonset->sub_SeqFeature() ) {\n\t\t# $exon is-a Bio::SeqFeature::FeaturePair\n\t\tprint \"Exon from \", $exon->start, \" to \", $exon->end, \n\t\t\t\" on strand \", $exon->strand(), \"\\n\";\n\t\t# you can get out what it matched using the est_hit attribute\n\t\tmy $homol = $exon->est_hit();\n\t\tprint \"Matched to sequence \", $homol->seq_id, \n\t\t\t\" at \", $homol->start,\" to \", $homol->end, \"\\n\";\n\t}\n\n\t# essential if you gave a filename at initialization (otherwise \n  \t# the file stays open)\n\t$spidey->close();\n\n=head1 DESCRIPTION\n\nThe spidey module provides a parser and results object for spidey \noutput. The spidey results are specialised types of SeqFeatures, \nmeaning you can add them to AnnSeq objects fine, and manipulate them \nin the \"normal\" seqfeature manner.\n\nThe spidey Exon objects are Bio::SeqFeature::FeaturePair inherited \nobjects. The $esthit = $exon-E<gt>est_hit() is the alignment as a \nfeature on the matching object (normally, a cDNA), in which the \nstart/end points are where the hit lies.\n\nTo make this module work sensibly you need to run\n\n     spidey -i genomic.fasta -m cDNA.fasta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ryan Golhar\n\nEmail golharam@umdnj.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Spidey::Results;\nuse strict;\n\nuse File::Basename;\nuse Bio::Root::Root;\nuse Bio::Tools::Spidey::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # call the inherited method first\n    my $make = $self->SUPER::_initialize_state(@args);\n\n#    my ($est_is_first) = $self->_rearrange([qw(ESTFIRST)], @args);\n\n#    delete($self->{'_est_is_first'});\n#    $self->{'_est_is_first'} = $est_is_first if(defined($est_is_first));\n    $self->analysis_method(\"Spidey\");\n}\n\n=head2 analysis_method\n\n Usage     : $spidey->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Spidey/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Spidey/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 parse_next_alignment\n\n Title   : parse_next_alignment\n Usage   : @exons = $spidey_result->parse_next_alignment;\n           foreach $exon (@exons) {\n               # do something\n           }\n Function: Parses the next alignment of the Spidey result file and returns the\n           found exons as an array of Bio::Tools::Spidey::Exon objects. Call\n           this method repeatedly until an empty array is returned to get the\n           results for all alignments.\n Example :\n Returns : An array of Bio::Tools::Spidey::Exon objects\n Args    :\n\n\n\nsub parse_next_alignment {\n    my ($self) = @_;\n    # for strand 1 = plus, -1 = minus\n    my ($started,$version,$strand, $exoncount) = (0,0,0,-1);\n    my (%seq1props,%seq2props,@exons);\n    \n    # we refer to the properties of each seq by reference\n\n    while(defined($_ = $self->_readline())) {\n\tchomp;\n\t#\n\t# bascially, parse a Spidey result...\n\t#\n\t# matches: --SPIDEY version 1.40--\n\tif( /^--SPIDEY\\s+version\\s+(\\d+\\.\\d+)--/) {\n\t    if($started) {\n\t\t$self->_pushback($_);\n\t\treturn \\@exons;\n\t    }\n\t    $version = $1;\n\t    if ($version != 1.40) {\n\t\t$self->throw(\"Spidey parser only designed to work with Spidey v1.40\\n\");\n\t    }\n\t    $started = 1;\n\t} elsif (/^Genomic:\\s+(\\S+)\\s.*,\\s+(\\d+)\\sbp$/ ) {\n\t    # matches: Genomic: lcl|some_name other information, 1234 bp\n\t    # $seq1props{'filename'} = $1;\n\t    $seq1props{'seqname'} = $1;\n\t    $seq1props{'length'} = $2;\t   \n\t    $self->genomic_dna_length($seq1props{'length'});\n\n\t} elsif( /^mRNA:\\s+(\\S+)\\s.*,(?:\\s+mRNA\\s+sequence,)?\\s(\\d+)\\sbp$/ ) {\n\t    # matches: mRNA:\n\t    # $seq2props{'filename'} = $1;\n\t    $seq2props{'seqname'} = $1;\n\t    $seq2props{'length'} = $2;\n\n\t} elsif( /^Strand:/ ) {\n\t    if (/plus/) {\n\t\t$strand = 1;\n\t    } else {\n\t\t$strand = -1;\n\t    }\n\t} elsif( /^Number of exons: (\\d+)/ ) {\n\t    $exoncount = $1;\n\n\t    my ($genomic_start, $genomic_stop, $cdna_start, $cdna_stop,\n\t\t$id, $mismatches, $gaps, $splice_donor, \n\t\t$splice_acceptor, $uncertain);\n\n\t    # the next $exoncount lines contains information\n\t    # about the matches of each exon.  we should parse\n\t    # this information here\n\n\t    for (my $ec = 1; $ec <= $exoncount; $ec++) {\n\t\tif (defined($_ = $self->_readline())) {\n\t\t    chomp;\n\n\t\t    if (/^Exon\\s$ec[\\(\\)-]*:\\s(\\d+)-(\\d+)\\s\\(gen\\)\\s+(\\d+)-(\\d+)\\s\\(mRNA\\)\\s+id\\s([\\d\\.inf-]+)%\\s+mismatches\\s(\\d+)\\s+gaps\\s(\\d+)\\s+splice\\ssite\\s\\(d\\s+a\\):\\s(\\d+)\\s+(\\d+)\\s*(\\w*)/) {\n\t\t\t$genomic_start = $1;\n\t\t\t$genomic_stop = $2;\n\t\t\t$cdna_start = $3;\n\t\t\t$cdna_stop = $4;\n\t\t\t$id = $5;\n\t\t\t$mismatches = $6;\n\t\t\t$gaps = $7;\n\t\t\t$splice_donor = $8;\n\t\t\t$splice_acceptor = $9;\n\t\t\t$uncertain = $10;\n\t\t    } else {\n\t\t\t$self->throw( \"Failed to match anything:\\n$_\\n\");\n\t\t    }\n\n\t\t    my $exon = Bio::Tools::Spidey::Exon->new\n\t\t\t(-start  => $genomic_start,\n\t\t\t -end    => $genomic_stop,\n\t\t\t -strand => $strand);\n\t\t    $exon->seq_id($seq1props{'seqname'});\n\n\t\t    # feature1 is supposed to be initialized to a Similarity object, but we provide a safety net\n\t\t    if ($exon->feature1->can('seqlength')) {\n\t\t\t$exon->feature1->seqlength($seq1props{'length'});\n\t\t    } else {\n\t\t\t$exon->feature1->add_tag_value('seqlength', $seq1props{'length'});\n\t\t    }\n\n\t\t    # create and initialize the feature wrapping the 'hit' (the cDNA)\n\t\t    my $fea2 = Bio::SeqFeature::Similarity->new\n\t\t\t(-start   => $cdna_start,\n\t\t\t -end     => $cdna_stop,\n\t\t\t -strand  => $strand,\n\t\t\t -seq_id  => $seq2props{'seqname'},\n\t\t\t -primary => \"aligning_cDNA\");\n\t\t    $fea2->seqlength($seq2props{'length'});\n\t\t    # store\n\t\t    $exon->est_hit($fea2);\t   \n\n\t\t    # general properties\n\t\t    $exon->source_tag($self->analysis_method());\n\t\t    $exon->percentage_id($5);\n\t\t    $exon->mismatches($6);\n\t\t    $exon->gaps($7);\n\t\t    $exon->donor($8);\n\t\t    $exon->acceptor($9);\n\n\t\t    # push onto array\n\t\t    push(@exons, $exon);\n\t\t} else {\n\t\t    $self->throw(\"Unexpected end of file reached\\n\");\n\t\t}\n\t    }\n\t} elsif( /^Number of splice sites:\\s+(\\d+)/ ) {\n\t    $self->splicesites($1);\t\n\t} elsif( /^mRNA coverage:\\s+(\\d+)%/ ) { \n\t    $self->est_coverage($1);\n\t} elsif(/^overall percent identity:\\s+([\\d\\.]+)%/ ) {\n\t    $self->overall_percentage_id($1);\n\t} elsif(/^Missing mRNA ends:\\s+(\\w+)/ ) {\n\t    $self->missing_mrna_ends($1);\n\t} elsif( /^Exon (\\d+): (\\d+)-(\\d+) \\(gen\\)\\s+(\\d+)-(\\d+) \\(mRNA\\)/ ) {\n\t    my ($exon_num, $gen_start, $gen_stop, $cdna_start, $cdna_stop);\t\t\t\t\t\t\n\t    $exon_num = $1;\n\t    $gen_start = $2;\n\t    $gen_stop = $3;\n\t    $cdna_start = $4;\n\t    $cdna_stop = $5;\t\t\t\n\t} elsif( /No alignment found/ ) {\n\t    return [];\n\t} else {\n\t    #$self->debug(\"unmatched $_\\n\");\n\t}\n    }\n    # Typical format:\n    # \tExon 1: 36375798-36375691 (gen)  1-108 (mRNA)\n    #\n    #\n    #\tCCTCTTTTTCTTTGCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #        \t   |  ||||||||||||||||||||||||||||||||||||||||||||||\n    #\t          ATGTCAGGGTATATACCCAGTTACTTAGACAAGGATGAGCTATGTGTAGT\n    #\t           M  S  G  Y  I  P  S  Y  L  D  K  D  E  L  C  V  V \n    #\n    #\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAGGT\n    #\t||||||||||||||||||||||||||||||||||||||||||||||||||||||||||\n    #\tATGTGGGGACAAAGCCACCGGATATCATTATCGCTGCATCACTTGTGAAGGTTGCAAG\n    #\t  C  G  D  K  A  T  G  Y  H  Y  R  C  I  T  C  E  G  C  K \n    #\n    #\n    #\tAAATGGCA\n    #\n    @exons ? return \\@exons : return ;\n}\n\n=head2 next_exonset\n\n  Title   : next_exonset\n  Usage   : $exonset = $spidey_result->parse_next_exonset;\n         print \"Exons start at \", $exonset->start(), \n        \"and end at \", $exonset->end(), \"\\n\";\n         for $exon ($exonset->sub_SeqFeature()) {\n\t    # do something\n         }\n  Function: Parses the next alignment of the Spidey result file and returns the\n       set of exons as a container of features. The container is itself\n       a Bio::SeqFeature::Generic object, with the Bio::Tools::Spidey::Exon\n       objects as sub features. Start, end, and strand of the container\n       will represent the total region covered by the exons of this set.\n\n      See the documentation of parse_next_alignment() for further\n      reference about parsing and how the information is stored.\n Example : \n Returns : An Bio::SeqFeature::Generic object holding Bio::Tools::Spidey::Exon\n          objects as sub features.\n Args    :\n\n\nsub next_exonset {\n    my $self = shift;\n    my $exonset;\n\n    # get the next array of exons\n    my $exons = $self->parse_next_alignment();\n    if( ! defined $exons ) {\n        $self->warn(\"No exons returned\");\n        return;\n    } \n    if( @$exons == 0 ) {\n\treturn Bio::SeqFeature::Generic->new();\n    }\n    # create the container of exons as a feature object itself, with the\n    # data of the first exon for initialization\n    $exonset = Bio::SeqFeature::Generic->new('-start' => $exons->[0]->start(),\n\t\t\t\t\t     '-end' => $exons->[-1]->end(),\n\t\t\t\t\t     '-strand' => $exons->[0]->strand(),\n\t\t\t\t\t     '-primary' => \"ExonSet\");\n    $exonset->source_tag($exons->[0]->source_tag());\n    $exonset->seq_id($exons->[0]->seq_id());\n    # now add all exons as sub features, with enabling EXPANsion of the region\n    # covered in total\n    foreach my $exon (@$exons) {\n\t$exonset->add_sub_SeqFeature($exon, 'EXPAND');\n    }\n    return $exonset;\n}\n\n=head2 next_feature\n\n  Title   : next_feature\n  Usage   : while($exonset = $spidey->next_feature()) {\n\t    # do something\n\t   }\n  Function: Does the same as L<next_exonset()>. See there for documentation of\n      the functionality. Call this method repeatedly until FALSE is\n      returned.\n\n      The returned object is actually a SeqFeatureI implementing object.\n      This method is required for classes implementing the\n      SeqAnalysisParserI interface, and is merely an alias for \n      next_exonset() at present.\n\n  Example :\n  Returns : A Bio::SeqFeature::Generic object.\n  Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_exonset doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_exonset(@args);\n}\n\n=head2 genomic_dna_length\n\n    Title   : genomic_dna_length\n    Usage   : $spidey->genomic_dna_length();\n    Function: Returns the length of the genomic DNA used in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub genomic_dna_length {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'genomic_dna_length'} = $val;\n    } else {\n\t$val = $self->{'genomic_dna_length'};\n    }\n    return $val;\n}\n\n=head2 splicesites\n\n    Title   : splicesites\n    Usage   : $spidey->splicesites();\n    Function: Returns the number of splice sites found in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub splicesites {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'splicesites'} = $val;\n    } else {\n\t$val = $self->{'splicesites'};\n    }\n    return $val;\n}\n\n=head2 est_coverage\n\n    Title   : est_coverage\n    Usage   : $spidey->est_coverage();\n    Function: Returns the percent of est coverage in this Spidey result\n    Example :\n    Returns : An integer value.\n    Args    :\n\n\nsub est_coverage {\n     my ($self, @args) = @_;\n     my $val;\n     \n     if(@args) {\n\t $val = shift(@args);\n\t $self->{'est_coverage'} = $val;\n     } else {\n\t $val = $self->{'est_coverage'};\n     }\n     return $val;\n }\n\n=head2 overall_percentage_id\n\n    Title   : overall_percentage_id\n    Usage   : $spidey->overall_percentage_id();\n    Function: Returns the overall percent id in this Spidey result\n    Example :\n    Returns : An float value.\n    Args    :\n\n\nsub overall_percentage_id {\n    my ($self, @args) = @_;\n    my $val;\n\n    if(@args) {\n\t$val = shift(@args);\n\t$self->{'overall_percentage_id'} = $val;\n    } else {\n\t$val = $self->{'overall_percentage_id'};\n    }\n    return $val;\n}\n\n=head2 missing_mrna_ends\n\n    Title   : missing_mrna_ends\n    Usage   : $spidey->missing_mrna_ends();\n    Function: Returns left/right/neither from Spidey\n    Example :\n    Returns : A string value.\n    Args    :"},"kind":12,"range":{"start":{"character":0,"line":516},"end":{"line":527,"character":9999}},"line":516,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"missing_mrna_ends","children":[{"line":517,"name":"$self","localvar":"my","kind":13,"containerName":"missing_mrna_ends","definition":"my"},{"line":517,"name":"@args","kind":13,"containerName":"missing_mrna_ends"},{"definition":"my","name":"$val","containerName":"missing_mrna_ends","localvar":"my","kind":13,"line":518},{"name":"@args","kind":13,"containerName":"missing_mrna_ends","line":520},{"name":"$val","containerName":"missing_mrna_ends","kind":13,"line":521},{"name":"@args","containerName":"missing_mrna_ends","kind":13,"line":521},{"containerName":"missing_mrna_ends","kind":13,"name":"$self","line":522},{"name":"$val","containerName":"missing_mrna_ends","kind":13,"line":522},{"name":"$val","kind":13,"containerName":"missing_mrna_ends","line":524},{"containerName":"missing_mrna_ends","kind":13,"name":"$self","line":524},{"kind":13,"containerName":"missing_mrna_ends","name":"$val","line":526}]}]}