{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":109},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"line":111,"range":{"start":{"character":0,"line":111},"end":{"line":128,"character":9999}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":112,"definition":"my"},{"line":112,"name":"@args","kind":13,"containerName":"new"},{"line":113,"name":"%param","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":113},{"line":114,"containerName":"new","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":114},{"name":"@args","containerName":"new","kind":13,"line":114},{"line":116,"kind":13,"localvar":"my","containerName":"new","name":"$prim","definition":"my"},{"line":116,"name":"$prim_tag","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$source","line":116},{"kind":13,"containerName":"new","name":"$source_tag","line":116},{"line":117,"name":"$self","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"_rearrange","line":117},{"name":"@args","kind":13,"containerName":"new","line":121},{"containerName":"new","kind":13,"name":"$self","line":123},{"name":"primary_tag","containerName":"new","kind":12,"line":123},{"kind":13,"containerName":"new","name":"$prim","line":123},{"name":"$prim_tag","containerName":"new","kind":13,"line":123},{"line":124,"name":"$self","containerName":"new","kind":13},{"line":124,"containerName":"new","kind":12,"name":"source_tag"},{"line":124,"name":"$source","kind":13,"containerName":"new"},{"line":124,"containerName":"new","kind":13,"name":"$source_tag"},{"kind":13,"containerName":"new","name":"$self","line":125},{"name":"strand","kind":12,"containerName":"new","line":125},{"name":"$self","containerName":"new","kind":13,"line":125},{"line":125,"kind":12,"containerName":"new","name":"strand"},{"line":126,"name":"$self","containerName":"new","kind":13},{"line":126,"name":"query","containerName":"new","kind":12},{"line":127,"name":"$self","kind":13,"containerName":"new"}],"name":"new","containerName":"main::"},{"line":114,"kind":12,"containerName":"new","name":"SUPER"},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"percentage_id","kind":13,"line":142},{"line":142,"name":"@args","kind":13,"containerName":"percentage_id"},{"definition":"my","line":143,"name":"$frac","kind":13,"localvar":"my","containerName":"percentage_id"},{"localvar":"my","containerName":"percentage_id","kind":13,"name":"$val","line":144,"definition":"my"},{"line":145,"kind":13,"localvar":"my","containerName":"percentage_id","name":"$delegated","definition":"my"},{"kind":13,"containerName":"percentage_id","name":"@args","line":147},{"containerName":"percentage_id","kind":13,"name":"$frac","line":148},{"line":148,"name":"$args","kind":13,"containerName":"percentage_id"},{"line":149,"containerName":"percentage_id","kind":13,"name":"$frac"},{"line":149,"kind":13,"containerName":"percentage_id","name":"$frac"},{"line":151,"name":"$self","kind":13,"containerName":"percentage_id"},{"line":151,"name":"query","containerName":"percentage_id","kind":12},{"line":151,"name":"can","kind":12,"containerName":"percentage_id"},{"line":152,"name":"$frac","containerName":"percentage_id","kind":13},{"kind":13,"containerName":"percentage_id","name":"$self","line":153},{"containerName":"percentage_id","kind":12,"name":"query","line":153},{"line":153,"name":"frac_identical","kind":12,"containerName":"percentage_id"},{"line":153,"containerName":"percentage_id","kind":13,"name":"$frac"},{"name":"$val","containerName":"percentage_id","kind":13,"line":155},{"line":155,"containerName":"percentage_id","kind":13,"name":"$self"},{"kind":12,"containerName":"percentage_id","name":"query","line":155},{"kind":12,"containerName":"percentage_id","name":"frac_identical","line":155},{"name":"$delegated","containerName":"percentage_id","kind":13,"line":156},{"name":"$self","kind":13,"containerName":"percentage_id","line":158},{"line":158,"kind":12,"containerName":"percentage_id","name":"est_hit"},{"line":158,"containerName":"percentage_id","kind":12,"name":"can"},{"line":159,"kind":13,"containerName":"percentage_id","name":"$frac"},{"line":160,"containerName":"percentage_id","kind":13,"name":"$self"},{"line":160,"kind":12,"containerName":"percentage_id","name":"est_hit"},{"line":160,"containerName":"percentage_id","kind":12,"name":"frac_identical"},{"line":160,"kind":13,"containerName":"percentage_id","name":"$frac"},{"line":163,"name":"$val","containerName":"percentage_id","kind":13},{"line":163,"name":"$self","containerName":"percentage_id","kind":13},{"name":"est_hit","kind":12,"containerName":"percentage_id","line":163},{"name":"frac_identical","containerName":"percentage_id","kind":12,"line":163},{"name":"$delegated","containerName":"percentage_id","kind":13,"line":164},{"kind":13,"containerName":"percentage_id","name":"$delegated","line":166},{"line":167,"name":"@args","kind":13,"containerName":"percentage_id"},{"line":168,"name":"$val","containerName":"percentage_id","kind":13},{"containerName":"percentage_id","kind":13,"name":"@args","line":168},{"name":"$self","kind":13,"containerName":"percentage_id","line":169},{"line":169,"name":"$val","containerName":"percentage_id","kind":13},{"containerName":"percentage_id","kind":13,"name":"$val","line":171},{"line":171,"containerName":"percentage_id","kind":13,"name":"$self"},{"name":"$val","kind":13,"containerName":"percentage_id","line":174}],"name":"percentage_id","containerName":"main::","definition":"sub","detail":"($self,@args)","line":141,"kind":12,"range":{"start":{"line":141,"character":0},"end":{"character":9999,"line":175}},"signature":{"label":"percentage_id($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Exon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Sim4::Exon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney-at-sanger.ac.uk>\n# and Hilmar Lapp <hlapp-at-gmx.net>\n#\n# Copyright Ewan Birney, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Sim4::Exon - A single exon determined by an alignment\n\n=head1 SYNOPSIS\n\n  # See Bio::Tools::Sim4::Results for a description of the context.\n\n  # an instance of this class is-a Bio::SeqFeature::SimilarityPair\n\n  # coordinates of the exon (recommended way):\n  print \"exon from \", $exon->start(),\n  \t\" to \", $exon->end(), \"\\n\";\n\n  # the same (feature1() inherited from Bio::SeqFeature::FeaturePair)\n  print \"exon from \", $exon->feature1()->start(),\n  \t\" to \", $exon->feature1()->end(), \"\\n\";\n  # also the same (query() inherited from Bio::SeqFeature::SimilarityPair):\n  print \"exon from \", $exon->query()->start(),\n  \t\" to \", $exon->query()->end(), \"\\n\";\n\n  # coordinates on the matching EST (recommended way):\n  print \"matches on EST from \", $exon->est_hit()->start(),\n  \t\" to \", $exon->est_hit()->end(), \"\\n\";\n\n  # the same (feature2() inherited from Bio::SeqFeature::FeaturePair)\n  print \"matches on EST from \", $exon->feature2()->start(),\n  \t\" to \", $exon->feature2()->end(), \"\\n\";\n  # also the same (subject() inherited from Bio::SeqFeature::SimilarityPair):\n  print \"exon from \", $exon->subject()->start(),\n  \t\" to \", $exon->subject()->end(), \"\\n\";\n\n=head1 DESCRIPTION\n\nThis class inherits from Bio::SeqFeature::SimilarityPair and represents an\nexon on a genomic sequence determined by similarity, that is, by aligning an\nEST sequence (using Sim4 in this case). Consequently, the notion of query and\nsubject is always from the perspective of the genomic sequence: query refers\nto the genomic seq, subject to the aligned EST hit. Because of this,\n$exon-E<gt>start(), $exon-E<gt>end() etc will always return what you expect. \n\nTo get the coordinates on the matching EST, refer to the properties of the\nfeature returned by L<est_hit>().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney, Hilmar Lapp\n\nEwan Birney E<lt>birney-at-sanger.ac.ukE<gt>\nHilmar Lapp E<lt>hlapp-at-gmx.netE<gt> or E<lt>hilmar.lapp-at-pharma.novartis.comE<gt>.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Sim4::Exon;\nuse strict;\n\n\nuse base qw(Bio::SeqFeature::SimilarityPair);\n\nsub new {\n    my ($class,@args) = @_;\n    my %param = @args;\n    my $self = $class->SUPER::new(@args);\n\n    my ($prim, $prim_tag, $source, $source_tag) = \n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      PRIMARY_TAG \n\t\t\t      SOURCE\n\t\t\t      SOURCE_TAG)], \n\t\t\t  @args);\n\n    $self->primary_tag('exon') unless $prim || $prim_tag;\n    $self->source_tag('Sim4') unless $source || $source_tag;\n    $self->strand(0) unless defined($self->strand());\n    $self->query();\n    return $self; \n}\n\n=head2 percentage_id\n\n Title   : percentage_id\n Usage   : $obj->percentage_id($newval)\n Function: This is a synonym for 100 * $obj->est_hit()->frac_identical().\n Returns : value of percentage_id\n Args    : newvalue (optional)"}},{"range":{"start":{"line":190,"character":0},"end":{"character":9999,"line":193}},"kind":12,"line":190,"containerName":"main::","name":"est_hit","children":[{"containerName":"est_hit","localvar":"my","kind":13,"name":"$self","line":191,"definition":"my"},{"name":"$self","kind":13,"containerName":"est_hit","line":192},{"line":192,"name":"feature2","kind":12,"containerName":"est_hit"}],"definition":"sub"}]}