{"vars":[{"containerName":"","kind":2,"name":"base","line":92},{"line":95,"containerName":"File::Spec::File","kind":2,"name":"Path"},{"containerName":"main::","name":"run","children":[{"definition":"my","line":110,"kind":13,"localvar":"my","containerName":"run","name":"$self"},{"line":110,"containerName":"run","kind":13,"name":"@args"},{"line":111,"containerName":"run","kind":13,"name":"$self"},{"line":111,"kind":12,"containerName":"run","name":"throw_not_implemented"}],"detail":"($self,@args)","definition":"sub","range":{"start":{"character":0,"line":109},"end":{"character":9999,"line":112}},"kind":12,"line":109,"signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments","parameters":[{"label":"$self"},{"label":"@args"}],"label":"run($self,@args)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)","label":"error_string($self,$value)"},"range":{"start":{"line":126,"character":0},"end":{"line":132,"character":9999}},"kind":12,"line":126,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"error_string","children":[{"definition":"my","line":127,"name":"$self","containerName":"error_string","localvar":"my","kind":13},{"line":127,"name":"$value","kind":13,"containerName":"error_string"},{"line":128,"name":"$value","kind":13,"containerName":"error_string"},{"kind":13,"containerName":"error_string","name":"$self","line":129},{"line":129,"name":"$value","kind":13,"containerName":"error_string"},{"name":"$self","containerName":"error_string","kind":13,"line":131}]},{"range":{"end":{"line":151,"character":9999},"start":{"line":145,"character":0}},"kind":12,"line":145,"signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"arguments($self,$value)"},"containerName":"main::","name":"arguments","children":[{"line":146,"localvar":"my","containerName":"arguments","kind":13,"name":"$self","definition":"my"},{"containerName":"arguments","kind":13,"name":"$value","line":146},{"containerName":"arguments","kind":13,"name":"$value","line":147},{"line":148,"containerName":"arguments","kind":13,"name":"$self"},{"line":148,"kind":13,"containerName":"arguments","name":"$value"},{"line":150,"name":"$self","containerName":"arguments","kind":13}],"detail":"($self,$value)","definition":"sub"},{"signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"no_param_checks($self,$value)"},"line":166,"range":{"end":{"character":9999,"line":173},"start":{"line":166,"character":0}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"localvar":"my","containerName":"no_param_checks","kind":13,"name":"$self","line":167,"definition":"my"},{"kind":13,"containerName":"no_param_checks","name":"$value","line":167},{"line":168,"containerName":"no_param_checks","kind":13,"name":"$value"},{"name":"$self","kind":13,"containerName":"no_param_checks","line":168},{"name":"$value","containerName":"no_param_checks","kind":13,"line":169},{"line":169,"name":"$value","containerName":"no_param_checks","kind":13},{"containerName":"no_param_checks","kind":13,"name":"$self","line":170},{"kind":13,"containerName":"no_param_checks","name":"$value","line":170},{"line":172,"name":"$self","kind":13,"containerName":"no_param_checks"}],"name":"no_param_checks","containerName":"main::"},{"line":188,"kind":12,"range":{"start":{"character":0,"line":188},"end":{"character":9999,"line":191}},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"save_tempfiles","name":"$self","line":189},{"line":190,"kind":13,"containerName":"save_tempfiles","name":"$self"},{"line":190,"name":"io","containerName":"save_tempfiles","kind":12},{"line":190,"containerName":"save_tempfiles","kind":12,"name":"save_tempfiles"}],"name":"save_tempfiles","containerName":"main::","definition":"sub"},{"signature":{"parameters":[{"label":"$self"},{"label":"$nm"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to","label":"outfile_name($self,$nm)"},"line":205,"kind":12,"range":{"start":{"line":205,"character":0},"end":{"line":212,"character":9999}},"definition":"sub","detail":"($self,$nm)","children":[{"line":206,"containerName":"outfile_name","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":206,"kind":13,"containerName":"outfile_name","name":"$nm"},{"line":207,"containerName":"outfile_name","kind":13,"name":"$nm"},{"kind":13,"containerName":"outfile_name","name":"$self","line":207},{"kind":13,"containerName":"outfile_name","name":"$nm","line":208},{"line":208,"name":"$nm","kind":13,"containerName":"outfile_name"},{"kind":13,"containerName":"outfile_name","name":"$self","line":209},{"line":209,"name":"$nm","kind":13,"containerName":"outfile_name"},{"name":"$self","containerName":"outfile_name","kind":13,"line":211}],"name":"outfile_name","containerName":"main::"},{"name":"tempdir","containerName":"main::","children":[{"definition":"my","line":227,"localvar":"my","kind":13,"containerName":"tempdir","name":"$self"},{"name":"$self","kind":13,"containerName":"tempdir","line":229},{"name":"$self","kind":13,"containerName":"tempdir","line":230},{"containerName":"tempdir","kind":13,"name":"$self","line":231},{"name":"$self","kind":13,"containerName":"tempdir","line":231},{"name":"io","kind":12,"containerName":"tempdir","line":231},{"line":231,"name":"tempdir","kind":12,"containerName":"tempdir"},{"line":231,"name":"$self","kind":13,"containerName":"tempdir"},{"name":"save_tempfiles","containerName":"tempdir","kind":12,"line":231},{"line":233,"kind":13,"containerName":"tempdir","name":"$self"},{"name":"$self","kind":13,"containerName":"tempdir","line":234},{"kind":13,"containerName":"tempdir","name":"$self","line":236}],"definition":"sub","kind":12,"range":{"end":{"line":237,"character":9999},"start":{"line":226,"character":0}},"line":226},{"name":"CLEANUP","kind":12,"line":231},{"definition":"sub","detail":"($self)","children":[{"line":251,"localvar":"my","kind":13,"containerName":"cleanup","name":"$self","definition":"my"},{"line":252,"name":"$self","containerName":"cleanup","kind":13},{"line":252,"containerName":"cleanup","kind":12,"name":"io"},{"name":"_io_cleanup","kind":12,"containerName":"cleanup","line":252},{"line":253,"containerName":"cleanup","kind":13,"name":"$self"},{"containerName":"cleanup","kind":13,"name":"$self","line":253},{"line":254,"localvar":"my","kind":13,"containerName":"cleanup","name":"$verbose","definition":"my"},{"kind":13,"containerName":"cleanup","name":"$self","line":254},{"line":254,"containerName":"cleanup","kind":12,"name":"verbose"},{"line":255,"containerName":"cleanup","kind":13,"name":"$self"},{"containerName":"cleanup","kind":13,"name":"$verbose","line":255}],"containerName":"main::","name":"cleanup","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none","label":"cleanup($self)"},"line":250,"range":{"start":{"character":0,"line":250},"end":{"line":257,"character":9999}},"kind":12},{"line":255,"kind":12,"containerName":"Path::rmtree","name":"File"},{"detail":"($self)","definition":"sub","name":"io","containerName":"main::","children":[{"definition":"my","line":271,"localvar":"my","kind":13,"containerName":"io","name":"$self"},{"line":272,"name":"$self","kind":13,"containerName":"io"},{"name":"$self","containerName":"io","kind":13,"line":273},{"line":273,"containerName":"io","kind":12,"name":"new"},{"name":"$self","containerName":"io","kind":13,"line":273},{"name":"verbose","containerName":"io","kind":12,"line":273},{"line":275,"containerName":"io","kind":13,"name":"$self"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none","label":"io($self)"},"range":{"start":{"line":270,"character":0},"end":{"line":276,"character":9999}},"kind":12,"line":270},{"line":273,"kind":12,"containerName":"Root::IO","name":"Bio"},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":290,"name":"$self","kind":13,"localvar":"my","containerName":"version"},{"containerName":"version","kind":13,"name":"@args","line":290}],"name":"version","containerName":"main::","signature":{"label":"version($self,@args)","documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string","parameters":[{"label":"$self"},{"label":"@args"}]},"line":289,"range":{"start":{"character":0,"line":289},"end":{"line":292,"character":9999}},"kind":12},{"detail":"($self,$exe,$warn)","definition":"sub","name":"executable","containerName":"main::","children":[{"definition":"my","line":306,"containerName":"executable","localvar":"my","kind":13,"name":"$self"},{"name":"$exe","kind":13,"containerName":"executable","line":306},{"line":306,"containerName":"executable","kind":13,"name":"$warn"},{"containerName":"executable","kind":13,"name":"$exe","line":308},{"name":"$self","containerName":"executable","kind":13,"line":309},{"kind":13,"containerName":"executable","name":"$exe","line":309},{"line":312,"name":"$self","containerName":"executable","kind":13},{"definition":"my","line":313,"name":"$prog_path","kind":13,"localvar":"my","containerName":"executable"},{"line":313,"containerName":"executable","kind":13,"name":"$self"},{"name":"program_path","kind":12,"containerName":"executable","line":313},{"containerName":"executable","kind":13,"name":"$prog_path","line":315},{"line":316,"name":"$prog_path","kind":13,"containerName":"executable"},{"containerName":"executable","kind":13,"name":"$prog_path","line":316},{"line":317,"kind":13,"containerName":"executable","name":"$self"},{"line":317,"name":"$prog_path","kind":13,"containerName":"executable"},{"line":319,"name":"$self","kind":13,"containerName":"executable"},{"kind":12,"containerName":"executable","name":"program_dir","line":319},{"kind":13,"containerName":"executable","name":"$self","line":320},{"line":320,"name":"warn","kind":12,"containerName":"executable"},{"name":"$warn","containerName":"executable","kind":13,"line":320},{"line":323,"kind":13,"containerName":"executable","name":"$self"},{"line":324,"localvar":"my","containerName":"executable","kind":13,"name":"$exe","definition":"my"},{"name":"$exe","kind":13,"containerName":"executable","line":325},{"line":325,"name":"$self","containerName":"executable","kind":13},{"line":325,"name":"io","kind":12,"containerName":"executable"},{"line":325,"name":"exists_exe","kind":12,"containerName":"executable"},{"line":325,"kind":13,"containerName":"executable","name":"$self"},{"line":325,"kind":12,"containerName":"executable","name":"program_name"},{"name":"$exe","containerName":"executable","kind":13,"line":325},{"line":326,"name":"$self","kind":13,"containerName":"executable"},{"line":326,"name":"$exe","containerName":"executable","kind":13},{"line":329,"name":"$self","containerName":"executable","kind":13},{"kind":12,"containerName":"executable","name":"warn","line":329},{"kind":13,"containerName":"executable","name":"$self","line":329},{"line":329,"containerName":"executable","kind":12,"name":"program_name"},{"line":329,"kind":13,"containerName":"executable","name":"$warn"},{"kind":13,"containerName":"executable","name":"$self","line":330},{"name":"$self","kind":13,"containerName":"executable","line":334}],"signature":{"label":"executable($self,$exe,$warn)","documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found","parameters":[{"label":"$self"},{"label":"$exe"},{"label":"$warn"}]},"kind":12,"range":{"start":{"character":0,"line":305},"end":{"character":9999,"line":335}},"line":305},{"children":[{"definition":"my","line":348,"name":"$self","containerName":"program_path","localvar":"my","kind":13},{"definition":"my","line":349,"name":"@path","containerName":"program_path","localvar":"my","kind":13},{"line":350,"kind":13,"containerName":"program_path","name":"@path"},{"kind":13,"containerName":"program_path","name":"$self","line":350},{"kind":12,"containerName":"program_path","name":"program_dir","line":350},{"name":"$self","containerName":"program_path","kind":13,"line":350},{"line":350,"kind":12,"containerName":"program_path","name":"program_dir"},{"name":"@path","kind":13,"containerName":"program_path","line":351},{"containerName":"program_path","kind":13,"name":"$self","line":351},{"line":351,"name":"program_name","kind":12,"containerName":"program_path"},{"name":"$self","kind":13,"containerName":"program_path","line":351},{"name":"program_name","kind":12,"containerName":"program_path","line":351},{"name":"catfile","kind":12,"containerName":"program_path","line":352},{"containerName":"program_path","kind":13,"name":"@path","line":352}],"containerName":"main::","name":"program_path","definition":"sub","detail":"($self)","line":347,"range":{"start":{"character":0,"line":347},"end":{"line":353,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exe, $warn) = @_;\n    \n    if (defined $exe) {\n        $self->{'_pathtoexe'} = $exe;\n    }\n    \n    unless( defined $self->{'_pathtoexe'} ) {\n        my $prog_path = $self->program_path;\n        \n        if ($prog_path) {\n            if (-e $prog_path && -x $prog_path) {\n                $self->{'_pathtoexe'} = $prog_path;\n            }\n            elsif ($self->program_dir) {\n                $self->warn(\"executable not found in $prog_path, trying system path...\") if $warn;\n            }\n        }\n        unless ($self->{'_pathtoexe'}) {\n            my $exe;\n            if (($exe = $self->io->exists_exe($self->program_name)) && -x $exe) {\n                $self->{'_pathtoexe'} = $exe;\n            }\n            else {\n                $self->warn(\"Cannot find executable for \".$self->program_name) if $warn;\n                $self->{'_pathtoexe'} = undef;\n            }\n        }\n    }\n    $self->{'_pathtoexe'};\n}\n\n=head2 program_path\n\n Title   : program_path\n Usage   : my $path = $factory->program_path();\n Function: Builds path for executable \n Returns : string representing the full path to the exe\n Args    : none","label":"program_path($self)"}},{"line":352,"kind":12,"containerName":"Spec","name":"File"},{"line":366,"range":{"start":{"line":366,"character":0},"end":{"character":9999,"line":369}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exe, $warn) = @_;\n    \n    if (defined $exe) {\n        $self->{'_pathtoexe'} = $exe;\n    }\n    \n    unless( defined $self->{'_pathtoexe'} ) {\n        my $prog_path = $self->program_path;\n        \n        if ($prog_path) {\n            if (-e $prog_path && -x $prog_path) {\n                $self->{'_pathtoexe'} = $prog_path;\n            }\n            elsif ($self->program_dir) {\n                $self->warn(\"executable not found in $prog_path, trying system path...\") if $warn;\n            }\n        }\n        unless ($self->{'_pathtoexe'}) {\n            my $exe;\n            if (($exe = $self->io->exists_exe($self->program_name)) && -x $exe) {\n                $self->{'_pathtoexe'} = $exe;\n            }\n            else {\n                $self->warn(\"Cannot find executable for \".$self->program_name) if $warn;\n                $self->{'_pathtoexe'} = undef;\n            }\n        }\n    }\n    $self->{'_pathtoexe'};\n}\n\n=head2 program_path\n\n Title   : program_path\n Usage   : my $path = $factory->program_path();\n Function: Builds path for executable \n Returns : string representing the full path to the exe\n Args    : none\n\n\nsub program_path {\n   my ($self) = @_;\n   my @path;\n   push @path, $self->program_dir if $self->program_dir;\n   push @path, $self->program_name.($^O =~ /mswin/i ? '.exe' : '') if $self->program_name;\n   return File::Spec->catfile(@path);\n}\n\n=head2 program_dir\n\n Title   : program_dir\n Usage   : my $dir = $factory->program_dir();\n Function: Abstract get method for dir of program. To be implemented\n           by wrapper.\n Returns : string representing program directory \n Args    : none ","label":"program_dir($self)"},"children":[{"name":"$self","containerName":"program_dir","localvar":"my","kind":13,"line":367,"definition":"my"},{"name":"$self","kind":13,"containerName":"program_dir","line":368},{"line":368,"name":"throw_not_implemented","kind":12,"containerName":"program_dir"}],"name":"program_dir","containerName":"main::","definition":"sub","detail":"($self)"},{"name":"program_name","containerName":"main::","children":[{"definition":"my","line":383,"name":"$self","localvar":"my","kind":13,"containerName":"program_name"},{"line":384,"containerName":"program_name","kind":13,"name":"$self"},{"line":384,"kind":12,"containerName":"program_name","name":"throw_not_implemented"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":382,"character":0},"end":{"character":9999,"line":385}},"line":382,"signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exe, $warn) = @_;\n    \n    if (defined $exe) {\n        $self->{'_pathtoexe'} = $exe;\n    }\n    \n    unless( defined $self->{'_pathtoexe'} ) {\n        my $prog_path = $self->program_path;\n        \n        if ($prog_path) {\n            if (-e $prog_path && -x $prog_path) {\n                $self->{'_pathtoexe'} = $prog_path;\n            }\n            elsif ($self->program_dir) {\n                $self->warn(\"executable not found in $prog_path, trying system path...\") if $warn;\n            }\n        }\n        unless ($self->{'_pathtoexe'}) {\n            my $exe;\n            if (($exe = $self->io->exists_exe($self->program_name)) && -x $exe) {\n                $self->{'_pathtoexe'} = $exe;\n            }\n            else {\n                $self->warn(\"Cannot find executable for \".$self->program_name) if $warn;\n                $self->{'_pathtoexe'} = undef;\n            }\n        }\n    }\n    $self->{'_pathtoexe'};\n}\n\n=head2 program_path\n\n Title   : program_path\n Usage   : my $path = $factory->program_path();\n Function: Builds path for executable \n Returns : string representing the full path to the exe\n Args    : none\n\n\nsub program_path {\n   my ($self) = @_;\n   my @path;\n   push @path, $self->program_dir if $self->program_dir;\n   push @path, $self->program_name.($^O =~ /mswin/i ? '.exe' : '') if $self->program_name;\n   return File::Spec->catfile(@path);\n}\n\n=head2 program_dir\n\n Title   : program_dir\n Usage   : my $dir = $factory->program_dir();\n Function: Abstract get method for dir of program. To be implemented\n           by wrapper.\n Returns : string representing program directory \n Args    : none \n\n\nsub program_dir {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 program_name\n\n Title   : program_name\n Usage   : my $name = $factory->program_name();\n Function: Abstract get method for name of program. To be implemented\n           by wrapper.\n Returns : string representing program name\n Args    : none","parameters":[{"label":"$self"}],"label":"program_name($self)"}},{"definition":"sub","name":"quiet","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"quiet","line":400},{"line":401,"containerName":"quiet","kind":13,"name":"$self"},{"line":402,"kind":13,"containerName":"quiet","name":"$self"}],"kind":12,"range":{"end":{"line":403,"character":9999},"start":{"line":399,"character":0}},"line":399},{"name":"quiet","kind":12,"line":401},{"line":402,"name":"quiet","kind":12},{"line":442,"kind":12,"range":{"end":{"character":9999,"line":458},"start":{"line":442,"character":0}},"signature":{"documentation":"1;\n# $Id: WrapperBase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::WrapperBase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::WrapperBase - A Base object for wrappers around executables\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $errstr = $obj->error_string();\n  my $exe    = $obj->executable();\n  $obj->save_tempfiles($booleanflag)\n  my $outfile= $obj->outfile_name();\n  my $tempdir= $obj->tempdir(); # get a temporary dir for executing\n  my $io     = $obj->io;  # Bio::Root::IO object\n  my $cleanup= $obj->cleanup(); # remove tempfiles\n\n  $obj->run({-arg1 => $value});\n\n=head1 DESCRIPTION\n\nThis is a basic module from which to build executable wrapper modules.\nIt has some basic methods to help when implementing new modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track of\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Run::WrapperBase;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\nuse File::Spec;\nuse File::Path qw(); # don't import anything\n\n=head2 run\n\n Title   : run\n Usage   : $wrapper->run({ARGS HERE});\n Function: Support generic running with args passed in\n           as a hashref\n Returns : Depends on the implementation, status OR data\n Args    : hashref of named arguments\n\n\n\nsub run {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 error_string\n\n Title   : error_string\n Usage   : $obj->error_string($newval)\n Function: Where the output from the last analysis run is stored.\n Returns : value of error_string\n Args    : newvalue (optional)\n\n\n\nsub error_string{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_error_string'} = $value;\n    }\n    return $self->{'_error_string'} || '';\n}\n\n=head2 arguments\n\n Title   : arguments\n Usage   : $obj->arguments($newval)\n Function: Commandline parameters \n Returns : value of arguments\n Args    : newvalue (optional)\n\n\n\nsub arguments {\n  my ($self,$value) = @_;\n  if(defined $value) {\n    $self->{'_arguments'} = $value;\n  }\n  return $self->{'_arguments'} || '';\n}\n\n\n=head2 no_param_checks\n\n Title   : no_param_checks\n Usage   : $obj->no_param_checks($newval)\n Function: Boolean flag as to whether or not we should\n           trust the sanity checks for parameter values\n Returns : value of no_param_checks\n Args    : newvalue (optional)\n\n\n\nsub no_param_checks{\n   my ($self,$value) = @_;\n   if( defined $value || ! defined $self->{'no_param_checks'} ) {\n       $value = 0 unless defined $value;\n      $self->{'no_param_checks'} = $value;\n    }\n    return $self->{'no_param_checks'};\n}\n\n=head2 save_tempfiles\n\n Title   : save_tempfiles\n Usage   : $obj->save_tempfiles($newval)\n Function: Get/set the choice of if tempfiles in the temp dir (see tempdir())\n           are kept or cleaned up. Default is '0', ie. delete temp files.\n           NB:\u00caThis must be set to the desired value PRIOR to first creating\n           a temp dir with tempdir().\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub save_tempfiles{\n    my $self = shift;\n    return $self->io->save_tempfiles(@_);\n}\n\n=head2 outfile_name\n\n Title   : outfile_name\n Usage   : my $outfile = $wrapper->outfile_name();\n Function: Get/Set the name of the output file for this run\n           (if you wanted to do something special)\n Returns : string\n Args    : [optional] string to set value to\n\n\n\nsub outfile_name{\n   my ($self,$nm) = @_;\n   if( defined $nm || ! defined $self->{'_outfilename'} ) { \n       $nm = 'mlc' unless defined $nm;\n       $self->{'_outfilename'} = $nm;\n   }\n   return $self->{'_outfilename'};\n}\n\n\n=head2 tempdir\n\n Title   : tempdir\n Usage   : my $tmpdir = $self->tempdir();\n Function: Retrieve a temporary directory name (which is created)\n Returns : string which is the name of the temporary directory\n Args    : none\n\n\n\nsub tempdir{\n   my ($self) = shift;\n\n   $self->{'_tmpdir'} = shift if @_;\n   unless( $self->{'_tmpdir'} ) {\n       $self->{'_tmpdir'} = $self->io->tempdir(CLEANUP => ! $self->save_tempfiles );\n   }\n   unless( -d $self->{'_tmpdir'} ) {\n       mkdir($self->{'_tmpdir'},0777);\n   }\n   return $self->{'_tmpdir'};\n}\n\n=head2 cleanup\n\n Title   : cleanup\n Usage   : $wrapper->cleanup();\n Function: Will cleanup the tempdir directory\n Returns : none\n Args    : none\n\n\n\nsub cleanup{\n   my ($self) = @_;\n   $self->io->_io_cleanup();\n   if( defined $self->{'_tmpdir'} && -d $self->{'_tmpdir'} ) {\n      my $verbose = ($self->verbose >= 1) ? 1 : 0;\n      File::Path::rmtree( $self->{'_tmpdir'}, $verbose);\n   }\n}\n\n=head2 io\n\n Title   : io\n Usage   : $obj->io($newval)\n Function: Gets a Bio::Root::IO object\n Returns : Bio::Root::IO object\n Args    : none\n\n\n\nsub io{\n   my ($self) = @_;\n   unless( defined $self->{'io'} ) {\n       $self->{'io'} = Bio::Root::IO->new(-verbose => $self->verbose);\n   }\n    return $self->{'io'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version = $wrapper->version()\n Function: Returns the program version (if available)\n Returns : string representing version of the program \n Args    : [Optional] value to (re)set version string\n\n\n\nsub version{\n   my ($self,@args) = @_;\n   return;\n}\n\n=head2 executable\n\n Title   : executable\n Usage   : my $exe = $factory->executable();\n Function: Finds the full path to the executable\n Returns : string representing the full path to the exe\n Args    : [optional] name of executable to set path to\n           [optional] boolean flag whether or not warn when exe is not found\n\n\nsub executable {\n    my ($self, $exe, $warn) = @_;\n    \n    if (defined $exe) {\n        $self->{'_pathtoexe'} = $exe;\n    }\n    \n    unless( defined $self->{'_pathtoexe'} ) {\n        my $prog_path = $self->program_path;\n        \n        if ($prog_path) {\n            if (-e $prog_path && -x $prog_path) {\n                $self->{'_pathtoexe'} = $prog_path;\n            }\n            elsif ($self->program_dir) {\n                $self->warn(\"executable not found in $prog_path, trying system path...\") if $warn;\n            }\n        }\n        unless ($self->{'_pathtoexe'}) {\n            my $exe;\n            if (($exe = $self->io->exists_exe($self->program_name)) && -x $exe) {\n                $self->{'_pathtoexe'} = $exe;\n            }\n            else {\n                $self->warn(\"Cannot find executable for \".$self->program_name) if $warn;\n                $self->{'_pathtoexe'} = undef;\n            }\n        }\n    }\n    $self->{'_pathtoexe'};\n}\n\n=head2 program_path\n\n Title   : program_path\n Usage   : my $path = $factory->program_path();\n Function: Builds path for executable \n Returns : string representing the full path to the exe\n Args    : none\n\n\nsub program_path {\n   my ($self) = @_;\n   my @path;\n   push @path, $self->program_dir if $self->program_dir;\n   push @path, $self->program_name.($^O =~ /mswin/i ? '.exe' : '') if $self->program_name;\n   return File::Spec->catfile(@path);\n}\n\n=head2 program_dir\n\n Title   : program_dir\n Usage   : my $dir = $factory->program_dir();\n Function: Abstract get method for dir of program. To be implemented\n           by wrapper.\n Returns : string representing program directory \n Args    : none \n\n\nsub program_dir {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 program_name\n\n Title   : program_name\n Usage   : my $name = $factory->program_name();\n Function: Abstract get method for name of program. To be implemented\n           by wrapper.\n Returns : string representing program name\n Args    : none\n\n\nsub program_name {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 quiet\n\n Title   : quiet\n Usage   : $factory->quiet(1);\n           if ($factory->quiet()) { ... }\n Function: Get/set the quiet state. Can be used by wrappers to control if\n           program output is printed to the console or not.\n Returns : boolean\n Args    : none to get, boolean to set\n\n\nsub quiet {\n    my $self = shift;\n    if (@_) { $self->{quiet} = shift }\n    return $self->{quiet} || 0;\n}\n\n=head2  _setparams()\n\n Title   : _setparams\n Usage   : $params = $self->_setparams(-params => [qw(window evalue_cutoff)])\n Function: For internal use by wrapper modules to build parameter strings\n           suitable for sending to the program being wrapped. For each method\n           name supplied, calls the method and adds the method name (as modified\n           by optional things) along with its value (unless a switch) to the\n           parameter string\n Example : $params = $self->_setparams(-params => [qw(window evalue_cutoff)],\n                                       -switches => [qw(simple large all)],\n                                       -double_dash => 1,\n                                       -underscore_to_dash => 1);\n           If window() and simple() had not been previously called, but\n           evalue_cutoff(0.5), large(1) and all(0) had been called, $params\n           would be ' --evalue-cutoff 0.5 --large'\n Returns : parameter string\n Args    : -params => [] or {}  # array ref of method names to call,\n                                  or hash ref where keys are method names and\n                                  values are how those names should be output\n                                  in the params string\n           -switches => [] or {}# as for -params, but no value is printed for\n                                  these methods\n           -join => string      # define how parameters and their values are\n                                  joined, default ' '. (eg. could be '=' for\n                                  param=value)\n           -lc => boolean       # lc() method names prior to output in string\n           -dash => boolean     # prefix all method names with a single dash\n           -double_dash => bool # prefix all method names with a double dash\n           -mixed_dash => bool  # prefix single-character method names with a\n                                # single dash, and multi-character method names\n                                # with a double-dash\n           -underscore_to_dash => boolean # convert all underscores in method\n                                            names to dashes","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_setparams($self,@args)"},"children":[{"line":443,"localvar":"my","containerName":"_setparams","kind":13,"name":"$self","definition":"my"},{"line":443,"name":"@args","kind":13,"containerName":"_setparams"},{"definition":"my","line":445,"name":"$params","localvar":"my","containerName":"_setparams","kind":13},{"kind":13,"containerName":"_setparams","name":"$switches","line":445},{"line":445,"kind":13,"containerName":"_setparams","name":"$join"},{"line":445,"kind":13,"containerName":"_setparams","name":"$lc"},{"line":445,"kind":13,"containerName":"_setparams","name":"$d"},{"line":445,"kind":13,"containerName":"_setparams","name":"$dd"},{"line":445,"kind":13,"containerName":"_setparams","name":"$md"},{"name":"$utd","kind":13,"containerName":"_setparams","line":445},{"name":"$self","kind":13,"containerName":"_setparams","line":446},{"name":"_rearrange","kind":12,"containerName":"_setparams","line":446},{"name":"@args","kind":13,"containerName":"_setparams","line":453},{"line":454,"kind":13,"containerName":"_setparams","name":"$self"},{"name":"throw","containerName":"_setparams","kind":12,"line":454},{"line":454,"name":"$params","containerName":"_setparams","kind":13},{"line":454,"name":"$switches","containerName":"_setparams","kind":13},{"line":455,"name":"$self","kind":13,"containerName":"_setparams"},{"line":455,"containerName":"_setparams","kind":12,"name":"throw"},{"line":455,"kind":13,"containerName":"_setparams","name":"$d"},{"line":455,"name":"$dd","kind":13,"containerName":"_setparams"},{"name":"$md","kind":13,"containerName":"_setparams","line":455},{"name":"$join","containerName":"_setparams","kind":13,"line":456},{"definition":"my","line":458,"localvar":"my","containerName":"_setparams","kind":13,"name":"%params"},{"containerName":"_setparams","kind":13,"name":"$params","line":458},{"kind":13,"containerName":"_setparams","name":"$params","line":458}],"containerName":"main::","name":"_setparams","definition":"sub","detail":"($self,@args)"},{"line":458,"containerName":null,"kind":13,"name":"$params"},{"definition":"my","line":459,"name":"%switches","localvar":"my","containerName":null,"kind":13},{"name":"$switches","kind":13,"containerName":null,"line":459},{"name":"%switches","containerName":null,"kind":13,"line":459},{"name":"$switches","containerName":null,"kind":13,"line":459},{"definition":"my","name":"$param_string","kind":13,"localvar":"my","containerName":null,"line":461},{"name":"$hash_ref","kind":13,"localvar":"my","containerName":null,"line":462,"definition":"my"},{"kind":13,"containerName":null,"name":"%params","line":462},{"line":462,"name":"%switches","kind":13,"containerName":null},{"line":463,"localvar":"my","kind":13,"containerName":null,"name":"$method","definition":"my"},{"line":463,"name":"$method_out","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%hash_ref","line":463},{"definition":"my","line":464,"name":"$value","localvar":"my","containerName":null,"kind":13},{"line":464,"containerName":null,"kind":13,"name":"$self"},{"kind":13,"containerName":null,"name":"$method","line":464},{"line":465,"kind":13,"containerName":null,"name":"$value"},{"kind":13,"containerName":null,"name":"%switches","line":466},{"line":466,"kind":13,"containerName":null,"name":"$method"},{"line":466,"name":"$value","containerName":null,"kind":13},{"line":468,"name":"$method_out","containerName":null,"kind":13},{"line":468,"containerName":null,"kind":13,"name":"$method_out"},{"containerName":null,"kind":13,"name":"$lc","line":468},{"localvar":"my","containerName":null,"kind":13,"name":"$method_length","line":469,"definition":"my"},{"line":469,"name":"$method_out","kind":13,"containerName":null},{"line":469,"containerName":null,"kind":13,"name":"$md"},{"name":"$method_out","containerName":null,"kind":13,"line":470},{"name":"$method_out","kind":13,"containerName":null,"line":470},{"line":470,"containerName":null,"kind":13,"name":"$d"},{"name":"$md","containerName":null,"kind":13,"line":470},{"line":470,"kind":13,"containerName":null,"name":"$method_length"},{"containerName":null,"kind":13,"name":"$method_out","line":471},{"kind":13,"containerName":null,"name":"$method_out","line":471},{"name":"$dd","containerName":null,"kind":13,"line":471},{"line":471,"name":"$md","containerName":null,"kind":13},{"line":471,"kind":13,"containerName":null,"name":"$method_length"},{"line":472,"name":"$method_out","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$utd","line":472},{"name":"%params","kind":13,"containerName":null,"line":475},{"line":475,"name":"$method","kind":13,"containerName":null},{"line":475,"kind":13,"containerName":null,"name":"%value"},{"name":"$value","kind":13,"containerName":null,"line":476},{"kind":13,"containerName":null,"name":"$value","line":476},{"kind":13,"containerName":null,"name":"$param_string","line":479},{"line":479,"name":"$method_out","kind":13,"containerName":null},{"line":479,"kind":13,"containerName":null,"name":"%switches"},{"name":"$method","containerName":null,"kind":13,"line":479},{"name":"$join","containerName":null,"kind":13,"line":479},{"line":479,"containerName":null,"kind":13,"name":"$value"},{"name":"$param_string","kind":13,"containerName":null,"line":483},{"definition":"sub","name":"DESTROY","containerName":"main::","children":[{"definition":"my","line":487,"kind":13,"localvar":"my","containerName":"DESTROY","name":"$self"},{"line":488,"name":"$self","containerName":"DESTROY","kind":13},{"name":"save_tempfiles","containerName":"DESTROY","kind":12,"line":488},{"line":489,"containerName":"DESTROY","kind":13,"name":"$self"},{"line":489,"name":"cleanup","containerName":"DESTROY","kind":12},{"kind":13,"containerName":"DESTROY","name":"$self","line":491}],"range":{"end":{"character":9999,"line":492},"start":{"character":0,"line":486}},"kind":12,"line":486},{"line":491,"containerName":"DESTROY","kind":12,"name":"SUPER"}],"version":5}