{"vars":[{"kind":2,"containerName":"","name":"base","line":123},{"containerName":"main::","name":"new","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$class","line":137},{"kind":13,"containerName":"new","name":"@args","line":137},{"line":139,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":139},{"kind":13,"containerName":"new","name":"@args","line":139},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$trees","line":140},{"kind":13,"containerName":"new","name":"$smat","line":140},{"line":140,"containerName":"new","kind":13,"name":"$freq"},{"name":"$model","containerName":"new","kind":13,"line":141},{"name":"$sspace","containerName":"new","kind":13,"line":141},{"name":"$self","containerName":"new","kind":13,"line":142},{"line":142,"containerName":"new","kind":12,"name":"_rearrange"},{"line":144,"name":"@args","containerName":"new","kind":13},{"line":146,"name":"$trees","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$trees","line":147},{"line":148,"containerName":"new","kind":13,"name":"$self"},{"line":148,"name":"warn","containerName":"new","kind":12},{"line":150,"localvar":"my","containerName":"new","kind":13,"name":"$t","definition":"my"},{"line":150,"containerName":"new","kind":13,"name":"$trees"},{"kind":13,"containerName":"new","name":"$self","line":151},{"line":151,"kind":12,"containerName":"new","name":"add_tree"},{"name":"$t","containerName":"new","kind":13,"line":151},{"name":"$smat","containerName":"new","kind":13,"line":157},{"name":"$self","kind":13,"containerName":"new","line":158},{"line":158,"kind":12,"containerName":"new","name":"substitution_matrix"},{"line":158,"name":"$smat","containerName":"new","kind":13},{"name":"$freq","kind":13,"containerName":"new","line":160},{"name":"$self","containerName":"new","kind":13,"line":161},{"line":161,"name":"residue_frequencies","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$freq","line":161},{"name":"$model","containerName":"new","kind":13,"line":164},{"containerName":"new","kind":13,"name":"$self","line":164},{"line":164,"containerName":"new","kind":12,"name":"model"},{"line":164,"name":"$model","kind":13,"containerName":"new"},{"line":165,"name":"$sspace","kind":13,"containerName":"new"},{"line":165,"name":"$self","kind":13,"containerName":"new"},{"line":165,"kind":12,"containerName":"new","name":"search_space"},{"containerName":"new","kind":13,"name":"$sspace","line":165},{"containerName":"new","kind":13,"name":"$self","line":166},{"line":168,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub","range":{"end":{"character":9999,"line":169},"start":{"character":0,"line":136}},"kind":12,"line":136,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : ","parameters":[{"label":"$class"},{"label":"@args"}]}},{"line":139,"name":"SUPER","kind":12,"containerName":"new"},{"line":182,"kind":12,"range":{"end":{"character":9999,"line":189},"start":{"line":182,"character":0}},"signature":{"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"model($self,$value)"},"children":[{"definition":"my","line":183,"name":"$self","localvar":"my","kind":13,"containerName":"model"},{"kind":13,"containerName":"model","name":"$value","line":183},{"kind":13,"containerName":"model","name":"$value","line":184},{"kind":13,"containerName":"model","name":"$self","line":185},{"kind":13,"containerName":"model","name":"$value","line":185},{"containerName":"model","kind":13,"name":"$self","line":187}],"name":"model","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","line":205,"containerName":"substitution_matrix","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"substitution_matrix","name":"$val","line":205},{"name":"$val","kind":13,"containerName":"substitution_matrix","line":206},{"line":207,"name":"$val","containerName":"substitution_matrix","kind":13},{"line":208,"containerName":"substitution_matrix","localvar":"my","kind":13,"name":"$v","definition":"my"},{"line":208,"kind":13,"containerName":"substitution_matrix","name":"$val"},{"line":209,"containerName":"substitution_matrix","kind":13,"name":"$v"},{"name":"$self","containerName":"substitution_matrix","kind":13,"line":210},{"kind":12,"containerName":"substitution_matrix","name":"warn","line":210},{"line":214,"containerName":"substitution_matrix","kind":13,"name":"$self"},{"line":214,"containerName":"substitution_matrix","kind":13,"name":"$val"},{"containerName":"substitution_matrix","kind":13,"name":"$self","line":216},{"containerName":"substitution_matrix","kind":12,"name":"warn","line":216}],"name":"substitution_matrix","containerName":"main::","signature":{"label":"substitution_matrix($self,$val)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none","parameters":[{"label":"$self"},{"label":"$val"}]},"line":204,"kind":12,"range":{"start":{"character":0,"line":204},"end":{"character":9999,"line":219}}},{"containerName":null,"kind":13,"name":"%self","line":220},{"children":[{"line":236,"localvar":"my","kind":13,"containerName":"transition_probability_matrix","name":"$self","definition":"my"},{"line":236,"containerName":"transition_probability_matrix","kind":13,"name":"$type"},{"line":236,"containerName":"transition_probability_matrix","kind":13,"name":"$val"},{"line":237,"kind":13,"containerName":"transition_probability_matrix","name":"$type"},{"kind":13,"containerName":"transition_probability_matrix","name":"$type","line":237},{"line":238,"name":"$val","kind":13,"containerName":"transition_probability_matrix"},{"line":239,"name":"$val","containerName":"transition_probability_matrix","kind":13},{"line":240,"name":"$v","containerName":"transition_probability_matrix","localvar":"my","kind":13,"definition":"my"},{"line":240,"containerName":"transition_probability_matrix","kind":13,"name":"$val"},{"line":241,"containerName":"transition_probability_matrix","kind":13,"name":"$v"},{"containerName":"transition_probability_matrix","kind":13,"name":"$self","line":242},{"line":242,"kind":12,"containerName":"transition_probability_matrix","name":"warn"},{"line":246,"name":"$self","kind":13,"containerName":"transition_probability_matrix"},{"containerName":"transition_probability_matrix","kind":13,"name":"$type","line":246},{"name":"$val","containerName":"transition_probability_matrix","kind":13,"line":246},{"line":248,"kind":13,"containerName":"transition_probability_matrix","name":"$self"},{"name":"warn","containerName":"transition_probability_matrix","kind":12,"line":248}],"name":"transition_probability_matrix","containerName":"main::","definition":"sub","detail":"($self,$type,$val)","line":235,"range":{"start":{"line":235,"character":0},"end":{"character":9999,"line":251}},"kind":12,"signature":{"label":"transition_probability_matrix($self,$type,$val)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$val"}]}},{"name":"%self","kind":13,"containerName":null,"line":255},{"line":255,"name":"$type","kind":13,"containerName":null},{"detail":"($self,$val)","definition":"sub","name":"residue_frequencies","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"residue_frequencies","kind":13,"line":277,"definition":"my"},{"line":277,"containerName":"residue_frequencies","kind":13,"name":"$val"},{"line":278,"name":"$val","kind":13,"containerName":"residue_frequencies"},{"containerName":"residue_frequencies","kind":13,"name":"$val","line":279},{"line":280,"kind":13,"containerName":"residue_frequencies","name":"$self"},{"line":280,"kind":13,"containerName":"residue_frequencies","name":"$val"},{"line":282,"kind":13,"containerName":"residue_frequencies","name":"$self"},{"kind":12,"containerName":"residue_frequencies","name":"warn","line":282},{"line":285,"kind":13,"containerName":"residue_frequencies","name":"$self"}],"signature":{"label":"residue_frequencies($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'\n\n\n\nsub transition_probability_matrix {\n   my ($self,$type,$val) = @_;\n   $type = '1PAM-1.0e7' unless defined $type;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probability_matrix\");\n\t\t   return;\n\t       }\n\t   } \n\t   $self->{'_TPM'}->{$type} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probablity_matrix\");\n\t   return;\n       }\n   }\n\n   # fix this for nucml where there are 2 values (one is just a transformation\n   # of the either, but how to represent?)\n   return $self->{'_TPM'}->{$type};\n}\n\n=head2 residue_frequencies\n\n Title   : residue_frequencies\n Usage   : my %data = $molphy->residue_frequencies()\n Function: Get the modeled and expected frequencies for\n           each of the residues in the sequence\n Returns : hash of either aa (protml) or nt (nucml) frequencies\n           each key will point to an array reference where\n           1st slot is model's expected frequency\n           2nd slot is observed frequency in the data\n           $hash{'A'}->[0] = \n Args    : none\n\n\n'"},"range":{"start":{"character":0,"line":276},"end":{"line":285,"character":9999}},"kind":12,"line":276},{"name":"next_tree","containerName":"main::","children":[{"definition":"my","line":299,"containerName":"next_tree","localvar":"my","kind":13,"name":"$self"},{"name":"@args","kind":13,"containerName":"next_tree","line":299},{"line":300,"name":"$self","kind":13,"containerName":"next_tree"},{"name":"$self","kind":13,"containerName":"next_tree","line":300}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"line":298,"character":0},"end":{"line":301,"character":9999}},"line":298,"signature":{"label":"next_tree($self,@args)","documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'\n\n\n\nsub transition_probability_matrix {\n   my ($self,$type,$val) = @_;\n   $type = '1PAM-1.0e7' unless defined $type;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probability_matrix\");\n\t\t   return;\n\t       }\n\t   } \n\t   $self->{'_TPM'}->{$type} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probablity_matrix\");\n\t   return;\n       }\n   }\n\n   # fix this for nucml where there are 2 values (one is just a transformation\n   # of the either, but how to represent?)\n   return $self->{'_TPM'}->{$type};\n}\n\n=head2 residue_frequencies\n\n Title   : residue_frequencies\n Usage   : my %data = $molphy->residue_frequencies()\n Function: Get the modeled and expected frequencies for\n           each of the residues in the sequence\n Returns : hash of either aa (protml) or nt (nucml) frequencies\n           each key will point to an array reference where\n           1st slot is model's expected frequency\n           2nd slot is observed frequency in the data\n           $hash{'A'}->[0] = \n Args    : none\n\n\n\n#'\n\nsub residue_frequencies {\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   $self->{'_residue_frequencies'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for residue_frequencies\");\n       }\n   }\n   return %{$self->{'_residue_frequencies'}};\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree;\n Function: Get the next tree from the factory\n Returns : L<Bio::Tree::TreeI>\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]}},{"children":[],"name":"rewind_tree_iterator","containerName":"main::","definition":"sub","line":314,"range":{"end":{"line":316,"character":9999},"start":{"line":314,"character":0}},"kind":12},{"detail":"($self,$tree)","definition":"sub","containerName":"main::","name":"add_tree","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"add_tree","name":"$self","line":329},{"containerName":"add_tree","kind":13,"name":"$tree","line":329},{"name":"$tree","containerName":"add_tree","kind":13,"line":330},{"kind":13,"containerName":"add_tree","name":"$tree","line":330},{"containerName":"add_tree","kind":13,"name":"$tree","line":330},{"line":330,"containerName":"add_tree","kind":12,"name":"isa"},{"line":331,"name":"$self","kind":13,"containerName":"add_tree"},{"name":"$tree","kind":13,"containerName":"add_tree","line":331}],"signature":{"parameters":[{"label":"$self"},{"label":"$tree"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'\n\n\n\nsub transition_probability_matrix {\n   my ($self,$type,$val) = @_;\n   $type = '1PAM-1.0e7' unless defined $type;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probability_matrix\");\n\t\t   return;\n\t       }\n\t   } \n\t   $self->{'_TPM'}->{$type} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probablity_matrix\");\n\t   return;\n       }\n   }\n\n   # fix this for nucml where there are 2 values (one is just a transformation\n   # of the either, but how to represent?)\n   return $self->{'_TPM'}->{$type};\n}\n\n=head2 residue_frequencies\n\n Title   : residue_frequencies\n Usage   : my %data = $molphy->residue_frequencies()\n Function: Get the modeled and expected frequencies for\n           each of the residues in the sequence\n Returns : hash of either aa (protml) or nt (nucml) frequencies\n           each key will point to an array reference where\n           1st slot is model's expected frequency\n           2nd slot is observed frequency in the data\n           $hash{'A'}->[0] = \n Args    : none\n\n\n\n#'\n\nsub residue_frequencies {\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   $self->{'_residue_frequencies'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for residue_frequencies\");\n       }\n   }\n   return %{$self->{'_residue_frequencies'}};\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree;\n Function: Get the next tree from the factory\n Returns : L<Bio::Tree::TreeI>\n Args    : none\n\n\nsub next_tree{\n   my ($self,@args) = @_;\n   return $self->{'_trees'}->[$self->{'_treeiterator'}++] || undef;\n}\n\n=head2 rewind_tree\n\n Title   : rewind_tree_iterator\n Usage   : $result->rewind_tree()\n Function: Rewinds the tree iterator so that next_tree can be \n           called again from the beginning\n Returns : none\n Args    : none\n\n\nsub rewind_tree_iterator {\n    shift->{'_treeiterator'} = 0;\n}\n\n=head2 add_tree\n\n Title   : add_tree\n Usage   : $result->add_tree($tree);\n Function: Adds a tree \n Returns : integer which is the number of trees stored\n Args    : L<Bio::Tree::TreeI>","label":"add_tree($self,$tree)"},"range":{"end":{"line":332,"character":9999},"start":{"line":328,"character":0}},"kind":12,"line":328},{"kind":13,"containerName":null,"name":"%self","line":333},{"signature":{"label":"search_space($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Result.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy::Result\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy::Result - container for data parsed from a ProtML run\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, you will get it back as part of a \n  # Molphy parser\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];\n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n\n=head1 DESCRIPTION\n\nA container for data parsed from a ProtML run.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy::Result;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy::Result->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy::Result object \n Returns : Bio::Tools::Phylo::Molphy::Result\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($trees,$smat,$freq,\n      $model, $sspace,\n      ) = $self->_rearrange([qw(TREES SUBSTITUTION_MATRIX\n\t\t\t\tFREQUENCIES\n\t\t\t\tMODEL SEARCH_SPACE)], @args);\n\n  if( $trees ) {\n      if(ref($trees) !~ /ARRAY/i ) { \n\t  $self->warn(\"Must provide a valid array reference to initialize trees\");\n      } else {\n\t  foreach my $t ( @$trees ) {\n\t      $self->add_tree($t);\n\t  }\n      }\n  }\n  # initialize things through object methods to be a good \n  # little OO programmer\n  if( ref($smat) =~ /HASH/i ) {\n      $self->substitution_matrix($smat);\n  }\n  if( ref($freq) =~ /HASH/i ) {\n      $self->residue_frequencies($freq);\n  }\n  \n  $model && $self->model($model); \n  $sspace && $self->search_space($sspace);\n  $self->{'_treeiterator'} = 0;\n\n  return $self;\n}\n\n=head2 model\n\n Title   : model\n Usage   : $obj->model($newval)\n Function: \n Returns : value of model\n Args    : newvalue (optional)\n\n\n\nsub model{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'model'} = $value;\n    }\n    return $self->{'model'};\n\n}\n\n=head2 substitution_matrix\n\n Title   : substitution_matrix\n Usage   : my $smat = $result->subsitution_matrix;\n Function: Get the relative substitution matrix calculated in the ML procedure\n Returns : reference to hash of hashes where key is the aa/nt name and value\n           is another hash ref which contains keys for all the aa/nt \n           possibilities\n Args    : none\n\n\n\nsub substitution_matrix{\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t\t   return;\n\t       }\n\t   }\n\t   $self->{'_substitution_matrix'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for substition_matrix\");\n\t   return;\n       }\n   }\n   return $self->{'_substitution_matrix'};\n}\n\n=head2 transition_probability_matrix\n\n Title   : transition_probability_matrix\n Usage   : my $matrixref = $molphy->transition_probablity_matrix();\n Function: Gets the observed transition probability matrix\n Returns : hash of hashes of aa/nt transition to each other aa/nt \n Args    : Transition matrix type, typically\n           '1PAM-1.0e05' or '1PAM-1.0e07'\n\n\n\nsub transition_probability_matrix {\n   my ($self,$type,$val) = @_;\n   $type = '1PAM-1.0e7' unless defined $type;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   foreach my $v (values %{$val} ) {\n\t       if( ref($v) !~ /HASH/i ) { \n\t\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probability_matrix\");\n\t\t   return;\n\t       }\n\t   } \n\t   $self->{'_TPM'}->{$type} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for transition_probablity_matrix\");\n\t   return;\n       }\n   }\n\n   # fix this for nucml where there are 2 values (one is just a transformation\n   # of the either, but how to represent?)\n   return $self->{'_TPM'}->{$type};\n}\n\n=head2 residue_frequencies\n\n Title   : residue_frequencies\n Usage   : my %data = $molphy->residue_frequencies()\n Function: Get the modeled and expected frequencies for\n           each of the residues in the sequence\n Returns : hash of either aa (protml) or nt (nucml) frequencies\n           each key will point to an array reference where\n           1st slot is model's expected frequency\n           2nd slot is observed frequency in the data\n           $hash{'A'}->[0] = \n Args    : none\n\n\n\n#'\n\nsub residue_frequencies {\n   my ($self,$val) = @_;\n   if(defined $val ) { \n       if( ref($val) =~ /HASH/ ) {\n\t   $self->{'_residue_frequencies'} = $val;\n       } else { \n\t   $self->warn(\"Must be a valid hashref of hashrefs for residue_frequencies\");\n       }\n   }\n   return %{$self->{'_residue_frequencies'}};\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree;\n Function: Get the next tree from the factory\n Returns : L<Bio::Tree::TreeI>\n Args    : none\n\n\nsub next_tree{\n   my ($self,@args) = @_;\n   return $self->{'_trees'}->[$self->{'_treeiterator'}++] || undef;\n}\n\n=head2 rewind_tree\n\n Title   : rewind_tree_iterator\n Usage   : $result->rewind_tree()\n Function: Rewinds the tree iterator so that next_tree can be \n           called again from the beginning\n Returns : none\n Args    : none\n\n\nsub rewind_tree_iterator {\n    shift->{'_treeiterator'} = 0;\n}\n\n=head2 add_tree\n\n Title   : add_tree\n Usage   : $result->add_tree($tree);\n Function: Adds a tree \n Returns : integer which is the number of trees stored\n Args    : L<Bio::Tree::TreeI>\n\n\nsub add_tree{\n   my ($self,$tree) = @_;\n   if( $tree && ref($tree) && $tree->isa('Bio::Tree::TreeI') ) {\n       push @{$self->{'_trees'}},$tree;\n   }\n   return scalar @{$self->{'_trees'}};\n}\n\n=head2 search_space\n\n Title   : search_space\n Usage   : $obj->search_space($newval)\n Function: \n Returns : value of search_space\n Args    : newvalue (optional)"},"line":347,"range":{"start":{"character":0,"line":347},"end":{"character":9999,"line":353}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"line":348,"localvar":"my","containerName":"search_space","kind":13,"name":"$self","definition":"my"},{"line":348,"name":"$value","containerName":"search_space","kind":13},{"name":"$value","containerName":"search_space","kind":13,"line":349},{"name":"$self","kind":13,"containerName":"search_space","line":350},{"line":350,"containerName":"search_space","kind":13,"name":"$value"},{"line":352,"name":"$self","kind":13,"containerName":"search_space"}],"name":"search_space","containerName":"main::"}],"version":5}