{"vars":[{"line":119,"kind":2,"containerName":"","name":"base"},{"range":{"start":{"line":132,"character":0},"end":{"character":9999,"line":139}},"kind":12,"line":132,"signature":{"documentation":"1;\n# $Id: Molphy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy - parser for Molphy output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];     \n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n=head1 DESCRIPTION\n\nA parser for Molphy output (protml,dnaml)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy;\nuse strict;\n\nuse Bio::Tools::Phylo::Molphy::Result;\nuse Bio::TreeIO;\nuse IO::String;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy object \n Returns : Bio::Tools::Phylo::Molphy\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":133,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"line":133,"name":"@args","containerName":"new","kind":13},{"line":135,"name":"$self","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":135,"name":"$class","kind":13,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":135},{"line":136,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"_initialize_io","line":136},{"line":136,"name":"@args","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":138}],"detail":"($class,@args)","definition":"sub"},{"line":135,"name":"SUPER","kind":12,"containerName":"new"},{"signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Molphy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::Molphy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::Molphy - parser for Molphy output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Molphy;\n  my $parser = Bio::Tools::Phylo::Molphy->new(-file => 'output.protml');\n  while( my $r = $parser->next_result ) {\n    # r is a Bio::Tools::Phylo::Molphy::Result object\n\n    # print the model name\n    print $r->model, \"\\n\";\n\n    # get the substitution matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # substitution rate\n    my $smat = $r->substitution_matrix;\n    print \"Arg -> Gln substitution rate is %d\\n\", \n          $smat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the transition probablity matrix\n    # this is a hash of 3letter aa codes -> 3letter aa codes representing\n    # transition probabilty\n    my $tmat = $r->transition_probability_matrix;\n    print \"Arg -> Gln transition probablity is %.2f\\n\", \n          $tmat->{'Arg'}->{'Gln'}, \"\\n\";\n\n    # get the frequency for each of the residues\n    my $rfreqs = $r->residue_frequencies;\n\n    foreach my $residue ( keys %{$rfreqs} ) {\n       printf \"residue %s  expected freq: %.2f observed freq: %.2f\\n\",\n              $residue,$rfreqs->{$residue}->[0], $rfreqs->{$residue}->[1];     \n    }\n\n    my @trees;\n    while( my $t = $r->next_tree ) {\n        push @trees, $t;\n    }\n\n    print \"search space is \", $r->search_space, \"\\n\",\n          \"1st tree score is \", $trees[0]->score, \"\\n\";\n\n    # writing to STDOUT, use -file => '>filename' to specify a file\n    my $out = Bio::TreeIO->new(-format => \"newick\");\n    $out->write_tree($trees[0]); # writing only the 1st tree\n  }\n\n=head1 DESCRIPTION\n\nA parser for Molphy output (protml,dnaml)\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::Molphy;\nuse strict;\n\nuse Bio::Tools::Phylo::Molphy::Result;\nuse Bio::TreeIO;\nuse IO::String;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::Molphy->new();\n Function: Builds a new Bio::Tools::Phylo::Molphy object \n Returns : Bio::Tools::Phylo::Molphy\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $r = $molphy->next_result\n Function: Get the next result set from parser data\n Returns : Bio::Tools::Phylo::Molphy::Result object\n Args    : none","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":269},"start":{"character":0,"line":152}},"kind":12,"line":152,"detail":"($self)","definition":"sub","name":"next_result","containerName":"main::","children":[{"definition":"my","line":153,"name":"$self","kind":13,"localvar":"my","containerName":"next_result"},{"name":"$state","localvar":"my","containerName":"next_result","kind":13,"line":156,"definition":"my"},{"line":156,"name":"$transition_ct","kind":13,"containerName":"next_result"},{"line":157,"containerName":"next_result","kind":13,"name":"@transition_matrix"},{"name":"%transition_mat","kind":13,"containerName":"next_result","line":157},{"containerName":"next_result","kind":13,"name":"@resloc","line":157},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"%subst_matrix","line":158},{"kind":13,"containerName":"next_result","name":"@treelines","line":158},{"name":"@treedata","containerName":"next_result","kind":13,"line":158},{"line":158,"name":"%frequencies","containerName":"next_result","kind":13},{"name":"$treenum","containerName":"next_result","localvar":"my","kind":13,"line":159,"definition":"my"},{"line":159,"kind":13,"containerName":"next_result","name":"$possible_trees"},{"kind":13,"containerName":"next_result","name":"$model","line":159},{"definition":"my","line":160,"name":"$trans_type","localvar":"my","kind":13,"containerName":"next_result"},{"line":160,"containerName":"next_result","kind":13,"name":"$trans_amount"},{"definition":"my","containerName":"next_result","localvar":"my","kind":13,"name":"$parsed","line":161},{"line":162,"name":"$self","kind":13,"containerName":"next_result"},{"line":162,"containerName":"next_result","kind":12,"name":"_readline"},{"name":"$parsed","containerName":"next_result","kind":13,"line":163},{"line":165,"kind":13,"containerName":"next_result","name":"%subst_matrix"},{"line":166,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"_pushback","line":166},{"name":"$state","kind":13,"containerName":"next_result","line":169},{"line":170,"name":"@tempdata","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"line":171,"containerName":"next_result","kind":13,"name":"@resloc"},{"line":172,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"_readline","line":172},{"kind":13,"localvar":"my","containerName":"next_result","name":"@data","line":177,"definition":"my"},{"definition":"my","line":178,"name":"$i","localvar":"my","containerName":"next_result","kind":13},{"name":"$l","localvar":"my","containerName":"next_result","kind":13,"line":179,"definition":"my"},{"kind":13,"containerName":"next_result","name":"@data","line":179},{"name":"$l","containerName":"next_result","kind":13,"line":180},{"line":181,"kind":13,"containerName":"next_result","name":"@resloc"},{"line":181,"name":"$l","containerName":"next_result","kind":13},{"line":183,"name":"$i","kind":13,"containerName":"next_result"},{"line":185,"name":"@tempdata","containerName":"next_result","kind":13},{"line":185,"name":"@data","containerName":"next_result","kind":13},{"name":"$i","containerName":"next_result","localvar":"my","kind":13,"line":187,"definition":"my"},{"line":188,"containerName":"next_result","localvar":"my","kind":13,"name":"$row","definition":"my"},{"containerName":"next_result","kind":13,"name":"@tempdata","line":188},{"line":189,"name":"$j","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"line":190,"name":"$col","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"kind":13,"containerName":"next_result","name":"$row","line":190},{"line":191,"kind":13,"containerName":"next_result","name":"$i"},{"line":191,"kind":13,"containerName":"next_result","name":"$j"},{"line":193,"name":"$subst_matrix","kind":13,"containerName":"next_result"},{"name":"$resloc","containerName":"next_result","kind":13,"line":193},{"containerName":"next_result","kind":13,"name":"$i","line":193},{"containerName":"next_result","kind":13,"name":"$resloc","line":193},{"name":"$j","containerName":"next_result","kind":13,"line":193},{"line":195,"kind":13,"containerName":"next_result","name":"$subst_matrix"},{"kind":13,"containerName":"next_result","name":"$resloc","line":195},{"name":"$i","containerName":"next_result","kind":13,"line":195},{"name":"$resloc","containerName":"next_result","kind":13,"line":195},{"name":"$j","kind":13,"containerName":"next_result","line":195},{"containerName":"next_result","kind":13,"name":"$col","line":195},{"kind":13,"containerName":"next_result","name":"$j","line":197},{"line":199,"name":"$i","containerName":"next_result","kind":13},{"line":203,"kind":13,"containerName":"next_result","name":"$state"},{"definition":"my","line":204,"containerName":"next_result","localvar":"my","kind":13,"name":"$newtrans_type"},{"line":205,"name":"$trans_amount","containerName":"next_result","kind":13},{"line":206,"name":"$trans_type","containerName":"next_result","kind":13},{"definition":"my","line":208,"containerName":"next_result","localvar":"my","kind":13,"name":"$i"},{"definition":"my","line":209,"kind":13,"localvar":"my","containerName":"next_result","name":"$row"},{"line":209,"kind":13,"containerName":"next_result","name":"@transition_matrix"},{"definition":"my","name":"$j","localvar":"my","containerName":"next_result","kind":13,"line":210},{"definition":"my","line":211,"name":"$col","containerName":"next_result","localvar":"my","kind":13},{"name":"$row","kind":13,"containerName":"next_result","line":211},{"containerName":"next_result","kind":13,"name":"$transition_mat","line":212},{"line":212,"name":"$trans_type","containerName":"next_result","kind":13},{"line":212,"kind":13,"containerName":"next_result","name":"$resloc"},{"kind":13,"containerName":"next_result","name":"$i","line":212},{"line":212,"name":"$resloc","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$j","line":212},{"name":"$col","kind":13,"containerName":"next_result","line":212},{"name":"$j","containerName":"next_result","kind":13,"line":213},{"name":"$i","containerName":"next_result","kind":13,"line":215},{"name":"$trans_type","containerName":"next_result","kind":13,"line":218},{"line":218,"name":"$newtrans_type","containerName":"next_result","kind":13},{"line":219,"kind":13,"containerName":"next_result","name":"$transition_ct"},{"kind":13,"containerName":"next_result","name":"@transition_matrix","line":220},{"name":"$state","containerName":"next_result","kind":13,"line":223},{"line":224,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"_readline","line":224},{"containerName":"next_result","kind":13,"name":"$self","line":225},{"line":225,"name":"_readline","kind":12,"containerName":"next_result"},{"line":227,"containerName":"next_result","kind":13,"name":"$self"},{"line":227,"kind":12,"containerName":"next_result","name":"_pushback"},{"definition":"my","line":232,"name":"$index","containerName":"next_result","localvar":"my","kind":13},{"line":232,"name":"$res","containerName":"next_result","kind":13},{"line":232,"name":"$model","containerName":"next_result","kind":13},{"line":232,"name":"$data","containerName":"next_result","kind":13},{"line":233,"name":"$frequencies","kind":13,"containerName":"next_result"},{"line":233,"containerName":"next_result","kind":13,"name":"$res"},{"kind":13,"containerName":"next_result","name":"$model","line":233},{"containerName":"next_result","kind":13,"name":"$data","line":233},{"containerName":"next_result","localvar":"my","kind":13,"name":"@save","line":236,"definition":"my"},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":"next_result","line":238},{"line":239,"name":"$row","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"line":239,"kind":13,"containerName":"next_result","name":"@transition_matrix"},{"definition":"my","line":240,"name":"$j","localvar":"my","kind":13,"containerName":"next_result"},{"localvar":"my","containerName":"next_result","kind":13,"name":"$col","line":241,"definition":"my"},{"name":"$row","containerName":"next_result","kind":13,"line":241},{"line":242,"name":"$transition_mat","kind":13,"containerName":"next_result"},{"line":242,"kind":13,"containerName":"next_result","name":"$trans_type"},{"line":242,"containerName":"next_result","kind":13,"name":"$resloc"},{"containerName":"next_result","kind":13,"name":"$i","line":242},{"line":242,"name":"$resloc","kind":13,"containerName":"next_result"},{"line":242,"name":"$j","containerName":"next_result","kind":13},{"line":242,"kind":13,"containerName":"next_result","name":"$col"},{"name":"$j","containerName":"next_result","kind":13,"line":243},{"line":245,"name":"$i","kind":13,"containerName":"next_result"},{"line":247,"containerName":"next_result","kind":13,"name":"$treenum"},{"kind":13,"containerName":"next_result","name":"$self","line":248},{"containerName":"next_result","kind":12,"name":"_pushback","line":248},{"line":252,"containerName":"next_result","kind":13,"name":"$state"},{"name":"$treenum","containerName":"next_result","kind":13,"line":253},{"line":253,"kind":13,"containerName":"next_result","name":"$possible_trees"},{"line":253,"kind":13,"containerName":"next_result","name":"$model"},{"line":253,"kind":13,"containerName":"next_result","name":"@save"},{"kind":13,"containerName":"next_result","name":"$model","line":254},{"line":255,"name":"$state","containerName":"next_result","kind":13},{"name":"$trans_type","containerName":"next_result","kind":13,"line":259},{"line":261,"name":"$transition_matrix","containerName":"next_result","kind":13},{"line":261,"name":"$transition_ct","kind":13,"containerName":"next_result"},{"line":262,"name":"$transition_ct","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$transition_ct","line":262},{"line":263,"containerName":"next_result","kind":13,"name":"$trans_type"},{"definition":"my","name":"$res","kind":13,"localvar":"my","containerName":"next_result","line":265},{"line":265,"kind":13,"containerName":"next_result","name":"@row"},{"name":"$transition_ct","kind":13,"containerName":"next_result","line":266},{"name":"$transition_matrix","kind":13,"containerName":"next_result","line":267},{"name":"$transition_ct","containerName":"next_result","kind":13,"line":267},{"name":"@row","containerName":"next_result","kind":13,"line":267}]},{"line":269,"name":"%state","containerName":null,"kind":13},{"line":271,"name":"@treedata","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@treelines","line":275},{"localvar":"my","kind":13,"containerName":null,"name":"@trees","line":279,"definition":"my"},{"name":"@treelines","containerName":null,"kind":13,"line":280},{"definition":"my","line":281,"name":"$strdat","localvar":"my","containerName":null,"kind":13},{"line":281,"name":"IO","kind":12,"containerName":"String"},{"line":281,"name":"new","containerName":"main::","kind":12},{"line":281,"kind":13,"containerName":null,"name":"@treelines"},{"containerName":null,"localvar":"my","kind":13,"name":"$treeio","line":282,"definition":"my"},{"containerName":"TreeIO","kind":12,"name":"Bio","line":282},{"line":282,"containerName":"main::","kind":12,"name":"new"},{"containerName":null,"kind":13,"name":"$strdat","line":282},{"line":284,"localvar":"my","kind":13,"containerName":null,"name":"$tree","definition":"my"},{"name":"$treeio","kind":13,"containerName":null,"line":284},{"containerName":"main::","kind":12,"name":"next_tree","line":284},{"line":285,"name":"@treedata","containerName":null,"kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$dat","line":286},{"line":286,"kind":13,"containerName":null,"name":"@treedata"},{"name":"$tree","kind":13,"containerName":null,"line":288},{"name":"id","kind":12,"containerName":"main::","line":288},{"name":"@dat","kind":13,"containerName":null,"line":288},{"kind":13,"containerName":null,"name":"$tree","line":289},{"name":"score","containerName":"main::","kind":12,"line":289},{"line":289,"containerName":null,"kind":13,"name":"@dat"},{"line":291,"name":"@trees","containerName":null,"kind":13},{"line":291,"containerName":null,"kind":13,"name":"$tree"},{"line":294,"name":"$parsed","kind":13,"containerName":null},{"definition":"my","name":"$result","localvar":"my","kind":13,"containerName":null,"line":295},{"line":295,"containerName":"Tools::Phylo::Molphy::Result","kind":12,"name":"Bio"},{"line":296,"kind":12,"containerName":"main::","name":"new"},{"line":296,"containerName":null,"kind":13,"name":"@trees"},{"line":297,"kind":13,"containerName":null,"name":"%subst_matrix"},{"line":298,"name":"%frequencies","containerName":null,"kind":13},{"line":299,"kind":13,"containerName":null,"name":"$model"},{"name":"$possible_trees","containerName":null,"kind":13,"line":300},{"definition":"my","name":"$type","localvar":"my","kind":13,"containerName":null,"line":302},{"containerName":null,"kind":13,"name":"$mat","line":302},{"line":302,"name":"%transition_mat","containerName":null,"kind":13},{"name":"$result","kind":13,"containerName":null,"line":303},{"kind":12,"containerName":"main::","name":"transition_probability_matrix","line":303},{"line":303,"name":"$type","kind":13,"containerName":null},{"line":303,"name":"$mat","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$result","line":305}],"version":5}