{"vars":[{"line":142,"containerName":"","kind":2,"name":"base"},{"line":144,"name":"$MotifTag","kind":13,"containerName":"main::","definition":"our"},{"containerName":null,"kind":13,"name":"$SrcTag","line":144},{"line":144,"kind":13,"containerName":null,"name":"$DescTag"},{"line":146,"name":"$MINSCORE","kind":13,"containerName":"main::","definition":"our"},{"definition":"our","kind":13,"containerName":"main::","name":"$DEFAULT_VERSION","line":147},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Infernal - A parser for Infernal output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Infernal;\n  my $parser = Bio::Tools::Infernal->new(-file => $rna_output,\n                                        -motiftag => 'misc_binding'\n                                        -desctag => 'Lysine riboswitch',\n                                        -cm    => 'RF00168',\n                                        -rfam  =>  'RF00168',\n                                        -minscore => 20);\n  #parse the results, get a Bio::SeqFeature::FeaturePair\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nThis is a highly experimental parser for Infernal output from the cmsearch\nprogram.  At some point it is anticipated that this will morph into a proper\nSearchIO parser, along with the related RNAMotif and ERPIN tools.\n\nThe Infernal suite of programs are used for generating RNA CM (covariance\nmodels) and searching sequences using CMs to locate potentially similar\nstructures.  The program is under active development; it is anticiapted that\nthis will support the latest version available.\n\nThis parser has been tested and is capable of parsing Infernal 0.7 and 0.71\noutput.  However, future Infernal versions may break parsing as the output is\nconstantly evolving, so keep an eye on this space for additional notes.\n\nCurrently data is parsed into a Bio::SeqFeature::FeaturePair object, consisting\nof a query (the covariance model) and the hit (sequence searched).  \n\nModel data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  --------------------------------------------------------------------------\n  primary tag     $sf->primary_tag                Rfam ID (if passed to new())\n  start           $sf->start                      Based on CM length\n  end             $sf->end                        Based on CM length\n  score           $sf->score                      Bit score\n  strand          $sf->strand                     0 (CM does not have a strand)\n  seqid           $sf->seq_id                     Rfam ID (if passed to new())\n  display name    $sf->feature1->display_name     CM name (if passed to new())\n  source          $sf->feature1->source tag      'Infernal' followed by version\n\nHit data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  ------------------------------------------------------------------\n  start           $sf->hstart\n  end             $sf->hend\n  score(bits)     $sf->hscore\n  strand          $sf->hstrand\n  seqid           $sf->hseqid\n  Primary Tag     $sf->hprimary_tag\n  Source Tag      $sf->hsource_tag\n\nAdded FeaturePair tags are : \n\n   secstructure - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   model        - name of the descriptor file (may include path to file)\n   midline      - contains structural information from the descriptor\n                  used as a query\n   hit          - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n   seqname      - raw sequence name (for downstream parsing if needed)\n\nAn additional parameter ('minscore') is added due to the huge number\nof spurious hits generated by cmsearch.  This screens data, only building\nand returning objects when a minimal bitscore is present.  \n\nSee t/rnamotif.t for example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Infernal;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Data::Dumper;\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding Infernal infernal);\n\nour $MINSCORE = 0;\nour $DEFAULT_VERSION = '0.71';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Infernal->new();\n Function: Builds a new Bio::Tools::Infernal object \n Returns : an instance of Bio::Tools::Infernal\n Args    : -fh/-file  - for input filehandle/filename\n           -motiftag  - primary tag used in gene features (default 'misc_binding')\n           -desctag   - tag used for display_name name (default 'infernal')\n           -srctag    - source tag used in all features (default 'Infernal')\n           -rfam      - Rfam id number\n           -cm        - covariance model used in analysis (may be same as rfam #)\n           -minscore  - minimum score (simple screener, since Infernal generates\n                        a ton of spurious hits)\n           -version   - Infernal program version\n\n yes, this is actually _initialize, but the args are passed to\n the constructor.\n see Bio::Tools::AnalysisResult for further details","label":"_initialize($self,@args)"},"line":171,"range":{"end":{"line":191,"character":9999},"start":{"character":0,"line":171}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"localvar":"my","kind":13,"containerName":"_initialize","name":"$self","line":172,"definition":"my"},{"line":172,"containerName":"_initialize","kind":13,"name":"@args"},{"kind":13,"containerName":"_initialize","name":"$self","line":173},{"line":173,"containerName":"_initialize","kind":12,"name":"warn"},{"line":174,"name":"$self","kind":13,"containerName":"_initialize"},{"line":174,"containerName":"_initialize","kind":13,"name":"@args"},{"line":175,"name":"$motiftag","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"name":"$desctag","kind":13,"containerName":"_initialize","line":175},{"line":175,"kind":13,"containerName":"_initialize","name":"$srctag"},{"name":"$rfam","containerName":"_initialize","kind":13,"line":175},{"containerName":"_initialize","kind":13,"name":"$cm","line":175},{"line":175,"containerName":"_initialize","kind":13,"name":"$ms"},{"containerName":"_initialize","kind":13,"name":"$ver","line":175},{"kind":13,"containerName":"_initialize","name":"$self","line":176},{"line":183,"name":"@args","kind":13,"containerName":"_initialize"},{"line":184,"name":"$self","kind":13,"containerName":"_initialize"},{"line":184,"containerName":"_initialize","kind":12,"name":"motif_tag"},{"line":184,"containerName":"_initialize","kind":13,"name":"$motiftag"},{"containerName":"_initialize","kind":13,"name":"$motiftag","line":184},{"name":"$MotifTag","containerName":"_initialize","kind":13,"line":184},{"kind":13,"containerName":"_initialize","name":"$self","line":185},{"name":"source_tag","kind":12,"containerName":"_initialize","line":185},{"kind":13,"containerName":"_initialize","name":"$srctag","line":185},{"kind":13,"containerName":"_initialize","name":"$srctag","line":185},{"line":185,"containerName":"_initialize","kind":13,"name":"$SrcTag"},{"kind":13,"containerName":"_initialize","name":"$self","line":186},{"line":186,"name":"desc_tag","containerName":"_initialize","kind":12},{"line":186,"kind":13,"containerName":"_initialize","name":"$desctag"},{"line":186,"name":"$desctag","kind":13,"containerName":"_initialize"},{"name":"$DescTag","containerName":"_initialize","kind":13,"line":186},{"line":187,"name":"$cm","containerName":"_initialize","kind":13},{"name":"$self","kind":13,"containerName":"_initialize","line":187},{"containerName":"_initialize","kind":12,"name":"covariance_model","line":187},{"name":"$cm","containerName":"_initialize","kind":13,"line":187},{"line":188,"name":"$rfam","containerName":"_initialize","kind":13},{"line":188,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"rfam","kind":12,"containerName":"_initialize","line":188},{"line":188,"kind":13,"containerName":"_initialize","name":"$rfam"},{"kind":13,"containerName":"_initialize","name":"$self","line":189},{"kind":12,"containerName":"_initialize","name":"program_version","line":189},{"name":"$ver","containerName":"_initialize","kind":13,"line":189},{"name":"$ver","containerName":"_initialize","kind":13,"line":189},{"containerName":"_initialize","kind":13,"name":"$DEFAULT_VERSION","line":189},{"name":"$self","kind":13,"containerName":"_initialize","line":190},{"line":190,"kind":12,"containerName":"_initialize","name":"minscore"},{"name":"$ms","kind":13,"containerName":"_initialize","line":190},{"line":190,"kind":13,"containerName":"_initialize","name":"$ms"},{"line":190,"containerName":"_initialize","kind":13,"name":"$MINSCORE"}],"name":"_initialize","containerName":"main::"},{"line":174,"name":"SUPER","kind":12,"containerName":"_initialize"},{"line":176,"kind":12,"containerName":"_rearrange","name":"SUPER"},{"line":212,"range":{"end":{"character":9999,"line":217},"start":{"line":212,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","line":213,"name":"$self","localvar":"my","containerName":"motif_tag","kind":13},{"kind":13,"containerName":"motif_tag","name":"$self","line":215},{"line":216,"containerName":"motif_tag","kind":13,"name":"$self"}],"name":"motif_tag","containerName":"main::"},{"definition":"sub","name":"source_tag","containerName":"main::","children":[{"line":232,"name":"$self","localvar":"my","containerName":"source_tag","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"source_tag","line":234},{"containerName":"source_tag","kind":13,"name":"$self","line":235}],"kind":12,"range":{"end":{"character":9999,"line":236},"start":{"line":231,"character":0}},"line":231},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"desc_tag","kind":13,"line":254},{"line":256,"kind":13,"containerName":"desc_tag","name":"$self"},{"kind":13,"containerName":"desc_tag","name":"$self","line":257}],"containerName":"main::","name":"desc_tag","line":253,"kind":12,"range":{"end":{"character":9999,"line":258},"start":{"line":253,"character":0}}},{"range":{"end":{"line":275,"character":9999},"start":{"character":0,"line":270}},"kind":12,"line":270,"name":"covariance_model","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"covariance_model","name":"$self","line":271},{"name":"$self","kind":13,"containerName":"covariance_model","line":273},{"name":"$self","containerName":"covariance_model","kind":13,"line":274}],"definition":"sub"},{"line":287,"kind":12,"range":{"end":{"line":292,"character":9999},"start":{"character":0,"line":287}},"definition":"sub","children":[{"containerName":"rfam","localvar":"my","kind":13,"name":"$self","line":288,"definition":"my"},{"containerName":"rfam","kind":13,"name":"$self","line":290},{"line":291,"name":"$self","kind":13,"containerName":"rfam"}],"name":"rfam","containerName":"main::"},{"containerName":"main::","name":"minscore","children":[{"line":305,"containerName":"minscore","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"minscore","line":307},{"name":"$self","kind":13,"containerName":"minscore","line":308}],"definition":"sub","kind":12,"range":{"start":{"line":304,"character":0},"end":{"line":309,"character":9999}},"line":304},{"containerName":"main::","name":"program_version","children":[{"definition":"my","line":323,"name":"$self","containerName":"program_version","localvar":"my","kind":13},{"kind":13,"containerName":"program_version","name":"$self","line":325},{"containerName":"program_version","kind":13,"name":"$self","line":326}],"definition":"sub","range":{"start":{"character":0,"line":322},"end":{"character":9999,"line":327}},"kind":12,"line":322},{"detail":"($self,$method)","definition":"sub","containerName":"main::","name":"analysis_method","children":[{"definition":"my","line":340,"name":"$self","containerName":"analysis_method","localvar":"my","kind":13},{"line":340,"kind":13,"containerName":"analysis_method","name":"$method"},{"name":"$method","kind":13,"containerName":"analysis_method","line":341},{"name":"$method","kind":13,"containerName":"analysis_method","line":341},{"line":342,"name":"$self","containerName":"analysis_method","kind":13},{"name":"throw","containerName":"analysis_method","kind":12,"line":342},{"line":342,"kind":13,"containerName":"analysis_method","name":"$self"},{"name":"$self","kind":13,"containerName":"analysis_method","line":344},{"name":"$method","containerName":"analysis_method","kind":13,"line":344}],"signature":{"label":"analysis_method($self,$method)","documentation":"1;\n# $Id: Infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Infernal - A parser for Infernal output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Infernal;\n  my $parser = Bio::Tools::Infernal->new(-file => $rna_output,\n                                        -motiftag => 'misc_binding'\n                                        -desctag => 'Lysine riboswitch',\n                                        -cm    => 'RF00168',\n                                        -rfam  =>  'RF00168',\n                                        -minscore => 20);\n  #parse the results, get a Bio::SeqFeature::FeaturePair\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nThis is a highly experimental parser for Infernal output from the cmsearch\nprogram.  At some point it is anticipated that this will morph into a proper\nSearchIO parser, along with the related RNAMotif and ERPIN tools.\n\nThe Infernal suite of programs are used for generating RNA CM (covariance\nmodels) and searching sequences using CMs to locate potentially similar\nstructures.  The program is under active development; it is anticiapted that\nthis will support the latest version available.\n\nThis parser has been tested and is capable of parsing Infernal 0.7 and 0.71\noutput.  However, future Infernal versions may break parsing as the output is\nconstantly evolving, so keep an eye on this space for additional notes.\n\nCurrently data is parsed into a Bio::SeqFeature::FeaturePair object, consisting\nof a query (the covariance model) and the hit (sequence searched).  \n\nModel data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  --------------------------------------------------------------------------\n  primary tag     $sf->primary_tag                Rfam ID (if passed to new())\n  start           $sf->start                      Based on CM length\n  end             $sf->end                        Based on CM length\n  score           $sf->score                      Bit score\n  strand          $sf->strand                     0 (CM does not have a strand)\n  seqid           $sf->seq_id                     Rfam ID (if passed to new())\n  display name    $sf->feature1->display_name     CM name (if passed to new())\n  source          $sf->feature1->source tag      'Infernal' followed by version\n\nHit data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  ------------------------------------------------------------------\n  start           $sf->hstart\n  end             $sf->hend\n  score(bits)     $sf->hscore\n  strand          $sf->hstrand\n  seqid           $sf->hseqid\n  Primary Tag     $sf->hprimary_tag\n  Source Tag      $sf->hsource_tag\n\nAdded FeaturePair tags are : \n\n   secstructure - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   model        - name of the descriptor file (may include path to file)\n   midline      - contains structural information from the descriptor\n                  used as a query\n   hit          - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n   seqname      - raw sequence name (for downstream parsing if needed)\n\nAn additional parameter ('minscore') is added due to the huge number\nof spurious hits generated by cmsearch.  This screens data, only building\nand returning objects when a minimal bitscore is present.  \n\nSee t/rnamotif.t for example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Infernal;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Data::Dumper;\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding Infernal infernal);\n\nour $MINSCORE = 0;\nour $DEFAULT_VERSION = '0.71';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Infernal->new();\n Function: Builds a new Bio::Tools::Infernal object \n Returns : an instance of Bio::Tools::Infernal\n Args    : -fh/-file  - for input filehandle/filename\n           -motiftag  - primary tag used in gene features (default 'misc_binding')\n           -desctag   - tag used for display_name name (default 'infernal')\n           -srctag    - source tag used in all features (default 'Infernal')\n           -rfam      - Rfam id number\n           -cm        - covariance model used in analysis (may be same as rfam #)\n           -minscore  - minimum score (simple screener, since Infernal generates\n                        a ton of spurious hits)\n           -version   - Infernal program version\n\n\n# yes, this is actually _initialize, but the args are passed to\n# the constructor.\n# see Bio::Tools::AnalysisResult for further details\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::infernal instead');  \n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag,$rfam,$cm,$ms,$ver) =\n        $self->SUPER::_rearrange([qw(MOTIFTAG\n                                    DESCTAG\n                                    SRCTAG\n                                    RFAM\n                                    CM\n                                    MINSCORE\n                                    VERSION\n                                 )],@args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $cm        && $self->covariance_model($cm);\n  $rfam      && $self->rfam($rfam);\n  $self->program_version(defined $ver ? $ver : $DEFAULT_VERSION);\n  $self->minscore(defined $ms ? $ms : $MINSCORE);\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'Infernal' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'infernal' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the Infernal output, this should\n           be set every time an Infernal object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 covariance_model\n\n Title   : covariance_model\n Usage   : $obj->covariance_model($newval)\n Function: Get/Set the value used for the covariance model used in the analysis.\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub covariance_model{\n    my $self = shift;\n\n    return $self->{'_cmodel'} = shift if @_;\n    return $self->{'_cmodel'};\n}\n\n=head2 rfam\n\n Title   : rfam\n Usage   : $obj->rfam($newval)\n Function: Get/Set the Rfam accession number\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rfam {\n    my $self = shift;\n\n    return $self->{'_rfam'} = shift if @_;\n    return $self->{'_rfam'};\n}\n\n=head2 minscore\n\n Title   : minscore\n Usage   : $obj->minscore($newval)\n Function: Get/Set the minimum score threshold for generating SeqFeatures\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub minscore {\n    my $self = shift;\n\n    return $self->{'_minscore'} = shift if @_;\n    return $self->{'_minscore'};\n}\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $obj->program_version($newval)\n Function: Get/Set the Infernal program version\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n           Note: this is set to $DEFAULT_VERSION by, um, default\n\n\nsub program_version {\n    my $self = shift;\n\n    return $self->{'_program_version'} = shift if @_;\n    return $self->{'_program_version'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Infernal/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}]},"kind":12,"range":{"end":{"character":9999,"line":345},"start":{"character":0,"line":339}},"line":339},{"containerName":"analysis_method","kind":12,"name":"SUPER","line":344},{"children":[{"definition":"my","line":365,"name":"$self","kind":13,"localvar":"my","containerName":"next_feature"},{"line":365,"containerName":"next_feature","kind":13,"name":"@args"},{"containerName":"next_feature","kind":13,"name":"$self","line":369},{"line":369,"containerName":"next_feature","kind":12,"name":"next_prediction"},{"line":369,"containerName":"next_feature","kind":13,"name":"@args"}],"name":"next_feature","containerName":"main::","definition":"sub","detail":"($self,@args)","line":364,"kind":12,"range":{"start":{"line":364,"character":0},"end":{"character":9999,"line":370}},"signature":{"label":"next_feature($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Infernal - A parser for Infernal output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Infernal;\n  my $parser = Bio::Tools::Infernal->new(-file => $rna_output,\n                                        -motiftag => 'misc_binding'\n                                        -desctag => 'Lysine riboswitch',\n                                        -cm    => 'RF00168',\n                                        -rfam  =>  'RF00168',\n                                        -minscore => 20);\n  #parse the results, get a Bio::SeqFeature::FeaturePair\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nThis is a highly experimental parser for Infernal output from the cmsearch\nprogram.  At some point it is anticipated that this will morph into a proper\nSearchIO parser, along with the related RNAMotif and ERPIN tools.\n\nThe Infernal suite of programs are used for generating RNA CM (covariance\nmodels) and searching sequences using CMs to locate potentially similar\nstructures.  The program is under active development; it is anticiapted that\nthis will support the latest version available.\n\nThis parser has been tested and is capable of parsing Infernal 0.7 and 0.71\noutput.  However, future Infernal versions may break parsing as the output is\nconstantly evolving, so keep an eye on this space for additional notes.\n\nCurrently data is parsed into a Bio::SeqFeature::FeaturePair object, consisting\nof a query (the covariance model) and the hit (sequence searched).  \n\nModel data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  --------------------------------------------------------------------------\n  primary tag     $sf->primary_tag                Rfam ID (if passed to new())\n  start           $sf->start                      Based on CM length\n  end             $sf->end                        Based on CM length\n  score           $sf->score                      Bit score\n  strand          $sf->strand                     0 (CM does not have a strand)\n  seqid           $sf->seq_id                     Rfam ID (if passed to new())\n  display name    $sf->feature1->display_name     CM name (if passed to new())\n  source          $sf->feature1->source tag      'Infernal' followed by version\n\nHit data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  ------------------------------------------------------------------\n  start           $sf->hstart\n  end             $sf->hend\n  score(bits)     $sf->hscore\n  strand          $sf->hstrand\n  seqid           $sf->hseqid\n  Primary Tag     $sf->hprimary_tag\n  Source Tag      $sf->hsource_tag\n\nAdded FeaturePair tags are : \n\n   secstructure - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   model        - name of the descriptor file (may include path to file)\n   midline      - contains structural information from the descriptor\n                  used as a query\n   hit          - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n   seqname      - raw sequence name (for downstream parsing if needed)\n\nAn additional parameter ('minscore') is added due to the huge number\nof spurious hits generated by cmsearch.  This screens data, only building\nand returning objects when a minimal bitscore is present.  \n\nSee t/rnamotif.t for example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Infernal;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Data::Dumper;\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding Infernal infernal);\n\nour $MINSCORE = 0;\nour $DEFAULT_VERSION = '0.71';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Infernal->new();\n Function: Builds a new Bio::Tools::Infernal object \n Returns : an instance of Bio::Tools::Infernal\n Args    : -fh/-file  - for input filehandle/filename\n           -motiftag  - primary tag used in gene features (default 'misc_binding')\n           -desctag   - tag used for display_name name (default 'infernal')\n           -srctag    - source tag used in all features (default 'Infernal')\n           -rfam      - Rfam id number\n           -cm        - covariance model used in analysis (may be same as rfam #)\n           -minscore  - minimum score (simple screener, since Infernal generates\n                        a ton of spurious hits)\n           -version   - Infernal program version\n\n\n# yes, this is actually _initialize, but the args are passed to\n# the constructor.\n# see Bio::Tools::AnalysisResult for further details\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::infernal instead');  \n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag,$rfam,$cm,$ms,$ver) =\n        $self->SUPER::_rearrange([qw(MOTIFTAG\n                                    DESCTAG\n                                    SRCTAG\n                                    RFAM\n                                    CM\n                                    MINSCORE\n                                    VERSION\n                                 )],@args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $cm        && $self->covariance_model($cm);\n  $rfam      && $self->rfam($rfam);\n  $self->program_version(defined $ver ? $ver : $DEFAULT_VERSION);\n  $self->minscore(defined $ms ? $ms : $MINSCORE);\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'Infernal' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'infernal' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the Infernal output, this should\n           be set every time an Infernal object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 covariance_model\n\n Title   : covariance_model\n Usage   : $obj->covariance_model($newval)\n Function: Get/Set the value used for the covariance model used in the analysis.\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub covariance_model{\n    my $self = shift;\n\n    return $self->{'_cmodel'} = shift if @_;\n    return $self->{'_cmodel'};\n}\n\n=head2 rfam\n\n Title   : rfam\n Usage   : $obj->rfam($newval)\n Function: Get/Set the Rfam accession number\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rfam {\n    my $self = shift;\n\n    return $self->{'_rfam'} = shift if @_;\n    return $self->{'_rfam'};\n}\n\n=head2 minscore\n\n Title   : minscore\n Usage   : $obj->minscore($newval)\n Function: Get/Set the minimum score threshold for generating SeqFeatures\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub minscore {\n    my $self = shift;\n\n    return $self->{'_minscore'} = shift if @_;\n    return $self->{'_minscore'};\n}\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $obj->program_version($newval)\n Function: Get/Set the Infernal program version\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n           Note: this is set to $DEFAULT_VERSION by, um, default\n\n\nsub program_version {\n    my $self = shift;\n\n    return $self->{'_program_version'} = shift if @_;\n    return $self->{'_program_version'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Infernal/i.\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method { \n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Infernal/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)"}},{"line":385,"kind":12,"range":{"end":{"line":484,"character":9999},"start":{"character":0,"line":385}},"signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Infernal - A parser for Infernal output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Infernal;\n  my $parser = Bio::Tools::Infernal->new(-file => $rna_output,\n                                        -motiftag => 'misc_binding'\n                                        -desctag => 'Lysine riboswitch',\n                                        -cm    => 'RF00168',\n                                        -rfam  =>  'RF00168',\n                                        -minscore => 20);\n  #parse the results, get a Bio::SeqFeature::FeaturePair\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nThis is a highly experimental parser for Infernal output from the cmsearch\nprogram.  At some point it is anticipated that this will morph into a proper\nSearchIO parser, along with the related RNAMotif and ERPIN tools.\n\nThe Infernal suite of programs are used for generating RNA CM (covariance\nmodels) and searching sequences using CMs to locate potentially similar\nstructures.  The program is under active development; it is anticiapted that\nthis will support the latest version available.\n\nThis parser has been tested and is capable of parsing Infernal 0.7 and 0.71\noutput.  However, future Infernal versions may break parsing as the output is\nconstantly evolving, so keep an eye on this space for additional notes.\n\nCurrently data is parsed into a Bio::SeqFeature::FeaturePair object, consisting\nof a query (the covariance model) and the hit (sequence searched).  \n\nModel data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  --------------------------------------------------------------------------\n  primary tag     $sf->primary_tag                Rfam ID (if passed to new())\n  start           $sf->start                      Based on CM length\n  end             $sf->end                        Based on CM length\n  score           $sf->score                      Bit score\n  strand          $sf->strand                     0 (CM does not have a strand)\n  seqid           $sf->seq_id                     Rfam ID (if passed to new())\n  display name    $sf->feature1->display_name     CM name (if passed to new())\n  source          $sf->feature1->source tag      'Infernal' followed by version\n\nHit data is accessible via the following:\n\n  Data            SeqFeature::FeaturePair         Note\n  ------------------------------------------------------------------\n  start           $sf->hstart\n  end             $sf->hend\n  score(bits)     $sf->hscore\n  strand          $sf->hstrand\n  seqid           $sf->hseqid\n  Primary Tag     $sf->hprimary_tag\n  Source Tag      $sf->hsource_tag\n\nAdded FeaturePair tags are : \n\n   secstructure - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   model        - name of the descriptor file (may include path to file)\n   midline      - contains structural information from the descriptor\n                  used as a query\n   hit          - sequence of motif, separated by spaces according to\n                  matches to the structure in the descriptor (in\n                  SecStructure).\n   seqname      - raw sequence name (for downstream parsing if needed)\n\nAn additional parameter ('minscore') is added due to the huge number\nof spurious hits generated by cmsearch.  This screens data, only building\nand returning objects when a minimal bitscore is present.  \n\nSee t/rnamotif.t for example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Infernal;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::FeaturePair;\nuse Data::Dumper;\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding Infernal infernal);\n\nour $MINSCORE = 0;\nour $DEFAULT_VERSION = '0.71';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Infernal->new();\n Function: Builds a new Bio::Tools::Infernal object \n Returns : an instance of Bio::Tools::Infernal\n Args    : -fh/-file  - for input filehandle/filename\n           -motiftag  - primary tag used in gene features (default 'misc_binding')\n           -desctag   - tag used for display_name name (default 'infernal')\n           -srctag    - source tag used in all features (default 'Infernal')\n           -rfam      - Rfam id number\n           -cm        - covariance model used in analysis (may be same as rfam #)\n           -minscore  - minimum score (simple screener, since Infernal generates\n                        a ton of spurious hits)\n           -version   - Infernal program version\n\n\n# yes, this is actually _initialize, but the args are passed to\n# the constructor.\n# see Bio::Tools::AnalysisResult for further details\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::infernal instead');  \n  $self->SUPER::_initialize(@args);\n  my ($motiftag,$desctag,$srctag,$rfam,$cm,$ms,$ver) =\n        $self->SUPER::_rearrange([qw(MOTIFTAG\n                                    DESCTAG\n                                    SRCTAG\n                                    RFAM\n                                    CM\n                                    MINSCORE\n                                    VERSION\n                                 )],@args);\n  $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n  $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n  $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n  $cm        && $self->covariance_model($cm);\n  $rfam      && $self->rfam($rfam);\n  $self->program_version(defined $ver ? $ver : $DEFAULT_VERSION);\n  $self->minscore(defined $ms ? $ms : $MINSCORE);\n}\n\n=head2 motif_tag\n\n Title   : motif_tag\n Usage   : $obj->motif_tag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'Infernal' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'infernal' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the Infernal output, this should\n           be set every time an Infernal object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 covariance_model\n\n Title   : covariance_model\n Usage   : $obj->covariance_model($newval)\n Function: Get/Set the value used for the covariance model used in the analysis.\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub covariance_model{\n    my $self = shift;\n\n    return $self->{'_cmodel'} = shift if @_;\n    return $self->{'_cmodel'};\n}\n\n=head2 rfam\n\n Title   : rfam\n Usage   : $obj->rfam($newval)\n Function: Get/Set the Rfam accession number\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rfam {\n    my $self = shift;\n\n    return $self->{'_rfam'} = shift if @_;\n    return $self->{'_rfam'};\n}\n\n=head2 minscore\n\n Title   : minscore\n Usage   : $obj->minscore($newval)\n Function: Get/Set the minimum score threshold for generating SeqFeatures\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub minscore {\n    my $self = shift;\n\n    return $self->{'_minscore'} = shift if @_;\n    return $self->{'_minscore'};\n}\n\n=head2 program_version\n\n Title   : program_version\n Usage   : $obj->program_version($newval)\n Function: Get/Set the Infernal program version\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n           Note: this is set to $DEFAULT_VERSION by, um, default\n\n\nsub program_version {\n    my $self = shift;\n\n    return $self->{'_program_version'} = shift if @_;\n    return $self->{'_program_version'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /Infernal/i.\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method { \n    my ($self, $method) = @_;  \n    if($method && ($method !~ /Infernal/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $obj->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the RNAMotif result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Generic object\n Args    : None (at present)","parameters":[{"label":"$self"}]},"children":[{"definition":"my","name":"$self","containerName":"next_prediction","localvar":"my","kind":13,"line":386},{"line":388,"localvar":"my","containerName":"next_prediction","kind":13,"name":"$start","definition":"my"},{"line":388,"name":"$end","containerName":"next_prediction","kind":13},{"line":388,"containerName":"next_prediction","kind":13,"name":"$strand"},{"kind":13,"containerName":"next_prediction","name":"$score","line":388},{"definition":"my","line":390,"name":"%hsp_key","localvar":"my","kind":13,"containerName":"next_prediction"},{"line":394,"kind":13,"localvar":"my","containerName":"next_prediction","name":"$line","definition":"my"},{"line":396,"name":"$line","kind":13,"containerName":"next_prediction"},{"line":396,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":396,"name":"_readline","kind":12,"containerName":"next_prediction"},{"line":397,"containerName":"next_prediction","kind":13,"name":"$line"},{"kind":13,"containerName":"next_prediction","name":"$line","line":398},{"line":399,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":399,"containerName":"next_prediction","kind":12,"name":"_current_hit"},{"line":401,"containerName":"next_prediction","kind":13,"name":"$line"},{"name":"$strand","kind":13,"containerName":"next_prediction","line":402},{"containerName":"next_prediction","kind":13,"name":"$start","line":403},{"line":403,"kind":13,"containerName":"next_prediction","name":"$end"},{"containerName":"next_prediction","kind":13,"name":"$score","line":403},{"name":"$start","containerName":"next_prediction","kind":13,"line":404},{"line":404,"name":"$end","containerName":"next_prediction","kind":13},{"containerName":"next_prediction","kind":13,"name":"$start","line":405},{"line":405,"name":"$end","kind":13,"containerName":"next_prediction"},{"line":405,"kind":13,"containerName":"next_prediction","name":"$end"},{"containerName":"next_prediction","kind":13,"name":"$start","line":405},{"name":"$strand","containerName":"next_prediction","kind":13,"line":406},{"line":410,"name":"$line","containerName":"next_prediction","kind":13},{"line":411,"containerName":"next_prediction","kind":13,"name":"$self"},{"kind":12,"containerName":"next_prediction","name":"_pushback","line":411},{"name":"$line","containerName":"next_prediction","kind":13,"line":411},{"localvar":"my","containerName":"next_prediction","kind":13,"name":"$offset","line":413,"definition":"my"},{"localvar":"my","containerName":"next_prediction","kind":13,"name":"$ct","line":414,"definition":"my"},{"line":414,"name":"$strln","kind":13,"containerName":"next_prediction"},{"line":415,"name":"$hsp","localvar":"my","kind":13,"containerName":"next_prediction","definition":"my"},{"line":417,"kind":13,"containerName":"next_prediction","name":"$line"},{"line":417,"name":"$self","kind":13,"containerName":"next_prediction"},{"containerName":"next_prediction","kind":12,"name":"_readline","line":417},{"line":418,"name":"$line","kind":13,"containerName":"next_prediction"},{"line":419,"containerName":"next_prediction","kind":13,"name":"$line"},{"line":421,"name":"$line","containerName":"next_prediction","kind":13},{"line":421,"containerName":"next_prediction","kind":13,"name":"$line"},{"name":"$self","containerName":"next_prediction","kind":13,"line":422},{"name":"_pushback","kind":12,"containerName":"next_prediction","line":422},{"line":422,"name":"$line","containerName":"next_prediction","kind":13},{"name":"$iterator","kind":13,"localvar":"my","containerName":"next_prediction","line":426,"definition":"my"},{"name":"$ct","kind":13,"containerName":"next_prediction","line":426},{"kind":13,"containerName":"next_prediction","name":"%4","line":426},{"kind":13,"containerName":"next_prediction","name":"$strln","line":428},{"line":428,"name":"$line","containerName":"next_prediction","kind":13},{"name":"$iterator","kind":13,"containerName":"next_prediction","line":428},{"definition":"my","line":435,"name":"$data","localvar":"my","containerName":"next_prediction","kind":13},{"line":435,"kind":13,"containerName":"next_prediction","name":"$line"},{"line":435,"containerName":"next_prediction","kind":13,"name":"$offset"},{"name":"$strln","kind":13,"containerName":"next_prediction","line":435},{"kind":13,"containerName":"next_prediction","name":"$offset","line":435},{"name":"$hsp","kind":13,"containerName":"next_prediction","line":436},{"line":436,"kind":13,"containerName":"next_prediction","name":"$hsp_key"},{"line":436,"containerName":"next_prediction","kind":13,"name":"$iterator"},{"line":436,"name":"$data","containerName":"next_prediction","kind":13},{"line":437,"containerName":"next_prediction","kind":13,"name":"$ct"},{"line":439,"name":"$self","containerName":"next_prediction","kind":13},{"name":"minscore","kind":12,"containerName":"next_prediction","line":439},{"line":439,"kind":13,"containerName":"next_prediction","name":"$score"},{"definition":"my","containerName":"next_prediction","localvar":"my","kind":13,"name":"$name","line":440},{"line":440,"name":"$program","kind":13,"containerName":"next_prediction"},{"name":"$rfam","kind":13,"containerName":"next_prediction","line":440},{"name":"$cm","kind":13,"containerName":"next_prediction","line":440},{"line":440,"kind":13,"containerName":"next_prediction","name":"$dt"},{"line":440,"containerName":"next_prediction","kind":13,"name":"$st"},{"line":440,"name":"$mt","kind":13,"containerName":"next_prediction"},{"name":"$self","kind":13,"containerName":"next_prediction","line":441},{"line":441,"name":"_current_hit","containerName":"next_prediction","kind":12},{"line":441,"containerName":"next_prediction","kind":13,"name":"$self"},{"line":441,"kind":12,"containerName":"next_prediction","name":"analysis_method"},{"name":"$self","containerName":"next_prediction","kind":13,"line":441},{"kind":12,"containerName":"next_prediction","name":"rfam","line":441},{"containerName":"next_prediction","kind":13,"name":"$self","line":442},{"name":"covariance_model","containerName":"next_prediction","kind":12,"line":442},{"line":442,"name":"$self","containerName":"next_prediction","kind":13},{"name":"desc_tag","containerName":"next_prediction","kind":12,"line":442},{"line":442,"name":"$self","kind":13,"containerName":"next_prediction"},{"line":442,"name":"source_tag","kind":12,"containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":443},{"name":"motif_tag","containerName":"next_prediction","kind":12,"line":443},{"name":"$ver","localvar":"my","containerName":"next_prediction","kind":13,"line":444,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_prediction","line":444},{"line":444,"containerName":"next_prediction","kind":12,"name":"program_version"},{"name":"$qid","localvar":"my","containerName":"next_prediction","kind":13,"line":445,"definition":"my"},{"line":445,"name":"$name","containerName":"next_prediction","kind":13},{"line":446,"containerName":"next_prediction","kind":13,"name":"$name"},{"name":"$qid","kind":13,"containerName":"next_prediction","line":447},{"localvar":"my","kind":13,"containerName":"next_prediction","name":"$fp","line":449,"definition":"my"},{"line":449,"name":"new","kind":12,"containerName":"next_prediction"},{"definition":"my","line":450,"containerName":"next_prediction","localvar":"my","kind":13,"name":"$strlen"},{"containerName":"next_prediction","kind":13,"name":"$hsp","line":450},{"name":"$qf","localvar":"my","containerName":"next_prediction","kind":13,"line":451,"definition":"my"},{"kind":12,"containerName":"next_prediction","name":"new","line":451},{"line":451,"name":"$mt","containerName":"next_prediction","kind":13},{"kind":13,"containerName":"next_prediction","name":"$cm","line":453},{"line":454,"kind":13,"containerName":"next_prediction","name":"$score"},{"line":456,"name":"$strlen","kind":13,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$rfam","line":457},{"line":460,"localvar":"my","kind":13,"containerName":"next_prediction","name":"$hf","definition":"my"},{"line":460,"name":"new","containerName":"next_prediction","kind":12},{"line":460,"containerName":"next_prediction","kind":13,"name":"$mt"},{"kind":13,"containerName":"next_prediction","name":"$dt","line":462},{"name":"$score","containerName":"next_prediction","kind":13,"line":463},{"line":464,"name":"$start","kind":13,"containerName":"next_prediction"},{"line":465,"name":"$end","kind":13,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$qid","line":466},{"kind":13,"containerName":"next_prediction","name":"$strand","line":468},{"line":469,"name":"$fp","containerName":"next_prediction","kind":13},{"name":"feature1","containerName":"next_prediction","kind":12,"line":469},{"line":469,"containerName":"next_prediction","kind":13,"name":"$qf"},{"name":"$fp","containerName":"next_prediction","kind":13,"line":470},{"line":470,"name":"feature2","kind":12,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$hf","line":470},{"line":471,"containerName":"next_prediction","kind":13,"name":"$fp"},{"line":471,"kind":12,"containerName":"next_prediction","name":"add_tag_value"},{"line":471,"kind":13,"containerName":"next_prediction","name":"$hsp"},{"name":"$fp","kind":13,"containerName":"next_prediction","line":472},{"line":472,"kind":12,"containerName":"next_prediction","name":"add_tag_value"},{"kind":13,"containerName":"next_prediction","name":"$hsp","line":472},{"line":473,"name":"$fp","containerName":"next_prediction","kind":13},{"kind":12,"containerName":"next_prediction","name":"add_tag_value","line":473},{"kind":13,"containerName":"next_prediction","name":"$hsp","line":473},{"containerName":"next_prediction","kind":13,"name":"$fp","line":474},{"containerName":"next_prediction","kind":12,"name":"add_tag_value","line":474},{"name":"$hsp","kind":13,"containerName":"next_prediction","line":474},{"containerName":"next_prediction","kind":13,"name":"$fp","line":475},{"line":475,"kind":12,"containerName":"next_prediction","name":"add_tag_value"},{"line":475,"containerName":"next_prediction","kind":13,"name":"$name"},{"line":476,"containerName":"next_prediction","kind":13,"name":"$fp"},{"name":"display_name","containerName":"next_prediction","kind":12,"line":476},{"line":476,"name":"$dt","containerName":"next_prediction","kind":13},{"line":477,"name":"$fp","kind":13,"containerName":"next_prediction"},{"name":"$line","kind":13,"containerName":"next_prediction","line":483}],"name":"next_prediction","containerName":"main::","definition":"sub","detail":"($self)"},{"kind":12,"name":"PARSER","line":395},{"line":400,"kind":12,"name":"PARSER"},{"kind":12,"name":"HSP","line":416},{"line":423,"name":"HSP","kind":12},{"kind":12,"containerName":"SeqFeature::FeaturePair","name":"Bio","line":449},{"line":451,"containerName":"SeqFeature::Generic","kind":12,"name":"Bio"},{"line":460,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"line":479,"name":"PARSER","kind":12},{"definition":"sub","name":"_current_hit","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_current_hit","kind":13,"line":487},{"line":488,"name":"$self","kind":13,"containerName":"_current_hit"},{"line":489,"containerName":"_current_hit","kind":13,"name":"$self"}],"kind":12,"range":{"start":{"line":486,"character":0},"end":{"line":490,"character":9999}},"line":486}],"version":5}