{"version":5,"vars":[{"kind":2,"containerName":"","name":"vars","line":89},{"kind":2,"containerName":"","name":"base","line":98},{"line":99,"kind":13,"containerName":null,"name":"$SOURCE_TAG"},{"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>","parameters":[{"label":"$class"},{"label":"@args"}]},"range":{"start":{"character":0,"line":112},"end":{"line":118,"character":9999}},"kind":12,"line":112,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","localvar":"my","containerName":"new","kind":13,"line":114},{"containerName":"new","kind":13,"name":"@args","line":114},{"line":115,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":115,"name":"$class","containerName":"new","kind":13},{"name":"@args","containerName":"new","kind":13,"line":115},{"name":"$self","containerName":"new","kind":13,"line":116},{"kind":12,"containerName":"new","name":"_initialize_io","line":116},{"line":116,"name":"@args","kind":13,"containerName":"new"},{"line":117,"containerName":"new","kind":13,"name":"$self"}]},{"containerName":"new","kind":12,"name":"SUPER","line":115},{"detail":"($self)","definition":"sub","name":"next_prediction","containerName":"main::","children":[{"definition":"my","containerName":"next_prediction","localvar":"my","kind":13,"name":"$self","line":136},{"definition":"my","name":"$gene","localvar":"my","containerName":"next_prediction","kind":13,"line":138},{"line":138,"kind":13,"containerName":"next_prediction","name":"$transcript"},{"name":"$current_gene_id","kind":13,"containerName":"next_prediction","line":138},{"name":"$transcript_score","localvar":"my","kind":13,"containerName":"next_prediction","line":139,"definition":"my"},{"line":141,"name":"$gene_id","kind":13,"localvar":"my","containerName":"next_prediction","definition":"my"},{"line":141,"name":"$exon_type","kind":13,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$exon_start","line":141},{"line":141,"name":"$exon_end","kind":13,"containerName":"next_prediction"},{"line":141,"name":"$exon_score","kind":13,"containerName":"next_prediction"},{"line":142,"kind":13,"containerName":"next_prediction","name":"$exon_strand"},{"line":142,"name":"$start_phase","containerName":"next_prediction","kind":13},{"line":142,"containerName":"next_prediction","kind":13,"name":"$end_phase"},{"line":142,"kind":13,"containerName":"next_prediction","name":"$start_sig_score"},{"containerName":"next_prediction","kind":13,"name":"$end_sig_score","line":143},{"line":143,"kind":13,"containerName":"next_prediction","name":"$coding_pot_score"},{"kind":13,"containerName":"next_prediction","name":"$homol_score","line":143},{"line":145,"containerName":"next_prediction","kind":13,"name":"$self"},{"kind":12,"containerName":"next_prediction","name":"_readline","line":145},{"containerName":"next_prediction","kind":13,"name":"$self","line":147},{"line":147,"containerName":"next_prediction","kind":12,"name":"debug"},{"definition":"my","line":164,"name":"$target_id","localvar":"my","kind":13,"containerName":"next_prediction"},{"containerName":"next_prediction","kind":13,"name":"$self","line":165},{"line":165,"containerName":"next_prediction","kind":12,"name":"_target_id"},{"line":165,"kind":13,"containerName":"next_prediction","name":"$target_id"},{"definition":"my","line":171,"name":"@fields","localvar":"my","containerName":"next_prediction","kind":13},{"name":"$gene_id","kind":13,"containerName":"next_prediction","line":175},{"containerName":"next_prediction","kind":13,"name":"@fields","line":175},{"containerName":"next_prediction","kind":13,"name":"$exon_type","line":177},{"line":177,"kind":13,"containerName":"next_prediction","name":"$exon_start"},{"line":177,"name":"$exon_end","containerName":"next_prediction","kind":13},{"containerName":"next_prediction","kind":13,"name":"$exon_score","line":177},{"line":178,"name":"$exon_strand","containerName":"next_prediction","kind":13},{"line":178,"containerName":"next_prediction","kind":13,"name":"$start_phase"},{"line":178,"containerName":"next_prediction","kind":13,"name":"$end_phase"},{"containerName":"next_prediction","kind":13,"name":"$start_sig_score","line":178},{"name":"$end_sig_score","kind":13,"containerName":"next_prediction","line":179},{"kind":13,"containerName":"next_prediction","name":"$coding_pot_score","line":179},{"name":"$homol_score","containerName":"next_prediction","kind":13,"line":179},{"line":179,"name":"@fields","containerName":"next_prediction","kind":13},{"containerName":"next_prediction","kind":13,"name":"$current_gene_id","line":181},{"name":"$current_gene_id","kind":13,"containerName":"next_prediction","line":184},{"line":184,"name":"$gene_id","containerName":"next_prediction","kind":13},{"line":185,"kind":13,"containerName":"next_prediction","name":"$transcript_score"},{"containerName":"next_prediction","kind":13,"name":"$exon_score","line":185},{"kind":13,"containerName":"next_prediction","name":"$gene","line":187},{"line":187,"name":"new","kind":12,"containerName":"next_prediction"},{"line":188,"name":"$SOURCE_TAG","containerName":"next_prediction","kind":13},{"line":189,"containerName":"next_prediction","kind":13,"name":"$transcript"},{"line":189,"name":"new","containerName":"next_prediction","kind":12},{"name":"$SOURCE_TAG","kind":13,"containerName":"next_prediction","line":190},{"kind":13,"containerName":"next_prediction","name":"$self","line":192},{"line":192,"containerName":"next_prediction","kind":12,"name":"_add_exon"},{"line":192,"kind":13,"containerName":"next_prediction","name":"$gene"},{"containerName":"next_prediction","kind":13,"name":"$transcript","line":192},{"line":192,"containerName":"next_prediction","kind":13,"name":"$exon_type"},{"line":192,"kind":13,"containerName":"next_prediction","name":"$exon_start"},{"line":192,"containerName":"next_prediction","kind":13,"name":"$exon_end"},{"containerName":"next_prediction","kind":13,"name":"$exon_score","line":192},{"name":"$exon_strand","containerName":"next_prediction","kind":13,"line":193},{"line":193,"kind":13,"containerName":"next_prediction","name":"$start_phase"},{"kind":13,"containerName":"next_prediction","name":"$end_phase","line":193},{"line":193,"name":"$start_sig_score","kind":13,"containerName":"next_prediction"},{"line":194,"containerName":"next_prediction","kind":13,"name":"$end_sig_score"},{"line":194,"kind":13,"containerName":"next_prediction","name":"$coding_pot_score"},{"kind":13,"containerName":"next_prediction","name":"$homol_score","line":194},{"line":196,"name":"$gene_id","kind":13,"containerName":"next_prediction"},{"name":"$current_gene_id","kind":13,"containerName":"next_prediction","line":196},{"line":199,"kind":13,"containerName":"next_prediction","name":"$transcript_score"},{"name":"$exon_score","kind":13,"containerName":"next_prediction","line":199},{"name":"$self","kind":13,"containerName":"next_prediction","line":201},{"line":201,"name":"_add_exon","containerName":"next_prediction","kind":12},{"name":"$gene","containerName":"next_prediction","kind":13,"line":201},{"kind":13,"containerName":"next_prediction","name":"$transcript","line":201},{"line":201,"name":"$exon_type","containerName":"next_prediction","kind":13},{"name":"$exon_start","kind":13,"containerName":"next_prediction","line":201},{"name":"$exon_end","kind":13,"containerName":"next_prediction","line":201},{"line":201,"name":"$exon_score","containerName":"next_prediction","kind":13},{"kind":13,"containerName":"next_prediction","name":"$exon_strand","line":202},{"containerName":"next_prediction","kind":13,"name":"$start_phase","line":202},{"line":202,"name":"$end_phase","containerName":"next_prediction","kind":13},{"line":202,"name":"$start_sig_score","kind":13,"containerName":"next_prediction"},{"name":"$end_sig_score","containerName":"next_prediction","kind":13,"line":203},{"line":203,"name":"$coding_pot_score","containerName":"next_prediction","kind":13},{"name":"$homol_score","containerName":"next_prediction","kind":13,"line":203},{"name":"$self","kind":13,"containerName":"next_prediction","line":208},{"line":208,"name":"_pushback","containerName":"next_prediction","kind":12},{"line":213,"name":"$gene","containerName":"next_prediction","kind":13},{"line":215,"name":"$transcript","kind":13,"containerName":"next_prediction"},{"name":"seq_id","containerName":"next_prediction","kind":12,"line":215},{"line":215,"name":"$self","containerName":"next_prediction","kind":13},{"kind":12,"containerName":"next_prediction","name":"_target_id","line":215},{"containerName":"next_prediction","kind":13,"name":"$transcript","line":216},{"line":216,"name":"score","containerName":"next_prediction","kind":12},{"name":"$transcript_score","containerName":"next_prediction","kind":13,"line":216},{"line":217,"name":"$gene","containerName":"next_prediction","kind":13},{"line":217,"containerName":"next_prediction","kind":12,"name":"add_transcript"},{"containerName":"next_prediction","kind":13,"name":"$transcript","line":217},{"kind":13,"containerName":"next_prediction","name":"$gene","line":218},{"line":218,"kind":12,"containerName":"next_prediction","name":"seq_id"},{"line":218,"containerName":"next_prediction","kind":13,"name":"$self"},{"line":218,"containerName":"next_prediction","kind":12,"name":"_target_id"},{"definition":"my","name":"$exon","containerName":"next_prediction","localvar":"my","kind":13,"line":220},{"line":220,"name":"$gene","containerName":"next_prediction","kind":13},{"name":"exons","kind":12,"containerName":"next_prediction","line":220},{"line":222,"name":"$exon","containerName":"next_prediction","kind":13},{"line":222,"name":"seq_id","kind":12,"containerName":"next_prediction"},{"line":222,"name":"$self","kind":13,"containerName":"next_prediction"},{"line":222,"kind":12,"containerName":"next_prediction","name":"_target_id"},{"name":"$self","containerName":"next_prediction","kind":13,"line":225},{"name":"_set_strand","containerName":"next_prediction","kind":12,"line":225},{"line":225,"name":"$gene","kind":13,"containerName":"next_prediction"},{"containerName":"next_prediction","kind":13,"name":"$gene","line":228}],"signature":{"label":"next_prediction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>\n\n\nsub new\n{\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    return $self;\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $geneid->next_prediction)\n           {\n               # do something\n           }\n Function: Returns the gene structure prediction of the geneid result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Gene::GeneStructure object\n Args    : None"},"range":{"start":{"line":134,"character":0},"end":{"line":229,"character":9999}},"kind":12,"line":134},{"line":187,"name":"Bio","kind":12,"containerName":"SeqFeature::Gene::GeneStructure"},{"name":"Bio","kind":12,"containerName":"SeqFeature::Gene::Transcript","line":189},{"detail":"($self,$gene,$transcript,$exon_type,$exon_start,$exon_end,$exon_score,$exon_strand,$start_phase,$end_phase,$start_sig_score,$end_sig_score,$coding_pot_score,$homol_score)","definition":"sub","name":"_add_exon","containerName":"main::","children":[{"line":244,"containerName":"_add_exon","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":244,"name":"$gene","containerName":"_add_exon","kind":13},{"line":244,"containerName":"_add_exon","kind":13,"name":"$transcript"},{"name":"$exon_type","kind":13,"containerName":"_add_exon","line":244},{"containerName":"_add_exon","kind":13,"name":"$exon_start","line":244},{"line":244,"name":"$exon_end","containerName":"_add_exon","kind":13},{"name":"$exon_score","containerName":"_add_exon","kind":13,"line":245},{"line":245,"kind":13,"containerName":"_add_exon","name":"$exon_strand"},{"line":245,"kind":13,"containerName":"_add_exon","name":"$start_phase"},{"line":245,"name":"$end_phase","kind":13,"containerName":"_add_exon"},{"line":245,"containerName":"_add_exon","kind":13,"name":"$start_sig_score"},{"line":246,"name":"$end_sig_score","kind":13,"containerName":"_add_exon"},{"line":246,"kind":13,"containerName":"_add_exon","name":"$coding_pot_score"},{"name":"$homol_score","kind":13,"containerName":"_add_exon","line":246},{"containerName":"_add_exon","kind":13,"name":"$exon_type","line":248},{"line":250,"name":"$strand","containerName":"_add_exon","localvar":"my","kind":13,"definition":"my"},{"name":"$exon_strand","containerName":"_add_exon","kind":13,"line":250},{"line":252,"kind":13,"localvar":"my","containerName":"_add_exon","name":"$exon","definition":"my"},{"line":252,"name":"new","kind":12,"containerName":"_add_exon"},{"name":"$SOURCE_TAG","containerName":"_add_exon","kind":13,"line":252},{"containerName":"_add_exon","kind":13,"name":"$exon_start","line":253},{"line":254,"name":"$exon_end","kind":13,"containerName":"_add_exon"},{"line":255,"name":"$strand","containerName":"_add_exon","kind":13},{"containerName":"_add_exon","kind":13,"name":"$exon_score","line":256},{"line":257,"containerName":"_add_exon","kind":13,"name":"$exon"},{"line":257,"kind":12,"containerName":"_add_exon","name":"is_coding"},{"line":258,"name":"$exon","containerName":"_add_exon","kind":13},{"line":258,"name":"add_tag_value","containerName":"_add_exon","kind":12},{"line":258,"kind":13,"containerName":"_add_exon","name":"$exon_type"},{"line":259,"containerName":"_add_exon","kind":13,"name":"$exon"},{"name":"add_tag_value","containerName":"_add_exon","kind":12,"line":259},{"line":259,"name":"$start_phase","kind":13,"containerName":"_add_exon"},{"line":260,"name":"$exon","containerName":"_add_exon","kind":13},{"line":260,"containerName":"_add_exon","kind":12,"name":"add_tag_value"},{"containerName":"_add_exon","kind":13,"name":"$end_phase","line":260},{"line":261,"containerName":"_add_exon","kind":13,"name":"$exon"},{"containerName":"_add_exon","kind":12,"name":"add_tag_value","line":261},{"line":261,"containerName":"_add_exon","kind":13,"name":"$start_sig_score"},{"kind":13,"containerName":"_add_exon","name":"$exon","line":262},{"name":"add_tag_value","kind":12,"containerName":"_add_exon","line":262},{"kind":13,"containerName":"_add_exon","name":"$end_sig_score","line":262},{"line":263,"kind":13,"containerName":"_add_exon","name":"$exon"},{"kind":12,"containerName":"_add_exon","name":"add_tag_value","line":263},{"line":263,"name":"$coding_pot_score","containerName":"_add_exon","kind":13},{"line":264,"name":"$exon","containerName":"_add_exon","kind":13},{"line":264,"name":"add_tag_value","kind":12,"containerName":"_add_exon"},{"kind":13,"containerName":"_add_exon","name":"$homol_score","line":264},{"line":266,"name":"$transcript","kind":13,"containerName":"_add_exon"},{"name":"strand","containerName":"_add_exon","kind":12,"line":266},{"line":266,"containerName":"_add_exon","kind":13,"name":"$strand"},{"name":"$transcript","kind":13,"containerName":"_add_exon","line":266},{"line":266,"kind":12,"containerName":"_add_exon","name":"strand"},{"line":267,"containerName":"_add_exon","kind":13,"name":"$transcript"},{"name":"add_exon","containerName":"_add_exon","kind":12,"line":267},{"line":267,"name":"$exon","kind":13,"containerName":"_add_exon"},{"line":267,"kind":13,"containerName":"_add_exon","name":"$exon_type"}],"signature":{"documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>\n\n\nsub new\n{\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    return $self;\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $geneid->next_prediction)\n           {\n               # do something\n           }\n Function: Returns the gene structure prediction of the geneid result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Gene::GeneStructure object\n Args    : None\n\n\nsub next_prediction\n{\n    my ($self) = @_;\n\n    my ($gene, $transcript, $current_gene_id);\n    my $transcript_score = 0;\n\n    my ($gene_id, $exon_type, $exon_start, $exon_end, $exon_score,\n        $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score);\n\n    while (defined($_ = $self->_readline))\n    {\n        $self->debug($_);\n\n        s/^\\s+//;\n        s/\\s+$//;\n\n        # We have a choice of geneid, gff or XML formats. The native\n        # geneid format has more information than gff. However, we\n        # then need to perform the hack of extracting the sequence ID\n        # from the header of the embedded Fasta file which comes after\n        # the exon data, as it is not stored elsewhere. Ack.\n        # the new version of geneID includes the sequence ID in a slightly\n        # different format and a new \"or\" statement was added below\n        # also removed \"unless defined $self->_target_id;\" inorder to continue\n        # generating new sequence IDs.\n        \n        if (/^>(\\S+)\\|GeneId/ or /^# Sequence (\\S+)/)\n        {\n            my $target_id = $1;\n            $self->_target_id($target_id);\n            next;\n        }\n\n        next unless (/(Single|First|Internal|Terminal)/);\n\n        my @fields = split(/\\s+/, $_);\n\n        # Grab gene_id from eol first as there are issues with\n        # inconsistent whitespace in the AA coords field\n        $gene_id = pop @fields;\n\n        ($exon_type, $exon_start, $exon_end, $exon_score,\n         $exon_strand, $start_phase, $end_phase, $start_sig_score,\n         $end_sig_score, $coding_pot_score, $homol_score) = @fields[0..10];\n\n        if (! defined $current_gene_id)\n        {\n            # Starting the requested prediction\n            $current_gene_id = $gene_id;\n            $transcript_score = $exon_score;\n\n            $gene = Bio::SeqFeature::Gene::GeneStructure->new(-source =>\n                                                              $SOURCE_TAG);\n            $transcript = Bio::SeqFeature::Gene::Transcript->new(-source =>\n                                                                 $SOURCE_TAG);\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        elsif ($gene_id eq $current_gene_id)\n        {\n            # Still in requested prediction\n            $transcript_score += $exon_score;\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        else\n        {\n            # Found following prediction\n            $self->_pushback($_);\n            last;\n        }\n    }\n\n    if (defined $gene)\n    {\n        $transcript->seq_id($self->_target_id);\n        $transcript->score($transcript_score);\n        $gene->add_transcript($transcript);\n        $gene->seq_id($self->_target_id);\n\n        foreach my $exon ($gene->exons)\n        {\n            $exon->seq_id($self->_target_id);\n        }\n\n        $self->_set_strand($gene);\n    }\n\n    return $gene;\n}\n\n=head2 _add_exon\n\n Title   : _add_exon\n Usage   : $obj->_add_exon($gene, $transcript, ... exon data ...)\n Function: Adds a new exon to both gene and transcript from the data\n         : supplied as args\n Example :\n Returns : Nothing","parameters":[{"label":"$self"},{"label":"$gene"},{"label":"$transcript"},{"label":"$exon_type"},{"label":"$exon_start"},{"label":"$exon_end"},{"label":"$exon_score"},{"label":"$exon_strand"},{"label":"$start_phase"},{"label":"$end_phase"},{"label":"$start_sig_score"},{"label":"$end_sig_score"},{"label":"$coding_pot_score"},{"label":"$homol_score"}],"label":"_add_exon($self,$gene,$transcript,$exon_type,$exon_start,$exon_end,$exon_score,$exon_strand,$start_phase,$end_phase,$start_sig_score,$end_sig_score,$coding_pot_score,$homol_score)"},"kind":12,"range":{"end":{"line":268,"character":9999},"start":{"line":242,"character":0}},"line":242},{"line":252,"containerName":"SeqFeature::Gene::Exon","kind":12,"name":"Bio"},{"definition":"sub","detail":"($self,$gene)","children":[{"definition":"my","line":284,"localvar":"my","containerName":"_set_strand","kind":13,"name":"$self"},{"line":284,"name":"$gene","kind":13,"containerName":"_set_strand"},{"localvar":"my","kind":13,"containerName":"_set_strand","name":"$fwd","line":286,"definition":"my"},{"line":287,"name":"$rev","containerName":"_set_strand","localvar":"my","kind":13,"definition":"my"},{"line":289,"name":"@exons","localvar":"my","containerName":"_set_strand","kind":13,"definition":"my"},{"containerName":"_set_strand","kind":13,"name":"$gene","line":289},{"name":"exons","containerName":"_set_strand","kind":12,"line":289},{"name":"$exon","kind":13,"localvar":"my","containerName":"_set_strand","line":290,"definition":"my"},{"containerName":"_set_strand","kind":13,"name":"@exons","line":290},{"line":292,"containerName":"_set_strand","localvar":"my","kind":13,"name":"$strand","definition":"my"},{"containerName":"_set_strand","kind":13,"name":"$exon","line":292},{"name":"strand","kind":12,"containerName":"_set_strand","line":292},{"name":"$strand","kind":13,"containerName":"_set_strand","line":294},{"line":296,"name":"$fwd","containerName":"_set_strand","kind":13},{"kind":13,"containerName":"_set_strand","name":"$strand","line":298},{"containerName":"_set_strand","kind":13,"name":"$rev","line":300},{"name":"$fwd","containerName":"_set_strand","kind":13,"line":304},{"name":"$gene","kind":13,"containerName":"_set_strand","line":306},{"line":306,"name":"strand","containerName":"_set_strand","kind":12},{"name":"$rev","containerName":"_set_strand","kind":13,"line":308},{"name":"$gene","containerName":"_set_strand","kind":13,"line":310},{"line":310,"kind":12,"containerName":"_set_strand","name":"strand"},{"containerName":"_set_strand","kind":13,"name":"$gene","line":314},{"line":314,"containerName":"_set_strand","kind":12,"name":"strand"},{"line":317,"name":"$gene","kind":13,"containerName":"_set_strand"}],"name":"_set_strand","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$gene"}],"documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>\n\n\nsub new\n{\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    return $self;\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $geneid->next_prediction)\n           {\n               # do something\n           }\n Function: Returns the gene structure prediction of the geneid result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Gene::GeneStructure object\n Args    : None\n\n\nsub next_prediction\n{\n    my ($self) = @_;\n\n    my ($gene, $transcript, $current_gene_id);\n    my $transcript_score = 0;\n\n    my ($gene_id, $exon_type, $exon_start, $exon_end, $exon_score,\n        $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score);\n\n    while (defined($_ = $self->_readline))\n    {\n        $self->debug($_);\n\n        s/^\\s+//;\n        s/\\s+$//;\n\n        # We have a choice of geneid, gff or XML formats. The native\n        # geneid format has more information than gff. However, we\n        # then need to perform the hack of extracting the sequence ID\n        # from the header of the embedded Fasta file which comes after\n        # the exon data, as it is not stored elsewhere. Ack.\n        # the new version of geneID includes the sequence ID in a slightly\n        # different format and a new \"or\" statement was added below\n        # also removed \"unless defined $self->_target_id;\" inorder to continue\n        # generating new sequence IDs.\n        \n        if (/^>(\\S+)\\|GeneId/ or /^# Sequence (\\S+)/)\n        {\n            my $target_id = $1;\n            $self->_target_id($target_id);\n            next;\n        }\n\n        next unless (/(Single|First|Internal|Terminal)/);\n\n        my @fields = split(/\\s+/, $_);\n\n        # Grab gene_id from eol first as there are issues with\n        # inconsistent whitespace in the AA coords field\n        $gene_id = pop @fields;\n\n        ($exon_type, $exon_start, $exon_end, $exon_score,\n         $exon_strand, $start_phase, $end_phase, $start_sig_score,\n         $end_sig_score, $coding_pot_score, $homol_score) = @fields[0..10];\n\n        if (! defined $current_gene_id)\n        {\n            # Starting the requested prediction\n            $current_gene_id = $gene_id;\n            $transcript_score = $exon_score;\n\n            $gene = Bio::SeqFeature::Gene::GeneStructure->new(-source =>\n                                                              $SOURCE_TAG);\n            $transcript = Bio::SeqFeature::Gene::Transcript->new(-source =>\n                                                                 $SOURCE_TAG);\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        elsif ($gene_id eq $current_gene_id)\n        {\n            # Still in requested prediction\n            $transcript_score += $exon_score;\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        else\n        {\n            # Found following prediction\n            $self->_pushback($_);\n            last;\n        }\n    }\n\n    if (defined $gene)\n    {\n        $transcript->seq_id($self->_target_id);\n        $transcript->score($transcript_score);\n        $gene->add_transcript($transcript);\n        $gene->seq_id($self->_target_id);\n\n        foreach my $exon ($gene->exons)\n        {\n            $exon->seq_id($self->_target_id);\n        }\n\n        $self->_set_strand($gene);\n    }\n\n    return $gene;\n}\n\n=head2 _add_exon\n\n Title   : _add_exon\n Usage   : $obj->_add_exon($gene, $transcript, ... exon data ...)\n Function: Adds a new exon to both gene and transcript from the data\n         : supplied as args\n Example :\n Returns : Nothing\n\n\nsub _add_exon\n{\n    my ($self, $gene, $transcript, $exon_type, $exon_start, $exon_end,\n        $exon_score, $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score) = @_;\n\n    $exon_type =~ s/First/Initial/;\n\n    my $strand = $exon_strand eq '+' ? 1 : -1;\n\n    my $exon = Bio::SeqFeature::Gene::Exon->new(-source => $SOURCE_TAG,\n                                                -start  => $exon_start,\n                                                -end    => $exon_end,\n                                                -strand => $strand,\n                                                -score  => $exon_score);\n    $exon->is_coding(1);\n    $exon->add_tag_value(\"Type\", $exon_type);\n    $exon->add_tag_value('phase', $start_phase);\n    $exon->add_tag_value('end_phase', $end_phase);\n    $exon->add_tag_value('start_signal_score', $start_sig_score);\n    $exon->add_tag_value('end_signal_score', $end_sig_score);\n    $exon->add_tag_value('coding_potential_score', $coding_pot_score);\n    $exon->add_tag_value('homology_score', $homol_score);\n\n    $transcript->strand($strand) unless $transcript->strand != 0;\n    $transcript->add_exon($exon, $exon_type);\n}\n\n=head2 _set_strand\n\n Title   : _set_strand\n Usage   : $obj->_set_strand($gene)\n Function: Sets the overall gene strand to the same strand as all\n         : the exons if they are all on the same strand, or to strand 0\n         : if the exons are on different strands.\n Example :\n Returns : Nothing","label":"_set_strand($self,$gene)"},"line":282,"range":{"end":{"character":9999,"line":318},"start":{"character":0,"line":282}},"kind":12},{"kind":12,"name":"exons","line":304},{"kind":12,"name":"exons","line":308},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_target_id","name":"$self","line":332},{"name":"$val","containerName":"_target_id","kind":13,"line":332},{"containerName":"_target_id","kind":13,"name":"$val","line":333},{"line":335,"kind":13,"containerName":"_target_id","name":"$self"},{"line":335,"name":"$val","kind":13,"containerName":"_target_id"},{"line":338,"name":"$self","kind":13,"containerName":"_target_id"}],"containerName":"main::","name":"_target_id","definition":"sub","detail":"($self,$val)","line":330,"kind":12,"range":{"start":{"character":0,"line":330},"end":{"character":9999,"line":339}},"signature":{"label":"_target_id($self,$val)","documentation":"1;\n# $Id: Geneid.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Keith James\n#\n# Copyright Genome Research Ltd.\n#\n# You may distribute this module under the same terms as Perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Geneid - Results of one geneid run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Geneid;\n  my $gid = Bio::Tools::Geneid(-file => \"geneid.out\");\n\n  while (my $gene = $gid->next_prediction)\n  {\n    my @transcripts = $gene->transcripts;\n      foreach my $t (@transcripts)\n      {\n        my @exons = $t->exons;\n        foreach my $e (@exons)\n        {\n          printf(\"Exon %d..%d\\n\", $e->start, $e->end);\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of geneid by Enrique Blanco and\nRoderic Guig\u00f3 (IMIM-UPF). See http://www1.imim.es/software/geneid. It\nrelies on native geneid output format internally and will work with\ngeneid versions 1.0 and 1.1. Currently this module supports only the\ndefault mode of operation which is to predict exons and assemble an\noptimal gene prediction.\n\nIt takes either a file handle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Keith James\n\n Email: kdj@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Geneid;\n\nuse vars qw($SOURCE_TAG);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n$SOURCE_TAG = 'geneid';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file = \"<geneid.out\");\n           $obj->new(-fh => \\*GI);\n Function: Constructor for geneid wrapper. Takes either a file\n         : or filehandle\n Returns : L<Bio::Tools::Geneid>\n\n\nsub new\n{\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n    return $self;\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $geneid->next_prediction)\n           {\n               # do something\n           }\n Function: Returns the gene structure prediction of the geneid result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::SeqFeature::Gene::GeneStructure object\n Args    : None\n\n\nsub next_prediction\n{\n    my ($self) = @_;\n\n    my ($gene, $transcript, $current_gene_id);\n    my $transcript_score = 0;\n\n    my ($gene_id, $exon_type, $exon_start, $exon_end, $exon_score,\n        $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score);\n\n    while (defined($_ = $self->_readline))\n    {\n        $self->debug($_);\n\n        s/^\\s+//;\n        s/\\s+$//;\n\n        # We have a choice of geneid, gff or XML formats. The native\n        # geneid format has more information than gff. However, we\n        # then need to perform the hack of extracting the sequence ID\n        # from the header of the embedded Fasta file which comes after\n        # the exon data, as it is not stored elsewhere. Ack.\n        # the new version of geneID includes the sequence ID in a slightly\n        # different format and a new \"or\" statement was added below\n        # also removed \"unless defined $self->_target_id;\" inorder to continue\n        # generating new sequence IDs.\n        \n        if (/^>(\\S+)\\|GeneId/ or /^# Sequence (\\S+)/)\n        {\n            my $target_id = $1;\n            $self->_target_id($target_id);\n            next;\n        }\n\n        next unless (/(Single|First|Internal|Terminal)/);\n\n        my @fields = split(/\\s+/, $_);\n\n        # Grab gene_id from eol first as there are issues with\n        # inconsistent whitespace in the AA coords field\n        $gene_id = pop @fields;\n\n        ($exon_type, $exon_start, $exon_end, $exon_score,\n         $exon_strand, $start_phase, $end_phase, $start_sig_score,\n         $end_sig_score, $coding_pot_score, $homol_score) = @fields[0..10];\n\n        if (! defined $current_gene_id)\n        {\n            # Starting the requested prediction\n            $current_gene_id = $gene_id;\n            $transcript_score = $exon_score;\n\n            $gene = Bio::SeqFeature::Gene::GeneStructure->new(-source =>\n                                                              $SOURCE_TAG);\n            $transcript = Bio::SeqFeature::Gene::Transcript->new(-source =>\n                                                                 $SOURCE_TAG);\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        elsif ($gene_id eq $current_gene_id)\n        {\n            # Still in requested prediction\n            $transcript_score += $exon_score;\n\n            $self->_add_exon($gene, $transcript, $exon_type, $exon_start, $exon_end, $exon_score,\n                             $exon_strand, $start_phase, $end_phase, $start_sig_score,\n                             $end_sig_score, $coding_pot_score, $homol_score);\n        }\n        else\n        {\n            # Found following prediction\n            $self->_pushback($_);\n            last;\n        }\n    }\n\n    if (defined $gene)\n    {\n        $transcript->seq_id($self->_target_id);\n        $transcript->score($transcript_score);\n        $gene->add_transcript($transcript);\n        $gene->seq_id($self->_target_id);\n\n        foreach my $exon ($gene->exons)\n        {\n            $exon->seq_id($self->_target_id);\n        }\n\n        $self->_set_strand($gene);\n    }\n\n    return $gene;\n}\n\n=head2 _add_exon\n\n Title   : _add_exon\n Usage   : $obj->_add_exon($gene, $transcript, ... exon data ...)\n Function: Adds a new exon to both gene and transcript from the data\n         : supplied as args\n Example :\n Returns : Nothing\n\n\nsub _add_exon\n{\n    my ($self, $gene, $transcript, $exon_type, $exon_start, $exon_end,\n        $exon_score, $exon_strand, $start_phase, $end_phase, $start_sig_score,\n        $end_sig_score, $coding_pot_score, $homol_score) = @_;\n\n    $exon_type =~ s/First/Initial/;\n\n    my $strand = $exon_strand eq '+' ? 1 : -1;\n\n    my $exon = Bio::SeqFeature::Gene::Exon->new(-source => $SOURCE_TAG,\n                                                -start  => $exon_start,\n                                                -end    => $exon_end,\n                                                -strand => $strand,\n                                                -score  => $exon_score);\n    $exon->is_coding(1);\n    $exon->add_tag_value(\"Type\", $exon_type);\n    $exon->add_tag_value('phase', $start_phase);\n    $exon->add_tag_value('end_phase', $end_phase);\n    $exon->add_tag_value('start_signal_score', $start_sig_score);\n    $exon->add_tag_value('end_signal_score', $end_sig_score);\n    $exon->add_tag_value('coding_potential_score', $coding_pot_score);\n    $exon->add_tag_value('homology_score', $homol_score);\n\n    $transcript->strand($strand) unless $transcript->strand != 0;\n    $transcript->add_exon($exon, $exon_type);\n}\n\n=head2 _set_strand\n\n Title   : _set_strand\n Usage   : $obj->_set_strand($gene)\n Function: Sets the overall gene strand to the same strand as all\n         : the exons if they are all on the same strand, or to strand 0\n         : if the exons are on different strands.\n Example :\n Returns : Nothing\n\n\nsub _set_strand\n{\n    my ($self, $gene) = @_;\n\n    my $fwd = 0;\n    my $rev = 0;\n\n    my @exons = $gene->exons;\n    foreach my $exon (@exons)\n    {\n        my $strand = $exon->strand;\n\n        if ($strand == 1)\n        {\n            $fwd++;\n        }\n        elsif ($strand == -1)\n        {\n            $rev++;\n        }\n    }\n\n    if ($#exons == $fwd)\n    {\n        $gene->strand(1);\n    }\n    elsif ($#exons == $rev)\n    {\n        $gene->strand(-1);\n    }\n    else\n    {\n        $gene->strand(0);\n    }\n\n    return $gene;\n}\n\n=head2 _target_id\n\n Title   : _target_id\n Usage   : $obj->_target_id\n Function: get/set for genomic sequence id\n Example :\n Returns : A target ID","parameters":[{"label":"$self"},{"label":"$val"}]}}]}