{"vars":[{"kind":2,"containerName":"","name":"base","line":96},{"children":[{"localvar":"my","containerName":"new","kind":13,"name":"$class","line":112,"definition":"my"},{"line":112,"kind":13,"containerName":"new","name":"@args"},{"line":113,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":113},{"name":"@args","kind":13,"containerName":"new","line":113},{"line":114,"name":"$eutil","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"new","name":"$self","line":114},{"line":114,"containerName":"new","kind":12,"name":"_rearrange"},{"name":"@args","kind":13,"containerName":"new","line":114},{"line":115,"name":"$eutil","containerName":"new","kind":13},{"line":116,"containerName":"new","kind":13,"name":"$self"},{"line":116,"name":"eutil","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$eutil","line":116},{"containerName":"new","kind":13,"name":"$self","line":117},{"line":117,"name":"datatype","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$self","line":118}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":111,"range":{"start":{"character":0,"line":111},"end":{"line":119,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: LinkInfo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Info::LinkInfo\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n# \n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Info::LinkInfo - class for storing einfo link data \n\n=head1 SYNOPSIS\n\n    ## should not create instance directly; Bio::Tools::EUtilities does this ##\n\n    # get a LinkInfo object using Bio:Tools::EUtilities    \n    print \"Link name: \",$link->get_link_name,\"\\n\";\n    print \"Link name: \",$link->get_link_menu_name,\"\\n\";\n    print \"Link desc: \",$link->get_link_description,\"\\n\";\n    print \"DBFrom: \",$link->get_dbfrom,\"\\n\"; # database linked from\n    print \"DBTo: \",$link->get_dbto,\"\\n\"; # database linked to\n\n=head1 DESCRIPTION\n\nThis class handles data output (XML) from einfo and elink.\n\neinfo is capable of returning two types of information: 1) a list of all\navailable databases (when called w/o parameters) and 2) information about a\nspecific database. The latter information includes the database description,\nrecord count, and date/time stamp for the last update, among other things. It\nalso includes a list of fields (indices by which record data is stored which can\nbe used in queries) and links (crossrefs between related records in other\ndatabases at NCBI). Data from the latter two are stored in two small subclasses\n(Field and Link) which can be iterated through or retrieved all at once, as\ndemonstrated above. NOTE: Methods described for the Link and Field subclasses\nare unique to those classes (as they retrieve data unique to those data types). \n\nFurther documentation for Link and Field subclass methods is included below.\n\nFor more information on einfo see:\n\n   http://eutils.ncbi.nlm.nih.gov/entrez/query/static/einfo_help.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other Bioperl\nmodules. Send your comments and suggestions preferably to one of the Bioperl\nmailing lists. Your participation is much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track the bugs\nand their resolution. Bug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Info::LinkInfo;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\nuse strict;\nuse warnings;\n\n=head2 new\n\n Title    : new\n Note     : *** should not be called by end-users ***  \n Usage    : my $ct = Bio::Tools::EUtilities::Info::LinkInfo;\n Function : returns new LinkInfo instance\n Returns  : Bio::Tools::EUtilities::Info::LinkInfo instance\n Args     : none (all data added via _add_data, most methods are getters only)","label":"new($class,@args)"}},{"kind":2,"containerName":"","name":"warnings","line":112},{"kind":12,"containerName":"new","name":"SUPER","line":113},{"line":133,"kind":12,"range":{"start":{"character":0,"line":133},"end":{"line":135,"character":9999}},"definition":"sub","children":[],"containerName":"main::","name":"get_database"},{"range":{"start":{"character":0,"line":141},"end":{"character":9999,"line":143}},"kind":12,"line":141,"containerName":"main::","name":"get_db","children":[{"line":142,"kind":12,"containerName":"get_db","name":"get_database"}],"definition":"sub"},{"children":[{"line":150,"kind":12,"containerName":"get_dbto","name":"get_database"}],"containerName":"main::","name":"get_dbto","definition":"sub","line":149,"range":{"end":{"character":9999,"line":151},"start":{"line":149,"character":0}},"kind":12},{"range":{"start":{"line":164,"character":0},"end":{"character":9999,"line":164}},"kind":12,"line":164,"name":"get_dbfrom","containerName":"main::","children":[],"definition":"sub"},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"get_link_name","line":177},{"name":"$self","containerName":"get_link_name","kind":13,"line":178},{"line":178,"name":"eutil","containerName":"get_link_name","kind":12},{"name":"$self","kind":13,"containerName":"get_link_name","line":179},{"line":181,"name":"$self","kind":13,"containerName":"get_link_name"}],"containerName":"main::","name":"get_link_name","definition":"sub","line":176,"range":{"end":{"line":183,"character":9999},"start":{"line":176,"character":0}},"kind":12},{"range":{"start":{"character":0,"line":195},"end":{"line":195,"character":9999}},"kind":12,"line":195,"definition":"sub","containerName":"main::","name":"get_link_description","children":[]},{"line":207,"range":{"end":{"character":9999,"line":210},"start":{"line":207,"character":0}},"kind":12,"children":[{"kind":13,"localvar":"my","containerName":"get_link_menu_name","name":"$self","line":208,"definition":"my"},{"containerName":"get_link_menu_name","kind":13,"name":"$self","line":209},{"kind":12,"containerName":"get_link_menu_name","name":"eutil","line":209},{"kind":13,"containerName":"get_link_menu_name","name":"$self","line":209},{"containerName":"get_link_menu_name","kind":13,"name":"$self","line":209}],"name":"get_link_menu_name","containerName":"main::","definition":"sub"},{"kind":12,"range":{"start":{"line":223,"character":0},"end":{"character":9999,"line":223}},"line":223,"containerName":"main::","name":"get_priority","children":[],"definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":236},"start":{"line":236,"character":0}},"line":236,"definition":"sub","containerName":"main::","name":"get_html_tag","children":[]},{"children":[],"name":"get_url","containerName":"main::","definition":"sub","line":250,"range":{"start":{"character":0,"line":250},"end":{"character":9999,"line":250}},"kind":12},{"definition":"sub","detail":"($self,$simple)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_add_data","name":"$self","line":255},{"name":"$simple","containerName":"_add_data","kind":13,"line":255},{"name":"$self","containerName":"_add_data","kind":13,"line":256},{"name":"$simple","kind":13,"containerName":"_add_data","line":256},{"containerName":"_add_data","kind":13,"name":"$simple","line":256},{"line":256,"name":"$simple","containerName":"_add_data","kind":13}],"name":"_add_data","containerName":"main::","signature":{"documentation":" private method","parameters":[{"label":"$self"},{"label":"$simple"}],"label":"_add_data($self,$simple)"},"line":254,"kind":12,"range":{"end":{"character":9999,"line":257},"start":{"character":0,"line":254}}},{"children":[{"name":"$self","localvar":"my","containerName":"to_string","kind":13,"line":271,"definition":"my"},{"definition":"my","line":272,"name":"$level","kind":13,"localvar":"my","containerName":"to_string"},{"line":273,"containerName":"to_string","localvar":"my","kind":13,"name":"$pad","definition":"my"},{"name":"$level","kind":13,"containerName":"to_string","line":273},{"definition":"my","name":"%tags","localvar":"my","kind":13,"containerName":"to_string","line":275},{"definition":"my","localvar":"my","kind":13,"containerName":"to_string","name":"$string","line":284},{"containerName":"to_string","localvar":"my","kind":13,"name":"$tag","line":285,"definition":"my"},{"containerName":"to_string","kind":13,"name":"$a","line":285},{"containerName":"to_string","kind":13,"name":"$b","line":285},{"name":"%tags","kind":13,"containerName":"to_string","line":285},{"definition":"my","name":"$m","kind":13,"localvar":"my","containerName":"to_string","line":286},{"line":286,"kind":13,"containerName":"to_string","name":"$nm"},{"line":286,"kind":13,"containerName":"to_string","name":"$tags"},{"line":286,"name":"$tag","containerName":"to_string","kind":13},{"line":286,"containerName":"to_string","kind":13,"name":"$tags"},{"kind":13,"containerName":"to_string","name":"$tag","line":286},{"line":287,"localvar":"my","kind":13,"containerName":"to_string","name":"$content","definition":"my"},{"name":"$self","containerName":"to_string","kind":13,"line":287},{"name":"$m","kind":13,"containerName":"to_string","line":287},{"line":288,"name":"$content","kind":13,"containerName":"to_string"},{"line":289,"kind":13,"containerName":"to_string","name":"$string"},{"line":290,"name":"$level","containerName":"to_string","kind":13},{"line":291,"kind":13,"containerName":"to_string","name":"$pad"},{"name":"$nm","kind":13,"containerName":"to_string","line":291},{"name":"$self","containerName":"to_string","kind":13,"line":292},{"kind":12,"containerName":"to_string","name":"_text_wrap","line":292},{"name":"$pad","kind":13,"containerName":"to_string","line":293},{"line":294,"kind":13,"containerName":"to_string","name":"$content"},{"kind":13,"containerName":"to_string","name":"$string","line":296}],"containerName":"main::","name":"to_string","definition":"sub","line":270,"kind":12,"range":{"start":{"line":270,"character":0},"end":{"line":297,"character":9999}}}],"version":5}