{"version":5,"vars":[{"containerName":"strict::Bio::Tools::Analysis::Protein::Domcut::IO::String::Bio::SeqIO::HTTP::Request","kind":2,"name":"Common","line":162},{"containerName":"","kind":2,"name":"base","line":166},{"line":168,"containerName":null,"localvar":"my","kind":13,"name":"$URL","definition":"my"},{"name":"$ANALYSIS_NAME","containerName":null,"localvar":"my","kind":13,"line":169,"definition":"my"},{"line":170,"localvar":"my","kind":13,"containerName":null,"name":"%ANALYSIS_SPEC","definition":"my"},{"definition":"my","name":"@INPUT_SPEC","kind":13,"localvar":"my","containerName":null,"line":183},{"definition":"my","name":"%RESULT_SPEC","kind":13,"localvar":"my","containerName":null,"line":192},{"signature":{"label":"result($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Domcut.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Domcut\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Domcut -  a wrapper around Domcut server\n\n=head1  SYNOPSIS\n\n  use   Bio::Tools::Analysis::Protein::Domcut;\n  #get a  Bio::PrimarySeq\n  use Bio::PrimarySeq;\n  my $seq = Bio::PrimarySeq->new\n     (-seq=>'IKLCVNLAILAKAHLIELALAL',\n     -primary_id=>'test'); # a Bio::PrimarySeqI object\n\n  my $domcut = Bio::Tools::Analysis::Protein::Domcut->new (-seq=>$seq);\n  $domcut->run;\n  print $domcut->result;# #raw text to standard out\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein domain\nboundaries.  Each residue in the protein receives a score, those\nbetter than the significance threshold and at a local minimum receive\na rank - i.e., the best minimum is rank 1, the second best minimum is\nrank2 etc. These correspond to domain boundaries.  e.g.,\n\n  my $analysis_object = Bio::Tools::Analysis::Protein::Domcut->new\n     (-seq => $seq);\n\ncreates a new object. The sequence supplied must be a Bio::PrimarySeq and not\na Bio::Seq object. \n\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output\n\nGiven an amino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method\n\n=over 4\n\n* 1\n\nThe raw text of the program output\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state. Each element in the array is a residue (indexed from 0).\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices.\nSo, in order to add features to an existing Bio::Seq object;\n\n  # get a Bio::Seq object\n  my $seqobj;\n  my $tool = Bio::Tools::Analysis::Protein::Domcut->new\n      ( -seq => $seqobj->primary_seq);\n  $tool->run;\n\n  my @fts = $tool->result(Bio::SeqFeatureI);\n\n  $seqobj->add_SeqFeature(@fts);\n\n  # if you want  meta sequences as well :\n  my $meta = $tool->result('meta');\n  $seqobj->primary_seq($meta);\n\n  # can access meta data in a Bio::Seq object via a \n  # call to primary_seq:\n\n  print $seq4->primary_seq->named_submeta_text('Domcut', 1,2), \"\\n\";\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence. In this case, the sequence can be associated with a\nsingle array of Domcut prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->submeta_text(10,20), \"\\n\";\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>, \nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n\nuse strict;\npackage Bio::Tools::Analysis::Protein::Domcut;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(GET);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\nmy $URL = 'http://www.Bork.EMBL-Heidelberg.DE/Docu/mikita/domplot.cgi?';\nmy $ANALYSIS_NAME = 'Domcut';\nmy $ANALYSIS_SPEC =\n    {\n     'name'        => 'Domcut',\n     'type'        => 'protein', #compulsory entry as is used for seq checking\n     'version'     => 'n/a',\n     'supplier'    => 'Ohara lab, Laboratory of DNA technology, \n                       Kazusa DNA Research Institute, 1532-3 Yana,\n                       Kisarazu, Japan',\n     'description' => 'to predict domain boundaries in proteins',\n     'reference'   => 'Bioinformatics 19, 673-674 (2003)',\n    };\n\n\nmy $INPUT_SPEC =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',\n     },\n    ];\n\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'parsed'           => \"Array of {'score' =>, 'rank'=> ]\",\n     'meta'             => 'Bio::Seq::Meta::Array object'\n    };\n\n=head2 result\n\n Name    : result\n Purpose : To retrieve results of analysis in one of several formats.\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : various - see keysin $RESULT_SPEC. \n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>. Tagnames are 'score' \nand 'rank'.\n\n* 'parsed'\n\nArray of array references of [score, rank].\n\n* 'all'\n\nA Bio::Seq::Meta::Array object. Scores can be accessed using methods\nfrom this class. Meta sequence name is Domcut."},"range":{"end":{"line":332,"character":9999},"start":{"character":0,"line":241}},"kind":12,"line":241,"detail":"($self,$value)","definition":"sub","name":"result","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"result","kind":13,"name":"$self","line":242},{"name":"$value","kind":13,"containerName":"result","line":242},{"line":243,"localvar":"my","containerName":"result","kind":13,"name":"@scores","definition":"my"},{"definition":"my","line":244,"name":"@fts","localvar":"my","kind":13,"containerName":"result"},{"name":"$value","kind":13,"containerName":"result","line":246},{"line":248,"kind":13,"containerName":"result","name":"$self"},{"line":249,"containerName":"result","localvar":"my","kind":13,"name":"$result","definition":"my"},{"line":249,"kind":12,"containerName":"result","name":"new"},{"line":249,"name":"$self","containerName":"result","kind":13},{"name":"$line","kind":13,"localvar":"my","containerName":"result","line":250,"definition":"my"},{"containerName":"result","kind":13,"name":"$result","line":250},{"name":"$line","kind":13,"containerName":"result","line":251},{"name":"$line","containerName":"result","kind":13,"line":252},{"line":253,"containerName":"result","kind":13,"name":"@scores"},{"line":258,"name":"$self","containerName":"result","kind":13},{"kind":13,"containerName":"result","name":"@scores","line":258},{"name":"$value","containerName":"result","kind":13,"line":261},{"localvar":"my","kind":13,"containerName":"result","name":"$i","line":262,"definition":"my"},{"definition":"my","line":263,"containerName":"result","localvar":"my","kind":13,"name":"$in_trough"},{"containerName":"result","localvar":"my","kind":13,"name":"$st","line":264,"definition":"my"},{"kind":13,"containerName":"result","name":"$end","line":264},{"kind":13,"containerName":"result","name":"$rank","line":264},{"line":264,"name":"$min_score","containerName":"result","kind":13},{"line":264,"name":"$min_locus","containerName":"result","kind":13},{"localvar":"my","containerName":"result","kind":13,"name":"$seqlen","line":265,"definition":"my"},{"containerName":"result","kind":13,"name":"$self","line":265},{"line":265,"containerName":"result","kind":12,"name":"seq"},{"line":265,"name":"length","kind":12,"containerName":"result"},{"definition":"my","name":"$score","kind":13,"localvar":"my","containerName":"result","line":266},{"line":266,"kind":13,"containerName":"result","name":"$self"},{"line":269,"name":"$in_trough","kind":13,"containerName":"result"},{"name":"$score","containerName":"result","kind":13,"line":269},{"line":270,"containerName":"result","kind":13,"name":"$in_trough"},{"line":271,"containerName":"result","kind":13,"name":"$st"},{"containerName":"result","kind":13,"name":"$i","line":271},{"line":275,"name":"$in_trough","containerName":"result","kind":13},{"kind":13,"containerName":"result","name":"$score","line":275},{"name":"$i","kind":13,"containerName":"result","line":275},{"line":275,"containerName":"result","kind":13,"name":"$seqlen"},{"line":276,"name":"$score","containerName":"result","kind":13},{"kind":13,"containerName":"result","name":"$rank","line":277},{"line":277,"kind":13,"containerName":"result","name":"$score"},{"kind":13,"containerName":"result","name":"$min_score","line":278},{"line":278,"name":"$score","containerName":"result","kind":13},{"kind":13,"containerName":"result","name":"$min_locus","line":279},{"name":"$i","kind":13,"containerName":"result","line":279},{"line":285,"name":"$in_trough","kind":13,"containerName":"result"},{"line":285,"kind":13,"containerName":"result","name":"$score"},{"line":286,"name":"$i","kind":13,"containerName":"result"},{"name":"$seqlen","containerName":"result","kind":13,"line":286},{"name":"$rank","kind":13,"containerName":"result","line":287},{"containerName":"result","kind":13,"name":"@fts","line":288},{"line":288,"name":"new","kind":12,"containerName":"result"},{"kind":13,"containerName":"result","name":"$st","line":289},{"line":290,"name":"$i","containerName":"result","kind":13},{"line":294,"name":"$min_score","containerName":"result","kind":13},{"name":"$rank","containerName":"result","kind":13,"line":295},{"name":"$min_locus","kind":13,"containerName":"result","line":296},{"name":"$st","containerName":"result","kind":13,"line":301},{"kind":13,"containerName":"result","name":"$in_trough","line":301},{"name":"$min_locus","kind":13,"containerName":"result","line":301},{"line":301,"name":"$min_score","containerName":"result","kind":13},{"kind":13,"containerName":"result","name":"$rank","line":301},{"containerName":"result","kind":13,"name":"$i","line":303},{"name":"@fts","kind":13,"containerName":"result","line":305},{"name":"$value","containerName":"result","kind":13,"line":308},{"line":311,"kind":13,"containerName":"result","name":"$self"},{"line":311,"name":"seq","kind":12,"containerName":"result"},{"line":311,"containerName":"result","kind":12,"name":"isa"},{"line":312,"name":"$self","kind":13,"containerName":"result"},{"name":"seq","containerName":"result","kind":12,"line":312},{"line":314,"containerName":"result","kind":13,"name":"$self"},{"line":314,"name":"seq","containerName":"result","kind":12},{"name":"isa","kind":12,"containerName":"result","line":314},{"name":"$self","containerName":"result","kind":13,"line":315},{"kind":12,"containerName":"result","name":"throw","line":315},{"definition":"my","name":"$meta_name","localvar":"my","containerName":"result","kind":13,"line":316},{"kind":13,"containerName":"result","name":"$meta_name","line":319},{"containerName":"result","kind":13,"name":"$self","line":319},{"name":"seq","kind":12,"containerName":"result","line":319},{"name":"meta_names","kind":12,"containerName":"result","line":319},{"kind":13,"containerName":"result","name":"$self","line":320},{"name":"warn","containerName":"result","kind":12,"line":320},{"containerName":"result","kind":13,"name":"$Bio","line":325},{"localvar":"my","containerName":"result","kind":13,"name":"@meta","line":326,"definition":"my"},{"name":"$self","containerName":"result","kind":13,"line":326},{"kind":13,"containerName":"result","name":"$self","line":327},{"kind":12,"containerName":"result","name":"seq","line":327},{"line":327,"kind":12,"containerName":"result","name":"named_meta"},{"name":"$meta_name","kind":13,"containerName":"result","line":327},{"line":327,"name":"@meta","kind":13,"containerName":"result"},{"line":330,"containerName":"result","kind":13,"name":"$self"},{"name":"seq","containerName":"result","kind":12,"line":330}]},{"line":249,"containerName":"String","kind":12,"name":"IO"},{"line":253,"name":"score","kind":12},{"line":254,"kind":12,"name":"rank"},{"line":288,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"line":294,"name":"score","kind":12},{"line":295,"kind":12,"name":"rank"},{"name":"residue","kind":12,"line":296},{"containerName":"Meta::Array::DEFAULT_NAME","kind":12,"name":"Seq","line":325},{"containerName":null,"kind":13,"name":"%value","line":334},{"name":"%self","containerName":null,"kind":13,"line":335},{"line":339,"containerName":null,"kind":13,"name":"%self"},{"line":342,"kind":12,"range":{"end":{"line":350,"character":9999},"start":{"line":342,"character":0}},"children":[{"line":343,"localvar":"my","containerName":"_init","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"_init","line":344},{"name":"url","kind":12,"containerName":"_init","line":344},{"kind":13,"containerName":"_init","name":"$URL","line":344},{"containerName":"_init","kind":13,"name":"$self","line":345},{"line":345,"kind":13,"containerName":"_init","name":"$ANALYSIS_SPEC"},{"line":346,"kind":13,"containerName":"_init","name":"$self"},{"line":346,"name":"$INPUT_SPEC","kind":13,"containerName":"_init"},{"line":347,"name":"$self","kind":13,"containerName":"_init"},{"line":347,"name":"$RESULT_SPEC","kind":13,"containerName":"_init"},{"line":348,"containerName":"_init","kind":13,"name":"$self"},{"line":348,"kind":13,"containerName":"_init","name":"$ANALYSIS_NAME"},{"containerName":"_init","kind":13,"name":"$self","line":349}],"containerName":"main::","name":"_init","definition":"sub"},{"line":352,"range":{"end":{"line":366,"character":9999},"start":{"character":0,"line":352}},"kind":12,"children":[{"definition":"my","line":353,"containerName":"_run","localvar":"my","kind":13,"name":"$self"},{"line":354,"name":"$seq_fasta","containerName":"_run","localvar":"my","kind":13,"definition":"my"},{"line":354,"name":"$self","kind":13,"containerName":"_run"},{"name":"seq","containerName":"_run","kind":12,"line":354},{"kind":12,"containerName":"_run","name":"seq","line":354},{"name":"$self","containerName":"_run","kind":13,"line":355},{"line":355,"name":"delay","kind":12,"containerName":"_run"},{"name":"$self","containerName":"_run","kind":13,"line":357},{"name":"sleep","kind":12,"containerName":"_run","line":357},{"line":358,"kind":13,"containerName":"_run","name":"$self"},{"line":358,"name":"status","containerName":"_run","kind":12},{"name":"$rqst","localvar":"my","kind":13,"containerName":"_run","line":359,"definition":"my"},{"line":359,"name":"$self","containerName":"_run","kind":13},{"line":359,"containerName":"_run","kind":12,"name":"url"},{"kind":13,"containerName":"_run","name":"$seq_fasta","line":360},{"line":362,"name":"$content","containerName":"_run","localvar":"my","kind":13,"definition":"my"},{"line":362,"containerName":"_run","kind":13,"name":"$self"},{"line":362,"name":"request","containerName":"_run","kind":12},{"line":362,"kind":13,"containerName":"_run","name":"$rqst"},{"name":"$text","containerName":"_run","localvar":"my","kind":13,"line":363,"definition":"my"},{"line":363,"kind":13,"containerName":"_run","name":"$content"},{"name":"content","kind":12,"containerName":"_run","line":363},{"line":364,"kind":13,"containerName":"_run","name":"$self"},{"containerName":"_run","kind":13,"name":"$text","line":364},{"line":365,"containerName":"_run","kind":13,"name":"$self"},{"kind":12,"containerName":"_run","name":"status","line":365},{"kind":13,"containerName":"_run","name":"$text","line":365}],"name":"_run","containerName":"main::","definition":"sub"},{"line":359,"kind":12,"name":"GET"}]}