{"vars":[{"line":54,"name":"vars","containerName":"","kind":2},{"line":59,"containerName":"","kind":2,"name":"base"},{"containerName":null,"kind":13,"name":"$CREATIONORDER","line":62},{"range":{"end":{"character":9999,"line":113},"start":{"character":0,"line":81}},"kind":12,"line":81,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n' for emacs","parameters":[{"label":"$class"},{"label":"@args"}]},"name":"new","containerName":"main::","children":[{"name":"$class","containerName":"new","localvar":"my","kind":13,"line":82,"definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":82},{"definition":"my","line":84,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"line":84,"kind":13,"containerName":"new","name":"$class"},{"line":84,"name":"@args","containerName":"new","kind":13},{"line":85,"kind":13,"containerName":"new","name":"$self"},{"line":85,"name":"warn","containerName":"new","kind":12},{"definition":"my","line":87,"name":"$children","containerName":"new","localvar":"my","kind":13},{"containerName":"new","kind":13,"name":"$branchlen","line":87},{"containerName":"new","kind":13,"name":"$id","line":87},{"name":"$taxon","kind":13,"containerName":"new","line":87},{"line":87,"containerName":"new","kind":13,"name":"$rank"},{"containerName":"new","kind":13,"name":"$desc","line":87},{"line":89,"name":"$self","kind":13,"containerName":"new"},{"line":89,"name":"_rearrange","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":94},{"line":96,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$desc","line":97},{"containerName":"new","kind":13,"name":"$self","line":97},{"kind":12,"containerName":"new","name":"description","line":97},{"kind":13,"containerName":"new","name":"$desc","line":97},{"kind":13,"containerName":"new","name":"$taxon","line":98},{"line":98,"kind":13,"containerName":"new","name":"$self"},{"line":98,"name":"taxon","kind":12,"containerName":"new"},{"line":98,"kind":13,"containerName":"new","name":"$taxon"},{"line":99,"name":"$id","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":99},{"name":"id","kind":12,"containerName":"new","line":99},{"line":99,"kind":13,"containerName":"new","name":"$id"},{"containerName":"new","kind":13,"name":"$branchlen","line":100},{"name":"$self","containerName":"new","kind":13,"line":100},{"line":100,"kind":12,"containerName":"new","name":"branch_length"},{"containerName":"new","kind":13,"name":"$branchlen","line":100},{"containerName":"new","kind":13,"name":"$rank","line":101},{"kind":13,"containerName":"new","name":"$self","line":101},{"line":101,"containerName":"new","kind":12,"name":"rank"},{"line":101,"name":"$rank","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$children","line":103},{"kind":13,"containerName":"new","name":"$children","line":104},{"containerName":"new","kind":13,"name":"$self","line":105},{"line":105,"kind":12,"containerName":"new","name":"warn"},{"definition":"my","line":107,"kind":13,"localvar":"my","containerName":"new","name":"$c"},{"name":"$children","containerName":"new","kind":13,"line":107},{"line":108,"name":"$self","containerName":"new","kind":13},{"line":108,"name":"add_Descendent","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$c","line":108},{"line":111,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"_creation_id","line":111},{"line":111,"name":"$CREATIONORDER","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":112}],"detail":"($class,@args)","definition":"sub"},{"line":84,"containerName":"new","kind":12,"name":"SUPER"},{"signature":{"label":"add_Descendent($self,$node,$ignoreoverwrite)","parameters":[{"label":"$self"},{"label":"$node"},{"label":"$ignoreoverwrite"}],"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node."},"line":129,"kind":12,"range":{"start":{"line":129,"character":0},"end":{"character":9999,"line":148}},"definition":"sub","detail":"($self,$node,$ignoreoverwrite)","children":[{"definition":"my","containerName":"add_Descendent","localvar":"my","kind":13,"name":"$self","line":131},{"line":131,"containerName":"add_Descendent","kind":13,"name":"$node"},{"containerName":"add_Descendent","kind":13,"name":"$ignoreoverwrite","line":131},{"name":"$node","containerName":"add_Descendent","kind":13,"line":133},{"line":134,"name":"$node","kind":13,"containerName":"add_Descendent"},{"kind":12,"containerName":"add_Descendent","name":"isa","line":134},{"name":"$self","kind":13,"containerName":"add_Descendent","line":135},{"name":"warn","kind":12,"containerName":"add_Descendent","line":135},{"line":139,"name":"$node","containerName":"add_Descendent","kind":13},{"line":139,"containerName":"add_Descendent","kind":13,"name":"$self"},{"kind":13,"containerName":"add_Descendent","name":"$self","line":140},{"line":140,"containerName":"add_Descendent","kind":13,"name":"$node"},{"name":"internal_id","containerName":"add_Descendent","kind":12,"line":140},{"line":140,"name":"$ignoreoverwrite","kind":13,"containerName":"add_Descendent"},{"line":141,"containerName":"add_Descendent","kind":13,"name":"$self"},{"name":"throw","containerName":"add_Descendent","kind":12,"line":141},{"name":"$self","kind":13,"containerName":"add_Descendent","line":144},{"containerName":"add_Descendent","kind":13,"name":"$node","line":144},{"containerName":"add_Descendent","kind":12,"name":"internal_id","line":144},{"kind":13,"containerName":"add_Descendent","name":"$node","line":144},{"name":"$self","kind":13,"containerName":"add_Descendent","line":146},{"kind":12,"containerName":"add_Descendent","name":"invalidate_height","line":146},{"kind":13,"containerName":"add_Descendent","name":"$self","line":148}],"containerName":"main::","name":"add_Descendent"},{"signature":{"label":"each_Descendent($self,$sortby)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.","parameters":[{"label":"$self"},{"label":"$sortby"}]},"range":{"start":{"character":0,"line":163},"end":{"line":173,"character":9999}},"kind":12,"line":163,"detail":"($self,$sortby)","definition":"sub","name":"each_Descendent","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"each_Descendent","line":164},{"line":164,"kind":13,"containerName":"each_Descendent","name":"$sortby"},{"line":168,"kind":13,"containerName":"each_Descendent","name":"$sortby"},{"line":170,"name":"$sortby","kind":13,"containerName":"each_Descendent"},{"definition":"my","line":171,"name":"@values","containerName":"each_Descendent","localvar":"my","kind":13},{"containerName":"each_Descendent","kind":13,"name":"$sortby","line":171},{"kind":13,"containerName":"each_Descendent","name":"$self","line":171},{"line":172,"name":"@values","kind":13,"containerName":"each_Descendent"}]},{"line":174,"kind":13,"containerName":null,"name":"%sortby"},{"line":176,"kind":13,"containerName":null,"name":"@a"},{"line":176,"name":"@b","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@a","line":177},{"line":177,"name":"@b","containerName":null,"kind":13},{"name":"height","kind":12,"containerName":"main::","line":178},{"line":178,"containerName":"main::","kind":12,"name":"internal_id"},{"kind":13,"containerName":null,"name":"%self","line":179},{"line":182,"name":"@a","containerName":null,"kind":13},{"name":"@b","containerName":null,"kind":13,"line":182},{"line":183,"name":"height","containerName":"main::","kind":12},{"line":184,"containerName":null,"kind":13,"name":"%self"},{"signature":{"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.","parameters":[{"label":"$self"},{"label":"@nodes"}],"label":"remove_Descendent($self,@nodes)"},"range":{"start":{"line":200,"character":0},"end":{"line":212,"character":9999}},"kind":12,"line":200,"detail":"($self,@nodes)","definition":"sub","name":"remove_Descendent","containerName":"main::","children":[{"localvar":"my","containerName":"remove_Descendent","kind":13,"name":"$self","line":201,"definition":"my"},{"name":"@nodes","containerName":"remove_Descendent","kind":13,"line":201},{"line":202,"name":"$n","containerName":"remove_Descendent","localvar":"my","kind":13,"definition":"my"},{"name":"@nodes","kind":13,"containerName":"remove_Descendent","line":202},{"name":"$self","kind":13,"containerName":"remove_Descendent","line":203},{"containerName":"remove_Descendent","kind":13,"name":"$n","line":203},{"line":203,"name":"internal_id","kind":12,"containerName":"remove_Descendent"},{"line":204,"containerName":"remove_Descendent","kind":13,"name":"$n"},{"line":205,"containerName":"remove_Descendent","kind":13,"name":"$self"},{"line":205,"kind":13,"containerName":"remove_Descendent","name":"$n"},{"name":"internal_id","kind":12,"containerName":"remove_Descendent","line":205},{"kind":13,"containerName":"remove_Descendent","name":"$self","line":206},{"kind":13,"containerName":"remove_Descendent","name":"$n","line":206},{"line":206,"name":"internal_id","kind":12,"containerName":"remove_Descendent"},{"name":"$self","kind":13,"containerName":"remove_Descendent","line":209},{"line":209,"kind":12,"containerName":"remove_Descendent","name":"debug"},{"name":"$n","kind":13,"containerName":"remove_Descendent","line":209},{"line":209,"name":"id","containerName":"remove_Descendent","kind":12},{"line":209,"containerName":"remove_Descendent","kind":13,"name":"$n"},{"name":"$self","containerName":"remove_Descendent","kind":13,"line":209},{"line":209,"name":"id","containerName":"remove_Descendent","kind":12},{"containerName":"remove_Descendent","kind":13,"name":"$self","line":209},{"line":210,"kind":13,"containerName":"remove_Descendent","name":"$self"},{"name":"debug","kind":12,"containerName":"remove_Descendent","line":210},{"containerName":"remove_Descendent","kind":13,"name":"$self","line":210}]},{"range":{"end":{"line":233,"character":9999},"start":{"character":0,"line":229}},"kind":12,"line":229,"signature":{"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none","parameters":[{"label":"$self"}],"label":"remove_all_Descendents($self)"},"name":"remove_all_Descendents","containerName":"main::","children":[{"definition":"my","line":230,"name":"$self","localvar":"my","kind":13,"containerName":"remove_all_Descendents"},{"definition":"my","localvar":"my","containerName":"remove_all_Descendents","kind":13,"name":"$node","line":233},{"line":233,"name":"$val","kind":13,"containerName":"remove_all_Descendents"},{"line":233,"name":"$self","kind":13,"containerName":"remove_all_Descendents"}],"detail":"($self)","definition":"sub"},{"containerName":null,"kind":13,"name":"%val","line":234},{"line":236,"containerName":null,"kind":13,"name":"%self"},{"line":263,"kind":12,"range":{"end":{"line":269,"character":9999},"start":{"line":263,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)","label":"ancestor($self,$value)"},"children":[{"line":264,"localvar":"my","containerName":"ancestor","kind":13,"name":"$self","definition":"my"},{"line":264,"kind":13,"containerName":"ancestor","name":"$value"},{"line":265,"name":"$value","containerName":"ancestor","kind":13},{"name":"$self","kind":13,"containerName":"ancestor","line":266},{"containerName":"ancestor","kind":13,"name":"$value","line":266},{"line":268,"name":"$self","containerName":"ancestor","kind":13}],"containerName":"main::","name":"ancestor","definition":"sub","detail":"($self,$value)"},{"line":282,"kind":12,"range":{"start":{"character":0,"line":282},"end":{"line":288,"character":9999}},"signature":{"label":"branch_length($self,$value)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"branch_length","line":283,"definition":"my"},{"line":283,"name":"$value","containerName":"branch_length","kind":13},{"name":"$value","kind":13,"containerName":"branch_length","line":284},{"name":"$self","kind":13,"containerName":"branch_length","line":285},{"containerName":"branch_length","kind":13,"name":"$value","line":285},{"containerName":"branch_length","kind":13,"name":"$self","line":287}],"containerName":"main::","name":"branch_length","definition":"sub","detail":"($self,$value)"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"description","children":[{"line":301,"name":"$self","localvar":"my","containerName":"description","kind":13,"definition":"my"},{"line":301,"kind":13,"containerName":"description","name":"$value"},{"line":302,"name":"$value","kind":13,"containerName":"description"},{"line":303,"name":"$self","containerName":"description","kind":13},{"kind":13,"containerName":"description","name":"$value","line":303},{"name":"$self","kind":13,"containerName":"description","line":305}],"signature":{"label":"description($self,$value)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"character":9999,"line":306},"start":{"character":0,"line":300}},"line":300},{"line":318,"range":{"end":{"line":324,"character":9999},"start":{"character":0,"line":318}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)","label":"rank($self,$value)"},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"rank","line":319,"definition":"my"},{"name":"$value","containerName":"rank","kind":13,"line":319},{"kind":13,"containerName":"rank","name":"$value","line":320},{"line":321,"kind":13,"containerName":"rank","name":"$self"},{"name":"$value","containerName":"rank","kind":13,"line":321},{"line":323,"name":"$self","containerName":"rank","kind":13}],"name":"rank","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"signature":{"label":"taxon($self,$value)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n because internal taxa have names too...","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"end":{"character":9999,"line":344},"start":{"character":0,"line":338}},"kind":12,"line":338,"detail":"($self,$value)","definition":"sub","name":"taxon","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"taxon","line":339,"definition":"my"},{"containerName":"taxon","kind":13,"name":"$value","line":339},{"line":340,"kind":13,"containerName":"taxon","name":"$value"},{"name":"$self","kind":13,"containerName":"taxon","line":341},{"line":341,"name":"$value","containerName":"taxon","kind":13},{"name":"$self","kind":13,"containerName":"taxon","line":343}]},{"signature":{"label":"id($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)"},"line":357,"kind":12,"range":{"start":{"character":0,"line":357},"end":{"character":9999,"line":363}},"definition":"sub","detail":"($self,$value)","children":[{"line":358,"containerName":"id","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"id","line":358},{"line":359,"containerName":"id","kind":13,"name":"$value"},{"line":360,"name":"$self","kind":13,"containerName":"id"},{"name":"$value","containerName":"id","kind":13,"line":360},{"line":362,"containerName":"id","kind":13,"name":"$self"}],"name":"id","containerName":"main::"},{"name":"DESTROY","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"DESTROY","name":"$self","line":366,"definition":"my"},{"name":"$self","kind":13,"containerName":"DESTROY","line":368},{"line":369,"name":"$self","kind":13,"containerName":"DESTROY"},{"line":370,"name":"$self","containerName":"DESTROY","kind":13},{"line":371,"name":"$nodeid","localvar":"my","containerName":"DESTROY","kind":13,"definition":"my"},{"name":"$node","containerName":"DESTROY","kind":13,"line":371},{"line":371,"containerName":"DESTROY","kind":13,"name":"$self"},{"line":372,"name":"$node","containerName":"DESTROY","kind":13},{"kind":13,"containerName":"DESTROY","name":"$node","line":373},{"kind":12,"containerName":"DESTROY","name":"DESTROY","line":373},{"name":"$node","containerName":"DESTROY","kind":13,"line":374},{"kind":13,"containerName":"DESTROY","name":"$self","line":376}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":365},"end":{"character":9999,"line":377}},"line":365,"signature":{"label":"DESTROY($self)","parameters":[{"label":"$self"}],"documentation":""}},{"kind":12,"containerName":"DESTROY","name":"SUPER","line":368},{"name":"internal_id","containerName":"main::","children":[{"line":394,"name":"_creation_id","containerName":"internal_id","kind":12}],"definition":"sub","kind":12,"range":{"start":{"line":393,"character":0},"end":{"character":9999,"line":395}},"line":393},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)","label":"_creation_id($self,$value)"},"line":408,"kind":12,"range":{"start":{"character":0,"line":408},"end":{"line":414,"character":9999}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":409,"localvar":"my","kind":13,"containerName":"_creation_id","name":"$self"},{"line":409,"containerName":"_creation_id","kind":13,"name":"$value"},{"kind":13,"containerName":"_creation_id","name":"$value","line":410},{"line":411,"name":"$self","kind":13,"containerName":"_creation_id"},{"line":411,"containerName":"_creation_id","kind":13,"name":"$value"},{"kind":13,"containerName":"_creation_id","name":"$self","line":413}],"name":"_creation_id","containerName":"main::"},{"definition":"sub","detail":"($self)","children":[{"name":"$self","containerName":"is_Leaf","localvar":"my","kind":13,"line":429,"definition":"my"},{"definition":"my","name":"$rc","containerName":"is_Leaf","localvar":"my","kind":13,"line":430},{"containerName":"is_Leaf","kind":13,"name":"$rc","line":431},{"name":"$self","containerName":"is_Leaf","kind":13,"line":431},{"kind":13,"containerName":"is_Leaf","name":"$self","line":432}],"containerName":"main::","name":"is_Leaf","signature":{"label":"is_Leaf($self)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none","parameters":[{"label":"$self"}]},"line":428,"range":{"end":{"character":9999,"line":432},"start":{"line":428,"character":0}},"kind":12},{"line":433,"name":"$rc","kind":13,"containerName":null},{"definition":"sub","detail":"($self)","children":[{"line":458,"localvar":"my","kind":13,"containerName":"height","name":"$self","definition":"my"},{"kind":13,"containerName":"height","name":"$self","line":460},{"line":460,"kind":13,"containerName":"height","name":"$self"},{"line":462,"kind":13,"containerName":"height","name":"$self"},{"line":462,"containerName":"height","kind":12,"name":"is_Leaf"},{"containerName":"height","kind":13,"name":"$self","line":463},{"name":"branch_length","kind":12,"containerName":"height","line":463},{"line":464,"containerName":"height","kind":13,"name":"$self"},{"kind":12,"containerName":"height","name":"debug","line":464},{"line":464,"name":"$self","kind":13,"containerName":"height"},{"containerName":"height","kind":12,"name":"id","line":464},{"name":"$self","containerName":"height","kind":13,"line":467},{"name":"branch_length","kind":12,"containerName":"height","line":467},{"line":469,"name":"$max","localvar":"my","kind":13,"containerName":"height","definition":"my"},{"localvar":"my","kind":13,"containerName":"height","name":"$subnode","line":470,"definition":"my"},{"name":"$self","containerName":"height","kind":13,"line":470},{"line":470,"name":"each_Descendent","containerName":"height","kind":12},{"definition":"my","line":471,"name":"$s","localvar":"my","containerName":"height","kind":13},{"line":471,"containerName":"height","kind":13,"name":"$subnode"},{"name":"height","kind":12,"containerName":"height","line":471},{"line":472,"name":"$s","containerName":"height","kind":13},{"line":472,"name":"$max","containerName":"height","kind":13},{"line":472,"containerName":"height","kind":13,"name":"$max"},{"kind":13,"containerName":"height","name":"$s","line":472},{"name":"$self","containerName":"height","kind":13,"line":474},{"line":474,"name":"$max","containerName":"height","kind":13},{"line":474,"containerName":"height","kind":13,"name":"$self"},{"name":"branch_length","containerName":"height","kind":12,"line":474}],"containerName":"main::","name":"height","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf {\n    my ($self) = @_;\n    my $rc = 0;\n    $rc = 1 if( ! defined $self->{'_desc'} ||\t\n\t\tkeys %{$self->{'_desc'}} == 0);\n    return $rc;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $taxon->to_string()\n Function: For debugging, provide a taxon as a string\n Returns : string\n Args    : none\n\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $taxon->height\n Function: Returns the height of the tree starting at this\n           taxon.  Height is the maximum branchlength.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none","label":"height($self)"},"line":457,"range":{"end":{"line":475,"character":9999},"start":{"line":457,"character":0}},"kind":12},{"signature":{"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf {\n    my ($self) = @_;\n    my $rc = 0;\n    $rc = 1 if( ! defined $self->{'_desc'} ||\t\n\t\tkeys %{$self->{'_desc'}} == 0);\n    return $rc;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $taxon->to_string()\n Function: For debugging, provide a taxon as a string\n Returns : string\n Args    : none\n\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $taxon->height\n Function: Returns the height of the tree starting at this\n           taxon.  Height is the maximum branchlength.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height { \n    my ($self) = @_;\n\n    return $self->{'_height'} if( defined $self->{'_height'} );\n    \n    if( $self->is_Leaf ) { \n      if( !defined $self->branch_length ) { \n\t      $self->debug(sprintf(\"Trying to calculate height of a taxon when a taxon (%s) has an undefined branch_length\",$self->id || '?' ));\n\t      return 0;\n      }\n      return $self->branch_length;\n   }\n   my $max = 0;\n   foreach my $subnode ( $self->each_Descendent ) { \n       my $s = $subnode->height;\n       if( $s > $max ) { $max = $s; }\n   }\n   return ($self->{'_height'} = $max + ($self->branch_length || 1));\n}\n\n=head2 invalidate_height\n\n Title   : invalidate_height\n Usage   : private helper method\n Function: Invalidate our cached value of the taxon's height in the tree\n Returns : nothing\n Args    : none","parameters":[{"label":"$self"}],"label":"invalidate_height($self)"},"line":487,"kind":12,"range":{"start":{"character":0,"line":487},"end":{"line":494,"character":9999}},"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"invalidate_height","line":488},{"name":"$self","kind":13,"containerName":"invalidate_height","line":490},{"name":"$self","containerName":"invalidate_height","kind":13,"line":491},{"line":491,"kind":12,"containerName":"invalidate_height","name":"ancestor"},{"line":492,"containerName":"invalidate_height","kind":13,"name":"$self"},{"kind":12,"containerName":"invalidate_height","name":"ancestor","line":492},{"containerName":"invalidate_height","kind":12,"name":"invalidate_height","line":492}],"containerName":"main::","name":"invalidate_height"},{"line":507,"kind":12,"range":{"start":{"line":507,"character":0},"end":{"line":519,"character":9999}},"signature":{"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf {\n    my ($self) = @_;\n    my $rc = 0;\n    $rc = 1 if( ! defined $self->{'_desc'} ||\t\n\t\tkeys %{$self->{'_desc'}} == 0);\n    return $rc;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $taxon->to_string()\n Function: For debugging, provide a taxon as a string\n Returns : string\n Args    : none\n\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $taxon->height\n Function: Returns the height of the tree starting at this\n           taxon.  Height is the maximum branchlength.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height { \n    my ($self) = @_;\n\n    return $self->{'_height'} if( defined $self->{'_height'} );\n    \n    if( $self->is_Leaf ) { \n      if( !defined $self->branch_length ) { \n\t      $self->debug(sprintf(\"Trying to calculate height of a taxon when a taxon (%s) has an undefined branch_length\",$self->id || '?' ));\n\t      return 0;\n      }\n      return $self->branch_length;\n   }\n   my $max = 0;\n   foreach my $subnode ( $self->each_Descendent ) { \n       my $s = $subnode->height;\n       if( $s > $max ) { $max = $s; }\n   }\n   return ($self->{'_height'} = $max + ($self->branch_length || 1));\n}\n\n=head2 invalidate_height\n\n Title   : invalidate_height\n Usage   : private helper method\n Function: Invalidate our cached value of the taxon's height in the tree\n Returns : nothing\n Args    : none\n\n\nsub invalidate_height { \n    my ($self) = @_;\n    \n    $self->{'_height'} = undef;\n    if( $self->ancestor ) {\n\t    $self->ancestor->invalidate_height;\n    }\n}\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj->classify()\n Function: a method to return the classification of a species\n Returns : name of taxon and ancestor's taxon recursively\n Args    : boolean to specify whether we want all taxa not just ranked \n           levels","parameters":[{"label":"$self"},{"label":"$allnodes"}],"label":"classify($self,$allnodes)"},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"classify","kind":13,"line":508},{"line":508,"containerName":"classify","kind":13,"name":"$allnodes"},{"definition":"my","name":"@classification","kind":13,"localvar":"my","containerName":"classify","line":510},{"line":510,"name":"$self","containerName":"classify","kind":13},{"name":"taxon","kind":12,"containerName":"classify","line":510},{"definition":"my","line":511,"name":"$node","kind":13,"localvar":"my","containerName":"classify"},{"containerName":"classify","kind":13,"name":"$self","line":511},{"line":513,"kind":13,"containerName":"classify","name":"$node"},{"line":513,"containerName":"classify","kind":12,"name":"ancestor"},{"line":514,"name":"@classification","kind":13,"containerName":"classify"},{"containerName":"classify","kind":13,"name":"$node","line":514},{"line":514,"kind":12,"containerName":"classify","name":"ancestor"},{"kind":12,"containerName":"classify","name":"taxon","line":514},{"line":514,"kind":13,"containerName":"classify","name":"$allnodes"},{"name":"$node","containerName":"classify","kind":13,"line":515},{"line":515,"name":"$node","kind":13,"containerName":"classify"},{"containerName":"classify","kind":12,"name":"ancestor","line":515},{"line":518,"name":"@classification","kind":13,"containerName":"classify"}],"name":"classify","containerName":"main::","definition":"sub","detail":"($self,$allnodes)"},{"range":{"start":{"line":531,"character":0},"end":{"character":9999,"line":542}},"kind":12,"line":531,"signature":{"label":"has_rank($self,$rank)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf {\n    my ($self) = @_;\n    my $rc = 0;\n    $rc = 1 if( ! defined $self->{'_desc'} ||\t\n\t\tkeys %{$self->{'_desc'}} == 0);\n    return $rc;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $taxon->to_string()\n Function: For debugging, provide a taxon as a string\n Returns : string\n Args    : none\n\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $taxon->height\n Function: Returns the height of the tree starting at this\n           taxon.  Height is the maximum branchlength.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height { \n    my ($self) = @_;\n\n    return $self->{'_height'} if( defined $self->{'_height'} );\n    \n    if( $self->is_Leaf ) { \n      if( !defined $self->branch_length ) { \n\t      $self->debug(sprintf(\"Trying to calculate height of a taxon when a taxon (%s) has an undefined branch_length\",$self->id || '?' ));\n\t      return 0;\n      }\n      return $self->branch_length;\n   }\n   my $max = 0;\n   foreach my $subnode ( $self->each_Descendent ) { \n       my $s = $subnode->height;\n       if( $s > $max ) { $max = $s; }\n   }\n   return ($self->{'_height'} = $max + ($self->branch_length || 1));\n}\n\n=head2 invalidate_height\n\n Title   : invalidate_height\n Usage   : private helper method\n Function: Invalidate our cached value of the taxon's height in the tree\n Returns : nothing\n Args    : none\n\n\nsub invalidate_height { \n    my ($self) = @_;\n    \n    $self->{'_height'} = undef;\n    if( $self->ancestor ) {\n\t    $self->ancestor->invalidate_height;\n    }\n}\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj->classify()\n Function: a method to return the classification of a species\n Returns : name of taxon and ancestor's taxon recursively\n Args    : boolean to specify whether we want all taxa not just ranked \n           levels\n\n\nsub classify {\n   my ($self,$allnodes) = @_;\n\n   my @classification=($self->taxon);\n   my $node=$self;\n\n   while (defined $node->ancestor) {\n      push @classification, $node->ancestor->taxon if $allnodes==1;\n      $node=$node->ancestor;\n   }\n\n   return (@classification);\n}\n\n=head2 has_rank\n\n Title   : has_rank\n Usage   : $obj->has_rank($rank)\n Function: a method to query ancestors' rank\n Returns : boolean\n Args    : $rank","parameters":[{"label":"$self"},{"label":"$rank"}]},"name":"has_rank","containerName":"main::","children":[{"line":532,"localvar":"my","kind":13,"containerName":"has_rank","name":"$self","definition":"my"},{"line":532,"kind":13,"containerName":"has_rank","name":"$rank"},{"name":"$self","containerName":"has_rank","kind":13,"line":534},{"name":"$self","kind":13,"containerName":"has_rank","line":534},{"line":534,"name":"rank","containerName":"has_rank","kind":12},{"line":534,"containerName":"has_rank","kind":13,"name":"$rank"},{"name":"$self","containerName":"has_rank","kind":13,"line":536},{"containerName":"has_rank","kind":12,"name":"ancestor","line":536},{"line":537,"containerName":"has_rank","kind":13,"name":"$self"},{"kind":13,"containerName":"has_rank","name":"$self","line":537},{"kind":12,"containerName":"has_rank","name":"ancestor","line":537},{"kind":12,"containerName":"has_rank","name":"rank","line":537},{"line":537,"kind":13,"containerName":"has_rank","name":"$rank"},{"line":538,"name":"$self","containerName":"has_rank","kind":13},{"containerName":"has_rank","kind":13,"name":"$self","line":538},{"line":538,"name":"ancestor","containerName":"has_rank","kind":12}],"detail":"($self,$rank)","definition":"sub"},{"detail":"($self,$taxon)","definition":"sub","containerName":"main::","name":"has_taxon","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"has_taxon","kind":13,"line":555},{"line":555,"name":"$taxon","containerName":"has_taxon","kind":13},{"name":"$self","containerName":"has_taxon","kind":13,"line":557},{"line":558,"name":"$self","containerName":"has_taxon","kind":13},{"line":558,"kind":12,"containerName":"has_taxon","name":"id"},{"containerName":"has_taxon","kind":13,"name":"$self","line":558},{"line":558,"kind":12,"containerName":"has_taxon","name":"id"},{"line":558,"containerName":"has_taxon","kind":13,"name":"$taxon"},{"containerName":"has_taxon","kind":12,"name":"id","line":558},{"kind":13,"containerName":"has_taxon","name":"$self","line":559},{"containerName":"has_taxon","kind":12,"name":"taxon","line":559},{"line":559,"name":"$taxon","containerName":"has_taxon","kind":13},{"name":"taxon","kind":12,"containerName":"has_taxon","line":559},{"name":"$self","kind":13,"containerName":"has_taxon","line":559},{"line":559,"name":"rank","containerName":"has_taxon","kind":12},{"line":559,"name":"$taxon","kind":13,"containerName":"has_taxon"},{"containerName":"has_taxon","kind":12,"name":"rank","line":559},{"line":561,"name":"$self","kind":13,"containerName":"has_taxon"},{"name":"ancestor","containerName":"has_taxon","kind":12,"line":561},{"name":"$self","kind":13,"containerName":"has_taxon","line":562},{"line":563,"name":"$self","kind":13,"containerName":"has_taxon"},{"containerName":"has_taxon","kind":12,"name":"id","line":563},{"name":"$self","containerName":"has_taxon","kind":13,"line":563},{"name":"id","containerName":"has_taxon","kind":12,"line":563},{"line":563,"name":"$taxon","kind":13,"containerName":"has_taxon"},{"line":563,"containerName":"has_taxon","kind":12,"name":"id"},{"containerName":"has_taxon","kind":13,"name":"$self","line":564},{"name":"taxon","containerName":"has_taxon","kind":12,"line":564},{"line":564,"name":"$taxon","kind":13,"containerName":"has_taxon"},{"line":564,"containerName":"has_taxon","kind":12,"name":"taxon"},{"line":564,"kind":13,"containerName":"has_taxon","name":"$self"},{"line":564,"containerName":"has_taxon","kind":12,"name":"rank"},{"name":"$taxon","kind":13,"containerName":"has_taxon","line":564},{"line":564,"containerName":"has_taxon","kind":12,"name":"rank"},{"kind":13,"containerName":"has_taxon","name":"$self","line":565},{"name":"taxon","containerName":"has_taxon","kind":12,"line":565},{"containerName":"has_taxon","kind":13,"name":"$self","line":566},{"line":566,"name":"$self","containerName":"has_taxon","kind":13},{"line":566,"containerName":"has_taxon","kind":12,"name":"ancestor"}],"signature":{"label":"has_taxon($self,$taxon)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf {\n    my ($self) = @_;\n    my $rc = 0;\n    $rc = 1 if( ! defined $self->{'_desc'} ||\t\n\t\tkeys %{$self->{'_desc'}} == 0);\n    return $rc;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $taxon->to_string()\n Function: For debugging, provide a taxon as a string\n Returns : string\n Args    : none\n\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $taxon->height\n Function: Returns the height of the tree starting at this\n           taxon.  Height is the maximum branchlength.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height { \n    my ($self) = @_;\n\n    return $self->{'_height'} if( defined $self->{'_height'} );\n    \n    if( $self->is_Leaf ) { \n      if( !defined $self->branch_length ) { \n\t      $self->debug(sprintf(\"Trying to calculate height of a taxon when a taxon (%s) has an undefined branch_length\",$self->id || '?' ));\n\t      return 0;\n      }\n      return $self->branch_length;\n   }\n   my $max = 0;\n   foreach my $subnode ( $self->each_Descendent ) { \n       my $s = $subnode->height;\n       if( $s > $max ) { $max = $s; }\n   }\n   return ($self->{'_height'} = $max + ($self->branch_length || 1));\n}\n\n=head2 invalidate_height\n\n Title   : invalidate_height\n Usage   : private helper method\n Function: Invalidate our cached value of the taxon's height in the tree\n Returns : nothing\n Args    : none\n\n\nsub invalidate_height { \n    my ($self) = @_;\n    \n    $self->{'_height'} = undef;\n    if( $self->ancestor ) {\n\t    $self->ancestor->invalidate_height;\n    }\n}\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj->classify()\n Function: a method to return the classification of a species\n Returns : name of taxon and ancestor's taxon recursively\n Args    : boolean to specify whether we want all taxa not just ranked \n           levels\n\n\nsub classify {\n   my ($self,$allnodes) = @_;\n\n   my @classification=($self->taxon);\n   my $node=$self;\n\n   while (defined $node->ancestor) {\n      push @classification, $node->ancestor->taxon if $allnodes==1;\n      $node=$node->ancestor;\n   }\n\n   return (@classification);\n}\n\n=head2 has_rank\n\n Title   : has_rank\n Usage   : $obj->has_rank($rank)\n Function: a method to query ancestors' rank\n Returns : boolean\n Args    : $rank\n\n\nsub has_rank {\n   my ($self,$rank) = @_;\n\n   return $self if $self->rank eq $rank;\n\n   while (defined $self->ancestor) {\n      return $self if $self->ancestor->rank eq $rank;\n      $self=$self->ancestor;\n   }\n\n   return;\n}\n\n=head2 has_taxon\n\n Title   : has_taxon\n Usage   : $obj->has_taxon($taxon)\n Function: a method to query ancestors' taxa\n Returns : boolean\n Args    : Bio::Taxonomy::Taxon object","parameters":[{"label":"$self"},{"label":"$taxon"}]},"kind":12,"range":{"end":{"line":570,"character":9999},"start":{"line":554,"character":0}},"line":554},{"signature":{"label":"distance_to_root($self,$taxon)","documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf {\n    my ($self) = @_;\n    my $rc = 0;\n    $rc = 1 if( ! defined $self->{'_desc'} ||\t\n\t\tkeys %{$self->{'_desc'}} == 0);\n    return $rc;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $taxon->to_string()\n Function: For debugging, provide a taxon as a string\n Returns : string\n Args    : none\n\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $taxon->height\n Function: Returns the height of the tree starting at this\n           taxon.  Height is the maximum branchlength.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height { \n    my ($self) = @_;\n\n    return $self->{'_height'} if( defined $self->{'_height'} );\n    \n    if( $self->is_Leaf ) { \n      if( !defined $self->branch_length ) { \n\t      $self->debug(sprintf(\"Trying to calculate height of a taxon when a taxon (%s) has an undefined branch_length\",$self->id || '?' ));\n\t      return 0;\n      }\n      return $self->branch_length;\n   }\n   my $max = 0;\n   foreach my $subnode ( $self->each_Descendent ) { \n       my $s = $subnode->height;\n       if( $s > $max ) { $max = $s; }\n   }\n   return ($self->{'_height'} = $max + ($self->branch_length || 1));\n}\n\n=head2 invalidate_height\n\n Title   : invalidate_height\n Usage   : private helper method\n Function: Invalidate our cached value of the taxon's height in the tree\n Returns : nothing\n Args    : none\n\n\nsub invalidate_height { \n    my ($self) = @_;\n    \n    $self->{'_height'} = undef;\n    if( $self->ancestor ) {\n\t    $self->ancestor->invalidate_height;\n    }\n}\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj->classify()\n Function: a method to return the classification of a species\n Returns : name of taxon and ancestor's taxon recursively\n Args    : boolean to specify whether we want all taxa not just ranked \n           levels\n\n\nsub classify {\n   my ($self,$allnodes) = @_;\n\n   my @classification=($self->taxon);\n   my $node=$self;\n\n   while (defined $node->ancestor) {\n      push @classification, $node->ancestor->taxon if $allnodes==1;\n      $node=$node->ancestor;\n   }\n\n   return (@classification);\n}\n\n=head2 has_rank\n\n Title   : has_rank\n Usage   : $obj->has_rank($rank)\n Function: a method to query ancestors' rank\n Returns : boolean\n Args    : $rank\n\n\nsub has_rank {\n   my ($self,$rank) = @_;\n\n   return $self if $self->rank eq $rank;\n\n   while (defined $self->ancestor) {\n      return $self if $self->ancestor->rank eq $rank;\n      $self=$self->ancestor;\n   }\n\n   return;\n}\n\n=head2 has_taxon\n\n Title   : has_taxon\n Usage   : $obj->has_taxon($taxon)\n Function: a method to query ancestors' taxa\n Returns : boolean\n Args    : Bio::Taxonomy::Taxon object\n\n\nsub has_taxon {\n   my ($self,$taxon) = @_;\n\n   return $self if \n      ((defined $self->id && $self->id == $taxon->id) ||\n      ($self->taxon eq $taxon->taxon && $self->rank eq $taxon->rank));\n\n   while (defined $self->ancestor) {\n      return $self if \n         ((defined $self->id && $self->id == $taxon->id) ||\n         ($self->taxon eq $taxon->taxon && $self->rank eq $taxon->rank) &&\n         ($self->taxon ne 'no rank'));\n      $self=$self->ancestor;\n   }\n\n   return;\n}\n\n=head2 distance_to_root\n\n Title   : distance_to_root\n Usage   : $obj->distance_to_root\n Function: a method to query ancestors' taxa\n Returns : number of links to root\n Args    :","parameters":[{"label":"$self"},{"label":"$taxon"}]},"line":582,"kind":12,"range":{"start":{"character":0,"line":582},"end":{"character":9999,"line":593}},"definition":"sub","detail":"($self,$taxon)","children":[{"localvar":"my","kind":13,"containerName":"distance_to_root","name":"$self","line":583,"definition":"my"},{"name":"$taxon","kind":13,"containerName":"distance_to_root","line":583},{"definition":"my","line":585,"name":"$count","containerName":"distance_to_root","localvar":"my","kind":13},{"containerName":"distance_to_root","kind":13,"name":"$self","line":587},{"line":587,"name":"ancestor","containerName":"distance_to_root","kind":12},{"line":588,"kind":13,"containerName":"distance_to_root","name":"$count"},{"line":589,"name":"$self","containerName":"distance_to_root","kind":13},{"line":589,"name":"$self","containerName":"distance_to_root","kind":13},{"line":589,"name":"ancestor","kind":12,"containerName":"distance_to_root"},{"line":592,"name":"$count","containerName":"distance_to_root","kind":13}],"name":"distance_to_root","containerName":"main::"},{"signature":{"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf {\n    my ($self) = @_;\n    my $rc = 0;\n    $rc = 1 if( ! defined $self->{'_desc'} ||\t\n\t\tkeys %{$self->{'_desc'}} == 0);\n    return $rc;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $taxon->to_string()\n Function: For debugging, provide a taxon as a string\n Returns : string\n Args    : none\n\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $taxon->height\n Function: Returns the height of the tree starting at this\n           taxon.  Height is the maximum branchlength.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height { \n    my ($self) = @_;\n\n    return $self->{'_height'} if( defined $self->{'_height'} );\n    \n    if( $self->is_Leaf ) { \n      if( !defined $self->branch_length ) { \n\t      $self->debug(sprintf(\"Trying to calculate height of a taxon when a taxon (%s) has an undefined branch_length\",$self->id || '?' ));\n\t      return 0;\n      }\n      return $self->branch_length;\n   }\n   my $max = 0;\n   foreach my $subnode ( $self->each_Descendent ) { \n       my $s = $subnode->height;\n       if( $s > $max ) { $max = $s; }\n   }\n   return ($self->{'_height'} = $max + ($self->branch_length || 1));\n}\n\n=head2 invalidate_height\n\n Title   : invalidate_height\n Usage   : private helper method\n Function: Invalidate our cached value of the taxon's height in the tree\n Returns : nothing\n Args    : none\n\n\nsub invalidate_height { \n    my ($self) = @_;\n    \n    $self->{'_height'} = undef;\n    if( $self->ancestor ) {\n\t    $self->ancestor->invalidate_height;\n    }\n}\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj->classify()\n Function: a method to return the classification of a species\n Returns : name of taxon and ancestor's taxon recursively\n Args    : boolean to specify whether we want all taxa not just ranked \n           levels\n\n\nsub classify {\n   my ($self,$allnodes) = @_;\n\n   my @classification=($self->taxon);\n   my $node=$self;\n\n   while (defined $node->ancestor) {\n      push @classification, $node->ancestor->taxon if $allnodes==1;\n      $node=$node->ancestor;\n   }\n\n   return (@classification);\n}\n\n=head2 has_rank\n\n Title   : has_rank\n Usage   : $obj->has_rank($rank)\n Function: a method to query ancestors' rank\n Returns : boolean\n Args    : $rank\n\n\nsub has_rank {\n   my ($self,$rank) = @_;\n\n   return $self if $self->rank eq $rank;\n\n   while (defined $self->ancestor) {\n      return $self if $self->ancestor->rank eq $rank;\n      $self=$self->ancestor;\n   }\n\n   return;\n}\n\n=head2 has_taxon\n\n Title   : has_taxon\n Usage   : $obj->has_taxon($taxon)\n Function: a method to query ancestors' taxa\n Returns : boolean\n Args    : Bio::Taxonomy::Taxon object\n\n\nsub has_taxon {\n   my ($self,$taxon) = @_;\n\n   return $self if \n      ((defined $self->id && $self->id == $taxon->id) ||\n      ($self->taxon eq $taxon->taxon && $self->rank eq $taxon->rank));\n\n   while (defined $self->ancestor) {\n      return $self if \n         ((defined $self->id && $self->id == $taxon->id) ||\n         ($self->taxon eq $taxon->taxon && $self->rank eq $taxon->rank) &&\n         ($self->taxon ne 'no rank'));\n      $self=$self->ancestor;\n   }\n\n   return;\n}\n\n=head2 distance_to_root\n\n Title   : distance_to_root\n Usage   : $obj->distance_to_root\n Function: a method to query ancestors' taxa\n Returns : number of links to root\n Args    :\n\n\nsub distance_to_root {\n   my ($self,$taxon) = @_;\n\n   my $count=0;\n\n   while (defined $self->ancestor) {\n      $count++;\n      $self=$self->ancestor;\n   }\n\n   return $count;\n}\n\n=head2 recent_common_ancestor\n\n Title   : recent_common_ancestor\n Usage   : $obj->recent_common_ancestor($taxon)\n Function: a method to query find common ancestors\n Returns : Bio::Taxonomy::Taxon of query or undef if no ancestor of rank\n Args    : Bio::Taxonomy::Taxon","parameters":[{"label":"$self"},{"label":"$node"}],"label":"recent_common_ancestor($self,$node)"},"kind":12,"range":{"end":{"line":615,"character":9999},"start":{"line":605,"character":0}},"line":605,"detail":"($self,$node)","definition":"sub","name":"recent_common_ancestor","containerName":"main::","children":[{"definition":"my","line":606,"localvar":"my","kind":13,"containerName":"recent_common_ancestor","name":"$self"},{"line":606,"kind":13,"containerName":"recent_common_ancestor","name":"$node"},{"line":608,"containerName":"recent_common_ancestor","kind":13,"name":"$node"},{"containerName":"recent_common_ancestor","kind":12,"name":"ancestor","line":608},{"definition":"my","line":609,"name":"$common","localvar":"my","kind":13,"containerName":"recent_common_ancestor"},{"name":"$self","kind":13,"containerName":"recent_common_ancestor","line":609},{"line":609,"name":"has_taxon","containerName":"recent_common_ancestor","kind":12},{"line":609,"name":"$node","containerName":"recent_common_ancestor","kind":13},{"kind":13,"containerName":"recent_common_ancestor","name":"$common","line":610},{"line":610,"containerName":"recent_common_ancestor","kind":13,"name":"$common"},{"line":611,"name":"$node","kind":13,"containerName":"recent_common_ancestor"},{"line":611,"name":"$node","containerName":"recent_common_ancestor","kind":13},{"name":"ancestor","kind":12,"containerName":"recent_common_ancestor","line":611}]},{"line":627,"range":{"end":{"character":9999,"line":644},"start":{"line":627,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Taxon.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from \n# the Bio::Tree::Node code of Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Taxon - Generic Taxonomic Entity object\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon instead.\n\n    use Bio::Taxonomy::Taxon;\n    my $taxonA = Bio::Taxonomy::Taxon->new();\n    my $taxonL = Bio::Taxonomy::Taxon->new();\n    my $taxonR = Bio::Taxonomy::Taxon->new();\n\n    my $taxon = Bio::Taxonomy::Taxon->new();\n    $taxon->add_Descendents($taxonL);\n    $taxon->add_Descendents($taxonR);\n\n    my $species = $taxon->species;\n\n=head1 DESCRIPTION\n\nMakes a taxonomic unit suitable for use in a taxonomic tree\n\n=head1 AUTHOR\n\nDan Kortschak email B<kortschak@rsbs.anu.edu.au>\n\n=head1 CONTRIBUTORS\n\nSendu Bala: bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# code begins...\n\npackage Bio::Taxonomy::Taxon;\nuse vars qw($CREATIONORDER);\nuse strict;\n\nuse Bio::Species;\n\nuse base qw(Bio::Root::Root Bio::Tree::NodeI);\n\nBEGIN { \n    $CREATIONORDER = 0;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Taxon->new();\n Function: Builds a new Bio::Taxonomy::Taxon object\n Returns : Bio::Taxonomy::Taxon\n Args    : -descendents   => array pointer to descendents (optional)\n     \t   -branch_length => branch length [integer] (optional)\n     \t   -taxon     => taxon\n           -id     => unique taxon id for node (from NCBI's list preferably)\n           -rank  => the taxonomic level of the node (also from NCBI)\n\n\n#' for emacs\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Taxon is deprecated. Use Bio::Taxon instead.\");\n  \n  my ($children,$branchlen,$id,$taxon,$rank,$desc) = \n\n                      $self->_rearrange([qw(DESCENDENTS\n                                            BRANCH_LENGTH\n                                            ID\n                                            TAXON\n                                            RANK\n                                            DESC)], @args);\n  \n  $self->{'_desc'} = {};\n  defined $desc && $self->description($desc);\n  defined $taxon && $self->taxon($taxon);\n  defined $id && $self->id($id);\n  defined $branchlen && $self->branch_length($branchlen);\n  defined $rank && $self->rank($rank);\n\n  if( defined $children ) {\n      if( ref($children) !~ /ARRAY/i ) {\n\t  $self->warn(\"Must specify a valid ARRAY reference to initialize a Taxon's Descendents\");\n      }\n      foreach my $c ( @$children ) { \t\n \t  $self->add_Descendent($c);\n      }\n  }\n  $self->_creation_id($CREATIONORDER++);\n  return $self;\n}\n\n=head2 add_Descendent\n\n Title   : add_Descendent\n Usage   : $taxon->add_Descendent($taxon);\n Function: Adds a descendent to a taxon\n Returns : number of current descendents for this taxon\n Args    : Bio::Taxonomy::Taxon\n           boolean flag, true if you want to ignore the fact that you are\n           adding a second node with the same unique id (typically memory \n           location reference in this implementation).  default is false and \n           will throw an error if you try and overwrite an existing node.\n\n\nsub add_Descendent{\n\n   my ($self,$node,$ignoreoverwrite) = @_;\n\n   return -1 if( ! defined $node ) ;\n   if( ! $node->isa('Bio::Taxonomy::Taxon') ) {\n       $self->warn(\"Trying to add a Descendent who is not a Bio::Taxonomy::Taxon\");\n       return -1;\n   }\n   # do we care about order?\n   $node->{'_ancestor'} = $self;\n   if( $self->{'_desc'}->{$node->internal_id} && ! $ignoreoverwrite ) {\n       $self->throw(\"Going to overwrite a taxon which is $node that is already stored here, set the ignore overwrite flag (parameter 2) to true to ignore this in the future\");\n   }\n   \n   $self->{'_desc'}->{$node->internal_id} = $node; # is this safely unique - we've tested before at any rate??\n   \n   $self->invalidate_height();\n   \n   return scalar keys %{$self->{'_desc'}};\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent($sortby)\n Usage   : my @taxa = $taxon->each_Descendent;\n Function: all the descendents for this taxon (but not their descendents\n\t\t\t\t\t      i.e. not a recursive fetchall)\n Returns : Array of Bio::Taxonomy::Taxon objects\n Args    : $sortby [optional] \"height\", \"creation\" or coderef to be used\n           to sort the order of children taxa.\n\n\nsub each_Descendent{\n   my ($self, $sortby) = @_;\n\n   # order can be based on branch length (and sub branchlength)\n\n   $sortby ||= 'height';\n\n   if (ref $sortby eq 'CODE') {\n       my @values = sort $sortby values %{$self->{'_desc'}};\n       return @values;\n   } else  {\n       if ($sortby eq 'height') {\n\t   return map { $_->[0] }\n\t\t  sort { $a->[1] <=> $b->[1] || \n\t\t\t $a->[2] <=> $b->[2] } \n\t       map { [$_, $_->height, $_->internal_id ] } \n\t   values %{$self->{'_desc'}};\n       } else {\n\t   return map { $_->[0] }\n\t          sort { $a->[1] <=> $b->[1] } \n\t          map { [$_, $_->height ] }\n\t          values %{$self->{'_desc'}};\t   \n       }\n   }\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $taxon->remove_Descedent($taxon_foo);\n Function: Removes a specific taxon from being a Descendent of this taxon\n Returns : nothing\n Args    : An array of Bio::taxonomy::Taxon objects which have be previously\n           passed to the add_Descendent call of this object.\n\n\nsub remove_Descendent{\n   my ($self,@nodes) = @_;\n   foreach my $n ( @nodes ) { \n       if( $self->{'_desc'}->{$n->internal_id} ) {\n\t   $n->{'_ancestor'} = undef;\n\t   $self->{'_desc'}->{$n->internal_id}->{'_ancestor'} = undef;\n\t   delete $self->{'_desc'}->{$n->internal_id};\n\t   \n       } else { \n\t   $self->debug(sprintf(\"no taxon %s (%s) listed as a descendent in this taxon %s (%s)\\n\",$n->id, $n,$self->id,$self));\n\t   $self->debug(\"Descendents are \" . join(',', keys %{$self->{'_desc'}}).\"\\n\");\n       }\n   }\n   1;\n}\n\n=head2 remove_all_Descendents\n\n Title   : remove_all_Descendents\n Usage   : $taxon->remove_All_Descendents()\n Function: Cleanup the taxon's reference to descendents and reset\n           their ancestor pointers to undef, if you don't have a reference\n           to these objects after this call they will be cleanedup - so\n           a get_nodes from the Tree object would be a safe thing to do first\n Returns : nothing\n Args    : none\n\n\nsub remove_all_Descendents{\n   my ($self) = @_;\n   # this won't cleanup the taxa themselves if you also have\n   # a copy/pointer of them (I think)...\n   while( my ($node,$val) = each %{ $self->{'_desc'} } ) {\n       $val->{'_ancestor'} = undef;\n   }\n   $self->{'_desc'} = {};\n   1;\n}\n\n=head2 get_Descendents\n\n Title   : get_Descendents\n Usage   : my @taxa = $taxon->get_Descendents;\n Function: Recursively fetch all the taxa and their descendents\n           *NOTE* This is different from each_Descendent\n Returns : Array or Bio::Taxonomy::Taxon objects\n Args    : none\n\n\n# implemented in the interface \n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : $taxon->ancestor($newval)\n Function: Set the Ancestor\n Returns : value of ancestor\n Args    : newvalue (optional)\n\n\nsub ancestor {\n   my ($self, $value) = @_;\n   if (defined $value) {\n       $self->{'_ancestor'} = $value;\n   }\n   return $self->{'_ancestor'};\n}\n\n=head2 branch_length\n\n Title   : branch_length\n Usage   : $obj->branch_length($newval)\n Function:\n Example :\n Returns : value of branch_length\n Args    : newvalue (optional)\n\n\nsub branch_length {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'branch_length'} = $value;\n    }\n    return $self->{'branch_length'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description($newval)\n Function:\n Returns : value of description\n Args    : newvalue (optional)\n\n\nsub description {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_description'} = $value;\n   }\n   return $self->{'_description'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Set the taxonomic rank\n Returns : taxonomic rank of taxon\n Args    : newvalue (optional)\n\n\nsub rank {\n   my ($self,$value) = @_;\n   if (defined $value) {\n      $self->{'_rank'} = $value;\n   }\n   return $self->{'_rank'};\n}\n\n=head2 taxon\n\n Title   : taxon\n Usage   : $obj->taxon($newtaxon)\n Function: Set the name of the taxon\n Example :\n Returns : name of taxon\n Args    : newtaxon (optional)\n\n\n# because internal taxa have names too...\nsub taxon {\n   my ($self,$value) = @_;\n   if( defined $value  ) {\n       $self->{'_taxon'} = $value;\n   }\n   return $self->{'_taxon'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id($newval)\n Function:\n Example :\n Returns : value of id\n Args    : newvalue (optional)\n\n\nsub id {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       $self->{'_id'} = $value;\n   }\n   return $self->{'_id'};\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # ensure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\n=head2 internal_id\n\n Title   : internal_id\n Usage   : my $internalid = $taxon->internal_id\n Function: Returns the internal unique id for this taxon\n           (a monotonically increasing number for this in-memory implementation\n            but could be a database determined unique id in other \n\t    implementations)\n Returns : unique id\n Args    : none\n\n\nsub internal_id {\n   return $_[0]->_creation_id;\n}\n\n=head2 _creation_id\n\n Title   : _creation_id\n Usage   : $obj->_creation_id($newval)\n Function: a private method signifying the internal creation order\n Returns : value of _creation_id\n Args    : newvalue (optional)\n\n\n\nsub _creation_id {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_creation_id'} = $value;\n    }\n    return $self->{'_creation_id'} || 0;\n}\n\n# The following methods are implemented by NodeI decorated interface\n\n=head2 is_Leaf\n\n Title   : is_Leaf\n Usage   : if( $node->is_Leaf )\n Function: Get Leaf status\n Returns : boolean\n Args    : none\n\n\nsub is_Leaf {\n    my ($self) = @_;\n    my $rc = 0;\n    $rc = 1 if( ! defined $self->{'_desc'} ||\t\n\t\tkeys %{$self->{'_desc'}} == 0);\n    return $rc;\n}\n\n=head2 to_string\n\n Title   : to_string\n Usage   : my $str = $taxon->to_string()\n Function: For debugging, provide a taxon as a string\n Returns : string\n Args    : none\n\n\n=head2 height\n\n Title   : height\n Usage   : my $len = $taxon->height\n Function: Returns the height of the tree starting at this\n           taxon.  Height is the maximum branchlength.\n Returns : The longest length (weighting branches with branch_length) to a leaf\n Args    : none\n\n\nsub height { \n    my ($self) = @_;\n\n    return $self->{'_height'} if( defined $self->{'_height'} );\n    \n    if( $self->is_Leaf ) { \n      if( !defined $self->branch_length ) { \n\t      $self->debug(sprintf(\"Trying to calculate height of a taxon when a taxon (%s) has an undefined branch_length\",$self->id || '?' ));\n\t      return 0;\n      }\n      return $self->branch_length;\n   }\n   my $max = 0;\n   foreach my $subnode ( $self->each_Descendent ) { \n       my $s = $subnode->height;\n       if( $s > $max ) { $max = $s; }\n   }\n   return ($self->{'_height'} = $max + ($self->branch_length || 1));\n}\n\n=head2 invalidate_height\n\n Title   : invalidate_height\n Usage   : private helper method\n Function: Invalidate our cached value of the taxon's height in the tree\n Returns : nothing\n Args    : none\n\n\nsub invalidate_height { \n    my ($self) = @_;\n    \n    $self->{'_height'} = undef;\n    if( $self->ancestor ) {\n\t    $self->ancestor->invalidate_height;\n    }\n}\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj->classify()\n Function: a method to return the classification of a species\n Returns : name of taxon and ancestor's taxon recursively\n Args    : boolean to specify whether we want all taxa not just ranked \n           levels\n\n\nsub classify {\n   my ($self,$allnodes) = @_;\n\n   my @classification=($self->taxon);\n   my $node=$self;\n\n   while (defined $node->ancestor) {\n      push @classification, $node->ancestor->taxon if $allnodes==1;\n      $node=$node->ancestor;\n   }\n\n   return (@classification);\n}\n\n=head2 has_rank\n\n Title   : has_rank\n Usage   : $obj->has_rank($rank)\n Function: a method to query ancestors' rank\n Returns : boolean\n Args    : $rank\n\n\nsub has_rank {\n   my ($self,$rank) = @_;\n\n   return $self if $self->rank eq $rank;\n\n   while (defined $self->ancestor) {\n      return $self if $self->ancestor->rank eq $rank;\n      $self=$self->ancestor;\n   }\n\n   return;\n}\n\n=head2 has_taxon\n\n Title   : has_taxon\n Usage   : $obj->has_taxon($taxon)\n Function: a method to query ancestors' taxa\n Returns : boolean\n Args    : Bio::Taxonomy::Taxon object\n\n\nsub has_taxon {\n   my ($self,$taxon) = @_;\n\n   return $self if \n      ((defined $self->id && $self->id == $taxon->id) ||\n      ($self->taxon eq $taxon->taxon && $self->rank eq $taxon->rank));\n\n   while (defined $self->ancestor) {\n      return $self if \n         ((defined $self->id && $self->id == $taxon->id) ||\n         ($self->taxon eq $taxon->taxon && $self->rank eq $taxon->rank) &&\n         ($self->taxon ne 'no rank'));\n      $self=$self->ancestor;\n   }\n\n   return;\n}\n\n=head2 distance_to_root\n\n Title   : distance_to_root\n Usage   : $obj->distance_to_root\n Function: a method to query ancestors' taxa\n Returns : number of links to root\n Args    :\n\n\nsub distance_to_root {\n   my ($self,$taxon) = @_;\n\n   my $count=0;\n\n   while (defined $self->ancestor) {\n      $count++;\n      $self=$self->ancestor;\n   }\n\n   return $count;\n}\n\n=head2 recent_common_ancestor\n\n Title   : recent_common_ancestor\n Usage   : $obj->recent_common_ancestor($taxon)\n Function: a method to query find common ancestors\n Returns : Bio::Taxonomy::Taxon of query or undef if no ancestor of rank\n Args    : Bio::Taxonomy::Taxon\n\n\nsub recent_common_ancestor {\n   my ($self,$node) = @_;\n\n   while (defined $node->ancestor) {\n      my $common=$self->has_taxon($node);\n      return $common if defined $common;\n      $node=$node->ancestor;\n   }\n\n   return;\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj=$taxon->species;\n Function: Returns a Bio::Species object reflecting the taxon's tree position\n Returns : a Bio::Species object\n Args    : none","label":"species($self)"},"children":[{"definition":"my","line":628,"name":"$self","kind":13,"localvar":"my","containerName":"species"},{"definition":"my","name":"$species","localvar":"my","kind":13,"containerName":"species","line":629},{"containerName":"species","kind":13,"name":"$self","line":631},{"line":631,"name":"has_rank","kind":12,"containerName":"species"},{"kind":13,"containerName":"species","name":"$self","line":631},{"name":"ancestor","containerName":"species","kind":12,"line":631},{"line":631,"kind":12,"containerName":"species","name":"rank"},{"line":632,"name":"$species","kind":13,"containerName":"species"},{"containerName":"species","kind":12,"name":"new","line":632},{"line":632,"kind":13,"containerName":"species","name":"$self"},{"name":"ancestor","containerName":"species","kind":12,"line":632},{"line":632,"kind":12,"containerName":"species","name":"classify"},{"line":633,"name":"$species","kind":13,"containerName":"species"},{"name":"genus","kind":12,"containerName":"species","line":633},{"line":633,"containerName":"species","kind":13,"name":"$self"},{"line":633,"name":"ancestor","containerName":"species","kind":12},{"line":633,"name":"ancestor","containerName":"species","kind":12},{"name":"taxon","kind":12,"containerName":"species","line":633},{"line":634,"name":"$species","kind":13,"containerName":"species"},{"line":634,"name":"species","kind":12,"containerName":"species"},{"line":634,"kind":13,"containerName":"species","name":"$self"},{"line":634,"containerName":"species","kind":12,"name":"ancestor"},{"line":634,"kind":12,"containerName":"species","name":"taxon"},{"line":635,"kind":13,"containerName":"species","name":"$species"},{"containerName":"species","kind":12,"name":"sub_species","line":635},{"name":"$self","kind":13,"containerName":"species","line":635},{"name":"taxon","kind":12,"containerName":"species","line":635},{"line":636,"name":"$self","containerName":"species","kind":13},{"containerName":"species","kind":12,"name":"has_rank","line":636},{"line":637,"containerName":"species","kind":13,"name":"$species"},{"containerName":"species","kind":12,"name":"new","line":637},{"line":637,"name":"$self","containerName":"species","kind":13},{"name":"classify","kind":12,"containerName":"species","line":637},{"containerName":"species","kind":13,"name":"$species","line":638},{"containerName":"species","kind":12,"name":"genus","line":638},{"name":"$self","containerName":"species","kind":13,"line":638},{"name":"ancestor","kind":12,"containerName":"species","line":638},{"containerName":"species","kind":12,"name":"taxon","line":638},{"line":639,"containerName":"species","kind":13,"name":"$species"},{"line":639,"name":"species","containerName":"species","kind":12},{"line":639,"kind":13,"containerName":"species","name":"$self"},{"line":639,"name":"taxon","containerName":"species","kind":12},{"containerName":"species","kind":13,"name":"$self","line":641},{"name":"throw","kind":12,"containerName":"species","line":641},{"kind":13,"containerName":"species","name":"$species","line":643}],"name":"species","containerName":"main::","definition":"sub","detail":"($self)"},{"containerName":"Species","kind":12,"name":"Bio","line":632},{"kind":12,"containerName":"Species","name":"Bio","line":637}],"version":5}