{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":156},{"kind":13,"containerName":"main::","name":"%lookUp","line":161,"definition":"our"},{"name":"new","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"new","name":"$class","line":230,"definition":"my"},{"kind":13,"containerName":"new","name":"@args","line":230},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$self","line":231},{"name":"$class","kind":13,"containerName":"new","line":231},{"line":231,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":232,"containerName":"new","localvar":"my","kind":13,"name":"$io"},{"name":"new","kind":12,"containerName":"new","line":232},{"line":232,"containerName":"new","kind":13,"name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":233},{"kind":12,"containerName":"new","name":"_parse","line":233},{"line":233,"name":"$io","containerName":"new","kind":13},{"line":233,"name":"_fh","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$io","line":234},{"line":234,"name":"close","containerName":"new","kind":12},{"line":235,"kind":13,"containerName":"new","name":"$self"}],"detail":"($class,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":236},"start":{"line":229,"character":0}},"line":229,"signature":{"documentation":"1;\n# $Header$\n#\n# bioperl module for Bio::Structure::SecStr::DSSP::Res.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ed Green <ed@compbio.berkeley.edu>\n#\n# Copyright Univ. of California\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::SecStr::DSSP::Res - Module for parsing/accessing dssp output\n\n=head1 SYNOPSIS\n\n  my $dssp_obj = Bio::Structure::SecStr::DSSP::Res->new('-file'=>'filename.dssp');\n\n  # or\n\n  my $dssp_obj = Bio::Structure::SecStr::DSSP::Res->new('-fh'=>\\*STDOUT);\n\n  # get DSSP defined Secondary Structure for residue 20\n  $sec_str = $dssp_obj->resSecStr( 20 );\n\n  # get dssp defined sec. structure summary for PDB residue  # 10 of chain A\n\n  $sec_str = $dssp_obj->resSecStrSum( '10:A' );\n\n=head1 DESCRIPTION\n\nDSSP::Res is a module for objectifying DSSP output.  Methods are then\navailable for extracting all the information within the output file\nand convenient subsets of it.\nThe principal purpose of DSSP is to determine secondary structural\nelements of a given structure.\n\n    ( Dictionary of protein secondary structure: pattern recognition\n      of hydrogen-bonded and geometrical features.\n      Biopolymers. 1983 Dec;22(12):2577-637. )\n\nThe DSSP program is available from:\n  http://www.cmbi.kun.nl/swift/dssp\n\nThis information is available on a per residue basis ( see resSecStr\nand resSecStrSum methods ) or on a per chain basis ( see secBounds\nmethod ).\n\nresSecStr() & secBounds() return one of the following:\n    'H' = alpha helix\n    'B' = residue in isolated beta-bridge\n    'E' = extended strand, participates in beta ladder\n    'G' = 3-helix (3/10 helix)\n    'I' = 5 helix (pi helix)\n    'T' = hydrogen bonded turn\n    'S' = bend\n    ''  = no assignment\n\nA more general classification is returned using the resSecStrSum()\nmethod.  The purpose of this is to have a method for DSSP and STRIDE\nderived output whose range is the same.\nIts output is one of the following:\n\n    'H' = helix         ( => 'H', 'G', or 'I' from above )\n    'B' = beta          ( => 'B' or 'E' from above )\n    'T' = turn          ( => 'T' or 'S' from above )\n    ' ' = no assignment ( => ' ' from above )\n\nThe methods are roughly divided into 3 sections:\n1.  Global features of this structure (PDB ID, total surface area,\n    etc.).  These methods do not require an argument.\n2.  Residue specific features ( amino acid, secondary structure,\n    solvent exposed surface area, etc. ).  These methods do require an\n    arguement.  The argument is supposed to uniquely identify a\n    residue described within the structure.  It can be of any of the\n    following forms:\n    ('#A:B') or ( #, 'A', 'B' )\n      || |\n      || - Chain ID (blank for single chain)\n      |--- Insertion code for this residue.  Blank for most residues.\n      |--- Numeric portion of residue ID.\n\n    (#)\n     |\n     --- Numeric portion of residue ID.  If there is only one chain and\n         it has no ID AND there is no residue with an insertion code at this\n         number, then this can uniquely specify a residue.\n\n    ('#:C') or ( #, 'C' )\n      | |\n      | -Chain ID\n      ---Numeric portion of residue ID.\n\n  If a residue is incompletely specified then the first residue that\n  fits the arguments is returned.  For example, if 19 is the argument\n  and there are three chains, A, B, and C with a residue whose number\n  is 19, then 19:A will be returned (assuming its listed first).\n\n  Since neither DSSP nor STRIDE correctly handle alt-loc codes, they\n  are not supported by these modules.\n\n3.  Value-added methods.  Return values are not verbatem strings\n    parsed from DSSP or STRIDE output.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ed Green\n\nEmail ed@compbio.berkeley.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each method.\nInternal methods are preceded with a _\n\n\npackage Bio::Structure::SecStr::DSSP::Res;\nuse strict;\nuse Bio::Root::IO;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n# Would be a class variable if Perl had them\n\n               #attribute        begin col        # columns\nour %lookUp = ( 'pdb_resnum'     => [  5,           5 ],\n\t\t'insertionco'    => [  10,          1 ],\n\t\t'pdb_chain'      => [  11,          1 ],\n\t\t\n\t\t'amino_acid'     => [  13,          1 ],\n\t\t'term_sig'       => [  14,          1 ],\n\t\t\n\t\t'ss_summary'     => [  16,          1 ],\n\t\t'3tph'           => [  18,          1 ],\n\t\t'4tph'           => [  19,          1 ],\n\t\t'5tph'           => [  20,          1 ],\n\t\t'geo_bend'       => [  21,          1 ],\n\t\t'chirality'      => [  22,          1 ],\n\t\t'beta_br1la'     => [  23,          1 ],\n\t\t'beta_br2la'     => [  24,          1 ],\n\n\t\t'bb_part1nu'     => [  25,          4 ],\n\t\t'bb_part2nu'     => [  29,          4 ],\n\t\t'betash_lab'     => [  33,          1 ],\n\t\t\n\t\t'solv_acces'     => [  34,          4 ],\n\t\t\n\t\t'hb1_nh_o_p'     => [  39,          6 ],\n\t\t'hb1_nh_o_e'     => [  46,          4 ],\n\t\t\n\t\t'hb1_o_hn_p'     => [  50,          6 ],\n\t\t'hb1_o_hn_e'     => [  57,          4 ],\n\t\t\n\t\t'hb2_nh_o_p'     => [  61,          6 ],\n\t\t'hb2_nh_o_e'     => [  68,          4 ],\n\t\t\n\t\t'hb2_o_hn_p'     => [  72,          6 ],\n\t\t'hb2_o_hn_e'     => [  79,          4 ],\n\t\t\n\t\t'tco'            => [  85,          6 ],\n\t\t\n\t\t'kappa'          => [  91,          6 ],\n\t\t\n\t\t'alpha'          => [  97,          6 ],\n\t\n\t\t'phi'            => [ 103,          6 ],\n\n\t\t'psi'            => [ 109,          6 ],\n\t\t\n\t\t'x_ca'           => [ 115,          7 ],\n\t\t\n\t\t'y_ca'           => [ 122,          7 ],\n\t\t\n\t\t'z_ca'           => [ 129,          7 ] );\n\n\n=head1 CONSTRUCTOR\n\n\n\n\n=head2 new\n\n Title         : new\n Usage         : makes new object of this class\n Function      : Constructor\n Example       : $dssp_obj = Bio::DSSP:Res->new( filename or FILEHANDLE )\n Returns       : object (ref)\n Args          : filename ( must be proper DSSP output file )","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"line":231,"name":"SUPER","containerName":"new","kind":12},{"kind":12,"containerName":"Root::IO","name":"Bio","line":232},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"totSurfArea","kind":13,"line":257},{"line":258,"name":"$self","containerName":"totSurfArea","kind":13}],"containerName":"main::","name":"totSurfArea","line":256,"range":{"start":{"character":0,"line":256},"end":{"line":259,"character":9999}},"kind":12},{"line":274,"kind":12,"range":{"end":{"character":9999,"line":296},"start":{"character":0,"line":274}},"definition":"sub","children":[{"definition":"my","line":275,"localvar":"my","kind":13,"containerName":"numResidues","name":"$self"},{"name":"$chain","localvar":"my","kind":13,"containerName":"numResidues","line":276,"definition":"my"},{"line":277,"kind":13,"containerName":"numResidues","name":"$chain"},{"line":278,"containerName":"numResidues","kind":13,"name":"$self"},{"definition":"my","line":281,"containerName":"numResidues","localvar":"my","kind":13,"name":"$num_res"},{"line":282,"containerName":"numResidues","kind":13,"name":"$cont_seg"},{"line":283,"name":"$cont_seg_pnt","kind":13,"localvar":"my","containerName":"numResidues","definition":"my"},{"name":"$self","kind":13,"containerName":"numResidues","line":283},{"line":283,"name":"_contSegs","kind":12,"containerName":"numResidues"},{"containerName":"numResidues","kind":13,"name":"$cont_seg","line":284},{"line":284,"containerName":"numResidues","kind":13,"name":"$cont_seg_pnt"},{"line":285,"name":"$chain","containerName":"numResidues","kind":13},{"line":285,"name":"$cont_seg","kind":13,"containerName":"numResidues"},{"name":"$num_res","containerName":"numResidues","kind":13,"line":287},{"line":287,"name":"$self","containerName":"numResidues","kind":13},{"name":"_toDsspKey","containerName":"numResidues","kind":12,"line":287},{"line":287,"name":"$cont_seg","kind":13,"containerName":"numResidues"},{"line":288,"name":"$self","containerName":"numResidues","kind":13},{"line":288,"name":"_toDsspKey","containerName":"numResidues","kind":12},{"line":288,"kind":13,"containerName":"numResidues","name":"$cont_seg"},{"line":295,"name":"$num_res","containerName":"numResidues","kind":13}],"name":"numResidues","containerName":"main::"},{"definition":"sub","containerName":"main::","name":"pdbID","children":[{"definition":"my","line":314,"containerName":"pdbID","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"pdbID","line":315}],"kind":12,"range":{"end":{"character":9999,"line":316},"start":{"line":313,"character":0}},"line":313},{"definition":"sub","children":[{"definition":"my","line":331,"kind":13,"localvar":"my","containerName":"pdbAuthor","name":"$self"},{"line":332,"kind":13,"containerName":"pdbAuthor","name":"$self"}],"name":"pdbAuthor","containerName":"main::","line":330,"range":{"start":{"character":0,"line":330},"end":{"character":9999,"line":333}},"kind":12},{"kind":12,"range":{"start":{"line":347,"character":0},"end":{"line":350,"character":9999}},"line":347,"definition":"sub","containerName":"main::","name":"pdbCompound","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"pdbCompound","line":348},{"line":349,"name":"$self","kind":13,"containerName":"pdbCompound"}]},{"containerName":"main::","name":"pdbDate","children":[{"definition":"my","line":365,"name":"$self","localvar":"my","kind":13,"containerName":"pdbDate"},{"name":"$self","containerName":"pdbDate","kind":13,"line":366}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":364},"end":{"line":367,"character":9999}},"line":364},{"range":{"start":{"line":381,"character":0},"end":{"character":9999,"line":384}},"kind":12,"line":381,"definition":"sub","name":"pdbHeader","containerName":"main::","children":[{"definition":"my","containerName":"pdbHeader","localvar":"my","kind":13,"name":"$self","line":382},{"line":383,"containerName":"pdbHeader","kind":13,"name":"$self"}]},{"line":398,"kind":12,"range":{"end":{"line":401,"character":9999},"start":{"character":0,"line":398}},"children":[{"line":399,"localvar":"my","kind":13,"containerName":"pdbSource","name":"$self","definition":"my"},{"line":400,"kind":13,"containerName":"pdbSource","name":"$self"}],"name":"pdbSource","containerName":"main::","definition":"sub"},{"children":[{"definition":"my","line":419,"name":"$self","kind":13,"localvar":"my","containerName":"resAA"},{"definition":"my","line":420,"localvar":"my","kind":13,"containerName":"resAA","name":"@args"},{"name":"$dssp_key","containerName":"resAA","localvar":"my","kind":13,"line":421,"definition":"my"},{"name":"$self","kind":13,"containerName":"resAA","line":421},{"containerName":"resAA","kind":12,"name":"_toDsspKey","line":421},{"containerName":"resAA","kind":13,"name":"@args","line":421},{"name":"$self","kind":13,"containerName":"resAA","line":422},{"kind":13,"containerName":"resAA","name":"$dssp_key","line":422}],"name":"resAA","containerName":"main::","definition":"sub","line":418,"kind":12,"range":{"end":{"character":9999,"line":423},"start":{"line":418,"character":0}}},{"line":437,"range":{"start":{"line":437,"character":0},"end":{"line":442,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"resPhi","name":"$self","line":438},{"definition":"my","name":"@args","kind":13,"localvar":"my","containerName":"resPhi","line":439},{"definition":"my","localvar":"my","containerName":"resPhi","kind":13,"name":"$dssp_key","line":440},{"line":440,"kind":13,"containerName":"resPhi","name":"$self"},{"name":"_toDsspKey","kind":12,"containerName":"resPhi","line":440},{"line":440,"name":"@args","kind":13,"containerName":"resPhi"},{"line":441,"containerName":"resPhi","kind":13,"name":"$self"},{"name":"$dssp_key","kind":13,"containerName":"resPhi","line":441}],"containerName":"main::","name":"resPhi"},{"line":456,"range":{"start":{"character":0,"line":456},"end":{"character":9999,"line":461}},"kind":12,"definition":"sub","children":[{"line":457,"name":"$self","localvar":"my","kind":13,"containerName":"resPsi","definition":"my"},{"line":458,"name":"@args","localvar":"my","containerName":"resPsi","kind":13,"definition":"my"},{"line":459,"containerName":"resPsi","localvar":"my","kind":13,"name":"$dssp_key","definition":"my"},{"line":459,"kind":13,"containerName":"resPsi","name":"$self"},{"line":459,"containerName":"resPsi","kind":12,"name":"_toDsspKey"},{"name":"@args","kind":13,"containerName":"resPsi","line":459},{"line":460,"name":"$self","kind":13,"containerName":"resPsi"},{"line":460,"containerName":"resPsi","kind":13,"name":"$dssp_key"}],"name":"resPsi","containerName":"main::"},{"kind":12,"range":{"end":{"character":9999,"line":481},"start":{"character":0,"line":476}},"line":476,"name":"resSolvAcc","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"resSolvAcc","kind":13,"line":477},{"line":478,"name":"@args","localvar":"my","kind":13,"containerName":"resSolvAcc","definition":"my"},{"definition":"my","line":479,"name":"$dssp_key","localvar":"my","kind":13,"containerName":"resSolvAcc"},{"line":479,"kind":13,"containerName":"resSolvAcc","name":"$self"},{"line":479,"name":"_toDsspKey","kind":12,"containerName":"resSolvAcc"},{"line":479,"name":"@args","containerName":"resSolvAcc","kind":13},{"name":"$self","kind":13,"containerName":"resSolvAcc","line":480},{"name":"$dssp_key","containerName":"resSolvAcc","kind":13,"line":480}],"definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":496},"end":{"character":9999,"line":501}},"line":496,"name":"resSurfArea","containerName":"main::","children":[{"line":497,"kind":13,"localvar":"my","containerName":"resSurfArea","name":"$self","definition":"my"},{"line":498,"localvar":"my","containerName":"resSurfArea","kind":13,"name":"@args","definition":"my"},{"line":499,"name":"$dssp_key","localvar":"my","containerName":"resSurfArea","kind":13,"definition":"my"},{"containerName":"resSurfArea","kind":13,"name":"$self","line":499},{"line":499,"kind":12,"containerName":"resSurfArea","name":"_toDsspKey"},{"containerName":"resSurfArea","kind":13,"name":"@args","line":499},{"name":"$self","kind":13,"containerName":"resSurfArea","line":500},{"containerName":"resSurfArea","kind":13,"name":"$dssp_key","line":500}],"definition":"sub"},{"definition":"sub","name":"resSecStr","containerName":"main::","children":[{"line":519,"name":"$self","localvar":"my","containerName":"resSecStr","kind":13,"definition":"my"},{"line":520,"containerName":"resSecStr","localvar":"my","kind":13,"name":"@args","definition":"my"},{"definition":"my","line":521,"kind":13,"localvar":"my","containerName":"resSecStr","name":"$dssp_key"},{"kind":13,"containerName":"resSecStr","name":"$self","line":521},{"line":521,"name":"_toDsspKey","kind":12,"containerName":"resSecStr"},{"name":"@args","kind":13,"containerName":"resSecStr","line":521},{"line":522,"name":"$ss_char","localvar":"my","containerName":"resSecStr","kind":13,"definition":"my"},{"kind":13,"containerName":"resSecStr","name":"$self","line":522},{"line":522,"kind":13,"containerName":"resSecStr","name":"$dssp_key"},{"containerName":"resSecStr","kind":13,"name":"$ss_char","line":523},{"line":523,"kind":13,"containerName":"resSecStr","name":"$ss_char"}],"range":{"start":{"character":0,"line":518},"end":{"line":525,"character":9999}},"kind":12,"line":518},{"definition":"sub","name":"resSecStrSum","containerName":"main::","children":[{"name":"$self","containerName":"resSecStrSum","localvar":"my","kind":13,"line":547,"definition":"my"},{"definition":"my","containerName":"resSecStrSum","localvar":"my","kind":13,"name":"@args","line":548},{"line":549,"name":"$dssp_key","kind":13,"localvar":"my","containerName":"resSecStrSum","definition":"my"},{"line":549,"name":"$self","kind":13,"containerName":"resSecStrSum"},{"line":549,"name":"_toDsspKey","kind":12,"containerName":"resSecStrSum"},{"line":549,"name":"@args","containerName":"resSecStrSum","kind":13},{"localvar":"my","containerName":"resSecStrSum","kind":13,"name":"$ss_char","line":550,"definition":"my"},{"name":"$self","containerName":"resSecStrSum","kind":13,"line":550},{"line":550,"kind":13,"containerName":"resSecStrSum","name":"$dssp_key"},{"line":551,"kind":13,"containerName":"resSecStrSum","name":"$ss_char"},{"kind":13,"containerName":"resSecStrSum","name":"$ss_char","line":551},{"line":551,"name":"$ss_char","containerName":"resSecStrSum","kind":13},{"line":554,"containerName":"resSecStrSum","kind":13,"name":"$ss_char"},{"line":554,"name":"$ss_char","containerName":"resSecStrSum","kind":13},{"name":"$ss_char","containerName":"resSecStrSum","kind":13,"line":557},{"name":"$ss_char","kind":13,"containerName":"resSecStrSum","line":557}],"kind":12,"range":{"start":{"character":0,"line":546},"end":{"character":9999,"line":563}},"line":546},{"line":593,"range":{"start":{"line":593,"character":0},"end":{"character":9999,"line":596}},"kind":12,"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"hBonds","line":594},{"line":595,"name":"$self","containerName":"hBonds","kind":13}],"name":"hBonds","containerName":"main::","definition":"sub"},{"name":"numSSBr","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"numSSBr","kind":13,"name":"$self","line":611},{"line":612,"containerName":"numSSBr","kind":13,"name":"$self"},{"line":613,"kind":13,"containerName":"numSSBr","name":"$self"},{"line":614,"name":"$self","containerName":"numSSBr","kind":13}],"definition":"sub","range":{"start":{"character":0,"line":610},"end":{"line":615,"character":9999}},"kind":12,"line":610},{"containerName":"main::","name":"resHB_O_HN","children":[{"definition":"my","line":636,"name":"$self","containerName":"resHB_O_HN","localvar":"my","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"resHB_O_HN","name":"@args","line":637},{"line":638,"containerName":"resHB_O_HN","localvar":"my","kind":13,"name":"$dssp_key","definition":"my"},{"name":"$self","containerName":"resHB_O_HN","kind":13,"line":638},{"line":638,"kind":12,"containerName":"resHB_O_HN","name":"_toDsspKey"},{"name":"@args","containerName":"resHB_O_HN","kind":13,"line":638},{"line":639,"name":"$self","kind":13,"containerName":"resHB_O_HN"},{"line":639,"name":"$dssp_key","kind":13,"containerName":"resHB_O_HN"},{"line":640,"kind":13,"containerName":"resHB_O_HN","name":"$self"},{"line":640,"name":"$dssp_key","kind":13,"containerName":"resHB_O_HN"},{"kind":13,"containerName":"resHB_O_HN","name":"$self","line":641},{"line":641,"kind":13,"containerName":"resHB_O_HN","name":"$dssp_key"},{"line":642,"name":"$self","kind":13,"containerName":"resHB_O_HN"},{"name":"$dssp_key","containerName":"resHB_O_HN","kind":13,"line":642}],"definition":"sub","range":{"end":{"character":9999,"line":643},"start":{"character":0,"line":635}},"kind":12,"line":635},{"containerName":"main::","name":"resHB_NH_O","children":[{"line":665,"containerName":"resHB_NH_O","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","containerName":"resHB_NH_O","localvar":"my","kind":13,"name":"@args","line":666},{"line":667,"localvar":"my","containerName":"resHB_NH_O","kind":13,"name":"$dssp_key","definition":"my"},{"kind":13,"containerName":"resHB_NH_O","name":"$self","line":667},{"containerName":"resHB_NH_O","kind":12,"name":"_toDsspKey","line":667},{"name":"@args","kind":13,"containerName":"resHB_NH_O","line":667},{"line":668,"name":"$self","containerName":"resHB_NH_O","kind":13},{"kind":13,"containerName":"resHB_NH_O","name":"$dssp_key","line":668},{"line":669,"name":"$self","containerName":"resHB_NH_O","kind":13},{"line":669,"kind":13,"containerName":"resHB_NH_O","name":"$dssp_key"},{"line":670,"containerName":"resHB_NH_O","kind":13,"name":"$self"},{"line":670,"name":"$dssp_key","kind":13,"containerName":"resHB_NH_O"},{"line":671,"kind":13,"containerName":"resHB_NH_O","name":"$self"},{"kind":13,"containerName":"resHB_NH_O","name":"$dssp_key","line":671}],"definition":"sub","kind":12,"range":{"end":{"line":672,"character":9999},"start":{"line":664,"character":0}},"line":664},{"range":{"end":{"line":692,"character":9999},"start":{"line":687,"character":0}},"kind":12,"line":687,"containerName":"main::","name":"resTco","children":[{"definition":"my","line":688,"name":"$self","localvar":"my","kind":13,"containerName":"resTco"},{"line":689,"name":"@args","kind":13,"localvar":"my","containerName":"resTco","definition":"my"},{"definition":"my","containerName":"resTco","localvar":"my","kind":13,"name":"$dssp_key","line":690},{"line":690,"name":"$self","kind":13,"containerName":"resTco"},{"line":690,"name":"_toDsspKey","containerName":"resTco","kind":12},{"name":"@args","kind":13,"containerName":"resTco","line":690},{"line":691,"kind":13,"containerName":"resTco","name":"$self"},{"name":"$dssp_key","kind":13,"containerName":"resTco","line":691}],"definition":"sub"},{"line":707,"kind":12,"range":{"end":{"line":712,"character":9999},"start":{"character":0,"line":707}},"definition":"sub","children":[{"localvar":"my","containerName":"resKappa","kind":13,"name":"$self","line":708,"definition":"my"},{"definition":"my","localvar":"my","containerName":"resKappa","kind":13,"name":"@args","line":709},{"line":710,"kind":13,"localvar":"my","containerName":"resKappa","name":"$dssp_key","definition":"my"},{"name":"$self","kind":13,"containerName":"resKappa","line":710},{"name":"_toDsspKey","kind":12,"containerName":"resKappa","line":710},{"line":710,"containerName":"resKappa","kind":13,"name":"@args"},{"name":"$self","containerName":"resKappa","kind":13,"line":711},{"kind":13,"containerName":"resKappa","name":"$dssp_key","line":711}],"name":"resKappa","containerName":"main::"},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"resAlpha","line":728,"definition":"my"},{"definition":"my","localvar":"my","containerName":"resAlpha","kind":13,"name":"@args","line":729},{"localvar":"my","containerName":"resAlpha","kind":13,"name":"$dssp_key","line":730,"definition":"my"},{"line":730,"name":"$self","containerName":"resAlpha","kind":13},{"name":"_toDsspKey","containerName":"resAlpha","kind":12,"line":730},{"name":"@args","kind":13,"containerName":"resAlpha","line":730},{"name":"$self","kind":13,"containerName":"resAlpha","line":731},{"line":731,"kind":13,"containerName":"resAlpha","name":"$dssp_key"}],"name":"resAlpha","containerName":"main::","definition":"sub","line":727,"range":{"end":{"line":732,"character":9999},"start":{"character":0,"line":727}},"kind":12},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"secBounds","line":755},{"line":756,"name":"$chain","localvar":"my","containerName":"secBounds","kind":13,"definition":"my"},{"line":757,"containerName":"secBounds","localvar":"my","kind":13,"name":"%sec_bounds","definition":"my"},{"line":759,"name":"$chain","kind":13,"containerName":"secBounds"},{"containerName":"secBounds","kind":13,"name":"$chain","line":759},{"containerName":"secBounds","kind":13,"name":"$chain","line":759},{"line":759,"containerName":"secBounds","kind":13,"name":"$chain"},{"line":762,"name":"$self","kind":13,"containerName":"secBounds"},{"containerName":"secBounds","kind":13,"name":"$self","line":764},{"line":764,"name":"$chain","kind":13,"containerName":"secBounds"},{"line":765,"name":"$self","containerName":"secBounds","kind":13},{"name":"throw","kind":12,"containerName":"secBounds","line":765},{"line":767,"name":"$self","containerName":"secBounds","kind":13},{"name":"$chain","containerName":"secBounds","kind":13,"line":767},{"definition":"my","containerName":"secBounds","localvar":"my","kind":13,"name":"$cur_element","line":770},{"name":"$i","containerName":"secBounds","kind":13,"line":770},{"line":770,"containerName":"secBounds","kind":13,"name":"$cur_chain"},{"line":770,"kind":13,"containerName":"secBounds","name":"$beg"},{"line":773,"containerName":"secBounds","kind":13,"name":"$cur_element"},{"containerName":"secBounds","kind":13,"name":"$self","line":773},{"line":774,"name":"$beg","kind":13,"containerName":"secBounds"},{"line":776,"name":"$i","kind":13,"containerName":"secBounds"},{"line":776,"name":"$i","kind":13,"containerName":"secBounds"},{"line":776,"containerName":"secBounds","kind":13,"name":"$self"},{"line":776,"containerName":"secBounds","kind":12,"name":"_numResLines"},{"containerName":"secBounds","kind":13,"name":"$i","line":776},{"kind":13,"containerName":"secBounds","name":"$self","line":777},{"containerName":"secBounds","kind":13,"name":"$i","line":777},{"name":"$sec_bounds","kind":13,"containerName":"secBounds","line":779},{"containerName":"secBounds","kind":13,"name":"$self","line":779},{"kind":12,"containerName":"secBounds","name":"_pdbChain","line":779},{"line":779,"name":"$beg","kind":13,"containerName":"secBounds"},{"name":"$self","containerName":"secBounds","kind":13,"line":780},{"line":780,"name":"_toPdbId","kind":12,"containerName":"secBounds"},{"kind":13,"containerName":"secBounds","name":"$beg","line":780},{"line":781,"containerName":"secBounds","kind":13,"name":"$self"},{"line":781,"kind":12,"containerName":"secBounds","name":"_toPdbId"},{"kind":13,"containerName":"secBounds","name":"$i","line":781},{"line":782,"name":"$cur_element","kind":13,"containerName":"secBounds"},{"line":783,"name":"$i","kind":13,"containerName":"secBounds"},{"line":784,"containerName":"secBounds","kind":13,"name":"$beg"},{"line":784,"kind":13,"containerName":"secBounds","name":"$i"},{"line":785,"kind":13,"containerName":"secBounds","name":"$cur_element"},{"line":785,"name":"$self","kind":13,"containerName":"secBounds"},{"line":785,"kind":13,"containerName":"secBounds","name":"$i"},{"line":788,"name":"$self","containerName":"secBounds","kind":13},{"line":788,"name":"$i","containerName":"secBounds","kind":13},{"line":788,"name":"$cur_element","kind":13,"containerName":"secBounds"},{"kind":13,"containerName":"secBounds","name":"$sec_bounds","line":790},{"line":790,"name":"$self","kind":13,"containerName":"secBounds"},{"line":790,"name":"_pdbChain","kind":12,"containerName":"secBounds"},{"containerName":"secBounds","kind":13,"name":"$beg","line":790},{"line":791,"containerName":"secBounds","kind":13,"name":"$self"},{"containerName":"secBounds","kind":12,"name":"_toPdbId","line":791},{"line":791,"kind":13,"containerName":"secBounds","name":"$beg"},{"line":792,"containerName":"secBounds","kind":13,"name":"$self"},{"kind":12,"containerName":"secBounds","name":"_toPdbId","line":792},{"kind":13,"containerName":"secBounds","name":"$i","line":792},{"line":793,"name":"$cur_element","kind":13,"containerName":"secBounds"},{"containerName":"secBounds","kind":13,"name":"$beg","line":794},{"line":794,"kind":13,"containerName":"secBounds","name":"$i"},{"containerName":"secBounds","kind":13,"name":"$cur_element","line":795},{"name":"$self","containerName":"secBounds","kind":13,"line":795},{"line":795,"containerName":"secBounds","kind":13,"name":"$i"}],"containerName":"main::","name":"secBounds","definition":"sub","line":754,"range":{"end":{"character":9999,"line":796},"start":{"line":754,"character":0}},"kind":12},{"name":"%self","containerName":null,"kind":13,"line":799},{"containerName":null,"kind":13,"name":"%i","line":799},{"line":799,"containerName":null,"kind":13,"name":"%cur_element"},{"line":800,"name":"%sec_bounds","kind":13,"containerName":null},{"line":800,"name":"$self","containerName":null,"kind":13},{"name":"_pdbChain","kind":12,"containerName":"main::","line":800},{"name":"@beg","containerName":null,"kind":13,"line":800},{"kind":13,"containerName":null,"name":"$self","line":801},{"containerName":"main::","kind":12,"name":"_toPdbId","line":801},{"containerName":null,"kind":13,"name":"$beg","line":801},{"line":802,"containerName":null,"kind":13,"name":"$self"},{"line":802,"kind":12,"containerName":"main::","name":"_toPdbId"},{"line":802,"name":"$i","containerName":null,"kind":13},{"line":803,"name":"%cur_element","containerName":null,"kind":13},{"line":807,"name":"%sec_bounds","kind":13,"containerName":null},{"line":807,"name":"$self","containerName":null,"kind":13},{"line":807,"containerName":"main::","kind":12,"name":"_pdbChain"},{"line":807,"kind":13,"containerName":null,"name":"@beg"},{"line":808,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"_toPdbId","line":808},{"name":"$beg","containerName":null,"kind":13,"line":808},{"line":809,"name":"$self","containerName":null,"kind":13},{"name":"_toPdbId","containerName":"main::","kind":12,"line":809},{"line":809,"name":"$i","kind":13,"containerName":null},{"name":"$cur_element","containerName":null,"kind":13,"line":810},{"kind":13,"containerName":null,"name":"%sec_bounds","line":811},{"line":811,"name":"$self","containerName":null,"kind":13},{"line":811,"kind":12,"containerName":"main::","name":"_pdbChain"},{"kind":13,"containerName":null,"name":"@i","line":811},{"name":"$self","kind":13,"containerName":null,"line":812},{"containerName":"main::","kind":12,"name":"_toPdbId","line":812},{"line":812,"containerName":null,"kind":13,"name":"$i"},{"kind":13,"containerName":null,"name":"$self","line":813},{"line":813,"name":"_toPdbId","kind":12,"containerName":"main::"},{"name":"$i","containerName":null,"kind":13,"line":813},{"line":814,"name":"%self","containerName":null,"kind":13},{"name":"%i","containerName":null,"kind":13,"line":814},{"kind":13,"containerName":null,"name":"%self","line":817},{"kind":13,"containerName":null,"name":"%sec_bounds","line":817},{"containerName":null,"kind":13,"name":"%self","line":820},{"name":"%chain","kind":13,"containerName":null,"line":820},{"line":821,"containerName":null,"kind":13,"name":"$self"},{"line":821,"name":"throw","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"%self","line":824},{"name":"$chain","containerName":null,"kind":13,"line":824},{"name":"chains","containerName":"main::","children":[{"line":842,"containerName":"chains","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","containerName":"chains","localvar":"my","kind":13,"name":"$cont_segs","line":843},{"name":"$self","containerName":"chains","kind":13,"line":843},{"line":843,"name":"_contSegs","containerName":"chains","kind":12},{"definition":"my","localvar":"my","containerName":"chains","kind":13,"name":"%chains","line":844},{"line":845,"name":"$seg","containerName":"chains","localvar":"my","kind":13,"definition":"my"},{"line":846,"name":"$seg","kind":13,"containerName":"chains"},{"line":846,"name":"$cont_segs","kind":13,"containerName":"chains"}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":846},"start":{"character":0,"line":841}},"line":841},{"line":847,"name":"%chains","containerName":null,"kind":13},{"name":"@seg","kind":13,"containerName":null,"line":847},{"name":"@chains","localvar":"my","containerName":null,"kind":13,"line":849,"definition":"my"},{"containerName":null,"kind":13,"name":"%chains","line":849},{"name":"@chains","kind":13,"containerName":null,"line":850},{"definition":"sub","containerName":"main::","name":"residues","children":[{"name":"$self","containerName":"residues","localvar":"my","kind":13,"line":873,"definition":"my"},{"localvar":"my","containerName":"residues","kind":13,"name":"$chain","line":874,"definition":"my"},{"name":"@residues","containerName":"residues","localvar":"my","kind":13,"line":875,"definition":"my"},{"name":"$num_res","localvar":"my","containerName":"residues","kind":13,"line":876,"definition":"my"},{"line":876,"kind":13,"containerName":"residues","name":"$self"},{"line":876,"containerName":"residues","kind":12,"name":"_numResLines"},{"containerName":"residues","localvar":"my","kind":13,"name":"$aa","line":877,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"residues","name":"$i","line":878},{"containerName":"residues","kind":13,"name":"$i","line":878},{"containerName":"residues","kind":13,"name":"$num_res","line":878},{"line":878,"name":"$i","containerName":"residues","kind":13},{"line":882,"name":"$aa","kind":13,"containerName":"residues"},{"line":882,"containerName":"residues","kind":13,"name":"$self"},{"line":882,"kind":13,"containerName":"residues","name":"$i"},{"kind":13,"containerName":"residues","name":"$aa","line":883},{"line":884,"containerName":"residues","kind":13,"name":"$chain"},{"containerName":"residues","kind":13,"name":"$chain","line":885},{"name":"$self","kind":13,"containerName":"residues","line":885},{"line":885,"containerName":"residues","kind":13,"name":"$i"},{"name":"@residues","kind":13,"containerName":"residues","line":886},{"name":"$self","containerName":"residues","kind":13,"line":887},{"containerName":"residues","kind":13,"name":"$i","line":887},{"containerName":"residues","kind":13,"name":"$self","line":888},{"name":"$i","kind":13,"containerName":"residues","line":888},{"line":890,"name":"$self","containerName":"residues","kind":13},{"containerName":"residues","kind":13,"name":"$i","line":890},{"name":"@residues","containerName":"residues","kind":13,"line":894}],"kind":12,"range":{"start":{"character":0,"line":872},"end":{"line":895,"character":9999}},"line":872},{"line":916,"kind":12,"range":{"end":{"line":943,"character":9999},"start":{"line":916,"character":0}},"definition":"sub","children":[{"definition":"my","line":917,"name":"$self","localvar":"my","kind":13,"containerName":"getSeq"},{"definition":"my","kind":13,"localvar":"my","containerName":"getSeq","name":"$chain","line":918},{"localvar":"my","kind":13,"containerName":"getSeq","name":"$pot_chain","line":920,"definition":"my"},{"name":"$seq","containerName":"getSeq","kind":13,"line":921},{"name":"$frag_num","kind":13,"containerName":"getSeq","line":922},{"line":923,"name":"$frag","containerName":"getSeq","kind":13},{"line":924,"containerName":"getSeq","kind":13,"name":"$curPdbNum"},{"line":925,"name":"$lastPdbNum","containerName":"getSeq","kind":13},{"name":"$gap_len","kind":13,"containerName":"getSeq","line":926},{"name":"$i","containerName":"getSeq","kind":13,"line":927},{"name":"$id","kind":13,"containerName":"getSeq","line":928},{"line":930,"name":"@frags","localvar":"my","kind":13,"containerName":"getSeq","definition":"my"},{"containerName":"getSeq","kind":13,"name":"$chain","line":932},{"name":"$chain","containerName":"getSeq","kind":13,"line":933},{"name":"$self","containerName":"getSeq","kind":13,"line":936},{"name":"$chain","kind":13,"containerName":"getSeq","line":936},{"containerName":"getSeq","kind":13,"name":"$self","line":937},{"line":937,"containerName":"getSeq","kind":13,"name":"$chain"},{"containerName":"getSeq","localvar":"my","kind":13,"name":"$contSegs_pnt","line":940,"definition":"my"},{"name":"$self","containerName":"getSeq","kind":13,"line":940},{"line":940,"name":"_contSegs","kind":12,"containerName":"getSeq"},{"name":"$pot_chain","containerName":"getSeq","kind":13,"line":943},{"kind":13,"containerName":"getSeq","name":"$contSegs_pnt","line":943}],"name":"getSeq","containerName":"main::"},{"line":944,"name":"@pot_chain","containerName":null,"kind":13},{"name":"%chain","containerName":null,"kind":13,"line":944},{"line":945,"containerName":null,"kind":13,"name":"@frags"},{"kind":13,"containerName":null,"name":"$pot_chain","line":945},{"kind":13,"containerName":null,"name":"@frags","line":950},{"name":"$chain","kind":13,"containerName":null,"line":951},{"name":"@contSegs_pnt","containerName":null,"kind":13,"line":951},{"containerName":null,"kind":13,"name":"$pot_chain","line":952},{"line":952,"containerName":null,"kind":13,"name":"%contSegs_pnt"},{"name":"@pot_chain","kind":13,"containerName":null,"line":953},{"line":953,"name":"%chain","kind":13,"containerName":null},{"name":"@frags","containerName":null,"kind":13,"line":954},{"line":954,"name":"$pot_chain","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$seq","line":960},{"kind":13,"containerName":null,"name":"$frag_num","line":961},{"containerName":null,"kind":13,"name":"$frag","line":962},{"line":962,"name":"@frags","containerName":null,"kind":13},{"line":963,"kind":13,"containerName":null,"name":"$frag_num"},{"name":"%frag_num","containerName":null,"kind":13,"line":964},{"line":965,"containerName":null,"kind":13,"name":"$curPdbNum"},{"kind":13,"containerName":null,"name":"$self","line":965},{"line":965,"name":"_pdbNum","kind":12,"containerName":"main::"},{"name":"@frag","kind":13,"containerName":null,"line":965},{"line":966,"kind":13,"containerName":null,"name":"$gap_len"},{"line":966,"containerName":null,"kind":13,"name":"$curPdbNum"},{"name":"$lastPdbNum","containerName":null,"kind":13,"line":966},{"kind":13,"containerName":null,"name":"%gap_len","line":967},{"kind":13,"containerName":null,"name":"$seq","line":968},{"containerName":null,"kind":13,"name":"%gap_len","line":968},{"name":"$seq","kind":13,"containerName":null,"line":971},{"kind":13,"containerName":null,"name":"$i","line":974},{"name":"@frag","kind":13,"containerName":null,"line":974},{"kind":13,"containerName":null,"name":"$i","line":974},{"name":"@frag","containerName":null,"kind":13,"line":974},{"name":"%i","containerName":null,"kind":13,"line":974},{"line":975,"containerName":null,"kind":13,"name":"$seq"},{"kind":13,"containerName":null,"name":"$self","line":975},{"line":975,"kind":12,"containerName":"main::","name":"_resAA"},{"line":975,"kind":13,"containerName":null,"name":"$i"},{"name":"$lastPdbNum","containerName":null,"kind":13,"line":977},{"name":"$self","containerName":null,"kind":13,"line":977},{"line":977,"name":"_pdbNum","kind":12,"containerName":"main::"},{"line":977,"kind":13,"containerName":null,"name":"$i"},{"line":982,"containerName":null,"kind":13,"name":"$id"},{"name":"$self","containerName":null,"kind":13,"line":982},{"name":"pdbID","containerName":"main::","kind":12,"line":982},{"line":983,"kind":13,"containerName":null,"name":"$id"},{"line":985,"kind":13,"containerName":null,"name":"%self"},{"line":985,"name":"$chain","containerName":null,"kind":13},{"name":"Bio","kind":12,"containerName":"PrimarySeq","line":985},{"line":985,"kind":12,"containerName":"main::","name":"new"},{"line":985,"containerName":null,"kind":13,"name":"$seq"},{"name":"$id","containerName":null,"kind":13,"line":986},{"name":"%self","kind":13,"containerName":null,"line":989},{"containerName":null,"kind":13,"name":"$chain","line":989},{"kind":12,"range":{"start":{"line":1009,"character":0},"end":{"character":9999,"line":1013}},"line":1009,"definition":"sub","containerName":"main::","name":"_pdbChain","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_pdbChain","kind":13,"line":1010},{"definition":"my","line":1011,"localvar":"my","containerName":"_pdbChain","kind":13,"name":"$dssp_key"},{"name":"$self","kind":13,"containerName":"_pdbChain","line":1012},{"containerName":"_pdbChain","kind":13,"name":"$dssp_key","line":1012}]},{"line":1027,"kind":12,"range":{"end":{"character":9999,"line":1031},"start":{"line":1027,"character":0}},"definition":"sub","children":[{"kind":13,"localvar":"my","containerName":"_resAA","name":"$self","line":1028,"definition":"my"},{"line":1029,"name":"$dssp_key","localvar":"my","containerName":"_resAA","kind":13,"definition":"my"},{"name":"$self","containerName":"_resAA","kind":13,"line":1030},{"kind":13,"containerName":"_resAA","name":"$dssp_key","line":1030}],"containerName":"main::","name":"_resAA"},{"definition":"sub","children":[{"localvar":"my","containerName":"_pdbNum","kind":13,"name":"$self","line":1050,"definition":"my"},{"line":1051,"name":"$dssp_key","localvar":"my","kind":13,"containerName":"_pdbNum","definition":"my"},{"containerName":"_pdbNum","kind":13,"name":"$self","line":1052},{"kind":13,"containerName":"_pdbNum","name":"$dssp_key","line":1052}],"name":"_pdbNum","containerName":"main::","line":1049,"kind":12,"range":{"end":{"line":1053,"character":9999},"start":{"line":1049,"character":0}}},{"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_pdbInsCo","line":1068},{"line":1069,"containerName":"_pdbInsCo","localvar":"my","kind":13,"name":"$dssp_key","definition":"my"},{"line":1070,"kind":13,"containerName":"_pdbInsCo","name":"$self"},{"line":1070,"kind":13,"containerName":"_pdbInsCo","name":"$dssp_key"}],"containerName":"main::","name":"_pdbInsCo","line":1067,"kind":12,"range":{"start":{"character":0,"line":1067},"end":{"line":1071,"character":9999}}},{"range":{"end":{"character":9999,"line":1093},"start":{"character":0,"line":1085}},"kind":12,"line":1085,"definition":"sub","name":"_toPdbId","containerName":"main::","children":[{"definition":"my","line":1086,"name":"$self","kind":13,"localvar":"my","containerName":"_toPdbId"},{"containerName":"_toPdbId","localvar":"my","kind":13,"name":"$dssp_key","line":1087,"definition":"my"},{"name":"$pdbId","containerName":"_toPdbId","localvar":"my","kind":13,"line":1088,"definition":"my"},{"name":"$self","containerName":"_toPdbId","kind":13,"line":1088},{"line":1088,"containerName":"_toPdbId","kind":12,"name":"_pdbNum"},{"kind":13,"containerName":"_toPdbId","name":"$dssp_key","line":1088},{"kind":13,"containerName":"_toPdbId","name":"$self","line":1089},{"containerName":"_toPdbId","kind":12,"name":"_pdbInsCo","line":1089},{"line":1089,"name":"$dssp_key","containerName":"_toPdbId","kind":13},{"definition":"my","name":"$chain","containerName":"_toPdbId","localvar":"my","kind":13,"line":1090},{"containerName":"_toPdbId","kind":13,"name":"$self","line":1090},{"containerName":"_toPdbId","kind":12,"name":"_pdbChain","line":1090},{"line":1090,"name":"$dssp_key","containerName":"_toPdbId","kind":13},{"line":1091,"kind":13,"containerName":"_toPdbId","name":"$pdbId"},{"name":"$chain","kind":13,"containerName":"_toPdbId","line":1091},{"name":"$pdbId","containerName":"_toPdbId","kind":13,"line":1092}]},{"definition":"sub","name":"_contSegs","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_contSegs","kind":13,"line":1114},{"name":"$self","containerName":"_contSegs","kind":13,"line":1115},{"name":"$self","containerName":"_contSegs","kind":13,"line":1116},{"line":1120,"kind":13,"localvar":"my","containerName":"_contSegs","name":"$cur_chain","definition":"my"},{"line":1120,"kind":13,"containerName":"_contSegs","name":"$i"},{"name":"$beg","containerName":"_contSegs","kind":13,"line":1120},{"containerName":"_contSegs","localvar":"my","kind":13,"name":"@contSegs","line":1121,"definition":"my"},{"line":1123,"name":"$cur_chain","containerName":"_contSegs","kind":13},{"name":"$self","kind":13,"containerName":"_contSegs","line":1123},{"line":1123,"kind":12,"containerName":"_contSegs","name":"_pdbChain"},{"line":1124,"name":"$beg","containerName":"_contSegs","kind":13},{"kind":13,"containerName":"_contSegs","name":"$i","line":1126},{"line":1126,"containerName":"_contSegs","kind":13,"name":"$i"},{"name":"$self","kind":13,"containerName":"_contSegs","line":1126},{"line":1126,"containerName":"_contSegs","kind":12,"name":"_numResLines"},{"line":1126,"name":"$i","containerName":"_contSegs","kind":13},{"containerName":"_contSegs","kind":13,"name":"$self","line":1127},{"line":1127,"name":"$i","kind":13,"containerName":"_contSegs"},{"line":1128,"kind":13,"containerName":"_contSegs","name":"@contSegs"},{"line":1128,"name":"$beg","containerName":"_contSegs","kind":13},{"line":1128,"containerName":"_contSegs","kind":13,"name":"$i"},{"line":1128,"name":"$cur_chain","containerName":"_contSegs","kind":13},{"containerName":"_contSegs","kind":13,"name":"$beg","line":1129},{"containerName":"_contSegs","kind":13,"name":"$i","line":1129},{"line":1130,"containerName":"_contSegs","kind":13,"name":"$cur_chain"},{"name":"$self","containerName":"_contSegs","kind":13,"line":1130},{"containerName":"_contSegs","kind":12,"name":"_pdbChain","line":1130},{"line":1130,"name":"$i","containerName":"_contSegs","kind":13},{"kind":13,"containerName":"_contSegs","name":"@contSegs","line":1134},{"line":1134,"name":"$beg","kind":13,"containerName":"_contSegs"},{"name":"$i","kind":13,"containerName":"_contSegs","line":1134},{"containerName":"_contSegs","kind":13,"name":"$cur_chain","line":1134},{"line":1136,"kind":13,"containerName":"_contSegs","name":"$self"},{"line":1136,"name":"@contSegs","containerName":"_contSegs","kind":13},{"line":1137,"kind":13,"containerName":"_contSegs","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":1113},"end":{"line":1139,"character":9999}},"line":1113},{"line":1157,"range":{"start":{"character":0,"line":1157},"end":{"character":9999,"line":1159}},"kind":12,"children":[{"localvar":"my","kind":13,"containerName":"_numResLines","name":"$self","line":1158,"definition":"my"},{"line":1159,"kind":13,"containerName":"_numResLines","name":"$self"}],"name":"_numResLines","containerName":"main::","definition":"sub"},{"name":"_toDsspKey","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_toDsspKey","line":1186},{"localvar":"my","kind":13,"containerName":"_toDsspKey","name":"$arg_str","line":1187,"definition":"my"},{"line":1189,"name":"$key_num","localvar":"my","containerName":"_toDsspKey","kind":13,"definition":"my"},{"containerName":"_toDsspKey","kind":13,"name":"$chain_id","line":1189},{"line":1189,"containerName":"_toDsspKey","kind":13,"name":"$ins_code"},{"line":1193,"kind":13,"containerName":"_toDsspKey","name":"$key_num"},{"line":1195,"kind":13,"containerName":"_toDsspKey","name":"$ins_code"},{"kind":13,"containerName":"_toDsspKey","name":"$chain_id","line":1196},{"containerName":"_toDsspKey","kind":13,"name":"$chain_id","line":1199},{"name":"$arg_str","kind":13,"containerName":"_toDsspKey","line":1203},{"containerName":"_toDsspKey","kind":13,"name":"$arg_str","line":1204},{"line":1206,"containerName":"_toDsspKey","kind":13,"name":"$chain_id"},{"line":1206,"containerName":"_toDsspKey","kind":13,"name":"$arg_str"},{"line":1207,"name":"$arg_str","containerName":"_toDsspKey","kind":13},{"line":1209,"kind":13,"containerName":"_toDsspKey","name":"$arg_str"},{"line":1211,"name":"$ins_code","kind":13,"containerName":"_toDsspKey"},{"line":1211,"kind":13,"containerName":"_toDsspKey","name":"$arg_str"},{"containerName":"_toDsspKey","kind":13,"name":"$arg_str","line":1212},{"line":1215,"kind":13,"containerName":"_toDsspKey","name":"$key_num"},{"line":1215,"name":"$arg_str","kind":13,"containerName":"_toDsspKey"},{"definition":"my","line":1220,"name":"$i","kind":13,"localvar":"my","containerName":"_toDsspKey"},{"name":"$i","kind":13,"containerName":"_toDsspKey","line":1220},{"kind":13,"containerName":"_toDsspKey","name":"$self","line":1220},{"line":1220,"name":"_numResLines","kind":12,"containerName":"_toDsspKey"},{"containerName":"_toDsspKey","kind":13,"name":"$i","line":1220},{"line":1221,"name":"$self","containerName":"_toDsspKey","kind":13},{"kind":13,"containerName":"_toDsspKey","name":"$i","line":1221},{"containerName":"_toDsspKey","kind":13,"name":"$self","line":1222},{"line":1222,"name":"$i","kind":13,"containerName":"_toDsspKey"},{"name":"$key_num","containerName":"_toDsspKey","kind":13,"line":1224},{"line":1224,"name":"$self","kind":13,"containerName":"_toDsspKey"},{"name":"$i","containerName":"_toDsspKey","kind":13,"line":1224},{"line":1225,"name":"$chain_id","kind":13,"containerName":"_toDsspKey"},{"name":"$chain_id","kind":13,"containerName":"_toDsspKey","line":1226},{"line":1226,"containerName":"_toDsspKey","kind":13,"name":"$self"},{"line":1226,"kind":13,"containerName":"_toDsspKey","name":"$i"},{"line":1228,"containerName":"_toDsspKey","kind":13,"name":"$ins_code"},{"line":1229,"name":"$ins_code","kind":13,"containerName":"_toDsspKey"},{"line":1229,"name":"$self","containerName":"_toDsspKey","kind":13},{"name":"$i","containerName":"_toDsspKey","kind":13,"line":1229},{"line":1231,"name":"$i","containerName":"_toDsspKey","kind":13},{"name":"$i","containerName":"_toDsspKey","kind":13,"line":1235},{"name":"$i","kind":13,"containerName":"_toDsspKey","line":1240},{"name":"$self","kind":13,"containerName":"_toDsspKey","line":1245},{"name":"throw","containerName":"_toDsspKey","kind":12,"line":1245}],"definition":"sub","range":{"end":{"line":1246,"character":9999},"start":{"line":1182,"character":0}},"kind":12,"line":1182},{"kind":12,"range":{"end":{"line":1369,"character":9999},"start":{"line":1260,"character":0}},"line":1260,"definition":"sub","name":"_parse","containerName":"main::","children":[{"line":1261,"name":"$self","kind":13,"localvar":"my","containerName":"_parse","definition":"my"},{"definition":"my","line":1262,"name":"$file","kind":13,"localvar":"my","containerName":"_parse"},{"definition":"my","localvar":"my","containerName":"_parse","kind":13,"name":"$cur","line":1263},{"definition":"my","name":"$current_chain","localvar":"my","containerName":"_parse","kind":13,"line":1264},{"definition":"my","line":1265,"name":"@elements","localvar":"my","containerName":"_parse","kind":13},{"kind":13,"containerName":"_parse","name":"@hbond","line":1265},{"definition":"my","line":1266,"name":"%head","containerName":"_parse","localvar":"my","kind":13},{"name":"%his","containerName":"_parse","kind":13,"line":1266},{"definition":"my","localvar":"my","containerName":"_parse","kind":13,"name":"$element","line":1267},{"definition":"my","localvar":"my","containerName":"_parse","kind":13,"name":"$res_num","line":1268},{"line":1270,"kind":13,"containerName":"_parse","name":"$cur"},{"line":1270,"name":"$file","kind":13,"containerName":"_parse"},{"line":1271,"name":"$cur","kind":13,"containerName":"_parse"},{"line":1272,"containerName":"_parse","kind":13,"name":"$self"},{"kind":12,"containerName":"_parse","name":"throw","line":1272},{"containerName":"_parse","kind":13,"name":"$cur","line":1277},{"containerName":"_parse","kind":13,"name":"$file","line":1277},{"line":1278,"name":"$element","containerName":"_parse","kind":13},{"line":1278,"name":"$cur","kind":13,"containerName":"_parse"},{"name":"$head","containerName":"_parse","kind":13,"line":1279},{"line":1279,"name":"$element","containerName":"_parse","kind":13},{"line":1281,"containerName":"_parse","kind":13,"name":"$cur"},{"name":"$file","containerName":"_parse","kind":13,"line":1281},{"name":"$cur","containerName":"_parse","kind":13,"line":1283},{"kind":13,"containerName":"_parse","name":"@elements","line":1284},{"line":1284,"name":"$cur","containerName":"_parse","kind":13},{"line":1285,"name":"@elements","kind":13,"containerName":"_parse"},{"containerName":"_parse","kind":13,"name":"$head","line":1286},{"line":1286,"name":"@elements","containerName":"_parse","kind":13},{"line":1287,"containerName":"_parse","kind":13,"name":"$head"},{"name":"@elements","containerName":"_parse","kind":13,"line":1287},{"line":1290,"containerName":"_parse","kind":13,"name":"@elements"},{"line":1291,"name":"$element","kind":13,"containerName":"_parse"},{"kind":13,"containerName":"_parse","name":"@elements","line":1291},{"line":1292,"name":"@elements","containerName":"_parse","kind":13},{"line":1293,"name":"$element","containerName":"_parse","kind":13},{"kind":13,"containerName":"_parse","name":"$element","line":1293},{"line":1293,"name":"@elements","containerName":"_parse","kind":13},{"line":1295,"name":"$head","kind":13,"containerName":"_parse"},{"containerName":"_parse","kind":13,"name":"$element","line":1295},{"kind":13,"containerName":"_parse","name":"$cur","line":1297},{"containerName":"_parse","kind":13,"name":"$file","line":1297},{"line":1301,"kind":13,"containerName":"_parse","name":"$cur"},{"line":1302,"name":"$element","kind":13,"containerName":"_parse"},{"line":1302,"name":"$cur","kind":13,"containerName":"_parse"},{"line":1303,"kind":13,"containerName":"_parse","name":"$head"},{"containerName":"_parse","kind":13,"name":"$element","line":1303},{"kind":13,"containerName":"_parse","name":"$cur","line":1305},{"line":1305,"name":"$file","containerName":"_parse","kind":13},{"name":"$cur","kind":13,"containerName":"_parse","line":1309},{"name":"$element","kind":13,"containerName":"_parse","line":1310},{"containerName":"_parse","kind":13,"name":"$cur","line":1310},{"line":1311,"containerName":"_parse","kind":13,"name":"$head"},{"name":"$element","kind":13,"containerName":"_parse","line":1311},{"line":1313,"name":"$cur","kind":13,"containerName":"_parse"},{"line":1313,"kind":13,"containerName":"_parse","name":"$file"},{"name":"$cur","kind":13,"containerName":"_parse","line":1316},{"kind":13,"containerName":"_parse","name":"$element","line":1317},{"line":1317,"name":"$cur","kind":13,"containerName":"_parse"},{"name":"$head","kind":13,"containerName":"_parse","line":1318},{"line":1318,"containerName":"_parse","kind":13,"name":"$element"},{"name":"$cur","containerName":"_parse","kind":13,"line":1320},{"name":"$file","containerName":"_parse","kind":13,"line":1320},{"line":1324,"name":"$cur","containerName":"_parse","kind":13},{"name":"$element","containerName":"_parse","kind":13,"line":1325},{"containerName":"_parse","kind":13,"name":"$cur","line":1325},{"line":1326,"kind":13,"containerName":"_parse","name":"$head"},{"containerName":"_parse","kind":13,"name":"$element","line":1326},{"line":1328,"kind":13,"containerName":"_parse","name":"$cur"},{"name":"$file","containerName":"_parse","kind":13,"line":1328},{"containerName":"_parse","kind":13,"name":"@elements","line":1332},{"name":"$cur","containerName":"_parse","kind":13,"line":1332},{"line":1333,"containerName":"_parse","kind":13,"name":"@elements"},{"name":"$head","containerName":"_parse","kind":13,"line":1334},{"kind":13,"containerName":"_parse","name":"@elements","line":1334},{"line":1335,"name":"$head","kind":13,"containerName":"_parse"},{"line":1335,"name":"@elements","kind":13,"containerName":"_parse"},{"name":"$head","containerName":"_parse","kind":13,"line":1336},{"line":1336,"kind":13,"containerName":"_parse","name":"@elements"},{"line":1337,"containerName":"_parse","kind":13,"name":"$head"},{"containerName":"_parse","kind":13,"name":"@elements","line":1337},{"containerName":"_parse","kind":13,"name":"$head","line":1338},{"line":1338,"name":"@elements","kind":13,"containerName":"_parse"},{"line":1340,"name":"$cur","containerName":"_parse","kind":13},{"containerName":"_parse","kind":13,"name":"$file","line":1340},{"containerName":"_parse","kind":13,"name":"$element","line":1341},{"line":1341,"name":"$cur","containerName":"_parse","kind":13},{"line":1342,"containerName":"_parse","kind":13,"name":"$head"},{"line":1342,"kind":13,"containerName":"_parse","name":"$element"},{"line":1343,"containerName":"_parse","kind":13,"name":"$self"},{"line":1343,"name":"%head","kind":13,"containerName":"_parse"},{"definition":"my","line":1345,"localvar":"my","containerName":"_parse","kind":13,"name":"$i"},{"line":1345,"name":"$i","containerName":"_parse","kind":13},{"name":"$i","containerName":"_parse","kind":13,"line":1345},{"name":"$cur","containerName":"_parse","kind":13,"line":1346},{"kind":13,"containerName":"_parse","name":"$file","line":1346},{"kind":13,"containerName":"_parse","name":"$element","line":1347},{"line":1348,"containerName":"_parse","kind":13,"name":"$cur"},{"line":1349,"containerName":"_parse","kind":13,"name":"@hbond"},{"name":"$element","kind":13,"containerName":"_parse","line":1349},{"line":1352,"containerName":"_parse","kind":13,"name":"$self"},{"name":"@hbond","kind":13,"containerName":"_parse","line":1352},{"definition":"my","name":"$histogram_finished","containerName":"_parse","localvar":"my","kind":13,"line":1354},{"name":"$histogram_finished","containerName":"_parse","kind":13,"line":1355},{"line":1355,"name":"$cur","kind":13,"containerName":"_parse"},{"line":1355,"kind":13,"containerName":"_parse","name":"$file"},{"line":1356,"name":"$cur","kind":13,"containerName":"_parse"},{"kind":13,"containerName":"_parse","name":"$histogram_finished","line":1357},{"line":1361,"containerName":"_parse","kind":13,"name":"$cur"},{"line":1361,"kind":13,"containerName":"_parse","name":"$file"},{"line":1362,"name":"$cur","containerName":"_parse","kind":13},{"line":1365,"kind":13,"containerName":"_parse","name":"$res_num"},{"name":"$cur","kind":13,"containerName":"_parse","line":1365},{"line":1366,"containerName":"_parse","kind":13,"name":"$res_num"},{"name":"$self","containerName":"_parse","kind":13,"line":1367},{"kind":13,"containerName":"_parse","name":"$res_num","line":1367},{"kind":13,"containerName":"_parse","name":"$cur","line":1367}]},{"name":"_parseResLine","kind":12,"line":1367},{"definition":"sub","detail":"()","children":[{"line":1385,"localvar":"my","containerName":"_parseResLine","kind":13,"name":"$cur","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_parseResLine","name":"$feat","line":1386},{"name":"$value","kind":13,"containerName":"_parseResLine","line":1386},{"definition":"my","line":1387,"name":"%elements","localvar":"my","containerName":"_parseResLine","kind":13},{"name":"$feat","containerName":"_parseResLine","kind":13,"line":1389},{"name":"%lookUp","containerName":"_parseResLine","kind":13,"line":1389},{"line":1390,"name":"$value","containerName":"_parseResLine","kind":13},{"kind":13,"containerName":"_parseResLine","name":"$cur","line":1390},{"kind":13,"containerName":"_parseResLine","name":"$lookUp","line":1390},{"kind":13,"containerName":"_parseResLine","name":"$feat","line":1390},{"containerName":"_parseResLine","kind":13,"name":"$lookUp","line":1391},{"name":"$feat","kind":13,"containerName":"_parseResLine","line":1391},{"containerName":"_parseResLine","kind":13,"name":"$value","line":1392},{"line":1393,"name":"$elements","containerName":"_parseResLine","kind":13},{"line":1393,"containerName":"_parseResLine","kind":13,"name":"$feat"},{"name":"$value","kind":13,"containerName":"_parseResLine","line":1393},{"line":1397,"containerName":"_parseResLine","kind":13,"name":"$elements"},{"line":1397,"name":"$elements","containerName":"_parseResLine","kind":13},{"line":1398,"name":"$elements","containerName":"_parseResLine","kind":13},{"line":1400,"name":"%elements","containerName":"_parseResLine","kind":13}],"name":"_parseResLine","containerName":"main::","signature":{"label":"_parseResLine()","parameters":[],"documentation":"1;\n# $Header$\n#\n# bioperl module for Bio::Structure::SecStr::DSSP::Res.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ed Green <ed@compbio.berkeley.edu>\n#\n# Copyright Univ. of California\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::SecStr::DSSP::Res - Module for parsing/accessing dssp output\n\n=head1 SYNOPSIS\n\n  my $dssp_obj = Bio::Structure::SecStr::DSSP::Res->new('-file'=>'filename.dssp');\n\n  # or\n\n  my $dssp_obj = Bio::Structure::SecStr::DSSP::Res->new('-fh'=>\\*STDOUT);\n\n  # get DSSP defined Secondary Structure for residue 20\n  $sec_str = $dssp_obj->resSecStr( 20 );\n\n  # get dssp defined sec. structure summary for PDB residue  # 10 of chain A\n\n  $sec_str = $dssp_obj->resSecStrSum( '10:A' );\n\n=head1 DESCRIPTION\n\nDSSP::Res is a module for objectifying DSSP output.  Methods are then\navailable for extracting all the information within the output file\nand convenient subsets of it.\nThe principal purpose of DSSP is to determine secondary structural\nelements of a given structure.\n\n    ( Dictionary of protein secondary structure: pattern recognition\n      of hydrogen-bonded and geometrical features.\n      Biopolymers. 1983 Dec;22(12):2577-637. )\n\nThe DSSP program is available from:\n  http://www.cmbi.kun.nl/swift/dssp\n\nThis information is available on a per residue basis ( see resSecStr\nand resSecStrSum methods ) or on a per chain basis ( see secBounds\nmethod ).\n\nresSecStr() & secBounds() return one of the following:\n    'H' = alpha helix\n    'B' = residue in isolated beta-bridge\n    'E' = extended strand, participates in beta ladder\n    'G' = 3-helix (3/10 helix)\n    'I' = 5 helix (pi helix)\n    'T' = hydrogen bonded turn\n    'S' = bend\n    ''  = no assignment\n\nA more general classification is returned using the resSecStrSum()\nmethod.  The purpose of this is to have a method for DSSP and STRIDE\nderived output whose range is the same.\nIts output is one of the following:\n\n    'H' = helix         ( => 'H', 'G', or 'I' from above )\n    'B' = beta          ( => 'B' or 'E' from above )\n    'T' = turn          ( => 'T' or 'S' from above )\n    ' ' = no assignment ( => ' ' from above )\n\nThe methods are roughly divided into 3 sections:\n1.  Global features of this structure (PDB ID, total surface area,\n    etc.).  These methods do not require an argument.\n2.  Residue specific features ( amino acid, secondary structure,\n    solvent exposed surface area, etc. ).  These methods do require an\n    arguement.  The argument is supposed to uniquely identify a\n    residue described within the structure.  It can be of any of the\n    following forms:\n    ('#A:B') or ( #, 'A', 'B' )\n      || |\n      || - Chain ID (blank for single chain)\n      |--- Insertion code for this residue.  Blank for most residues.\n      |--- Numeric portion of residue ID.\n\n    (#)\n     |\n     --- Numeric portion of residue ID.  If there is only one chain and\n         it has no ID AND there is no residue with an insertion code at this\n         number, then this can uniquely specify a residue.\n\n    ('#:C') or ( #, 'C' )\n      | |\n      | -Chain ID\n      ---Numeric portion of residue ID.\n\n  If a residue is incompletely specified then the first residue that\n  fits the arguments is returned.  For example, if 19 is the argument\n  and there are three chains, A, B, and C with a residue whose number\n  is 19, then 19:A will be returned (assuming its listed first).\n\n  Since neither DSSP nor STRIDE correctly handle alt-loc codes, they\n  are not supported by these modules.\n\n3.  Value-added methods.  Return values are not verbatem strings\n    parsed from DSSP or STRIDE output.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ed Green\n\nEmail ed@compbio.berkeley.edu\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each method.\nInternal methods are preceded with a _\n\n\npackage Bio::Structure::SecStr::DSSP::Res;\nuse strict;\nuse Bio::Root::IO;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\n# Would be a class variable if Perl had them\n\n               #attribute        begin col        # columns\nour %lookUp = ( 'pdb_resnum'     => [  5,           5 ],\n\t\t'insertionco'    => [  10,          1 ],\n\t\t'pdb_chain'      => [  11,          1 ],\n\t\t\n\t\t'amino_acid'     => [  13,          1 ],\n\t\t'term_sig'       => [  14,          1 ],\n\t\t\n\t\t'ss_summary'     => [  16,          1 ],\n\t\t'3tph'           => [  18,          1 ],\n\t\t'4tph'           => [  19,          1 ],\n\t\t'5tph'           => [  20,          1 ],\n\t\t'geo_bend'       => [  21,          1 ],\n\t\t'chirality'      => [  22,          1 ],\n\t\t'beta_br1la'     => [  23,          1 ],\n\t\t'beta_br2la'     => [  24,          1 ],\n\n\t\t'bb_part1nu'     => [  25,          4 ],\n\t\t'bb_part2nu'     => [  29,          4 ],\n\t\t'betash_lab'     => [  33,          1 ],\n\t\t\n\t\t'solv_acces'     => [  34,          4 ],\n\t\t\n\t\t'hb1_nh_o_p'     => [  39,          6 ],\n\t\t'hb1_nh_o_e'     => [  46,          4 ],\n\t\t\n\t\t'hb1_o_hn_p'     => [  50,          6 ],\n\t\t'hb1_o_hn_e'     => [  57,          4 ],\n\t\t\n\t\t'hb2_nh_o_p'     => [  61,          6 ],\n\t\t'hb2_nh_o_e'     => [  68,          4 ],\n\t\t\n\t\t'hb2_o_hn_p'     => [  72,          6 ],\n\t\t'hb2_o_hn_e'     => [  79,          4 ],\n\t\t\n\t\t'tco'            => [  85,          6 ],\n\t\t\n\t\t'kappa'          => [  91,          6 ],\n\t\t\n\t\t'alpha'          => [  97,          6 ],\n\t\n\t\t'phi'            => [ 103,          6 ],\n\n\t\t'psi'            => [ 109,          6 ],\n\t\t\n\t\t'x_ca'           => [ 115,          7 ],\n\t\t\n\t\t'y_ca'           => [ 122,          7 ],\n\t\t\n\t\t'z_ca'           => [ 129,          7 ] );\n\n\n=head1 CONSTRUCTOR\n\n\n\n\n=head2 new\n\n Title         : new\n Usage         : makes new object of this class\n Function      : Constructor\n Example       : $dssp_obj = Bio::DSSP:Res->new( filename or FILEHANDLE )\n Returns       : object (ref)\n Args          : filename ( must be proper DSSP output file )\n\n\nsub new {\n    my ( $class, @args ) = @_;\n    my $self = $class->SUPER::new( @args );\n    my $io = Bio::Root::IO->new( @args );\n    $self->_parse( $io->_fh() );\n    $io->close();\n    return $self;\n}\n\n=head1 ACCESSORS\n\n\n\n# GLOBAL FEATURES / INFO / STATS\n\n=head2 totSurfArea\n\n Title         : totSurfArea\n Usage         : returns total accessible surface area in square Ang.\n Function      :\n Example       : $surArea = $dssp_obj->totSurfArea();\n Returns       : scalar\n Args          : none\n\n\nsub totSurfArea {\n    my $self = shift;\n    return $self->{ 'Head' }->{ 'ProAccSurf' };\n}\n\n=head2 numResidues\n\n Title         : numResidues\n Usage         : returns the total number of residues in all chains or\n                 just the specified chain if a chain is specified\n Function      :\n Example       : $num_res = $dssp_obj->numResidues();\n Returns       : scalar int\n Args          : none\n\n\n\nsub numResidues {\n    my $self = shift;\n    my $chain = shift;\n    if ( !( $chain ) ) {\n\treturn $self->{'Head'}->{'TotNumRes'};\n    }\n    else {\n\tmy ( $num_res,\n\t     $cont_seg );\n\tmy $cont_seg_pnt = $self->_contSegs();\n\tforeach $cont_seg ( @{ $cont_seg_pnt } ) {\n\t    if ( $chain eq $cont_seg->[ 2 ] ) {\n\t\t# this segment is part of the chain we want\n\t\t$num_res += ( $self->_toDsspKey( $cont_seg->[ 1 ] )\n\t\t\t      - $self->_toDsspKey( $cont_seg->[ 0 ] )\n\t\t\t      + 1 ); # this works because we know the\n\t\t\t\t     # the region between the start\n\t\t\t\t     # and end of a dssp key is\n\t\t\t\t     # continuous\n\t    }\n\t}\n\treturn $num_res;\n    }\n}\n\n#  STRAIGHT FROM PDB ENTRY\n\n=head2 pdbID\n\n Title         : pdbID\n Usage         : returns pdb identifier ( 1FJM, e.g.)\n Function      :\n Example       : $pdb_id = $dssp_obj->pdbID();\n Returns       : scalar string\n Args          : none\n\n\n\nsub pdbID {\n    my $self = shift;\n    return $self->{'Head'}->{'PDB'};\n}\n\n=head2 pdbAuthor\n\n Title         : pdbAuthor\n Usage         : returns author field\n Function      :\n Example       : $auth = $dssp_obj->pdbAuthor()\n Returns       : scalar string\n Args          : none\n\n\n\nsub pdbAuthor {\n    my $self = shift;\n    return $self->{'Head'}->{'AUTHOR'};\n}\n\n=head2 pdbCompound\n\n Title         : pdbCompound\n Usage         : returns pdbCompound given in PDB file\n Function      :\n Example       : $cmpd = $dssp_obj->pdbCompound();\n Returns       : scalar string\n Args          : none\n\n\n\nsub pdbCompound {\n    my $self = shift;\n    return $self->{'Head'}->{'COMPND'};\n}\n\n=head2 pdbDate\n\n Title         : pdbDate\n Usage         : returns date given in PDB file\n Function      :\n Example       : $pdb_date = $dssp_obj->pdbDate();\n Returns       : scalar\n Args          : none\n\n\n\nsub pdbDate {\n    my $self = shift;\n    return $self->{'Head'}->{'DATE'};\n}\n\n=head2 pdbHeader\n\n Title         : pdbHeader\n Usage         : returns header info from PDB file\n Function      :\n Example       : $header = $dssp_obj->pdbHeader();\n Returns       : scalar\n Args          : none\n\n\n\nsub pdbHeader {\n    my $self = shift;\n    return $self->{'Head'}->{'HEADER'};\n}\n\n=head2 pdbSource\n\n Title         : pdbSource\n Usage         : returns pdbSource information from PDBSOURCE line\n Function      :\n Example       : $pdbSource = $dssp_obj->pdbSource();\n Returns       : scalar\n Args          : none\n\n\n\nsub pdbSource {\n    my $self = shift;\n    return $self->{'Head'}->{'SOURCE'};\n}\n\n\n# RESIDUE SPECIFIC ACCESSORS\n\n=head2 resAA\n\n Title         : resAA\n Usage         : fetches the 1 char amino acid code, given an id\n Function      :\n Example       : $aa = $dssp_obj->resAA( '20:A' ); # pdb id as arg\n Returns       : 1 character scalar string\n Args          : RESIDUE_ID\n\n\n\nsub resAA {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'amino_acid' };\n}\n\n=head2 resPhi\n\n Title         : resPhi\n Usage         : returns phi angle of a single residue\n Function      : accessor\n Example       : $phi = $dssp_obj->resPhi( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resPhi {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'phi' };\n}\n\n=head2 resPsi\n\n Title         : resPsi\n Usage         : returns psi angle of a single residue\n Function      : accessor\n Example       : $psi = $dssp_obj->resPsi( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resPsi {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'psi' };\n}\n\n=head2 resSolvAcc\n\n Title         : resSolvAcc\n Usage         : returns solvent exposed area of this residue in\n                 square Angstroms\n Function      :\n Example       : $solv_acc = $dssp_obj->resSolvAcc( RESIDUE_ID );\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resSolvAcc {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'solv_acces' };\n}\n\n=head2 resSurfArea\n\n Title         : resSurfArea\n Usage         : returns solvent exposed area of this residue in\n                 square Angstroms\n Function      :\n Example       : $solv_acc = $dssp_obj->resSurfArea( RESIDUE_ID );\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resSurfArea {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'solv_acces' };\n}\n\n=head2 resSecStr\n\n Title         : resSecStr\n Usage         : $ss = $dssp_obj->resSecStr( RESIDUE_ID );\n Function      : returns the DSSP secondary structural designation of this residue\n Example       :\n Returns       : a character ( 'B', 'E', 'G', 'H', 'I', 'S', 'T', or ' ' )\n Args          : RESIDUE_ID\n NOTE          : The range of this method differs from that of the\n    resSecStr method in the STRIDE SecStr parser.  That is because of the\n    slightly different format for STRIDE and DSSP output.  The resSecStrSum\n    method exists to map these different ranges onto an identical range.\n\n\nsub resSecStr {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    my $ss_char = $self->{ 'Res' }->[ $dssp_key ]->{ 'ss_summary' };\n    return $ss_char if $ss_char;\n    return ' ';\n}\n\n\n=head2 resSecStrSum\n\n Title         : resSecStrSum\n Usage         : $ss = $dssp_obj->resSecStrSum( $id );\n Function      : returns what secondary structure group this residue belongs\n                 to.  One of:  'H': helix ( H, G, or I )\n                               'B': beta  ( B or E )\n                               'T': turn  ( T or S )\n                               ' ': none  ( ' ' )\n                 This method is similar to resSecStr, but the information\n                 it returns is less specific.\n Example       :\n Returns       : a character ( 'H', 'B', 'T', or ' ' )\n Args          : dssp residue number of pdb residue identifier\n\n\n\nsub resSecStrSum {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    my $ss_char = $self->{ 'Res' }->[ $dssp_key ]->{ 'ss_summary' };\n    if ( $ss_char eq 'H' || $ss_char eq 'G' || $ss_char eq 'I' ) {\n\treturn 'H';\n    }\n    if ( $ss_char eq ' ' || !( $ss_char ) ) {\n\treturn ' ';\n    }\n    if ( $ss_char eq 'B' || $ss_char eq 'E' ) {\n\treturn 'B';\n    }\n    else {\n\treturn 'T';\n    }\n}\n\n# DSSP SPECIFIC\n\n=head2 hBonds\n\n Title         : hBonds\n Usage         : returns number of 14 different types of H Bonds\n Function      :\n Example       : $hb = $dssp_obj->hBonds\n Returns       : pointer to 14 element array of ints\n Args          : none\n NOTE          : The different type of H-Bonds reported are, in order:\n    TYPE O(I)-->H-N(J)\n    IN PARALLEL BRIDGES\n    IN ANTIPARALLEL BRIDGES\n    TYPE O(I)-->H-N(I-5)\n    TYPE O(I)-->H-N(I-4)\n    TYPE O(I)-->H-N(I-3)\n    TYPE O(I)-->H-N(I-2)\n    TYPE O(I)-->H-N(I-1)\n    TYPE O(I)-->H-N(I+0)\n    TYPE O(I)-->H-N(I+1)\n    TYPE O(I)-->H-N(I+2)\n    TYPE O(I)-->H-N(I+3)\n    TYPE O(I)-->H-N(I+4)\n    TYPE O(I)-->H-N(I+5)\n\n\nsub hBonds {\n    my $self = shift;\n    return $self->{ 'HBond'};\n}\n\n=head2 numSSBr\n\n Title         : numSSBr\n Usage         : returns info about number of SS-bridges\n Function      :\n Example       : @SS_br = $dssp_obj->numSSbr();\n Returns       : 3 element scalar int array\n Args          : none\n\n\n\nsub numSSBr {\n    my $self = shift;\n    return ( $self->{'Head'}->{'TotSSBr'},\n\t     $self->{'Head'}->{'TotIaSSBr'},\n\t     $self->{'Head'}->{'TotIeSSBr'} );\n}\n\n=head2 resHB_O_HN\n\n Title         : resHB_O_HN\n Usage         : returns pointer to a 4 element array\n                 consisting of: relative position of binding\n                 partner #1, energy of that bond (kcal/mol),\n                 relative positionof binding partner #2,\n                 energy of that bond (kcal/mol).  If the bond\n                 is not bifurcated, the second bond is reported\n                 as 0, 0.0\n Function      : accessor\n Example       : $oBonds_ptr = $dssp_obj->resHB_O_HN( RESIDUE_ID )\n Returns       : pointer to 4 element array\n Args          : RESIDUE_ID\n\n\n\nsub resHB_O_HN {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return ( $self->{ 'Res' }->[ $dssp_key ]->{ 'hb1_o_hn_p' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb1_o_hn_e' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb2_o_hn_p' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb2_o_hn_e' } );\n}\n\n\n=head2 resHB_NH_O\n\n Title         : resHB_NH_O\n Usage         : returns pointer to a 4 element array\n                 consisting of: relative position of binding\n                 partner #1, energy of that bond (kcal/mol),\n                 relative positionof binding partner #2,\n                 energy of that bond (kcal/mol).  If the bond\n                 is not bifurcated, the second bond is reported\n                 as 0, 0.0\n Function      : accessor\n Example       : $nhBonds_ptr = $dssp_obj->resHB_NH_O( RESIDUE_ID )\n Returns       : pointer to 4 element array\n Args          : RESIDUE_ID\n\n\n\nsub resHB_NH_O {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return ( $self->{ 'Res' }->[ $dssp_key ]->{ 'hb1_nh_o_p' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb1_nh_o_e' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb2_nh_o_p' },\n\t     $self->{ 'Res' }->[ $dssp_key ]->{ 'hb2_nh_o_e' } );\n}\n\n\n=head2 resTco\n\n Title         : resTco\n Usage         : returns tco angle around this residue\n Function      : accessor\n Example       : resTco = $dssp_obj->resTco( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID\n\n\n\nsub resTco {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'tco' };\n}\n\n\n=head2 resKappa\n\n Title         : resKappa\n Usage         : returns kappa angle around this residue\n Function      : accessor\n Example       : $kappa = $dssp_obj->resKappa( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID ( dssp or PDB )\n\n\n\nsub resKappa {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'kappa' };\n}\n\n\n=head2 resAlpha\n\n Title         : resAlpha\n Usage         : returns alpha angle around this residue\n Function      : accessor\n Example       : $alpha = $dssp_obj->resAlpha( RESIDUE_ID )\n Returns       : scalar\n Args          : RESIDUE_ID ( dssp or PDB )\n\n\n\nsub resAlpha {\n    my $self = shift;\n    my @args = @_;\n    my $dssp_key = $self->_toDsspKey( @args );\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'alpha' };\n}\n\n# VALUE ADDED METHODS (NOT JUST PARSE/REPORT)\n\n=head2 secBounds\n\n Title         : secBounds\n Usage         : gets residue ids of boundary residues in each\n                 contiguous secondary structural element of specified\n                 chain\n Function      : returns pointer to array of 3 element arrays.  First\n                 two elements are the PDB IDs of the start and end points,\n                 respectively and inclusively.  The last element is the\n                 DSSP secondary structural assignment code,\n                 i.e. one of : ('B', 'E', 'G', 'H', 'I', 'S', 'T', or ' ')\n Example       : $ss_elements_pts = $dssp_obj->secBounds( 'A' );\n Returns       : pointer to array of arrays\n Args          : chain id ( 'A', for example ).  No arg => no chain id\n\n\n\nsub secBounds {\n    my $self = shift;\n    my $chain = shift;\n    my %sec_bounds;\n\n    $chain = '-' if ( !( $chain ) || $chain eq ' ' || $chain eq '-' );\n\n    # if we've memoized this chain, use that\n    if ( $self->{ 'SecBounds' } ) {\n\t# check to make sure chain is valid\n\tif ( !( $self->{ 'SecBounds' }->{ $chain } ) ) {\n\t    $self->throw( \"No such chain: $chain\\n\" );\n\t}\n\treturn $self->{ 'SecBounds' }->{ $chain };\n    }\n\n    my ( $cur_element, $i, $cur_chain, $beg, );\n\n    #initialize\n    $cur_element = $self->{ 'Res' }->[ 1 ]->{ 'ss_summary' };\n    $beg = 1;\n\n    for ( $i = 2; $i <= $self->_numResLines() - 1; $i++ ) {\n\tif ( $self->{ 'Res' }->[ $i ]->{ 'amino_acid' } eq '!' ) {\n\t    # element is terminated by a chain discontinuity\n\t    push( @{ $sec_bounds{ $self->_pdbChain( $beg ) } },\n\t\t  [ $self->_toPdbId( $beg ),\n\t\t    $self->_toPdbId( $i - 1 ),\n\t\t    $cur_element ] );\n\t    $i++;\n\t    $beg = $i;\n\t    $cur_element = $self->{ 'Res' }->[ $i ]->{ 'ss_summary' };\n\t}\n\t\n\telsif ( $self->{ 'Res' }->[ $i ]->{ 'ss_summary' } ne $cur_element ) {\n\t    # element is terminated by beginning of a new element\n\t    push( @{ $sec_bounds{ $self->_pdbChain( $beg ) } },\n\t\t  [ $self->_toPdbId( $beg ),\n\t\t    $self->_toPdbId( $i - 1 ),\n\t\t    $cur_element ] );\n\t    $beg = $i;\n\t    $cur_element = $self->{ 'Res' }->[ $i ]->{ 'ss_summary' };\n\t}\n    }\n    #last residue\n    if ( $self->{ 'Res' }->[ $i ]->{ 'ss_summary' } eq $cur_element ) {\n\tpush( @{ $sec_bounds{ $self->_pdbChain( $beg ) } },\n\t      [ $self->_toPdbId( $beg ),\n\t\t$self->_toPdbId( $i ),\n\t\t$cur_element ] );\n    }\n\n    else {\n\tpush( @{ $sec_bounds{ $self->_pdbChain( $beg ) } },\n\t      [ $self->_toPdbId( $beg ),\n\t\t$self->_toPdbId( $i - 1 ),\n\t\t$cur_element ] );\n\tpush( @{ $sec_bounds{ $self->_pdbChain( $i ) } },\n\t      [ $self->_toPdbId( $i ),\n\t\t$self->_toPdbId( $i ),\n\t\t$self->{ 'Res' }->[ $i ]->{ 'ss_summary' } ] );\n    }\n\n    $self->{ 'SecBounds' } = \\%sec_bounds;\n\n    # check to make sure chain is valid\n    if ( !( $self->{ 'SecBounds' }->{ $chain } ) ) {\n\t$self->throw( \"No such chain: $chain\\n\" );\n    }\n\n    return $self->{ 'SecBounds' }->{ $chain };\n}\n\n\n\n=head2 chains\n\n Title         : chains\n Usage         : returns pointer to array of chain I.D.s (characters)\n Function      :\n Example       : $chains_pnt = $dssp_obj->chains();\n Returns       : array of characters, one of which may be ' '\n Args          : none\n\n\n\nsub chains {\n    my $self = shift;\n    my $cont_segs = $self->_contSegs();\n    my %chains;\n    my $seg;\n    foreach $seg ( @{ $cont_segs } ) {\n\t$chains{ $seg->[ 2 ] } = 1;\n    }\n    my @chains = keys( %chains );\n    return \\@chains;\n}\n\n\n=head2 residues\n\n    Title : residues\n    Usage : returns array of residue identifiers for all residues in\n    the output file, or in a specific chain\n    Function :\n    Example : @residues_ids = $dssp_obj->residues()\n    Returns : array of residue identifiers\n    Args : if none => returns residue ids of all residues of all\n    chains (in order); if chain id is given, returns just the residue\n    ids of residues in that chain\n\n\n\n# Can't use the standard interface for getting the amino acid,\n# pdb_resnum, etc. in this method because we don't *know* the residue\n# indentifiers - we are building a list of them.\nsub residues {\n    my $self  = shift;\n    my $chain = shift;\n    my @residues;\n    my $num_res = $self->_numResLines();\n    my $aa;\n    for ( my $i = 1; $i <= $num_res; $i++ ) {\n\t# find what character was in the slot for tha amino acid code,\n\t# if it's a '!' we know this is not a *real* amino acid, it's\n\t# a chain discontinuity marker \n\t$aa = $self->{ 'Res' }->[ $i ]->{ 'amino_acid' };\n\tif ( $aa ne '!' ) {\n\t    if ( !$chain ||\n\t\t $chain eq $self->{ 'Res' }->[ $i ]->{ 'pdb_chain' } ) {\n\t\tpush( @residues, \n\t\t      $self->{ 'Res' }->[ $i ]->{ 'pdb_resnum' }.\n\t\t      $self->{ 'Res' }->[ $i ]->{ 'insertionco' }.\n\t\t      \":\".\n\t\t      $self->{ 'Res' }->[ $i ]->{ 'pdb_chain' } );\n\t    }\n\t}\n    }\n    return @residues;\n}\n\n\n=head2 getSeq\n\n Title         : getSeq\n Usage         : returns a Bio::PrimarySeq object which represents a good\n                 guess at the sequence of the given chain\n Function      : For most chains of most entries, the sequence returned by\n                 this method will be very good.  However, it is inherently\n                 unsafe to rely on DSSP to extract sequence information about\n                 a PDB entry.  More reliable information can be obtained from\n                 the PDB entry itself.\n Example       : $pso = $dssp_obj->getSeq( 'A' );\n Returns       : (pointer to) a PrimarySeq object\n Args          : Chain identifier.  If none given, ' ' is assumed.  If no ' '\n                 chain, the first chain is used.\n\n\n\nsub getSeq {\n    my $self  = shift;\n    my $chain = shift;\n\n    my ( $pot_chain,\n\t $seq,\n\t $frag_num,\n\t $frag,\n\t $curPdbNum,\n\t $lastPdbNum,\n\t $gap_len,\n\t $i,\n\t $id,\n\t );\n    my @frags;\n\n    if ( !( $chain ) ) {\n\t$chain = ' ';\n    }\n\n    if ( $self->{ 'Seq' }->{ $chain } ) {\n\treturn $self->{ 'Seq' }->{ $chain };\n    }\n\n    my $contSegs_pnt = $self->_contSegs();\n\n    # load up specified chain\n    foreach $pot_chain ( @{ $contSegs_pnt } ) {\n\tif ( $pot_chain->[ 2 ] eq $chain ) {\n\t    push( @frags, $pot_chain );\n\t}\n    }\n    \n    # if that didn't work, just get the first one\n    if ( !( @frags ) ) {\n\t$chain = $contSegs_pnt->[ 0 ]->[ 2 ];\n\tforeach $pot_chain ( @{ $contSegs_pnt } ) {\n\t    if ( $pot_chain->[ 2 ] eq $chain ) {\n\t\tpush( @frags, $pot_chain );\n\t    }\n\t}\n    }\n\n    # now build the sequence string\n    $seq = \"\";\n    $frag_num = 0;\n    foreach $frag ( @frags ) {\n\t$frag_num++;\n\tif ( $frag_num > 1 ) {  # we need to put in some gap seq\n\t    $curPdbNum = $self->_pdbNum( $frag->[ 0 ] );\n\t    $gap_len = $curPdbNum - $lastPdbNum - 1;\n\t    if ( $gap_len > 0 ) {\n\t\t$seq .= 'u' x $gap_len;\n\t    }\n\t    else {\n\t\t$seq .= 'u';\n\t    }\n\t}\n\tfor ( $i = $frag->[ 0 ]; $i <= $frag->[ 1 ]; $i++ ) {\n\t    $seq .= $self->_resAA( $i );\n\t}\n\t$lastPdbNum = $self->_pdbNum( $i - 1 );\n    }\n\n\n\n    $id = $self->pdbID();\n    $id .= \":$chain\";\n\n    $self->{ 'Seq' }->{ $chain } =  Bio::PrimarySeq->new ( -seq => $seq,\n\t\t\t\t\t\t\t   -id  => $id,\n\t\t\t\t\t\t\t   -moltype => 'protein'\n\t\t\t\t\t\t\t   );\n    return $self->{ 'Seq' }->{ $chain };\n}\n\n=head1 INTERNAL METHODS\n\n\n\n=head2 _pdbChain\n\n Title         : _pdbChain\n Usage         : returns the pdb chain id of given residue\n Function      :\n Example       : $chain_id = $dssp_obj->pdbChain( DSSP_KEY );\n Returns       : scalar\n Args          : DSSP_KEY ( dssp or pdb )\n\n\n\nsub _pdbChain {\n    my $self = shift;\n    my $dssp_key = shift;\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'pdb_chain' };\n}\n\n=head2 _resAA\n\n Title         : _resAA\n Usage         : fetches the 1 char amino acid code, given a dssp id\n Function      :\n Example       : $aa = $dssp_obj->_resAA( dssp_id );\n Returns       : 1 character scalar string\n Args          : dssp_id\n\n\n\nsub _resAA {\n    my $self = shift;\n    my $dssp_key = shift;\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'amino_acid' };\n}\n\n\n=head2 _pdbNum\n\n Title        : _pdbNum\n Usage        : fetches the numeric portion of the identifier for a given\n                residue as reported by the pdb entry.  Note, this DOES NOT\n                uniquely specify a residue.  There may be an insertion code\n                and/or chain identifier differences.\n Function     :\n Example      : $pdbNum = $self->_pdbNum( DSSP_ID );\n Returns      : a scalar\n Args         : DSSP_ID\n\n\n\nsub _pdbNum {\n    my $self = shift;\n    my $dssp_key = shift;\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'pdb_resnum' };\n}\n\n=head2 _pdbInsCo\n\n Title        : _pdbInsCo\n Usage        : fetches the Insertion Code for this residue, if it has one.\n Function     :\n Example      : $pdbNum = $self->_pdbInsCo( DSSP_ID );\n Returns      : a scalar\n Args         : DSSP_ID\n\n\n\nsub _pdbInsCo {\n    my $self = shift;\n    my $dssp_key = shift;\n    return $self->{ 'Res' }->[ $dssp_key ]->{ 'insertionco' };\n}\n\n=head2 _toPdbId\n\n Title        : _toPdbId\n Usage        : Takes a dssp key and builds the corresponding\n                PDB identifier string\n Function     :\n Example      : $pdbId = $self->_toPdbId( DSSP_ID );\n Returns      : scalar\n Args         : DSSP_ID\n\n\nsub _toPdbId {\n    my $self = shift;\n    my $dssp_key = shift;\n    my $pdbId = ( $self->_pdbNum( $dssp_key ).\n\t\t  $self->_pdbInsCo( $dssp_key ) );\n    my $chain = $self->_pdbChain( $dssp_key );\n    $pdbId = \"$pdbId:$chain\" if $chain;\n    return $pdbId;\n}\n\n=head2 _contSegs\n\n Title         : _contSegs\n Usage         : find the endpoints of continuous regions of this structure\n Function      : returns pointer to array of 3 element array.\n                 Elements are the dssp keys of the start and end points of each\n                 continuous element and its PDB chain id (may be blank).\n                 Note that it is common to have several\n                 continuous elements with the same chain id.  This occurs\n                 when an internal region is disordered and no structural\n                 information is available.\n Example       : $cont_seg_ptr = $dssp_obj->_contSegs();\n Returns       : pointer to array of arrays\n Args          : none\n\n\n\nsub _contSegs {\n    my $self = shift;\n    if ( $self->{ 'contSegs' } ) {\n\treturn $self->{ 'contSegs' };\n    }\n    else {\n\t# first time, so make contSegs\n\tmy ( $cur_chain, $i, $beg );\n\tmy @contSegs;\n\t#initialize\n\t$cur_chain = $self->_pdbChain( 1 );\n\t$beg = 1;\n\t#internal residues\n\tfor ( $i = 2; $i <= $self->_numResLines() - 1; $i++ ) {\n\t    if ( $self->{ 'Res' }->[ $i ]->{ 'amino_acid' } eq '!' ) {\n\t\tpush( @contSegs, [ $beg, $i - 1, $cur_chain ] );\n\t\t$beg = $i + 1;\n\t\t$cur_chain = $self->_pdbChain( $i + 1 );\n\t    }\n\t}\n\t# last residue must be the end of a chain\n\tpush( @contSegs, [ $beg, $i, $cur_chain ] );\n\n\t$self->{ 'contSegs' } = \\@contSegs;\n\treturn $self->{ 'contSegs' };\n    }\n}\n\n=head2 _numResLines\n\n Title         : _numResLines\n Usage         : returns the total number of residue lines in this\n                 dssp file.\n                 This number is DIFFERENT than the number of residues in\n                 the pdb file because dssp has chain termination and chain\n                 discontinuity 'residues'.\n Function      :\n Example       : $num_res = $dssp_obj->_numResLines();\n Returns       : scalar int\n Args          : none\n\n\n\nsub _numResLines {\n    my $self = shift;\n    return ( $#{$self->{ 'Res' }} );\n}\n\n=head2 _toDsspKey\n\n Title         : _toDsspKey\n Usage         : returns the unique dssp integer key given a pdb residue id.\n                 All accessor methods require (internally)\n                 the dssp key.   This method is very useful in converting\n                 pdb keys to dssp keys so the accessors can accept pdb keys\n                 as argument.  PDB Residue IDs are inherently\n                 problematic since they have multiple parts of\n                 overlapping function and ill-defined or observed\n                 convention in form.  Input can be in any of the formats\n                 described in the DESCRIPTION section above.\n Function      :\n Example       : $dssp_id = $dssp_obj->_pdbKeyToDsspKey( '10B:A' )\n Returns       : scalar int\n Args          : pdb residue identifier: num[insertion code]:[chain]\n\n\n\nsub _toDsspKey {\n    # Consider adding lookup table for 'common' name (like 20:A) for\n    # fast access.  Could be built during parse of input.\n\n    my $self = shift;\n    my $arg_str;\n\n    my ( $key_num, $chain_id, $ins_code );\n\n    # check to see how many args are given\n    if ( $#_ > 1 ) { # multiple args\n\t$key_num = shift;\n\tif ( $#_ > 1 ) { # still multiple args => ins. code, too\n\t    $ins_code = shift;\n\t    $chain_id = shift;\n\t}\n\telse { # just one more arg. => chain_id\n\t    $chain_id = shift;\n\t}\n    }\n    else { # only single arg.  Might be number or string\n\t$arg_str = shift;\n\tif ( $arg_str =~ /:/ ) {\n\t    # a chain is specified\n\t    ( $chain_id ) = ( $arg_str =~ /:(.)/);\n\t    $arg_str =~ s/:.//;\n\t}\n\tif ( $arg_str =~ /[A-Z]|[a-z]/ ) {\n\t    # an insertion code is specified\n\t    ( $ins_code ) = ( $arg_str =~ /([A-Z]|[a-z])/ );\n\t    $arg_str =~ s/[A-Z]|[a-z]//g;\n\t}\n\t#now, get the number bit-> everything still around\n\t$key_num = $arg_str;\n    }\n\n    # Now find the residue which fits this description.  Linear search is\n    # probably not the best way to do this, but oh well...\n    for ( my $i = 1; $i <= $self->_numResLines(); $i++ ) {\n\tunless ( ($self->{'Res'}->[$i]->{'term_sig'} eq '*') ||\n\t\t ($self->{'Res'}->[$i]->{'amino_acid'} eq '!') ) {\n\t    # chain break 'residue', doesn't match anything\n\t    if ( $key_num == $self->{'Res'}->[$i]->{'pdb_resnum'} ) {\n\t\tif ( $chain_id ) { # if a chain was specified\n\t\t    if ( $chain_id eq $self->{'Res'}->[$i]->{'pdb_chain'} ) {\n\t\t\t# and it's the right one\n\t\t\tif ( $ins_code ) { # if insertion code was specified\n\t\t\t    if ( $ins_code eq $self->{'Res'}->[$i]->{'insertionco'} ) {\n\t\t\t\t# and it's the right one\n\t\t\t\treturn $i;\n\t\t\t    }\n\t\t\t}\n\t\t\telse { # no isertion code specified, this is it\n\t\t\t    return $i;\n\t\t\t}\n\t\t    }\n\t\t}\n\t\telse { # no chain was specified\n\t\t    return $i;\n\t\t}\n\t    }\n\t}\n    }\n    $self->throw( \"PDB key not found.\" );\n}\n\n=head2 _parse\n\n Title         : _parse\n Usage         : parses dssp output\n Function      :\n Example       : used by the constructor\n Returns       :\n Args          : input source ( handled by Bio::Root:IO )\n\n\n\nsub _parse {\n    my $self = shift;\n    my $file = shift;\n    my $cur;\n    my $current_chain;\n    my ( @elements, @hbond );\n    my ( %head, %his, );\n    my $element;\n    my $res_num;\n\n    $cur = <$file>;\n    unless ( $cur =~ /^==== Secondary Structure Definition/ ) {\n\t$self->throw( \"Not dssp output\" );\n\treturn;\n    }\n\n    # REFERENCE line (always there)\n    $cur = <$file>;\n    ( $element ) = ( $cur =~ /^REFERENCE\\s+(.+?)\\s+\\./ );\n    $head{ 'REFERENCE' } = $element;\n\n    $cur = <$file>;\n    # Check for HEADER line (not always there)\n    if ( $cur =~ /^HEADER\\s/ ) {\n\t@elements = split( /\\s+/, $cur );\n\tpop( @elements ); # take off that annoying period\n\t$head{ 'PDB' } = pop( @elements );\n\t$head{ 'DATE' } = pop( @elements );\n\t# now, everything else is \"header\" except for the word\n\t# HEADER\n\tshift( @elements );\n\t$element = shift( @elements );\n\twhile ( @elements ) {\n\t    $element = $element.\" \".shift( @elements );\n\t}\n\t$head{ 'HEADER' } = $element;\n\t\n\t$cur = <$file>;\n    }\n\n    # Check for COMPND line (not always there)\n    if ( $cur =~ /^COMPND\\s/ ) {\n\t($element) = ( $cur =~ /^COMPND\\s+(.+?)\\s+\\./ );\n\t$head{ 'COMPND' } = $element;\n\t\n\t$cur = <$file>;\n    }\n\n    # Check for SOURCE or PDBSOURCE line (not always there)\n    if ( $cur =~ /^PDBSOURCE\\s/ ) {\n\t($element) = ( $cur =~ /^PDBSOURCE\\s+(.+?)\\s+\\./ );\n\t$head{ 'SOURCE' } = $element;\n\t\n\t$cur = <$file>;\n    }\n\n    elsif ( $cur =~ /^SOURCE\\s/ ) {\n\t($element) = ( $cur =~ /^SOURCE\\s+(.+?)\\s+\\./ );\n\t$head{ 'SOURCE' } = $element;\n\t\n\t$cur = <$file>;\n    }\n\n    # Check for AUTHOR line (not always there)\n    if ( $cur =~ /^AUTHOR/ ) {\n\t($element) = ( $cur =~ /^AUTHOR\\s+(.+?)\\s+/ );\n\t$head{ 'AUTHOR' } = $element;\n\n\t$cur = <$file>;\n    }\n\n    # A B C D E TOTAL NUMBER OF RESIDUES, NUMBER ... line\n    @elements = split( /\\s+/, $cur );\n    shift( @elements );\n    $head{ 'TotNumRes' } = shift( @elements );\n    $head{ 'NumChain' }  = shift( @elements );\n    $head{ 'TotSSBr' }   = shift( @elements );\n    $head{ 'TotIaSSBr' } = shift( @elements );\n    $head{ 'TotIeSSBr' } = shift( @elements );\n\n    $cur = <$file>;\n    ( $element ) = ( $cur =~ /\\s*(\\d+\\.\\d*)\\s+ACCESSIBLE SURFACE OF PROTEIN/ );\n    $head{ 'ProAccSurf' } = $element;\n    $self->{ 'Head' } = \\%head;\n\n    for ( my $i = 1; $i <= 14; $i++ ) {\n\t$cur = <$file>;\n\t( $element ) =\n\t    $cur =~ /\\s*(\\d+)\\s+\\d+\\.\\d+\\s+TOTAL NUMBER OF HYDROGEN/;\n\tpush( @hbond, $element );\n#\t$hbond{ $hBondType } = $element;\n    }\n    $self->{ 'HBond' } = \\@hbond;\n\n    my $histogram_finished = 0;\n    while ( !($histogram_finished) && chomp( $cur = <$file> ) ) {\n\tif ( $cur =~ /RESIDUE AA STRUCTURE/ ) {\n\t    $histogram_finished = 1;\n\t}\n    }\n\n    while ( $cur = <$file> ) {\n\tif ( $cur =~ m/^\\s*$/ ) {\n\t    next;\n\t}\n\t$res_num = substr( $cur, 0, 5 );\n\t$res_num =~ s/\\s//g;\n\t$self->{ 'Res' }->[ $res_num ] = &_parseResLine( $cur );\n    }\n}\n\n\n=head2 _parseResLine\n\n Title         : _parseResLine\n Usage         : parses a single residue line\n Function      :\n Example       : used internally\n Returns       :\n Args          : residue line ( string )"},"line":1384,"kind":12,"range":{"start":{"character":0,"line":1384},"end":{"line":1401,"character":9999}}}]}