{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":136},{"containerName":"","kind":2,"name":"base","line":140},{"containerName":null,"kind":13,"name":"%ONECODE","line":145},{"line":155,"kind":13,"containerName":null,"name":"%THREECODE"},{"signature":{"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$stop"},{"label":"$sep"}],"label":"seq3($self,$seq,$stop,$sep)"},"line":184,"range":{"start":{"character":0,"line":184},"end":{"line":205,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$seq,$stop,$sep)","children":[{"line":185,"name":"$self","containerName":"seq3","localvar":"my","kind":13,"definition":"my"},{"line":185,"kind":13,"containerName":"seq3","name":"$seq"},{"line":185,"name":"$stop","kind":13,"containerName":"seq3"},{"containerName":"seq3","kind":13,"name":"$sep","line":185},{"line":187,"kind":13,"containerName":"seq3","name":"$seq"},{"name":"isa","containerName":"seq3","kind":12,"line":187},{"line":188,"containerName":"seq3","kind":13,"name":"$self"},{"containerName":"seq3","kind":12,"name":"throw","line":188},{"line":189,"name":"$seq","kind":13,"containerName":"seq3"},{"line":189,"kind":12,"containerName":"seq3","name":"alphabet"},{"name":"$self","containerName":"seq3","kind":13,"line":190},{"line":190,"name":"throw","kind":12,"containerName":"seq3"},{"line":192,"kind":13,"containerName":"seq3","name":"$stop"},{"name":"$stop","containerName":"seq3","kind":13,"line":193},{"line":193,"name":"$self","kind":13,"containerName":"seq3"},{"name":"throw","containerName":"seq3","kind":12,"line":193},{"line":194,"kind":13,"containerName":"seq3","name":"$THREECODE"},{"name":"$stop","containerName":"seq3","kind":13,"line":194},{"line":196,"name":"$sep","kind":13,"containerName":"seq3"},{"definition":"my","localvar":"my","kind":13,"containerName":"seq3","name":"$aa3s","line":198},{"line":199,"containerName":"seq3","localvar":"my","kind":13,"name":"$aa","definition":"my"},{"line":199,"name":"$seq","containerName":"seq3","kind":13},{"line":199,"name":"seq","containerName":"seq3","kind":12},{"kind":13,"containerName":"seq3","name":"$THREECODE","line":200},{"line":200,"name":"$aa","kind":13,"containerName":"seq3"},{"name":"$aa3s","containerName":"seq3","kind":13,"line":200},{"line":200,"containerName":"seq3","kind":13,"name":"$THREECODE"},{"line":200,"name":"$aa","containerName":"seq3","kind":13},{"line":200,"kind":13,"containerName":"seq3","name":"$sep"},{"name":"$aa3s","kind":13,"containerName":"seq3","line":201},{"line":201,"name":"$sep","kind":13,"containerName":"seq3"},{"line":203,"kind":13,"containerName":"seq3","name":"$sep"},{"kind":13,"containerName":"seq3","name":"$aa3s","line":203},{"kind":13,"containerName":"seq3","name":"$sep","line":203},{"name":"$sep","kind":13,"containerName":"seq3","line":203},{"line":204,"name":"$aa3s","kind":13,"containerName":"seq3"}],"name":"seq3","containerName":"main::"},{"signature":{"label":"seq3in($self,$seq,$string,$stop,$unknown)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$string"},{"label":"$stop"},{"label":"$unknown"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'"},"line":226,"range":{"end":{"line":253,"character":9999},"start":{"character":0,"line":226}},"kind":12,"definition":"sub","detail":"($self,$seq,$string,$stop,$unknown)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"seq3in","line":227,"definition":"my"},{"kind":13,"containerName":"seq3in","name":"$seq","line":227},{"kind":13,"containerName":"seq3in","name":"$string","line":227},{"line":227,"name":"$stop","kind":13,"containerName":"seq3in"},{"containerName":"seq3in","kind":13,"name":"$unknown","line":227},{"kind":13,"containerName":"seq3in","name":"$seq","line":229},{"kind":12,"containerName":"seq3in","name":"isa","line":229},{"containerName":"seq3in","kind":13,"name":"$self","line":230},{"name":"throw","containerName":"seq3in","kind":12,"line":230},{"name":"$seq","kind":13,"containerName":"seq3in","line":231},{"line":231,"containerName":"seq3in","kind":12,"name":"alphabet"},{"name":"$self","kind":13,"containerName":"seq3in","line":232},{"name":"throw","containerName":"seq3in","kind":12,"line":232},{"containerName":"seq3in","kind":13,"name":"$stop","line":234},{"line":235,"name":"$stop","kind":13,"containerName":"seq3in"},{"containerName":"seq3in","kind":13,"name":"$self","line":235},{"line":235,"containerName":"seq3in","kind":12,"name":"throw"},{"name":"$ONECODE","kind":13,"containerName":"seq3in","line":236},{"line":236,"name":"$stop","containerName":"seq3in","kind":13},{"containerName":"seq3in","kind":13,"name":"$unknown","line":238},{"line":239,"name":"$unknown","containerName":"seq3in","kind":13},{"kind":13,"containerName":"seq3in","name":"$self","line":239},{"kind":12,"containerName":"seq3in","name":"throw","line":239},{"kind":13,"containerName":"seq3in","name":"$ONECODE","line":240},{"containerName":"seq3in","kind":13,"name":"$unknown","line":240},{"line":243,"localvar":"my","containerName":"seq3in","kind":13,"name":"$aas","definition":"my"},{"line":243,"kind":13,"containerName":"seq3in","name":"$aa3"},{"line":244,"localvar":"my","kind":13,"containerName":"seq3in","name":"$length","definition":"my"},{"kind":13,"containerName":"seq3in","name":"$string","line":244},{"definition":"my","line":245,"kind":13,"localvar":"my","containerName":"seq3in","name":"$i"},{"containerName":"seq3in","kind":13,"name":"$i","line":245},{"containerName":"seq3in","kind":13,"name":"$length","line":245},{"name":"$i","containerName":"seq3in","kind":13,"line":245},{"line":246,"containerName":"seq3in","kind":13,"name":"$aa3"},{"kind":13,"containerName":"seq3in","name":"$string","line":246},{"containerName":"seq3in","kind":13,"name":"$i","line":246},{"kind":13,"containerName":"seq3in","name":"$aa3","line":247},{"containerName":"seq3in","kind":13,"name":"$aa3","line":247},{"line":248,"kind":13,"containerName":"seq3in","name":"$ONECODE"},{"line":248,"containerName":"seq3in","kind":13,"name":"$aa3"},{"line":248,"kind":13,"containerName":"seq3in","name":"$aas"},{"line":248,"containerName":"seq3in","kind":13,"name":"$ONECODE"},{"line":248,"name":"$aa3","kind":13,"containerName":"seq3in"},{"line":249,"containerName":"seq3in","kind":13,"name":"$aas"},{"kind":13,"containerName":"seq3in","name":"$ONECODE","line":249},{"name":"$seq","containerName":"seq3in","kind":13,"line":251},{"line":251,"name":"seq","kind":12,"containerName":"seq3in"},{"kind":13,"containerName":"seq3in","name":"$aas","line":251},{"line":252,"kind":13,"containerName":"seq3in","name":"$seq"}],"containerName":"main::","name":"seq3in"},{"detail":"($self,$seq,@args)","definition":"sub","name":"translate_3frames","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"translate_3frames","kind":13,"line":268,"definition":"my"},{"kind":13,"containerName":"translate_3frames","name":"$seq","line":268},{"name":"@args","kind":13,"containerName":"translate_3frames","line":268},{"line":270,"name":"$self","kind":13,"containerName":"translate_3frames"},{"kind":12,"containerName":"translate_3frames","name":"throw","line":270},{"containerName":"translate_3frames","kind":13,"name":"$seq","line":270},{"line":271,"name":"$seq","containerName":"translate_3frames","kind":13},{"name":"can","containerName":"translate_3frames","kind":12,"line":271},{"definition":"my","localvar":"my","containerName":"translate_3frames","kind":13,"name":"$stop","line":273},{"name":"$unknown","kind":13,"containerName":"translate_3frames","line":273},{"name":"$frame","kind":13,"containerName":"translate_3frames","line":273},{"line":273,"name":"$tableid","containerName":"translate_3frames","kind":13},{"name":"$fullCDS","containerName":"translate_3frames","kind":13,"line":273},{"line":273,"kind":13,"containerName":"translate_3frames","name":"$throw"},{"name":"@args","containerName":"translate_3frames","kind":13,"line":273},{"localvar":"my","kind":13,"containerName":"translate_3frames","name":"@seqs","line":274,"definition":"my"},{"line":275,"name":"$f","containerName":"translate_3frames","localvar":"my","kind":13,"definition":"my"},{"name":"$f","containerName":"translate_3frames","kind":13,"line":276},{"line":277,"containerName":"translate_3frames","localvar":"my","kind":13,"name":"$translation","definition":"my"},{"name":"$seq","containerName":"translate_3frames","kind":13,"line":277},{"name":"translate","containerName":"translate_3frames","kind":12,"line":277},{"line":277,"name":"$stop","containerName":"translate_3frames","kind":13},{"line":277,"name":"$unknown","kind":13,"containerName":"translate_3frames"},{"line":277,"name":"$f","kind":13,"containerName":"translate_3frames"},{"kind":13,"containerName":"translate_3frames","name":"$tableid","line":277},{"containerName":"translate_3frames","kind":13,"name":"$fullCDS","line":277},{"containerName":"translate_3frames","kind":13,"name":"$throw","line":277},{"name":"$translation","kind":13,"containerName":"translate_3frames","line":278},{"line":278,"name":"id","containerName":"translate_3frames","kind":12},{"line":278,"kind":13,"containerName":"translate_3frames","name":"$seq"},{"line":278,"kind":12,"containerName":"translate_3frames","name":"id"},{"kind":13,"containerName":"translate_3frames","name":"$f","line":278},{"line":279,"kind":13,"containerName":"translate_3frames","name":"@seqs"},{"line":279,"name":"$translation","containerName":"translate_3frames","kind":13},{"containerName":"translate_3frames","kind":13,"name":"$f","line":280},{"line":283,"containerName":"translate_3frames","kind":13,"name":"@seqs"}],"signature":{"label":"translate_3frames($self,$seq,@args)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate"},"range":{"end":{"line":284,"character":9999},"start":{"character":0,"line":267}},"kind":12,"line":267},{"signature":{"parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate","label":"translate_6frames($self,$seq,@args)"},"range":{"start":{"line":299,"character":0},"end":{"character":9999,"line":310}},"kind":12,"line":299,"detail":"($self,$seq,@args)","definition":"sub","containerName":"main::","name":"translate_6frames","children":[{"kind":13,"localvar":"my","containerName":"translate_6frames","name":"$self","line":300,"definition":"my"},{"line":300,"name":"$seq","containerName":"translate_6frames","kind":13},{"containerName":"translate_6frames","kind":13,"name":"@args","line":300},{"line":302,"kind":13,"localvar":"my","containerName":"translate_6frames","name":"@seqs","definition":"my"},{"line":302,"containerName":"translate_6frames","kind":13,"name":"$self"},{"kind":12,"containerName":"translate_6frames","name":"translate_3frames","line":302},{"line":302,"name":"$seq","kind":13,"containerName":"translate_6frames"},{"name":"@args","kind":13,"containerName":"translate_6frames","line":302},{"definition":"my","line":303,"name":"@seqs2","localvar":"my","kind":13,"containerName":"translate_6frames"},{"line":303,"name":"$self","containerName":"translate_6frames","kind":13},{"line":303,"containerName":"translate_6frames","kind":12,"name":"translate_3frames"},{"line":303,"containerName":"translate_6frames","kind":13,"name":"$seq"},{"containerName":"translate_6frames","kind":12,"name":"revcom","line":303},{"line":303,"name":"@args","containerName":"translate_6frames","kind":13},{"line":304,"name":"$seq2","containerName":"translate_6frames","localvar":"my","kind":13,"definition":"my"},{"name":"@seqs2","kind":13,"containerName":"translate_6frames","line":304},{"line":305,"name":"$tmp","containerName":"translate_6frames","localvar":"my","kind":13,"definition":"my"},{"name":"$seq2","kind":13,"containerName":"translate_6frames","line":305},{"containerName":"translate_6frames","kind":12,"name":"id","line":305},{"line":306,"containerName":"translate_6frames","kind":13,"name":"$tmp"},{"line":307,"containerName":"translate_6frames","kind":13,"name":"$seq2"},{"containerName":"translate_6frames","kind":12,"name":"id","line":307},{"containerName":"translate_6frames","kind":13,"name":"$tmp","line":307},{"line":309,"kind":13,"containerName":"translate_6frames","name":"@seqs"},{"line":309,"name":"@seqs2","kind":13,"containerName":"translate_6frames"}]},{"signature":{"parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]","label":"valid_aa($self,$code)"},"line":327,"range":{"start":{"line":327,"character":0},"end":{"character":9999,"line":357}},"kind":12,"definition":"sub","detail":"($self,$code)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"valid_aa","line":328},{"kind":13,"containerName":"valid_aa","name":"$code","line":328},{"name":"$code","containerName":"valid_aa","kind":13,"line":330},{"definition":"my","line":331,"name":"@codes","containerName":"valid_aa","localvar":"my","kind":13},{"line":332,"localvar":"my","containerName":"valid_aa","kind":13,"name":"$c","definition":"my"},{"kind":13,"containerName":"valid_aa","name":"%ONECODE","line":332},{"name":"@codes","containerName":"valid_aa","kind":13,"line":333},{"kind":13,"containerName":"valid_aa","name":"$c","line":333},{"containerName":"valid_aa","kind":13,"name":"$c","line":333},{"kind":13,"containerName":"valid_aa","name":"@codes","line":335},{"line":336,"name":"@codes","containerName":"valid_aa","kind":13},{"line":338,"name":"$code","containerName":"valid_aa","kind":13},{"line":339,"localvar":"my","kind":13,"containerName":"valid_aa","name":"@codes","definition":"my"},{"definition":"my","line":340,"localvar":"my","kind":13,"containerName":"valid_aa","name":"$c"},{"name":"%ONECODE","kind":13,"containerName":"valid_aa","line":340},{"name":"@codes","containerName":"valid_aa","kind":13,"line":341},{"line":341,"containerName":"valid_aa","kind":13,"name":"$c"},{"line":341,"name":"$c","kind":13,"containerName":"valid_aa"},{"line":343,"containerName":"valid_aa","kind":13,"name":"@codes"},{"containerName":"valid_aa","kind":13,"name":"@codes","line":344},{"line":346,"name":"$code","containerName":"valid_aa","kind":13},{"line":347,"kind":13,"localvar":"my","containerName":"valid_aa","name":"%codes","definition":"my"},{"line":347,"name":"%ONECODE","kind":13,"containerName":"valid_aa"},{"line":348,"localvar":"my","containerName":"valid_aa","kind":13,"name":"$c","definition":"my"},{"kind":13,"containerName":"valid_aa","name":"%ONECODE","line":348},{"localvar":"my","containerName":"valid_aa","kind":13,"name":"$aa","line":349,"definition":"my"},{"containerName":"valid_aa","kind":13,"name":"$ONECODE","line":349},{"line":349,"kind":13,"containerName":"valid_aa","name":"$c"},{"kind":13,"containerName":"valid_aa","name":"$codes","line":350},{"name":"$aa","containerName":"valid_aa","kind":13,"line":350},{"kind":13,"containerName":"valid_aa","name":"$c","line":350},{"line":352,"name":"%codes","kind":13,"containerName":"valid_aa"},{"line":354,"kind":13,"containerName":"valid_aa","name":"$self"},{"kind":12,"containerName":"valid_aa","name":"warn","line":354},{"containerName":"valid_aa","kind":13,"name":"$self","line":354}],"name":"valid_aa","containerName":"main::"},{"line":379,"range":{"end":{"character":9999,"line":398},"start":{"character":0,"line":379}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@mutations"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.","label":"mutate($self,$seq,@mutations)"},"children":[{"kind":13,"localvar":"my","containerName":"mutate","name":"$self","line":380,"definition":"my"},{"name":"$seq","containerName":"mutate","kind":13,"line":380},{"line":380,"name":"@mutations","kind":13,"containerName":"mutate"},{"containerName":"mutate","kind":13,"name":"$self","line":382},{"name":"throw","containerName":"mutate","kind":12,"line":382},{"line":382,"name":"$seq","kind":13,"containerName":"mutate"},{"containerName":"mutate","kind":13,"name":"$seq","line":384},{"line":384,"name":"isa","kind":12,"containerName":"mutate"},{"line":385,"containerName":"mutate","kind":13,"name":"$self"},{"kind":12,"containerName":"mutate","name":"throw","line":385},{"line":385,"containerName":"mutate","kind":13,"name":"$mutations"},{"line":387,"name":"$mutations","kind":13,"containerName":"mutate"},{"containerName":"mutate","kind":12,"name":"isa","line":387},{"definition":"my","name":"$mutation","localvar":"my","containerName":"mutate","kind":13,"line":389},{"name":"@mutations","kind":13,"containerName":"mutate","line":389},{"line":390,"name":"$self","containerName":"mutate","kind":13},{"containerName":"mutate","kind":12,"name":"throw","line":390},{"name":"$mutation","containerName":"mutate","kind":13,"line":391},{"kind":12,"containerName":"mutate","name":"pos","line":391},{"line":391,"name":"$seq","containerName":"mutate","kind":13},{"containerName":"mutate","kind":12,"name":"length","line":391},{"localvar":"my","kind":13,"containerName":"mutate","name":"$string","line":393,"definition":"my"},{"line":393,"kind":13,"containerName":"mutate","name":"$seq"},{"line":393,"name":"seq","containerName":"mutate","kind":12},{"line":394,"name":"$string","kind":13,"containerName":"mutate"},{"name":"$mutation","containerName":"mutate","kind":13,"line":394},{"containerName":"mutate","kind":12,"name":"pos","line":394},{"name":"$mutation","kind":13,"containerName":"mutate","line":394},{"line":394,"name":"len","containerName":"mutate","kind":12},{"kind":13,"containerName":"mutate","name":"$mutation","line":394},{"name":"seq","kind":12,"containerName":"mutate","line":394},{"line":395,"name":"$seq","containerName":"mutate","kind":13},{"name":"seq","kind":12,"containerName":"mutate","line":395},{"line":395,"containerName":"mutate","kind":13,"name":"$string"}],"name":"mutate","containerName":"main::","definition":"sub","detail":"($self,$seq,@mutations)"},{"definition":"sub","detail":"($self,$seq,@seqs)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"cat","line":418},{"line":418,"containerName":"cat","kind":13,"name":"$seq"},{"line":418,"name":"@seqs","containerName":"cat","kind":13},{"name":"$self","containerName":"cat","kind":13,"line":419},{"kind":12,"containerName":"cat","name":"throw","line":419},{"line":419,"kind":13,"containerName":"cat","name":"$seq"},{"line":421,"containerName":"cat","kind":13,"name":"$seq"},{"line":421,"containerName":"cat","kind":12,"name":"isa"},{"definition":"my","line":424,"name":"$catseq","localvar":"my","kind":13,"containerName":"cat"},{"line":424,"name":"@seqs","containerName":"cat","kind":13},{"name":"$self","kind":13,"containerName":"cat","line":425},{"line":425,"containerName":"cat","kind":12,"name":"throw"},{"name":"$catseq","kind":13,"containerName":"cat","line":425},{"line":427,"kind":13,"containerName":"cat","name":"$catseq"},{"name":"isa","kind":12,"containerName":"cat","line":427},{"name":"$self","containerName":"cat","kind":13,"line":429},{"line":429,"name":"throw","kind":12,"containerName":"cat"},{"kind":13,"containerName":"cat","name":"$seq","line":430},{"kind":12,"containerName":"cat","name":"display_id","line":430},{"name":"$seq","kind":13,"containerName":"cat","line":430},{"name":"alphabet","containerName":"cat","kind":12,"line":430},{"line":430,"name":"$catseq","kind":13,"containerName":"cat"},{"line":430,"containerName":"cat","kind":12,"name":"display_id"},{"containerName":"cat","kind":13,"name":"$catseq","line":431},{"name":"alphabet","containerName":"cat","kind":12,"line":431},{"line":432,"kind":13,"containerName":"cat","name":"$catseq"},{"name":"alphabet","containerName":"cat","kind":12,"line":432},{"name":"$seq","kind":13,"containerName":"cat","line":432},{"name":"alphabet","containerName":"cat","kind":12,"line":432},{"localvar":"my","kind":13,"containerName":"cat","name":"$length","line":435,"definition":"my"},{"line":435,"name":"$seq","kind":13,"containerName":"cat"},{"line":435,"kind":12,"containerName":"cat","name":"length"},{"name":"$seq","kind":13,"containerName":"cat","line":436},{"containerName":"cat","kind":12,"name":"seq","line":436},{"line":436,"kind":13,"containerName":"cat","name":"$seq"},{"kind":12,"containerName":"cat","name":"seq","line":436},{"line":436,"name":"$catseq","kind":13,"containerName":"cat"},{"line":436,"name":"seq","kind":12,"containerName":"cat"},{"containerName":"cat","kind":13,"name":"$seq","line":439},{"name":"isa","kind":12,"containerName":"cat","line":439},{"name":"$catseq","kind":13,"containerName":"cat","line":439},{"name":"isa","containerName":"cat","kind":12,"line":439},{"line":440,"name":"$key","localvar":"my","containerName":"cat","kind":13,"definition":"my"},{"line":440,"name":"$catseq","containerName":"cat","kind":13},{"containerName":"cat","kind":12,"name":"annotation","line":440},{"line":440,"name":"get_all_annotation_keys","kind":12,"containerName":"cat"},{"definition":"my","name":"$value","localvar":"my","containerName":"cat","kind":13,"line":442},{"containerName":"cat","kind":13,"name":"$catseq","line":442},{"line":442,"containerName":"cat","kind":12,"name":"annotation"},{"containerName":"cat","kind":12,"name":"get_Annotations","line":442},{"line":442,"containerName":"cat","kind":13,"name":"$key"},{"containerName":"cat","kind":13,"name":"$seq","line":443},{"line":443,"containerName":"cat","kind":12,"name":"annotation"},{"name":"add_Annotation","kind":12,"containerName":"cat","line":443},{"kind":13,"containerName":"cat","name":"$key","line":443},{"line":443,"name":"$value","containerName":"cat","kind":13},{"name":"$seq","kind":13,"containerName":"cat","line":449},{"line":449,"name":"isa","kind":12,"containerName":"cat"},{"line":449,"kind":13,"containerName":"cat","name":"$catseq"},{"containerName":"cat","kind":12,"name":"isa","line":449},{"name":"$feat","containerName":"cat","localvar":"my","kind":13,"line":450,"definition":"my"},{"containerName":"cat","kind":13,"name":"$catseq","line":450},{"line":450,"name":"get_SeqFeatures","containerName":"cat","kind":12},{"kind":13,"containerName":"cat","name":"$seq","line":451},{"line":451,"name":"add_SeqFeature","kind":12,"containerName":"cat"},{"line":451,"containerName":"cat","kind":13,"name":"$self"},{"line":451,"containerName":"cat","kind":12,"name":"_coord_adjust"},{"kind":13,"containerName":"cat","name":"$feat","line":451},{"containerName":"cat","kind":13,"name":"$length","line":451}],"name":"cat","containerName":"main::","signature":{"label":"cat($self,$seq,@seqs)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"@seqs"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added."},"line":417,"kind":12,"range":{"start":{"line":417,"character":0},"end":{"line":457,"character":9999}}},{"line":473,"range":{"start":{"line":473,"character":0},"end":{"character":9999,"line":491}},"kind":12,"signature":{"label":"trunc_with_features($self,$seq,$start,$end)","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)"},"children":[{"definition":"my","line":475,"kind":13,"localvar":"my","containerName":"trunc_with_features","name":"$self"},{"line":475,"kind":13,"containerName":"trunc_with_features","name":"$seq"},{"line":475,"name":"$start","containerName":"trunc_with_features","kind":13},{"name":"$end","kind":13,"containerName":"trunc_with_features","line":475},{"kind":13,"containerName":"trunc_with_features","name":"$self","line":476},{"line":476,"containerName":"trunc_with_features","kind":12,"name":"throw"},{"containerName":"trunc_with_features","kind":13,"name":"$seq","line":476},{"containerName":"trunc_with_features","kind":13,"name":"$seq","line":478},{"line":478,"name":"isa","kind":12,"containerName":"trunc_with_features"},{"definition":"my","containerName":"trunc_with_features","localvar":"my","kind":13,"name":"$trunc","line":479},{"name":"$seq","containerName":"trunc_with_features","kind":13,"line":479},{"line":479,"name":"trunc","kind":12,"containerName":"trunc_with_features"},{"containerName":"trunc_with_features","kind":13,"name":"$start","line":479},{"name":"$end","kind":13,"containerName":"trunc_with_features","line":479},{"definition":"my","line":480,"name":"$truncrange","kind":13,"localvar":"my","containerName":"trunc_with_features"},{"kind":12,"containerName":"trunc_with_features","name":"new","line":480},{"line":480,"kind":13,"containerName":"trunc_with_features","name":"$start"},{"name":"$end","kind":13,"containerName":"trunc_with_features","line":480},{"localvar":"my","kind":13,"containerName":"trunc_with_features","name":"$key","line":482,"definition":"my"},{"kind":13,"containerName":"trunc_with_features","name":"$seq","line":482},{"kind":12,"containerName":"trunc_with_features","name":"annotation","line":482},{"line":482,"containerName":"trunc_with_features","kind":12,"name":"get_all_annotation_keys"},{"definition":"my","line":483,"localvar":"my","containerName":"trunc_with_features","kind":13,"name":"$value"},{"line":483,"containerName":"trunc_with_features","kind":13,"name":"$seq"},{"line":483,"containerName":"trunc_with_features","kind":12,"name":"annotation"},{"kind":12,"containerName":"trunc_with_features","name":"get_Annotations","line":483},{"line":483,"name":"$key","containerName":"trunc_with_features","kind":13},{"containerName":"trunc_with_features","kind":13,"name":"$trunc","line":484},{"kind":12,"containerName":"trunc_with_features","name":"annotation","line":484},{"line":484,"name":"add_Annotation","kind":12,"containerName":"trunc_with_features"},{"containerName":"trunc_with_features","kind":13,"name":"$key","line":484},{"name":"$value","kind":13,"containerName":"trunc_with_features","line":484},{"containerName":"trunc_with_features","kind":13,"name":"$trunc","line":489},{"line":489,"kind":12,"containerName":"trunc_with_features","name":"add_SeqFeature"},{"kind":13,"containerName":"trunc_with_features","name":"$self","line":489},{"line":489,"kind":12,"containerName":"trunc_with_features","name":"_coord_adjust"},{"name":"$start","containerName":"trunc_with_features","kind":13,"line":489},{"line":489,"name":"$end","kind":13,"containerName":"trunc_with_features"},{"line":489,"name":"$start","kind":13,"containerName":"trunc_with_features"},{"line":489,"kind":12,"containerName":"trunc_with_features","name":"overlaps"},{"name":"$truncrange","kind":13,"containerName":"trunc_with_features","line":489},{"kind":13,"containerName":"trunc_with_features","name":"$seq","line":489},{"kind":12,"containerName":"trunc_with_features","name":"get_SeqFeatures","line":489},{"kind":13,"containerName":"trunc_with_features","name":"$trunc","line":490}],"name":"trunc_with_features","containerName":"main::","definition":"sub","detail":"($self,$seq,$start,$end)"},{"line":475,"name":"Range","containerName":"Bio","kind":2},{"name":"Bio","containerName":"Range","kind":12,"line":480},{"children":[{"definition":"my","containerName":"_coord_adjust","localvar":"my","kind":13,"name":"$self","line":513},{"line":513,"name":"$feat","kind":13,"containerName":"_coord_adjust"},{"line":513,"name":"$add","kind":13,"containerName":"_coord_adjust"},{"line":513,"kind":13,"containerName":"_coord_adjust","name":"$length"},{"line":514,"kind":13,"containerName":"_coord_adjust","name":"$self"},{"kind":12,"containerName":"_coord_adjust","name":"throw","line":514},{"line":514,"containerName":"_coord_adjust","kind":13,"name":"$feat"},{"line":516,"containerName":"_coord_adjust","kind":13,"name":"$feat"},{"line":516,"name":"isa","containerName":"_coord_adjust","kind":12},{"line":517,"containerName":"_coord_adjust","localvar":"my","kind":13,"name":"@adjsubfeat","definition":"my"},{"definition":"my","name":"$subfeat","containerName":"_coord_adjust","localvar":"my","kind":13,"line":518},{"line":518,"name":"$feat","containerName":"_coord_adjust","kind":13},{"line":518,"name":"remove_SeqFeatures","containerName":"_coord_adjust","kind":12},{"line":519,"name":"@adjsubfeat","containerName":"_coord_adjust","kind":13},{"line":519,"name":"$self","kind":13,"containerName":"_coord_adjust"},{"containerName":"_coord_adjust","kind":12,"name":"_coord_adjust","line":519},{"name":"$subfeat","kind":13,"containerName":"_coord_adjust","line":519},{"containerName":"_coord_adjust","kind":13,"name":"$add","line":519},{"line":519,"kind":13,"containerName":"_coord_adjust","name":"$length"},{"definition":"my","containerName":"_coord_adjust","localvar":"my","kind":13,"name":"@loc","line":521},{"line":522,"kind":13,"containerName":"_coord_adjust","name":"$feat"},{"name":"location","kind":12,"containerName":"_coord_adjust","line":522},{"containerName":"_coord_adjust","kind":12,"name":"each_Location","line":522},{"name":"@coords","kind":13,"localvar":"my","containerName":"_coord_adjust","line":523,"definition":"my"},{"line":523,"kind":12,"containerName":"_coord_adjust","name":"start"},{"kind":12,"containerName":"_coord_adjust","name":"end","line":523},{"line":524,"containerName":"_coord_adjust","localvar":"my","kind":13,"name":"$strand","definition":"my"},{"name":"strand","kind":12,"containerName":"_coord_adjust","line":524},{"definition":"my","line":525,"localvar":"my","kind":13,"containerName":"_coord_adjust","name":"$type"},{"name":"location_type","kind":12,"containerName":"_coord_adjust","line":525},{"name":"@coords","kind":13,"containerName":"_coord_adjust","line":526},{"definition":"my","line":527,"name":"$newstart","localvar":"my","containerName":"_coord_adjust","kind":13},{"line":527,"kind":13,"containerName":"_coord_adjust","name":"$newend"},{"line":527,"containerName":"_coord_adjust","kind":13,"name":"@coords"},{"line":528,"name":"$type","containerName":"_coord_adjust","kind":13},{"containerName":"_coord_adjust","kind":13,"name":"@loc","line":529},{"name":"new","kind":12,"containerName":"_coord_adjust","line":529},{"line":529,"kind":13,"containerName":"_coord_adjust","name":"$newstart"},{"line":530,"name":"$newend","kind":13,"containerName":"_coord_adjust"},{"line":531,"name":"$strand","containerName":"_coord_adjust","kind":13},{"name":"$type","containerName":"_coord_adjust","kind":13,"line":533},{"line":535,"name":"@loc","containerName":"_coord_adjust","kind":13},{"name":"new","kind":12,"containerName":"_coord_adjust","line":535},{"name":"$newstart","containerName":"_coord_adjust","kind":13,"line":535},{"line":536,"containerName":"_coord_adjust","kind":13,"name":"$newend"},{"containerName":"_coord_adjust","kind":13,"name":"$strand","line":537},{"name":"$type","kind":13,"containerName":"_coord_adjust","line":539},{"line":542,"name":"$newfeat","localvar":"my","containerName":"_coord_adjust","kind":13,"definition":"my"},{"line":542,"name":"new","containerName":"_coord_adjust","kind":12},{"kind":13,"containerName":"_coord_adjust","name":"$feat","line":542},{"containerName":"_coord_adjust","kind":12,"name":"primary_tag","line":542},{"definition":"my","localvar":"my","kind":13,"containerName":"_coord_adjust","name":"$key","line":543},{"line":543,"name":"$feat","containerName":"_coord_adjust","kind":13},{"name":"annotation","containerName":"_coord_adjust","kind":12,"line":543},{"line":543,"containerName":"_coord_adjust","kind":12,"name":"get_all_annotation_keys"},{"definition":"my","name":"$value","kind":13,"localvar":"my","containerName":"_coord_adjust","line":544},{"line":544,"name":"$feat","kind":13,"containerName":"_coord_adjust"},{"line":544,"containerName":"_coord_adjust","kind":12,"name":"annotation"},{"name":"get_Annotations","containerName":"_coord_adjust","kind":12,"line":544},{"containerName":"_coord_adjust","kind":13,"name":"$key","line":544},{"containerName":"_coord_adjust","kind":13,"name":"$newfeat","line":545},{"line":545,"name":"annotation","kind":12,"containerName":"_coord_adjust"},{"line":545,"containerName":"_coord_adjust","kind":12,"name":"add_Annotation"},{"line":545,"name":"$key","kind":13,"containerName":"_coord_adjust"},{"line":545,"containerName":"_coord_adjust","kind":13,"name":"$value"},{"definition":"my","line":548,"name":"$key","localvar":"my","containerName":"_coord_adjust","kind":13},{"kind":13,"containerName":"_coord_adjust","name":"$feat","line":548},{"line":548,"containerName":"_coord_adjust","kind":12,"name":"get_all_tags"},{"line":549,"name":"$newfeat","kind":13,"containerName":"_coord_adjust"},{"line":549,"containerName":"_coord_adjust","kind":12,"name":"add_tag_value"},{"line":549,"kind":13,"containerName":"_coord_adjust","name":"$key"},{"name":"$feat","containerName":"_coord_adjust","kind":13,"line":549},{"name":"get_tag_values","kind":12,"containerName":"_coord_adjust","line":549},{"name":"$key","kind":13,"containerName":"_coord_adjust","line":549},{"name":"@loc","kind":13,"containerName":"_coord_adjust","line":551},{"containerName":"_coord_adjust","kind":13,"name":"$newfeat","line":552},{"name":"location","kind":12,"containerName":"_coord_adjust","line":552},{"line":552,"kind":13,"containerName":"_coord_adjust","name":"$loc"},{"definition":"my","line":554,"kind":13,"localvar":"my","containerName":"_coord_adjust","name":"$loc"},{"name":"new","kind":12,"containerName":"_coord_adjust","line":554},{"line":555,"name":"$loc","kind":13,"containerName":"_coord_adjust"},{"line":555,"kind":12,"containerName":"_coord_adjust","name":"add_sub_Location"},{"line":555,"name":"@loc","containerName":"_coord_adjust","kind":13},{"line":556,"kind":13,"containerName":"_coord_adjust","name":"$newfeat"},{"line":556,"name":"location","kind":12,"containerName":"_coord_adjust"},{"line":556,"name":"$loc","containerName":"_coord_adjust","kind":13},{"line":558,"name":"$newfeat","containerName":"_coord_adjust","kind":13},{"name":"add_SeqFeature","kind":12,"containerName":"_coord_adjust","line":558},{"line":558,"name":"@adjsubfeat","containerName":"_coord_adjust","kind":13},{"containerName":"_coord_adjust","kind":13,"name":"$newfeat","line":559}],"containerName":"main::","name":"_coord_adjust","definition":"sub","detail":"($self,$feat,$add,$length)","line":512,"kind":12,"range":{"start":{"character":0,"line":512},"end":{"line":560,"character":9999}},"signature":{"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)\n\n\n\nsub trunc_with_features{\n    use Bio::Range;\n    my ($self,$seq,$start,$end) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $trunc=$seq->trunc($start, $end);\n    my $truncrange=Bio::Range->new(-start=>$start, -end=>$end, -strand=>0);\n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $trunc->annotation->add_Annotation($key, $value);\n\t}\n    } \n    \n    #move features\n    $trunc->add_SeqFeature(grep {$_=$self->_coord_adjust($_, 1-$start, $end+1-$start) if $_->overlaps($truncrange)} $seq->get_SeqFeatures);\n    return $trunc;\n}\n\n\n\n=head2 _coord_adjust\n\n  Title   : _coord_adjust\n  Usage   : my $newfeat=Bio::SeqUtils->_coord_adjust($feature, 100, $seq->length);\n  Function: Recursive subroutine to adjust the coordinates of a feature\n            and all its subfeatures. If a sequence length is specified, then\n            any adjusted features that have locations beyond the boundaries\n            of the sequence are converted to Bio::Location::Fuzzy objects.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the number of bases to add to the coordinates\n            (optional) the length of the parent sequence","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$add"},{"label":"$length"}],"label":"_coord_adjust($self,$feat,$add,$length)"}},{"containerName":"Location::Fuzzy","kind":12,"name":"Bio","line":529},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":535},{"line":542,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"containerName":"Location::Split","kind":12,"name":"Bio","line":554},{"signature":{"label":"revcom_with_features($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)\n\n\n\nsub trunc_with_features{\n    use Bio::Range;\n    my ($self,$seq,$start,$end) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $trunc=$seq->trunc($start, $end);\n    my $truncrange=Bio::Range->new(-start=>$start, -end=>$end, -strand=>0);\n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $trunc->annotation->add_Annotation($key, $value);\n\t}\n    } \n    \n    #move features\n    $trunc->add_SeqFeature(grep {$_=$self->_coord_adjust($_, 1-$start, $end+1-$start) if $_->overlaps($truncrange)} $seq->get_SeqFeatures);\n    return $trunc;\n}\n\n\n\n=head2 _coord_adjust\n\n  Title   : _coord_adjust\n  Usage   : my $newfeat=Bio::SeqUtils->_coord_adjust($feature, 100, $seq->length);\n  Function: Recursive subroutine to adjust the coordinates of a feature\n            and all its subfeatures. If a sequence length is specified, then\n            any adjusted features that have locations beyond the boundaries\n            of the sequence are converted to Bio::Location::Fuzzy objects.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the number of bases to add to the coordinates\n            (optional) the length of the parent sequence\n\n\n\nsub _coord_adjust {\n    my ($self, $feat, $add, $length)=@_;\n    $self->throw('Object [$feat] '. 'of class ['. ref($feat).\n                 '] should be a Bio::SeqFeatureI ')\n        unless $feat->isa('Bio::SeqFeatureI');\n    my @adjsubfeat;\n    for my $subfeat ($feat->remove_SeqFeatures) {\n        push @adjsubfeat, $self->_coord_adjust($subfeat, $add, $length);\n    }\n    my @loc;\n    for ($feat->location->each_Location) {\n        my @coords=($_->start, $_->end);\n        my $strand=$_->strand;\n\tmy $type=$_->location_type;\n        map s/(\\d+)/if ($add+$1<1) {'<1'} elsif (defined $length and $add+$1>$length) {\">$length\"} else {$add+$1}/ge, @coords;\n\tmy($newstart,$newend)=@coords;\n\tunless ($type eq 'IN-BETWEEN') {\n\t    push @loc, Bio::Location::Fuzzy->new(-start=>$newstart,\n\t\t\t\t\t\t -end=>$newend,\n\t\t\t\t\t\t -strand=>$strand,\n\t\t\t\t\t\t -location_type=>$type\n\t\t\t\t\t\t);\n\t} else {\n\t    push @loc, Bio::Location::Simple->new(-start=>$newstart,\n\t\t\t\t\t  -end=>$newend,\n\t\t\t\t\t  -strand=>$strand,\n\t\t\t\t\t  -location_type=>$type\n\t\t\t\t\t );\n\t}\n    }\n    my $newfeat=Bio::SeqFeature::Generic->new(-primary=>$feat->primary_tag);\n    foreach my $key ( $feat->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $feat->annotation->get_Annotations($key) ) {\n\t    $newfeat->annotation->add_Annotation($key, $value);\n\t}\n    } \n    foreach my $key ( $feat->get_all_tags() ) {\n\t    $newfeat->add_tag_value($key, $feat->get_tag_values($key));\n    } \n    if (@loc==1) {\n        $newfeat->location($loc[0])\n    } else {\n        my $loc=Bio::Location::Split->new;\n        $loc->add_sub_Location(@loc);\n        $newfeat->location($loc);\n    }\n    $newfeat->add_SeqFeature($_) for @adjsubfeat;\n    return $newfeat;\n}\n\n\n=head2 revcom_with_features\n\n Title   : revcom_with_features\n Usage   : $revcom=Bio::SeqUtils->revcom_with_features($seq);\n Function: Like Bio::Seq::revcom, but keeps features (adjusting coordinates\n           as appropriate.\n Returns : A new sequence object\n Args    : A sequence object"},"line":575,"kind":12,"range":{"start":{"line":575,"character":0},"end":{"character":9999,"line":592}},"definition":"sub","detail":"($self,$seq)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"revcom_with_features","line":576},{"line":576,"name":"$seq","kind":13,"containerName":"revcom_with_features"},{"kind":13,"containerName":"revcom_with_features","name":"$self","line":577},{"line":577,"name":"throw","containerName":"revcom_with_features","kind":12},{"name":"$seq","containerName":"revcom_with_features","kind":13,"line":577},{"line":579,"name":"$seq","containerName":"revcom_with_features","kind":13},{"line":579,"name":"isa","kind":12,"containerName":"revcom_with_features"},{"line":580,"name":"$revcom","localvar":"my","containerName":"revcom_with_features","kind":13,"definition":"my"},{"line":580,"name":"$seq","kind":13,"containerName":"revcom_with_features"},{"line":580,"containerName":"revcom_with_features","kind":12,"name":"revcom"},{"line":583,"name":"$key","localvar":"my","kind":13,"containerName":"revcom_with_features","definition":"my"},{"name":"$seq","kind":13,"containerName":"revcom_with_features","line":583},{"name":"annotation","containerName":"revcom_with_features","kind":12,"line":583},{"line":583,"containerName":"revcom_with_features","kind":12,"name":"get_all_annotation_keys"},{"line":584,"localvar":"my","containerName":"revcom_with_features","kind":13,"name":"$value","definition":"my"},{"line":584,"kind":13,"containerName":"revcom_with_features","name":"$seq"},{"kind":12,"containerName":"revcom_with_features","name":"annotation","line":584},{"kind":12,"containerName":"revcom_with_features","name":"get_Annotations","line":584},{"line":584,"containerName":"revcom_with_features","kind":13,"name":"$key"},{"containerName":"revcom_with_features","kind":13,"name":"$revcom","line":585},{"name":"annotation","containerName":"revcom_with_features","kind":12,"line":585},{"line":585,"containerName":"revcom_with_features","kind":12,"name":"add_Annotation"},{"name":"$key","kind":13,"containerName":"revcom_with_features","line":585},{"line":585,"name":"$value","containerName":"revcom_with_features","kind":13},{"line":590,"name":"$revcom","kind":13,"containerName":"revcom_with_features"},{"line":590,"name":"add_SeqFeature","containerName":"revcom_with_features","kind":12},{"line":590,"containerName":"revcom_with_features","kind":13,"name":"$self"},{"name":"_feature_revcom","kind":12,"containerName":"revcom_with_features","line":590},{"containerName":"revcom_with_features","kind":13,"name":"$seq","line":590},{"line":590,"name":"length","containerName":"revcom_with_features","kind":12},{"name":"$seq","containerName":"revcom_with_features","kind":13,"line":590},{"name":"get_SeqFeatures","kind":12,"containerName":"revcom_with_features","line":590},{"line":591,"name":"$revcom","kind":13,"containerName":"revcom_with_features"}],"containerName":"main::","name":"revcom_with_features"},{"detail":"($self,$feat,$length)","definition":"sub","containerName":"main::","name":"_feature_revcom","children":[{"definition":"my","line":610,"localvar":"my","containerName":"_feature_revcom","kind":13,"name":"$self"},{"line":610,"kind":13,"containerName":"_feature_revcom","name":"$feat"},{"containerName":"_feature_revcom","kind":13,"name":"$length","line":610},{"line":611,"name":"$self","containerName":"_feature_revcom","kind":13},{"line":611,"containerName":"_feature_revcom","kind":12,"name":"throw"},{"line":611,"name":"$feat","kind":13,"containerName":"_feature_revcom"},{"kind":13,"containerName":"_feature_revcom","name":"$feat","line":613},{"line":613,"kind":12,"containerName":"_feature_revcom","name":"isa"},{"line":614,"name":"@adjsubfeat","containerName":"_feature_revcom","localvar":"my","kind":13,"definition":"my"},{"definition":"my","containerName":"_feature_revcom","localvar":"my","kind":13,"name":"$subfeat","line":615},{"line":615,"containerName":"_feature_revcom","kind":13,"name":"$feat"},{"line":615,"kind":12,"containerName":"_feature_revcom","name":"remove_SeqFeatures"},{"line":616,"containerName":"_feature_revcom","kind":13,"name":"@adjsubfeat"},{"kind":13,"containerName":"_feature_revcom","name":"$self","line":616},{"line":616,"containerName":"_feature_revcom","kind":12,"name":"_feature_revcom"},{"name":"$subfeat","containerName":"_feature_revcom","kind":13,"line":616},{"line":616,"name":"$length","kind":13,"containerName":"_feature_revcom"},{"line":618,"containerName":"_feature_revcom","localvar":"my","kind":13,"name":"@loc","definition":"my"},{"name":"$feat","containerName":"_feature_revcom","kind":13,"line":619},{"name":"location","containerName":"_feature_revcom","kind":12,"line":619},{"line":619,"name":"each_Location","kind":12,"containerName":"_feature_revcom"},{"definition":"my","line":620,"localvar":"my","containerName":"_feature_revcom","kind":13,"name":"$type"},{"name":"location_type","containerName":"_feature_revcom","kind":12,"line":620},{"localvar":"my","kind":13,"containerName":"_feature_revcom","name":"$strand","line":621,"definition":"my"},{"name":"strand","containerName":"_feature_revcom","kind":12,"line":622},{"line":622,"kind":13,"containerName":"_feature_revcom","name":"$strand"},{"line":623,"name":"strand","containerName":"_feature_revcom","kind":12},{"name":"$strand","kind":13,"containerName":"_feature_revcom","line":623},{"name":"$strand","kind":13,"containerName":"_feature_revcom","line":624},{"line":624,"name":"strand","containerName":"_feature_revcom","kind":12},{"line":625,"localvar":"my","kind":13,"containerName":"_feature_revcom","name":"$newend","definition":"my"},{"name":"$self","containerName":"_feature_revcom","kind":13,"line":625},{"containerName":"_feature_revcom","kind":12,"name":"_coord_revcom","line":625},{"line":625,"name":"start","kind":12,"containerName":"_feature_revcom"},{"line":626,"containerName":"_feature_revcom","kind":12,"name":"start_pos_type"},{"line":627,"name":"$length","kind":13,"containerName":"_feature_revcom"},{"line":628,"kind":13,"localvar":"my","containerName":"_feature_revcom","name":"$newstart","definition":"my"},{"kind":13,"containerName":"_feature_revcom","name":"$self","line":628},{"line":628,"kind":12,"containerName":"_feature_revcom","name":"_coord_revcom"},{"containerName":"_feature_revcom","kind":12,"name":"end","line":628},{"line":629,"name":"end_pos_type","kind":12,"containerName":"_feature_revcom"},{"line":630,"name":"$length","containerName":"_feature_revcom","kind":13},{"line":631,"name":"$type","containerName":"_feature_revcom","kind":13},{"containerName":"_feature_revcom","kind":13,"name":"@loc","line":632},{"line":632,"name":"new","kind":12,"containerName":"_feature_revcom"},{"containerName":"_feature_revcom","kind":13,"name":"$newstart","line":632},{"line":633,"containerName":"_feature_revcom","kind":13,"name":"$newend"},{"line":634,"name":"$strand","kind":13,"containerName":"_feature_revcom"},{"line":636,"name":"$type","kind":13,"containerName":"_feature_revcom"},{"line":638,"containerName":"_feature_revcom","kind":13,"name":"@loc"},{"containerName":"_feature_revcom","kind":12,"name":"new","line":638},{"line":638,"containerName":"_feature_revcom","kind":13,"name":"$newstart"},{"line":639,"name":"$newend","containerName":"_feature_revcom","kind":13},{"name":"$strand","containerName":"_feature_revcom","kind":13,"line":640},{"line":642,"containerName":"_feature_revcom","kind":13,"name":"$type"},{"definition":"my","localvar":"my","kind":13,"containerName":"_feature_revcom","name":"$newfeat","line":645},{"containerName":"_feature_revcom","kind":12,"name":"new","line":645},{"line":645,"containerName":"_feature_revcom","kind":13,"name":"$feat"},{"line":645,"kind":12,"containerName":"_feature_revcom","name":"primary_tag"},{"definition":"my","line":646,"name":"$key","kind":13,"localvar":"my","containerName":"_feature_revcom"},{"line":646,"name":"$feat","containerName":"_feature_revcom","kind":13},{"line":646,"kind":12,"containerName":"_feature_revcom","name":"annotation"},{"containerName":"_feature_revcom","kind":12,"name":"get_all_annotation_keys","line":646},{"name":"$value","localvar":"my","kind":13,"containerName":"_feature_revcom","line":647,"definition":"my"},{"line":647,"name":"$feat","kind":13,"containerName":"_feature_revcom"},{"containerName":"_feature_revcom","kind":12,"name":"annotation","line":647},{"line":647,"name":"get_Annotations","kind":12,"containerName":"_feature_revcom"},{"containerName":"_feature_revcom","kind":13,"name":"$key","line":647},{"name":"$newfeat","containerName":"_feature_revcom","kind":13,"line":648},{"line":648,"kind":12,"containerName":"_feature_revcom","name":"annotation"},{"line":648,"name":"add_Annotation","containerName":"_feature_revcom","kind":12},{"line":648,"kind":13,"containerName":"_feature_revcom","name":"$key"},{"line":648,"containerName":"_feature_revcom","kind":13,"name":"$value"},{"name":"$key","containerName":"_feature_revcom","localvar":"my","kind":13,"line":651,"definition":"my"},{"line":651,"containerName":"_feature_revcom","kind":13,"name":"$feat"},{"line":651,"containerName":"_feature_revcom","kind":12,"name":"get_all_tags"},{"name":"$newfeat","containerName":"_feature_revcom","kind":13,"line":652},{"kind":12,"containerName":"_feature_revcom","name":"add_tag_value","line":652},{"containerName":"_feature_revcom","kind":13,"name":"$key","line":652},{"line":652,"containerName":"_feature_revcom","kind":13,"name":"$feat"},{"line":652,"kind":12,"containerName":"_feature_revcom","name":"get_tag_values"},{"name":"$key","containerName":"_feature_revcom","kind":13,"line":652},{"kind":13,"containerName":"_feature_revcom","name":"@loc","line":654},{"kind":13,"containerName":"_feature_revcom","name":"$newfeat","line":655},{"line":655,"name":"location","containerName":"_feature_revcom","kind":12},{"line":655,"kind":13,"containerName":"_feature_revcom","name":"$loc"},{"definition":"my","line":657,"name":"$loc","localvar":"my","containerName":"_feature_revcom","kind":13},{"line":657,"kind":12,"containerName":"_feature_revcom","name":"new"},{"line":658,"containerName":"_feature_revcom","kind":13,"name":"$loc"},{"line":658,"kind":12,"containerName":"_feature_revcom","name":"add_sub_Location"},{"name":"@loc","kind":13,"containerName":"_feature_revcom","line":658},{"line":659,"kind":13,"containerName":"_feature_revcom","name":"$newfeat"},{"name":"location","kind":12,"containerName":"_feature_revcom","line":659},{"line":659,"name":"$loc","kind":13,"containerName":"_feature_revcom"},{"line":661,"name":"$newfeat","containerName":"_feature_revcom","kind":13},{"line":661,"kind":12,"containerName":"_feature_revcom","name":"add_SeqFeature"},{"name":"@adjsubfeat","containerName":"_feature_revcom","kind":13,"line":661},{"line":662,"name":"$newfeat","containerName":"_feature_revcom","kind":13}],"signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$length"}],"documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)\n\n\n\nsub trunc_with_features{\n    use Bio::Range;\n    my ($self,$seq,$start,$end) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $trunc=$seq->trunc($start, $end);\n    my $truncrange=Bio::Range->new(-start=>$start, -end=>$end, -strand=>0);\n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $trunc->annotation->add_Annotation($key, $value);\n\t}\n    } \n    \n    #move features\n    $trunc->add_SeqFeature(grep {$_=$self->_coord_adjust($_, 1-$start, $end+1-$start) if $_->overlaps($truncrange)} $seq->get_SeqFeatures);\n    return $trunc;\n}\n\n\n\n=head2 _coord_adjust\n\n  Title   : _coord_adjust\n  Usage   : my $newfeat=Bio::SeqUtils->_coord_adjust($feature, 100, $seq->length);\n  Function: Recursive subroutine to adjust the coordinates of a feature\n            and all its subfeatures. If a sequence length is specified, then\n            any adjusted features that have locations beyond the boundaries\n            of the sequence are converted to Bio::Location::Fuzzy objects.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the number of bases to add to the coordinates\n            (optional) the length of the parent sequence\n\n\n\nsub _coord_adjust {\n    my ($self, $feat, $add, $length)=@_;\n    $self->throw('Object [$feat] '. 'of class ['. ref($feat).\n                 '] should be a Bio::SeqFeatureI ')\n        unless $feat->isa('Bio::SeqFeatureI');\n    my @adjsubfeat;\n    for my $subfeat ($feat->remove_SeqFeatures) {\n        push @adjsubfeat, $self->_coord_adjust($subfeat, $add, $length);\n    }\n    my @loc;\n    for ($feat->location->each_Location) {\n        my @coords=($_->start, $_->end);\n        my $strand=$_->strand;\n\tmy $type=$_->location_type;\n        map s/(\\d+)/if ($add+$1<1) {'<1'} elsif (defined $length and $add+$1>$length) {\">$length\"} else {$add+$1}/ge, @coords;\n\tmy($newstart,$newend)=@coords;\n\tunless ($type eq 'IN-BETWEEN') {\n\t    push @loc, Bio::Location::Fuzzy->new(-start=>$newstart,\n\t\t\t\t\t\t -end=>$newend,\n\t\t\t\t\t\t -strand=>$strand,\n\t\t\t\t\t\t -location_type=>$type\n\t\t\t\t\t\t);\n\t} else {\n\t    push @loc, Bio::Location::Simple->new(-start=>$newstart,\n\t\t\t\t\t  -end=>$newend,\n\t\t\t\t\t  -strand=>$strand,\n\t\t\t\t\t  -location_type=>$type\n\t\t\t\t\t );\n\t}\n    }\n    my $newfeat=Bio::SeqFeature::Generic->new(-primary=>$feat->primary_tag);\n    foreach my $key ( $feat->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $feat->annotation->get_Annotations($key) ) {\n\t    $newfeat->annotation->add_Annotation($key, $value);\n\t}\n    } \n    foreach my $key ( $feat->get_all_tags() ) {\n\t    $newfeat->add_tag_value($key, $feat->get_tag_values($key));\n    } \n    if (@loc==1) {\n        $newfeat->location($loc[0])\n    } else {\n        my $loc=Bio::Location::Split->new;\n        $loc->add_sub_Location(@loc);\n        $newfeat->location($loc);\n    }\n    $newfeat->add_SeqFeature($_) for @adjsubfeat;\n    return $newfeat;\n}\n\n\n=head2 revcom_with_features\n\n Title   : revcom_with_features\n Usage   : $revcom=Bio::SeqUtils->revcom_with_features($seq);\n Function: Like Bio::Seq::revcom, but keeps features (adjusting coordinates\n           as appropriate.\n Returns : A new sequence object\n Args    : A sequence object\n\n\n\nsub revcom_with_features{\n    my ($self,$seq) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $revcom=$seq->revcom;\n    \n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $revcom->annotation->add_Annotation($key, $value);\n\t}\n    } \n\n    #move features\n    $revcom->add_SeqFeature(map {$self->_feature_revcom($_, $seq->length)} $seq->get_SeqFeatures);\n    return $revcom;\n}\n\n=head2 _feature_revcom\n\n  Title   : _feature_revcom\n  Usage   : my $newfeat=Bio::SeqUtils->_feature_revcom($feature, $seq->length);\n  Function: Recursive subroutine to reverse complement a feature and\n            all its subfeatures. The length of the parent sequence must be\n            specified.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the length of the parent sequence","label":"_feature_revcom($self,$feat,$length)"},"kind":12,"range":{"end":{"character":9999,"line":663},"start":{"line":609,"character":0}},"line":609},{"name":"Bio","containerName":"Location::Fuzzy","kind":12,"line":632},{"name":"Bio","kind":12,"containerName":"Location::Simple","line":638},{"line":645,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"line":657,"containerName":"Location::Split","kind":12,"name":"Bio"},{"signature":{"parameters":[{"label":"$self"},{"label":"$coord"},{"label":"$type"},{"label":"$length"}],"documentation":"","label":"_coord_revcom($self,$coord,$type,$length)"},"line":665,"kind":12,"range":{"end":{"character":9999,"line":675},"start":{"character":0,"line":665}},"definition":"sub","detail":"($self,$coord,$type,$length)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_coord_revcom","name":"$self","line":666},{"containerName":"_coord_revcom","kind":13,"name":"$coord","line":666},{"line":666,"name":"$type","kind":13,"containerName":"_coord_revcom"},{"line":666,"kind":13,"containerName":"_coord_revcom","name":"$length"},{"line":667,"name":"$type","containerName":"_coord_revcom","kind":13},{"line":667,"name":"$type","containerName":"_coord_revcom","kind":13},{"containerName":"_coord_revcom","kind":13,"name":"$coord","line":668},{"line":670,"name":"$coord","kind":13,"containerName":"_coord_revcom"},{"line":671,"name":"$coord","containerName":"_coord_revcom","kind":13},{"line":671,"name":"$coord","containerName":"_coord_revcom","kind":13},{"containerName":"_coord_revcom","kind":13,"name":"$type","line":671},{"containerName":"_coord_revcom","kind":13,"name":"$coord","line":672},{"name":"$coord","kind":13,"containerName":"_coord_revcom","line":672},{"line":672,"kind":13,"containerName":"_coord_revcom","name":"$type"},{"name":"$coord","kind":13,"containerName":"_coord_revcom","line":674}],"name":"_coord_revcom","containerName":"main::"},{"detail":"($self,$seq,$sim,$rate)","definition":"sub","containerName":"main::","name":"evolve","children":[{"line":703,"containerName":"evolve","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$seq","containerName":"evolve","kind":13,"line":703},{"line":703,"kind":13,"containerName":"evolve","name":"$sim"},{"containerName":"evolve","kind":13,"name":"$rate","line":703},{"name":"$rate","containerName":"evolve","kind":13,"line":704},{"line":706,"kind":13,"containerName":"evolve","name":"$self"},{"line":706,"containerName":"evolve","kind":12,"name":"throw"},{"containerName":"evolve","kind":13,"name":"$seq","line":706},{"line":708,"name":"$seq","kind":13,"containerName":"evolve"},{"name":"isa","containerName":"evolve","kind":12,"line":708},{"line":710,"name":"$self","containerName":"evolve","kind":13},{"kind":12,"containerName":"evolve","name":"throw","line":710},{"line":711,"kind":13,"containerName":"evolve","name":"$sim"},{"line":711,"name":"$sim","kind":13,"containerName":"evolve"},{"name":"$self","kind":13,"containerName":"evolve","line":713},{"name":"warn","containerName":"evolve","kind":12,"line":713},{"kind":13,"containerName":"evolve","name":"$sim","line":715},{"line":717,"containerName":"evolve","kind":13,"name":"$self"},{"line":717,"kind":12,"containerName":"evolve","name":"throw"},{"line":718,"kind":13,"containerName":"evolve","name":"$seq"},{"name":"alphabet","containerName":"evolve","kind":12,"line":718},{"name":"%changes","localvar":"my","kind":13,"containerName":"evolve","line":722,"definition":"my"},{"name":"$changes","containerName":"evolve","kind":13,"line":723},{"name":"$changes","kind":13,"containerName":"evolve","line":724},{"line":725,"name":"$changes","kind":13,"containerName":"evolve"},{"kind":13,"containerName":"evolve","name":"$changes","line":726},{"definition":"my","line":732,"name":"$bin_size","kind":13,"localvar":"my","containerName":"evolve"},{"line":732,"kind":13,"containerName":"evolve","name":"$rate"},{"definition":"my","containerName":"evolve","localvar":"my","kind":13,"name":"$transition","line":733},{"line":733,"name":"$bin_size","containerName":"evolve","kind":13},{"name":"$first_transversion","kind":13,"localvar":"my","containerName":"evolve","line":734,"definition":"my"},{"name":"$transition","containerName":"evolve","kind":13,"line":734},{"name":"$bin_size","containerName":"evolve","kind":13,"line":734},{"definition":"my","name":"$string","kind":13,"localvar":"my","containerName":"evolve","line":737},{"name":"$seq","containerName":"evolve","kind":13,"line":737},{"line":737,"name":"seq","containerName":"evolve","kind":12},{"line":738,"containerName":"evolve","kind":13,"name":"$string"},{"definition":"my","line":740,"localvar":"my","containerName":"evolve","kind":13,"name":"$oristring"},{"line":740,"name":"$string","kind":13,"containerName":"evolve"},{"name":"$length","localvar":"my","containerName":"evolve","kind":13,"line":741,"definition":"my"},{"line":741,"name":"$seq","kind":13,"containerName":"evolve"},{"kind":12,"containerName":"evolve","name":"length","line":741},{"line":745,"kind":13,"localvar":"my","containerName":"evolve","name":"$loc","definition":"my"},{"line":745,"name":"$length","containerName":"evolve","kind":13},{"name":"$oldnuc","localvar":"my","kind":13,"containerName":"evolve","line":749,"definition":"my"},{"line":749,"containerName":"evolve","kind":13,"name":"$string"},{"name":"$loc","kind":13,"containerName":"evolve","line":749},{"definition":"my","line":750,"name":"$newnuc","kind":13,"localvar":"my","containerName":"evolve"},{"definition":"my","line":753,"localvar":"my","containerName":"evolve","kind":13,"name":"$choose"},{"name":"$choose","kind":13,"containerName":"evolve","line":754},{"line":754,"kind":13,"containerName":"evolve","name":"$transition"},{"name":"$newnuc","kind":13,"containerName":"evolve","line":755},{"name":"$changes","containerName":"evolve","kind":13,"line":755},{"kind":13,"containerName":"evolve","name":"$oldnuc","line":755},{"line":757,"kind":13,"containerName":"evolve","name":"$choose"},{"line":757,"name":"$first_transversion","containerName":"evolve","kind":13},{"name":"$newnuc","kind":13,"containerName":"evolve","line":758},{"line":758,"containerName":"evolve","kind":13,"name":"$changes"},{"line":758,"kind":13,"containerName":"evolve","name":"$oldnuc"},{"name":"$newnuc","containerName":"evolve","kind":13,"line":760},{"line":760,"name":"$changes","containerName":"evolve","kind":13},{"line":760,"name":"$oldnuc","kind":13,"containerName":"evolve"},{"line":764,"containerName":"evolve","kind":13,"name":"$string"},{"name":"$loc","containerName":"evolve","kind":13,"line":764},{"kind":13,"containerName":"evolve","name":"$newnuc","line":764},{"name":"$self","kind":13,"containerName":"evolve","line":766},{"kind":12,"containerName":"evolve","name":"debug","line":766},{"line":769,"kind":13,"containerName":"evolve","name":"$self"},{"line":769,"containerName":"evolve","kind":12,"name":"_get_similarity"},{"line":769,"name":"$oristring","kind":13,"containerName":"evolve"},{"line":769,"name":"$string","containerName":"evolve","kind":13},{"name":"$sim","kind":13,"containerName":"evolve","line":769},{"containerName":"evolve","kind":13,"name":"$seq","line":773},{"kind":12,"containerName":"evolve","name":"id","line":773},{"containerName":"evolve","kind":13,"name":"$seq","line":774},{"line":774,"containerName":"evolve","kind":12,"name":"description"},{"name":"$string","kind":13,"containerName":"evolve","line":776}],"signature":{"label":"evolve($self,$seq,$sim,$rate)","documentation":"1;\n# $Id: SeqUtils.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqUtils\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqUtils - Additional methods for PrimarySeq objects\n\n=head1 SYNOPSIS\n\n    use Bio::SeqUtils;\n    # get a Bio::PrimarySeqI compliant object, $seq, somehow\n    $util = Bio::SeqUtils->new();\n    $polypeptide_3char = $util->seq3($seq);\n    # or\n    $polypeptide_3char = Bio::SeqUtils->seq3($seq);\n\n    # set the sequence string (stored in one char code in the object)\n    Bio::SeqUtils->seq3($seq, $polypeptide_3char);\n\n    # translate a sequence in all six frames\n    @seqs = Bio::SeqUtils->translate_6frames($seq);\n\n    # inplace editing of the sequence\n    Bio::SeqUtils->mutate($seq,\n                          Bio::LiveSeq::Mutation->new(-seq => 'c',\n                                                      -pos => 3\n                                                     ));\n    # mutate a sequence to desired similarity%\n    $newseq = Bio::SeqUtils-> evolve\n        ($seq, $similarity, $transition_transversion_rate);\n\n\n    # concatenate two or more sequences with annotations and features,\n    # the first sequence will be modified\n    Bio::SeqUtils->cat(@seqs);\n\n    # truncate a sequence, retaining features and adjusting their\n    # coordinates if necessary\n    my $truncseq = Bio::SeqUtils->trunc_with_features($seq, 100, 200);\n\n    # reverse complement a sequence and its features\n    my $revcomseq = Bio::SeqUtils->revcom_with_features($seq);\n\n=head1 DESCRIPTION\n\nThis class is a holder of methods that work on Bio::PrimarySeqI-\ncompliant sequence objects, e.g. Bio::PrimarySeq and\nBio::Seq. These methods are not part of the Bio::PrimarySeqI\ninterface and should in general not be essential to the primary function\nof sequence objects. If you are thinking of adding essential\nfunctions, it might be better to create your own sequence class.\nSee L<Bio::PrimarySeqI>, L<Bio::PrimarySeq>, and L<Bio::Seq> for more.\n\nThe methods take as their first argument a sequence object. It is\npossible to use methods without first creating a SeqUtils object,\ni.e. use it as an anonymous hash.\n\nThe first two methods, seq3() and seq3in(), give out or read in protein\nsequences coded in three letter IUPAC amino acid codes.\n\nThe next two methods, translate_3frames() and translate_6frames(), wrap\naround the standard translate method to give back an array of three\nforward or all six frame translations.\n\nThe mutate() method mutates the sequence string with a mutation\ndescription object.\n\nThe cat() method concatenates two or more sequences. The first sequence \nis modified by addition of the remaining sequences. All annotations and \nsequence features will be transferred.\n\nThe revcom_with_features() and trunc_with_features() methods are similar\nto the revcom() and trunc() methods from Bio::Seq, but also adjust any\nfeatures associated with the sequence as appropriate.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nRoy R. Chaudhuri - roy.chaudhuri at gmail.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqUtils;\nuse vars qw(%ONECODE %THREECODE);\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::Root);\n# new inherited from RootI\n\nBEGIN {\n    # Note : Ambiguity code 'J' = I/L (used for ambiguities in mass-spec data)\n    %ONECODE =\n    ('Ala' => 'A', 'Asx' => 'B', 'Cys' => 'C', 'Asp' => 'D',\n     'Glu' => 'E', 'Phe' => 'F', 'Gly' => 'G', 'His' => 'H',\n     'Ile' => 'I', 'Lys' => 'K', 'Leu' => 'L', 'Met' => 'M',\n     'Asn' => 'N', 'Pro' => 'P', 'Gln' => 'Q', 'Arg' => 'R',\n     'Ser' => 'S', 'Thr' => 'T', 'Val' => 'V', 'Trp' => 'W',\n     'Xaa' => 'X', 'Tyr' => 'Y', 'Glx' => 'Z', 'Ter' => '*',\n     'Sec' => 'U', 'Pyl' => 'O', 'Xle' => 'J'\n     );\n\n    %THREECODE =\n    ('A' => 'Ala', 'B' => 'Asx', 'C' => 'Cys', 'D' => 'Asp',\n     'E' => 'Glu', 'F' => 'Phe', 'G' => 'Gly', 'H' => 'His',\n     'I' => 'Ile', 'K' => 'Lys', 'L' => 'Leu', 'M' => 'Met',\n     'N' => 'Asn', 'P' => 'Pro', 'Q' => 'Gln', 'R' => 'Arg',\n     'S' => 'Ser', 'T' => 'Thr', 'V' => 'Val', 'W' => 'Trp',\n     'Y' => 'Tyr', 'Z' => 'Glx', 'X' => 'Xaa', '*' => 'Ter',\n     'U' => 'Sec', 'O' => 'Pyl', 'J' => 'Xle'\n     );\n}\n\n=head2 seq3\n\n Title   : seq3\n Usage   : $string = Bio::SeqUtils->seq3($seq)\n Function: Read only method that returns the amino acid sequence as a\n           string of three letter codes. alphabet has to be\n           'protein'. Output follows the IUPAC standard plus 'Ter' for\n           terminator. Any unknown character, including the default\n           unknown character 'X', is changed into 'Xaa'. A noncoded\n           aminoacid selenocystein is recognized (Sec, U).\n\n Returns : A scalar\n Args    : character used for stop in the protein sequence optional,\n           defaults to '*' string used to separate the output amino\n           acid codes, optional, defaults to ''\n\n\nsub seq3 {\n   my ($self, $seq, $stop, $sep ) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n       $self->throw('Not a Bio::PrimarySeqI object but [$self]');\n   $seq->alphabet eq 'protein' ||\n       $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n       length $stop != 1 and $self->throw('One character stop needed, not [$stop]');\n       $THREECODE{$stop} = \"Ter\";\n   }\n   $sep ||= '';\n\n   my $aa3s;\n   foreach my $aa  (split //, uc $seq->seq) {\n       $THREECODE{$aa} and $aa3s .= $THREECODE{$aa}. $sep, next;\n       $aa3s .= 'Xaa'. $sep;\n   }\n   $sep and substr($aa3s, -(length $sep), length $sep) = '' ;\n   return $aa3s;\n}\n\n=head2 seq3in\n\n Title   : seq3in\n Usage   : $seq = Bio::SeqUtils->seq3in($seq, 'MetGlyTer')\n Function: Method for changing of the sequence of a\n           Bio::PrimarySeqI sequence object. The three letter amino\n           acid input string is converted into one letter code.  Any\n           unknown character triplet, including the default 'Xaa', is\n           converted into 'X'.\n\n Returns : Bio::PrimarySeq object\n Args    : sequence string\n           optional character to be used for stop in the protein sequence,\n              defaults to '*'\n           optional character to be used for unknown in the protein sequence,\n              defaults to 'X'\n\n\nsub seq3in {\n   my ($self, $seq, $string, $stop, $unknown) = @_;\n\n   $seq->isa('Bio::PrimarySeqI') ||\n\t  $self->throw(\"Not a Bio::PrimarySeqI object but [$self]\");\n   $seq->alphabet eq 'protein' ||\n\t  $self->throw('Not a protein sequence');\n\n   if (defined $stop) {\n\t\tlength $stop != 1 and $self->throw(\"One character stop needed, not [$stop]\");\n\t\t$ONECODE{'Ter'} = $stop;\n   }\n   if (defined $unknown) {\n\t\tlength $unknown != 1 and $self->throw(\"One character stop needed, not [$unknown]\");\n\t\t$ONECODE{'Xaa'} = $unknown;\n   }\n\n   my ($aas, $aa3);\n   my $length = (length $string) - 2;\n   for (my $i = 0 ; $i < $length ; $i += 3)  {\n\t\t$aa3 = substr($string, $i, 3);\n\t\t$aa3 = ucfirst(lc($aa3)); \n\t\t$ONECODE{$aa3} and $aas .= $ONECODE{$aa3}, next;\n\t\t$aas .= $ONECODE{'Xaa'};\n   }\n   $seq->seq($aas);\n   return $seq;\n}\n\n=head2 translate_3frames\n\n Title   : translate_3frames\n Usage   : @prots = Bio::SeqUtils->translate_3frames($seq)\n Function: Translate a nucleotide sequence in three forward frames.\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_3frames {\n    my ($self, $seq, @args ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).  ']  can not be translated.')\n\tunless $seq->can('translate');\n\n    my ($stop, $unknown, $frame, $tableid, $fullCDS, $throw) = @args;\n    my @seqs;\n    my $f = 0;\n    while ($f != 3) {\n        my $translation = $seq->translate($stop, $unknown,$f,$tableid, $fullCDS, $throw );\n\t$translation->id($seq->id. \"-\". $f. \"F\");\n\tpush @seqs, $translation;\n\t$f++;\n    }\n\n    return @seqs;\n}\n\n=head2 translate_6frames\n\n Title   : translate_6frames\n Usage   : @prots = Bio::SeqUtils->translate_6frames($seq)\n Function: translate a nucleotide sequence in all six frames\n           The IDs of the sequences are appended with '-0F', '-1F', '-2F',\n           '-0R', '-1R', '-2R'.\n Returns : An array of seq objects\n Args    : sequence object\n           same arguments as to Bio::PrimarySeqI::translate\n\n\nsub translate_6frames {\n    my ($self, $seq, @args ) = @_;\n\n    my @seqs = $self->translate_3frames($seq, @args);\n    my @seqs2 = $self->translate_3frames($seq->revcom, @args);\n    foreach my $seq2 (@seqs2) {\n\tmy ($tmp) = $seq2->id;\n\t$tmp =~ s/F$/R/g;\n\t$seq2->id($tmp);\n    }\n    return @seqs, @seqs2;\n}\n\n\n=head2 valid_aa\n\n Title   : valid_aa\n Usage   : my @aa = $table->valid_aa\n Function: Retrieves a list of the valid amino acid codes.\n           The list is ordered so that first 21 codes are for unique \n           amino acids. The rest are ['B', 'Z', 'X', '*'].\n Returns : array of all the valid amino acid codes\n Args    : [optional] $code => [0 -> return list of 1 letter aa codes,\n\t\t\t\t1 -> return list of 3 letter aa codes,\n\t\t\t\t2 -> return associative array of both ]\n\n\nsub valid_aa{\n   my ($self,$code) = @_;\n\n   if( ! $code ) { \n       my @codes;\n       foreach my $c ( sort values %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /[BZX\\*]/ );\n       }\n       push @codes, qw(B Z X *); # so they are in correct order ?\n       return @codes;\n  }\n   elsif( $code == 1 ) { \n       my @codes;\n       foreach my $c ( sort keys %ONECODE ) {\n\t   push @codes, $c unless ( $c =~ /(Asx|Glx|Xaa|Ter)/ );\n       }\n       push @codes, ('Asx', 'Glx', 'Xaa', 'Ter' );\n       return @codes;\n   }\n   elsif( $code == 2 ) { \n       my %codes = %ONECODE;\n       foreach my $c ( keys %ONECODE ) {\n\t   my $aa = $ONECODE{$c};\n\t   $codes{$aa} = $c;\n       }\n       return %codes;\n   } else {\n       $self->warn(\"unrecognized code in \".ref($self).\" method valid_aa()\");\n       return ();\n   }\n}\n\n=head2 mutate\n\n Title   : mutate\n Usage   : Bio::SeqUtils->mutate($seq,$mutation1, $mutation2);\n Function: Inplace editing of the sequence.\n\n           The second argument can be a Bio::LiveSeq::Mutation object\n           or an array of them. The mutations are applied sequentially\n           checking only that their position is within the current\n           sequence.  Insertions are inserted before the given\n           position.\n\n Returns : boolean\n Args    : sequence object\n           mutation, a Bio::LiveSeq::Mutation object, or an array of them\n\nSee L<Bio::LiveSeq::Mutation>.\n\n\nsub mutate {\n    my ($self, $seq, @mutations ) = @_;\n\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n\tunless $seq->isa('Bio::PrimarySeqI');\n    $self->throw('Object [$mutations[0]] '. 'of class ['. ref($mutations[0]).\n                 '] should be a Bio::LiveSeq::Mutation')\n\tunless $mutations[0]->isa('Bio::LiveSeq::Mutation');\n\n    foreach my $mutation (@mutations) {\n        $self->throw('Attempting to mutate sequence beyond its length')\n            unless $mutation->pos - 1 <= $seq->length;\n\n        my $string = $seq->seq;\n        substr $string, $mutation->pos - 1, $mutation->len, $mutation->seq;\n        $seq->seq($string);\n    }\n    1;\n}\n\n\n=head2 cat\n\n  Title   : cat\n  Usage   : my $catseq = Bio::SeqUtils->cat(@seqs)\n  Function: Concatenates an array of Bio::Seq objects, using the first sequence\n            as a target. Annotations and sequence features are copied over \n            from any additional objects. Adjusts the coordinates of copied \n            features.\n  Returns : a boolean\n  Args    : array of sequence objects\n\nNote that annotations have no sequence locations. If you concatenate\nsequences with the same annotations they will all be added.\n\n\nsub cat {\n    my ($self, $seq, @seqs) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::PrimarySeqI ')\n        unless $seq->isa('Bio::PrimarySeqI');\n    \n\n    for my $catseq (@seqs) {\n        $self->throw('Object [$catseq] '. 'of class ['. ref($catseq).\n                     '] should be a Bio::PrimarySeqI ')\n            unless $catseq->isa('Bio::PrimarySeqI');\n\n        $self->throw('Trying to concatenate sequences with different alphabets: '.\n                     $seq->display_id. '('. $seq->alphabet. ') and '. $catseq->display_id.\n                     '('. $catseq->alphabet. ')')\n            unless $catseq->alphabet eq $seq->alphabet;\n\n\n        my $length=$seq->length;\n        $seq->seq($seq->seq.$catseq->seq);\n\n        # move annotations\n        if ($seq->isa(\"Bio::AnnotatableI\") and $catseq->isa(\"Bio::AnnotatableI\")) {\n            foreach my $key ( $catseq->annotation->get_all_annotation_keys() ) {\n\n                foreach my $value ( $catseq->annotation->get_Annotations($key) ) {\n                    $seq->annotation->add_Annotation($key, $value);\n                }\n            } \n        }\n        \n        # move SeqFeatures\n        if ( $seq->isa('Bio::SeqI') and $catseq->isa('Bio::SeqI')) {\n            for my $feat ($catseq->get_SeqFeatures) {\n                $seq->add_SeqFeature($self->_coord_adjust($feat, $length));\n            }\n        }\n\n    }\n    1;\n}\n\n\n=head2 trunc_with_features\n\n Title   : trunc_with_features\n Usage   : $trunc=Bio::SeqUtils->trunc_with_features($seq, $start, $end);\n Function: Like Bio::Seq::trunc, but keeps features (adjusting coordinates\n           where necessary. Features that partially overlap the region have\n           their location changed to a Bio::Location::Fuzzy.\n Returns : A new sequence object\n Args    : A sequence object, start coordinate, end coordinate (inclusive)\n\n\n\nsub trunc_with_features{\n    use Bio::Range;\n    my ($self,$seq,$start,$end) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $trunc=$seq->trunc($start, $end);\n    my $truncrange=Bio::Range->new(-start=>$start, -end=>$end, -strand=>0);\n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $trunc->annotation->add_Annotation($key, $value);\n\t}\n    } \n    \n    #move features\n    $trunc->add_SeqFeature(grep {$_=$self->_coord_adjust($_, 1-$start, $end+1-$start) if $_->overlaps($truncrange)} $seq->get_SeqFeatures);\n    return $trunc;\n}\n\n\n\n=head2 _coord_adjust\n\n  Title   : _coord_adjust\n  Usage   : my $newfeat=Bio::SeqUtils->_coord_adjust($feature, 100, $seq->length);\n  Function: Recursive subroutine to adjust the coordinates of a feature\n            and all its subfeatures. If a sequence length is specified, then\n            any adjusted features that have locations beyond the boundaries\n            of the sequence are converted to Bio::Location::Fuzzy objects.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the number of bases to add to the coordinates\n            (optional) the length of the parent sequence\n\n\n\nsub _coord_adjust {\n    my ($self, $feat, $add, $length)=@_;\n    $self->throw('Object [$feat] '. 'of class ['. ref($feat).\n                 '] should be a Bio::SeqFeatureI ')\n        unless $feat->isa('Bio::SeqFeatureI');\n    my @adjsubfeat;\n    for my $subfeat ($feat->remove_SeqFeatures) {\n        push @adjsubfeat, $self->_coord_adjust($subfeat, $add, $length);\n    }\n    my @loc;\n    for ($feat->location->each_Location) {\n        my @coords=($_->start, $_->end);\n        my $strand=$_->strand;\n\tmy $type=$_->location_type;\n        map s/(\\d+)/if ($add+$1<1) {'<1'} elsif (defined $length and $add+$1>$length) {\">$length\"} else {$add+$1}/ge, @coords;\n\tmy($newstart,$newend)=@coords;\n\tunless ($type eq 'IN-BETWEEN') {\n\t    push @loc, Bio::Location::Fuzzy->new(-start=>$newstart,\n\t\t\t\t\t\t -end=>$newend,\n\t\t\t\t\t\t -strand=>$strand,\n\t\t\t\t\t\t -location_type=>$type\n\t\t\t\t\t\t);\n\t} else {\n\t    push @loc, Bio::Location::Simple->new(-start=>$newstart,\n\t\t\t\t\t  -end=>$newend,\n\t\t\t\t\t  -strand=>$strand,\n\t\t\t\t\t  -location_type=>$type\n\t\t\t\t\t );\n\t}\n    }\n    my $newfeat=Bio::SeqFeature::Generic->new(-primary=>$feat->primary_tag);\n    foreach my $key ( $feat->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $feat->annotation->get_Annotations($key) ) {\n\t    $newfeat->annotation->add_Annotation($key, $value);\n\t}\n    } \n    foreach my $key ( $feat->get_all_tags() ) {\n\t    $newfeat->add_tag_value($key, $feat->get_tag_values($key));\n    } \n    if (@loc==1) {\n        $newfeat->location($loc[0])\n    } else {\n        my $loc=Bio::Location::Split->new;\n        $loc->add_sub_Location(@loc);\n        $newfeat->location($loc);\n    }\n    $newfeat->add_SeqFeature($_) for @adjsubfeat;\n    return $newfeat;\n}\n\n\n=head2 revcom_with_features\n\n Title   : revcom_with_features\n Usage   : $revcom=Bio::SeqUtils->revcom_with_features($seq);\n Function: Like Bio::Seq::revcom, but keeps features (adjusting coordinates\n           as appropriate.\n Returns : A new sequence object\n Args    : A sequence object\n\n\n\nsub revcom_with_features{\n    my ($self,$seq) = @_;\n    $self->throw('Object [$seq] '. 'of class ['. ref($seq).\n                 '] should be a Bio::SeqI ')\n    unless $seq->isa('Bio::SeqI');\n    my $revcom=$seq->revcom;\n    \n    #move annotations\n    foreach my $key ( $seq->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $seq->annotation->get_Annotations($key) ) {\n\t    $revcom->annotation->add_Annotation($key, $value);\n\t}\n    } \n\n    #move features\n    $revcom->add_SeqFeature(map {$self->_feature_revcom($_, $seq->length)} $seq->get_SeqFeatures);\n    return $revcom;\n}\n\n=head2 _feature_revcom\n\n  Title   : _feature_revcom\n  Usage   : my $newfeat=Bio::SeqUtils->_feature_revcom($feature, $seq->length);\n  Function: Recursive subroutine to reverse complement a feature and\n            all its subfeatures. The length of the parent sequence must be\n            specified.\n\n  Returns : A Bio::SeqFeatureI compliant object.\n  Args    : A Bio::SeqFeatureI compliant object,\n            the length of the parent sequence\n\n\n\nsub _feature_revcom {\n    my ($self, $feat, $length)=@_;\n    $self->throw('Object [$feat] '. 'of class ['. ref($feat).\n                 '] should be a Bio::SeqFeatureI ')\n        unless $feat->isa('Bio::SeqFeatureI');\n    my @adjsubfeat;\n    for my $subfeat ($feat->remove_SeqFeatures) {\n        push @adjsubfeat, $self->_feature_revcom($subfeat, $length);\n    }\n    my @loc;\n    for ($feat->location->each_Location) {\n\tmy $type=$_->location_type;\n        my $strand;\n\tif ($_->strand==-1) {$strand=1}\n\telsif ($_->strand==1) {$strand=-1}\n\telse {$strand=$_->strand}\n\tmy $newend=$self->_coord_revcom($_->start,\n\t\t\t\t\t$_->start_pos_type,\n\t\t\t\t\t$length);\n\tmy $newstart=$self->_coord_revcom($_->end,\n\t\t\t\t\t  $_->end_pos_type,\n\t\t\t\t\t  $length);\n\tunless ($type eq 'IN-BETWEEN') {\n\t    push @loc, Bio::Location::Fuzzy->new(-start=>$newstart,\n\t\t\t\t\t\t -end=>$newend,\n\t\t\t\t\t\t -strand=>$strand,\n\t\t\t\t\t\t -location_type=>$type\n\t\t\t\t\t\t);\n\t} else {\n\t    push @loc, Bio::Location::Simple->new(-start=>$newstart,\n\t\t\t\t\t\t  -end=>$newend,\n\t\t\t\t\t\t  -strand=>$strand,\n\t\t\t\t\t\t  -location_type=>$type\n\t\t\t\t\t\t );\n\t}\n    }\n    my $newfeat=Bio::SeqFeature::Generic->new(-primary=>$feat->primary_tag);\n    foreach my $key ( $feat->annotation->get_all_annotation_keys() ) {\n\tforeach my $value ( $feat->annotation->get_Annotations($key) ) {\n\t    $newfeat->annotation->add_Annotation($key, $value);\n\t}\n    } \n    foreach my $key ( $feat->get_all_tags() ) {\n\t    $newfeat->add_tag_value($key, $feat->get_tag_values($key));\n    } \n    if (@loc==1) {\n        $newfeat->location($loc[0])\n    } else {\n        my $loc=Bio::Location::Split->new;\n        $loc->add_sub_Location(@loc);\n        $newfeat->location($loc);\n    }\n    $newfeat->add_SeqFeature($_) for @adjsubfeat;\n    return $newfeat;\n}\n\nsub _coord_revcom {\n    my ($self, $coord, $type, $length)=@_;\n    if ($type eq 'BETWEEN' or $type eq 'WITHIN') {\n\t$coord=~s/(\\d+)(.*)(\\d+)/$length+1-$3.$2.$length+1-$1/ge;\n    } else {\n\t$coord=~s/(\\d+)/$length+1-$1/ge;\n\t$coord='>'.$coord if $type eq 'BEFORE';\n\t$coord='<'.$coord if $type eq 'AFTER';\n    }\n    return $coord;\n}\n\n=head2 evolve\n\n  Title   : evolve\n  Usage   : my $newseq = Bio::SeqUtils->\n                evolve($seq, $similarity, $transition_transversion_rate);\n  Function: Mutates the sequence by point mutations until the similarity of\n            the new sequence has decreased to the required level. \n            Transition/transversion rate is adjustable.\n  Returns : A new Bio::PrimarySeq object\n  Args    : sequence object\n            percentage similarity (e.g. 80)\n            tr/tv rate, optional, defaults to 1 (= 1:1)\n\nSet the verbosity of the Bio::SeqUtils object to positive integer to\nsee the mutations as they happen.\n\nThis method works only on nucleotide sequences. It prints a warning if\nyou set the target similarity to be less than 25%.\n\nTransition/transversion ratio is an observed attribute of an sequence\ncomparison. We are dealing here with the transition/transversion rate\nthat we set for our model of sequence evolution.","parameters":[{"label":"$self"},{"label":"$seq"},{"label":"$sim"},{"label":"$rate"}]},"kind":12,"range":{"start":{"line":702,"character":0},"end":{"character":9999,"line":777}},"line":702},{"line":773,"name":"new","kind":12},{"kind":12,"containerName":"PrimarySeq","name":"Bio","line":773},{"children":[{"kind":13,"localvar":"my","containerName":"_get_similarity","name":"$self","line":781,"definition":"my"},{"line":781,"name":"$oriseq","kind":13,"containerName":"_get_similarity"},{"name":"$seq","containerName":"_get_similarity","kind":13,"line":781},{"definition":"my","localvar":"my","containerName":"_get_similarity","kind":13,"name":"$len","line":783},{"line":783,"name":"$oriseq","kind":13,"containerName":"_get_similarity"},{"definition":"my","line":784,"name":"$c","localvar":"my","kind":13,"containerName":"_get_similarity"},{"line":786,"localvar":"my","containerName":"_get_similarity","kind":13,"name":"$i","definition":"my"},{"containerName":"_get_similarity","kind":13,"name":"$i","line":786},{"containerName":"_get_similarity","kind":13,"name":"$len","line":786},{"name":"$i","kind":13,"containerName":"_get_similarity","line":786},{"name":"$c","containerName":"_get_similarity","kind":13,"line":787},{"line":787,"name":"$oriseq","containerName":"_get_similarity","kind":13},{"kind":13,"containerName":"_get_similarity","name":"$i","line":787},{"line":787,"name":"$seq","kind":13,"containerName":"_get_similarity"},{"line":787,"kind":13,"containerName":"_get_similarity","name":"$i"},{"name":"$c","kind":13,"containerName":"_get_similarity","line":789},{"containerName":"_get_similarity","kind":13,"name":"$len","line":789}],"name":"_get_similarity","containerName":"main::","definition":"sub","detail":"($self,$oriseq,$seq)","line":780,"kind":12,"range":{"end":{"line":790,"character":9999},"start":{"line":780,"character":0}},"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$oriseq"},{"label":"$seq"}],"label":"_get_similarity($self,$oriseq,$seq)"}}]}