{"version":5,"vars":[{"line":70,"kind":2,"containerName":"","name":"vars"},{"line":76,"name":"@ISA","containerName":null,"kind":13},{"name":"SeqFactory","containerName":"strict::Bio::SeqIO::Bio::Seq","kind":2,"line":76},{"line":78,"kind":12,"range":{"end":{"line":86,"character":9999},"start":{"character":0,"line":78}},"definition":"sub","children":[{"line":81,"name":"$READ_AVAIL","kind":13,"containerName":"BEGIN"},{"line":83,"kind":13,"containerName":"BEGIN","name":"@ISA"},{"line":84,"name":"$READ_AVAIL","containerName":"BEGIN","kind":13}],"name":"BEGIN","containerName":"main::"},{"line":80,"containerName":"SeqIO::staden::read","kind":12,"name":"Bio"},{"kind":12,"range":{"end":{"character":9999,"line":104},"start":{"line":88,"character":0}},"line":88,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"containerName":"main::","name":"_initialize","children":[{"definition":"my","line":89,"localvar":"my","kind":13,"containerName":"_initialize","name":"$self"},{"name":"@args","kind":13,"containerName":"_initialize","line":89},{"line":90,"containerName":"_initialize","kind":13,"name":"$self"},{"line":90,"name":"@args","kind":13,"containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":91},{"line":91,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":92},{"line":92,"containerName":"_initialize","kind":12,"name":"sequence_factory"},{"line":92,"kind":12,"containerName":"_initialize","name":"new"},{"name":"$self","containerName":"_initialize","kind":13,"line":92},{"line":92,"name":"verbose","kind":12,"containerName":"_initialize"},{"line":95,"kind":13,"localvar":"my","containerName":"_initialize","name":"$compression","definition":"my"},{"name":"$self","kind":13,"containerName":"_initialize","line":95},{"line":95,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"line":95,"containerName":"_initialize","kind":13,"name":"@args"},{"name":"$compression","containerName":"_initialize","kind":13,"line":96},{"line":96,"kind":13,"containerName":"_initialize","name":"$compression"},{"name":"$self","kind":13,"containerName":"_initialize","line":97},{"containerName":"_initialize","kind":12,"name":"compression","line":97},{"line":97,"name":"$compression","kind":13,"containerName":"_initialize"},{"name":"$READ_AVAIL","kind":13,"containerName":"_initialize","line":99},{"line":100,"name":"throw","containerName":"_initialize","kind":12}],"detail":"($self,@args)","definition":"sub"},{"line":90,"containerName":"_initialize","kind":12,"name":"SUPER"},{"name":"Bio","containerName":"Seq::SeqFactory","kind":12,"line":92},{"kind":12,"containerName":"Root::Root","name":"Bio","line":100},{"range":{"start":{"character":0,"line":116},"end":{"line":131,"character":9999}},"kind":12,"line":116,"signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ztr.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::ztr\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::ztr - ztr trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from ztr trace\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::ztr;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));      \n  }\n\n  my ($compression) = $self->_rearrange([qw[COMPRESSION]], @args);\n  $compression = 2 unless defined $compression;\n  $self->compression($compression);\n\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE"},"containerName":"main::","name":"next_seq","children":[{"localvar":"my","kind":13,"containerName":"next_seq","name":"$self","line":118,"definition":"my"},{"definition":"my","name":"$seq","containerName":"next_seq","localvar":"my","kind":13,"line":120},{"name":"$id","containerName":"next_seq","kind":13,"line":120},{"kind":13,"containerName":"next_seq","name":"$desc","line":120},{"name":"$qual","kind":13,"containerName":"next_seq","line":120},{"containerName":"next_seq","kind":13,"name":"$self","line":120},{"line":120,"containerName":"next_seq","kind":12,"name":"read_trace"},{"name":"$self","containerName":"next_seq","kind":13,"line":120},{"name":"_fh","kind":12,"containerName":"next_seq","line":120},{"line":123,"name":"$seq","containerName":"next_seq","kind":13},{"line":123,"kind":13,"containerName":"next_seq","name":"$self"},{"line":123,"name":"sequence_factory","kind":12,"containerName":"next_seq"},{"name":"create","kind":12,"containerName":"next_seq","line":123},{"name":"$seq","containerName":"next_seq","kind":13,"line":123},{"name":"$id","containerName":"next_seq","kind":13,"line":124},{"line":125,"kind":13,"containerName":"next_seq","name":"$id"},{"line":126,"containerName":"next_seq","kind":13,"name":"$desc"},{"line":129,"name":"$qual","containerName":"next_seq","kind":13},{"line":130,"name":"$seq","containerName":"next_seq","kind":13}],"detail":"($self)","definition":"sub"},{"line":144,"range":{"end":{"line":154,"character":9999},"start":{"character":0,"line":144}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: ztr.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::ztr\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::ztr - ztr trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from ztr trace\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::ztr;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));      \n  }\n\n  my ($compression) = $self->_rearrange([qw[COMPRESSION]], @args);\n  $compression = 2 unless defined $compression;\n  $self->compression($compression);\n\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    my ($seq, $id, $desc, $qual) = $self->read_trace($self->_fh, 'ztr');\n\n    # create the seq object\n    $seq = $self->sequence_factory->create(-seq        => $seq,\n\t\t\t\t\t   -id         => $id,\n\t\t\t\t\t   -primary_id => $id,\n\t\t\t\t\t   -desc       => $desc,\n\t\t\t\t\t   -alphabet   => 'DNA',\n\t\t\t\t\t   -qual       => $qual\n\t\t\t\t\t   );\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object","label":"write_seq($self,@seq)"},"children":[{"line":145,"name":"$self","localvar":"my","containerName":"write_seq","kind":13,"definition":"my"},{"name":"@seq","kind":13,"containerName":"write_seq","line":145},{"localvar":"my","kind":13,"containerName":"write_seq","name":"$fh","line":147,"definition":"my"},{"line":147,"kind":13,"containerName":"write_seq","name":"$self"},{"name":"_fh","kind":12,"containerName":"write_seq","line":147},{"definition":"my","name":"$seq","kind":13,"localvar":"my","containerName":"write_seq","line":148},{"line":148,"name":"@seq","kind":13,"containerName":"write_seq"},{"line":149,"name":"$self","containerName":"write_seq","kind":13},{"line":149,"name":"write_trace","kind":12,"containerName":"write_seq"},{"name":"$fh","containerName":"write_seq","kind":13,"line":149},{"containerName":"write_seq","kind":13,"name":"$seq","line":149},{"line":149,"name":"$self","containerName":"write_seq","kind":13},{"name":"compression","containerName":"write_seq","kind":12,"line":149},{"line":152,"containerName":"write_seq","kind":13,"name":"$self"},{"line":152,"kind":12,"containerName":"write_seq","name":"flush"},{"line":152,"containerName":"write_seq","kind":13,"name":"$self"},{"line":152,"name":"_flush_on_write","containerName":"write_seq","kind":12},{"kind":13,"containerName":"write_seq","name":"$self","line":152},{"line":152,"name":"_fh","kind":12,"containerName":"write_seq"}],"containerName":"main::","name":"write_seq","definition":"sub","detail":"($self,@seq)"},{"detail":"($self,$val)","definition":"sub","name":"compression","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"compression","name":"$self","line":170,"definition":"my"},{"name":"$val","kind":13,"containerName":"compression","line":170},{"kind":13,"containerName":"compression","name":"$val","line":172},{"name":"$val","containerName":"compression","kind":13,"line":173},{"line":174,"name":"$self","kind":13,"containerName":"compression"},{"containerName":"compression","kind":13,"name":"$val","line":174},{"line":176,"name":"$self","containerName":"compression","kind":13},{"line":180,"containerName":"compression","kind":13,"name":"$self"}],"signature":{"documentation":"1;\n# $Id: ztr.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::ztr\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::ztr - ztr trace sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from ztr trace\nfiles.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Aaron Mackey\n\nEmail: amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::ztr;\nuse vars qw(@ISA $READ_AVAIL);\nuse strict;\n\nuse Bio::SeqIO;\nuse Bio::Seq::SeqFactory;\n\npush @ISA, qw( Bio::SeqIO );\n\nsub BEGIN {\n    eval { require Bio::SeqIO::staden::read; };\n    if ($@) {\n\t$READ_AVAIL = 0;\n    } else {\n\tpush @ISA, \"Bio::SeqIO::staden::read\";\n\t$READ_AVAIL = 1;\n    }\n}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new(-verbose => $self->verbose(), -type => 'Bio::Seq::Quality'));      \n  }\n\n  my ($compression) = $self->_rearrange([qw[COMPRESSION]], @args);\n  $compression = 2 unless defined $compression;\n  $self->compression($compression);\n\n  unless ($READ_AVAIL) {\n      Bio::Root::Root->throw( -class => 'Bio::Root::SystemException',\n\t\t\t      -text  => \"Bio::SeqIO::staden::read is not available; make sure the bioperl-ext package has been installed successfully!\"\n\t\t\t    );\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq::Quality object\n Args    : NONE\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    my ($seq, $id, $desc, $qual) = $self->read_trace($self->_fh, 'ztr');\n\n    # create the seq object\n    $seq = $self->sequence_factory->create(-seq        => $seq,\n\t\t\t\t\t   -id         => $id,\n\t\t\t\t\t   -primary_id => $id,\n\t\t\t\t\t   -desc       => $desc,\n\t\t\t\t\t   -alphabet   => 'DNA',\n\t\t\t\t\t   -qual       => $qual\n\t\t\t\t\t   );\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object\n\n\n\nsub write_seq {\n    my ($self,@seq) = @_;\n\n    my $fh = $self->_fh;\n    foreach my $seq (@seq) {\n\t$self->write_trace($fh, $seq, 'ztr' . $self->compression);\n    }\n\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 compression\n\n Title   : compression\n Usage   : $stream->compression(3);\n Function: determines the level of ZTR compression\n Returns : the current (or newly set) value.\n Args    : 1, 2 or 3 - any other (defined) value will cause the compression\n           to be reset to the default of 2.","parameters":[{"label":"$self"},{"label":"$val"}],"label":"compression($self,$val)"},"range":{"end":{"line":181,"character":9999},"start":{"character":0,"line":168}},"kind":12,"line":168},{"line":174,"name":"_compression","kind":12},{"line":176,"name":"_compression","kind":12},{"line":180,"kind":12,"name":"_compression"}]}