{"vars":[{"line":86,"containerName":"","kind":2,"name":"vars"},{"containerName":"","kind":2,"name":"base","line":88},{"name":"%ATTMAP","containerName":null,"kind":13,"line":92},{"name":"TSeq_sequence","kind":12,"line":92},{"name":"Data","kind":12,"line":92},{"name":"TSeq_gi","kind":12,"line":93},{"kind":12,"name":"Data","line":93},{"name":"TSeq_defline","kind":12,"line":94},{"kind":12,"name":"Data","line":94},{"kind":12,"name":"TSeq_sid","line":95},{"line":95,"name":"Data","kind":12},{"kind":12,"name":"TSeq_accver","line":96},{"name":"Data","kind":12,"line":96},{"name":"TSeq_taxid","kind":12,"line":97},{"kind":12,"name":"Data","line":97},{"line":98,"kind":12,"name":"TSeq_orgname"},{"kind":12,"name":"Data","line":98},{"signature":{"parameters":[{"label":"$proto"},{"label":"@args"}],"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE","label":"new($proto,@args)"},"line":112,"range":{"end":{"line":119,"character":9999},"start":{"character":0,"line":112}},"kind":12,"definition":"sub","detail":"($proto,@args)","children":[{"definition":"my","line":113,"kind":13,"localvar":"my","containerName":"new","name":"$proto"},{"name":"@args","containerName":"new","kind":13,"line":113},{"definition":"my","line":114,"localvar":"my","kind":13,"containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"$proto","line":114},{"name":"$proto","containerName":"new","kind":13,"line":114},{"definition":"my","name":"$self","localvar":"my","containerName":"new","kind":13,"line":116},{"line":116,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"$self","line":118}],"containerName":"main::","name":"new"},{"detail":"($self,$doctype)","definition":"sub","name":"doctype_decl","containerName":"main::","children":[{"line":126,"name":"$self","containerName":"doctype_decl","localvar":"my","kind":13,"definition":"my"},{"line":126,"kind":13,"containerName":"doctype_decl","name":"$doctype"},{"containerName":"doctype_decl","kind":13,"name":"$doctype","line":128},{"containerName":"doctype_decl","kind":13,"name":"$self","line":129},{"line":129,"kind":12,"containerName":"doctype_decl","name":"throw"},{"line":129,"kind":13,"containerName":"doctype_decl","name":"$doctype"}],"signature":{"parameters":[{"label":"$self"},{"label":"$doctype"}],"documentation":" Event hadling methods for PerlSax   #","label":"doctype_decl($self,$doctype)"},"kind":12,"range":{"end":{"character":9999,"line":132},"start":{"line":125,"character":0}},"line":125},{"children":[{"definition":"my","containerName":"start_document","localvar":"my","kind":13,"name":"$self","line":145},{"line":147,"containerName":"start_document","kind":13,"name":"$self"},{"line":148,"containerName":"start_document","kind":13,"name":"$self"}],"name":"start_document","containerName":"main::","definition":"sub","detail":"($self)","line":144,"kind":12,"range":{"end":{"character":9999,"line":149},"start":{"character":0,"line":144}},"signature":{"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE","parameters":[{"label":"$self"}],"label":"start_document($self)"}},{"name":"end_document","containerName":"main::","children":[{"definition":"my","line":162,"containerName":"end_document","localvar":"my","kind":13,"name":"$self"},{"containerName":"end_document","kind":13,"name":"$self","line":163}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":161},"end":{"line":164,"character":9999}},"line":161,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE","label":"end_document($self)"}},{"line":176,"kind":12,"range":{"start":{"line":176,"character":0},"end":{"character":9999,"line":179}},"signature":{"parameters":[{"label":"$self"},{"label":"$starting"}],"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE","label":"start_element($self,$starting)"},"children":[{"line":177,"localvar":"my","kind":13,"containerName":"start_element","name":"$self","definition":"my"},{"line":177,"name":"$starting","containerName":"start_element","kind":13},{"kind":13,"containerName":"start_element","name":"$self","line":179}],"containerName":"main::","name":"start_element","definition":"sub","detail":"($self,$starting)"},{"line":179,"name":"$starting","kind":13,"containerName":null},{"containerName":"main::","name":"end_element","children":[{"line":193,"localvar":"my","kind":13,"containerName":"end_element","name":"$self","definition":"my"},{"kind":13,"containerName":"end_element","name":"$ending","line":193},{"name":"$ename","kind":13,"localvar":"my","containerName":"end_element","line":196,"definition":"my"},{"line":196,"name":"$ending","kind":13,"containerName":"end_element"},{"line":197,"containerName":"end_element","kind":13,"name":"$self"},{"line":197,"containerName":"end_element","kind":13,"name":"$ename"},{"containerName":"end_element","kind":13,"name":"$self","line":197},{"line":197,"name":"can","containerName":"end_element","kind":12},{"name":"$ename","containerName":"end_element","kind":13,"line":197}],"detail":"($self,$ending)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":192},"end":{"character":9999,"line":198}},"line":192,"signature":{"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_element {\n    my ($self, $starting) = @_;\n\n    push(@{$self->{'_elements'}}, $starting);\n}\n\n=head2 end_element\n\n  Title\t\t: end_element\n  Usage\t\t: NONE\n  Function\t: end_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE","parameters":[{"label":"$self"},{"label":"$ending"}],"label":"end_element($self,$ending)"}},{"children":[{"definition":"my","line":211,"containerName":"characters","localvar":"my","kind":13,"name":"$self"},{"line":211,"name":"$characters","kind":13,"containerName":"characters"},{"definition":"my","line":213,"name":"$data","localvar":"my","kind":13,"containerName":"characters"},{"line":213,"name":"$characters","kind":13,"containerName":"characters"},{"name":"$data","kind":13,"containerName":"characters","line":215},{"name":"$data","containerName":"characters","kind":13,"line":215},{"definition":"my","localvar":"my","containerName":"characters","kind":13,"name":"$current","line":217},{"name":"$self","kind":13,"containerName":"characters","line":217},{"line":217,"containerName":"characters","kind":12,"name":"_current_element"},{"name":"$current","containerName":"characters","kind":13,"line":218},{"line":218,"kind":13,"containerName":"characters","name":"$data"}],"name":"characters","containerName":"main::","definition":"sub","detail":"($self,$characters)","line":210,"kind":12,"range":{"start":{"line":210,"character":0},"end":{"character":9999,"line":219}},"signature":{"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_element {\n    my ($self, $starting) = @_;\n\n    push(@{$self->{'_elements'}}, $starting);\n}\n\n=head2 end_element\n\n  Title\t\t: end_element\n  Usage\t\t: NONE\n  Function\t: end_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_element {\n    my ($self, $ending) = @_;\n\n    # do I have a handler for this element?\n    my $ename = $ending->{'Name'};\n    $self->$ename if ($self->can($ename));\n}\n\n=head2 characters\n\n  Title\t\t: characters\n  Usage\t\t: NONE\n  Function\t: characters handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE","parameters":[{"label":"$self"},{"label":"$characters"}],"label":"characters($self,$characters)"}},{"line":237,"range":{"start":{"line":237,"character":0},"end":{"character":9999,"line":243}},"kind":12,"signature":{"label":"TSeq($self)","documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_element {\n    my ($self, $starting) = @_;\n\n    push(@{$self->{'_elements'}}, $starting);\n}\n\n=head2 end_element\n\n  Title\t\t: end_element\n  Usage\t\t: NONE\n  Function\t: end_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_element {\n    my ($self, $ending) = @_;\n\n    # do I have a handler for this element?\n    my $ename = $ending->{'Name'};\n    $self->$ename if ($self->can($ename));\n}\n\n=head2 characters\n\n  Title\t\t: characters\n  Usage\t\t: NONE\n  Function\t: characters handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub characters {\n    my ($self, $characters) = @_;\n\n    my $data = $characters->{'Data'};\n\n    return unless (defined($data) and $data =~ /\\S/);\n\n    my $current = $self->_current_element;\n    $current->{'Data'} = $data;\n}\n\n\n###########################################\n# Element-specific handlers\n# called at END of element name\n##########################################\n\n=head2 TSeq\n\n  Title\t\t: TSeq\n  Usage\t\t: NONE\n  Function\t: event handler for END of a TSeq element\n  Returns\t: loh of parsed sequence atts for Bio::SeqIO::tinyseq\n  Args\t\t: NONE","parameters":[{"label":"$self"}]},"children":[{"containerName":"TSeq","localvar":"my","kind":13,"name":"$self","line":238,"definition":"my"},{"definition":"my","name":"%seqatts","kind":13,"localvar":"my","containerName":"TSeq","line":240},{"name":"$element","containerName":"TSeq","localvar":"my","kind":13,"line":243,"definition":"my"},{"line":243,"name":"$self","kind":13,"containerName":"TSeq"}],"name":"TSeq","containerName":"main::","definition":"sub","detail":"($self)"},{"definition":"my","line":244,"name":"$element_name","localvar":"my","containerName":null,"kind":13},{"line":244,"containerName":null,"kind":13,"name":"%element"},{"name":"$element_name","kind":13,"containerName":null,"line":245},{"definition":"my","line":247,"localvar":"my","containerName":null,"kind":13,"name":"$conversion"},{"line":247,"containerName":null,"kind":13,"name":"%ATTMAP"},{"line":247,"containerName":null,"kind":13,"name":"$element_name"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$element_att","line":249},{"line":249,"containerName":null,"kind":13,"name":"$pseq_att"},{"name":"%conversion","containerName":null,"kind":13,"line":249},{"containerName":null,"kind":13,"name":"%seqatts","line":250},{"name":"$pseq_att","kind":13,"containerName":null,"line":250},{"kind":13,"containerName":null,"name":"%element","line":250},{"line":250,"containerName":null,"kind":13,"name":"$element_att"},{"line":254,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%seqatts","line":254},{"signature":{"documentation":"1;\n# BioPerl module for Bio::SeqIO::tinyseqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::tinyseq::tinyseqHandler - XML event handlers to support NCBI TinySeq XML parsing\n\n=head1 SYNOPSIS\n\nDo not use this module directly; use the SeqIO handler system:\n\n  $stream = Bio::SeqIO->new( -file => $filename, -format => 'tinyseq' );\n\n  while ( my $seq = $stream->next_seq ) {\n    ....\n  }\n\n=head1 DESCRIPTION\n\nThis object provides event handler methods for parsing sequence files\nin the NCBI TinySeq XML format.  A TinySeq is a lightweight XML file\nof sequence information on one or more sequences, analgous to FASTA\nformat.\n\nSee L<http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.mod.dtd> for the DTD.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, L<Bio::Seq>.\n\n=head1 AUTHOR\n\nDonald Jackson, E<lt>donald.jackson@bms.comE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::tinyseq::tinyseqHandler;\n\nuse strict;\nuse warnings;\n\n\nuse vars qw(%ATTMAP);\n\nuse base qw(Bio::Root::Root);\n\n# %ATTMAP defines correspondence between TSeq elements, PrimarySeq attributes\n# Format: element_name => { xml_attname => pseq_attname }\n%ATTMAP\t= ( TSeq_sequence\t=> { Data\t=> '-seq'},\n\t    TSeq_gi\t\t=> { Data\t=> '-primary_id' },\n\t    TSeq_defline\t=> { Data\t=> '-desc' },\n\t    TSeq_sid\t\t=> { Data\t=> '-sid' },\n\t    TSeq_accver\t\t=> { Data\t=> '-accver' },\n\t    TSeq_taxid\t\t=> { Data\t=> '-taxid' },\n\t    TSeq_orgname\t=> { Data\t=> '-organism' }\n\t   );\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: $handler = Bio::SeqIO::tinyseq::tinyseqHandler->new()\n  Function\t: instantiates a tinyseqHandler for use by\n                  XML::Parser::PerlSAX\n  Returns\t: Bio::SeqIO::tinyseq::tinyseqHandler object\n  Args\t\t: NONE\n\n\nsub new {\n    my ($proto, @args) = @_;\n    my $class = ref($proto) || $proto;\n\n    my $self =  bless({}, $class);\n\n    return $self;\n}\n\n#######################################\n# Event hadling methods for PerlSax   #\n#######################################\n\nsub doctype_decl {\n    my ($self, $doctype) = @_;\n    # make sure we have a tinyseq\n    unless ($doctype->{'SystemId'} eq 'http://www.ncbi.nlm.nih.gov/dtd/NCBI_TSeq.dtd') {\n\t$self->throw(\"This document doesn't use the NCBI TinySeq dtd; it's a \", $doctype->{'SystemId'} );\n    }\n\n}\n\n=head2 start_document\n\n  Title\t\t: start_document\n  Usage\t\t: NONE\n  Function\t: start_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_document {\n    my ($self) = @_;\n\n    $self->{'_seqatts'} = [];\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n  Title\t\t: end_document\n  Usage\t\t: NONE\n  Function\t: end_document handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_seqatts'};\n}\n\n=head2 start_element\n\n  Title\t\t: start_element\n  Usage\t\t: NONE\n  Function\t: start_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub start_element {\n    my ($self, $starting) = @_;\n\n    push(@{$self->{'_elements'}}, $starting);\n}\n\n=head2 end_element\n\n  Title\t\t: end_element\n  Usage\t\t: NONE\n  Function\t: end_element handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub end_element {\n    my ($self, $ending) = @_;\n\n    # do I have a handler for this element?\n    my $ename = $ending->{'Name'};\n    $self->$ename if ($self->can($ename));\n}\n\n=head2 characters\n\n  Title\t\t: characters\n  Usage\t\t: NONE\n  Function\t: characters handler for use by XML::Parser::PerlSAX\n  Returns\t: NONE\n  Args\t\t: NONE\n\n\nsub characters {\n    my ($self, $characters) = @_;\n\n    my $data = $characters->{'Data'};\n\n    return unless (defined($data) and $data =~ /\\S/);\n\n    my $current = $self->_current_element;\n    $current->{'Data'} = $data;\n}\n\n\n###########################################\n# Element-specific handlers\n# called at END of element name\n##########################################\n\n=head2 TSeq\n\n  Title\t\t: TSeq\n  Usage\t\t: NONE\n  Function\t: event handler for END of a TSeq element\n  Returns\t: loh of parsed sequence atts for Bio::SeqIO::tinyseq\n  Args\t\t: NONE\n\n\nsub TSeq {\n    my ($self) = @_;\n\n    my %seqatts;\n\n    # map elements onto PrimarySeq keys\n    while (my $element = pop @{ $self->{'_elements'} }) {\n\tmy $element_name = $element->{'Name'};\n\tlast if ($element_name eq 'TSeq');\n\n\tmy $conversion = $ATTMAP{$element_name} or next;\n\n\twhile(my($element_att, $pseq_att) = each %$conversion) {\n\t    $seqatts{$pseq_att} = $element->{$element_att};\n\t}\n    }\n\n    push(@{ $self->{'_seqatts'} }, \\%seqatts);\n\n}\n\n#############################################\n# Utility method to return current element info\n##############################################\n\n=head2 _current_element\n\n  Title\t\t: _current_element\n  Usage\t\t: Internal method\n  Function\t: Utility method to return current element info\n  Returns\t: XML::Parser::PerlSAX hash for current element\n  Args\t\t: NONE","parameters":[{"label":"$self"}],"label":"_current_element($self)"},"range":{"end":{"line":275,"character":9999},"start":{"line":272,"character":0}},"kind":12,"line":272,"detail":"($self)","definition":"sub","name":"_current_element","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"_current_element","kind":13,"name":"$self","line":273},{"line":274,"containerName":"_current_element","kind":13,"name":"$self"}]}],"version":5}