{"version":5,"vars":[{"line":83,"name":"base","kind":2,"containerName":""},{"definition":"sub","detail":"($self,@args)","children":[{"line":86,"containerName":"_initialize","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"@args","kind":13,"containerName":"_initialize","line":86},{"line":87,"name":"$self","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"@args","line":87},{"line":88,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"sequence_factory","kind":12,"containerName":"_initialize","line":88},{"line":89,"name":"$self","containerName":"_initialize","kind":13},{"line":89,"containerName":"_initialize","kind":12,"name":"sequence_factory"},{"name":"new","kind":12,"containerName":"_initialize","line":90},{"line":90,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"verbose","kind":12,"containerName":"_initialize","line":90}],"name":"_initialize","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"},"line":85,"range":{"start":{"line":85,"character":0},"end":{"line":93,"character":9999}},"kind":12},{"line":87,"containerName":"_initialize","kind":12,"name":"SUPER"},{"name":"Bio","containerName":"Seq::SeqFactory","kind":12,"line":89},{"children":[{"name":"$self","localvar":"my","containerName":"next_seq","kind":13,"line":106,"definition":"my"},{"name":"@args","kind":13,"containerName":"next_seq","line":106},{"name":"$id","kind":13,"localvar":"my","containerName":"next_seq","line":107,"definition":"my"},{"line":107,"name":"$type","containerName":"next_seq","kind":13},{"name":"$desc","containerName":"next_seq","kind":13,"line":107},{"line":107,"name":"$line","kind":13,"containerName":"next_seq"},{"line":107,"name":"$chksum","containerName":"next_seq","kind":13},{"kind":13,"containerName":"next_seq","name":"$sequence","line":107},{"containerName":"next_seq","kind":13,"name":"$date","line":107},{"containerName":"next_seq","kind":13,"name":"$len","line":107},{"name":"$self","containerName":"next_seq","kind":13,"line":109},{"line":109,"containerName":"next_seq","kind":12,"name":"_readline"},{"line":112,"containerName":"next_seq","kind":13,"name":"$desc"},{"line":114,"name":"$line","containerName":"next_seq","kind":13},{"kind":13,"containerName":"next_seq","name":"$chksum","line":115},{"name":"$type","containerName":"next_seq","kind":13,"line":116},{"line":118,"containerName":"next_seq","kind":13,"name":"$id"},{"kind":13,"containerName":"next_seq","name":"$len","line":120},{"line":120,"name":"$date","containerName":"next_seq","kind":13},{"name":"$desc","kind":13,"containerName":"next_seq","line":125},{"line":127,"name":"$self","kind":13,"containerName":"next_seq"},{"name":"_readline","kind":12,"containerName":"next_seq","line":127},{"kind":13,"containerName":"next_seq","name":"$self","line":132},{"line":132,"kind":12,"containerName":"next_seq","name":"throw"},{"name":"$sequence","kind":13,"containerName":"next_seq","line":138},{"line":142,"containerName":"next_seq","kind":13,"name":"$chksum"},{"name":"$sequence","kind":13,"containerName":"next_seq","line":143},{"line":143,"name":"$chksum","containerName":"next_seq","kind":13},{"name":"$self","containerName":"next_seq","kind":13,"line":144},{"kind":12,"containerName":"next_seq","name":"throw","line":144},{"kind":13,"containerName":"next_seq","name":"$id","line":150},{"containerName":"next_seq","kind":13,"name":"$id","line":150},{"name":"$type","kind":13,"containerName":"next_seq","line":154},{"kind":13,"containerName":"next_seq","name":"$type","line":155},{"line":155,"kind":13,"containerName":"next_seq","name":"$type"},{"line":156,"containerName":"next_seq","kind":13,"name":"$type"},{"line":156,"name":"$type","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$self","line":159},{"name":"sequence_factory","containerName":"next_seq","kind":12,"line":159},{"line":159,"containerName":"next_seq","kind":12,"name":"create"},{"line":159,"name":"$sequence","kind":13,"containerName":"next_seq"},{"line":160,"name":"$id","containerName":"next_seq","kind":13},{"line":161,"name":"$desc","containerName":"next_seq","kind":13},{"name":"$type","kind":13,"containerName":"next_seq","line":162},{"line":163,"name":"$date","containerName":"next_seq","kind":13}],"containerName":"main::","name":"next_seq","definition":"sub","detail":"($self,@args)","line":105,"range":{"start":{"line":105,"character":0},"end":{"character":9999,"line":165}},"kind":12,"signature":{"documentation":"1;\n# $Id: gcg.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::gcg\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::gcg - GCG sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from GCG flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: E<lt>birney@ebi.ac.ukE<gt>\n       E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::gcg;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::RichSeq'));\n   }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_seq($self,@args)"}},{"line":143,"name":"_validate_checksum","kind":12},{"signature":{"label":"write_seq($self,@seq)","parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: gcg.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::gcg\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::gcg - GCG sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from GCG flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: E<lt>birney@ebi.ac.ukE<gt>\n       E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::gcg;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::RichSeq'));\n   }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n   my ($self,@args)    = @_;\n   my($id,$type,$desc,$line,$chksum,$sequence,$date,$len);\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## Get the descriptive info (anything before the line with '..')\n       unless( /\\.\\.$/ ) { $desc.= $_; }\n       ## Pull ID, Checksum & Type from the line containing '..'\n       /\\.\\.$/ && do     { $line = $_; chomp;\n                           if(/Check\\:\\s(\\d+)\\s/) { $chksum = $1; }\n                           if(/Type:\\s(\\w)\\s/)    { $type   = $1; }\n                           if(/(\\S+)\\s+Length/)\n\t\t\t   { $id     = $1; }\n\t\t\t   if(/Length:\\s+(\\d+)\\s+(\\S.+\\S)\\s+Type/ )\n\t\t\t   { $len = $1; $date = $2;}\n                           last;\n                         }\n   }\n   return if ( !defined $_);\n   chomp($desc);  # remove last \"\\n\"\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## This is where we grab the sequence info.\n\n       if( /\\.\\.$/ ) {\n        $self->throw(\"Looks like start of another sequence. See documentation. \");\n       }\n\n       next if($_ eq \"\\n\");       ## skip whitespace lines in formatted seq\n       s/[\\d\\s\\t]//g;            ## remove anything that is not alphabet char: preserve anything that is not explicitly specified for removal (Stefan Kirov)\n       # $_ = uc($_);               ## uppercase sequence: NO. Keep the case. HL\n       $sequence .= $_;\n   }\n   ##If we parsed out a checksum, we might as well test it\n\n   if(defined $chksum) {\n       unless(_validate_checksum(uc($sequence),$chksum)) {\n\t   $self->throw(\"Checksum failure on parsed sequence.\");\n       }\n   }\n\n   ## Remove whitespace from identifier because the constructor\n   ## will throw a warning otherwise...\n   if(defined $id) { $id =~ s/\\s+//g;}\n\n   ## Turn our parsed \"Type: N\" or \"Type: P\" (if found) into the appropriate\n   ## keyword that the constructor expects...\n   if(defined $type) {\n       if($type eq \"N\") { $type = \"dna\";      }\n       if($type eq \"P\") { $type = \"prot\";    }\n   }\n\n   return $self->sequence_factory->create(-seq  => $sequence,\n\t\t\t\t\t  -id   => $id,\n\t\t\t\t\t  -desc => $desc,\n\t\t\t\t\t  -type => $type,\n\t\t\t\t\t  -dates => [ $date ]\n\t\t\t\t\t  );\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the formatted $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : array of Bio::PrimarySeqI object"},"range":{"start":{"character":0,"line":178},"end":{"line":234,"character":9999}},"kind":12,"line":178,"detail":"($self,@seq)","definition":"sub","name":"write_seq","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"write_seq","localvar":"my","kind":13,"line":179},{"line":179,"kind":13,"containerName":"write_seq","name":"@seq"},{"definition":"my","name":"$seq","localvar":"my","containerName":"write_seq","kind":13,"line":180},{"line":180,"name":"@seq","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$self","line":181},{"line":181,"kind":12,"containerName":"write_seq","name":"throw"},{"name":"$seq","kind":13,"containerName":"write_seq","line":182},{"line":182,"containerName":"write_seq","kind":13,"name":"$seq"},{"line":182,"name":"$seq","kind":13,"containerName":"write_seq"},{"name":"isa","containerName":"write_seq","kind":12,"line":182},{"line":184,"containerName":"write_seq","kind":13,"name":"$self"},{"line":184,"kind":12,"containerName":"write_seq","name":"warn"},{"line":184,"name":"$seq","kind":13,"containerName":"write_seq"},{"name":"display_id","kind":12,"containerName":"write_seq","line":184},{"name":"$seq","containerName":"write_seq","kind":13,"line":185},{"containerName":"write_seq","kind":12,"name":"display_id","line":185},{"definition":"my","name":"$str","localvar":"my","kind":13,"containerName":"write_seq","line":187},{"name":"$seq","kind":13,"containerName":"write_seq","line":187},{"line":187,"containerName":"write_seq","kind":12,"name":"seq"},{"name":"$comment","localvar":"my","containerName":"write_seq","kind":13,"line":188,"definition":"my"},{"line":188,"name":"$seq","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":12,"name":"desc","line":188},{"definition":"my","line":189,"name":"$id","containerName":"write_seq","localvar":"my","kind":13},{"containerName":"write_seq","kind":13,"name":"$seq","line":189},{"containerName":"write_seq","kind":12,"name":"id","line":189},{"kind":13,"localvar":"my","containerName":"write_seq","name":"$type","line":190,"definition":"my"},{"line":190,"kind":13,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","kind":12,"name":"alphabet","line":190},{"containerName":"write_seq","localvar":"my","kind":13,"name":"$timestamp","line":191,"definition":"my"},{"name":"$seq","containerName":"write_seq","kind":13,"line":193},{"name":"can","containerName":"write_seq","kind":12,"line":193},{"line":194,"kind":13,"containerName":"write_seq","name":"$timestamp"},{"name":"$seq","containerName":"write_seq","kind":13,"line":194},{"name":"get_dates","containerName":"write_seq","kind":12,"line":194},{"line":196,"kind":13,"containerName":"write_seq","name":"$timestamp"},{"definition":"my","containerName":"write_seq","localvar":"my","kind":13,"name":"$sum","line":198},{"containerName":"write_seq","kind":13,"name":"$offset","line":198},{"kind":13,"containerName":"write_seq","name":"$len","line":198},{"kind":13,"containerName":"write_seq","name":"$i","line":198},{"name":"$j","kind":13,"containerName":"write_seq","line":198},{"line":198,"containerName":"write_seq","kind":13,"name":"$cnt"},{"containerName":"write_seq","kind":13,"name":"@out","line":198},{"containerName":"write_seq","kind":13,"name":"$len","line":200},{"name":"$str","kind":13,"containerName":"write_seq","line":200},{"line":202,"name":"$offset","containerName":"write_seq","kind":13},{"line":204,"kind":13,"containerName":"write_seq","name":"$sum"},{"containerName":"write_seq","kind":13,"name":"$self","line":204},{"kind":12,"containerName":"write_seq","name":"GCG_checksum","line":204},{"line":204,"name":"$seq","containerName":"write_seq","kind":13},{"name":"@out","containerName":"write_seq","kind":13,"line":207},{"name":"@out","kind":13,"containerName":"write_seq","line":208},{"line":211,"kind":13,"containerName":"write_seq","name":"$i"},{"name":"$j","containerName":"write_seq","kind":13,"line":212},{"line":212,"name":"$j","kind":13,"containerName":"write_seq"},{"name":"$len","kind":13,"containerName":"write_seq","line":212},{"line":213,"name":"$j","containerName":"write_seq","kind":13},{"name":"$out","kind":13,"containerName":"write_seq","line":214},{"line":214,"containerName":"write_seq","kind":13,"name":"$i"},{"line":214,"name":"$j","containerName":"write_seq","kind":13},{"name":"$offset","containerName":"write_seq","kind":13,"line":214},{"name":"$out","containerName":"write_seq","kind":13,"line":216},{"kind":13,"containerName":"write_seq","name":"$i","line":216},{"containerName":"write_seq","kind":13,"name":"$str","line":216},{"kind":13,"containerName":"write_seq","name":"$j","line":216},{"kind":13,"containerName":"write_seq","name":"$j","line":217},{"line":218,"containerName":"write_seq","kind":13,"name":"$j"},{"line":218,"kind":13,"containerName":"write_seq","name":"$len"},{"line":218,"containerName":"write_seq","kind":13,"name":"$j"},{"line":219,"containerName":"write_seq","kind":13,"name":"$out"},{"line":219,"kind":13,"containerName":"write_seq","name":"$i"},{"line":220,"name":"$j","kind":13,"containerName":"write_seq"},{"line":221,"name":"$out","kind":13,"containerName":"write_seq"},{"line":221,"name":"$i","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":13,"name":"$j","line":225},{"line":226,"kind":13,"containerName":"write_seq","name":"$out"},{"line":226,"containerName":"write_seq","kind":13,"name":"$i"},{"line":228,"name":"$out","kind":13,"containerName":"write_seq"},{"containerName":"write_seq","kind":13,"name":"$i","line":228},{"line":229,"containerName":"write_seq","kind":13,"name":"$self"},{"name":"_print","containerName":"write_seq","kind":12,"line":229},{"containerName":"write_seq","kind":13,"name":"@out","line":229},{"containerName":"write_seq","kind":13,"name":"$self","line":232},{"containerName":"write_seq","kind":12,"name":"flush","line":232},{"line":232,"kind":13,"containerName":"write_seq","name":"$self"},{"line":232,"name":"_flush_on_write","containerName":"write_seq","kind":12},{"name":"$self","containerName":"write_seq","kind":13,"line":232},{"line":232,"name":"_fh","kind":12,"containerName":"write_seq"}]},{"name":"out","kind":12,"line":211},{"line":249,"range":{"start":{"line":249,"character":0},"end":{"line":267,"character":9999}},"kind":12,"signature":{"label":"GCG_checksum($self,$seqobj)","parameters":[{"label":"$self"},{"label":"$seqobj"}],"documentation":"1;\n# $Id: gcg.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::gcg\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::gcg - GCG sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from GCG flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: E<lt>birney@ebi.ac.ukE<gt>\n       E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::gcg;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::RichSeq'));\n   }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n   my ($self,@args)    = @_;\n   my($id,$type,$desc,$line,$chksum,$sequence,$date,$len);\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## Get the descriptive info (anything before the line with '..')\n       unless( /\\.\\.$/ ) { $desc.= $_; }\n       ## Pull ID, Checksum & Type from the line containing '..'\n       /\\.\\.$/ && do     { $line = $_; chomp;\n                           if(/Check\\:\\s(\\d+)\\s/) { $chksum = $1; }\n                           if(/Type:\\s(\\w)\\s/)    { $type   = $1; }\n                           if(/(\\S+)\\s+Length/)\n\t\t\t   { $id     = $1; }\n\t\t\t   if(/Length:\\s+(\\d+)\\s+(\\S.+\\S)\\s+Type/ )\n\t\t\t   { $len = $1; $date = $2;}\n                           last;\n                         }\n   }\n   return if ( !defined $_);\n   chomp($desc);  # remove last \"\\n\"\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## This is where we grab the sequence info.\n\n       if( /\\.\\.$/ ) {\n        $self->throw(\"Looks like start of another sequence. See documentation. \");\n       }\n\n       next if($_ eq \"\\n\");       ## skip whitespace lines in formatted seq\n       s/[\\d\\s\\t]//g;            ## remove anything that is not alphabet char: preserve anything that is not explicitly specified for removal (Stefan Kirov)\n       # $_ = uc($_);               ## uppercase sequence: NO. Keep the case. HL\n       $sequence .= $_;\n   }\n   ##If we parsed out a checksum, we might as well test it\n\n   if(defined $chksum) {\n       unless(_validate_checksum(uc($sequence),$chksum)) {\n\t   $self->throw(\"Checksum failure on parsed sequence.\");\n       }\n   }\n\n   ## Remove whitespace from identifier because the constructor\n   ## will throw a warning otherwise...\n   if(defined $id) { $id =~ s/\\s+//g;}\n\n   ## Turn our parsed \"Type: N\" or \"Type: P\" (if found) into the appropriate\n   ## keyword that the constructor expects...\n   if(defined $type) {\n       if($type eq \"N\") { $type = \"dna\";      }\n       if($type eq \"P\") { $type = \"prot\";    }\n   }\n\n   return $self->sequence_factory->create(-seq  => $sequence,\n\t\t\t\t\t  -id   => $id,\n\t\t\t\t\t  -desc => $desc,\n\t\t\t\t\t  -type => $type,\n\t\t\t\t\t  -dates => [ $date ]\n\t\t\t\t\t  );\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the formatted $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : array of Bio::PrimarySeqI object\n\n\n\nsub write_seq {\n    my ($self,@seq) = @_;\n    for my $seq (@seq) {\n\t$self->throw(\"Did not provide a valid Bio::PrimarySeqI object\")\n\t    unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n\n        $self->warn(\"No whitespace allowed in GCG ID [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n\tmy $str         = $seq->seq;\n\tmy $comment     = $seq->desc || '';\n\tmy $id          = $seq->id;\n\tmy $type        = ( $seq->alphabet() =~ /[dr]na/i ) ? 'N' : 'P';\n\tmy $timestamp;\n\n\tif( $seq->can('get_dates') ) {\n\t    ($timestamp) = $seq->get_dates;\n\t} else {\n\t    $timestamp = localtime(time);\n\t}\n\tmy($sum,$offset,$len,$i,$j,$cnt,@out);\n\n\t$len = length($str);\n\t## Set the offset if we have any non-standard numbering going on\n\t$offset=1;\n\t# checksum\n\t$sum = $self->GCG_checksum($seq);\n\n\t#Output the sequence header info\n\tpush(@out,\"$comment\\n\");\n\tpush(@out,\"$id  Length: $len  $timestamp  Type: $type  Check: $sum  ..\\n\\n\");\n\n\t#Format the sequence\n\t$i = $#out + 1;\n\tfor($j = 0 ; $j < $len ; ) {\n\t    if( $j % 50 == 0) {\n\t\t$out[$i] = sprintf(\"%8d  \",($j+$offset)); #numbering\n\t    }\n\t    $out[$i] .= sprintf(\"%s\",substr($str,$j,10));\n\t    $j += 10;\n\t    if( $j < $len && $j % 50 != 0 ) {\n\t\t$out[$i] .= \" \";\n\t    }elsif($j % 50 == 0 ) {\n\t\t$out[$i++] .= \"\\n\\n\";\n\t    }\n\t}\n\tlocal($^W) = 0;\n\tif($j % 50 != 0 ) {\n\t    $out[$i] .= \"\\n\";\n\t}\n\t$out[$i] .= \"\\n\";\n\treturn unless $self->_print(@out);\n    }\n\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 GCG_checksum\n\n Title     : GCG_checksum\n Usage     : $cksum = $gcgio->GCG_checksum($seq);\n Function  : returns a gcg checksum for the sequence specified\n\n             This method can also be called as a class method.\n Example   :\n Returns   : a GCG checksum string\n Argument  : a Bio::PrimarySeqI implementing object"},"children":[{"localvar":"my","containerName":"GCG_checksum","kind":13,"name":"$self","line":250,"definition":"my"},{"line":250,"name":"$seqobj","kind":13,"containerName":"GCG_checksum"},{"containerName":"GCG_checksum","localvar":"my","kind":13,"name":"$index","line":251,"definition":"my"},{"definition":"my","line":252,"containerName":"GCG_checksum","localvar":"my","kind":13,"name":"$checksum"},{"definition":"my","line":253,"containerName":"GCG_checksum","localvar":"my","kind":13,"name":"$char"},{"definition":"my","line":255,"kind":13,"localvar":"my","containerName":"GCG_checksum","name":"$seq"},{"line":255,"containerName":"GCG_checksum","kind":13,"name":"$seqobj"},{"line":255,"name":"seq","containerName":"GCG_checksum","kind":12},{"line":256,"name":"$seq","containerName":"GCG_checksum","kind":13},{"name":"$char","kind":13,"containerName":"GCG_checksum","line":258},{"containerName":"GCG_checksum","kind":13,"name":"$seq","line":258},{"line":259,"name":"$index","kind":13,"containerName":"GCG_checksum"},{"name":"$checksum","containerName":"GCG_checksum","kind":13,"line":260},{"name":"$index","kind":13,"containerName":"GCG_checksum","line":260},{"name":"$char","containerName":"GCG_checksum","kind":13,"line":260},{"name":"$index","containerName":"GCG_checksum","kind":13,"line":261},{"name":"$index","kind":13,"containerName":"GCG_checksum","line":262},{"line":266,"kind":13,"containerName":"GCG_checksum","name":"$checksum"}],"name":"GCG_checksum","containerName":"main::","definition":"sub","detail":"($self,$seqobj)"},{"definition":"sub","detail":"($seq,$parsed_sum)","children":[{"definition":"my","name":"$seq","localvar":"my","kind":13,"containerName":"_validate_checksum","line":285},{"line":285,"name":"$parsed_sum","kind":13,"containerName":"_validate_checksum"},{"name":"$i","localvar":"my","kind":13,"containerName":"_validate_checksum","line":286,"definition":"my"},{"line":286,"name":"$len","containerName":"_validate_checksum","kind":13},{"line":286,"containerName":"_validate_checksum","kind":13,"name":"$computed_sum"},{"line":286,"kind":13,"containerName":"_validate_checksum","name":"$cnt"},{"name":"$len","containerName":"_validate_checksum","kind":13,"line":288},{"containerName":"_validate_checksum","kind":13,"name":"$seq","line":288},{"line":292,"containerName":"_validate_checksum","kind":13,"name":"$i"},{"name":"$i","kind":13,"containerName":"_validate_checksum","line":292},{"line":292,"kind":13,"containerName":"_validate_checksum","name":"$len"},{"line":292,"containerName":"_validate_checksum","kind":13,"name":"$i"},{"line":293,"name":"$cnt","kind":13,"containerName":"_validate_checksum"},{"name":"$computed_sum","kind":13,"containerName":"_validate_checksum","line":294},{"line":294,"name":"$cnt","containerName":"_validate_checksum","kind":13},{"line":294,"kind":13,"containerName":"_validate_checksum","name":"$seq"},{"kind":13,"containerName":"_validate_checksum","name":"$i","line":294},{"name":"$cnt","kind":13,"containerName":"_validate_checksum","line":295},{"name":"$cnt","kind":13,"containerName":"_validate_checksum","line":295},{"containerName":"_validate_checksum","kind":13,"name":"$computed_sum","line":297},{"line":301,"name":"$parsed_sum","kind":13,"containerName":"_validate_checksum"},{"line":301,"kind":13,"containerName":"_validate_checksum","name":"$computed_sum"}],"containerName":"main::","name":"_validate_checksum","signature":{"documentation":"1;\n# $Id: gcg.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::gcg\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::gcg - GCG sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from GCG flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: E<lt>birney@ebi.ac.ukE<gt>\n       E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::gcg;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n  if( ! defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFactory->new\n\t\t\t      (-verbose => $self->verbose(),\n\t\t\t       -type => 'Bio::Seq::RichSeq'));\n   }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n   my ($self,@args)    = @_;\n   my($id,$type,$desc,$line,$chksum,$sequence,$date,$len);\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## Get the descriptive info (anything before the line with '..')\n       unless( /\\.\\.$/ ) { $desc.= $_; }\n       ## Pull ID, Checksum & Type from the line containing '..'\n       /\\.\\.$/ && do     { $line = $_; chomp;\n                           if(/Check\\:\\s(\\d+)\\s/) { $chksum = $1; }\n                           if(/Type:\\s(\\w)\\s/)    { $type   = $1; }\n                           if(/(\\S+)\\s+Length/)\n\t\t\t   { $id     = $1; }\n\t\t\t   if(/Length:\\s+(\\d+)\\s+(\\S.+\\S)\\s+Type/ )\n\t\t\t   { $len = $1; $date = $2;}\n                           last;\n                         }\n   }\n   return if ( !defined $_);\n   chomp($desc);  # remove last \"\\n\"\n\n   while( defined($_ = $self->_readline()) ) {\n\n       ## This is where we grab the sequence info.\n\n       if( /\\.\\.$/ ) {\n        $self->throw(\"Looks like start of another sequence. See documentation. \");\n       }\n\n       next if($_ eq \"\\n\");       ## skip whitespace lines in formatted seq\n       s/[\\d\\s\\t]//g;            ## remove anything that is not alphabet char: preserve anything that is not explicitly specified for removal (Stefan Kirov)\n       # $_ = uc($_);               ## uppercase sequence: NO. Keep the case. HL\n       $sequence .= $_;\n   }\n   ##If we parsed out a checksum, we might as well test it\n\n   if(defined $chksum) {\n       unless(_validate_checksum(uc($sequence),$chksum)) {\n\t   $self->throw(\"Checksum failure on parsed sequence.\");\n       }\n   }\n\n   ## Remove whitespace from identifier because the constructor\n   ## will throw a warning otherwise...\n   if(defined $id) { $id =~ s/\\s+//g;}\n\n   ## Turn our parsed \"Type: N\" or \"Type: P\" (if found) into the appropriate\n   ## keyword that the constructor expects...\n   if(defined $type) {\n       if($type eq \"N\") { $type = \"dna\";      }\n       if($type eq \"P\") { $type = \"prot\";    }\n   }\n\n   return $self->sequence_factory->create(-seq  => $sequence,\n\t\t\t\t\t  -id   => $id,\n\t\t\t\t\t  -desc => $desc,\n\t\t\t\t\t  -type => $type,\n\t\t\t\t\t  -dates => [ $date ]\n\t\t\t\t\t  );\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: writes the formatted $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : array of Bio::PrimarySeqI object\n\n\n\nsub write_seq {\n    my ($self,@seq) = @_;\n    for my $seq (@seq) {\n\t$self->throw(\"Did not provide a valid Bio::PrimarySeqI object\")\n\t    unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n\n        $self->warn(\"No whitespace allowed in GCG ID [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n\tmy $str         = $seq->seq;\n\tmy $comment     = $seq->desc || '';\n\tmy $id          = $seq->id;\n\tmy $type        = ( $seq->alphabet() =~ /[dr]na/i ) ? 'N' : 'P';\n\tmy $timestamp;\n\n\tif( $seq->can('get_dates') ) {\n\t    ($timestamp) = $seq->get_dates;\n\t} else {\n\t    $timestamp = localtime(time);\n\t}\n\tmy($sum,$offset,$len,$i,$j,$cnt,@out);\n\n\t$len = length($str);\n\t## Set the offset if we have any non-standard numbering going on\n\t$offset=1;\n\t# checksum\n\t$sum = $self->GCG_checksum($seq);\n\n\t#Output the sequence header info\n\tpush(@out,\"$comment\\n\");\n\tpush(@out,\"$id  Length: $len  $timestamp  Type: $type  Check: $sum  ..\\n\\n\");\n\n\t#Format the sequence\n\t$i = $#out + 1;\n\tfor($j = 0 ; $j < $len ; ) {\n\t    if( $j % 50 == 0) {\n\t\t$out[$i] = sprintf(\"%8d  \",($j+$offset)); #numbering\n\t    }\n\t    $out[$i] .= sprintf(\"%s\",substr($str,$j,10));\n\t    $j += 10;\n\t    if( $j < $len && $j % 50 != 0 ) {\n\t\t$out[$i] .= \" \";\n\t    }elsif($j % 50 == 0 ) {\n\t\t$out[$i++] .= \"\\n\\n\";\n\t    }\n\t}\n\tlocal($^W) = 0;\n\tif($j % 50 != 0 ) {\n\t    $out[$i] .= \"\\n\";\n\t}\n\t$out[$i] .= \"\\n\";\n\treturn unless $self->_print(@out);\n    }\n\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 GCG_checksum\n\n Title     : GCG_checksum\n Usage     : $cksum = $gcgio->GCG_checksum($seq);\n Function  : returns a gcg checksum for the sequence specified\n\n             This method can also be called as a class method.\n Example   :\n Returns   : a GCG checksum string\n Argument  : a Bio::PrimarySeqI implementing object\n\n\nsub GCG_checksum {\n    my ($self,$seqobj) = @_;\n    my $index = 0;\n    my $checksum = 0;\n    my $char;\n\n    my $seq = $seqobj->seq();\n    $seq =~ tr/a-z/A-Z/;\n\n    foreach $char ( split(/[\\.\\-]*/, $seq)) {\n\t$index++;\n\t$checksum += ($index * (unpack(\"c\",$char) || 0) );\n\tif( $index ==  57 ) {\n\t    $index = 0;\n\t}\n    }\n\n    return ($checksum % 10000);\n}\n\n=head2 _validate_checksum\n\n Title   : _validate_checksum\n Usage   : n/a - internal method\n Function: if parsed gcg sequence contains a checksum field\n         : we compare it to a value computed here on the parsed\n         : sequence. A checksum mismatch would indicate some\n         : type of parsing failure occured.\n         :\n Returns : 1 for success, 0 for failure\n Args    : string containing parsed seq, value of parsed cheksum","parameters":[{"label":"$seq"},{"label":"$parsed_sum"}],"label":"_validate_checksum($seq,$parsed_sum)"},"line":284,"kind":12,"range":{"end":{"character":9999,"line":306},"start":{"line":284,"character":0}}}]}