{"vars":[{"kind":2,"containerName":"","name":"vars","line":79},{"containerName":"","kind":2,"name":"base","line":81},{"line":97,"range":{"end":{"character":9999,"line":113},"start":{"line":97,"character":0}},"kind":12,"signature":{"label":"new($caller,$seq,$ann,$comp,$map,$src)","documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature","parameters":[{"label":"$caller"},{"label":"$seq"},{"label":"$ann"},{"label":"$comp"},{"label":"$map"},{"label":"$src"}]},"children":[{"name":"$caller","localvar":"my","kind":13,"containerName":"new","line":98,"definition":"my"},{"line":98,"name":"$seq","kind":13,"containerName":"new"},{"name":"$ann","containerName":"new","kind":13,"line":98},{"name":"$comp","containerName":"new","kind":13,"line":98},{"kind":13,"containerName":"new","name":"$map","line":98},{"line":98,"name":"$src","containerName":"new","kind":13},{"name":"$class","kind":13,"localvar":"my","containerName":"new","line":100,"definition":"my"},{"line":100,"containerName":"new","kind":13,"name":"$caller"},{"name":"$caller","containerName":"new","kind":13,"line":100},{"name":"$self","kind":13,"localvar":"my","containerName":"new","line":102,"definition":"my"},{"containerName":"new","kind":13,"name":"$seq","line":103},{"kind":13,"containerName":"new","name":"$ann","line":104},{"kind":13,"containerName":"new","name":"$comp","line":105},{"containerName":"new","kind":13,"name":"$map","line":106},{"line":107,"name":"$src","kind":13,"containerName":"new"},{"name":"$class","kind":13,"containerName":"new","line":110},{"containerName":"new","kind":13,"name":"$self","line":112}],"containerName":"main::","name":"new","definition":"sub","detail":"($caller,$seq,$ann,$comp,$map,$src)"},{"name":"seqs","kind":12,"line":103},{"line":104,"name":"anns","kind":12},{"line":105,"kind":12,"name":"comps"},{"name":"map_pos","kind":12,"line":106},{"line":107,"kind":12,"name":"has_source"},{"line":108,"name":"seq_h","kind":12},{"kind":12,"name":"ann_l","line":109},{"definition":"sub","name":"convert","containerName":"main::","children":[{"line":128,"localvar":"my","containerName":"convert","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"@ann","localvar":"my","kind":13,"containerName":"convert","line":129},{"line":129,"containerName":"convert","kind":13,"name":"$self"}],"range":{"start":{"line":127,"character":0},"end":{"line":129,"character":9999}},"kind":12,"line":127},{"line":129,"kind":12,"name":"anns"},{"line":129,"containerName":null,"kind":13,"name":"%self"},{"name":"anns","kind":12,"line":129},{"definition":"my","name":"@seq","kind":13,"localvar":"my","containerName":null,"line":130},{"line":130,"name":"%self","containerName":null,"kind":13},{"name":"seqs","kind":12,"line":130},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@comp","line":133},{"containerName":null,"kind":13,"name":"%self","line":134},{"name":"comps","kind":12,"line":134},{"line":135,"containerName":null,"kind":13,"name":"@comp"},{"name":"%self","containerName":null,"kind":13,"line":135},{"kind":12,"name":"comps","line":135},{"name":"@seq","containerName":null,"kind":13,"line":139},{"line":140,"kind":13,"containerName":null,"name":"$self"},{"line":140,"name":"_add_seq","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"@ann","line":144},{"line":145,"name":"$self","containerName":null,"kind":13},{"line":145,"name":"_annotation","kind":12,"containerName":"main::"},{"name":"$self","kind":13,"containerName":null,"line":148},{"line":148,"name":"_order_feats","containerName":"main::","kind":12},{"name":"%self","kind":13,"containerName":null,"line":148},{"line":148,"name":"seq_h","kind":12},{"line":162,"range":{"end":{"line":177,"character":9999},"start":{"line":162,"character":0}},"kind":12,"signature":{"label":"_order_feats($self,$seqs)","parameters":[{"label":"$self"},{"label":"$seqs"}],"documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences"},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_order_feats","line":163},{"kind":13,"containerName":"_order_feats","name":"$seqs","line":163},{"line":164,"name":"$seq","localvar":"my","kind":13,"containerName":"_order_feats","definition":"my"},{"kind":13,"containerName":"_order_feats","name":"$self","line":164},{"line":165,"localvar":"my","containerName":"_order_feats","kind":13,"name":"$id","definition":"my"},{"line":165,"name":"$seq","containerName":"_order_feats","kind":13},{"kind":12,"containerName":"_order_feats","name":"id","line":165},{"localvar":"my","containerName":"_order_feats","kind":13,"name":"$ann","line":166,"definition":"my"},{"line":166,"containerName":"_order_feats","kind":13,"name":"$self"},{"line":169,"name":"@src","localvar":"my","containerName":"_order_feats","kind":13,"definition":"my"},{"line":169,"name":"primary_tag","kind":12,"containerName":"_order_feats"},{"kind":13,"containerName":"_order_feats","name":"$ann","line":169},{"line":171,"name":"@genes","localvar":"my","kind":13,"containerName":"_order_feats","definition":"my"},{"kind":12,"containerName":"_order_feats","name":"primary_tag","line":171},{"name":"$ann","kind":13,"containerName":"_order_feats","line":171},{"definition":"my","name":"@other","kind":13,"localvar":"my","containerName":"_order_feats","line":172},{"name":"$a","containerName":"_order_feats","kind":13,"line":172},{"line":172,"kind":12,"containerName":"_order_feats","name":"start"},{"name":"$b","containerName":"_order_feats","kind":13,"line":172},{"name":"start","kind":12,"containerName":"_order_feats","line":172},{"name":"$b","containerName":"_order_feats","kind":13,"line":172},{"name":"end","kind":12,"containerName":"_order_feats","line":172},{"line":172,"name":"$a","kind":13,"containerName":"_order_feats"},{"line":172,"containerName":"_order_feats","kind":12,"name":"end"},{"kind":12,"containerName":"_order_feats","name":"primary_tag","line":173},{"containerName":"_order_feats","kind":12,"name":"primary_tag","line":174},{"line":174,"kind":13,"containerName":"_order_feats","name":"$ann"},{"line":176,"kind":13,"containerName":"_order_feats","name":"$seq"},{"line":176,"name":"@src","kind":13,"containerName":"_order_feats"},{"line":176,"name":"@genes","kind":13,"containerName":"_order_feats"},{"line":176,"containerName":"_order_feats","kind":13,"name":"@other"}],"containerName":"main::","name":"_order_feats","definition":"sub","detail":"($self,$seqs)"},{"name":"main_seq","kind":12,"line":164},{"line":166,"name":"ann_l","kind":12},{"definition":"sub","detail":"($self,$el)","children":[{"line":190,"name":"$self","kind":13,"localvar":"my","containerName":"_add_seq","definition":"my"},{"line":190,"name":"$el","containerName":"_add_seq","kind":13},{"line":191,"name":"$residues","containerName":"_add_seq","localvar":"my","kind":13,"definition":"my"},{"line":193,"kind":13,"containerName":"_add_seq","name":"$el"},{"kind":13,"containerName":"_add_seq","name":"$residues","line":194},{"name":"$el","containerName":"_add_seq","kind":13,"line":194},{"name":"$residues","containerName":"_add_seq","kind":13,"line":195},{"line":196,"name":"$residues","containerName":"_add_seq","kind":13},{"line":197,"name":"$residues","containerName":"_add_seq","kind":13},{"definition":"my","line":203,"name":"$id","kind":13,"localvar":"my","containerName":"_add_seq"},{"name":"$el","kind":13,"containerName":"_add_seq","line":203},{"definition":"my","line":204,"kind":13,"localvar":"my","containerName":"_add_seq","name":"$ver"},{"line":204,"name":"$el","kind":13,"containerName":"_add_seq"},{"line":205,"kind":13,"localvar":"my","containerName":"_add_seq","name":"$name","definition":"my"},{"line":205,"name":"$el","containerName":"_add_seq","kind":13},{"line":207,"name":"$name","kind":13,"containerName":"_add_seq"},{"line":207,"kind":13,"containerName":"_add_seq","name":"$name"},{"name":"$id","containerName":"_add_seq","kind":13,"line":207},{"line":208,"name":"$self","kind":13,"containerName":"_add_seq"},{"line":208,"name":"complain","containerName":"_add_seq","kind":12},{"definition":"my","line":212,"name":"$seq","localvar":"my","kind":13,"containerName":"_add_seq"},{"line":212,"name":"$self","containerName":"_add_seq","kind":13},{"line":212,"name":"_seq","containerName":"_add_seq","kind":12},{"line":212,"kind":13,"containerName":"_add_seq","name":"$id"},{"line":215,"localvar":"my","containerName":"_add_seq","kind":13,"name":"$featHandler","definition":"my"},{"name":"$self","kind":13,"containerName":"_add_seq","line":215},{"line":215,"kind":12,"containerName":"_add_seq","name":"_feat_handler"},{"line":218,"kind":13,"containerName":"_add_seq","name":"$seq"},{"line":218,"name":"seq","containerName":"_add_seq","kind":12},{"line":218,"name":"$residues","containerName":"_add_seq","kind":13},{"line":219,"name":"$seq","kind":13,"containerName":"_add_seq"},{"name":"seq_version","containerName":"_add_seq","kind":12,"line":219},{"name":"$ver","kind":13,"containerName":"_add_seq","line":219},{"line":219,"containerName":"_add_seq","kind":13,"name":"$ver"},{"line":222,"kind":13,"containerName":"_add_seq","name":"$id"},{"line":223,"kind":13,"containerName":"_add_seq","name":"$seq"},{"containerName":"_add_seq","kind":12,"name":"accession","line":223},{"line":223,"kind":13,"containerName":"_add_seq","name":"$id"},{"definition":"my","line":228,"name":"$focus","kind":13,"localvar":"my","containerName":"_add_seq"},{"kind":13,"containerName":"_add_seq","name":"$el","line":229},{"containerName":"_add_seq","kind":13,"name":"$self","line":230},{"line":230,"name":"$seq","kind":13,"containerName":"_add_seq"},{"line":231,"kind":13,"containerName":"_add_seq","name":"$focus"},{"line":235,"localvar":"my","kind":13,"containerName":"_add_seq","name":"$length","definition":"my"},{"line":235,"containerName":"_add_seq","kind":13,"name":"$el"},{"line":236,"containerName":"_add_seq","kind":13,"name":"$length"},{"line":236,"name":"$seq","kind":13,"containerName":"_add_seq"},{"line":236,"containerName":"_add_seq","kind":12,"name":"length"},{"line":236,"name":"$length","kind":13,"containerName":"_add_seq"},{"line":237,"containerName":"_add_seq","kind":13,"name":"$seq"},{"containerName":"_add_seq","kind":12,"name":"seq","line":237},{"name":"$length","containerName":"_add_seq","kind":13,"line":237},{"name":"$seq","containerName":"_add_seq","kind":13,"line":237},{"name":"length","kind":12,"containerName":"_add_seq","line":237},{"kind":13,"containerName":"_add_seq","name":"$length","line":237},{"kind":13,"containerName":"_add_seq","name":"$self","line":238},{"line":238,"name":"complain","containerName":"_add_seq","kind":12},{"line":238,"kind":13,"containerName":"_add_seq","name":"$seq"},{"containerName":"_add_seq","kind":12,"name":"length","line":238},{"line":239,"name":"$length","kind":13,"containerName":"_add_seq"},{"line":240,"name":"$seq","kind":13,"containerName":"_add_seq"},{"name":"seq","kind":12,"containerName":"_add_seq","line":240},{"line":241,"name":"$seq","containerName":"_add_seq","kind":13},{"containerName":"_add_seq","kind":12,"name":"length","line":241},{"name":"$length","containerName":"_add_seq","kind":13,"line":241},{"line":245,"containerName":"_add_seq","localvar":"my","kind":13,"name":"$tags","definition":"my"},{"line":246,"kind":13,"containerName":"_add_seq","name":"$el"},{"line":247,"name":"$tags","kind":13,"containerName":"_add_seq"},{"name":"$el","kind":13,"containerName":"_add_seq","line":247},{"line":249,"name":"$el","kind":13,"containerName":"_add_seq"},{"kind":13,"containerName":"_add_seq","name":"$tags","line":250},{"kind":13,"containerName":"_add_seq","name":"$tags","line":251},{"line":251,"name":"$self","kind":13,"containerName":"_add_seq"},{"line":251,"name":"dbxref","containerName":"_add_seq","kind":12},{"line":251,"kind":13,"containerName":"_add_seq","name":"$el"}],"containerName":"main::","name":"_add_seq","signature":{"label":"_add_seq($self,$el)","documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences\n\n\nsub _order_feats {\n    my ($self, $seqs) = @_;\n    my $seq = $self->{main_seq};\n    my $id  = $seq->id;\n    my $ann = $self->{ann_l};\n\n    # make sure source(s) come first\n    my @src   = grep { $_->primary_tag =~ /source|origin|\\bregion\\b/ } @$ann;\n    # preserve gene->mRNA->CDS or ncRNA->gene->transcript order\n    my @genes = grep { $_->primary_tag =~ /gene|CDS|[a-z]+RNA|transcript/ } @$ann;\n    my @other = sort { $a->start <=> $b->start || $b->end   <=> $a->end  } \n                grep { $_->primary_tag !~ /source|origin|\\bregion\\b/ } \n                grep { $_->primary_tag !~ /gene|mRNA|CDS/ } @$ann;\n    \n    return [$seq, [@src, @genes, @other]];\n}\n\n=head2 _add_seq\n\n Title   : _add_seq\n Usage   : $self->_add_seq($seq_element)\n Function: an internal method to process the sequence elements\n Returns : nothing\n Args    : a sequence element","parameters":[{"label":"$self"},{"label":"$el"}]},"line":189,"kind":12,"range":{"start":{"character":0,"line":189},"end":{"character":9999,"line":252}}},{"name":"_residues","kind":12,"line":193},{"name":"_residues","kind":12,"line":194},{"kind":12,"name":"Characters","line":194},{"name":"Attributes","kind":12,"line":203},{"name":"id","kind":12,"line":203},{"name":"Attributes","kind":12,"line":204},{"line":204,"name":"version","kind":12},{"line":205,"name":"_name","kind":12},{"line":205,"name":"Characters","kind":12},{"kind":12,"name":"Attributes","line":229},{"kind":12,"name":"focus","line":229},{"kind":12,"name":"main_seq","line":230},{"line":235,"name":"Attributes","kind":12},{"kind":12,"name":"Attributes","line":246},{"kind":12,"name":"md5checksum","line":246},{"name":"md5checksum","kind":12,"line":247},{"line":247,"kind":12,"name":"Attributes"},{"kind":12,"name":"md5checksum","line":247},{"name":"_dbxref","kind":12,"line":249},{"name":"dbxref","kind":12,"line":250},{"line":251,"kind":12,"name":"dbxref"},{"line":251,"name":"_dbxref","kind":12},{"line":253,"kind":13,"containerName":null,"name":"%el"},{"line":253,"name":"_description","kind":12},{"definition":"my","name":"$desc","containerName":null,"localvar":"my","kind":13,"line":254},{"name":"%el","containerName":null,"kind":13,"line":254},{"line":254,"kind":12,"name":"_description"},{"line":254,"kind":12,"name":"Characters"},{"name":"$seq","kind":13,"containerName":null,"line":255},{"name":"description","containerName":"main::","kind":12,"line":255},{"name":"$desc","containerName":null,"kind":13,"line":255},{"line":257,"containerName":null,"kind":13,"name":"%el"},{"name":"_organism","kind":12,"line":257},{"line":258,"name":"@organism","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"%el","containerName":null,"kind":13,"line":258},{"line":258,"kind":12,"name":"_organism"},{"line":258,"kind":12,"name":"Characters"},{"line":259,"kind":13,"containerName":null,"name":"@organism"},{"name":"$self","kind":13,"containerName":null,"line":260},{"line":260,"kind":12,"containerName":"main::","name":"complain"},{"definition":"my","line":263,"localvar":"my","containerName":null,"kind":13,"name":"$species"},{"kind":12,"containerName":"Species","name":"Bio","line":263},{"containerName":"main::","kind":12,"name":"new","line":263},{"line":263,"kind":13,"containerName":null,"name":"@organism"},{"line":264,"name":"$seq","containerName":null,"kind":13},{"line":264,"name":"species","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$species","line":264},{"name":"$seq","containerName":null,"kind":13,"line":267},{"line":267,"name":"species","kind":12,"containerName":"main::"},{"name":"%tags","kind":13,"containerName":null,"line":268},{"line":268,"kind":12,"name":"organism"},{"line":268,"kind":13,"containerName":null,"name":"$seq"},{"line":268,"kind":12,"containerName":"main::","name":"species"},{"line":268,"containerName":"main::","kind":12,"name":"binomial"},{"kind":13,"localvar":"my","containerName":null,"name":"$alphabet","line":284,"definition":"my"},{"name":"%el","kind":13,"containerName":null,"line":284},{"line":284,"kind":12,"name":"Attributes"},{"kind":12,"name":"type","line":284},{"line":285,"name":"%alphabet","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$alphabet","line":286},{"line":287,"name":"$alphabet","containerName":null,"kind":13},{"name":"$seq","kind":13,"containerName":null,"line":288},{"containerName":"main::","kind":12,"name":"alphabet","line":288},{"line":288,"kind":13,"containerName":null,"name":"$alphabet"},{"containerName":null,"kind":13,"name":"%self","line":292},{"line":292,"kind":12,"name":"has_source"},{"name":"%focus","containerName":null,"kind":13,"line":292},{"name":"%focus","containerName":null,"kind":13,"line":296},{"containerName":null,"kind":13,"name":"$self","line":298},{"line":298,"kind":12,"containerName":"main::","name":"_map_position"},{"name":"%self","kind":13,"containerName":null,"line":298},{"line":298,"kind":12,"name":"map_pos"},{"name":"$seq","kind":13,"containerName":null,"line":298},{"containerName":null,"kind":13,"name":"%featHandler","line":299},{"line":299,"name":"offset","kind":12},{"line":299,"name":"%self","kind":13,"containerName":null},{"name":"offset","kind":12,"line":299},{"line":303,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"flush","line":303},{"signature":{"label":"_map_position($self,$el)","documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences\n\n\nsub _order_feats {\n    my ($self, $seqs) = @_;\n    my $seq = $self->{main_seq};\n    my $id  = $seq->id;\n    my $ann = $self->{ann_l};\n\n    # make sure source(s) come first\n    my @src   = grep { $_->primary_tag =~ /source|origin|\\bregion\\b/ } @$ann;\n    # preserve gene->mRNA->CDS or ncRNA->gene->transcript order\n    my @genes = grep { $_->primary_tag =~ /gene|CDS|[a-z]+RNA|transcript/ } @$ann;\n    my @other = sort { $a->start <=> $b->start || $b->end   <=> $a->end  } \n                grep { $_->primary_tag !~ /source|origin|\\bregion\\b/ } \n                grep { $_->primary_tag !~ /gene|mRNA|CDS/ } @$ann;\n    \n    return [$seq, [@src, @genes, @other]];\n}\n\n=head2 _add_seq\n\n Title   : _add_seq\n Usage   : $self->_add_seq($seq_element)\n Function: an internal method to process the sequence elements\n Returns : nothing\n Args    : a sequence element\n\n\nsub _add_seq {\n    my ($self, $el) = @_;\n    my $residues = '';\n\n    if ($el->{_residues}) {\n        $residues = $el->{_residues}->{Characters};\n        $residues =~ s/[ \\n\\r]//g;\n        $residues =~ s/\\!//g;\n        $residues =~ tr/a-z/A-Z/;\n    } \n    else {\n\treturn 0;\n    }\n\n    my $id   = $el->{Attributes}->{id};\n    my $ver  = $el->{Attributes}->{version};\n    my $name = $el->{_name}->{Characters};\n    \n    if ($name && $name ne $id) {\n        $self->complain(\"The sequence name and unique ID do not match.  Using ID\");\n    }\n    \n    # get/set the sequence object\n    my $seq = $self->_seq($id);\n    \n    # get/set the feature handler\n    my $featHandler = $self->_feat_handler;\n    \n    # populate the sequence object\n    $seq->seq($residues);\n    $seq->seq_version($ver) if $ver;\n    \n    # assume the id is the accession number\n    if ( $id =~ /^\\w+$/ ) {\n\t$seq->accession($id);\n    }\n    \n    # If the focus attribute is set to \"true\", this is the main\n    # sequence\n    my $focus = 0;\n    if ( defined $el->{Attributes}->{focus} ) {\n        $self->{main_seq} = $seq;\n        $focus++;\n    }\n\n    # make sure real and annotated lengths match\n    my $length = $el->{Attributes}->{'length'};\n    $length && $seq->length(int($length));\n    if ( $seq->seq && defined($length) && $seq->length != int($length) ) {\n        $self->complain(\"The specified sequence has length \", $seq->length(),\n                        \" but the length attribute= \", $length);\n        $seq->seq( undef );\n        $seq->length( int($length) );\n    }\n\n    # deal with top-level annotations\n    my $tags = {};\n    if ( $el->{Attributes}->{md5checksum} ) {\n\t$tags->{md5checksum} = [$el->{Attributes}->{md5checksum}];\n    }\n    if ($el->{_dbxref}) {\n\t$tags->{dbxref} ||= [];\n        push @{$tags->{dbxref}}, $self->dbxref( $el->{_dbxref} );\n    }\n    if ($el->{_description}) {\n        my $desc = $el->{_description}->{Characters};\n        $seq->description( $desc );\n    } \n    if ($el->{_organism}) {\n        my @organism = split /\\s+/, $el->{_organism}->{Characters};\n        if (@organism < 2) {\n\t    $self->complain(\"Species name should have at least two words\");\n\t}\n\telse {\n\t    my $species = Bio::Species->new( -classification => [reverse @organism] );\n\t    $seq->species($species);\n\t}\n    }\n    if ( defined($seq->species) ) {\n\t$tags->{organism} = [$seq->species->binomial];\n    }\n#    elsif ($seq eq $self->{main_seq}) {\n#\t$self->warn(\"The source organism for this sequence was\\n\" .\n#\t\t    \"not specified.  I will guess Drosophila melanogaster.\\n\" .\n#\t\t    \"Otherwise, add <organism>Genus species</organism>\\n\" .\n#\t\t    \"to the main sequence element\");\n#\tmy @class = qw/ Eukaryota Metazoa Arthropoda Insecta Pterygota\n#\t                Neoptera Endopterygota Diptera Brachycera \n#\t                Muscomorpha Ephydroidea Drosophilidae Drosophila melanogaster/;\n#\tmy $species = Bio::Species->new( -classification => [ reverse @class ],\n#\t\t\t\t\t -common_name    => 'fruit fly' );\n#\t$seq->species( $species );\n#    }\n    \n    # convert GAME to bioperl molecule types\n    my $alphabet = $el->{Attributes}->{type};\n    if ( $alphabet ) {\n        $alphabet =~ s/aa/protein/;\n\t$alphabet =~ s/cdna/rna/;\n\t$seq->alphabet($alphabet);\n    }\n\n    # add a source feature if req'd\n    if ( !$self->{has_source} && $focus ) {\n\t#$self->{source} = $featHandler->add_source($seq->length, $tags);\n    }\n    \n    if ( $focus ) {\n        # add the map position\n        $self->_map_position( $self->{map_pos}, $seq );\n        $featHandler->{offset} = $self->{offset};\n    }\n    \n    # prune the sequence from the parse tree\n    $self->flush;\n}\n\n=head2 _map_position\n\n Title   : _map_position\n Usage   : $self->_map_position($map_posn_element)\n Function: an internal method to process the <map_position> element\n Returns : nothing\n Args    : a map_position element","parameters":[{"label":"$self"},{"label":"$el"}]},"range":{"start":{"character":0,"line":316},"end":{"line":381,"character":9999}},"kind":12,"line":316,"detail":"($self,$el)","definition":"sub","containerName":"main::","name":"_map_position","children":[{"definition":"my","localvar":"my","containerName":"_map_position","kind":13,"name":"$self","line":317},{"name":"$el","containerName":"_map_position","kind":13,"line":317},{"line":320,"name":"$el","kind":13,"containerName":"_map_position"},{"kind":13,"containerName":"_map_position","name":"$self","line":321},{"kind":13,"localvar":"my","containerName":"_map_position","name":"$arm","line":327,"definition":"my"},{"kind":13,"containerName":"_map_position","name":"$el","line":327},{"definition":"my","containerName":"_map_position","localvar":"my","kind":13,"name":"$type","line":328},{"name":"$el","kind":13,"containerName":"_map_position","line":328},{"definition":"my","line":329,"containerName":"_map_position","localvar":"my","kind":13,"name":"$loc"},{"line":329,"containerName":"_map_position","kind":13,"name":"$el"},{"definition":"my","localvar":"my","kind":13,"containerName":"_map_position","name":"$start","line":330},{"containerName":"_map_position","kind":13,"name":"$loc","line":330},{"line":331,"containerName":"_map_position","localvar":"my","kind":13,"name":"$end","definition":"my"},{"containerName":"_map_position","kind":13,"name":"$loc","line":331},{"line":337,"containerName":"_map_position","kind":13,"name":"$self"},{"line":337,"kind":13,"containerName":"_map_position","name":"$start"},{"name":"$seq_id","kind":13,"localvar":"my","containerName":"_map_position","line":339,"definition":"my"},{"line":339,"containerName":"_map_position","kind":13,"name":"$el"},{"name":"$seq","containerName":"_map_position","localvar":"my","kind":13,"line":340,"definition":"my"},{"containerName":"_map_position","kind":13,"name":"$self","line":340},{"line":340,"kind":13,"containerName":"_map_position","name":"$seq_id"},{"line":342,"name":"$seq","kind":13,"containerName":"_map_position"},{"line":343,"containerName":"_map_position","kind":13,"name":"$self"},{"line":343,"name":"throw","containerName":"_map_position","kind":12},{"line":345,"containerName":"_map_position","kind":13,"name":"$seq"},{"line":345,"kind":13,"containerName":"_map_position","name":"$self"},{"line":346,"name":"$self","kind":13,"containerName":"_map_position"},{"line":346,"kind":12,"containerName":"_map_position","name":"throw"},{"definition":"my","containerName":"_map_position","localvar":"my","kind":13,"name":"$species","line":349},{"line":352,"kind":13,"containerName":"_map_position","name":"$self"},{"definition":"my","line":353,"localvar":"my","kind":13,"containerName":"_map_position","name":"$feat"},{"line":353,"name":"$self","kind":13,"containerName":"_map_position"},{"line":355,"name":"$feat","kind":13,"containerName":"_map_position"},{"line":355,"name":"has_tag","kind":12,"containerName":"_map_position"},{"containerName":"_map_position","kind":13,"name":"$species","line":356},{"containerName":"_map_position","kind":13,"name":"$seq","line":356},{"line":356,"containerName":"_map_position","kind":12,"name":"species"},{"containerName":"_map_position","kind":12,"name":"binomial","line":356},{"line":357,"name":"$feat","kind":13,"containerName":"_map_position"},{"name":"add_tag_value","containerName":"_map_position","kind":12,"line":357},{"line":357,"containerName":"_map_position","kind":13,"name":"$species"},{"line":360,"containerName":"_map_position","localvar":"my","kind":13,"name":"%tags","definition":"my"},{"line":361,"kind":13,"containerName":"_map_position","name":"$arm"},{"line":364,"name":"$type","kind":13,"containerName":"_map_position"},{"name":"%tags","kind":13,"containerName":"_map_position","line":366},{"kind":13,"containerName":"_map_position","name":"$feat","line":367},{"containerName":"_map_position","kind":12,"name":"add_tag_value","line":367},{"line":367,"name":"$tags","containerName":"_map_position","kind":13},{"line":370,"kind":13,"containerName":"_map_position","name":"$seq"},{"containerName":"_map_position","kind":12,"name":"add_SeqFeature","line":370},{"containerName":"_map_position","kind":13,"name":"$feat","line":370},{"definition":"my","line":374,"localvar":"my","kind":13,"containerName":"_map_position","name":"$desc"},{"containerName":"_map_position","kind":13,"name":"$seq","line":374},{"name":"description","kind":12,"containerName":"_map_position","line":374},{"line":375,"kind":13,"containerName":"_map_position","name":"$species"},{"kind":13,"containerName":"_map_position","name":"$arm","line":375},{"kind":13,"containerName":"_map_position","name":"$start","line":375},{"line":375,"kind":13,"containerName":"_map_position","name":"$end"},{"kind":13,"containerName":"_map_position","name":"$desc","line":375},{"name":"$seq","kind":13,"containerName":"_map_position","line":376},{"line":376,"name":"description","containerName":"_map_position","kind":12},{"kind":13,"containerName":"_map_position","name":"$self","line":380},{"kind":12,"containerName":"_map_position","name":"flush","line":380}]},{"name":"offset","kind":12,"line":321},{"kind":12,"name":"_arm","line":327},{"line":327,"kind":12,"name":"Characters"},{"line":328,"kind":12,"name":"Attributes"},{"name":"type","kind":12,"line":328},{"line":329,"name":"_span","kind":12},{"line":330,"kind":12,"name":"_start"},{"line":330,"kind":12,"name":"Characters"},{"name":"_end","kind":12,"line":331},{"line":331,"kind":12,"name":"Characters"},{"line":337,"name":"offset","kind":12},{"kind":12,"name":"Attributes","line":339},{"kind":12,"name":"seq","line":339},{"name":"seq_h","kind":12,"line":340},{"name":"main_seq","kind":12,"line":345},{"line":352,"name":"source","kind":12},{"line":353,"name":"source","kind":12},{"line":357,"name":"organism","kind":12},{"line":360,"name":"mol_type","kind":12},{"kind":12,"name":"chromosome","line":361},{"name":"location","kind":12,"line":362},{"line":363,"kind":12,"name":"type"},{"name":"_annotation","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_annotation","localvar":"my","kind":13,"line":394},{"line":394,"name":"$el","containerName":"_annotation","kind":13},{"definition":"my","line":396,"name":"$id","containerName":"_annotation","localvar":"my","kind":13},{"name":"$el","kind":13,"containerName":"_annotation","line":396},{"definition":"my","name":"$type","localvar":"my","kind":13,"containerName":"_annotation","line":397},{"line":397,"name":"$el","containerName":"_annotation","kind":13},{"name":"$tags","localvar":"my","kind":13,"containerName":"_annotation","line":398,"definition":"my"},{"kind":13,"localvar":"my","containerName":"_annotation","name":"$gname","line":399,"definition":"my"},{"line":399,"containerName":"_annotation","kind":13,"name":"$el"},{"containerName":"_annotation","kind":13,"name":"$id","line":399},{"name":"$el","containerName":"_annotation","kind":13,"line":399},{"definition":"my","name":"$seqid","kind":13,"localvar":"my","containerName":"_annotation","line":405},{"name":"$self","kind":13,"containerName":"_annotation","line":405},{"name":"id","containerName":"_annotation","kind":12,"line":405},{"line":406,"name":"$featHandler","kind":13,"localvar":"my","containerName":"_annotation","definition":"my"},{"name":"$self","kind":13,"containerName":"_annotation","line":406},{"name":"_feat_handler","containerName":"_annotation","kind":12,"line":406},{"definition":"my","line":408,"kind":13,"localvar":"my","containerName":"_annotation","name":"@feats"},{"line":410,"name":"$child","localvar":"my","kind":13,"containerName":"_annotation","definition":"my"},{"name":"$el","containerName":"_annotation","kind":13,"line":410}],"detail":"($self,$el)","definition":"sub","range":{"start":{"character":0,"line":393},"end":{"line":410,"character":9999}},"kind":12,"line":393,"signature":{"parameters":[{"label":"$self"},{"label":"$el"}],"documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences\n\n\nsub _order_feats {\n    my ($self, $seqs) = @_;\n    my $seq = $self->{main_seq};\n    my $id  = $seq->id;\n    my $ann = $self->{ann_l};\n\n    # make sure source(s) come first\n    my @src   = grep { $_->primary_tag =~ /source|origin|\\bregion\\b/ } @$ann;\n    # preserve gene->mRNA->CDS or ncRNA->gene->transcript order\n    my @genes = grep { $_->primary_tag =~ /gene|CDS|[a-z]+RNA|transcript/ } @$ann;\n    my @other = sort { $a->start <=> $b->start || $b->end   <=> $a->end  } \n                grep { $_->primary_tag !~ /source|origin|\\bregion\\b/ } \n                grep { $_->primary_tag !~ /gene|mRNA|CDS/ } @$ann;\n    \n    return [$seq, [@src, @genes, @other]];\n}\n\n=head2 _add_seq\n\n Title   : _add_seq\n Usage   : $self->_add_seq($seq_element)\n Function: an internal method to process the sequence elements\n Returns : nothing\n Args    : a sequence element\n\n\nsub _add_seq {\n    my ($self, $el) = @_;\n    my $residues = '';\n\n    if ($el->{_residues}) {\n        $residues = $el->{_residues}->{Characters};\n        $residues =~ s/[ \\n\\r]//g;\n        $residues =~ s/\\!//g;\n        $residues =~ tr/a-z/A-Z/;\n    } \n    else {\n\treturn 0;\n    }\n\n    my $id   = $el->{Attributes}->{id};\n    my $ver  = $el->{Attributes}->{version};\n    my $name = $el->{_name}->{Characters};\n    \n    if ($name && $name ne $id) {\n        $self->complain(\"The sequence name and unique ID do not match.  Using ID\");\n    }\n    \n    # get/set the sequence object\n    my $seq = $self->_seq($id);\n    \n    # get/set the feature handler\n    my $featHandler = $self->_feat_handler;\n    \n    # populate the sequence object\n    $seq->seq($residues);\n    $seq->seq_version($ver) if $ver;\n    \n    # assume the id is the accession number\n    if ( $id =~ /^\\w+$/ ) {\n\t$seq->accession($id);\n    }\n    \n    # If the focus attribute is set to \"true\", this is the main\n    # sequence\n    my $focus = 0;\n    if ( defined $el->{Attributes}->{focus} ) {\n        $self->{main_seq} = $seq;\n        $focus++;\n    }\n\n    # make sure real and annotated lengths match\n    my $length = $el->{Attributes}->{'length'};\n    $length && $seq->length(int($length));\n    if ( $seq->seq && defined($length) && $seq->length != int($length) ) {\n        $self->complain(\"The specified sequence has length \", $seq->length(),\n                        \" but the length attribute= \", $length);\n        $seq->seq( undef );\n        $seq->length( int($length) );\n    }\n\n    # deal with top-level annotations\n    my $tags = {};\n    if ( $el->{Attributes}->{md5checksum} ) {\n\t$tags->{md5checksum} = [$el->{Attributes}->{md5checksum}];\n    }\n    if ($el->{_dbxref}) {\n\t$tags->{dbxref} ||= [];\n        push @{$tags->{dbxref}}, $self->dbxref( $el->{_dbxref} );\n    }\n    if ($el->{_description}) {\n        my $desc = $el->{_description}->{Characters};\n        $seq->description( $desc );\n    } \n    if ($el->{_organism}) {\n        my @organism = split /\\s+/, $el->{_organism}->{Characters};\n        if (@organism < 2) {\n\t    $self->complain(\"Species name should have at least two words\");\n\t}\n\telse {\n\t    my $species = Bio::Species->new( -classification => [reverse @organism] );\n\t    $seq->species($species);\n\t}\n    }\n    if ( defined($seq->species) ) {\n\t$tags->{organism} = [$seq->species->binomial];\n    }\n#    elsif ($seq eq $self->{main_seq}) {\n#\t$self->warn(\"The source organism for this sequence was\\n\" .\n#\t\t    \"not specified.  I will guess Drosophila melanogaster.\\n\" .\n#\t\t    \"Otherwise, add <organism>Genus species</organism>\\n\" .\n#\t\t    \"to the main sequence element\");\n#\tmy @class = qw/ Eukaryota Metazoa Arthropoda Insecta Pterygota\n#\t                Neoptera Endopterygota Diptera Brachycera \n#\t                Muscomorpha Ephydroidea Drosophilidae Drosophila melanogaster/;\n#\tmy $species = Bio::Species->new( -classification => [ reverse @class ],\n#\t\t\t\t\t -common_name    => 'fruit fly' );\n#\t$seq->species( $species );\n#    }\n    \n    # convert GAME to bioperl molecule types\n    my $alphabet = $el->{Attributes}->{type};\n    if ( $alphabet ) {\n        $alphabet =~ s/aa/protein/;\n\t$alphabet =~ s/cdna/rna/;\n\t$seq->alphabet($alphabet);\n    }\n\n    # add a source feature if req'd\n    if ( !$self->{has_source} && $focus ) {\n\t#$self->{source} = $featHandler->add_source($seq->length, $tags);\n    }\n    \n    if ( $focus ) {\n        # add the map position\n        $self->_map_position( $self->{map_pos}, $seq );\n        $featHandler->{offset} = $self->{offset};\n    }\n    \n    # prune the sequence from the parse tree\n    $self->flush;\n}\n\n=head2 _map_position\n\n Title   : _map_position\n Usage   : $self->_map_position($map_posn_element)\n Function: an internal method to process the <map_position> element\n Returns : nothing\n Args    : a map_position element\n\n\nsub _map_position {\n    my ($self, $el) = @_;\n\n    # we can live without it\n    if ( !$el ) {\n\t$self->{offset}= 0;\n\treturn 0;\n    }\n\n\n    # chromosome and coordinates\n    my $arm   = $el->{_arm}->{Characters};\n    my $type  = $el->{Attributes}->{type};\n    my $loc   = $el->{_span};\n    my $start = $loc->{_start}->{Characters};\n    my $end   = $loc->{_end}->{Characters};\n    \n    # define the offset (may be a partial sequence)\n    # The coordinates will be relative but the CDS description\n    # coordinates may be absolute if the game-XML comes from apollo \n    # or gadfly\n    $self->{offset} = $start - 1;\n\n    my $seq_id = $el->{Attributes}->{seq};\n    my $seq = $self->{seq_h}->{$seq_id};\n    \n    unless ( $seq ) {\n        $self->throw(\"Map position with no corresponding sequence object\");\n    }\n    unless ($seq eq $self->{main_seq}){\n        $self->throw(\"Map position does not correspond to the main sequence\");\n    }\n    \n    my $species = '';\n    \n    # create/update the top-level sequence feature if req'd\n    if ( $self->{source} ) {\n\tmy $feat = $self->{source};\n    \n\tunless ($feat->has_tag('organism')) {\n\t    $species = eval {$seq->species->binomial} || 'unknown species';\n\t    $feat->add_tag_value( organism => $species );\n\t}\n    \n\tmy %tags = ( mol_type   => \"genomic dna\",\n\t\t     chromosome => $arm,\n\t\t     location   => \"$start..$end\",\n\t\t     type       => $type\n\t\t     );\n    \n\tfor (keys %tags) {\n\t    $feat->add_tag_value( $_ => $tags{$_} );\n\t}\n        \n\t$seq->add_SeqFeature($feat);\n    }\n\n    # come up with a description if there is none\n    my $desc = $seq->description;\n    if ( $species && $arm && $start && $end && !$desc) {\n\t$seq->description(\"$species chromosome $arm $start..$end \" .\n\t                  \"segment of complete sequence\");\n    }\n    \n    $self->flush;\n}\n\n=head2 _annotation\n\n Title   : _annotation\n Usage   : $self->_annotation($annotation_element)\n Function: an internal method to process <annotation> elements\n Returns : nothing\n Args    : an annotation element","label":"_annotation($self,$el)"}},{"line":396,"name":"Attributes","kind":12},{"name":"id","kind":12,"line":396},{"kind":12,"name":"_type","line":397},{"line":397,"kind":12,"name":"Characters"},{"kind":12,"name":"_name","line":399},{"kind":12,"name":"Characters","line":399},{"line":399,"kind":12,"name":"_name"},{"kind":12,"name":"Characters","line":399},{"name":"main_seq","kind":12,"line":405},{"name":"Children","kind":12,"line":410},{"line":411,"containerName":null,"localvar":"my","kind":13,"name":"$name","definition":"my"},{"containerName":null,"kind":13,"name":"%child","line":411},{"name":"Name","kind":12,"line":411},{"containerName":null,"kind":13,"name":"%name","line":414},{"line":415,"containerName":null,"kind":13,"name":"%tags"},{"line":415,"kind":12,"name":"dbxref"},{"name":"%tags","containerName":null,"kind":13,"line":416},{"line":416,"kind":12,"name":"dbxref"},{"name":"$self","containerName":null,"kind":13,"line":416},{"containerName":"main::","kind":12,"name":"dbxref","line":416},{"line":416,"containerName":null,"kind":13,"name":"$child"},{"line":418,"kind":13,"containerName":null,"name":"%name"},{"name":"%tags","kind":13,"containerName":null,"line":419},{"line":419,"name":"dbxref","kind":12},{"line":420,"name":"%tags","containerName":null,"kind":13},{"kind":12,"name":"dbxref","line":420},{"line":420,"containerName":null,"kind":13,"name":"$self"},{"line":420,"kind":12,"containerName":"main::","name":"dbxref"},{"containerName":null,"kind":13,"name":"%child","line":420},{"name":"_dbxref","kind":12,"line":420},{"line":422,"name":"%name","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@feats","line":423},{"containerName":null,"kind":13,"name":"$featHandler","line":423},{"containerName":"main::","kind":12,"name":"feature_set","line":423},{"line":423,"name":"$id","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$gname","line":423},{"line":423,"name":"$child","kind":13,"containerName":null},{"line":423,"containerName":null,"kind":13,"name":"$type"},{"line":425,"name":"%name","kind":13,"containerName":null},{"line":426,"name":"%tags","containerName":null,"kind":13},{"kind":12,"name":"comment","line":426},{"name":"$self","containerName":null,"kind":13,"line":426},{"name":"comment","containerName":"main::","kind":12,"line":426},{"name":"$child","kind":13,"containerName":null,"line":426},{"containerName":null,"kind":13,"name":"%name","line":428},{"kind":13,"containerName":null,"name":"$self","line":429},{"kind":12,"containerName":"main::","name":"property","line":429},{"line":429,"kind":13,"containerName":null,"name":"$child"},{"kind":13,"containerName":null,"name":"$tags","line":429},{"line":431,"containerName":null,"kind":13,"name":"%name"},{"line":434,"name":"$featHandler","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"has_gene","line":434},{"line":434,"name":"$child","kind":13,"containerName":null},{"line":434,"name":"$gname","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$id","line":434},{"name":"%name","kind":13,"containerName":null,"line":441},{"line":442,"name":"%tags","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@name","line":442},{"line":442,"name":"%child","containerName":null,"kind":13},{"kind":12,"name":"Characters","line":442},{"name":"%name","containerName":null,"kind":13,"line":444},{"line":445,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"complain","line":445},{"kind":13,"containerName":null,"name":"$featHandler","line":453},{"line":453,"kind":12,"containerName":"main::","name":"has_gene"},{"containerName":null,"kind":13,"name":"%type","line":453},{"line":454,"containerName":null,"kind":13,"name":"$featHandler"},{"name":"has_gene","containerName":"main::","kind":12,"line":454},{"line":454,"name":"$el","kind":13,"containerName":null},{"line":454,"name":"$gname","kind":13,"containerName":null},{"name":"$id","kind":13,"containerName":null,"line":454},{"line":457,"containerName":null,"kind":13,"name":"%tags"},{"kind":12,"name":"symbol","line":457},{"name":"%tags","kind":13,"containerName":null,"line":458},{"line":458,"name":"gene","kind":12},{"name":"%tags","kind":13,"containerName":null,"line":459},{"kind":12,"name":"gene","line":459},{"line":459,"name":"%tags","kind":13,"containerName":null},{"kind":12,"name":"symbol","line":459},{"containerName":null,"kind":13,"name":"%tags","line":461},{"kind":12,"name":"symbol","line":461},{"name":"$featHandler","kind":13,"containerName":null,"line":465},{"line":465,"name":"add_annotation","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"%self","line":465},{"line":465,"kind":12,"name":"main_seq"},{"line":465,"name":"$type","containerName":null,"kind":13},{"line":465,"name":"$id","containerName":null,"kind":13},{"line":465,"containerName":null,"kind":13,"name":"$tags"},{"line":465,"kind":13,"containerName":null,"name":"@feats"},{"line":466,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"flush","line":466},{"line":481,"kind":12,"range":{"end":{"character":9999,"line":495},"start":{"character":0,"line":481}},"signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: seqHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::game::seqHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::game::seqHandler -- a class for handling game-XML sequences\n\n=head1 SYNOPSIS\n\nThis modules is not used directly\n\n=head1 DESCRIPTION\n\nBio::SeqIO::game::seqHandler processes all of the sequences associated with a game record\nand, via feature handlers, processes the associated annotations\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\nto one of the Bioperl mailing lists.\n\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::SeqIO::game::seqHandler;\n\nuse Data::Dumper;\n\nuse Bio::SeqIO::game::featHandler;\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::RichSeq;\nuse Bio::Species;\nuse strict;\n\nuse vars qw {};\n\nuse base qw(Bio::SeqIO::game::gameSubs);\n\n=head2 new\n\n Title   : new\n Usage   : my $seqHandler = Bio::SeqIO::game::seqHandler->new($seq, $ann, $comp, $map, $src )\n Function: constructor method to create a sequence handler\n Returns : a sequence handler object\n Args    : $seq  -- an XML sequence element\n           $ann  -- a ref. to a list of <annotation> elements\n           $comp -- a ref. to a list of <computational_analysis> elements (not used yet)\n           $map  -- a <map_position> element\n           $src  -- a flag to indicate that the sequence already has a source feature\n\n\nsub new {\n    my ($caller, $seq, $ann, $comp, $map, $src ) =  @_;\n\n    my $class = ref($caller) || $caller;\n\n    my $self = bless ( { \n\tseqs     => $seq,\n        anns     => $ann,\n        comps    => $comp,\n        map_pos  => $map,\n\thas_source => $src,\n        seq_h    => {},\n\tann_l    => []\n    }, $class );\n\n    return $self;\n}\n\n=head2 convert\n\n Title   : convert\n Usage   : @seqs = $seqHandler->convert\n Function: converts the main XML sequence element and associated annotations to Bio::\n Returns : a ref. to a an array containing the sequence object and a ref. to a list of  features\n Args    : none\n\n Note    : The features and sequence are kept apart to facilitate downstream filtering of features \n\n\nsub convert {\n    my $self = shift;\n    my @ann  = @{$self->{anns}} if defined $self->{anns};;\n    my @seq  = @{$self->{seqs}};\n    \n    # not used yet\n    my @comp;\n    if ( $self->{comps} ) {\n        @comp = @{$self->{comps}}    \n    }\n    \n    # process the sequence elements\n    for ( @seq ) {\n\t$self->_add_seq( $_ );\n    }\n    \n    # process the annotation elements\n    for ( @ann ) {\n\t$self->_annotation( $_ );\n    }\n    \n    return $self->_order_feats( $self->{seq_h} );\n}\n\n=head2 _order_feats\n\n Title   : _order_feats\n Usage   : $self->_order_feats( $self->{seq_h} )\n Function: an internal method to ensure the source feature comes first\n           and keep gene, mRNA and CDS features together \n Returns : a ref. to an array containing the sequence object and a ref. to a list of  features \n Args    : a ref. to a hash of sequences\n\n\nsub _order_feats {\n    my ($self, $seqs) = @_;\n    my $seq = $self->{main_seq};\n    my $id  = $seq->id;\n    my $ann = $self->{ann_l};\n\n    # make sure source(s) come first\n    my @src   = grep { $_->primary_tag =~ /source|origin|\\bregion\\b/ } @$ann;\n    # preserve gene->mRNA->CDS or ncRNA->gene->transcript order\n    my @genes = grep { $_->primary_tag =~ /gene|CDS|[a-z]+RNA|transcript/ } @$ann;\n    my @other = sort { $a->start <=> $b->start || $b->end   <=> $a->end  } \n                grep { $_->primary_tag !~ /source|origin|\\bregion\\b/ } \n                grep { $_->primary_tag !~ /gene|mRNA|CDS/ } @$ann;\n    \n    return [$seq, [@src, @genes, @other]];\n}\n\n=head2 _add_seq\n\n Title   : _add_seq\n Usage   : $self->_add_seq($seq_element)\n Function: an internal method to process the sequence elements\n Returns : nothing\n Args    : a sequence element\n\n\nsub _add_seq {\n    my ($self, $el) = @_;\n    my $residues = '';\n\n    if ($el->{_residues}) {\n        $residues = $el->{_residues}->{Characters};\n        $residues =~ s/[ \\n\\r]//g;\n        $residues =~ s/\\!//g;\n        $residues =~ tr/a-z/A-Z/;\n    } \n    else {\n\treturn 0;\n    }\n\n    my $id   = $el->{Attributes}->{id};\n    my $ver  = $el->{Attributes}->{version};\n    my $name = $el->{_name}->{Characters};\n    \n    if ($name && $name ne $id) {\n        $self->complain(\"The sequence name and unique ID do not match.  Using ID\");\n    }\n    \n    # get/set the sequence object\n    my $seq = $self->_seq($id);\n    \n    # get/set the feature handler\n    my $featHandler = $self->_feat_handler;\n    \n    # populate the sequence object\n    $seq->seq($residues);\n    $seq->seq_version($ver) if $ver;\n    \n    # assume the id is the accession number\n    if ( $id =~ /^\\w+$/ ) {\n\t$seq->accession($id);\n    }\n    \n    # If the focus attribute is set to \"true\", this is the main\n    # sequence\n    my $focus = 0;\n    if ( defined $el->{Attributes}->{focus} ) {\n        $self->{main_seq} = $seq;\n        $focus++;\n    }\n\n    # make sure real and annotated lengths match\n    my $length = $el->{Attributes}->{'length'};\n    $length && $seq->length(int($length));\n    if ( $seq->seq && defined($length) && $seq->length != int($length) ) {\n        $self->complain(\"The specified sequence has length \", $seq->length(),\n                        \" but the length attribute= \", $length);\n        $seq->seq( undef );\n        $seq->length( int($length) );\n    }\n\n    # deal with top-level annotations\n    my $tags = {};\n    if ( $el->{Attributes}->{md5checksum} ) {\n\t$tags->{md5checksum} = [$el->{Attributes}->{md5checksum}];\n    }\n    if ($el->{_dbxref}) {\n\t$tags->{dbxref} ||= [];\n        push @{$tags->{dbxref}}, $self->dbxref( $el->{_dbxref} );\n    }\n    if ($el->{_description}) {\n        my $desc = $el->{_description}->{Characters};\n        $seq->description( $desc );\n    } \n    if ($el->{_organism}) {\n        my @organism = split /\\s+/, $el->{_organism}->{Characters};\n        if (@organism < 2) {\n\t    $self->complain(\"Species name should have at least two words\");\n\t}\n\telse {\n\t    my $species = Bio::Species->new( -classification => [reverse @organism] );\n\t    $seq->species($species);\n\t}\n    }\n    if ( defined($seq->species) ) {\n\t$tags->{organism} = [$seq->species->binomial];\n    }\n#    elsif ($seq eq $self->{main_seq}) {\n#\t$self->warn(\"The source organism for this sequence was\\n\" .\n#\t\t    \"not specified.  I will guess Drosophila melanogaster.\\n\" .\n#\t\t    \"Otherwise, add <organism>Genus species</organism>\\n\" .\n#\t\t    \"to the main sequence element\");\n#\tmy @class = qw/ Eukaryota Metazoa Arthropoda Insecta Pterygota\n#\t                Neoptera Endopterygota Diptera Brachycera \n#\t                Muscomorpha Ephydroidea Drosophilidae Drosophila melanogaster/;\n#\tmy $species = Bio::Species->new( -classification => [ reverse @class ],\n#\t\t\t\t\t -common_name    => 'fruit fly' );\n#\t$seq->species( $species );\n#    }\n    \n    # convert GAME to bioperl molecule types\n    my $alphabet = $el->{Attributes}->{type};\n    if ( $alphabet ) {\n        $alphabet =~ s/aa/protein/;\n\t$alphabet =~ s/cdna/rna/;\n\t$seq->alphabet($alphabet);\n    }\n\n    # add a source feature if req'd\n    if ( !$self->{has_source} && $focus ) {\n\t#$self->{source} = $featHandler->add_source($seq->length, $tags);\n    }\n    \n    if ( $focus ) {\n        # add the map position\n        $self->_map_position( $self->{map_pos}, $seq );\n        $featHandler->{offset} = $self->{offset};\n    }\n    \n    # prune the sequence from the parse tree\n    $self->flush;\n}\n\n=head2 _map_position\n\n Title   : _map_position\n Usage   : $self->_map_position($map_posn_element)\n Function: an internal method to process the <map_position> element\n Returns : nothing\n Args    : a map_position element\n\n\nsub _map_position {\n    my ($self, $el) = @_;\n\n    # we can live without it\n    if ( !$el ) {\n\t$self->{offset}= 0;\n\treturn 0;\n    }\n\n\n    # chromosome and coordinates\n    my $arm   = $el->{_arm}->{Characters};\n    my $type  = $el->{Attributes}->{type};\n    my $loc   = $el->{_span};\n    my $start = $loc->{_start}->{Characters};\n    my $end   = $loc->{_end}->{Characters};\n    \n    # define the offset (may be a partial sequence)\n    # The coordinates will be relative but the CDS description\n    # coordinates may be absolute if the game-XML comes from apollo \n    # or gadfly\n    $self->{offset} = $start - 1;\n\n    my $seq_id = $el->{Attributes}->{seq};\n    my $seq = $self->{seq_h}->{$seq_id};\n    \n    unless ( $seq ) {\n        $self->throw(\"Map position with no corresponding sequence object\");\n    }\n    unless ($seq eq $self->{main_seq}){\n        $self->throw(\"Map position does not correspond to the main sequence\");\n    }\n    \n    my $species = '';\n    \n    # create/update the top-level sequence feature if req'd\n    if ( $self->{source} ) {\n\tmy $feat = $self->{source};\n    \n\tunless ($feat->has_tag('organism')) {\n\t    $species = eval {$seq->species->binomial} || 'unknown species';\n\t    $feat->add_tag_value( organism => $species );\n\t}\n    \n\tmy %tags = ( mol_type   => \"genomic dna\",\n\t\t     chromosome => $arm,\n\t\t     location   => \"$start..$end\",\n\t\t     type       => $type\n\t\t     );\n    \n\tfor (keys %tags) {\n\t    $feat->add_tag_value( $_ => $tags{$_} );\n\t}\n        \n\t$seq->add_SeqFeature($feat);\n    }\n\n    # come up with a description if there is none\n    my $desc = $seq->description;\n    if ( $species && $arm && $start && $end && !$desc) {\n\t$seq->description(\"$species chromosome $arm $start..$end \" .\n\t                  \"segment of complete sequence\");\n    }\n    \n    $self->flush;\n}\n\n=head2 _annotation\n\n Title   : _annotation\n Usage   : $self->_annotation($annotation_element)\n Function: an internal method to process <annotation> elements\n Returns : nothing\n Args    : an annotation element\n\n\nsub _annotation {\n    my ($self, $el) = @_;\n\n    my $id      = $el->{Attributes}->{id};\n    my $type    = $el->{_type}->{Characters};\n    my $tags    = {};\n    my $gname   = $el->{_name}->{Characters} eq $id ? '' : $el->{_name}->{Characters};\n\n    # 'transposable element' is too long (breaks Bio::SeqIO::GenBank)\n    # $type =~ s/transposable_element/repeat_region/;\n    \n    # annotations must be on the main sequence\n    my $seqid = $self->{main_seq}->id;\n    my $featHandler = $self->_feat_handler;\n    \n    my @feats = ();\n    \n    for my $child ( @{$el->{Children}} ) {\n        my $name = $child->{Name};\n\t\n\t# these elements require special handling\n\tif ( $name eq 'dbxref' ) {\n\t    $tags->{dbxref} ||= [];\n\t    push @{$tags->{dbxref}}, $self->dbxref( $child );\n\t}\n\telsif ( $name eq 'aspect' ) {\n\t    $tags->{dbxref} ||= [];\n\t    push @{$tags->{dbxref}}, $self->dbxref( $child->{_dbxref} );\n\t}\n        elsif ( $name eq 'feature_set' ) {\n            push @feats, $featHandler->feature_set( $id, $gname, $child, $type );\n\t}\n        elsif ( $name eq 'comment' ) {\n\t    $tags->{comment} = [$self->comment( $child )];\n\t}\n\telsif ( $name eq 'property' ) {\n\t    $self->property( $child, $tags );\n\t}\n\telsif ( $name eq 'gene' ) {\n\t    # we may be dealing with an annotation that is not\n\t    # a gene, so we have to nest the gene inside it\n\t    $featHandler->has_gene( $child, $gname, $id )\n        }\n        \n\t# otherwise, tag/value pairs\n\t# -- mild dtd enforcement\n\t# synonym is not in the dtd but shows up in gadfly\n\t# annotations\t\n\telsif ( $name =~ /type|synonym/ ) {\n\t    $tags->{$name} = [$child->{Characters}];\n\t}\n\telsif ( $name ne 'name' ) {\n            $self->complain(\"Unrecognized element '$name'. I don't \" .\n                            \"know what to do with $name elements in \" .\n                            \"top-level sequence annotations.\" );\n        }\n\n    }\n\t\n    # add a gene annotation if required\n    unless ( $featHandler->has_gene || $type ne 'gene' ) {\n\t$featHandler->has_gene( $el, $gname, $id )\n    }\n\n    if ( $tags->{symbol} ) {\n        if ( !$tags->{gene} ) {\n\t   $tags->{gene} = $tags->{symbol};\n\t}\n\tdelete $tags->{symbol};\n    }\n    \n    \n    $featHandler->add_annotation( $self->{main_seq}, $type, $id, $tags, \\@feats );\n    $self->flush;\n}\n\n# get/set the sequence object\n\n=head2 _seq\n\n Title   : _seq\n Usage   : my $seq = $self->_seq\n Function: an internal sequence getter/setter\n Returns : a Bio::RichSeq object\n Args    : a sequence ID","label":"_seq($self,$id)"},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_seq","kind":13,"line":482},{"line":482,"containerName":"_seq","kind":13,"name":"$id"},{"line":483,"kind":13,"containerName":"_seq","name":"$id"},{"line":483,"containerName":"_seq","kind":13,"name":"$self"},{"containerName":"_seq","kind":12,"name":"throw","line":483},{"localvar":"my","kind":13,"containerName":"_seq","name":"$seq","line":485,"definition":"my"},{"line":487,"name":"$self","containerName":"_seq","kind":13},{"line":487,"kind":13,"containerName":"_seq","name":"$id"},{"kind":13,"containerName":"_seq","name":"$seq","line":488},{"kind":13,"containerName":"_seq","name":"$self","line":488},{"line":488,"containerName":"_seq","kind":13,"name":"$id"},{"line":490,"name":"$seq","kind":13,"containerName":"_seq"},{"line":490,"containerName":"_seq","kind":12,"name":"new"},{"name":"$id","containerName":"_seq","kind":13,"line":490},{"name":"$self","kind":13,"containerName":"_seq","line":491},{"containerName":"_seq","kind":13,"name":"$id","line":491},{"kind":13,"containerName":"_seq","name":"$seq","line":491},{"name":"$seq","kind":13,"containerName":"_seq","line":494}],"containerName":"main::","name":"_seq","definition":"sub","detail":"($self,$id)"},{"line":487,"name":"seq_h","kind":12},{"kind":12,"name":"seq_h","line":488},{"line":490,"name":"Bio","containerName":"Seq::RichSeq","kind":12},{"line":491,"name":"seq_h","kind":12},{"children":[{"name":"$self","localvar":"my","containerName":"_feat_handler","kind":13,"line":510,"definition":"my"},{"line":512,"kind":13,"localvar":"my","containerName":"_feat_handler","name":"$handler","definition":"my"},{"definition":"my","line":513,"name":"$seq","containerName":"_feat_handler","localvar":"my","kind":13},{"line":513,"containerName":"_feat_handler","kind":13,"name":"$self"},{"containerName":"_feat_handler","kind":13,"name":"$self","line":515},{"containerName":"_feat_handler","kind":13,"name":"$handler","line":516},{"containerName":"_feat_handler","kind":13,"name":"$self","line":516},{"definition":"my","name":"@args","containerName":"_feat_handler","localvar":"my","kind":13,"line":519},{"kind":13,"containerName":"_feat_handler","name":"$seq","line":519},{"name":"$self","containerName":"_feat_handler","kind":13,"line":519},{"line":519,"name":"$self","kind":13,"containerName":"_feat_handler"},{"line":520,"name":"$handler","containerName":"_feat_handler","kind":13},{"line":520,"name":"new","containerName":"_feat_handler","kind":12},{"line":520,"kind":13,"containerName":"_feat_handler","name":"@args"},{"kind":13,"containerName":"_feat_handler","name":"$self","line":521},{"line":521,"kind":13,"containerName":"_feat_handler","name":"$handler"},{"line":524,"name":"$handler","kind":13,"containerName":"_feat_handler"}],"name":"_feat_handler","containerName":"main::","definition":"sub","line":509,"kind":12,"range":{"end":{"line":525,"character":9999},"start":{"line":509,"character":0}}},{"line":513,"name":"main_seq","kind":12},{"line":515,"name":"feat_handler","kind":12},{"kind":12,"name":"feat_handler","line":516},{"kind":12,"name":"seq_h","line":519},{"line":519,"kind":12,"name":"ann_l"},{"name":"Bio","containerName":"SeqIO::game::featHandler","kind":12,"line":520},{"line":521,"kind":12,"name":"feat_handler"}],"version":5}