{"version":5,"vars":[{"kind":2,"containerName":"","name":"vars","line":78},{"kind":2,"containerName":"","name":"base","line":84},{"line":86,"kind":13,"containerName":null,"name":"@SEQ_ID_TYPES"},{"name":"%DEFAULT_SEQ_ID_TYPE","containerName":null,"kind":13,"line":87},{"line":89,"name":"$WIDTH","kind":13,"containerName":null},{"containerName":"main::","name":"_initialize","children":[{"definition":"my","line":92,"containerName":"_initialize","localvar":"my","kind":13,"name":"$self"},{"name":"@args","containerName":"_initialize","kind":13,"line":92},{"line":93,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":13,"containerName":"_initialize","name":"@args","line":93},{"line":94,"name":"$width","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"_initialize","line":94},{"line":94,"name":"_rearrange","kind":12,"containerName":"_initialize"},{"line":94,"name":"@args","containerName":"_initialize","kind":13},{"line":95,"kind":13,"containerName":"_initialize","name":"$width"},{"name":"$self","containerName":"_initialize","kind":13,"line":95},{"line":95,"name":"width","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$width","line":95},{"kind":13,"containerName":"_initialize","name":"$self","line":96},{"line":96,"kind":12,"containerName":"_initialize","name":"sequence_factory"},{"line":97,"containerName":"_initialize","kind":13,"name":"$self"},{"line":97,"name":"sequence_factory","kind":12,"containerName":"_initialize"},{"line":97,"kind":12,"containerName":"_initialize","name":"new"}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":99},"start":{"character":0,"line":91}},"line":91,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"}},{"containerName":"_initialize","kind":12,"name":"SUPER","line":93},{"line":97,"containerName":"Seq::SeqFastaSpeedFactory","kind":12,"name":"Bio"},{"signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::fasta - fasta sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: birney@ebi.ac.uk\n       lstein@cshl.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::fasta;\nuse vars qw($WIDTH @SEQ_ID_TYPES $DEFAULT_SEQ_ID_TYPE);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::SeqIO);\n\n@SEQ_ID_TYPES = qw(accession accession.version display primary);\n$DEFAULT_SEQ_ID_TYPE = 'display';\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n  unless ( defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object, or nothing if no more available\n Args    : NONE"},"line":111,"range":{"end":{"character":9999,"line":180},"start":{"character":0,"line":111}},"kind":12,"definition":"sub","detail":"($self)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_seq","line":112,"definition":"my"},{"definition":"my","line":113,"name":"$seq","localvar":"my","kind":13,"containerName":"next_seq"},{"definition":"my","name":"$alphabet","kind":13,"localvar":"my","containerName":"next_seq","line":114},{"localvar":"my","containerName":"next_seq","kind":13,"name":"$entry","line":116,"definition":"my"},{"line":116,"kind":13,"containerName":"next_seq","name":"$self"},{"line":116,"kind":12,"containerName":"next_seq","name":"_readline"},{"line":118,"containerName":"next_seq","kind":13,"name":"$entry"},{"line":119,"containerName":"next_seq","kind":13,"name":"$entry"},{"kind":13,"containerName":"next_seq","name":"$entry","line":120},{"line":120,"name":"$self","kind":13,"containerName":"next_seq"},{"line":120,"name":"_readline","containerName":"next_seq","kind":12},{"name":"$entry","containerName":"next_seq","kind":13,"line":121},{"line":126,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"throw","containerName":"next_seq","kind":12,"line":126},{"line":127,"name":"$entry","kind":13,"containerName":"next_seq"},{"line":129,"name":"$entry","kind":13,"containerName":"next_seq"},{"line":131,"localvar":"my","containerName":"next_seq","kind":13,"name":"$top","definition":"my"},{"name":"$sequence","containerName":"next_seq","kind":13,"line":131},{"kind":13,"containerName":"next_seq","name":"$entry","line":131},{"kind":13,"containerName":"next_seq","name":"$sequence","line":132},{"line":132,"kind":13,"containerName":"next_seq","name":"$sequence"},{"definition":"my","line":136,"name":"$id","kind":13,"localvar":"my","containerName":"next_seq"},{"line":136,"containerName":"next_seq","kind":13,"name":"$fulldesc"},{"name":"$top","kind":13,"containerName":"next_seq","line":137},{"containerName":"next_seq","kind":13,"name":"$id","line":138},{"kind":13,"containerName":"next_seq","name":"$fulldesc","line":138},{"line":141,"kind":13,"containerName":"next_seq","name":"$id"},{"name":"$id","containerName":"next_seq","kind":13,"line":141},{"line":141,"containerName":"next_seq","kind":13,"name":"$id"},{"line":141,"kind":13,"containerName":"next_seq","name":"$fulldesc"},{"line":143,"name":"$sequence","kind":13,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$sequence","line":143},{"line":146,"name":"$alphabet","kind":13,"containerName":"next_seq"},{"line":146,"name":"$self","containerName":"next_seq","kind":13},{"line":146,"containerName":"next_seq","kind":12,"name":"alphabet"},{"line":147,"name":"$sequence","kind":13,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$sequence","line":147},{"line":148,"name":"$alphabet","kind":13,"containerName":"next_seq"},{"kind":13,"containerName":"next_seq","name":"$alphabet","line":150},{"line":159,"containerName":"next_seq","kind":13,"name":"$seq"},{"line":159,"kind":13,"containerName":"next_seq","name":"$self"},{"line":159,"containerName":"next_seq","kind":12,"name":"sequence_factory"},{"line":159,"kind":12,"containerName":"next_seq","name":"create"},{"line":160,"kind":13,"containerName":"next_seq","name":"$sequence"},{"line":161,"containerName":"next_seq","kind":13,"name":"$id"},{"line":165,"containerName":"next_seq","kind":13,"name":"$fulldesc"},{"line":166,"name":"$alphabet","kind":13,"containerName":"next_seq"},{"line":178,"containerName":"next_seq","kind":13,"name":"$seq"}],"name":"next_seq","containerName":"main::"},{"children":[{"definition":"my","line":193,"localvar":"my","kind":13,"containerName":"write_seq","name":"$self"},{"line":193,"name":"@seq","containerName":"write_seq","kind":13},{"line":194,"name":"$width","containerName":"write_seq","localvar":"my","kind":13,"definition":"my"},{"line":194,"containerName":"write_seq","kind":13,"name":"$self"},{"line":194,"name":"width","kind":12,"containerName":"write_seq"},{"definition":"my","name":"$seq","containerName":"write_seq","localvar":"my","kind":13,"line":195},{"line":195,"kind":13,"containerName":"write_seq","name":"@seq"},{"containerName":"write_seq","kind":13,"name":"$self","line":196},{"line":196,"name":"throw","containerName":"write_seq","kind":12},{"line":197,"name":"$seq","kind":13,"containerName":"write_seq"},{"kind":13,"containerName":"write_seq","name":"$seq","line":197},{"line":197,"containerName":"write_seq","kind":13,"name":"$seq"},{"containerName":"write_seq","kind":12,"name":"isa","line":197},{"name":"$top","kind":13,"localvar":"my","containerName":"write_seq","line":199,"definition":"my"},{"line":202,"name":"$id_type","localvar":"my","containerName":"write_seq","kind":13,"definition":"my"},{"line":202,"kind":13,"containerName":"write_seq","name":"$self"},{"line":202,"containerName":"write_seq","kind":12,"name":"preferred_id_type"},{"kind":13,"containerName":"write_seq","name":"$id_type","line":203},{"kind":13,"containerName":"write_seq","name":"$top","line":204},{"containerName":"write_seq","kind":13,"name":"$seq","line":204},{"containerName":"write_seq","kind":12,"name":"accession_number","line":204},{"name":"$id_type","containerName":"write_seq","kind":13,"line":205},{"line":206,"kind":13,"containerName":"write_seq","name":"$top"},{"line":206,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":206,"name":"version","kind":12,"containerName":"write_seq"},{"line":208,"name":"$id_type","kind":13,"containerName":"write_seq"},{"kind":13,"containerName":"write_seq","name":"$self","line":209},{"kind":12,"containerName":"write_seq","name":"warn","line":209},{"line":209,"name":"$seq","kind":13,"containerName":"write_seq"},{"line":209,"containerName":"write_seq","kind":12,"name":"display_id"},{"line":210,"name":"$seq","containerName":"write_seq","kind":13},{"line":210,"containerName":"write_seq","kind":12,"name":"display_id"},{"kind":13,"containerName":"write_seq","name":"$seq","line":210},{"containerName":"write_seq","kind":12,"name":"display_id","line":210},{"containerName":"write_seq","kind":13,"name":"$top","line":211},{"kind":13,"containerName":"write_seq","name":"$seq","line":211},{"containerName":"write_seq","kind":12,"name":"display_id","line":211},{"line":212,"name":"$top","kind":13,"containerName":"write_seq"},{"name":"$top","containerName":"write_seq","kind":13,"line":212},{"name":"$self","kind":13,"containerName":"write_seq","line":213},{"name":"warn","kind":12,"containerName":"write_seq","line":213},{"line":213,"name":"$top","containerName":"write_seq","kind":13},{"line":214,"kind":13,"containerName":"write_seq","name":"$top"},{"containerName":"write_seq","kind":13,"name":"$top","line":214},{"name":"$id_type","containerName":"write_seq","kind":13,"line":215},{"line":216,"kind":13,"containerName":"write_seq","name":"$top"},{"name":"$seq","kind":13,"containerName":"write_seq","line":216},{"containerName":"write_seq","kind":12,"name":"primary_id","line":216},{"name":"$seq","containerName":"write_seq","kind":13,"line":219},{"name":"can","containerName":"write_seq","kind":12,"line":219},{"line":219,"name":"$desc","containerName":"write_seq","localvar":"my","kind":13,"definition":"my"},{"line":219,"kind":13,"containerName":"write_seq","name":"$seq"},{"line":219,"kind":12,"containerName":"write_seq","name":"desc"},{"line":220,"kind":13,"containerName":"write_seq","name":"$desc"},{"line":221,"containerName":"write_seq","kind":13,"name":"$top"},{"line":224,"kind":13,"containerName":"write_seq","name":"$seq"},{"name":"isa","kind":12,"containerName":"write_seq","line":224},{"name":"$self","kind":13,"containerName":"write_seq","line":225},{"name":"_print","kind":12,"containerName":"write_seq","line":225},{"definition":"my","name":"$buff_max","localvar":"my","kind":13,"containerName":"write_seq","line":229},{"definition":"my","line":230,"containerName":"write_seq","localvar":"my","kind":13,"name":"$buff_size"},{"line":230,"name":"$buff_max","containerName":"write_seq","kind":13},{"kind":13,"containerName":"write_seq","name":"$width","line":230},{"name":"$width","containerName":"write_seq","kind":13,"line":230},{"kind":13,"localvar":"my","containerName":"write_seq","name":"$seq_length","line":231,"definition":"my"},{"line":231,"name":"$seq","containerName":"write_seq","kind":13},{"line":231,"containerName":"write_seq","kind":12,"name":"length"},{"line":232,"kind":13,"localvar":"my","containerName":"write_seq","name":"$num_chunks","definition":"my"},{"line":232,"name":"$seq_length","containerName":"write_seq","kind":13},{"line":232,"containerName":"write_seq","kind":13,"name":"$buff_size"},{"line":233,"kind":13,"localvar":"my","containerName":"write_seq","name":"$c","definition":"my"},{"name":"$c","containerName":"write_seq","kind":13,"line":233},{"containerName":"write_seq","kind":13,"name":"$num_chunks","line":233},{"name":"$c","kind":13,"containerName":"write_seq","line":233},{"definition":"my","name":"$buff_end","containerName":"write_seq","localvar":"my","kind":13,"line":234},{"kind":13,"containerName":"write_seq","name":"$buff_size","line":234},{"line":234,"name":"$c","containerName":"write_seq","kind":13},{"line":235,"name":"$buff_end","containerName":"write_seq","kind":13},{"line":235,"containerName":"write_seq","kind":13,"name":"$seq_length"},{"line":235,"name":"$buff_end","kind":13,"containerName":"write_seq"},{"name":"$seq_length","kind":13,"containerName":"write_seq","line":235},{"definition":"my","line":236,"kind":13,"localvar":"my","containerName":"write_seq","name":"$buff"},{"kind":13,"containerName":"write_seq","name":"$seq","line":236},{"name":"subseq","kind":12,"containerName":"write_seq","line":236},{"name":"$buff_size","kind":13,"containerName":"write_seq","line":236},{"line":236,"containerName":"write_seq","kind":13,"name":"$c"},{"line":236,"name":"$buff_end","containerName":"write_seq","kind":13},{"containerName":"write_seq","kind":13,"name":"$buff","line":237},{"line":238,"name":"$buff","kind":13,"containerName":"write_seq"},{"line":239,"name":"$self","containerName":"write_seq","kind":13},{"line":239,"name":"_print","containerName":"write_seq","kind":12},{"line":239,"name":"$buff","kind":13,"containerName":"write_seq"},{"line":241,"name":"$self","containerName":"write_seq","kind":13},{"kind":12,"containerName":"write_seq","name":"_print","line":241},{"line":245,"name":"$str","containerName":"write_seq","localvar":"my","kind":13,"definition":"my"},{"line":245,"kind":13,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","kind":12,"name":"seq","line":245},{"line":246,"kind":13,"containerName":"write_seq","name":"$str"},{"line":246,"name":"$str","containerName":"write_seq","kind":13},{"line":247,"containerName":"write_seq","kind":13,"name":"$str"},{"name":"$str","kind":13,"containerName":"write_seq","line":249},{"line":251,"name":"$self","kind":13,"containerName":"write_seq"},{"line":251,"containerName":"write_seq","kind":12,"name":"_print"},{"line":251,"name":"$top","containerName":"write_seq","kind":13},{"name":"$str","containerName":"write_seq","kind":13,"line":251},{"containerName":"write_seq","kind":13,"name":"$self","line":255},{"kind":12,"containerName":"write_seq","name":"flush","line":255},{"kind":13,"containerName":"write_seq","name":"$self","line":255},{"line":255,"kind":12,"containerName":"write_seq","name":"_flush_on_write"},{"line":255,"name":"$self","kind":13,"containerName":"write_seq"},{"line":255,"name":"_fh","containerName":"write_seq","kind":12}],"name":"write_seq","containerName":"main::","definition":"sub","detail":"($self,@seq)","line":192,"range":{"end":{"line":257,"character":9999},"start":{"character":0,"line":192}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::fasta - fasta sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: birney@ebi.ac.uk\n       lstein@cshl.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::fasta;\nuse vars qw($WIDTH @SEQ_ID_TYPES $DEFAULT_SEQ_ID_TYPE);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::SeqIO);\n\n@SEQ_ID_TYPES = qw(accession accession.version display primary);\n$DEFAULT_SEQ_ID_TYPE = 'display';\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n  unless ( defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object, or nothing if no more available\n Args    : NONE\n\n\nsub next_seq {\n    my( $self ) = @_;\n    my $seq;\n    my $alphabet;\n    local $/ = \"\\n>\";\n    return unless my $entry = $self->_readline;\n\n    chomp($entry);\n    if ($entry =~ m/\\A\\s*\\Z/s)  { # very first one\n\treturn unless $entry = $self->_readline;\n\tchomp($entry);\n    }\n    \n    # this just checks the initial input; beyond that, due to setting $/ above,\n    # the > is part of the record separator and is removed\n    $self->throw(\"The sequence does not appear to be FASTA format \".\n        \"(lacks a descriptor line '>')\") if $. == 1 && $entry !~ /^>/;\n    \n    $entry =~ s/^>//;\n    \n    my ($top,$sequence) = split(/\\n/,$entry,2);\n    defined $sequence && $sequence =~ s/>//g;\n#    my ($top,$sequence) = $entry =~ /^>?(.+?)\\n+([^>]*)/s\n#\tor $self->throw(\"Can't parse fasta entry\");\n\n    my ($id,$fulldesc);\n    if( $top =~ /^\\s*(\\S+)\\s*(.*)/ ) {\n\t($id,$fulldesc) = ($1,$2);\n    }\n    \n    if (defined $id && $id eq '') {$id=$fulldesc;} # FIX incase no space \n                                                   # between > and name \\AE\n    defined $sequence && $sequence =~ tr/ \\t\\n\\r//d;\t# Remove whitespace\n\n    # for empty sequences we need to know the mol.type\n    $alphabet = $self->alphabet();\n    if(defined $sequence && length($sequence) == 0) {\n\tif(! defined($alphabet)) {\n\t    # let's default to dna\n\t    $alphabet = \"dna\";\n\t}\n    } else {\n\t# we don't need it really, so disable\n\t# we want to keep this if SeqIO alphabet was set by user\n\t# not sure if this could break something\n\t#$alphabet = undef;\n    }\n\n    $seq = $self->sequence_factory->create(\n\t\t\t\t\t   -seq         => $sequence,\n\t\t\t\t\t   -id          => $id,\n\t\t\t\t\t   # Ewan's note - I don't think this healthy\n\t\t\t\t\t   # but obviously to taste.\n\t\t\t\t\t   #-primary_id  => $id,\n\t\t\t\t\t   -desc        => $fulldesc,\n\t\t\t\t\t   -alphabet    => $alphabet,\n\t\t\t\t\t   -direct      => 1,\n\t\t\t\t\t   );\n\n\n\n\n    # if there wasn't one before, set the guessed type\n    #unless ( defined $alphabet ) {\n\t# don't assume that all our seqs are the same as the first one found\n\t#$self->alphabet($seq->alphabet());\n    #}\n    return $seq;\n\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: Writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of 1 or more Bio::PrimarySeqI objects","label":"write_seq($self,@seq)"}},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":272,"kind":13,"localvar":"my","containerName":"width","name":"$self"},{"line":272,"kind":13,"containerName":"width","name":"$value"},{"line":273,"name":"$value","kind":13,"containerName":"width"},{"containerName":"width","kind":13,"name":"$self","line":274},{"line":274,"name":"$value","kind":13,"containerName":"width"},{"name":"$self","kind":13,"containerName":"width","line":276},{"line":276,"name":"$WIDTH","containerName":"width","kind":13}],"containerName":"main::","name":"width","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::fasta - fasta sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: birney@ebi.ac.uk\n       lstein@cshl.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::fasta;\nuse vars qw($WIDTH @SEQ_ID_TYPES $DEFAULT_SEQ_ID_TYPE);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::SeqIO);\n\n@SEQ_ID_TYPES = qw(accession accession.version display primary);\n$DEFAULT_SEQ_ID_TYPE = 'display';\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n  unless ( defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object, or nothing if no more available\n Args    : NONE\n\n\nsub next_seq {\n    my( $self ) = @_;\n    my $seq;\n    my $alphabet;\n    local $/ = \"\\n>\";\n    return unless my $entry = $self->_readline;\n\n    chomp($entry);\n    if ($entry =~ m/\\A\\s*\\Z/s)  { # very first one\n\treturn unless $entry = $self->_readline;\n\tchomp($entry);\n    }\n    \n    # this just checks the initial input; beyond that, due to setting $/ above,\n    # the > is part of the record separator and is removed\n    $self->throw(\"The sequence does not appear to be FASTA format \".\n        \"(lacks a descriptor line '>')\") if $. == 1 && $entry !~ /^>/;\n    \n    $entry =~ s/^>//;\n    \n    my ($top,$sequence) = split(/\\n/,$entry,2);\n    defined $sequence && $sequence =~ s/>//g;\n#    my ($top,$sequence) = $entry =~ /^>?(.+?)\\n+([^>]*)/s\n#\tor $self->throw(\"Can't parse fasta entry\");\n\n    my ($id,$fulldesc);\n    if( $top =~ /^\\s*(\\S+)\\s*(.*)/ ) {\n\t($id,$fulldesc) = ($1,$2);\n    }\n    \n    if (defined $id && $id eq '') {$id=$fulldesc;} # FIX incase no space \n                                                   # between > and name \\AE\n    defined $sequence && $sequence =~ tr/ \\t\\n\\r//d;\t# Remove whitespace\n\n    # for empty sequences we need to know the mol.type\n    $alphabet = $self->alphabet();\n    if(defined $sequence && length($sequence) == 0) {\n\tif(! defined($alphabet)) {\n\t    # let's default to dna\n\t    $alphabet = \"dna\";\n\t}\n    } else {\n\t# we don't need it really, so disable\n\t# we want to keep this if SeqIO alphabet was set by user\n\t# not sure if this could break something\n\t#$alphabet = undef;\n    }\n\n    $seq = $self->sequence_factory->create(\n\t\t\t\t\t   -seq         => $sequence,\n\t\t\t\t\t   -id          => $id,\n\t\t\t\t\t   # Ewan's note - I don't think this healthy\n\t\t\t\t\t   # but obviously to taste.\n\t\t\t\t\t   #-primary_id  => $id,\n\t\t\t\t\t   -desc        => $fulldesc,\n\t\t\t\t\t   -alphabet    => $alphabet,\n\t\t\t\t\t   -direct      => 1,\n\t\t\t\t\t   );\n\n\n\n\n    # if there wasn't one before, set the guessed type\n    #unless ( defined $alphabet ) {\n\t# don't assume that all our seqs are the same as the first one found\n\t#$self->alphabet($seq->alphabet());\n    #}\n    return $seq;\n\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: Writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of 1 or more Bio::PrimarySeqI objects\n\n\nsub write_seq {\n   my ($self,@seq) = @_;\n   my $width = $self->width;\n   foreach my $seq (@seq) {\n\t\t$self->throw(\"Did not provide a valid Bio::PrimarySeqI object\") \n\t\t  unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n\n\t\tmy $top;\n\n\t\t# Allow for different ids \n\t\tmy $id_type = $self->preferred_id_type;\n\t\tif( $id_type =~ /^acc/i ) {\n\t\t\t$top = $seq->accession_number();\n\t\t\tif( $id_type =~ /vers/i ) {\n\t\t\t\t$top .= \".\" . $seq->version();\n\t\t\t}\n\t\t} elsif($id_type =~ /^displ/i ) { \n\t\t\t$self->warn(\"No whitespace allowed in FASTA ID [\". $seq->display_id. \"]\")\n\t\t\t  if defined $seq->display_id && $seq->display_id =~ /\\s/;\n\t\t\t$top = $seq->display_id();\n\t\t\t$top = '' unless defined $top;\n\t\t\t$self->warn(\"No whitespace allowed in FASTA ID [\". $top. \"]\")\n\t\t\t  if defined $top && $top =~ /\\s/;\n\t\t} elsif($id_type =~ /^pri/i ) {\n\t\t\t$top = $seq->primary_id();\n\t\t}\n\n\t\tif ($seq->can('desc') and my $desc = $seq->desc()) {\n\t\t\t$desc =~ s/\\n//g;\n\t\t\t$top .= \" $desc\";\n\t\t}\n\t\t\n\t\tif( $seq->isa('Bio::Seq::LargeSeqI') ) {\n\t\t  $self->_print(\">$top\\n\");\n\t\t  # for large seqs, don't call seq(), it defeats the\n\t\t  # purpose of the largeseq functionality.  instead get\n\t\t  # chunks of the seq, $width at a time\n\t\t  my $buff_max = 2000;\n\t\t  my $buff_size = int($buff_max/$width)*$width; #< buffer is even multiple of widths\n\t\t  my $seq_length = $seq->length;\n\t\t  my $num_chunks = int($seq_length/$buff_size+1);\n\t\t  for( my $c = 0; $c < $num_chunks; $c++ ) {\n\t\t    my $buff_end = $buff_size*($c+1);\n\t\t    $buff_end = $seq_length if $buff_end > $seq_length;\n\t\t    my $buff = $seq->subseq($buff_size*$c+1,$buff_end);\n\t\t    if($buff) {\n\t\t      $buff =~ s/(.{1,$width})/$1\\n/g;\n\t\t      $self->_print($buff);\n\t\t    } else {\n\t\t      $self->_print(\"\\n\");\n\t\t    }\n\t\t  }\n\t\t} else {\n\t\t  my $str = $seq->seq;\n\t\t  if(defined $str && length($str) > 0) {\n\t\t    $str =~ s/(.{1,$width})/$1\\n/g;\n\t\t  } else {\n\t\t    $str = \"\\n\";\n\t\t  }\n\t\t  $self->_print (\">\",$top,\"\\n\",$str) or return;\n\t\t}\n   }\n\n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 width\n\n Title   : width\n Usage   : $obj->width($newval)\n Function: Get/Set the line width for FASTA output\n Returns : value of width\n Args    : newvalue (optional)","label":"width($self,$value)"},"line":271,"range":{"end":{"character":9999,"line":277},"start":{"line":271,"character":0}},"kind":12},{"line":294,"kind":12,"range":{"start":{"line":294,"character":0},"end":{"line":305,"character":9999}},"signature":{"label":"preferred_id_type($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: fasta.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::SeqIO::fasta\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#          and Lincoln Stein <lstein@cshl.org>\n#\n# Copyright Ewan Birney & Lincoln Stein\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# October 18, 1999  Largely rewritten by Lincoln Stein\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::fasta - fasta sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::SeqIO class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from fasta flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Ewan Birney & Lincoln Stein\n\nEmail: birney@ebi.ac.uk\n       lstein@cshl.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::fasta;\nuse vars qw($WIDTH @SEQ_ID_TYPES $DEFAULT_SEQ_ID_TYPE);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::Seq::SeqFastaSpeedFactory;\n\nuse base qw(Bio::SeqIO);\n\n@SEQ_ID_TYPES = qw(accession accession.version display primary);\n$DEFAULT_SEQ_ID_TYPE = 'display';\n\nBEGIN { $WIDTH = 60}\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);  \n  my ($width) = $self->_rearrange([qw(WIDTH)], @args);\n  $width && $self->width($width);\n  unless ( defined $self->sequence_factory ) {\n      $self->sequence_factory(Bio::Seq::SeqFastaSpeedFactory->new());\n  }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object, or nothing if no more available\n Args    : NONE\n\n\nsub next_seq {\n    my( $self ) = @_;\n    my $seq;\n    my $alphabet;\n    local $/ = \"\\n>\";\n    return unless my $entry = $self->_readline;\n\n    chomp($entry);\n    if ($entry =~ m/\\A\\s*\\Z/s)  { # very first one\n\treturn unless $entry = $self->_readline;\n\tchomp($entry);\n    }\n    \n    # this just checks the initial input; beyond that, due to setting $/ above,\n    # the > is part of the record separator and is removed\n    $self->throw(\"The sequence does not appear to be FASTA format \".\n        \"(lacks a descriptor line '>')\") if $. == 1 && $entry !~ /^>/;\n    \n    $entry =~ s/^>//;\n    \n    my ($top,$sequence) = split(/\\n/,$entry,2);\n    defined $sequence && $sequence =~ s/>//g;\n#    my ($top,$sequence) = $entry =~ /^>?(.+?)\\n+([^>]*)/s\n#\tor $self->throw(\"Can't parse fasta entry\");\n\n    my ($id,$fulldesc);\n    if( $top =~ /^\\s*(\\S+)\\s*(.*)/ ) {\n\t($id,$fulldesc) = ($1,$2);\n    }\n    \n    if (defined $id && $id eq '') {$id=$fulldesc;} # FIX incase no space \n                                                   # between > and name \\AE\n    defined $sequence && $sequence =~ tr/ \\t\\n\\r//d;\t# Remove whitespace\n\n    # for empty sequences we need to know the mol.type\n    $alphabet = $self->alphabet();\n    if(defined $sequence && length($sequence) == 0) {\n\tif(! defined($alphabet)) {\n\t    # let's default to dna\n\t    $alphabet = \"dna\";\n\t}\n    } else {\n\t# we don't need it really, so disable\n\t# we want to keep this if SeqIO alphabet was set by user\n\t# not sure if this could break something\n\t#$alphabet = undef;\n    }\n\n    $seq = $self->sequence_factory->create(\n\t\t\t\t\t   -seq         => $sequence,\n\t\t\t\t\t   -id          => $id,\n\t\t\t\t\t   # Ewan's note - I don't think this healthy\n\t\t\t\t\t   # but obviously to taste.\n\t\t\t\t\t   #-primary_id  => $id,\n\t\t\t\t\t   -desc        => $fulldesc,\n\t\t\t\t\t   -alphabet    => $alphabet,\n\t\t\t\t\t   -direct      => 1,\n\t\t\t\t\t   );\n\n\n\n\n    # if there wasn't one before, set the guessed type\n    #unless ( defined $alphabet ) {\n\t# don't assume that all our seqs are the same as the first one found\n\t#$self->alphabet($seq->alphabet());\n    #}\n    return $seq;\n\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq(@seq)\n Function: Writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of 1 or more Bio::PrimarySeqI objects\n\n\nsub write_seq {\n   my ($self,@seq) = @_;\n   my $width = $self->width;\n   foreach my $seq (@seq) {\n\t\t$self->throw(\"Did not provide a valid Bio::PrimarySeqI object\") \n\t\t  unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n\n\t\tmy $top;\n\n\t\t# Allow for different ids \n\t\tmy $id_type = $self->preferred_id_type;\n\t\tif( $id_type =~ /^acc/i ) {\n\t\t\t$top = $seq->accession_number();\n\t\t\tif( $id_type =~ /vers/i ) {\n\t\t\t\t$top .= \".\" . $seq->version();\n\t\t\t}\n\t\t} elsif($id_type =~ /^displ/i ) { \n\t\t\t$self->warn(\"No whitespace allowed in FASTA ID [\". $seq->display_id. \"]\")\n\t\t\t  if defined $seq->display_id && $seq->display_id =~ /\\s/;\n\t\t\t$top = $seq->display_id();\n\t\t\t$top = '' unless defined $top;\n\t\t\t$self->warn(\"No whitespace allowed in FASTA ID [\". $top. \"]\")\n\t\t\t  if defined $top && $top =~ /\\s/;\n\t\t} elsif($id_type =~ /^pri/i ) {\n\t\t\t$top = $seq->primary_id();\n\t\t}\n\n\t\tif ($seq->can('desc') and my $desc = $seq->desc()) {\n\t\t\t$desc =~ s/\\n//g;\n\t\t\t$top .= \" $desc\";\n\t\t}\n\t\t\n\t\tif( $seq->isa('Bio::Seq::LargeSeqI') ) {\n\t\t  $self->_print(\">$top\\n\");\n\t\t  # for large seqs, don't call seq(), it defeats the\n\t\t  # purpose of the largeseq functionality.  instead get\n\t\t  # chunks of the seq, $width at a time\n\t\t  my $buff_max = 2000;\n\t\t  my $buff_size = int($buff_max/$width)*$width; #< buffer is even multiple of widths\n\t\t  my $seq_length = $seq->length;\n\t\t  my $num_chunks = int($seq_length/$buff_size+1);\n\t\t  for( my $c = 0; $c < $num_chunks; $c++ ) {\n\t\t    my $buff_end = $buff_size*($c+1);\n\t\t    $buff_end = $seq_length if $buff_end > $seq_length;\n\t\t    my $buff = $seq->subseq($buff_size*$c+1,$buff_end);\n\t\t    if($buff) {\n\t\t      $buff =~ s/(.{1,$width})/$1\\n/g;\n\t\t      $self->_print($buff);\n\t\t    } else {\n\t\t      $self->_print(\"\\n\");\n\t\t    }\n\t\t  }\n\t\t} else {\n\t\t  my $str = $seq->seq;\n\t\t  if(defined $str && length($str) > 0) {\n\t\t    $str =~ s/(.{1,$width})/$1\\n/g;\n\t\t  } else {\n\t\t    $str = \"\\n\";\n\t\t  }\n\t\t  $self->_print (\">\",$top,\"\\n\",$str) or return;\n\t\t}\n   }\n\n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return 1;\n}\n\n\n=head2 width\n\n Title   : width\n Usage   : $obj->width($newval)\n Function: Get/Set the line width for FASTA output\n Returns : value of width\n Args    : newvalue (optional)\n\n\n\nsub width{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'width'} = $value;\n    }\n    return $self->{'width'} || $WIDTH;\n}\n\n=head2 preferred_id_type\n\n Title   : preferred_id_type\n Usage   : $obj->preferred_id_type('accession')\n Function: Get/Set the preferred type of identifier to use in the \">ID\" position\n           for FASTA output.\n Returns : string, one of values defined in @Bio::SeqIO::fasta::SEQ_ID_TYPES.\n           Default = $Bio::SeqIO::fasta::DEFAULT_SEQ_ID_TYPE ('display').\n Args    : string when setting. This must be one of values defined in \n           @Bio::SeqIO::fasta::SEQ_ID_TYPES. Allowable values:\n           accession, accession.version, display, primary\n Throws  : fatal exception if the supplied id type is not in @SEQ_ID_TYPES."},"children":[{"definition":"my","line":295,"localvar":"my","kind":13,"containerName":"preferred_id_type","name":"$self"},{"name":"$type","containerName":"preferred_id_type","kind":13,"line":295},{"name":"$type","kind":13,"containerName":"preferred_id_type","line":296},{"line":297,"name":"$type","containerName":"preferred_id_type","kind":13},{"kind":13,"containerName":"preferred_id_type","name":"@SEQ_ID_TYPES","line":297},{"line":298,"kind":13,"containerName":"preferred_id_type","name":"$self"},{"line":298,"containerName":"preferred_id_type","kind":12,"name":"throw"},{"line":301,"name":"$self","containerName":"preferred_id_type","kind":13},{"line":301,"name":"$type","containerName":"preferred_id_type","kind":13},{"name":"$self","kind":13,"containerName":"preferred_id_type","line":304},{"line":304,"name":"$DEFAULT_SEQ_ID_TYPE","kind":13,"containerName":"preferred_id_type"}],"name":"preferred_id_type","containerName":"main::","definition":"sub","detail":"($self,$type)"}]}