{"vars":[{"name":"vars","containerName":"","kind":2,"line":96},{"line":100,"name":"InMemoryCache","containerName":"strict::Bio::DB","kind":2},{"kind":13,"containerName":null,"name":"%HasInMemory","line":100},{"name":"$HasInMemory","kind":13,"containerName":null,"line":101},{"line":108,"name":"base","kind":2,"containerName":""},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none","label":"get_SeqFeatures($self,@args)"},"range":{"end":{"line":130,"character":9999},"start":{"line":126,"character":0}},"kind":12,"line":126,"detail":"($self,@args)","definition":"sub","name":"get_SeqFeatures","containerName":"main::","children":[{"containerName":"get_SeqFeatures","localvar":"my","kind":13,"name":"$self","line":127,"definition":"my"},{"name":"@args","containerName":"get_SeqFeatures","kind":13,"line":127},{"name":"$self","containerName":"get_SeqFeatures","kind":13,"line":129},{"name":"throw_not_implemented","containerName":"get_SeqFeatures","kind":12,"line":129}]},{"containerName":"main::","name":"display_name","children":[{"name":"throw_not_implemented","kind":12,"containerName":"display_name","line":143}],"definition":"sub","kind":12,"range":{"start":{"line":142,"character":0},"end":{"character":9999,"line":144}},"line":142},{"line":158,"kind":12,"range":{"start":{"line":158,"character":0},"end":{"line":163,"character":9999}},"signature":{"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"primary_tag($self,@args)"},"children":[{"definition":"my","line":159,"localvar":"my","kind":13,"containerName":"primary_tag","name":"$self"},{"line":159,"name":"@args","containerName":"primary_tag","kind":13},{"line":161,"kind":13,"containerName":"primary_tag","name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"primary_tag","line":161}],"containerName":"main::","name":"primary_tag","definition":"sub","detail":"($self,@args)"},{"line":177,"range":{"start":{"character":0,"line":177},"end":{"character":9999,"line":181}},"kind":12,"signature":{"label":"source_tag($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none"},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"source_tag","line":178},{"name":"@args","containerName":"source_tag","kind":13,"line":178},{"line":180,"containerName":"source_tag","kind":13,"name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"source_tag","line":180}],"containerName":"main::","name":"source_tag","definition":"sub","detail":"($self,@args)"},{"signature":{"label":"has_tag($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :"},"kind":12,"range":{"end":{"line":198,"character":9999},"start":{"line":193,"character":0}},"line":193,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"has_tag","children":[{"line":194,"name":"$self","containerName":"has_tag","localvar":"my","kind":13,"definition":"my"},{"line":194,"kind":13,"containerName":"has_tag","name":"@args"},{"line":196,"kind":13,"containerName":"has_tag","name":"$self"},{"line":196,"containerName":"has_tag","kind":12,"name":"throw_not_implemented"}]},{"children":[{"name":"throw_not_implemented","containerName":"get_tag_values","kind":12,"line":213}],"name":"get_tag_values","containerName":"main::","definition":"sub","line":212,"range":{"start":{"character":0,"line":212},"end":{"line":214,"character":9999}},"kind":12},{"line":233,"range":{"start":{"line":233,"character":0},"end":{"line":242,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\nsub has_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $self->get_tag_values('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    : a string\n\nthrows an exception if there is no such tag\n\n\nsub get_tag_values {\n    shift->throw_not_implemented();\n}\n\n=head2 get_tagset_values\n\n Title   : get_tagset_values\n Usage   : @values = $self->get_tagset_values(qw(label transcript_id product))\n Function: \n Returns : An array comprising the values of the specified tags, in order of tags\n Args    : An array of strings\n\ndoes NOT throw an exception if none of the tags are not present\n\nthis method is useful for getting a human-readable label for a\nSeqFeatureI; not all tags can be assumed to be present, so a list of\npossible tags in preferential order is provided\n\n interface + abstract method","label":"get_tagset_values($self,@args)"},"children":[{"definition":"my","line":234,"name":"$self","localvar":"my","kind":13,"containerName":"get_tagset_values"},{"containerName":"get_tagset_values","kind":13,"name":"@args","line":234},{"definition":"my","name":"@vals","localvar":"my","kind":13,"containerName":"get_tagset_values","line":235},{"definition":"my","line":236,"name":"$arg","kind":13,"localvar":"my","containerName":"get_tagset_values"},{"line":236,"name":"@args","containerName":"get_tagset_values","kind":13},{"name":"$self","containerName":"get_tagset_values","kind":13,"line":237},{"containerName":"get_tagset_values","kind":12,"name":"has_tag","line":237},{"name":"$arg","containerName":"get_tagset_values","kind":13,"line":237},{"name":"@vals","containerName":"get_tagset_values","kind":13,"line":238},{"name":"$self","containerName":"get_tagset_values","kind":13,"line":238},{"name":"get_tag_values","containerName":"get_tagset_values","kind":12,"line":238},{"line":238,"kind":13,"containerName":"get_tagset_values","name":"$arg"},{"line":241,"containerName":"get_tagset_values","kind":13,"name":"@vals"}],"name":"get_tagset_values","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"range":{"end":{"character":9999,"line":257},"start":{"line":255,"character":0}},"kind":12,"line":255,"containerName":"main::","name":"get_all_tags","children":[{"line":256,"name":"throw_not_implemented","containerName":"get_all_tags","kind":12}],"definition":"sub"},{"definition":"sub","children":[{"name":"throw_not_implemented","containerName":"attach_seq","kind":12,"line":289}],"name":"attach_seq","containerName":"main::","line":288,"kind":12,"range":{"end":{"character":9999,"line":290},"start":{"line":288,"character":0}}},{"line":306,"kind":12,"range":{"start":{"line":306,"character":0},"end":{"character":9999,"line":308}},"definition":"sub","children":[{"line":307,"containerName":"seq","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"seq"},{"definition":"sub","name":"entire_seq","containerName":"main::","children":[{"containerName":"entire_seq","kind":12,"name":"throw_not_implemented","line":324}],"kind":12,"range":{"start":{"line":323,"character":0},"end":{"character":9999,"line":325}},"line":323},{"children":[{"name":"throw_not_implemented","containerName":"seq_id","kind":12,"line":347}],"containerName":"main::","name":"seq_id","definition":"sub","line":346,"kind":12,"range":{"end":{"line":348,"character":9999},"start":{"line":346,"character":0}}},{"definition":"sub","detail":"($self,$formatter)","children":[{"line":372,"name":"$self","kind":13,"localvar":"my","containerName":"gff_string","definition":"my"},{"name":"$formatter","kind":13,"containerName":"gff_string","line":372},{"kind":13,"containerName":"gff_string","name":"$formatter","line":374},{"line":374,"kind":13,"containerName":"gff_string","name":"$self"},{"line":374,"name":"_static_gff_formatter","kind":12,"containerName":"gff_string"},{"kind":13,"containerName":"gff_string","name":"$formatter","line":374},{"line":375,"containerName":"gff_string","kind":13,"name":"$formatter"},{"kind":12,"containerName":"gff_string","name":"gff_string","line":375},{"kind":13,"containerName":"gff_string","name":"$self","line":375}],"containerName":"main::","name":"gff_string","signature":{"label":"gff_string($self,$formatter)","parameters":[{"label":"$self"},{"label":"$formatter"}],"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\nsub has_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $self->get_tag_values('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    : a string\n\nthrows an exception if there is no such tag\n\n\nsub get_tag_values {\n    shift->throw_not_implemented();\n}\n\n=head2 get_tagset_values\n\n Title   : get_tagset_values\n Usage   : @values = $self->get_tagset_values(qw(label transcript_id product))\n Function: \n Returns : An array comprising the values of the specified tags, in order of tags\n Args    : An array of strings\n\ndoes NOT throw an exception if none of the tags are not present\n\nthis method is useful for getting a human-readable label for a\nSeqFeatureI; not all tags can be assumed to be present, so a list of\npossible tags in preferential order is provided\n\n\n# interface + abstract method\nsub get_tagset_values {\n    my ($self, @args) = @_;\n    my @vals = ();\n    foreach my $arg (@args) {\n        if ($self->has_tag($arg)) {\n            push(@vals, $self->get_tag_values($arg));\n        }\n    }\n    return @vals;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: gives all tags for this feature\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_all_tags{\n    shift->throw_not_implemented();\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n\n           Note that it is not guaranteed that if you obtain a feature from\n           an object in bioperl, it will have a sequence attached. Also,\n           implementors of this interface can choose to provide an empty\n           implementation of this method. I.e., there is also no guarantee\n           that if you do attach a sequence, seq() or entire_seq() will not\n           return undef.\n\n           The reason that this method is here on the interface is to enable\n           you to call it on every SeqFeatureI compliant object, and\n           that it will be implemented in a useful way and set to a useful\n           value for the great majority of use cases. Implementors who choose\n           to ignore the call are encouraged to specifically state this in\n           their documentation.\n\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n    shift->throw_not_implemented();\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there is a sequence attached)\n           for this feature\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n    shift->throw_not_implemented();\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\n\nsub entire_seq {\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    shift->throw_not_implemented();\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           The implementation provided here returns GFF2 by default. If you\n           want a different version, supply an object implementing a method\n           gff_string() accepting a SeqFeatureI object as argument. E.g., to\n           obtain GFF1 format, do the following:\n\n                my $gffio = Bio::Tools::GFF->new(-gff_version => 1);\n                $gff1str = $feat->gff_string($gff1io);\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string()."},"line":371,"kind":12,"range":{"start":{"character":0,"line":371},"end":{"line":376,"character":9999}}},{"definition":"my","line":378,"name":"$static_gff_formatter","localvar":"my","kind":13,"containerName":null},{"children":[{"localvar":"my","kind":13,"containerName":"_static_gff_formatter","name":"$self","line":393,"definition":"my"},{"name":"@args","containerName":"_static_gff_formatter","kind":13,"line":393},{"kind":13,"containerName":"_static_gff_formatter","name":"$static_gff_formatter","line":395},{"line":396,"kind":13,"containerName":"_static_gff_formatter","name":"$static_gff_formatter"},{"line":396,"name":"new","containerName":"_static_gff_formatter","kind":12},{"name":"$static_gff_formatter","kind":13,"containerName":"_static_gff_formatter","line":398}],"containerName":"main::","name":"_static_gff_formatter","definition":"sub","detail":"($self,@args)","line":392,"kind":12,"range":{"start":{"character":0,"line":392},"end":{"line":399,"character":9999}},"signature":{"documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\nsub has_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $self->get_tag_values('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    : a string\n\nthrows an exception if there is no such tag\n\n\nsub get_tag_values {\n    shift->throw_not_implemented();\n}\n\n=head2 get_tagset_values\n\n Title   : get_tagset_values\n Usage   : @values = $self->get_tagset_values(qw(label transcript_id product))\n Function: \n Returns : An array comprising the values of the specified tags, in order of tags\n Args    : An array of strings\n\ndoes NOT throw an exception if none of the tags are not present\n\nthis method is useful for getting a human-readable label for a\nSeqFeatureI; not all tags can be assumed to be present, so a list of\npossible tags in preferential order is provided\n\n\n# interface + abstract method\nsub get_tagset_values {\n    my ($self, @args) = @_;\n    my @vals = ();\n    foreach my $arg (@args) {\n        if ($self->has_tag($arg)) {\n            push(@vals, $self->get_tag_values($arg));\n        }\n    }\n    return @vals;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: gives all tags for this feature\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_all_tags{\n    shift->throw_not_implemented();\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n\n           Note that it is not guaranteed that if you obtain a feature from\n           an object in bioperl, it will have a sequence attached. Also,\n           implementors of this interface can choose to provide an empty\n           implementation of this method. I.e., there is also no guarantee\n           that if you do attach a sequence, seq() or entire_seq() will not\n           return undef.\n\n           The reason that this method is here on the interface is to enable\n           you to call it on every SeqFeatureI compliant object, and\n           that it will be implemented in a useful way and set to a useful\n           value for the great majority of use cases. Implementors who choose\n           to ignore the call are encouraged to specifically state this in\n           their documentation.\n\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n    shift->throw_not_implemented();\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there is a sequence attached)\n           for this feature\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n    shift->throw_not_implemented();\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\n\nsub entire_seq {\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    shift->throw_not_implemented();\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           The implementation provided here returns GFF2 by default. If you\n           want a different version, supply an object implementing a method\n           gff_string() accepting a SeqFeatureI object as argument. E.g., to\n           obtain GFF1 format, do the following:\n\n                my $gffio = Bio::Tools::GFF->new(-gff_version => 1);\n                $gff1str = $feat->gff_string($gff1io);\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().\n\n\n\nsub gff_string{\n   my ($self,$formatter) = @_;\n\n   $formatter = $self->_static_gff_formatter unless $formatter;\n   return $formatter->gff_string($self);\n}\n\nmy $static_gff_formatter = undef;\n\n=head2 _static_gff_formatter\n\n Title   : _static_gff_formatter\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_static_gff_formatter($self,@args)"}},{"line":395,"name":"Bio","containerName":"Tools::GFF","kind":12},{"kind":12,"containerName":"Tools::GFF","name":"Bio","line":396},{"line":450,"range":{"start":{"line":450,"character":0},"end":{"line":622,"character":9999}},"kind":12,"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"spliced_seq","kind":13,"line":451,"definition":"my"},{"localvar":"my","containerName":"spliced_seq","kind":13,"name":"@args","line":452,"definition":"my"},{"definition":"my","line":453,"kind":13,"localvar":"my","containerName":"spliced_seq","name":"$db"},{"kind":13,"containerName":"spliced_seq","name":"$nosort","line":453},{"line":453,"name":"$phase","kind":13,"containerName":"spliced_seq"},{"name":"$self","containerName":"spliced_seq","kind":13,"line":454},{"line":454,"containerName":"spliced_seq","kind":12,"name":"_rearrange"},{"line":454,"name":"@args","kind":13,"containerName":"spliced_seq"},{"line":457,"kind":13,"containerName":"spliced_seq","name":"$self"},{"name":"entire_seq","kind":12,"containerName":"spliced_seq","line":457},{"line":457,"kind":12,"containerName":"spliced_seq","name":"is_circular"},{"containerName":"spliced_seq","kind":13,"name":"$nosort","line":458},{"definition":"my","line":462,"kind":13,"localvar":"my","containerName":"spliced_seq","name":"$old_api"},{"name":"@args","kind":13,"containerName":"spliced_seq","line":462},{"name":"@args","kind":13,"containerName":"spliced_seq","line":463},{"name":"$old_api","kind":13,"containerName":"spliced_seq","line":463},{"line":464,"containerName":"spliced_seq","kind":13,"name":"$self"},{"name":"warn","containerName":"spliced_seq","kind":12,"line":464},{"line":466,"containerName":"spliced_seq","kind":13,"name":"$db"},{"containerName":"spliced_seq","kind":13,"name":"@args","line":466},{"line":466,"containerName":"spliced_seq","kind":13,"name":"@args"},{"line":467,"containerName":"spliced_seq","kind":13,"name":"$nosort"},{"kind":13,"containerName":"spliced_seq","name":"@args","line":467},{"containerName":"spliced_seq","kind":13,"name":"@args","line":467},{"line":468,"containerName":"spliced_seq","kind":13,"name":"$phase"},{"line":468,"name":"@args","kind":13,"containerName":"spliced_seq"},{"line":468,"kind":13,"containerName":"spliced_seq","name":"@args"},{"kind":13,"containerName":"spliced_seq","name":"$phase","line":471},{"line":471,"kind":13,"containerName":"spliced_seq","name":"$phase"},{"line":471,"kind":13,"containerName":"spliced_seq","name":"$phase"},{"line":472,"containerName":"spliced_seq","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"spliced_seq","line":472},{"line":473,"containerName":"spliced_seq","kind":13,"name":"$phase"},{"line":476,"name":"$db","kind":13,"containerName":"spliced_seq"},{"kind":13,"containerName":"spliced_seq","name":"$db","line":476},{"line":476,"name":"$db","kind":13,"containerName":"spliced_seq"},{"name":"isa","containerName":"spliced_seq","kind":12,"line":476},{"name":"$self","kind":13,"containerName":"spliced_seq","line":477},{"kind":12,"containerName":"spliced_seq","name":"warn","line":477},{"line":479,"name":"$db","kind":13,"containerName":"spliced_seq"},{"line":480,"name":"$db","containerName":"spliced_seq","kind":13},{"line":480,"name":"$HasInMemory","kind":13,"containerName":"spliced_seq"},{"kind":13,"containerName":"spliced_seq","name":"$db","line":481},{"name":"isa","kind":12,"containerName":"spliced_seq","line":481},{"line":482,"name":"$db","kind":13,"containerName":"spliced_seq"},{"line":482,"containerName":"spliced_seq","kind":12,"name":"new"},{"kind":13,"containerName":"spliced_seq","name":"$db","line":482},{"name":"$self","containerName":"spliced_seq","kind":13,"line":485},{"line":485,"kind":12,"containerName":"spliced_seq","name":"location"},{"line":485,"containerName":"spliced_seq","kind":12,"name":"isa"},{"kind":13,"containerName":"spliced_seq","name":"$phase","line":486},{"containerName":"spliced_seq","kind":13,"name":"$self","line":487},{"line":487,"name":"debug","kind":12,"containerName":"spliced_seq"},{"name":"$phase","kind":13,"containerName":"spliced_seq","line":487},{"name":"$self","kind":13,"containerName":"spliced_seq","line":487},{"containerName":"spliced_seq","kind":12,"name":"end","line":487},{"definition":"my","name":"$seqstr","kind":13,"localvar":"my","containerName":"spliced_seq","line":488},{"line":488,"name":"$self","containerName":"spliced_seq","kind":13},{"containerName":"spliced_seq","kind":12,"name":"seq","line":488},{"name":"seq","containerName":"spliced_seq","kind":12,"line":488},{"name":"$phase","containerName":"spliced_seq","kind":13,"line":488},{"definition":"my","line":489,"containerName":"spliced_seq","localvar":"my","kind":13,"name":"$out"},{"line":489,"kind":12,"containerName":"spliced_seq","name":"new"},{"line":489,"kind":13,"containerName":"spliced_seq","name":"$self"},{"name":"entire_seq","containerName":"spliced_seq","kind":12,"line":489},{"containerName":"spliced_seq","kind":12,"name":"display_id","line":490},{"line":491,"name":"$seqstr","kind":13,"containerName":"spliced_seq"},{"kind":13,"containerName":"spliced_seq","name":"$out","line":492},{"line":494,"kind":13,"containerName":"spliced_seq","name":"$self"},{"line":494,"name":"seq","kind":12,"containerName":"spliced_seq"},{"containerName":"spliced_seq","kind":13,"name":"$self","line":499},{"kind":12,"containerName":"spliced_seq","name":"location","line":499},{"line":499,"kind":12,"containerName":"spliced_seq","name":"isa"},{"line":500,"kind":13,"containerName":"spliced_seq","name":"$self"},{"name":"throw","kind":12,"containerName":"spliced_seq","line":500},{"definition":"my","line":503,"localvar":"my","kind":13,"containerName":"spliced_seq","name":"$seqstr"},{"definition":"my","line":504,"name":"$seqid","localvar":"my","containerName":"spliced_seq","kind":13},{"name":"$self","containerName":"spliced_seq","kind":13,"line":504},{"name":"entire_seq","containerName":"spliced_seq","kind":12,"line":504},{"name":"display_id","containerName":"spliced_seq","kind":12,"line":504},{"definition":"my","localvar":"my","kind":13,"containerName":"spliced_seq","name":"$mixed","line":512},{"name":"$mixedloc","containerName":"spliced_seq","kind":13,"line":512},{"line":512,"name":"$fstrand","kind":13,"containerName":"spliced_seq"},{"line":514,"name":"$self","kind":13,"containerName":"spliced_seq"},{"line":514,"kind":12,"containerName":"spliced_seq","name":"isa"},{"name":"$self","kind":13,"containerName":"spliced_seq","line":515},{"line":515,"name":"absolute","kind":12,"containerName":"spliced_seq"},{"name":"$self","containerName":"spliced_seq","kind":13,"line":516},{"kind":12,"containerName":"spliced_seq","name":"warn","line":516},{"definition":"my","line":519,"name":"@locset","containerName":"spliced_seq","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"spliced_seq","line":519},{"kind":12,"containerName":"spliced_seq","name":"location","line":519},{"name":"each_Location","containerName":"spliced_seq","kind":12,"line":519},{"definition":"my","kind":13,"localvar":"my","containerName":"spliced_seq","name":"@locs","line":520},{"line":521,"kind":13,"containerName":"spliced_seq","name":"$nosort"},{"line":522,"containerName":"spliced_seq","kind":13,"name":"@locs"},{"name":"$a","kind":13,"containerName":"spliced_seq","line":527},{"line":527,"name":"$b","kind":13,"containerName":"spliced_seq"},{"name":"$fstrand","kind":13,"containerName":"spliced_seq","line":529},{"line":529,"name":"strand","kind":12,"containerName":"spliced_seq"},{"containerName":"spliced_seq","kind":13,"name":"$fstrand","line":529},{"line":530,"containerName":"spliced_seq","kind":13,"name":"$mixed"},{"line":530,"name":"strand","kind":12,"containerName":"spliced_seq"},{"line":530,"name":"$fstrand","containerName":"spliced_seq","kind":13},{"name":"strand","kind":12,"containerName":"spliced_seq","line":530},{"name":"seq_id","containerName":"spliced_seq","kind":12,"line":531},{"line":532,"name":"$mixedloc","kind":13,"containerName":"spliced_seq"},{"line":532,"containerName":"spliced_seq","kind":12,"name":"seq_id"},{"line":532,"name":"$seqid","kind":13,"containerName":"spliced_seq"},{"line":534,"kind":12,"containerName":"spliced_seq","name":"start"},{"line":534,"name":"strand","kind":12,"containerName":"spliced_seq"},{"name":"@locset","containerName":"spliced_seq","kind":13,"line":535},{"line":537,"kind":13,"containerName":"spliced_seq","name":"$mixed"},{"line":538,"kind":13,"containerName":"spliced_seq","name":"$self"},{"line":538,"name":"warn","containerName":"spliced_seq","kind":12},{"containerName":"spliced_seq","kind":13,"name":"@locs","line":539},{"containerName":"spliced_seq","kind":13,"name":"@locset","line":539},{"line":543,"name":"@locs","containerName":"spliced_seq","kind":13},{"containerName":"spliced_seq","kind":13,"name":"@locset","line":543},{"line":544,"name":"$fstrand","kind":13,"containerName":"spliced_seq"},{"name":"$locs","kind":13,"containerName":"spliced_seq","line":544},{"kind":12,"containerName":"spliced_seq","name":"strand","line":544},{"definition":"my","localvar":"my","kind":13,"containerName":"spliced_seq","name":"$loc","line":547},{"name":"@locs","containerName":"spliced_seq","kind":13,"line":547},{"kind":13,"containerName":"spliced_seq","name":"$loc","line":548},{"line":548,"kind":12,"containerName":"spliced_seq","name":"isa"},{"name":"$self","kind":13,"containerName":"spliced_seq","line":549},{"line":549,"kind":12,"containerName":"spliced_seq","name":"throw"},{"line":551,"name":"$called_seq","containerName":"spliced_seq","localvar":"my","kind":13,"definition":"my"},{"line":552,"name":"$fstrand","kind":13,"containerName":"spliced_seq"},{"line":552,"name":"$loc","kind":13,"containerName":"spliced_seq"},{"line":552,"name":"strand","kind":12,"containerName":"spliced_seq"},{"line":553,"kind":13,"containerName":"spliced_seq","name":"$self"},{"line":553,"name":"warn","containerName":"spliced_seq","kind":12},{"line":557,"containerName":"spliced_seq","kind":13,"name":"$loc"},{"line":557,"name":"seq_id","containerName":"spliced_seq","kind":12},{"name":"$loc","containerName":"spliced_seq","kind":13,"line":558},{"name":"seq_id","containerName":"spliced_seq","kind":12,"line":558},{"line":558,"containerName":"spliced_seq","kind":13,"name":"$seqid"},{"name":"$db","kind":13,"containerName":"spliced_seq","line":559},{"line":560,"localvar":"my","containerName":"spliced_seq","kind":13,"name":"$sid","definition":"my"},{"line":560,"kind":13,"containerName":"spliced_seq","name":"$loc"},{"line":560,"name":"seq_id","kind":12,"containerName":"spliced_seq"},{"kind":13,"containerName":"spliced_seq","name":"$sid","line":561},{"line":563,"name":"$called_seq","kind":13,"containerName":"spliced_seq"},{"name":"$db","kind":13,"containerName":"spliced_seq","line":563},{"line":563,"name":"get_Seq_by_acc","containerName":"spliced_seq","kind":12},{"name":"$sid","kind":13,"containerName":"spliced_seq","line":563},{"containerName":"spliced_seq","kind":13,"name":"$self","line":566},{"line":566,"name":"warn","kind":12,"containerName":"spliced_seq"},{"kind":13,"containerName":"spliced_seq","name":"$called_seq","line":567},{"kind":13,"containerName":"spliced_seq","name":"$self","line":570},{"line":570,"containerName":"spliced_seq","kind":12,"name":"warn"},{"line":570,"name":"$loc","kind":13,"containerName":"spliced_seq"},{"name":"seq_id","kind":12,"containerName":"spliced_seq","line":570},{"name":"$called_seq","kind":13,"containerName":"spliced_seq","line":571},{"name":"$called_seq","containerName":"spliced_seq","kind":13,"line":573},{"kind":13,"containerName":"spliced_seq","name":"$seqstr","line":574},{"line":574,"kind":13,"containerName":"spliced_seq","name":"$self"},{"line":574,"name":"length","kind":12,"containerName":"spliced_seq"},{"line":578,"name":"$called_seq","kind":13,"containerName":"spliced_seq"},{"line":578,"containerName":"spliced_seq","kind":13,"name":"$self"},{"line":578,"containerName":"spliced_seq","kind":12,"name":"entire_seq"},{"kind":13,"containerName":"spliced_seq","name":"$called_seq","line":582},{"line":582,"containerName":"spliced_seq","kind":12,"name":"length"},{"line":582,"name":"$loc","kind":13,"containerName":"spliced_seq"},{"containerName":"spliced_seq","kind":12,"name":"end","line":582},{"definition":"my","localvar":"my","kind":13,"containerName":"spliced_seq","name":"$accession","line":583},{"name":"$called_seq","kind":13,"containerName":"spliced_seq","line":583},{"name":"accession","kind":12,"containerName":"spliced_seq","line":583},{"definition":"my","name":"$end","localvar":"my","kind":13,"containerName":"spliced_seq","line":584},{"name":"$loc","kind":13,"containerName":"spliced_seq","line":584},{"kind":12,"containerName":"spliced_seq","name":"end","line":584},{"definition":"my","line":585,"localvar":"my","containerName":"spliced_seq","kind":13,"name":"$length"},{"line":585,"name":"$called_seq","containerName":"spliced_seq","kind":13},{"containerName":"spliced_seq","kind":12,"name":"length","line":585},{"line":586,"name":"$orig_id","containerName":"spliced_seq","localvar":"my","kind":13,"definition":"my"},{"line":586,"name":"$self","kind":13,"containerName":"spliced_seq"},{"line":586,"kind":12,"containerName":"spliced_seq","name":"seq_id"},{"definition":"my","line":587,"localvar":"my","kind":13,"containerName":"spliced_seq","name":"$locus"},{"line":587,"name":"$self","containerName":"spliced_seq","kind":13},{"name":"get_tagset_values","kind":12,"containerName":"spliced_seq","line":587},{"kind":13,"containerName":"spliced_seq","name":"$self","line":588},{"line":588,"kind":12,"containerName":"spliced_seq","name":"throw"},{"kind":13,"containerName":"spliced_seq","name":"$self","line":593},{"name":"isa","containerName":"spliced_seq","kind":12,"line":593},{"line":594,"name":"$s","kind":13,"localvar":"my","containerName":"spliced_seq","definition":"my"},{"line":594,"kind":13,"containerName":"spliced_seq","name":"$e"},{"kind":13,"containerName":"spliced_seq","name":"$loc","line":594},{"line":594,"kind":12,"containerName":"spliced_seq","name":"start"},{"line":594,"name":"$loc","containerName":"spliced_seq","kind":13},{"line":594,"name":"end","containerName":"spliced_seq","kind":12},{"line":598,"name":"$seqstr","containerName":"spliced_seq","kind":13},{"containerName":"spliced_seq","kind":13,"name":"$called_seq","line":598},{"containerName":"spliced_seq","kind":12,"name":"subseq","line":598},{"name":"$s","containerName":"spliced_seq","kind":13,"line":598},{"kind":13,"containerName":"spliced_seq","name":"$e","line":598},{"name":"seq","containerName":"spliced_seq","kind":12,"line":598},{"containerName":"spliced_seq","kind":12,"name":"seq","line":598},{"name":"$loc","kind":13,"containerName":"spliced_seq","line":601},{"kind":12,"containerName":"spliced_seq","name":"strand","line":601},{"line":602,"kind":13,"containerName":"spliced_seq","name":"$seqstr"},{"name":"$called_seq","kind":13,"containerName":"spliced_seq","line":602},{"name":"subseq","kind":12,"containerName":"spliced_seq","line":602},{"containerName":"spliced_seq","kind":13,"name":"$loc","line":602},{"name":"start","kind":12,"containerName":"spliced_seq","line":602},{"name":"$loc","containerName":"spliced_seq","kind":13,"line":602},{"name":"end","kind":12,"containerName":"spliced_seq","line":602},{"name":"$nosort","kind":13,"containerName":"spliced_seq","line":604},{"name":"$seqstr","kind":13,"containerName":"spliced_seq","line":605},{"line":605,"name":"$called_seq","containerName":"spliced_seq","kind":13},{"line":605,"name":"trunc","kind":12,"containerName":"spliced_seq"},{"line":605,"kind":13,"containerName":"spliced_seq","name":"$loc"},{"kind":12,"containerName":"spliced_seq","name":"start","line":605},{"name":"$loc","containerName":"spliced_seq","kind":13,"line":605},{"name":"end","kind":12,"containerName":"spliced_seq","line":605},{"kind":12,"containerName":"spliced_seq","name":"revcom","line":605},{"line":605,"name":"seq","kind":12,"containerName":"spliced_seq"},{"name":"$seqstr","kind":13,"containerName":"spliced_seq","line":605},{"line":607,"name":"$seqstr","containerName":"spliced_seq","kind":13},{"line":607,"name":"$called_seq","containerName":"spliced_seq","kind":13},{"line":607,"name":"trunc","kind":12,"containerName":"spliced_seq"},{"line":607,"name":"$loc","containerName":"spliced_seq","kind":13},{"line":607,"kind":12,"containerName":"spliced_seq","name":"start"},{"line":607,"name":"$loc","containerName":"spliced_seq","kind":13},{"line":607,"name":"end","kind":12,"containerName":"spliced_seq"},{"name":"revcom","containerName":"spliced_seq","kind":12,"line":607},{"kind":12,"containerName":"spliced_seq","name":"seq","line":607},{"line":613,"kind":13,"containerName":"spliced_seq","name":"$phase"},{"name":"$seqstr","kind":13,"containerName":"spliced_seq","line":614},{"name":"$seqstr","containerName":"spliced_seq","kind":13,"line":614},{"name":"$phase","kind":13,"containerName":"spliced_seq","line":614},{"line":617,"name":"$out","localvar":"my","kind":13,"containerName":"spliced_seq","definition":"my"},{"name":"new","containerName":"spliced_seq","kind":12,"line":617},{"line":617,"name":"$self","containerName":"spliced_seq","kind":13},{"line":617,"name":"entire_seq","containerName":"spliced_seq","kind":12},{"line":618,"kind":12,"containerName":"spliced_seq","name":"display_id"},{"name":"$seqstr","kind":13,"containerName":"spliced_seq","line":619},{"kind":13,"containerName":"spliced_seq","name":"$out","line":621}],"containerName":"main::","name":"spliced_seq"},{"line":482,"containerName":"DB::InMemoryCache","kind":12,"name":"Bio"},{"line":489,"name":"Bio","kind":12,"containerName":"Seq"},{"containerName":"Seq","kind":12,"name":"Bio","line":617},{"signature":{"label":"location($self)","documentation":"1;\n# $Id: SeqFeatureI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeatureI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeatureI - Abstract interface of a Sequence Feature\n\n=head1 SYNOPSIS\n\n    # get a seqfeature somehow, eg, from a Sequence with Features attached\n\n    foreach $feat ( $seq->get_SeqFeatures() ) {\n       print \"Feature from \", $feat->start, \"to \",\n\t       $feat->end, \" Primary tag  \", $feat->primary_tag,\n\t          \", produced by \", $feat->source_tag(), \"\\n\";\n\n       if( $feat->strand == 0 ) {\n\t\t    print \"Feature applicable to either strand\\n\";\n       } else {\n          print \"Feature on strand \", $feat->strand,\"\\n\"; # -1,1\n       }\n\n       print \"feature location is \",$feat->start, \"..\",\n          $feat->end, \" on strand \", $feat->strand, \"\\n\";\n       print \"easy utility to print locations in GenBank/EMBL way \",\n          $feat->location->to_FTstring(), \"\\n\";\n\n       foreach $tag ( $feat->get_all_tags() ) {\n\t\t    print \"Feature has tag \", $tag, \" with values, \",\n\t\t      join(' ',$feat->get_tag_values($tag)), \"\\n\";\n       }\n\t    print \"new feature\\n\" if $feat->has_tag('new');\n\t    # features can have sub features\n\t    my @subfeat = $feat->get_SeqFeatures();\n\t }\n\n=head1 DESCRIPTION\n\nThis interface is the functions one can expect for any Sequence\nFeature, whatever its implementation or whether it is a more complex\ntype (eg, a Gene). This object does not actually provide any\nimplemention, it just provides the definitions of what methods one can\ncall. See Bio::SeqFeature::Generic for a good standard implementation\nof this object\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeatureI;\nuse vars qw($HasInMemory);\nuse strict;\nBEGIN {\n    eval { require Bio::DB::InMemoryCache };\n    if( $@ ) { $HasInMemory = 0 }\n    else { $HasInMemory = 1 }\n}\n\nuse Bio::Seq;\n\nuse Carp;\n\nuse base qw(Bio::RangeI);\n\n=head1 Bio::SeqFeatureI specific methods\n\nNew method interfaces.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\nsub get_SeqFeatures{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $name = $feat->display_name()\n Function: Returns the human-readable name of the feature for displays.\n Returns : a string\n Args    : none\n\n\nsub display_name {\n    shift->throw_not_implemented();\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n Function: Returns the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $tag_exists = $self->has_tag('some_tag')\n Function: \n Returns : TRUE if the specified tag exists, and FALSE otherwise\n Args    :\n\n\nsub has_tag{\n   my ($self,@args) = @_;\n\n   $self->throw_not_implemented();\n\n}\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $self->get_tag_values('some_tag')\n Function: \n Returns : An array comprising the values of the specified tag.\n Args    : a string\n\nthrows an exception if there is no such tag\n\n\nsub get_tag_values {\n    shift->throw_not_implemented();\n}\n\n=head2 get_tagset_values\n\n Title   : get_tagset_values\n Usage   : @values = $self->get_tagset_values(qw(label transcript_id product))\n Function: \n Returns : An array comprising the values of the specified tags, in order of tags\n Args    : An array of strings\n\ndoes NOT throw an exception if none of the tags are not present\n\nthis method is useful for getting a human-readable label for a\nSeqFeatureI; not all tags can be assumed to be present, so a list of\npossible tags in preferential order is provided\n\n\n# interface + abstract method\nsub get_tagset_values {\n    my ($self, @args) = @_;\n    my @vals = ();\n    foreach my $arg (@args) {\n        if ($self->has_tag($arg)) {\n            push(@vals, $self->get_tag_values($arg));\n        }\n    }\n    return @vals;\n}\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: gives all tags for this feature\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_all_tags{\n    shift->throw_not_implemented();\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n\n           Note that it is not guaranteed that if you obtain a feature from\n           an object in bioperl, it will have a sequence attached. Also,\n           implementors of this interface can choose to provide an empty\n           implementation of this method. I.e., there is also no guarantee\n           that if you do attach a sequence, seq() or entire_seq() will not\n           return undef.\n\n           The reason that this method is here on the interface is to enable\n           you to call it on every SeqFeatureI compliant object, and\n           that it will be implemented in a useful way and set to a useful\n           value for the great majority of use cases. Implementors who choose\n           to ignore the call are encouraged to specifically state this in\n           their documentation.\n\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n    shift->throw_not_implemented();\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there is a sequence attached)\n           for this feature\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n    shift->throw_not_implemented();\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    : none\n\n\n\nsub entire_seq {\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    shift->throw_not_implemented();\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           The implementation provided here returns GFF2 by default. If you\n           want a different version, supply an object implementing a method\n           gff_string() accepting a SeqFeatureI object as argument. E.g., to\n           obtain GFF1 format, do the following:\n\n                my $gffio = Bio::Tools::GFF->new(-gff_version => 1);\n                $gff1str = $feat->gff_string($gff1io);\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().\n\n\n\nsub gff_string{\n   my ($self,$formatter) = @_;\n\n   $formatter = $self->_static_gff_formatter unless $formatter;\n   return $formatter->gff_string($self);\n}\n\nmy $static_gff_formatter = undef;\n\n=head2 _static_gff_formatter\n\n Title   : _static_gff_formatter\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _static_gff_formatter{\n   my ($self,@args) = @_;\n   require Bio::Tools::GFF; # on the fly inclusion -- is this better?\n   if( !defined $static_gff_formatter ) {\n       $static_gff_formatter = Bio::Tools::GFF->new('-gff_version' => 2);\n   }\n   return $static_gff_formatter;\n}\n\n\n=head1 Decorating methods\n\nThese methods have an implementation provided by Bio::SeqFeatureI,\nbut can be validly overwritten by subclasses\n\n=head2 spliced_seq\n\n  Title   : spliced_seq\n\n  Usage   : $seq = $feature->spliced_seq()\n            $seq = $feature_with_remote_locations->spliced_seq($db_for_seqs)\n\n  Function: Provides a sequence of the feature which is the most\n            semantically \"relevant\" feature for this sequence. A default\n            implementation is provided which for simple cases returns just\n            the sequence, but for split cases, loops over the split location\n            to return the sequence. In the case of split locations with\n            remote locations, eg\n\n            join(AB000123:5567-5589,80..1144)\n\n            in the case when a database object is passed in, it will attempt\n            to retrieve the sequence from the database object, and \"Do the right thing\",\n            however if no database object is provided, it will generate the correct\n            number of N's (DNA) or X's (protein, though this is unlikely).\n\n            This function is deliberately \"magical\" attempting to second guess\n            what a user wants as \"the\" sequence for this feature.\n\n            Implementing classes are free to override this method with their\n            own magic if they have a better idea what the user wants.\n\n  Args    : [optional]\n            -db        A L<Bio::DB::RandomAccessI> compliant object if\n                       one needs to retrieve remote seqs.\n            -nosort    boolean if the locations should not be sorted\n                       by start location.  This may occur, for instance,\n                       in a circular sequence where a gene span starts\n                       before the end of the sequence and ends after the\n                       sequence start. Example : join(15685..16260,1..207)\n\t\t\t\t\t   (default = if sequence is_circular(), 1, otherwise 0)\n\t\t\t-phase     truncates the returned sequence based on the\n\t\t\t\t\t   intron phase (0,1,2).\n\n  Returns : A L<Bio::PrimarySeqI> object\n\n\nsub spliced_seq {\n    my $self = shift;\n\tmy @args = @_;\n\tmy ($db, $nosort, $phase) =\n\t   $self->_rearrange([qw(DB NOSORT PHASE)], @args);\n\t\n\t# set no_sort based on the parent sequence status\n\tif ($self->entire_seq->is_circular) {\n\t\t$nosort = 1;\n\t}\n\t\n\t# (added 7/7/06 to allow use old API (with warnings)\n\tmy $old_api = (!(grep {$_ =~ /(?:nosort|db|phase)/} @args)) ? 1 : 0;\n\tif (@args && $old_api) {\n\t\t$self->warn(q(API has changed; please use '-db' or '-nosort' ).\n                     qq(for args. See POD for more details.));\n\t\t$db = shift @args if @args;\n\t\t$nosort = shift @args if @args;\n\t\t$phase = shift @args if @args;\n\t};\n\t\n\tif (defined($phase) && ($phase < 0 || $phase > 2)) {\n\t    $self->warn(\"Phase must be 0,1, or 2.  Setting phase to 0...\");\n\t    $phase = 0;\n\t}\n\t\n\tif( $db && ref($db) && ! $db->isa('Bio::DB::RandomAccessI') ) {\n        $self->warn(\"Must pass in a valid Bio::DB::RandomAccessI object\".\n                    \" for access to remote locations for spliced_seq\");\n        $db = undef;\n    } elsif( defined $db && $HasInMemory &&\n            $db->isa('Bio::DB::InMemoryCache') ) {\n        $db = Bio::DB::InMemoryCache->new(-seqdb => $db);\n    }\n\n    if( ! $self->location->isa(\"Bio::Location::SplitLocationI\") ) {\n        if ($phase) {\n\t    $self->debug(\"Subseq start: \",$phase+1,\"\\tend: \",$self->end,\"\\n\");\n\t    my $seqstr = substr($self->seq->seq, $phase);\n\t    my $out = Bio::Seq->new( -id => $self->entire_seq->display_id\n\t\t\t\t. \"_spliced_feat\",\n\t\t\t -seq => $seqstr);\n\t    return $out;\n\t} else {\n\t    return $self->seq(); # nice and easy!\n\t}\n    }\n    \n    # redundant test, but the above ISA is probably not ideal.\n    if( ! $self->location->isa(\"Bio::Location::SplitLocationI\") ) {\n\t$self->throw(\"not atomic, not split, yikes, in trouble!\");\n    }\n\n    my $seqstr = '';\n    my $seqid = $self->entire_seq->display_id;\n    # This is to deal with reverse strand features\n    # so we are really sorting features 5' -> 3' on their strand\n    # i.e. rev strand features will be sorted largest to smallest\n    # as this how revcom CDSes seem to be annotated in genbank.\n    # Might need to eventually allow this to be programable?\n    # (can I mention how much fun this is NOT! --jason)\n\n    my ($mixed,$mixedloc, $fstrand) = (0);\n\n    if( $self->isa('Bio::Das::SegmentI') &&\n\t! $self->absolute ) {\n\t$self->warn(\"Calling spliced_seq with a Bio::Das::SegmentI which does have absolute set to 1 -- be warned you may not be getting things on the correct strand\");\n    }\n\n    my @locset = $self->location->each_Location;\n    my @locs;\n    if( ! $nosort ) {\n\t@locs = map { $_->[0] }\n\t# sort so that most negative is first basically to order\n\t# the features on the opposite strand 5'->3' on their strand\n\t# rather than they way most are input which is on the fwd strand\n\n\tsort { $a->[1] <=> $b->[1] } # Yes Tim, Schwartzian transformation\n\tmap {\n\t    $fstrand = $_->strand unless defined $fstrand;\n\t    $mixed = 1 if defined $_->strand && $fstrand != $_->strand;\n\t    if( defined $_->seq_id ) {\n\t\t$mixedloc = 1 if( $_->seq_id ne $seqid );\n\t    }\n\t    [ $_, $_->start * ($_->strand || 1)];\n\t} @locset;\n\n\tif ( $mixed ) {\n\t    $self->warn(\"Mixed strand locations, spliced seq using the input order rather than trying to sort\");\n\t    @locs = @locset;\n\t}\n    } else {\n\t# use the original order instead of trying to sort\n\t@locs = @locset;\n\t$fstrand = $locs[0]->strand;\n    }\n\n    foreach my $loc ( @locs ) {\n\tif( ! $loc->isa(\"Bio::Location::Atomic\") ) {\n\t    $self->throw(\"Can only deal with one level deep locations\");\n\t}\n\tmy $called_seq;\n\tif( $fstrand != $loc->strand ) {\n\t    $self->warn(\"feature strand is different from location strand!\");\n\t}\n\t# deal with remote sequences\n\n\tif( defined $loc->seq_id &&\n\t    $loc->seq_id ne $seqid ) {\n\t    if( defined $db ) {\n\t\tmy $sid = $loc->seq_id;\n\t\t$sid =~ s/\\.\\d+$//g;\n\t\teval {\n\t\t    $called_seq = $db->get_Seq_by_acc($sid);\n\t\t};\n\t\tif( $@ ) {\n\t\t    $self->warn(\"In attempting to join a remote location, sequence $sid was not in database. Will provide padding N's. Full exception \\n\\n$@\");\n\t\t    $called_seq = undef;\n\t\t}\n\t    } else {\n\t\t$self->warn( \"cannot get remote location for \".$loc->seq_id .\" without a valid Bio::DB::RandomAccessI database handle (like Bio::DB::GenBank)\");\n\t\t$called_seq = undef;\n\t    }\n\t    if( !defined $called_seq ) {\n\t\t$seqstr .= 'N' x $self->length;\n\t\tnext;\n\t    }\n\t} else {\n\t    $called_seq = $self->entire_seq;\n\t}\n\n    # does the called sequence make sense? Bug 1780\n    if ($called_seq->length < $loc->end) {\n        my $accession = $called_seq->accession;\n        my $end = $loc->end;\n        my $length = $called_seq->length;\n        my $orig_id = $self->seq_id; # originating sequence\n        my ($locus) = $self->get_tagset_values(\"locus_tag\");\n        $self->throw(\"Location end ($end) exceeds length ($length) of \".\n                     \"called sequence $accession.\\nCheck sequence version used in \".\n                     \"$locus locus-tagged SeqFeature in $orig_id.\");\n    }\n\n\tif( $self->isa('Bio::Das::SegmentI') ) {\n\t    my ($s,$e) = ($loc->start,$loc->end);\n\t\t# $called_seq is Bio::DB::GFF::RelSegment, as well as its subseq();\n\t\t# Bio::DB::GFF::RelSegment::seq() returns a Bio::PrimarySeq, and using seq()\n\t\t# in turn returns a string.  Confused?\n\t    $seqstr .= $called_seq->subseq($s,$e)->seq()->seq();\n\t} else {\n\t    # This is dumb, subseq should work on locations...\n\t    if( $loc->strand == 1 ) {\n\t\t$seqstr .= $called_seq->subseq($loc->start,$loc->end);\n\t    } else {\n\t\tif( $nosort ) {\n\t\t    $seqstr = $called_seq->trunc($loc->start,$loc->end)->revcom->seq() . $seqstr;\n\t\t} else {\n\t\t    $seqstr .= $called_seq->trunc($loc->start,$loc->end)->revcom->seq();\n\t\t}\n\t    }\n\t}\n    }\n    \n    if (defined($phase)) {\n\t$seqstr = substr($seqstr, $phase);\n    }\n    \n    my $out = Bio::Seq->new( -id => $self->entire_seq->display_id\n\t\t\t            . \"_spliced_feat\",\n\t\t\t     -seq => $seqstr);\n\n    return $out;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location\n\t   of feature on sequence or parent feature\n Returns : Bio::LocationI object\n Args    : none","parameters":[{"label":"$self"}]},"line":636,"range":{"start":{"line":636,"character":0},"end":{"line":640,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"location","line":637,"definition":"my"},{"line":639,"name":"$self","kind":13,"containerName":"location"},{"name":"throw_not_implemented","kind":12,"containerName":"location","line":639}],"name":"location","containerName":"main::"},{"kind":12,"range":{"end":{"character":9999,"line":676},"start":{"line":656,"character":0}},"line":656,"definition":"sub","containerName":"main::","name":"primary_id","children":[{"localvar":"my","containerName":"primary_id","kind":13,"name":"$self","line":657,"definition":"my"},{"name":"$self","containerName":"primary_id","kind":13,"line":669},{"line":669,"name":"has_tag","containerName":"primary_id","kind":12},{"line":670,"kind":13,"containerName":"primary_id","name":"$self"},{"line":670,"name":"remove_tag","containerName":"primary_id","kind":12},{"line":672,"containerName":"primary_id","kind":13,"name":"$self"},{"kind":12,"containerName":"primary_id","name":"add_tag_value","line":672},{"line":674,"kind":13,"localvar":"my","containerName":"primary_id","name":"$id","definition":"my"},{"kind":13,"containerName":"primary_id","name":"$self","line":674},{"kind":12,"containerName":"primary_id","name":"get_tagset_values","line":674},{"name":"$id","containerName":"primary_id","kind":13,"line":675}]},{"definition":"sub","containerName":"main::","name":"generate_unique_persistent_id","children":[{"containerName":"generate_unique_persistent_id","localvar":"my","kind":13,"name":"$self","line":680,"definition":"my"},{"name":"new","containerName":"generate_unique_persistent_id","kind":12,"line":682},{"line":682,"name":"generate_unique_persistent_id","kind":12,"containerName":"generate_unique_persistent_id"},{"name":"$self","containerName":"generate_unique_persistent_id","kind":13,"line":682}],"kind":12,"range":{"start":{"line":678,"character":0},"end":{"line":683,"character":9999}},"line":678},{"line":682,"kind":12,"containerName":"SeqFeature::Tools::IDHandler::Bio::SeqFeature::Tools::IDHandler","name":"Bio"}],"version":5}