{"vars":[{"line":110,"name":"base","containerName":"","kind":2},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: FeatureNamer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::FeatureNamer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::FeatureNamer - generates unique persistent names for features\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::FeatureNamer;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $namer = Bio::SeqFeature::Tools::FeatureNamer->new;\n  my @features = $seq->get_SeqFeatures;\n  foreach my $feature (@features) {\n    $namer->name_feature($feature) unless $feature->display_name;\n  }  \n\n=head1 DESCRIPTION\n\nThis is a helper class for providing names for SeqFeatures\n\nThe L<Bio::SeqFeatureI> class provides a display_name\nmethod. Typically the display_name is not set when parsing formats\nsuch as genbank - instead properties such as B<label>, B<product> or\nB<gene> are set in a somewhat inconsistent manner.\n\nIn addition, when generating subfeatures (for example, exons that are\nsubfeatures of a transcript feature), it is often desirable to name\nthese subfeatures before either exporting to another format or\nreporting to the user.\n\nThis module is intended to help given uniform display_names to\nfeatures and their subfeatures.\n\n=head1 TODO\n\nCurrently the naming policy is hardcoded. It may be desirable to allow\nplugging in variations on naming policies; this could be done either\nby subclassing, anonymous subroutines (closures) or\nparameterization. Contact the author if you feel you have need for a\ndifferent naming policy\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm AT fruitfly DOT org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::FeatureNamer;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::FeatureNamer->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::FeatureNamer\n Args    : see below"},"range":{"end":{"line":135,"character":9999},"start":{"line":124,"character":0}},"kind":12,"line":124,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":125,"localvar":"my","kind":13,"containerName":"new","name":"$class"},{"line":125,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":126},{"line":126,"kind":13,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":126},{"line":134,"kind":13,"containerName":"new","name":"$self"}]},{"name":"SUPER","containerName":"new","kind":12,"line":126},{"signature":{"label":"name_feature($self,$sf)","parameters":[{"label":"$self"},{"label":"$sf"}],"documentation":"1;\n# $Id: FeatureNamer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::FeatureNamer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::FeatureNamer - generates unique persistent names for features\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::FeatureNamer;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $namer = Bio::SeqFeature::Tools::FeatureNamer->new;\n  my @features = $seq->get_SeqFeatures;\n  foreach my $feature (@features) {\n    $namer->name_feature($feature) unless $feature->display_name;\n  }  \n\n=head1 DESCRIPTION\n\nThis is a helper class for providing names for SeqFeatures\n\nThe L<Bio::SeqFeatureI> class provides a display_name\nmethod. Typically the display_name is not set when parsing formats\nsuch as genbank - instead properties such as B<label>, B<product> or\nB<gene> are set in a somewhat inconsistent manner.\n\nIn addition, when generating subfeatures (for example, exons that are\nsubfeatures of a transcript feature), it is often desirable to name\nthese subfeatures before either exporting to another format or\nreporting to the user.\n\nThis module is intended to help given uniform display_names to\nfeatures and their subfeatures.\n\n=head1 TODO\n\nCurrently the naming policy is hardcoded. It may be desirable to allow\nplugging in variations on naming policies; this could be done either\nby subclassing, anonymous subroutines (closures) or\nparameterization. Contact the author if you feel you have need for a\ndifferent naming policy\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm AT fruitfly DOT org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::FeatureNamer;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::FeatureNamer->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::FeatureNamer\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n#    my($typemap) =\n#\t$self->_rearrange([qw(TYPEMAP\n#\t\t\t     )],\n#                          @args);#\n\n#    $typemap  && $self->typemap($typemap);\n    return $self; # success - we hope!\n}\n\n=head2 name_feature\n\n Title   : name_feature\n Usage   : $namer->name_feature($sf);\n Function: sets display_name\n Example :\n Returns : \n Args    : L<Bio::SeqFeatureI>\n\nThis method calls generate_feature_name() and uses the returned value\nto set the display_name of the feature"},"range":{"end":{"line":155,"character":9999},"start":{"character":0,"line":151}},"kind":12,"line":151,"detail":"($self,$sf)","definition":"sub","name":"name_feature","containerName":"main::","children":[{"line":152,"name":"$self","localvar":"my","kind":13,"containerName":"name_feature","definition":"my"},{"line":152,"containerName":"name_feature","kind":13,"name":"$sf"},{"name":"$name","kind":13,"localvar":"my","containerName":"name_feature","line":153,"definition":"my"},{"name":"$self","kind":13,"containerName":"name_feature","line":153},{"line":153,"name":"generate_feature_name","containerName":"name_feature","kind":12},{"line":153,"name":"$sf","containerName":"name_feature","kind":13},{"name":"$sf","kind":13,"containerName":"name_feature","line":154},{"name":"display_name","containerName":"name_feature","kind":12,"line":154},{"line":154,"name":"$name","kind":13,"containerName":"name_feature"}]},{"range":{"start":{"line":179,"character":0},"end":{"character":9999,"line":192}},"kind":12,"line":179,"signature":{"label":"name_contained_features($self,$sf)","parameters":[{"label":"$self"},{"label":"$sf"}],"documentation":"1;\n# $Id: FeatureNamer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::FeatureNamer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::FeatureNamer - generates unique persistent names for features\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::FeatureNamer;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $namer = Bio::SeqFeature::Tools::FeatureNamer->new;\n  my @features = $seq->get_SeqFeatures;\n  foreach my $feature (@features) {\n    $namer->name_feature($feature) unless $feature->display_name;\n  }  \n\n=head1 DESCRIPTION\n\nThis is a helper class for providing names for SeqFeatures\n\nThe L<Bio::SeqFeatureI> class provides a display_name\nmethod. Typically the display_name is not set when parsing formats\nsuch as genbank - instead properties such as B<label>, B<product> or\nB<gene> are set in a somewhat inconsistent manner.\n\nIn addition, when generating subfeatures (for example, exons that are\nsubfeatures of a transcript feature), it is often desirable to name\nthese subfeatures before either exporting to another format or\nreporting to the user.\n\nThis module is intended to help given uniform display_names to\nfeatures and their subfeatures.\n\n=head1 TODO\n\nCurrently the naming policy is hardcoded. It may be desirable to allow\nplugging in variations on naming policies; this could be done either\nby subclassing, anonymous subroutines (closures) or\nparameterization. Contact the author if you feel you have need for a\ndifferent naming policy\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm AT fruitfly DOT org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::FeatureNamer;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::FeatureNamer->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::FeatureNamer\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n#    my($typemap) =\n#\t$self->_rearrange([qw(TYPEMAP\n#\t\t\t     )],\n#                          @args);#\n\n#    $typemap  && $self->typemap($typemap);\n    return $self; # success - we hope!\n}\n\n=head2 name_feature\n\n Title   : name_feature\n Usage   : $namer->name_feature($sf);\n Function: sets display_name\n Example :\n Returns : \n Args    : L<Bio::SeqFeatureI>\n\nThis method calls generate_feature_name() and uses the returned value\nto set the display_name of the feature\n\n\nsub name_feature {\n    my ($self, $sf) = @_;\n    my $name = $self->generate_feature_name($sf);\n    $sf->display_name($name);\n}\n\n=head2 name_contained_features\n\n Title   : name_contained_features\n Usage   : $namer->name_contained_features($sf);\n Function: sets display_name for all features contained by sf\n Example :\n Returns : \n Args    : L<Bio::SeqFeatureI>\n\niterates through all subfeatures of a certain feature (using\nget_all_SeqFeatures) and names each subfeatures, based on the\ngenerated name for the holder feature\n\nA subfeature is named by concatenating the generated name of the\ncontainer feature with the type and a number.\n\nFor example, if the containing feature is a gene with display name\nB<dpp>, subfeatures will be named dpp-mRNA-1 dpp-mRNA2 dpp-exon1\ndpp-exon2 etc"},"containerName":"main::","name":"name_contained_features","children":[{"kind":13,"localvar":"my","containerName":"name_contained_features","name":"$self","line":180,"definition":"my"},{"containerName":"name_contained_features","kind":13,"name":"$sf","line":180},{"definition":"my","localvar":"my","kind":13,"containerName":"name_contained_features","name":"$cname","line":181},{"line":181,"containerName":"name_contained_features","kind":13,"name":"$self"},{"line":181,"name":"generate_feature_name","kind":12,"containerName":"name_contained_features"},{"line":181,"name":"$sf","containerName":"name_contained_features","kind":13},{"definition":"my","name":"@subsfs","localvar":"my","containerName":"name_contained_features","kind":13,"line":182},{"name":"$sf","containerName":"name_contained_features","kind":13,"line":182},{"name":"get_all_SeqFeatures","containerName":"name_contained_features","kind":12,"line":182},{"line":183,"name":"%num_by_type","localvar":"my","containerName":"name_contained_features","kind":13,"definition":"my"},{"definition":"my","line":184,"name":"$ssf","localvar":"my","kind":13,"containerName":"name_contained_features"},{"name":"@subsfs","kind":13,"containerName":"name_contained_features","line":184},{"name":"$type","kind":13,"localvar":"my","containerName":"name_contained_features","line":185,"definition":"my"},{"name":"$ssf","containerName":"name_contained_features","kind":13,"line":185},{"containerName":"name_contained_features","kind":12,"name":"primary_tag","line":185},{"definition":"my","line":186,"name":"$num","containerName":"name_contained_features","localvar":"my","kind":13},{"containerName":"name_contained_features","kind":13,"name":"$num_by_type","line":186},{"line":186,"containerName":"name_contained_features","kind":13,"name":"$type"},{"kind":13,"containerName":"name_contained_features","name":"$num","line":187},{"line":188,"kind":13,"containerName":"name_contained_features","name":"$num_by_type"},{"line":188,"name":"$type","containerName":"name_contained_features","kind":13},{"name":"$num","kind":13,"containerName":"name_contained_features","line":188},{"containerName":"name_contained_features","kind":13,"name":"$ssf","line":189},{"containerName":"name_contained_features","kind":12,"name":"display_name","line":189}],"detail":"($self,$sf)","definition":"sub"},{"definition":"sub","detail":"($self,$sf)","children":[{"containerName":"generate_feature_name","localvar":"my","kind":13,"name":"$self","line":226,"definition":"my"},{"line":226,"containerName":"generate_feature_name","kind":13,"name":"$sf"},{"definition":"my","kind":13,"localvar":"my","containerName":"generate_feature_name","name":"$name","line":228},{"kind":13,"containerName":"generate_feature_name","name":"$sf","line":228},{"name":"display_name","kind":12,"containerName":"generate_feature_name","line":228},{"kind":13,"containerName":"generate_feature_name","name":"$name","line":229},{"line":230,"name":"$sf","containerName":"generate_feature_name","kind":13},{"name":"has_tag","containerName":"generate_feature_name","kind":12,"line":230},{"kind":13,"containerName":"generate_feature_name","name":"$name","line":231},{"line":231,"name":"$sf","containerName":"generate_feature_name","kind":13},{"line":231,"kind":12,"containerName":"generate_feature_name","name":"get_tag_values"},{"name":"$sf","kind":13,"containerName":"generate_feature_name","line":233},{"containerName":"generate_feature_name","kind":12,"name":"has_tag","line":233},{"line":234,"name":"$name","containerName":"generate_feature_name","kind":13},{"name":"$sf","containerName":"generate_feature_name","kind":13,"line":234},{"kind":12,"containerName":"generate_feature_name","name":"get_tag_values","line":234},{"line":236,"containerName":"generate_feature_name","kind":13,"name":"$sf"},{"containerName":"generate_feature_name","kind":12,"name":"primary_tag","line":236},{"name":"$sf","kind":13,"containerName":"generate_feature_name","line":237},{"line":237,"kind":12,"containerName":"generate_feature_name","name":"has_tag"},{"line":238,"kind":13,"containerName":"generate_feature_name","name":"$name"},{"kind":13,"containerName":"generate_feature_name","name":"$sf","line":238},{"kind":12,"containerName":"generate_feature_name","name":"get_tag_values","line":238},{"line":240,"kind":13,"containerName":"generate_feature_name","name":"$sf"},{"line":240,"kind":12,"containerName":"generate_feature_name","name":"primary_tag"},{"line":241,"name":"$sf","kind":13,"containerName":"generate_feature_name"},{"kind":12,"containerName":"generate_feature_name","name":"has_tag","line":241},{"line":242,"containerName":"generate_feature_name","kind":13,"name":"$name"},{"kind":13,"containerName":"generate_feature_name","name":"$sf","line":242},{"line":242,"kind":12,"containerName":"generate_feature_name","name":"get_tag_values"},{"line":245,"containerName":"generate_feature_name","kind":13,"name":"$name"},{"name":"$sf","kind":13,"containerName":"generate_feature_name","line":245},{"line":245,"kind":12,"containerName":"generate_feature_name","name":"display_name"},{"line":248,"name":"$name","kind":13,"containerName":"generate_feature_name"}],"containerName":"main::","name":"generate_feature_name","signature":{"documentation":"1;\n# $Id: FeatureNamer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::FeatureNamer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::FeatureNamer - generates unique persistent names for features\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::FeatureNamer;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $namer = Bio::SeqFeature::Tools::FeatureNamer->new;\n  my @features = $seq->get_SeqFeatures;\n  foreach my $feature (@features) {\n    $namer->name_feature($feature) unless $feature->display_name;\n  }  \n\n=head1 DESCRIPTION\n\nThis is a helper class for providing names for SeqFeatures\n\nThe L<Bio::SeqFeatureI> class provides a display_name\nmethod. Typically the display_name is not set when parsing formats\nsuch as genbank - instead properties such as B<label>, B<product> or\nB<gene> are set in a somewhat inconsistent manner.\n\nIn addition, when generating subfeatures (for example, exons that are\nsubfeatures of a transcript feature), it is often desirable to name\nthese subfeatures before either exporting to another format or\nreporting to the user.\n\nThis module is intended to help given uniform display_names to\nfeatures and their subfeatures.\n\n=head1 TODO\n\nCurrently the naming policy is hardcoded. It may be desirable to allow\nplugging in variations on naming policies; this could be done either\nby subclassing, anonymous subroutines (closures) or\nparameterization. Contact the author if you feel you have need for a\ndifferent naming policy\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm AT fruitfly DOT org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::FeatureNamer;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::FeatureNamer->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::FeatureNamer\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n#    my($typemap) =\n#\t$self->_rearrange([qw(TYPEMAP\n#\t\t\t     )],\n#                          @args);#\n\n#    $typemap  && $self->typemap($typemap);\n    return $self; # success - we hope!\n}\n\n=head2 name_feature\n\n Title   : name_feature\n Usage   : $namer->name_feature($sf);\n Function: sets display_name\n Example :\n Returns : \n Args    : L<Bio::SeqFeatureI>\n\nThis method calls generate_feature_name() and uses the returned value\nto set the display_name of the feature\n\n\nsub name_feature {\n    my ($self, $sf) = @_;\n    my $name = $self->generate_feature_name($sf);\n    $sf->display_name($name);\n}\n\n=head2 name_contained_features\n\n Title   : name_contained_features\n Usage   : $namer->name_contained_features($sf);\n Function: sets display_name for all features contained by sf\n Example :\n Returns : \n Args    : L<Bio::SeqFeatureI>\n\niterates through all subfeatures of a certain feature (using\nget_all_SeqFeatures) and names each subfeatures, based on the\ngenerated name for the holder feature\n\nA subfeature is named by concatenating the generated name of the\ncontainer feature with the type and a number.\n\nFor example, if the containing feature is a gene with display name\nB<dpp>, subfeatures will be named dpp-mRNA-1 dpp-mRNA2 dpp-exon1\ndpp-exon2 etc\n\n\nsub name_contained_features{\n   my ($self,$sf) = @_;\n   my $cname = $self->generate_feature_name($sf);\n   my @subsfs = $sf->get_all_SeqFeatures;\n   my %num_by_type = ();\n   foreach my $ssf (@subsfs) {\n       my $type = $ssf->primary_tag;\n       my $num = $num_by_type{$type} || 0;\n       $num++;\n       $num_by_type{$type} = $num;\n       $ssf->display_name(\"$cname-$type-$num\");\n   }\n   return;\n}\n\n=head2 generate_feature_name\n\n Title   : generate_feature_name\n Usage   : $name = $namer->generate_feature_name($sf);\n Function: derives a sensible human readable name for a $sf\n Example :\n Returns : str\n Args    : L<Bio::SeqFeatureI>\n\nreturns a generated name (but does not actually set display_name).\n\nIf display_name is already set, the method will return this\n\nOtherwise, the name will depend on the property:\n\n\n* label\n\n* product\n\n* gene\n\n* locus_tag\n\n\n(in order of priority)","parameters":[{"label":"$self"},{"label":"$sf"}],"label":"generate_feature_name($self,$sf)"},"line":225,"kind":12,"range":{"end":{"character":9999,"line":249},"start":{"line":225,"character":0}}}],"version":5}