{"vars":[{"name":"base","kind":2,"containerName":"","line":75},{"signature":{"documentation":"","parameters":[{"label":"$caller"},{"label":"@args"}],"label":"new($caller,@args)"},"kind":12,"range":{"start":{"character":0,"line":77},"end":{"line":87,"character":9999}},"line":77,"detail":"($caller,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"line":78,"name":"$caller","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":78},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":79,"definition":"my"},{"line":79,"name":"$caller","kind":13,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":79},{"name":"$self","containerName":"new","kind":13,"line":80},{"name":"_register_for_cleanup","kind":12,"containerName":"new","line":80},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$primary","line":81},{"name":"$self","containerName":"new","kind":13,"line":81},{"line":81,"kind":12,"containerName":"new","name":"_rearrange"},{"line":81,"containerName":"new","kind":13,"name":"@args"},{"kind":13,"containerName":"new","name":"$primary","line":83},{"name":"$primary","kind":13,"containerName":"new","line":83},{"line":84,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"primary_tag","line":84},{"kind":13,"containerName":"new","name":"$primary","line":84},{"line":85,"name":"$self","kind":13,"containerName":"new"},{"line":85,"kind":12,"containerName":"new","name":"strand"},{"kind":13,"containerName":"new","name":"$self","line":85},{"line":85,"name":"strand","containerName":"new","kind":12},{"line":86,"containerName":"new","kind":13,"name":"$self"}]},{"name":"SUPER","containerName":"new","kind":12,"line":79},{"name":"transcript_destroy","kind":12,"line":80},{"signature":{"label":"promoters($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : "},"line":107,"kind":12,"range":{"end":{"line":110,"character":9999},"start":{"line":107,"character":0}},"definition":"sub","detail":"($self)","children":[{"localvar":"my","kind":13,"containerName":"promoters","name":"$self","line":108,"definition":"my"},{"containerName":"promoters","kind":13,"name":"$self","line":109},{"containerName":"promoters","kind":12,"name":"get_feature_type","line":109}],"containerName":"main::","name":"promoters"},{"range":{"end":{"character":9999,"line":132},"start":{"line":129,"character":0}},"kind":12,"line":129,"signature":{"label":"add_promoter($self,$fea)","parameters":[{"label":"$self"},{"label":"$fea"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object."},"name":"add_promoter","containerName":"main::","children":[{"line":130,"containerName":"add_promoter","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":130,"containerName":"add_promoter","kind":13,"name":"$fea"},{"name":"$self","containerName":"add_promoter","kind":13,"line":131},{"containerName":"add_promoter","kind":12,"name":"_add","line":131},{"line":131,"containerName":"add_promoter","kind":13,"name":"$fea"}],"detail":"($self,$fea)","definition":"sub"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"flush_promoters","line":151},{"containerName":"flush_promoters","kind":13,"name":"$self","line":152},{"line":152,"name":"_flush","containerName":"flush_promoters","kind":12}],"containerName":"main::","name":"flush_promoters","signature":{"label":"flush_promoters($self)","documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none","parameters":[{"label":"$self"}]},"line":150,"range":{"end":{"line":153,"character":9999},"start":{"line":150,"character":0}},"kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.","label":"exons($self,$type)"},"range":{"start":{"character":0,"line":173},"end":{"line":177,"character":9999}},"kind":12,"line":173,"detail":"($self,$type)","definition":"sub","name":"exons","containerName":"main::","children":[{"definition":"my","containerName":"exons","localvar":"my","kind":13,"name":"$self","line":174},{"line":174,"containerName":"exons","kind":13,"name":"$type"},{"line":175,"name":"$self","containerName":"exons","kind":13},{"name":"get_unordered_feature_type","containerName":"exons","kind":12,"line":175},{"line":176,"containerName":"exons","kind":13,"name":"$type"}]},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"exons_ordered","line":196},{"line":196,"name":"$type","containerName":"exons_ordered","kind":13},{"name":"$self","containerName":"exons_ordered","kind":13,"line":197},{"line":197,"name":"get_feature_type","kind":12,"containerName":"exons_ordered"},{"kind":13,"containerName":"exons_ordered","name":"$type","line":197}],"containerName":"main::","name":"exons_ordered","definition":"sub","detail":"($self,$type)","line":195,"range":{"end":{"character":9999,"line":198},"start":{"character":0,"line":195}},"kind":12,"signature":{"label":"exons_ordered($self,$type)","documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.","parameters":[{"label":"$self"},{"label":"$type"}]}},{"children":[{"definition":"my","line":227,"localvar":"my","containerName":"add_exon","kind":13,"name":"$self"},{"line":227,"name":"$fea","kind":13,"containerName":"add_exon"},{"kind":13,"containerName":"add_exon","name":"$type","line":227},{"line":228,"containerName":"add_exon","kind":13,"name":"$fea"},{"name":"isa","kind":12,"containerName":"add_exon","line":228},{"containerName":"add_exon","kind":13,"name":"$self","line":229},{"line":229,"kind":12,"containerName":"add_exon","name":"throw"},{"line":231,"name":"$self","containerName":"add_exon","kind":13},{"name":"_add","kind":12,"containerName":"add_exon","line":231},{"kind":13,"containerName":"add_exon","name":"$fea","line":231},{"containerName":"add_exon","kind":13,"name":"$type","line":231}],"name":"add_exon","containerName":"main::","definition":"sub","detail":"($self,$fea,$type)","line":226,"kind":12,"range":{"end":{"line":232,"character":9999},"start":{"character":0,"line":226}},"signature":{"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).","parameters":[{"label":"$self"},{"label":"$fea"},{"label":"$type"}],"label":"add_exon($self,$fea,$type)"}},{"signature":{"label":"flush_exons($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional)."},"kind":12,"range":{"start":{"character":0,"line":251},"end":{"line":254,"character":9999}},"line":251,"detail":"($self,$type)","definition":"sub","containerName":"main::","name":"flush_exons","children":[{"definition":"my","line":252,"localvar":"my","kind":13,"containerName":"flush_exons","name":"$self"},{"name":"$type","containerName":"flush_exons","kind":13,"line":252},{"name":"$self","kind":13,"containerName":"flush_exons","line":253},{"line":253,"kind":12,"containerName":"flush_exons","name":"_flush"},{"kind":13,"containerName":"flush_exons","name":"$type","line":253}]},{"definition":"sub","detail":"($self)","children":[{"line":280,"name":"$self","containerName":"introns","localvar":"my","kind":13,"definition":"my"},{"line":281,"localvar":"my","containerName":"introns","kind":13,"name":"@introns","definition":"my"},{"definition":"my","localvar":"my","containerName":"introns","kind":13,"name":"@exons","line":282},{"containerName":"introns","kind":13,"name":"$self","line":282},{"name":"exons","containerName":"introns","kind":12,"line":282},{"line":283,"name":"$strand","kind":13,"localvar":"my","containerName":"introns","definition":"my"},{"line":283,"name":"$rev_order","kind":13,"containerName":"introns"},{"localvar":"my","containerName":"introns","kind":13,"name":"$exon","line":289,"definition":"my"},{"line":289,"containerName":"introns","kind":13,"name":"@exons"},{"containerName":"introns","kind":13,"name":"$strand","line":290},{"line":290,"name":"$exon","kind":13,"containerName":"introns"},{"kind":12,"containerName":"introns","name":"strand","line":290},{"name":"$strand","kind":13,"containerName":"introns","line":291},{"containerName":"introns","kind":13,"name":"$rev_order","line":293},{"kind":13,"containerName":"introns","name":"$exons","line":293},{"name":"end","kind":12,"containerName":"introns","line":293},{"line":293,"name":"$exons","containerName":"introns","kind":13},{"kind":12,"containerName":"introns","name":"start","line":293},{"line":297,"containerName":"introns","kind":13,"name":"$strand"},{"line":297,"name":"$strand","kind":13,"containerName":"introns"},{"name":"$rev_order","kind":13,"containerName":"introns","line":297},{"line":300,"name":"@exons","containerName":"introns","kind":13},{"kind":13,"containerName":"introns","name":"$a","line":300},{"containerName":"introns","kind":13,"name":"$b","line":300},{"name":"start","kind":12,"containerName":"introns","line":301},{"line":301,"containerName":"introns","kind":12,"name":"strand"},{"name":"@exons","kind":13,"containerName":"introns","line":301},{"kind":13,"containerName":"introns","name":"@exons","line":305},{"kind":13,"containerName":"introns","name":"$b","line":305},{"name":"$a","containerName":"introns","kind":13,"line":305},{"line":305,"name":"start","containerName":"introns","kind":12},{"line":305,"name":"@exons","containerName":"introns","kind":13},{"kind":13,"localvar":"my","containerName":"introns","name":"$exonA","line":308,"definition":"my"},{"line":308,"name":"@exons","containerName":"introns","kind":13},{"definition":"my","line":308,"localvar":"my","containerName":"introns","kind":13,"name":"$exonB"},{"line":308,"kind":13,"containerName":"introns","name":"@exons"},{"definition":"my","line":309,"name":"$intron","kind":13,"localvar":"my","containerName":"introns"},{"containerName":"introns","kind":12,"name":"new","line":309},{"line":310,"kind":13,"containerName":"introns","name":"$intron"},{"line":310,"kind":12,"containerName":"introns","name":"upstream_Exon"},{"name":"$exonA","containerName":"introns","kind":13,"line":310},{"kind":13,"containerName":"introns","name":"$intron","line":311},{"line":311,"containerName":"introns","kind":12,"name":"downstream_Exon"},{"line":311,"name":"$exonB","containerName":"introns","kind":13},{"line":312,"name":"$intron","kind":13,"containerName":"introns"},{"line":312,"name":"attach_seq","containerName":"introns","kind":12},{"name":"$self","kind":13,"containerName":"introns","line":312},{"line":312,"containerName":"introns","kind":12,"name":"entire_seq"},{"name":"$self","kind":13,"containerName":"introns","line":312},{"line":312,"kind":12,"containerName":"introns","name":"entire_seq"},{"line":313,"name":"@exons","kind":13,"containerName":"introns"},{"name":"$exonB","containerName":"introns","kind":13,"line":313},{"name":"@introns","kind":13,"containerName":"introns","line":314},{"line":314,"containerName":"introns","kind":13,"name":"$intron"},{"line":316,"kind":13,"containerName":"introns","name":"@introns"}],"containerName":"main::","name":"introns","signature":{"label":"introns($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : "},"line":279,"range":{"start":{"line":279,"character":0},"end":{"line":317,"character":9999}},"kind":12},{"kind":12,"name":"exons","line":286},{"containerName":"SeqFeature::Gene::Intron","kind":12,"name":"Bio","line":309},{"definition":"sub","detail":"($self,$fea)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"poly_A_site","kind":13,"line":333},{"line":333,"containerName":"poly_A_site","kind":13,"name":"$fea"},{"line":334,"kind":13,"containerName":"poly_A_site","name":"$fea"},{"name":"$self","kind":13,"containerName":"poly_A_site","line":335},{"line":335,"name":"_add","containerName":"poly_A_site","kind":12},{"containerName":"poly_A_site","kind":13,"name":"$fea","line":335},{"containerName":"poly_A_site","kind":13,"name":"$self","line":337},{"line":337,"containerName":"poly_A_site","kind":12,"name":"get_feature_type"}],"name":"poly_A_site","containerName":"main::","signature":{"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.","parameters":[{"label":"$self"},{"label":"$fea"}],"label":"poly_A_site($self,$fea)"},"line":332,"kind":12,"range":{"end":{"line":338,"character":9999},"start":{"character":0,"line":332}}},{"name":"utrs","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"utrs","line":362,"definition":"my"},{"name":"$type","kind":13,"containerName":"utrs","line":362},{"line":363,"kind":13,"containerName":"utrs","name":"$self"},{"kind":12,"containerName":"utrs","name":"get_feature_type","line":363},{"line":363,"containerName":"utrs","kind":13,"name":"$type"}],"detail":"($self,$type)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":365},"start":{"character":0,"line":361}},"line":361,"signature":{"label":"utrs($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature."}},{"signature":{"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self, $type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::UTR',$type);\n\n}\n\n=head2 add_utr\n\n Title   : add_utr()\n Usage   : $transcript->add_utr($utrobj, 'utr3prime');\n           $transcript->add_utr($utrobj);\n Function: Add a UTR feature/site to this transcript.\n\n           The second parameter is optional and denotes the type of the UTR\n           feature. Presently recognized types include 'utr5prime' and 'utr3prime'\n           for UTR on the 5' and 3' end of a gene, respectively.\n\n           Calling this method is the same as calling \n           add_exon($utrobj, 'utr'.$type). In this sense a UTR object is a\n           special exon object, which is transcribed, not spliced out, but\n           not translated.\n\n           Note that the object supplied should return FALSE for is_coding().\n           Otherwise cds() and friends will become confused.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::UTR implementing object.","parameters":[{"label":"$self"},{"label":"$fea"},{"label":"$type"}],"label":"add_utr($self,$fea,$type)"},"line":392,"range":{"end":{"character":9999,"line":395},"start":{"character":0,"line":392}},"kind":12,"definition":"sub","detail":"($self,$fea,$type)","children":[{"line":393,"name":"$self","localvar":"my","kind":13,"containerName":"add_utr","definition":"my"},{"line":393,"kind":13,"containerName":"add_utr","name":"$fea"},{"line":393,"name":"$type","kind":13,"containerName":"add_utr"},{"containerName":"add_utr","kind":13,"name":"$self","line":394},{"kind":12,"containerName":"add_utr","name":"_add","line":394},{"line":394,"containerName":"add_utr","kind":13,"name":"$fea"},{"name":"$type","containerName":"add_utr","kind":13,"line":394}],"name":"add_utr","containerName":"main::"},{"children":[{"line":413,"name":"$self","localvar":"my","kind":13,"containerName":"flush_utrs","definition":"my"},{"line":413,"containerName":"flush_utrs","kind":13,"name":"$type"},{"line":414,"containerName":"flush_utrs","kind":13,"name":"$self"},{"kind":12,"containerName":"flush_utrs","name":"_flush","line":414},{"line":414,"kind":13,"containerName":"flush_utrs","name":"$type"}],"containerName":"main::","name":"flush_utrs","definition":"sub","detail":"($self,$type)","line":412,"range":{"end":{"character":9999,"line":415},"start":{"character":0,"line":412}},"kind":12,"signature":{"label":"flush_utrs($self,$type)","documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self, $type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::UTR',$type);\n\n}\n\n=head2 add_utr\n\n Title   : add_utr()\n Usage   : $transcript->add_utr($utrobj, 'utr3prime');\n           $transcript->add_utr($utrobj);\n Function: Add a UTR feature/site to this transcript.\n\n           The second parameter is optional and denotes the type of the UTR\n           feature. Presently recognized types include 'utr5prime' and 'utr3prime'\n           for UTR on the 5' and 3' end of a gene, respectively.\n\n           Calling this method is the same as calling \n           add_exon($utrobj, 'utr'.$type). In this sense a UTR object is a\n           special exon object, which is transcribed, not spliced out, but\n           not translated.\n\n           Note that the object supplied should return FALSE for is_coding().\n           Otherwise cds() and friends will become confused.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::UTR implementing object.\n\n\n\nsub add_utr {\n    my ($self, $fea, $type) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 flush_utrs\n\n Title   : flush_utrs()\n Usage   : $transcript->flush_utrs();\n           $transcript->flush_utrs('utr3prime');\n Function: Remove all or a specific type of UTR features/sites from this\n           transcript.\n\n           Cf. add_utr() for documentation about recognized types.\n Returns : a list of the removed features\n Args    : Optionally a string denoting the type of UTR feature.","parameters":[{"label":"$self"},{"label":"$type"}]}},{"signature":{"label":"sub_SeqFeature($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self, $type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::UTR',$type);\n\n}\n\n=head2 add_utr\n\n Title   : add_utr()\n Usage   : $transcript->add_utr($utrobj, 'utr3prime');\n           $transcript->add_utr($utrobj);\n Function: Add a UTR feature/site to this transcript.\n\n           The second parameter is optional and denotes the type of the UTR\n           feature. Presently recognized types include 'utr5prime' and 'utr3prime'\n           for UTR on the 5' and 3' end of a gene, respectively.\n\n           Calling this method is the same as calling \n           add_exon($utrobj, 'utr'.$type). In this sense a UTR object is a\n           special exon object, which is transcribed, not spliced out, but\n           not translated.\n\n           Note that the object supplied should return FALSE for is_coding().\n           Otherwise cds() and friends will become confused.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::UTR implementing object.\n\n\n\nsub add_utr {\n    my ($self, $fea, $type) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 flush_utrs\n\n Title   : flush_utrs()\n Usage   : $transcript->flush_utrs();\n           $transcript->flush_utrs('utr3prime');\n Function: Remove all or a specific type of UTR features/sites from this\n           transcript.\n\n           Cf. add_utr() for documentation about recognized types.\n Returns : a list of the removed features\n Args    : Optionally a string denoting the type of UTR feature.\n\n\n\nsub flush_utrs {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $transcript->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the exon etc features.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none"},"kind":12,"range":{"start":{"character":0,"line":432},"end":{"character":9999,"line":443}},"line":432,"detail":"($self)","definition":"sub","containerName":"main::","name":"sub_SeqFeature","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"sub_SeqFeature","name":"$self","line":433},{"line":434,"kind":13,"localvar":"my","containerName":"sub_SeqFeature","name":"@feas","definition":"my"},{"kind":13,"containerName":"sub_SeqFeature","name":"@feas","line":437},{"kind":13,"containerName":"sub_SeqFeature","name":"$self","line":437},{"name":"@feas","containerName":"sub_SeqFeature","kind":13,"line":439},{"line":439,"name":"$self","kind":13,"containerName":"sub_SeqFeature"},{"line":439,"name":"exons","kind":12,"containerName":"sub_SeqFeature"},{"line":440,"name":"@feas","kind":13,"containerName":"sub_SeqFeature"},{"line":440,"containerName":"sub_SeqFeature","kind":13,"name":"$self"},{"line":440,"kind":12,"containerName":"sub_SeqFeature","name":"promoters"},{"line":441,"name":"@feas","containerName":"sub_SeqFeature","kind":13},{"line":441,"containerName":"sub_SeqFeature","kind":13,"name":"$self"},{"name":"poly_A_site","kind":12,"containerName":"sub_SeqFeature","line":441},{"containerName":"sub_SeqFeature","kind":13,"name":"$self","line":441},{"name":"poly_A_site","kind":12,"containerName":"sub_SeqFeature","line":441},{"line":442,"name":"@feas","containerName":"sub_SeqFeature","kind":13}]},{"containerName":"sub_SeqFeature","kind":12,"name":"SUPER","line":437},{"definition":"sub","detail":"($self,$fea_only)","children":[{"line":467,"localvar":"my","containerName":"flush_sub_SeqFeature","kind":13,"name":"$self","definition":"my"},{"line":467,"kind":13,"containerName":"flush_sub_SeqFeature","name":"$fea_only"},{"line":469,"name":"$self","containerName":"flush_sub_SeqFeature","kind":13},{"name":"$fea_only","containerName":"flush_sub_SeqFeature","kind":13,"line":470},{"line":471,"name":"$self","containerName":"flush_sub_SeqFeature","kind":13},{"name":"flush_promoters","kind":12,"containerName":"flush_sub_SeqFeature","line":471},{"line":472,"containerName":"flush_sub_SeqFeature","kind":13,"name":"$self"},{"name":"flush_exons","kind":12,"containerName":"flush_sub_SeqFeature","line":472},{"line":473,"kind":13,"containerName":"flush_sub_SeqFeature","name":"$self"},{"line":473,"name":"flush_utrs","containerName":"flush_sub_SeqFeature","kind":12},{"line":474,"kind":13,"containerName":"flush_sub_SeqFeature","name":"$self"},{"name":"poly_A_site","containerName":"flush_sub_SeqFeature","kind":12,"line":474}],"containerName":"main::","name":"flush_sub_SeqFeature","signature":{"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self, $type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::UTR',$type);\n\n}\n\n=head2 add_utr\n\n Title   : add_utr()\n Usage   : $transcript->add_utr($utrobj, 'utr3prime');\n           $transcript->add_utr($utrobj);\n Function: Add a UTR feature/site to this transcript.\n\n           The second parameter is optional and denotes the type of the UTR\n           feature. Presently recognized types include 'utr5prime' and 'utr3prime'\n           for UTR on the 5' and 3' end of a gene, respectively.\n\n           Calling this method is the same as calling \n           add_exon($utrobj, 'utr'.$type). In this sense a UTR object is a\n           special exon object, which is transcribed, not spliced out, but\n           not translated.\n\n           Note that the object supplied should return FALSE for is_coding().\n           Otherwise cds() and friends will become confused.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::UTR implementing object.\n\n\n\nsub add_utr {\n    my ($self, $fea, $type) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 flush_utrs\n\n Title   : flush_utrs()\n Usage   : $transcript->flush_utrs();\n           $transcript->flush_utrs('utr3prime');\n Function: Remove all or a specific type of UTR features/sites from this\n           transcript.\n\n           Cf. add_utr() for documentation about recognized types.\n Returns : a list of the removed features\n Args    : Optionally a string denoting the type of UTR feature.\n\n\n\nsub flush_utrs {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $transcript->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the exon etc features.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none\n\n\n\nsub sub_SeqFeature {\n   my ($self) = @_;   \n   my @feas;\n   \n   # get what the parent already has\n   @feas = $self->SUPER::sub_SeqFeature();\n   # add the features we have in addition\n   push(@feas, $self->exons()); # this includes UTR features\n   push(@feas, $self->promoters());\n   push(@feas, $self->poly_A_site()) if($self->poly_A_site());\n   return @feas;\n}\n\n=head2 flush_sub_SeqFeature\n\n Title   : flush_sub_SeqFeature\n Usage   : $transcript->flush_sub_SeqFeature();\n           $transcript->flush_sub_SeqFeature(1);\n Function: Removes all subfeatures.\n\n           This method is overridden from Bio::SeqFeature::Generic to flush\n           all additional subfeatures like exons, promoters, etc., which is\n           almost certainly not what you want. To remove only features added\n           through $transcript->add_sub_SeqFeature($feature) pass any\n           argument evaluating to TRUE.\n\n Example :\n Returns : none\n Args    : Optionally, an argument evaluating to TRUE will suppress flushing\n           of all transcript-specific subfeatures (exons etc.).","parameters":[{"label":"$self"},{"label":"$fea_only"}],"label":"flush_sub_SeqFeature($self,$fea_only)"},"line":466,"kind":12,"range":{"end":{"line":476,"character":9999},"start":{"character":0,"line":466}}},{"name":"SUPER","kind":12,"containerName":"flush_sub_SeqFeature","line":469},{"containerName":"main::","name":"cds","children":[{"definition":"my","line":503,"name":"$self","localvar":"my","containerName":"cds","kind":13},{"line":504,"containerName":"cds","localvar":"my","kind":13,"name":"@exons","definition":"my"},{"line":504,"name":"$self","containerName":"cds","kind":13},{"containerName":"cds","kind":12,"name":"exons_ordered","line":504},{"line":505,"kind":13,"localvar":"my","containerName":"cds","name":"$strand","definition":"my"},{"line":507,"containerName":"cds","kind":13,"name":"@exons"},{"definition":"my","line":510,"name":"$exon","containerName":"cds","localvar":"my","kind":13},{"line":510,"kind":13,"containerName":"cds","name":"@exons"},{"containerName":"cds","kind":13,"name":"$exon","line":511},{"line":511,"containerName":"cds","kind":12,"name":"strand"},{"containerName":"cds","kind":13,"name":"$strand","line":511},{"line":512,"containerName":"cds","kind":13,"name":"$strand"},{"line":512,"containerName":"cds","kind":13,"name":"$exon"},{"name":"strand","containerName":"cds","kind":12,"line":512},{"name":"$exon","kind":13,"containerName":"cds","line":514},{"line":514,"name":"strand","containerName":"cds","kind":12},{"name":"$exon","containerName":"cds","kind":13,"line":514},{"line":514,"name":"strand","kind":12,"containerName":"cds"},{"line":514,"containerName":"cds","kind":13,"name":"$strand"},{"line":515,"containerName":"cds","kind":13,"name":"$self"},{"line":515,"kind":12,"containerName":"cds","name":"throw"},{"definition":"my","name":"$cds","containerName":"cds","localvar":"my","kind":13,"line":519},{"line":519,"name":"$self","containerName":"cds","kind":13},{"name":"_make_cds","containerName":"cds","kind":12,"line":519},{"line":519,"name":"@exons","kind":13,"containerName":"cds"},{"name":"$cds","containerName":"cds","kind":13,"line":520},{"line":521,"containerName":"cds","kind":12,"name":"new"},{"line":521,"kind":13,"containerName":"cds","name":"$self"},{"name":"seq_id","containerName":"cds","kind":12,"line":521},{"line":522,"name":"$cds","containerName":"cds","kind":13}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":502},"end":{"line":524,"character":9999}},"line":502,"signature":{"label":"cds($self)","documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self, $type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::UTR',$type);\n\n}\n\n=head2 add_utr\n\n Title   : add_utr()\n Usage   : $transcript->add_utr($utrobj, 'utr3prime');\n           $transcript->add_utr($utrobj);\n Function: Add a UTR feature/site to this transcript.\n\n           The second parameter is optional and denotes the type of the UTR\n           feature. Presently recognized types include 'utr5prime' and 'utr3prime'\n           for UTR on the 5' and 3' end of a gene, respectively.\n\n           Calling this method is the same as calling \n           add_exon($utrobj, 'utr'.$type). In this sense a UTR object is a\n           special exon object, which is transcribed, not spliced out, but\n           not translated.\n\n           Note that the object supplied should return FALSE for is_coding().\n           Otherwise cds() and friends will become confused.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::UTR implementing object.\n\n\n\nsub add_utr {\n    my ($self, $fea, $type) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 flush_utrs\n\n Title   : flush_utrs()\n Usage   : $transcript->flush_utrs();\n           $transcript->flush_utrs('utr3prime');\n Function: Remove all or a specific type of UTR features/sites from this\n           transcript.\n\n           Cf. add_utr() for documentation about recognized types.\n Returns : a list of the removed features\n Args    : Optionally a string denoting the type of UTR feature.\n\n\n\nsub flush_utrs {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $transcript->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the exon etc features.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none\n\n\n\nsub sub_SeqFeature {\n   my ($self) = @_;   \n   my @feas;\n   \n   # get what the parent already has\n   @feas = $self->SUPER::sub_SeqFeature();\n   # add the features we have in addition\n   push(@feas, $self->exons()); # this includes UTR features\n   push(@feas, $self->promoters());\n   push(@feas, $self->poly_A_site()) if($self->poly_A_site());\n   return @feas;\n}\n\n=head2 flush_sub_SeqFeature\n\n Title   : flush_sub_SeqFeature\n Usage   : $transcript->flush_sub_SeqFeature();\n           $transcript->flush_sub_SeqFeature(1);\n Function: Removes all subfeatures.\n\n           This method is overridden from Bio::SeqFeature::Generic to flush\n           all additional subfeatures like exons, promoters, etc., which is\n           almost certainly not what you want. To remove only features added\n           through $transcript->add_sub_SeqFeature($feature) pass any\n           argument evaluating to TRUE.\n\n Example :\n Returns : none\n Args    : Optionally, an argument evaluating to TRUE will suppress flushing\n           of all transcript-specific subfeatures (exons etc.).\n\n\n\nsub flush_sub_SeqFeature {\n   my ($self,$fea_only) = @_;\n\n   $self->SUPER::flush_sub_SeqFeature();\n   if(! $fea_only) {\n       $self->flush_promoters();\n       $self->flush_exons();\n       $self->flush_utrs();\n       $self->poly_A_site(0);\n   }\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $seq = $transcript->cds();\n Function: Returns the CDS (coding sequence) as defined by the exons\n           of this transcript and the attached sequence.\n\n           If no sequence is attached this method will return false.\n\n           Note that the implementation provided here returns a\n           concatenation of all coding exons, thereby assuming that\n           exons do not overlap.\n\n           Note also that you cannot set the CDS via this method. Set\n           a single CDS feature as a single exon, or derive your own\n           class if you want to store a predicted CDS.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","parameters":[{"label":"$self"}]}},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":521},{"children":[{"localvar":"my","kind":13,"containerName":"protein","name":"$self","line":542,"definition":"my"},{"definition":"my","name":"$seq","localvar":"my","kind":13,"containerName":"protein","line":543},{"line":545,"name":"$seq","kind":13,"containerName":"protein"},{"kind":13,"containerName":"protein","name":"$self","line":545},{"kind":12,"containerName":"protein","name":"cds","line":545},{"name":"$seq","containerName":"protein","kind":13,"line":546},{"line":546,"kind":12,"containerName":"protein","name":"translate"},{"name":"$seq","kind":13,"containerName":"protein","line":546}],"name":"protein","containerName":"main::","definition":"sub","detail":"($self)","line":541,"range":{"start":{"line":541,"character":0},"end":{"line":548,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self, $type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::UTR',$type);\n\n}\n\n=head2 add_utr\n\n Title   : add_utr()\n Usage   : $transcript->add_utr($utrobj, 'utr3prime');\n           $transcript->add_utr($utrobj);\n Function: Add a UTR feature/site to this transcript.\n\n           The second parameter is optional and denotes the type of the UTR\n           feature. Presently recognized types include 'utr5prime' and 'utr3prime'\n           for UTR on the 5' and 3' end of a gene, respectively.\n\n           Calling this method is the same as calling \n           add_exon($utrobj, 'utr'.$type). In this sense a UTR object is a\n           special exon object, which is transcribed, not spliced out, but\n           not translated.\n\n           Note that the object supplied should return FALSE for is_coding().\n           Otherwise cds() and friends will become confused.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::UTR implementing object.\n\n\n\nsub add_utr {\n    my ($self, $fea, $type) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 flush_utrs\n\n Title   : flush_utrs()\n Usage   : $transcript->flush_utrs();\n           $transcript->flush_utrs('utr3prime');\n Function: Remove all or a specific type of UTR features/sites from this\n           transcript.\n\n           Cf. add_utr() for documentation about recognized types.\n Returns : a list of the removed features\n Args    : Optionally a string denoting the type of UTR feature.\n\n\n\nsub flush_utrs {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $transcript->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the exon etc features.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none\n\n\n\nsub sub_SeqFeature {\n   my ($self) = @_;   \n   my @feas;\n   \n   # get what the parent already has\n   @feas = $self->SUPER::sub_SeqFeature();\n   # add the features we have in addition\n   push(@feas, $self->exons()); # this includes UTR features\n   push(@feas, $self->promoters());\n   push(@feas, $self->poly_A_site()) if($self->poly_A_site());\n   return @feas;\n}\n\n=head2 flush_sub_SeqFeature\n\n Title   : flush_sub_SeqFeature\n Usage   : $transcript->flush_sub_SeqFeature();\n           $transcript->flush_sub_SeqFeature(1);\n Function: Removes all subfeatures.\n\n           This method is overridden from Bio::SeqFeature::Generic to flush\n           all additional subfeatures like exons, promoters, etc., which is\n           almost certainly not what you want. To remove only features added\n           through $transcript->add_sub_SeqFeature($feature) pass any\n           argument evaluating to TRUE.\n\n Example :\n Returns : none\n Args    : Optionally, an argument evaluating to TRUE will suppress flushing\n           of all transcript-specific subfeatures (exons etc.).\n\n\n\nsub flush_sub_SeqFeature {\n   my ($self,$fea_only) = @_;\n\n   $self->SUPER::flush_sub_SeqFeature();\n   if(! $fea_only) {\n       $self->flush_promoters();\n       $self->flush_exons();\n       $self->flush_utrs();\n       $self->poly_A_site(0);\n   }\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $seq = $transcript->cds();\n Function: Returns the CDS (coding sequence) as defined by the exons\n           of this transcript and the attached sequence.\n\n           If no sequence is attached this method will return false.\n\n           Note that the implementation provided here returns a\n           concatenation of all coding exons, thereby assuming that\n           exons do not overlap.\n\n           Note also that you cannot set the CDS via this method. Set\n           a single CDS feature as a single exon, or derive your own\n           class if you want to store a predicted CDS.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\nsub cds {\n    my ($self) = @_;\n    my @exons = $self->exons_ordered();  #this is always sorted properly according to strand\n    my $strand;\n\n    return  unless(@exons);\n    # record strand (a minus-strand transcript must have the exons sorted in\n    # reverse order)\n    foreach my $exon (@exons) {\n\tif(defined($exon->strand()) && (! $strand)) {\n\t    $strand = $exon->strand();\n\t}\n\tif($exon->strand() && (($exon->strand() * $strand) < 0)) {\n\t    $self->throw(\"Transcript mixes coding exons on plus and minus \".\n\t\t\t \"strand. This makes no sense.\");\n\t}\n    }\n    my $cds = $self->_make_cds(@exons);\n    return unless $cds;\n    return Bio::PrimarySeq->new('-id' => $self->seq_id(),\n\t\t\t\t'-seq' => $cds,\n\t\t\t\t'-alphabet' => \"dna\");\n}\n\n=head2 protein\n\n Title   : protein()\n Usage   : $protein = $transcript->protein();\n Function: Get the protein encoded by the transcript as a sequence object.\n\n           The implementation provided here simply calls translate() on the\n           object returned by cds().\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","parameters":[{"label":"$self"}],"label":"protein($self)"}},{"definition":"sub","detail":"($self)","children":[{"line":569,"kind":13,"localvar":"my","containerName":"mrna","name":"$self","definition":"my"},{"containerName":"mrna","localvar":"my","kind":13,"name":"$seq","line":570,"definition":"my"},{"line":570,"kind":13,"containerName":"mrna","name":"$mrna"},{"name":"$elem","kind":13,"containerName":"mrna","line":570},{"line":573,"containerName":"mrna","kind":13,"name":"$seq"},{"name":"$self","kind":13,"containerName":"mrna","line":573},{"line":573,"containerName":"mrna","kind":12,"name":"cds"},{"kind":13,"containerName":"mrna","name":"$seq","line":574},{"line":575,"name":"$seq","containerName":"mrna","kind":13},{"line":575,"kind":12,"containerName":"mrna","name":"new"},{"name":"$self","kind":13,"containerName":"mrna","line":575},{"line":575,"kind":12,"containerName":"mrna","name":"seq_id"},{"line":580,"name":"$mrna","kind":13,"containerName":"mrna"},{"line":581,"containerName":"mrna","kind":13,"name":"$elem"},{"containerName":"mrna","kind":13,"name":"$self","line":581},{"line":581,"name":"utrs","containerName":"mrna","kind":12},{"name":"$mrna","containerName":"mrna","kind":13,"line":582},{"line":582,"kind":13,"containerName":"mrna","name":"$elem"},{"line":582,"containerName":"mrna","kind":12,"name":"seq"},{"containerName":"mrna","kind":12,"name":"seq","line":582},{"line":584,"kind":13,"containerName":"mrna","name":"$seq"},{"containerName":"mrna","kind":12,"name":"seq","line":584},{"line":584,"containerName":"mrna","kind":13,"name":"$mrna"},{"line":584,"containerName":"mrna","kind":13,"name":"$seq"},{"name":"seq","kind":12,"containerName":"mrna","line":584},{"name":"$mrna","containerName":"mrna","kind":13,"line":585},{"line":586,"kind":13,"containerName":"mrna","name":"$elem"},{"containerName":"mrna","kind":13,"name":"$self","line":586},{"name":"utrs","kind":12,"containerName":"mrna","line":586},{"name":"$mrna","containerName":"mrna","kind":13,"line":587},{"name":"$elem","kind":13,"containerName":"mrna","line":587},{"name":"seq","containerName":"mrna","kind":12,"line":587},{"name":"seq","kind":12,"containerName":"mrna","line":587},{"line":589,"name":"$seq","kind":13,"containerName":"mrna"},{"line":589,"name":"seq","containerName":"mrna","kind":12},{"line":589,"name":"$seq","containerName":"mrna","kind":13},{"name":"seq","containerName":"mrna","kind":12,"line":589},{"name":"$mrna","kind":13,"containerName":"mrna","line":589},{"name":"$self","kind":13,"containerName":"mrna","line":590},{"line":590,"containerName":"mrna","kind":12,"name":"poly_A_site"},{"line":591,"name":"$seq","containerName":"mrna","kind":13},{"kind":12,"containerName":"mrna","name":"seq","line":591},{"name":"$seq","containerName":"mrna","kind":13,"line":591},{"line":591,"containerName":"mrna","kind":12,"name":"seq"},{"containerName":"mrna","kind":13,"name":"$self","line":591},{"line":591,"kind":12,"containerName":"mrna","name":"poly_A_site"},{"line":591,"kind":12,"containerName":"mrna","name":"seq"},{"line":591,"kind":12,"containerName":"mrna","name":"seq"},{"line":593,"containerName":"mrna","kind":13,"name":"$seq"},{"name":"length","containerName":"mrna","kind":12,"line":593},{"name":"$seq","containerName":"mrna","kind":13,"line":594}],"name":"mrna","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self, $type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::UTR',$type);\n\n}\n\n=head2 add_utr\n\n Title   : add_utr()\n Usage   : $transcript->add_utr($utrobj, 'utr3prime');\n           $transcript->add_utr($utrobj);\n Function: Add a UTR feature/site to this transcript.\n\n           The second parameter is optional and denotes the type of the UTR\n           feature. Presently recognized types include 'utr5prime' and 'utr3prime'\n           for UTR on the 5' and 3' end of a gene, respectively.\n\n           Calling this method is the same as calling \n           add_exon($utrobj, 'utr'.$type). In this sense a UTR object is a\n           special exon object, which is transcribed, not spliced out, but\n           not translated.\n\n           Note that the object supplied should return FALSE for is_coding().\n           Otherwise cds() and friends will become confused.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::UTR implementing object.\n\n\n\nsub add_utr {\n    my ($self, $fea, $type) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 flush_utrs\n\n Title   : flush_utrs()\n Usage   : $transcript->flush_utrs();\n           $transcript->flush_utrs('utr3prime');\n Function: Remove all or a specific type of UTR features/sites from this\n           transcript.\n\n           Cf. add_utr() for documentation about recognized types.\n Returns : a list of the removed features\n Args    : Optionally a string denoting the type of UTR feature.\n\n\n\nsub flush_utrs {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $transcript->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the exon etc features.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none\n\n\n\nsub sub_SeqFeature {\n   my ($self) = @_;   \n   my @feas;\n   \n   # get what the parent already has\n   @feas = $self->SUPER::sub_SeqFeature();\n   # add the features we have in addition\n   push(@feas, $self->exons()); # this includes UTR features\n   push(@feas, $self->promoters());\n   push(@feas, $self->poly_A_site()) if($self->poly_A_site());\n   return @feas;\n}\n\n=head2 flush_sub_SeqFeature\n\n Title   : flush_sub_SeqFeature\n Usage   : $transcript->flush_sub_SeqFeature();\n           $transcript->flush_sub_SeqFeature(1);\n Function: Removes all subfeatures.\n\n           This method is overridden from Bio::SeqFeature::Generic to flush\n           all additional subfeatures like exons, promoters, etc., which is\n           almost certainly not what you want. To remove only features added\n           through $transcript->add_sub_SeqFeature($feature) pass any\n           argument evaluating to TRUE.\n\n Example :\n Returns : none\n Args    : Optionally, an argument evaluating to TRUE will suppress flushing\n           of all transcript-specific subfeatures (exons etc.).\n\n\n\nsub flush_sub_SeqFeature {\n   my ($self,$fea_only) = @_;\n\n   $self->SUPER::flush_sub_SeqFeature();\n   if(! $fea_only) {\n       $self->flush_promoters();\n       $self->flush_exons();\n       $self->flush_utrs();\n       $self->poly_A_site(0);\n   }\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $seq = $transcript->cds();\n Function: Returns the CDS (coding sequence) as defined by the exons\n           of this transcript and the attached sequence.\n\n           If no sequence is attached this method will return false.\n\n           Note that the implementation provided here returns a\n           concatenation of all coding exons, thereby assuming that\n           exons do not overlap.\n\n           Note also that you cannot set the CDS via this method. Set\n           a single CDS feature as a single exon, or derive your own\n           class if you want to store a predicted CDS.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\nsub cds {\n    my ($self) = @_;\n    my @exons = $self->exons_ordered();  #this is always sorted properly according to strand\n    my $strand;\n\n    return  unless(@exons);\n    # record strand (a minus-strand transcript must have the exons sorted in\n    # reverse order)\n    foreach my $exon (@exons) {\n\tif(defined($exon->strand()) && (! $strand)) {\n\t    $strand = $exon->strand();\n\t}\n\tif($exon->strand() && (($exon->strand() * $strand) < 0)) {\n\t    $self->throw(\"Transcript mixes coding exons on plus and minus \".\n\t\t\t \"strand. This makes no sense.\");\n\t}\n    }\n    my $cds = $self->_make_cds(@exons);\n    return unless $cds;\n    return Bio::PrimarySeq->new('-id' => $self->seq_id(),\n\t\t\t\t'-seq' => $cds,\n\t\t\t\t'-alphabet' => \"dna\");\n}\n\n=head2 protein\n\n Title   : protein()\n Usage   : $protein = $transcript->protein();\n Function: Get the protein encoded by the transcript as a sequence object.\n\n           The implementation provided here simply calls translate() on the\n           object returned by cds().\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub protein {\n    my ($self) = @_;\n    my $seq;\n\n    $seq = $self->cds();\n    return $seq->translate() if $seq;\n    return;\n}\n\n=head2 mrna\n\n Title   : mrna()\n Usage   : $mrna = $transcript->mrna();\n Function: Get the mRNA of the transcript as a sequence object.\n\n           The difference to cds() is that the sequence object returned by\n           this methods will also include UTR and the poly-adenylation site,\n           but not promoter sequence (TBD).\n\n           HL: do we really need this method?\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","label":"mrna($self)"},"line":568,"range":{"start":{"line":568,"character":0},"end":{"character":9999,"line":595}},"kind":12},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":575},{"signature":{"label":"_get_typed_keys($self,$keyprefix,$type)","documentation":"","parameters":[{"label":"$self"},{"label":"$keyprefix"},{"label":"$type"}]},"kind":12,"range":{"end":{"line":605,"character":9999},"start":{"character":0,"line":597}},"line":597,"detail":"($self,$keyprefix,$type)","definition":"sub","containerName":"main::","name":"_get_typed_keys","children":[{"definition":"my","line":598,"containerName":"_get_typed_keys","localvar":"my","kind":13,"name":"$self"},{"line":598,"name":"$keyprefix","containerName":"_get_typed_keys","kind":13},{"line":598,"containerName":"_get_typed_keys","kind":13,"name":"$type"},{"definition":"my","line":599,"localvar":"my","containerName":"_get_typed_keys","kind":13,"name":"@keys"},{"line":600,"name":"@feas","containerName":"_get_typed_keys","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_get_typed_keys","name":"$type","line":603},{"name":"$type","kind":13,"containerName":"_get_typed_keys","line":603},{"line":603,"name":"$type","containerName":"_get_typed_keys","kind":13},{"name":"@keys","kind":13,"containerName":"_get_typed_keys","line":605},{"containerName":"_get_typed_keys","kind":13,"name":"$self","line":605}]},{"line":606,"kind":13,"containerName":null,"name":"@keys"},{"line":609,"kind":12,"range":{"start":{"line":609,"character":0},"end":{"line":646,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"@exons"}],"documentation":"","label":"_make_cds($self,@exons)"},"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_make_cds","line":610},{"name":"@exons","kind":13,"containerName":"_make_cds","line":610},{"line":611,"containerName":"_make_cds","localvar":"my","kind":13,"name":"$cds","definition":"my"},{"line":613,"name":"$exon","localvar":"my","containerName":"_make_cds","kind":13,"definition":"my"},{"line":613,"name":"@exons","kind":13,"containerName":"_make_cds"},{"name":"$exon","containerName":"_make_cds","kind":13,"line":614},{"line":614,"containerName":"_make_cds","kind":12,"name":"seq"},{"name":"$exon","containerName":"_make_cds","kind":13,"line":614},{"kind":12,"containerName":"_make_cds","name":"is_coding","line":614},{"definition":"my","line":615,"localvar":"my","kind":13,"containerName":"_make_cds","name":"$phase"},{"containerName":"_make_cds","kind":13,"name":"$cds","line":615},{"containerName":"_make_cds","kind":13,"name":"$exon","line":617},{"name":"frame","containerName":"_make_cds","kind":12,"line":617},{"line":617,"name":"$phase","containerName":"_make_cds","kind":13},{"name":"$exon","containerName":"_make_cds","kind":13,"line":617},{"line":617,"name":"frame","containerName":"_make_cds","kind":12},{"name":"$cds","kind":13,"containerName":"_make_cds","line":621},{"kind":13,"containerName":"_make_cds","name":"$exon","line":621},{"name":"seq","containerName":"_make_cds","kind":12,"line":621},{"line":621,"name":"seq","containerName":"_make_cds","kind":12},{"definition":"my","name":"$seq","localvar":"my","containerName":"_make_cds","kind":13,"line":624},{"kind":13,"containerName":"_make_cds","name":"$exon","line":624},{"kind":12,"containerName":"_make_cds","name":"cds","line":624},{"name":"$seq","kind":13,"containerName":"_make_cds","line":625},{"line":626,"kind":13,"containerName":"_make_cds","name":"$seq"},{"name":"$seq","kind":13,"containerName":"_make_cds","line":626},{"line":626,"name":"seq","containerName":"_make_cds","kind":12},{"line":628,"kind":13,"containerName":"_make_cds","name":"$phase"},{"containerName":"_make_cds","localvar":"my","kind":13,"name":"$n_crop","line":630,"definition":"my"},{"line":631,"kind":13,"containerName":"_make_cds","name":"$seq"},{"line":632,"containerName":"_make_cds","kind":13,"name":"$n_crop"},{"line":634,"name":"$n_crop","kind":13,"containerName":"_make_cds"},{"line":634,"containerName":"_make_cds","kind":13,"name":"$phase"},{"line":636,"kind":13,"containerName":"_make_cds","name":"$seq"},{"containerName":"_make_cds","kind":13,"name":"$seq","line":636},{"containerName":"_make_cds","kind":13,"name":"$phase","line":636},{"line":639,"name":"$seq","containerName":"_make_cds","kind":13},{"line":639,"name":"$phase","kind":13,"containerName":"_make_cds"},{"containerName":"_make_cds","kind":13,"name":"$seq","line":639},{"line":642,"name":"$cds","kind":13,"containerName":"_make_cds"},{"containerName":"_make_cds","kind":13,"name":"$seq","line":642},{"line":645,"name":"$cds","kind":13,"containerName":"_make_cds"}],"containerName":"main::","name":"_make_cds","definition":"sub","detail":"($self,@exons)"},{"definition":"sub","containerName":"main::","name":"features","children":[{"line":661,"name":"$self","containerName":"features","localvar":"my","kind":13,"definition":"my"},{"line":662,"name":"$self","kind":13,"containerName":"features"}],"kind":12,"range":{"end":{"line":662,"character":9999},"start":{"line":660,"character":0}},"line":660},{"line":662,"kind":12,"name":"defined"},{"range":{"start":{"character":0,"line":677},"end":{"character":9999,"line":679}},"kind":12,"line":677,"signature":{"label":"features_ordered($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Transcript.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::Transcript\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::Transcript - A feature representing a transcript\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution.  Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Gene::Transcript;\nuse strict;\n\n\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::TranscriptI);\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&transcript_destroy);\n    my ($primary) = $self->_rearrange([qw(PRIMARY)],@args);\n\n    $primary = 'transcript' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features/sites of this transcript. \n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 add_promoter\n\n Title   : add_promoter()\n Usage   : $transcript->add_promoter($feature);\n Function: Add a promoter feature/site to this transcript.\n\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub add_promoter {\n    my ($self, $fea) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 flush_promoters\n\n Title   : flush_promoters()\n Usage   : $transcript->flush_promoters();\n Function: Remove all promoter features/sites from this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : the removed features as a list\n Args    : none\n\n\n\nsub flush_promoters {\n    my ($self) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Promoter');\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           ($inital_exon) = $gene->exons('Initial');\n Function: Get all exon features or all exons of specified type of this \n           transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types: \n           initial, internal, terminal.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\n\nsub exons {\n    my ($self, $type) = @_;\n    return $self->get_unordered_feature_type('Bio::SeqFeature::Gene::ExonI', \n\t\t\t\t\t     $type);\n}\n\n=head2 exons_ordered\n\n Title   : exons_ordered\n Usage   : @exons = $gene->exons_ordered();\n           @exons = $gene->exons_ordered(\"Internal\");\n Function: Get an ordered list of all exon features or all exons of specified\n           type of this transcript.\n\n           Exon type is treated as a case-insensitive regular expression and \n           is optional. For consistency, use only the following types:\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the primary_tag of the feature.\n\n\nsub exons_ordered { \n    my ($self,$type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::ExonI', $type);\n}\n\n=head2 add_exon\n\n Title   : add_exon()\n Usage   : $transcript->add_exon($exon,'initial');\n Function: Add a exon feature to this transcript.\n\n           The second argument denotes the type of exon. Mixing exons with and\n           without a type is likely to cause trouble in exons(). Either\n           leave out the type for all exons or for none.\n\n           Presently, the following types are known: initial, internal, \n           terminal, utr, utr5prime, and utr3prime (all case-insensitive).\n           UTR should better be added through utrs()/add_utr().\n\n           If you wish to use other or additional types, you will almost\n           certainly have to call exon_type_sortorder() in order to replace\n           the default sort order, or mrna(), cds(), protein(), and exons()\n           may yield unexpected results.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::ExonI implementing object.\n           A string indicating the type of the exon (optional).\n\n\n\nsub add_exon {\n    my ($self, $fea, $type) = @_;\n    if(! $fea->isa('Bio::SeqFeature::Gene::ExonI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::ExonI\");\n    }\n    $self->_add($fea,'Bio::SeqFeature::Gene::Exon', $type);\n}\n\n=head2 flush_exons\n\n Title   : flush_exons()\n Usage   : $transcript->flush_exons();\n           $transcript->flush_exons('terminal');\n Function: Remove all or a certain type of exon features from this transcript.\n\n           See add_exon() for documentation about types.\n\n           Calling without a type will not flush UTRs. Call flush_utrs() for\n           this purpose.\n Returns : the deleted features as a list\n Args    : A string indicating the type of the exon (optional).\n\n\n\nsub flush_exons {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::Exon',$type);\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all intron features this gene structure.\n\n           Note that this implementation generates these features\n           on-the-fly, that is, it simply treats all regions between\n           exons as introns, assuming that exons do not overlap. A\n           consequence is that a consistent correspondence between the\n           elements in the returned array and the array that exons()\n           returns will exist only if the exons are properly sorted\n           within their types (forward for plus- strand and reverse\n           for minus-strand transcripts). To ensure correctness the\n           elements in the array returned will always be sorted.\n\n Returns : An array of Bio::SeqFeature::Gene::Intron objects representing\n           the intron regions.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @introns = ();\n    my @exons = $self->exons();\n    my ($strand, $rev_order);\n\n    # if there's 1 or less exons we're done\n    return () unless($#exons > 0);\n    # record strand and order (a minus-strand transcript is likely to have\n    # the exons stacked in reverse order)\n    foreach my $exon (@exons) {\n\t$strand = $exon->strand();\n\tlast if $strand; # we're done if we've got 1 or -1\n    }\n    $rev_order = ($exons[0]->end() < $exons[1]->start() ? 0 : 1);\n\n    # Make sure exons are sorted. Because we assume they don't overlap, we\n    # simply sort by start position.\n    if((! defined($strand)) || ($strand != -1) || (! $rev_order)) {\n\t# always sort forward for plus-strand transcripts, and for negative-\n\t# strand transcripts that appear to be unsorted or forward sorted\n        @exons = map { $_->[0] } sort { $a->[1] <=> $b->[1] } \n\t         map { [ $_, $_->start * ($_->strand || 1)] } @exons;\n    } else {\n\t# sort in reverse order for transcripts on the negative strand and\n\t# found to be in reverse order\n        @exons = map { $_->[0] } sort { $b->[1] <=> $a->[1] } map { [ $_, $_->start()] } @exons;\n    }\n    # loop over all intervening gaps\n    while ((my $exonA = shift (@exons)) &&(my $exonB = shift(@exons))){\n       my $intron = Bio::SeqFeature::Gene::Intron->new(-primary=>'intron');\n       $intron->upstream_Exon($exonA);\n       $intron->downstream_Exon($exonB);\n       $intron->attach_seq($self->entire_seq) if $self->entire_seq;\n       unshift(@exons,$exonB);\n       push @introns,$intron;\n    }\n    return @introns;\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get/set the poly-adenylation feature/site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object representing the\n           poly-adenylation region.\n Args    : A Bio::SeqFeatureI implementing object on set, or FALSE to flush\n           a previously set object.\n\n\n\nsub poly_A_site {\n    my ($self, $fea) = @_;\n    if ($fea) {\n\t$self->_add($fea,'Bio::SeqFeature::Gene::Poly_A_site');\n    }\n    return ($self->get_feature_type('Bio::SeqFeature::Gene::Poly_A_site'))[0];\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs('utr3prime');\n           @utr_sites = $transcript->utrs('utr5prime');\n           @utr_sites = $transcript->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           transcript.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: utr5prime utr3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n Returns : An array of Bio::SeqFeature::Gene::UTR objects\n           representing the UTR regions or sites.\n Args    : Optionally, either utr3prime, or utr5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self, $type) = @_;\n    return $self->get_feature_type('Bio::SeqFeature::Gene::UTR',$type);\n\n}\n\n=head2 add_utr\n\n Title   : add_utr()\n Usage   : $transcript->add_utr($utrobj, 'utr3prime');\n           $transcript->add_utr($utrobj);\n Function: Add a UTR feature/site to this transcript.\n\n           The second parameter is optional and denotes the type of the UTR\n           feature. Presently recognized types include 'utr5prime' and 'utr3prime'\n           for UTR on the 5' and 3' end of a gene, respectively.\n\n           Calling this method is the same as calling \n           add_exon($utrobj, 'utr'.$type). In this sense a UTR object is a\n           special exon object, which is transcribed, not spliced out, but\n           not translated.\n\n           Note that the object supplied should return FALSE for is_coding().\n           Otherwise cds() and friends will become confused.\n\n Returns : \n Args    : A Bio::SeqFeature::Gene::UTR implementing object.\n\n\n\nsub add_utr {\n    my ($self, $fea, $type) = @_;\n    $self->_add($fea,'Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 flush_utrs\n\n Title   : flush_utrs()\n Usage   : $transcript->flush_utrs();\n           $transcript->flush_utrs('utr3prime');\n Function: Remove all or a specific type of UTR features/sites from this\n           transcript.\n\n           Cf. add_utr() for documentation about recognized types.\n Returns : a list of the removed features\n Args    : Optionally a string denoting the type of UTR feature.\n\n\n\nsub flush_utrs {\n    my ($self, $type) = @_;\n    return $self->_flush('Bio::SeqFeature::Gene::UTR',$type);\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $transcript->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the exon etc features.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none\n\n\n\nsub sub_SeqFeature {\n   my ($self) = @_;   \n   my @feas;\n   \n   # get what the parent already has\n   @feas = $self->SUPER::sub_SeqFeature();\n   # add the features we have in addition\n   push(@feas, $self->exons()); # this includes UTR features\n   push(@feas, $self->promoters());\n   push(@feas, $self->poly_A_site()) if($self->poly_A_site());\n   return @feas;\n}\n\n=head2 flush_sub_SeqFeature\n\n Title   : flush_sub_SeqFeature\n Usage   : $transcript->flush_sub_SeqFeature();\n           $transcript->flush_sub_SeqFeature(1);\n Function: Removes all subfeatures.\n\n           This method is overridden from Bio::SeqFeature::Generic to flush\n           all additional subfeatures like exons, promoters, etc., which is\n           almost certainly not what you want. To remove only features added\n           through $transcript->add_sub_SeqFeature($feature) pass any\n           argument evaluating to TRUE.\n\n Example :\n Returns : none\n Args    : Optionally, an argument evaluating to TRUE will suppress flushing\n           of all transcript-specific subfeatures (exons etc.).\n\n\n\nsub flush_sub_SeqFeature {\n   my ($self,$fea_only) = @_;\n\n   $self->SUPER::flush_sub_SeqFeature();\n   if(! $fea_only) {\n       $self->flush_promoters();\n       $self->flush_exons();\n       $self->flush_utrs();\n       $self->poly_A_site(0);\n   }\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $seq = $transcript->cds();\n Function: Returns the CDS (coding sequence) as defined by the exons\n           of this transcript and the attached sequence.\n\n           If no sequence is attached this method will return false.\n\n           Note that the implementation provided here returns a\n           concatenation of all coding exons, thereby assuming that\n           exons do not overlap.\n\n           Note also that you cannot set the CDS via this method. Set\n           a single CDS feature as a single exon, or derive your own\n           class if you want to store a predicted CDS.\n\n Example :\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\nsub cds {\n    my ($self) = @_;\n    my @exons = $self->exons_ordered();  #this is always sorted properly according to strand\n    my $strand;\n\n    return  unless(@exons);\n    # record strand (a minus-strand transcript must have the exons sorted in\n    # reverse order)\n    foreach my $exon (@exons) {\n\tif(defined($exon->strand()) && (! $strand)) {\n\t    $strand = $exon->strand();\n\t}\n\tif($exon->strand() && (($exon->strand() * $strand) < 0)) {\n\t    $self->throw(\"Transcript mixes coding exons on plus and minus \".\n\t\t\t \"strand. This makes no sense.\");\n\t}\n    }\n    my $cds = $self->_make_cds(@exons);\n    return unless $cds;\n    return Bio::PrimarySeq->new('-id' => $self->seq_id(),\n\t\t\t\t'-seq' => $cds,\n\t\t\t\t'-alphabet' => \"dna\");\n}\n\n=head2 protein\n\n Title   : protein()\n Usage   : $protein = $transcript->protein();\n Function: Get the protein encoded by the transcript as a sequence object.\n\n           The implementation provided here simply calls translate() on the\n           object returned by cds().\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub protein {\n    my ($self) = @_;\n    my $seq;\n\n    $seq = $self->cds();\n    return $seq->translate() if $seq;\n    return;\n}\n\n=head2 mrna\n\n Title   : mrna()\n Usage   : $mrna = $transcript->mrna();\n Function: Get the mRNA of the transcript as a sequence object.\n\n           The difference to cds() is that the sequence object returned by\n           this methods will also include UTR and the poly-adenylation site,\n           but not promoter sequence (TBD).\n\n           HL: do we really need this method?\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub mrna {\n    my ($self) = @_;\n    my ($seq, $mrna, $elem);\n\n    # get the coding part\n    $seq = $self->cds();\n    if(! $seq) {\n\t$seq = Bio::PrimarySeq->new('-id' => $self->seq_id(),\n\t\t\t\t    '-alphabet' => \"rna\",\n\t\t\t\t    '-seq' => \"\");\n    }\n    # get and add UTR sequences\n    $mrna = \"\";\n    foreach $elem ($self->utrs('utr5prime')) {\n\t$mrna .= $elem->seq()->seq();\n    }\n    $seq->seq($mrna . $seq->seq());\n    $mrna = \"\";\n    foreach $elem ($self->utrs('utr3prime')) {\n\t$mrna .= $elem->seq()->seq();\n    }\n    $seq->seq($seq->seq() . $mrna);\n    if($self->poly_A_site()) {\n\t$seq->seq($seq->seq() . $self->poly_A_site()->seq()->seq());\n    }\n    return if($seq->length() == 0);\n    return $seq;\n}\n\nsub _get_typed_keys {\n    my ($self, $keyprefix, $type) = @_;\n    my @keys = ();\n    my @feas = ();\n\n    # make case-insensitive\n    $type = ($type ? lc($type) : \"\");\n    # pull out all feature types that exist and match\n    @keys = grep { /^_$keyprefix$type/i; } (keys(%{$self}));\n    return @keys;\n}\n\nsub _make_cds {\n    my ($self,@exons) = @_;\n    my $cds = \"\";\n\n    foreach my $exon (@exons) {\n\tnext if((! defined($exon->seq())) || (! $exon->is_coding()));\n\tmy $phase = length($cds) % 3;\n\t# let's check the simple case \n\tif((! defined($exon->frame())) || ($phase == $exon->frame())) {\n\t    # this one fits exactly, or frame of the exon is undefined (should\n\t    # we warn about that?); we bypass the $exon->cds() here (hmm,\n\t    # not very clean style, but I don't see where this screws up)\n\t    $cds .= $exon->seq()->seq();\n\t} else {\n\t    # this one is probably from exon shuffling and needs some work\n\t    my $seq = $exon->cds(); # now $seq is guaranteed to be in frame 0\n\t    next if(! $seq);\n\t    $seq = $seq->seq();\n\t    # adjustment needed?\n\t    if($phase > 0) {\n\t\t# how many Ns can we chop off the piece to be added?\n\t\tmy $n_crop = 0;\n\t\tif($seq =~ /^(n+)/i) {\n\t\t    $n_crop = length($1);\n\t\t}\n\t\tif($n_crop >= $phase) {\n\t\t    # chop off to match the phase\n\t\t    $seq = substr($seq, $phase);\n\t\t} else {\n\t\t    # fill in Ns\n\t\t    $seq = (\"n\" x (3-$phase)) . $seq;\n\t\t}\n\t    }\n\t    $cds .= $seq;\n\t}\n    }\n    return $cds;\n}\n\n=head2 features\n\n Title   : features\n Usage   : my @features=$transcript->features;\n Function: returns all the features associated with this transcript\n Returns : a list of SeqFeatureI implementing objects\n Args    : none\n\n\n\n\nsub features {\n    my $self = shift;    \n    return grep { defined } @{$self->{'_features'} || []};\n}\n\n=head2 features_ordered\n\n Title   : features_ordered\n Usage   : my @features=$transcript->features_ordered;\n Function: returns all the features associated with this transcript,\n           in order by feature start, according to strand\n Returns : a list of SeqFeatureI implementing objects\n Args    : none"},"name":"features_ordered","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"features_ordered","localvar":"my","kind":13,"line":678},{"line":679,"kind":13,"containerName":"features_ordered","name":"$self"},{"name":"_stranded_sort","containerName":"features_ordered","kind":12,"line":679},{"line":679,"name":"$self","containerName":"features_ordered","kind":13}],"detail":"($self)","definition":"sub"},{"children":[{"name":"$self","localvar":"my","containerName":"get_unordered_feature_type","kind":13,"line":684,"definition":"my"},{"name":"$type","kind":13,"containerName":"get_unordered_feature_type","line":684},{"containerName":"get_unordered_feature_type","kind":13,"name":"$pri","line":684},{"definition":"my","line":685,"localvar":"my","containerName":"get_unordered_feature_type","kind":13,"name":"@list"},{"name":"$self","containerName":"get_unordered_feature_type","kind":13,"line":686},{"line":686,"name":"features","containerName":"get_unordered_feature_type","kind":12},{"containerName":"get_unordered_feature_type","kind":12,"name":"isa","line":687},{"line":687,"name":"$type","containerName":"get_unordered_feature_type","kind":13},{"name":"$pri","containerName":"get_unordered_feature_type","kind":13,"line":688},{"name":"primary_tag","kind":12,"containerName":"get_unordered_feature_type","line":688},{"line":691,"name":"@list","kind":13,"containerName":"get_unordered_feature_type"},{"name":"@list","containerName":"get_unordered_feature_type","kind":13,"line":694}],"name":"get_unordered_feature_type","containerName":"main::","definition":"sub","detail":"($self,$type,$pri)","line":683,"range":{"start":{"character":0,"line":683},"end":{"character":9999,"line":696}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$pri"}],"label":"get_unordered_feature_type($self,$type,$pri)"}},{"range":{"end":{"line":701,"character":9999},"start":{"character":0,"line":698}},"kind":12,"line":698,"definition":"sub","containerName":"main::","name":"get_feature_type","children":[{"definition":"my","line":699,"kind":13,"localvar":"my","containerName":"get_feature_type","name":"$self"},{"kind":13,"containerName":"get_feature_type","name":"$self","line":700},{"name":"_stranded_sort","containerName":"get_feature_type","kind":12,"line":700},{"line":700,"name":"$self","containerName":"get_feature_type","kind":13},{"line":700,"name":"get_unordered_feature_type","kind":12,"containerName":"get_feature_type"}]},{"signature":{"label":"_flush($self,$type,$pri)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$pri"}],"documentation":"This was fixed by Gene Cutler - the indexing on the list being reversed\nfixed a bad bug.  Thanks Gene!"},"line":705,"kind":12,"range":{"end":{"character":9999,"line":721},"start":{"character":0,"line":705}},"definition":"sub","detail":"($self,$type,$pri)","children":[{"definition":"my","name":"$self","containerName":"_flush","localvar":"my","kind":13,"line":706},{"line":706,"name":"$type","kind":13,"containerName":"_flush"},{"name":"$pri","containerName":"_flush","kind":13,"line":706},{"name":"@list","containerName":"_flush","localvar":"my","kind":13,"line":707,"definition":"my"},{"containerName":"_flush","kind":13,"name":"$self","line":707},{"line":707,"name":"features","containerName":"_flush","kind":12},{"line":708,"localvar":"my","containerName":"_flush","kind":13,"name":"@cut","definition":"my"},{"containerName":"_flush","kind":13,"name":"$list","line":710},{"name":"$list","kind":13,"containerName":"_flush","line":711},{"kind":12,"containerName":"_flush","name":"isa","line":711},{"line":711,"name":"$type","kind":13,"containerName":"_flush"},{"line":712,"name":"$pri","containerName":"_flush","kind":13},{"line":712,"containerName":"_flush","kind":13,"name":"$list"},{"name":"primary_tag","kind":12,"containerName":"_flush","line":712},{"containerName":"_flush","kind":13,"name":"@cut","line":715},{"line":715,"name":"@list","containerName":"_flush","kind":13},{"line":719,"name":"$self","kind":13,"containerName":"_flush"},{"containerName":"_flush","kind":13,"name":"@list","line":719},{"name":"@cut","containerName":"_flush","kind":13,"line":720}],"containerName":"main::","name":"_flush"},{"line":709,"name":"list","kind":12},{"containerName":"main::","name":"_add","children":[{"definition":"my","line":724,"containerName":"_add","localvar":"my","kind":13,"name":"$self"},{"name":"$fea","containerName":"_add","kind":13,"line":724},{"line":724,"containerName":"_add","kind":13,"name":"$type"},{"name":"$pri","kind":13,"containerName":"_add","line":724},{"name":"$fea","containerName":"_add","kind":13,"line":731},{"line":731,"containerName":"_add","kind":12,"name":"isa"},{"kind":13,"containerName":"_add","name":"$self","line":732},{"line":732,"name":"throw","kind":12,"containerName":"_add"},{"line":734,"kind":13,"containerName":"_add","name":"$fea"},{"kind":12,"containerName":"_add","name":"isa","line":734},{"containerName":"_add","kind":13,"name":"$type","line":734},{"name":"$pri","containerName":"_add","kind":13,"line":734},{"line":735,"containerName":"_add","kind":13,"name":"$fea"},{"line":735,"name":"$self","kind":13,"containerName":"_add"},{"line":735,"kind":12,"containerName":"_add","name":"_new_of_type"},{"line":735,"kind":13,"containerName":"_add","name":"$fea"},{"line":735,"containerName":"_add","kind":13,"name":"$type"},{"line":735,"containerName":"_add","kind":13,"name":"$pri"},{"name":"$self","containerName":"_add","kind":13,"line":737},{"line":737,"name":"strand","containerName":"_add","kind":12},{"name":"$self","kind":13,"containerName":"_add","line":738},{"line":738,"kind":12,"containerName":"_add","name":"strand"},{"name":"$fea","kind":13,"containerName":"_add","line":738},{"line":738,"name":"strand","containerName":"_add","kind":12},{"line":740,"name":"$self","kind":13,"containerName":"_add"},{"kind":12,"containerName":"_add","name":"strand","line":740},{"line":740,"name":"$fea","kind":13,"containerName":"_add"},{"containerName":"_add","kind":12,"name":"strand","line":740},{"line":741,"containerName":"_add","kind":13,"name":"$self"},{"line":741,"kind":12,"containerName":"_add","name":"throw"},{"line":745,"kind":13,"containerName":"_add","name":"$self"},{"kind":12,"containerName":"_add","name":"_expand_region","line":745},{"line":745,"name":"$fea","containerName":"_add","kind":13},{"line":746,"kind":13,"containerName":"_add","name":"$self"},{"name":"entire_seq","kind":12,"containerName":"_add","line":746},{"containerName":"_add","kind":13,"name":"$fea","line":746},{"line":746,"name":"entire_seq","kind":12,"containerName":"_add"},{"line":747,"name":"$fea","containerName":"_add","kind":13},{"line":747,"name":"can","kind":12,"containerName":"_add"},{"line":748,"containerName":"_add","kind":13,"name":"$fea"},{"containerName":"_add","kind":12,"name":"attach_seq","line":748},{"name":"$self","kind":13,"containerName":"_add","line":748},{"line":748,"name":"entire_seq","kind":12,"containerName":"_add"},{"name":"$self","kind":13,"containerName":"_add","line":750},{"name":"parent","containerName":"_add","kind":12,"line":750},{"name":"$self","kind":13,"containerName":"_add","line":751},{"line":751,"name":"parent","containerName":"_add","kind":12},{"containerName":"_add","kind":12,"name":"_expand_region","line":751},{"line":751,"containerName":"_add","kind":13,"name":"$fea"},{"name":"$self","kind":13,"containerName":"_add","line":753}],"detail":"($self,$fea,$type,$pri)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":753},"start":{"character":0,"line":723}},"line":723,"signature":{"label":"_add($self,$fea,$type,$pri)","documentation":"","parameters":[{"label":"$self"},{"label":"$fea"},{"label":"$type"},{"label":"$pri"}]}},{"line":731,"containerName":"SeqFeature::Gene::Promoter::Bio::SeqFeature::Gene::UTR::Bio::SeqFeature::Gene::Exon::Bio::SeqFeature::Gene::Intron::Bio::SeqFeature::Gene::Poly_A_site","kind":12,"name":"Bio"},{"line":753,"kind":13,"containerName":null,"name":"$fea"},{"kind":12,"range":{"end":{"line":775,"character":9999},"start":{"character":0,"line":757}},"line":757,"signature":{"label":"_stranded_sort($self,@list)","parameters":[{"label":"$self"},{"label":"@list"}],"documentation":""},"name":"_stranded_sort","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"_stranded_sort","kind":13,"name":"$self","line":758},{"name":"@list","containerName":"_stranded_sort","kind":13,"line":758},{"name":"$strand","localvar":"my","containerName":"_stranded_sort","kind":13,"line":759,"definition":"my"},{"line":760,"name":"$fea","localvar":"my","kind":13,"containerName":"_stranded_sort","definition":"my"},{"kind":13,"containerName":"_stranded_sort","name":"@list","line":760},{"line":761,"containerName":"_stranded_sort","kind":13,"name":"$fea"},{"line":761,"name":"strand","kind":12,"containerName":"_stranded_sort"},{"containerName":"_stranded_sort","kind":13,"name":"$strand","line":763},{"line":763,"containerName":"_stranded_sort","kind":13,"name":"$fea"},{"line":763,"containerName":"_stranded_sort","kind":12,"name":"strand"},{"kind":13,"containerName":"_stranded_sort","name":"$strand","line":763},{"line":764,"name":"$fea","kind":13,"containerName":"_stranded_sort"},{"kind":12,"containerName":"_stranded_sort","name":"strand","line":764},{"line":764,"name":"$strand","kind":13,"containerName":"_stranded_sort"},{"name":"$strand","containerName":"_stranded_sort","kind":13,"line":765},{"line":770,"name":"$strand","containerName":"_stranded_sort","kind":13},{"line":770,"name":"$strand","containerName":"_stranded_sort","kind":13},{"name":"$b","kind":13,"containerName":"_stranded_sort","line":771},{"name":"$a","kind":13,"containerName":"_stranded_sort","line":771},{"line":771,"kind":12,"containerName":"_stranded_sort","name":"start"},{"name":"@list","containerName":"_stranded_sort","kind":13,"line":771},{"name":"$a","containerName":"_stranded_sort","kind":13,"line":773},{"containerName":"_stranded_sort","kind":13,"name":"$b","line":773},{"name":"start","containerName":"_stranded_sort","kind":12,"line":773},{"line":773,"kind":13,"containerName":"_stranded_sort","name":"@list"}],"detail":"($self,@list)","definition":"sub"},{"line":777,"range":{"end":{"line":788,"character":9999},"start":{"line":777,"character":0}},"kind":12,"signature":{"label":"_new_of_type($self,$fea,$type,$pri)","parameters":[{"label":"$self"},{"label":"$fea"},{"label":"$type"},{"label":"$pri"}],"documentation":""},"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_new_of_type","line":778,"definition":"my"},{"line":778,"containerName":"_new_of_type","kind":13,"name":"$fea"},{"line":778,"name":"$type","containerName":"_new_of_type","kind":13},{"kind":13,"containerName":"_new_of_type","name":"$pri","line":778},{"kind":13,"localvar":"my","containerName":"_new_of_type","name":"$primary","line":779,"definition":"my"},{"containerName":"_new_of_type","kind":13,"name":"$pri","line":780},{"line":781,"containerName":"_new_of_type","kind":13,"name":"$primary"},{"kind":13,"containerName":"_new_of_type","name":"$pri","line":781},{"kind":13,"containerName":"_new_of_type","name":"$primary","line":783},{"containerName":"_new_of_type","kind":13,"name":"$type","line":783},{"containerName":"_new_of_type","kind":13,"name":"$fea","line":785},{"line":785,"kind":13,"containerName":"_new_of_type","name":"$type"},{"name":"$fea","containerName":"_new_of_type","kind":13,"line":786},{"line":786,"containerName":"_new_of_type","kind":12,"name":"primary_tag"},{"containerName":"_new_of_type","kind":13,"name":"$primary","line":786},{"line":787,"kind":13,"containerName":"_new_of_type","name":"$fea"}],"name":"_new_of_type","containerName":"main::","definition":"sub","detail":"($self,$fea,$type,$pri)"},{"line":790,"range":{"start":{"line":790,"character":0},"end":{"line":798,"character":9999}},"kind":12,"children":[{"definition":"my","line":791,"kind":13,"localvar":"my","containerName":"transcript_destroy","name":"$self"},{"name":"$f","localvar":"my","containerName":"transcript_destroy","kind":13,"line":794,"definition":"my"},{"line":794,"containerName":"transcript_destroy","kind":13,"name":"$self"},{"name":"features","kind":12,"containerName":"transcript_destroy","line":794},{"name":"$f","containerName":"transcript_destroy","kind":13,"line":795},{"containerName":"transcript_destroy","kind":13,"name":"$self","line":797},{"line":797,"name":"parent","kind":12,"containerName":"transcript_destroy"}],"name":"transcript_destroy","containerName":"main::","definition":"sub"}],"version":5}