{"vars":[{"name":"base","kind":2,"containerName":"","line":77},{"children":[{"line":95,"name":"$self","localvar":"my","kind":13,"containerName":"is_coding","definition":"my"},{"containerName":"is_coding","kind":13,"name":"$self","line":96},{"line":96,"containerName":"is_coding","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"is_coding","definition":"sub","detail":"($self)","line":94,"range":{"end":{"character":9999,"line":97},"start":{"character":0,"line":94}},"kind":12,"signature":{"documentation":"1;\n# $Id: ExonI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::ExonI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::ExonI - Interface for a feature representing an exon\n\n=head1 SYNOPSIS\n\nSee documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing an exon. An exon in this definition is\ntranscribed and at least for one particular transcript not spliced out\nof the pre-mRNA. However, it does not necessarily code for amino acid.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::ExonI;\nuse strict;\n\nuse base qw(Bio::SeqFeatureI);\n\n\n=head2 is_coding\n\n Title   : is_coding\n Usage   : if($exon->is_coding()) {\n                   # do something\n           }\n Function: Whether or not the exon codes for amino acid.\n Returns : TRUE if the object represents a feature translated into protein,\n           and FALSE otherwise.\n Args    : ","parameters":[{"label":"$self"}],"label":"is_coding($self)"}},{"line":117,"kind":12,"range":{"start":{"character":0,"line":117},"end":{"character":9999,"line":120}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ExonI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::ExonI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::ExonI - Interface for a feature representing an exon\n\n=head1 SYNOPSIS\n\nSee documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing an exon. An exon in this definition is\ntranscribed and at least for one particular transcript not spliced out\nof the pre-mRNA. However, it does not necessarily code for amino acid.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::ExonI;\nuse strict;\n\nuse base qw(Bio::SeqFeatureI);\n\n\n=head2 is_coding\n\n Title   : is_coding\n Usage   : if($exon->is_coding()) {\n                   # do something\n           }\n Function: Whether or not the exon codes for amino acid.\n Returns : TRUE if the object represents a feature translated into protein,\n           and FALSE otherwise.\n Args    : \n\n\n\nsub is_coding {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 cds\n\n Title   : cds()\n Usage   : $cds = $exon->cds();\n Function: Get the coding sequence of the exon as a sequence object.\n\n           The returned sequence object must be in frame 0, i.e., the first\n           base starts a codon.\n\n           An implementation may return undef, indicating that a coding\n           sequence does not exist, e.g. for a UTR (untranslated region).\n\n Returns : A L<Bio::PrimarySeqI> implementing object.\n Args    : ","label":"cds($self)"},"children":[{"localvar":"my","containerName":"cds","kind":13,"name":"$self","line":118,"definition":"my"},{"line":119,"name":"$self","containerName":"cds","kind":13},{"line":119,"name":"throw_not_implemented","kind":12,"containerName":"cds"}],"containerName":"main::","name":"cds","definition":"sub","detail":"($self)"}],"version":5}