{"vars":[{"line":91,"kind":2,"containerName":"","name":"vars"},{"line":97,"name":"base","containerName":"","kind":2},{"signature":{"documentation":"1;\n# $Id: FeaturePair.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::FeaturePair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::FeaturePair - hold pair feature information e.g. blast hits\n\n=head1 SYNOPSIS\n\n    my $feat  = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,\n\t\t\t\t\t\t -feature2 => $f2,\n\t\t\t\t\t      );\n\n    # Bio::SeqFeatureI methods can be used\n\n    my $start = $feat->start;\n    my $end   = $feat->end;\n\n    # Bio::FeaturePair methods can be used\n    my $hstart = $feat->hstart;\n    my $hend   = $feat->hend;\n\n   my $feature1 = $feat->feature1;  # returns feature1 object\n\n=head1 DESCRIPTION\n\nA sequence feature object where the feature is itself a feature on\nanother sequence - e.g. a blast hit where residues 1-40 of a protein\nsequence SW:HBA_HUMAN has hit to bases 100 - 220 on a genomic sequence\nHS120G22.  The genomic sequence coordinates are used to create one\nsequence feature $f1 and the protein coordinates are used to create\nfeature $f2.  A FeaturePair object can then be made\n\n    my $fp = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,   # genomic\n\t\t\t\t\t      -feature2 => $f2,   # protein\n\t\t\t\t\t      );\n\nThis object can be used as a standard Bio::SeqFeatureI in which case\n\n    my $gstart = $fp->start  # returns start coord on feature1 - genomic seq.\n    my $gend   = $fp->end    # returns end coord on feature1.\n\nIn general standard Bio::SeqFeatureI method calls return information\nin feature1.\n\nData in the feature 2 object are generally obtained using the standard\nmethods prefixed by h (for hit!)\n\n    my $pstart = $fp->hstart # returns start coord on feature2 = protein seq.\n    my $pend   = $fp->hend   # returns end coord on feature2.\n\nIf you wish to swap feature1 and feature2 around :\n\n    $feat->invert\n\nso... \n\n    $feat->start # etc. returns data in $feature2 object\n\n\nNo sub_SeqFeatures or tags can be stored in this object directly.  Any\nfeatures or tags are expected to be stored in the contained objects\nfeature1, and feature2.\n\n=head1 CONTACT\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::FeaturePair;\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse Bio::SeqFeatureI;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Constructor for this module. Accepts the following parameters:\n\n             -feature1   Bio::SeqFeatureI-compliant object\n             -feature2   Bio::SeqFeatureI-compliant object\n             -feature_factory  Bio::Factory::ObjectFactoryI compliant\n                         object to be used when feature1 and/or feature2\n                         are accessed without explicitly set before. This\n                         is mostly useful for derived classes who want to\n                         set their preferred class for feature objects.\n\n Example :\n Returns : \n Args    : see above","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"range":{"start":{"line":120,"character":0},"end":{"line":165,"character":9999}},"kind":12,"line":120,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":121,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":121},{"definition":"my","line":140,"name":"$self","localvar":"my","kind":13,"containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":140},{"name":"$feature1","kind":13,"localvar":"my","containerName":"new","line":141,"definition":"my"},{"containerName":"new","kind":13,"name":"$feature2","line":141},{"line":141,"name":"$featfact","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":142},{"line":142,"kind":12,"containerName":"new","name":"_rearrange"},{"line":145,"containerName":"new","kind":13,"name":"@args"},{"kind":13,"containerName":"new","name":"$self","line":147},{"line":147,"name":"_register_for_cleanup","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$featfact","line":149},{"name":"$featfact","kind":13,"containerName":"new","line":150},{"line":150,"containerName":"new","kind":12,"name":"new"},{"line":154,"name":"$self","containerName":"new","kind":13},{"name":"feature_factory","kind":12,"containerName":"new","line":154},{"name":"$featfact","containerName":"new","kind":13,"line":154},{"line":156,"containerName":"new","kind":13,"name":"$feature1"},{"name":"$self","containerName":"new","kind":13,"line":156},{"kind":12,"containerName":"new","name":"feature1","line":156},{"line":156,"name":"$feature1","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$feature2","line":157},{"line":157,"name":"$self","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"feature2","line":157},{"line":157,"kind":13,"containerName":"new","name":"$feature2"},{"line":161,"name":"$self","kind":13,"containerName":"new"},{"line":161,"kind":12,"containerName":"new","name":"set_attributes"},{"kind":13,"containerName":"new","name":"@args","line":161},{"name":"$self","kind":13,"containerName":"new","line":164}]},{"line":140,"kind":12,"containerName":"new","name":"SUPER"},{"kind":12,"name":"cleanup_fp","line":147},{"name":"Bio","kind":12,"containerName":"Factory::ObjectFactory","line":150},{"containerName":"main::","name":"feature1","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"feature1","line":180,"definition":"my"},{"line":180,"name":"$arg","kind":13,"containerName":"feature1"},{"name":"$arg","kind":13,"containerName":"feature1","line":181},{"line":181,"name":"$self","kind":13,"containerName":"feature1"},{"line":182,"name":"$self","containerName":"feature1","kind":13},{"containerName":"feature1","kind":12,"name":"throw","line":182},{"line":183,"containerName":"feature1","kind":13,"name":"$self"},{"containerName":"feature1","kind":12,"name":"feature_factory","line":183},{"kind":13,"containerName":"feature1","name":"$arg","line":184},{"line":184,"containerName":"feature1","kind":13,"name":"$self"},{"containerName":"feature1","kind":12,"name":"feature_factory","line":184},{"name":"create_object","kind":12,"containerName":"feature1","line":184},{"line":184,"name":"$arg","containerName":"feature1","kind":13},{"name":"$self","kind":13,"containerName":"feature1","line":185},{"line":185,"name":"throw","containerName":"feature1","kind":12},{"containerName":"feature1","kind":13,"name":"$arg","line":186},{"line":186,"name":"$arg","kind":13,"containerName":"feature1"},{"kind":12,"containerName":"feature1","name":"isa","line":186},{"line":187,"name":"$self","containerName":"feature1","kind":13},{"name":"$arg","containerName":"feature1","kind":13,"line":187},{"name":"$self","kind":13,"containerName":"feature1","line":189}],"detail":"($self,$arg)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":179},"end":{"line":190,"character":9999}},"line":179,"signature":{"parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: FeaturePair.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::FeaturePair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::FeaturePair - hold pair feature information e.g. blast hits\n\n=head1 SYNOPSIS\n\n    my $feat  = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,\n\t\t\t\t\t\t -feature2 => $f2,\n\t\t\t\t\t      );\n\n    # Bio::SeqFeatureI methods can be used\n\n    my $start = $feat->start;\n    my $end   = $feat->end;\n\n    # Bio::FeaturePair methods can be used\n    my $hstart = $feat->hstart;\n    my $hend   = $feat->hend;\n\n   my $feature1 = $feat->feature1;  # returns feature1 object\n\n=head1 DESCRIPTION\n\nA sequence feature object where the feature is itself a feature on\nanother sequence - e.g. a blast hit where residues 1-40 of a protein\nsequence SW:HBA_HUMAN has hit to bases 100 - 220 on a genomic sequence\nHS120G22.  The genomic sequence coordinates are used to create one\nsequence feature $f1 and the protein coordinates are used to create\nfeature $f2.  A FeaturePair object can then be made\n\n    my $fp = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,   # genomic\n\t\t\t\t\t      -feature2 => $f2,   # protein\n\t\t\t\t\t      );\n\nThis object can be used as a standard Bio::SeqFeatureI in which case\n\n    my $gstart = $fp->start  # returns start coord on feature1 - genomic seq.\n    my $gend   = $fp->end    # returns end coord on feature1.\n\nIn general standard Bio::SeqFeatureI method calls return information\nin feature1.\n\nData in the feature 2 object are generally obtained using the standard\nmethods prefixed by h (for hit!)\n\n    my $pstart = $fp->hstart # returns start coord on feature2 = protein seq.\n    my $pend   = $fp->hend   # returns end coord on feature2.\n\nIf you wish to swap feature1 and feature2 around :\n\n    $feat->invert\n\nso... \n\n    $feat->start # etc. returns data in $feature2 object\n\n\nNo sub_SeqFeatures or tags can be stored in this object directly.  Any\nfeatures or tags are expected to be stored in the contained objects\nfeature1, and feature2.\n\n=head1 CONTACT\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::FeaturePair;\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse Bio::SeqFeatureI;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Constructor for this module. Accepts the following parameters:\n\n             -feature1   Bio::SeqFeatureI-compliant object\n             -feature2   Bio::SeqFeatureI-compliant object\n             -feature_factory  Bio::Factory::ObjectFactoryI compliant\n                         object to be used when feature1 and/or feature2\n                         are accessed without explicitly set before. This\n                         is mostly useful for derived classes who want to\n                         set their preferred class for feature objects.\n\n Example :\n Returns : \n Args    : see above\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    #\n    # We've got a certain problem here that somewhat relates to chicken and\n    # eggs. The problem is, we override a lot of SeqFeatureI methods here\n    # to delegate them to either feature1 or feature2. If we pass along\n    # those attributes right away, we need feature1 or feature2 or the feature\n    # factory in place, or there is no way around the dreaded default, which\n    # is ugly too (as it necessitates subsequent copying if you wanted a\n    # different feature object class).\n    #\n    # So I decided to go with the lesser of two evils here: we need to assume\n    # here that we can set all attributes through set_attributes(), which we\n    # assume is no different from setting them through the constructor. This\n    # gives us a window to set the feature objects and the factory, such that\n    # any derived class doesn't have to worry about this any more.\n    #\n    # I'm happy to hear a better solution, but I think this one isn't so bad.\n    #\n    my $self = $class->SUPER::new();\n    my ($feature1,$feature2,$featfact) = \n\t$self->_rearrange([qw(FEATURE1\n\t\t\t      FEATURE2\n\t\t\t      FEATURE_FACTORY\n\t\t\t      )],@args);\n    \n    $self->_register_for_cleanup(\\&cleanup_fp);\n    # initialize the feature object factory if not provided\n    if(! $featfact) {\n\t$featfact = Bio::Factory::ObjectFactory->new(\n\t\t\t\t   -type => \"Bio::SeqFeature::Generic\",\n\t\t\t\t   -interface => \"Bio::SeqFeatureI\");\n    }\n    $self->feature_factory($featfact);\n    # Store the features in the object\n    $feature1 && $self->feature1($feature1);\n    $feature2 && $self->feature2($feature2);\n    \n    # OK. Now we're setup to store all the attributes, and they'll go right\n    # away into the right objects.\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 feature1\n\n Title   : feature1\n Usage   : $f = $featpair->feature1\n           $featpair->feature1($feature)\n Function: Get/set for the query feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI","label":"feature1($self,$arg)"}},{"kind":12,"range":{"end":{"character":9999,"line":216},"start":{"character":0,"line":204}},"line":204,"signature":{"label":"feature2($self,$arg)","parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: FeaturePair.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::FeaturePair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::FeaturePair - hold pair feature information e.g. blast hits\n\n=head1 SYNOPSIS\n\n    my $feat  = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,\n\t\t\t\t\t\t -feature2 => $f2,\n\t\t\t\t\t      );\n\n    # Bio::SeqFeatureI methods can be used\n\n    my $start = $feat->start;\n    my $end   = $feat->end;\n\n    # Bio::FeaturePair methods can be used\n    my $hstart = $feat->hstart;\n    my $hend   = $feat->hend;\n\n   my $feature1 = $feat->feature1;  # returns feature1 object\n\n=head1 DESCRIPTION\n\nA sequence feature object where the feature is itself a feature on\nanother sequence - e.g. a blast hit where residues 1-40 of a protein\nsequence SW:HBA_HUMAN has hit to bases 100 - 220 on a genomic sequence\nHS120G22.  The genomic sequence coordinates are used to create one\nsequence feature $f1 and the protein coordinates are used to create\nfeature $f2.  A FeaturePair object can then be made\n\n    my $fp = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,   # genomic\n\t\t\t\t\t      -feature2 => $f2,   # protein\n\t\t\t\t\t      );\n\nThis object can be used as a standard Bio::SeqFeatureI in which case\n\n    my $gstart = $fp->start  # returns start coord on feature1 - genomic seq.\n    my $gend   = $fp->end    # returns end coord on feature1.\n\nIn general standard Bio::SeqFeatureI method calls return information\nin feature1.\n\nData in the feature 2 object are generally obtained using the standard\nmethods prefixed by h (for hit!)\n\n    my $pstart = $fp->hstart # returns start coord on feature2 = protein seq.\n    my $pend   = $fp->hend   # returns end coord on feature2.\n\nIf you wish to swap feature1 and feature2 around :\n\n    $feat->invert\n\nso... \n\n    $feat->start # etc. returns data in $feature2 object\n\n\nNo sub_SeqFeatures or tags can be stored in this object directly.  Any\nfeatures or tags are expected to be stored in the contained objects\nfeature1, and feature2.\n\n=head1 CONTACT\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::FeaturePair;\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse Bio::SeqFeatureI;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Constructor for this module. Accepts the following parameters:\n\n             -feature1   Bio::SeqFeatureI-compliant object\n             -feature2   Bio::SeqFeatureI-compliant object\n             -feature_factory  Bio::Factory::ObjectFactoryI compliant\n                         object to be used when feature1 and/or feature2\n                         are accessed without explicitly set before. This\n                         is mostly useful for derived classes who want to\n                         set their preferred class for feature objects.\n\n Example :\n Returns : \n Args    : see above\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    #\n    # We've got a certain problem here that somewhat relates to chicken and\n    # eggs. The problem is, we override a lot of SeqFeatureI methods here\n    # to delegate them to either feature1 or feature2. If we pass along\n    # those attributes right away, we need feature1 or feature2 or the feature\n    # factory in place, or there is no way around the dreaded default, which\n    # is ugly too (as it necessitates subsequent copying if you wanted a\n    # different feature object class).\n    #\n    # So I decided to go with the lesser of two evils here: we need to assume\n    # here that we can set all attributes through set_attributes(), which we\n    # assume is no different from setting them through the constructor. This\n    # gives us a window to set the feature objects and the factory, such that\n    # any derived class doesn't have to worry about this any more.\n    #\n    # I'm happy to hear a better solution, but I think this one isn't so bad.\n    #\n    my $self = $class->SUPER::new();\n    my ($feature1,$feature2,$featfact) = \n\t$self->_rearrange([qw(FEATURE1\n\t\t\t      FEATURE2\n\t\t\t      FEATURE_FACTORY\n\t\t\t      )],@args);\n    \n    $self->_register_for_cleanup(\\&cleanup_fp);\n    # initialize the feature object factory if not provided\n    if(! $featfact) {\n\t$featfact = Bio::Factory::ObjectFactory->new(\n\t\t\t\t   -type => \"Bio::SeqFeature::Generic\",\n\t\t\t\t   -interface => \"Bio::SeqFeatureI\");\n    }\n    $self->feature_factory($featfact);\n    # Store the features in the object\n    $feature1 && $self->feature1($feature1);\n    $feature2 && $self->feature2($feature2);\n    \n    # OK. Now we're setup to store all the attributes, and they'll go right\n    # away into the right objects.\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 feature1\n\n Title   : feature1\n Usage   : $f = $featpair->feature1\n           $featpair->feature1($feature)\n Function: Get/set for the query feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI\n\n\n\nsub feature1 {\n    my ($self,$arg) = @_;    \n    if ( defined($arg) || !defined $self->{'feature1'} ) {\n\t$self->throw(\"internal error: feature factory not set!\") \n\t    unless $self->feature_factory;\n\t$arg = $self->feature_factory->create_object() unless( defined $arg);\n\t$self->throw(\"Argument [$arg] must be a Bio::SeqFeatureI\") \n\t    unless (ref($arg) && $arg->isa(\"Bio::SeqFeatureI\"));\n\t$self->{'feature1'} = $arg;\n    }\n    return $self->{'feature1'};\n}\n\n=head2 feature2\n\n Title   : feature2\n Usage   : $f = $featpair->feature2\n           $featpair->feature2($feature)\n Function: Get/set for the hit feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI"},"containerName":"main::","name":"feature2","children":[{"line":205,"containerName":"feature2","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"feature2","name":"$arg","line":205},{"containerName":"feature2","kind":13,"name":"$arg","line":207},{"line":207,"name":"$self","containerName":"feature2","kind":13},{"name":"$self","containerName":"feature2","kind":13,"line":208},{"containerName":"feature2","kind":12,"name":"throw","line":208},{"containerName":"feature2","kind":13,"name":"$self","line":209},{"containerName":"feature2","kind":12,"name":"feature_factory","line":209},{"containerName":"feature2","kind":13,"name":"$arg","line":210},{"line":210,"name":"$self","containerName":"feature2","kind":13},{"line":210,"kind":12,"containerName":"feature2","name":"feature_factory"},{"kind":12,"containerName":"feature2","name":"create_object","line":210},{"line":210,"name":"$arg","kind":13,"containerName":"feature2"},{"line":211,"containerName":"feature2","kind":13,"name":"$self"},{"line":211,"name":"throw","containerName":"feature2","kind":12},{"name":"$arg","containerName":"feature2","kind":13,"line":212},{"containerName":"feature2","kind":13,"name":"$arg","line":212},{"line":212,"name":"isa","kind":12,"containerName":"feature2"},{"line":213,"name":"$self","kind":13,"containerName":"feature2"},{"line":213,"name":"$arg","kind":13,"containerName":"feature2"},{"kind":13,"containerName":"feature2","name":"$self","line":215}],"detail":"($self,$arg)","definition":"sub"},{"definition":"sub","children":[{"line":230,"kind":12,"containerName":"start","name":"feature1"},{"line":230,"name":"start","kind":12,"containerName":"start"}],"containerName":"main::","name":"start","line":229,"kind":12,"range":{"start":{"line":229,"character":0},"end":{"line":231,"character":9999}}},{"definition":"sub","containerName":"main::","name":"end","children":[{"containerName":"end","kind":12,"name":"feature1","line":246},{"containerName":"end","kind":12,"name":"end","line":246}],"kind":12,"range":{"end":{"line":247,"character":9999},"start":{"character":0,"line":245}},"line":245},{"containerName":"main::","name":"strand","children":[{"name":"feature1","containerName":"strand","kind":12,"line":262},{"line":262,"kind":12,"containerName":"strand","name":"strand"}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":261},"end":{"character":9999,"line":263}},"line":261},{"kind":12,"range":{"start":{"character":0,"line":276},"end":{"character":9999,"line":278}},"line":276,"definition":"sub","name":"location","containerName":"main::","children":[{"containerName":"location","kind":12,"name":"feature1","line":277},{"line":277,"name":"location","kind":12,"containerName":"location"}]},{"children":[{"line":293,"kind":12,"containerName":"score","name":"feature1"},{"line":293,"name":"score","containerName":"score","kind":12}],"containerName":"main::","name":"score","definition":"sub","line":292,"range":{"start":{"line":292,"character":0},"end":{"character":9999,"line":294}},"kind":12},{"line":308,"kind":12,"range":{"start":{"character":0,"line":308},"end":{"character":9999,"line":310}},"children":[{"name":"feature1","containerName":"frame","kind":12,"line":309},{"name":"frame","containerName":"frame","kind":12,"line":309}],"containerName":"main::","name":"frame","definition":"sub"},{"line":323,"range":{"end":{"line":325,"character":9999},"start":{"line":323,"character":0}},"kind":12,"children":[{"kind":12,"containerName":"primary_tag","name":"feature1","line":324},{"name":"primary_tag","containerName":"primary_tag","kind":12,"line":324}],"containerName":"main::","name":"primary_tag","definition":"sub"},{"range":{"start":{"character":0,"line":340},"end":{"line":342,"character":9999}},"kind":12,"line":340,"definition":"sub","containerName":"main::","name":"source_tag","children":[{"line":341,"containerName":"source_tag","kind":12,"name":"feature1"},{"containerName":"source_tag","kind":12,"name":"source_tag","line":341}]},{"containerName":"main::","name":"seq_id","children":[{"line":363,"kind":12,"containerName":"seq_id","name":"feature1"},{"name":"seq_id","kind":12,"containerName":"seq_id","line":363}],"definition":"sub","kind":12,"range":{"start":{"line":362,"character":0},"end":{"line":364,"character":9999}},"line":362},{"definition":"sub","children":[{"line":379,"name":"feature2","containerName":"hseq_id","kind":12},{"kind":12,"containerName":"hseq_id","name":"seq_id","line":379}],"name":"hseq_id","containerName":"main::","line":378,"range":{"end":{"line":380,"character":9999},"start":{"line":378,"character":0}},"kind":12},{"definition":"sub","name":"hstart","containerName":"main::","children":[{"kind":12,"containerName":"hstart","name":"feature2","line":395},{"name":"start","containerName":"hstart","kind":12,"line":395}],"range":{"end":{"character":9999,"line":396},"start":{"line":394,"character":0}},"kind":12,"line":394},{"line":410,"kind":12,"range":{"end":{"character":9999,"line":412},"start":{"character":0,"line":410}},"definition":"sub","children":[{"containerName":"hend","kind":12,"name":"feature2","line":411},{"line":411,"containerName":"hend","kind":12,"name":"end"}],"name":"hend","containerName":"main::"},{"line":427,"kind":12,"range":{"end":{"line":429,"character":9999},"start":{"character":0,"line":427}},"definition":"sub","children":[{"kind":12,"containerName":"hstrand","name":"feature2","line":428},{"line":428,"containerName":"hstrand","kind":12,"name":"strand"}],"containerName":"main::","name":"hstrand"},{"children":[{"name":"feature2","kind":12,"containerName":"hscore","line":444},{"line":444,"containerName":"hscore","kind":12,"name":"score"}],"containerName":"main::","name":"hscore","definition":"sub","line":443,"range":{"start":{"line":443,"character":0},"end":{"line":445,"character":9999}},"kind":12},{"children":[{"containerName":"hframe","kind":12,"name":"feature2","line":460},{"kind":12,"containerName":"hframe","name":"frame","line":460}],"name":"hframe","containerName":"main::","definition":"sub","line":459,"range":{"start":{"line":459,"character":0},"end":{"character":9999,"line":461}},"kind":12},{"definition":"sub","children":[{"kind":12,"containerName":"hprimary_tag","name":"feature2","line":475},{"name":"primary_tag","containerName":"hprimary_tag","kind":12,"line":475}],"containerName":"main::","name":"hprimary_tag","line":474,"range":{"end":{"character":9999,"line":476},"start":{"line":474,"character":0}},"kind":12},{"line":491,"kind":12,"range":{"end":{"line":493,"character":9999},"start":{"character":0,"line":491}},"definition":"sub","children":[{"line":492,"name":"feature2","kind":12,"containerName":"hsource_tag"},{"containerName":"hsource_tag","kind":12,"name":"source_tag","line":492}],"containerName":"main::","name":"hsource_tag"},{"kind":12,"range":{"start":{"character":0,"line":506},"end":{"character":9999,"line":514}},"line":506,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: FeaturePair.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::FeaturePair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::FeaturePair - hold pair feature information e.g. blast hits\n\n=head1 SYNOPSIS\n\n    my $feat  = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,\n\t\t\t\t\t\t -feature2 => $f2,\n\t\t\t\t\t      );\n\n    # Bio::SeqFeatureI methods can be used\n\n    my $start = $feat->start;\n    my $end   = $feat->end;\n\n    # Bio::FeaturePair methods can be used\n    my $hstart = $feat->hstart;\n    my $hend   = $feat->hend;\n\n   my $feature1 = $feat->feature1;  # returns feature1 object\n\n=head1 DESCRIPTION\n\nA sequence feature object where the feature is itself a feature on\nanother sequence - e.g. a blast hit where residues 1-40 of a protein\nsequence SW:HBA_HUMAN has hit to bases 100 - 220 on a genomic sequence\nHS120G22.  The genomic sequence coordinates are used to create one\nsequence feature $f1 and the protein coordinates are used to create\nfeature $f2.  A FeaturePair object can then be made\n\n    my $fp = Bio::SeqFeature::FeaturePair->new(-feature1 => $f1,   # genomic\n\t\t\t\t\t      -feature2 => $f2,   # protein\n\t\t\t\t\t      );\n\nThis object can be used as a standard Bio::SeqFeatureI in which case\n\n    my $gstart = $fp->start  # returns start coord on feature1 - genomic seq.\n    my $gend   = $fp->end    # returns end coord on feature1.\n\nIn general standard Bio::SeqFeatureI method calls return information\nin feature1.\n\nData in the feature 2 object are generally obtained using the standard\nmethods prefixed by h (for hit!)\n\n    my $pstart = $fp->hstart # returns start coord on feature2 = protein seq.\n    my $pend   = $fp->hend   # returns end coord on feature2.\n\nIf you wish to swap feature1 and feature2 around :\n\n    $feat->invert\n\nso... \n\n    $feat->start # etc. returns data in $feature2 object\n\n\nNo sub_SeqFeatures or tags can be stored in this object directly.  Any\nfeatures or tags are expected to be stored in the contained objects\nfeature1, and feature2.\n\n=head1 CONTACT\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::FeaturePair;\nuse vars qw($AUTOLOAD);\nuse strict;\n\nuse Bio::SeqFeatureI;\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n=head2 new\n\n Title   : new\n Usage   :\n Function: Constructor for this module. Accepts the following parameters:\n\n             -feature1   Bio::SeqFeatureI-compliant object\n             -feature2   Bio::SeqFeatureI-compliant object\n             -feature_factory  Bio::Factory::ObjectFactoryI compliant\n                         object to be used when feature1 and/or feature2\n                         are accessed without explicitly set before. This\n                         is mostly useful for derived classes who want to\n                         set their preferred class for feature objects.\n\n Example :\n Returns : \n Args    : see above\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    #\n    # We've got a certain problem here that somewhat relates to chicken and\n    # eggs. The problem is, we override a lot of SeqFeatureI methods here\n    # to delegate them to either feature1 or feature2. If we pass along\n    # those attributes right away, we need feature1 or feature2 or the feature\n    # factory in place, or there is no way around the dreaded default, which\n    # is ugly too (as it necessitates subsequent copying if you wanted a\n    # different feature object class).\n    #\n    # So I decided to go with the lesser of two evils here: we need to assume\n    # here that we can set all attributes through set_attributes(), which we\n    # assume is no different from setting them through the constructor. This\n    # gives us a window to set the feature objects and the factory, such that\n    # any derived class doesn't have to worry about this any more.\n    #\n    # I'm happy to hear a better solution, but I think this one isn't so bad.\n    #\n    my $self = $class->SUPER::new();\n    my ($feature1,$feature2,$featfact) = \n\t$self->_rearrange([qw(FEATURE1\n\t\t\t      FEATURE2\n\t\t\t      FEATURE_FACTORY\n\t\t\t      )],@args);\n    \n    $self->_register_for_cleanup(\\&cleanup_fp);\n    # initialize the feature object factory if not provided\n    if(! $featfact) {\n\t$featfact = Bio::Factory::ObjectFactory->new(\n\t\t\t\t   -type => \"Bio::SeqFeature::Generic\",\n\t\t\t\t   -interface => \"Bio::SeqFeatureI\");\n    }\n    $self->feature_factory($featfact);\n    # Store the features in the object\n    $feature1 && $self->feature1($feature1);\n    $feature2 && $self->feature2($feature2);\n    \n    # OK. Now we're setup to store all the attributes, and they'll go right\n    # away into the right objects.\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 feature1\n\n Title   : feature1\n Usage   : $f = $featpair->feature1\n           $featpair->feature1($feature)\n Function: Get/set for the query feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI\n\n\n\nsub feature1 {\n    my ($self,$arg) = @_;    \n    if ( defined($arg) || !defined $self->{'feature1'} ) {\n\t$self->throw(\"internal error: feature factory not set!\") \n\t    unless $self->feature_factory;\n\t$arg = $self->feature_factory->create_object() unless( defined $arg);\n\t$self->throw(\"Argument [$arg] must be a Bio::SeqFeatureI\") \n\t    unless (ref($arg) && $arg->isa(\"Bio::SeqFeatureI\"));\n\t$self->{'feature1'} = $arg;\n    }\n    return $self->{'feature1'};\n}\n\n=head2 feature2\n\n Title   : feature2\n Usage   : $f = $featpair->feature2\n           $featpair->feature2($feature)\n Function: Get/set for the hit feature\n Returns : Bio::SeqFeatureI\n Args    : Bio::SeqFeatureI\n\n\n\nsub feature2 {\n    my ($self,$arg) = @_;\n\n    if ( defined($arg) || ! defined $self->{'feature2'}) {\n\t$self->throw(\"internal error: feature factory not set!\") \n\t    unless $self->feature_factory;\n\t$arg = $self->feature_factory->create_object() unless( defined $arg);\n\t$self->throw(\"Argument [$arg] must be a Bio::SeqFeatureI\") \n\t    unless (ref($arg) && $arg->isa(\"Bio::SeqFeatureI\"));\n\t$self->{'feature2'} = $arg;\n    }\n    return $self->{'feature2'};\n}\n\n=head2 start\n\n Title   : start\n Usage   : $start = $featpair->start\n           $featpair->start(20)\n Function: Get/set on the start coordinate of feature1\n Returns : integer\n Args    : [optional] beginning of feature\n\n\nsub start {\n    return shift->feature1->start(@_);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $featpair->end\n           $featpair->end($end)\n Function: get/set on the end coordinate of feature1\n Returns : integer\n Args    : [optional] ending point of feature\n\n\n\nsub end{\n    return shift->feature1->end(@_);    \n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : [optional] strand information to set\n\n\n\nsub strand{\n    return shift->feature1->strand(@_);    \n}\n\n=head2 location\n\n Title   : location\n Usage   : $location = $featpair->location\n           $featpair->location($location)\n Function: Get/set location object (using feature1)\n Returns : Bio::LocationI object\n Args    : [optional] LocationI to store\n\n\nsub location {\n    return shift->feature1->location(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    return shift->feature1->score(@_);    \n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n    return shift->feature1->frame(@_);    \n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $ptag = $featpair->primary_tag\n Function: get/set on the primary_tag of feature1\n Returns : 0,1,2\n Args    : none if get, the new value if set\n\n\n\nsub primary_tag{\n    return shift->feature1->primary_tag(@_);    \n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub source_tag{\n    return shift->feature1->source_tag(@_);    \n}\n\n=head2 seqname\n\n Title   : seqname\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store \n           the seqname.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seqname\n Args    : newvalue (optional)\n\n\n\nsub seq_id{\n    return shift->feature1->seq_id(@_);    \n}\n\n=head2 hseqname\n\n Title   : hseqname\n Usage   : $featpair->hseqname($newval)\n Function: Get/set method for the name of\n           feature2.\n Returns : value of $feature2->seq_id\n Args    : newvalue (optional)\n\n\n\nsub hseq_id {\n    return shift->feature2->seq_id(@_);\n}\n\n\n=head2 hstart\n\n Title   : hstart\n Usage   : $start = $featpair->hstart\n           $featpair->hstart(20)\n Function: Get/set on the start coordinate of feature2\n Returns : integer\n Args    : none\n\n\nsub hstart {\n    return shift->feature2->start(@_);    \n}\n\n=head2 hend\n\n Title   : hend\n Usage   : $end = $featpair->hend\n           $featpair->hend($end)\n Function: get/set on the end coordinate of feature2\n Returns : integer\n Args    : none\n\n\n\nsub hend{\n    return shift->feature2->end(@_);    \n}\n\n\n=head2 hstrand\n\n Title   : hstrand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub hstrand{\n    return shift->feature2->strand(@_);\n}\n\n=head2 hscore\n\n Title   : hscore\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub hscore {\n    return shift->feature2->score(@_);    \n}\n\n=head2 hframe\n\n Title   : hframe\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2\n Args    : none if get, the new value if set\n\n\n\nsub hframe {\n    return shift->feature2->frame(@_);    \n}\n\n=head2 hprimary_tag\n\n Title   : hprimary_tag\n Usage   : $ptag = $featpair->hprimary_tag\n Function: Get/set on the primary_tag of feature2\n Returns : 0,1,2\n Args    : none if get, the new value if set\n\n\n\nsub hprimary_tag{\n    return shift->feature2->primary_tag(@_);    \n}\n\n=head2 hsource_tag\n\n Title   : hsource_tag\n Usage   : $tag = $feat->hsource_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan' \n Returns : a string \n Args    : none\n\n\n\nsub hsource_tag{\n    return shift->feature2->source_tag(@_);\n}\n\n=head2 invert\n\n Title   : invert\n Usage   : $tag = $feat->invert\n Function: Swaps feature1 and feature2 around\n Returns : Nothing\n Args    : none","label":"invert($self)"},"containerName":"main::","name":"invert","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"invert","line":507},{"definition":"my","line":509,"name":"$tmp","localvar":"my","kind":13,"containerName":"invert"},{"line":509,"name":"$self","containerName":"invert","kind":13},{"name":"feature1","kind":12,"containerName":"invert","line":509},{"kind":13,"containerName":"invert","name":"$self","line":511},{"containerName":"invert","kind":12,"name":"feature1","line":511},{"name":"$self","kind":13,"containerName":"invert","line":511},{"line":511,"name":"feature2","kind":12,"containerName":"invert"},{"line":512,"kind":13,"containerName":"invert","name":"$self"},{"line":512,"containerName":"invert","kind":12,"name":"feature2"},{"name":"$tmp","kind":13,"containerName":"invert","line":512}],"detail":"($self)","definition":"sub"},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"feature_factory","line":539,"definition":"my"},{"containerName":"feature_factory","kind":13,"name":"$self","line":541},{"line":542,"containerName":"feature_factory","kind":13,"name":"$self"}],"name":"feature_factory","containerName":"main::","line":538,"range":{"end":{"character":9999,"line":543},"start":{"character":0,"line":538}},"kind":12},{"line":551,"range":{"start":{"character":0,"line":551},"end":{"line":555,"character":9999}},"kind":12,"children":[{"containerName":"hseqname","localvar":"my","kind":13,"name":"$self","line":552,"definition":"my"},{"kind":13,"containerName":"hseqname","name":"$self","line":553},{"line":553,"containerName":"hseqname","kind":12,"name":"warn"},{"line":554,"name":"$self","kind":13,"containerName":"hseqname"},{"line":554,"name":"hseq_id","kind":12,"containerName":"hseqname"}],"name":"hseqname","containerName":"main::","definition":"sub"},{"line":557,"range":{"start":{"character":0,"line":557},"end":{"character":9999,"line":560}},"kind":12,"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"cleanup_fp","name":"$self","line":558},{"name":"$self","containerName":"cleanup_fp","kind":13,"line":559},{"line":559,"kind":13,"containerName":"cleanup_fp","name":"$self"}],"containerName":"main::","name":"cleanup_fp","definition":"sub"}],"version":5}