{"vars":[{"name":"vars","kind":2,"containerName":"","line":170},{"line":175,"containerName":"","kind":2,"name":"base"},{"kind":13,"containerName":null,"name":"$DEFAULT_NAME","line":180},{"kind":13,"containerName":null,"name":"$GAP","line":181},{"name":"$META_GAP","kind":13,"containerName":null,"line":182},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$class","line":203},{"line":203,"containerName":"new","kind":13,"name":"@args"},{"line":205,"name":"$self","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":205},{"line":205,"name":"@args","kind":13,"containerName":"new"},{"line":207,"name":"$meta","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":207,"containerName":"new","kind":13,"name":"$qual"},{"line":207,"containerName":"new","kind":13,"name":"$trace"},{"line":207,"name":"$trace_indices","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$trace_data","line":207},{"line":208,"containerName":"new","kind":13,"name":"$self"},{"line":208,"kind":12,"containerName":"new","name":"_rearrange"},{"line":213,"containerName":"new","kind":13,"name":"@args"},{"line":215,"containerName":"new","kind":13,"name":"$self"},{"line":215,"containerName":"new","kind":13,"name":"$DEFAULT_NAME"},{"name":"$self","kind":13,"containerName":"new","line":216},{"line":217,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$trace_data","line":217},{"name":"$meta","kind":13,"containerName":"new","line":219},{"containerName":"new","kind":13,"name":"$self","line":219},{"line":219,"kind":12,"containerName":"new","name":"meta"},{"name":"$meta","kind":13,"containerName":"new","line":219},{"line":220,"name":"$qual","kind":13,"containerName":"new"},{"line":220,"kind":13,"containerName":"new","name":"$self"},{"line":220,"name":"qual","containerName":"new","kind":12},{"line":220,"name":"$qual","kind":13,"containerName":"new"},{"line":221,"name":"$trace","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":221},{"name":"named_meta","containerName":"new","kind":12,"line":221},{"name":"$trace","kind":13,"containerName":"new","line":221},{"line":222,"containerName":"new","kind":13,"name":"$trace_indices"},{"containerName":"new","kind":13,"name":"$self","line":222},{"line":222,"name":"named_meta","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$trace_indices","line":222},{"line":224,"containerName":"new","kind":13,"name":"$self"}],"containerName":"main::","name":"new","signature":{"documentation":"1;\n# $Id: Quality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Quality\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Quality - Implementation of sequence with residue quality and trace values\n\n=head1 SYNOPSIS\n\n  use Bio::Seq::Quality;\n\n  # input can be space delimited string or array ref\n  my $qual = '0 1 2 3 4 5 6 7 8 9 11 12';\n  my $trace = '0 5 10 15 20 25 30 35 40 45 50 55';\n\n  my $seq = Bio::Seq::Quality->new\n      ( -qual => $qual,\n        -trace_indices => $trace,\n        -seq =>  'atcgatcgatcg',\n        -id  => 'human_id',\n        -accession_number => 'S000012',\n        -verbose => -1   # to silence deprecated methods\n  );\n\n  my $quals = $seq->qual; # array ref\n  my $traces = $seq->trace;  # array ref\n\n  my $quals = $seq->qual_text; # string\n  my $traces = $seq->trace_text; # string\n\n\n  # get sub values\n  $quals = $seq->subqual(2, 3);  # array ref\n  $traces = $seq->subtrace(2, 3); # array ref\n  $quals = $seq->subqual_text(2, 3); # string\n  $quals = $seq->subtrace_text(2, 3); # string\n\n  # set sub values \n  $seq->subqual(2, 3, \"9 9\");\n  $seq->subtrace(2, 3, \"9 9\");\n\n\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence\nstring.\n\nIt is a reimplementation of Chad Matsalla's Bio::Seq::SeqWithQuality\nmodule using Bio::Seq::MetaI. \n\nThe implementation is based on Bio::Seq::Meta::Array. qual() and\ntrace() are base methods to store and retrieve information that have\nextensions to retrieve values as a scalar (e.g. qual_text() ), or get\nor set subvalues (e.g. subqual() ). See L<Bio::Seq::MetaI> for more details.\n\nAll the functional code is in Bio::Seq::Meta::Array.\n\nThere deprecated methods that are included for compatibility with\nBio::Seq::SeqWithQuality. These will print a warning unless verbosity\nof the object is set to be less than zero.\n\n=head2 Differences from Bio::Seq::SeqWithQuality\n\nIt is not possible to fully follow the interface of\nBio::Seq::SeqWithQuality since internally a Bio::Seq::SeqWithQuality\nobject is a composite of two independent objects: a Bio::PrimarySeq\nobject and Bio::Seq::PrimaryQual object. Both of these objects can be\ncreated separately and merged into Bio::Seq::SeqWithQuality.\n\nThis implementation is based on Bio::Seq::Meta::Array that is a subclass\nof Bio::PrimarySeq that stores any number of meta information in\nunnamed arrays.\n\nHere we assume that two meta sets, called 'qual' and 'trace_indices' are\nattached to a sequence. (But there is nothing that prevents you to add\nas many named meta sets as you need using normal meta() methods).\n\nqual() is an alias to meta(), qualat($loc) is an alias to\nsubmeta($loc,$loc).\n\ntrace_indices() in Bio::Seq::SeqWithQuality has been abbreviated to\ntrace() and is an alias to named_meta('trace').\n\nYou can create an object without passing any arguments to the\nconstructor (Bio::Seq::SeqWithQuality fails without alphabet). It will\nwarn about not being able to set alphabet unless you set verbosity of\nthe object to a negative value.\n\nAfter the latest rewrite, the meta information sets (quality and\ntrace) no longer cover all the residues automatically. Methods to\ncheck the length of meta information (L<quality_length>,\nL<trace_length>)and to see if the ends are flushed to the sequence\nhave been added (L<quality_is_flush>, L<trace_is_flush>). To force\nthe old functinality, set L<force_flush> to true.\n\nqual_obj() and seq_obj() methods do not exist!\n\nFinally, there is only one set of descriptors (primary_id, display_id,\naccession_number) for the object.\n\n\n=head1 SEE ALSO\n\nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics at dieselwurks dot com\n\nDan Bolser, dan dot bolser at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Quality;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::Seq::Meta::Array);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Quality->new\n\t        ( -qual => '0 1 2 3 4 5 6 7 8 9 11 12',\n                  -trace => '0 5 10 15 20 25 30 35 40 45 50 55',\n                  -seq =>  'atcgatcgatcg',\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Quality class.\n           Note that you can provide an empty quality and trace strings.\n Returns : a new Bio::Seq::Quality object","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"line":202,"kind":12,"range":{"end":{"line":225,"character":9999},"start":{"line":202,"character":0}}},{"name":"SUPER","kind":12,"containerName":"new","line":205},{"name":"trace_data","kind":12,"line":217},{"children":[{"localvar":"my","containerName":"qual","kind":13,"name":"$self","line":250,"definition":"my"},{"definition":"my","line":251,"name":"$value","containerName":"qual","localvar":"my","kind":13},{"containerName":"qual","kind":13,"name":"$value","line":252},{"name":"$value","containerName":"qual","kind":13,"line":252},{"line":253,"name":"qual","kind":12,"containerName":"qual"},{"name":"$value","containerName":"qual","kind":13,"line":253},{"kind":13,"containerName":"qual","name":"$value","line":253},{"containerName":"qual","kind":13,"name":"$value","line":254},{"kind":12,"containerName":"qual","name":"isa","line":254},{"kind":13,"containerName":"qual","name":"$self","line":255},{"line":255,"name":"_empty_cache","containerName":"qual","kind":12},{"containerName":"qual","kind":13,"name":"$value","line":255},{"line":256,"name":"$self","containerName":"qual","kind":13},{"line":256,"name":"named_meta","kind":12,"containerName":"qual"},{"line":256,"containerName":"qual","kind":13,"name":"$DEFAULT_NAME"},{"name":"$value","containerName":"qual","kind":13,"line":256}],"name":"qual","containerName":"main::","definition":"sub","line":249,"kind":12,"range":{"start":{"line":249,"character":0},"end":{"line":257,"character":9999}}},{"line":270,"range":{"end":{"line":271,"character":9999},"start":{"character":0,"line":270}},"kind":12,"definition":"sub","children":[{"name":"submeta","containerName":"qual_text","kind":12,"line":271}],"containerName":"main::","name":"qual_text"},{"line":271,"name":"shift","kind":12},{"definition":"sub","children":[{"line":298,"kind":12,"containerName":"subqual","name":"named_submeta"},{"kind":13,"containerName":"subqual","name":"$DEFAULT_NAME","line":298}],"containerName":"main::","name":"subqual","line":297,"kind":12,"range":{"end":{"line":299,"character":9999},"start":{"line":297,"character":0}}},{"definition":"sub","children":[{"line":313,"name":"submeta","containerName":"subqual_text","kind":12}],"name":"subqual_text","containerName":"main::","line":312,"kind":12,"range":{"end":{"character":9999,"line":313},"start":{"character":0,"line":312}}},{"kind":12,"name":"shift","line":313},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":328,"localvar":"my","kind":13,"containerName":"quality_length","name":"$self"},{"line":329,"containerName":"quality_length","kind":13,"name":"$self"},{"name":"named_meta_length","containerName":"quality_length","kind":12,"line":329}],"name":"quality_length","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Quality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Quality\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Quality - Implementation of sequence with residue quality and trace values\n\n=head1 SYNOPSIS\n\n  use Bio::Seq::Quality;\n\n  # input can be space delimited string or array ref\n  my $qual = '0 1 2 3 4 5 6 7 8 9 11 12';\n  my $trace = '0 5 10 15 20 25 30 35 40 45 50 55';\n\n  my $seq = Bio::Seq::Quality->new\n      ( -qual => $qual,\n        -trace_indices => $trace,\n        -seq =>  'atcgatcgatcg',\n        -id  => 'human_id',\n        -accession_number => 'S000012',\n        -verbose => -1   # to silence deprecated methods\n  );\n\n  my $quals = $seq->qual; # array ref\n  my $traces = $seq->trace;  # array ref\n\n  my $quals = $seq->qual_text; # string\n  my $traces = $seq->trace_text; # string\n\n\n  # get sub values\n  $quals = $seq->subqual(2, 3);  # array ref\n  $traces = $seq->subtrace(2, 3); # array ref\n  $quals = $seq->subqual_text(2, 3); # string\n  $quals = $seq->subtrace_text(2, 3); # string\n\n  # set sub values \n  $seq->subqual(2, 3, \"9 9\");\n  $seq->subtrace(2, 3, \"9 9\");\n\n\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence\nstring.\n\nIt is a reimplementation of Chad Matsalla's Bio::Seq::SeqWithQuality\nmodule using Bio::Seq::MetaI. \n\nThe implementation is based on Bio::Seq::Meta::Array. qual() and\ntrace() are base methods to store and retrieve information that have\nextensions to retrieve values as a scalar (e.g. qual_text() ), or get\nor set subvalues (e.g. subqual() ). See L<Bio::Seq::MetaI> for more details.\n\nAll the functional code is in Bio::Seq::Meta::Array.\n\nThere deprecated methods that are included for compatibility with\nBio::Seq::SeqWithQuality. These will print a warning unless verbosity\nof the object is set to be less than zero.\n\n=head2 Differences from Bio::Seq::SeqWithQuality\n\nIt is not possible to fully follow the interface of\nBio::Seq::SeqWithQuality since internally a Bio::Seq::SeqWithQuality\nobject is a composite of two independent objects: a Bio::PrimarySeq\nobject and Bio::Seq::PrimaryQual object. Both of these objects can be\ncreated separately and merged into Bio::Seq::SeqWithQuality.\n\nThis implementation is based on Bio::Seq::Meta::Array that is a subclass\nof Bio::PrimarySeq that stores any number of meta information in\nunnamed arrays.\n\nHere we assume that two meta sets, called 'qual' and 'trace_indices' are\nattached to a sequence. (But there is nothing that prevents you to add\nas many named meta sets as you need using normal meta() methods).\n\nqual() is an alias to meta(), qualat($loc) is an alias to\nsubmeta($loc,$loc).\n\ntrace_indices() in Bio::Seq::SeqWithQuality has been abbreviated to\ntrace() and is an alias to named_meta('trace').\n\nYou can create an object without passing any arguments to the\nconstructor (Bio::Seq::SeqWithQuality fails without alphabet). It will\nwarn about not being able to set alphabet unless you set verbosity of\nthe object to a negative value.\n\nAfter the latest rewrite, the meta information sets (quality and\ntrace) no longer cover all the residues automatically. Methods to\ncheck the length of meta information (L<quality_length>,\nL<trace_length>)and to see if the ends are flushed to the sequence\nhave been added (L<quality_is_flush>, L<trace_is_flush>). To force\nthe old functinality, set L<force_flush> to true.\n\nqual_obj() and seq_obj() methods do not exist!\n\nFinally, there is only one set of descriptors (primary_id, display_id,\naccession_number) for the object.\n\n\n=head1 SEE ALSO\n\nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics at dieselwurks dot com\n\nDan Bolser, dan dot bolser at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Quality;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::Seq::Meta::Array);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Quality->new\n\t        ( -qual => '0 1 2 3 4 5 6 7 8 9 11 12',\n                  -trace => '0 5 10 15 20 25 30 35 40 45 50 55',\n                  -seq =>  'atcgatcgatcg',\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Quality class.\n           Note that you can provide an empty quality and trace strings.\n Returns : a new Bio::Seq::Quality object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $qual, $trace, $trace_indices, $trace_data) =\n        $self->_rearrange([qw(META\n                              QUAL\n                              TRACE\n                              TRACE_INDICES\n                              TRACE_DATA)],\n                          @args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n    $self->{'_meta'}->{'trace'} = [];\n    $self->{trace_data} = $trace_data;\n\n    $meta && $self->meta($meta);\n    $qual && $self->qual($qual);\n    $trace && $self->named_meta('trace', $trace);\n    $trace_indices && $self->named_meta('trace', $trace_indices);\n\n    return $self;\n}\n\n\n=head2 qual\n\n Title   : qual\n Usage   : $qual_values  = $obj->qual($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref or Bio::Seq::PrimaryQual, optional\n\nSetting quality values resets the cached good quality ranges that\ndepend on the set threshold value.\n\n\nsub qual {\n    my $self = shift;\n    my $value = shift;\n    $value = $value->qual\n        if ref($value) and ref($value) ne 'ARRAY' and\n           $value->isa('Bio::Seq::PrimaryQual');\n    $self->_empty_cache if $value;\n    $self->named_meta($DEFAULT_NAME, $value);\n}\n\n=head2 qual_text\n\n Title   : qual_text\n Usage   : $qual_values  = $obj->qual_text($values_arrayref);\n Function: Variant of meta() and qual()  guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub qual_text {\n    return join ' ', @{shift->submeta(@_)};\n}\n\n=head2 subqual\n\n Title   : subqual\n Usage   : $subset_of_qual_values = $obj->subqual(10, 20, $value_string);\n           $subset_of_qual_values = $obj->subqual(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n Returns : A reference to an array\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub subqual {\n    shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 subqual_text\n\n Title   : subqual_text\n Usage   : $meta_values  = $obj->subqual_text(20, $value_string);\n Function: Variant of subqual() returning a stringified\n           representation  of meta data. For details, see L<Bio::Seq::MetaI>.\n Returns : a string\n Args    : new value, optional\n\n\nsub subqual_text {\n    return join ' ', @{shift->submeta(@_)};\n}\n\n\n=head2 quality_length\n\n Title   : quality_length()\n Usage   : $qual_len  = $obj->quality_length();\n Function: return the number of elements in the quality array\n Returns : integer\n Args    : -","label":"quality_length($self)"},"line":327,"range":{"start":{"character":0,"line":327},"end":{"line":330,"character":9999}},"kind":12},{"definition":"sub","containerName":"main::","name":"quality_is_flush","children":[{"name":"is_flush","containerName":"quality_is_flush","kind":12,"line":346}],"range":{"end":{"character":9999,"line":347},"start":{"character":0,"line":345}},"kind":12,"line":345},{"definition":"sub","containerName":"main::","name":"trace","children":[{"line":369,"name":"named_meta","kind":12,"containerName":"trace"}],"range":{"end":{"character":9999,"line":370},"start":{"character":0,"line":368}},"kind":12,"line":368},{"line":383,"range":{"end":{"line":384,"character":9999},"start":{"line":383,"character":0}},"kind":12,"definition":"sub","children":[{"line":384,"name":"named_submeta","kind":12,"containerName":"trace_text"}],"containerName":"main::","name":"trace_text"},{"line":384,"kind":12,"name":"shift"},{"definition":"sub","name":"subtrace","containerName":"main::","children":[{"line":412,"containerName":"subtrace","kind":12,"name":"named_submeta"}],"kind":12,"range":{"end":{"character":9999,"line":413},"start":{"line":411,"character":0}},"line":411},{"kind":12,"range":{"end":{"line":427,"character":9999},"start":{"line":426,"character":0}},"line":426,"containerName":"main::","name":"subtrace_text","children":[{"line":427,"containerName":"subtrace_text","kind":12,"name":"named_submeta"}],"definition":"sub"},{"name":"shift","kind":12,"line":427},{"detail":"($self)","definition":"sub","name":"trace_length","containerName":"main::","children":[{"definition":"my","line":442,"localvar":"my","kind":13,"containerName":"trace_length","name":"$self"},{"line":443,"name":"$self","containerName":"trace_length","kind":13},{"name":"named_meta_length","kind":12,"containerName":"trace_length","line":443}],"signature":{"label":"trace_length($self)","documentation":"1;\n# $Id: Quality.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::Quality\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::Quality - Implementation of sequence with residue quality and trace values\n\n=head1 SYNOPSIS\n\n  use Bio::Seq::Quality;\n\n  # input can be space delimited string or array ref\n  my $qual = '0 1 2 3 4 5 6 7 8 9 11 12';\n  my $trace = '0 5 10 15 20 25 30 35 40 45 50 55';\n\n  my $seq = Bio::Seq::Quality->new\n      ( -qual => $qual,\n        -trace_indices => $trace,\n        -seq =>  'atcgatcgatcg',\n        -id  => 'human_id',\n        -accession_number => 'S000012',\n        -verbose => -1   # to silence deprecated methods\n  );\n\n  my $quals = $seq->qual; # array ref\n  my $traces = $seq->trace;  # array ref\n\n  my $quals = $seq->qual_text; # string\n  my $traces = $seq->trace_text; # string\n\n\n  # get sub values\n  $quals = $seq->subqual(2, 3);  # array ref\n  $traces = $seq->subtrace(2, 3); # array ref\n  $quals = $seq->subqual_text(2, 3); # string\n  $quals = $seq->subtrace_text(2, 3); # string\n\n  # set sub values \n  $seq->subqual(2, 3, \"9 9\");\n  $seq->subtrace(2, 3, \"9 9\");\n\n\n\n=head1 DESCRIPTION\n\nThis object stores base quality values together with the sequence\nstring.\n\nIt is a reimplementation of Chad Matsalla's Bio::Seq::SeqWithQuality\nmodule using Bio::Seq::MetaI. \n\nThe implementation is based on Bio::Seq::Meta::Array. qual() and\ntrace() are base methods to store and retrieve information that have\nextensions to retrieve values as a scalar (e.g. qual_text() ), or get\nor set subvalues (e.g. subqual() ). See L<Bio::Seq::MetaI> for more details.\n\nAll the functional code is in Bio::Seq::Meta::Array.\n\nThere deprecated methods that are included for compatibility with\nBio::Seq::SeqWithQuality. These will print a warning unless verbosity\nof the object is set to be less than zero.\n\n=head2 Differences from Bio::Seq::SeqWithQuality\n\nIt is not possible to fully follow the interface of\nBio::Seq::SeqWithQuality since internally a Bio::Seq::SeqWithQuality\nobject is a composite of two independent objects: a Bio::PrimarySeq\nobject and Bio::Seq::PrimaryQual object. Both of these objects can be\ncreated separately and merged into Bio::Seq::SeqWithQuality.\n\nThis implementation is based on Bio::Seq::Meta::Array that is a subclass\nof Bio::PrimarySeq that stores any number of meta information in\nunnamed arrays.\n\nHere we assume that two meta sets, called 'qual' and 'trace_indices' are\nattached to a sequence. (But there is nothing that prevents you to add\nas many named meta sets as you need using normal meta() methods).\n\nqual() is an alias to meta(), qualat($loc) is an alias to\nsubmeta($loc,$loc).\n\ntrace_indices() in Bio::Seq::SeqWithQuality has been abbreviated to\ntrace() and is an alias to named_meta('trace').\n\nYou can create an object without passing any arguments to the\nconstructor (Bio::Seq::SeqWithQuality fails without alphabet). It will\nwarn about not being able to set alphabet unless you set verbosity of\nthe object to a negative value.\n\nAfter the latest rewrite, the meta information sets (quality and\ntrace) no longer cover all the residues automatically. Methods to\ncheck the length of meta information (L<quality_length>,\nL<trace_length>)and to see if the ends are flushed to the sequence\nhave been added (L<quality_is_flush>, L<trace_is_flush>). To force\nthe old functinality, set L<force_flush> to true.\n\nqual_obj() and seq_obj() methods do not exist!\n\nFinally, there is only one set of descriptors (primary_id, display_id,\naccession_number) for the object.\n\n\n=head1 SEE ALSO\n\nL<Bio::Seq::MetaI>, \nL<Bio::Seq::Meta::Array>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nChad Matsalla, bioinformatics at dieselwurks dot com\n\nDan Bolser, dan dot bolser at gmail dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::Quality;\nuse vars qw($DEFAULT_NAME $GAP $META_GAP);\nuse strict;\n\n#use overload '\"\"' => \\&to_string;\n\nuse base qw(Bio::Seq::Meta::Array);\n\n\nBEGIN {\n\n    $DEFAULT_NAME = 'DEFAULT';\n    $GAP = '-';\n    $META_GAP = ' ';\n}\n\n=head2 new\n\n Title   : new\n Usage   : $metaseq = Bio::Seq::Quality->new\n\t        ( -qual => '0 1 2 3 4 5 6 7 8 9 11 12',\n                  -trace => '0 5 10 15 20 25 30 35 40 45 50 55',\n                  -seq =>  'atcgatcgatcg',\n\t          -id  => 'human_id',\n\t          -accession_number => 'S000012',\n\t        );\n Function: Constructor for Bio::Seq::Quality class.\n           Note that you can provide an empty quality and trace strings.\n Returns : a new Bio::Seq::Quality object\n\n\n\nsub new {\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my($meta, $qual, $trace, $trace_indices, $trace_data) =\n        $self->_rearrange([qw(META\n                              QUAL\n                              TRACE\n                              TRACE_INDICES\n                              TRACE_DATA)],\n                          @args);\n\n    $self->{'_meta'}->{$DEFAULT_NAME} = [];\n    $self->{'_meta'}->{'trace'} = [];\n    $self->{trace_data} = $trace_data;\n\n    $meta && $self->meta($meta);\n    $qual && $self->qual($qual);\n    $trace && $self->named_meta('trace', $trace);\n    $trace_indices && $self->named_meta('trace', $trace_indices);\n\n    return $self;\n}\n\n\n=head2 qual\n\n Title   : qual\n Usage   : $qual_values  = $obj->qual($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref or Bio::Seq::PrimaryQual, optional\n\nSetting quality values resets the cached good quality ranges that\ndepend on the set threshold value.\n\n\nsub qual {\n    my $self = shift;\n    my $value = shift;\n    $value = $value->qual\n        if ref($value) and ref($value) ne 'ARRAY' and\n           $value->isa('Bio::Seq::PrimaryQual');\n    $self->_empty_cache if $value;\n    $self->named_meta($DEFAULT_NAME, $value);\n}\n\n=head2 qual_text\n\n Title   : qual_text\n Usage   : $qual_values  = $obj->qual_text($values_arrayref);\n Function: Variant of meta() and qual()  guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub qual_text {\n    return join ' ', @{shift->submeta(@_)};\n}\n\n=head2 subqual\n\n Title   : subqual\n Usage   : $subset_of_qual_values = $obj->subqual(10, 20, $value_string);\n           $subset_of_qual_values = $obj->subqual(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n Returns : A reference to an array\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\nsub subqual {\n    shift->named_submeta($DEFAULT_NAME, @_);\n}\n\n=head2 subqual_text\n\n Title   : subqual_text\n Usage   : $meta_values  = $obj->subqual_text(20, $value_string);\n Function: Variant of subqual() returning a stringified\n           representation  of meta data. For details, see L<Bio::Seq::MetaI>.\n Returns : a string\n Args    : new value, optional\n\n\nsub subqual_text {\n    return join ' ', @{shift->submeta(@_)};\n}\n\n\n=head2 quality_length\n\n Title   : quality_length()\n Usage   : $qual_len  = $obj->quality_length();\n Function: return the number of elements in the quality array\n Returns : integer\n Args    : -\n\n\nsub quality_length {\n   my ($self) = @_;\n   return $self->named_meta_length('DEFAULT');\n}\n\n\n\n=head2 quality_is_flush\n\n Title   : quality_is_flush\n Usage   : $quality_is_flush  = $obj->quality_is_flush()\n Function: Boolean to tell if the trace length equals the sequence length.\n           Returns true if force_flush() is set.\n Returns : boolean 1 or 0\n Args    : none\n\n\nsub quality_is_flush {\n    return shift->is_flush('quality');\n}\n\n\n=head2 trace\n\n Title   : trace\n Usage   : $trace_values  = $obj->trace($values_string);\n Function:\n\n           Get and set method for the meta data starting from residue\n           position one. Since it is dependent on the length of the\n           sequence, it needs to be manipulated after the sequence.\n\n           The length of the returned value always matches the length\n           of the sequence.\n\n Returns : reference to an array of meta data\n Args    : new value, string or array ref, optional\n\n\nsub trace {\n    return shift->named_meta('trace', shift);\n}\n\n=head2 trace_text\n\n Title   : trace_text\n Usage   : $trace_values  = $obj->trace_text($values_arrayref);\n Function: Variant of meta() and trace()  guarantied to return a string\n           representation  of meta data. For details, see L<meta>.\n Returns : a string\n Args    : new value, optional\n\n\nsub trace_text {\n    return join ' ', @{shift->named_submeta('trace', @_)};\n}\n\n=head2 subtrace\n\n Title   : subtrace\n Usage   : $subset_of_trace_values = $obj->subtrace(10, 20, $value_string);\n           $subset_of_trace_values = $obj->subtrace(10, undef, $value_string);\n Function:\n\n           Get and set method for meta data for subsequences.\n\n           Numbering starts from 1 and the number is inclusive, ie 1-2\n           are the first two residue of the sequence. Start cannot be\n           larger than end but can be equal.\n\n           If the second argument is missing the returned values\n           should extend to the end of the sequence.\n\n Returns : A reference to an array\n Args    : integer, start position\n           integer, end position, optional when a third argument present\n           new value, optional\n\n\n\nsub subtrace {\n    return shift->named_submeta('trace', @_);\n}\n\n=head2 subtrace_text\n\n Title   : subtrace_text\n Usage   : $meta_values  = $obj->subtrace_text(20, $value_string);\n Function: Variant of subtrace() returning a stringified\n           representation  of meta data. For details, see L<Bio::Seq::MetaI>.\n Returns : a string\n Args    : new value, optional\n\n\nsub subtrace_text {\n    return join ' ', @{shift->named_submeta('trace', @_)};\n}\n\n\n=head2 trace_length\n\n Title   : trace_length()\n Usage   : $trace_len  = $obj->trace_length();\n Function: return the number of elements in the trace set\n Returns : integer\n Args    : -","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":444},"start":{"character":0,"line":441}},"kind":12,"line":441},{"kind":12,"range":{"end":{"character":9999,"line":459},"start":{"line":457,"character":0}},"line":457,"name":"trace_is_flush","containerName":"main::","children":[{"line":458,"containerName":"trace_is_flush","kind":12,"name":"is_flush"}],"definition":"sub"},{"containerName":"main::","name":"get_trace_graph","children":[{"definition":"my","line":481,"localvar":"my","kind":13,"containerName":"get_trace_graph","name":"$self"},{"kind":13,"localvar":"my","containerName":"get_trace_graph","name":"$trace","line":482,"definition":"my"},{"line":482,"kind":13,"containerName":"get_trace_graph","name":"$scale"},{"line":483,"containerName":"get_trace_graph","kind":13,"name":"$self"},{"line":483,"name":"_rearrange","containerName":"get_trace_graph","kind":12},{"name":"$trace","kind":13,"containerName":"get_trace_graph","line":487},{"line":488,"name":"$self","kind":13,"containerName":"get_trace_graph"},{"kind":13,"containerName":"get_trace_graph","name":"$trace","line":489},{"line":489,"name":"$trace","kind":13,"containerName":"get_trace_graph"},{"containerName":"get_trace_graph","localvar":"my","kind":13,"name":"@trace_data","line":490,"definition":"my"},{"line":490,"name":"$self","kind":13,"containerName":"get_trace_graph"},{"line":490,"containerName":"get_trace_graph","kind":13,"name":"$trace"},{"name":"$self","containerName":"get_trace_graph","kind":13,"line":490},{"line":490,"containerName":"get_trace_graph","kind":13,"name":"$trace"},{"containerName":"get_trace_graph","kind":13,"name":"$self","line":491},{"line":491,"name":"$trace","containerName":"get_trace_graph","kind":13}],"definition":"sub","kind":12,"range":{"start":{"line":479,"character":0},"end":{"line":491,"character":9999}},"line":479},{"kind":12,"name":"trace_data","line":488},{"kind":12,"name":"trace_data","line":490},{"line":490,"kind":12,"name":"trace_data"},{"name":"trace_data","kind":12,"line":491},{"definition":"my","name":"$max","containerName":null,"localvar":"my","kind":13,"line":492},{"kind":13,"containerName":null,"name":"%self","line":492},{"line":492,"kind":12,"name":"trace_data"},{"kind":12,"name":"max_height","line":492},{"line":493,"kind":13,"containerName":null,"name":"$scale"},{"kind":13,"containerName":null,"name":"%scale","line":493},{"kind":13,"containerName":null,"name":"@trace_data","line":495},{"kind":13,"containerName":null,"name":"$max","line":495},{"line":495,"name":"$scale","containerName":null,"kind":13},{"name":"@trace_data","containerName":null,"kind":13,"line":495},{"name":"@trace_data","containerName":null,"kind":13,"line":497},{"name":"threshold","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"threshold","name":"$self","line":514},{"definition":"my","line":515,"name":"$value","kind":13,"localvar":"my","containerName":"threshold"},{"containerName":"threshold","kind":13,"name":"$value","line":516},{"line":517,"kind":13,"containerName":"threshold","name":"$self"},{"line":517,"containerName":"threshold","kind":12,"name":"throw"},{"line":518,"kind":13,"containerName":"threshold","name":"$value"},{"containerName":"threshold","kind":13,"name":"$self","line":519},{"name":"_empty_cache","kind":12,"containerName":"threshold","line":519},{"line":520,"name":"$self","containerName":"threshold","kind":13},{"containerName":"threshold","kind":13,"name":"$self","line":520},{"line":520,"name":"$value","containerName":"threshold","kind":13},{"containerName":"threshold","kind":13,"name":"$self","line":521},{"containerName":"threshold","kind":13,"name":"$value","line":521},{"name":"$self","kind":13,"containerName":"threshold","line":523}],"definition":"sub","kind":12,"range":{"start":{"line":513,"character":0},"end":{"character":9999,"line":524}},"line":513},{"line":520,"name":"_threshold","kind":12},{"kind":12,"name":"_threshold","line":520},{"name":"_threshold","kind":12,"line":521},{"line":523,"kind":12,"name":"_threshold"},{"definition":"sub","containerName":"main::","name":"count_clear_ranges","children":[{"line":541,"kind":13,"localvar":"my","containerName":"count_clear_ranges","name":"$self","definition":"my"},{"line":542,"containerName":"count_clear_ranges","localvar":"my","kind":13,"name":"$threshold","definition":"my"},{"containerName":"count_clear_ranges","kind":13,"name":"$self","line":543},{"kind":12,"containerName":"count_clear_ranges","name":"threshold","line":543},{"line":543,"containerName":"count_clear_ranges","kind":13,"name":"$threshold"},{"line":543,"containerName":"count_clear_ranges","kind":13,"name":"$threshold"},{"line":546,"name":"$self","containerName":"count_clear_ranges","kind":13},{"line":546,"name":"_find_clear_ranges","kind":12,"containerName":"count_clear_ranges"},{"line":546,"containerName":"count_clear_ranges","kind":13,"name":"$self"},{"line":548,"containerName":"count_clear_ranges","kind":13,"name":"$self"}],"range":{"end":{"line":548,"character":9999},"start":{"character":0,"line":540}},"kind":12,"line":540},{"name":"_ranges","kind":12,"line":546},{"name":"_ranges","kind":12,"line":548},{"line":564,"range":{"start":{"character":0,"line":564},"end":{"character":9999,"line":573}},"kind":12,"children":[{"line":565,"localvar":"my","containerName":"clear_ranges_length","kind":13,"name":"$self","definition":"my"},{"name":"$threshold","kind":13,"localvar":"my","containerName":"clear_ranges_length","line":566,"definition":"my"},{"name":"$self","containerName":"clear_ranges_length","kind":13,"line":567},{"containerName":"clear_ranges_length","kind":12,"name":"threshold","line":567},{"line":567,"containerName":"clear_ranges_length","kind":13,"name":"$threshold"},{"name":"$threshold","kind":13,"containerName":"clear_ranges_length","line":567},{"containerName":"clear_ranges_length","kind":13,"name":"$self","line":570},{"name":"_find_clear_ranges","kind":12,"containerName":"clear_ranges_length","line":570},{"kind":13,"containerName":"clear_ranges_length","name":"$self","line":570},{"definition":"my","line":572,"containerName":"clear_ranges_length","localvar":"my","kind":13,"name":"$sum"},{"name":"$sum","containerName":"clear_ranges_length","kind":13,"line":573},{"kind":13,"containerName":"clear_ranges_length","name":"$self","line":573}],"name":"clear_ranges_length","containerName":"main::","definition":"sub"},{"line":570,"name":"_ranges","kind":12},{"name":"length","kind":12,"line":573},{"line":573,"kind":12,"name":"_ranges"},{"line":574,"containerName":null,"kind":13,"name":"$sum"},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"get_clear_range","name":"$self","line":591},{"definition":"my","localvar":"my","kind":13,"containerName":"get_clear_range","name":"$threshold","line":592},{"name":"$self","kind":13,"containerName":"get_clear_range","line":593},{"containerName":"get_clear_range","kind":12,"name":"threshold","line":593},{"kind":13,"containerName":"get_clear_range","name":"$threshold","line":593},{"line":593,"kind":13,"containerName":"get_clear_range","name":"$threshold"},{"containerName":"get_clear_range","kind":13,"name":"$self","line":596},{"line":596,"name":"_find_clear_ranges","kind":12,"containerName":"get_clear_range"},{"kind":13,"containerName":"get_clear_range","name":"$self","line":596},{"line":599,"containerName":"get_clear_range","kind":13,"name":"$self"},{"line":602,"name":"$b","kind":13,"containerName":"get_clear_range"},{"name":"$a","kind":13,"containerName":"get_clear_range","line":602},{"name":"$self","containerName":"get_clear_range","kind":13,"line":602}],"containerName":"main::","name":"get_clear_range","line":590,"kind":12,"range":{"start":{"character":0,"line":590},"end":{"line":602,"character":9999}}},{"line":596,"name":"_ranges","kind":12},{"line":599,"name":"_ranges","kind":12},{"name":"length","kind":12,"line":602},{"name":"length","kind":12,"line":602},{"kind":12,"name":"_ranges","line":602},{"line":604,"kind":12,"containerName":"Seq::Quality","name":"Bio"},{"kind":12,"containerName":"main::","name":"new","line":605},{"kind":13,"containerName":null,"name":"$self","line":605},{"name":"subseq","kind":12,"containerName":"main::","line":605},{"line":605,"name":"start","kind":12},{"line":605,"name":"end","kind":12},{"name":"$self","kind":13,"containerName":null,"line":606},{"line":606,"kind":12,"containerName":"main::","name":"subqual"},{"line":606,"name":"start","kind":12},{"kind":12,"name":"end","line":606},{"children":[{"line":627,"name":"$self","kind":13,"localvar":"my","containerName":"get_all_clean_ranges","definition":"my"},{"definition":"my","line":628,"name":"$minl","localvar":"my","kind":13,"containerName":"get_all_clean_ranges"},{"containerName":"get_all_clean_ranges","kind":13,"name":"$minl","line":630},{"name":"$self","containerName":"get_all_clean_ranges","kind":13,"line":631},{"line":631,"containerName":"get_all_clean_ranges","kind":12,"name":"throw"},{"line":632,"kind":13,"containerName":"get_all_clean_ranges","name":"$minl"},{"line":635,"containerName":"get_all_clean_ranges","kind":13,"name":"$self"},{"name":"_find_clear_ranges","kind":12,"containerName":"get_all_clean_ranges","line":635},{"name":"$self","kind":13,"containerName":"get_all_clean_ranges","line":635},{"definition":"my","line":638,"localvar":"my","kind":13,"containerName":"get_all_clean_ranges","name":"@ranges"},{"definition":"my","line":639,"localvar":"my","kind":13,"containerName":"get_all_clean_ranges","name":"$r"},{"name":"$b","kind":13,"containerName":"get_all_clean_ranges","line":639},{"name":"$a","containerName":"get_all_clean_ranges","kind":13,"line":639},{"kind":13,"containerName":"get_all_clean_ranges","name":"$self","line":639}],"name":"get_all_clean_ranges","containerName":"main::","definition":"sub","line":626,"range":{"start":{"character":0,"line":626},"end":{"character":9999,"line":639}},"kind":12},{"kind":12,"name":"_ranges","line":635},{"line":639,"kind":12,"name":"start"},{"line":639,"name":"start","kind":12},{"kind":12,"name":"_ranges","line":639},{"line":640,"kind":13,"containerName":null,"name":"%r"},{"line":640,"name":"length","kind":12},{"line":640,"containerName":null,"kind":13,"name":"$minl"},{"line":642,"kind":13,"containerName":null,"name":"@ranges"},{"kind":12,"containerName":"Seq::Quality","name":"Bio","line":642},{"containerName":"main::","kind":12,"name":"new","line":643},{"line":643,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"subseq","line":643},{"containerName":null,"kind":13,"name":"%r","line":643},{"line":643,"kind":12,"name":"start"},{"line":643,"kind":13,"containerName":null,"name":"%r"},{"name":"end","kind":12,"line":643},{"kind":13,"containerName":null,"name":"$self","line":644},{"line":644,"name":"subqual","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"%r","line":644},{"kind":12,"name":"start","line":644},{"name":"%r","containerName":null,"kind":13,"line":644},{"line":644,"name":"end","kind":12},{"containerName":null,"kind":13,"name":"@ranges","line":647},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_find_clear_ranges","name":"$self","line":656},{"name":"$self","containerName":"_find_clear_ranges","kind":13,"line":658},{"name":"throw","kind":12,"containerName":"_find_clear_ranges","line":658},{"line":659,"name":"$self","containerName":"_find_clear_ranges","kind":13},{"kind":12,"containerName":"_find_clear_ranges","name":"threshold","line":659},{"line":661,"localvar":"my","containerName":"_find_clear_ranges","kind":13,"name":"$flag","definition":"my"},{"name":"$threshold","containerName":"_find_clear_ranges","localvar":"my","kind":13,"line":662,"definition":"my"},{"name":"$self","containerName":"_find_clear_ranges","kind":13,"line":662},{"containerName":"_find_clear_ranges","kind":12,"name":"threshold","line":662},{"definition":"my","kind":13,"localvar":"my","containerName":"_find_clear_ranges","name":"$i","line":663},{"definition":"my","line":664,"name":"$q","localvar":"my","containerName":"_find_clear_ranges","kind":13},{"kind":13,"containerName":"_find_clear_ranges","name":"$self","line":664},{"line":664,"name":"qual","kind":12,"containerName":"_find_clear_ranges"}],"containerName":"main::","name":"_find_clear_ranges","line":655,"kind":12,"range":{"start":{"character":0,"line":655},"end":{"line":664,"character":9999}}},{"kind":13,"containerName":null,"name":"$i","line":665},{"line":667,"containerName":null,"kind":13,"name":"%flag"},{"line":668,"name":"$q","containerName":null,"kind":13},{"line":668,"name":"%threshold","containerName":null,"kind":13},{"definition":"my","line":669,"localvar":"my","containerName":null,"kind":13,"name":"$range"},{"name":"%range","containerName":null,"kind":13,"line":670},{"line":670,"kind":12,"name":"end"},{"kind":13,"containerName":null,"name":"$i","line":670},{"line":671,"name":"%range","containerName":null,"kind":13},{"kind":12,"name":"start","line":671},{"line":671,"name":"$flag","kind":13,"containerName":null},{"line":672,"name":"%range","containerName":null,"kind":13},{"line":672,"name":"length","kind":12},{"line":672,"name":"$i","kind":13,"containerName":null},{"line":672,"name":"$flag","containerName":null,"kind":13},{"line":673,"name":"%self","kind":13,"containerName":null},{"line":673,"name":"_ranges","kind":12},{"line":673,"kind":13,"containerName":null,"name":"$range"},{"name":"%flag","kind":13,"containerName":null,"line":674},{"line":677,"kind":13,"containerName":null,"name":"$flag"},{"name":"$i","kind":13,"containerName":null,"line":677},{"name":"$q","kind":13,"containerName":null,"line":677},{"name":"$threshold","containerName":null,"kind":13,"line":677},{"line":681,"name":"%flag","kind":13,"containerName":null},{"definition":"my","line":683,"localvar":"my","containerName":null,"kind":13,"name":"$range"},{"kind":13,"containerName":null,"name":"%range","line":684},{"line":684,"name":"end","kind":12},{"containerName":null,"kind":13,"name":"$i","line":684},{"containerName":null,"kind":13,"name":"%range","line":685},{"line":685,"kind":12,"name":"start"},{"kind":13,"containerName":null,"name":"$flag","line":685},{"name":"%range","kind":13,"containerName":null,"line":686},{"name":"length","kind":12,"line":686},{"line":686,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"kind":13,"name":"$flag","line":686},{"kind":13,"containerName":null,"name":"%self","line":687},{"name":"_ranges","kind":12,"line":687},{"name":"$range","containerName":null,"kind":13,"line":687},{"range":{"start":{"line":694,"character":0},"end":{"line":697,"character":9999}},"kind":12,"line":694,"containerName":"main::","name":"_empty_cache","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_empty_cache","line":695},{"line":696,"name":"$self","containerName":"_empty_cache","kind":13}],"definition":"sub"},{"line":696,"kind":12,"name":"_ranges"},{"children":[{"definition":"my","localvar":"my","containerName":"trace_indices","kind":13,"name":"$self","line":706},{"name":"$self","containerName":"trace_indices","kind":13,"line":707},{"kind":12,"containerName":"trace_indices","name":"named_meta","line":707}],"name":"trace_indices","containerName":"main::","definition":"sub","line":705,"range":{"end":{"line":708,"character":9999},"start":{"line":705,"character":0}},"kind":12},{"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"trace_index_at","name":"$self","line":711},{"line":711,"containerName":"trace_index_at","kind":13,"name":"$val"},{"line":712,"name":"$self","kind":13,"containerName":"trace_index_at"},{"kind":12,"containerName":"trace_index_at","name":"named_submeta","line":712},{"name":"$val","kind":13,"containerName":"trace_index_at","line":712},{"name":"$val","kind":13,"containerName":"trace_index_at","line":712}],"containerName":"main::","name":"trace_index_at","signature":{"label":"trace_index_at($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":""},"line":710,"range":{"start":{"line":710,"character":0},"end":{"line":712,"character":9999}},"kind":12},{"definition":"sub","children":[{"definition":"my","line":717,"name":"$self","localvar":"my","kind":13,"containerName":"sub_trace_index"},{"name":"$self","containerName":"sub_trace_index","kind":13,"line":718},{"containerName":"sub_trace_index","kind":12,"name":"named_submeta","line":718}],"containerName":"main::","name":"sub_trace_index","line":716,"kind":12,"range":{"end":{"character":9999,"line":719},"start":{"character":0,"line":716}}},{"name":"qualat","containerName":"main::","children":[{"line":723,"containerName":"qualat","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$val","containerName":"qualat","kind":13,"line":723},{"name":"$self","containerName":"qualat","kind":13,"line":724},{"name":"submeta","containerName":"qualat","kind":12,"line":724},{"line":724,"name":"$val","containerName":"qualat","kind":13},{"line":724,"kind":13,"containerName":"qualat","name":"$val"}],"detail":"($self,$val)","definition":"sub","range":{"start":{"character":0,"line":722},"end":{"line":724,"character":9999}},"kind":12,"line":722,"signature":{"label":"qualat($self,$val)","documentation":"","parameters":[{"label":"$self"},{"label":"$val"}]}},{"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"baseat","kind":13,"line":729},{"line":729,"containerName":"baseat","kind":13,"name":"$val"},{"line":730,"containerName":"baseat","kind":13,"name":"$self"},{"name":"subseq","containerName":"baseat","kind":12,"line":730},{"line":730,"name":"$val","containerName":"baseat","kind":13},{"containerName":"baseat","kind":13,"name":"$val","line":730}],"containerName":"main::","name":"baseat","signature":{"label":"baseat($self,$val)","documentation":"","parameters":[{"label":"$self"},{"label":"$val"}]},"line":728,"kind":12,"range":{"end":{"line":731,"character":9999},"start":{"line":728,"character":0}}}],"version":5}