{"vars":[{"line":82,"name":"vars","kind":2,"containerName":""},{"line":89,"name":"base","kind":2,"containerName":""},{"children":[{"definition":"my","line":93,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":93},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$self","line":94},{"line":94,"containerName":"new","kind":13,"name":"$class"},{"name":"@args","kind":13,"containerName":"new","line":94},{"line":96,"containerName":"new","localvar":"my","kind":13,"name":"$pseq","definition":"my"},{"kind":13,"containerName":"new","name":"$self","line":96},{"name":"_rearrange","kind":12,"containerName":"new","line":96},{"line":96,"name":"@args","containerName":"new","kind":13},{"line":98,"kind":13,"containerName":"new","name":"$pseq"},{"containerName":"new","kind":13,"name":"$pseq","line":99},{"line":99,"name":"new","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"@args","line":99},{"line":101,"kind":13,"containerName":"new","name":"$self"},{"line":101,"name":"primary_seq","kind":12,"containerName":"new"},{"line":101,"name":"$pseq","kind":13,"containerName":"new"},{"line":103,"name":"$self","containerName":"new","kind":13}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":92,"kind":12,"range":{"end":{"line":104,"character":9999},"start":{"line":92,"character":0}},"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"}},{"line":94,"kind":12,"containerName":"new","name":"SUPER"},{"containerName":"Seq::LargePrimarySeq","kind":12,"name":"Bio","line":99},{"children":[{"definition":"my","line":120,"name":"$self","kind":13,"localvar":"my","containerName":"trunc"},{"line":120,"containerName":"trunc","kind":13,"name":"$s"},{"containerName":"trunc","kind":13,"name":"$e","line":120},{"kind":13,"containerName":"trunc","name":"$self","line":122},{"line":122,"containerName":"trunc","kind":12,"name":"display_id"},{"line":123,"name":"$self","kind":13,"containerName":"trunc"},{"line":123,"name":"accession_number","kind":12,"containerName":"trunc"},{"kind":13,"containerName":"trunc","name":"$self","line":124},{"line":124,"name":"desc","kind":12,"containerName":"trunc"},{"line":125,"kind":13,"containerName":"trunc","name":"$self"},{"name":"alphabet","containerName":"trunc","kind":12,"line":125},{"containerName":"trunc","kind":13,"name":"$self","line":126},{"line":126,"name":"primary_seq","kind":12,"containerName":"trunc"},{"kind":12,"containerName":"trunc","name":"trunc","line":126},{"line":126,"kind":13,"containerName":"trunc","name":"$s"},{"kind":13,"containerName":"trunc","name":"$e","line":126}],"name":"trunc","containerName":"main::","definition":"sub","detail":"($self,$s,$e)","line":119,"range":{"end":{"line":127,"character":9999},"start":{"character":0,"line":119}},"kind":12,"signature":{"label":"trunc($self,$s,$e)","parameters":[{"label":"$self"},{"label":"$s"},{"label":"$e"}],"documentation":"1;\n# $Id: LargeSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargeSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney, Jason Stajich\n#\n# Copyright Ewan Birney, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeSeq - SeqI compliant object that stores sequence as\nfiles in /tmp\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargeSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n# Object preamble\n\nuse Bio::Seq::LargePrimarySeq;\n\nuse base qw(Bio::Seq Bio::Seq::LargeSeqI);\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($pseq) = $self->_rearrange([qw(PRIMARYSEQ)], @args);\n\n    if( ! defined $pseq ) {\n\t$pseq = Bio::Seq::LargePrimarySeq->new(@args);\n    }\n    $self->primary_seq($pseq);\n\n    return $self;\n}\n\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::SeqI object\n Args    :"}},{"line":122,"name":"Bio","kind":12,"containerName":"Seq::LargeSeq"},{"range":{"start":{"character":0,"line":145},"end":{"character":9999,"line":148}},"kind":12,"line":145,"signature":{"parameters":[{"label":"$self"},{"label":"$str"}],"documentation":"1;\n# $Id: LargeSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargeSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney, Jason Stajich\n#\n# Copyright Ewan Birney, Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeSeq - SeqI compliant object that stores sequence as\nfiles in /tmp\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n\n=head1 DESCRIPTION\n\nThis object stores a sequence as a series of files in a temporary\ndirectory. The aim is to allow someone the ability to store very large\nsequences (eg, E<gt> 100MBases) in a file system without running out\nof memory (eg, on a 64 MB real memory machine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably paste your\nmachine. However, calls $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargeSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n# Object preamble\n\nuse Bio::Seq::LargePrimarySeq;\n\nuse base qw(Bio::Seq Bio::Seq::LargeSeqI);\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($pseq) = $self->_rearrange([qw(PRIMARYSEQ)], @args);\n\n    if( ! defined $pseq ) {\n\t$pseq = Bio::Seq::LargePrimarySeq->new(@args);\n    }\n    $self->primary_seq($pseq);\n\n    return $self;\n}\n\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : a fresh Bio::SeqI object\n Args    :\n\n\nsub trunc {\n    my ($self, $s, $e) = @_;\n    return new Bio::Seq::LargeSeq\n        ('-display_id' => $self->display_id,\n         '-accession_number' => $self->accession_number,\n         '-desc' => $self->desc,\n         '-alphabet' => $self->alphabet,\n         -primaryseq => $self->primary_seq->trunc($s,$e));\n}\n\n=head2 Bio::Seq::LargePrimarySeq methods\n\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargePrimarySeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append","label":"add_sequence_as_string($self,$str)"},"name":"add_sequence_as_string","containerName":"main::","children":[{"line":146,"name":"$self","containerName":"add_sequence_as_string","localvar":"my","kind":13,"definition":"my"},{"line":146,"name":"$str","containerName":"add_sequence_as_string","kind":13},{"containerName":"add_sequence_as_string","kind":13,"name":"$self","line":147},{"line":147,"containerName":"add_sequence_as_string","kind":12,"name":"primary_seq"},{"line":147,"containerName":"add_sequence_as_string","kind":12,"name":"add_sequence_as_string"},{"line":147,"name":"$str","containerName":"add_sequence_as_string","kind":13}],"detail":"($self,$str)","definition":"sub"}],"version":5}