{"vars":[{"line":158,"containerName":"","kind":2,"name":"base"},{"kind":12,"range":{"start":{"character":0,"line":225},"end":{"line":237,"character":9999}},"line":225,"signature":{"label":"new($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EncodedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::EncodedSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::EncodedSeq - subtype of L<Bio::LocatableSeq|Bio::LocatableSeq> to store DNA that encodes a protein\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => $dna,\n                                  -encoding => \"CCCCCCCIIIIICCCCC\",\n                                  -start => 1,\n                                  -strand => 1,\n                                  -length => 17);\n\n  # splice out (and possibly revcomp) the coding sequence\n  $cds = obj->cds;\n\n  # obtain the protein translation of the sequence\n  $prot = $obj->translate;\n\n  # other access/inspection routines as with Bio::LocatableSeq and\n  # Bio::SeqI; note that coordinates are relative only to the DNA\n  # sequence, not it's implicit encoded protein sequence.\n\n=head1 DESCRIPTION\n\nBio::Seq::EncodedSeq is a L<Bio::LocatableSeq|Bio::LocatableSeq>\nobject that holds a DNA sequence as well as information about the\ncoding potential of that DNA sequence.  It is meant to be useful in an\nalignment context, where the DNA may contain frameshifts, gaps and/or\nintrons, or in describing the transcript of a gene.  An EncodedSeq\nprovides the ability to access the \"spliced\" coding sequence, meaning\nthat all introns and gaps are removed, and any frameshifts are\nadjusted to provide a \"clean\" CDS.\n\nIn order to make simultaneous use of either the DNA or the implicit\nencoded protein sequence coordinates, please see\nL<Bio::Coordinate::EncodingPair>.\n\n=head1 ENCODING\n\nWe use the term \"encoding\" here to refer to the series of symbols that\nwe use to identify which residues of a DNA sequence are protein-coding\n(i.e. part of a codon), intronic, part of a 5' or 3', frameshift\n\"mutations\", etc.  From this information, a Bio::Seq::EncodedSeq is\nable to \"figure out\" its translational CDS.  There are two sets of\ncoding characters, one termed \"implicit\" and one termed \"explicit\".\n\nThe \"implicit\" encoding is a bit simpler than the \"explicit\" encoding:\n'C' is used for any nucleotide that's part of a codon, 'U' for any\nUTR, etc.  The full list is shown below:\n\n Code  Meaning\n ----  -------\n  C    coding\n  I    intronic\n  U    untranslated\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nThe \"explicit\" encoding is just an expansion of the \"implicit\"\nencoding, to denote phase:\n\n Code  Meaning\n ----  -------\n  C    coding, 1st codon position\n  D    coding, 2nd codon position\n  E    coding, 3rd codon position\n\n  I    intronic, phase 0 (relative to intron begin)\n  J    intronic, phase 1\n  K    intronic, phase 2\n\n  U    untranslated 3'UTR\n  V    untranslated 5'UTR\n\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nNote that the explicit coding is meant to provide easy access to\nposition/phase specific nucleotides:\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => \"ACAATCAGACTACG...\",\n                                   -encoding => \"CCCCCCIII...\"\n                                  );\n\n  # fetch arrays of nucleotides at each codon position:\n  my @pos1 = $obj->dnaseq(encoding => 'C', explicit => 1);\n  my @pos2 = $obj->dnaseq(encoding => 'D');\n  my @pos3 = $obj->dnaseq(encoding => 'E');\n\n  # fetch arrays of \"3-1\" codon dinucleotides, useful for genomic\n  # signature analyses without compounding influences of codon bias:\n  my @pairs = $obj->dnaseq(encoding => 'EC');\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::EncodedSeq;\n\nuse strict;\n\n\nuse base qw(Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Seq::EncodedSeq->new(-seq      => \"AGTACGTGTCATG\",\n                                            -encoding => \"CCCCCCFCCCCCC\",\n                                            -id       => \"myseq\",\n                                            -start    => 1,\n                                            -end      => 13,\n                                            -strand   => 1\n                                      );\n Function: creates a new Bio::Seq::EncodedSeq object from a supplied DNA\n           sequence\n Returns : a new Bio::Seq::EncodedSeq object\n\n Args    : seq      - primary nucleotide sequence used to encode the\n                      protein; note that any positions involved in a\n                      gap ('G') or backward frameshift ('B') should\n                      have one or more gap characters; if the encoding\n                      specifies G or B, but no (or not enough) gap\n                      characters exist, *they'll be added*; similary,\n                      if there are gap characters without a\n                      corresponding G or B encoding, G's will be\n                      inserted into the encoding.  This allows some\n                      flexibility in specifying your sequence and\n                      coding without having to calculate a lot of the\n                      encoding for yourself.\n\n           encoding - a string of characters (see Encoding Table)\n                      describing backwards frameshifts implied by the\n                      encoding but not present in the sequence will be\n                      added (as '-'s) to the sequence.  If not\n                      supplied, it will be assumed that all positions\n                      are coding (C).  Encoding may include either\n                      implicit phase encoding characters (i.e. \"CCC\")\n                      and/or explicit encoding characters (i.e. \"CDE\").\n                      Additionally, prefixed numbers may be used to\n                      denote repetition (i.e. \"27C3I28C\").\n\n                      Alternatively, encoding may be a hashref\n                      datastructure, with encoding characters as keys\n                      and Bio::LocationI objects (or arrayrefs of\n                      Bio::LocationI objects) as values, e.g.:\n\n                      { C => [ Bio::Location::Simple->new(1,9),\n                               Bio::Location::Simple->new(11,13) ],\n                        F => Bio::Location::Simple->new(10,10),\n                      } # same as \"CCCCCCCCCFCCC\"\n\n                      Note that if the location ranges overlap, the\n                      behavior of the encoding will be undefined\n                      (well, it will be defined, but only according to\n                      the order in which the hash keys are read, which\n                      is basically undefined ... just don't do that).\n\n           id, start, end, strand - as with Bio::LocatableSeq; note\n                      that the coordinates are relative to the\n                      encoding DNA sequence, not the implicit protein\n                      sequence.  If strand is reversed, then the\n                      encoding is assumed to be relative to the\n                      reverse strand as well.\n\n'"},"name":"new","containerName":"main::","children":[{"definition":"my","line":227,"name":"$self","localvar":"my","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@args","line":227},{"containerName":"new","kind":13,"name":"$self","line":228},{"line":228,"name":"$self","containerName":"new","kind":13},{"name":"@args","kind":13,"containerName":"new","line":228},{"definition":"my","name":"$enc","containerName":"new","localvar":"my","kind":13,"line":229},{"line":229,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"_rearrange","line":229},{"name":"@args","containerName":"new","kind":13,"line":229},{"line":231,"name":"$enc","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":232},{"line":232,"containerName":"new","kind":12,"name":"encoding"},{"name":"$enc","containerName":"new","kind":13,"line":232},{"containerName":"new","kind":13,"name":"$self","line":234},{"kind":12,"containerName":"new","name":"_recheck_encoding","line":234},{"line":236,"containerName":"new","kind":13,"name":"$self"}],"detail":"($self,@args)","definition":"sub"},{"name":"SUPER","kind":12,"containerName":"new","line":228},{"signature":{"label":"encoding($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EncodedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::EncodedSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::EncodedSeq - subtype of L<Bio::LocatableSeq|Bio::LocatableSeq> to store DNA that encodes a protein\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => $dna,\n                                  -encoding => \"CCCCCCCIIIIICCCCC\",\n                                  -start => 1,\n                                  -strand => 1,\n                                  -length => 17);\n\n  # splice out (and possibly revcomp) the coding sequence\n  $cds = obj->cds;\n\n  # obtain the protein translation of the sequence\n  $prot = $obj->translate;\n\n  # other access/inspection routines as with Bio::LocatableSeq and\n  # Bio::SeqI; note that coordinates are relative only to the DNA\n  # sequence, not it's implicit encoded protein sequence.\n\n=head1 DESCRIPTION\n\nBio::Seq::EncodedSeq is a L<Bio::LocatableSeq|Bio::LocatableSeq>\nobject that holds a DNA sequence as well as information about the\ncoding potential of that DNA sequence.  It is meant to be useful in an\nalignment context, where the DNA may contain frameshifts, gaps and/or\nintrons, or in describing the transcript of a gene.  An EncodedSeq\nprovides the ability to access the \"spliced\" coding sequence, meaning\nthat all introns and gaps are removed, and any frameshifts are\nadjusted to provide a \"clean\" CDS.\n\nIn order to make simultaneous use of either the DNA or the implicit\nencoded protein sequence coordinates, please see\nL<Bio::Coordinate::EncodingPair>.\n\n=head1 ENCODING\n\nWe use the term \"encoding\" here to refer to the series of symbols that\nwe use to identify which residues of a DNA sequence are protein-coding\n(i.e. part of a codon), intronic, part of a 5' or 3', frameshift\n\"mutations\", etc.  From this information, a Bio::Seq::EncodedSeq is\nable to \"figure out\" its translational CDS.  There are two sets of\ncoding characters, one termed \"implicit\" and one termed \"explicit\".\n\nThe \"implicit\" encoding is a bit simpler than the \"explicit\" encoding:\n'C' is used for any nucleotide that's part of a codon, 'U' for any\nUTR, etc.  The full list is shown below:\n\n Code  Meaning\n ----  -------\n  C    coding\n  I    intronic\n  U    untranslated\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nThe \"explicit\" encoding is just an expansion of the \"implicit\"\nencoding, to denote phase:\n\n Code  Meaning\n ----  -------\n  C    coding, 1st codon position\n  D    coding, 2nd codon position\n  E    coding, 3rd codon position\n\n  I    intronic, phase 0 (relative to intron begin)\n  J    intronic, phase 1\n  K    intronic, phase 2\n\n  U    untranslated 3'UTR\n  V    untranslated 5'UTR\n\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nNote that the explicit coding is meant to provide easy access to\nposition/phase specific nucleotides:\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => \"ACAATCAGACTACG...\",\n                                   -encoding => \"CCCCCCIII...\"\n                                  );\n\n  # fetch arrays of nucleotides at each codon position:\n  my @pos1 = $obj->dnaseq(encoding => 'C', explicit => 1);\n  my @pos2 = $obj->dnaseq(encoding => 'D');\n  my @pos3 = $obj->dnaseq(encoding => 'E');\n\n  # fetch arrays of \"3-1\" codon dinucleotides, useful for genomic\n  # signature analyses without compounding influences of codon bias:\n  my @pairs = $obj->dnaseq(encoding => 'EC');\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::EncodedSeq;\n\nuse strict;\n\n\nuse base qw(Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Seq::EncodedSeq->new(-seq      => \"AGTACGTGTCATG\",\n                                            -encoding => \"CCCCCCFCCCCCC\",\n                                            -id       => \"myseq\",\n                                            -start    => 1,\n                                            -end      => 13,\n                                            -strand   => 1\n                                      );\n Function: creates a new Bio::Seq::EncodedSeq object from a supplied DNA\n           sequence\n Returns : a new Bio::Seq::EncodedSeq object\n\n Args    : seq      - primary nucleotide sequence used to encode the\n                      protein; note that any positions involved in a\n                      gap ('G') or backward frameshift ('B') should\n                      have one or more gap characters; if the encoding\n                      specifies G or B, but no (or not enough) gap\n                      characters exist, *they'll be added*; similary,\n                      if there are gap characters without a\n                      corresponding G or B encoding, G's will be\n                      inserted into the encoding.  This allows some\n                      flexibility in specifying your sequence and\n                      coding without having to calculate a lot of the\n                      encoding for yourself.\n\n           encoding - a string of characters (see Encoding Table)\n                      describing backwards frameshifts implied by the\n                      encoding but not present in the sequence will be\n                      added (as '-'s) to the sequence.  If not\n                      supplied, it will be assumed that all positions\n                      are coding (C).  Encoding may include either\n                      implicit phase encoding characters (i.e. \"CCC\")\n                      and/or explicit encoding characters (i.e. \"CDE\").\n                      Additionally, prefixed numbers may be used to\n                      denote repetition (i.e. \"27C3I28C\").\n\n                      Alternatively, encoding may be a hashref\n                      datastructure, with encoding characters as keys\n                      and Bio::LocationI objects (or arrayrefs of\n                      Bio::LocationI objects) as values, e.g.:\n\n                      { C => [ Bio::Location::Simple->new(1,9),\n                               Bio::Location::Simple->new(11,13) ],\n                        F => Bio::Location::Simple->new(10,10),\n                      } # same as \"CCCCCCCCCFCCC\"\n\n                      Note that if the location ranges overlap, the\n                      behavior of the encoding will be undefined\n                      (well, it will be defined, but only according to\n                      the order in which the hash keys are read, which\n                      is basically undefined ... just don't do that).\n\n           id, start, end, strand - as with Bio::LocatableSeq; note\n                      that the coordinates are relative to the\n                      encoding DNA sequence, not the implicit protein\n                      sequence.  If strand is reversed, then the\n                      encoding is assumed to be relative to the\n                      reverse strand as well.\n\n\n#'\n\nsub new {\n\n    my ($self, @args) = @_;\n    $self = $self->SUPER::new(@args, -alphabet => 'dna');\n    my ($enc) = $self->_rearrange([qw(ENCODING)], @args);\n    # set the real encoding:\n    if ($enc) {\n\t$self->encoding($enc);\n    } else {\n\t$self->_recheck_encoding;\n    }\n    return $self;\n}\n\n=head2 encoding\n\n Title   : encoding\n Usage   : $obj->encoding(\"CCCCCC\");\n           $obj->encoding( -encoding => { I => $location } );\n           $enc = $obj->encoding(-explicit => 1);\n           $enc = $obj->encoding(\"CCCCCC\", -explicit => 1);\n           $enc = $obj->encoding(-location => $location,\n                                 -explicit => 1,\n                                 -absolute => 1 );\n Function: get/set the objects encoding, either globally or by location(s).\n Returns : the (possibly new) encoding string.\n Args    : encoding - see the encoding argument to the new() function.\n\n           explicit - whether or not to return explicit phase\n                      information in the coding (i.e. \"CCC\" becomes\n                      \"CDE\", \"III\" becomes \"IJK\", etc); defaults to 0.\n\n           location - optional; location to get/set the encoding.\n                      Defaults to the entire sequence.\n\n           absolute - whether or not the locational elements (either\n                      in the encoding hashref or the location\n                      argument) are relative to the absolute start/end\n                      of the Bio::LocatableSeq, or to the internal,\n                      relative coordinate system (beginning at 1);\n                      defaults to 0 (i.e. relative)"},"kind":12,"range":{"end":{"character":9999,"line":381},"start":{"line":269,"character":0}},"line":269,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"encoding","children":[{"containerName":"encoding","localvar":"my","kind":13,"name":"$self","line":271,"definition":"my"},{"name":"@args","kind":13,"containerName":"encoding","line":271},{"localvar":"my","containerName":"encoding","kind":13,"name":"$enc","line":272,"definition":"my"},{"line":272,"name":"$loc","kind":13,"containerName":"encoding"},{"line":272,"name":"$exp","kind":13,"containerName":"encoding"},{"line":272,"containerName":"encoding","kind":13,"name":"$abs"},{"containerName":"encoding","kind":13,"name":"$self","line":272},{"line":272,"containerName":"encoding","kind":12,"name":"_rearrange"},{"containerName":"encoding","kind":13,"name":"@args","line":272},{"name":"$enc","containerName":"encoding","kind":13,"line":274},{"line":276,"containerName":"encoding","kind":13,"name":"$enc"},{"kind":13,"containerName":"encoding","name":"$self","line":277},{"line":277,"containerName":"encoding","kind":12,"name":"throw"},{"line":280,"localvar":"my","kind":13,"containerName":"encoding","name":"$char","definition":"my"},{"line":280,"name":"$locs","kind":13,"containerName":"encoding"},{"line":280,"name":"$enc","kind":13,"containerName":"encoding"},{"name":"$locs","containerName":"encoding","kind":13,"line":281},{"name":"$locs","containerName":"encoding","kind":13,"line":282},{"line":284,"kind":13,"containerName":"encoding","name":"$self"},{"line":284,"name":"throw","containerName":"encoding","kind":12},{"line":287,"kind":13,"containerName":"encoding","name":"$enc"},{"line":288,"name":"$enc","kind":13,"containerName":"encoding"},{"line":288,"name":"$enc","kind":13,"containerName":"encoding"},{"name":"$exp","containerName":"encoding","kind":13,"line":289},{"name":"$exp","kind":13,"containerName":"encoding","line":289},{"name":"$enc","containerName":"encoding","kind":13,"line":289},{"containerName":"encoding","kind":13,"name":"$enc","line":291},{"definition":"my","name":"$numenc","containerName":"encoding","localvar":"my","kind":13,"line":292},{"name":"$enc","kind":13,"containerName":"encoding","line":292},{"name":"$enc","containerName":"encoding","kind":13,"line":293},{"line":294,"containerName":"encoding","kind":13,"name":"$numenc"},{"kind":13,"localvar":"my","containerName":"encoding","name":"$num","line":295,"definition":"my"},{"name":"$char","kind":13,"containerName":"encoding","line":295},{"name":"$num","containerName":"encoding","kind":13,"line":296},{"line":296,"kind":13,"containerName":"encoding","name":"$num"},{"line":297,"containerName":"encoding","kind":13,"name":"$enc"},{"containerName":"encoding","kind":13,"name":"$char","line":297},{"line":297,"name":"$num","kind":13,"containerName":"encoding"},{"line":301,"kind":13,"containerName":"encoding","name":"$exp"},{"line":301,"name":"$exp","containerName":"encoding","kind":13},{"kind":13,"containerName":"encoding","name":"$enc","line":301},{"line":302,"name":"$self","containerName":"encoding","kind":13},{"line":302,"containerName":"encoding","kind":12,"name":"throw"},{"line":303,"name":"$enc","containerName":"encoding","kind":13},{"containerName":"encoding","kind":13,"name":"$self","line":304},{"line":304,"containerName":"encoding","kind":12,"name":"throw"},{"name":"$loc","containerName":"encoding","kind":13,"line":307},{"definition":"my","kind":13,"localvar":"my","containerName":"encoding","name":"$ct","line":310},{"line":310,"kind":13,"containerName":"encoding","name":"$enc"},{"line":311,"kind":13,"containerName":"encoding","name":"$ct"},{"name":"$enc","kind":13,"containerName":"encoding","line":311},{"name":"$ct","containerName":"encoding","kind":13,"line":311},{"name":"$self","containerName":"encoding","kind":13,"line":312},{"name":"throw","kind":12,"containerName":"encoding","line":312},{"line":313,"containerName":"encoding","kind":13,"name":"$loc"},{"line":313,"kind":12,"containerName":"encoding","name":"location_type"},{"containerName":"encoding","kind":13,"name":"$loc","line":313},{"line":313,"name":"length","containerName":"encoding","kind":12},{"name":"$ct","containerName":"encoding","kind":13,"line":313},{"definition":"my","line":315,"name":"$start","localvar":"my","containerName":"encoding","kind":13},{"line":315,"name":"$loc","containerName":"encoding","kind":13},{"line":315,"kind":12,"containerName":"encoding","name":"start"},{"definition":"my","line":316,"localvar":"my","kind":13,"containerName":"encoding","name":"$end"},{"containerName":"encoding","kind":13,"name":"$loc","line":316},{"containerName":"encoding","kind":12,"name":"end","line":316},{"line":319,"containerName":"encoding","kind":13,"name":"$start"},{"line":319,"containerName":"encoding","kind":13,"name":"$self"},{"name":"start","containerName":"encoding","kind":12,"line":319},{"definition":"my","name":"$diff","localvar":"my","kind":13,"containerName":"encoding","line":320},{"line":320,"name":"$self","kind":13,"containerName":"encoding"},{"name":"start","containerName":"encoding","kind":12,"line":320},{"kind":13,"containerName":"encoding","name":"$start","line":320},{"line":321,"kind":13,"containerName":"encoding","name":"$start"},{"name":"$self","containerName":"encoding","kind":13,"line":321},{"line":321,"kind":12,"containerName":"encoding","name":"start"},{"containerName":"encoding","kind":13,"name":"$enc","line":322},{"line":322,"kind":13,"containerName":"encoding","name":"$enc"},{"line":322,"containerName":"encoding","kind":13,"name":"$diff"},{"line":324,"kind":13,"containerName":"encoding","name":"$end"},{"kind":13,"containerName":"encoding","name":"$self","line":324},{"line":324,"kind":12,"containerName":"encoding","name":"end"},{"definition":"my","line":325,"containerName":"encoding","localvar":"my","kind":13,"name":"$diff"},{"line":325,"name":"$end","containerName":"encoding","kind":13},{"containerName":"encoding","kind":13,"name":"$self","line":325},{"line":325,"containerName":"encoding","kind":12,"name":"end"},{"line":326,"kind":13,"containerName":"encoding","name":"$end"},{"line":326,"kind":13,"containerName":"encoding","name":"$self"},{"line":326,"containerName":"encoding","kind":12,"name":"end"},{"line":327,"name":"$enc","containerName":"encoding","kind":13},{"line":327,"kind":13,"containerName":"encoding","name":"$enc"},{"name":"$diff","kind":13,"containerName":"encoding","line":327},{"name":"$currenc","localvar":"my","kind":13,"containerName":"encoding","line":330,"definition":"my"},{"name":"$self","kind":13,"containerName":"encoding","line":330},{"localvar":"my","containerName":"encoding","kind":13,"name":"$currseq","line":331,"definition":"my"},{"kind":13,"containerName":"encoding","name":"$self","line":331},{"line":331,"name":"seq","kind":12,"containerName":"encoding"},{"definition":"my","containerName":"encoding","localvar":"my","kind":13,"name":"$spanstart","line":333},{"line":333,"name":"$spanend","containerName":"encoding","kind":13},{"name":"$self","containerName":"encoding","kind":13,"line":333},{"name":"column_from_residue_number","containerName":"encoding","kind":12,"line":333},{"line":333,"name":"$start","containerName":"encoding","kind":13},{"line":334,"name":"$self","containerName":"encoding","kind":13},{"line":334,"name":"column_from_residue_number","containerName":"encoding","kind":12},{"line":334,"name":"$end","kind":13,"containerName":"encoding"},{"line":336,"name":"$currseq","kind":13,"containerName":"encoding"},{"line":338,"name":"$spanstart","kind":13,"containerName":"encoding"},{"kind":13,"containerName":"encoding","name":"$spanend","line":338},{"line":338,"kind":13,"containerName":"encoding","name":"$spanend"},{"name":"$spanstart","containerName":"encoding","kind":13,"line":338},{"line":338,"name":"$self","containerName":"encoding","kind":13},{"name":"strand","kind":12,"containerName":"encoding","line":338},{"line":339,"containerName":"encoding","localvar":"my","kind":13,"name":"$before","definition":"my"},{"containerName":"encoding","kind":13,"name":"$in","line":339},{"name":"$after","containerName":"encoding","kind":13,"line":339},{"containerName":"encoding","kind":13,"name":"$currseq","line":339},{"line":343,"containerName":"encoding","kind":13,"name":"$in"},{"name":"$in","containerName":"encoding","kind":13,"line":344},{"line":345,"containerName":"encoding","kind":13,"name":"$currseq"},{"name":"$before","kind":13,"containerName":"encoding","line":345},{"line":345,"name":"$in","kind":13,"containerName":"encoding"},{"line":345,"name":"$after","containerName":"encoding","kind":13},{"line":347,"name":"$self","containerName":"encoding","kind":13},{"line":347,"name":"seq","containerName":"encoding","kind":12},{"line":347,"name":"$currseq","containerName":"encoding","kind":13},{"line":347,"containerName":"encoding","kind":13,"name":"$self"},{"containerName":"encoding","kind":12,"name":"alphabet","line":347},{"line":350,"kind":13,"containerName":"encoding","name":"$currenc"},{"line":350,"containerName":"encoding","kind":13,"name":"$currenc"},{"line":350,"name":"$self","kind":13,"containerName":"encoding"},{"name":"strand","containerName":"encoding","kind":12,"line":350},{"kind":13,"containerName":"encoding","name":"$currenc","line":351},{"name":"$spanstart","kind":13,"containerName":"encoding","line":351},{"line":351,"name":"$spanend","containerName":"encoding","kind":13},{"line":351,"kind":13,"containerName":"encoding","name":"$spanstart"},{"containerName":"encoding","kind":13,"name":"$loc","line":351},{"name":"location_type","kind":12,"containerName":"encoding","line":351},{"line":352,"name":"$self","containerName":"encoding","kind":13},{"kind":12,"containerName":"encoding","name":"strand","line":352},{"kind":13,"containerName":"encoding","name":"$enc","line":352},{"line":352,"name":"$enc","kind":13,"containerName":"encoding"},{"containerName":"encoding","kind":13,"name":"$currenc","line":353},{"line":353,"kind":13,"containerName":"encoding","name":"$currenc"},{"containerName":"encoding","kind":13,"name":"$self","line":353},{"name":"strand","containerName":"encoding","kind":12,"line":353},{"containerName":"encoding","kind":13,"name":"$self","line":355},{"line":355,"name":"$currenc","kind":13,"containerName":"encoding"},{"kind":13,"containerName":"encoding","name":"$self","line":356},{"line":356,"name":"_recheck_encoding","containerName":"encoding","kind":12},{"name":"$currenc","containerName":"encoding","kind":13,"line":358},{"line":358,"kind":13,"containerName":"encoding","name":"$self"},{"kind":13,"containerName":"encoding","name":"$currenc","line":359},{"line":359,"name":"$currenc","kind":13,"containerName":"encoding"},{"line":359,"name":"$self","containerName":"encoding","kind":13},{"name":"strand","kind":12,"containerName":"encoding","line":359},{"containerName":"encoding","kind":13,"name":"$enc","line":360},{"line":360,"containerName":"encoding","kind":13,"name":"$currenc"},{"name":"$spanstart","kind":13,"containerName":"encoding","line":360},{"line":360,"kind":13,"containerName":"encoding","name":"$enc"},{"line":361,"name":"$enc","containerName":"encoding","kind":13},{"name":"$enc","kind":13,"containerName":"encoding","line":361},{"line":361,"containerName":"encoding","kind":13,"name":"$self"},{"containerName":"encoding","kind":12,"name":"strand","line":361},{"line":363,"containerName":"encoding","kind":13,"name":"$exp"},{"name":"$enc","containerName":"encoding","kind":13,"line":363},{"name":"$self","containerName":"encoding","kind":13,"line":363},{"name":"_convert2implicit","containerName":"encoding","kind":12,"line":363},{"kind":13,"containerName":"encoding","name":"$enc","line":363},{"definition":"my","line":369,"name":"$dna","kind":13,"localvar":"my","containerName":"encoding"},{"line":369,"name":"$self","kind":13,"containerName":"encoding"},{"line":369,"name":"seq","kind":12,"containerName":"encoding"},{"line":370,"containerName":"encoding","kind":13,"name":"$dna"},{"name":"$self","containerName":"encoding","kind":13,"line":371},{"line":371,"kind":12,"containerName":"encoding","name":"seq"},{"line":371,"containerName":"encoding","kind":13,"name":"$dna"},{"kind":13,"containerName":"encoding","name":"$self","line":372},{"line":372,"name":"$enc","containerName":"encoding","kind":13},{"line":375,"name":"$self","containerName":"encoding","kind":13},{"name":"throw","containerName":"encoding","kind":12,"line":375},{"containerName":"encoding","kind":13,"name":"$self","line":378},{"line":378,"containerName":"encoding","kind":12,"name":"_recheck_encoding"},{"containerName":"encoding","kind":13,"name":"$exp","line":380},{"line":380,"kind":13,"containerName":"encoding","name":"$self"},{"line":380,"kind":13,"containerName":"encoding","name":"$self"},{"line":380,"containerName":"encoding","kind":12,"name":"_convert2implicit"},{"containerName":"encoding","kind":13,"name":"$self","line":380}]},{"line":282,"kind":12,"containerName":"isa","name":"UNIVERSAL"},{"name":"_encoding","kind":12,"line":330},{"line":355,"kind":12,"name":"_encoding"},{"name":"_encoding","kind":12,"line":358},{"name":"_encoding","kind":12,"line":372},{"line":380,"name":"_encoding","kind":12},{"line":380,"kind":12,"name":"_encoding"},{"children":[{"line":385,"name":"$self","localvar":"my","containerName":"_convert2implicit","kind":13,"definition":"my"},{"kind":13,"containerName":"_convert2implicit","name":"$enc","line":385},{"line":387,"kind":13,"containerName":"_convert2implicit","name":"$enc"},{"line":388,"name":"$enc","containerName":"_convert2implicit","kind":13},{"kind":13,"containerName":"_convert2implicit","name":"$enc","line":389},{"containerName":"_convert2implicit","kind":13,"name":"$enc","line":391}],"containerName":"main::","name":"_convert2implicit","definition":"sub","detail":"($self,$enc)","line":383,"kind":12,"range":{"end":{"character":9999,"line":392},"start":{"line":383,"character":0}},"signature":{"label":"_convert2implicit($self,$enc)","documentation":"","parameters":[{"label":"$self"},{"label":"$enc"}]}},{"kind":12,"range":{"start":{"character":0,"line":394},"end":{"line":469,"character":9999}},"line":394,"name":"_recheck_encoding","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_recheck_encoding","line":396,"definition":"my"},{"line":398,"name":"@enc","localvar":"my","kind":13,"containerName":"_recheck_encoding","definition":"my"},{"kind":13,"containerName":"_recheck_encoding","name":"$self","line":398},{"definition":"my","line":400,"name":"@nt","localvar":"my","containerName":"_recheck_encoding","kind":13},{"containerName":"_recheck_encoding","kind":13,"name":"$self","line":400},{"name":"@nt","kind":13,"containerName":"_recheck_encoding","line":401},{"line":401,"containerName":"_recheck_encoding","kind":13,"name":"@nt"},{"line":401,"name":"$self","containerName":"_recheck_encoding","kind":13},{"name":"strand","kind":12,"containerName":"_recheck_encoding","line":401},{"name":"$self","kind":13,"containerName":"_recheck_encoding","line":401},{"name":"strand","kind":12,"containerName":"_recheck_encoding","line":401},{"line":404,"name":"@enc","containerName":"_recheck_encoding","kind":13},{"line":405,"name":"@nt","kind":13,"containerName":"_recheck_encoding"},{"line":405,"containerName":"_recheck_encoding","kind":13,"name":"@enc"},{"line":409,"name":"$i","containerName":"_recheck_encoding","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_recheck_encoding","name":"$i","line":410},{"name":"$i","containerName":"_recheck_encoding","kind":13,"line":410},{"name":"@nt","kind":13,"containerName":"_recheck_encoding","line":410},{"line":410,"containerName":"_recheck_encoding","kind":13,"name":"$i"},{"line":410,"kind":13,"containerName":"_recheck_encoding","name":"@enc"},{"line":410,"name":"$i","containerName":"_recheck_encoding","kind":13},{"name":"$nt","containerName":"_recheck_encoding","kind":13,"line":411},{"line":411,"name":"$i","kind":13,"containerName":"_recheck_encoding"},{"name":"$enc","kind":13,"containerName":"_recheck_encoding","line":411},{"line":411,"name":"$i","kind":13,"containerName":"_recheck_encoding"},{"line":412,"containerName":"_recheck_encoding","kind":13,"name":"@enc"},{"line":412,"kind":13,"containerName":"_recheck_encoding","name":"$i"},{"containerName":"_recheck_encoding","kind":13,"name":"$nt","line":413},{"kind":13,"containerName":"_recheck_encoding","name":"$i","line":413},{"containerName":"_recheck_encoding","kind":13,"name":"$enc","line":413},{"name":"$i","kind":13,"containerName":"_recheck_encoding","line":413},{"line":414,"kind":13,"containerName":"_recheck_encoding","name":"@nt"},{"line":414,"containerName":"_recheck_encoding","kind":13,"name":"$i"},{"name":"$i","kind":13,"containerName":"_recheck_encoding","line":417},{"name":"@enc","containerName":"_recheck_encoding","kind":13,"line":417},{"line":419,"name":"$i","kind":13,"containerName":"_recheck_encoding"},{"line":419,"kind":13,"containerName":"_recheck_encoding","name":"@enc"},{"containerName":"_recheck_encoding","kind":13,"name":"$i","line":419},{"containerName":"_recheck_encoding","kind":13,"name":"$enc","line":420},{"name":"$i","kind":13,"containerName":"_recheck_encoding","line":420},{"name":"@nt","kind":13,"containerName":"_recheck_encoding","line":421},{"line":423,"kind":13,"containerName":"_recheck_encoding","name":"$self"},{"line":423,"containerName":"_recheck_encoding","kind":12,"name":"throw"},{"line":423,"name":"@enc","kind":13,"containerName":"_recheck_encoding"},{"name":"$i","kind":13,"containerName":"_recheck_encoding","line":423},{"line":426,"containerName":"_recheck_encoding","kind":13,"name":"$i"},{"line":426,"containerName":"_recheck_encoding","kind":13,"name":"@nt"},{"line":427,"name":"$i","kind":13,"containerName":"_recheck_encoding"},{"name":"@nt","containerName":"_recheck_encoding","kind":13,"line":427},{"line":427,"name":"$i","kind":13,"containerName":"_recheck_encoding"},{"containerName":"_recheck_encoding","kind":13,"name":"$nt","line":428},{"line":428,"name":"$i","containerName":"_recheck_encoding","kind":13},{"kind":13,"containerName":"_recheck_encoding","name":"@enc","line":429},{"name":"@enc","kind":13,"containerName":"_recheck_encoding","line":431},{"definition":"my","line":436,"containerName":"_recheck_encoding","localvar":"my","kind":13,"name":"@cde_array"},{"definition":"my","line":437,"containerName":"_recheck_encoding","localvar":"my","kind":13,"name":"@ijk_array"},{"line":439,"name":"$Cct","containerName":"_recheck_encoding","localvar":"my","kind":13,"definition":"my"},{"name":"$Ict","kind":13,"containerName":"_recheck_encoding","line":439},{"line":439,"kind":13,"containerName":"_recheck_encoding","name":"$Uct"},{"line":439,"containerName":"_recheck_encoding","kind":13,"name":"$Vct"},{"name":"$Vwarned","kind":13,"containerName":"_recheck_encoding","line":439},{"name":"$i","containerName":"_recheck_encoding","kind":13,"line":440},{"line":440,"containerName":"_recheck_encoding","kind":13,"name":"$i"},{"line":440,"containerName":"_recheck_encoding","kind":13,"name":"@enc"},{"line":440,"name":"$i","kind":13,"containerName":"_recheck_encoding"},{"name":"$enc","kind":13,"containerName":"_recheck_encoding","line":441},{"line":441,"name":"$i","containerName":"_recheck_encoding","kind":13},{"name":"$temp_index","containerName":"_recheck_encoding","localvar":"my","kind":13,"line":442,"definition":"my"},{"line":442,"name":"$Cct","kind":13,"containerName":"_recheck_encoding"},{"line":442,"kind":13,"containerName":"_recheck_encoding","name":"%3"},{"line":443,"name":"$enc","containerName":"_recheck_encoding","kind":13},{"name":"$i","kind":13,"containerName":"_recheck_encoding","line":443},{"name":"$cde_array","containerName":"_recheck_encoding","kind":13,"line":443},{"line":443,"name":"$temp_index","containerName":"_recheck_encoding","kind":13},{"line":444,"name":"$Cct","kind":13,"containerName":"_recheck_encoding"},{"line":444,"kind":13,"containerName":"_recheck_encoding","name":"$Ict"},{"name":"$Uct","containerName":"_recheck_encoding","kind":13,"line":444},{"name":"$self","kind":13,"containerName":"_recheck_encoding","line":445},{"containerName":"_recheck_encoding","kind":12,"name":"warn","line":445},{"line":446,"name":"$Vct","kind":13,"containerName":"_recheck_encoding"},{"line":446,"containerName":"_recheck_encoding","kind":13,"name":"$Vwarned"},{"name":"$enc","containerName":"_recheck_encoding","kind":13,"line":447},{"kind":13,"containerName":"_recheck_encoding","name":"$i","line":447},{"kind":13,"containerName":"_recheck_encoding","name":"$enc","line":448},{"line":448,"kind":13,"containerName":"_recheck_encoding","name":"$i"},{"containerName":"_recheck_encoding","kind":13,"name":"$ijk_array","line":448},{"kind":13,"containerName":"_recheck_encoding","name":"$Ict","line":448},{"line":449,"containerName":"_recheck_encoding","kind":13,"name":"$Ict"},{"line":449,"kind":13,"containerName":"_recheck_encoding","name":"$Uct"},{"containerName":"_recheck_encoding","kind":13,"name":"$self","line":450},{"name":"warn","kind":12,"containerName":"_recheck_encoding","line":450},{"name":"$Vct","kind":13,"containerName":"_recheck_encoding","line":451},{"line":451,"name":"$Vwarned","containerName":"_recheck_encoding","kind":13},{"line":452,"kind":13,"containerName":"_recheck_encoding","name":"$enc"},{"name":"$i","containerName":"_recheck_encoding","kind":13,"line":452},{"line":453,"name":"$Uct","kind":13,"containerName":"_recheck_encoding"},{"kind":13,"containerName":"_recheck_encoding","name":"$enc","line":454},{"name":"$i","containerName":"_recheck_encoding","kind":13,"line":454},{"name":"$Vct","containerName":"_recheck_encoding","kind":13,"line":455},{"line":457,"name":"$enc","kind":13,"containerName":"_recheck_encoding"},{"name":"$i","kind":13,"containerName":"_recheck_encoding","line":457},{"kind":13,"containerName":"_recheck_encoding","name":"$Cct","line":458},{"name":"$Ict","containerName":"_recheck_encoding","kind":13,"line":458},{"line":459,"name":"$enc","kind":13,"containerName":"_recheck_encoding"},{"name":"$i","kind":13,"containerName":"_recheck_encoding","line":459},{"line":464,"name":"@nt","containerName":"_recheck_encoding","kind":13},{"name":"@nt","containerName":"_recheck_encoding","kind":13,"line":464},{"line":464,"kind":13,"containerName":"_recheck_encoding","name":"$self"},{"line":464,"name":"strand","containerName":"_recheck_encoding","kind":12},{"kind":13,"containerName":"_recheck_encoding","name":"$self","line":464},{"containerName":"_recheck_encoding","kind":12,"name":"strand","line":464},{"line":466,"containerName":"_recheck_encoding","kind":13,"name":"$self"},{"line":466,"name":"@nt","kind":13,"containerName":"_recheck_encoding"},{"name":"$self","kind":13,"containerName":"_recheck_encoding","line":468},{"containerName":"_recheck_encoding","kind":13,"name":"@enc","line":468}],"definition":"sub"},{"kind":12,"name":"_encoding","line":398},{"name":"SUPER","kind":12,"containerName":"seq","line":400},{"name":"enc","kind":12,"line":423},{"line":468,"name":"_encoding","kind":12},{"children":[{"definition":"my","line":488,"kind":13,"localvar":"my","containerName":"cds","name":"$self"},{"containerName":"cds","kind":13,"name":"@args","line":488},{"kind":13,"localvar":"my","containerName":"cds","name":"$nogaps","line":490,"definition":"my"},{"line":490,"containerName":"cds","kind":13,"name":"$loc"},{"containerName":"cds","kind":13,"name":"$self","line":490},{"kind":12,"containerName":"cds","name":"_rearrange","line":490},{"name":"@args","kind":13,"containerName":"cds","line":490},{"line":491,"name":"$nogaps","kind":13,"containerName":"cds"},{"line":491,"containerName":"cds","kind":13,"name":"$nogaps"},{"line":493,"localvar":"my","kind":13,"containerName":"cds","name":"@nt","definition":"my"},{"containerName":"cds","kind":13,"name":"$self","line":493},{"line":493,"kind":12,"containerName":"cds","name":"strand"},{"line":493,"kind":13,"containerName":"cds","name":"$self"},{"containerName":"cds","kind":12,"name":"revcom","line":493},{"line":493,"kind":12,"containerName":"cds","name":"seq"},{"line":493,"containerName":"cds","kind":13,"name":"$self"},{"kind":12,"containerName":"cds","name":"seq","line":493},{"name":"@enc","localvar":"my","containerName":"cds","kind":13,"line":494,"definition":"my"},{"kind":13,"containerName":"cds","name":"$self","line":494},{"name":"_convert2implicit","kind":12,"containerName":"cds","line":494},{"line":494,"name":"$self","kind":13,"containerName":"cds"},{"definition":"my","name":"$start","kind":13,"localvar":"my","containerName":"cds","line":496},{"line":496,"kind":13,"containerName":"cds","name":"$end"},{"line":496,"kind":13,"containerName":"cds","name":"@nt"},{"containerName":"cds","kind":13,"name":"$loc","line":498},{"line":499,"kind":13,"containerName":"cds","name":"$start"},{"line":499,"kind":13,"containerName":"cds","name":"$loc"},{"kind":12,"containerName":"cds","name":"start","line":499},{"containerName":"cds","kind":13,"name":"$start","line":500},{"name":"$loc","containerName":"cds","kind":13,"line":500},{"name":"location_type","kind":12,"containerName":"cds","line":500},{"line":501,"name":"$start","kind":13,"containerName":"cds"},{"name":"$self","kind":13,"containerName":"cds","line":501},{"kind":12,"containerName":"cds","name":"column_from_residue_number","line":501},{"containerName":"cds","kind":13,"name":"$start","line":501},{"name":"$start","kind":13,"containerName":"cds","line":502},{"line":504,"name":"$end","containerName":"cds","kind":13},{"name":"$loc","kind":13,"containerName":"cds","line":504},{"line":504,"name":"end","containerName":"cds","kind":12},{"kind":13,"containerName":"cds","name":"$end","line":505},{"name":"$self","containerName":"cds","kind":13,"line":505},{"name":"column_from_residue_number","containerName":"cds","kind":12,"line":505},{"line":505,"name":"$end","kind":13,"containerName":"cds"},{"line":507,"name":"$start","kind":13,"containerName":"cds"},{"name":"$end","kind":13,"containerName":"cds","line":507},{"name":"$end","containerName":"cds","kind":13,"line":507},{"line":507,"name":"$start","containerName":"cds","kind":13},{"name":"$self","kind":13,"containerName":"cds","line":507},{"containerName":"cds","kind":12,"name":"strand","line":507},{"line":508,"kind":13,"containerName":"cds","name":"$start"},{"line":511,"localvar":"my","containerName":"cds","kind":13,"name":"$i","definition":"my"},{"line":511,"name":"$start","containerName":"cds","kind":13},{"line":511,"kind":13,"containerName":"cds","name":"$i"},{"line":511,"kind":13,"containerName":"cds","name":"$end"},{"line":511,"kind":13,"containerName":"cds","name":"$i"},{"containerName":"cds","kind":13,"name":"$enc","line":512},{"containerName":"cds","kind":13,"name":"$i","line":512},{"line":512,"name":"$enc","kind":13,"containerName":"cds"},{"kind":13,"containerName":"cds","name":"$i","line":512},{"containerName":"cds","kind":13,"name":"$enc","line":512},{"containerName":"cds","kind":13,"name":"$i","line":512},{"kind":13,"containerName":"cds","name":"$nt","line":514},{"kind":13,"containerName":"cds","name":"$i","line":514},{"containerName":"cds","kind":13,"name":"$enc","line":515},{"line":515,"containerName":"cds","kind":13,"name":"$i"},{"line":515,"kind":13,"containerName":"cds","name":"$enc"},{"line":515,"name":"$i","kind":13,"containerName":"cds"},{"line":517,"name":"$nt","kind":13,"containerName":"cds"},{"line":517,"containerName":"cds","kind":13,"name":"$i"},{"line":517,"name":"$nogaps","kind":13,"containerName":"cds"},{"containerName":"cds","kind":13,"name":"$self","line":521},{"containerName":"cds","kind":12,"name":"can_call_new","line":521},{"kind":13,"containerName":"cds","name":"$self","line":521},{"name":"new","kind":12,"containerName":"cds","line":522},{"name":"@nt","containerName":"cds","kind":13,"line":522},{"line":522,"name":"$start","kind":13,"containerName":"cds"},{"line":522,"containerName":"cds","kind":13,"name":"$end"},{"name":"$self","kind":13,"containerName":"cds","line":523},{"line":523,"name":"start","containerName":"cds","kind":12},{"line":524,"containerName":"cds","kind":13,"name":"$self"},{"line":524,"name":"end","kind":12,"containerName":"cds"}],"containerName":"main::","name":"cds","definition":"sub","detail":"($self,@args)","line":486,"kind":12,"range":{"end":{"line":526,"character":9999},"start":{"line":486,"character":0}},"signature":{"label":"cds($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EncodedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::EncodedSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::EncodedSeq - subtype of L<Bio::LocatableSeq|Bio::LocatableSeq> to store DNA that encodes a protein\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => $dna,\n                                  -encoding => \"CCCCCCCIIIIICCCCC\",\n                                  -start => 1,\n                                  -strand => 1,\n                                  -length => 17);\n\n  # splice out (and possibly revcomp) the coding sequence\n  $cds = obj->cds;\n\n  # obtain the protein translation of the sequence\n  $prot = $obj->translate;\n\n  # other access/inspection routines as with Bio::LocatableSeq and\n  # Bio::SeqI; note that coordinates are relative only to the DNA\n  # sequence, not it's implicit encoded protein sequence.\n\n=head1 DESCRIPTION\n\nBio::Seq::EncodedSeq is a L<Bio::LocatableSeq|Bio::LocatableSeq>\nobject that holds a DNA sequence as well as information about the\ncoding potential of that DNA sequence.  It is meant to be useful in an\nalignment context, where the DNA may contain frameshifts, gaps and/or\nintrons, or in describing the transcript of a gene.  An EncodedSeq\nprovides the ability to access the \"spliced\" coding sequence, meaning\nthat all introns and gaps are removed, and any frameshifts are\nadjusted to provide a \"clean\" CDS.\n\nIn order to make simultaneous use of either the DNA or the implicit\nencoded protein sequence coordinates, please see\nL<Bio::Coordinate::EncodingPair>.\n\n=head1 ENCODING\n\nWe use the term \"encoding\" here to refer to the series of symbols that\nwe use to identify which residues of a DNA sequence are protein-coding\n(i.e. part of a codon), intronic, part of a 5' or 3', frameshift\n\"mutations\", etc.  From this information, a Bio::Seq::EncodedSeq is\nable to \"figure out\" its translational CDS.  There are two sets of\ncoding characters, one termed \"implicit\" and one termed \"explicit\".\n\nThe \"implicit\" encoding is a bit simpler than the \"explicit\" encoding:\n'C' is used for any nucleotide that's part of a codon, 'U' for any\nUTR, etc.  The full list is shown below:\n\n Code  Meaning\n ----  -------\n  C    coding\n  I    intronic\n  U    untranslated\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nThe \"explicit\" encoding is just an expansion of the \"implicit\"\nencoding, to denote phase:\n\n Code  Meaning\n ----  -------\n  C    coding, 1st codon position\n  D    coding, 2nd codon position\n  E    coding, 3rd codon position\n\n  I    intronic, phase 0 (relative to intron begin)\n  J    intronic, phase 1\n  K    intronic, phase 2\n\n  U    untranslated 3'UTR\n  V    untranslated 5'UTR\n\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nNote that the explicit coding is meant to provide easy access to\nposition/phase specific nucleotides:\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => \"ACAATCAGACTACG...\",\n                                   -encoding => \"CCCCCCIII...\"\n                                  );\n\n  # fetch arrays of nucleotides at each codon position:\n  my @pos1 = $obj->dnaseq(encoding => 'C', explicit => 1);\n  my @pos2 = $obj->dnaseq(encoding => 'D');\n  my @pos3 = $obj->dnaseq(encoding => 'E');\n\n  # fetch arrays of \"3-1\" codon dinucleotides, useful for genomic\n  # signature analyses without compounding influences of codon bias:\n  my @pairs = $obj->dnaseq(encoding => 'EC');\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::EncodedSeq;\n\nuse strict;\n\n\nuse base qw(Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Seq::EncodedSeq->new(-seq      => \"AGTACGTGTCATG\",\n                                            -encoding => \"CCCCCCFCCCCCC\",\n                                            -id       => \"myseq\",\n                                            -start    => 1,\n                                            -end      => 13,\n                                            -strand   => 1\n                                      );\n Function: creates a new Bio::Seq::EncodedSeq object from a supplied DNA\n           sequence\n Returns : a new Bio::Seq::EncodedSeq object\n\n Args    : seq      - primary nucleotide sequence used to encode the\n                      protein; note that any positions involved in a\n                      gap ('G') or backward frameshift ('B') should\n                      have one or more gap characters; if the encoding\n                      specifies G or B, but no (or not enough) gap\n                      characters exist, *they'll be added*; similary,\n                      if there are gap characters without a\n                      corresponding G or B encoding, G's will be\n                      inserted into the encoding.  This allows some\n                      flexibility in specifying your sequence and\n                      coding without having to calculate a lot of the\n                      encoding for yourself.\n\n           encoding - a string of characters (see Encoding Table)\n                      describing backwards frameshifts implied by the\n                      encoding but not present in the sequence will be\n                      added (as '-'s) to the sequence.  If not\n                      supplied, it will be assumed that all positions\n                      are coding (C).  Encoding may include either\n                      implicit phase encoding characters (i.e. \"CCC\")\n                      and/or explicit encoding characters (i.e. \"CDE\").\n                      Additionally, prefixed numbers may be used to\n                      denote repetition (i.e. \"27C3I28C\").\n\n                      Alternatively, encoding may be a hashref\n                      datastructure, with encoding characters as keys\n                      and Bio::LocationI objects (or arrayrefs of\n                      Bio::LocationI objects) as values, e.g.:\n\n                      { C => [ Bio::Location::Simple->new(1,9),\n                               Bio::Location::Simple->new(11,13) ],\n                        F => Bio::Location::Simple->new(10,10),\n                      } # same as \"CCCCCCCCCFCCC\"\n\n                      Note that if the location ranges overlap, the\n                      behavior of the encoding will be undefined\n                      (well, it will be defined, but only according to\n                      the order in which the hash keys are read, which\n                      is basically undefined ... just don't do that).\n\n           id, start, end, strand - as with Bio::LocatableSeq; note\n                      that the coordinates are relative to the\n                      encoding DNA sequence, not the implicit protein\n                      sequence.  If strand is reversed, then the\n                      encoding is assumed to be relative to the\n                      reverse strand as well.\n\n\n#'\n\nsub new {\n\n    my ($self, @args) = @_;\n    $self = $self->SUPER::new(@args, -alphabet => 'dna');\n    my ($enc) = $self->_rearrange([qw(ENCODING)], @args);\n    # set the real encoding:\n    if ($enc) {\n\t$self->encoding($enc);\n    } else {\n\t$self->_recheck_encoding;\n    }\n    return $self;\n}\n\n=head2 encoding\n\n Title   : encoding\n Usage   : $obj->encoding(\"CCCCCC\");\n           $obj->encoding( -encoding => { I => $location } );\n           $enc = $obj->encoding(-explicit => 1);\n           $enc = $obj->encoding(\"CCCCCC\", -explicit => 1);\n           $enc = $obj->encoding(-location => $location,\n                                 -explicit => 1,\n                                 -absolute => 1 );\n Function: get/set the objects encoding, either globally or by location(s).\n Returns : the (possibly new) encoding string.\n Args    : encoding - see the encoding argument to the new() function.\n\n           explicit - whether or not to return explicit phase\n                      information in the coding (i.e. \"CCC\" becomes\n                      \"CDE\", \"III\" becomes \"IJK\", etc); defaults to 0.\n\n           location - optional; location to get/set the encoding.\n                      Defaults to the entire sequence.\n\n           absolute - whether or not the locational elements (either\n                      in the encoding hashref or the location\n                      argument) are relative to the absolute start/end\n                      of the Bio::LocatableSeq, or to the internal,\n                      relative coordinate system (beginning at 1);\n                      defaults to 0 (i.e. relative)\n\n\nsub encoding {\n\n    my ($self, @args) = @_;\n    my ($enc, $loc, $exp, $abs) = $self->_rearrange([qw(ENCODING LOCATION EXPLICIT ABSOLUTE)], @args);\n\n    if (!$enc) {\n\t# do nothing; _recheck_encoding will fix for us, if necessary\n    } elsif (ref $enc eq 'HASH') {\n\t$self->throw( -class => 'Bio::Root::NotImplemented',\n\t\t      -text  => \"Hashref functionality not yet implemented;\\nplease email me if you really need this.\");\n\t#TODO: finish all this\n\twhile (my ($char, $locs) = each %$enc) {\n\t    if (ref $locs eq 'ARRAY') {\n\t    } elsif (UNIVERSAL::isa($locs, \"Bio::LocationI\")) {\n\t    } else {\n\t\t$self->throw(\"Only a scalar or a ref to a hash; not a ref to a @{{lc ref $enc}}\");\n\t    }\n\t}\n    } elsif (! ref $enc) {\n\t$enc = uc $enc;\n\t$exp = 1 if (!defined $exp && $enc =~ m/[DEJKV]/o);\n\n\tif ($enc =~ m/\\d/o) { # numerically \"enhanced\" encoding\n\t    my $numenc = $enc;\n\t    $enc = '';\n\t    while ($numenc =~ m/\\G(\\d*)([CDEIJKUVGFB])/g) {\n\t\tmy ($num, $char) = ($1, $2);\n\t\t$num = 1 unless $num;\n\t\t$enc .= $char x $num;\n\t    }\n\t}\n\n\tif (defined $exp && $exp == 0 && $enc =~ m/([^CIUGFB])/) {\n\t    $self->throw(\"Unrecognized character '$1' in implicit encoding\");\n\t} elsif ($enc =~ m/[^CDEIJKUVGFB]/) {\n\t    $self->throw(\"Unrecognized character '$1' in explicit encoding\");\n\t}\n\n\tif ($loc) { # a global location, over which to apply the specified encoding.\n\n\t    # balk if too many non-gap characters present in encoding:\n\t    my ($ct) = $enc =~ tr/GB/GB/;\n\t    $ct = length($enc) - $ct;\n\t    $self->throw(\"Location length doesn't match number of coding chars in encoding!\")\n\t\tif ($loc->location_type eq 'EXACT' &&  $loc->length != $ct);\n\n\t    my $start = $loc->start;\n\t    my $end = $loc->end;\n\n\t    # strip any encoding that hangs off the ends of the sequence:\n\t    if ($start < $self->start) {\n\t\tmy $diff = $self->start - $start;\n\t\t$start = $self->start;\n\t\t$enc = substr($enc, $diff);\n\t    }\n\t    if ($end > $self->end) {\n\t\tmy $diff = $end - $self->end;\n\t\t$end = $self->end;\n\t\t$enc = substr($enc, -$diff);\n\t    }\n\n\t    my $currenc = $self->{_encoding};\n\t    my $currseq = $self->seq;\n\n\t    my ($spanstart, $spanend) = ($self->column_from_residue_number($start),\n\t\t\t\t\t $self->column_from_residue_number($end) );\n\n\t    if ($currseq) {\n\t\t# strip any gaps in sequence spanned by this location:\n\t\t($spanstart, $spanend) = ($spanend, $spanstart) if $self->strand < 0;\n\t\tmy ($before, $in, $after) = $currseq =~ m/(.{@{[ $spanstart - ($loc->location_type eq 'IN-BETWEEN' ? 0 : 1) ]}})\n                                                          (.{@{[ $spanend - $spanstart + ($loc->location_type eq 'IN-BETWEEN' ? -1 : 1) ]}})\n                                                          (.*)\n                                                         /x;\n                $in ||= '';\n\t\t$in =~ s/[\\.\\-]+//g;\n\t\t$currseq = ($before||'') . $in. ($after||'');\n\t\t# change seq without changing the alphabet\n\t\t$self->seq($currseq,$self->alphabet());\n\t    }\n\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\t    substr($currenc, $spanstart, $spanend - $spanstart + ($loc->location_type eq 'IN-BETWEEN' ? -1 : 1),\n\t\t   $self->strand >= 0 ? $enc : reverse $enc);\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\n\t    $self->{_encoding} = $currenc;\n\t    $self->_recheck_encoding;\n\n\t    $currenc = $self->{_encoding};\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\t    $enc = substr($currenc, $spanstart, length $enc);\n\t    $enc = reverse $enc if $self->strand < 0;\n\n\t    return $exp ? $enc: $self->_convert2implicit($enc);\n\n\t} else {\n\t    # presume a global redefinition; strip any current gap\n\t    # characters in the sequence so they don't corrupt the\n\t    # encoding\n\t    my $dna = $self->seq;\n\t    $dna =~ s/[\\.\\-]//g;\n\t    $self->seq($dna, 'dna');\n\t    $self->{_encoding} = $enc;\n\t}\n    } else {\n\t$self->throw(\"Only a scalar or a ref to a hash; not a ref to a @{{lc ref $enc}}\");\n    }\n\n    $self->_recheck_encoding();\n\n    return $exp ? $self->{_encoding} : $self->_convert2implicit($self->{_encoding});\n}\n\nsub _convert2implicit {\n\n    my ($self, $enc) = @_;\n\n    $enc =~ s/[DE]/C/g;\n    $enc =~ s/[JK]/I/g;\n    $enc =~ s/V/U/g;\n\n    return $enc;\n}\n\nsub _recheck_encoding {\n\n    my $self = shift;\n\n    my @enc = split //, ($self->{_encoding} || '');\n\n    my @nt = split(//, $self->SUPER::seq);\n    @nt = reverse @nt if $self->strand && $self->strand < 0;\n\n    # make sure an encoding exists!\n    @enc = ('C') x scalar grep { !/[\\.\\-]/o } @nt\n\tunless @enc;\n\n    # check for gaps to be truly present in the sequence\n    # and vice versa\n    my $i;\n    for ($i = 0 ; $i < @nt && $i < @enc ; $i++) {\n\tif ($nt[$i] =~ /[\\.\\-]/o && $enc[$i] !~ m/[GB]/o) {\n\t    splice(@enc, $i, 0, 'G');\n\t} elsif ($nt[$i] !~ /[\\.\\-]/o && $enc[$i] =~ m/[GB]/o) {\n\t    splice(@nt, $i, 0, '-');\n\t}\n    }\n    if ($i < @enc) {\n\t# extra encoding; presumably all gaps?\n\tfor (  ; $i < @enc ; $i++) {\n\t    if ($enc[$i] =~ m/[GB]/o) {\n\t\tpush @nt, '-';\n\t    } else {\n\t\t$self->throw(\"Extraneous encoding info: \" . join('', @enc[$i..$#enc]));\n\t    }\n\t}\n    } elsif ($i < @nt) {\n\tfor (  ; $i < @nt ; $i++) {\n\t    if ($nt[$i] =~ m/[\\.\\-]/o) {\n\t\tpush @enc, 'G';\n\t    } else {\n\t\tpush @enc, 'C';\n\t    }\n\t}\n    }\n\n    my @cde_array = qw(C D E);\n    my @ijk_array = qw(I J K);\n    # convert any leftover implicit coding into explicit coding\n    my ($Cct, $Ict, $Uct, $Vct, $Vwarned) = (0, 0, 0, 0);\n    for ($i = 0 ; $i < @enc ; $i++) {\n\tif ($enc[$i] =~ m/[CDE]/o) {\n\t    my  $temp_index = $Cct %3;\n\t    $enc[$i] = $cde_array[$temp_index];\n\t    $Cct++; $Ict = 0; $Uct = 1;\n\t    $self->warn(\"3' untranslated encoding (V) seen prior to other coding symbols\")\n\t\tif ($Vct && !$Vwarned++);\n\t} elsif ($enc[$i] =~ m/[IJK]/o) {\n\t    $enc[$i] = $ijk_array[$Ict % 3];\n\t    $Ict++; $Uct = 1;\n\t    $self->warn(\"3' untranslated encoding (V) seen before other coding symbols\")\n\t\tif ($Vct && !$Vwarned++);\n\t} elsif ($enc[$i] =~ m/[UV]/o) {\n\t    if ($Uct == 1) {\n\t\t$enc[$i] = 'V';\n\t\t$Vct = 1;\n\t    }\n\t} elsif ($enc[$i] eq 'B') {\n\t    $Cct++; $Ict++\n\t} elsif ($enc[$i] eq 'G') {\n\t    # gap; leave alone\n\t}\n    }\n\n    @nt = reverse @nt if $self->strand && $self->strand < 0;\n\n    $self->{'seq'} = join('', @nt);\n    # $self->seq(join('', @nt), 'dna');\n    $self->{_encoding} = join '', @enc;\n}\n\n=head2 cds\n\n Title   : cds\n Usage   : $cds = $obj->cds(-nogaps => 1);\n Function: obtain the \"spliced\" DNA sequence, by removing any\n           nucleotides that participate in an UTR, forward frameshift\n           or intron, and replacing any unknown nucleotide implied by\n           a backward frameshift or gap with N's.\n Returns : a Bio::Seq::EncodedSeq object, with an encoding consisting only\n           of \"CCCC..\".\n Args    : nogaps - strip any gap characters (resulting from 'G' or 'B'\n           encodings), rather than replacing them with N's."}},{"line":494,"kind":12,"name":"_encoding"},{"name":"defined","kind":12,"line":522},{"definition":"sub","name":"translate","containerName":"main::","children":[{"name":"cds","kind":12,"containerName":"translate","line":539}],"range":{"start":{"line":539,"character":0},"end":{"character":9999,"line":539}},"kind":12,"line":539},{"name":"SUPER","kind":12,"containerName":"translate","line":539},{"line":555,"kind":12,"range":{"end":{"character":9999,"line":555},"start":{"line":555,"character":0}},"children":[{"line":555,"kind":12,"containerName":"protseq","name":"cds"},{"line":555,"name":"seq","containerName":"protseq","kind":12}],"containerName":"main::","name":"protseq","definition":"sub"},{"line":555,"containerName":"translate","kind":12,"name":"SUPER"},{"definition":"sub","detail":"($self,@args)","children":[{"line":584,"name":"$self","localvar":"my","kind":13,"containerName":"dnaseq","definition":"my"},{"line":584,"kind":13,"containerName":"dnaseq","name":"@args"},{"line":585,"name":"$seq","kind":13,"localvar":"my","containerName":"dnaseq","definition":"my"},{"line":585,"kind":13,"containerName":"dnaseq","name":"$enc"},{"line":585,"name":"$loc","containerName":"dnaseq","kind":13},{"containerName":"dnaseq","kind":13,"name":"$self","line":585},{"line":585,"name":"_rearrange","kind":12,"containerName":"dnaseq"},{"line":585,"containerName":"dnaseq","kind":13,"name":"@args"},{"kind":13,"containerName":"dnaseq","name":"$self","line":588}],"containerName":"main::","name":"dnaseq","signature":{"label":"dnaseq($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EncodedSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::EncodedSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::EncodedSeq - subtype of L<Bio::LocatableSeq|Bio::LocatableSeq> to store DNA that encodes a protein\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => $dna,\n                                  -encoding => \"CCCCCCCIIIIICCCCC\",\n                                  -start => 1,\n                                  -strand => 1,\n                                  -length => 17);\n\n  # splice out (and possibly revcomp) the coding sequence\n  $cds = obj->cds;\n\n  # obtain the protein translation of the sequence\n  $prot = $obj->translate;\n\n  # other access/inspection routines as with Bio::LocatableSeq and\n  # Bio::SeqI; note that coordinates are relative only to the DNA\n  # sequence, not it's implicit encoded protein sequence.\n\n=head1 DESCRIPTION\n\nBio::Seq::EncodedSeq is a L<Bio::LocatableSeq|Bio::LocatableSeq>\nobject that holds a DNA sequence as well as information about the\ncoding potential of that DNA sequence.  It is meant to be useful in an\nalignment context, where the DNA may contain frameshifts, gaps and/or\nintrons, or in describing the transcript of a gene.  An EncodedSeq\nprovides the ability to access the \"spliced\" coding sequence, meaning\nthat all introns and gaps are removed, and any frameshifts are\nadjusted to provide a \"clean\" CDS.\n\nIn order to make simultaneous use of either the DNA or the implicit\nencoded protein sequence coordinates, please see\nL<Bio::Coordinate::EncodingPair>.\n\n=head1 ENCODING\n\nWe use the term \"encoding\" here to refer to the series of symbols that\nwe use to identify which residues of a DNA sequence are protein-coding\n(i.e. part of a codon), intronic, part of a 5' or 3', frameshift\n\"mutations\", etc.  From this information, a Bio::Seq::EncodedSeq is\nable to \"figure out\" its translational CDS.  There are two sets of\ncoding characters, one termed \"implicit\" and one termed \"explicit\".\n\nThe \"implicit\" encoding is a bit simpler than the \"explicit\" encoding:\n'C' is used for any nucleotide that's part of a codon, 'U' for any\nUTR, etc.  The full list is shown below:\n\n Code  Meaning\n ----  -------\n  C    coding\n  I    intronic\n  U    untranslated\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nThe \"explicit\" encoding is just an expansion of the \"implicit\"\nencoding, to denote phase:\n\n Code  Meaning\n ----  -------\n  C    coding, 1st codon position\n  D    coding, 2nd codon position\n  E    coding, 3rd codon position\n\n  I    intronic, phase 0 (relative to intron begin)\n  J    intronic, phase 1\n  K    intronic, phase 2\n\n  U    untranslated 3'UTR\n  V    untranslated 5'UTR\n\n  G    gapped (for use in alignments)\n  F    a \"forward\", +1 frameshift\n  B    a \"backward\", -1 frameshift\n\nNote that the explicit coding is meant to provide easy access to\nposition/phase specific nucleotides:\n\n  $obj = Bio::Seq::EncodedSeq->new(-seq => \"ACAATCAGACTACG...\",\n                                   -encoding => \"CCCCCCIII...\"\n                                  );\n\n  # fetch arrays of nucleotides at each codon position:\n  my @pos1 = $obj->dnaseq(encoding => 'C', explicit => 1);\n  my @pos2 = $obj->dnaseq(encoding => 'D');\n  my @pos3 = $obj->dnaseq(encoding => 'E');\n\n  # fetch arrays of \"3-1\" codon dinucleotides, useful for genomic\n  # signature analyses without compounding influences of codon bias:\n  my @pairs = $obj->dnaseq(encoding => 'EC');\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::EncodedSeq;\n\nuse strict;\n\n\nuse base qw(Bio::LocatableSeq);\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Seq::EncodedSeq->new(-seq      => \"AGTACGTGTCATG\",\n                                            -encoding => \"CCCCCCFCCCCCC\",\n                                            -id       => \"myseq\",\n                                            -start    => 1,\n                                            -end      => 13,\n                                            -strand   => 1\n                                      );\n Function: creates a new Bio::Seq::EncodedSeq object from a supplied DNA\n           sequence\n Returns : a new Bio::Seq::EncodedSeq object\n\n Args    : seq      - primary nucleotide sequence used to encode the\n                      protein; note that any positions involved in a\n                      gap ('G') or backward frameshift ('B') should\n                      have one or more gap characters; if the encoding\n                      specifies G or B, but no (or not enough) gap\n                      characters exist, *they'll be added*; similary,\n                      if there are gap characters without a\n                      corresponding G or B encoding, G's will be\n                      inserted into the encoding.  This allows some\n                      flexibility in specifying your sequence and\n                      coding without having to calculate a lot of the\n                      encoding for yourself.\n\n           encoding - a string of characters (see Encoding Table)\n                      describing backwards frameshifts implied by the\n                      encoding but not present in the sequence will be\n                      added (as '-'s) to the sequence.  If not\n                      supplied, it will be assumed that all positions\n                      are coding (C).  Encoding may include either\n                      implicit phase encoding characters (i.e. \"CCC\")\n                      and/or explicit encoding characters (i.e. \"CDE\").\n                      Additionally, prefixed numbers may be used to\n                      denote repetition (i.e. \"27C3I28C\").\n\n                      Alternatively, encoding may be a hashref\n                      datastructure, with encoding characters as keys\n                      and Bio::LocationI objects (or arrayrefs of\n                      Bio::LocationI objects) as values, e.g.:\n\n                      { C => [ Bio::Location::Simple->new(1,9),\n                               Bio::Location::Simple->new(11,13) ],\n                        F => Bio::Location::Simple->new(10,10),\n                      } # same as \"CCCCCCCCCFCCC\"\n\n                      Note that if the location ranges overlap, the\n                      behavior of the encoding will be undefined\n                      (well, it will be defined, but only according to\n                      the order in which the hash keys are read, which\n                      is basically undefined ... just don't do that).\n\n           id, start, end, strand - as with Bio::LocatableSeq; note\n                      that the coordinates are relative to the\n                      encoding DNA sequence, not the implicit protein\n                      sequence.  If strand is reversed, then the\n                      encoding is assumed to be relative to the\n                      reverse strand as well.\n\n\n#'\n\nsub new {\n\n    my ($self, @args) = @_;\n    $self = $self->SUPER::new(@args, -alphabet => 'dna');\n    my ($enc) = $self->_rearrange([qw(ENCODING)], @args);\n    # set the real encoding:\n    if ($enc) {\n\t$self->encoding($enc);\n    } else {\n\t$self->_recheck_encoding;\n    }\n    return $self;\n}\n\n=head2 encoding\n\n Title   : encoding\n Usage   : $obj->encoding(\"CCCCCC\");\n           $obj->encoding( -encoding => { I => $location } );\n           $enc = $obj->encoding(-explicit => 1);\n           $enc = $obj->encoding(\"CCCCCC\", -explicit => 1);\n           $enc = $obj->encoding(-location => $location,\n                                 -explicit => 1,\n                                 -absolute => 1 );\n Function: get/set the objects encoding, either globally or by location(s).\n Returns : the (possibly new) encoding string.\n Args    : encoding - see the encoding argument to the new() function.\n\n           explicit - whether or not to return explicit phase\n                      information in the coding (i.e. \"CCC\" becomes\n                      \"CDE\", \"III\" becomes \"IJK\", etc); defaults to 0.\n\n           location - optional; location to get/set the encoding.\n                      Defaults to the entire sequence.\n\n           absolute - whether or not the locational elements (either\n                      in the encoding hashref or the location\n                      argument) are relative to the absolute start/end\n                      of the Bio::LocatableSeq, or to the internal,\n                      relative coordinate system (beginning at 1);\n                      defaults to 0 (i.e. relative)\n\n\nsub encoding {\n\n    my ($self, @args) = @_;\n    my ($enc, $loc, $exp, $abs) = $self->_rearrange([qw(ENCODING LOCATION EXPLICIT ABSOLUTE)], @args);\n\n    if (!$enc) {\n\t# do nothing; _recheck_encoding will fix for us, if necessary\n    } elsif (ref $enc eq 'HASH') {\n\t$self->throw( -class => 'Bio::Root::NotImplemented',\n\t\t      -text  => \"Hashref functionality not yet implemented;\\nplease email me if you really need this.\");\n\t#TODO: finish all this\n\twhile (my ($char, $locs) = each %$enc) {\n\t    if (ref $locs eq 'ARRAY') {\n\t    } elsif (UNIVERSAL::isa($locs, \"Bio::LocationI\")) {\n\t    } else {\n\t\t$self->throw(\"Only a scalar or a ref to a hash; not a ref to a @{{lc ref $enc}}\");\n\t    }\n\t}\n    } elsif (! ref $enc) {\n\t$enc = uc $enc;\n\t$exp = 1 if (!defined $exp && $enc =~ m/[DEJKV]/o);\n\n\tif ($enc =~ m/\\d/o) { # numerically \"enhanced\" encoding\n\t    my $numenc = $enc;\n\t    $enc = '';\n\t    while ($numenc =~ m/\\G(\\d*)([CDEIJKUVGFB])/g) {\n\t\tmy ($num, $char) = ($1, $2);\n\t\t$num = 1 unless $num;\n\t\t$enc .= $char x $num;\n\t    }\n\t}\n\n\tif (defined $exp && $exp == 0 && $enc =~ m/([^CIUGFB])/) {\n\t    $self->throw(\"Unrecognized character '$1' in implicit encoding\");\n\t} elsif ($enc =~ m/[^CDEIJKUVGFB]/) {\n\t    $self->throw(\"Unrecognized character '$1' in explicit encoding\");\n\t}\n\n\tif ($loc) { # a global location, over which to apply the specified encoding.\n\n\t    # balk if too many non-gap characters present in encoding:\n\t    my ($ct) = $enc =~ tr/GB/GB/;\n\t    $ct = length($enc) - $ct;\n\t    $self->throw(\"Location length doesn't match number of coding chars in encoding!\")\n\t\tif ($loc->location_type eq 'EXACT' &&  $loc->length != $ct);\n\n\t    my $start = $loc->start;\n\t    my $end = $loc->end;\n\n\t    # strip any encoding that hangs off the ends of the sequence:\n\t    if ($start < $self->start) {\n\t\tmy $diff = $self->start - $start;\n\t\t$start = $self->start;\n\t\t$enc = substr($enc, $diff);\n\t    }\n\t    if ($end > $self->end) {\n\t\tmy $diff = $end - $self->end;\n\t\t$end = $self->end;\n\t\t$enc = substr($enc, -$diff);\n\t    }\n\n\t    my $currenc = $self->{_encoding};\n\t    my $currseq = $self->seq;\n\n\t    my ($spanstart, $spanend) = ($self->column_from_residue_number($start),\n\t\t\t\t\t $self->column_from_residue_number($end) );\n\n\t    if ($currseq) {\n\t\t# strip any gaps in sequence spanned by this location:\n\t\t($spanstart, $spanend) = ($spanend, $spanstart) if $self->strand < 0;\n\t\tmy ($before, $in, $after) = $currseq =~ m/(.{@{[ $spanstart - ($loc->location_type eq 'IN-BETWEEN' ? 0 : 1) ]}})\n                                                          (.{@{[ $spanend - $spanstart + ($loc->location_type eq 'IN-BETWEEN' ? -1 : 1) ]}})\n                                                          (.*)\n                                                         /x;\n                $in ||= '';\n\t\t$in =~ s/[\\.\\-]+//g;\n\t\t$currseq = ($before||'') . $in. ($after||'');\n\t\t# change seq without changing the alphabet\n\t\t$self->seq($currseq,$self->alphabet());\n\t    }\n\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\t    substr($currenc, $spanstart, $spanend - $spanstart + ($loc->location_type eq 'IN-BETWEEN' ? -1 : 1),\n\t\t   $self->strand >= 0 ? $enc : reverse $enc);\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\n\t    $self->{_encoding} = $currenc;\n\t    $self->_recheck_encoding;\n\n\t    $currenc = $self->{_encoding};\n\t    $currenc = reverse $currenc if $self->strand < 0;\n\t    $enc = substr($currenc, $spanstart, length $enc);\n\t    $enc = reverse $enc if $self->strand < 0;\n\n\t    return $exp ? $enc: $self->_convert2implicit($enc);\n\n\t} else {\n\t    # presume a global redefinition; strip any current gap\n\t    # characters in the sequence so they don't corrupt the\n\t    # encoding\n\t    my $dna = $self->seq;\n\t    $dna =~ s/[\\.\\-]//g;\n\t    $self->seq($dna, 'dna');\n\t    $self->{_encoding} = $enc;\n\t}\n    } else {\n\t$self->throw(\"Only a scalar or a ref to a hash; not a ref to a @{{lc ref $enc}}\");\n    }\n\n    $self->_recheck_encoding();\n\n    return $exp ? $self->{_encoding} : $self->_convert2implicit($self->{_encoding});\n}\n\nsub _convert2implicit {\n\n    my ($self, $enc) = @_;\n\n    $enc =~ s/[DE]/C/g;\n    $enc =~ s/[JK]/I/g;\n    $enc =~ s/V/U/g;\n\n    return $enc;\n}\n\nsub _recheck_encoding {\n\n    my $self = shift;\n\n    my @enc = split //, ($self->{_encoding} || '');\n\n    my @nt = split(//, $self->SUPER::seq);\n    @nt = reverse @nt if $self->strand && $self->strand < 0;\n\n    # make sure an encoding exists!\n    @enc = ('C') x scalar grep { !/[\\.\\-]/o } @nt\n\tunless @enc;\n\n    # check for gaps to be truly present in the sequence\n    # and vice versa\n    my $i;\n    for ($i = 0 ; $i < @nt && $i < @enc ; $i++) {\n\tif ($nt[$i] =~ /[\\.\\-]/o && $enc[$i] !~ m/[GB]/o) {\n\t    splice(@enc, $i, 0, 'G');\n\t} elsif ($nt[$i] !~ /[\\.\\-]/o && $enc[$i] =~ m/[GB]/o) {\n\t    splice(@nt, $i, 0, '-');\n\t}\n    }\n    if ($i < @enc) {\n\t# extra encoding; presumably all gaps?\n\tfor (  ; $i < @enc ; $i++) {\n\t    if ($enc[$i] =~ m/[GB]/o) {\n\t\tpush @nt, '-';\n\t    } else {\n\t\t$self->throw(\"Extraneous encoding info: \" . join('', @enc[$i..$#enc]));\n\t    }\n\t}\n    } elsif ($i < @nt) {\n\tfor (  ; $i < @nt ; $i++) {\n\t    if ($nt[$i] =~ m/[\\.\\-]/o) {\n\t\tpush @enc, 'G';\n\t    } else {\n\t\tpush @enc, 'C';\n\t    }\n\t}\n    }\n\n    my @cde_array = qw(C D E);\n    my @ijk_array = qw(I J K);\n    # convert any leftover implicit coding into explicit coding\n    my ($Cct, $Ict, $Uct, $Vct, $Vwarned) = (0, 0, 0, 0);\n    for ($i = 0 ; $i < @enc ; $i++) {\n\tif ($enc[$i] =~ m/[CDE]/o) {\n\t    my  $temp_index = $Cct %3;\n\t    $enc[$i] = $cde_array[$temp_index];\n\t    $Cct++; $Ict = 0; $Uct = 1;\n\t    $self->warn(\"3' untranslated encoding (V) seen prior to other coding symbols\")\n\t\tif ($Vct && !$Vwarned++);\n\t} elsif ($enc[$i] =~ m/[IJK]/o) {\n\t    $enc[$i] = $ijk_array[$Ict % 3];\n\t    $Ict++; $Uct = 1;\n\t    $self->warn(\"3' untranslated encoding (V) seen before other coding symbols\")\n\t\tif ($Vct && !$Vwarned++);\n\t} elsif ($enc[$i] =~ m/[UV]/o) {\n\t    if ($Uct == 1) {\n\t\t$enc[$i] = 'V';\n\t\t$Vct = 1;\n\t    }\n\t} elsif ($enc[$i] eq 'B') {\n\t    $Cct++; $Ict++\n\t} elsif ($enc[$i] eq 'G') {\n\t    # gap; leave alone\n\t}\n    }\n\n    @nt = reverse @nt if $self->strand && $self->strand < 0;\n\n    $self->{'seq'} = join('', @nt);\n    # $self->seq(join('', @nt), 'dna');\n    $self->{_encoding} = join '', @enc;\n}\n\n=head2 cds\n\n Title   : cds\n Usage   : $cds = $obj->cds(-nogaps => 1);\n Function: obtain the \"spliced\" DNA sequence, by removing any\n           nucleotides that participate in an UTR, forward frameshift\n           or intron, and replacing any unknown nucleotide implied by\n           a backward frameshift or gap with N's.\n Returns : a Bio::Seq::EncodedSeq object, with an encoding consisting only\n           of \"CCCC..\".\n Args    : nogaps - strip any gap characters (resulting from 'G' or 'B'\n           encodings), rather than replacing them with N's.\n\n\nsub cds {\n\n    my ($self, @args) = @_;\n\n    my ($nogaps, $loc) = $self->_rearrange([qw(NOGAPS LOCATION)], @args);\n    $nogaps = 0 unless defined $nogaps;\n\n    my @nt = split //, $self->strand < 0 ? $self->revcom->seq : $self->seq;\n    my @enc = split //, $self->_convert2implicit($self->{_encoding});\n\n    my ($start, $end) = (0, scalar @nt);\n\n    if ($loc) {\n\t$start = $loc->start;\n\t$start++ if $loc->location_type eq 'IN-BETWEEN';\n\t$start = $self->column_from_residue_number($start);\n\t$start--;\n\n\t$end = $loc->end;\n\t$end = $self->column_from_residue_number($end);\n\n\t($start, $end) = ($end, $start) if $self->strand < 0;\n\t$start--;\n    }\n\n    for (my $i = $start ; $i < $end ; $i++) {\n\tif ($enc[$i] eq 'I' || $enc[$i] eq 'U' || $enc[$i] eq 'F') {\n\t    # remove introns, untranslated and forward frameshift nucleotides\n\t    $nt[$i] = undef;\n\t} elsif ($enc[$i] eq 'G' || $enc[$i] eq 'B') {\n\t    # replace gaps and backward frameshifts with N's, unless asked not to.\n\t    $nt[$i] = $nogaps ? undef : 'N';\n\t}\n    }\n\n    return ($self->can_call_new ? ref($self) : __PACKAGE__)->new\n\t(-seq => join('', grep { defined } @nt[$start..--$end]),\n\t -start => $self->start,\n\t -end => $self->end,\n\t -strand => 1, -alphabet => 'dna');\n}\n\n=head2 translate\n\n Title   : translate\n Usage   : $prot = $obj->translate(@args);\n Function: obtain the protein sequence encoded by the underlying DNA\n           sequence; same as $obj->cds()->translate(@args).\n Returns : a Bio::PrimarySeq object.\n Args    : same as the translate() function of Bio::PrimarySeqI\n\n\nsub translate { shift->cds(-nogaps => 1, @_)->SUPER::translate(@_) };\n\n=head2 protseq\n\n Title   : seq\n Usage   : $protseq = $obj->protseq();\n Function: obtain the raw protein sequence encoded by the underlying\n           DNA sequence; This is the same as calling\n           $obj->translate()->seq();\n Returns : a string of single-letter amino acid codes\n Args :    same as the seq() function of Bio::PrimarySeq; note that this\n           function may not be used to set the protein sequence; see\n           the dnaseq() function for that.\n\n\nsub protseq { shift->cds(-nogaps => 1, @_)->SUPER::translate(@_)->seq };\n\n=head2 dnaseq\n\n Title   : dnaseq\n Usage   : $dnaseq = $obj->dnaseq();\n           $obj->dnaseq(\"ACGTGTCGT\", \"CCCCCCCCC\");\n           $obj->dnaseq(-seq      => \"ATG\",\n                        -encoding => \"CCC\",\n                        -location => $loc );\n           @introns = $obj->$dnaseq(-encoding => 'I')\n Function: get/set the underlying DNA sequence; will overwrite any\n           current DNA and/or encoding information present.\n Returns : a string of single-letter nucleotide codes, including any\n           gaps implied by the encoding.\n Args    : seq      - the DNA sequence to be used as a replacement\n           encoding - the encoding of the DNA sequence (see the new()\n                      constructor); defaults to all 'C' if setting a\n                      new DNA sequence.  If no new DNA sequence is\n                      being provided, then the encoding is used as a\n                      \"filter\" for which to return fragments of\n                      non-overlapping DNA that match the encoding.\n           location - optional, the location of the DNA sequence to\n                      get/set; defaults to the entire sequence."},"line":582,"kind":12,"range":{"end":{"character":9999,"line":589},"start":{"character":0,"line":582}}},{"detail":"($self,$start,$end)","definition":"sub","name":"trunc","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"trunc","line":594,"definition":"my"},{"containerName":"trunc","kind":13,"name":"$start","line":594},{"kind":13,"containerName":"trunc","name":"$end","line":594},{"definition":"my","name":"$new","localvar":"my","kind":13,"containerName":"trunc","line":595},{"name":"$self","containerName":"trunc","kind":13,"line":595},{"name":"$start","kind":13,"containerName":"trunc","line":595},{"containerName":"trunc","kind":13,"name":"$end","line":595},{"line":596,"containerName":"trunc","kind":13,"name":"$start"},{"name":"$enc","containerName":"trunc","localvar":"my","kind":13,"line":597,"definition":"my"},{"line":597,"name":"$self","containerName":"trunc","kind":13},{"containerName":"trunc","kind":13,"name":"$enc","line":598},{"name":"$enc","containerName":"trunc","kind":13,"line":598},{"containerName":"trunc","kind":13,"name":"$self","line":598},{"name":"strand","containerName":"trunc","kind":12,"line":598},{"line":599,"containerName":"trunc","kind":13,"name":"$enc"},{"line":599,"containerName":"trunc","kind":13,"name":"$enc"},{"line":599,"name":"$start","containerName":"trunc","kind":13},{"name":"$end","kind":13,"containerName":"trunc","line":599},{"line":599,"name":"$start","containerName":"trunc","kind":13},{"line":600,"kind":13,"containerName":"trunc","name":"$enc"},{"line":600,"name":"$enc","kind":13,"containerName":"trunc"},{"kind":13,"containerName":"trunc","name":"$self","line":600},{"line":600,"name":"strand","kind":12,"containerName":"trunc"},{"line":601,"kind":13,"containerName":"trunc","name":"$new"},{"containerName":"trunc","kind":12,"name":"encoding","line":601},{"kind":13,"containerName":"trunc","name":"$enc","line":601},{"line":602,"name":"$new","kind":13,"containerName":"trunc"}],"signature":{"label":"trunc($self,$start,$end)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":" need to overload this so that we truncate both the seq and the encoding!"},"range":{"start":{"line":592,"character":0},"end":{"character":9999,"line":603}},"kind":12,"line":592},{"kind":12,"containerName":"trunc","name":"SUPER","line":595},{"kind":12,"name":"_encoding","line":597}],"version":5}