{"version":5,"vars":[{"line":84,"containerName":"","kind":2,"name":"vars"},{"line":96,"containerName":null,"kind":13,"name":"%MODEMAP"},{"name":"POSIX","containerName":"","kind":2,"line":96},{"containerName":null,"kind":13,"name":"@STATES","line":100},{"line":101,"containerName":null,"kind":13,"name":"%MAPPING"},{"line":125,"name":"base","kind":2,"containerName":""},{"containerName":"main::","name":"_initialize","children":[{"line":138,"name":"$self","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"containerName":"_initialize","kind":13,"name":"@args","line":138},{"name":"$self","kind":13,"containerName":"_initialize","line":139},{"line":139,"containerName":"_initialize","kind":13,"name":"@args"},{"line":140,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","kind":12,"name":"_eventHandler","line":140},{"line":140,"name":"register_factory","containerName":"_initialize","kind":12},{"containerName":"_initialize","kind":12,"name":"new","line":140},{"line":142,"name":"$self","kind":13,"containerName":"_initialize"},{"kind":12,"containerName":"_initialize","name":"_eventHandler","line":142},{"line":142,"name":"register_factory","containerName":"_initialize","kind":12},{"line":142,"kind":12,"containerName":"_initialize","name":"new"}],"detail":"($self,@args)","definition":"sub","range":{"end":{"line":143,"character":9999},"start":{"line":137,"character":0}},"kind":12,"line":137,"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO","parameters":[{"label":"$self"},{"label":"@args"}]}},{"line":139,"name":"SUPER","kind":12,"containerName":"_initialize"},{"line":140,"containerName":"Search::Result::ResultFactory","kind":12,"name":"Bio"},{"name":"Bio","kind":12,"containerName":"Search::HSP::HSPFactory","line":142},{"line":156,"range":{"end":{"character":9999,"line":277},"start":{"character":0,"line":156}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","label":"next_result($self)"},"children":[{"definition":"my","line":157,"name":"$self","containerName":"next_result","localvar":"my","kind":13},{"definition":"my","line":161,"kind":13,"localvar":"my","containerName":"next_result","name":"$curquery"},{"line":161,"name":"$curhit","kind":13,"containerName":"next_result"},{"name":"$state","localvar":"my","kind":13,"containerName":"next_result","line":162,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_result","line":163},{"containerName":"next_result","kind":12,"name":"start_document","line":163},{"name":"@hit_signifs","kind":13,"localvar":"my","containerName":"next_result","line":164,"definition":"my"},{"name":"$self","kind":13,"containerName":"next_result","line":165},{"line":165,"name":"_readline","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$state","line":167},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$qid","line":168},{"name":"$qhspid","containerName":"next_result","kind":13,"line":168},{"line":168,"name":"$qpercent","containerName":"next_result","kind":13},{"line":168,"kind":13,"containerName":"next_result","name":"$junk"},{"line":169,"name":"$alnlen","containerName":"next_result","kind":13},{"line":169,"containerName":"next_result","kind":13,"name":"$qdb"},{"line":169,"name":"$qacc","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$qstart","line":169},{"line":169,"name":"$qend","kind":13,"containerName":"next_result"},{"name":"$qstrand","kind":13,"containerName":"next_result","line":169},{"containerName":"next_result","kind":13,"name":"$hitdb","line":170},{"line":170,"name":"$hacc","kind":13,"containerName":"next_result"},{"line":170,"name":"$hstart","kind":13,"containerName":"next_result"},{"name":"$hend","kind":13,"containerName":"next_result","line":170},{"line":171,"name":"$hstrand","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$hstart","line":184},{"line":184,"name":"$hstart","containerName":"next_result","kind":13},{"name":"$hend","kind":13,"containerName":"next_result","line":185},{"line":185,"name":"$hend","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$qstart","line":186},{"line":186,"kind":13,"containerName":"next_result","name":"$qstart"},{"line":187,"kind":13,"containerName":"next_result","name":"$qend"},{"line":187,"kind":13,"containerName":"next_result","name":"$qend"},{"containerName":"next_result","kind":13,"name":"$hstart","line":188},{"name":"$hend","kind":13,"containerName":"next_result","line":188},{"line":188,"kind":13,"containerName":"next_result","name":"$qstart"},{"kind":13,"containerName":"next_result","name":"$qend","line":188},{"name":"$alnlen","kind":13,"containerName":"next_result","line":189},{"kind":13,"containerName":"next_result","name":"$self","line":190},{"name":"warn","containerName":"next_result","kind":12,"line":190},{"line":193,"name":"$self","kind":13,"containerName":"next_result"},{"name":"$curquery","containerName":"next_result","kind":13,"line":195},{"line":196,"name":"$curquery","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$qid","line":196},{"containerName":"next_result","kind":13,"name":"$self","line":197},{"line":197,"containerName":"next_result","kind":12,"name":"end_element"},{"line":198,"containerName":"next_result","kind":13,"name":"$self"},{"name":"_pushback","kind":12,"containerName":"next_result","line":198},{"containerName":"next_result","kind":13,"name":"$self","line":199},{"line":199,"name":"end_element","containerName":"next_result","kind":12},{"line":200,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"end_document","line":200},{"name":"$curhit","kind":13,"containerName":"next_result","line":203},{"containerName":"next_result","kind":13,"name":"$curhit","line":204},{"containerName":"next_result","kind":13,"name":"$hacc","line":204},{"name":"$self","kind":13,"containerName":"next_result","line":206},{"containerName":"next_result","kind":12,"name":"end_element","line":206},{"name":"$self","containerName":"next_result","kind":13,"line":207},{"line":207,"kind":12,"containerName":"next_result","name":"start_element"},{"containerName":"next_result","kind":13,"name":"$self","line":208},{"line":208,"name":"element","containerName":"next_result","kind":12},{"line":209,"kind":13,"containerName":"next_result","name":"$hacc"},{"line":210,"kind":13,"containerName":"next_result","name":"$self"},{"line":210,"kind":12,"containerName":"next_result","name":"element"},{"name":"$hacc","kind":13,"containerName":"next_result","line":211},{"line":213,"containerName":"next_result","kind":13,"name":"$curquery"},{"kind":13,"containerName":"next_result","name":"$self","line":214},{"line":214,"containerName":"next_result","kind":12,"name":"start_element"},{"line":215,"name":"$self","kind":13,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":216},{"line":216,"name":"element","kind":12,"containerName":"next_result"},{"line":217,"name":"$qid","containerName":"next_result","kind":13},{"line":218,"name":"$self","kind":13,"containerName":"next_result"},{"line":218,"containerName":"next_result","kind":12,"name":"element"},{"line":220,"name":"$self","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"element","line":220},{"name":"$qdb","containerName":"next_result","kind":13,"line":221},{"line":222,"name":"$self","kind":13,"containerName":"next_result"},{"line":222,"name":"element","containerName":"next_result","kind":12},{"line":223,"containerName":"next_result","kind":13,"name":"$hitdb"},{"line":226,"name":"$self","containerName":"next_result","kind":13},{"line":226,"containerName":"next_result","kind":12,"name":"start_element"},{"line":227,"kind":13,"containerName":"next_result","name":"$self"},{"line":227,"kind":12,"containerName":"next_result","name":"element"},{"line":228,"name":"$hacc","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":229},{"line":229,"kind":12,"containerName":"next_result","name":"element"},{"kind":13,"containerName":"next_result","name":"$hacc","line":230},{"line":236,"containerName":"next_result","kind":13,"name":"$qstrand"},{"line":237,"name":"$qstart","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$qend","line":237},{"line":237,"name":"$qend","kind":13,"containerName":"next_result"},{"line":237,"kind":13,"containerName":"next_result","name":"$qstart"},{"name":"$hstrand","containerName":"next_result","kind":13,"line":239},{"line":240,"name":"$hstart","kind":13,"containerName":"next_result"},{"line":240,"name":"$hend","kind":13,"containerName":"next_result"},{"line":240,"kind":13,"containerName":"next_result","name":"$hend"},{"containerName":"next_result","kind":13,"name":"$hstart","line":240},{"kind":13,"containerName":"next_result","name":"$self","line":243},{"line":243,"kind":12,"containerName":"next_result","name":"start_element"},{"kind":13,"containerName":"next_result","name":"$self","line":244},{"line":244,"kind":12,"containerName":"next_result","name":"element"},{"name":"$qstart","kind":13,"containerName":"next_result","line":245},{"name":"$self","containerName":"next_result","kind":13,"line":246},{"name":"element","kind":12,"containerName":"next_result","line":246},{"line":247,"name":"$qend","containerName":"next_result","kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":248},{"containerName":"next_result","kind":12,"name":"element","line":248},{"line":249,"containerName":"next_result","kind":13,"name":"$hstart"},{"name":"$self","containerName":"next_result","kind":13,"line":250},{"containerName":"next_result","kind":12,"name":"element","line":250},{"name":"$hend","kind":13,"containerName":"next_result","line":251},{"name":"$self","containerName":"next_result","kind":13,"line":252},{"containerName":"next_result","kind":12,"name":"element","line":252},{"line":253,"kind":13,"containerName":"next_result","name":"$alnlen"},{"kind":13,"containerName":"next_result","name":"$curquery","line":255},{"line":255,"kind":13,"containerName":"next_result","name":"$qid"},{"containerName":"next_result","kind":13,"name":"$curhit","line":256},{"line":256,"name":"$hacc","containerName":"next_result","kind":13},{"name":"$state","kind":13,"containerName":"next_result","line":257},{"line":258,"containerName":"next_result","kind":13,"name":"$curquery"},{"name":"$self","containerName":"next_result","kind":13,"line":259},{"kind":12,"containerName":"next_result","name":"warn","line":259},{"containerName":"next_result","kind":13,"name":"$self","line":263},{"containerName":"next_result","kind":12,"name":"element","line":263},{"kind":13,"containerName":"next_result","name":"$STATES","line":263},{"line":263,"name":"$state","kind":13,"containerName":"next_result"},{"line":265,"name":"$state","kind":13,"containerName":"next_result"},{"name":"@STATES","kind":13,"containerName":"next_result","line":265},{"containerName":"next_result","kind":13,"name":"$state","line":266},{"kind":13,"containerName":"next_result","name":"$self","line":267},{"line":267,"name":"end_element","containerName":"next_result","kind":12},{"line":271,"kind":13,"containerName":"next_result","name":"$curquery"},{"line":272,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"end_element","line":272},{"line":273,"name":"$self","containerName":"next_result","kind":13},{"line":273,"kind":12,"containerName":"next_result","name":"end_element"},{"line":274,"name":"$self","containerName":"next_result","kind":13},{"line":274,"containerName":"next_result","kind":12,"name":"end_document"}],"name":"next_result","containerName":"main::","definition":"sub","detail":"($self)"},{"signature":{"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"start_element($self,$data)"},"range":{"end":{"character":9999,"line":301},"start":{"line":290,"character":0}},"kind":12,"line":290,"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"start_element","children":[{"definition":"my","line":291,"localvar":"my","kind":13,"containerName":"start_element","name":"$self"},{"line":291,"name":"$data","containerName":"start_element","kind":13},{"definition":"my","line":293,"name":"$nm","containerName":"start_element","localvar":"my","kind":13},{"line":293,"kind":13,"containerName":"start_element","name":"$data"},{"name":"$type","localvar":"my","kind":13,"containerName":"start_element","line":294,"definition":"my"},{"name":"$MODEMAP","kind":13,"containerName":"start_element","line":294},{"line":294,"containerName":"start_element","kind":13,"name":"$nm"},{"line":295,"kind":13,"containerName":"start_element","name":"$self"},{"line":295,"name":"_mode","kind":12,"containerName":"start_element"},{"line":295,"containerName":"start_element","kind":13,"name":"$type"},{"line":296,"kind":13,"containerName":"start_element","name":"$self"},{"name":"_eventHandler","kind":12,"containerName":"start_element","line":296},{"kind":12,"containerName":"start_element","name":"will_handle","line":296},{"containerName":"start_element","kind":13,"name":"$type","line":296},{"definition":"my","line":297,"kind":13,"localvar":"my","containerName":"start_element","name":"$func"},{"name":"$type","kind":13,"containerName":"start_element","line":297},{"name":"$self","kind":13,"containerName":"start_element","line":298},{"line":298,"name":"_eventHandler","kind":12,"containerName":"start_element"},{"line":298,"containerName":"start_element","kind":13,"name":"$func"},{"name":"$data","kind":13,"containerName":"start_element","line":298},{"line":300,"containerName":"start_element","kind":13,"name":"$self"},{"name":"$type","containerName":"start_element","kind":13,"line":300}]},{"name":"%nm","containerName":null,"kind":13,"line":302},{"name":"%self","containerName":null,"kind":13,"line":303},{"line":304,"name":"%self","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":305},{"range":{"start":{"character":0,"line":321},"end":{"line":343,"character":9999}},"kind":12,"line":321,"signature":{"label":"end_element($self,$data)","documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"containerName":"main::","name":"end_element","children":[{"definition":"my","line":322,"localvar":"my","containerName":"end_element","kind":13,"name":"$self"},{"name":"$data","containerName":"end_element","kind":13,"line":322},{"definition":"my","localvar":"my","containerName":"end_element","kind":13,"name":"$nm","line":323},{"line":323,"name":"$data","containerName":"end_element","kind":13},{"line":324,"localvar":"my","containerName":"end_element","kind":13,"name":"$rc","definition":"my"},{"name":"$nm","containerName":"end_element","kind":13,"line":327},{"line":329,"name":"$self","kind":13,"containerName":"end_element"},{"line":329,"kind":12,"containerName":"end_element","name":"element"},{"line":330,"name":"$self","kind":13,"containerName":"end_element"},{"line":332,"name":"$self","containerName":"end_element","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"end_element","name":"$type","line":335},{"line":335,"name":"$MODEMAP","kind":13,"containerName":"end_element"},{"kind":13,"containerName":"end_element","name":"$nm","line":335},{"name":"$self","containerName":"end_element","kind":13,"line":336},{"line":336,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"line":336,"name":"will_handle","containerName":"end_element","kind":12},{"containerName":"end_element","kind":13,"name":"$type","line":336},{"line":337,"name":"$func","kind":13,"localvar":"my","containerName":"end_element","definition":"my"},{"line":337,"name":"$type","kind":13,"containerName":"end_element"},{"line":338,"name":"$rc","containerName":"end_element","kind":13},{"line":338,"name":"$self","containerName":"end_element","kind":13},{"line":338,"name":"_eventHandler","kind":12,"containerName":"end_element"},{"line":338,"containerName":"end_element","kind":13,"name":"$func"},{"name":"$self","kind":13,"containerName":"end_element","line":338},{"name":"$self","kind":13,"containerName":"end_element","line":339},{"line":341,"name":"$self","kind":13,"containerName":"end_element"}],"detail":"($self,$data)","definition":"sub"},{"name":"%MAPPING","kind":13,"containerName":null,"line":343},{"line":343,"name":"%nm","kind":13,"containerName":null},{"name":"%MAPPING","containerName":null,"kind":13,"line":344},{"line":344,"name":"%nm","kind":13,"containerName":null},{"definition":"my","line":345,"containerName":null,"localvar":"my","kind":13,"name":"$key"},{"line":345,"name":"%MAPPING","kind":13,"containerName":null},{"line":345,"containerName":null,"kind":13,"name":"@nm"},{"line":346,"containerName":null,"kind":13,"name":"%self"},{"line":346,"kind":13,"containerName":null,"name":"%key"},{"line":346,"name":"%MAPPING","containerName":null,"kind":13},{"line":346,"name":"%nm","containerName":null,"kind":13},{"line":346,"containerName":null,"kind":13,"name":"$key"},{"containerName":null,"kind":13,"name":"%self","line":346},{"name":"%self","kind":13,"containerName":null,"line":348},{"name":"%MAPPING","containerName":null,"kind":13,"line":348},{"name":"$nm","kind":13,"containerName":null,"line":348},{"line":348,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":351},{"line":351,"name":"warn","kind":12,"containerName":"main::"},{"line":353,"containerName":null,"kind":13,"name":"%self"},{"line":355,"name":"%self","kind":13,"containerName":null},{"line":355,"kind":13,"containerName":null,"name":"$rc"},{"name":"$nm","kind":13,"containerName":null,"line":355},{"line":356,"name":"$rc","kind":13,"containerName":null},{"line":371,"range":{"end":{"line":376,"character":9999},"start":{"character":0,"line":371}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","label":"element($self,$data)"},"children":[{"line":372,"name":"$self","localvar":"my","containerName":"element","kind":13,"definition":"my"},{"name":"$data","containerName":"element","kind":13,"line":372},{"name":"$self","containerName":"element","kind":13,"line":373},{"kind":12,"containerName":"element","name":"start_element","line":373},{"line":373,"containerName":"element","kind":13,"name":"$data"},{"name":"$self","containerName":"element","kind":13,"line":374},{"containerName":"element","kind":12,"name":"characters","line":374},{"line":374,"containerName":"element","kind":13,"name":"$data"},{"containerName":"element","kind":13,"name":"$self","line":375},{"containerName":"element","kind":12,"name":"end_element","line":375},{"line":375,"kind":13,"containerName":"element","name":"$data"}],"containerName":"main::","name":"element","definition":"sub","detail":"($self,$data)"},{"children":[{"containerName":"characters","localvar":"my","kind":13,"name":"$self","line":391,"definition":"my"},{"containerName":"characters","kind":13,"name":"$data","line":391},{"name":"$data","containerName":"characters","kind":13,"line":393},{"name":"$data","containerName":"characters","kind":13,"line":394},{"line":395,"name":"$data","kind":13,"containerName":"characters"},{"name":"$self","kind":13,"containerName":"characters","line":398},{"kind":12,"containerName":"characters","name":"in_element","line":398},{"name":"$data","containerName":"characters","kind":13,"line":399},{"name":"$self","containerName":"characters","kind":13,"line":401},{"line":401,"name":"$data","kind":13,"containerName":"characters"},{"kind":13,"containerName":"characters","name":"$data","line":401},{"line":404,"containerName":"characters","kind":13,"name":"$self"},{"line":404,"containerName":"characters","kind":13,"name":"$data"}],"name":"characters","containerName":"main::","definition":"sub","detail":"($self,$data)","line":390,"range":{"start":{"line":390,"character":0},"end":{"character":9999,"line":405}},"kind":12,"signature":{"label":"characters($self,$data)","documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}]}},{"signature":{"label":"_mode($self,$value)","documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"line":425,"character":9999},"start":{"character":0,"line":419}},"line":419,"detail":"($self,$value)","definition":"sub","name":"_mode","containerName":"main::","children":[{"definition":"my","line":420,"localvar":"my","kind":13,"containerName":"_mode","name":"$self"},{"line":420,"name":"$value","kind":13,"containerName":"_mode"},{"name":"$value","kind":13,"containerName":"_mode","line":421},{"line":422,"name":"$self","kind":13,"containerName":"_mode"},{"containerName":"_mode","kind":13,"name":"$value","line":422},{"line":424,"containerName":"_mode","kind":13,"name":"$self"}]},{"kind":12,"range":{"start":{"character":0,"line":440},"end":{"line":444,"character":9999}},"line":440,"signature":{"label":"within_element($self,$name)","documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]},"containerName":"main::","name":"within_element","children":[{"line":441,"localvar":"my","kind":13,"containerName":"within_element","name":"$self","definition":"my"},{"containerName":"within_element","kind":13,"name":"$name","line":441},{"name":"$name","containerName":"within_element","kind":13,"line":442},{"containerName":"within_element","kind":13,"name":"$self","line":443},{"line":444,"name":"$self","containerName":"within_element","kind":13}],"detail":"($self,$name)","definition":"sub"},{"line":445,"kind":13,"containerName":null,"name":"%self"},{"line":446,"containerName":null,"kind":13,"name":"%name"},{"signature":{"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"},"kind":12,"range":{"start":{"character":0,"line":466},"end":{"line":470,"character":9999}},"line":466,"detail":"($self,$name)","definition":"sub","containerName":"main::","name":"in_element","children":[{"definition":"my","name":"$self","containerName":"in_element","localvar":"my","kind":13,"line":467},{"line":467,"name":"$name","kind":13,"containerName":"in_element"},{"line":468,"containerName":"in_element","kind":13,"name":"$self"},{"containerName":"in_element","kind":13,"name":"$self","line":469},{"line":469,"name":"$name","kind":13,"containerName":"in_element"}]},{"line":484,"kind":12,"range":{"end":{"character":9999,"line":491},"start":{"line":484,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none","label":"start_document($self)"},"children":[{"definition":"my","line":485,"localvar":"my","kind":13,"containerName":"start_document","name":"$self"},{"line":486,"kind":13,"containerName":"start_document","name":"$self"},{"name":"$self","kind":13,"containerName":"start_document","line":487},{"kind":13,"containerName":"start_document","name":"$self","line":488},{"name":"$self","containerName":"start_document","kind":13,"line":489},{"line":490,"name":"$self","kind":13,"containerName":"start_document"}],"name":"start_document","containerName":"main::","definition":"sub","detail":"($self)"},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"end_document","kind":13,"line":506},{"name":"@args","containerName":"end_document","kind":13,"line":506},{"line":507,"containerName":"end_document","kind":13,"name":"$self"}],"containerName":"main::","name":"end_document","definition":"sub","detail":"($self,@args)","line":505,"kind":12,"range":{"end":{"line":508,"character":9999},"start":{"character":0,"line":505}},"signature":{"label":"end_document($self,@args)","documentation":"1;\n# $Id: waba.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::waba\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::waba - SearchIO parser for Jim Kent WABA program\nalignment output\n\n=head1 SYNOPSIS\n\n    # do not use this object directly, rather through Bio::SearchIO\n\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'waba',\n\t\t\t       -file   => 'output.wab');\n    while( my $result = $in->next_result ) {\n\twhile( my $hit = $result->next_hit ) {\n\t    while( my $hsp = $result->next_hsp ) {\n\n\t    }\n\t}\n    }\n\n=head1 DESCRIPTION\n\nThis parser will process the waba output (NOT the human readable format).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::waba;\nuse vars qw(%MODEMAP %MAPPING @STATES);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Search::Result::ResultFactory;\nuse Bio::Search::HSP::HSPFactory;\n\nuse POSIX;\n\nBEGIN { \n    # mapping of NCBI Blast terms to Bioperl hash keys\n    %MODEMAP = ('WABAOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n    @STATES = qw(Hsp_qseq Hsp_hseq Hsp_stateseq);\n    %MAPPING = \n\t( \n\t  'Hsp_query-from'=>  'HSP-query_start',\n\t  'Hsp_query-to'  =>  'HSP-query_end',\n\t  'Hsp_hit-from'  =>  'HSP-hit_start',\n\t  'Hsp_hit-to'    =>  'HSP-hit_end',\n\t  'Hsp_qseq'      =>  'HSP-query_seq',\n\t  'Hsp_hseq'      =>  'HSP-hit_seq',\n\t  'Hsp_midline'   =>  'HSP-homology_seq',\n\t  'Hsp_stateseq'  =>  'HSP-hmmstate_seq',\n\t  'Hsp_align-len' =>  'HSP-hsp_length',\n\t  \n\t  'Hit_id'        => 'HIT-name',\n\t  'Hit_accession' => 'HIT-accession',\n\n\t  'WABAOutput_program'  => 'RESULT-algorithm_name',\n\t  'WABAOutput_version'  => 'RESULT-algorithm_version',\n\t  'WABAOutput_query-def'=> 'RESULT-query_name',\n\t  'WABAOutput_query-db' => 'RESULT-query_database',\n \t  'WABAOutput_db'       => 'RESULT-database_name',\n\t  );\n}\n\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::waba->new();\n Function: Builds a new Bio::SearchIO::waba object \n Returns : Bio::SearchIO::waba\n Args    : see Bio::SearchIO\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    $self->_eventHandler->register_factory('result', Bio::Search::Result::ResultFactory->new(-type => 'Bio::Search::Result::WABAResult'));\n\n    $self->_eventHandler->register_factory('hsp', Bio::Search::HSP::HSPFactory->new(-type => 'Bio::Search::HSP::WABAHSP'));\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n    my ($self) = @_;\n    local $/ = \"\\n\";\n    local $_;\n    \n    my ($curquery,$curhit);\n    my $state = -1;\n    $self->start_document();\n    my @hit_signifs;\n    while( defined ($_ = $self->_readline )) { \n\t\n\tif( $state == -1 ) {\n\t    my ($qid, $qhspid,$qpercent, $junk,\n\t\t$alnlen,$qdb,$qacc,$qstart,$qend,$qstrand,\n\t\t$hitdb,$hacc,$hstart,$hend,\n\t\t$hstrand) =\n\t\t    ( /^(\\S+)\\.(\\S+)\\s+align\\s+ # get the queryid\n\t\t      (\\d+(\\.\\d+)?)\\%\\s+     # get the percentage\n\t\t      of\\s+(\\d+)\\s+  # get the length of the alignment\n\t\t      (\\S+)\\s+           # this is the query database\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for query\n\t\t      \\s+([\\-\\+])        # query strand\n\t\t      \\s+(\\S+)\\.         # hit db\n\t\t      (\\S+):(\\-?\\d+)\\-(\\-?\\d+) # The accession:start-end for hit\n\t\t      \\s+([\\-\\+])\\s*$    # hit strand\n\t\t      /ox );\n\t    \n\t    # Curses.  Jim's code is 0 based, the following is to readjust\n\t    if( $hstart < 0 ) { $hstart *= -1}\n\t    if( $hend   < 0 ) { $hend   *= -1}\n\t    if( $qstart < 0 ) { $qstart *= -1}\n\t    if( $qend   < 0 ) { $qend   *= -1}\n\t    $hstart++; $hend++; $qstart++; $qend++;\n\t    if( ! defined $alnlen ) {\n\t\t$self->warn(\"Unable to parse the rest of the WABA alignment info for: '$_'\");\n\t\tlast;\n\t    }\n\t    $self->{'_reporttype'} = 'WABA'; # hardcoded - only \n\t                                     # one type of WABA AFAIK\t    \n\t    if( defined $curquery && \n\t\t$curquery ne $qid ) { \n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->_pushback($_);\n\t\t$self->end_element({'Name' => 'WABAOutput'});\n\t\treturn $self->end_document();\n\t    } \n\t    \n\t    if( defined $curhit &&\n\t\t$curhit ne $hacc) {\n\t\t# slight duplication here -- keep these in SYNC\n\t\t$self->end_element({'Name' => 'Hit'});\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\n\t    } elsif ( ! defined $curquery ) {\n\t\t$self->start_element({'Name' => 'WABAOutput'});\n\t\t$self->{'_result_count'}++;\n\t\t$self->element({'Name' => 'WABAOutput_query-def',\n\t\t\t\t'Data' => $qid });\n\t\t$self->element({'Name' => 'WABAOutput_program',\n\t\t\t\t'Data' => 'WABA'});\n\t\t$self->element({'Name' => 'WABAOutput_query-db',\n\t\t\t\t'Data' => $qdb});\n\t\t$self->element({'Name' => 'WABAOutput_db',\n\t\t\t\t'Data' => $hitdb});\n\t\t\n\t\t# slight duplication here -- keep these N'SYNC ;-)\n\t\t$self->start_element({'Name' => 'Hit'});\n\t\t$self->element({'Name' => 'Hit_id',\n\t\t\t\t'Data' => $hacc});\n\t\t$self->element({'Name' => 'Hit_accession',\n\t\t\t\t'Data' => $hacc});\n\t    }\n\n\t    \n\t    # strand is inferred by start,end values\n\t    # in the Result Builder\n\t    if( $qstrand eq '-' ) {\n\t\t($qstart,$qend) = ($qend,$qstart);\n\t    }\n\t    if( $hstrand eq '-' ) {\n\t\t($hstart,$hend) = ($hend,$hstart);\n\t    }\n\n\t    $self->start_element({'Name' => 'Hsp'});\n\t    $self->element({'Name' => 'Hsp_query-from',\n\t\t\t    'Data' => $qstart});\n\t    $self->element({'Name' => 'Hsp_query-to',\n\t\t\t    'Data' => $qend});\n\t    $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t    'Data' => $hstart});\n\t    $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t    'Data' => $hend});\n\t    $self->element({'Name' => 'Hsp_align-len',\n\t\t\t    'Data' => $alnlen});\n\t    \n\t    $curquery = $qid;\n\t    $curhit   = $hacc;\n\t    $state = 0;\n\t} elsif( ! defined $curquery ) {\n\t    $self->warn(\"skipping because no Hit begin line was recognized\\n$_\") if( $_ !~ /^\\s+$/ );\n\t    next;\n\t} else { \n\t    chomp;\n\t    $self->element({'Name' => $STATES[$state++],\n\t\t\t    'Data' => $_});\n\t    if( $state >= scalar @STATES ) {\n\t\t$state = -1;\n\t\t$self->end_element({'Name' => 'Hsp'});\n\t    }\n\t}\n    }\n    if( defined $curquery  ) {\n\t$self->end_element({'Name' => 'Hit'});\n\t$self->end_element({'Name' => 'WABAOutput'});\n\treturn $self->end_document();\n    }\n    return;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};    \n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\t\t\t\t\t\t \n\tunshift @{$self->{'_elements'}}, $type;\n    }\n    if($nm eq 'WABAOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n    if( $nm eq 'Hsp' ) {\n\tforeach ( qw(Hsp_qseq Hsp_midline Hsp_hseq) ) {\n\t    $self->element({'Name' => $_,\n\t\t\t    'Data' => $self->{'_last_hspdata'}->{$_}});\n\t}\n\t$self->{'_last_hspdata'} = {}\n    }\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\t    \n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) { \t\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\t    \n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else { \n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'WABAOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;   \n\n   return unless ( defined $data->{'Data'} );\n   if( $data->{'Data'} =~ /^\\s+$/ ) {\n       return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n   }\n\n   if( $self->in_element('hsp') && \n       $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ ) {\n       \n       $self->{'_last_hspdata'}->{$data->{'Name'}} .= $data->{'Data'};\n   }  \n   \n   $self->{'_last_data'} = $data->{'Data'}; \n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element{\n   my ($self,$name) = @_;  \n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       } \n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element{\n   my ($self,$name) = @_;  \n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]}},{"containerName":"main::","name":"result_count","children":[{"line":522,"name":"$self","localvar":"my","containerName":"result_count","kind":13,"definition":"my"},{"line":523,"kind":13,"containerName":"result_count","name":"$self"}],"definition":"sub","range":{"start":{"character":0,"line":521},"end":{"line":524,"character":9999}},"kind":12,"line":521},{"definition":"sub","children":[{"name":"result_count","containerName":"report_count","kind":12,"line":526}],"name":"report_count","containerName":"main::","line":526,"range":{"start":{"line":526,"character":0},"end":{"line":526,"character":9999}},"kind":12}]}