{"vars":[{"kind":2,"containerName":"","name":"base","line":75},{"line":77,"localvar":"my","kind":13,"containerName":null,"name":"%MODEMAP","definition":"my"},{"line":83,"name":"%MAPPING","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":138,"localvar":"my","containerName":null,"kind":13,"name":"$MINSCORE","definition":"my"},{"name":"$DEFAULT_VERSION","containerName":null,"localvar":"my","kind":13,"line":139,"definition":"my"},{"localvar":"my","containerName":null,"kind":13,"name":"$DEFAULT_ALGORITHM","line":140,"definition":"my"},{"line":157,"kind":12,"range":{"end":{"character":9999,"line":194},"start":{"line":157,"character":0}},"signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"line":158,"name":"$self","containerName":"_initialize","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_initialize","name":"@args","line":158},{"name":"$self","containerName":"_initialize","kind":13,"line":159},{"containerName":"_initialize","kind":13,"name":"@args","line":159},{"definition":"my","line":160,"kind":13,"localvar":"my","containerName":"_initialize","name":"$cutoff"},{"line":160,"containerName":"_initialize","kind":13,"name":"$accession"},{"name":"$version","containerName":"_initialize","kind":13,"line":160},{"line":161,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"_rearrange","kind":12,"containerName":"_initialize","line":161},{"line":161,"kind":13,"containerName":"_initialize","name":"@args"},{"definition":"my","name":"$handler","containerName":"_initialize","localvar":"my","kind":13,"line":162},{"line":162,"name":"$self","kind":13,"containerName":"_initialize"},{"line":162,"name":"_eventHandler","containerName":"_initialize","kind":12},{"kind":13,"containerName":"_initialize","name":"$handler","line":163},{"line":163,"name":"register_factory","kind":12,"containerName":"_initialize"},{"line":165,"kind":12,"containerName":"_initialize","name":"new"},{"line":168,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"verbose","kind":12,"containerName":"_initialize","line":168},{"name":"$handler","containerName":"_initialize","kind":13,"line":172},{"name":"register_factory","containerName":"_initialize","kind":12,"line":172},{"kind":12,"containerName":"_initialize","name":"new","line":174},{"name":"$self","containerName":"_initialize","kind":13,"line":177},{"line":177,"containerName":"_initialize","kind":12,"name":"verbose"},{"line":181,"name":"$handler","containerName":"_initialize","kind":13},{"name":"register_factory","kind":12,"containerName":"_initialize","line":181},{"kind":12,"containerName":"_initialize","name":"new","line":183},{"name":"$self","kind":13,"containerName":"_initialize","line":186},{"line":186,"name":"verbose","containerName":"_initialize","kind":12},{"line":189,"name":"$accession","containerName":"_initialize","kind":13},{"containerName":"_initialize","kind":13,"name":"$self","line":189},{"kind":12,"containerName":"_initialize","name":"query_accession","line":189},{"name":"$accession","kind":13,"containerName":"_initialize","line":189},{"name":"$cutoff","kind":13,"containerName":"_initialize","line":190},{"containerName":"_initialize","kind":13,"name":"$MINSCORE","line":190},{"name":"$self","containerName":"_initialize","kind":13,"line":191},{"line":191,"kind":12,"containerName":"_initialize","name":"hsp_minscore"},{"name":"$cutoff","containerName":"_initialize","kind":13,"line":191},{"name":"$version","kind":13,"containerName":"_initialize","line":192},{"line":192,"name":"$DEFAULT_VERSION","kind":13,"containerName":"_initialize"},{"line":193,"containerName":"_initialize","kind":13,"name":"$self"},{"line":193,"name":"algorithm_version","containerName":"_initialize","kind":12},{"line":193,"name":"$version","kind":13,"containerName":"_initialize"}],"name":"_initialize","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"name":"SUPER","kind":12,"containerName":"_initialize","line":159},{"line":165,"containerName":"Factory::ObjectFactory","kind":12,"name":"Bio"},{"line":174,"name":"Bio","kind":12,"containerName":"Factory::ObjectFactory"},{"name":"Bio","containerName":"Factory::ObjectFactory","kind":12,"line":183},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","containerName":"next_result","kind":13,"name":"$self","line":207,"definition":"my"},{"name":"$seentop","localvar":"my","containerName":"next_result","kind":13,"line":208,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$accession","line":211},{"kind":13,"containerName":"next_result","name":"$self","line":211},{"name":"query_accession","kind":12,"containerName":"next_result","line":211},{"definition":"my","line":212,"localvar":"my","containerName":"next_result","kind":13,"name":"$minscore"},{"name":"$self","kind":13,"containerName":"next_result","line":212},{"kind":12,"containerName":"next_result","name":"hsp_minscore","line":212},{"name":"$version","containerName":"next_result","localvar":"my","kind":13,"line":213,"definition":"my"},{"line":213,"containerName":"next_result","kind":13,"name":"$self"},{"line":213,"name":"algorithm_version","kind":12,"containerName":"next_result"},{"line":214,"name":"$verbose","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":214},{"kind":12,"containerName":"next_result","name":"verbose","line":214},{"kind":13,"containerName":"next_result","name":"$self","line":215},{"line":215,"kind":12,"containerName":"next_result","name":"start_document"},{"line":216,"containerName":"next_result","localvar":"my","kind":13,"name":"$lasthit","definition":"my"},{"line":216,"kind":13,"containerName":"next_result","name":"$lastscore"},{"line":216,"name":"$lastlen","containerName":"next_result","kind":13},{"line":216,"kind":13,"containerName":"next_result","name":"$lasteval"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$line","line":219},{"line":219,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"_readline","line":219},{"line":220,"name":"$line","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$line","line":221},{"line":222,"name":"$seentop","containerName":"next_result","kind":13},{"kind":13,"containerName":"next_result","name":"$self","line":223},{"line":223,"name":"_pushback","containerName":"next_result","kind":12},{"name":"$line","kind":13,"containerName":"next_result","line":223},{"line":226,"kind":13,"containerName":"next_result","name":"$self"},{"line":226,"name":"start_element","containerName":"next_result","kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":227},{"name":"element_hash","containerName":"next_result","kind":12,"line":227},{"line":230,"name":"$version","containerName":"next_result","kind":13},{"name":"$accession","kind":13,"containerName":"next_result","line":231},{"name":"$seentop","containerName":"next_result","kind":13,"line":233},{"line":236,"containerName":"next_result","kind":13,"name":"$line"},{"line":236,"containerName":"next_result","kind":13,"name":"$self"},{"line":236,"kind":12,"containerName":"next_result","name":"_readline"},{"line":237,"name":"$line","kind":13,"containerName":"next_result"},{"name":"$line","kind":13,"containerName":"next_result","line":238},{"line":239,"name":"$line","kind":13,"containerName":"next_result"},{"line":240,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_pushback","kind":12,"containerName":"next_result","line":240},{"line":240,"name":"$line","containerName":"next_result","kind":13},{"name":"$line","containerName":"next_result","kind":13,"line":243},{"line":244,"containerName":"next_result","kind":13,"name":"$self"},{"line":244,"containerName":"next_result","kind":12,"name":"element"},{"line":248,"name":"$line","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$self","line":249},{"line":249,"containerName":"next_result","kind":12,"name":"element"},{"line":253,"name":"$line","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":254},{"containerName":"next_result","kind":12,"name":"element","line":254},{"name":"$line","containerName":"next_result","kind":13,"line":258},{"line":259,"name":"$self","containerName":"next_result","kind":13},{"name":"element_hash","containerName":"next_result","kind":12,"line":259},{"name":"$line","containerName":"next_result","kind":13,"line":263},{"line":264,"name":"$self","containerName":"next_result","kind":13},{"line":264,"name":"element","containerName":"next_result","kind":12},{"line":268,"name":"$line","kind":13,"containerName":"next_result"},{"line":269,"name":"$self","kind":13,"containerName":"next_result"},{"kind":12,"containerName":"next_result","name":"element","line":269},{"line":275,"kind":13,"containerName":"next_result","name":"$line"},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$id","line":276},{"line":276,"name":"$desc","kind":13,"containerName":"next_result"},{"line":277,"kind":13,"containerName":"next_result","name":"$desc"},{"name":"$lasthit","containerName":"next_result","kind":13,"line":280},{"kind":13,"containerName":"next_result","name":"$id","line":280},{"name":"$lasthit","containerName":"next_result","kind":13,"line":280},{"name":"$self","kind":13,"containerName":"next_result","line":281},{"kind":12,"containerName":"next_result","name":"within_element","line":281},{"containerName":"next_result","kind":13,"name":"$self","line":282},{"containerName":"next_result","kind":12,"name":"element_hash","line":282},{"line":283,"kind":13,"containerName":"next_result","name":"$lasteval"},{"name":"$lastscore","kind":13,"containerName":"next_result","line":284},{"kind":13,"containerName":"next_result","name":"$lastscore","line":286},{"name":"$self","containerName":"next_result","kind":13,"line":287},{"name":"end_element","kind":12,"containerName":"next_result","line":287},{"kind":13,"containerName":"next_result","name":"$self","line":289},{"line":289,"name":"start_element","containerName":"next_result","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$gi","line":290},{"name":"$acc","containerName":"next_result","kind":13,"line":290},{"line":290,"kind":13,"containerName":"next_result","name":"$ver"},{"line":290,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_get_seq_identifiers","kind":12,"containerName":"next_result","line":290},{"line":290,"containerName":"next_result","kind":13,"name":"$id"},{"name":"$self","containerName":"next_result","kind":13,"line":292},{"name":"element_hash","kind":12,"containerName":"next_result","line":292},{"containerName":"next_result","kind":13,"name":"$id","line":293},{"kind":13,"containerName":"next_result","name":"$gi","line":294},{"name":"$ver","kind":13,"containerName":"next_result","line":295},{"name":"$acc","containerName":"next_result","kind":13,"line":296},{"name":"$acc","containerName":"next_result","kind":13,"line":296},{"name":"$id","containerName":"next_result","kind":13,"line":296},{"line":298,"name":"$desc","containerName":"next_result","kind":13},{"name":"$lasthit","kind":13,"containerName":"next_result","line":300},{"line":300,"name":"$id","containerName":"next_result","kind":13},{"line":301,"name":"$line","containerName":"next_result","kind":13},{"line":301,"containerName":"next_result","kind":13,"name":"$line"},{"name":"$str","kind":13,"localvar":"my","containerName":"next_result","line":302,"definition":"my"},{"name":"$hn","kind":13,"containerName":"next_result","line":302},{"name":"$pos","kind":13,"containerName":"next_result","line":302},{"name":"$score","kind":13,"containerName":"next_result","line":302},{"line":302,"kind":13,"containerName":"next_result","name":"$eval"},{"line":302,"name":"$line","containerName":"next_result","kind":13},{"line":303,"containerName":"next_result","kind":13,"name":"$minscore"},{"containerName":"next_result","kind":13,"name":"$score","line":303},{"line":304,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"start_element","line":304},{"name":"$start","localvar":"my","containerName":"next_result","kind":13,"line":306,"definition":"my"},{"line":306,"containerName":"next_result","kind":13,"name":"$end"},{"line":306,"kind":13,"containerName":"next_result","name":"$pos"},{"line":307,"name":"$start","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$end","line":307},{"line":307,"containerName":"next_result","kind":13,"name":"$end"},{"line":307,"containerName":"next_result","kind":13,"name":"$start"},{"line":307,"name":"$str","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$line","line":308},{"line":308,"containerName":"next_result","kind":13,"name":"$self"},{"kind":12,"containerName":"next_result","name":"_readline","line":308},{"name":"$line","kind":13,"containerName":"next_result","line":309},{"line":310,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element_hash","kind":12,"containerName":"next_result","line":310},{"containerName":"next_result","kind":13,"name":"$start","line":312},{"line":313,"containerName":"next_result","kind":13,"name":"$end"},{"line":314,"kind":13,"containerName":"next_result","name":"$score"},{"line":315,"name":"$score","kind":13,"containerName":"next_result"},{"line":316,"containerName":"next_result","kind":13,"name":"$eval"},{"name":"$line","kind":13,"containerName":"next_result","line":318},{"line":319,"name":"$line","containerName":"next_result","kind":13},{"line":321,"kind":13,"containerName":"next_result","name":"$line"},{"line":322,"kind":13,"containerName":"next_result","name":"$self"},{"line":322,"name":"end_element","containerName":"next_result","kind":12},{"line":323,"containerName":"next_result","kind":13,"name":"$lastscore"},{"line":323,"name":"$score","kind":13,"containerName":"next_result"},{"name":"$lastscore","kind":13,"containerName":"next_result","line":323},{"line":323,"kind":13,"containerName":"next_result","name":"$lastscore"},{"containerName":"next_result","kind":13,"name":"$score","line":323},{"name":"$lasteval","kind":13,"containerName":"next_result","line":324},{"kind":13,"containerName":"next_result","name":"$eval","line":324},{"containerName":"next_result","kind":13,"name":"$lasteval","line":324},{"line":324,"name":"$lasteval","kind":13,"containerName":"next_result"},{"line":324,"name":"$eval","kind":13,"containerName":"next_result"},{"line":330,"name":"$seentop","containerName":"next_result","kind":13},{"line":331,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"within_element","line":331},{"line":332,"name":"$self","kind":13,"containerName":"next_result"},{"name":"element_hash","containerName":"next_result","kind":12,"line":332},{"line":333,"name":"$lasteval","containerName":"next_result","kind":13},{"line":334,"name":"$lastscore","kind":13,"containerName":"next_result"},{"name":"$lastscore","containerName":"next_result","kind":13,"line":336},{"kind":13,"containerName":"next_result","name":"$self","line":337},{"kind":12,"containerName":"next_result","name":"end_element","line":337},{"containerName":"next_result","kind":13,"name":"$self","line":339},{"line":339,"name":"end_element","containerName":"next_result","kind":12},{"line":341,"containerName":"next_result","kind":13,"name":"$self"},{"line":341,"name":"end_document","containerName":"next_result","kind":12}],"containerName":"main::","name":"next_result","signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"line":206,"range":{"end":{"character":9999,"line":342},"start":{"line":206,"character":0}},"kind":12},{"name":"PARSER","kind":12,"line":218},{"kind":12,"name":"PARSER","line":224},{"line":235,"name":"HEADER","kind":12},{"kind":12,"name":"HEADER","line":241},{"line":354,"kind":12,"range":{"start":{"character":0,"line":354},"end":{"line":366,"character":9999}},"signature":{"label":"start_element($self,$data)","documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"children":[{"line":355,"name":"$self","localvar":"my","containerName":"start_element","kind":13,"definition":"my"},{"kind":13,"containerName":"start_element","name":"$data","line":355},{"localvar":"my","kind":13,"containerName":"start_element","name":"$nm","line":358,"definition":"my"},{"line":358,"name":"$data","containerName":"start_element","kind":13},{"definition":"my","localvar":"my","containerName":"start_element","kind":13,"name":"$type","line":359},{"kind":13,"containerName":"start_element","name":"$MODEMAP","line":359},{"line":359,"name":"$nm","containerName":"start_element","kind":13},{"containerName":"start_element","kind":13,"name":"$type","line":360},{"containerName":"start_element","kind":13,"name":"$self","line":361},{"kind":12,"containerName":"start_element","name":"_eventHandler","line":361},{"line":361,"name":"will_handle","containerName":"start_element","kind":12},{"line":361,"containerName":"start_element","kind":13,"name":"$type"},{"line":362,"localvar":"my","containerName":"start_element","kind":13,"name":"$func","definition":"my"},{"line":362,"containerName":"start_element","kind":13,"name":"$type"},{"line":363,"name":"$self","containerName":"start_element","kind":13},{"containerName":"start_element","kind":12,"name":"_eventHandler","line":363},{"line":363,"name":"$func","kind":13,"containerName":"start_element"},{"line":363,"name":"$data","kind":13,"containerName":"start_element"},{"line":365,"name":"$self","kind":13,"containerName":"start_element"},{"line":365,"kind":13,"containerName":"start_element","name":"$type"}],"name":"start_element","containerName":"main::","definition":"sub","detail":"($self,$data)"},{"name":"$type","containerName":null,"kind":13,"line":368},{"line":368,"name":"%type","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":370},{"kind":13,"containerName":null,"name":"%self","line":371},{"line":386,"range":{"start":{"line":386,"character":0},"end":{"character":9999,"line":399}},"kind":12,"signature":{"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"end_element($self,$data)"},"children":[{"containerName":"end_element","localvar":"my","kind":13,"name":"$self","line":387,"definition":"my"},{"name":"$data","kind":13,"containerName":"end_element","line":387},{"name":"$nm","kind":13,"localvar":"my","containerName":"end_element","line":388,"definition":"my"},{"line":388,"kind":13,"containerName":"end_element","name":"$data"},{"containerName":"end_element","localvar":"my","kind":13,"name":"$type","line":389,"definition":"my"},{"line":389,"kind":13,"containerName":"end_element","name":"$MODEMAP"},{"line":389,"containerName":"end_element","kind":13,"name":"$nm"},{"name":"$rc","localvar":"my","kind":13,"containerName":"end_element","line":390,"definition":"my"},{"line":392,"containerName":"end_element","kind":13,"name":"$type"},{"containerName":"end_element","kind":13,"name":"$self","line":393},{"line":393,"containerName":"end_element","kind":12,"name":"_eventHandler"},{"line":393,"name":"will_handle","kind":12,"containerName":"end_element"},{"line":393,"name":"$type","kind":13,"containerName":"end_element"},{"definition":"my","line":394,"name":"$func","localvar":"my","kind":13,"containerName":"end_element"},{"kind":13,"containerName":"end_element","name":"$type","line":394},{"line":395,"kind":13,"containerName":"end_element","name":"$rc"},{"kind":13,"containerName":"end_element","name":"$self","line":395},{"line":395,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"name":"$func","kind":13,"containerName":"end_element","line":395},{"line":395,"kind":13,"containerName":"end_element","name":"$self"},{"kind":13,"containerName":"end_element","name":"$self","line":396},{"definition":"my","localvar":"my","containerName":"end_element","kind":13,"name":"$lastelem","line":398},{"line":398,"kind":13,"containerName":"end_element","name":"$self"}],"name":"end_element","containerName":"main::","definition":"sub","detail":"($self,$data)"},{"line":400,"kind":13,"containerName":null,"name":"%MAPPING"},{"line":400,"kind":13,"containerName":null,"name":"%nm"},{"name":"%MAPPING","containerName":null,"kind":13,"line":401},{"line":401,"containerName":null,"kind":13,"name":"%nm"},{"line":402,"localvar":"my","kind":13,"containerName":null,"name":"$key","definition":"my"},{"line":402,"containerName":null,"kind":13,"name":"%MAPPING"},{"line":402,"kind":13,"containerName":null,"name":"@nm"},{"line":403,"containerName":null,"kind":13,"name":"%self"},{"line":403,"name":"%key","containerName":null,"kind":13},{"name":"%MAPPING","containerName":null,"kind":13,"line":403},{"name":"%nm","kind":13,"containerName":null,"line":403},{"line":403,"kind":13,"containerName":null,"name":"$key"},{"name":"%self","kind":13,"containerName":null,"line":404},{"line":407,"containerName":null,"kind":13,"name":"%self"},{"line":407,"name":"%MAPPING","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$nm","line":407},{"kind":13,"containerName":null,"name":"%self","line":407},{"line":411,"kind":13,"containerName":null,"name":"$self"},{"name":"debug","containerName":"main::","kind":12,"line":411},{"line":413,"name":"%self","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":415},{"containerName":null,"kind":13,"name":"$rc","line":415},{"line":415,"containerName":null,"kind":13,"name":"$type"},{"line":415,"containerName":null,"kind":13,"name":"$type"},{"kind":13,"containerName":null,"name":"$rc","line":416},{"definition":"sub","detail":"($self,$data)","children":[{"containerName":"element","localvar":"my","kind":13,"name":"$self","line":431,"definition":"my"},{"containerName":"element","kind":13,"name":"$data","line":431},{"kind":13,"containerName":"element","name":"$self","line":433},{"line":433,"kind":12,"containerName":"element","name":"characters"},{"line":433,"kind":13,"containerName":"element","name":"$data"},{"line":434,"kind":13,"containerName":"element","name":"$self"},{"line":434,"kind":12,"containerName":"element","name":"end_element"},{"name":"$data","kind":13,"containerName":"element","line":434}],"containerName":"main::","name":"element","signature":{"label":"element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'"},"line":430,"kind":12,"range":{"start":{"line":430,"character":0},"end":{"character":9999,"line":435}}},{"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"element_hash","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"element_hash","line":451,"definition":"my"},{"line":451,"name":"$data","kind":13,"containerName":"element_hash"},{"line":452,"name":"$self","kind":13,"containerName":"element_hash"},{"line":452,"kind":12,"containerName":"element_hash","name":"throw"},{"line":452,"name":"$data","kind":13,"containerName":"element_hash"},{"line":452,"name":"$data","containerName":"element_hash","kind":13},{"definition":"my","line":453,"name":"$nm","kind":13,"localvar":"my","containerName":"element_hash"},{"kind":13,"containerName":"element_hash","name":"$data","line":453}],"signature":{"label":"element_hash($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value"},"kind":12,"range":{"start":{"line":450,"character":0},"end":{"character":9999,"line":453}},"line":450},{"line":454,"kind":13,"containerName":null,"name":"%data"},{"name":"$nm","kind":13,"containerName":null,"line":454},{"line":454,"name":"%data","kind":13,"containerName":null},{"name":"$nm","kind":13,"containerName":null,"line":454},{"name":"%MAPPING","containerName":null,"kind":13,"line":455},{"kind":13,"containerName":null,"name":"%nm","line":455},{"line":456,"containerName":null,"kind":13,"name":"%MAPPING"},{"containerName":null,"kind":13,"name":"%nm","line":456},{"line":457,"name":"$key","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":null,"name":"%MAPPING","line":457},{"line":457,"name":"@nm","kind":13,"containerName":null},{"line":458,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%key","line":458},{"name":"%MAPPING","kind":13,"containerName":null,"line":458},{"containerName":null,"kind":13,"name":"%nm","line":458},{"kind":13,"containerName":null,"name":"$key","line":458},{"kind":13,"containerName":null,"name":"%data","line":459},{"line":459,"containerName":null,"kind":13,"name":"%nm"},{"line":462,"containerName":null,"kind":13,"name":"%self"},{"line":462,"containerName":null,"kind":13,"name":"%MAPPING"},{"kind":13,"containerName":null,"name":"$nm","line":462},{"line":462,"name":"%data","kind":13,"containerName":null},{"line":462,"name":"$nm","containerName":null,"kind":13},{"definition":"sub","detail":"($self,$data)","children":[{"line":480,"localvar":"my","containerName":"characters","kind":13,"name":"$self","definition":"my"},{"line":480,"name":"$data","containerName":"characters","kind":13},{"line":481,"name":"$data","kind":13,"containerName":"characters"},{"kind":13,"containerName":"characters","name":"$data","line":481},{"containerName":"characters","kind":13,"name":"$self","line":482},{"line":482,"kind":13,"containerName":"characters","name":"$data"}],"containerName":"main::","name":"characters","signature":{"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"},"line":479,"range":{"start":{"character":0,"line":479},"end":{"line":483,"character":9999}},"kind":12},{"detail":"($self,$name)","definition":"sub","containerName":"main::","name":"within_element","children":[{"definition":"my","line":498,"localvar":"my","kind":13,"containerName":"within_element","name":"$self"},{"name":"$name","containerName":"within_element","kind":13,"line":498},{"line":501,"name":"$name","kind":13,"containerName":"within_element"},{"line":501,"name":"$self","containerName":"within_element","kind":13},{"name":"$self","kind":13,"containerName":"within_element","line":502}],"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","label":"within_element($self,$name)"},"kind":12,"range":{"end":{"line":502,"character":9999},"start":{"line":497,"character":0}},"line":497},{"line":503,"name":"%self","containerName":null,"kind":13},{"line":504,"name":"$name","kind":13,"containerName":null},{"name":"in_element","containerName":"main::","children":[{"line":522,"name":"$self","containerName":"in_element","localvar":"my","kind":13,"definition":"my"},{"line":522,"containerName":"in_element","kind":13,"name":"$name"},{"line":523,"name":"$self","kind":13,"containerName":"in_element"},{"line":524,"containerName":"in_element","kind":13,"name":"$self"},{"line":524,"name":"$name","kind":13,"containerName":"in_element"}],"detail":"($self,$name)","definition":"sub","range":{"end":{"line":525,"character":9999},"start":{"line":521,"character":0}},"kind":12,"line":521,"signature":{"label":"in_element($self,$name)","documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]}},{"name":"start_document","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"start_document","kind":13,"line":538,"definition":"my"},{"line":539,"name":"$self","containerName":"start_document","kind":13},{"containerName":"start_document","kind":13,"name":"$self","line":540},{"line":541,"containerName":"start_document","kind":13,"name":"$self"},{"containerName":"start_document","kind":13,"name":"$self","line":542}],"detail":"($self)","definition":"sub","range":{"start":{"line":537,"character":0},"end":{"line":543,"character":9999}},"kind":12,"line":537,"signature":{"label":"start_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none"}},{"signature":{"label":"end_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: erpin.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::erpin\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::erpin - SearchIO-based ERPIN parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is an experimental SearchIO-based parser for output from\nthe erpin program.  It currently parses erpin output for ERPIN\nversions 4.2.5 and above; older versions may work but will not be supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::erpin;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # no evalues yet\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', #\n        'Hsp_hit-to'      => 'HSP-hit_end', #\n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        # not supported yet\n        'Hsp_positive'    => 'HSP-conserved',\n        'Hsp_identity'    => 'HSP-identical',\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # none yet\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'ERPIN_program'  => 'RESULT-algorithm_name', # get/set \n        'ERPIN_version'  => 'RESULT-algorithm_version', # get/set \n        'ERPIN_query-def'=> 'RESULT-query_name', # get/set \n        'ERPIN_query-len'=> 'RESULT-query_length', \n        'ERPIN_query-acc'=> 'RESULT-query_accession', # get/set \n        'ERPIN_querydesc'=> 'RESULT-query_description', # get/set\n        'ERPIN_db'       => 'RESULT-database_name',  # get/set \n        'ERPIN_db-len'   => 'RESULT-database_entries', # none yet\n        'ERPIN_db-let'   => 'RESULT-database_letters', # none yet\n        \n        'Parameters_cutoff'      => { 'RESULT-parameters' => 'cutoff' },\n        'Parameters_expect'      => { 'RESULT-parameters' => 'expect' },\n        \n        'Parameters_include'     => { 'RESULT-parameters' => 'include' },\n        'Parameters_sc-match'    => { 'RESULT-parameters' => 'match' },\n        'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch' },\n        'Parameters_gap-open'    => { 'RESULT-parameters' => 'gapopen' },\n        'Parameters_gap-extend'  => { 'RESULT-parameters' => 'gapext' },\n        'Parameters_filter'      => { 'RESULT-parameters' => 'filter' },\n        'Parameters_allowgaps'   => { 'RESULT-parameters' => 'allowgaps' },\n        'Parameters_full_dbpath' => { 'RESULT-parameters' => 'full_dbpath' },        \n        'Statistics_db-let'      => { 'RESULT-statistics' => 'dbletters' },\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_VERSION = '4.2.5';\nmy $DEFAULT_ALGORITHM = 'erpin';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file     => cmsearch (infernal) filename\n           -format       => 'erpin'\n           -algorithm    => algorithm (default 'Infernal')\n           -query_acc    => query accession, eg. Rfam accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -version      => ERPIN version (not reported in output)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($cutoff, $accession, $version) =\n       $self->_rearrange([qw(HSP_MINSCORE QUERY_ACC VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose()\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose()\n        )\n    );\n    $accession && $self->query_accession($accession);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my $accession = $self->query_accession;\n    my $minscore = $self->hsp_minscore;\n    my $version = $self->algorithm_version;\n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    my ($lasthit, $lastscore, $lastlen, $lasteval);\n    #my $hitline;\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        next if $line =~ m{^\\s*$};\n        if ($line =~ m{^Training\\sset:\\s+\"(.*)\"}xmso) {\n            if ($seentop) {\n                $self->_pushback($line);\n                last PARSER;\n            }\n            $self->start_element({'Name' => 'Result'});\n            $self->element_hash( {\n                'ERPIN_query-def'   => $1,\n                'ERPIN_program'     =>'erpin',\n                'ERPIN_version'     => $version,\n                'ERPIN_query-acc'   => $accession,\n                });\n            $seentop = 1;\n            # parse rest of header here\n            HEADER:\n            while (defined ($line = $self->_readline) ) {\n                next if $line =~ m{^\\s*$};\n                if (index($line, '>') == 0 ||\n                    index($line, '-------- at level 1 --------') == 0) {\n                    $self->_pushback($line);\n                    last HEADER;\n                }\n                if ($line =~ m{^\\s+(\\d+\\ssequences\\sof\\slength\\s\\d+)}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_querydesc',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^Cutoff:\\s+(\\S+)}xmso) {\n                    $self->element(\n                        {'Name' => 'Parameters_cutoff',\n                         'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^Database:\\s+\"(.*)\"}xmso) {\n                    $self->element(\n                        {'Name' => 'ERPIN_db',\n                         'Data' => $1}\n                       );\n                } elsif ($line =~ m{^\\s+(\\d+)\\snucleotides\\sto\\sbe\\sprocessed\\sin\\s(\\d+)\\ssequences}xmso) {\n                    $self->element_hash(\n                        {'ERPIN_db-len' => $2,\n                         'ERPIN_db-let' => $1}\n                       );\n                } elsif ($line =~ m{^E-value\\sat\\scutoff\\s\\S+\\sfor\\s\\S+\\sdouble\\sstrand\\sdata:\\s+(\\S+)}xmso) {\n                    $self->element(\n                                   {'Name' => 'Parameters_expect',\n                                    'Data' => $1}\n                                  );\n                } elsif ($line =~ m{^\\s+(ATGC\\sratios:\\s+(?:\\S+\\s+\\S+\\s+\\S+\\s+\\S+))}) {\n                    $self->element(\n                                   {'Name' => 'Statistics_db-let',\n                                    'Data' => $1}\n                                  );\n                }\n            }\n        } elsif ($line =~ m{^>(\\S+)\\s+(.*)}xmso ) {\n            my ($id, $desc) = ($1, $2);\n            chomp $desc;\n            # desc line is repeated for each strand, so must check\n            # prior to starting a new hit\n            if (!$lasthit || $id ne $lasthit) {\n                if ($self->within_element('hit') ) {\n                    $self->element_hash({\n                        'Hit_signif' => $lasteval,\n                        'Hit_score'  => $lastscore,\n                        'Hit_bits'   => $lastscore\n                        });\n                    $self->end_element({'Name' => 'Hit'});\n                }                \n                $self->start_element({'Name' => 'Hit'});\n                my ($gi, $acc, $ver) = $self->_get_seq_identifiers($id);\n            \n                $self->element_hash({\n                    'Hit_id'        => $id,\n                    'Hit_gi'        => $gi,\n                    'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                        $acc ? $acc : $id,\n                    'Hit_def'       => $desc\n                    });\n            }\n            $lasthit = $id;\n        } elsif ( (index($line, 'FW') == 0) || (index($line, 'RC') == 0)) {\n            my ($str, $hn, $pos, $score, $eval) = split ' ', $line;\n            if ($minscore < $score) {\n                $self->start_element({'Name' => 'Hsp'});\n                \n                my ($start, $end) = split m{\\.\\.}, $pos, 2;\n                ($start, $end) = ($end, $start) if ($str eq 'RC');\n                $line = $self->_readline;\n                chomp $line;\n                $self->element_hash({\n                    'Hsp_stranded'     => 'HIT',\n                    'Hsp_hit-from'     => $start,\n                    'Hsp_hit-to'       => $end,\n                    'Hsp_score'        => $score,\n                    'Hsp_bit-score'    => $score,\n                    'Hsp_evalue'       => $eval,\n                    'Hsp_query-from'   => 1,\n                    'Hsp_query-to'     => length($line),\n                    'Hsp_align-len'    => length($line),\n                    'Hsp_hseq'         =>$line\n                    });\n                $self->end_element({'Name' => 'Hsp'});\n                $lastscore = $score if (!$lastscore || $lastscore < $score);\n                $lasteval = $eval if (!$lasteval || $lasteval > $eval);\n            }\n        } else {\n            #$self->debug(\"Dropped data: $line\");\n        }\n    }\n    if ($seentop) {\n        if ($self->within_element('hit')) {\n            $self->element_hash({\n                    'Hit_signif'    => $lasteval,\n                    'Hit_score'     => $lastscore,\n                    'Hit_bits'      => $lastscore\n                    });\n            $self->end_element({'Name' => 'Hit'}); \n        }\n        $self->end_element({'Name' => 'Result'});\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"kind":12,"range":{"start":{"line":555,"character":0},"end":{"line":558,"character":9999}},"line":555,"detail":"($self)","definition":"sub","containerName":"main::","name":"end_document","children":[{"definition":"my","line":556,"containerName":"end_document","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"end_document","line":557}]},{"range":{"start":{"line":570,"character":0},"end":{"line":573,"character":9999}},"kind":12,"line":570,"name":"result_count","containerName":"main::","children":[{"definition":"my","line":571,"kind":13,"localvar":"my","containerName":"result_count","name":"$self"},{"name":"$self","kind":13,"containerName":"result_count","line":572}],"definition":"sub"},{"definition":"sub","children":[{"containerName":"query_accession","localvar":"my","kind":13,"name":"$self","line":587,"definition":"my"},{"line":588,"name":"$self","kind":13,"containerName":"query_accession"},{"containerName":"query_accession","kind":13,"name":"$self","line":589}],"containerName":"main::","name":"query_accession","line":586,"kind":12,"range":{"start":{"character":0,"line":586},"end":{"character":9999,"line":590}}},{"range":{"start":{"character":0,"line":602},"end":{"character":9999,"line":606}},"kind":12,"line":602,"definition":"sub","name":"hsp_minscore","containerName":"main::","children":[{"definition":"my","line":603,"localvar":"my","kind":13,"containerName":"hsp_minscore","name":"$self"},{"name":"$self","containerName":"hsp_minscore","kind":13,"line":604},{"line":605,"kind":13,"containerName":"hsp_minscore","name":"$self"}]},{"line":618,"kind":12,"range":{"start":{"character":0,"line":618},"end":{"character":9999,"line":622}},"children":[{"line":619,"kind":13,"localvar":"my","containerName":"algorithm_version","name":"$self","definition":"my"},{"containerName":"algorithm_version","kind":13,"name":"$self","line":620},{"name":"$self","kind":13,"containerName":"algorithm_version","line":621}],"containerName":"main::","name":"algorithm_version","definition":"sub"}],"version":5}