{"vars":[{"line":83,"name":"base","containerName":"","kind":2},{"line":85,"localvar":"my","kind":13,"containerName":null,"name":"%MODEMAP","definition":"my"},{"line":94,"name":"%MAPPING","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"definition":"my","line":154,"name":"%IGNOREDTAGS","kind":13,"localvar":"my","containerName":null},{"detail":"($self)","definition":"sub","containerName":"main::","name":"start_document","children":[{"definition":"my","line":184,"kind":13,"localvar":"my","containerName":"start_document","name":"$self"},{"containerName":"start_document","kind":13,"name":"$self","line":185},{"name":"$self","containerName":"start_document","kind":13,"line":186},{"line":187,"containerName":"start_document","kind":13,"name":"$self"}],"signature":{"label":"start_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PsiBlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::PsiBlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::PsiBlastHandler - XML Handler for NCBI Blast PSIBLAST XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST PSIBLAST XML parsing. Currently it passes\nelements off to the event handler, which is ultimately responsible for\nBio::Search object generation.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::PsiBlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n    'BlastOutput'   => 'result',\n    'Iteration'     => 'iteration',\n    'Hit'           => 'hit',\n    'Hsp'           => 'hsp'\n);\n\n# MAPPING is distinct from BlastHandler, can't really mix the two...\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',\n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n\n                # Iteration-specific parameters\n                'Iteration_iter-num'  => 'ITERATION-number',\n                'Iteration_converged' => 'ITERATION-converged',\n\n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,\n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none"},"kind":12,"range":{"start":{"character":0,"line":183},"end":{"line":188,"character":9999}},"line":183},{"detail":"($self,@args)","definition":"sub","name":"end_document","containerName":"main::","children":[{"line":201,"name":"$self","localvar":"my","kind":13,"containerName":"end_document","definition":"my"},{"line":201,"name":"@args","containerName":"end_document","kind":13},{"line":204,"kind":13,"containerName":"end_document","name":"$self"},{"line":207,"containerName":"end_document","kind":13,"name":"$self"}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PsiBlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::PsiBlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::PsiBlastHandler - XML Handler for NCBI Blast PSIBLAST XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST PSIBLAST XML parsing. Currently it passes\nelements off to the event handler, which is ultimately responsible for\nBio::Search object generation.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::PsiBlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n    'BlastOutput'   => 'result',\n    'Iteration'     => 'iteration',\n    'Hit'           => 'hit',\n    'Hsp'           => 'hsp'\n);\n\n# MAPPING is distinct from BlastHandler, can't really mix the two...\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',\n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n\n                # Iteration-specific parameters\n                'Iteration_iter-num'  => 'ITERATION-number',\n                'Iteration_converged' => 'ITERATION-converged',\n\n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,\n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $parser->end_document;\n Function: SAX method to indicate finishing parsing a new document\n Returns : Bio::Search::Result::ResultI object\n Args    : none","label":"end_document($self,@args)"},"range":{"start":{"character":0,"line":200},"end":{"character":9999,"line":208}},"kind":12,"line":200},{"definition":"sub","detail":"($self,$data)","children":[{"line":221,"name":"$self","localvar":"my","containerName":"start_element","kind":13,"definition":"my"},{"name":"$data","containerName":"start_element","kind":13,"line":221},{"definition":"my","name":"$nm","kind":13,"localvar":"my","containerName":"start_element","line":223},{"containerName":"start_element","kind":13,"name":"$data","line":223},{"line":225,"kind":13,"localvar":"my","containerName":"start_element","name":"$type","definition":"my"},{"name":"$MODEMAP","containerName":"start_element","kind":13,"line":225},{"line":225,"name":"$nm","containerName":"start_element","kind":13},{"containerName":"start_element","kind":13,"name":"$self","line":226},{"line":226,"containerName":"start_element","kind":12,"name":"eventHandler"},{"kind":12,"containerName":"start_element","name":"will_handle","line":226},{"line":226,"containerName":"start_element","kind":13,"name":"$type"},{"definition":"my","name":"$func","localvar":"my","containerName":"start_element","kind":13,"line":227},{"line":227,"containerName":"start_element","kind":13,"name":"$type"},{"kind":13,"containerName":"start_element","name":"$self","line":228},{"line":228,"kind":12,"containerName":"start_element","name":"eventHandler"},{"line":228,"containerName":"start_element","kind":13,"name":"$func"},{"containerName":"start_element","kind":13,"name":"$data","line":228}],"containerName":"main::","name":"start_element","signature":{"label":"start_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: PsiBlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::PsiBlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::PsiBlastHandler - XML Handler for NCBI Blast PSIBLAST XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST PSIBLAST XML parsing. Currently it passes\nelements off to the event handler, which is ultimately responsible for\nBio::Search object generation.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::PsiBlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n    'BlastOutput'   => 'result',\n    'Iteration'     => 'iteration',\n    'Hit'           => 'hit',\n    'Hsp'           => 'hsp'\n);\n\n# MAPPING is distinct from BlastHandler, can't really mix the two...\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',\n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n\n                # Iteration-specific parameters\n                'Iteration_iter-num'  => 'ITERATION-number',\n                'Iteration_converged' => 'ITERATION-converged',\n\n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,\n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $parser->end_document;\n Function: SAX method to indicate finishing parsing a new document\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   \n   # reset data carried throughout parse\n   $self->{'_resultdata'} = undef;\n   \n   # pass back ref to results queue; caller must reset handler results queue\n   return $self->{'_result'};\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $parser->start_element($data)\n Function: SAX method to indicate starting a new element\n Returns : none\n Args    : hash ref for data"},"line":220,"kind":12,"range":{"end":{"line":231,"character":9999},"start":{"line":220,"character":0}}},{"signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: PsiBlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::PsiBlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::PsiBlastHandler - XML Handler for NCBI Blast PSIBLAST XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST PSIBLAST XML parsing. Currently it passes\nelements off to the event handler, which is ultimately responsible for\nBio::Search object generation.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::PsiBlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n    'BlastOutput'   => 'result',\n    'Iteration'     => 'iteration',\n    'Hit'           => 'hit',\n    'Hsp'           => 'hsp'\n);\n\n# MAPPING is distinct from BlastHandler, can't really mix the two...\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',\n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n\n                # Iteration-specific parameters\n                'Iteration_iter-num'  => 'ITERATION-number',\n                'Iteration_converged' => 'ITERATION-converged',\n\n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,\n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $parser->end_document;\n Function: SAX method to indicate finishing parsing a new document\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   \n   # reset data carried throughout parse\n   $self->{'_resultdata'} = undef;\n   \n   # pass back ref to results queue; caller must reset handler results queue\n   return $self->{'_result'};\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $parser->start_element($data)\n Function: SAX method to indicate starting a new element\n Returns : none\n Args    : hash ref for data\n\n\nsub start_element{\n    my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n\n    if( my $type = $MODEMAP{$nm} ) {\n        if( $self->eventHandler->will_handle($type) ) {\n            my $func = sprintf(\"start_%s\",lc $type);\n            $self->eventHandler->$func($data->{'Attributes'});\n        }                                                    \n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $parser->end_element($data)\n Function: Signals finishing an element\n Returns : Bio::Search object dpending on what type of element\n Args    : hash ref for data"},"range":{"start":{"line":243,"character":0},"end":{"character":9999,"line":256}},"kind":12,"line":243,"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"end_element","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"end_element","name":"$self","line":244},{"line":244,"name":"$data","containerName":"end_element","kind":13},{"name":"$nm","localvar":"my","containerName":"end_element","kind":13,"line":246,"definition":"my"},{"containerName":"end_element","kind":13,"name":"$data","line":246},{"name":"$rc","localvar":"my","containerName":"end_element","kind":13,"line":247,"definition":"my"},{"name":"$nm","containerName":"end_element","kind":13,"line":248},{"kind":13,"containerName":"end_element","name":"$self","line":249},{"line":250,"name":"$self","containerName":"end_element","kind":13},{"line":252,"name":"$nm","kind":13,"containerName":"end_element"},{"containerName":"end_element","kind":13,"name":"$self","line":254},{"name":"$self","containerName":"end_element","kind":13,"line":254},{"line":255,"containerName":"end_element","kind":13,"name":"$self"}]},{"line":257,"name":"$type","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":257,"containerName":null,"kind":13,"name":"%MODEMAP"},{"containerName":null,"kind":13,"name":"%nm","line":257},{"kind":13,"containerName":null,"name":"$self","line":258},{"line":258,"containerName":"main::","kind":12,"name":"eventHandler"},{"line":258,"name":"will_handle","kind":12,"containerName":"main::"},{"name":"%type","containerName":null,"kind":13,"line":258},{"containerName":null,"localvar":"my","kind":13,"name":"$func","line":259,"definition":"my"},{"line":259,"name":"$type","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$rc","line":260},{"line":260,"name":"$self","containerName":null,"kind":13},{"name":"eventHandler","kind":12,"containerName":"main::","line":260},{"containerName":null,"kind":13,"name":"$func","line":260},{"line":260,"kind":13,"containerName":null,"name":"%self"},{"line":261,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%MAPPING","line":264},{"name":"%nm","kind":13,"containerName":null,"line":264},{"kind":13,"containerName":null,"name":"%MAPPING","line":265},{"line":265,"containerName":null,"kind":13,"name":"%nm"},{"name":"$key","kind":13,"localvar":"my","containerName":null,"line":266,"definition":"my"},{"name":"%MAPPING","kind":13,"containerName":null,"line":266},{"name":"@nm","kind":13,"containerName":null,"line":266},{"name":"%self","containerName":null,"kind":13,"line":267},{"name":"%key","containerName":null,"kind":13,"line":267},{"name":"%MAPPING","kind":13,"containerName":null,"line":267},{"line":267,"kind":13,"containerName":null,"name":"%nm"},{"line":267,"name":"$key","containerName":null,"kind":13},{"line":267,"containerName":null,"kind":13,"name":"%self"},{"name":"%self","kind":13,"containerName":null,"line":269},{"line":269,"name":"%MAPPING","containerName":null,"kind":13},{"name":"$nm","kind":13,"containerName":null,"line":269},{"line":269,"containerName":null,"kind":13,"name":"%self"},{"name":"%IGNOREDTAGS","containerName":null,"kind":13,"line":272},{"line":272,"name":"%nm","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":276},{"name":"debug","containerName":"main::","kind":12,"line":276},{"kind":13,"containerName":null,"name":"%self","line":278},{"line":282,"name":"%self","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$rc","line":282},{"line":282,"kind":13,"containerName":null,"name":"$nm"},{"line":284,"containerName":null,"kind":13,"name":"%nm"},{"line":285,"containerName":null,"kind":13,"name":"%self"},{"detail":"($self,$data)","definition":"sub","containerName":"main::","name":"characters","children":[{"definition":"my","containerName":"characters","localvar":"my","kind":13,"name":"$self","line":301},{"containerName":"characters","kind":13,"name":"$data","line":301},{"line":302,"containerName":"characters","kind":13,"name":"$data"},{"line":302,"containerName":"characters","kind":13,"name":"$data"},{"line":303,"name":"$self","containerName":"characters","kind":13},{"containerName":"characters","kind":13,"name":"$data","line":303}],"signature":{"label":"characters($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: PsiBlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::PsiBlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::PsiBlastHandler - XML Handler for NCBI Blast PSIBLAST XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST PSIBLAST XML parsing. Currently it passes\nelements off to the event handler, which is ultimately responsible for\nBio::Search object generation.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::PsiBlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n    'BlastOutput'   => 'result',\n    'Iteration'     => 'iteration',\n    'Hit'           => 'hit',\n    'Hsp'           => 'hsp'\n);\n\n# MAPPING is distinct from BlastHandler, can't really mix the two...\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',\n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n\n                # Iteration-specific parameters\n                'Iteration_iter-num'  => 'ITERATION-number',\n                'Iteration_converged' => 'ITERATION-converged',\n\n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,\n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $parser->end_document;\n Function: SAX method to indicate finishing parsing a new document\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   \n   # reset data carried throughout parse\n   $self->{'_resultdata'} = undef;\n   \n   # pass back ref to results queue; caller must reset handler results queue\n   return $self->{'_result'};\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $parser->start_element($data)\n Function: SAX method to indicate starting a new element\n Returns : none\n Args    : hash ref for data\n\n\nsub start_element{\n    my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n\n    if( my $type = $MODEMAP{$nm} ) {\n        if( $self->eventHandler->will_handle($type) ) {\n            my $func = sprintf(\"start_%s\",lc $type);\n            $self->eventHandler->$func($data->{'Attributes'});\n        }                                                    \n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $parser->end_element($data)\n Function: Signals finishing an element\n Returns : Bio::Search object dpending on what type of element\n Args    : hash ref for data\n\n\nsub end_element{\n    my ($self,$data) = @_;\n\n    my $nm = $data->{'Name'};\n    my $rc;\n    if($nm eq 'BlastOutput_program' &&\n       $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n        $self->{'_type'} = uc $1; \n    }\n    if ($nm eq 'Iteration') {\n        map {\n            $self->{'_values'}->{$_} = $self->{'_resultdata'}->{$_};\n            } keys %{ $self->{'_resultdata'} };\n    }\n    if( my $type = $MODEMAP{$nm} ) {\n        if( $self->eventHandler->will_handle($type) ) {\n            my $func = sprintf(\"end_%s\",lc $type);\n            $rc = $self->eventHandler->$func($self->{'_type'},\n                                              $self->{'_values'});\n        }\n    }\n    elsif( exists $MAPPING{$nm} ) {\n        if ( ref($MAPPING{$nm}) =~ /hash/i ) {\n            my $key = (keys %{$MAPPING{$nm}})[0];\n            $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n        } else {\n            $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n        }\n    }\n    elsif( exists $IGNOREDTAGS{$nm} ){\n        # ignores these elements for now\n    }\n    else {      \n        $self->debug(\"ignoring unrecognized element type $nm\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n                                # end of an element\n                                \n    # add to ResultI array\n    $self->{'_result'} = $rc if( $nm eq 'BlastOutput' );\n    # reset values for each Result round\n    if ($nm eq 'BlastOutput') {\n        $self->{'_values'} = {};\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $parser->characters($data)\n Function: Signals new characters to be processed\n Returns : characters read\n Args    : hash ref with the key 'Data'"},"range":{"start":{"character":0,"line":300},"end":{"line":304,"character":9999}},"kind":12,"line":300},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"eventHandler","line":307},{"name":"$self","containerName":"eventHandler","kind":13,"line":308},{"line":309,"name":"$self","containerName":"eventHandler","kind":13}],"name":"eventHandler","containerName":"main::","line":306,"range":{"end":{"line":310,"character":9999},"start":{"line":306,"character":0}},"kind":12}],"version":5}