{"vars":[{"name":"base","kind":2,"containerName":"","line":178},{"name":"%column_map","localvar":"my","containerName":null,"kind":13,"line":188,"definition":"my"},{"line":221,"range":{"start":{"line":221,"character":0},"end":{"line":221,"character":9999}},"kind":12,"children":[{"containerName":"column_map","kind":13,"name":"%column_map","line":221}],"containerName":"main::","name":"column_map","definition":"sub"},{"definition":"sub","detail":"($self,$result,$include_labels)","children":[{"definition":"my","line":245,"containerName":"to_string","localvar":"my","kind":13,"name":"$self"},{"name":"$result","containerName":"to_string","kind":13,"line":245},{"kind":13,"containerName":"to_string","name":"$include_labels","line":245},{"line":247,"name":"$str","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"line":247,"containerName":"to_string","kind":13,"name":"$include_labels"},{"line":247,"containerName":"to_string","kind":13,"name":"$self"},{"kind":12,"containerName":"to_string","name":"column_labels","line":247},{"name":"$resultfilter","containerName":"to_string","localvar":"my","kind":13,"line":248,"definition":"my"},{"line":248,"name":"$hitfilter","kind":13,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$hspfilter","line":249},{"name":"$self","containerName":"to_string","kind":13,"line":249},{"line":249,"kind":12,"containerName":"to_string","name":"filter"},{"line":250,"containerName":"to_string","kind":13,"name":"$self"},{"kind":12,"containerName":"to_string","name":"filter","line":250},{"containerName":"to_string","kind":13,"name":"$self","line":251},{"line":251,"name":"filter","kind":12,"containerName":"to_string"},{"line":252,"kind":13,"containerName":"to_string","name":"$resultfilter"},{"kind":13,"containerName":"to_string","name":"$resultfilter","line":252}],"name":"to_string","containerName":"main::","signature":{"documentation":"1;\n# $Id: HSPTableWriter.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::SearchIO::Writer::HSPTableWriter - Tab-delimited data for Bio::Search::HSP::HSPI objects\n\n=head1 SYNOPSIS\n\n=head2 Example 1: Using the default columns\n\n    use Bio::SearchIO;\n    use Bio::SearchIO::Writer::HSPTableWriter;\n\n    my $in = Bio::SearchIO->new();\n\n    my $writer = Bio::SearchIO::Writer::HSPTableWriter->new();\n\n    my $out = Bio::SearchIO->new( -writer => $writer );\n\n    while ( my $result = $in->next_result() ) {\n        $out->write_result($result, ($in->report_count - 1 ? 0 : 1) );\n    }\n\n=head2 Example 2: Specifying a subset of columns \n\n    use Bio::SearchIO;\n    use Bio::SearchIO::Writer::HSPTableWriter;\n\n    my $in = Bio::SearchIO->new();\n\n    my $writer = Bio::SearchIO::Writer::HSPTableWriter->new( \n                                  -columns => [qw(\n                                                  query_name\n                                                  query_length\n                                                  hit_name\n                                                  hit_length\n                                                  rank\n                                                  frac_identical_query\n                                                  expect\n                                                  )]  );\n\n    my $out = Bio::SearchIO->new( -writer => $writer,\n\t\t\t\t  -file   => \">searchio.out\" );\n\n    while ( my $result = $in->next_result() ) {\n        $out->write_result($result, ($in->report_count - 1 ? 0 : 1) );\n    }\n\n=head2 Custom Labels\n\nYou can also specify different column labels if you don't want to use\nthe defaults.  Do this by specifying a C<-labels> hash reference\nparameter when creating the HSPTableWriter object.  The keys of the\nhash should be the column number (left-most column = 1) for the label(s)\nyou want to specify. Here's an example:\n\n    my $writer = Bio::SearchIO::Writer::HSPTableWriter->new( \n                               -columns => [qw( query_name \n                                                query_length\n                                                hit_name\n                                                hit_length  )],\n                               -labels  => { 1 => 'QUERY_GI',\n  \t                                     3 => 'HIT_IDENTIFIER' } );\n\n\n=head1 DESCRIPTION\n\nBio::SearchIO::Writer::HSPTableWriter generates output at the finest\nlevel of granularity for data within a search result. Data for each HSP\nwithin each hit in a search result is output in tab-delimited format,\none row per HSP.\n\n=head2 Available Columns\n\nHere are the columns that can be specified in the C<-columns>\nparameter when creating a HSPTableWriter object.  If a C<-columns> parameter\nis not specified, this list, in this order, will be used as the default.\n\n    query_name             # Sequence identifier of the query.\n    query_length           # Full length of the query sequence\n    hit_name               # Sequence identifier of the hit\n    hit_length             # Full length of the hit sequence\n    round                  # Round number for hit (PSI-BLAST)\n    rank\n    expect                 # Expect value for the alignment\n    score                  # Score for the alignment (e.g., BLAST score)\n    bits                   # Bit score for the alignment\n    frac_identical_query   # fraction of identical substitutions in query\n    frac_identical_hit     # fraction of identical substitutions in hit\n    frac_conserved_query   # fraction of conserved substitutions in query\n    frac_conserved_hit     # fraction of conserved substitutions in hit\n    length_aln_query       # Length of the aligned portion of the query sequence\n    length_aln_hit         # Length of the aligned portion of the hit sequence\n    gaps_query             # Number of gap characters in the aligned query sequence\n    gaps_hit               # Number of gap characters in the aligned hit sequence\n    gaps_total             # Number of gap characters in the aligned query and hit sequences\n    start_query            # Starting coordinate of the aligned portion of the query sequence\n    end_query              # Ending coordinate of the aligned portion of the query sequence\n    start_hit              # Starting coordinate of the aligned portion of the hit sequence\n    end_hit                # Ending coordinate of the aligned portion of the hit sequence\n    strand_query           # Strand of the aligned query sequence\n    strand_hit             # Strand of the aligned hit sequence\n    frame                  # Reading frame of the aligned query sequence \n    hit_description        # Full description of the hit sequence\n    query_description      # Full description of the query sequence\n    frac_identical_total   # fraction of total identical substitutions\n    frac_conserved_total   # fraction of total conserved substitutions\n\nFor more details about these columns, see the documentation for the\ncorresponding method in Bio::Search::HSP::HSPI.\n\n=head1 TODO\n\nFigure out the best way to incorporate algorithm-specific score columns.\nThe best route is probably to have algorith-specific subclasses \n(e.g., BlastHSPTableWriter, FastaHSPTableWriter).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/           \n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\nSee L<the FEEDBACK section | FEEDBACK> for where to send bug reports\nand comments.\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\nThis library is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 SEE ALSO\n\n    Bio::SearchIO::Writer::HitTableWriter\n    Bio::SearchIO::Writer::ResultTableWriter\n\n=head1 METHODS\n\n\npackage Bio::SearchIO::Writer::HSPTableWriter;\n\nuse strict;\n\nuse base qw(Bio::SearchIO::Writer::ResultTableWriter);\n\n\n# Array fields: column, object, method[/argument], printf format, column label\n# Methods for result object are defined in Bio::Search::Result::ResultI.\n# Methods for hit object are defined in Bio::Search::Hit::HitI.\n# Methods for hsp object are defined in Bio::Search::HSP::HSPI.\n# Tech note: If a bogus method is supplied, it will result in all values to be zero.\n#            Don't know why this is.\n# TODO (maybe): Allow specification of signif_format (i.e., separate mantissa/exponent)\nmy %column_map = (\n                  'query_name'            => ['1', 'result', 'query_name', 's', 'QUERY' ],\n                  'query_length'          => ['2', 'result', 'query_length', 'd', 'LEN_Q'],\n                  'hit_name'              => ['3', 'hit', 'name', 's', 'HIT'],\n                  'hit_length'            => ['4', 'hit', 'hit_length', 'd', 'LEN_H'],\n                  'round'                 => ['5', 'hit', 'iteration', 'd', 'ROUND', 'hit'],\n                  'rank'                  => ['6', 'hsp', 'rank', 'd', 'RANK'],\n                  'expect'                => ['7', 'hsp', 'expect', '.1e', 'EXPCT'],\n                  'score'                 => ['8', 'hsp', 'score', 'd', 'SCORE'],\n                  'bits'                  => ['9', 'hsp', 'bits', 'd', 'BITS'],\n                  'frac_identical_query'  => ['10', 'hsp', 'frac_identical/query', '.2f', 'FR_IDQ'],\n                  'frac_identical_hit'    => ['11', 'hsp', 'frac_identical/hit', '.2f', 'FR_IDH'],\n                  'frac_conserved_query'  => ['12', 'hsp', 'frac_conserved/query', '.2f', 'FR_CNQ'],\n                  'frac_conserved_hit'    => ['13', 'hsp', 'frac_conserved/hit', '.2f', 'FR_CNH'],\n                  'length_aln_query'      => ['14', 'hsp', 'length/query', 'd', 'LN_ALQ'],\n                  'length_aln_hit'        => ['15', 'hsp', 'length/hit', 'd', 'LN_ALH'],\n                  'gaps_query'            => ['16', 'hsp', 'gaps/query', 'd', 'GAPS_Q'],\n                  'gaps_hit'              => ['17', 'hsp', 'gaps/hit', 'd', 'GAPS_H'],\n                  'gaps_total'            => ['18', 'hsp', 'gaps/total', 'd', 'GAPS_QH'],\n                  'start_query'           => ['19', 'hsp', 'start/query', 'd', 'START_Q'],\n                  'end_query'             => ['20', 'hsp', 'end/query', 'd', 'END_Q'],\n                  'start_hit'             => ['21', 'hsp', 'start/hit', 'd', 'START_H'],\n                  'end_hit'               => ['22', 'hsp', 'end/hit', 'd', 'END_H'],\n                  'strand_query'          => ['23', 'hsp', 'strand/query', 'd', 'STRND_Q'],\n                  'strand_hit'            => ['24', 'hsp', 'strand/hit', 'd', 'STRND_H'],\n                  'frame_hit'             => ['25', 'hsp', 'frame/hit', 's', 'FRAME_H'],\n                  'frame_query'           => ['26', 'hsp', 'frame/query', 's', 'FRAME_Q'],\n                  'hit_description'       => ['27', 'hit', 'hit_description', 's', 'DESC_H'],\n                  'query_description'     => ['28', 'result', 'query_description', 's', 'DESC_Q'],\n                  'frac_identical_total'  => ['29', 'hsp', 'frac_identical/total', '.2f', 'FR_IDT'],\n                  'frac_conserved_total'  => ['30', 'hsp', 'frac_conserved/total', '.2f', 'FR_CNT'],\n                 );\n\nsub column_map { return %column_map }\n\n=head2 to_string()\n\nNote: this method is not intended for direct use. \nThe SearchIO::write_result() method calls it automatically \nif the writer is hooked up to a SearchIO object as illustrated in\nL<the SYNOPSIS section | SYNOPSIS>.\n\n Title     : to_string()\n           :\n Usage     : print $writer->to_string( $result_obj, [$include_labels] );\n           :\n Argument  : $result_obj = A Bio::Search::Result::ResultI object\n           : $include_labels = boolean, if true column labels are included (default: false)\n           :\n Returns   : String containing tab-delimited set of data for each HSP\n           : in each Hit of the supplied ResultI object. \n           :\n Throws    : n/a","parameters":[{"label":"$self"},{"label":"$result"},{"label":"$include_labels"}],"label":"to_string($self,$result,$include_labels)"},"line":244,"range":{"start":{"line":244,"character":0},"end":{"character":9999,"line":252}},"kind":12},{"line":252,"name":"%result","containerName":null,"kind":13},{"line":253,"containerName":null,"localvar":"my","kind":13,"name":"$func_ref","definition":"my"},{"line":253,"containerName":null,"kind":13,"name":"$self"},{"line":253,"kind":12,"containerName":"main::","name":"row_data_func"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$printf_fmt","line":254},{"line":254,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"printf_fmt","line":254},{"kind":13,"containerName":null,"name":"$result","line":255},{"name":"can","kind":12,"containerName":"main::","line":255},{"name":"$result","kind":13,"containerName":null,"line":256},{"containerName":"main::","kind":12,"name":"rewind","line":256},{"definition":"my","line":257,"name":"$hit","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"$result","line":257},{"name":"next_hit","kind":12,"containerName":"main::","line":257},{"name":"$hitfilter","kind":13,"containerName":null,"line":258},{"kind":13,"containerName":null,"name":"$hitfilter","line":258},{"kind":13,"containerName":null,"name":"$hit","line":258},{"line":259,"name":"$hit","kind":13,"containerName":null},{"name":"can","kind":12,"containerName":"main::","line":259},{"line":259,"containerName":null,"kind":13,"name":"$hit"},{"line":259,"name":"rewind","kind":12,"containerName":"main::"},{"kind":13,"localvar":"my","containerName":null,"name":"$hsp","line":260,"definition":"my"},{"containerName":null,"kind":13,"name":"$hit","line":260},{"line":260,"name":"next_hsp","kind":12,"containerName":"main::"},{"line":261,"containerName":null,"kind":13,"name":"$hspfilter"},{"line":261,"name":"$hspfilter","containerName":null,"kind":13},{"line":261,"containerName":null,"kind":13,"name":"$hsp"},{"definition":"my","name":"@row_data","kind":13,"localvar":"my","containerName":null,"line":262},{"line":262,"kind":13,"containerName":null,"name":"$func_ref"},{"line":262,"containerName":null,"kind":13,"name":"$result"},{"kind":13,"containerName":null,"name":"$hit","line":262},{"containerName":null,"kind":13,"name":"$hsp","line":262},{"containerName":null,"kind":13,"name":"%str","line":263},{"line":263,"containerName":null,"kind":13,"name":"$printf_fmt"},{"line":263,"containerName":null,"kind":13,"name":"@row_data"},{"line":267,"name":"$str","kind":13,"containerName":null},{"line":268,"kind":13,"containerName":null,"name":"$str"},{"range":{"start":{"character":0,"line":284},"end":{"character":9999,"line":286}},"kind":12,"line":284,"name":"end_report","containerName":"main::","children":[],"definition":"sub"}],"version":5}