{"vars":[{"name":"base","kind":2,"containerName":"","line":81},{"signature":{"documentation":"1;\n# \n#\n# BioPerl module for wrapping runtime parameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla (bioinformatics1 at dieselwurks dot com)\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::StatisticsI - A Base object for statistics\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $void   = $obj->set_statistic(\"statistic_name\",\"statistic_value\"); \n  my $value  = $obj->get_statistic(\"statistic_name\");\n\n=head1 DESCRIPTION\n\nThis is a basic container to hold the statistics returned from a program.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1 at dieselwurks dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::StatisticsI;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : $statistic_object->get_statistic($statistic_name);\n Function: Get the value of a statistic named $statistic_name\n Returns : A scalar that should be a string\n Args    : A scalar that should be a string","parameters":[{"label":"$self"},{"label":"$arg"}],"label":"get_statistic($self,$arg)"},"kind":12,"range":{"start":{"line":94,"character":0},"end":{"character":9999,"line":97}},"line":94,"detail":"($self,$arg)","definition":"sub","name":"get_statistic","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"get_statistic","kind":13,"line":95},{"name":"$arg","containerName":"get_statistic","kind":13,"line":95},{"line":96,"kind":13,"containerName":"get_statistic","name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"get_statistic","line":96}]},{"children":[{"definition":"my","line":111,"name":"$self","localvar":"my","kind":13,"containerName":"set_statistic"},{"line":111,"name":"$name","containerName":"set_statistic","kind":13},{"line":111,"containerName":"set_statistic","kind":13,"name":"$value"},{"line":112,"name":"$self","kind":13,"containerName":"set_statistic"},{"line":112,"name":"throw_not_implemented","kind":12,"containerName":"set_statistic"}],"name":"set_statistic","containerName":"main::","definition":"sub","detail":"($self,$name,$value)","line":110,"kind":12,"range":{"start":{"character":0,"line":110},"end":{"line":113,"character":9999}},"signature":{"documentation":"1;\n# \n#\n# BioPerl module for wrapping runtime parameters\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla (bioinformatics1 at dieselwurks dot com)\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::StatisticsI - A Base object for statistics\n\n=head1 SYNOPSIS\n\n  # do not use this object directly, it provides the following methods\n  # for its subclasses\n\n  my $void   = $obj->set_statistic(\"statistic_name\",\"statistic_value\"); \n  my $value  = $obj->get_statistic(\"statistic_name\");\n\n=head1 DESCRIPTION\n\nThis is a basic container to hold the statistics returned from a program.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1 at dieselwurks dot com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::StatisticsI;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 get_statistic\n\n Title   : get_statistic\n Usage   : $statistic_object->get_statistic($statistic_name);\n Function: Get the value of a statistic named $statistic_name\n Returns : A scalar that should be a string\n Args    : A scalar that should be a string\n\n\nsub get_statistic {\n   my ($self,$arg) = @_;\n     $self->throw_not_implemented;\n}\n\n\n=head2 set_statistic\n\n Title   : set_statistic\n Usage   : $statistic_object->set_statistic($statistic_name => $statistic_value);\n Function: Set the value of a statistic named $statistic_name to $statistic_value\n Returns : Void\n Args    : A hash containing name=>value pairs","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$value"}],"label":"set_statistic($self,$name,$value)"}}],"version":5}