{"vars":[{"name":"base","kind":2,"containerName":"","line":84},{"line":105,"kind":12,"range":{"start":{"line":105,"character":0},"end":{"character":9999,"line":125}},"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: HmmpfamResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::HmmpfamResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::HmmpfamResult - A parser and result object for hmmpfam\n                                     results\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam result output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::HmmpfamResult;\n\nuse strict;\n\nuse Bio::Search::Hit::HmmpfamHit;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::PullResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Result::hmmpfam->new();\n Function: Builds a new Bio::SearchIO::Result::hmmpfam object \n Returns : Bio::SearchIO::Result::hmmpfam\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -parameters => hash ref of search parameters (key => value), optional\n           -statistics => hash ref of search statistics (key => value), optional\n\n\t\t   where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           result, and $start and $end define the tell() position within the\n           filehandle that the result data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)","label":"new($class,@args)"},"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":106},{"name":"@args","containerName":"new","kind":13,"line":106},{"definition":"my","line":107,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"line":107,"containerName":"new","kind":13,"name":"$class"},{"line":107,"kind":13,"containerName":"new","name":"@args"},{"line":109,"name":"$self","kind":13,"containerName":"new"},{"line":109,"name":"_setup","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":109},{"definition":"my","name":"$field","localvar":"my","kind":13,"containerName":"new","line":111},{"line":112,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_fields","line":112},{"line":112,"name":"$field","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":115},{"name":"_dependencies","kind":12,"containerName":"new","line":115},{"line":124,"name":"$self","kind":13,"containerName":"new"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":107,"name":"SUPER","kind":12,"containerName":"new"},{"line":115,"kind":12,"name":"query_name"},{"kind":12,"name":"query_accession","line":116},{"line":117,"name":"query_description","kind":12},{"kind":12,"name":"hit_table","line":118},{"line":119,"kind":12,"name":"num_hits"},{"kind":12,"name":"no_hits_found","line":120},{"kind":12,"name":"hsp_table","line":121},{"kind":12,"name":"next_alignment","line":122},{"line":131,"kind":12,"range":{"end":{"line":146,"character":9999},"start":{"character":0,"line":131}},"definition":"sub","children":[{"definition":"my","line":132,"kind":13,"localvar":"my","containerName":"_discover_header","name":"$self"},{"name":"$self","containerName":"_discover_header","kind":13,"line":133},{"line":133,"name":"_chunk_seek","kind":12,"containerName":"_discover_header"},{"definition":"my","localvar":"my","containerName":"_discover_header","kind":13,"name":"$header","line":134},{"name":"$self","kind":13,"containerName":"_discover_header","line":134},{"containerName":"_discover_header","kind":12,"name":"_get_chunk_by_end","line":134},{"containerName":"_discover_header","kind":13,"name":"$self","line":135},{"line":135,"name":"$self","containerName":"_discover_header","kind":13},{"line":135,"name":"_chunk_tell","kind":12,"containerName":"_discover_header"},{"containerName":"_discover_header","kind":13,"name":"$header","line":137},{"line":137,"name":"$self","kind":13,"containerName":"_discover_header"},{"line":137,"name":"throw","containerName":"_discover_header","kind":12},{"kind":13,"containerName":"_discover_header","name":"$self","line":139},{"name":"_fields","containerName":"_discover_header","kind":12,"line":139},{"line":139,"name":"$header","kind":13,"containerName":"_discover_header"},{"name":"$self","kind":13,"containerName":"_discover_header","line":140},{"kind":12,"containerName":"_discover_header","name":"_fields","line":140},{"containerName":"_discover_header","kind":13,"name":"$header","line":140},{"line":141,"name":"$self","containerName":"_discover_header","kind":13},{"name":"_fields","kind":12,"containerName":"_discover_header","line":141},{"line":141,"kind":13,"containerName":"_discover_header","name":"$header"},{"line":142,"name":"$self","containerName":"_discover_header","kind":13},{"containerName":"_discover_header","kind":12,"name":"_fields","line":142},{"line":143,"name":"$self","containerName":"_discover_header","kind":13},{"name":"_fields","kind":12,"containerName":"_discover_header","line":143},{"name":"$self","containerName":"_discover_header","kind":13,"line":145},{"name":"_fields","kind":12,"containerName":"_discover_header","line":145}],"containerName":"main::","name":"_discover_header"},{"line":135,"kind":12,"name":"_after_header"},{"line":139,"kind":12,"name":"query_name"},{"kind":12,"name":"query_accession","line":140},{"name":"query_description","kind":12,"line":141},{"kind":12,"name":"query_accession","line":142},{"line":143,"kind":12,"name":"query_description"},{"line":145,"kind":12,"name":"header"},{"children":[{"line":149,"kind":13,"localvar":"my","containerName":"_discover_hit_table","name":"$self","definition":"my"},{"containerName":"_discover_hit_table","kind":13,"name":"$self","line":151},{"containerName":"_discover_hit_table","kind":12,"name":"_chunk_seek","line":151},{"kind":13,"containerName":"_discover_hit_table","name":"$self","line":151},{"definition":"my","line":152,"name":"$table","kind":13,"localvar":"my","containerName":"_discover_hit_table"},{"kind":13,"containerName":"_discover_hit_table","name":"$self","line":152},{"line":152,"name":"_get_chunk_by_end","containerName":"_discover_hit_table","kind":12},{"containerName":"_discover_hit_table","kind":13,"name":"$self","line":153},{"name":"$self","containerName":"_discover_hit_table","kind":13,"line":153},{"line":153,"name":"_chunk_tell","containerName":"_discover_hit_table","kind":12},{"definition":"my","line":155,"kind":13,"localvar":"my","containerName":"_discover_hit_table","name":"$evalue_cutoff"},{"line":155,"containerName":"_discover_hit_table","kind":13,"name":"$self"},{"line":155,"kind":12,"containerName":"_discover_hit_table","name":"get_field"},{"name":"$evalue_cutoff","kind":13,"containerName":"_discover_hit_table","line":156},{"name":"$evalue_cutoff","kind":13,"containerName":"_discover_hit_table","line":156},{"definition":"my","kind":13,"localvar":"my","containerName":"_discover_hit_table","name":"$score_cutoff","line":157},{"name":"$self","kind":13,"containerName":"_discover_hit_table","line":157},{"name":"get_field","containerName":"_discover_hit_table","kind":12,"line":157},{"line":158,"kind":13,"containerName":"_discover_hit_table","name":"$score_cutoff"},{"line":158,"name":"$score_cutoff","containerName":"_discover_hit_table","kind":13},{"line":159,"name":"$hsps_cutoff","kind":13,"localvar":"my","containerName":"_discover_hit_table","definition":"my"},{"line":159,"name":"$self","kind":13,"containerName":"_discover_hit_table"},{"line":159,"name":"get_field","kind":12,"containerName":"_discover_hit_table"},{"line":160,"name":"$hsps_cutoff","kind":13,"containerName":"_discover_hit_table"},{"containerName":"_discover_hit_table","kind":13,"name":"$hsps_cutoff","line":160},{"line":162,"name":"@table","localvar":"my","kind":13,"containerName":"_discover_hit_table","definition":"my"},{"line":163,"name":"$no_hit","localvar":"my","kind":13,"containerName":"_discover_hit_table","definition":"my"},{"name":"$table","containerName":"_discover_hit_table","kind":13,"line":164},{"line":165,"kind":13,"containerName":"_discover_hit_table","name":"$no_hit"},{"name":"$evalue","containerName":"_discover_hit_table","localvar":"my","kind":13,"line":166,"definition":"my"},{"line":167,"kind":13,"containerName":"_discover_hit_table","name":"$evalue_cutoff"},{"line":167,"containerName":"_discover_hit_table","kind":13,"name":"$evalue"},{"containerName":"_discover_hit_table","kind":13,"name":"$evalue_cutoff","line":167},{"line":168,"name":"$score_cutoff","containerName":"_discover_hit_table","kind":13},{"line":168,"kind":13,"containerName":"_discover_hit_table","name":"$score_cutoff"},{"containerName":"_discover_hit_table","kind":13,"name":"$hsps_cutoff","line":169},{"line":169,"kind":13,"containerName":"_discover_hit_table","name":"$hsps_cutoff"},{"line":170,"kind":13,"containerName":"_discover_hit_table","name":"@table"},{"containerName":"_discover_hit_table","kind":13,"name":"$evalue","line":170},{"line":172,"kind":13,"containerName":"_discover_hit_table","name":"$self"},{"name":"_fields","kind":12,"containerName":"_discover_hit_table","line":172},{"line":172,"kind":13,"containerName":"_discover_hit_table","name":"@table"},{"line":173,"name":"$self","containerName":"_discover_hit_table","kind":13},{"name":"@table","kind":13,"containerName":"_discover_hit_table","line":173},{"line":175,"name":"$self","kind":13,"containerName":"_discover_hit_table"},{"name":"_fields","kind":12,"containerName":"_discover_hit_table","line":175},{"kind":13,"containerName":"_discover_hit_table","name":"$no_hit","line":175},{"line":176,"containerName":"_discover_hit_table","kind":13,"name":"$self"},{"line":176,"name":"_fields","containerName":"_discover_hit_table","kind":12},{"kind":13,"containerName":"_discover_hit_table","name":"@table","line":176}],"containerName":"main::","name":"_discover_hit_table","definition":"sub","line":148,"kind":12,"range":{"start":{"line":148,"character":0},"end":{"line":177,"character":9999}}},{"name":"_after_header","kind":12,"line":151},{"name":"_after_hit_table","kind":12,"line":153},{"name":"hit_table","kind":12,"line":172},{"line":173,"name":"_next_hit_index","kind":12},{"line":175,"name":"no_hits_found","kind":12},{"line":176,"name":"num_hits","kind":12},{"definition":"sub","containerName":"main::","name":"_discover_hsp_table","children":[{"definition":"my","line":180,"kind":13,"localvar":"my","containerName":"_discover_hsp_table","name":"$self"},{"name":"$self","kind":13,"containerName":"_discover_hsp_table","line":182},{"line":182,"name":"_chunk_seek","containerName":"_discover_hsp_table","kind":12},{"name":"$self","containerName":"_discover_hsp_table","kind":13,"line":182},{"definition":"my","line":183,"name":"$table","kind":13,"localvar":"my","containerName":"_discover_hsp_table"},{"name":"$self","kind":13,"containerName":"_discover_hsp_table","line":183},{"line":183,"name":"_get_chunk_by_end","kind":12,"containerName":"_discover_hsp_table"},{"containerName":"_discover_hsp_table","kind":13,"name":"$table","line":184},{"containerName":"_discover_hsp_table","kind":13,"name":"$self","line":184},{"containerName":"_discover_hsp_table","kind":12,"name":"_get_chunk_by_end","line":184},{"name":"$self","containerName":"_discover_hsp_table","kind":13,"line":185},{"line":185,"name":"$self","kind":13,"containerName":"_discover_hsp_table"},{"line":185,"kind":12,"containerName":"_discover_hsp_table","name":"_chunk_tell"},{"line":187,"containerName":"_discover_hsp_table","localvar":"my","kind":13,"name":"%table","definition":"my"},{"line":190,"kind":13,"containerName":"_discover_hsp_table","name":"$table"},{"line":192,"kind":13,"localvar":"my","containerName":"_discover_hsp_table","name":"$evalue","definition":"my"},{"line":193,"kind":13,"containerName":"_discover_hsp_table","name":"$table"},{"line":193,"kind":13,"containerName":"_discover_hsp_table","name":"$evalue"},{"line":195,"containerName":"_discover_hsp_table","kind":13,"name":"$table"}],"kind":12,"range":{"end":{"line":197,"character":9999},"start":{"line":179,"character":0}},"line":179},{"name":"_after_hit_table","kind":12,"line":182},{"kind":12,"name":"_after_hsp_table","line":185},{"line":193,"kind":12,"name":"hsp_data"},{"name":"hit_length","kind":12,"line":195},{"line":198,"containerName":null,"kind":13,"name":"$self"},{"line":198,"containerName":"main::","kind":12,"name":"_fields"},{"line":198,"kind":12,"name":"hsp_table"},{"line":198,"containerName":null,"kind":13,"name":"%table"},{"children":[{"definition":"my","containerName":"_discover_alignments","localvar":"my","kind":13,"name":"$self","line":202},{"name":"$self","kind":13,"containerName":"_discover_alignments","line":203},{"name":"_fields","kind":12,"containerName":"_discover_alignments","line":203}],"name":"_discover_alignments","containerName":"main::","definition":"sub","line":201,"range":{"end":{"character":9999,"line":204},"start":{"line":201,"character":0}},"kind":12},{"line":203,"kind":12,"name":"alignments"},{"kind":12,"range":{"end":{"character":9999,"line":249},"start":{"line":206,"character":0}},"line":206,"containerName":"main::","name":"_next_alignment","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_next_alignment","line":207},{"name":"$self","containerName":"_next_alignment","kind":13,"line":208},{"line":210,"localvar":"my","kind":13,"containerName":"_next_alignment","name":"$aligns","definition":"my"},{"line":210,"name":"$self","kind":13,"containerName":"_next_alignment"},{"name":"_fields","kind":12,"containerName":"_next_alignment","line":210},{"name":"$self","kind":13,"containerName":"_next_alignment","line":212},{"name":"$self","containerName":"_next_alignment","kind":13,"line":213},{"name":"_chunk_seek","containerName":"_next_alignment","kind":12,"line":213},{"name":"$self","kind":13,"containerName":"_next_alignment","line":213},{"definition":"my","localvar":"my","kind":13,"containerName":"_next_alignment","name":"$chunk","line":214},{"kind":13,"containerName":"_next_alignment","name":"$self","line":214},{"line":214,"name":"_get_chunk_by_end","kind":12,"containerName":"_next_alignment"},{"line":215,"containerName":"_next_alignment","kind":13,"name":"$chunk"},{"line":216,"name":"$self","containerName":"_next_alignment","kind":13},{"line":220,"containerName":"_next_alignment","kind":13,"name":"$self"},{"line":220,"containerName":"_next_alignment","kind":13,"name":"$self"},{"name":"_chunk_tell","containerName":"_next_alignment","kind":12,"line":220},{"line":221,"kind":13,"containerName":"_next_alignment","name":"$self"},{"line":221,"name":"$chunk","containerName":"_next_alignment","kind":13},{"name":"$self","containerName":"_next_alignment","kind":13,"line":222},{"name":"_next_alignment","kind":12,"containerName":"_next_alignment","line":222},{"line":225,"containerName":"_next_alignment","kind":13,"name":"$self"},{"line":225,"name":"_chunk_seek","kind":12,"containerName":"_next_alignment"},{"line":225,"containerName":"_next_alignment","kind":13,"name":"$self"},{"definition":"my","line":226,"name":"$chunk","containerName":"_next_alignment","localvar":"my","kind":13},{"line":226,"kind":13,"containerName":"_next_alignment","name":"$self"},{"line":226,"name":"_get_chunk_by_end","containerName":"_next_alignment","kind":12},{"name":"$chunk","kind":13,"containerName":"_next_alignment","line":227},{"kind":13,"containerName":"_next_alignment","name":"$self","line":228},{"name":"_chunk_seek","kind":12,"containerName":"_next_alignment","line":228},{"line":228,"kind":13,"containerName":"_next_alignment","name":"$self"},{"name":"$chunk","containerName":"_next_alignment","kind":13,"line":229},{"name":"$self","kind":13,"containerName":"_next_alignment","line":229},{"line":229,"kind":12,"containerName":"_next_alignment","name":"_get_chunk_by_end"},{"kind":13,"containerName":"_next_alignment","name":"$chunk","line":231},{"kind":13,"containerName":"_next_alignment","name":"$self","line":232},{"line":237,"name":"$self","kind":13,"containerName":"_next_alignment"},{"kind":13,"containerName":"_next_alignment","name":"$self","line":237},{"containerName":"_next_alignment","kind":12,"name":"_chunk_tell","line":237},{"name":"$self","containerName":"_next_alignment","kind":13,"line":239},{"containerName":"_next_alignment","kind":13,"name":"$chunk","line":240},{"name":"$self","containerName":"_next_alignment","kind":13,"line":240},{"name":"$chunk","kind":13,"containerName":"_next_alignment","line":240},{"line":243,"containerName":"_next_alignment","kind":13,"name":"$chunk"},{"containerName":"_next_alignment","kind":13,"name":"$self","line":244},{"definition":"my","line":246,"kind":13,"localvar":"my","containerName":"_next_alignment","name":"$name"},{"name":"$domain","kind":13,"containerName":"_next_alignment","line":246},{"name":"$chunk","containerName":"_next_alignment","kind":13,"line":246},{"name":"$aligns","kind":13,"containerName":"_next_alignment","line":247},{"line":247,"kind":13,"containerName":"_next_alignment","name":"$name"},{"line":247,"containerName":"_next_alignment","kind":13,"name":"$domain"},{"name":"$chunk","kind":13,"containerName":"_next_alignment","line":247}],"definition":"sub"},{"line":208,"kind":12,"name":"_no_more_alignments"},{"kind":12,"name":"alignments","line":210},{"line":212,"kind":12,"name":"_after_previous_alignment"},{"kind":12,"name":"_after_hsp_table","line":213},{"name":"_no_more_alignments","kind":12,"line":216},{"kind":12,"name":"_after_previous_alignment","line":220},{"name":"_next_alignment_start_text","kind":12,"line":221},{"kind":12,"name":"_after_previous_alignment","line":225},{"line":228,"kind":12,"name":"_after_previous_alignment"},{"line":232,"kind":12,"name":"_no_more_alignments"},{"line":237,"name":"_after_previous_alignment","kind":12},{"name":"_next_alignment_start_text","kind":12,"line":239},{"line":240,"name":"_next_alignment_start_text","kind":12},{"name":"_next_alignment_start_text","kind":12,"line":244},{"children":[{"name":"$self","containerName":"_discover_next_hit","localvar":"my","kind":13,"line":252,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_discover_next_hit","name":"@hit_table","line":253},{"containerName":"_discover_next_hit","kind":13,"name":"$self","line":253},{"line":253,"kind":12,"containerName":"_discover_next_hit","name":"get_field"}],"containerName":"main::","name":"_discover_next_hit","definition":"sub","line":251,"range":{"end":{"line":253,"character":9999},"start":{"line":251,"character":0}},"kind":12},{"line":254,"name":"%self","kind":13,"containerName":null},{"line":254,"name":"_next_hit_index","kind":12},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"@hit_data","line":257},{"line":257,"name":"@hit_table","kind":13,"containerName":null},{"line":257,"name":"%self","kind":13,"containerName":null},{"line":257,"kind":12,"name":"_next_hit_index"},{"line":257,"containerName":null,"kind":13,"name":"%self"},{"line":257,"kind":12,"name":"_next_hit_index"},{"name":"$self","kind":13,"containerName":null,"line":259},{"name":"_fields","kind":12,"containerName":"main::","line":259},{"kind":12,"name":"next_hit","line":259},{"name":"Bio","containerName":"Search::Hit::HmmpfamHit","kind":12,"line":259},{"name":"new","containerName":"main::","kind":12,"line":259},{"line":259,"name":"$self","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@hit_data","line":260},{"name":"%self","containerName":null,"kind":13,"line":262},{"name":"_next_hit_index","kind":12,"line":262},{"kind":12,"name":"hit_table","line":262},{"name":"%self","kind":13,"containerName":null,"line":263},{"name":"_next_hit_index","kind":12,"line":263},{"definition":"sub","children":[{"line":279,"name":"$self","localvar":"my","kind":13,"containerName":"next_hit","definition":"my"},{"line":280,"name":"$hit","localvar":"my","kind":13,"containerName":"next_hit","definition":"my"},{"kind":13,"containerName":"next_hit","name":"$self","line":280},{"kind":12,"containerName":"next_hit","name":"get_field","line":280},{"containerName":"next_hit","kind":13,"name":"$self","line":281},{"line":281,"containerName":"next_hit","kind":12,"name":"_fields"},{"line":282,"name":"$hit","containerName":"next_hit","kind":13}],"name":"next_hit","containerName":"main::","line":278,"range":{"start":{"character":0,"line":278},"end":{"character":9999,"line":283}},"kind":12},{"line":281,"name":"next_hit","kind":12},{"line":309,"kind":12,"range":{"start":{"character":0,"line":309},"end":{"line":319,"character":9999}},"definition":"sub","children":[{"definition":"my","line":310,"name":"$self","containerName":"hits","localvar":"my","kind":13},{"line":311,"name":"$old","localvar":"my","kind":13,"containerName":"hits","definition":"my"},{"containerName":"hits","kind":13,"name":"$self","line":311},{"kind":13,"containerName":"hits","name":"$self","line":312},{"kind":12,"containerName":"hits","name":"rewind","line":312},{"kind":13,"localvar":"my","containerName":"hits","name":"@hits","line":313,"definition":"my"},{"name":"$hit","kind":13,"localvar":"my","containerName":"hits","line":314,"definition":"my"},{"line":314,"name":"$self","containerName":"hits","kind":13},{"name":"next_hit","containerName":"hits","kind":12,"line":314},{"line":315,"kind":13,"containerName":"hits","name":"@hits"},{"line":315,"name":"$hit","containerName":"hits","kind":13},{"name":"$self","containerName":"hits","kind":13,"line":317},{"line":317,"name":"@hits","containerName":"hits","kind":13},{"kind":13,"containerName":"hits","name":"$old","line":317},{"name":"@hits","containerName":"hits","kind":13,"line":318}],"containerName":"main::","name":"hits"},{"line":311,"kind":12,"name":"_next_hit_index"},{"line":317,"kind":12,"name":"_next_hit_index"},{"kind":12,"range":{"start":{"character":0,"line":360},"end":{"character":9999,"line":367}},"line":360,"signature":{"documentation":"1;\n# $Id: HmmpfamResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::HmmpfamResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::HmmpfamResult - A parser and result object for hmmpfam\n                                     results\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam result output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::HmmpfamResult;\n\nuse strict;\n\nuse Bio::Search::Hit::HmmpfamHit;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::PullResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Result::hmmpfam->new();\n Function: Builds a new Bio::SearchIO::Result::hmmpfam object \n Returns : Bio::SearchIO::Result::hmmpfam\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -parameters => hash ref of search parameters (key => value), optional\n           -statistics => hash ref of search statistics (key => value), optional\n\n\t\t   where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           result, and $start and $end define the tell() position within the\n           filehandle that the result data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tforeach my $field (qw( header hit_table hsp_table alignments next_model models query_length )) {\n\t\t$self->_fields->{$field} = undef;\n\t}\n\t\n\t$self->_dependencies( { ( query_name => 'header',\n                              query_accession => 'header',\n                              query_description => 'header',\n                              hit_table => 'header',\n\t\t\t\t\t\t\t  num_hits => 'hit_table',\n\t\t\t\t\t\t\t  no_hits_found => 'hit_table',\n                              hsp_table => 'hit_table',\n                              next_alignment => 'hsp_table' ) } );\n    \n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all ResultI questions\n#\n\nsub _discover_header {\n\tmy $self = shift;\n\t$self->_chunk_seek(0);\n\tmy $header = $self->_get_chunk_by_end(\"all domains):\\n\");\n\t$self->{_after_header} = $self->_chunk_tell;\n\t\n\t$header || $self->throw(\"Could not find hmmer header, is file really hmmer format?\");\n\t\n\t($self->_fields->{query_name}) = $header =~ /^Query(?:\\s+sequence)?:\\s+(\\S+)/m;\n\t($self->_fields->{query_accession}) = $header =~ /^Accession:\\s+(\\S+)/m;\n\t($self->_fields->{query_description}) = $header =~ /^Description:\\s+(\\S.+)/m;\n\t$self->_fields->{query_accession} ||= '';\n\t$self->_fields->{query_description} ||= '';\n\t\n\t$self->_fields->{header} = 1; # stop this method being called again\n}\n\nsub _discover_hit_table {\n\tmy $self = shift;\n\t\n\t$self->_chunk_seek($self->{_after_header});\n\tmy $table = $self->_get_chunk_by_end(\"for domains:\\n\");\n\t$self->{_after_hit_table} = $self->_chunk_tell;\n\t\n\tmy $evalue_cutoff = $self->get_field('evalue_cutoff');\n\tundef $evalue_cutoff if $evalue_cutoff eq '[unset]';\n\tmy $score_cutoff = $self->get_field('score_cutoff');\n\tundef $score_cutoff if $score_cutoff eq '[unset]';\n\tmy $hsps_cutoff = $self->get_field('hsps_cutoff');\n\tundef $hsps_cutoff if $hsps_cutoff eq '[unset]';\n\t\n\tmy @table;\n\tmy $no_hit = 1;\n\twhile ($table =~ /^(\\S+)\\s+(\\S.+?)?\\s+(\\S+)\\s+(\\S+)\\s+(\\d+)\\n/gm) {\n\t\t$no_hit = 0;\n\t\tmy $evalue = abs($4); # consistency for tests under Windows\n\t\tnext if ($evalue_cutoff && $evalue > $evalue_cutoff);\n\t\tnext if ($score_cutoff && $3 < $score_cutoff);\n\t\tnext if ($hsps_cutoff && $5 < $hsps_cutoff);\n\t\tpush(@table, [$1, $2, $3, $evalue, $5]);\n\t}\n\t$self->_fields->{hit_table} = \\@table;\n\t$self->{_next_hit_index} = @table > 0 ? 0 : -1;\n\t\n\t$self->_fields->{no_hits_found} = $no_hit;\n\t$self->_fields->{num_hits} = @table;\n}\n\nsub _discover_hsp_table {\n\tmy $self = shift;\n\t\n\t$self->_chunk_seek($self->{_after_hit_table});\n\tmy $table = $self->_get_chunk_by_end(\"top-scoring domains:\\n\");\n\t$table ||= $self->_get_chunk_by_end(\"//\\n\"); # A0 reports\n\t$self->{_after_hsp_table} = $self->_chunk_tell;\n\t\n\tmy %table;\n\t# can't save this regex work for the hsp object because the hit object needs\n\t# its length, so may as well just do all the work here\n\twhile ($table =~ /^(\\S+)\\s+(\\d+)\\/\\d+\\s+(\\d+)\\s+(\\d+)\\s+\\S\\S\\s+(\\d+)\\s+(\\d+)\\s+\\S(\\S)\\s+(\\S+)\\s+(\\S+)/gm) {\n\t\t# rank query_start query_end hit_start hit_end score evalue\n\t\tmy $evalue = abs($9); # consistency for tests under Windows\n\t\tpush(@{$table{$1}->{hsp_data}}, [$2, $3, $4, $5, $6, $8, $evalue]);\n\t\tif ($7 eq ']') {\n\t\t\t$table{$1}->{hit_length} = $6;\n\t\t}\n\t}\n\t$self->_fields->{hsp_table} = \\%table;\n}\n\nsub _discover_alignments {\n\tmy $self = shift;\n\t$self->_fields->{alignments} = { };\n}\n\nsub _next_alignment {\n\tmy $self = shift;;\n\treturn if $self->{_no_more_alignments};\n\t\n\tmy $aligns = $self->_fields->{alignments};\n\t\n\tunless (defined $self->{_after_previous_alignment}) {\n\t\t$self->_chunk_seek($self->{_after_hsp_table});\n\t\tmy $chunk = $self->_get_chunk_by_end(\": domain\");\n\t\tunless ($chunk) {\n\t\t\t$self->{_no_more_alignments} = 1;\n\t\t\treturn;\n\t\t}\n\t\t\n\t\t$self->{_after_previous_alignment} = $self->_chunk_tell;\n\t\t$self->{_next_alignment_start_text} = $chunk;\n\t\treturn $self->_next_alignment;\n\t}\n\t\n\t$self->_chunk_seek($self->{_after_previous_alignment});\n\tmy $chunk = $self->_get_chunk_by_end(\": domain\");\n\tunless ($chunk) {\n\t\t$self->_chunk_seek($self->{_after_previous_alignment});\n\t\t$chunk = $self->_get_chunk_by_end(\"//\");\n\t\t\n\t\tunless ($chunk) {\n\t\t\t$self->{_no_more_alignments} = 1;\n\t\t\treturn;\n\t\t}\n\t}\n\t\n\t$self->{_after_previous_alignment} = $self->_chunk_tell;\n\t\n\tif (defined $self->{_next_alignment_start_text}) {\n\t\t$chunk = $self->{_next_alignment_start_text}.$chunk;\n\t}\n\t\n\t$chunk =~ s/(\\S+: domain)$//;\n\t$self->{_next_alignment_start_text} = $1;\n\t\n\tmy ($name, $domain) = $chunk =~ /^(\\S+): domain (\\d+)/;\n\t$aligns->{$name.'~~~~'.$domain} = $chunk;\n\treturn 1;\n}\n\nsub _discover_next_hit {\n\tmy $self = shift;\n\tmy @hit_table = @{$self->get_field('hit_table')};\n\treturn if $self->{_next_hit_index} == -1;\n\t\n\t#[name description score significance num_hsps rank]\n\tmy @hit_data = (@{$hit_table[$self->{_next_hit_index}++]}, $self->{_next_hit_index});\n\t\n\t$self->_fields->{next_hit} = Bio::Search::Hit::HmmpfamHit->new(-parent => $self,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -hit_data => \\@hit_data);\n\t\n\tif ($self->{_next_hit_index} > $#hit_table) {\n\t\t$self->{_next_hit_index} = -1;\n\t}\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n\tmy $self = shift;\n    my $hit = $self->get_field('next_hit');\n\tundef $self->_fields->{next_hit};\n\treturn $hit;\n}\n\n=head2 next_model\n\n Title   : next_model\n Usage   : my $domain = $result->next_model\n Function: Returns the next domain - this is an alias for next_hit()\n Returns : L<Bio::Search::Hit::HitI> object\n Args    : none\n\n\n*next_model = \\&next_hit;\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n\tmy $self = shift;\n\tmy $old = $self->{_next_hit_index} || 0;\n\t$self->rewind;\n\tmy @hits;\n\twhile (defined(my $hit = $self->next_hit)) {\n\t\tpush(@hits, $hit);\n\t}\n\t$self->{_next_hit_index} = @hits > 0 ? $old : -1;\n\treturn @hits;\n}\n\n=head2 models\n\n Title   : models\n Usage   : my @domains = $result->models;\n Function: Returns the list of HMM models seen - this is an alias for hits()\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n\n\n*models = \\&hits;\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits('<score')\n Function\t: Sorts the hits so that they come out in the desired order when\n              hits() or next_hit() is called.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.\n\t\t\t  You will be sorting array references, not HitI objects. The\n\t\t\t  references contain name as element 0, description as element 1,\n\t\t\t  score as element 2, significance as element 3 and number of hsps\n\t\t\t  as element 4.\n\t\t\t  By default the sort order is ascending significance value (ie.\n\t\t\t  most significant hits first).\n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access\n\t\t\t  Bio::Search::Result::HmmpfamResult namespace. \n              For example, use : \n              $result->sort_hits(\n\t\t\t\tsub{$Bio::Search::Result::HmmpfamResult::a->[2]\n\t\t\t\t                         <=> \n\t\t\t\t\t$Bio::Search::Result::HmmpfamResult::b->[2]});\n              NOT $result->sort_hits($a->[2] <=> $b->[2]);","parameters":[{"label":"$self"},{"label":"$code_ref"}],"label":"sort_hits($self,$code_ref)"},"containerName":"main::","name":"sort_hits","children":[{"line":361,"name":"$self","localvar":"my","kind":13,"containerName":"sort_hits","definition":"my"},{"containerName":"sort_hits","kind":13,"name":"$code_ref","line":361},{"line":362,"containerName":"sort_hits","kind":13,"name":"$code_ref"},{"line":362,"name":"$a","kind":13,"containerName":"sort_hits"},{"line":362,"kind":13,"containerName":"sort_hits","name":"$b"},{"line":366,"name":"$table_ref","localvar":"my","kind":13,"containerName":"sort_hits","definition":"my"},{"name":"$self","containerName":"sort_hits","kind":13,"line":366},{"kind":12,"containerName":"sort_hits","name":"get_field","line":366},{"containerName":"sort_hits","kind":13,"name":"$table_ref","line":367}],"detail":"($self,$code_ref)","definition":"sub"},{"line":369,"localvar":"my","containerName":null,"kind":13,"name":"@sorted","definition":"my"},{"line":369,"kind":13,"containerName":null,"name":"$code_ref"},{"name":"$table_ref","kind":13,"containerName":null,"line":369},{"containerName":null,"kind":13,"name":"@sorted","line":370},{"line":370,"containerName":null,"kind":13,"name":"$table_ref"},{"line":370,"name":"$self","kind":13,"containerName":null},{"line":370,"name":"throw","containerName":"main::","kind":12},{"name":"$self","containerName":null,"kind":13,"line":371},{"line":371,"name":"_fields","containerName":"main::","kind":12},{"kind":12,"name":"hit_table","line":371},{"name":"@sorted","kind":13,"containerName":null,"line":371},{"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"rewind","name":"$self","line":386,"definition":"my"},{"name":"$self","kind":13,"containerName":"rewind","line":387},{"line":387,"name":"_fields","containerName":"rewind","kind":12},{"kind":13,"containerName":"rewind","name":"$self","line":388},{"line":388,"containerName":"rewind","kind":12,"name":"get_field"},{"line":390,"name":"$self","containerName":"rewind","kind":13},{"line":390,"name":"$self","kind":13,"containerName":"rewind"},{"kind":12,"containerName":"rewind","name":"_fields","line":390}],"containerName":"main::","name":"rewind","line":385,"kind":12,"range":{"start":{"character":0,"line":385},"end":{"line":390,"character":9999}}},{"name":"hit_table","kind":12,"line":387},{"kind":12,"name":"_next_hit_index","line":390},{"kind":12,"name":"hit_table","line":390}],"version":5}