{"vars":[{"name":"base","kind":2,"containerName":"","line":115},{"line":130,"range":{"end":{"line":133,"character":9999},"start":{"line":130,"character":0}},"kind":12,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.","parameters":[{"label":"$self"},{"label":"@args"}],"label":"name($self,@args)"},"children":[{"definition":"my","line":131,"localvar":"my","kind":13,"containerName":"name","name":"$self"},{"line":131,"containerName":"name","kind":13,"name":"@args"},{"name":"$self","containerName":"name","kind":13,"line":132},{"kind":12,"containerName":"name","name":"throw_not_implemented","line":132}],"containerName":"main::","name":"name","definition":"sub","detail":"($self,@args)"},{"signature":{"label":"description($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none"},"range":{"end":{"character":9999,"line":148},"start":{"line":145,"character":0}},"kind":12,"line":145,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"description","children":[{"line":146,"localvar":"my","kind":13,"containerName":"description","name":"$self","definition":"my"},{"line":146,"kind":13,"containerName":"description","name":"@args"},{"line":147,"kind":13,"containerName":"description","name":"$self"},{"line":147,"containerName":"description","kind":12,"name":"throw_not_implemented"}]},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"accession","children":[{"definition":"my","line":162,"localvar":"my","kind":13,"containerName":"accession","name":"$self"},{"line":162,"containerName":"accession","kind":13,"name":"@args"},{"line":163,"kind":13,"containerName":"accession","name":"$self"},{"kind":12,"containerName":"accession","name":"throw_not_implemented","line":163}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","label":"accession($self,@args)"},"kind":12,"range":{"start":{"character":0,"line":161},"end":{"line":164,"character":9999}},"line":161},{"line":176,"kind":12,"range":{"end":{"line":179,"character":9999},"start":{"character":0,"line":176}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","label":"locus($self,@args)"},"children":[{"definition":"my","localvar":"my","containerName":"locus","kind":13,"name":"$self","line":177},{"containerName":"locus","kind":13,"name":"@args","line":177},{"name":"$self","containerName":"locus","kind":13,"line":178},{"containerName":"locus","kind":12,"name":"throw_not_implemented","line":178}],"name":"locus","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"definition":"sub","detail":"($self,@args)","children":[{"line":192,"containerName":"length","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":192,"kind":13,"containerName":"length","name":"@args"},{"line":193,"name":"$self","containerName":"length","kind":13},{"line":193,"kind":12,"containerName":"length","name":"throw_not_implemented"}],"containerName":"main::","name":"length","signature":{"label":"length($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"line":191,"range":{"start":{"character":0,"line":191},"end":{"line":194,"character":9999}},"kind":12},{"containerName":"main::","name":"algorithm","children":[{"name":"$self","localvar":"my","containerName":"algorithm","kind":13,"line":212,"definition":"my"},{"name":"@args","containerName":"algorithm","kind":13,"line":212},{"line":213,"kind":13,"containerName":"algorithm","name":"$self"},{"containerName":"algorithm","kind":12,"name":"throw_not_implemented","line":213}],"detail":"($self,@args)","definition":"sub","range":{"end":{"character":9999,"line":214},"start":{"character":0,"line":211}},"kind":12,"line":211,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"algorithm($self,@args)"}},{"range":{"start":{"character":0,"line":228},"end":{"line":230,"character":9999}},"kind":12,"line":228,"containerName":"main::","name":"raw_score","children":[{"name":"throw_not_implemented","kind":12,"containerName":"raw_score","line":229}],"definition":"sub"},{"range":{"start":{"line":238,"character":0},"end":{"line":238,"character":9999}},"kind":12,"line":238,"name":"score","containerName":"main::","children":[{"line":238,"name":"raw_score","containerName":"score","kind":12}],"definition":"sub"},{"range":{"end":{"line":255,"character":9999},"start":{"character":0,"line":253}},"kind":12,"line":253,"definition":"sub","name":"significance","containerName":"main::","children":[{"line":254,"name":"throw_not_implemented","containerName":"significance","kind":12}]},{"line":271,"range":{"start":{"line":271,"character":0},"end":{"character":9999,"line":274}},"kind":12,"children":[{"line":273,"name":"throw_not_implemented","kind":12,"containerName":"bits"}],"containerName":"main::","name":"bits","definition":"sub"},{"detail":"($self,@args)","definition":"sub","name":"next_hsp","containerName":"main::","children":[{"line":288,"kind":13,"localvar":"my","containerName":"next_hsp","name":"$self","definition":"my"},{"line":288,"kind":13,"containerName":"next_hsp","name":"@args"},{"containerName":"next_hsp","kind":13,"name":"$self","line":289},{"line":289,"containerName":"next_hsp","kind":12,"name":"throw_not_implemented"}],"signature":{"label":"next_hsp($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none","parameters":[{"label":"$self"},{"label":"@args"}]},"range":{"start":{"character":0,"line":287},"end":{"character":9999,"line":290}},"kind":12,"line":287},{"line":311,"range":{"end":{"line":316,"character":9999},"start":{"line":311,"character":0}},"kind":12,"children":[{"line":313,"localvar":"my","kind":13,"containerName":"hsps","name":"$self","definition":"my"},{"kind":13,"containerName":"hsps","name":"$self","line":315},{"line":315,"name":"throw_not_implemented","containerName":"hsps","kind":12}],"containerName":"main::","name":"hsps","definition":"sub"},{"kind":12,"range":{"end":{"line":337,"character":9999},"start":{"line":334,"character":0}},"line":334,"name":"num_hsps","containerName":"main::","children":[{"line":336,"name":"throw_not_implemented","containerName":"num_hsps","kind":12}],"definition":"sub"},{"signature":{"label":"seq_inds($self,$seqType,$class,$collapse)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}]},"kind":12,"range":{"end":{"line":389,"character":9999},"start":{"line":366,"character":0}},"line":366,"detail":"($self,$seqType,$class,$collapse)","definition":"sub","containerName":"main::","name":"seq_inds","children":[{"kind":13,"localvar":"my","containerName":"seq_inds","name":"$self","line":368,"definition":"my"},{"line":368,"name":"$seqType","containerName":"seq_inds","kind":13},{"line":368,"kind":13,"containerName":"seq_inds","name":"$class"},{"line":368,"name":"$collapse","containerName":"seq_inds","kind":13},{"line":370,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"line":371,"name":"$class","kind":13,"containerName":"seq_inds"},{"kind":13,"containerName":"seq_inds","name":"$collapse","line":372},{"containerName":"seq_inds","kind":13,"name":"$seqType","line":374},{"line":374,"containerName":"seq_inds","kind":13,"name":"$seqType"},{"localvar":"my","kind":13,"containerName":"seq_inds","name":"@inds","line":376,"definition":"my"},{"containerName":"seq_inds","kind":13,"name":"$hsp","line":376},{"line":377,"containerName":"seq_inds","kind":13,"name":"$hsp"},{"line":377,"containerName":"seq_inds","kind":13,"name":"$self"},{"kind":12,"containerName":"seq_inds","name":"hsps","line":377},{"kind":13,"containerName":"seq_inds","name":"@inds","line":379},{"name":"$hsp","containerName":"seq_inds","kind":13,"line":379},{"line":379,"name":"seq_inds","kind":12,"containerName":"seq_inds"},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":379},{"line":379,"kind":13,"containerName":"seq_inds","name":"$class"},{"containerName":"seq_inds","kind":13,"name":"@inds","line":383},{"name":"%tmp","localvar":"my","containerName":"seq_inds","kind":13,"line":384,"definition":"my"},{"line":384,"containerName":"seq_inds","kind":13,"name":"@inds"},{"line":385,"kind":13,"containerName":"seq_inds","name":"@inds"},{"line":385,"kind":13,"containerName":"seq_inds","name":"$a"},{"kind":13,"containerName":"seq_inds","name":"$b","line":385},{"containerName":"seq_inds","kind":13,"name":"%tmp","line":385},{"line":388,"name":"$collapse","containerName":"seq_inds","kind":13},{"line":388,"name":"@inds","kind":13,"containerName":"seq_inds"},{"line":388,"containerName":"seq_inds","kind":13,"name":"@inds"}]},{"line":388,"name":"Bio","containerName":"Search::BlastUtils::collapse_nums","kind":12},{"children":[{"line":403,"name":"$self","localvar":"my","containerName":"rewind","kind":13,"definition":"my"},{"name":"$self","containerName":"rewind","kind":13,"line":404},{"line":404,"name":"throw_not_implemented","kind":12,"containerName":"rewind"}],"containerName":"main::","name":"rewind","definition":"sub","detail":"($self)","line":402,"range":{"start":{"line":402,"character":0},"end":{"line":405,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\n#-------------\nsub seq_inds {\n#-------------\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);    \n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::BlastUtils::collapse_nums(@inds) : @inds; \n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           if possible\n Returns : none\n Args    : none","label":"rewind($self)"}},{"name":"overlap","containerName":"main::","children":[{"kind":12,"containerName":"overlap","name":"throw_not_implemented","line":427}],"definition":"sub","range":{"end":{"character":9999,"line":427},"start":{"line":427,"character":0}},"kind":12,"line":427},{"kind":12,"range":{"end":{"character":9999,"line":453},"start":{"character":0,"line":453}},"line":453,"name":"n","containerName":"main::","children":[{"containerName":"n","kind":12,"name":"throw_not_implemented","line":453}],"definition":"sub"},{"name":"p","containerName":"main::","children":[{"kind":12,"containerName":"p","name":"throw_not_implemented","line":483}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":483},"start":{"character":0,"line":483}},"line":483},{"line":505,"kind":12,"range":{"start":{"line":505,"character":0},"end":{"character":9999,"line":505}},"definition":"sub","children":[{"kind":12,"containerName":"hsp","name":"throw_not_implemented","line":505}],"name":"hsp","containerName":"main::"},{"definition":"sub","children":[{"containerName":"logical_length","kind":12,"name":"throw_not_implemented","line":529}],"name":"logical_length","containerName":"main::","line":529,"kind":12,"range":{"start":{"line":529,"character":0},"end":{"character":9999,"line":529}}},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":545,"name":"$self","containerName":"rank","localvar":"my","kind":13},{"containerName":"rank","kind":13,"name":"$value","line":545},{"line":546,"name":"$self","containerName":"rank","kind":13},{"line":546,"name":"throw_not_implemented","kind":12,"containerName":"rank"}],"containerName":"main::","name":"rank","signature":{"label":"rank($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\n#-------------\nsub seq_inds {\n#-------------\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);    \n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::BlastUtils::collapse_nums(@inds) : @inds; \n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           if possible\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by L<Bio::Search::BlastUtils::_adjust_contigs()>.\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap { shift->throw_not_implemented }\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n { shift->throw_not_implemented }\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p { shift->throw_not_implemented() }\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp { shift->throw_not_implemented }\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length { shift->throw_not_implemented() }\n\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)"},"line":544,"range":{"end":{"line":547,"character":9999},"start":{"line":544,"character":0}},"kind":12},{"children":[{"definition":"my","line":563,"localvar":"my","containerName":"each_accession_number","kind":13,"name":"$self"},{"line":563,"kind":13,"containerName":"each_accession_number","name":"$value"},{"name":"$self","kind":13,"containerName":"each_accession_number","line":564},{"name":"throw_not_implemented","containerName":"each_accession_number","kind":12,"line":564}],"containerName":"main::","name":"each_accession_number","definition":"sub","detail":"($self,$value)","line":562,"kind":12,"range":{"start":{"character":0,"line":562},"end":{"line":565,"character":9999}},"signature":{"label":"each_accession_number($self,$value)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\n#-------------\nsub seq_inds {\n#-------------\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);    \n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::BlastUtils::collapse_nums(@inds) : @inds; \n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           if possible\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by L<Bio::Search::BlastUtils::_adjust_contigs()>.\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap { shift->throw_not_implemented }\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n { shift->throw_not_implemented }\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p { shift->throw_not_implemented() }\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp { shift->throw_not_implemented }\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length { shift->throw_not_implemented() }\n\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank{\n   my ($self,$value) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]}},{"line":583,"kind":12,"range":{"start":{"line":583,"character":0},"end":{"character":9999,"line":583}},"children":[{"name":"throw_not_implemented","containerName":"tiled_hsps","kind":12,"line":583}],"name":"tiled_hsps","containerName":"main::","definition":"sub"},{"line":627,"range":{"end":{"line":627,"character":9999},"start":{"line":627,"character":0}},"kind":12,"children":[{"name":"throw_not_implemented","kind":12,"containerName":"strand","line":627}],"name":"strand","containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","name":"frame","children":[{"name":"throw_not_implemented","kind":12,"containerName":"frame","line":649}],"range":{"end":{"line":649,"character":9999},"start":{"character":0,"line":649}},"kind":12,"line":649},{"definition":"sub","children":[{"line":683,"kind":12,"containerName":"matches","name":"throw_not_implemented"}],"containerName":"main::","name":"matches","line":683,"kind":12,"range":{"start":{"line":683,"character":0},"end":{"line":683,"character":9999}}},{"definition":"sub","name":"hit_description","containerName":"main::","children":[{"name":"description","containerName":"hit_description","kind":12,"line":687}],"range":{"start":{"line":687,"character":0},"end":{"character":9999,"line":687}},"kind":12,"line":687},{"children":[{"containerName":"hit_length","kind":12,"name":"length","line":689}],"containerName":"main::","name":"hit_length","definition":"sub","line":689,"range":{"start":{"line":689,"character":0},"end":{"line":689,"character":9999}},"kind":12},{"range":{"start":{"line":712,"character":0},"end":{"character":9999,"line":712}},"kind":12,"line":712,"definition":"sub","containerName":"main::","name":"sort_hsps","children":[{"kind":12,"containerName":"sort_hsps","name":"throw_not_implemented","line":712}]},{"line":725,"kind":12,"range":{"start":{"line":725,"character":0},"end":{"line":728,"character":9999}},"children":[{"name":"$Bio","containerName":"_default_sort_hsps","kind":13,"line":726},{"kind":12,"containerName":"_default_sort_hsps","name":"evalue","line":726},{"name":"$Bio","containerName":"_default_sort_hsps","kind":13,"line":727},{"line":727,"name":"evalue","containerName":"_default_sort_hsps","kind":12}],"containerName":"main::","name":"_default_sort_hsps","definition":"sub"},{"name":"Search","kind":12,"containerName":"Hit::HitI::a","line":726},{"name":"Search","kind":12,"containerName":"Hit::HitI::a","line":727}],"version":5}