{"vars":[{"definition":"my","line":193,"localvar":"my","containerName":null,"kind":13,"name":"$debug"},{"containerName":"","kind":2,"name":"strict","line":193},{"name":"$Error","kind":13,"containerName":null,"line":193},{"definition":"my","name":"$DEFAULT_VALUE","kind":13,"localvar":"my","containerName":null,"line":194},{"name":"Debug","kind":12,"containerName":"","line":194},{"name":"@Bio","containerName":null,"kind":13,"line":206},{"line":206,"name":"Root","kind":12,"containerName":"Exception::ISA"},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: Exception.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Root::Exception\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::Root::Exception - Generic exception objects for Bioperl\n\n=head1 SYNOPSIS\n\n=head2 Throwing exceptions using L<Error.pm throw|Error::throw>:\n\n    use Bio::Root::Exception;\n    use Error;\n\n    # Set Error::Debug to include stack trace data in the error messages\n    $Error::Debug = 1;\n\n    $file = shift;\n    open (IN, $file) ||\n\t    throw Bio::Root::FileOpenException ( \"Can't open file $file for reading\", $!);\n\n=head2 Throwing exceptions using L<Bioperl throw|Bio::Root::Root/throw>:\n\n     # Here we have an object that ISA Bio::Root::Root, so it inherits throw().\n\n     open (IN, $file) || \n                $object->throw(-class => 'Bio::Root::FileOpenException',\n                               -text => \"Can't open file $file for reading\",\n                               -value => $!);\n\n=head2 Catching and handling exceptions using L<Error.pm try|Error/try>:\n\n    use Bio::Root::Exception;\n    use Error qw(:try);\n\n    # Note that we need to import the 'try' tag from Error.pm\n\n    # Set Error::Debug to include stack trace data in the error messages\n    $Error::Debug = 1;\n\n    $file = shift;\n    try {\n        open (IN, $file) ||\n\t    throw Bio::Root::FileOpenException ( \"Can't open file $file for reading\", $!);\n    }\n    catch Bio::Root::FileOpenException with {\n        my $err = shift;\n        print STDERR \"Using default input file: $default_file\\n\";\n        open (IN, $default_file) || die \"Can't open $default_file\";\n    }\n    otherwise {\n        my $err = shift;\n    \tprint STDERR \"An unexpected exception occurred: \\n$err\";\n\n\t# By placing an the error object reference within double quotes,\n\t# you're invoking its stringify() method.\n    }\n   finally {\n       # Any code that you want to execute regardless of whether or not\n       # an exception occurred.\n   };  \n   # the ending semicolon is essential!\n\n\n=head2 Defining a new Exception type as a subclass of Bio::Root::Exception:\n\n    @Bio::TestException::ISA = qw( Bio::Root::Exception );\n\n=head1 DESCRIPTION\n\n=head2 Exceptions defined in L<Bio::Root::Exception>\n\nThese are generic exceptions for typical problem situations that could arise\nin any module or script. \n\n=over 8\n\n* Bio::Root::Exception()\n\n* Bio::Root::NotImplemented()\n\n* Bio::Root::IOException()\n\n* Bio::Root::FileOpenException()\n\n* Bio::Root::SystemException()\n\n* Bio::Root::BadParameter()\n\n* Bio::Root::OutOfRange()\n\n* Bio::Root::NoSuchThing()\n\n\nUsing defined exception classes like these is a good idea because it\nindicates the basic nature of what went wrong in a convenient,\ncomputable way.\n\nIf there is a type of exception that you want to throw\nthat is not covered by the classes listed above, it is easy to define\na new one that fits your needs. Just write a line like the following\nin your module or script where you want to use it (or put it somewhere\nthat is accessible to your code):\n\n    @NoCanDoException::ISA = qw( Bio::Root::Exception );\n\nAll of the exceptions defined in this module inherit from a common\nbase class exception, Bio::Root::Exception. This allows a user to\nwrite a handler for all Bioperl-derived exceptions as follows:\n\n           use Bio::Whatever;\n           use Error qw(:try);\n\n           try {\n                # some code that depends on Bioperl\n           }\n           catch Bio::Root::Exception with {\n               my $err = shift;\n               print \"A Bioperl exception occurred:\\n$err\\n\";\n           };\n\nSo if you do create your own exceptions, just be sure they inherit\nfrom Bio::Root::Exception directly, or indirectly by inheriting from a\nBio::Root::Exception subclass.\n\nThe exceptions in Bio::Root::Exception are extensions of Graham Barr's\nL<Error> module available from CPAN.  Despite this dependency, the\nL<Bio::Root::Exception> module does not explicitly C<require Error>.\nThis permits Bio::Root::Exception to be loaded even when\nError.pm is not available.\n\n=head2 Throwing exceptions within Bioperl modules\n\nError.pm is not part of the Bioperl distibution, and may not be\npresent within  any given perl installation. So, when you want to \nthrow an exception in a Bioperl module, the safe way to throw it\nis to use L<Bio::Root::Root/throw> which can use Error.pm \nwhen it's available. See documentation in Bio::Root::Root for details.\n\n=head1 SEE ALSO\n\nSee the C<examples/exceptions> directory of the Bioperl distribution for \nworking demo code.\n\nL<Bio::Root::Root/throw> for information about throwing \nL<Bio::Root::Exception>-based exceptions.\n\nL<Error> (available from CPAN, author: GBARR)\n\nError.pm is helping to guide the design of exception handling in Perl 6. \nSee these RFC's: \n\n     http://dev.perl.org/rfc/63.pod \n\n     http://dev.perl.org/rfc/88.pod\n\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\nThis library is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 EXCEPTIONS\n\n\n# Define some generic exceptions.'\n\npackage Bio::Root::Exception;\nuse Bio::Root::Version;\n\nuse strict;\n\nmy $debug = $Error::Debug;  # Prevents the \"used only once\" warning.\nmy $DEFAULT_VALUE = \"__DUMMY__\";  # Permits eval{} based handlers to work\n\n=head2 L<Bio::Root::Exception>\n\n Purpose : A generic base class for all BioPerl exceptions.\n           By including a \"catch Bio::Root::Exception\" block, you\n           should be able to trap all BioPerl exceptions.\n Example : throw Bio::Root::Exception(\"A generic exception\", $!);\n\n\n#---------------------------------------------------------\n@Bio::Root::Exception::ISA = qw( Error );\n#---------------------------------------------------------\n\n=head1 Methods defined by Bio::Root::Exception\n\n=head2 new\n\n Purpose : Guarantees that -value is set properly before\n           calling Error::new().\n\n Arguments: key-value style arguments same as for Error::new()\n\n     You can also specify plain arguments as ($message, $value)\n     where $value is optional.\n\n     -value, if defined, must be non-zero and not an empty string \n     in order for eval{}-based exception handlers to work. \n     These require that if($@) evaluates to true, which will not \n     be the case if the Error has no value (Error overloads \n     numeric operations to the Error::value() method).\n\n     It is OK to create Bio::Root::Exception objects without\n     specifing -value. In this case, an invisible dummy value is used.\n\n     If you happen to specify a -value of zero (0), it will\n     be replaced by the string \"The number zero (0)\".\n\n     If you happen to specify a -value of empty string (\"\"), it will\n     be replaced by the string \"An empty string (\"\")\"."},"line":238,"kind":12,"range":{"end":{"line":261,"character":9999},"start":{"line":238,"character":0}},"definition":"sub","detail":"($class,@args)","children":[{"name":"$class","localvar":"my","kind":13,"containerName":"new","line":239,"definition":"my"},{"line":239,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$value","line":240},{"line":240,"name":"%params","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":241},{"line":241,"name":"$args","containerName":"new","kind":13},{"line":242,"name":"%params","containerName":"new","kind":13},{"name":"@args","kind":13,"containerName":"new","line":242},{"line":243,"containerName":"new","kind":13,"name":"$value"},{"line":243,"name":"$params","kind":13,"containerName":"new"},{"name":"$params","containerName":"new","kind":13,"line":246},{"line":246,"name":"$args","kind":13,"containerName":"new"},{"line":247,"kind":13,"containerName":"new","name":"$value"},{"containerName":"new","kind":13,"name":"$args","line":247},{"line":250,"name":"$value","containerName":"new","kind":13},{"line":251,"name":"$value","containerName":"new","kind":13},{"line":251,"containerName":"new","kind":13,"name":"$value"},{"name":"$value","kind":13,"containerName":"new","line":251},{"kind":13,"containerName":"new","name":"$value","line":252},{"line":252,"containerName":"new","kind":13,"name":"$value"},{"line":255,"name":"$value","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$DEFAULT_VALUE","line":255},{"line":257,"name":"$params","containerName":"new","kind":13},{"name":"$value","containerName":"new","kind":13,"line":257},{"definition":"my","name":"$self","localvar":"my","containerName":"new","kind":13,"line":259},{"name":"$class","kind":13,"containerName":"new","line":259},{"line":259,"name":"%params","containerName":"new","kind":13},{"line":260,"name":"$self","containerName":"new","kind":13}],"containerName":"main::","name":"new"},{"name":"SUPER","kind":12,"containerName":"new","line":259},{"name":"pretty_format","containerName":"main::","children":[{"line":275,"containerName":"pretty_format","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":276,"kind":13,"localvar":"my","containerName":"pretty_format","name":"$msg","definition":"my"},{"line":276,"containerName":"pretty_format","kind":13,"name":"$self"},{"kind":12,"containerName":"pretty_format","name":"text","line":276},{"kind":13,"localvar":"my","containerName":"pretty_format","name":"$stack","line":277,"definition":"my"},{"line":278,"name":"$Error","kind":13,"containerName":"pretty_format"},{"containerName":"pretty_format","kind":13,"name":"$stack","line":279},{"containerName":"pretty_format","kind":13,"name":"$self","line":279},{"kind":12,"containerName":"pretty_format","name":"_reformat_stacktrace","line":279},{"kind":13,"localvar":"my","containerName":"pretty_format","name":"$value_string","line":281,"definition":"my"},{"containerName":"pretty_format","kind":13,"name":"$self","line":281},{"line":281,"name":"value","containerName":"pretty_format","kind":12},{"line":281,"name":"$DEFAULT_VALUE","kind":13,"containerName":"pretty_format"},{"line":281,"name":"$self","containerName":"pretty_format","kind":13},{"line":281,"kind":12,"containerName":"pretty_format","name":"value"},{"definition":"my","line":282,"localvar":"my","kind":13,"containerName":"pretty_format","name":"$class"},{"name":"$self","kind":13,"containerName":"pretty_format","line":282},{"definition":"my","line":284,"name":"$title","localvar":"my","containerName":"pretty_format","kind":13},{"definition":"my","line":285,"localvar":"my","kind":13,"containerName":"pretty_format","name":"$footer"},{"containerName":"pretty_format","kind":13,"name":"$title","line":285},{"definition":"my","line":286,"name":"$out","localvar":"my","containerName":"pretty_format","kind":13},{"containerName":"pretty_format","kind":13,"name":"$value_string","line":287},{"line":287,"name":"$stack","containerName":"pretty_format","kind":13},{"name":"$footer","containerName":"pretty_format","kind":13,"line":287},{"containerName":"pretty_format","kind":13,"name":"$out","line":288}],"definition":"sub","range":{"end":{"character":9999,"line":289},"start":{"character":0,"line":274}},"kind":12,"line":274},{"line":278,"name":"Debug","containerName":"","kind":12},{"line":285,"name":"CORE","containerName":"length","kind":12},{"line":300,"kind":12,"range":{"start":{"character":0,"line":300},"end":{"character":9999,"line":338}},"definition":"sub","children":[{"definition":"my","line":301,"containerName":"_reformat_stacktrace","localvar":"my","kind":13,"name":"$self"},{"definition":"my","line":302,"containerName":"_reformat_stacktrace","localvar":"my","kind":13,"name":"$msg"},{"line":302,"name":"$self","kind":13,"containerName":"_reformat_stacktrace"},{"name":"text","containerName":"_reformat_stacktrace","kind":12,"line":302},{"definition":"my","line":303,"localvar":"my","containerName":"_reformat_stacktrace","kind":13,"name":"$stack"},{"line":303,"containerName":"_reformat_stacktrace","kind":13,"name":"$self"},{"line":303,"name":"stacktrace","kind":12,"containerName":"_reformat_stacktrace"},{"kind":13,"containerName":"_reformat_stacktrace","name":"$stack","line":304},{"definition":"my","line":305,"containerName":"_reformat_stacktrace","localvar":"my","kind":13,"name":"@stack"},{"kind":13,"containerName":"_reformat_stacktrace","name":"$stack","line":305},{"line":306,"localvar":"my","containerName":"_reformat_stacktrace","kind":13,"name":"@new_stack","definition":"my"},{"line":307,"localvar":"my","containerName":"_reformat_stacktrace","kind":13,"name":"$method","definition":"my"},{"line":307,"kind":13,"containerName":"_reformat_stacktrace","name":"$file"},{"line":307,"name":"$linenum","kind":13,"containerName":"_reformat_stacktrace"},{"containerName":"_reformat_stacktrace","kind":13,"name":"$prev_file","line":307},{"name":"$prev_linenum","containerName":"_reformat_stacktrace","kind":13,"line":307},{"name":"$stack_count","localvar":"my","kind":13,"containerName":"_reformat_stacktrace","line":308,"definition":"my"},{"line":309,"localvar":"my","kind":13,"containerName":"_reformat_stacktrace","name":"$i","definition":"my"},{"containerName":"_reformat_stacktrace","kind":13,"name":"$stack","line":311},{"containerName":"_reformat_stacktrace","kind":13,"name":"$i","line":311},{"line":312,"containerName":"_reformat_stacktrace","kind":13,"name":"$stack"},{"line":312,"kind":13,"containerName":"_reformat_stacktrace","name":"$i"},{"line":313,"name":"$method","kind":13,"containerName":"_reformat_stacktrace"},{"kind":13,"containerName":"_reformat_stacktrace","name":"$file","line":313},{"line":313,"kind":13,"containerName":"_reformat_stacktrace","name":"$linenum"},{"containerName":"_reformat_stacktrace","kind":13,"name":"$stack_count","line":314},{"line":319,"kind":13,"containerName":"_reformat_stacktrace","name":"$stack_count"},{"line":320,"kind":13,"containerName":"_reformat_stacktrace","name":"@new_stack"},{"line":321,"name":"$prev_file","kind":13,"containerName":"_reformat_stacktrace"},{"containerName":"_reformat_stacktrace","kind":13,"name":"$prev_linenum","line":321},{"kind":13,"containerName":"_reformat_stacktrace","name":"$file","line":321},{"name":"$linenum","kind":13,"containerName":"_reformat_stacktrace","line":321},{"line":325,"containerName":"_reformat_stacktrace","kind":13,"name":"$method"},{"line":326,"kind":13,"containerName":"_reformat_stacktrace","name":"$method"},{"line":328,"containerName":"_reformat_stacktrace","kind":13,"name":"$method"},{"line":328,"containerName":"_reformat_stacktrace","kind":13,"name":"$file"},{"name":"$method","kind":13,"containerName":"_reformat_stacktrace","line":329},{"line":332,"kind":13,"containerName":"_reformat_stacktrace","name":"@new_stack"},{"line":333,"kind":13,"containerName":"_reformat_stacktrace","name":"$prev_file"},{"line":333,"kind":13,"containerName":"_reformat_stacktrace","name":"$prev_linenum"},{"line":333,"name":"$file","containerName":"_reformat_stacktrace","kind":13},{"line":333,"name":"$linenum","kind":13,"containerName":"_reformat_stacktrace"},{"name":"@new_stack","kind":13,"containerName":"_reformat_stacktrace","line":335},{"line":337,"kind":13,"containerName":"_reformat_stacktrace","name":"@new_stack"}],"containerName":"main::","name":"_reformat_stacktrace"},{"line":309,"name":"stack","kind":12},{"name":"stringify","containerName":"main::","children":[{"definition":"my","line":355,"name":"$self","containerName":"stringify","localvar":"my","kind":13},{"line":355,"name":"@args","containerName":"stringify","kind":13},{"containerName":"stringify","kind":13,"name":"$self","line":356},{"line":356,"name":"pretty_format","kind":12,"containerName":"stringify"},{"line":356,"containerName":"stringify","kind":13,"name":"@args"}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":357},"start":{"line":354,"character":0}},"line":354,"signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: Exception.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Root::Exception\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n=head1 NAME\n\nBio::Root::Exception - Generic exception objects for Bioperl\n\n=head1 SYNOPSIS\n\n=head2 Throwing exceptions using L<Error.pm throw|Error::throw>:\n\n    use Bio::Root::Exception;\n    use Error;\n\n    # Set Error::Debug to include stack trace data in the error messages\n    $Error::Debug = 1;\n\n    $file = shift;\n    open (IN, $file) ||\n\t    throw Bio::Root::FileOpenException ( \"Can't open file $file for reading\", $!);\n\n=head2 Throwing exceptions using L<Bioperl throw|Bio::Root::Root/throw>:\n\n     # Here we have an object that ISA Bio::Root::Root, so it inherits throw().\n\n     open (IN, $file) || \n                $object->throw(-class => 'Bio::Root::FileOpenException',\n                               -text => \"Can't open file $file for reading\",\n                               -value => $!);\n\n=head2 Catching and handling exceptions using L<Error.pm try|Error/try>:\n\n    use Bio::Root::Exception;\n    use Error qw(:try);\n\n    # Note that we need to import the 'try' tag from Error.pm\n\n    # Set Error::Debug to include stack trace data in the error messages\n    $Error::Debug = 1;\n\n    $file = shift;\n    try {\n        open (IN, $file) ||\n\t    throw Bio::Root::FileOpenException ( \"Can't open file $file for reading\", $!);\n    }\n    catch Bio::Root::FileOpenException with {\n        my $err = shift;\n        print STDERR \"Using default input file: $default_file\\n\";\n        open (IN, $default_file) || die \"Can't open $default_file\";\n    }\n    otherwise {\n        my $err = shift;\n    \tprint STDERR \"An unexpected exception occurred: \\n$err\";\n\n\t# By placing an the error object reference within double quotes,\n\t# you're invoking its stringify() method.\n    }\n   finally {\n       # Any code that you want to execute regardless of whether or not\n       # an exception occurred.\n   };  \n   # the ending semicolon is essential!\n\n\n=head2 Defining a new Exception type as a subclass of Bio::Root::Exception:\n\n    @Bio::TestException::ISA = qw( Bio::Root::Exception );\n\n=head1 DESCRIPTION\n\n=head2 Exceptions defined in L<Bio::Root::Exception>\n\nThese are generic exceptions for typical problem situations that could arise\nin any module or script. \n\n=over 8\n\n* Bio::Root::Exception()\n\n* Bio::Root::NotImplemented()\n\n* Bio::Root::IOException()\n\n* Bio::Root::FileOpenException()\n\n* Bio::Root::SystemException()\n\n* Bio::Root::BadParameter()\n\n* Bio::Root::OutOfRange()\n\n* Bio::Root::NoSuchThing()\n\n\nUsing defined exception classes like these is a good idea because it\nindicates the basic nature of what went wrong in a convenient,\ncomputable way.\n\nIf there is a type of exception that you want to throw\nthat is not covered by the classes listed above, it is easy to define\na new one that fits your needs. Just write a line like the following\nin your module or script where you want to use it (or put it somewhere\nthat is accessible to your code):\n\n    @NoCanDoException::ISA = qw( Bio::Root::Exception );\n\nAll of the exceptions defined in this module inherit from a common\nbase class exception, Bio::Root::Exception. This allows a user to\nwrite a handler for all Bioperl-derived exceptions as follows:\n\n           use Bio::Whatever;\n           use Error qw(:try);\n\n           try {\n                # some code that depends on Bioperl\n           }\n           catch Bio::Root::Exception with {\n               my $err = shift;\n               print \"A Bioperl exception occurred:\\n$err\\n\";\n           };\n\nSo if you do create your own exceptions, just be sure they inherit\nfrom Bio::Root::Exception directly, or indirectly by inheriting from a\nBio::Root::Exception subclass.\n\nThe exceptions in Bio::Root::Exception are extensions of Graham Barr's\nL<Error> module available from CPAN.  Despite this dependency, the\nL<Bio::Root::Exception> module does not explicitly C<require Error>.\nThis permits Bio::Root::Exception to be loaded even when\nError.pm is not available.\n\n=head2 Throwing exceptions within Bioperl modules\n\nError.pm is not part of the Bioperl distibution, and may not be\npresent within  any given perl installation. So, when you want to \nthrow an exception in a Bioperl module, the safe way to throw it\nis to use L<Bio::Root::Root/throw> which can use Error.pm \nwhen it's available. See documentation in Bio::Root::Root for details.\n\n=head1 SEE ALSO\n\nSee the C<examples/exceptions> directory of the Bioperl distribution for \nworking demo code.\n\nL<Bio::Root::Root/throw> for information about throwing \nL<Bio::Root::Exception>-based exceptions.\n\nL<Error> (available from CPAN, author: GBARR)\n\nError.pm is helping to guide the design of exception handling in Perl 6. \nSee these RFC's: \n\n     http://dev.perl.org/rfc/63.pod \n\n     http://dev.perl.org/rfc/88.pod\n\n\n=head1 AUTHOR \n\nSteve Chervitz E<lt>sac@bioperl.orgE<gt>\n\n=head1 COPYRIGHT\n\nCopyright (c) 2001 Steve Chervitz. All Rights Reserved.\n\nThis library is free software; you can redistribute it and/or modify\nit under the same terms as Perl itself.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 EXCEPTIONS\n\n\n# Define some generic exceptions.'\n\npackage Bio::Root::Exception;\nuse Bio::Root::Version;\n\nuse strict;\n\nmy $debug = $Error::Debug;  # Prevents the \"used only once\" warning.\nmy $DEFAULT_VALUE = \"__DUMMY__\";  # Permits eval{} based handlers to work\n\n=head2 L<Bio::Root::Exception>\n\n Purpose : A generic base class for all BioPerl exceptions.\n           By including a \"catch Bio::Root::Exception\" block, you\n           should be able to trap all BioPerl exceptions.\n Example : throw Bio::Root::Exception(\"A generic exception\", $!);\n\n\n#---------------------------------------------------------\n@Bio::Root::Exception::ISA = qw( Error );\n#---------------------------------------------------------\n\n=head1 Methods defined by Bio::Root::Exception\n\n=head2 new\n\n Purpose : Guarantees that -value is set properly before\n           calling Error::new().\n\n Arguments: key-value style arguments same as for Error::new()\n\n     You can also specify plain arguments as ($message, $value)\n     where $value is optional.\n\n     -value, if defined, must be non-zero and not an empty string \n     in order for eval{}-based exception handlers to work. \n     These require that if($@) evaluates to true, which will not \n     be the case if the Error has no value (Error overloads \n     numeric operations to the Error::value() method).\n\n     It is OK to create Bio::Root::Exception objects without\n     specifing -value. In this case, an invisible dummy value is used.\n\n     If you happen to specify a -value of zero (0), it will\n     be replaced by the string \"The number zero (0)\".\n\n     If you happen to specify a -value of empty string (\"\"), it will\n     be replaced by the string \"An empty string (\"\")\".\n\n\nsub new {\n    my ($class, @args) = @_; \n    my ($value, %params);\n    if( @args % 2 == 0 && $args[0] =~ /^-/) {\n        %params = @args;\n        $value = $params{'-value'};\n    }\n    else {\n        $params{-text} = $args[0];\n        $value = $args[1];\n    }\n\n    if( defined $value ) {\n        $value = \"The number zero (0)\" if $value =~ /^\\d+$/ && $value == 0;\n        $value = \"An empty string (\\\"\\\")\" if $value eq \"\";\n    }\n    else {\n\t$value ||= $DEFAULT_VALUE;\n    }\n    $params{-value} = $value;\n\n    my $self = $class->SUPER::new( %params );\n    return $self;\n}\n\n=head2 pretty_format()\n\n Purpose : Get a nicely formatted string containing information about the \n           exception. Format is similar to that produced by \n           Bio::Root::Root::throw(), with the addition of the name of\n           the exception class in the EXCEPTION line and some other\n           data available via the Error object.\n Example : print $error->pretty_format;\n\n\nsub pretty_format {\n    my $self = shift;\n    my $msg = $self->text;\n    my $stack = '';\n    if( $Error::Debug ) {\n      $stack = $self->_reformat_stacktrace();\n    }\n    my $value_string = $self->value ne $DEFAULT_VALUE ? \"VALUE: \".$self->value.\"\\n\" : \"\";\n    my $class = ref($self);\n\n    my $title = \"------------- EXCEPTION: $class -------------\";\n    my $footer = \"\\n\" . '-' x CORE::length($title);\n    my $out = \"\\n$title\\n\" .\n       \"MSG: $msg\\n\". $value_string. $stack. $footer . \"\\n\";\n    return $out;\n}\n\n\n# Reformatting of the stack performed by  _reformat_stacktrace:\n#   1. Shift the file:line data in line i to line i+1.\n#   2. change xxx::__ANON__() to \"try{} block\"\n#   3. skip the \"require\" and \"Error::subs::try\" stack entries (boring)\n# This means that the first line in the stack won't have any file:line data\n# But this isn't a big issue since it's for a Bio::Root::-based method \n# that doesn't vary from exception to exception.\n\nsub _reformat_stacktrace {\n    my $self = shift;\n    my $msg = $self->text;\n    my $stack = $self->stacktrace();\n    $stack =~ s/\\Q$msg//;\n    my @stack = split( /\\n/, $stack);\n    my @new_stack = ();\n    my ($method, $file, $linenum, $prev_file, $prev_linenum);\n    my $stack_count = 0;\n    foreach my $i( 0..$#stack ) {\n        # print \"STACK-ORIG: $stack[$i]\\n\";\n        if( ($stack[$i] =~ /^\\s*([^(]+)\\s*\\(.*\\) called at (\\S+) line (\\d+)/) ||\n             ($stack[$i] =~ /^\\s*(require 0) called at (\\S+) line (\\d+)/)) {\n            ($method, $file, $linenum) = ($1, $2, $3);\n            $stack_count++;\n        }\n        else{\n            next;\n        }\n        if( $stack_count == 1 ) {\n            push @new_stack, \"STACK: $method\";\n            ($prev_file, $prev_linenum) = ($file, $linenum);\n            next;\n        }\n\n        if( $method =~ /__ANON__/ ) {\n            $method = \"try{} block\";\n        }\n        if( ($method =~ /^require/ and $file =~ /Error\\.pm/ ) ||\n            ($method =~ /^Error::subs::try/ ) )   {\n            last;\n        }\n        push @new_stack, \"STACK: $method $prev_file:$prev_linenum\";\n        ($prev_file, $prev_linenum) = ($file, $linenum);\n    }\n    push @new_stack, \"STACK: $prev_file:$prev_linenum\";\n\n    return join \"\\n\", @new_stack;\n}\n\n=head2 stringify()\n\n Purpose : Overrides Error::stringify() to call pretty_format(). \n           This is called automatically when an exception object \n           is placed between double quotes.\n Example : catch Bio::Root::Exception with {\n              my $error = shift;\n              print \"$error\";\n           }\n\nSee Also: L<pretty_format()|pretty_format>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"stringify($self,@args)"}},{"kind":13,"containerName":null,"name":"@Bio","line":371},{"line":371,"name":"Root","kind":12,"containerName":"NotImplemented::ISA"},{"containerName":null,"kind":13,"name":"@Bio","line":384},{"line":384,"name":"Root","containerName":"IOException::ISA","kind":12},{"name":"@Bio","containerName":null,"kind":13,"line":398},{"line":398,"containerName":"FileOpenException::ISA","kind":12,"name":"Root"},{"line":412,"kind":13,"containerName":null,"name":"@Bio"},{"kind":12,"containerName":"SystemException::ISA","name":"Root","line":412},{"name":"@Bio","containerName":null,"kind":13,"line":427},{"name":"Root","kind":12,"containerName":"BadParameter::ISA","line":427},{"kind":13,"containerName":null,"name":"@Bio","line":442},{"line":442,"name":"Root","containerName":"OutOfRange::ISA","kind":12},{"line":457,"name":"@Bio","containerName":null,"kind":13},{"name":"Root","containerName":"NoSuchThing::ISA","kind":12,"line":457}],"version":5}