{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":83},{"containerName":"main::","name":"unique_id","children":[{"definition":"my","line":98,"localvar":"my","kind":13,"containerName":"unique_id","name":"$self"},{"line":99,"kind":13,"containerName":"unique_id","name":"$self"},{"containerName":"unique_id","kind":12,"name":"throw_not_implemented","line":99}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":97,"character":0},"end":{"line":100,"character":9999}},"line":97,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::IndividualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IndividualI - An individual who has Genotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  # Get a Bio::PopGen::IndividualI somehow\n  # test if it has alleles/genotypes for a given marker\n  if( $ind->has_marker($markername) ) {\n  }\n  # get the unique id\n  print $ind->unique_id, \"\\n\";\n\n  # get the number of results (genotypes)\n  print $ind->num_results;\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IndividualI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string","label":"unique_id($self)"}},{"kind":12,"range":{"start":{"line":113,"character":0},"end":{"line":115,"character":9999}},"line":113,"containerName":"main::","name":"num_genotypes","children":[{"containerName":"num_genotypes","kind":12,"name":"throw_not_implemented","line":114}],"definition":"sub"},{"name":"num_of_results","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"num_of_results","name":"$self","line":118,"definition":"my"},{"line":119,"kind":13,"containerName":"num_of_results","name":"$self"},{"line":119,"name":"deprecated","kind":12,"containerName":"num_of_results"},{"name":"$self","kind":13,"containerName":"num_of_results","line":120},{"line":120,"name":"num_genotypes","kind":12,"containerName":"num_of_results"}],"definition":"sub","range":{"start":{"character":0,"line":117},"end":{"line":121,"character":9999}},"kind":12,"line":117},{"signature":{"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::IndividualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IndividualI - An individual who has Genotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  # Get a Bio::PopGen::IndividualI somehow\n  # test if it has alleles/genotypes for a given marker\n  if( $ind->has_marker($markername) ) {\n  }\n  # get the unique id\n  print $ind->unique_id, \"\\n\";\n\n  # get the number of results (genotypes)\n  print $ind->num_results;\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IndividualI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 num_genotypes\n\n Title   : num_genotypes\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_genotypes { \n    shift->throw_not_implemented;\n}\n\nsub num_of_results{ \n    my $self = shift;\n    $self->deprecated(\"num_of_results is deprecated, use num_genotypes instead\");\n    $self->num_genotypes;\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object","parameters":[{"label":"$self"},{"label":"$arg"}],"label":"annotation($self,$arg)"},"kind":12,"range":{"end":{"line":136,"character":9999},"start":{"line":133,"character":0}},"line":133,"detail":"($self,$arg)","definition":"sub","containerName":"main::","name":"annotation","children":[{"line":134,"localvar":"my","kind":13,"containerName":"annotation","name":"$self","definition":"my"},{"line":134,"containerName":"annotation","kind":13,"name":"$arg"},{"line":135,"kind":13,"containerName":"annotation","name":"$self"},{"line":135,"kind":12,"containerName":"annotation","name":"throw_not_implemented"}]},{"line":150,"kind":12,"range":{"start":{"character":0,"line":150},"end":{"line":153,"character":9999}},"signature":{"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::IndividualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IndividualI - An individual who has Genotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  # Get a Bio::PopGen::IndividualI somehow\n  # test if it has alleles/genotypes for a given marker\n  if( $ind->has_marker($markername) ) {\n  }\n  # get the unique id\n  print $ind->unique_id, \"\\n\";\n\n  # get the number of results (genotypes)\n  print $ind->num_results;\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IndividualI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 num_genotypes\n\n Title   : num_genotypes\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_genotypes { \n    shift->throw_not_implemented;\n}\n\nsub num_of_results{ \n    my $self = shift;\n    $self->deprecated(\"num_of_results is deprecated, use num_genotypes instead\");\n    $self->num_genotypes;\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)","parameters":[{"label":"$self"}],"label":"get_Genotypes($self)"},"children":[{"definition":"my","line":151,"localvar":"my","kind":13,"containerName":"get_Genotypes","name":"$self"},{"containerName":"get_Genotypes","kind":13,"name":"$self","line":152},{"line":152,"name":"throw_not_implemented","containerName":"get_Genotypes","kind":12}],"containerName":"main::","name":"get_Genotypes","definition":"sub","detail":"($self)"},{"line":167,"range":{"end":{"line":170,"character":9999},"start":{"line":167,"character":0}},"kind":12,"signature":{"label":"has_Marker($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::IndividualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IndividualI - An individual who has Genotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  # Get a Bio::PopGen::IndividualI somehow\n  # test if it has alleles/genotypes for a given marker\n  if( $ind->has_marker($markername) ) {\n  }\n  # get the unique id\n  print $ind->unique_id, \"\\n\";\n\n  # get the number of results (genotypes)\n  print $ind->num_results;\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IndividualI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 num_genotypes\n\n Title   : num_genotypes\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_genotypes { \n    shift->throw_not_implemented;\n}\n\nsub num_of_results{ \n    my $self = shift;\n    $self->deprecated(\"num_of_results is deprecated, use num_genotypes instead\");\n    $self->num_genotypes;\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)\n\n\n\nsub get_Genotypes{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 has_Marker\n\n Title   : has_Marker\n Usage   : if( $ind->has_Marker($name) ) {}\n Function: Boolean test to see if an Individual has a genotype \n           for a specific marker\n Returns : Boolean (true or false)\n Args    : String representing a marker name"},"children":[{"definition":"my","containerName":"has_Marker","localvar":"my","kind":13,"name":"$self","line":168},{"name":"$name","containerName":"has_Marker","kind":13,"line":168},{"kind":13,"containerName":"has_Marker","name":"$self","line":169},{"line":169,"name":"throw_not_implemented","containerName":"has_Marker","kind":12}],"name":"has_Marker","containerName":"main::","definition":"sub","detail":"($self,$name)"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id $\n#\n# BioPerl module for Bio::PopGen::IndividualI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IndividualI - An individual who has Genotype or Sequence Results\n\n=head1 SYNOPSIS\n\n  # Get a Bio::PopGen::IndividualI somehow\n  # test if it has alleles/genotypes for a given marker\n  if( $ind->has_marker($markername) ) {\n  }\n  # get the unique id\n  print $ind->unique_id, \"\\n\";\n\n  # get the number of results (genotypes)\n  print $ind->num_results;\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IndividualI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 unique_id\n\n Title   : unique_id\n Usage   : my $id = $individual->unique_id\n Function: Unique Identifier\n Returns : string representing unique identifier\n Args    : string\n\n\n\nsub unique_id{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 num_genotypes\n\n Title   : num_genotypes\n Usage   : my $count = $person->num_results;\n Function: returns the count of the number of Results for a person\n Returns : integer\n Args    : none\n\n\nsub num_genotypes { \n    shift->throw_not_implemented;\n}\n\nsub num_of_results{ \n    my $self = shift;\n    $self->deprecated(\"num_of_results is deprecated, use num_genotypes instead\");\n    $self->num_genotypes;\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $ind->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this individual\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $ind->get_Genotypes(-marker => $markername);\n Function: Get the genotypes for an individual, based on a criteria\n Returns : Array of genotypes\n Args    : either none (return all genotypes) or \n           -marker => name of marker to return (exact match, case matters)\n\n\n\nsub get_Genotypes{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 has_Marker\n\n Title   : has_Marker\n Usage   : if( $ind->has_Marker($name) ) {}\n Function: Boolean test to see if an Individual has a genotype \n           for a specific marker\n Returns : Boolean (true or false)\n Args    : String representing a marker name\n\n\n\nsub has_Marker{\n   my ($self,$name) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $individual->get_marker_names;\n Function: Returns the list of known marker names\n Returns : List of strings\n Args    : none","label":"get_marker_names($self)"},"range":{"end":{"character":9999,"line":186},"start":{"character":0,"line":183}},"kind":12,"line":183,"detail":"($self)","definition":"sub","containerName":"main::","name":"get_marker_names","children":[{"line":184,"localvar":"my","kind":13,"containerName":"get_marker_names","name":"$self","definition":"my"},{"name":"$self","containerName":"get_marker_names","kind":13,"line":185},{"line":185,"name":"throw_not_implemented","containerName":"get_marker_names","kind":12}]}]}