{"vars":[{"containerName":"","kind":2,"name":"base","line":62},{"children":[{"line":80,"name":"$pkg","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":80,"containerName":"new","kind":13,"name":"$cont"},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":81,"definition":"my"},{"kind":13,"containerName":"new","name":"$pkg","line":81},{"kind":13,"localvar":"my","containerName":"new","name":"@arr","line":82,"definition":"my"},{"name":"$cont","kind":13,"containerName":"new","line":83},{"definition":"my","line":85,"containerName":"new","localvar":"my","kind":13,"name":"$i"},{"line":85,"name":"$i","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$cont","line":85},{"name":"$i","containerName":"new","kind":13,"line":85},{"line":86,"kind":13,"containerName":"new","name":"$arr"},{"kind":13,"containerName":"new","name":"$i","line":86},{"name":"$self","kind":13,"containerName":"new","line":88},{"line":88,"kind":13,"containerName":"new","name":"@arr"},{"name":"@arr","kind":13,"containerName":"new","line":91},{"line":91,"kind":13,"containerName":"new","name":"$cont"}],"containerName":"main::","name":"new","definition":"sub","detail":"($pkg,$cont)","line":79,"range":{"start":{"line":79,"character":0},"end":{"character":9999,"line":92}},"kind":12,"signature":{"label":"new($pkg,$cont)","documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.","parameters":[{"label":"$pkg"},{"label":"$cont"}]}},{"line":81,"name":"SUPER","kind":12,"containerName":"new"},{"line":88,"name":"arr","kind":12},{"line":93,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"dim","line":93},{"line":93,"name":"@arr","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":94},{"line":94,"name":"arr","kind":12},{"containerName":null,"kind":13,"name":"@arr","line":94},{"kind":13,"containerName":null,"name":"$self","line":95},{"line":95,"name":"$pkg","containerName":null,"kind":13},{"name":"$self","kind":13,"containerName":null,"line":96},{"definition":"sub","containerName":"main::","name":"dim","children":[],"range":{"end":{"line":101,"character":9999},"start":{"line":99,"character":0}},"kind":12,"line":99},{"kind":12,"name":"dim","line":100},{"name":"overload","kind":2,"containerName":"","line":104},{"name":"add","kind":12,"line":104},{"name":"substract","kind":12,"line":105},{"line":106,"name":"scalarproduct","kind":12},{"name":"comparelex","kind":12,"line":107},{"line":108,"kind":12,"name":"comparelex"},{"kind":12,"name":"display","line":109},{"name":"as_array","kind":12,"line":110},{"range":{"end":{"character":9999,"line":114},"start":{"line":112,"character":0}},"kind":12,"line":112,"name":"as_array","containerName":"main::","children":[],"definition":"sub"},{"line":113,"kind":12,"name":"arr"},{"signature":{"label":"display($self)","documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.","parameters":[{"label":"$self"}]},"line":128,"range":{"start":{"character":0,"line":128},"end":{"line":130,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"kind":13,"localvar":"my","containerName":"display","name":"$self","line":129,"definition":"my"},{"line":130,"name":"@arr","containerName":"display","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"display","name":"$self","line":130}],"containerName":"main::","name":"display"},{"line":130,"kind":12,"name":"arr"},{"signature":{"label":"add($v1,$v2)","documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.","parameters":[{"label":"$v1"},{"label":"$v2"}]},"line":146,"range":{"end":{"line":157,"character":9999},"start":{"line":146,"character":0}},"kind":12,"definition":"sub","detail":"($v1,$v2)","children":[{"kind":13,"localvar":"my","containerName":"add","name":"$v1","line":147,"definition":"my"},{"name":"$v2","containerName":"add","kind":13,"line":147},{"name":"$v1","containerName":"add","kind":13,"line":149},{"line":149,"containerName":"add","kind":12,"name":"throw"},{"containerName":"add","kind":13,"name":"$v1","line":149},{"line":149,"name":"$v2","containerName":"add","kind":13},{"definition":"my","localvar":"my","containerName":"add","kind":13,"name":"$dim","line":150},{"line":150,"name":"$v1","kind":13,"containerName":"add"},{"definition":"my","name":"@sum","containerName":"add","localvar":"my","kind":13,"line":151},{"definition":"my","kind":13,"localvar":"my","containerName":"add","name":"$i","line":152},{"line":152,"kind":13,"containerName":"add","name":"$i"},{"containerName":"add","kind":13,"name":"$dim","line":152},{"line":152,"kind":13,"containerName":"add","name":"$i"},{"line":153,"kind":13,"containerName":"add","name":"$sum"},{"line":153,"containerName":"add","kind":13,"name":"$i"},{"kind":13,"containerName":"add","name":"$v1","line":153},{"kind":13,"containerName":"add","name":"$i","line":153},{"containerName":"add","kind":13,"name":"$v2","line":153},{"name":"$i","kind":13,"containerName":"add","line":153},{"line":155,"name":"$result","kind":13,"localvar":"my","containerName":"add","definition":"my"},{"containerName":"add","kind":12,"name":"new","line":155},{"line":155,"name":"@sum","containerName":"add","kind":13},{"name":"$result","kind":13,"containerName":"add","line":156}],"containerName":"main::","name":"add"},{"line":149,"name":"dim","kind":12},{"line":149,"name":"dim","kind":12},{"line":150,"name":"dim","kind":12},{"name":"Bio","kind":12,"containerName":"PhyloNetwork::muVector","line":155},{"signature":{"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.","parameters":[{"label":"$v1"},{"label":"$v2"}],"label":"substract($v1,$v2)"},"kind":12,"range":{"start":{"character":0,"line":171},"end":{"line":182,"character":9999}},"line":171,"detail":"($v1,$v2)","definition":"sub","name":"substract","containerName":"main::","children":[{"definition":"my","line":172,"name":"$v1","containerName":"substract","localvar":"my","kind":13},{"line":172,"containerName":"substract","kind":13,"name":"$v2"},{"line":174,"kind":13,"containerName":"substract","name":"$v1"},{"name":"throw","kind":12,"containerName":"substract","line":174},{"name":"$v1","containerName":"substract","kind":13,"line":174},{"containerName":"substract","kind":13,"name":"$v2","line":174},{"definition":"my","name":"$dim","localvar":"my","containerName":"substract","kind":13,"line":175},{"line":175,"name":"$v1","kind":13,"containerName":"substract"},{"definition":"my","containerName":"substract","localvar":"my","kind":13,"name":"@sum","line":176},{"definition":"my","localvar":"my","kind":13,"containerName":"substract","name":"$i","line":177},{"containerName":"substract","kind":13,"name":"$i","line":177},{"name":"$dim","kind":13,"containerName":"substract","line":177},{"containerName":"substract","kind":13,"name":"$i","line":177},{"containerName":"substract","kind":13,"name":"$sum","line":178},{"name":"$i","containerName":"substract","kind":13,"line":178},{"name":"$v1","containerName":"substract","kind":13,"line":178},{"containerName":"substract","kind":13,"name":"$i","line":178},{"line":178,"name":"$v2","kind":13,"containerName":"substract"},{"containerName":"substract","kind":13,"name":"$i","line":178},{"line":180,"name":"$result","kind":13,"localvar":"my","containerName":"substract","definition":"my"},{"line":180,"name":"new","kind":12,"containerName":"substract"},{"line":180,"containerName":"substract","kind":13,"name":"@sum"},{"containerName":"substract","kind":13,"name":"$result","line":181}]},{"line":174,"name":"dim","kind":12},{"line":174,"kind":12,"name":"dim"},{"line":175,"kind":12,"name":"dim"},{"line":178,"name":"arr","kind":12},{"line":178,"kind":12,"name":"arr"},{"line":180,"kind":12,"containerName":"PhyloNetwork::muVector","name":"Bio"},{"range":{"start":{"line":196,"character":0},"end":{"character":9999,"line":207}},"kind":12,"line":196,"signature":{"label":"scalarproduct($v1,$num,$swapped)","parameters":[{"label":"$v1"},{"label":"$num"},{"label":"$swapped"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator."},"name":"scalarproduct","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"scalarproduct","name":"$v1","line":197,"definition":"my"},{"kind":13,"containerName":"scalarproduct","name":"$num","line":197},{"line":197,"containerName":"scalarproduct","kind":13,"name":"$swapped"},{"definition":"my","line":199,"name":"$dim","localvar":"my","containerName":"scalarproduct","kind":13},{"name":"$v1","kind":13,"containerName":"scalarproduct","line":199},{"definition":"my","line":200,"containerName":"scalarproduct","localvar":"my","kind":13,"name":"@sum"},{"line":201,"name":"$i","kind":13,"localvar":"my","containerName":"scalarproduct","definition":"my"},{"line":201,"name":"$i","containerName":"scalarproduct","kind":13},{"name":"$dim","containerName":"scalarproduct","kind":13,"line":201},{"line":201,"containerName":"scalarproduct","kind":13,"name":"$i"},{"line":202,"kind":13,"containerName":"scalarproduct","name":"$sum"},{"containerName":"scalarproduct","kind":13,"name":"$i","line":202},{"line":202,"kind":13,"containerName":"scalarproduct","name":"$num"},{"line":202,"name":"$v1","kind":13,"containerName":"scalarproduct"},{"line":202,"name":"$i","containerName":"scalarproduct","kind":13},{"definition":"my","line":204,"name":"$result","containerName":"scalarproduct","localvar":"my","kind":13},{"name":"new","kind":12,"containerName":"scalarproduct","line":204},{"line":204,"name":"@sum","kind":13,"containerName":"scalarproduct"},{"line":205,"containerName":"scalarproduct","kind":13,"name":"$result"},{"name":"$result","containerName":"scalarproduct","kind":13,"line":206}],"detail":"($v1,$num,$swapped)","definition":"sub"},{"name":"dim","kind":12,"line":199},{"line":202,"kind":12,"name":"arr"},{"containerName":"PhyloNetwork::muVector","kind":12,"name":"Bio","line":204},{"name":"comparelex","containerName":"main::","children":[{"line":222,"name":"$v1","containerName":"comparelex","localvar":"my","kind":13,"definition":"my"},{"name":"$v2","kind":13,"containerName":"comparelex","line":222},{"name":"$v1","containerName":"comparelex","kind":13,"line":224},{"containerName":"comparelex","kind":12,"name":"throw","line":224},{"line":224,"name":"$v1","kind":13,"containerName":"comparelex"},{"containerName":"comparelex","kind":13,"name":"$v2","line":224},{"definition":"my","line":225,"name":"$dim","localvar":"my","containerName":"comparelex","kind":13},{"name":"$v1","kind":13,"containerName":"comparelex","line":225},{"definition":"my","containerName":"comparelex","localvar":"my","kind":13,"name":"$i","line":226},{"line":226,"kind":13,"containerName":"comparelex","name":"$i"},{"line":226,"containerName":"comparelex","kind":13,"name":"$dim"},{"line":226,"containerName":"comparelex","kind":13,"name":"$i"},{"line":227,"name":"$v1","kind":13,"containerName":"comparelex"},{"name":"$i","containerName":"comparelex","kind":13,"line":227},{"containerName":"comparelex","kind":13,"name":"$v2","line":227},{"name":"$i","kind":13,"containerName":"comparelex","line":227},{"line":228,"kind":13,"containerName":"comparelex","name":"$v1"},{"containerName":"comparelex","kind":13,"name":"$i","line":228},{"line":228,"containerName":"comparelex","kind":13,"name":"$v2"},{"name":"$i","kind":13,"containerName":"comparelex","line":228}],"detail":"($v1,$v2)","definition":"sub","range":{"end":{"character":9999,"line":231},"start":{"line":221,"character":0}},"kind":12,"line":221,"signature":{"label":"comparelex($v1,$v2)","documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.","parameters":[{"label":"$v1"},{"label":"$v2"}]}},{"line":224,"kind":12,"name":"dim"},{"kind":12,"name":"dim","line":224},{"line":225,"kind":12,"name":"dim"},{"line":227,"kind":12,"name":"arr"},{"name":"arr","kind":12,"line":227},{"line":228,"kind":12,"name":"arr"},{"line":228,"kind":12,"name":"arr"},{"line":243,"range":{"end":{"character":9999,"line":252},"start":{"line":243,"character":0}},"kind":12,"signature":{"label":"geq_poset($v1,$v2)","parameters":[{"label":"$v1"},{"label":"$v2"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.\n\n\nsub comparelex {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return -1 if $v1->{arr}->[$i] < $v2->{arr}->[$i];\n    return 1 if $v1->{arr}->[$i] > $v2->{arr}->[$i];\n  }\n  return 0;\n}\n\n=head2 geq_poset\n\n Title   : geq_poset\n Usage   : $mu1->geq_poset($mu2)\n Function: compares $mu and $mu2 w.r.t. the natural partial ordering\n Returns : boolean (1 if $mu >= $mu2, 0 otherwise)\n Args    : Bio::PhyloNetwork::muVector"},"children":[{"definition":"my","line":244,"name":"$v1","localvar":"my","containerName":"geq_poset","kind":13},{"line":244,"containerName":"geq_poset","kind":13,"name":"$v2"},{"name":"$v1","containerName":"geq_poset","kind":13,"line":246},{"line":246,"kind":12,"containerName":"geq_poset","name":"throw"},{"kind":13,"containerName":"geq_poset","name":"$v1","line":246},{"line":246,"name":"$v2","kind":13,"containerName":"geq_poset"},{"definition":"my","localvar":"my","kind":13,"containerName":"geq_poset","name":"$dim","line":247},{"line":247,"name":"$v1","kind":13,"containerName":"geq_poset"},{"name":"$i","localvar":"my","containerName":"geq_poset","kind":13,"line":248,"definition":"my"},{"line":248,"containerName":"geq_poset","kind":13,"name":"$i"},{"line":248,"name":"$dim","kind":13,"containerName":"geq_poset"},{"line":248,"kind":13,"containerName":"geq_poset","name":"$i"},{"name":"$v1","kind":13,"containerName":"geq_poset","line":249},{"line":249,"name":"$i","containerName":"geq_poset","kind":13},{"containerName":"geq_poset","kind":13,"name":"$v2","line":249},{"line":249,"kind":13,"containerName":"geq_poset","name":"$i"}],"name":"geq_poset","containerName":"main::","definition":"sub","detail":"($v1,$v2)"},{"kind":12,"name":"dim","line":246},{"line":246,"kind":12,"name":"dim"},{"line":247,"kind":12,"name":"dim"},{"signature":{"parameters":[{"label":"$v1"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.\n\n\nsub comparelex {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return -1 if $v1->{arr}->[$i] < $v2->{arr}->[$i];\n    return 1 if $v1->{arr}->[$i] > $v2->{arr}->[$i];\n  }\n  return 0;\n}\n\n=head2 geq_poset\n\n Title   : geq_poset\n Usage   : $mu1->geq_poset($mu2)\n Function: compares $mu and $mu2 w.r.t. the natural partial ordering\n Returns : boolean (1 if $mu >= $mu2, 0 otherwise)\n Args    : Bio::PhyloNetwork::muVector\n\n\nsub geq_poset {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= $v2->[$i];\n  }\n  return 1;\n}\n\n=head2 is_positive\n\n Title   : is_positive\n Usage   : $mu->is_positive()\n Function: tests if all components of $mu are positive (or zero)\n Returns : boolean\n Args    : none","label":"is_positive($v1)"},"line":264,"range":{"start":{"character":0,"line":264},"end":{"character":9999,"line":272}},"kind":12,"definition":"sub","detail":"($v1)","children":[{"definition":"my","line":265,"containerName":"is_positive","localvar":"my","kind":13,"name":"$v1"},{"line":267,"name":"$dim","containerName":"is_positive","localvar":"my","kind":13,"definition":"my"},{"line":267,"name":"$v1","kind":13,"containerName":"is_positive"},{"kind":13,"localvar":"my","containerName":"is_positive","name":"$i","line":268,"definition":"my"},{"line":268,"kind":13,"containerName":"is_positive","name":"$i"},{"name":"$dim","containerName":"is_positive","kind":13,"line":268},{"kind":13,"containerName":"is_positive","name":"$i","line":268},{"name":"$v1","kind":13,"containerName":"is_positive","line":269},{"line":269,"name":"$i","kind":13,"containerName":"is_positive"}],"containerName":"main::","name":"is_positive"},{"kind":12,"name":"dim","line":267},{"containerName":"main::","name":"hamming","children":[{"line":285,"kind":13,"localvar":"my","containerName":"hamming","name":"$v1","definition":"my"},{"kind":13,"containerName":"hamming","name":"$v2","line":285},{"kind":13,"containerName":"hamming","name":"$v1","line":287},{"line":287,"kind":12,"containerName":"hamming","name":"throw"},{"line":287,"name":"$v1","containerName":"hamming","kind":13},{"line":287,"name":"$v2","containerName":"hamming","kind":13},{"line":288,"localvar":"my","kind":13,"containerName":"hamming","name":"$dim","definition":"my"},{"kind":13,"containerName":"hamming","name":"$v1","line":288},{"definition":"my","line":289,"name":"$w","localvar":"my","kind":13,"containerName":"hamming"},{"containerName":"hamming","localvar":"my","kind":13,"name":"$i","line":290,"definition":"my"},{"containerName":"hamming","kind":13,"name":"$i","line":290},{"containerName":"hamming","kind":13,"name":"$dim","line":290},{"containerName":"hamming","kind":13,"name":"$i","line":290},{"line":291,"containerName":"hamming","kind":13,"name":"$w"},{"line":291,"kind":13,"containerName":"hamming","name":"$v1"},{"line":291,"kind":13,"containerName":"hamming","name":"$i"},{"kind":13,"containerName":"hamming","name":"$v2","line":291},{"kind":13,"containerName":"hamming","name":"$i","line":291},{"line":293,"kind":13,"containerName":"hamming","name":"$w"}],"detail":"($v1,$v2)","definition":"sub","range":{"start":{"character":0,"line":284},"end":{"character":9999,"line":294}},"kind":12,"line":284,"signature":{"parameters":[{"label":"$v1"},{"label":"$v2"}],"documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.\n\n\nsub comparelex {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return -1 if $v1->{arr}->[$i] < $v2->{arr}->[$i];\n    return 1 if $v1->{arr}->[$i] > $v2->{arr}->[$i];\n  }\n  return 0;\n}\n\n=head2 geq_poset\n\n Title   : geq_poset\n Usage   : $mu1->geq_poset($mu2)\n Function: compares $mu and $mu2 w.r.t. the natural partial ordering\n Returns : boolean (1 if $mu >= $mu2, 0 otherwise)\n Args    : Bio::PhyloNetwork::muVector\n\n\nsub geq_poset {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= $v2->[$i];\n  }\n  return 1;\n}\n\n=head2 is_positive\n\n Title   : is_positive\n Usage   : $mu->is_positive()\n Function: tests if all components of $mu are positive (or zero)\n Returns : boolean\n Args    : none\n\n\nsub is_positive {\n  my ($v1)=@_;\n\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= 0;\n  }\n  return 1;\n}\n\n=head2 hamming\n\n Title   : hamming\n Usage   : $mu1->hamming($mu2)\n Function: returns the Hamming distance between $mu1 and $mu2\n Returns : scalar\n Args    : Bio::PhyloNetwork::muVector","label":"hamming($v1,$v2)"}},{"line":287,"name":"dim","kind":12},{"line":287,"kind":12,"name":"dim"},{"line":288,"name":"dim","kind":12},{"children":[{"line":307,"name":"$v1","kind":13,"localvar":"my","containerName":"manhattan","definition":"my"},{"kind":13,"containerName":"manhattan","name":"$v2","line":307},{"line":309,"containerName":"manhattan","kind":13,"name":"$v1"},{"line":309,"containerName":"manhattan","kind":12,"name":"throw"},{"line":309,"containerName":"manhattan","kind":13,"name":"$v1"},{"name":"$v2","kind":13,"containerName":"manhattan","line":309},{"name":"$dim","containerName":"manhattan","localvar":"my","kind":13,"line":310,"definition":"my"},{"line":310,"name":"$v1","kind":13,"containerName":"manhattan"},{"line":311,"localvar":"my","containerName":"manhattan","kind":13,"name":"$w","definition":"my"},{"name":"$i","containerName":"manhattan","localvar":"my","kind":13,"line":312,"definition":"my"},{"line":312,"name":"$i","containerName":"manhattan","kind":13},{"line":312,"name":"$dim","containerName":"manhattan","kind":13},{"line":312,"containerName":"manhattan","kind":13,"name":"$i"},{"line":313,"name":"$w","kind":13,"containerName":"manhattan"},{"name":"$v1","kind":13,"containerName":"manhattan","line":313},{"line":313,"name":"$i","kind":13,"containerName":"manhattan"},{"line":313,"kind":13,"containerName":"manhattan","name":"$v2"},{"line":313,"containerName":"manhattan","kind":13,"name":"$i"},{"line":315,"name":"$w","kind":13,"containerName":"manhattan"}],"containerName":"main::","name":"manhattan","definition":"sub","detail":"($v1,$v2)","line":306,"kind":12,"range":{"end":{"line":316,"character":9999},"start":{"line":306,"character":0}},"signature":{"label":"manhattan($v1,$v2)","documentation":"1;\n# $Id: muVector.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::muVector\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::muVector - Module to compute with vectors of arbitrary\ndimension\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork::muVector;\n\n my $vec1=Bio::PhyloNetwork::muVector->new(4);\n my $vec2=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n my $vec3=Bio::PhyloNetwork::muVector->new([10,20,30,40]);\n\n my $vec4=$vec3-10*$vec2;\n if (($vec4 cmp $vec1) == 0) {\n   print \"$vec4 is zero\\n\";\n }\n\n my $vec5=Bio::PhyloNetwork::muVector->new([8,2,2,4]);\n my $vec6=Bio::PhyloNetwork::muVector->new([1,2,3,4]);\n\n print \"Test poset $vec5 > $vec6: \".$vec5->geq_poset($vec6).\"\\n\";\n print \"Test lex $vec5 > $vec6: \".($vec5 cmp $vec6).\"\\n\";\n\n=head1 DESCRIPTION\n\nThis is a module to work with vectors. It creates\nvectors of arbitrary length, defines its basic arithmetic operations,\nits lexicographic ordering and the natural structure of poset.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::muVector;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $mu = new Bio::PhyloNetwork::muVector();\n Function: Creates a new Bio::PhyloNetwork::muVector object\n Returns : Bio::PhyloNetwork::muVector\n Args    : integer or (reference to) an array\n\nIf given an integer as argument, returns a Bio::PhyloNetwork::muVector\nobject with dimension the integer given and initialized to zero.\nIf it is an anonimous array, then the vector is initialized with the values\nin the array and with the corresponding dimension.\n\n\nsub new {\n  my ($pkg,$cont)=@_;\n  my $self=$pkg->SUPER::new();\n  my @arr=();\n  if (!ref($cont)) {\n    #$cont is a number; initialize to a zero-vector\n    for (my $i=0; $i < $cont; $i++) {\n      $arr[$i]=0;\n    }\n    $self->{arr}=\\@arr;\n  } else {\n    #$cont points to an array\n    @arr=@{$cont};\n  }\n  $self->{dim}=scalar @arr;\n  $self->{arr}=\\@arr;\n  bless($self,$pkg);\n  return $self;\n}\n\nsub dim {\n  return shift->{dim}\n}\n\nuse overload\n  \"+\" => \\&add,\n  \"-\" => \\&substract,\n  \"*\" => \\&scalarproduct,\n  \"<=>\" => \\&comparelex,\n  \"cmp\" => \\&comparelex,\n  '\"\"' => \\&display,\n  '@{}' => \\&as_array;\n\nsub as_array {\n  return shift->{arr};\n}\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$mu->display()\n Function: returns an string displaying its contents\n Returns : string\n Args    : none\n\nThis function is also overloaded to the \"\" operator.\n\n\nsub display {\n  my ($self)=@_;\n  my @arr=@{$self->{arr}};\n  return \"(@arr)\";\n}\n\n=head2 add\n\n Title   : add\n Usage   : $mu->add($mu2)\n Function: returns the sum of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the + operator.\n\n\nsub add {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->[$i]+$v2->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 substract\n\n Title   : substract\n Usage   : $mu->substract($mu2)\n Function: returns the difference of $mu and $mu2\n Returns : Bio::PhyloNetwork::muVector\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the - operator.\n\n\nsub substract {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$v1->{arr}->[$i]-$v2->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n}\n\n=head2 scalarproduct\n\n Title   : scalarproduct\n Usage   : $mu->scalarproduct($ct)\n Function: returns the scalar product of $ct and $mu\n Returns : Bio::PhyloNetwork::muVector\n Args    : scalar\n\nThis function is also overloaded to the * operator.\n\n\nsub scalarproduct {\n  my ($v1,$num,$swapped)=@_;\n\n  my $dim=$v1->{dim};\n  my @sum=();\n  for (my $i=0; $i<$dim; $i++) {\n    $sum[$i]=$num*$v1->{arr}->[$i];\n  }\n  my $result=Bio::PhyloNetwork::muVector->new(\\@sum);\n  return $result;\n  return $result;\n}\n\n=head2 comparelex\n\n Title   : comparelex\n Usage   : $mu1->comparelex($mu2)\n Function: compares $mu and $mu2 w.r.t. the lexicographic ordering\n Returns : scalar (-1 if $mu1<$mu2, 0 if $mu1=$mu2, 1 if $mu1>$mu2)\n Args    : Bio::PhyloNetwork::muVector\n\nThis function is also overloaded to the E<lt>=E<gt> and cmp operator.\n\n\nsub comparelex {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return -1 if $v1->{arr}->[$i] < $v2->{arr}->[$i];\n    return 1 if $v1->{arr}->[$i] > $v2->{arr}->[$i];\n  }\n  return 0;\n}\n\n=head2 geq_poset\n\n Title   : geq_poset\n Usage   : $mu1->geq_poset($mu2)\n Function: compares $mu and $mu2 w.r.t. the natural partial ordering\n Returns : boolean (1 if $mu >= $mu2, 0 otherwise)\n Args    : Bio::PhyloNetwork::muVector\n\n\nsub geq_poset {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= $v2->[$i];\n  }\n  return 1;\n}\n\n=head2 is_positive\n\n Title   : is_positive\n Usage   : $mu->is_positive()\n Function: tests if all components of $mu are positive (or zero)\n Returns : boolean\n Args    : none\n\n\nsub is_positive {\n  my ($v1)=@_;\n\n  my $dim=$v1->{dim};\n  for (my $i=0; $i<$dim; $i++) {\n    return 0 unless $v1->[$i] >= 0;\n  }\n  return 1;\n}\n\n=head2 hamming\n\n Title   : hamming\n Usage   : $mu1->hamming($mu2)\n Function: returns the Hamming distance between $mu1 and $mu2\n Returns : scalar\n Args    : Bio::PhyloNetwork::muVector\n\n\nsub hamming {\n  my ($v1,$v2)=@_;\n\n  $v1->throw(\"Vectors not the same size\") unless ($v1->{dim} == $v2->{dim});\n  my $dim=$v1->{dim};\n  my $w=0;\n  for (my $i=0; $i<$dim; $i++) {\n    $w++ unless $v1->[$i] == $v2->[$i];\n  }\n  return $w;\n}\n\n=head2 manhattan\n\n Title   : manhattan\n Usage   : $mu1->manhattan($mu2)\n Function: returns the Manhattan distance between $mu1 and $mu2\n Returns : scalar\n Args    : Bio::PhyloNetwork::muVector","parameters":[{"label":"$v1"},{"label":"$v2"}]}},{"kind":12,"name":"dim","line":309},{"name":"dim","kind":12,"line":309},{"line":310,"kind":12,"name":"dim"}],"version":5}