{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":63},{"line":87,"range":{"start":{"character":0,"line":87},"end":{"line":125,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$pkg"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeFactoryX.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactoryX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactoryX - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactoryX;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".","label":"new($pkg,@args)"},"children":[{"localvar":"my","kind":13,"containerName":"new","name":"$pkg","line":88,"definition":"my"},{"line":88,"name":"@args","containerName":"new","kind":13},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$self","line":90},{"line":90,"name":"$pkg","kind":13,"containerName":"new"},{"line":90,"name":"@args","kind":13,"containerName":"new"},{"name":"$leavesR","containerName":"new","localvar":"my","kind":13,"line":92,"definition":"my"},{"line":92,"containerName":"new","kind":13,"name":"$numleaves"},{"containerName":"new","kind":13,"name":"$numhybrids","line":92},{"name":"$self","containerName":"new","kind":13,"line":93},{"containerName":"new","kind":12,"name":"_rearrange","line":93},{"line":95,"name":"@args","kind":13,"containerName":"new"},{"localvar":"my","containerName":"new","kind":13,"name":"@leaves","line":97,"definition":"my"},{"line":98,"kind":13,"containerName":"new","name":"$leavesR"},{"line":98,"name":"$numleaves","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"@leaves","line":99},{"kind":13,"containerName":"new","name":"$numleaves","line":99},{"line":100,"containerName":"new","kind":13,"name":"$leavesR"},{"name":"@leaves","kind":13,"containerName":"new","line":100},{"line":102,"name":"$leavesR","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":103},{"containerName":"new","kind":12,"name":"throw","line":103},{"containerName":"new","kind":13,"name":"@leaves","line":105},{"line":105,"containerName":"new","kind":13,"name":"$leavesR"},{"containerName":"new","kind":13,"name":"$self","line":106},{"kind":13,"containerName":"new","name":"$leavesR","line":106},{"line":108,"name":"$numleaves","containerName":"new","kind":13},{"name":"@leaves","kind":13,"containerName":"new","line":108},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"line":109,"containerName":"new","kind":13,"name":"$numleaves"},{"name":"$numleaves","containerName":"new","kind":13,"line":110},{"definition":"my","line":111,"localvar":"my","containerName":"new","kind":13,"name":"@leavesparent"},{"line":111,"name":"@leaves","containerName":"new","kind":13},{"definition":"my","line":112,"name":"$newleaf","localvar":"my","kind":13,"containerName":"new"},{"line":112,"containerName":"new","kind":13,"name":"@leavesparent"},{"name":"$self","kind":13,"containerName":"new","line":113},{"kind":13,"containerName":"new","name":"$newleaf","line":113},{"line":114,"containerName":"new","kind":13,"name":"$self"},{"name":"$pkg","containerName":"new","kind":13,"line":115},{"kind":13,"containerName":"new","name":"@leavesparent","line":115},{"definition":"my","name":"$oldnet","localvar":"my","kind":13,"containerName":"new","line":116},{"kind":13,"containerName":"new","name":"$self","line":116},{"line":116,"containerName":"new","kind":12,"name":"next_network_new"},{"line":117,"kind":13,"containerName":"new","name":"$self"},{"line":117,"containerName":"new","kind":13,"name":"$oldnet"},{"line":118,"name":"@candidates","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$oldnet","kind":13,"containerName":"new","line":118},{"kind":12,"containerName":"new","name":"nodes","line":118},{"name":"$self","containerName":"new","kind":13,"line":119},{"name":"@candidates","containerName":"new","kind":13,"line":119},{"line":121,"containerName":"new","kind":13,"name":"$self"},{"line":122,"containerName":"new","kind":13,"name":"$self"},{"line":123,"kind":13,"containerName":"new","name":"$self"},{"line":124,"containerName":"new","kind":13,"name":"$self"},{"line":124,"kind":13,"containerName":"new","name":"$pkg"}],"containerName":"main::","name":"new","definition":"sub","detail":"($pkg,@args)"},{"name":"PhyloNetwork","containerName":"Bio","kind":2,"line":88},{"line":90,"kind":12,"containerName":"new","name":"SUPER"},{"name":"leaves","kind":12,"line":106},{"name":"numleaves","kind":12,"line":109},{"line":113,"kind":12,"name":"newleaf"},{"line":114,"kind":12,"name":"parent"},{"line":116,"name":"parent","kind":12},{"name":"oldnet","kind":12,"line":117},{"kind":12,"name":"candidates","line":119},{"line":121,"name":"index","kind":12},{"kind":12,"name":"found","line":122},{"name":"thrown","kind":12,"line":123},{"signature":{"label":"next_network_new($self)","documentation":"1;\n# $Id: TreeFactoryX.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactoryX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactoryX - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactoryX;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS)],@args);\n\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n  if ($numleaves > 2) {\n    my @leavesparent=@leaves;\n    my $newleaf=pop @leavesparent;\n    $self->{newleaf}=$newleaf;\n    $self->{parent}=\n      new($pkg,-leaves=>\\@leavesparent);\n    my $oldnet=$self->{parent}->next_network_new();\n    $self->{oldnet}=$oldnet;\n    my @candidates=$oldnet->nodes();\n    $self->{candidates}=\\@candidates;\n  }\n  $self->{index}=0;\n  $self->{found}=[];\n  $self->{thrown}=0;\n  bless($self,$pkg);\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a tree\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":175},"start":{"line":137,"character":0}},"kind":12,"line":137,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_network_new","children":[{"localvar":"my","kind":13,"containerName":"next_network_new","name":"$self","line":138,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_network_new","name":"$n","line":140},{"line":140,"kind":13,"containerName":"next_network_new","name":"$self"},{"line":141,"name":"$self","containerName":"next_network_new","kind":13},{"name":"$self","containerName":"next_network_new","kind":13,"line":142},{"line":143,"name":"$graph","localvar":"my","containerName":"next_network_new","kind":13,"definition":"my"},{"name":"new","containerName":"next_network_new","kind":12,"line":143},{"name":"$graph","containerName":"next_network_new","kind":13,"line":144},{"line":144,"kind":12,"containerName":"next_network_new","name":"add_edges"},{"line":144,"containerName":"next_network_new","kind":13,"name":"$self"},{"kind":13,"containerName":"next_network_new","name":"$self","line":144},{"definition":"my","line":145,"localvar":"my","kind":13,"containerName":"next_network_new","name":"$net"},{"line":145,"containerName":"next_network_new","kind":12,"name":"new"},{"line":145,"containerName":"next_network_new","kind":13,"name":"$graph"},{"line":146,"name":"$self","containerName":"next_network_new","kind":13},{"name":"$self","containerName":"next_network_new","kind":13,"line":147},{"line":147,"name":"$net","containerName":"next_network_new","kind":13},{"line":148,"containerName":"next_network_new","kind":13,"name":"$net"},{"name":"$self","kind":13,"containerName":"next_network_new","line":155},{"line":155,"name":"$self","containerName":"next_network_new","kind":13},{"kind":13,"localvar":"my","containerName":"next_network_new","name":"$oldnet","line":156,"definition":"my"},{"line":156,"containerName":"next_network_new","kind":13,"name":"$self"},{"containerName":"next_network_new","kind":12,"name":"next_network_new","line":156},{"line":157,"containerName":"next_network_new","kind":13,"name":"$oldnet"},{"line":160,"name":"$self","kind":13,"containerName":"next_network_new"},{"containerName":"next_network_new","kind":13,"name":"$oldnet","line":160},{"name":"@candidates","containerName":"next_network_new","localvar":"my","kind":13,"line":161,"definition":"my"},{"line":161,"name":"$oldnet","kind":13,"containerName":"next_network_new"},{"line":161,"name":"nodes","kind":12,"containerName":"next_network_new"},{"line":162,"containerName":"next_network_new","kind":13,"name":"$self"},{"line":162,"name":"@candidates","containerName":"next_network_new","kind":13},{"line":163,"name":"$self","containerName":"next_network_new","kind":13},{"name":"$graph","localvar":"my","kind":13,"containerName":"next_network_new","line":165,"definition":"my"},{"containerName":"next_network_new","kind":13,"name":"$self","line":165},{"line":165,"kind":12,"containerName":"next_network_new","name":"copy"},{"containerName":"next_network_new","localvar":"my","kind":13,"name":"$u","line":166,"definition":"my"},{"line":166,"containerName":"next_network_new","kind":13,"name":"$self"},{"line":166,"name":"$self","kind":13,"containerName":"next_network_new"},{"localvar":"my","containerName":"next_network_new","kind":13,"name":"$w","line":167,"definition":"my"},{"line":167,"kind":13,"containerName":"next_network_new","name":"$graph"},{"line":167,"containerName":"next_network_new","kind":12,"name":"predecessors"},{"containerName":"next_network_new","kind":13,"name":"$u","line":167},{"line":168,"containerName":"next_network_new","kind":13,"name":"$graph"},{"line":168,"name":"delete_edge","kind":12,"containerName":"next_network_new"},{"containerName":"next_network_new","kind":13,"name":"$w","line":168},{"line":168,"kind":13,"containerName":"next_network_new","name":"$u"},{"name":"$graph","containerName":"next_network_new","kind":13,"line":169},{"line":169,"kind":12,"containerName":"next_network_new","name":"add_edge"},{"line":169,"name":"$w","containerName":"next_network_new","kind":13},{"containerName":"next_network_new","kind":13,"name":"$graph","line":171},{"line":171,"kind":12,"containerName":"next_network_new","name":"add_edge"},{"containerName":"next_network_new","kind":13,"name":"$u","line":171},{"name":"$graph","containerName":"next_network_new","kind":13,"line":172},{"kind":12,"containerName":"next_network_new","name":"add_edge","line":172},{"kind":13,"containerName":"next_network_new","name":"$self","line":172},{"definition":"my","name":"$net","localvar":"my","kind":13,"containerName":"next_network_new","line":173},{"line":173,"name":"new","containerName":"next_network_new","kind":12},{"containerName":"next_network_new","kind":13,"name":"$graph","line":173},{"line":174,"name":"$self","containerName":"next_network_new","kind":13},{"definition":"my","line":175,"containerName":"next_network_new","localvar":"my","kind":13,"name":"@found"},{"containerName":"next_network_new","kind":13,"name":"$self","line":175}]},{"line":140,"kind":12,"name":"numleaves"},{"kind":12,"name":"numleaves","line":141},{"line":142,"name":"index","kind":12},{"line":143,"kind":12,"containerName":"Directed","name":"Graph"},{"line":144,"kind":12,"name":"leaves"},{"line":144,"name":"leaves","kind":12},{"name":"Bio","kind":12,"containerName":"PhyloNetwork","line":145},{"line":146,"name":"index","kind":12},{"kind":12,"name":"found","line":147},{"line":155,"name":"index","kind":12},{"line":155,"name":"candidates","kind":12},{"line":156,"name":"parent","kind":12},{"line":160,"name":"oldnet","kind":12},{"name":"candidates","kind":12,"line":162},{"line":163,"name":"index","kind":12},{"line":165,"kind":12,"name":"oldnet"},{"line":165,"kind":12,"name":"graph"},{"name":"candidates","kind":12,"line":166},{"name":"index","kind":12,"line":166},{"line":172,"kind":12,"name":"newleaf"},{"name":"Bio","kind":12,"containerName":"PhyloNetwork","line":173},{"line":174,"kind":12,"name":"index"},{"line":175,"kind":12,"name":"found"},{"containerName":null,"kind":13,"name":"@found","line":176},{"kind":13,"containerName":null,"name":"$net","line":176},{"containerName":null,"kind":13,"name":"%self","line":177},{"kind":12,"name":"found","line":177},{"kind":13,"containerName":null,"name":"@found","line":177},{"name":"$net","kind":13,"containerName":null,"line":178},{"line":182,"kind":12,"range":{"end":{"line":185,"character":9999},"start":{"character":0,"line":182}},"signature":{"label":"next_network_repeated($self)","parameters":[{"label":"$self"}],"documentation":""},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"next_network_repeated","kind":13,"line":183},{"line":185,"kind":13,"containerName":"next_network_repeated","name":"$self"},{"line":185,"name":"$self","containerName":"next_network_repeated","kind":13}],"containerName":"main::","name":"next_network_repeated","definition":"sub","detail":"($self)"},{"kind":12,"name":"thrown","line":185},{"line":185,"name":"found","kind":12},{"kind":13,"containerName":null,"name":"%self","line":186},{"name":"thrown","kind":12,"line":186},{"name":"%self","kind":13,"containerName":null,"line":186},{"name":"thrown","kind":12,"line":186},{"line":187,"containerName":null,"kind":13,"name":"%self"},{"line":187,"name":"found","kind":12},{"containerName":null,"kind":13,"name":"%self","line":187},{"name":"thrown","kind":12,"line":187},{"range":{"end":{"line":193,"character":9999},"start":{"character":0,"line":190}},"kind":12,"line":190,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"next_network($self)"},"containerName":"main::","name":"next_network","children":[{"localvar":"my","containerName":"next_network","kind":13,"name":"$self","line":191,"definition":"my"},{"name":"$self","containerName":"next_network","kind":13,"line":192},{"line":192,"containerName":"next_network","kind":12,"name":"next_network_new"}],"detail":"($self)","definition":"sub"}]}