{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":62},{"name":"new","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$pkg","line":86,"definition":"my"},{"line":86,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","line":88,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"name":"$pkg","containerName":"new","kind":13,"line":88},{"line":88,"name":"@args","containerName":"new","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$net","line":90},{"name":"$short_labels","containerName":"new","kind":13,"line":90},{"name":"$self","containerName":"new","kind":13,"line":91},{"name":"_rearrange","kind":12,"containerName":"new","line":91},{"kind":13,"containerName":"new","name":"@args","line":92},{"name":"$short_labels","containerName":"new","kind":13,"line":93},{"containerName":"new","kind":13,"name":"$short_labels","line":94},{"name":"$gv","localvar":"my","kind":13,"containerName":"new","line":96,"definition":"my"},{"name":"new","containerName":"new","kind":12,"line":96},{"containerName":"new","localvar":"my","kind":13,"name":"$nodePN_to_nodeGV","line":97,"definition":"my"},{"line":98,"kind":13,"localvar":"my","containerName":"new","name":"@nodes","definition":"my"},{"line":98,"containerName":"new","kind":13,"name":"$net"},{"kind":12,"containerName":"new","name":"nodes","line":98},{"name":"$node","kind":13,"localvar":"my","containerName":"new","line":99,"definition":"my"},{"kind":13,"containerName":"new","name":"@nodes","line":99},{"line":103,"kind":13,"localvar":"my","containerName":"new","name":"$labelnodeint","definition":"my"},{"line":103,"name":"$net","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$node","line":103},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$labelnode","line":105},{"line":105,"containerName":"new","kind":13,"name":"$short_labels"},{"containerName":"new","kind":13,"name":"$labelnodeint","line":105},{"kind":13,"containerName":"new","name":"$labelnodeint","line":105},{"kind":13,"localvar":"my","containerName":"new","name":"$nodeGV","line":106,"definition":"my"},{"kind":13,"containerName":"new","name":"$gv","line":107},{"containerName":"new","kind":12,"name":"add_node","line":107},{"line":108,"kind":13,"containerName":"new","name":"$labelnode"},{"line":109,"name":"$net","kind":13,"containerName":"new"},{"name":"is_tree_node","containerName":"new","kind":12,"line":109},{"kind":13,"containerName":"new","name":"$node","line":109},{"line":110,"name":"$nodePN_to_nodeGV","kind":13,"containerName":"new"},{"line":110,"name":"$node","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$nodeGV","line":110},{"localvar":"my","containerName":"new","kind":13,"name":"@edges","line":112,"definition":"my"},{"containerName":"new","kind":13,"name":"$net","line":112},{"name":"edges","kind":12,"containerName":"new","line":112},{"name":"$edge","localvar":"my","kind":13,"containerName":"new","line":113,"definition":"my"},{"kind":13,"containerName":"new","name":"@edges","line":113},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$node1","line":114},{"containerName":"new","kind":13,"name":"$edge","line":114},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$node2","line":116},{"name":"$edge","kind":13,"containerName":"new","line":116},{"kind":13,"containerName":"new","name":"$gv","line":118},{"kind":12,"containerName":"new","name":"add_edge","line":118},{"containerName":"new","kind":13,"name":"$nodePN_to_nodeGV","line":118},{"containerName":"new","kind":13,"name":"$node1","line":118},{"kind":13,"containerName":"new","name":"$nodePN_to_nodeGV","line":118},{"line":118,"containerName":"new","kind":13,"name":"$node2"},{"line":120,"kind":13,"containerName":"new","name":"$self"},{"line":120,"name":"$gv","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":121},{"containerName":"new","kind":13,"name":"$nodePN_to_nodeGV","line":121},{"containerName":"new","kind":13,"name":"$self","line":122},{"line":122,"name":"$pkg","kind":13,"containerName":"new"}],"detail":"($pkg,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":123},"start":{"line":85,"character":0}},"line":85,"signature":{"label":"new($pkg,@args)","parameters":[{"label":"$pkg"},{"label":"@args"}],"documentation":"1;\n# $Id: GraphViz.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::GraphViz\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::GraphViz - Interface between PhyloNetwork and GraphViz\n\n=head1 SYNOPSIS\n\n  use Bio::PhyloNetwork;\n  use Bio::PhyloNetwork::GraphViz;\n\n  my $net=Bio::PhyloNetwork->new(\n      -eNewick=>'((H1,(H1,(H2,l))),H2)t0; (some long label)H1; (\"quoted label\")H2;'\n  );\n\n  my $gv=Bio::PhyloNetwork::GraphViz->new(-net=>$net,-short_labels=>1);\n\n  foreach my $u ($net->nodes()) {\n      print \"$u:\".$gv->nodePN_to_nodeGV->{$u}.\"\\n\";\n  }\n\n  print $gv->as_text;\n\n  open PS, \"> net.ps\";\n  print PS $gv->as_ps;\n  close PS;\n\n=head1 DESCRIPTION\n\nThis is a module to create GraphViz objects representing phylogenetic networks.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>, L<GraphViz>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::GraphViz;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root GraphViz);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $graphv = new Bio::PhyloNetwork::GraphViz();\n Function: Creates a new Bio::PhyloNetwork::GraphViz object\n Returns : Bio::PhyloNetwork::GraphViz\n Args    : -net => Bio::PhyloNetwork object\n           -short_labels => boolean (optional)\n\nReturns a Bio::PhyloNetwork::GraphViz object, which is an extension of\na GraphViz object. The GraphViz object is a representation of the\nphylogenetic network given. The extra information the created object\nholds is a hash table with keys the nodes of the PhyloNetwork object\nand values the nodes of the GraphViz object. If the optional argument\n-short_labels=E<gt>1 is given, the labels of the nodes in GraphViz are\nshortened to a maximum of 3 letters."}},{"containerName":"Bio","kind":2,"name":"PhyloNetwork","line":86},{"line":88,"name":"SUPER","containerName":"new","kind":12},{"name":"GraphViz","kind":12,"line":96},{"name":"labels","kind":12,"line":103},{"line":105,"kind":12,"name":"find_short_label"},{"line":105,"name":"find_label","kind":12},{"name":"label","kind":12,"line":108},{"line":109,"name":"shape","kind":12},{"kind":12,"name":"nodePN_to_nodeGV","line":121},{"containerName":"main::","name":"find_short_label","children":[{"definition":"my","containerName":"find_short_label","localvar":"my","kind":13,"name":"$str","line":135},{"name":"$str","containerName":"find_short_label","kind":13,"line":136}],"detail":"($str)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":134},"end":{"character":9999,"line":137}},"line":134,"signature":{"documentation":"sub generate_name {\n  my ($var)=@_;\n  if ($var =~ /\\D/) {\n    print \"$var contains a number.\\b\";\n    return $var;\n  }\n  return \"N$var\";\n}","parameters":[{"label":"$str"}],"label":"find_short_label($str)"}},{"line":136,"name":"find_label","kind":12},{"range":{"end":{"character":9999,"line":143},"start":{"line":139,"character":0}},"kind":12,"line":139,"signature":{"label":"find_label($str)","documentation":"","parameters":[{"label":"$str"}]},"name":"find_label","containerName":"main::","children":[{"definition":"my","line":140,"kind":13,"localvar":"my","containerName":"find_label","name":"$str"},{"name":"$str","kind":13,"containerName":"find_label","line":141},{"line":142,"name":"$str","kind":13,"containerName":"find_label"}],"detail":"($str)","definition":"sub"},{"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","containerName":"nodePN_to_nodeGV","kind":13,"line":158,"definition":"my"},{"name":"$self","kind":13,"containerName":"nodePN_to_nodeGV","line":159}],"containerName":"main::","name":"nodePN_to_nodeGV","signature":{"label":"nodePN_to_nodeGV($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GraphViz.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::GraphViz\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::GraphViz - Interface between PhyloNetwork and GraphViz\n\n=head1 SYNOPSIS\n\n  use Bio::PhyloNetwork;\n  use Bio::PhyloNetwork::GraphViz;\n\n  my $net=Bio::PhyloNetwork->new(\n      -eNewick=>'((H1,(H1,(H2,l))),H2)t0; (some long label)H1; (\"quoted label\")H2;'\n  );\n\n  my $gv=Bio::PhyloNetwork::GraphViz->new(-net=>$net,-short_labels=>1);\n\n  foreach my $u ($net->nodes()) {\n      print \"$u:\".$gv->nodePN_to_nodeGV->{$u}.\"\\n\";\n  }\n\n  print $gv->as_text;\n\n  open PS, \"> net.ps\";\n  print PS $gv->as_ps;\n  close PS;\n\n=head1 DESCRIPTION\n\nThis is a module to create GraphViz objects representing phylogenetic networks.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>, L<GraphViz>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::GraphViz;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root GraphViz);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $graphv = new Bio::PhyloNetwork::GraphViz();\n Function: Creates a new Bio::PhyloNetwork::GraphViz object\n Returns : Bio::PhyloNetwork::GraphViz\n Args    : -net => Bio::PhyloNetwork object\n           -short_labels => boolean (optional)\n\nReturns a Bio::PhyloNetwork::GraphViz object, which is an extension of\na GraphViz object. The GraphViz object is a representation of the\nphylogenetic network given. The extra information the created object\nholds is a hash table with keys the nodes of the PhyloNetwork object\nand values the nodes of the GraphViz object. If the optional argument\n-short_labels=E<gt>1 is given, the labels of the nodes in GraphViz are\nshortened to a maximum of 3 letters.\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($net,$short_labels)=\n    $self->_rearrange([qw(NET\n\t\t\t  SHORT_LABELS)],@args);\n  if (! defined $short_labels) {\n    $short_labels=0;\n  }\n  my $gv=GraphViz->new();\n  my $nodePN_to_nodeGV={};\n  my @nodes=$net->nodes();\n  foreach my $node (@nodes) {\n#    my $namenode=generate_name($node);\n#    $names->{$node}=$namenode;\n    ###\n    my $labelnodeint=$net->{labels}->{$node};\n    ###\n    my $labelnode=($short_labels ? find_short_label($labelnodeint) : find_label($labelnodeint));\n    my $nodeGV=\n      $gv->add_node(#$namenode,\n\t\t    label=>$labelnode,\n\t\t    shape=>($net->is_tree_node($node) ? 'circle' : 'box'));\n    $nodePN_to_nodeGV->{$node}=$nodeGV;\n  }\n  my @edges=$net->edges();\n  foreach my $edge (@edges) {\n    my $node1=$edge->[0];\n#    my $namenode1=generate_name($node1);\n    my $node2=$edge->[1];\n#    my $namenode2=generate_name($node2);\n    $gv->add_edge($nodePN_to_nodeGV->{$node1},$nodePN_to_nodeGV->{$node2});\n  }\n  $self=$gv;\n  $self->{nodePN_to_nodeGV}=$nodePN_to_nodeGV;\n  bless($self,$pkg);\n}\n\n#sub generate_name {\n#  my ($var)=@_;\n#  if ($var =~ /\\D/) {\n#    print \"$var contains a number.\\b\";\n#    return $var;\n#  }\n#  return \"N$var\";\n#}\n\nsub find_short_label {\n  my ($str)=@_;\n  return substr(find_label($str),0,3);\n}\n\nsub find_label {\n  my ($str)=@_;\n  $str =~ tr/A-Za-z0-9//cd;\n  return $str;\n}\n\n=head2 nodePN_to_nodeGV\n\n Title   : nodePN_to_nodeGV\n Usage   : my $hashR=$graphv->nodePN_to_nodeGV()\n Function: returns (a reference to) a hash holding the translation between\n           nodes of the Bio::PhyloNetwork object and nodes of the GraphViz\n           object\n Returns : reference to hash\n Args    : none"},"line":157,"range":{"start":{"line":157,"character":0},"end":{"character":9999,"line":160}},"kind":12},{"kind":12,"name":"nodePN_to_nodeGV","line":159}]}