{"vars":[{"name":"base","kind":2,"containerName":"","line":191},{"kind":14,"containerName":"main::","name":"DEFAULT_STATE","line":194,"definition":1},{"definition":1,"kind":14,"containerName":"main::","name":"MIM_NUMBER_STATE","line":195},{"name":"TITLE_STATE","kind":14,"containerName":"main::","line":196,"definition":1},{"line":197,"name":"TEXT_STATE","kind":14,"containerName":"main::","definition":1},{"line":198,"kind":14,"containerName":"main::","name":"MINI_MIM_TEXT_STATE","definition":1},{"definition":1,"containerName":"main::","kind":14,"name":"ALLELIC_VARIANT_STATE","line":199},{"line":200,"name":"SEE_ALSO_STATE","containerName":"main::","kind":14,"definition":1},{"definition":1,"name":"REF_STATE","kind":14,"containerName":"main::","line":201},{"definition":1,"containerName":"main::","kind":14,"name":"SYMPT_STATE","line":202},{"name":"CONTRIBUTORS_STATE","kind":14,"containerName":"main::","line":203,"definition":1},{"line":204,"containerName":"main::","kind":14,"name":"CREATED_BY_STATE","definition":1},{"name":"EDITED_BY_STATE","kind":14,"containerName":"main::","line":205,"definition":1},{"line":206,"name":"MINI_MIM_EDITED_BY_STATE","kind":14,"containerName":"main::","definition":1},{"line":207,"kind":14,"containerName":"main::","name":"MINI_MIM_CREATED_BY_STATE","definition":1},{"definition":1,"line":208,"name":"MINI_MIM_CONTRIBUTORS_STATE","containerName":"main::","kind":14},{"definition":1,"containerName":"main::","kind":14,"name":"TRUE","line":209},{"line":210,"kind":14,"containerName":"main::","name":"FALSE","definition":1},{"signature":{"documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"start":{"character":0,"line":226},"end":{"line":241,"character":9999}},"line":226,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":227,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"@args","line":227},{"definition":"my","line":229,"name":"$self","containerName":"new","localvar":"my","kind":13},{"name":"$class","containerName":"new","kind":13,"line":229},{"name":"@args","kind":13,"containerName":"new","line":229},{"definition":"my","line":231,"name":"$genemap_file_name","localvar":"my","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$omimtxt_file_name","line":231},{"line":232,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"_rearrange","line":232},{"line":232,"name":"@args","containerName":"new","kind":13},{"line":234,"kind":13,"containerName":"new","name":"$self"},{"line":234,"containerName":"new","kind":12,"name":"init"},{"line":236,"containerName":"new","kind":13,"name":"$genemap_file_name"},{"line":236,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"genemap_file_name","line":236},{"name":"$genemap_file_name","containerName":"new","kind":13,"line":236},{"name":"$omimtxt_file_name","containerName":"new","kind":13,"line":238},{"name":"$self","kind":13,"containerName":"new","line":238},{"containerName":"new","kind":12,"name":"omimtxt_file_name","line":238},{"containerName":"new","kind":13,"name":"$omimtxt_file_name","line":238},{"kind":13,"containerName":"new","name":"$self","line":240}]},{"containerName":"new","kind":12,"name":"SUPER","line":229},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $genemap_file_name, $omimtxt_file_name ) \n    = $self->_rearrange( [ qw( GENEMAP OMIMTEXT ) ], @args );\n\n    $self->init(); \n    \n    $genemap_file_name && $self->genemap_file_name( $genemap_file_name );\n    \n    $omimtxt_file_name && $self->omimtxt_file_name( $omimtxt_file_name);\n                         \n    return $self;\n}\n\n\n\n\n=head2 next_phenotype\n\n Title   : next_phenotype()\n Usage   : while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n               # do something with $omim_entry\n           }    \n Function: Returns an Bio::Phenotype::OMIM::OMIMentry or\n           undef once the end of the omim text file is reached.\n Returns : A Bio::Phenotype::OMIM::OMIMentry.\n Args    :","label":"next_phenotype($self)"},"line":259,"kind":12,"range":{"start":{"line":259,"character":0},"end":{"line":375,"character":9999}},"definition":"sub","detail":"($self)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_phenotype","line":260,"definition":"my"},{"line":262,"kind":13,"containerName":"next_phenotype","name":"$self"},{"line":262,"containerName":"next_phenotype","kind":12,"name":"_OMIM_text_file"},{"line":263,"kind":13,"containerName":"next_phenotype","name":"$self"},{"name":"_no_OMIM_text_file_provided_error","kind":12,"containerName":"next_phenotype","line":263},{"line":266,"containerName":"next_phenotype","kind":13,"name":"$self"},{"name":"_done","kind":12,"containerName":"next_phenotype","line":266},{"definition":"my","line":270,"name":"$fieldtag","kind":13,"localvar":"my","containerName":"next_phenotype"},{"line":271,"containerName":"next_phenotype","localvar":"my","kind":13,"name":"$contents","definition":"my"},{"name":"$line","localvar":"my","kind":13,"containerName":"next_phenotype","line":272,"definition":"my"},{"name":"$state","localvar":"my","containerName":"next_phenotype","kind":13,"line":273,"definition":"my"},{"definition":"my","line":274,"name":"$saw_mini_min_flag","localvar":"my","kind":13,"containerName":"next_phenotype"},{"definition":"my","line":275,"name":"%record","localvar":"my","containerName":"next_phenotype","kind":13},{"name":"$line","containerName":"next_phenotype","kind":13,"line":277},{"line":277,"name":"$self","containerName":"next_phenotype","kind":13},{"name":"_OMIM_text_file","kind":12,"containerName":"next_phenotype","line":277},{"line":277,"name":"_readline","containerName":"next_phenotype","kind":12},{"containerName":"next_phenotype","kind":13,"name":"$line","line":278},{"name":"$self","kind":13,"containerName":"next_phenotype","line":279},{"name":"_is_not_first_record","containerName":"next_phenotype","kind":12,"line":279},{"line":280,"name":"$self","kind":13,"containerName":"next_phenotype"},{"line":280,"name":"_add_to_hash","kind":12,"containerName":"next_phenotype"},{"line":280,"name":"$state","kind":13,"containerName":"next_phenotype"},{"kind":13,"containerName":"next_phenotype","name":"$contents","line":280},{"line":280,"containerName":"next_phenotype","kind":13,"name":"%record"},{"definition":"my","name":"$omim_entry","localvar":"my","kind":13,"containerName":"next_phenotype","line":281},{"name":"$self","kind":13,"containerName":"next_phenotype","line":281},{"name":"_createOMIMentry","kind":12,"containerName":"next_phenotype","line":281},{"name":"%record","kind":13,"containerName":"next_phenotype","line":281},{"kind":13,"containerName":"next_phenotype","name":"$omim_entry","line":282},{"line":285,"name":"$self","kind":13,"containerName":"next_phenotype"},{"kind":12,"containerName":"next_phenotype","name":"_is_not_first_record","line":285},{"kind":13,"containerName":"next_phenotype","name":"$line","line":289},{"kind":13,"containerName":"next_phenotype","name":"$fieldtag","line":290},{"name":"$state","kind":13,"containerName":"next_phenotype","line":291},{"containerName":"next_phenotype","kind":13,"name":"$self","line":292},{"containerName":"next_phenotype","kind":12,"name":"_add_to_hash","line":292},{"containerName":"next_phenotype","kind":13,"name":"$state","line":292},{"line":292,"name":"$contents","containerName":"next_phenotype","kind":13},{"name":"%record","kind":13,"containerName":"next_phenotype","line":292},{"name":"$contents","kind":13,"containerName":"next_phenotype","line":294},{"name":"$fieldtag","kind":13,"containerName":"next_phenotype","line":296},{"name":"$state","kind":13,"containerName":"next_phenotype","line":297},{"name":"$saw_mini_min_flag","kind":13,"containerName":"next_phenotype","line":298},{"kind":13,"containerName":"next_phenotype","name":"$fieldtag","line":300},{"kind":13,"containerName":"next_phenotype","name":"$state","line":301},{"containerName":"next_phenotype","kind":13,"name":"$saw_mini_min_flag","line":302},{"containerName":"next_phenotype","kind":13,"name":"$fieldtag","line":304},{"line":305,"name":"$state","containerName":"next_phenotype","kind":13},{"containerName":"next_phenotype","kind":13,"name":"$saw_mini_min_flag","line":306},{"kind":13,"containerName":"next_phenotype","name":"$fieldtag","line":308},{"line":309,"name":"$state","containerName":"next_phenotype","kind":13},{"line":310,"name":"$saw_mini_min_flag","containerName":"next_phenotype","kind":13},{"kind":13,"containerName":"next_phenotype","name":"$fieldtag","line":312},{"line":313,"containerName":"next_phenotype","kind":13,"name":"$state"},{"kind":13,"containerName":"next_phenotype","name":"$saw_mini_min_flag","line":314},{"kind":13,"containerName":"next_phenotype","name":"$fieldtag","line":316},{"containerName":"next_phenotype","kind":13,"name":"$state","line":317},{"kind":13,"containerName":"next_phenotype","name":"$saw_mini_min_flag","line":318},{"name":"$fieldtag","containerName":"next_phenotype","kind":13,"line":320},{"kind":13,"containerName":"next_phenotype","name":"$state","line":321},{"line":322,"kind":13,"containerName":"next_phenotype","name":"$saw_mini_min_flag"},{"line":324,"name":"$fieldtag","containerName":"next_phenotype","kind":13},{"kind":13,"containerName":"next_phenotype","name":"$state","line":325},{"line":326,"kind":13,"containerName":"next_phenotype","name":"$saw_mini_min_flag"},{"name":"$fieldtag","kind":13,"containerName":"next_phenotype","line":328},{"line":329,"name":"$saw_mini_min_flag","containerName":"next_phenotype","kind":13},{"line":330,"kind":13,"containerName":"next_phenotype","name":"$state"},{"line":333,"kind":13,"containerName":"next_phenotype","name":"$state"},{"line":336,"name":"$fieldtag","containerName":"next_phenotype","kind":13},{"line":337,"containerName":"next_phenotype","kind":13,"name":"$saw_mini_min_flag"},{"line":338,"name":"$state","containerName":"next_phenotype","kind":13},{"name":"$state","kind":13,"containerName":"next_phenotype","line":341},{"line":344,"containerName":"next_phenotype","kind":13,"name":"$fieldtag"},{"containerName":"next_phenotype","kind":13,"name":"$saw_mini_min_flag","line":345},{"containerName":"next_phenotype","kind":13,"name":"$state","line":346},{"line":349,"name":"$state","containerName":"next_phenotype","kind":13},{"containerName":"next_phenotype","kind":13,"name":"$contents","line":358},{"name":"$line","kind":13,"containerName":"next_phenotype","line":358},{"line":362,"name":"$self","containerName":"next_phenotype","kind":13},{"line":362,"name":"_OMIM_text_file","containerName":"next_phenotype","kind":12},{"line":362,"name":"close","kind":12,"containerName":"next_phenotype"},{"containerName":"next_phenotype","kind":13,"name":"$self","line":363},{"name":"_done","kind":12,"containerName":"next_phenotype","line":363},{"line":365,"name":"%record","kind":13,"containerName":"next_phenotype"},{"line":366,"name":"$self","kind":13,"containerName":"next_phenotype"},{"line":366,"name":"_not_a_OMIM_text_file_error","kind":12,"containerName":"next_phenotype"},{"line":369,"containerName":"next_phenotype","kind":13,"name":"$self"},{"kind":12,"containerName":"next_phenotype","name":"_add_to_hash","line":369},{"containerName":"next_phenotype","kind":13,"name":"$state","line":369},{"line":369,"kind":13,"containerName":"next_phenotype","name":"$contents"},{"line":369,"kind":13,"containerName":"next_phenotype","name":"%record"},{"definition":"my","line":371,"kind":13,"localvar":"my","containerName":"next_phenotype","name":"$omim_entry"},{"line":371,"name":"$self","kind":13,"containerName":"next_phenotype"},{"line":371,"kind":12,"containerName":"next_phenotype","name":"_createOMIMentry"},{"line":371,"kind":13,"containerName":"next_phenotype","name":"%record"},{"line":373,"name":"$omim_entry","kind":13,"containerName":"next_phenotype"}],"containerName":"main::","name":"next_phenotype"},{"name":"TRUE","kind":12,"line":266},{"kind":12,"name":"DEFAULT_STATE","line":273},{"kind":12,"name":"FALSE","line":274},{"line":279,"kind":12,"name":"TRUE"},{"name":"TRUE","kind":12,"line":285},{"line":291,"name":"DEFAULT_STATE","kind":12},{"kind":12,"name":"MIM_NUMBER_STATE","line":297},{"line":298,"name":"FALSE","kind":12},{"line":301,"name":"TITLE_STATE","kind":12},{"kind":12,"name":"FALSE","line":302},{"line":305,"name":"TEXT_STATE","kind":12},{"name":"FALSE","kind":12,"line":306},{"line":309,"name":"MINI_MIM_TEXT_STATE","kind":12},{"name":"TRUE","kind":12,"line":310},{"line":313,"kind":12,"name":"ALLELIC_VARIANT_STATE"},{"line":314,"kind":12,"name":"FALSE"},{"line":317,"name":"SEE_ALSO_STATE","kind":12},{"line":318,"kind":12,"name":"FALSE"},{"line":321,"name":"REF_STATE","kind":12},{"kind":12,"name":"FALSE","line":322},{"line":325,"kind":12,"name":"SYMPT_STATE"},{"line":326,"name":"FALSE","kind":12},{"line":329,"kind":12,"name":"TRUE"},{"name":"MINI_MIM_CONTRIBUTORS_STATE","kind":12,"line":330},{"name":"CONTRIBUTORS_STATE","kind":12,"line":333},{"line":337,"kind":12,"name":"TRUE"},{"line":338,"name":"MINI_MIM_CREATED_BY_STATE","kind":12},{"line":341,"kind":12,"name":"CREATED_BY_STATE"},{"kind":12,"name":"TRUE","line":345},{"line":346,"name":"MINI_MIM_EDITED_BY_STATE","kind":12},{"kind":12,"name":"EDITED_BY_STATE","line":349},{"line":363,"kind":12,"name":"TRUE"},{"children":[{"localvar":"my","containerName":"init","kind":13,"name":"$self","line":391,"definition":"my"},{"line":393,"kind":13,"containerName":"init","name":"$self"},{"line":393,"name":"genemap_file_name","kind":12,"containerName":"init"},{"name":"$self","kind":13,"containerName":"init","line":394},{"name":"omimtxt_file_name","kind":12,"containerName":"init","line":394},{"line":395,"name":"$self","containerName":"init","kind":13},{"line":395,"name":"_genemap_hash","containerName":"init","kind":12},{"name":"$self","containerName":"init","kind":13,"line":396},{"line":396,"name":"_OMIM_text_file","containerName":"init","kind":12},{"line":397,"name":"$self","kind":13,"containerName":"init"},{"containerName":"init","kind":12,"name":"_is_not_first_record","line":397},{"containerName":"init","kind":13,"name":"$self","line":398},{"line":398,"kind":12,"containerName":"init","name":"_done"}],"containerName":"main::","name":"init","definition":"sub","detail":"($self)","line":390,"range":{"start":{"line":390,"character":0},"end":{"character":9999,"line":400}},"kind":12,"signature":{"label":"init($self)","documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $genemap_file_name, $omimtxt_file_name ) \n    = $self->_rearrange( [ qw( GENEMAP OMIMTEXT ) ], @args );\n\n    $self->init(); \n    \n    $genemap_file_name && $self->genemap_file_name( $genemap_file_name );\n    \n    $omimtxt_file_name && $self->omimtxt_file_name( $omimtxt_file_name);\n                         \n    return $self;\n}\n\n\n\n\n=head2 next_phenotype\n\n Title   : next_phenotype()\n Usage   : while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n               # do something with $omim_entry\n           }    \n Function: Returns an Bio::Phenotype::OMIM::OMIMentry or\n           undef once the end of the omim text file is reached.\n Returns : A Bio::Phenotype::OMIM::OMIMentry.\n Args    :\n\n\nsub next_phenotype {\n    my ( $self ) = @_;\n    \n    unless( defined( $self->_OMIM_text_file() ) ) {\n        $self->_no_OMIM_text_file_provided_error();\n    }\n    \n    if ( $self->_done() == TRUE ) {\n        return;\n    }\n\n    my $fieldtag          = \"\";\n    my $contents          = \"\";\n    my $line              = \"\";\n    my $state             = DEFAULT_STATE;\n    my $saw_mini_min_flag = FALSE;\n    my %record            = ();\n    \n    while( $line = ( $self->_OMIM_text_file )->_readline() ) {\n        if ( $line =~ /^\\s*\\*RECORD\\*/ ) {\n            if ( $self->_is_not_first_record() == TRUE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n                my $omim_entry = $self->_createOMIMentry( \\%record );\n                return $omim_entry;\n            }\n            else {\n                $self->_is_not_first_record( TRUE );\n            }\n            \n        }\n        elsif ( $line =~ /^\\s*\\*FIELD\\*\\s*(\\S+)/ ) {\n            $fieldtag = $1;\n            if ( $state != DEFAULT_STATE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n            }\n            $contents = \"\";\n            \n            if ( $fieldtag eq \"NO\" ) {\n                $state = MIM_NUMBER_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TI\" ) {\n                $state = TITLE_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TX\" ) {\n                $state = TEXT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"MN\" ) {\n                $state = MINI_MIM_TEXT_STATE;\n                $saw_mini_min_flag = TRUE;           \n            }\n            elsif ( $fieldtag eq \"AV\" ) {\n                $state = ALLELIC_VARIANT_STATE;\n                $saw_mini_min_flag = FALSE;     \n            }\n            elsif ( $fieldtag eq \"SA\" ) { \n                $state = SEE_ALSO_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"RF\" ) {\n                $state = REF_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CS\" ) {\n                $state = SYMPT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CN\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CONTRIBUTORS_STATE;\n                }\n                else {\n                    $state = CONTRIBUTORS_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"CD\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CREATED_BY_STATE;\n                }\n                else {\n                    $state = CREATED_BY_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"ED\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_EDITED_BY_STATE;\n                }\n                else {\n                    $state = EDITED_BY_STATE;\n                }     \n            }\n            else {\n                print \"Warning: Unknown tag: $fieldtag\\n\";\n            }\n\n        }\n        else {\n            $contents .= $line;\n        }\n    }\n\n    $self->_OMIM_text_file()->close();\n    $self->_done( TRUE );\n\n    unless( %record ) {\n        $self->_not_a_OMIM_text_file_error();\n    }\n\n    $self->_add_to_hash( $state, $contents,\\%record );\n    \n    my $omim_entry = $self->_createOMIMentry( \\%record );\n    \n    return $omim_entry;\n\n} # next_phenotype\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $omim_parser->init();   \n Function: Initializes this OMIMparser to all \"\".\n Returns : \n Args    :","parameters":[{"label":"$self"}]}},{"name":"FALSE","kind":12,"line":397},{"kind":12,"name":"FALSE","line":398},{"children":[{"definition":"my","line":416,"name":"$self","localvar":"my","kind":13,"containerName":"genemap_file_name"},{"kind":13,"containerName":"genemap_file_name","name":"$value","line":416},{"line":418,"kind":13,"containerName":"genemap_file_name","name":"$value"},{"line":419,"kind":13,"containerName":"genemap_file_name","name":"$self"},{"name":"$value","kind":13,"containerName":"genemap_file_name","line":419},{"line":420,"containerName":"genemap_file_name","kind":13,"name":"$self"},{"kind":12,"containerName":"genemap_file_name","name":"_genemap_hash","line":420},{"kind":13,"containerName":"genemap_file_name","name":"$self","line":420},{"name":"_read_genemap","containerName":"genemap_file_name","kind":12,"line":420},{"line":420,"name":"$value","kind":13,"containerName":"genemap_file_name"},{"name":"$self","containerName":"genemap_file_name","kind":13,"line":423}],"name":"genemap_file_name","containerName":"main::","definition":"sub","detail":"($self,$value)","line":415,"range":{"end":{"line":424,"character":9999},"start":{"line":415,"character":0}},"kind":12,"signature":{"label":"genemap_file_name($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $genemap_file_name, $omimtxt_file_name ) \n    = $self->_rearrange( [ qw( GENEMAP OMIMTEXT ) ], @args );\n\n    $self->init(); \n    \n    $genemap_file_name && $self->genemap_file_name( $genemap_file_name );\n    \n    $omimtxt_file_name && $self->omimtxt_file_name( $omimtxt_file_name);\n                         \n    return $self;\n}\n\n\n\n\n=head2 next_phenotype\n\n Title   : next_phenotype()\n Usage   : while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n               # do something with $omim_entry\n           }    \n Function: Returns an Bio::Phenotype::OMIM::OMIMentry or\n           undef once the end of the omim text file is reached.\n Returns : A Bio::Phenotype::OMIM::OMIMentry.\n Args    :\n\n\nsub next_phenotype {\n    my ( $self ) = @_;\n    \n    unless( defined( $self->_OMIM_text_file() ) ) {\n        $self->_no_OMIM_text_file_provided_error();\n    }\n    \n    if ( $self->_done() == TRUE ) {\n        return;\n    }\n\n    my $fieldtag          = \"\";\n    my $contents          = \"\";\n    my $line              = \"\";\n    my $state             = DEFAULT_STATE;\n    my $saw_mini_min_flag = FALSE;\n    my %record            = ();\n    \n    while( $line = ( $self->_OMIM_text_file )->_readline() ) {\n        if ( $line =~ /^\\s*\\*RECORD\\*/ ) {\n            if ( $self->_is_not_first_record() == TRUE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n                my $omim_entry = $self->_createOMIMentry( \\%record );\n                return $omim_entry;\n            }\n            else {\n                $self->_is_not_first_record( TRUE );\n            }\n            \n        }\n        elsif ( $line =~ /^\\s*\\*FIELD\\*\\s*(\\S+)/ ) {\n            $fieldtag = $1;\n            if ( $state != DEFAULT_STATE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n            }\n            $contents = \"\";\n            \n            if ( $fieldtag eq \"NO\" ) {\n                $state = MIM_NUMBER_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TI\" ) {\n                $state = TITLE_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TX\" ) {\n                $state = TEXT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"MN\" ) {\n                $state = MINI_MIM_TEXT_STATE;\n                $saw_mini_min_flag = TRUE;           \n            }\n            elsif ( $fieldtag eq \"AV\" ) {\n                $state = ALLELIC_VARIANT_STATE;\n                $saw_mini_min_flag = FALSE;     \n            }\n            elsif ( $fieldtag eq \"SA\" ) { \n                $state = SEE_ALSO_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"RF\" ) {\n                $state = REF_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CS\" ) {\n                $state = SYMPT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CN\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CONTRIBUTORS_STATE;\n                }\n                else {\n                    $state = CONTRIBUTORS_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"CD\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CREATED_BY_STATE;\n                }\n                else {\n                    $state = CREATED_BY_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"ED\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_EDITED_BY_STATE;\n                }\n                else {\n                    $state = EDITED_BY_STATE;\n                }     \n            }\n            else {\n                print \"Warning: Unknown tag: $fieldtag\\n\";\n            }\n\n        }\n        else {\n            $contents .= $line;\n        }\n    }\n\n    $self->_OMIM_text_file()->close();\n    $self->_done( TRUE );\n\n    unless( %record ) {\n        $self->_not_a_OMIM_text_file_error();\n    }\n\n    $self->_add_to_hash( $state, $contents,\\%record );\n    \n    my $omim_entry = $self->_createOMIMentry( \\%record );\n    \n    return $omim_entry;\n\n} # next_phenotype\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $omim_parser->init();   \n Function: Initializes this OMIMparser to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n    \n    $self->genemap_file_name( \"\" );\n    $self->omimtxt_file_name( \"\" );\n    $self->_genemap_hash( {} );\n    $self->_OMIM_text_file( undef );\n    $self->_is_not_first_record( FALSE );\n    $self->_done( FALSE );\n\n} # init\n\n\n\n\n=head2 genemap_file_name\n\n Title   : genemap_file_name\n Usage   : $omimparser->genemap_file_name( \"genemap\" );\n Function: Set/get for the genemap file name.\n Returns : The genemap file name [string].\n Args    : The genemap file name [string] (optional)."}},{"name":"omimtxt_file_name","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"omimtxt_file_name","line":440},{"line":440,"name":"$value","containerName":"omimtxt_file_name","kind":13},{"line":442,"name":"$value","containerName":"omimtxt_file_name","kind":13},{"line":443,"name":"$self","containerName":"omimtxt_file_name","kind":13},{"name":"$value","kind":13,"containerName":"omimtxt_file_name","line":443},{"name":"$value","containerName":"omimtxt_file_name","kind":13,"line":444},{"line":445,"name":"$self","kind":13,"containerName":"omimtxt_file_name"},{"name":"_OMIM_text_file","containerName":"omimtxt_file_name","kind":12,"line":445},{"kind":12,"containerName":"omimtxt_file_name","name":"new","line":445},{"name":"new","kind":12,"containerName":"omimtxt_file_name","line":445},{"line":445,"containerName":"omimtxt_file_name","kind":13,"name":"$value"},{"line":449,"containerName":"omimtxt_file_name","kind":13,"name":"$self"}],"detail":"($self,$value)","definition":"sub","range":{"end":{"line":450,"character":9999},"start":{"line":439,"character":0}},"kind":12,"line":439,"signature":{"documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $genemap_file_name, $omimtxt_file_name ) \n    = $self->_rearrange( [ qw( GENEMAP OMIMTEXT ) ], @args );\n\n    $self->init(); \n    \n    $genemap_file_name && $self->genemap_file_name( $genemap_file_name );\n    \n    $omimtxt_file_name && $self->omimtxt_file_name( $omimtxt_file_name);\n                         \n    return $self;\n}\n\n\n\n\n=head2 next_phenotype\n\n Title   : next_phenotype()\n Usage   : while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n               # do something with $omim_entry\n           }    \n Function: Returns an Bio::Phenotype::OMIM::OMIMentry or\n           undef once the end of the omim text file is reached.\n Returns : A Bio::Phenotype::OMIM::OMIMentry.\n Args    :\n\n\nsub next_phenotype {\n    my ( $self ) = @_;\n    \n    unless( defined( $self->_OMIM_text_file() ) ) {\n        $self->_no_OMIM_text_file_provided_error();\n    }\n    \n    if ( $self->_done() == TRUE ) {\n        return;\n    }\n\n    my $fieldtag          = \"\";\n    my $contents          = \"\";\n    my $line              = \"\";\n    my $state             = DEFAULT_STATE;\n    my $saw_mini_min_flag = FALSE;\n    my %record            = ();\n    \n    while( $line = ( $self->_OMIM_text_file )->_readline() ) {\n        if ( $line =~ /^\\s*\\*RECORD\\*/ ) {\n            if ( $self->_is_not_first_record() == TRUE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n                my $omim_entry = $self->_createOMIMentry( \\%record );\n                return $omim_entry;\n            }\n            else {\n                $self->_is_not_first_record( TRUE );\n            }\n            \n        }\n        elsif ( $line =~ /^\\s*\\*FIELD\\*\\s*(\\S+)/ ) {\n            $fieldtag = $1;\n            if ( $state != DEFAULT_STATE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n            }\n            $contents = \"\";\n            \n            if ( $fieldtag eq \"NO\" ) {\n                $state = MIM_NUMBER_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TI\" ) {\n                $state = TITLE_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TX\" ) {\n                $state = TEXT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"MN\" ) {\n                $state = MINI_MIM_TEXT_STATE;\n                $saw_mini_min_flag = TRUE;           \n            }\n            elsif ( $fieldtag eq \"AV\" ) {\n                $state = ALLELIC_VARIANT_STATE;\n                $saw_mini_min_flag = FALSE;     \n            }\n            elsif ( $fieldtag eq \"SA\" ) { \n                $state = SEE_ALSO_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"RF\" ) {\n                $state = REF_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CS\" ) {\n                $state = SYMPT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CN\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CONTRIBUTORS_STATE;\n                }\n                else {\n                    $state = CONTRIBUTORS_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"CD\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CREATED_BY_STATE;\n                }\n                else {\n                    $state = CREATED_BY_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"ED\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_EDITED_BY_STATE;\n                }\n                else {\n                    $state = EDITED_BY_STATE;\n                }     \n            }\n            else {\n                print \"Warning: Unknown tag: $fieldtag\\n\";\n            }\n\n        }\n        else {\n            $contents .= $line;\n        }\n    }\n\n    $self->_OMIM_text_file()->close();\n    $self->_done( TRUE );\n\n    unless( %record ) {\n        $self->_not_a_OMIM_text_file_error();\n    }\n\n    $self->_add_to_hash( $state, $contents,\\%record );\n    \n    my $omim_entry = $self->_createOMIMentry( \\%record );\n    \n    return $omim_entry;\n\n} # next_phenotype\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $omim_parser->init();   \n Function: Initializes this OMIMparser to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n    \n    $self->genemap_file_name( \"\" );\n    $self->omimtxt_file_name( \"\" );\n    $self->_genemap_hash( {} );\n    $self->_OMIM_text_file( undef );\n    $self->_is_not_first_record( FALSE );\n    $self->_done( FALSE );\n\n} # init\n\n\n\n\n=head2 genemap_file_name\n\n Title   : genemap_file_name\n Usage   : $omimparser->genemap_file_name( \"genemap\" );\n Function: Set/get for the genemap file name.\n Returns : The genemap file name [string].\n Args    : The genemap file name [string] (optional).\n\n\nsub genemap_file_name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_genemap_file_name\" } = $value;\n        $self->_genemap_hash( $self->_read_genemap( $value ) );\n    }\n    \n    return $self->{ \"_genemap_file_name\" };\n} # genemap_file_name\n\n\n\n\n=head2 omimtxt_file_name\n\n Title   : omimtxt_file_name\n Usage   : $omimparser->omimtxt_file_name( \"omim.txt\" );\n Function: Set/get for the omim text file name.\n Returns : The the omim text file name [string].\n Args    : The the omim text file name [string] (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"omimtxt_file_name($self,$value)"}},{"line":445,"kind":12,"containerName":"Root::IO","name":"Bio"},{"detail":"($self,$record_ref)","definition":"sub","containerName":"main::","name":"_createOMIMentry","children":[{"line":457,"containerName":"_createOMIMentry","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":457,"kind":13,"containerName":"_createOMIMentry","name":"$record_ref"},{"definition":"my","line":459,"name":"$omim_entry","localvar":"my","kind":13,"containerName":"_createOMIMentry"},{"name":"new","containerName":"_createOMIMentry","kind":12,"line":459},{"line":460,"kind":13,"localvar":"my","containerName":"_createOMIMentry","name":"$mini_mim","definition":"my"},{"name":"new","containerName":"_createOMIMentry","kind":12,"line":460},{"localvar":"my","containerName":"_createOMIMentry","kind":13,"name":"$key","line":462,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_createOMIMentry","name":"$val","line":462},{"containerName":"_createOMIMentry","kind":13,"name":"$record_ref","line":462},{"name":"$val","kind":13,"containerName":"_createOMIMentry","line":464},{"kind":13,"containerName":"_createOMIMentry","name":"$val","line":465},{"name":"$key","kind":13,"containerName":"_createOMIMentry","line":467},{"kind":13,"containerName":"_createOMIMentry","name":"$val","line":468},{"line":469,"name":"$val","containerName":"_createOMIMentry","kind":13},{"line":471,"containerName":"_createOMIMentry","kind":13,"name":"$omim_entry"},{"line":471,"name":"MIM_number","kind":12,"containerName":"_createOMIMentry"},{"line":471,"containerName":"_createOMIMentry","kind":13,"name":"$val"},{"line":473,"localvar":"my","containerName":"_createOMIMentry","kind":13,"name":"$gm","definition":"my"},{"line":473,"name":"$self","kind":13,"containerName":"_createOMIMentry"},{"name":"_genemap_hash","kind":12,"containerName":"_createOMIMentry","line":473},{"containerName":"_createOMIMentry","kind":13,"name":"$val","line":474},{"name":"$self","containerName":"_createOMIMentry","kind":13,"line":475},{"line":475,"name":"_parse_genemap","containerName":"_createOMIMentry","kind":12},{"name":"$omim_entry","kind":13,"containerName":"_createOMIMentry","line":475},{"line":475,"kind":13,"containerName":"_createOMIMentry","name":"$val"},{"containerName":"_createOMIMentry","kind":13,"name":"$key","line":479},{"line":480,"name":"$title","localvar":"my","kind":13,"containerName":"_createOMIMentry","definition":"my"},{"line":480,"containerName":"_createOMIMentry","kind":13,"name":"$alt_titles"},{"line":480,"name":"$self","containerName":"_createOMIMentry","kind":13},{"containerName":"_createOMIMentry","kind":12,"name":"_parse_title","line":480},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":480},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":481},{"name":"title","kind":12,"containerName":"_createOMIMentry","line":481},{"name":"$title","containerName":"_createOMIMentry","kind":13,"line":481},{"line":482,"name":"$omim_entry","containerName":"_createOMIMentry","kind":13},{"line":482,"containerName":"_createOMIMentry","kind":12,"name":"alternative_titles_and_symbols"},{"line":482,"name":"$alt_titles","kind":13,"containerName":"_createOMIMentry"},{"line":483,"containerName":"_createOMIMentry","kind":13,"name":"$title"},{"containerName":"_createOMIMentry","kind":13,"name":"$omim_entry","line":484},{"containerName":"_createOMIMentry","kind":12,"name":"is_separate","line":484},{"kind":13,"containerName":"_createOMIMentry","name":"$title","line":486},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":487},{"name":"more_than_two_genes","containerName":"_createOMIMentry","kind":12,"line":487},{"containerName":"_createOMIMentry","kind":13,"name":"$key","line":490},{"line":491,"containerName":"_createOMIMentry","kind":13,"name":"$val"},{"line":491,"kind":13,"containerName":"_createOMIMentry","name":"$val"},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":492},{"line":492,"kind":12,"containerName":"_createOMIMentry","name":"description"},{"kind":13,"containerName":"_createOMIMentry","name":"$val","line":492},{"name":"$key","containerName":"_createOMIMentry","kind":13,"line":494},{"line":495,"containerName":"_createOMIMentry","localvar":"my","kind":13,"name":"@allelic_variants","definition":"my"},{"name":"$self","kind":13,"containerName":"_createOMIMentry","line":495},{"line":495,"containerName":"_createOMIMentry","kind":12,"name":"_parse_allelic_variants"},{"name":"$val","kind":13,"containerName":"_createOMIMentry","line":495},{"line":496,"containerName":"_createOMIMentry","kind":13,"name":"$omim_entry"},{"name":"add_AllelicVariants","kind":12,"containerName":"_createOMIMentry","line":496},{"line":496,"name":"@allelic_variants","containerName":"_createOMIMentry","kind":13},{"name":"$key","kind":13,"containerName":"_createOMIMentry","line":498},{"containerName":"_createOMIMentry","kind":13,"name":"$omim_entry","line":499},{"line":499,"containerName":"_createOMIMentry","kind":12,"name":"additional_references"},{"containerName":"_createOMIMentry","kind":13,"name":"$val","line":499},{"name":"$key","kind":13,"containerName":"_createOMIMentry","line":501},{"name":"@refs","kind":13,"localvar":"my","containerName":"_createOMIMentry","line":502,"definition":"my"},{"line":502,"name":"$self","containerName":"_createOMIMentry","kind":13},{"name":"_parse_references","containerName":"_createOMIMentry","kind":12,"line":502},{"containerName":"_createOMIMentry","kind":13,"name":"$val","line":502},{"kind":13,"containerName":"_createOMIMentry","name":"$omim_entry","line":503},{"line":503,"containerName":"_createOMIMentry","kind":12,"name":"add_References"},{"line":503,"name":"@refs","containerName":"_createOMIMentry","kind":13},{"kind":13,"containerName":"_createOMIMentry","name":"$key","line":505},{"line":506,"name":"$val","kind":13,"containerName":"_createOMIMentry"},{"line":506,"kind":13,"containerName":"_createOMIMentry","name":"$val"},{"kind":13,"containerName":"_createOMIMentry","name":"$omim_entry","line":507},{"line":507,"containerName":"_createOMIMentry","kind":12,"name":"clinical_symptoms_raw"},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":507},{"kind":13,"containerName":"_createOMIMentry","name":"$key","line":509},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":510},{"line":510,"name":"$val","containerName":"_createOMIMentry","kind":13},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":511},{"name":"contributors","kind":12,"containerName":"_createOMIMentry","line":511},{"line":511,"kind":13,"containerName":"_createOMIMentry","name":"$val"},{"line":513,"containerName":"_createOMIMentry","kind":13,"name":"$key"},{"line":514,"name":"$val","containerName":"_createOMIMentry","kind":13},{"line":514,"name":"$val","containerName":"_createOMIMentry","kind":13},{"kind":13,"containerName":"_createOMIMentry","name":"$omim_entry","line":515},{"line":515,"name":"created","kind":12,"containerName":"_createOMIMentry"},{"line":515,"name":"$val","containerName":"_createOMIMentry","kind":13},{"name":"$key","kind":13,"containerName":"_createOMIMentry","line":517},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":518},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":518},{"line":519,"name":"$omim_entry","containerName":"_createOMIMentry","kind":13},{"name":"edited","containerName":"_createOMIMentry","kind":12,"line":519},{"containerName":"_createOMIMentry","kind":13,"name":"$val","line":519},{"name":"$key","containerName":"_createOMIMentry","kind":13,"line":521},{"line":522,"name":"$mini_mim","kind":13,"containerName":"_createOMIMentry"},{"containerName":"_createOMIMentry","kind":12,"name":"description","line":522},{"line":522,"containerName":"_createOMIMentry","kind":13,"name":"$val"},{"name":"$key","containerName":"_createOMIMentry","kind":13,"line":524},{"line":525,"kind":13,"containerName":"_createOMIMentry","name":"$mini_mim"},{"containerName":"_createOMIMentry","kind":12,"name":"contributors","line":525},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":525},{"containerName":"_createOMIMentry","kind":13,"name":"$key","line":527},{"name":"$mini_mim","kind":13,"containerName":"_createOMIMentry","line":528},{"line":528,"name":"created","containerName":"_createOMIMentry","kind":12},{"containerName":"_createOMIMentry","kind":13,"name":"$val","line":528},{"name":"$key","containerName":"_createOMIMentry","kind":13,"line":530},{"line":531,"containerName":"_createOMIMentry","kind":13,"name":"$mini_mim"},{"name":"edited","kind":12,"containerName":"_createOMIMentry","line":531},{"line":531,"containerName":"_createOMIMentry","kind":13,"name":"$val"},{"definition":"my","kind":13,"localvar":"my","containerName":"_createOMIMentry","name":"$man","line":536},{"line":536,"containerName":"_createOMIMentry","kind":12,"name":"new"},{"name":"$man","kind":13,"containerName":"_createOMIMentry","line":537},{"kind":12,"containerName":"_createOMIMentry","name":"classification","line":537},{"line":538,"containerName":"_createOMIMentry","kind":13,"name":"$man"},{"name":"common_name","kind":12,"containerName":"_createOMIMentry","line":538},{"line":539,"containerName":"_createOMIMentry","kind":13,"name":"$omim_entry"},{"name":"species","kind":12,"containerName":"_createOMIMentry","line":539},{"line":539,"containerName":"_createOMIMentry","kind":13,"name":"$man"},{"line":540,"name":"$omim_entry","kind":13,"containerName":"_createOMIMentry"},{"line":540,"name":"miniMIM","containerName":"_createOMIMentry","kind":12},{"containerName":"_createOMIMentry","kind":13,"name":"$mini_mim","line":540},{"line":543,"name":"$self","containerName":"_createOMIMentry","kind":13},{"line":543,"name":"_finer_parse_symptoms","kind":12,"containerName":"_createOMIMentry"},{"line":543,"kind":13,"containerName":"_createOMIMentry","name":"$omim_entry"},{"line":545,"kind":13,"containerName":"_createOMIMentry","name":"$omim_entry"}],"signature":{"parameters":[{"label":"$self"},{"label":"$record_ref"}],"documentation":"","label":"_createOMIMentry($self,$record_ref)"},"kind":12,"range":{"start":{"character":0,"line":456},"end":{"character":9999,"line":547}},"line":456},{"name":"Bio","containerName":"Phenotype::OMIM::OMIMentry","kind":12,"line":459},{"kind":12,"containerName":"Phenotype::OMIM::MiniMIMentry","name":"Bio","line":460},{"line":467,"kind":12,"name":"MIM_NUMBER_STATE"},{"line":474,"kind":12,"name":"gm"},{"name":"TITLE_STATE","kind":12,"line":479},{"line":484,"kind":12,"name":"TRUE"},{"line":487,"name":"TRUE","kind":12},{"kind":12,"name":"TEXT_STATE","line":490},{"name":"ALLELIC_VARIANT_STATE","kind":12,"line":494},{"name":"SEE_ALSO_STATE","kind":12,"line":498},{"kind":12,"name":"REF_STATE","line":501},{"kind":12,"name":"SYMPT_STATE","line":505},{"kind":12,"name":"CONTRIBUTORS_STATE","line":509},{"line":513,"name":"CREATED_BY_STATE","kind":12},{"kind":12,"name":"EDITED_BY_STATE","line":517},{"kind":12,"name":"MINI_MIM_TEXT_STATE","line":521},{"line":524,"name":"MINI_MIM_CONTRIBUTORS_STATE","kind":12},{"kind":12,"name":"MINI_MIM_CREATED_BY_STATE","line":527},{"name":"MINI_MIM_EDITED_BY_STATE","kind":12,"line":530},{"line":536,"name":"Bio","containerName":"Species","kind":12},{"range":{"end":{"line":570,"character":9999},"start":{"line":550,"character":0}},"kind":12,"line":550,"signature":{"label":"_finer_parse_symptoms($self,$omim_entry)","documentation":"","parameters":[{"label":"$self"},{"label":"$omim_entry"}]},"name":"_finer_parse_symptoms","containerName":"main::","children":[{"definition":"my","containerName":"_finer_parse_symptoms","localvar":"my","kind":13,"name":"$self","line":551},{"name":"$omim_entry","containerName":"_finer_parse_symptoms","kind":13,"line":551},{"definition":"my","line":552,"name":"$text","localvar":"my","kind":13,"containerName":"_finer_parse_symptoms"},{"line":552,"name":"$omim_entry","containerName":"_finer_parse_symptoms","kind":13},{"line":552,"kind":12,"containerName":"_finer_parse_symptoms","name":"clinical_symptoms_raw"},{"line":553,"name":"$text","containerName":"_finer_parse_symptoms","kind":13},{"localvar":"my","containerName":"_finer_parse_symptoms","kind":13,"name":"$part","line":554,"definition":"my"},{"definition":"my","line":555,"kind":13,"localvar":"my","containerName":"_finer_parse_symptoms","name":"$line"},{"line":555,"containerName":"_finer_parse_symptoms","kind":13,"name":"$text"},{"line":556,"containerName":"_finer_parse_symptoms","kind":13,"name":"$line"},{"name":"$part","containerName":"_finer_parse_symptoms","kind":13,"line":557},{"name":"$line","kind":13,"containerName":"_finer_parse_symptoms","line":558},{"kind":13,"containerName":"_finer_parse_symptoms","name":"$line","line":559},{"definition":"my","line":560,"containerName":"_finer_parse_symptoms","localvar":"my","kind":13,"name":"$symptom"},{"line":561,"name":"$part","containerName":"_finer_parse_symptoms","kind":13},{"containerName":"_finer_parse_symptoms","kind":13,"name":"$omim_entry","line":565},{"line":565,"name":"add_clinical_symptoms","containerName":"_finer_parse_symptoms","kind":12},{"line":565,"containerName":"_finer_parse_symptoms","kind":13,"name":"$part"},{"name":"$symptom","containerName":"_finer_parse_symptoms","kind":13,"line":565},{"line":569,"containerName":"_finer_parse_symptoms","kind":13,"name":"$omim_entry"},{"kind":12,"containerName":"_finer_parse_symptoms","name":"clinical_symptoms_raw","line":569}],"detail":"($self,$omim_entry)","definition":"sub"},{"detail":"($self,$omim_entry,$val)","definition":"sub","containerName":"main::","name":"_parse_genemap","children":[{"definition":"my","line":573,"containerName":"_parse_genemap","localvar":"my","kind":13,"name":"$self"},{"line":573,"name":"$omim_entry","containerName":"_parse_genemap","kind":13},{"name":"$val","kind":13,"containerName":"_parse_genemap","line":573},{"definition":"my","containerName":"_parse_genemap","localvar":"my","kind":13,"name":"$genemap_line","line":575},{"line":575,"name":"$self","containerName":"_parse_genemap","kind":13},{"line":575,"name":"_genemap_hash","containerName":"_parse_genemap","kind":12}],"signature":{"label":"_parse_genemap($self,$omim_entry,$val)","documentation":"","parameters":[{"label":"$self"},{"label":"$omim_entry"},{"label":"$val"}]},"range":{"start":{"line":572,"character":0},"end":{"line":575,"character":9999}},"kind":12,"line":572},{"name":"$val","containerName":null,"kind":13,"line":575},{"definition":"my","name":"@a","kind":13,"localvar":"my","containerName":null,"line":576},{"name":"$genemap_line","containerName":null,"kind":13,"line":576},{"definition":"my","line":578,"name":"$locations","kind":13,"localvar":"my","containerName":null},{"name":"@a","containerName":null,"kind":13,"line":578},{"line":579,"name":"%locations","kind":13,"containerName":null},{"line":580,"containerName":null,"kind":13,"name":"$locations"},{"name":"@ls","localvar":"my","kind":13,"containerName":null,"line":581,"definition":"my"},{"line":581,"name":"$locations","containerName":null,"kind":13},{"line":582,"name":"@cps","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":583,"kind":13,"localvar":"my","containerName":null,"name":"$l","definition":"my"},{"name":"@ls","containerName":null,"kind":13,"line":583},{"line":584,"kind":13,"localvar":"my","containerName":null,"name":"$cp","definition":"my"},{"line":584,"containerName":"Map::CytoPosition","kind":12,"name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":584},{"line":584,"containerName":null,"kind":13,"name":"$l"},{"containerName":null,"kind":13,"name":"@cps","line":585},{"name":"$cp","kind":13,"containerName":null,"line":585},{"line":587,"kind":13,"containerName":null,"name":"$omim_entry"},{"name":"add_CytoPositions","containerName":"main::","kind":12,"line":587},{"line":587,"kind":13,"containerName":null,"name":"@cps"},{"name":"$gene_symbols","localvar":"my","kind":13,"containerName":null,"line":590,"definition":"my"},{"containerName":null,"kind":13,"name":"@a","line":590},{"line":591,"containerName":null,"kind":13,"name":"%gene_symbols"},{"containerName":null,"kind":13,"name":"$gene_symbols","line":592},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@gss","line":593},{"line":593,"name":"$gene_symbols","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$omim_entry","line":594},{"line":594,"containerName":"main::","kind":12,"name":"add_gene_symbols"},{"line":594,"kind":13,"containerName":null,"name":"@gss"},{"definition":"my","line":597,"name":"$mouse_correlates","localvar":"my","kind":13,"containerName":null},{"line":597,"containerName":null,"kind":13,"name":"@a"},{"name":"%mouse_correlates","containerName":null,"kind":13,"line":598},{"kind":13,"containerName":null,"name":"$mouse_correlates","line":599},{"definition":"my","line":600,"kind":13,"localvar":"my","containerName":null,"name":"@mcs"},{"line":600,"name":"$mouse_correlates","kind":13,"containerName":null},{"definition":"my","name":"@cs","containerName":null,"localvar":"my","kind":13,"line":601},{"line":602,"name":"$mc","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"line":602,"kind":13,"containerName":null,"name":"@mcs"},{"definition":"my","line":603,"name":"$mouse","localvar":"my","kind":13,"containerName":null},{"line":603,"containerName":"Species","kind":12,"name":"Bio"},{"name":"new","kind":12,"containerName":"main::","line":603},{"line":604,"name":"$mouse","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"classification","line":604},{"line":605,"kind":13,"containerName":null,"name":"$mouse"},{"line":605,"name":"common_name","kind":12,"containerName":"main::"},{"definition":"my","name":"$c","localvar":"my","kind":13,"containerName":null,"line":606},{"name":"Bio","kind":12,"containerName":"Phenotype::Correlate","line":606},{"line":606,"name":"new","containerName":"main::","kind":12},{"line":607,"name":"$c","containerName":null,"kind":13},{"name":"name","containerName":"main::","kind":12,"line":607},{"kind":13,"containerName":null,"name":"$mc","line":607},{"kind":13,"containerName":null,"name":"$c","line":608},{"containerName":"main::","kind":12,"name":"species","line":608},{"line":608,"kind":13,"containerName":null,"name":"$mouse"},{"kind":13,"containerName":null,"name":"$c","line":609},{"line":609,"name":"type","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"@cs","line":611},{"line":611,"name":"$c","containerName":null,"kind":13},{"name":"$omim_entry","kind":13,"containerName":null,"line":613},{"line":613,"name":"add_Correlates","containerName":"main::","kind":12},{"name":"@cs","containerName":null,"kind":13,"line":613},{"name":"$omim_entry","kind":13,"containerName":null,"line":616},{"line":616,"kind":12,"containerName":"main::","name":"gene_status"},{"line":616,"name":"@a","kind":13,"containerName":null},{"line":616,"kind":13,"containerName":null,"name":"@a"},{"line":617,"containerName":null,"kind":13,"name":"$omim_entry"},{"line":617,"name":"mapping_method","kind":12,"containerName":"main::"},{"line":617,"name":"@a","kind":13,"containerName":null},{"line":617,"name":"@a","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$omim_entry","line":618},{"line":618,"containerName":"main::","kind":12,"name":"comment"},{"line":618,"containerName":null,"kind":13,"name":"@a"},{"kind":13,"containerName":null,"name":"@a","line":618},{"definition":"sub","detail":"($self,$text)","children":[{"kind":13,"localvar":"my","containerName":"_parse_allelic_variants","name":"$self","line":626,"definition":"my"},{"containerName":"_parse_allelic_variants","kind":13,"name":"$text","line":626},{"definition":"my","name":"@allelic_variants","localvar":"my","kind":13,"containerName":"_parse_allelic_variants","line":628},{"definition":"my","line":629,"localvar":"my","kind":13,"containerName":"_parse_allelic_variants","name":"$number"},{"definition":"my","line":630,"kind":13,"localvar":"my","containerName":"_parse_allelic_variants","name":"$title"},{"definition":"my","line":631,"localvar":"my","containerName":"_parse_allelic_variants","kind":13,"name":"$symbol_mut_line"},{"definition":"my","line":632,"name":"$prev_line","containerName":"_parse_allelic_variants","localvar":"my","kind":13},{"definition":"my","name":"$description","kind":13,"localvar":"my","containerName":"_parse_allelic_variants","line":633},{"line":634,"localvar":"my","kind":13,"containerName":"_parse_allelic_variants","name":"$saw_empty_line","definition":"my"},{"definition":"my","name":"@lines","localvar":"my","kind":13,"containerName":"_parse_allelic_variants","line":636},{"line":636,"name":"$text","containerName":"_parse_allelic_variants","kind":13},{"definition":"my","line":638,"name":"$line","kind":13,"localvar":"my","containerName":"_parse_allelic_variants"},{"line":638,"name":"@lines","containerName":"_parse_allelic_variants","kind":13},{"line":639,"name":"$line","containerName":"_parse_allelic_variants","kind":13},{"line":640,"kind":13,"containerName":"_parse_allelic_variants","name":"$saw_empty_line"},{"name":"$line","kind":13,"containerName":"_parse_allelic_variants","line":642},{"definition":"my","line":643,"containerName":"_parse_allelic_variants","localvar":"my","kind":13,"name":"$current_number"},{"line":644,"kind":13,"containerName":"_parse_allelic_variants","name":"$number"},{"name":"$allelic_variant","localvar":"my","kind":13,"containerName":"_parse_allelic_variants","line":645,"definition":"my"},{"name":"$self","kind":13,"containerName":"_parse_allelic_variants","line":645},{"kind":12,"containerName":"_parse_allelic_variants","name":"_create_allelic_variant","line":645},{"line":645,"kind":13,"containerName":"_parse_allelic_variants","name":"$number"},{"name":"$title","kind":13,"containerName":"_parse_allelic_variants","line":645},{"name":"$symbol_mut_line","containerName":"_parse_allelic_variants","kind":13,"line":646},{"name":"$description","kind":13,"containerName":"_parse_allelic_variants","line":646},{"line":648,"name":"@allelic_variants","containerName":"_parse_allelic_variants","kind":13},{"line":648,"name":"$allelic_variant","kind":13,"containerName":"_parse_allelic_variants"},{"line":650,"name":"$number","kind":13,"containerName":"_parse_allelic_variants"},{"line":650,"name":"$current_number","kind":13,"containerName":"_parse_allelic_variants"},{"line":651,"name":"$title","kind":13,"containerName":"_parse_allelic_variants"},{"line":652,"name":"$prev_line","containerName":"_parse_allelic_variants","kind":13},{"name":"$symbol_mut_line","kind":13,"containerName":"_parse_allelic_variants","line":653},{"line":654,"containerName":"_parse_allelic_variants","kind":13,"name":"$description"},{"containerName":"_parse_allelic_variants","kind":13,"name":"$saw_empty_line","line":655},{"line":657,"name":"$title","kind":13,"containerName":"_parse_allelic_variants"},{"line":658,"name":"$title","containerName":"_parse_allelic_variants","kind":13},{"name":"$line","containerName":"_parse_allelic_variants","kind":13,"line":658},{"containerName":"_parse_allelic_variants","kind":13,"name":"$saw_empty_line","line":660},{"name":"$prev_line","containerName":"_parse_allelic_variants","kind":13,"line":661},{"line":661,"name":"$line","kind":13,"containerName":"_parse_allelic_variants"},{"line":663,"containerName":"_parse_allelic_variants","kind":13,"name":"$saw_empty_line"},{"kind":13,"containerName":"_parse_allelic_variants","name":"$prev_line","line":664},{"name":"$symbol_mut_line","kind":13,"containerName":"_parse_allelic_variants","line":665},{"line":665,"containerName":"_parse_allelic_variants","kind":13,"name":"$prev_line"},{"line":666,"name":"$prev_line","kind":13,"containerName":"_parse_allelic_variants"},{"containerName":"_parse_allelic_variants","kind":13,"name":"$description","line":668},{"kind":13,"containerName":"_parse_allelic_variants","name":"$description","line":669},{"line":669,"containerName":"_parse_allelic_variants","kind":13,"name":"$line"},{"kind":13,"containerName":"_parse_allelic_variants","name":"$description","line":672},{"kind":13,"containerName":"_parse_allelic_variants","name":"$line","line":672},{"line":677,"localvar":"my","kind":13,"containerName":"_parse_allelic_variants","name":"$allelic_variant","definition":"my"},{"kind":13,"containerName":"_parse_allelic_variants","name":"$self","line":677},{"name":"_create_allelic_variant","containerName":"_parse_allelic_variants","kind":12,"line":677},{"line":677,"kind":13,"containerName":"_parse_allelic_variants","name":"$number"},{"line":677,"name":"$title","kind":13,"containerName":"_parse_allelic_variants"},{"name":"$symbol_mut_line","containerName":"_parse_allelic_variants","kind":13,"line":678},{"name":"$description","kind":13,"containerName":"_parse_allelic_variants","line":678},{"name":"@allelic_variants","containerName":"_parse_allelic_variants","kind":13,"line":680},{"kind":13,"containerName":"_parse_allelic_variants","name":"$allelic_variant","line":680},{"line":682,"name":"@allelic_variants","kind":13,"containerName":"_parse_allelic_variants"}],"containerName":"main::","name":"_parse_allelic_variants","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$text"}],"label":"_parse_allelic_variants($self,$text)"},"line":625,"kind":12,"range":{"end":{"character":9999,"line":684},"start":{"line":625,"character":0}}},{"name":"FALSE","kind":12,"line":634},{"kind":12,"name":"TRUE","line":640},{"name":"FALSE","kind":12,"line":655},{"line":660,"kind":12,"name":"FALSE"},{"name":"TRUE","kind":12,"line":663},{"line":689,"kind":12,"range":{"end":{"character":9999,"line":728},"start":{"line":689,"character":0}},"signature":{"label":"_create_allelic_variant($self,$number,$title,$symbol_mut_line,$description)","documentation":"","parameters":[{"label":"$self"},{"label":"$number"},{"label":"$title"},{"label":"$symbol_mut_line"},{"label":"$description"}]},"children":[{"line":690,"name":"$self","containerName":"_create_allelic_variant","localvar":"my","kind":13,"definition":"my"},{"line":690,"kind":13,"containerName":"_create_allelic_variant","name":"$number"},{"line":690,"name":"$title","kind":13,"containerName":"_create_allelic_variant"},{"line":690,"name":"$symbol_mut_line","kind":13,"containerName":"_create_allelic_variant"},{"line":690,"containerName":"_create_allelic_variant","kind":13,"name":"$description"},{"definition":"my","name":"$symbol","localvar":"my","kind":13,"containerName":"_create_allelic_variant","line":692},{"line":693,"containerName":"_create_allelic_variant","localvar":"my","kind":13,"name":"$mutation","definition":"my"},{"line":694,"name":"$aa_ori","localvar":"my","kind":13,"containerName":"_create_allelic_variant","definition":"my"},{"definition":"my","line":695,"name":"$aa_mut","kind":13,"localvar":"my","containerName":"_create_allelic_variant"},{"definition":"my","name":"$position","localvar":"my","kind":13,"containerName":"_create_allelic_variant","line":696},{"kind":13,"containerName":"_create_allelic_variant","name":"$symbol_mut_line","line":698},{"kind":13,"containerName":"_create_allelic_variant","name":"$symbol","line":699},{"name":"$aa_ori","kind":13,"containerName":"_create_allelic_variant","line":700},{"line":701,"kind":13,"containerName":"_create_allelic_variant","name":"$aa_mut"},{"line":702,"name":"$position","containerName":"_create_allelic_variant","kind":13},{"name":"$symbol_mut_line","kind":13,"containerName":"_create_allelic_variant","line":704},{"name":"$symbol","containerName":"_create_allelic_variant","kind":13,"line":705},{"line":706,"name":"$mutation","kind":13,"containerName":"_create_allelic_variant"},{"kind":13,"containerName":"_create_allelic_variant","name":"$symbol","line":709},{"name":"$symbol_mut_line","kind":13,"containerName":"_create_allelic_variant","line":709},{"name":"$description","kind":13,"containerName":"_create_allelic_variant","line":712},{"line":712,"containerName":"_create_allelic_variant","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"_create_allelic_variant","line":712},{"name":"$mutation","containerName":"_create_allelic_variant","kind":13,"line":713},{"containerName":"_create_allelic_variant","kind":13,"name":"$self","line":713},{"name":"throw","kind":12,"containerName":"_create_allelic_variant","line":713},{"definition":"my","line":716,"localvar":"my","containerName":"_create_allelic_variant","kind":13,"name":"$allelic_variant"},{"line":716,"containerName":"_create_allelic_variant","kind":12,"name":"new"},{"name":"$allelic_variant","containerName":"_create_allelic_variant","kind":13,"line":717},{"line":717,"name":"number","kind":12,"containerName":"_create_allelic_variant"},{"line":717,"containerName":"_create_allelic_variant","kind":13,"name":"$number"},{"name":"$allelic_variant","containerName":"_create_allelic_variant","kind":13,"line":718},{"name":"aa_ori","containerName":"_create_allelic_variant","kind":12,"line":718},{"line":718,"name":"$aa_ori","containerName":"_create_allelic_variant","kind":13},{"line":719,"containerName":"_create_allelic_variant","kind":13,"name":"$allelic_variant"},{"containerName":"_create_allelic_variant","kind":12,"name":"aa_mut","line":719},{"line":719,"name":"$aa_mut","containerName":"_create_allelic_variant","kind":13},{"line":720,"name":"$allelic_variant","kind":13,"containerName":"_create_allelic_variant"},{"line":720,"kind":12,"containerName":"_create_allelic_variant","name":"position"},{"kind":13,"containerName":"_create_allelic_variant","name":"$position","line":720},{"line":721,"name":"$allelic_variant","containerName":"_create_allelic_variant","kind":13},{"containerName":"_create_allelic_variant","kind":12,"name":"title","line":721},{"line":721,"kind":13,"containerName":"_create_allelic_variant","name":"$title"},{"line":722,"name":"$allelic_variant","containerName":"_create_allelic_variant","kind":13},{"line":722,"name":"symbol","kind":12,"containerName":"_create_allelic_variant"},{"name":"$symbol","kind":13,"containerName":"_create_allelic_variant","line":722},{"line":723,"name":"$allelic_variant","containerName":"_create_allelic_variant","kind":13},{"containerName":"_create_allelic_variant","kind":12,"name":"description","line":723},{"line":723,"name":"$description","containerName":"_create_allelic_variant","kind":13},{"line":724,"name":"$allelic_variant","kind":13,"containerName":"_create_allelic_variant"},{"containerName":"_create_allelic_variant","kind":12,"name":"additional_mutations","line":724},{"line":724,"name":"$mutation","kind":13,"containerName":"_create_allelic_variant"},{"line":726,"containerName":"_create_allelic_variant","kind":13,"name":"$allelic_variant"}],"name":"_create_allelic_variant","containerName":"main::","definition":"sub","detail":"($self,$number,$title,$symbol_mut_line,$description)"},{"name":"Bio","kind":12,"containerName":"Phenotype::OMIM::OMIMentryAllelicVariant","line":716},{"signature":{"label":"_parse_title($self,$text)","documentation":"","parameters":[{"label":"$self"},{"label":"$text"}]},"line":733,"kind":12,"range":{"start":{"character":0,"line":733},"end":{"character":9999,"line":747}},"definition":"sub","detail":"($self,$text)","children":[{"name":"$self","localvar":"my","containerName":"_parse_title","kind":13,"line":734,"definition":"my"},{"line":734,"containerName":"_parse_title","kind":13,"name":"$text"},{"definition":"my","line":735,"name":"$title","localvar":"my","kind":13,"containerName":"_parse_title"},{"containerName":"_parse_title","kind":13,"name":"$text","line":736},{"kind":13,"containerName":"_parse_title","name":"$title","line":737},{"name":"$text","kind":13,"containerName":"_parse_title","line":738},{"line":741,"name":"$title","containerName":"_parse_title","kind":13},{"line":741,"name":"$text","kind":13,"containerName":"_parse_title"},{"line":742,"kind":13,"containerName":"_parse_title","name":"$text"},{"line":746,"name":"$title","kind":13,"containerName":"_parse_title"},{"containerName":"_parse_title","kind":13,"name":"$text","line":746}],"containerName":"main::","name":"_parse_title"},{"detail":"($self,$text)","definition":"sub","containerName":"main::","name":"_parse_references","children":[{"definition":"my","line":753,"name":"$self","kind":13,"localvar":"my","containerName":"_parse_references"},{"line":753,"containerName":"_parse_references","kind":13,"name":"$text"},{"line":755,"kind":13,"containerName":"_parse_references","name":"$text"},{"name":"$text","kind":13,"containerName":"_parse_references","line":756},{"line":757,"name":"$text","containerName":"_parse_references","kind":13},{"definition":"my","name":"@references","localvar":"my","kind":13,"containerName":"_parse_references","line":759},{"definition":"my","name":"@texts","containerName":"_parse_references","localvar":"my","kind":13,"line":761},{"line":761,"name":"$text","containerName":"_parse_references","kind":13},{"definition":"my","containerName":"_parse_references","localvar":"my","kind":13,"name":"$t","line":763},{"name":"@texts","kind":13,"containerName":"_parse_references","line":763},{"definition":"my","name":"$authors","localvar":"my","kind":13,"containerName":"_parse_references","line":765},{"definition":"my","line":766,"kind":13,"localvar":"my","containerName":"_parse_references","name":"$title"},{"definition":"my","line":767,"name":"$location","containerName":"_parse_references","localvar":"my","kind":13},{"kind":13,"containerName":"_parse_references","name":"$t","line":769},{"kind":13,"containerName":"_parse_references","name":"$t","line":771},{"line":772,"kind":13,"containerName":"_parse_references","name":"$authors"},{"name":"$title","kind":13,"containerName":"_parse_references","line":773},{"name":"$journal","localvar":"my","kind":13,"containerName":"_parse_references","line":774,"definition":"my"},{"localvar":"my","containerName":"_parse_references","kind":13,"name":"$volume","line":775,"definition":"my"},{"kind":13,"localvar":"my","containerName":"_parse_references","name":"$fromto","line":776,"definition":"my"},{"kind":13,"localvar":"my","containerName":"_parse_references","name":"$year","line":777,"definition":"my"},{"line":778,"name":"$from","containerName":"_parse_references","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$to","localvar":"my","containerName":"_parse_references","kind":13,"line":779},{"line":780,"name":"$fromto","containerName":"_parse_references","kind":13},{"name":"$from","containerName":"_parse_references","kind":13,"line":781},{"name":"$to","containerName":"_parse_references","kind":13,"line":782},{"line":784,"containerName":"_parse_references","kind":13,"name":"$fromto"},{"line":785,"name":"$from","containerName":"_parse_references","kind":13},{"line":787,"containerName":"_parse_references","kind":13,"name":"$location"},{"line":787,"name":"$journal","kind":13,"containerName":"_parse_references"},{"name":"$volume","kind":13,"containerName":"_parse_references","line":787},{"kind":13,"containerName":"_parse_references","name":"$from","line":787},{"name":"$to","containerName":"_parse_references","kind":13,"line":787},{"line":787,"kind":13,"containerName":"_parse_references","name":"$year"},{"name":"$t","containerName":"_parse_references","kind":13,"line":791},{"name":"$authors","kind":13,"containerName":"_parse_references","line":792},{"line":793,"containerName":"_parse_references","kind":13,"name":"$title"},{"line":794,"kind":13,"containerName":"_parse_references","name":"$location"},{"name":"$title","kind":13,"containerName":"_parse_references","line":797},{"containerName":"_parse_references","kind":13,"name":"$t","line":797},{"definition":"my","name":"$ref","containerName":"_parse_references","localvar":"my","kind":13,"line":800},{"line":800,"containerName":"_parse_references","kind":12,"name":"new"},{"kind":13,"containerName":"_parse_references","name":"$title","line":800},{"containerName":"_parse_references","kind":13,"name":"$location","line":801},{"line":802,"name":"$authors","kind":13,"containerName":"_parse_references"},{"line":803,"kind":13,"containerName":"_parse_references","name":"@references"},{"line":803,"containerName":"_parse_references","kind":13,"name":"$ref"},{"line":806,"containerName":"_parse_references","kind":13,"name":"@references"}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$text"}],"label":"_parse_references($self,$text)"},"kind":12,"range":{"start":{"line":752,"character":0},"end":{"character":9999,"line":808}},"line":752},{"line":800,"containerName":"Annotation::Reference","kind":12,"name":"Bio"},{"children":[{"line":814,"name":"$self","kind":13,"localvar":"my","containerName":"_genemap_hash","definition":"my"},{"kind":13,"containerName":"_genemap_hash","name":"$value","line":814},{"name":"$value","containerName":"_genemap_hash","kind":13,"line":816},{"kind":13,"containerName":"_genemap_hash","name":"$value","line":817},{"name":"$self","containerName":"_genemap_hash","kind":13,"line":818},{"line":818,"containerName":"_genemap_hash","kind":12,"name":"throw"},{"line":820,"name":"$self","kind":13,"containerName":"_genemap_hash"},{"line":820,"kind":13,"containerName":"_genemap_hash","name":"$value"},{"name":"$self","kind":13,"containerName":"_genemap_hash","line":824}],"name":"_genemap_hash","containerName":"main::","definition":"sub","detail":"($self,$value)","line":813,"kind":12,"range":{"start":{"character":0,"line":813},"end":{"character":9999,"line":825}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"_genemap_hash($self,$value)"}},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"_is_not_first_record","children":[{"definition":"my","line":832,"name":"$self","localvar":"my","kind":13,"containerName":"_is_not_first_record"},{"kind":13,"containerName":"_is_not_first_record","name":"$value","line":832},{"kind":13,"containerName":"_is_not_first_record","name":"$value","line":834},{"containerName":"_is_not_first_record","kind":13,"name":"$value","line":835},{"line":835,"name":"$value","containerName":"_is_not_first_record","kind":13},{"line":836,"containerName":"_is_not_first_record","kind":13,"name":"$self"},{"line":836,"name":"throw","kind":12,"containerName":"_is_not_first_record"},{"name":"$self","kind":13,"containerName":"_is_not_first_record","line":839},{"kind":13,"containerName":"_is_not_first_record","name":"$value","line":839},{"line":842,"kind":13,"containerName":"_is_not_first_record","name":"$self"}],"signature":{"label":"_is_not_first_record($self,$value)","documentation":"","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"start":{"line":830,"character":0},"end":{"character":9999,"line":843}},"kind":12,"line":830},{"line":835,"kind":12,"name":"FALSE"},{"name":"TRUE","kind":12,"line":835},{"kind":12,"name":"TRUE","line":837},{"kind":12,"name":"FALSE","line":837},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"_done($self,$value)"},"line":848,"range":{"end":{"character":9999,"line":860},"start":{"line":848,"character":0}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"line":849,"localvar":"my","containerName":"_done","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"_done","name":"$value","line":849},{"name":"$value","kind":13,"containerName":"_done","line":851},{"containerName":"_done","kind":13,"name":"$value","line":852},{"line":852,"name":"$value","kind":13,"containerName":"_done"},{"kind":13,"containerName":"_done","name":"$self","line":853},{"line":853,"name":"throw","kind":12,"containerName":"_done"},{"line":856,"containerName":"_done","kind":13,"name":"$self"},{"name":"$value","containerName":"_done","kind":13,"line":856},{"name":"$self","kind":13,"containerName":"_done","line":859}],"containerName":"main::","name":"_done"},{"name":"FALSE","kind":12,"line":852},{"kind":12,"name":"TRUE","line":852},{"kind":12,"name":"TRUE","line":854},{"line":854,"kind":12,"name":"FALSE"},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_OMIM_text_file($self,$value)"},"line":865,"kind":12,"range":{"start":{"line":865,"character":0},"end":{"line":877,"character":9999}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":866,"localvar":"my","containerName":"_OMIM_text_file","kind":13,"name":"$self"},{"line":866,"containerName":"_OMIM_text_file","kind":13,"name":"$value"},{"containerName":"_OMIM_text_file","kind":13,"name":"$value","line":868},{"name":"$value","containerName":"_OMIM_text_file","kind":13,"line":869},{"name":"isa","kind":12,"containerName":"_OMIM_text_file","line":869},{"line":870,"name":"$self","kind":13,"containerName":"_OMIM_text_file"},{"line":870,"name":"throw","kind":12,"containerName":"_OMIM_text_file"},{"kind":13,"containerName":"_OMIM_text_file","name":"$self","line":872},{"line":872,"kind":13,"containerName":"_OMIM_text_file","name":"$value"},{"line":876,"kind":13,"containerName":"_OMIM_text_file","name":"$self"}],"name":"_OMIM_text_file","containerName":"main::"},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$genemap_file_name"}],"label":"_read_genemap($self,$genemap_file_name)"},"line":882,"range":{"start":{"line":882,"character":0},"end":{"line":903,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$genemap_file_name)","children":[{"definition":"my","line":883,"localvar":"my","containerName":"_read_genemap","kind":13,"name":"$self"},{"line":883,"kind":13,"containerName":"_read_genemap","name":"$genemap_file_name"},{"definition":"my","name":"$line","localvar":"my","kind":13,"containerName":"_read_genemap","line":885},{"kind":13,"localvar":"my","containerName":"_read_genemap","name":"%genemap_hash","line":886,"definition":"my"},{"line":887,"containerName":"_read_genemap","localvar":"my","kind":13,"name":"$genemap_file","definition":"my"},{"line":887,"containerName":"_read_genemap","kind":12,"name":"new"},{"name":"$genemap_file_name","kind":13,"containerName":"_read_genemap","line":887},{"definition":"my","line":888,"name":"@a","containerName":"_read_genemap","localvar":"my","kind":13},{"line":889,"name":"%gm","kind":13,"localvar":"my","containerName":"_read_genemap","definition":"my"},{"name":"$line","kind":13,"containerName":"_read_genemap","line":891},{"name":"$genemap_file","kind":13,"containerName":"_read_genemap","line":891},{"line":891,"containerName":"_read_genemap","kind":12,"name":"_readline"},{"containerName":"_read_genemap","kind":13,"name":"@a","line":892},{"kind":13,"containerName":"_read_genemap","name":"$line","line":892},{"line":893,"containerName":"_read_genemap","kind":13,"name":"@a"},{"line":894,"name":"$self","containerName":"_read_genemap","kind":13},{"containerName":"_read_genemap","kind":12,"name":"throw","line":894},{"line":894,"kind":13,"containerName":"_read_genemap","name":"$self"},{"line":894,"containerName":"_read_genemap","kind":12,"name":"genemap_file_name"},{"name":"$gm","kind":13,"containerName":"_read_genemap","line":898},{"containerName":"_read_genemap","kind":13,"name":"$a","line":898},{"line":898,"kind":13,"containerName":"_read_genemap","name":"$line"},{"line":900,"containerName":"_read_genemap","kind":13,"name":"$genemap_file"},{"line":900,"containerName":"_read_genemap","kind":12,"name":"close"},{"name":"$self","containerName":"_read_genemap","kind":13,"line":901},{"containerName":"_read_genemap","kind":12,"name":"_genemap_hash","line":901},{"line":901,"name":"%gm","containerName":"_read_genemap","kind":13}],"name":"_read_genemap","containerName":"main::"},{"kind":12,"containerName":"Root::IO","name":"Bio","line":887},{"detail":"($self)","definition":"sub","name":"_no_OMIM_text_file_provided_error","containerName":"main::","children":[{"line":909,"name":"$self","localvar":"my","kind":13,"containerName":"_no_OMIM_text_file_provided_error","definition":"my"},{"definition":"my","name":"$msg","kind":13,"localvar":"my","containerName":"_no_OMIM_text_file_provided_error","line":911},{"name":"$msg","kind":13,"containerName":"_no_OMIM_text_file_provided_error","line":912},{"line":913,"kind":13,"containerName":"_no_OMIM_text_file_provided_error","name":"$msg"},{"line":914,"kind":13,"containerName":"_no_OMIM_text_file_provided_error","name":"$self"},{"line":914,"kind":12,"containerName":"_no_OMIM_text_file_provided_error","name":"throw"},{"containerName":"_no_OMIM_text_file_provided_error","kind":13,"name":"$msg","line":914}],"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_no_OMIM_text_file_provided_error($self)"},"kind":12,"range":{"end":{"line":915,"character":9999},"start":{"character":0,"line":908}},"line":908},{"line":920,"kind":12,"range":{"end":{"character":9999,"line":926},"start":{"line":920,"character":0}},"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_not_a_OMIM_text_file_error($self)"},"children":[{"definition":"my","line":921,"name":"$self","localvar":"my","containerName":"_not_a_OMIM_text_file_error","kind":13},{"definition":"my","containerName":"_not_a_OMIM_text_file_error","localvar":"my","kind":13,"name":"$msg","line":923},{"line":923,"name":"$self","containerName":"_not_a_OMIM_text_file_error","kind":13},{"name":"omimtxt_file_name","containerName":"_not_a_OMIM_text_file_error","kind":12,"line":923},{"name":"$self","kind":13,"containerName":"_not_a_OMIM_text_file_error","line":925},{"line":925,"containerName":"_not_a_OMIM_text_file_error","kind":12,"name":"throw"},{"line":925,"kind":13,"containerName":"_not_a_OMIM_text_file_error","name":"$msg"}],"name":"_not_a_OMIM_text_file_error","containerName":"main::","definition":"sub","detail":"($self)"},{"signature":{"label":"_add_to_hash($self,$state,$contents,$record_ref)","parameters":[{"label":"$self"},{"label":"$state"},{"label":"$contents"},{"label":"$record_ref"}],"documentation":""},"line":931,"range":{"end":{"character":9999,"line":941},"start":{"line":931,"character":0}},"kind":12,"definition":"sub","detail":"($self,$state,$contents,$record_ref)","children":[{"line":932,"kind":13,"localvar":"my","containerName":"_add_to_hash","name":"$self","definition":"my"},{"name":"$state","kind":13,"containerName":"_add_to_hash","line":932},{"name":"$contents","containerName":"_add_to_hash","kind":13,"line":932},{"line":932,"name":"$record_ref","containerName":"_add_to_hash","kind":13},{"line":934,"name":"$record_ref","containerName":"_add_to_hash","kind":13},{"line":934,"kind":13,"containerName":"_add_to_hash","name":"$state"},{"containerName":"_add_to_hash","kind":13,"name":"$record_ref","line":935},{"name":"$state","containerName":"_add_to_hash","kind":13,"line":935},{"line":936,"name":"$record_ref","kind":13,"containerName":"_add_to_hash"},{"line":936,"name":"$state","kind":13,"containerName":"_add_to_hash"},{"name":"$record_ref","containerName":"_add_to_hash","kind":13,"line":936},{"line":936,"containerName":"_add_to_hash","kind":13,"name":"$state"},{"line":936,"kind":13,"containerName":"_add_to_hash","name":"$contents"},{"name":"$record_ref","kind":13,"containerName":"_add_to_hash","line":939},{"line":939,"kind":13,"containerName":"_add_to_hash","name":"$state"},{"name":"$contents","containerName":"_add_to_hash","kind":13,"line":939}],"name":"_add_to_hash","containerName":"main::"}],"version":5}